DACSTRANSFORM(1)             DACS Commands Manual             DACSTRANSFORM(1)



NNAAMMEE
       dacstransform - rule-based document transformation

SSYYNNOOPPSSIISS
       ddaaccssttrraannssffoorrmm [ddaaccssooppttiioonnss[1]] [--aaddmmiinn] [--cctt _s_t_r] [--ddooccss _d_i_r] [--ff]
                     [--FF _f_i_e_l_d___s_e_p] [--ffdd _d_o_m_a_i_n] [--ffhh _h_o_s_t_n_a_m_e] [--ffjj _j_u_r_n_a_m_e]
                     [--ffnn _f_e_d_n_a_m_e] [--hh | --hheellpp] [--ii _i_d_e_n_t] [--iill _i_d_e_n_t]
                     [--iillgg _i_d_e_n_t] [--iieeuuiidd]
                     [--iieeuuiiddgg] [--iiuuiidd] [--iinnsseerrtt] [--iiuuiiddgg] [--llgg] [--nnaammee _s_t_r]
                     [--pprreeffiixx _s_t_r] [--rroolleess _r_o_l_e_s___v_f_s] [--rrpprreeffiixx _r_e_g_e_x]
                     [--rrssuuffffiixx _r_e_g_e_x] [--ssuuffffiixx _s_t_r] [{--rr | --rruulleess} _r_u_l_e_s___u_r_i]
                     [--vvaarr _n_a_m_e_=_v_a_l_u_e] [--xx] [----] {-- | _f_i_l_e}

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.


       ddaaccssttrraannssffoorrmm supplies the functionality of ddaaccss__ttrraannssffoorrmm from the
       command-line. Because the two programs are almost identical, please
       refer to ddaaccss__ttrraannssffoorrmm((88))[2] for details.

       If the program is executed through the system's "#!" mechanism
       (eexxeeccvvee((22))[3]), one or more command line arguments can be given:

           #!/usr/local/dacs/bin/dacstransform -Dfoo=val -ct ''
           Hello, world

           Bye

       Such programs always use the script file as input, therefore no
       expression or other file can be specified on the "#!" line.

           NNoottee
           The program has some limitations, including missing configuration
           capabilities and features, that might be expected in a production
           version but which have not yet been implemented.

OOPPTTIIOONNSS
       The arguments are processed as they are examined (left-to-right) and
       their ordering can be significant. Command line arguments override DDAACCSS
       configuration (see below).

       Please refer to ddaaccsscchheecckk((11))[4] for a description of the flags related
       to setting identities and DDAACCSS context. If no identity is specified,
       the program will use the values of the environment variables
       RREEMMOOTTEE__UUSSEERR and DDAACCSS__RROOLLEESS if they are available and valid.

       The following command line flags are recognized:

       --cctt _s_t_r
           Set the MIME Content-Type to _s_t_r. The default is not to emit this
           header.

       --ddooccss _d_i_r
           Set the directory containing the documents to _d_i_r - the _f_i_l_e
           argument will be relative to _d_i_r. If _d_i_r is the empty string,
           however, this mapping will not be performed. The mapping is also
           disabled if the --ff is given or if the standard input is read. This
           argument overrides any configuration of transform_docs or default
           behaviour.

       --ff
           Disable input file location mapping.

       --hh
       --hheellpp
           Prints the usage blurb, which includes a listing of the program's
           defaults.

       --iinnsseerrtt _d_i_r
           If a relative path is given for the value of a filename attribute
           with the insert, insertv, or expand directive, prefix the relative
           path with the string _d_i_r.

       --nnaammee _s_t_r
           The name of the input document is _s_t_r. This is used to associate a
           rule with the document; that is, it is matched against a rule's
           service or delegate element. By default, it is the name of the
           input file or the path component of the input URI. If the effective
           name does not begin with a slash character, one is prepended. The
           argument should probably be given if the standard input is being
           read.

       --pprreeffiixx _s_t_r
           A directive is introduced by _s_t_r appearing at the beginning of an
           input line. The default is "<--DACS ".

       --ssuuffffiixx _s_t_r
           A directive is terminated by _s_t_r appearing at the end of a
           directive line. The default is "-->".

       --rr _r_u_l_e_s___u_r_i
       --rruulleess _r_u_l_e_s___u_r_i
           The location of the ruleset to be applied to the document, as a
           DDAACCSS VFS URI.

       --rrpprreeffiixx _r_e_g_e_x
           A line whose beginning matches _r_e_g_e_x introduces a directive. This
           overrides the default and any --pprreeffiixx flag. IEEE Std 1003.2
           ("POSIX.2") "extended" regular expressions are supported
           (rreeggeexx((33))[5]).

       --rrssuuffffiixx _r_e_g_e_x
           A directive is terminated by a string that matches _r_e_g_e_x, followed
           immediately by the end of the line. This overrides the default and
           any --ssuuffffiixx flag. IEEE Std 1003.2 ("POSIX.2") "extended" regular
           expressions are supported (rreeggeexx((33))[5]).

       --vvaarr _n_a_m_e_=_v_a_l_u_e
           Add a variable definition to the _D_A_C_S namespace. The variable
           _$_{_D_A_C_S_:_:_n_a_m_e_} will be assigned the string _v_a_l_u_e. The _n_a_m_e must be
           syntactically valid. This flag is equivalent to the ddaaccssooppttiioonnss[1]
           flag --DD_n_a_m_e_=_v_a_l_u_e. This flag may be repeated. It is best to avoid
           the variable name _s_t_d_i_n, which has a special purpose. If _n_a_m_e is
           defined more than once its value is indeterminate.

           In a directive, an attribute value that is enclosed within backtick
           quotes is evaluated as an expression, which may include variable
           references. Variables from the _E_n_v namespace and, if available, the
           _C_o_n_f are also instantiated. The current directive's attributes are
           accessible in the _A_t_t_r namespace; these attribute values are
           _u_n_e_v_a_l_u_a_t_e_d and quoted.

       --xx
           Run as a command, not a web service. This is often required when
           ddaaccssttrraannssffoorrmm is run as a CGI program.

       ----
           Flags end. An input source argument may follow.

       After the flags, the input source can be specified. By default, or if --
       is given, the standard input is read, otherwise _f_i_l_e is read.

       Whitespace is not ignored at the beginning or end of an input line with
       respect to directive prefix and suffix matching.

   CCoonnffiigguurraattiioonn
       Configuration variables can be set to change some of the program's
       defaults, but each one is overridden if a value is also given on the
       command line:

       +o   _t_r_a_n_s_f_o_r_m___d_o_c_s: This is the full pathname of the root directory in
           which original documents are kept. By default, the program will use
           a subdirectory _$_{_C_o_n_f_:_:_D_A_C_S___H_O_M_E_}dacs_transform/docs. (default:
           /usr/local/dacs/dacs_transform/docs)

               SSeeccuurriittyy
               Change the default with care. In the absence of an appropriate
               access control rule, setting the pathname to "/" or the empty
               string, would provide access to any file on the server that can
               be read by this web service.

       +o   _t_r_a_n_s_f_o_r_m___a_c_l_s: This is the VFS specification for the rules. By
           default, the program will use
           _$_{_C_o_n_f_:_:_D_A_C_S___H_O_M_E_}dacs_transform/acls. (default:
           [transform-acls]dacs-fs:/usr/local/dacs/dacs_transform/acls)

       +o   _t_r_a_n_s_f_o_r_m___a_n_n_o_t_a_t_i_o_n: This is the annotation to interpolate in
           redacted text instead of the default.

       +o   _t_r_a_n_s_f_o_r_m___p_r_e_f_i_x: Instead of the default prefix string used to
           introduce a directive, the value of this variable is used. It must
           appear at the beginning of a line.

       +o   _t_r_a_n_s_f_o_r_m___s_u_f_f_i_x: Instead of the default string used to end a
           directive, the value of this variable is used.

       +o   _t_r_a_n_s_f_o_r_m___r_p_r_e_f_i_x: A line whose beginning matches the specified
           regular expression introduces a directive.

       +o   _t_r_a_n_s_f_o_r_m___r_s_u_f_f_i_x: The end of a directive is found by matching the
           specified regular expression.


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss__ttrraannssffoorrmm((88))[2], ddaaccss..eexxpprrss((55))[6], ddaaccss..aaccllss((55))[7]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[8])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[9] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_transform(8)
           http://dacs.dss.ca/man/dacs_transform.8.html

        3. execve(2)
           http://www.freebsd.org/cgi/man.cgi?query=execve&apropos=0&esektion=2&emanpath=FreeBSD+7.2-RELEASE&format=html

        4. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        5. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&esektion=3&emanpath=FreeBSD+7.2-RELEASE&format=html

        6. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

        7. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                  DACSTRANSFORM(1)
