DACSSCHED(1)                 DACS Commands Manual                 DACSSCHED(1)



NNAAMMEE
       dacssched - rule-based command scheduling

SSYYNNOOPPSSIISS
       ddaaccsssscchheedd [--hh | --hheellpp] [--llll _l_o_g___l_e_v_e_l] [--qq] [{--rr | --rruulleess} _r_u_l_e_s___u_r_i]
                 [{--ss | --sscchheedd} _s_c_h_e_d___u_r_i] [--vv]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite. It is a stand-alone program
       that neither accepts the usual DDAACCSS command line options (_d_a_c_s_o_p_t_i_o_n_s)
       nor accesses any DDAACCSS configuration files.

       The ddaaccsssscchheedd command runs other programs when specified conditions
       have been met. It does this by periodically examining a schedule,
       which, for each scheduled event, identifies the necessary conditions
       and the command line to be executed should the conditions be satisfied.
       Rules are stored separately from the schedule, although in a future
       version it might be possible to contain them with their schedule.

       Although ddaaccsssscchheedd is conceptually similar to ccrroonn((88))[1], aattrruunn((88))[2],
       and other programs used to schedule a command to be executed or a
       reminder to be sent at certain times or dates, there are some important
       differences. First, because the DDAACCSS rule evaluation engine is used,
       conditions much more broad and complex than simply the time or date can
       be used to schedule a command - DDAACCSS eexxpprreessssiioonnss[3] are available. For
       instance, a rule to manage automated file backup could be written to
       take into account context other than simply the day of the week and the
       time of day, if necessary even running external programs to assist in
       making the determination. Second, both a schedule and the rules
       referenced by a schedule are accessed through the DDAACCSS virtual
       filestore, which means they can be stored in file or database,
       retrieved by HTTP, and so on.

           NNoottee
           Although this program may be useful, it is currently merely a
           prototype intended for demonstration and experimentation purposes.
           Some configuration capabilities, features, and security steps
           required by a production version have not been implemented. The
           prototype must be invoked periodically; a production version would
           run in the background and automatically rescan the schedule at a
           given frequency. Note that because of its flexibility, the schedule
           must be polled at a suitable frequency - in general, the program
           cannot compute when the next scheduled event will occur. Also
           because events need not be triggered by a time or date, some events
           may need to "self-disabling" so that they are not repeatedly
           executed unintentionally.

   OOppeerraattiioonn
       The program loads a _s_c_h_e_d_u_l_e, which either comes from a default file or
       a location specified on the command line. A schedule is an ordinary
       text file, each line of which is either blank, a comment, or a
       scheduled event. The file is processed in the order in which the events
       appear from the top. Initial whitespace on any line is ignored. A
       comment line begins with a "#" character. A scheduled event consists of
       a _n_a_m_e, followed by whitespace, followed by a command. If _n_a_m_e
       evaluates to TTrruuee (i.e., it grants access), the command is executed
       through ssyysstteemm((33))[4]. If rule evaluation fails because of an error, the
       event is not executed. Events are not removed from the schedule after
       their command has been executed.

       A _n_a_m_e, which must begin with a slash, has no significance to
       ddaaccsssscchheedd; it is simply a label that is used to identify the rule to
       apply and is matched against a rule's service element.

       Here is a simple schedule containing one event:

           # A simple schedule
           /setdate   /usr/local/sbin/rdate -a

       If the condition labelled /setdate is TTrruuee the specified command will
       be executed.

       A simple rule such as the following might be associated with the event:

           <acl_rule status="enabled">
               <services>
                 <service url_pattern="/setdate"/>
               </services>

              <rule order="allow,deny">
                <allow>
                  time(hour) eq 2 and time(min) eq 0
                </allow>
              </rule>
           </acl_rule>

       This rule enables the event /setdate at 2:00am every day. We will
       assume that the schedule is processed exactly once per minute.

       Internally, ddaaccsssscchheedd converts the scheduled event above into the
       expression:

           rule("/setdate", _r_u_l_e___u_r_i)

       (where _r_u_l_e___u_r_i specifies the ruleset to use) and then evaluates the
       expression. Please refer to the rruullee predicate[5] for additional
       information.

   OOPPTTIIOONNSS
       The arguments are processed as they are examined (left-to-right) and
       their ordering can be significant.

       By default, the program will look for a schedule in the file
       _$_{_C_o_n_f_:_:_D_A_C_S___H_O_M_E_}/dacssched/sched. (default:
       /usr/local/dacs/dacssched/sched) The default location for the rules is
       _$_{_C_o_n_f_:_:_D_A_C_S___H_O_M_E_}/dacssched/acls. (default:
       /usr/local/dacs/dacssched/acls)

       The following command line flags are recognized:

       --hh
           Prints the usage blurb.

       --llll _l_o_g___l_e_v_e_l
           Set the debugging output level to _l_o_g___l_e_v_e_l (see ddaaccss((11))[6]). The
           default level is warn, and the --vv flag bumps the level to debug or
           trace.

       --qq
           Be quiet, except for error messages. The --vv and --llll flags are
           independent of this.

       --rr _r_u_l_e___u_r_i
       --rruulleess _r_u_l_e___u_r_i
           This flag specifies the ruleset to be used. It can be an absolute
           pathname or a URI in the syntax of the VVFFSS[7] configuration
           directive. Examples:


               -r "[acls1]dacs-fs:/local/acls"
               -rules /usr/local/myrules


       --ss _s_c_h_e_d___u_r_i
       --sscchheedd _s_c_h_e_d___u_r_i
           This flag specifies the schedule. It can be an absolute pathname or
           a URI in the syntax of the VVFFSS[7] configuration directive.

       --vv
           Increase the level of debugging output. The flag may be repeated.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss..eexxpprrss((55))[3], ddaaccss..aaccllss((55))[8]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[9])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[10] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. cron(8)
           http://www.freebsd.org/cgi/man.cgi?query=cron&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

        2. atrun(8)
           http://www.freebsd.org/cgi/man.cgi?query=atrun&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

        3. expressions
           http://dacs.dss.ca/man/dacs.exprs.5.html

        4. system(3)
           http://www.freebsd.org/cgi/man.cgi?query=system&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        5. rruullee predicate
           http://dacs.dss.ca/man/dacs.exprs.5.html#rule

        6. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        7. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        8. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      DACSSCHED(1)
