DACSCOOKIE(1)                DACS Commands Manual                DACSCOOKIE(1)



NNAAMMEE
       dacscookie - create DDAACCSS credentials and emit as a cookie

SSYYNNOOPPSSIISS
       ddaaccssccooookkiiee [ddaaccssooppttiioonnss[1]] [--ccrreeaattee] [--ii _i_d_e_n_t] [--uusseerr _u_s_e_r]
                            [--iipp _i_p_a_d_d_r]
                            [--rroollee _r_o_l_e___s_t_r] [--eexxppiirreess _d_a_t_e] [--uuaa _s_t_r]
                            ddaaccssccooookkiiee [ddaaccssooppttiioonnss[1]] --ddeeccrryypptt [--ccoonncciissee]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssccooookkiiee utility constructs DDAACCSS credentials that represent a
       single DDAACCSS identity and emits them as the _N_A_M_E=_V_A_L_U_E element of a HHTTTTPP
       ccooookkiiee[2] (RRFFCC 22110099[3], RRFFCC 22996655[4]) that may be used by DDAACCSS. It can
       also decode and display these cookies, provided the same encryption
       keys used to create the cookies are available. The program is useful
       for testing purposes, or by programs that perform authentication (e.g.,
       by calling ddaaccssaauutthh((11))[5]) and need to return credentials. It may also
       be used to generate an identity "offline"; the resulting credentials
       could be used by applications other than standard Web browsers, or be
       distributed via any secure channel (e.g., encrypted email) for use by
       the recipient.

       Configured or derived defaults are used if optional identity
       information is not provided.

           SSeeccuurriittyy
           Only the DDAACCSS administrator should be able to successfully run this
           program. Because DACS keys and configuration files must be limited
           to the administrator, this will normally be the case, but a careful
           administrator will set file permissions to deny access to all other
           users, or even delete the binary.

           Similarly, access to cookies generated by this program must be
           carefully controlled. Any jurisdiction within the same federation
           in which the credentials were created will be able to directly
           decrypt the credentials.

OOPPTTIIOONNSS
       ddaaccssccooookkiiee recognizes these options for cookie creation:

       --ccrreeaattee
           Create the specified credentials and emit them to the standard
           output as the _N_A_M_E=_V_A_L_U_E component of an HTTP cookie. This is the
           default.

       --eexxppiirreess _d_a_t_e
           Set the expiry date for the cookie. If _d_a_t_e begins with '+' and is
           followed by a digit string, the expiry date will be that number of
           seconds relative to the current time. Otherwise, the date is
           expected to be in one of the recognized formats (see ccoonncciissee
           ssyynnttaaxx[6]). If not provided, the configured default value,
           AAUUTTHH__CCRREEDDEENNTTIIAALLSS__DDEEFFAAUULLTT__LLIIFFEETTIIMMEE__SSEECCSS[7], will be used.

       --ii _i_d_e_n_t
           The identity (_i_d_e_n_t) is given in the ccoonncciissee ssyynnttaaxx[6]. Note that
           any elements that are explicitly given will override those that
           appear in _i_d_e_n_t.

       --iipp _i_p_a_d_d_r
           Use _i_p_a_d_d_r as the user's IP address (in numerical dot notation). If
           not provided, this element will be obtained from any --ii flag or
           else omitted from the credentials.

       --rroollee _r_o_l_e___s_t_r
           Use _r_o_l_e___s_t_r as the user's role string, which must be syntactically
           correct. If not provided, this element will be obtained from any --ii
           flag or else omitted from the credentials.

       --uuaa _s_t_r
           Use _s_t_r as the user agent string associated with the credentials.
           If no string is specified, the credentials cannot be verified
           against a user agent string. See ddaaccss..ccoonnff((55))[8].

       --uusseerr _n_a_m_e
           Use _n_a_m_e, a syntactically correct username, within the applicable
           jurisdiction. If not provided, this element must be specified using
           the --ii flag.


       ddaaccssccooookkiiee recognizes these options for cookie decryption:

       --ddeeccrryypptt
           Instead of creating credentials, read a cookie from the standard
           input and print its decoded contents to the standard output. If the
           input is invalid in any way, a message is displayed.

       --ccoonncciissee
           With the --ddeeccrryypptt flag, only print the identity in the ccoonncciissee uusseerr
           ssyynnttaaxx[6].

EEXXAAMMPPLLEESS
       The following will generate an identity and store it in a file:

           % dacscookie -u j1.example.com -user bobo > cookie.out
           % chmod 0600 cookie.out

       The following will display various elements of the credentials to
       stdout:

           % dacscookie -u j1.example.com -decrypt < cookie.out
           % rm cookie.out


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss__aauutthh__aaggeenntt((88))[9], ddaaccss__aauutthh__ttrraannssffeerr((88))[10],
       ddaaccss__aauutthheennttiiccaattee((88))[11], ddaaccssaauutthh((11))[5], ddaaccssccrreedd((11))[12],
       ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[13].

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[14])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[15] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. HTTP cookie
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

        3. RFC 2109
           http://www.rfc-editor.org/rfc/rfc2109.txt

        4. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

        5. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        6. concise syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

        7. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS

        8. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VERIFY_UA

        9. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       10. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       11. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       12. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

       13. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       14. www.dss.ca
           http://www.dss.ca

       15. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                     DACSCOOKIE(1)
