DACSCHECK(1)                 DACS Commands Manual                 DACSCHECK(1)



NNAAMMEE
       dacscheck - authorization check

SSYYNNOOPPSSIISS
       ddaaccsscchheecckk [--aaddmmiinn] [--aapppp _a_p_p_n_a_m_e] [--ccoonntteexxtt _f_i_l_e] [--DD_n_a_m_e_=_v_a_l_u_e]
                 [--FF _f_i_e_l_d___s_e_p] [--ffdd _d_o_m_a_i_n] [--ffhh _h_o_s_t_n_a_m_e] [--ffjj _j_u_r_n_a_m_e]
                 [--ffnn _f_e_d_n_a_m_e]
                 [--dduummpp] [--ggrroouuppss _g_r_o_u_p___v_f_s] [--hh] [--ii _i_d_e_n_t] [--iill _i_d_e_n_t]
                 [--iillgg _i_d_e_n_t] [--iieeuuiidd] [--iieeuuiiddgg] [--iiuuiidd] [--iiuuiiddgg] [--llgg]
                 [--llll _l_o_g___l_e_v_e_l] [--qq]
                 [--rreeddiirreecctt] [--rroolleess _r_o_l_e_s___v_f_s] [--rruulleess _r_u_l_e___v_f_s] [--vv]
                 [--vvaarr _n_a_m_e_=_v_a_l_u_e]
                 [--vvffss _v_f_s___u_r_i] [----] _o_b_j_e_c_t

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite. It is a stand-alone program
       that neither accepts the usual DDAACCSS command line options (_d_a_c_s_o_p_t_i_o_n_s)
       nor accesses any DDAACCSS configuration files.

       Put simply, ddaaccsscchheecckk looks at access control rules to test if a given
       user is authorized to do something or access something. The command's
       exit status gives the result of the test, and unless the _-_q flag is
       given, a line is printed to stdout that indicates the result. It
       provides simplified, general-purpose access to DDAACCSS's access control
       rule evaluation engine, even for programs other than web services, and
       it lends itself to fine-grained access control decisions.

       More specifically, ddaaccsscchheecckk checks if a request for object should be
       granted according to specified access control rules and a given
       evaluation context. To do its job, ddaaccsscchheecckk needs to know only a few
       things:

        1. where to find the access control rules to apply;

        2. the name of the object being accessed; and

        3. optionally, an evaluation context that specifies an identity for
           which access is being tested and variables that can be referenced
           by rules.


       The command does not perform any authentication; it assumes that the
       caller (or the execution environment) has already established the
       identity for which an access control decision is required. It may be
       used like any other command: run from the command line or a shell
       script, executed by a compiled program, or called from a scripting
       language such as PPeerrll[1], PPHHPP[2].  PPyytthhoonn[3], RRuubbyy[4], and TTccll//TTkk[5].

       Some simple examples will illustrate how ddaaccsscchheecckk can be used.

           NNoottee
           The examples in this document have been simplified for readability;
           in real use, absolute pathnames should appear, error checking
           should be performed, and so on. Also, the ddaaccsscchheecckk program and the
           rules that it requires must have file permissions set
           appropriately.

       The first example shows how a shell script might call ddaaccsscchheecckk to test
       whether the user running it is allowed to do so. It obtains the user's
       identity from the operating system; it assumes that the user has
       invoked the script from the command line and has therefore already
       signed in to the system. In the example, ddaaccsscchheecckk obtains the identity
       through a system call, but a script might choose to pass the value of
       the LLOOGGNNAAMMEE or UUSSEERR environment variable.

       The shell script simply asks ddaaccsscchheecckk if the effective uid (see
       ggeetteeuuiidd((22))[6]) is permitted to access /myapp. The exit status of
       ddaaccsscchheecckk (_$_?) gives the result. The pathname /myapp is essentially a
       label that is used to find the access control rule to apply; in this
       example it simply represents the name of the program. It could be the
       program's filename, but it need not be.

           #! /bin/sh

           dacscheck -q -ieuid -rules /usr/local/myapp/rules /myapp
           st="$?"
           if test "${st}" != 0
           then
             echo "Access is denied"
             exit "${st}"
           fi

           echo "Access is granted"

           # Do some stuff

           exit 0

       The directory /usr/local/myapp/rules might include a file named
       acl-app.0 that grants access only to bob and alice:

           <acl_rule status="enabled">
             <services>
              <service url_pattern="/myapp"/>
             </services>

             <rule order="allow,deny">
              <allow>
                user(":bob") or user(":alice")
              </allow>
             </rule>
           </acl_rule>

       Access control rules are described in ddaaccss..aaccllss((55))[7].

       A CGI program can obtain the identity of the user invoking it from the
       RREEMMOOTTEE__UUSSEERR environment variable and call ddaaccsscchheecckk, as demonstrated in
       the following shell script, which uses the same rule as above:

           #! /bin/sh

           if test "${REMOTE_USER}x" = "x"
           then
             idarg=""
           else
             idarg="-i ${REMOTE_USER}"
           fi

           echo "Context-Type: text/plain"
           echo ""

           # Note: append 2>&1 to the end of the next line to capture error messages
           dacscheck -q ${idarg} -rules /usr/local/myapp/rules /myapp

           st="$?"
           if test "${st}" = 0
           then
             echo "Access is granted"
           else
             echo "Access is denied"
           fi

           exit 0

       This example can easily be translated into any scripting language that
       allows an external program to be called and its exit status examined.
       Here is a similar example in PHP:

           $user = $_SERVER["REMOTE_USER"];
           putenv("REMOTE_USER=$user");
           system("/usr/local/dacs/bin/dacscheck -q -fn DEMO -icgi
                -rules /usr/local/myapp/rules /myapp", $st);
           if ($st != 0) {
           // Access is denied, bail out
             exit($st);
           }

           // Access is granted, proceed


           NNoottee
           Some may question the point of having a program call ddaaccsscchheecckk to
           test if the user invoking it is allowed to merely run the program.
           At first glance it might appear that one could achieve the same
           result by simply setting file permissions such that only bob and
           alice can run the program. If that could be done, the
           coarse-grained testing done by ddaaccsscchheecckk in the examples would be
           unnecessary. It turns out that there is more to it than that.

           Setting file permissions to achieve this on a traditional Unix-type
           system requires creating a new group in /etc/group, something that
           generally can only be done by a system administrator. Ordinary
           users must therefore either bother the system administrator each
           time such a group must be created or modified, or find some other
           way to achieve the same result (e.g., by encryption, using a
           special setuid or setgid command that provides password-protected
           access, or some other clumsy and possibly insecure solution).

           To address this limitation and others, many Unix-type operating
           systems now include file systems that extend the traditional Unix
           file permissions with an ACL-based mechanism (e.g., providing the
           ggeettffaaccll((11))[8] and sseettffaaccll((11))[9] commands, and the aaccll((33))[10] ACL
           security API).

           ddaaccsscchheecckk provides similar functionality but for _a_r_b_i_t_r_a_r_y _n_a_m_e_s,
           not only for objects in the file system, and with respect to
           _a_r_b_i_t_r_a_r_y _i_d_e_n_t_i_t_i_e_s, not only for those known to the operating
           system. For example, a CGI script can call ddaaccsscchheecckk to test access
           on behalf of a user known to the web server (e.g., via an account
           created using hhttppaasssswwdd((11))[11]) but not having an account on the
           underlying system. Therefore, besides being portable across
           platforms and available on systems without ACL-type file
           permissions, ddaaccsscchheecckk is a much more general solution than what
           most operating systems provide. In contrast to a system-provided
           ACL-based mechanism, however, ddaaccsscchheecckk is _n_o_t invoked
           transparently (i.e., it is not called automatically by the
           operating system when a resource such as a file is accessed). Also,
           with respect to testing whether a user is allowed to run a program,
           that program will typically perform the test itself and must
           therefore begin execution.

           For additional information:

           +o    UUssiinngg FFrreeeeBBSSDD''ss AACCLLss[12], Dru Lavigne, OONNLLaammpp..ccoomm[13],
               22-Sep-05.

           +o    PPOOSSIIXX AACCLLss iinn LLiinnuuxx[14], Mike Peters, lliinnuuxx..ccoomm[15], 2-Aug-04.

           +o   For Solaris, SSoollaarriiss 1100 aaccll((22))[16], SSuunn MMiiccrroossyysstteemmss[17] and
               UUssiinngg SSoollaarriiss AACCLLss[18] by the DDeepptt.. ooff CCoommppuutteerr SScciieennccee,, DDuukkee
               UUnniivveerrssiittyy[19].


       Because the authorization checking performed by ddaaccsscchheecckk is completely
       separate from that performed by the operating system for system calls,
       a UUnniixx identity such as root has no special rights or capabilities as
       far as ddaaccsscchheecckk is concerned unless rules have been written to grant
       them. The same applies to the application of UUnniixx groups.

       The next example demonstrates how some typical PPeerrll code can be
       improved by ddaaccsscchheecckk. The code fragment:

           if ($logged_in_as_root || $logged_in_as_current_admin) {
             # Do something privileged...
           }

       which depends on the two variables being properly initialized depending
       on the value of _$_u_s_e_r_n_a_m_e, can be replaced by this:

           # Determine if $username has admin privileges
           $output = `dacscheck -q -i $username -app myapp /myapp/admin`;
           $is_admin = ($? >> 8) == 0;

           if ($is_admin) {
             # Do something privileged...
           }

           # Later...
           if ($is_admin) {
             # Do something else privileged...
           }

       The new authorization test depends on the identity that is running the
       program (_$_u_s_e_r_n_a_m_e) and the separate ruleset that determines whether
       that identity should be granted access to /myapp/admin, which is simply
       a label for a rule that might look like this:

           <acl_rule status="enabled">
             <services>
              <service url_pattern="/myapp/admin"/>
             </services>

             <rule order="allow,deny">
              <allow>
                user("%:admin")
              </allow>
            </rule>
           </acl_rule>

       This rule grants access if and only if _$_u_s_e_r_n_a_m_e is a member of the
       DDAACCSS group named admin or is associated with that DDAACCSS role. Membership
       in that group can be changed dynamically, and can even be reduced to
       zero.

       The important observation is that _t_h_e _c_o_n_d_i_t_i_o_n_s _t_h_a_t _d_e_t_e_r_m_i_n_e _w_h_e_t_h_e_r
       _t_h_e _u_s_e_r _r_u_n_n_i_n_g _t_h_i_s _P_e_r_l _c_o_d_e _h_a_s _a_d_m_i_n_i_s_t_r_a_t_i_v_e _p_r_i_v_i_l_e_g_e_s _a_r_e
       _d_e_f_i_n_e_d _o_u_t_s_i_d_e _o_f _t_h_e _p_r_o_g_r_a_m _a_n_d _c_a_n _b_e _c_h_a_n_g_e_d _w_i_t_h_o_u_t _m_o_d_i_f_y_i_n_g _t_h_e
       _c_o_d_e _a_n_d _o_f_t_e_n _w_i_t_h_o_u_t _e_v_e_n _m_o_d_i_f_y_i_n_g _a_c_c_e_s_s _c_o_n_t_r_o_l _r_u_l_e_s.

       A few concepts that are used in this document are described elsewhere.
       Variables, variable namespaces, and expressions that are used in access
       control rules are discussed in ddaaccss..eexxpprrss((55))[20]. Naming in DDAACCSS is
       discussed in ddaaccss((11))[21], and DDAACCSS groups and roles are covered in
       ddaaccss..ggrroouuppss((55))[22].

           SSeeccuurriittyy
           Clearly ddaaccsscchheecckk, its caller, and the resources in question must
           be "isolated" from the user on whose behalf ddaaccsscchheecckk is being run,
           otherwise the user could access the resources directly or subvert
           access control tests. Therefore, ddaaccsscchheecckk and its caller must
           either be more privileged than the user on whose behalf it is being
           run or both programs must run in a secure context. This generally
           means that both ddaaccsscchheecckk and its caller should be run in isolation
           from users (as on a remote server) or as an effective user ID
           different from the user's.

   AAddvvaannttaaggeess
       Programs that perform authorization tests typically contain code like:

       +o   "If the current user has provided a suitable password, then execute
           the following code, otherwise do not", or

       +o   "If the current user is the administrator, do the following", or

       +o   "If the current user is allowed to perform an update operation,
           then show these menu items, otherwise do not show them"

       Complicated applications can be littered with these kinds of tests,
       making them prone to bugs and security problems. A change to a security
       policy may involve changes throughout an application or suite of
       applications. Also, password handling is often incorporated into such
       programs; because password management can require a significant
       implementation effort and is difficult to do securely, it seems wise to
       try to leverage existing implementations.

       Compared to custom-coded solutions, ddaaccsscchheecckk has many advantages:

       Data-driven policies
           As opposed to to specially-written access control logic,
           data-driven (rule-based) functionality is superior because:

           +o   Access control rules are separate from code, so changes to a
               set of rules automatically applies to all uses of those rules
               throughout an application or set of applications; code does not
               need to be modified if the policy is changed.

           +o   Bug fixes and improvements to rules are automatically available
               to programs that use ddaaccsscchheecckk; no recompilation of
               applications is necessary.

           +o   The person who administers the rules does not have to be the
               application's programmer (or even someone who understands the
               code), so delegating responsibility is much easier. This
               reduces the amount of programming required when changes are
               required, reduces code maintenance effort, and decreases the
               chance of error.

           +o   It is usually easier to understand (and express) a set of rules
               that describes an access control policy; code that implements
               the same policy will be more complex and difficult to
               understand, increasing the chance of error.

           Programming Efficiency


               +o   Applications are simplified and programming time and effort
                   are reduced because existing access control code (i.e.,
                   ddaaccsscchheecckk) is reused.

               +o   Sophisticated rules can be constructed without having to
                   write any code.  DDAACCSS features are available, such as roles
                   and groups, and can be used to construct simpler and more
                   expressive authorization policies than are likely to be
                   hand-coded.

               Portability
                   Rules are platform independent, can be stored remotely from
                   the applications that use them, and can potentially be
                   evaluated remotely.  ddaaccsscchheecckk is available for a variety
                   of platforms.

               Increased Sharing
                   Rules can be shared and used in different situations and by
                   different programs.

               Flexibility


                   +o   Because it does not rely on a web server, it can be
                       used by virtually any CGI-based program.

                   +o   With respect to DDAACCSS, it can be used in circumstances
                       where the mmoodd__aauutthh__ddaaccss[23] module cannot be used with
                       AAppaacchhee, or where AAppaacchhee cannot be used at all.

                   +o   Because it is implemented as an ordinary command,
                       ddaaccsscchheecckk can be used from the command line or invoked
                       from almost any script or program.

                   +o   For CGI-based programs, ddaaccsscchheecckk can be used without
                       any assistance from a system administrator; e.g., it
                       does not require a web server to be configured to
                       provide authorization for a CGI program because all
                       access control functionality is performed within the
                       program.

                   Increased Security
                       ddaaccsscchheecckk neither performs authentication nor relies on
                       any particular authentication method, so the
                       authentication method can be changed without affecting
                       the application's use of ddaaccsscchheecckk. Any supported means
                       of authentication can be used, not only the typical
                       password-based method.

                   While the performance of ddaaccsscchheecckk ought not to be a factor
                   for many applications, the C/C++ API can be used where it
                   is an issue. This API can be used to incorporate ddaaccsscchheecckk
                   functionality into compiled programs and extensible
                   languages, such as PPeerrll, PPyytthhoonn, TTccll//TTkk, and PPHHPP.

   IIddeennttiittiieess
       The identity for which access is to be tested is given to the program
       or obtained by the program from its execution environment. This
       identity is converted into DDAACCSS''ss internal representation.

       More than one identity can be specified; the check is made on behalf of
       the union of all the identities. If the identities bob and alice are
       specified, for instance, a rule that is satisfied by either identity
       may grant access.

       If no identity is given, the check is made on behalf of an
       unauthenticated user.

       An identity can be:

       +o   a login name that ddaaccsscchheecckk maps to from the real or effective uid
           of the program (i.e., the user who is running the program);

       +o   a DDAACCSS user identity (e.g., :carol, DSS:bob, or
           EXAMPLE-COM::DEMO:alice, see ddaaccss((11))[24]);

       +o   a simple name (bob is equivalent to :bob); or

       +o   a name expressed in the ccoonncciissee ssyynnttaaxx[25], which gives a username
           and, optionally, roles and attributes for the identity. Any
           identity that has expired is not used.


           NNootteess
           +o   ddaaccsscchheecckk validates the syntax of an identity it is given,
               converts and expands it to the concise syntax if necessary, and
               then converts it into its internal representation for
               credentials. These credentials are destroyed when the program
               terminates.

               Regardless of how it is specified, each identity must satisfy
               the syntactic requirements of a DDAACCSS user identity after this
               conversion and expansion (see ddaaccss((11))[24]). If a login name is
               specified as an identity, for example, it must be valid as a
               component of a DDAACCSS user identity; therefore, it cannot contain
               any invalid characters.

           +o   If no IP address is provided for an identity, it is obtained
               from the RREEMMOOTTEE__AADDDDRR environment variable when available,
               otherwise a default of 127.0.0.1 is used. The IP address
               associated with credentials is tested using the uusseerr(())
               predicate.

           +o   If an identity that is being tested includes a federation name,
               since the default federation name is unlikely to be correct, it
               will probably be necessary to tell ddaaccsscchheecckk which federation
               name to compare against using the --ffnn flag.

       Here are some examples of identities that may follow the --ii flag:

           bob
           :bob
           DSS:bob
           {u = bob}
           {u="bob"}
           {u="alice",g="admin"}
           {u="DSS:bob",g="guest"}
           {u="bob",a="a", g="guest"}


           NNoottee
           This string may need to be quoted appropriately on the command line
           because the brace characters are significant to some shells; e.g.,

               --ii '{u="bob"}'

       AAppaacchhee and other web servers set the environment variable RREEMMOOTTEE__UUSSEERR
       to the authenticated identity that invoked a web service. Provided its
       syntax is suitable, this identity can be passed to ddaaccsscchheecckk. For
       DDAACCSS-wrapped web services, DDAACCSS identities are available in this
       variable.

       By default, the federation, jurisdiction, and hostnames associated with
       the rules are derived from the system's hostname as returned by
       ggeetthhoossttnnaammee((33))[26]. If that name is unsuitable because it is not a FQDN
       (i.e., it is not a fully-qualified domain name because it does not
       contain a period), each of the alias names is examined (using
       ggeetthhoossttbbyynnaammee((33))[27]) until a FQDN is found. The jurisdiction name
       comes from the left-most component of the selected FQDN and the
       federation domain and name come from the remaining components. If no
       FQDN is found, the system's hostname will be selected as the
       jurisdiction name and defaults will be used as the federation domain
       and name (EXAMPLE.COM and EXAMPLE-COM, respectively).

       If the system's hostname is found to be (or explicitly given as)
       demo.example.com, for instance, the following variables will be set as
       indicated during rule evaluation:

       +o   _$_{_C_o_n_f_:_:_F_E_D_E_R_A_T_I_O_N___N_A_M_E_} and _$_{_D_A_C_S_:_:_F_E_D_E_R_A_T_I_O_N_} are both set to
           EXAMPLE-COM (dots are mapped to dashes to form a valid name)

       +o   _$_{_C_o_n_f_:_:_F_E_D_E_R_A_T_I_O_N___D_O_M_A_I_N_} is set to EXAMPLE.COM

       +o   _$_{_C_o_n_f_:_:_J_U_R_I_S_D_I_C_T_I_O_N___N_A_M_E_} and _$_{_D_A_C_S_:_:_J_U_R_I_S_D_I_C_T_I_O_N_} are set to the
           jurisdiction name, DEMO

       +o   _$_{_D_A_C_S_:_:_H_T_T_P___H_O_S_T_} is set to demo.example.com:80


       Often, rules and identities can be expressed such that the names chosen
       for the federation and jurisdiction are unimportant. When this is not
       the case, however, and the defaults chosen by ddaaccsscchheecckk are incorrect,
       they can be set on the command line. In some circumstances it might be
       appropriate for the jurisdiction name to be the name of the
       application, for example.

       Regardless of their origins, federation and jurisdiction names must
       always be syntactically valid (see ddaaccss((11))[24]).

   OObbjjeeccttss
       While an object will often be an actual thing, such as a file, menu, or
       variable, it can also be an abstraction, such as an operation.
       ddaaccsscchheecckk works with names - specifically, URIs - rather than objects
       _p_e_r _s_e.  _I_t _d_o_e_s _n_o_t _a_s_s_o_c_i_a_t_e _a_n_y _p_a_r_t_i_c_u_l_a_r _m_e_a_n_i_n_g _w_i_t_h _n_a_m_e_s_, _i_t
       _m_e_r_e_l_y _u_s_e_s _t_h_e_m _t_o _l_o_c_a_t_e _a_n _a_p_p_l_i_c_a_b_l_e _a_c_c_e_s_s _c_o_n_t_r_o_l _r_u_l_e.
       Therefore, provided the rule writer and applications that consult the
       rules agree on the naming scheme, the exact names that are chosen is
       largely irrelevant.

       An application assigns names to every object or class of objects that
       need to be referenced by access control rules. At its simplest, only
       one name is required (the name of the application, for example). In
       more complex situations, a wide variety of objects need to be named.
       The choice of names and the details of the naming hierarchy are up to
       the particular application, much like the organization of a software
       package's run-time file and directory organization depends on the
       particular package.

       The _o_b_j_e_c_t argument is the name that is matched against the services
       specified in access control rules. It can be either a URI or an
       absolute pathname (one that begins with a slash character), and either
       can have an optional query string component attached. An absolute
       pathname _p_a_t_h is mapped internally to a URI as file://_p_a_t_h; e.g.,
       /myapp is interpreted as file:///myapp (see RRFFCC 11773388[28]).

       The various components of the URI that names the object are available
       as DDAACCSS variables and environment variables (see below). If a query
       string is given, it is parsed and the individual arguments are made
       available to rules through the _A_r_g_s namespace, just as for DDAACCSS-wrapped
       web services.

           NNoottee
           Only the _p_a_t_h component of the URI is considered when DDAACCSS matches
           an object's name against the url_pattern of an access control rule.
           At present, the object name is not automatically canonicalized or
           resolved (see RRFFCC 33998866[29]), as is usually done by a web server, so
           relative path components should be avoided.

   RRuullee EEvvaalluuaattiioonn CCoonntteexxtt
       Rules are evaluated within an execution context that may affect
       expression evaluation implicitly or may be examined explicitly through
       variables.

       Since ddaaccsscchheecckk does not consult the DDAACCSS configuration files, the _C_o_n_f
       namespace is instantiated with few variables. At present, only the VFS
       directives are available in it.

       The _A_r_g_s namespace is instantiated if an _o_b_j_e_c_t argument has a query
       string component.

       The _D_A_C_S namespace is instantiated with a few standard variables (such
       as _$_{_D_A_C_S_:_:_J_U_R_I_S_D_I_C_T_I_O_N_}) but can also be instantiated in various ways
       from the command line and from files.

       The _E_n_v namespace is instantiated from the environment. Syntactically
       invalid variable names are silently ignored.

       Many variables normally set by a web server are instantiated by
       ddaaccsscchheecckk based on the object name. These variables are available in
       the _E_n_v and _D_A_C_S namespaces. For example, if the object name is
       https://example.com:8443/myapp/edit-menu?entry=item1, the following
       variables will be set as indicated:

           ${Env::HTTPS}=on
           ${Env::SERVER_NAME}=example.com
           ${Env::SERVER_ADDR}=142.179.101.118
           ${Env::HTTP_HOST}=example.com:8443
           ${Env::SERVER_PORT}=8443
           ${Env::REQUEST_URI}=/myapp/edit-menu
           ${Env::DOCUMENT_ROOT}=/
           ${Env::REQUEST_METHOD}=GET
           ${Env::SERVER_SOFTWARE}=dacscheck-1.4.8b
           ${Env::QUERY_STRING}=entry=item1
           ${Env::ARG_COUNT}=1
           ${Env::CURRENT_URI}=/myapp/edit-menu?entry=item1
           ${Env::CURRENT_URI_NO_QUERY}=/myapp/edit-menu

       Variables of the same name will also be set in the _D_A_C_S namespace and
       exported as environment variables. The value of _$_{_A_r_g_s_:_:_e_n_t_r_y_} will be
       item1. The request method defaults to GET. The variable
       _$_{_E_n_v_:_:_R_E_M_O_T_E___U_S_E_R_} (and therefore _$_{_D_A_C_S_:_:_R_E_M_O_T_E___U_S_E_R_} and the
       environment variable RREEMMOOTTEE__UUSSEERR) will be set based on the first
       identity specified on the command line; if no identity has been
       specified, this variable will be undefined.

   AAnn EExxaammppllee AApppplliiccaattiioonn
       To illustrate how the pieces fit together, let's consider a
       hypothetical (yet realistic) calendar application named ccaall that is
       written in PPeerrll and invoked as a CGI program. We'll allow a user that
       has been authenticated by the web server to read, create, or update
       only her own calendars, unless the owner of a calendar gives her
       permission to perform a read or update operation on the calendar. Each
       owner can specify which users have access to her own calendar and the
       type(s) of access allowed.

       This authorization policy can be specified fairly easily. One approach
       is to use:

       +o   A main rule that delegates responsibility for specifying a security
           policy for each user's calendars to that user.

       +o   Per-user, per-calendar rules that say which users can access a
           calendar and in what way or ways.


       The program's administrator might collect all of the run-time files for
       the application in the directory /usr/local/cal and its subdirectories,
       and organize it as follows:

       /usr/local/cal/rules/{acl-rule.0,acl-rule.1,...}
           General rules for the application

       /usr/local/cal/users/_u_s_e_r_n_a_m_e
           Root directory for calendars owned by _u_s_e_r_n_a_m_e

       /usr/local/cal/users/_u_s_e_r_n_a_m_e/cal-1/data/*
           Per-calendar data files

       /usr/local/cal/users/_u_s_e_r_n_a_m_e/rules/{acl-cal1.0,acl-cal2.0,...}
           Per-calendar DDAACCSS access control files

       /usr/local/cal/users/_u_s_e_r_n_a_m_e/groups/*
           Per-user DDAACCSS group lists, one per file

       Given these naming conventions:

       +o   to test whether it should perform a particular operation, the
           application would call ddaaccsscchheecckk, telling it to use the rules it
           finds in /usr/local/cal/rules.

       +o   the general rules for the application would delegate access control
           decisions for objects with names that match /users/_u_s_e_r_n_a_m_e/* to
           access control rules found in the directory
           /usr/local/cal/users/_u_s_e_r_n_a_m_e/rules. These rules would describe
           which users, if any, would be permitted to perform a given
           operation on the calendar.

       +o   the application would use object names of the form
           /users/_u_s_e_r_n_a_m_e/cal-1?OP=_o_p_e_r_a_t_i_o_n as arguments to ddaaccsscchheecckk. The
           ruleset for cal-1 would determine whether a given identity is
           allowed to perform the requested _o_p_e_r_a_t_i_o_n on the calendar. For
           example, alice (the owner) might be granted access regardless of
           the value of the _O_P argument, while bob might be granted access
           only if OP=read, and all others might be denied access. Later,
           alice might define a set of users that she names family and change
           the rule to allow any member of that group read and update access.


       Users' access control rules could themselves be under access control. A
       command line, GUI, or web interface would give the administrator and
       users the ability to manage rules.

       See the EEXXAAMMPPLLEESS[30] section for example rules.

       This is by no means the only way to organize the calendars, and a
       delegation-based approach isn't required. The administrator might
       instead put all of the rules under a common directory, like
       /usr/local/cal/rules/acl-_u_s_e_r_n_a_m_e.0/{acl-cal1.0,acl-cal2.0,...}, or put
       them closer to the calendar they are controlling, like
       /usr/local/cal/users/_u_s_e_r_n_a_m_e/cal-1/acl-cal1.0.

       Instead of testing whether an operation is permitted, rules can be
       written to return a constraint string that tells the caller what kind
       (or kinds) of access are permitted. The program's output line will
       include the constraint string within quotes.

   CCoommppaarriinngg ddaaccsscchheecckk wwiitthh ddaaccss__aaccss
       ddaaccss__aaccss((88))[31] is the DDAACCSS component that is called by AAppaacchhee (by the
       DDAACCSS mmoodd__aauutthh__ddaaccss[23] module, actually) to perform access control
       processing on web service requests. Its operation is normally invisible
       to web services; ddaaccss__aaccss does all of its work before a web service is
       even executed or a web page is returned.

       ddaaccsscchheecckk performs a function similar to the --cchheecckk__oonnllyy mode of
       operation of ddaaccss__aaccss in that it simply returns an access control
       decision. There are important differences between the two programs,
       however.

       ddaaccsscchheecckk:

       +o   is not a CGI program (though it can be called from one);

       +o   does not require mmoodd__aauutthh__ddaaccss[23];

       +o   does not use any DDAACCSS configuration files;

       +o   does not directly interact with a web server or any other DDAACCSS
           programs; and

       +o   runs at the privilege level of the user invoking it rather than the
           privilege level of AAppaacchhee.


       While ddaaccsscchheecckk uses ordinary DDAACCSS access control rules
       (ddaaccss..aaccllss((55))[7]), unlike most DDAACCSS commands it does not consult any
       DDAACCSS configuration files. The evaluation environment for access control
       rules is _s_i_m_i_l_a_r to that of web service testing, but it is not
       identical since there need not be a web server in the picture. Other
       than the attributes related to constraints, attributes such as
       pass_credentials have no meaning to ddaaccsscchheecckk.

       Use and configuration of DDAACCSS by ddaaccsscchheecckk is greatly simplified
       because no real federation or jurisdictions are defined; a completely
       self-contained environment is created so that a single program or set
       of related programs can perform both course-grained and fine-grained
       access control tests. No federation or jurisdiction cryptographic keys
       are used, and no real DDAACCSS credentials are created. Federation and
       jurisdiction names are instantiated, but those who write rules will
       often not need to be aware of them.

OOPPTTIIOONNSS
       The arguments are processed as they are examined (left-to-right) and
       their ordering can be significant; for example, values established by
       the --ffhh flag may affect options that follow it, such as those that use
       string interpolation. Exactly one _o_b_j_e_c_t argument is required.

       --aaddmmiinn
           All identities that follow on the command line are DDAACCSS identities
           that satisfy the ddaaccss__aaddmmiinn(()) function. Refer to the ADMIN_IDENTITY
           configuration directive in ddaaccss..ccoonnff((55))[32] and the "a" attribute
           for identities.

       --aapppp _a_p_p_n_a_m_e
           Specify an application name to be used to construct default paths
           (see the --rruulleess and --ggrroouuppss flags).

       --ccoonntteexxtt _f_i_l_e
           Variable definitions for the _D_A_C_S namespace are read, one per line,
           in the format _n_a_m_e=_v_a_l_u_e (with optional quotes around the _v_a_l_u_e).
           The _n_a_m_e must be syntactically valid. If _f_i_l_e is --, the standard
           input is read. For example, if _f_i_l_e contains the two lines:

               FOO=one
               BAZ=two

           then within access control rules _$_{_D_A_C_S_:_:_F_O_O_} will have the value
           "one" and _$_{_D_A_C_S_:_:_B_A_Z_} will have the value "two". This flag may be
           repeated, although the standard input can be read only once.

       --DD_n_a_m_e_=_v_a_l_u_e
           This is equivalent to --vvaarr _n_a_m_e_=_v_a_l_u_e.

       --dduummpp
           Perform all initializations, display the evaluation context, and
           then exit.

       --FF _f_i_e_l_d___s_e_p
           When roles are looked up, use the character _f_i_e_l_d___s_e_p as the field
           separator character instead of the default. For details, refer to
           the description of the VFS directive in ddaaccss..ccoonnff((55))[33].

               NNoottee
               Note that only the first occurrence of the character (from left
               to right) is treated as the separator character.

       --ffdd _d_o_m_a_i_n
           Use _d_o_m_a_i_n as the domain name for the federation. It must be
           syntactically valid.

       --ffhh _h_o_s_t_n_a_m_e
           Use _h_o_s_t_n_a_m_e, a fully-qualified domain name, as the system's
           hostname and to derive the federation and jurisdiction names. It
           must be syntactically valid.

       --ffjj _j_u_r_n_a_m_e
           Use _j_u_r_n_a_m_e as the jurisdiction name. It must be syntactically
           valid.

       --ffnn _f_e_d_n_a_m_e
           Use _f_e_d_n_a_m_e as the federation name. It must be syntactically valid.

       --ggrroouuppss _g_r_o_u_p___v_f_s
           By default, ddaaccsscchheecckk expects to find DDAACCSS group definitions rooted
           in the directory dacscheck/groups relative to DACS_HOME (e.g.,
           /usr/local/dacs/dacscheck/groups), or if --aapppp _a_p_p_n_a_m_e is given,
           rooted in the directory dacscheck/_a_p_p_n_a_m_e/groups relative to
           DACS_HOME (e.g., /usr/local/dacs/dacscheck/myapp/groups) This flag
           specifies a different location. It can be an absolute pathname
           (which will be string interpolated - see ddaaccss..ccoonnff((55))[34]) or a URI
           in the syntax of the VVFFSS[33] configuration directive. Examples:

               -groups "[groups]dacs-fs:/local/groups"
               -groups /home/bob/mygroups

           By default, a reference to the group %FOO:people will be mapped to
           a file named people.grp within the directory FOO relative to the
           DDAACCSS group directory.

       --hh
           Prints the usage blurb.

       --ii _i_d_e_n_t
           The given identity is added to the set of identities in effect
           during checking. This identity does not necessarily have an account
           on the system. If _i_d_e_n_t is the empty string, however, the flag has
           no effect; this is convenient behaviour when the flag is used like
           --ii $${{EEnnvv::::RREEMMOOTTEE__UUSSEERR::--""""}}, for example, where RREEMMOOTTEE__UUSSEERR may not
           have been set.

       --iiccggii
           If the environment variable RREEMMOOTTEE__UUSSEERR is set to a valid simple
           name or DDAACCSS identity, it is added to the set of identities in
           effect during checking. If the variable is not set or is invalid,
           this flag has no effect.

       --iiccggiigg
           Like the --iiccggii flag, except any roles associated with the username
           will be added.

       --iill _i_d_e_n_t
           The given identity is "local" and must correspond to an account on
           the system; if the --ggrroouuppss flag is in effect, the account's group
           membership will be added as roles to _i_d_e_n_t.

       --iillgg _i_d_e_n_t
           Like the --iillgg flag, except the account's group membership will be
           added as roles to _i_d_e_n_t regardless of whether the --ggrroouuppss flag is
           in effect.

       --iieeuuiidd
           The effective uid of the program is added to the set of identities.
           If the --ggrroouuppss flag is in effect, the account's group membership
           will be added as roles to _i_d_e_n_t.

       --iieeuuiiddgg
           The effective uid of the program is added to the set of identities.
           The account's group membership will be added as roles to _i_d_e_n_t
           regardless of whether the --ggrroouuppss flag is in effect.

       --iiuuiidd
           The real uid of the program is added to the set of identities. If
           the --ggrroouuppss flag is in effect, the account's group membership will
           be added as roles to _i_d_e_n_t.

       --iiuuiiddgg
           The real uid of the program is added to the set of identities. The
           account's group membership will be added as roles to _i_d_e_n_t
           regardless of whether the --ggrroouuppss flag is in effect.

       --llgg
           For each local identity that follows on the command line, use its
           Unix group membership to the identity's roles.

       --llll _l_o_g___l_e_v_e_l
           Set the debugging output level to _l_o_g___l_e_v_e_l (see ddaaccss((11))[21]). The
           default level is warn, and the --vv flag bumps the level to debug or
           trace.

       --qq
           Be quiet, except for error messages; the outcome will not be
           printed to stdout. The --vv and --llll flags are independent of this.

       --rreeddiirreecctt
           If access is denied and the applicable rule calls rreeddiirreecctt(())[35]
           with the BY_SIMPLE_REDIRECT argument, then the specified URL is
           printed to stdout. This flag enables the --qq flag.

       --rroolleess _r_o_l_e_s___v_f_s
           Roles for each identity that follows on the command line will be
           looked up using _r_o_l_e_s___v_f_s. It can be an absolute pathname (which
           will be string interpolated - see ddaaccss..ccoonnff((55))[34]) or a URI in the
           syntax of the VVFFSS[33] configuration directive. If any roles are
           found, they will be added to any other roles specified for the user
           (whether explicitly listed or obtained from Unix group membership).
           For example, if /usr/local/myapp/roles contains:

               bobo:users
               auggie:admin,users
               harley:guest

           then the command line:

               % dacscheck -roles /usr/local/myapp/roles -i auggie /myapp/admin

           will test access for the identity {u="auggie",g="admin,users"}.

       --rruulleess _r_u_l_e___v_f_s
           By default, ddaaccsscchheecckk expects to use a ruleset rooted in the
           directory dacscheck/acls relative to DACS_HOME (e.g.,
           /usr/local/dacs/dacscheck/acls), or if the flag --aapppp _a_p_p_n_a_m_e is
           given, rooted in the directory dacscheck/_a_p_p_n_a_m_e/acls relative to
           DACS_HOME (e.g., /usr/local/dacs/dacscheck/myapp/acls). This flag
           specifies a different ruleset to be used. It can be an absolute
           pathname (which will be string interpolated - see ddaaccss..ccoonnff((55))[34])
           or a URI in the syntax of the VVFFSS[33] configuration directive.
           Examples:

               -rules "[acls1]dacs-fs:/local/acls"
               -rules /usr/local/myrules

           This flag may be repeated; rulesets will examined in the order in
           which they are specified on the command line.

       --vv
           Increase the level of debugging output. The flag may be repeated.

       --vvaarr _n_a_m_e_=_v_a_l_u_e
           Like the --ccoonntteexxtt flag, this adds a variable definition to the _D_A_C_S
           namespace. The variable _D_A_C_S_:_:_n_a_m_e will be assigned the string
           _v_a_l_u_e. The _n_a_m_e must be syntactically valid. This flag may be
           repeated.

       --vvffss _v_f_s___u_r_i
           Add _v_f_s___u_r_i as a VVFFSS[33] configuration directive. This flag may be
           repeated, with later occurrences having a higher "priority" than
           earlier ones (just as if they appeared later in dacs.conf; see
           ddaaccss..ccoonnff((55))[32]).

       ----
           This marks the end of the flag arguments.

EEXXAAMMPPLLEESS
       To illustrate how ddaaccsscchheecckk might be used with real applications, here
       are some examples. The first few continue with the hypothetical
       calendar application described earlier.

        1. The file /usr/local/cal/rules/acl-rule.0 might look like:

               <acl_rule status="enabled">
                <services>
                 <delegate url_pattern="/users/alice/*"
                         rule_uri="/usr/local/cal/users/alice/rules/>
                 <delegate url_pattern="/users/bob/*"
                         rule_uri="/usr/local/cal/users/bob/rules/>
                 <service url_pattern="/usr/local/cal/bin/*"/>
                </services>

                <rule order="allow,deny">
                  <allow>
                     user("auth")
                  </allow>
                </rule>
               </acl_rule>

           This rule redirects requests for a particular user's calendar to
           that user's access control rules. It also says that access to the
           application's binaries is restricted to authenticated users. The
           application might issue a command such as:

               % dacscheck -i $REMOTE_USER -rules /usr/local/cal/rules _o_b_j_e_c_t

           which will return an exit status of 0 if RREEMMOOTTEE__UUSSEERR is granted
           access to _o_b_j_e_c_t; otherwise an exit status of 1 will be returned. A
           better choice is to use the command:

               % dacscheck -icgi -rules /usr/local/cal/rules _o_b_j_e_c_t

           which will leave the user unauthenticated if RREEMMOOTTEE__UUSSEERR is unset
           or invalid.

        2. The file /usr/local/cal/users/alice/rules/acl-cal1.0 contains the
           rule for user alice's "Calendar 1" and might look like:

               <acl_rule status="enabled">
                <services>
                 <service url_pattern="/users/alice/cal-1/*"/>
                </services>

                <rule order="allow,deny">
                  <precondition>
                    <predicate> user(":alice") </predicate>
                  </precondition>
                  <allow>
                    return(1)
                  </allow>
                </rule>

                <rule order="allow,deny">
                  <precondition>
                    <predicate> ${Args::OP} eq "read" </predicate>
                  </precondition>
                  <allow>
                    user(":bob")
                  </allow>
                </rule>

               </acl_rule>

           This rule says that alice is allowed full access to the calendar
           (there is no restriction on the operation), but bob only has read
           access.  ddaaccsscchheecckk would be called with
           /users/alice/cal-1?OP=create, /users/alice/cal-1?OP=update, or
           /users/alice/cal-1?OP=read to test for authorization to perform a
           create, update, or read operation on the calendar, respectively.

        3. If alice defines a DDAACCSS group that she calls family and adds the
           names julia and auggie to that group, she might modify the rule
           above by adding the following:

               <rule order="allow,deny">
                  <precondition>
                    <predicate> ${Args::OP} eq "read"
                            or ${Args::OP} eq "update"</predicate>
                  </precondition>
                  <allow>
                    user("%:alice-family")
                  </allow>
                </rule>

           This rule says that any member of the group alice-family is allowed
           read and update access to this calendar. The command:

               % dacscheck -i julia /users/alice/cal-1?OP=update

           would report that access is granted.

        4. The membership of alice's group called alice-family might be
           specified in the file /usr/local/cal/users/alice/groups/family

               <acl_rule status="enabled">
                <services>
                 <service url_pattern="/users/alice/groups/*"/>
                </services>

                <rule order="allow,deny">
                  <precondition>
                    <predicate> user(":alice") </predicate>
                  </precondition>
                  <allow>
                    return(1)
                  </allow>
                </rule>
               </acl_rule>

           This rule allows only alice to manage the membership of this group,
           but she is free modify the rule to allow others to manage her
           groups.

        5. As a final example for this application, alice's rules might also
           be under access control:

               <acl_rule status="enabled">
                <services>
                 <service url_pattern="/users/alice/groups/*"/>
                </services>

                <rule order="allow,deny">
                  <precondition>
                    <predicate> user(":alice") </predicate>
                  </precondition>
                  <allow>
                    return(1)
                  </allow>
                </rule>
               </acl_rule>

           This rule allows only alice to manage the membership of this group,
           but she is free modify the rule to allow others to manage her
           groups.

        6. A popular open source web log analyzer program, written in Perl,
           can be invoked as a CGI program. The program includes security
           provisions whereby it can restrict access to any user authenticated
           by the web server, by username (using RREEMMOOTTEE__UUSSEERR, as exported by
           the web server), or based on the user's IP address (using
           RREEMMOOTTEE__AADDDDRR). The approximately 40 lines of code (plus assorted
           initializations) that implements this security policy can
           essentially be replaced by just a few lines of code:

               my $exit_value = 0;
               system "/usr/local/dacs/bin/dacscheck", "-q", "-icgi", "-rules",
                  "/usr/local/webstats/acls", "/webstats";
               $exit_value  = $? >> 8;
               # print "dacscheck returned $exit_value for user \"$remote_user\"\n";
               if ($exit_value != 0) {
                 # dacscheck denies access; print message and exit
                 exit 1;
               }

               # dacscheck grants access, so continue


               TTiipp
               The DDAACCSS distribution includes a Perl module
               (/usr/local/dacs/lib/perl/DACScheck.pm) to make ddaaccsscchheecckk a
               little easier to use. The example above would be written as:

                   use DACScheck.pm;
                   dacscheck_rules("/usr/local/webstats/acls");

                   my $result = dacscheck_cgi("/webstats");
                   if ($result != 1) {
                     # dacscheck denies access; print message and exit
                     exit 1;
                   }

                   # dacscheck grants access, so continue

           A simple DDAACCSS access control rule can be written to duplicate the
           program's security functionality (using the uusseerr(()) and ffrroomm(())
           predicates, see ddaaccss..eexxpprrss((55))[20]), but more sophisticated policies
           can be added easily, all without having to modify the Perl program
           again.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if access is granted and 1 if access is denied. Any
       other exit status indicates an error occurred.

BBUUGGSS
       A lightweight method of defining DDAACCSS groups is needed. Once the
       internal are stable, this program's functionality will be made
       available through a C/C++ API, which will permit direct, efficient use
       by other applications and extensible languages (through ppeerrllxxss((11)), for
       example).

       The DDAACCSS__AACCSS aarrgguummeenntt[36] is not recognized by ddaaccsscchheecckk.

       Identities are not considered when roles are looked up; only the
       username is matched.

       Unlike ddaaccss__aaccss((88))[31], there is no support for automatically setting
       variables by parsing a message body (a MIME document).

       It might be possible to create a layer between an application and the
       underlying system so that ddaaccsscchheecckk can be called transparently, or
       nearly so.

SSEEEE AALLSSOO
       See ddaaccss((11))[21], ddaaccss..aaccllss((55))[7], ddaaccss..ccoonnff((55))[32], ddaaccss..eexxpprrss((55))[20],
       ddaaccss..ggrroouuppss((55))[22], ddaaccss..jjaavvaa((77))[37].

       RRuullee--bbaasseedd aacccceessss ccoonnttrrooll[38]

       DACScheck.pm

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[39])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[40] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. Perl
           http://www.perl.org/

        2. PHP
           http://www.php.net/

        3. Python
           http://www.python.org

        4. Ruby
           http://www.ruby-lang.org

        5. Tcl/Tk
           http://www.tcl.tk/software/

        6. geteuid(2)
           http://www.freebsd.org/cgi/man.cgi?query=geteuid&apropos=0&sektion=2&manpath=FreeBSD+7.2-RELEASE&format=html

        7. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

        8. getfacl(1)
           http://www.freebsd.org/cgi/man.cgi?query=getfacl&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

        9. setfacl(1)
           http://www.freebsd.org/cgi/man.cgi?query=setfacl&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       10. acl(3)
           http://www.freebsd.org/cgi/man.cgi?query=acl&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       11. htpasswd(1)
           http://httpd.apache.org/docs/2.2/programs/htpasswd.html

       12. Using FreeBSD's ACLs
           http://www.onlamp.com/pub/a/bsd/2005/09/22/FreeBSD_Basics.html

       13. ONLamp.com
           http://www.onlamp.com

       14. POSIX ACLs in Linux
           http://www.cs.unc.edu/cgi-bin/howto?howto=linux-posix-acls

       15. linux.com
           http://linux.com

       16. Solaris 10 acl(2)
           http://docs.sun.com/app/docs/doc/816-5167/6mbb2jaf2?a=view

       17. Sun Microsystems
           http://www.sun.com

       18. Using Solaris ACLs
           http://www.cs.duke.edu/csl/faqs/solaris-acls.php

       19. Dept. of Computer Science, Duke University
           http://www.cs.duke.edu

       20. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       21. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       22. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       23. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

       24. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       25. concise syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       26. gethostname(3)
           http://www.freebsd.org/cgi/man.cgi?query=gethostname&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       27. gethostbyname(3)
           http://www.freebsd.org/cgi/man.cgi?query=gethostbyname&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       28. RFC 1738
           http://www.rfc-editor.org/rfc/rfc1738.txt

       29. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       30. EXAMPLES
           http://dacs.dss.ca/man/#EXAMPLES

       31. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       32. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       33. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       34. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#interpolation

       35. redirect()
           http://dacs.dss.ca/man/dacs.exprs.5.html#redirect

       36. DACS_ACS argument
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

       37. dacs.java(7)
           http://dacs.dss.ca/man/dacs.java.7.html

       38. Rule-based access control
           http://www-128.ibm.com/developerworks/webservices/library/ws-soa-access.html

       39. www.dss.ca
           http://www.dss.ca

       40. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      DACSCHECK(1)
