DACS_NOTICES(8)            DACS Web Services Manual            DACS_NOTICES(8)



NNAAMMEE
       dacs_notices - DDAACCSS notice presentation and acknowledgement handler

SSYYNNOOPPSSIISS
       ddaaccss__nnoottiicceess [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       Some web service providers have a requirement that users must
       acknowledge a notice of some sort before access can be granted to an
       associated resource. A user attempting to access such a resource is
       shown a web page containing the notice and asked to acknowledge it or
       accept its conditions, typically by pressing an "I Accept" button on
       the web page. These notices are commonly legal notices, such as
       copyright notices, licensing notices, restricted access notices, and
       terms-of-use notices. This can also be applied to alert users to news
       (a warning about upcoming system maintenance, for example).

       ddaaccss__aaccss((88))[2] (the DDAACCSS access control service, or AACCSS) can be
       configured to invoke ddaaccss__nnoottiicceess when access control processing
       determines that one or more notices have not been acknowledged.
       ddaaccss__nnoottiicceess acts as both a generic notice presentation handler (it
       retrieves notices, presents them to the user, and requests the user to
       acknowledge the notices) and a matching notice acknowledgement handler
       (executed to process the user's response and take appropriate action).
       The presentation aspect of the program can be customized. It takes
       steps to defeat attempts to bypass notice presentation.

       In the DDAACCSS implementation, a notice (N) is usually some text,
       identified by a URL. A notice is associated with one or more resources
       (R) such that an attempt to access any of these resources requires the
       user to first explicitly acknowledge the textual material. A DDAACCSS event
       handler (H) is responsible for presenting the notice to the user. The
       basic flow of control is roughly as follows:

                   USER                  |  Apache/DACS

             a)    --- Request for R --->|---> (DACS Access Control Service)
             b)    <--- Redirect to H ---|<--

             c)    --- Request for H --->|---> (a notice presentation handler)
             d)        <--- Return N ----|<---

             e)     --- Submit Ack N --->|-->  (a notice acknowledgement handler)
             f)    <--- Redirect to R ---|<--

             g)    --- Request for R --->|---> (DACS access control service)
             h)                <--- R ---|<--

       More than one notice can be associated with a resource, in which case
       they are effectively concatenated for presentation purposes and
       collectively acknowledged (so N may be N1, N2, ..., Nn and Ack N
       acknowledges all of them).

       Having already acknowledged N in a session, a user should not need to
       do so again.  ddaaccss__nnoottiicceess uses a purely client-side approach; cookies
       are issued to remember that resources have been acknowledged. These
       cookies are called notice acknowledgement tokens or NATs. The
       implementation handles both authenticated and unauthenticated
       (anonymous) users. The cookie name consists of a prefix, the federation
       name, the jurisdiction name, and a unique component; see
       ddaaccss..ccoonnff((55))[3] for a description of configuration directives used by
       this program, including the NNOOTTIICCEESS__NNAATT__NNAAMMEE__PPRREEFFIIXX[4] directive.

       The program accepts the standard _F_O_R_M_A_T argument (see ddaaccss((11))[5]) to
       select between generation of an HTML presentation page intended for
       display by a browser (the default) or XML output intended for
       middleware. Output customization applies only to the former. When
       generating HTML output, ddaaccss__nnoottiicceess emits instructions, the content of
       the notices, and an HTML form by which the user submits a response.

           NNoottee
           Of course, apart from answering a skill-testing question or the
           like, there's no way of knowing that a user has actually read and
           understood the notices. It is unclear to what extent it is
           necessary to go in this regard with respect to providing support.
           DDAACCSS cannot guarantee that a human user has actually read these
           notices and indicated acceptance of them, but it can guarantee
           (optionally, using sseeccuurree mmooddee[6]) that a NAT cannot be obtained by
           a client without the client having received a copy of the notices.
           If the client wants to "trick the system" by not actually
           presenting the notices to the user or soliciting a response it can,
           and in this event the service provider might consider legal
           recourse.

       In future versions of DDAACCSS, the idea of notice/acknowledgement
       processing may be generalized so that an arbitrary condition can be
       tested for by access control rules, remembered through client-side
       state (for example), and made available via a seamless workflow.

   OOppeerraattiioonn
       Configuring notice acknowledgement processing involves:

       +o   Configuring an AACCSS__EERRRROORR__HHAANNDDLLEERR[7] directive to catch ACK_NEEDED
           (error code 905) events and invoke ddaaccss__nnoottiicceess;

       +o   Calling the aacckk[8] predicate from an access control rule to specify
           the notices that must be acknowledged; and

       +o   Configuring ddaaccss__nnoottiicceess.


       The following configuration directives are examined by ddaaccss__nnoottiicceess.
       All of these directives are optional. Refer to the individual
       directives for additional details.

       +o    NNOOTTIICCEESS__AACCKK__HHAANNDDLLEERR[9]: the URL of the notice acknowledgement
           handler, if not ddaaccss__nnoottiicceess.

       +o    NNOOTTIICCEESS__AACCCCEEPPTT__HHAANNDDLLEERR[10]: the URL (absolute or relative) to
           which a user agent will be redirected after a positive
           acknowledgement to a notice has been received (i.e., the notice or
           notices were "accepted"), if it is not possible to redirect the
           user agent to the request that initiated notice acknowledgement
           processing (e.g., if that request used the POST method).

       +o    NNOOTTIICCEESS__DDEECCLLIINNEE__HHAANNDDLLEERR[11]: the URL (absolute or relative) to
           which a user agent will be redirected after a negative
           acknowledgement to a notice has been received (i.e., the notice or
           notices were "declined").


           NNoottee
           When determining whether a resource has already been acknowledged,
           the query component of a resource URI is not considered.

       When emitting HTML, the web page generated by ddaaccss__nnoottiicceess can be
       customized through the notices VFS item type. The following items are
       emitted if they exist:

       +o   header: Initial HTML to emit.

       +o   prologue: HTML to emit immediately after the header.

       +o   instructions: HTML to emit immediately after the prologue and
           before the notices.

       +o   epilogue: HTML to emit immediately after the form that follows the
           notices.

       +o   trailer: Final HTML to emit.

       For example, given the configuration directives:

           VFS "[notices]dacs-fs:${Conf::DACS_HOME}/notices"

       files named header and trailer in the directory
       ${Conf::DACS_HOME}/notices would be expected to contain the initial and
       final HTML content, respectively. Note that these consist of text and
       HTML markup but are not complete HTML documents.

       Customization of the form is possible using configuration variables:

       +o   _n_o_t_i_c_e_s___p_r_o_m_p_t___t_e_x_t: This label appears immediately before the HTML
           form. The default is something like "Your response to the preceding
           notices is requested:<p>".

       +o   _n_o_t_i_c_e_s___a_c_c_e_p_t___l_a_b_e_l: This label appears next to the radio button
           corresponding to the "accepted" response. The default is something
           like "I Accept".

       +o   _n_o_t_i_c_e_s___d_e_c_l_i_n_e___l_a_b_e_l: This label appears next to the radio button
           corresponding to the "declined" response. The default is something
           like "I Decline".

       +o   _n_o_t_i_c_e_s___s_u_b_m_i_t___l_a_b_e_l: This label appears in the submit button. The
           default is something like "Send".

       Here are some examples of how these variables might be set to customize
       the form:

           EVAL ${Conf::notices_prompt_text} = "My &lt;b&gt;custom&lt;/b&gt; prompt:"
           EVAL ${Conf::notices_accept_label} = "I really do accept&lt;br&gt;"
           EVAL ${Conf::notices_submit_label} = "Submit me!"


   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[12], ddaaccss__nnoottiicceess understands
       the following CGI arguments:

       _A_C_C_E_P_T___L_A_B_E_L
           The value of this optional parameter is used by the notice
           presentation handler and overrides the value of the
           _$_{_C_o_n_f_:_:_n_o_t_i_c_e_s___a_c_c_e_p_t___l_a_b_e_l_} variable, if any.

       _D_E_C_L_I_N_E___L_A_B_E_L
           The value of this optional parameter is used by the notice
           presentation handler and overrides the value of the
           _$_{_C_o_n_f_:_:_n_o_t_i_c_e_s___d_e_c_l_i_n_e___l_a_b_e_l_} variable, if any.

       _H_M_A_C
           This value is a secure keyed hash. It is computed by ddaaccss__aaccss for
           use by the notice presentation handler. A hash is also computed
           (over different material) by the presentation handler and passed to
           the notice acknowledgement handler with the user's response and
           other information. Its purpose is to make it difficult to obtain a
           notice acknowledgement token directly by side-stepping notice
           acknowledgement processing. The federation-wide HMAC key is used.
           Please refer to the description of SSeeccuurree MMooddee[6].

           Neither this argument nor the TTIIMMEE[13] argument are used or
           required if the NNOOTTIICCEESS__SSEECCUURREE__HHAANNDDLLEERR[14] configuration directive
           has the value "no".

       _N_O_T_I_C_E___U_R_I_S
           The value of this argument is a space-separated list of URIs, each
           of which is invoked using the GET method and is expected to return
           a notice document.

               NNoottee
               The notices are expected to be fragments of HTML text, not
               complete HTML documents; each notice is "pasted" into the
               presentation page exactly as obtained from its URI.

       _T_I_M_E
           This is the Unix time at which ddaaccss__aaccss invoked the notice
           presentation handler for this workflow. It is used to limit the
           lifetime of the workflow so that it cannot easily be rerun to
           obtain notice acknowledgement tokens at will.

       _R_E_S_O_U_R_C_E___U_R_I_S
           The value of this argument is a space-separated list of URIs, each
           of which is associated with the notice(s).

       _R_E_S_P_O_N_S_E
           Passed to the notice acknowledgement handler, this argument is the
           user's response and must either be accepted or declined.

   MMiiddddlleewwaarree SSuuppppoorrtt
       ddaaccss__nnoottiicceess can be asked to emit various flavours of XML in support of
       middleware or thick clients. This is useful when middleware would
       prefer to prompt the user itself (acting as a notice presentation
       handler) and then invoke a acknowledgement handler (such as
       ddaaccss__nnoottiicceess) to obtain a NAT. Any customizations specified for HTML
       output are ignored when XML is being produced and are not passed to
       middleware.

       The XML emitted by ddaaccss__nnoottiicceess conforms to the DTD
       ddaaccss__nnoottiicceess..ddttdd[15]. When acting as a notice presentation handler, it
       returns a presentation_reply element and when acting as a notice
       acknowledgement handler, it returns a ack_reply element; in either mode
       of operation an error reply is possible (via the common_status
       element).

       In conjunction with ddaaccss__aaccss((88))[2], ddaaccss__nnoottiicceess can optionally operate
       in a "secure" mode, where a particular control flow is enforced.

       The simple (non-secure) mode will be described first.

       SSiimmppllee MMooddee
           The presentation_reply element lists one or more notices that must
           be acknowledged by the user. It includes a space-separated list of
           the URIs of the notices and a space-separated list of the URIs of
           resources that require these notices to be acknowledged. The text
           of the notices are base-64 encoded within the notice element, as
           specified by RRFFCC 22004455[16] (Section 6.8). The notice's URI is
           included as an attribute.

           The ack_reply element returns the user's response and, optionally,
           a URI to which the user can be redirected (depending on the
           context, this may be the URI of the request that required notices
           to be acknowledged, the value of the NNOOTTIICCEESS__AACCCCEEPPTT__HHAANNDDLLEERR[10]
           directive, or the value of the NNOOTTIICCEESS__DDEECCLLIINNEE__HHAANNDDLLEERR[11]
           directive). If a NAT is issued, it is returned (as an HTTP cookie)
           by the notice presentation handler.

       SSeeccuurree MMooddee
           The secure mode of operation, which may not be necessary in some
           environments, serves two main purposes:

            1. a NAT can be cryptographically protected against forgery and
               alteration. Refer to ddaaccss..nnaatt((55))[17].

            2. DDAACCSS can enforce a flow of control so that a client cannot
               obtain a NAT without having received a copy of the notice(s);
               this is the purpose of the hmac and time attributes. That is,
               DDAACCSS can make it necessary for the client to first call
               ddaaccss__aaccss((88))[2] with _-_c_h_e_c_k___o_n_l_y or _-_c_h_e_c_k___f_a_i_l, then call the
               notice presentation handler to get the text of the notices, and
               then call the notice acknowledgement handler to request the
               NAT. No other control flow is possible (ignoring errors).

           When combined, these protections make it difficult for an attacker
           or unfriendly user to bypass having to acknowledge notices by
           manufacturing NATs or having DDAACCSS simply issue arbitrary NATs.

           The value of the NNOOTTIICCEESS__SSEECCUURREE__HHAANNDDLLEERR[14] configuration directive
           determines whether the secure mode is disabled; it is enabled by
           default (see ddaaccss..ccoonnff((55))[3]).

           In secure mode, the total duration of the work flow is limited to
           120 seconds by default. This limit can be set using the
           NNOOTTIICCEESS__WWOORRKKFFLLOOWW__LLIIFFEETTIIMMEE__SSEECCSS[18] directive.

           Regardless of the selected output format, the required flow of
           control is:

            1. ddaaccss__aaccss receives a service request

               Access to the requested resource will not be granted by
               ddaaccss__aaccss((88))[2] until one or more notices have been acknowledged
               by the user.  ddaaccss__aaccss either redirects the client to the
               notice presentation handler or returns an XML document
               (ddaaccss__aaccss..ddttdd[19]) that describes which notices must be
               displayed and acknowledged; the behaviour depends on the
               service request. The notice presentation handler must be
               invoked and will expect to be passed the HHMMAACC[20] and TTIIMMEE[13]
               arguments.

               Provided they are in the same federation, the notice
               presentation handler may be in a different jurisdiction from
               ddaaccss__aaccss.

            2. Notice presentation handler is invoked

               The user is expected to be presented with the notices and asked
               to accept or decline them. The handler either returns a web
               page containing an HTML form or an XML document
               (ddaaccss__nnoottiicceess..ddttdd[15]). In either case, the handler will verify
               that ddaaccss__aaccss had been called "recently" (the security-related
               arguments expire after a set amount of time and cannot be
               reused). Its output will include HHMMAACC[20] and TTIIMMEE[13]
               arguments, either of which may differ from the values passed
               into the program; the notice acknowledgement handler expects to
               be passed these arguments.

            3. Notice acknowledgement handler is invoked

               The user's response is directed to the notice acknowledgement
               handler, which verifies that the notice presentation handler
               has been called. The handler either redirects the user
               appropriately or returns an XML document
               (ddaaccss__nnoottiicceess..ddttdd[15]). If no error has occurred and the user
               has accepted the notices, a NAT will also be returned.


           NNoottee
           In secure mode, presentation handling and acknowledgement handling
           are "matched". If ddaaccss__nnoottiicceess provides the latter functionality
           but not the former, presentation handling must behave as
           ddaaccss__nnoottiicceess expects (in its acknowledgement handling mode) with
           respect to security. When secure mode is used with middleware that
           performs its own presentation handling, for example, middleware
           will likely need to invoke ddaaccss__nnoottiicceess in its presentation
           handling mode solely to obtain security parameters to pass to
           ddaaccss__nnoottiicceess in its acknowledgement handling mode.

           When ddaaccss__nnoottiicceess acts as a notice presentation handler, it will
           validate its arguments (which originate from ddaaccss__aaccss) and emit
           values that may be validated by the notice acknowledgement handler.
           When ddaaccss__nnoottiicceess acts as a notice acknowledgement handler, it will
           validate its arguments. Therefore, if the notice acknowledgement
           handler runs in secure mode, the notice presentation handler must
           also run in secure mode.

           The presentation handling mode and the acknowledgement handling
           mode of ddaaccss__nnoottiicceess must agree on the URL of the acknowledgement
           handler. This means that either the identical URL must be used for
           both modes or both modes must find the NOTICES_ACK_HANDLER
           directive configured to the same value (as when two different
           jurisdictions are involved).

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       A client-side approach is used to note that resources have been
       acknowledged. While this is probably the simplest approach that works
       with both authenticated and unauthenticated users, it does not offer
       much support if one wants acknowledgements by authenticated users to be
       remembered across sessions (i.e., permanently). One possible solution
       is to allow persistent notice acknowledgements to be enabled for
       authenticated users, suppressing NAT cookies and causing a record to be
       written to a configured VFS item type when an authenticated user has
       accepted a notice. The aacckk(()) predicate would be extended so that the
       existence of persistent acknowledgement records could be checked, and
       some means of maintaining the persistent records might be added.

       The method used for generation of custom web pages is clunky and should
       be reconsidered.

SSEEEE AALLSSOO
       ddaaccss..nnaatt((55))[17], ddaaccss__aaccss((88))[2]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[21])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[22] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        3. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        4. NOTICES_NAT_NAME_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_NAT_NAME_PREFIX

        5. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        6. secure mode
           http://dacs.dss.ca/man/#secure_mode

        7. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

        8. ack
           http://dacs.dss.ca/man/dacs.exprs.5.html#ack

        9. NOTICES_ACK_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_ACK_HANDLER

       10. NOTICES_ACCEPT_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_ACCEPT_HANDLER

       11. NOTICES_DECLINE_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_DECLINE_HANDLER

       12. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       13. TIME
           http://dacs.dss.ca/man/#TIME

       14. NOTICES_SECURE_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_SECURE_HANDLER

       15. dacs_notices.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_notices.dtd

       16. RFC 2045
           http://www.rfc-editor.org/rfc/rfc2045.txt

       17. dacs.nat(5)
           http://dacs.dss.ca/man/dacs.nat.5.html

       18. NOTICES_WORKFLOW_LIFETIME_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#NOTICES_WORKFLOW_LIFETIME_SECS

       19. dacs_acs.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_acs.dtd

       20. HMAC
           http://dacs.dss.ca/man/#HMAC

       21. www.dss.ca
           http://www.dss.ca

       22. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                   DACS_NOTICES(8)
