DACS_AUTOLOGIN_SSL(8)      DACS Web Services Manual      DACS_AUTOLOGIN_SSL(8)



NNAAMMEE
       dacs_autologin_ssl - use an SSL client certificate to automatically
       obtain DDAACCSS credentials

SSYYNNOOPPSSIISS
       ddaaccss__aauuttoollooggiinn__ssssll [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccss__aauuttoollooggiinn__ssssll CGI program, in conjunction with appropriate
       DDAACCSS configuration and a valid SSL client certificate, can be used for
       user-transparent DDAACCSS authentication. A user is not prompted for a
       username or password, and no user-visible sign-on procedure takes
       place.

       At present, the program merely acts as glue to indirectly invoke
       ddaaccss__aauutthheennttiiccaattee((88))[2]. Any valid X.509 certificate can be used for
       this purpose, including a self-signed certificate. Please refer to the
       OOppeennSSSSLL[3] documentation for additional information about certificates.

       This program can be used to automatically and transparently
       authenticate a user that has been issued an SSL client certificate.
       When an unauthenticated user is denied access to a DDAACCSS-wrapped
       resource, she can be automatically authenticated and redirected back to
       the resource without any user input or action. This assumes that the
       client certificate is sent automatically by the browser and that no
       additional user prompting is needed by the authenticating jurisdiction.
       For redirection to the original resource to work properly. the original
       request must have used the GET method.

           NNoottee
           The cert style of authentication _m_u_s_t be configured when
           ddaaccss__aauuttoollooggiinn__ssssll is being used as described. See
           ddaaccss__aauutthheennttiiccaattee((88))[4].

OOPPTTIIOONNSS
       Only the standard _d_a_c_s_o_p_t_i_o_n_s[1] command line arguments are recognized.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       ddaasscc__aauuttoollooggiinn__ssssll understands the following CGI arguments.

       _D_A_C_S___E_R_R_O_R___U_R_L
           When ddaaccss__aauuttoollooggiinn__ssssll is invoked as a result of DDAACCSS event
           handling, _D_A_C_S___E_R_R_O_R___U_R_L is automatically passed to it by
           ddaaccss__aaccss((88))[5] and represents the original URL to which access was
           denied. In typical use, ddaaccss__aauuttoollooggiinn__ssssll is configured as the
           handler for a ddaaccss__aaccss 990022 error code (NO_AUTH, "Authentication by
           DACS is required").  ddaaccss__aauuttoollooggiinn__ssssll then invokes
           ddaaccss__aauutthheennttiiccaattee. If DDAACCSS authentication is successful,
           ddaaccss__aauutthheennttiiccaattee ordinarily issues a browser redirect to the value
           of _D_A_C_S___E_R_R_O_R___U_R_L and a cookie bearing the credentials are set in
           the browser (but see the _N_O_R_E_D_I_R_E_C_T argument). This argument is
           optional; if not provided, the jurisdiction's configured
           post-authentication action will occur.

       _N_O_R_E_D_I_R_E_C_T
           If this optional argument is present (its value is immaterial),
           ddaaccss__aauuttoollooggiinn__ssssll instructs ddaaccss__aauutthheennttiiccaattee to _n_o_t issue a
           browser redirect to the value of _D_A_C_S___E_R_R_O_R___U_R_L.

       _A_U_T_H___J_U_R_I_S_D_I_C_T_I_O_N
           If this optional argument is present, it gives the name of the
           jurisdiction at which authentication should take place. By default,
           ddaaccss__aauutthheennttiiccaattee is invoked at the same jurisdiction as
           ddaaccss__aauuttoollooggiinn__ssssll.

       _C_E_R_T___N_A_M_E___A_T_T_R
           This optional argument explicitly names the attribute in the
           certificate from which to set _U_S_E_R_N_A_M_E. The default value is
           _S_S_L___C_L_I_E_N_T___S___D_N___C_N. It is an error if the specified attribute name
           does not exist. Giving the value of _C_E_R_T___N_A_M_E___A_T_T_R as the empty
           string results in the empty string being passed as the value of
           _U_S_E_R_N_A_M_E.

EEXXAAMMPPLLEE
       A typical use of ddaaccss__aauuttoollooggiinn__ssssll is to transparently authenticate a
       user via his SSL client certificate.

       In the DDAACCSS configuration file, dacs.conf, jurisdiction EXAMPLE is
       configured as follows (this excerpt from a configuration file uses
       fictitious domain names):

           <Jurisdiction uri="example.com">

           JURISDICTION_NAME "EXAMPLE"

           ACS_ERROR_HANDLER "NO_AUTH https://example.com/cgi-bin/dacs/dacs_autologin_ssl"

           <!-- Authenticate using an SSL certificate. -->
           <Auth id="cert">
           URL "https://example.com/cgi-bin/dacs/local_cert_authenticate"
           STYLE "cert"
           CONTROL "sufficient"
           CERT_CA_PATH "/usr/local/apache2.2/conf/ssl.crt"
           CERT_NAME_ATTR "SSL_CLIENT_S_DN_CN"
           </Auth>

           </Jurisdiction>

       Assume the following access control rule applies to the request:

           <acl_rule status="enabled">
             <services>
               <service url_pattern='/foo.html'/>
             </services>

             <rule order="allow,deny">
               <allow>
                 user("auth")
               </allow>
             </rule>
           </acl_rule>



       The preceding configuration results in the following behaviour. An
       unauthenticated user accessing foo.html (https://example.com/foo.html)
       is denied access because the rule governing that web page tests for
       authentication and no credentials are sent with the request. As a
       result, the AACCSS__EERRRROORR__HHAANNDDLLEERR[6] directive causes the user to be
       redirected to ddaaccss__aauuttoollooggiinn__ssssll, which redirects the user to
       ddaaccss__aauutthheennttiiccaattee, passing arguments as necessary.

       ddaaccss__aauutthheennttiiccaattee then invokes llooccaall__cceerrtt__aauutthheennttiiccaattee[4], passing it
       the client's certificate. The certificate is validated and a username
       is extracted from it and mapped to a valid DDAACCSS username.

       If authentication succeeds, DDAACCSS credentials for the jurisdiction
       EXAMPLE are generated. These credentials are returned to the browser
       within a cookie and the browser is redirected to the value of
       _D_A_C_S___E_R_R_O_R___U_R_L (recall that _D_A_C_S___E_R_R_O_R___U_R_L was passed to
       ddaaccss__aauuttoollooggiinn__ssssll by ddaaccss__aaccss when the 990022 handler was invoked and was
       forwarded to ddaaccss__aauutthheennttiiccaattee). In this example the user is redirected
       to https://example.com/foo.html. Given the rule above, this time the
       user's request for foo.html will be granted.

       ddaaccss__aauuttoollooggiinn__ssssll may also be used as the target of an explicit
       authentication link. For example:

           <a href="https://example.com/cgi-bin/dacs/dacs_autologin_ssl?\
           AUTH_JURISDICTION=EXAMPLE&\
           DACS_ERROR_URL=https://example.com/cgi-bin/dacs/dacs_current_credentials">Login</a>

       Following the link should result in the user being authenticated and
       redirected to the specified URL.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[2], ddaaccss__aaccss((88))[5], ddaaccss..ccoonnff((55))[7],
       aauuttoollooggiinn((88))[8]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[9])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[10] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        3. OpenSSL
           http://www.openssl.org

        4. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_cert_authenticate

        5. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        6. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

        7. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        8. autologin(8)
           http://dacs.dss.ca/man/autologin.8.html

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012             DACS_AUTOLOGIN_SSL(8)
