DACS_AUTH_AGENT(8)         DACS Web Services Manual         DACS_AUTH_AGENT(8)



NNAAMMEE
       dacs_auth_agent - DDAACCSS delegated authentication service

SSYYNNOOPPSSIISS
       ddaaccss__aauutthh__aaggeenntt [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       The ddaaccss__aauutthh__aaggeenntt web service is used to request DDAACCSS credentials
       outside of the usual DDAACCSS authentication procedure (see
       ddaaccss__aauutthheennttiiccaattee((88))[2]). The client making the service request,
       whether a user agent or middleware, is considered to be an "agent"
       trusted by the jurisdiction that receives the request by virtue of
       having obtained DDAACCSS credentials and satisfying DDAACCSS access control
       rules that grant it access to this service. In other words, an agent
       simply requests credentials for a given identity from ddaaccss__aauutthh__aaggeenntt
       and they are returned if an access control rule grants access and
       ddaaccss__aauutthh__aaggeenntt is configured appropriately.

       The agent's DDAACCSS credentials can be obtained through
       ddaaccss__aauutthheennttiiccaattee((88))[2], ddaaccss__aauutthh__ttrraannssffeerr((88))[3], ddaaccssccrreedd((11))[4],
       ddaaccssccooookkiiee((11))[5], or even ddaaccss__aauutthh__aaggeenntt.

       If the request is successful, credentials are returned to the client
       within an HTTP cookie. Credentials generated by this service can be
       distinguished from those created by one of the other methods.

           SSeeccuurriittyy
           Access control rules are responsible for expressing restrictions on
           the types of operations to be granted to various trusted agents.
           Access to this web service must not be granted without establishing
           and testing carefully crafted access control rules and appropriate
           configuration. By default, all access to this service is denied.

       Much like Unix's ssuu((11))[6] command lets the superuser assume the Unix
       identity of any other user, this service provides a way for a
       privileged client to request credentials for a user known to the
       receiving jurisdiction. Any other credentials in the possession of the
       client remain in effect. Help desk personnel and system administrators
       can use this capability to assist users by temporarily impersonating a
       user without having to know the user's password, obtaining the user's
       client certificate, or following the user's usual authentication
       procedure.

       The service can also be invoked to effectively import an identity that
       is recognized by the agent but possibly not known to the receiving
       jurisdiction. This provides a way to convert foreign credentials,
       whether from a non-DDAACCSS based system or a different DDAACCSS federation,
       into credentials understood by the federation of the receiving
       jurisdiction. It is only necessary for the agent to understand the
       foreign credentials; DDAACCSS never sees them.

       Another use of this service is in conjunction with middleware that does
       its own authentication. Having authenticated a user, an application can
       ask ddaaccss__aauutthh__aaggeenntt for DDAACCSS credentials for the user.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[7], ddaaccss__aauutthh__aaggeenntt
       understands the following CGI arguments:

       _U_S_E_R_N_A_M_E
           If present, the agent asserts that _U_S_E_R_N_A_M_E is in some sense known
           to this jurisdiction.

       _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N
           If present, the agent asserts that _A_L_I_E_N___U_S_E_R_N_A_M_E, which must be
           provided, is associated with the named external system. This can be
           any string comprised of characters allowed in a DDAACCSS username;
           presumably the agent and DDAACCSS jurisdiction have agreed on the name
           to use. This name, or a string mapped from it, will be incorporated
           into the resulting DDAACCSS username and credentials.

       _A_L_I_E_N___U_S_E_R_N_A_M_E
           If present, the _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N argument must also be given. The
           agent asserts that the given name, relative to _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N,
           has been authenticated. This can be any string comprised of
           characters allowed in a DDAACCSS username. This name, or a string
           mapped from it, will be incorporated into the resulting DDAACCSS
           username and credentials.

       _D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N
           This identifies the receiving jurisdiction.

       _D_A_C_S___B_R_O_W_S_E_R
           This optional parameter is as described for the
           ddaaccss__aauutthheennttiiccaattee((88))[2] service.

       _O_P_E_R_A_T_I_O_N
           This optional parameter is as described for the
           ddaaccss__aauutthheennttiiccaattee((88))[2] service.

       _C_O_O_K_I_E___S_Y_N_T_A_X
           This optional parameter is as described for the
           ddaaccss__aauutthheennttiiccaattee((88))[2] service.

   OOppeerraattiioonn
       There are two modes of operation. In local mode, the _U_S_E_R_N_A_M_E argument
       is provided and is purported to be the DDAACCSS username of a user known to
       the receiving jurisdiction.

       The second mode, called alien mode, is selected if both an
       _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N argument and an _A_L_I_E_N___U_S_E_R_N_A_M_E argument are present.
       It is an error if only one of these arguments is given, and the
       _U_S_E_R_N_A_M_E is ignored. The mode checks that the _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N and the
       _A_L_I_E_N___U_S_E_R_N_A_M_E relative to it are satisfactory. This is done by
       requiring the _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N to be recognized by the receiving
       jurisdiction; it may optionally be mapped to a different string.
       Similarly, the _A_L_I_E_N___U_S_E_R_N_A_M_E argument must be recognized, relative to
       _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N or the string mapped from it.

       Credentials that have been designated as an AADDMMIINN__IIDDEENNTTIITTYY[8] will be
       returned only if the AAUUTTHH__AAGGEENNTT__AALLLLOOWW__AADDMMIINN__IIDDEENNTTIITTYY[9] configuration
       directive has the value "yes". Refer to ddaaccss..ccoonnff((55))[10] for a
       description of these configuration directives.

       A revocation test is always performed on the DDAACCSS identity; see
       ddaaccss..aaccllss((55))[11] for a description of how authentication revocation
       works.

       LLooccaall MMooddee
           If the _U_S_E_R_N_A_M_E argument is provided, it must consist of printable
           characters, as determined by iisspprriinntt((33))[12].

           By default, ddaaccss__aauutthh__aaggeenntt will blindly accept the trusted
           client's assertion that _U_S_E_R_N_A_M_E is known to the receiving
           jurisdiction. An administrator can constrain _U_S_E_R_N_A_M_E, however, and
           optionally map it into a replacement that is a valid DDAACCSS username.

           If the virtual filestore item type "auth_agent_local" is
           configured, it is expected to name a file consisting of
           expressions, one per line (a continued line ends with a backslash).
           Each expression is evaluated in turn until one returns a non-empty
           string value; this value, which must be a syntactically correct
           DDAACCSS username, becomes the mapped username. An evaluation error is
           fatal. The value of the _U_S_E_R_N_A_M_E argument is available to each
           expression as _$_{_E_x_p_r_:_:___} (reminiscent of Perl's _$__ variable).

           For example, consider the configuration directive:

               VFS "[auth_agent_local]dacs-fs:/usr/local/dacs/auth_agent_local_users"

           and the file /usr/local/dacs/auth_agent_local_users, which
           contains:

               regsub(${Expr::_}, "^auggie doggie$", "auggie")
               regsub(${Expr::_}, "^julia$", "sara")
               strtr(regsub(${Expr::_}, \
                   "\([^:]*\)://\([^.]*\)\\.\(.*\)", '${1}-${2}@${3}'), \
                     "A-Z", "a-z")

           If _U_S_E_R_N_A_M_E is "auggie doggie", credentials will be issued for
           "auggie". If _U_S_E_R_N_A_M_E is "julia", credentials will be issued for
           "sara". If _U_S_E_R_N_A_M_E is "https://Bob.Example.com", the third
           expression will return the string "https-bob@example.com", which
           will become the mapped name (this example is apropos of mapping
           OOppeennIIDD[13] names).

           When configured, roles are obtained for _U_S_E_R_N_A_M_E in the same way as
           is done for ddaaccss__aauutthheennttiiccaattee((88))[2].

       AAlliieenn MMooddee
           The alien mode of operation proceeds as follows:

            1. It looks up _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N using item type
               auth_agent_federations. When forming a key, the lookup
               operation will percent-encode any ':' and '%' characters in
               _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N, so the same encoding is required for keys
               that appear in auth_agent_federations. If it is not found,
               authentication fails. If found, it may optionally have a value;
               that value will be used within the resulting DDAACCSS credentials
               instead of the _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N argument. In any case, the
               resulting value must be valid for a DDAACCSS username.

            2. It looks up _A_L_I_E_N___U_S_E_R_N_A_M_E using an item type constructed by
               prepending the string "auth_agent_federation_" to the
               federation name derived during the previous step. When forming
               a key, the lookup operation will percent-encode any ':' and '%'
               characters in _A_L_I_E_N___U_S_E_R_N_A_M_E, so the same encoding is required
               for stored keys. If it is not found, authentication fails. If
               found, it may optionally have a value; that value will be used
               within the resulting DDAACCSS credentials instead of the
               _A_L_I_E_N___U_S_E_R_N_A_M_E argument. In any case, the resulting string must
               be valid for a DDAACCSS username.

            3. A DDAACCSS username will be formed using the federation name and
               username strings derived in the previous steps.


EEXXAAMMPPLLEESS
       The following is an example of local mode operation. Assume the
       following configuration directive is in effect:

           VFS "[auth_agent_local]dacs-fs:/usr/local/dacs/auth_agent_local_users"

       Also assume that the file /usr/local/dacs/auth_agent_local_users
       contains the expression:

           regsub(${Expr::_}, \
               "\([^:]*\)://\([^.]*\)\\.\(.*\)", '${1}-${2}@${3}')

       If a request is made with _U_S_E_R_N_A_M_E equal to "http://Bob.Example.com",
       new credentials will be issued for "http-Bob@Example.com" relative to
       the current jurisdiction.

       The following is an example of alien mode operation. Assume the
       following configuration directives are in effect:

           VFS "[auth_agent_federations]dacs-kwv-fs:/usr/local/dacs/auth_agent_feds"
           VFS "[auth_agent_federation_mars]dacs-kwv-fs:/usr/local/dacs/auth_agent_fed_mars"

       Also assume that the file /usr/local/dacs/auth_agent_feds consists of
       the line

           MARS:

       and the file /usr/local/dacs/auth_agent_fed_mars consists of the line

           gazoo:

       If a request is made with _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N equal to "MARS" and
       _A_L_I_E_N___U_S_E_R_N_A_M_E equal to "gazoo", the request will satisfy alien mode's
       rules of operation with the strings "MARS" and "gazoo" being used to
       form the DDAACCSS username relative to the current jurisdiction
       (_D_A_C_S___J_U_R_I_S_D_I_C_T_I_O_N).

       If instead _A_L_I_E_N___F_E_D_E_R_A_T_I_O_N were "http://example.com" and the file
       /usr/local/dacs/auth_agent_feds looked like:

           http%3A//example.com:example

       then the string "example" would be used with "gazoo" to form the DDAACCSS
       username.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

NNOOTTEESS
       The word "alien" is used because it sounds cooler than "foreign" and is
       arguably easier to spell.

       A superficially similar feature called "affiliated DDAACCSS federations",
       which provides single sign-on across federation boundaries, is
       sometimes a more appropriate solution; see ddaaccss__aauutthh__ttrraannssffeerr((88))[3].

BBUUGGSS
       It should be possible for keys that are matched against _U_S_E_R_N_A_M_E to be
       regular expressions and for the corresponding replacement values to
       interpolate matched substrings.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[2], ddaaccss__aauutthh__ttrraannssffeerr((88))[3],
       ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[14], ddaaccss__ssiiggnnoouutt((88))[15],
       ddaaccss..eexxpprrss((55))[16], ddaaccssccrreedd((11))[4], ddaaccssccooookkiiee((11))[5].

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[17])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[18] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        3. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

        4. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

        5. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

        6. su(1)
           http://www.freebsd.org/cgi/man.cgi?query=su&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

        7. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        8. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

        9. AUTH_AGENT_ALLOW_ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_AGENT_ALLOW_ADMIN_IDENTITY

       10. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       11. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       12. isprint(3)
           http://www.freebsd.org/cgi/man.cgi?query=isprint&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       13. OpenID
           http://openid.net/

       14. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       15. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       16. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       17. www.dss.ca
           http://www.dss.ca

       18. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                DACS_AUTH_AGENT(8)
