DACS.VFS(5)                   DACS Formats Manual                  DACS.VFS(5)



NNAAMMEE
       dacs.vfs - the DDAACCSS virtual filestore

DDEESSCCRRIIPPTTIIOONN
       These files are part of the DDAACCSS suite.

       The virtual filestore provides flexible ways for DDAACCSS and software
       built on top of DDAACCSS to obtain information regardless of how or where
       the information is stored. The DDAACCSS core accesses (almost) all
       configuration information through the virtual filestore layer, allowing
       information to be more easily shared and maintained, secured, or
       organized for better performance.

       Sometimes it is easiest to store information in a regular file
       initially, where it can be modified using an ordinary text editor, but
       after some growth a database might improve performance. In some
       situations, accessing the information remotely, via HTTP, makes
       administration more convenient or is more secure. A goal of the virtual
       filestore is to make it simple to make configuration choices
       appropriate to a particular DDAACCSS environment, and to change them as
       required. Consult ddaaccssvvffss((11))[1] for additional information.

       For example, the account file used by ddaaccssppaasssswwdd((11))[2] and other
       components is accessed from within DDAACCSS through the name passwds (a
       string called an item type). The DDAACCSS configuration in effect
       determines how this is mapped to an object that contains the account
       information, how an individual account name is looked up, and where the
       object is located.

       Each virtual filestore instance maps to either an uninterpreted
       sequence of bytes (e.g., a Unix file or the output of a program) or an
       object that contains zero or more items, each of which is associated
       with a key (i.e., the name of an item relative in its virtual filestore
       context) and has an uninterpreted sequence of bytes as its value (e.g.,
       a database file, a Unix file containing lines having a particular
       keyword/value structure, or a directory containing regular files).

       The VVFFSS[3] directive is used to specify where and how information is
       stored. Some commands and functions take a VFS specification as an
       argument to provide a default or override a default.

       For maximum portability, a key should be composed of characters from
       the PPoorrttaabbllee FFiilleennaammee CChhaarraacctteerr SSeett[4]: any alphanumeric character,
       period, hyphen, or underscore. The true limitation on the character set
       depends on the underlying storage scheme and URI syntax constraints.
       There is no _a _p_r_i_o_r_i limit on naming context or key length.

SSEEEE AALLSSOO
       ddaaccssvvffss((11))[1], ddaaccss..ccoonnff((55))[5], ddaaccss..iinnssttaallll((77))[6], ddaaccss__vvffss((88))[7]

BBUUGGSS
AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[8])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[9] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

        2. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

        3. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        4. Portable Filename Character Set
           http://www.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap03.html#tag_03_276

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        7. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACS.VFS(5)
