DACS.README(7)          DACS Miscellaneous Information          DACS.README(7)



NNAAMMEE
       dacs.readme - DDAACCSS README

DDEESSCCRRIIPPTTIIOONN
       This file is part of the DDAACCSS suite.

       Other important documents in this release:

       +o   for a brief description of this release, and possibly last minute
           updates, please refer to RREEAADDMMEE[1]

       +o   for a technical overview of the system, please see ddaaccss((11))[2]

       +o   for information about licensing, please refer to LLIICCEENNSSEE[3]

       +o   for information about installation, please refer to
           ddaaccss..iinnssttaallll((77))[4]

       +o   for the Quick Start tutorial, please refer to ddaaccss..qquuiicckk((77))[5]

       +o   for important release notes, please visit
           hhttttpp::////ddaaccss..ddssss..ccaa//ddoowwnnllooaadd..hhttmmll


           NNOO WWAARRRRAANNTTYY
           This software is provided by Dss "as is" and any express or implied
           warranties, including, but not limited to, the implied warranties
           of merchantability, fitness for a particular purpose, or
           non-infringement, are disclaimed. in no event shall dss be liable
           for any direct, indirect, incidental, special, exemplary, or
           consequential damages (including, but not limited to, procurement
           of substitute goods or services; loss of use, data, or profits; or
           business interruption) however caused and on any theory of
           liability, whether in contract, strict liability, or tort
           (including negligence or otherwise) arising in any way out of the
           use of this software, even if advised of the possibility of such
           damage.

   DDAACCSS AAtt aa GGllaannccee
       DDAACCSS is:

       +o   a light-weight, open source single sign-on system;

       +o   a flexible and powerful role-based access control system;

       +o   a set of feature-rich authentication methods;

       +o   an AAppaacchhee[6] 2.0 and 2.2 module and suite of CGI programs;

       +o   able to apply coarse-grained access control to web service requests
           made using standard web browsers;

       +o   able to provide fine-grained access control functionality to almost
           any program or script;

       +o   a collection of web services that can provide access control and
           identity management functionality to your middleware;

       +o   a C/C++ toolkit for building new authentication and access control
           functionality into programs, whether web-based or not;

       +o   for Unix-type platforms (currently), such as GNU/Linux and FreeBSD.


       _F_o_r _d_e_v_e_l_o_p_e_r_s, DDAACCSS makes access control functionality available
       through the command line, allowing scripts (Perl, PHP, shell, etc.) to
       make data-driven access control decisions rather than program-driven
       ones. This can be used completely independently of the web
       functionality and without dealing with run-time configuration of DDAACCSS.
       Please see ddaaccsscchheecckk((11))[7].  DDAACCSS also provides web services from which
       single sign-on systems can be constructed.

       _F_o_r _w_e_b _s_i_t_e_s, DDAACCSS can help manage access to web resources in many
       situations, whether you have just one web server, several web servers
       at one site, or many web servers spread across the Internet. You may
       find it to be useful simply as a universal authentication mechanism for
       a single AAppaacchhee server or as a full-fledged, single sign-on
       multi-server identity management and access control system.

           TTiipp
           If you are interested in ddaaccsscchheecckk((11))[7] or the general-purpose
           DDAACCSS utilities (e.g., hhttttpp((11))[8], ssssllcclliieenntt((11))[9]) but are not
           interested in web services or AAppaacchhee, refer to the instructions in
           ddaaccss..iinnssttaallll((77))[4].

       The DACS home page is at hhttttpp::////ddaaccss..ddssss..ccaa.  DDAACCSS is hosted as a
       SSoouurrcceeFFoorrggee[10] project at hhttttpp::////ssoouurrcceeffoorrggee..nneett//pprroojjeeccttss//ddaaccss.

   SSuuppppoorrtteedd PPllaattffoorrmmss
       DDAACCSS is currently developed and tested:

       +o   with AAppaacchhee[6] 2.0.64 and 2.2.21

       +o   on platforms:

           +o    FFrreeeeBBSSDD[11] 8.1/7.2/7.0 (amd64)

           +o    CCeennttOOSS[12] 5.7 (x86_64, Linux 2.6.X, built from RReedd HHaatt
               EEnntteerrpprriissee LLiinnuuxx[13] 5)

           +o    MMaacc OOSS XX[14] 10.7.2 (Lion, Intel Core i7, x86_64)

           +o   using GGCCCC 4.2 compilers

           +o   using FFiirreeffooxx 8.x and 9.x browsers, and IInntteerrnneett EExxpplloorreerr 8
               browsers


       FreeBSD 7.2 is the primary development platform. For this reason,
       references to Unix manual pages throughout the DDAACCSS documentation cite
       the FreeBSD documentation. This should not matter much if you are using
       a different platform, but keep this in mind.

       Most DDAACCSS installations are on Linux or FreeBSD platforms. Support for
       Mac OS X is relatively recent.

           NNoottee
           +o   When building DDAACCSS for use with AAppaacchhee 2.2, you will probably
               need to specify the ----wwiitthh--aappaacchhee--aapprr flag, and perhaps other
               AAppaacchhee-related flags, to ccoonnffiigguurree.

           +o   AAppaacchhee 1.3 is _n_o_t supported (please refer to the FFAAQQ[15]).

           +o   DDAACCSS has not been tested with AAppaacchhee 2.1.

   OOtthheerr PPllaattffoorrmmss
       DDAACCSS _i_s _n_o_t _o_f_f_i_c_i_a_l_l_y _s_u_p_p_o_r_t_e_d _o_n _p_l_a_t_f_o_r_m_s _o_t_h_e_r _t_h_a_n _t_h_o_s_e
       _m_e_n_t_i_o_n_e_d _a_b_o_v_e. Recent releases have built and worked correctly on
       other platforms, but because we do not have ready access to them, or
       due to lack of interest, we no longer test on them.

       Up to and including version 1.4.25, DDAACCSS was tested and used on SSoollaarriiss
       1100[16] (OOppeennSSoollaarriiss[17] 2008.11, SunOS 5.11, xx8866[18]).  Solaris is no
       longer supported. Early versions of DDAACCSS were used on Solaris 8 (SPARC)
       and Solaris 10 (SPARC) platforms. A wide variety of build, install, and
       run-time problems were encountered with third-party packages on the
       OpenSolaris and SPARC platforms. Depending on which third-party
       software your DDAACCSS configuration requires, or if you are prepared to
       try older versions of third-party software or devote extra effort, you
       may have some success running DDAACCSS on these platforms, but in general
       we cannot recommend using these platforms for DDAACCSS in production
       settings and they are no longer officially supported. Comments specific
       to Solaris remain in the DDAACCSS documentation but will likely be removed
       in a future release, as will configuration and build capabilities.

       Earlier releases of DDAACCSS compiled and (mostly) installed cleanly on
       WinXP/CCyyggwwiinn[19] 1.7.5 and later with GGCCCC 4.3, but starting with DDAACCSS
       1.4.26, CCyyggwwiinn[19] is no longer used for testing DDAACCSS. Comments
       specific to Cygwin that remain in the DDAACCSS documentation will likely be
       removed in a future release, as will configuration and build
       capabilities. Regarding Cygwin and earlier versions of DDAACCSS:

       +o    mmoodd__aauutthh__ddaaccss does not build as a shared module

       +o   there were problems building EExxppaatt 2.0.0 from source (2.0.1 is ok)

       +o   only limited testing has been performed on this platform

       +o   you can't execute src/config.nice; copy it to some other filename
           and execute that instead

       +o   when doing "make install", try the username and group
           "Administrators" or "Administrator" when prompted if you don't know
           what else to use (the install procedure should use those names as
           defaults


       We expect that DDAACCSS will also run on other varieties of Unix and with
       other browsers. No testing is done with very old browsers, however. We
       would appreciate reports of problems encountered while building or
       running DDAACCSS on unofficial platforms so that we can address portability
       issues and support these platforms better.

   WWaarrnniinnggss
       _P_l_e_a_s_e _r_e_a_d _t_h_i_s _s_e_c_t_i_o_n _c_a_r_e_f_u_l_l_y!

           SSeeccuurriittyy
            1. After obtaining a DDAACCSS release, please verify _a_l_l checksums for
               the file you downloaded. Do not use a download if any checksum
               for it does not match. Checksums are posted at
               hhttttpp::////ddaaccss..ddssss..ccaa//ddoowwnnllooaadd..hhttmmll immediately after a new
               release is distributed.

               OOppeennSSSSLL''ss ddggsstt command can be used to compute checksums; for
               example,

                   % openssl dgst -md5 dacs-1.4.22.tgz
                   % openssl dgst -sha1 dacs-1.4.22.tgz


            2. Improper installation, configuration, or use of DDAACCSS may leave
               your system open to various kinds of attacks and exploits.

               Many other systems and software components, including AAppaacchhee
               and OOppeennSSSSLL, can also compromise system security if not
               properly installed, configured, and administered; they give
               similar admonishments. Please take appropriate care.

               A DDAACCSS administrator ought to have some experience with AAppaacchhee
               configuration (including its authentication and access control
               directives, and building hhttttppdd), and basic knowledge of
               security issues on the installation platform.

            3. The security of DDAACCSS depends on the security of the underlying
               operating system, third party software, build, installation,
               and configuration parameters, human factors, and more. In
               particular, ensure that file ownership and modes are
               appropriate for run-time accessible DDAACCSS configuration and data
               files (dacs.conf, site.conf, encryption keys, access control
               rules, group files, etc.).

            4. Users of your DDAACCSS-wrapped services are responsible for
               maintaining the secrecy of information used to sign on (such as
               passwords) and authentication and authorization information
               sent to them by DDAACCSS (such as HTTP cookies). Spyware, and
               browser modifications or improper settings, may compromise
               security - DDAACCSS cannot prevent improper use or intentional
               misuse.

            5. After access is granted to a resource, DDAACCSS does nothing to
               stop a user from redistributing whatever is returned by the web
               server. Therefore, strictly speaking, DDAACCSS is neither a
               copyright enforcement system nor is it a Digital Rights
               Management (DRM) system, although it may be possible to apply
               DDAACCSS in those domains.  DDAACCSS does have the ability to force a
               user to view and acknowledge a copyright notice or license,
               however.

            6. Making routine backup copies of your current DDAACCSS configuration
               and data files is _s_t_r_o_n_g_l_y _e_n_c_o_u_r_a_g_e_d. A procedure should be
               established for periodically creating copies of your DDAACCSS
               installation and keeping them in a secure, off-site location.
               This is especially important for encryption keys and account
               files, which cannot be recreated if lost.

            7. Please review Section 15 ("Security Considerations") of RRFFCC
               22661166[20].

            8. Be sure to check for new releases of DDAACCSS regularly. New
               releases may address important bugs and security issues, so
               keeping your installation current is important. You can
               ssuubbssccrriibbee ttoo eemmaaiill nnoottiiffiiccaattiioonnss[21].

               You should likewise stay alert to new releases of third-party
               packages that your install of DDAACCSS uses.

            9. Test carefully after making changes to your DDAACCSS configuration.
               In particular, make sure that new access control rules and user
               authentication work as you expect.

           10. _F_o_r DDAACCSS _t_o _b_e _a _s_e_c_u_r_e _s_y_s_t_e_m_, _a_l_l _c_o_m_m_u_n_i_c_a_t_i_o_n _b_e_t_w_e_e_n DDAACCSS
               _a_n_d _i_t_s _u_s_e_r_s_, _c_o_m_p_o_n_e_n_t_s_, _a_n_d _m_i_d_d_l_e_w_a_r_e _m_u_s_t _t_a_k_e _p_l_a_c_e _o_v_e_r
               _a _s_e_c_u_r_e _c_o_n_n_e_c_t_i_o_n _(_t_y_p_i_c_a_l_l_y _u_s_i_n_g _S_S_L _a_n_d _t_h_e HHTTTTPPSS[22]
               _m_e_t_h_o_d_) _t_o _s_a_f_e_g_u_a_r_d _a_c_c_o_u_n_t _n_a_m_e_s_, _p_a_s_s_w_o_r_d_s_, DDAACCSS
               _c_r_e_d_e_n_t_i_a_l_s_, _a_n_d _s_o _o_n.  DDAACCSS does not _r_e_q_u_i_r_e secure network
               connections, however, and can function without them in
               situations where a lower standard of security is acceptable.
               See SSEECCUURREE__MMOODDEE[23].

               Note that if a client connects from an insecure subnet, various
               mmaann--iinn--tthhee--mmiiddddllee aattttaacckkss[24] are possible, even when it
               appears that SSL is being used (for example, see ssssllssttrriipp[25]).

           11. In the event of an emergency situation that might be related to
               DDAACCSS, you may, of course, stop all AAppaacchhee processes. It is
               sufficient to make dacs.conf inaccessible to AAppaacchhee, however,
               whether by renaming the file, changing its ownership, or
               changing its permissions. (Or, you may make the DDAACCSS web
               services unavailable using the same methods.) All DDAACCSS web
               services must be able to read dacs.conf, so this will
               effectively turn DDAACCSS off. More selective ways of limiting
               access are available, such as through the revocation list.

           12. DDAACCSS depends mainly on OOppeennSSSSLL[26], a third-party package that
               you need to obtain separately, for cryptographic functionality.
               Some library functions provided by your operating system (such
               as ccrryypptt((33))[27]) are also used.

           13. It is recommended that the Network Time Protocol (RRFFCC 11330055[28])
               or equivalent be used on any host that runs DDAACCSS commands or
               web services. A sudden, large change to a system's clock while
               DDAACCSS is operational may have undesirable effects and should be
               avoided.

           14. If you are deploying DDAACCSS as part of a publicly accessible web
               site, consider including a notification on your site that it
               may issue cookies. This is commonly mentioned in a site's
               "Privacy" or "Security" page.  DDAACCSS may not function as
               expected if a user's browser has disabled cookies or will not
               accept them; in particular, the single sign-on feature
               generally requires that users' browsers accept cookies.


           IImmppoorrttaanntt
           DDAACCSS MAY INCLUDE ITS OWN CRYPTOGRAPHIC FUNCTIONS and may therefore
           fall under certain import, export, and/or use restrictions in other
           parts of the world, even though DDAACCSS is created, maintained, and
           officially distributed from Canada.

           Export and/or import and/or use of strong cryptography software,
           providing cryptography hooks, or merely communicating technical
           details about cryptographic software is illegal in some parts of
           the world. YOU ARE STRONGLY ADVISED to pay close attention to any
           laws that may apply when you import, export, or use DDAACCSS, or even
           communicate about it. We are not liable for any violations you make
           - it is your responsibility. For additional information, see the
           CCrryyppttoo LLaaww SSuurrvveeyy[29].

   RRooaaddmmaapp
       DDAACCSS 1.4 is being released in stages. Our goal is to release new
       versions on a regular schedule, approximately every two months. Much of
       the DDAACCSS 1.4 functionality has already been designed and implemented;
       we merely need time to thoroughly test and document. A top priority is
       to fix all known bugs between releases and improve the documentation.

       Beyond DDAACCSS 1.4, we have many ideas for improving DDAACCSS, including
       adding new features and making it easier to administer.

       Please consult the DDAACCSS wweebb ssiittee for information on upcoming releases.

   UUppggrraaddiinngg
           SSeeccuurriittyy
           Because DDAACCSS is security software, we strongly recommend that you
           upgrade to the newest release as soon as you are able.

       Upgrading is neither a difficult nor a time consuming procedure most
       times. Sometimes an incompatible change in DDAACCSS will require you to
       change a DDAACCSS configuration file, but this should not be difficult to
       do and we will try to advise you of such changes.

       The DDAACCSS 1.4 releases contain a great many changes and improvements,
       some incompatible with earlier releases of DDAACCSS. If you are upgrading
       from DDAACCSS 1.3.2 or another older release, you will need to become
       familiar with these changes. You must manually convert your old DDAACCSS
       configuration files to the new format, for example. You should not find
       upgrading to be a difficult or time consuming task.

           IImmppoorrttaanntt
           Making backup copies of your DDAACCSS installation immediately prior to
           upgrading is strongly recommended.

       Some features available in earlier versions of DDAACCSS are not available
       in this release, but will be provided as soon as possible.

       Note that DDAACCSS 1.4 may not interoperate with prior releases.

       We aim to avoid making any backward incompatible changes within the
       DDAACCSS 1.4.x releases.

   AAddmmiinniissttrraattiioonn
       Once installed and configured, DDAACCSS requires very little
       administration.

           TTiipp
           At higher logging levels, DDAACCSS log files can become large quite
           quickly. You should therefore arrange for them to be rotated
           regularly (e.g., using nneewwssyysslloogg((88))[30]). A built-in log rotation
           feature is being considered for DDAACCSS.

       If you're creating DDAACCSS log files that have names based on their date
       of creation, to expire/rotate/compress them you might periodically run
       the ffiinndd((11))[31] command to identify old logs. For example, the command

           % find /usr/local/dacs/logs -type f -a -mtime 2 -a -exec gzip {} \;

       will compress any files in the log directory that haven't been modified
       for at least 24 hours.

       There are also AAppaacchhee modules available to do the rotation:

       +o    hhttttpp::////hhttttppdd..aappaacchhee..oorrgg//mmoodduulleess

       +o    hhttttpp::////mmoodduulleess..aappaacchhee..oorrgg


   RReellaatteedd SSooffttwwaarree
       A variety of other software and resources for DDAACCSS can be found in the
       ddaaccss--ccoonnttrriibb[32] project at SSoouurrcceeFFoorrggee[10].

       TThhee DDAACCSS JJaavvaa LLiibbrraarryy ((DDJJLL))
           The DDJJLL is being developed to support the use of DDAACCSS in Java
           client applications. It implements Java wrapper classes for
           selected DDAACCSS services, and provides an HTTP client through which
           DDAACCSS services may be accessed and DDAACCSS credentials obtained and
           managed.

       TThhee FFeeddAAddmmiinn WWeebb AApppplliiccaattiioonn
           FFeeddAAddmmiinn is an administrator console for managing the configuration
           of DDAACCSS federations and jurisdictions. It is deployed in a servlet
           container such as Tomcat, but must be accessed via an Apache+DDAACCSS
           proxy and deployed under a dedicated FEDADMIN DDAACCSS application
           jurisdiction.

           FFeeddAAddmmiinn implements partial coverage of the most common DDAACCSS
           configuration tasks, including viewing federation and jurisdiction
           configuration directives, adding and deleting local DDAACCSS users, and
           creating, editing, and deleting ACL rules.

   SSuuppppoorrtt
       An array of technical support is available from DDSSSS[33]. Please see the
       ssuuppppoorrtt ppaaggee[34] for details.

   KKnnoowwnn PPrroobblleemmss
       There are a few defects in the DDAACCSS 1.4 releases that administrators
       should be aware of. These are not likely to be addressed in the near
       future.

        1. If the HTTP data stream is compressed or encrypted (other than via
           SSL), DDAACCSS will not be able to access POST arguments and you should
           use the mmoodd__aauutthh__ddaaccss module directive "SetDACSAuthPostBuffer 0".

        2. In general, DDAACCSS does not support IPv6 addresses.

        3. The group management service and group distribution utilities have
           not be tested with this release of DDAACCSS.

        4. The man pages are generated from DocBook XML. The docbook-xsl used
           to create [nt]roff source is incomplete and/or buggy. As a result,
           the quality of the formatting is sometimes poor. You will find the
           HTML version of the documentation more readable.

        5. Support for internationalization is poor.

        6. Some configuration directives have global scope (i.e., they apply
           in several contexts) when it might be preferable to have
           context-specific versions of them. For example, the algorithm
           specified by PPAASSSSWWOORRDD__DDIIGGEESSTT[35] is used for more than one purpose
           within DDAACCSS. On the other hand, this reduces the number of
           directives, and therefore helps to contain the complexity of DDAACCSS.

   BBuuggss,, SSuuggggeessttiioonnss,, aanndd FFeeeeddbbaacckk
       Please see the ssuuppppoorrtt ppaaggee[34] for details.

       Some elements of DDAACCSS are less well-travelled than others and users may
       therefore experience problems with them. Please lleett uuss kknnooww[36] if you
       encounter bugs.

SSEEEE AALLSSOO
       ddaaccss((11))[2], ddaaccss..iinnssttaallll((77))[4], ddaaccss..qquuiicckk((77))[5]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[33])

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[3] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. README
           http://dacs.dss.ca/man/../misc/README

        2. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        3. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE

        4. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        5. dacs.quick(7)
           http://dacs.dss.ca/man/dacs.quick.7.html

        6. Apache
           http://httpd.apache.org

        7. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        8. http(1)
           http://dacs.dss.ca/man/http.1.html

        9. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       10. SourceForge
           http://www.sourceforge.net

       11. FreeBSD
           http://www.freebsd.org

       12. CentOS
           http://www.centos.org

       13. Red Hat Enterprise Linux
           http://www.redhat.com/rhel

       14. Mac OS X
           http://www.apple.com/macosx

       15. FAQ
           http://dacs.dss.ca/faq.html

       16. Solaris 10
           http://www.sun.com/software/solaris/10/index.jsp

       17. OpenSolaris
           http://www.opensolaris.com

       18. x86
           http://www.solaris-x86.org/

       19. Cygwin
           http://cygwin.com/

       20. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

       21. subscribe to email notifications
           http://freshmeat.net/projects/dacs/

       22. HTTPS
           http://www.rfc-editor.org/rfc/rfc2818.txt

       23. SECURE_MODE
           http://dacs.dss.ca/man/dacs.conf.5.html#SECURE_MODE

       24. man-in-the-middle attacks
           http://en.wikipedia.org/wiki/Man-in-the-middle_attack

       25. sslstrip
           http://www.thoughtcrime.org/software/sslstrip

       26. OpenSSL
           http://www.openssl.org

       27. crypt(3)
           http://www.freebsd.org/cgi/man.cgi?query=crypt&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       28. RFC 1305
           http://www.rfc-editor.org/rfc/rfc1305.txt

       29. Crypto Law Survey
           http://rechten.uvt.nl/koops/cryptolaw

       30. newsyslog(8)
           http://www.freebsd.org/cgi/man.cgi?query=newsyslog&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       31. find(1)
           http://www.freebsd.org/cgi/man.cgi?query=find&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       32. dacs-contrib
           http://sourceforge.net/projects/dacs-contrib

       33. DSS
           http://www.dss.ca

       34. support page
           http://dacs.dss.ca/support.html

       35. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       36. let us know
           http://www.dss.ca/contactus.html



DACS 1.4.27                       01/16/2012                    DACS.README(7)
