DACS.EXPRS(5)                 DACS Formats Manual                DACS.EXPRS(5)



NNAAMMEE
       dacs.exprs - DDAACCSS expression language

DDEESSCCRRIIPPTTIIOONN
       These files are part of the DDAACCSS suite.

       DDPPLL (the DDAACCSS programming language) is used in access control rules,
       its revocation list, and in configuration files. This programmability
       gives DDAACCSS maximum run-time configurability and flexibility. A DDPPLL
       expression - or even a small program - may appear within predicate,
       allow, and deny elements of an access control rule, for example.  DDPPLL
       is also accessible using the ddaaccsseexxpprr((11))[1] command, which can be used
       for writing scripts even for non-DDAACCSS applications.

       DDPPLL, which is gradually evolving in mostly backward-compatible ways, is
       similar in many ways to PPeerrll[2], PPHHPP[3], TTccll[4] and its expressions
       look and behave much like C/C++ expressions. The calling signatures for
       functions are reminiscent of those of TTccll, with literal or string
       arguments used to select a particular mode of operation or specify
       options. The syntaxes used for strings and variables have been
       influenced by various Unix shells. Our intent is for the language to
       feel familiar and be easy to use for the typical tasks at hand. We have
       tried not to be gratuitously different.

           NNoottee
           The philosophy guiding the design of the DDAACCSS expression language
           is that its power should be limited to basic operations on
           elementary data types that can be expressed simply and evaluated
           efficiently, along with a collection of utility and higher-level
           functions, targeted for the tasks at hand, that hide complexity.
           This is why the language does not include much in the way of
           control flow statements - our feeling is that complicated
           expressions are more likely to introduce mistakes, which can easily
           result in access control rules not working as intended.

           While fleshing out the language is not a priority, expression
           syntax and the set of functions are being extended as necessary. An
           extensibility mechanism is planned that would let user-defined
           functions be loaded at run-time.

           While there are no immediate plans to do so, replacing the DDAACCSS
           expression language with a general-purpose extension language may
           eventually make sense.  TTccll and PPeerrll would be leading contenders.

           TTiipp
           The ddaaccsseexxpprr((11))[1] utility can be useful for learning, testing, and
           debugging DDPPLL.

   EExxpprreessssiioonn SSyynnttaaxx
       Expression evaluation consists of a lexical analysis stage, in which
       the expression is broken into a sequence of tokens, followed by
       evaluation of the tokens.

       Expression syntax is checked before an expression is evaluated. Any
       syntactic or run-time evaluation error immediately terminates
       evaluation of the top-level expression and returns a FFaallssee result.

           NNoottee
           Because files containing expressions are local to the DDAACCSS site on
           which they appear (i.e., DDAACCSS does not copy them), they need not be
           portable across sites. This means that any DDAACCSS jurisdiction is
           free to customize or extend these expressions at will since they do
           not have to be understood or executed by any other jurisdiction.

       CCoommmmeennttss
           Three comment styles are recognized:

           +o   The /* ... */ C style comment syntax, which does not nest;

           +o   The // syntax of C++, where the remainder of the line following
               the token is ignored; and

           +o   The # syntax of shells and many scripting languages, provided
               the # is either at the beginning of a line or appears after
               whitespace, where the remainder of the line following the token
               is ignored. Note that escaping the # by preceding it with a
               backslash prevents the text that follows from being interpreted
               as a comment. For example, this will result in a syntax error
               if the backslash is omitted:

                   > ${foo:? \#xxx}
                   " #xxx"



       Here are examples of all three styles:

           /*
            * This is a comment
            */

           // This is another comment

           ${x} = 17;  # And one last comment

       Additionally, when expressions are parsed in the context of an XML
       document (such as in an access control rule), the XML comment syntax
       can be used (<!-- A comment -->). Such comments can span multiple
       lines.

           <!--
           Comment out this clause for now...
           <Auth id="authx">
           STYLE "expr"
           CONTROL "sufficient"
           </Auth>
           -->


   BBaassiicc DDaattaa TTyyppeess
       The following basic data types are supported:

       integer
       int
           , Integers are represented internally as a C/C++ lloonngg iinntt. Maximum
           and minimum values are platform dependent. Integers are written in
           the C-style syntax; for example, -1958, 0377 (octal), and 0xABC
           (hexadecimal, upper or lower case).

       real
       double
           , Reals are represented internally as a C/C++ ddoouubbllee. Maximum and
           minimum values are platform dependent. A real constant is an
           optional sequence of decimal digits (possibly signed) followed by a
           period and 1) at least one digit or 2) an 'e' or 'E' followed by at
           least one digit.

       string
           A string is a sequence of characters enclosed between matching
           single or double quotes (e.g., 'Hello world'). Interpolation of
           variables occurs within double quotes but not single quotes.
           C-style character escape codes and octal numeric escape codes are
           understood (e.g., "\t", "\010") and either quote character (e.g.,
           'It\'s here') and the backslash character (e.g., "\\") can be
           quoted. An unrecognized quoted character is mapped to that
           character (e.g., "\x" is "x"). Character strings are limited in
           length by available memory and are represented internally as a
           null-terminated vector.

               NNoottee
               +o   Because a string is null-terminated, it cannot contain a
                   NUL character. Also, functions that deal with strings
                   usually do not expect (most) ASCII control characters to
                   appear in a string. Therefore a string that contains an
                   unprintable character (a character that is not a tab,
                   newline, carriage return, and that does not satisfy
                   iisspprriinntt((33))[5]) automatically becomes a bstring (see below).

               +o   Because DDAACCSS configuration files are XML documents,
                   characters special to XML must be properly escaped within
                   them. In particular, an ampersand character must always be
                   written as &amp; and a < character must be written as &lt;.
                   For example, the query string a=1&b=2 might be used as

                       ${Foo::QUERY_STRING} = "a=1&amp;b=2"

               Variable references may occur within a (double-quoted) string;
               the value of the variable reference is interpolated at that
               point. If _$_{_F_o_o_:_:_b_a_r_} is "hello", then the value of
               "${Foo::bar}, world" is "hello, world".


                   NNoottee
                   The first expression is invalid and must be written as the
                   second:

                       foo"baz"
                       foo."baz"

           binary
           bstring
               , A binary string is a sequence of bytes, limited in length by
               available memory. Most language operators cannot be applied to
               data of this type without converting it to another type (e.g.,
               two bstring values cannot be added using the + operator). A
               binary string is not necessarily portable across systems.

                   > "\0\1\2"
                   "000102"


           bareword
               This type is a "literal word" much like Perl's _b_a_r_e_w_o_r_d_s. A
               bareword consists of an initial alphabetic character, followed
               by any number of alphanumerics and underscores. The resulting
               lexical token must have no other interpretation in the language
               and is treated as if it were a quoted string. This syntactic
               convenience makes these two function calls equivalent:

                   file(test, "-e", foo)
                   file("test", "-e", "foo")

               These two expressions are equivalent and yield "foobaz":


                   foo."baz"
                   foo.baz


           bool
               The boolean values TTrruuee and FFaallssee are either the result of
               evaluating certain expressions or are implicit argument values.
               This is really a pseudo-type because it is represented
               internally as an integer. In the former case, the integer 11 is
               the canonical "true" value and 00 is considered "false". In the
               latter case, there are several possibilities. If the argument
               is an integer or real, any non-zero value is considered TTrruuee
               and 00 is considered FFaallssee. For the string data type, both the
               empty string (i.e., "") and the string "0" are considered FFaallssee
               and anything else is considered TTrruuee. A binary string is
               equivalent to FFaallssee if and only if its length is zero. An empty
               list of either variety ("[]" or "{}") is FFaallssee, while any
               non-empty list or alist is TTrruuee.

           Automatic type conversion is performed when necessary and possible.
           In general, a "lower" type is promoted to a "higher" type (e.g., an
           integer is converted to a real when it is added to a real) and the
           result is of the higher type. Arguments to function calls are
           automatically coerced to the required types. A printable binary
           string (one not containing any "troublesome" control characters)
           can be converted into a string without loss; other binary strings
           are converted into a hexadecimal string representation for
           assignment or display.

           The C/C++ unary cast operation is available for explicit type
           conversion. Not all conversions are supported (e.g., integer to
           binary and binary to string). These type names are case sensitive.

           The language includes the concept of the void type, which cannot be
           stored in a variable, used as an operand, or printed. Some
           functions are void, pprriinntt(())[6] for example. A value can be ccaasstt[7]
           to void.

               NNoottee
               Support for binary data is only partially implemented.

   VVaarriiaabblleess aanndd NNaammeessppaacceess
       Every variable exists within a namespace. Namespaces exist so that the
       same variable name can exist safely and without ambiguity in different
       contexts. They also serve to group together and name a set of closely
       related variables, and they make it easy for all variables in the set
       to be assigned a characteristic (such as being read-only). For example,
       CGI parameter values are automatically put in the _A_r_g_s namespace and
       variables automatically created by DDAACCSS are put in the _D_A_C_S namespace.
       Namespaces address the problem of a parameter name that happens to have
       the same name as a variable created by DDAACCSS, for example. They also
       allow intermediate results to be stored in their own namespace, also
       avoiding the problem of clashing variable names.

       Variables are not declared in advance. The value of an uninitialized
       variable is the empty string, which is invalid in a numerical context,
       but variables should always be initialized before being used. Some
       variables are created automatically by DDAACCSS from the execution context
       (e.g., the value of a CGI parameter value, the identity of the client,
       an environment variable), as a side-effect of function evaluation, or
       by an assignment operator.

       The interpreter tries to maintain the natural type of a variable when
       possible, to avoid conversions to and from the string type.

       VVaarriiaabbllee SSyynnttaaxx
           A variable reference may have either of the following syntaxes:

               ${[_n_a_m_e_s_p_a_c_e::]_v_a_r_i_a_b_l_e_-_n_a_m_e[:_f_l_a_g_s]}
               $[_n_a_m_e_s_p_a_c_e::]_v_a_r_i_a_b_l_e_-_n_a_m_e

           For instance, the following refers to the value of a variable
           called _J_U_R_I_S_D_I_C_T_I_O_N___N_A_M_E within the namespace called _C_o_n_f:

               ${Conf::JURISDICTION_NAME}

           A variable called _J_U_R_I_S_D_I_C_T_I_O_N___N_A_M_E within a different namespace
           could exist and would be completely distinct.

           A namespace must begin with an alphabetic character and can be
           followed by any number of alphabetics, digits, dashes, and
           underscores. By convention, predefined namespaces begin with an
           upper case letter.

           If the namespace is omitted from a variable reference, a default
           namespace is implied (see below).

           A variable name consists of any number of alphanumeric characters
           (upper and lower case), and characters from this set:

               -_.!~*'()

           Additionally, a "%" character that is followed by two hexadecimal
           characters (upper and lower case) is acceptable.

           If instead of a variable name the character "#" appears, the number
           of variables in the namespace is returned. If the namespace does
           not exist, 0 is returned. For example, the value of this variable
           reference is the number of variables in the _C_o_n_f namespace:

               ${Conf::#}

           When the syntax with braces is used, a variable name may be
           followed by a colon and then one or more modifier flags that affect
           the processing of the variable. Referencing an invalid variable
           name or unknown namespace, or using an undefined modifier flag is
           an error. Referencing an undefined variable yields the empty
           string.

           Variable names are case sensitive by default; namespaces are always
           case sensitive.

           User-defined variables and namespaces are not persistent. They
           disappear when their execution context terminates.

               TTiipp
               A variable reference may not contain any whitespace except when
               it appears after a ?  or + modifier flag.

               TTiipp
               Because many variable references do not include flags or use
               punctuation characters in the variable name, as a convenience
               the braces that surround a variable reference may be omitted in
               certain cases. This is only possible if the variable name
               begins with an alphabetic or an underscore, which can be
               followed by alphanumerics and underscores. A namespace may be
               specified, but flags are not permitted, although the special
               "#" construct is also allowed. The variable name ends with the
               first invalid character. For example, these pairs of variable
               references are equivalent:


                   ${myvar}
                   $myvar

                   ${foo::baz}
                   $foo::baz

               Note that the variable reference ${foo-17} has a valid but
               different interpretation if the braces are omitted.

       VVaarriiaabbllee MMooddiiffiieerr FFllaaggss
           A variable reference may include one or more modifier flags that
           control how the reference is to be interpreted.

           The following modifier flags are recognized:

           e
               _E_x_i_s_t_s: The "e" modifier flag is used to test whether the
               variable exists (has been defined). Instead of returning the
               value of the variable or causing an error, the value of the
               variable reference is the string "1" if the variable is
               defined, the empty string otherwise (equivalent to FFaallssee).

           i
               _I_n_s_e_n_s_i_t_i_v_e: When looking up the name of a variable, the
               default is to use a case-sensitive comparison for the variable
               name. To use a case-insensitive comparison instead, an "i" flag
               is used (e.g., _$_{_F_O_O_:_:_i_}). The namespace lookup is always case
               sensitive.

           n
               _N_o_n_-_e_m_p_t_y: The "n" modifier flag tests whether the variable
               exists (has been defined) _a_n_d is not the empty string (i.e.,
               has zero length). Instead of returning the value of the
               variable or causing an error, the value of the variable
               reference is the string "1" if the variable is defined and is
               not the empty string, otherwise it is the empty string
               (equivalent to FFaallssee).

           z
               _Z_e_r_o: The opposite of the "n" flag, instead of returning the
               value of the variable or causing an error, the value of the
               variable reference is the string "1" if the variable is
               undefined or the empty string, otherwise it is the empty string
               (equivalent to FFaallssee).

           ?
               _D_e_f_a_u_l_t: The "?" modifier flag must appear last if it is used.
               The flag is immediately followed by zero or more characters.
               Its purpose is to associate a default value with the variable
               reference. If the variable is defined and is not empty, then
               the result of the variable reference is the value of the
               variable; otherwise, the result is the evaluation of the
               characters that follow the "?" flag. If no character follows
               the "?" flag, the empty string is indicated. The default may
               itself contain variable references, embedded spaces, etc., and
               is evaluated left to right. Any "}" characters appearing in the
               string before the last closing brace must be escaped by being
               preceded by a backslash.

           +
               _S_u_b_s_t_i_t_u_t_e: The "+" modifier flag must appear last if it is
               used. The flag is immediately followed by zero or more
               characters. Its purpose is to associate a substitute value with
               a variable reference. If the variable is defined and is not the
               empty string, then the result of the variable reference is the
               evaluation of the characters that follow the "+" flag; if the
               variable is undefined or is the empty string, the value of the
               variable reference is the empty string. If no character follows
               the "+" flag, the empty string is indicated. The substitute may
               itself contain variable references, embedded spaces, etc., and
               is evaluated left to right. Any "}" characters appearing in the
               string before the last closing brace must be escaped by being
               preceded by a backslash.
           The i can be combined with any other flag, but it must appear
           first. All other flags are mutually exclusive. Repetitions of a
           flag are ignored. An unrecognized flag raises an error condition.

           Consider these examples:

               ${Args::SCALE:?17}
               ${Foo::bar:i?${Bar::baz\}baz}
               "${DACS::QUERY:+?}${DACS::QUERY:?}"

           In the first example, if _$_{_A_r_g_s_:_:_S_C_A_L_E_} is undefined or empty, the
           value of the variable reference is "17" instead of the value of
           _$_{_A_r_g_s_:_:_S_C_A_L_E_}. In the second example, if _$_{_F_o_o_:_:_b_a_r_} (case
           insensitive) is defined, the result is its value, otherwise the
           result is the value of the string "${Bar::baz}baz". In the third
           example, if _$_{_D_A_C_S_:_:_Q_U_E_R_Y_} is defined and not empty, the value of
           the expression will be a question mark followed by the value of
           _$_{_D_A_C_S_:_:_Q_U_E_R_Y_}. If _$_{_D_A_C_S_:_:_Q_U_E_R_Y_} is undefined or empty, the value
           will be the empty string.

       RReesseerrvveedd NNaammeessppaacceess
           The following namespaces are predefined by DDAACCSS and reserved for
           particular uses. Some are read-only, which means that only DDAACCSS can
           create a variable or change the value of a variable in the
           namespace, except in certain contexts.

           _A_r_g_s
               Instantiated from query string arguments and the POST data
               stream (if the content type is
               application/x-www-form-urlencoded or multipart/form-data). This
               namespace is read-only.

           _A_r_g_v
               Instantiated by ddaaccsseexxpprr from the command line flags passed to
               the script. The value of _$_{_A_r_g_v_:_:_0_} is the name of the file
               being processed, with - signifying the standard input. The next
               argument, if any, will be _$_{_A_r_g_v_:_:_1_}, and so on. This namespace
               is read-only.

           _A_u_t_h
               Used by ddaaccss__aauutthheennttiiccaattee((88))[8] during authentication
               processing.

           _C_o_n_f
               Instantiated with configuration directive variables, this
               namespace is made read-only after configuration processing. See
               ddaaccss..ccoonnff((55))[9].

           _C_o_o_k_i_e_s
               This namespace is instantiated with HTTP cookies that were
               submitted with a request. For security reasons, those
               associated with DDAACCSS credentials are excluded. This is a
               read-only namespace. If a cookie named foo is sent by a user
               agent, an access control rule can access the cookie value as
               _$_{_C_o_o_k_i_e_s_:_:_f_o_o_}.

           _D_A_C_S
               Instantiated with DDAACCSS-specific variables. It is read-only. See
               ddaaccss__aaccss((88))[10].

           _E_n_v
               For web services, instantiated with the standard AAppaacchhee
               environment variables; for other programs, instantiated from
               the execution environment (eennvviirroonn((77))[11]). It is read-only.

           _E_x_e_c_E_n_v
               Used by eexxeecc(())[12].

           _L_D_A_P
               Used by llooccaall__llddaapp__aauutthheennttiiccaattee.

           _T_e_m_p
               Unless disabled or redefined at build-time, variable references
               that do not include a namespace are associated with this
               namespace as a convenience. The following three expressions are
               therefore equivalent:

                   ${foo} = 17
                   ${Temp::foo} = 17
                   $foo = 17

               In a future release, this mechanism may be generalized to
               provide a run-time means of selecting the default namespace.

   LLiissttss,, AAlliissttss,, aanndd AArrrraayyss
       DDPPLL supports more complicated data structures based on lists and
       associative lists. These types may also be combined and composed so
       that programmers can create lists of lists, and so on.

       LLiissttss
           A list is composed of zero or more basic data types or sub-lists. A
           list is created using the following syntax:

               _L_I_S_T     -> "[" "]" | "[" _L_I_S_T_-_E_L_S "]"
               _L_I_S_T_-_E_L_S -> _E_L | _E_L "," _L_I_S_T_-_E_L_S
               _E_L       -> _B_A_S_I_C_-_D_A_T_A_-_T_Y_P_E | _L_I_S_T

           A list can also be created through the lliisstt(())[13] function.

           Here is a list consisting of four elements:

               [1, "one", 1.000, ["one sublist"]]

           The lleennggtthh(())[14] function returns the number of elements in a list.

           A list can be assigned to a variable:

               $mylist = [1, 2, 3, 4, 5, 6]
               $mylist_copy = $mylist


               NNoottee
               These two statements are equivalent:

                   $mylist = ["one", "two"]
                   ${mylist} = ["one", "two"]

               And so are these two:

                   $mylist[0]
                   ${mylist}[0]

               Modifier flags therefore do not apply to list elements, only
               the list variable.

           A list or element can be appended to another list using the "."
           ("dot") concatenation operator. List elements can be rotated using
           the ">>" ("shift left") or "<<" ("shift right") operators. The
           compound assignment operator versions of these operators may also
           be used.

               > $mylist=[orange, apple, grape]
               [orange,apple,grape]
               > $mylist . banana
               [orange,apple,grape,banana]
               > $mylist .= [prune,plum]
               [orange,apple,grape,prune,plum]
               > $mylist .= [[lime]]
               [orange,apple,grape,prune,plum,[lime]]
               >$mylist << 1
               [apple,grape,banana,prune,plum,[lime],orange]

           A list element can be referenced using a subscript between zero and
           one less than the number of elements in the list:

               > $mylist = [1, 2, 3, 4, 5, 6]; length($mylist)
               6
               > $mylist[0]
               1

           It is an error to reference a non-existent list element using a
           subscript. (Note: additional syntax may be introduced to provide a
           way to declare lists and arrays.)

           The values of one or more list elements are selected by a list
           reference, which includes the simple subscript case just described.
           The value of a list reference is either a basic data type or a
           list.

               _L_I_S_T_-_R_E_F_E_R_E_N_C_E       -> "[" _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_E_L_S "]"
               _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_E_L_S   -> _E_M_P_T_Y | _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_E_L | _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_E_L "," _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_E_L_S
               _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_E_L    -> _E_X_P | _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_S_L_I_C_E
               _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_S_L_I_C_E -> _E_X_P ".." _E_X_P

               _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_S_E_Q   -> _L_I_S_T_-_R_E_F_E_R_E_N_C_E | _L_I_S_T_-_R_E_F_E_R_E_N_C_E _L_I_S_T_-_R_E_F_E_R_E_N_C_E_-_S_E_Q

           An _E_X_P must evaluate to a non-negative integer value. The ".."
           ("dotdot") range operator specifies a sequence of subscripts
           between the value to its left and the value to its right,
           inclusive. The left value must not be greater than the right value.
           If "#" appears to the right of the ".." operator, the number of
           elements in the list variable or the intermediate list computation
           is implied. A "#" may not appear to the left of ".." and may not be
           used in an expression (e.g., "#-2" is invalid). As in a function's
           argument list, a comma is not treated as the comma operator in this
           context. Note that it is not an error to specify non-existent
           elements in a slice; therefore it is possible for the value of a
           list reference to be the empty list.

               > $i=1, $mylist[$i]
               2
               > $mylist[1,3,5]
               [2,4,6]
               > $mylist[0..2,4]
               [1,2,3,5]
               > $mylist[2..#]
               [3,4,5,6]
               > $mylist[0..3]
               [1,2,3,4]

           The dotdot operator can also be used to construct an element of a
           list or alist:

               > $a = [1, 4..8, 10, 12, 13]
               [1,4..8,10,12,13]
               > length($a)
               5
               > $b = [0..2,4]; listref($a, $b)
               [1,4..8,10,13]

           Whether a "[" ... "]" sequence introduces a list constructor or
           list reference depends on the context; if it appears to the right
           of a list variable, list constructor, a function that returns a
           list, or another list reference, it is treated as a list reference.

           List references can be composed as a right-associative operation.
           For example:

               > $a = [[1,2,3], [4,5,6], [7,8,9]]
               [[1,2,3], [4,5,6], [7,8,9]]
               > $a[1][1]
               5
               > $a[0..1][1..2]
               [[4,5,6]]
               > $a[0..1][1..2][0][2]
               6


               TTiipp
               Individual characters and sequences of characters of a
               string-valued expression can be selected using ssttrrcchhaarrss(())[15],
               which uses a similar syntax.

               NNoottee
               +o   The list constructor and list reference syntax has not yet
                   been integrated with the eexxpprreessssiioonn ggrraammmmaarr[16].

               +o   A list value can also be assigned to a subscripted
                   variable; only a single subscript is allowed, however, and
                   the referenced element must already exist:

                       > $a = [1, 2, 3]
                       [1,2,3]
                       > $a[2] = 17
                       17
                       > $i = 1
                       1
                       > $a[$i] = [10, 11]
                       [10,11]
                       > $a
                       [1,[10,11],17]



       AAlliissttss
           DDPPLL''ss associative list, or "alist", is similar to Perl's hashes. An
           alist is composed of zero or more pairs. The first element of each
           pair is a case-sensitive key, unique within the alist, that is used
           to index the element. The second element of a pair is its value,
           which may be any data type. The key element of a pair, or all the
           keys in an alist, can be obtained using kkeeyyssooff(())[17]. Similarly,
           vvaalluueessooff(())[18] yields the value element or a list of value
           elements.

           Unlike a regular list, elements within an alist are not ordered.
           Two alists can only be compared for equality (or inequality); they
           are equal if they contain exactly the same pairs.

           An alist has the following syntax:

               _A_L_I_S_T       -> "{" "}" | "{" _A_L_I_S_T_-_P_A_I_R_S "}"
               _A_L_I_S_T_-_P_A_I_R_S -> _A_L_I_S_T_-_P_A_I_R | _A_L_I_S_T_-_P_A_I_R_S "," _A_L_I_S_T_-_P_A_I_R
               _A_L_I_S_T_-_P_A_I_R  -> _K_E_Y_-_E_L "," _V_A_L_U_E_-_E_L
               _K_E_Y_-_E_L      -> _S_T_R_I_N_G
               _V_A_L_U_E_-_E_L    -> _B_A_S_I_C_-_D_A_T_A_-_T_Y_P_E | _L_I_S_T | _A_L_I_S_T

           An alist can also be created through the aalliisstt(())[19] function.

           Here is an alist consisting of four elements:

               {"red", 0, "blue", 2, "green", 5, "black", 7}

           The lleennggtthh(())[14] function returns the number of pairs of elements
           in an alist.

           An alist can be assigned to a variable:

               $myalist = {1, 2, 3, 4, 5, 6}
               $myalist_copy = $myalist

           An alist can be appended to another alist using the "." ("dot")
           concatenation operator. The compound assignment operator version of
           this operator may also be used.

               > $myalist={sunny, 3}
               {"sunny", 3}
               > $myalist . {rainy, 11}
               {"sunny", 3, "rainy", 11}
               > $myalist .= {"snowy", 13}
               {"sunny", 3, "snowy", 13}

           An alist element or pair is referenced using a string subscript. A
           sequence of string subscripts can be used to select multiple pairs.
           If the subscript (or subscripts) are within brackets, then a
           successful result will be a basic data type or a list. If the
           subscript (or subscripts) are within braces, then a successful
           result will always be an alist. Note that because an alist
           subscript is not automatically converted to the string type, a
           numeric subscript is illegal.

               > $myalist = {a, 2, b, 4, c, 6}; length($myalist)
               3
               > $myalist["a"]
               2
               > $myalist{"b"}
               {"b", 4}
               > $myalist{"c", "a"}
               {"c", 6, "a", 2}

           It is an error to reference a non-existent alist element. (Note:
           additional syntax may be introduced to provide a way to declare
           lists and arrays.)

           Like regular lists, alist references can be composed as a
           right-associative operation:

               > $myalist = {a, [1, 2], b, [3, 4], c, [5, 6]}; length($myalist)
               3
               > $myalist["a"]
               [1, 2]
               > $myalist{"b"}
               {"b", [3, 4]}
               > $myalist{"b"}[1]
               4

           It is possible to convert an alist to a regular list, or vice
           versa; see the ccaasstt[7] operator.

               NNoottee
               There is currently no way to delete an alist pair.

   EExxpprreessssiioonn GGrraammmmaarr
       The following grammar is used to construct an expression (EXP) or
       sequence (S) of expressions.

           NNoottee
           The syntax is very similar to that of the C programming language.
           It differs with respect to data types, variables, compile-time
           operators, and on some minor aspects of grammar.

       A sequence of statements (or simply a sequence) is two or more
       expressions, with a ";" character separating them. The ";" is
       unnecessary following the last statement in a sequence of statements
       (and is therefore unnecessary if there is only one expression). The
       statements are evaluated in the order in which they appear. The value
       of a sequence is that of the last expression, unless an eexxiitt or rreettuurrnn
       function is invoked, in which case the value of the sequence is the
       value returned by the function call. An error condition will also
       terminate evaluation of the sequence and yield a result of FFaallssee. A
       sequence within curly braces is called a block.

       FFiigguurree 11.. EExxpprreessssiioonn GGrraammmmaarr

           _S    -> _E    | _E ";" | _E ";" _S
           _E    -> _E_2   | _E_2 "," _E
           _E_2   -> _E_3   | _V_A_R _A_S_S_I_G_N___O_P _E_2 | _I_F___E_L_S_E_I_F___E_L_S_E
           _E_3   -> _E_4   | _E_4 "?" _E ":" _E
           _E_4   -> _E_5   | _E_5 _O_R _E_5
           _E_5   -> _E_6   | _E_6 _A_N_D _E_5
           _E_6   -> _E_7   | _E_7 "|" _E_7
           _E_7   -> _E_8   | _E_8 "^" _E_8
           _E_8   -> _E_9   | _E_9 "&" _E_9
           _E_9   -> _E_1_0  | _E_1_0 _E_Q___O_P _E_1_0
           _E_1_0  -> _E_1_1  | _E_1_1 _R_E_L___O_P _E_1_1
           _E_1_1  -> _E_1_2  | _E_1_2 "." _E_1_2
           _E_1_2  -> _E_1_3  | _E_1_3 "<<" _E_1_3 | _E_1_3 ">>" _E_1_3
           _E_1_3  -> _E_1_4  | _E_1_4 "+" _E_1_4  | _E_1_4 "-" _E_1_4
           _E_1_4  -> _E_1_5  | _E_1_5 "*" _E_1_5  | _E_1_5 "/" _E_1_5 | _E_1_5 "%" _E_1_5
           _E_1_5  -> _E_1_6  | _E_1_6 "^" _E_1_4  | _E_1_6 "**" _E_1_4
           _E_1_6  -> _E_1_7  | _N_O_T _E_1_6 | "~" _E_1_6 | "++" _V_A_R | "--" _V_A_R
                        | "+" _E | "-" _E | "(" _t_y_p_e ")"
           _E_1_7  -> "(" _E ")" | _V_A_R "++" | _V_A_R "--" | _F_U_N_C_T_I_O_N___C_A_L_L | _P_R_I_M_A_R_Y

           _A_S_S_I_G_N___O_P -> "=" | "+=" | "-=" | "*=" | "/=" | "%=" | ">>="
                            | "<<=" | "&=" | "^=" | "|=" | ".="

           _P_R_I_M_A_R_Y -> _a _n_u_m_b_e_r | _a _s_t_r_i_n_g | _V_A_R
           _O_R      -> "||" | "or"
           _A_N_D     -> "&&" | "and"
           _N_O_T     -> "!"  | "not"
           _E_Q___O_P   -> "==" | "!=" | "eq" | "ne"
           _R_E_L___O_P  -> "<"  | "<=" | ">" | ">=" | "lt" | "le" | "gt" | "ge"
           _V_A_R     -> _a _v_a_r_i_a_b_l_e _r_e_f_e_r_e_n_c_e
           _F_U_N_C_T_I_O_N___C_A_L_L -> _F_U_N_C_T_I_O_N___N_A_M_E "(" _A_R_G___L_I_S_T ")"
           _A_R_G___L_I_S_T -> _E_M_P_T_Y | _E_2 | _A_R_G___L_I_S_T "," _E_2
           _E_M_P_T_Y    ->

       Keywords and function names are case sensitive.

       The production _V_A_R _A_S_S_I_G_N___O_P _E in the grammar refers to assignment of
       the evaluation of _E to a variable using the given assignment operator
       (_A_S_S_I_G_N___O_P). For example,

           ${a} += 17

       Provided _$_{_a_} has been initialized to an integer value, this expression
       increments it by 17.

       The production _I_F___E_L_S_E_I_F___E_L_S_E represents a familiar if statement with
       zero or more elseif components and an optional else component:

           if (_e_x_p_r_e_s_s_i_o_n) {
             _s_e_q_u_e_n_c_e
           }
           [elseif (_e_x_p_r_e_s_s_i_o_n) {
             _s_e_q_u_e_n_c_e
           }] ...
           [else {
             _s_e_q_u_e_n_c_e
           }]

       Each _b_l_o_c_k is an optional sequence of statements. Braces are mandatory.

           TTiipp
           An if_elseif_else statement has a value: it is either that of the
           last statement executed in the selected block, or the empty string
           if no statement is executed. In this example, _$_{_a_} is set to either
           33 or ${b} - 1, depending on whether _$_{_b_} is greater than eight:

               ${a} = if (${b} > 8) {${b}++; 33;} else {${b} - 1}

           The value of this expression is the string "hello, world":

               "hello, " . (if (0) {b . y . e} else {"world"})

           NNoottee
           As in C, function calls, nested assignment operators, and increment
           and decrement operators cause side effects where the value of a
           variable is changed during expression evaluation. Because exactly
           when such side effects take place is left unspecified, programmers
           should avoid writing code with these kinds of dependencies on
           evaluation ordering.

   OOppeerraattoorrss
       The operators that appear in the grammar have the following semantics.
       They are listed in order of increasing precedence (which is very close
       to ISO C's), with operators in the same section having equal
       precedence. The result of applying an operator is one of the ssuuppppoorrtteedd
       ddaattaa ttyyppeess[20], or an error. Parentheses can be applied to
       subexpressions in the usual way.

       Whenever it makes sense, intermediate values are automatically
       converted to an appropriate type by an operator. So, for example,
       adding an integer and a real will cause the integer to automatically be
       converted to a real, yielding a real value. Adding a string and a
       number will work only if the string can be successfully converted to a
       number. In situations where an integer is required, a real value
       (including a string that represents a valid real number) will be
       truncated to an integer. For logical comparison operators, the operands
       will both be converted to integers, reals, or strings as necessary. A
       string value that is an illegal number will always be treated as a
       string.

           NNoottee
            id="note11" xreflabel="dacsexpr prompts".PP In the examples that
           follow, the '>' character at the beginning of an input line is a
           prompt from ddaaccsseexxpprr((11))[1].

       ,
           This is the C/C++ comma operator. A pair of expressions separated
           by a comma is evaluated left to right, and the type and value of
           the result are the type and value of the right operand.

       =, +=, -=, *=, /=, %=, >>=, <<=, &=, ^=, |=, .=
           Assignment is done using a simple or compound assignment operator,
           each of which has right to left associativity. In the case of a
           compound assignment operator, the left hand side is evaluated only
           once. The type and value of an assignment is that of its right hand
           side. A variable reference is expected on the left side of the
           operator. Modifier flags are not permitted. The variable, which is
           created if it does not exist. The syntax of the variable reference
           includes the initial "${" and terminating "}" character (so it's
           similar to PPeerrll's syntax).

               > ${foo::bar} = "hello"
               "hello"
               > ${foo::bar} .= ", world"
               "hello, world"
               > ${a} = [1, 2]
               [1,2]
               > ${a} .= [3, 4]
               [1,2,3,4]


       ?:
           This is equivalent to the C/C++ conditional expression, which has
           right to left associativity. If the first expression is TTrruuee, the
           result is the value of the second expression (the third is not
           evaluated). If the first expression is FFaallssee, the result is the
           value of the third expression (the second is not evaluated).

       or, ||
           This is the C/C++ logical OR operator, which yields 11 (TTrruuee) if
           either operand is TTrruuee, otherwise it yields 00 (FFaallssee). Evaluation
           is from left to right and and stops as soon as the truth or
           falsehood of the result is known. The two tokens are synonymous.

       and, &&
           This is the C/C++ logical AND operator, which yields 11 (TTrruuee) if
           both operands are TTrruuee, otherwise it yields 00 (FFaallssee). Evaluation
           is from left to right and and stops as soon as the truth or
           falsehood of the result is known. The two tokens are synonymous.

               NNoottee
               When expressions are parsed as XML attribute values, an '&'
               character must be encoded as the five characters '&amp;'.

       |
           This is the C/C++ bitwise inclusive OR operator. Both operands must
           be integers.

       ^
           This is the C/C++ bitwise exclusive OR operator. Both operands must
           be integers.

       &
           This is the C/C++ bitwise AND operator. Both operands must be
           integers.

               NNoottee
               When expressions are parsed as XML attribute values, an '&'
               character must be encoded as the five characters '&amp;'.

       ==, !=, eq, ne, eq:i, ne:i
           These operators compare their arguments and return 1 if the
           relation is true, 0 otherwise. If both arguments are lists,
           corresponding elements of both lists are compared, recursively. If
           both arguments are alists, the number of pairs in both lists is
           compared and, if necessary, pairs in the first list are looked up
           in the second list for matching values (note that the
           case-insensitive variant applies only to the value component of a
           pair, not the key component). For other valid arguments an attempt
           is first made to coerce both arguments to numbers and do a numeric
           comparison. If that fails, a lexicographic comparison is performed.
           Operators having a :i modifier are like their counterparts without
           the modifier except they do case-insensitive string comparisons.

           If either argument is of type bstring, however, the comparison is
           done differently than explained above. Two bstring arguments are
           equal if and only if they are byte-wise identical. If one argument
           is a bstring and the other is a string, the latter is treated as a
           bstring of length(_s_t_r_i_n_g) bytes. The case flag is ignored if at
           least one argument is a bstring.

       <, <=, >, >=, lt, le, lt:i, le:i, gt, ge, gt:i, ge:i
           These operators compare their arguments and return 1 if the
           relation is true, 0 otherwise. An attempt is first made to coerce
           both arguments to numbers and do a numeric comparison. If that
           fails, a lexicographic comparison is performed. Operators having a
           :i modifier are like their counterparts without the modifier except
           they do a case-insensitive comparison.

               NNoottee
               When expressions are parsed as XML attribute values, the '<'
               character must be encoded as the four characters '&lt;'; the
               same applies to the "greater than" symbol.
           If either argument is of type bstring, however, the comparison is
           done differently than explained above. If two bstring arguments are
           compared, the shorter bstring is "less than" the other argument and
           they are equal if and only if they are byte-wise identical. If one
           argument is a bstring and the other is a string, the latter is
           treated as a bstring of length(_s_t_r_i_n_g) bytes. The case flag is
           ignored if at least one argument is a bstring.

       .
           The "dot" operator (not in ISO C) concatenates its right operand to
           its left operand. If both arguments are of type bstring, the result
           is also of type bstring. If the left operand is a list and the
           right operand is a basic data type, the right operand is appended
           to the list. If the left operand is a list and the right operand is
           also a list, the elements of the right operand are appended to the
           left operand. A list may not appear as the right operand if the
           left operand is not a list. In all other cases, both arguments are
           coerced to string (an error occurs if this cannot be done) before
           the left operand is appended to the right.

               > "hello" . ", world"
               "hello, world"
               > "hello" . (16 + 1)
               "hello17"
               > 17 . (16 + 1)
               "1717"
               > [1, 2, 3] . 4
               [1,2,3,4]
               > [1, 2, 3] . [4, 5, 6]
               [1,2,3,4,5,6]
               > [1, 2, 3] . [[4]]
               [1,2,3,[4]]


               NNoottee
               A period will be recognized as a decimal point in a real number
               context rather than as the dot operator, so the input:

                   4.5

               will be scanned as a number whereas, for example, the input:

                   "4".5

               will evaluate to the string "45".

       <<, >>
           These are the C/C++ bitwise left shift and right shift operators,
           respectively. The first operand may be an integer or a list, the
           second operand must be an integer. When shifting an integer, these
           operators are implemented using the corresponding C/C++ operators.
           In the case of right shifting, the behaviour with respect to
           arithmetic vs. logical shifts will be platform dependent.

       +, -
           These are the (binary) addition and subtraction operators,
           respectively. Both arguments are coerced to numbers. An error
           occurs if this cannot be done. Also, unary + and - operators may
           precede an arithmetic-valued expression.

       *, /, %
           These are the multiplication, division, and remainder operators,
           respectively. Both arguments are coerced to numbers. An error
           occurs if this cannot be done, such as attempting to divide by
           zero. For the remainder operator, both operands must be integers.

       **
           This is the exponentiation operator (not in ISO C). Both arguments
           are coerced to numbers (either both integers or both reals). An
           error occurs if this cannot be done, such as attempting to raise to
           a negative power.

               > 2**10
               1024


       +, -, not, !, ~, ++_V_A_R, --_V_A_R, (_t_y_p_e)
           The + and - operators are the (unary) arithmetic plus and minus
           operators, respectively. These may precede an arithmetic-valued
           expression. Both arguments are coerced to numbers. An error occurs
           if this cannot be done.

           The logical NOT operator (not, or equivalently, !) yields a result
           of zero when applied to a non-zero numeric value and non-zero when
           applied to an operand of zero. The result of applying this operator
           to a non-empty string is zero and it is non-zero when applied to an
           empty string string. These two tokens are synonymous.

           The ~ operator is the one's complement (bitwise not) unary
           operator.

           The ++_V_A_R and --_V_A_R operators are the prefix increment and
           decrement operators, respectively. These operators are followed by
           a variable reference. The variable must have an integer value.

               > ${foo} = 17, ++${foo}
               18

           An explicit type conversion can be forced by using a cast. The
           syntax for this type coercion is:

               (_t_y_p_e) _e_x_p_r_e_s_s_i_o_n

           The _t_y_p_e must be a recognized data type name: integer or int (for
           an integer), real or double (for a real), bool (for a boolean value
           as a long integer), string (for a character string), bstring or
           binary (for a binary string), list, alist, or void.

           A list can be cast to an alist, provided it has no elements or an
           even number of elements and if no key would appear more than once
           in the alist. A namespace can be cast to an alist; the operand
           specifies the namespace, either as a literal or a string. An alist
           can be cast to an list; the ordering of the pairs in the resulting
           list is unspecified. A void type can only be cast to void, which is
           a no-op. Here are some examples:

               > (int) 3.4
               3
               > (int) "3.6"
               3
               > (bool) 17
               1
               > (bool) ""
               0
               > (string) (4 * 3)
               "12"
               > ${x} = "17"; (int) ((real) ${x} + (bool) 1965)
               18
               > (bstring) "abc"
               "abc"
               > (bstring) 4.4
               "4.400000"
               > (bstring) "\0\1\2"
               ""
               > bstring("\0\1\2",3) . bstring("\3\4", 3)
               "0001020304"
               > (void) ($b=$x)
               >
               > (alist) [a, 1, "b", 2, 3, 3]
               {"a", 1, "b", 2, "3", 3}
               > (list) { red, first, blue, second, white, third }
               ["blue", "second", "white", "third", "red", "first"]
               > $env = (alist) Env; $env["HOME"]
               "/home/bobo"
               > $env{HOME}
               {"HOME","/home/bobo"}


       _V_A_R++, _V_A_R--, primary
           The _V_A_R++ and _V_A_R-- operators are the postfix increment and
           decrement operators, respectively. These operators are preceded by
           a variable reference. The variable must have an integer value.

           A primary is a basic ddaattaa ttyyppee[20] (i.e., an integer or real
           number, string, bareword, or binary string), or a vvaarriiaabbllee
           rreeffeerreennccee[21].

   FFuunnccttiioonnss
       A function call is written as a function name, optionally followed by
       whitespace, a left parenthesis, zero or more comma-separated arguments,
       and a right parenthesis. A function name begins with either an
       alphabetic character or an underscore, followed by any number of
       alphanumerics and underscores. Additionally, a pair of colons may
       appear exactly once within the name (except at the beginning or end of
       the name). The number of arguments and their expected types depends on
       the particular function being called. The order in which the arguments
       to a function are evaluated is undefined. There is no mechanism for
       creating user-defined functions yet (they will eventually be available
       on some platforms through dynamically linked libraries).

       The result of a function call is one of the ssuuppppoorrtteedd ddaattaa ttyyppeess[20],
       or an error. An invalid function call, including those that fail during
       execution, yields a FFaallssee result.

       FFuunnccttiioonn IInnddeexx::

       +o   aacckk: notice acknowledgement processing

       +o   aalliisstt: create an alist

       +o   aalliissttrreeff: create an alist reference

       +o   bbssttrriinngg: convert a string to binary

       +o   ccoonnttaaiinnss__aannyy: count elements common to two lists

       +o   ccoouunntteerr: persistent integer counters

       +o   ddaaccss__aaddmmiinn: test if user is an administrator

       +o   ddaaccss__aapppprroovvaall: create or test a signed authorization

       +o   ddaaccss__mmeettaa: get or update metadata

       +o   ddaaccssaauutthh: perform authentication tests

       +o   ddaaccsscchheecckk: perform authorization tests

       +o   ddeebbuugg: control debugging output

       +o   ddeeccooddee: convert from a text representation

       +o   ddiiggeesstt: cryptographic hash functions

       +o   eennccooddee: convert to a text representation

       +o   eevvaall: evaluate a string

       +o   eexxeecc: execute a program

       +o   eexxiitt: terminate current evaluation

       +o   eexxppaanndd: variable interpolation

       +o   ffiillee: perform an operation on a file

       +o   ffiillee__ggrroouupp: test if user is associated with file's group

       +o   ffiillee__oowwnneerr: test if user is associated with file's owner

       +o   ffrroomm: test where the current request comes from

       +o   ggeett: read the contents of a file or VFS object

       +o   hhaasshh: fast hashes

       +o   hhmmaacc: secure keyed-hashes

       +o   hhttttpp: invoke an HTTP request

       +o   iinnddeexx: search a string or list

       +o   iinnffoo: information about namespaces and variables

       +o   kkeeyyssooff: extract keys from an alist

       +o   llddaapp: extract a component from an LDAP name

       +o   lleennggtthh: string length

       +o   lliisstt: create a list

       +o   lliissttrreeff: dereference a list

       +o   oonn__ssuucccceessss: evaluate an expression if authentication or
           authorization succeeds

       +o   ppaasssswwoorrdd: compute or check a password hash

       +o   ppaatthhnnaammee: filename-based string interpolation

       +o   ppbbkkddff22: password-based key derivation

       +o   pprriinntt: display a string

       +o   pprriinnttff: display a formatted string

       +o   rraannddoomm: generate random values

       +o   rreeddiirreecctt: redirect user after access is denied

       +o   rreeggmmaattcchh: string matching

       +o   rreeggssuubb: string substitution

       +o   rreeqquueesstt__mmaattcchh: compare the current request to a URI

       +o   rreettuurrnn: terminate current evaluation

       +o   rruullee: recursive authorization checking

       +o   sseettvvaarr: operations on namespaces

       +o   ssiizzeeooff: basic data type sizes

       +o   sslleeeepp: suspend execution temporarily

       +o   ssoouurrccee: read and evaluate external expressions

       +o   sspprriinnttff: format a string

       +o   ssttrrcchhaarrss: select characters from a string

       +o   ssttrrffttiimmee: format the current date and time

       +o   ssttrrppttiimmee: parse a date and time

       +o   ssttrrrrssttrr: locate the last instance of a substring

       +o   ssttrrssttrr: locate the first instance of a substring

       +o   ssttrrttoolloowweerr: map uppercase to lowercase

       +o   ssttrrttoouuppppeerr: map lowercase to uppercase

       +o   ssttrrttrr: character transliteration

       +o   ssuubbsseett: test if one set is a subset of another

       +o   ssuubbssttrr: extract a substring

       +o   ssyynnttaaxx: perform a syntax check on a string

       +o   ttiimmee: local time and date

       +o   ttrraannssffoorrmm: filter text through rule-based transformations

       +o   ttrraannssffoorrmm__ccoonnffiigg: set options for transform

       +o   ttrriimm: delete trailing characters

       +o   ttyyppeeooff: get or test data type

       +o   uunnddeeff: an undefined value

       +o   uusseerr: test current user's identity

       +o   uussttaammpp: generate a unique stamp

       +o   vvaalluueessooff: extract values from an alist

       +o   vvaarr: operations on individual variables

       +o   vvffss: perform a VFS operation

       aacckk(_n_o_t_i_c_e_-_u_r_i[, _._._.][, EXACT_MATCH | ALL_MATCH])
           This function is associated with notice acknowledgement processing.
           The function indicates that the current service request has one or
           more notices associated with it (identified by a sequence of
           _n_o_t_i_c_e_-_u_r_i arguments), each one represented by a URI that will
           return the text of a notice that must be acknowledged by the user.
           Following the last URI is an optional mode argument. The
           EXACT_MATCH mode is the default mode and requires a single
           acknowledgement to address all of the specified notices. The
           ALL_MATCH argument specifies a less stringent matching mode and
           requires any set of acknowledgements to collectively address all of
           the specified notices. See ddaaccss__nnoottiicceess((88))[22].

       aalliisstt([_k_e_y, _v_a_l_u_e [, ...])
           This function is equivalent to the aalliisstt ccoonnssttrruuccttiioonn ooppeerraattoorr[23].
           There must be an even number of arguments, or no arguments. If the
           first argument of each pair (the key) is not a string or literal,
           it will be converted to a string, if possible.

               alist(cars, 2, bikes, 5)

           is equivalent to the expression:

               {"cars", 2, "bikes", 5}

           And the call:

               alist(2, xx, [0, 1], yy)

           yields:

               {"2", xx, "[0,1]", yy}


       aalliissttrreeff(_l_i_s_t)
           This function creates a new list that is equivalent to that of the
           special "brace syntax" subscript used to dereference an alist. This
           is currently useful only in conjunction with lliissttrreeff(())[24].

               listref({"a", 1, "b", 2, "c", 3}, alistref(["b"]))

           is equivalent to the expression:

               {"a", 1, "b", 2, "c", 3}{"b"}

           the value of which is:

               {"b", 2}


       bbssttrriinngg(_s_t_r_i_n_g, _l_e_n_g_t_h)
           This function converts the first _l_e_n_g_t_h characters of _s_t_r_i_n_g (which
           may also be a bstring and which is converted to a string if
           necessary) into the binary type. The _l_e_n_g_t_h argument may be less
           than the actual length of _s_t_r_i_n_g; if it is zero, then actual length
           is computed, and if _l_e_n_g_t_h is greater than the actual length, the
           actual length is used. The implicit null character on the end of
           _s_t_r_i_n_g is not considered part of it.

               > bstring("\0\1\2", 4)
               "000102"
               > bstring("\0\1\2", 2)
               "0001"


       ccoonnttaaiinnss__aannyy(_f_o_r_m_a_t, _t_e_s_t_-_s_e_t, _t_a_r_g_e_t_-_s_e_t[, nocase])
           This function returns a count of the number of elements of _t_e_s_t_-_s_e_t
           that appear in _t_a_r_g_e_t_-_s_e_t at least once. Duplicate elements may
           appear in _t_e_s_t_-_s_e_t and are considered to be distinct. The _f_o_r_m_a_t
           indicates how to parse the set arguments. It can be the space, tab,
           or newline character, or any punctuation character. For both sets,
           it is currently interpreted as the character that separates
           elements. If the optional nocase literal argument is given, then
           set elements are compared case-insensitively. The greatest possible
           return value is the number of distinct elements in the third
           parameter.

               contains_any(",", ${Args::LAYERS:i}, "Nests,Secret_roads,Heritage")
               contains_any(",", "a,a,b,z", "a,a,a,b,b,b,a,z,z")

           The first expression returns 33 if every element in the third
           parameter appears at least once (case insensitive) in the second
           parameter, otherwise the value of the expression is 00. The second
           expression returns 44.

       ccoouunntteerr(_o_p, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e [,_v_a_l_u_e])
           This function is used to manage persistent integer counters, which
           can be useful for a variety of purposes, such as counting the
           number of logins for a particular identity, limiting the number of
           logins, or restricting the number of times a resource can be
           accessed. Internally, counter values are iinntteeggeerrss[20].

           The first argument specifies an operation and is case-insensitive.
           The second argument identifies a filestore (typically a file or
           database). It must be an indexed filestore scheme, such as
           dacs-kwv-fs or dacs-db (see VVFFSS[25]). The third argument is the
           name of the counter, which acts as a key. The meaning of the fourth
           argument depends on the operation, but if present it must be an
           integer.

               NNoottee
               The current implementation has a limitation; a counter name
               (key) can be any printable string but cannot contain a space
               character. You can work around this limitation by encoding all
               keys every time they are used in a filestore operation.

            1. counter(set, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e, _n_e_w_-_v_a_l_u_e)

               This is used to create a new counter or reset an existing
               counter. The counter's value will be _n_e_w_-_v_a_l_u_e, which must be
               an integer, and is the return value.

            2. counter(create, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e, _i_n_i_t_i_a_l_-_v_a_l_u_e)

               This is used to create a new counter if it does not already
               exist. The new counter's value will be _i_n_i_t_i_a_l_-_v_a_l_u_e, which
               must be an integer. If the counter exists, its value will not
               be changed and is returned.

            3. counter(del[ete], _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e)

               This operation deletes an existing counter. The operation can
               be del or delete.

            4. counter(exists, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e)

               This operation returns 1 if a counter exists, 0 otherwise.

            5. counter(get, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e)

               This operation returns the current counter value.

            6. counter(inc|dec, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e[, _a_m_o_u_n_t])

               This operation increments or decrements an existing counter by
               _a_m_o_u_n_t, which must be an integer. If _a_m_o_u_n_t is not given, 1 is
               used. The updated counter value is returned.

            7. counter(decdel, _v_f_s_-_r_e_f, _c_o_u_n_t_e_r___n_a_m_e[, _a_m_o_u_n_t])

               This operation decrements an existing counter by _a_m_o_u_n_t, which
               must be an integer. If _a_m_o_u_n_t is not given, 1 is used. If the
               resulting value is zero or negative, the counter is deleted and
               zero is returned. If the counter is not deleted, its updated
               value is returned.

            8. counter(list, _v_f_s_-_r_e_f)

               This operation returns a list of counters as a string, newline
               separated, each with its current value.

               Operations that set or change the counter value return the new
               value.

               For filestores that support locking, read-only operations
               obtain a shared lock while the other operations obtain an
               exclusive lock.

               It is an error to reference a counter that does not exist
               unless the operation is set or exists.

                   NNoottee
                   To some extent, this function is a poor substitute for a
                   more general Perl-like ttiiee(()) function. Such a function is
                   being considered.

                   Modifications to counters are not atomic. Amongst other
                   things, this means that a crash may cause counter updates
                   to be lost.
               A counter would typically be created by running ddaaccsseexxpprr((11))[1]:

                   % dacsexpr -e 'counter(set, "dacs-kwv-fs:/usr/local/dacs/counters/logins", "EXAMPLE::EX:bob", 1)'

               The counter's value might then be tested in the rreevvooccaattiioonn
               lliisstt[26] or by an aacccceessss ccoonnttrrooll rruullee[27], for instance:

                   counter(exists, "dacs-kwv-fs:/usr/local/dacs/counters/logins", ${DACS::IDENTITY})

               The counter might be conditionally updated using the
               oonn__ssuucccceessss(())[28] function, or the AAUUTTHH__SSUUCCCCEESSSS[29] or
               AACCSS__SSUUCCCCEESSSS[30] directives, using an expression like:

                   counter(decdel, "dacs-kwv-fs:/usr/local/dacs/counters/logins", ${DACS::IDENTITY})


           ddaaccss__aaddmmiinn()
               This predicate returns TTrruuee if the user making a service
               request has any credentials that match any specified by the
               AADDMMIINN__IIDDEENNTTIITTYY[31] configuration directive.

           ddaaccss__aapppprroovvaall(_o_p[, ...])
               This function is used to create an aapppprroovvaall ssttaammpp[32] or
               inspect or validate one.

               The following operations are available:

               ddaaccss__aapppprroovvaall(approval, _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e, _n_a_m_e_s_p_a_c_e)
                   This operation parses the _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e (the
                   value of DDAACCSS__AAPPPPRROOVVAALL), setting variables in _n_a_m_e_s_p_a_c_e,
                   after first ddaaccss6644 ddeeccooddiinngg[33] the argument. If _n_a_m_e_s_p_a_c_e
                   exists, its contents are deleted. Variables set are: _j
                   (jurisdiction name), _h (hash/digest name), _s (stamp), _u
                   (URI), _m (HTTP method), and _i (user identity). See
                   ddaaccss__aaccss((88))[32]. The signature is _n_o_t checked. The function
                   returns TTrruuee (1) if the approval message is syntactically
                   correct, otherwise FFaallssee (0).

               ddaaccss__aapppprroovvaall(check, _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e)
                   The _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e is decoded and parsed, and the
                   signature is validated. The function returns TTrruuee (1) only
                   if the signature is correct, otherwise FFaallssee (0).

                   In the current implementation, the signature can only be
                   validated by the jurisdiction that signed the message. This
                   deficiency will be addressed in a future release and a web
                   service will also supply this functionality. Ideally, for
                   maximum convenience, availability, efficiency, and
                   simplicity, the recipient of an approval message should be
                   able to validate it directly if it has the appropriate
                   public key, invoke a web service at any jurisdiction in the
                   federation if public keys are distributed and kept current,
                   or at the jurisdiction that signed the message.

               ddaaccss__aapppprroovvaall(create, _u_r_i, _m_e_t_h_o_d, _i_d_e_n_t, _d_i_g_e_s_t_-_n_a_m_e)
                   Create and return a _d_a_c_s_6_4_-_a_p_p_r_o_v_a_l_-_m_e_s_s_a_g_e (as described
                   above and in ddaaccss__aaccss((88))[32]), formed from the given
                   arguments and signed by the current jurisdiction.


           ddaaccss__mmeettaa(_o_p[, ...])
               This function returns information associated with the current
               federation, current jurisdiction, or other jurisdictions in the
               current federation. See ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[34] for
               additional information.

               The following operations are available:

               ddaaccss__mmeettaa(federation, _n_a_m_e_s_p_a_c_e)
                   Return metadata for the current federation, setting
                   variables in _n_a_m_e_s_p_a_c_e. If _n_a_m_e_s_p_a_c_e exists, its contents
                   are deleted. Variables set are: _f_e_d_e_r_a_t_i_o_n, _d_o_m_a_i_n, _f_e_d___i_d
                   (if available), and _f_e_d___p_u_b_l_i_c___k_e_y (if available, in PEM
                   format).

               ddaaccss__mmeettaa(jname, _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e, _n_a_m_e_s_p_a_c_e)
                   Return metadata for the jurisdiction named
                   _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e in the current federation. If _n_a_m_e_s_p_a_c_e
                   exists, its contents are deleted. Variables set are: _j_n_a_m_e,
                   _n_a_m_e, _a_l_t___n_a_m_e, _d_a_c_s___u_r_l, _a_u_t_h_e_n_t_i_c_a_t_e_s, _p_r_o_m_p_t_s, _a_u_x_i_l_i_a_r_y
                   (if available), and _p_u_b_l_i_c___k_e_y (if available, in PEM
                   format).

               ddaaccss__mmeettaa(jurisdiction, _n_a_m_e_s_p_a_c_e)
                   This is equivalent to the jname operation with
                   _j_u_r_i_s_d_i_c_t_i_o_n___n_a_m_e set to the name of the current
                   jurisdiction.

               ddaaccss__mmeettaa(list_jurisdictions)
                   Return a newline-separated list of all jurisdiction names
                   in the current federation. A local copy of the metadata is
                   used.

               ddaaccss__mmeettaa(update_jurisdiction, _j_n_a_m_e [,_u_r_l])
                   _N_o_t _i_m_p_l_e_m_e_n_t_e_d. Intended to update the local metadata for
                   the jurisdiction name _j_n_a_m_e. If _u_r_l is absent, then the
                   current jurisdiction must already have the correct dacs_url
                   attribute in its entry for _j_n_a_m_e. If _u_r_l is given, it is
                   assumed to be the URL for ddaaccss__lliisstt__jjuurriissddiiccttiioonnss and it is
                   used instead of one formed from dacs_url for the
                   jurisdiction.

               ddaaccss__mmeettaa(update_jurisdictions, _j_n_a_m_e)
                   _N_o_t _i_m_p_l_e_m_e_n_t_e_d. Intended to update the local metadata for
                   all of the jurisdictions. If _j_n_a_m_e looks like a URL (i.e.,
                   it begins with either "http" or "https", then it is assumed
                   to be the URL for ddaaccss__lliisstt__jjuurriissddiiccttiioonnss and it is used to
                   obtain a fresh copy of the metadata; otherwise, _j_n_a_m_e is
                   assumed to be a jurisdiction name for which the current
                   jurisdiction already has a correct dacs_url attribute and
                   metadata is retrieved from that jurisdiction.


           ddaaccssaauutthh(_d_a_c_s_a_u_t_h_-_f_l_a_g_s)
           ddaaccssaauutthh(_a_r_g_1, _a_r_g_2[, ...])
               This function provides an interface to ddaaccssaauutthh((11))[35]. In the
               first usage, the single string argument is parsed into space or
               tab separated flags. Single or double quotes are allowed. In
               the second usage, each flag is a separate string or literal
               argument and is not parsed.

               An alist is returned that has the following three elements:

               result
                   An integer: 1 if authentication succeeded, 0 if it failed
                   or was not requested, and -1 if an error occured.

               identity
                   A string: if authentication was requested and succeeded,
                   this is the corresponding identity, otherwise it is the
                   empty string.

               roles
                   A string: if roles were requested (and authentication
                   succeeded, if requested), this is the role descriptor
                   string, otherwise it is the empty string.


                   IImmppoorrttaanntt
                   This function should be considered experimental. Use it
                   with caution. In version 1.4.25 and earlier, this function
                   returned an integer value (the result).

                   SSeeccuurriittyy
                   Like ddaaccssaauutthh and ddaaccss__aauutthheennttiiccaattee, if a built-in module
                   is used to perform authentication, this function must be
                   run by a setuid or setgid process to obtain sufficient
                   privileges to access the required files; this is true for
                   Unix password authentication, for example.
               Examples: .sp .if n  .RS 4 . .fam C .ps -1 .nf .if t  .sp -1 .
               .BB lightgray adjust-for-leading-newline .sp -1 > dacsauth("-m
               unix suff -user bobo -p apassword")
               {"result",0,"identity","","roles",""} > dacsauth("-m", "unix",
               "suff", "-user", "bobo", "-p", "bpassword")
               {"result",1,"identity","EXAMPLE::FEDROOT:bobo","roles",""} >
               dacsauth("-r unix
               -DVFS='[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys'
               -u bobo")
               {"result",0,"identity","","roles","bobo,wheel,www,users"} .EB
               lightgray adjust-for-leading-newline .if t  .sp 1 . .fi .fam
               .ps +1 .if n  .RE . .sp

           ddaaccsscchheecckk(_d_a_c_s_c_h_e_c_k_-_f_l_a_g_s)
           ddaaccsscchheecckk(_a_r_g_1, _a_r_g_2[, ...])
               This function provides an interface to ddaaccsscchheecckk((11))[36],
               returning 1 if access is granted, 0 if access is denied, and -1
               if an error occurs. In the first usage, the single string
               argument is parsed into space or tab separated flags. Single or
               double quotes are allowed. In the second usage, each flag is a
               separate string or literal argument and is not parsed.

                   IImmppoorrttaanntt
                   This function should be considered experimental. Use it
                   with caution.

           ddeebbuugg(_t_y_p_e, _v_a_l_u_e)
               This function enables, disables, or adjusts the amount of
               debugging output produced by the interpreter. Output type _t_y_p_e
               is set to _v_a_l_u_e, which may be "on", "off", or a non-negative
               integer level (the meaning of which depends on _t_y_p_e.

               The following _t_y_p_e names are recognized: TBD

           ddeeccooddee(_e_n_c_o_d_i_n_g_-_t_y_p_e, _s_t_r_i_n_g)
               This function performs the inverse of eennccooddee(())[37] for the same
               _e_n_c_o_d_i_n_g_-_t_y_p_e. The result is a bstring. The function will fail
               if its argument is not properly encoded.

               For the hex encoding type, alphabetic characters may be upper
               case or lower case.

           ddiiggeesstt(_m_s_g, _m_s_g_-_l_e_n [, _d_i_g_e_s_t_-_n_a_m_e])
               This function computes a ccrryyppttooggrraapphhiicc hhaasshh[38] of _m_s_g (a
               string or bstring). The _m_s_g_-_l_e_n is the length of _m_s_g in bytes;
               if it is 0, its length is computed. The hash algorithm can be
               any function provided by OOppeennSSSSLL and may be specified as
               _d_i_g_e_s_t_-_n_a_m_e, case insensitively, otherwise SHA1 is used. The
               list of available digest algorithms is subject to change, but
               is likely to include md5, sha, sha1, sha224, sha256, sha384,
               and sha512. The function value is a bstring. If cryptographic
               strength is not required, see hhaasshh(())[39].

                   > digest("foo", 0, "md5")
                   "acbd18db4cc2f85cedef654fccc4a4d8"
                   > digest("Hello, world", 0, "SHA256")
                   "4ae7c3b6ac0beff671efa8cf57386151c06e58ca53a78d83f36107316cec125f"


           eennccooddee(_e_n_c_o_d_i_n_g_-_t_y_p_e, _a_r_g)
               This function converts _a_r_g, a string or bstring, into a
               printable text representation that depends on _e_n_c_o_d_i_n_g_-_t_y_p_e.
               Applying ddeeccooddee(())[40] with the same _e_n_c_o_d_i_n_g_-_t_y_p_e to the output
               of this function will produce a value equivalent to the
               original _a_r_g. The result is a string.

               Note that encoding is only a representational or formatting
               change. If secrecy, authentication, or verification of
               integrity are required, use a cryptographic method.

               The following encoding types are recognized:

               eennccooddee(ascii85, _a_r_g)
                   This encoding, also known as rraaddiixx--8855[41], uses nearly
                   every printable character to obtain a compact encoding. But
                   note that the resulting strings may be problematic in many
                   contexts without additional encoding, which can largely
                   defeat the reason for selecting this encoding in the first
                   place. The start-of-data ("<~") and end-of-data ("~>")
                   indicators that are sometimes used with this encoding are
                   not included.

                       > encode(ascii85, decode(hex, "123456789a"))
                       "&i<X6RK"


               eennccooddee(cescape, _a_r_g)
                   This encoding converts its argument into a C-style escaped
                   string. Character escape codes are used when possible,
                   numeric escape codes are used for other non-printable
                   characters, and all other characters map to themselves.

                       > encode(cescape, bstring("hi\0\1\2\3\012", 7))
                       "hi\0\001\002\003\n"


               eennccooddee(dacs64, _a_r_g)
                   This encoding type produces a base-64 encoding of _a_r_g using
                   upper- and lower-case alphabetics, digits, '-', and '_'. It
                   is similar to the mime encoding except that '-' and '_' are
                   used in the encoding character set instead of '+' and '/'.
                   This encoding is better suited for use in paths and URIs,
                   for example, and is used extensively within DDAACCSS. It is
                   sometimes referred to as "the dacs64 encoding" or just
                   "dacs64" in the DDAACCSS documentation.

                       > encode(dacs64, bstring("\0\0\0\1", 4))
                       "_____-"


               eennccooddee(hex, _a_r_g)
                   This encoding converts each byte in _a_r_g into a hexadecimal
                   character pair.

                       > encode(hex, "Hello")
                       "48656c6c6f"


               eennccooddee(mime, _a_r_g)
                   This encoding applies the MIME base-64 encoding function
                   (RRFFCC 22004455[42], Section 6.8) to its argument and returns the
                   result.

                       > encode(mime, bstring("\0\0\0\1", 4))
                       "AAAAAQ=="


               eennccooddee(url, _a_r_g)
                   This returns the URL-encoding of the argument (RRFFCC
                   11773388[43], RRFFCC 22339966[44] (Section 2.4), and RRFFCC 33998866[45]).

                       > encode(url, bstring("a\0b", 3))
                       "a%00b"



           eevvaall(_e_x_p_r_e_s_s_i_o_n)
               This function evaluates its string argument and returns the
               result.

               The call:

                   > eval("length(\"abc\")")
                   3

           eexxeecc(_p_r_o_g, _._._.)
               The eexxeecc function executes _p_r_o_g, waits (indefinitely) for it to
               terminate, and returns the program's standard output. A
               trailing newline in the output is deleted. Optionally, command
               line arguments to _p_r_o_g may be given; they are automatically
               converted to strings. By default, no environment variables are
               passed to the program; if the namespace _E_x_e_c_E_n_v exists,
               however, its contents are used as the executed program's
               environment variables. The exit status of _p_r_o_g is made
               available as the value of _$_{_D_A_C_S_:_:_s_t_a_t_u_s_}. The program is
               executed using the eexxeeccvv((33))[46] function, not a command shell.

               On POSIX systems, this call returns the string "1\n" on
               Thursdays, "0\n" on any other day:

                   > exec("/bin/sh", "-c", "date | grep -c ^Thu")
                   "0"



                   > ${ExecEnv::PATH} = "/usr/bin";
                   "/usr/bin"
                   > exec("/bin/sh", "-c", "printenv");
                   "PATH=/usr/bin"


                   SSeeccuurriittyy
                   The program is executed as the same user and group IDs as
                   the DDAACCSS program that calls eexxeecc(()). Take appropriate
                   precautions to prevent unauthorized users from modifying or
                   replacing DDAACCSS configuration files, access control rules,
                   and so on.

           eexxiitt(_r_e_s_u_l_t)
               Equivalent to rreettuurrnn, this function causes evaluation of the
               expression, block, or program being evaluated to terminate and
               returns _r_e_s_u_l_t as the value of the expression or the program's
               exit status.

           eexxppaanndd(_s_t_r_i_n_g)
               The argument, a string, is returned with variable references
               expanded. An undefined variable expands to the empty string.

                   > ${a} = 17
                   17
                   > "${a}"
                   "17"
                   > '${a}'
                   "${a}"
                   > expand('${a}')
                   "17"
                   > ${b} = 1999, ${c} = expand('${a}, \${b}')
                   "17, ${b}"
                   > expand(${c})
                   "17, 1999"


           ffiillee(_o_p [,_a_r_g_-_l_i_s_t])
               This function performs various operations on files and
               filenames according to _o_p, which is one of the following
               operation names, followed by command-specific arguments. All
               arguments must either be strings or literal words.

                1. file(basename, _s_t_r_i_n_g [,_s_u_f_f_i_x])

                   This is used to extract the last component of a pathname
                   and is equivalent to the bbaasseennaammee((11))[47] command. It
                   deletes any prefix that ends with the last slash character
                   in _s_t_r_i_n_g, after first stripping trailing slashes, and a
                   _s_u_f_f_i_x, if present. The _s_u_f_f_i_x is _n_o_t stripped, however, if
                   it is identical to the remaining characters in _s_t_r_i_n_g. A
                   non-existent suffix is ignored. The value is the resulting
                   string.

                       > file(basename,"/a/b/c")
                       "c"
                       > file(basename,"/a/b/c.c")
                       "c.c"
                       > file(basename,"/a/b/c.c", ".c")
                       "c"
                       > file(basename,"/a/b/c.c", "c")
                       "c."
                       > file(basename,"/a/b/c.c", "c.c")
                       "c.c"
                       > file(basename,"/a/b/c.c//", "c.c")
                       "c.c"


                2. file(chmod, _a_b_s_-_m_o_d_e, _f_i_l_e)

                   Change the mode of _f_i_l_e to _a_b_s_-_m_o_d_e, which is an absolute
                   (octal) file mode (note, however, that DDAACCSS always set the
                   process uummaasskk to 07).

                       file(chmod, "0755", "/usr/local/dacs/tmp/foofile")

                3. file(dirname, _s_t_r_i_n_g)

                   Equivalent to the ddiirrnnaammee((11))[48] command, its value is the
                   string that remains after deleting the filename portion of
                   _s_t_r_i_n_g (a pathname), beginning with the last slash
                   character to the end of _s_t_r_i_n_g, after first stripping
                   trailing slashes.

                       > file(dirname,"/usr/local/dacs/bin/dacsexpr")
                       "/usr/local/dacs/bin"
                       > file(dirname,"/usr/local/dacs///")
                       "/usr/local"


                4. file(extension, _p_a_t_h_n_a_m_e)

                   The returned value is all of the characters in _p_a_t_h_n_a_m_e
                   after and including the last dot in the last element. If
                   there is no dot in the last element of _p_a_t_h_n_a_m_e, the value
                   is the empty string.

                       > file(extension,"acl-myapp.0")
                       ".0"


                5. file(lstat, _f_m_t, _f_i_l_e)

                   This is like the ssttaatt[49] operation, except in the case
                   where the named file is a symbolic link, in which case
                   llssttaatt returns information about the link, while ssttaatt
                   returns information about the file the link references.

                6. file(mkdir, _d_i_r_e_c_t_o_r_y [,abs-mode])

                   Create _d_i_r_e_c_t_o_r_y. If an absolute (octal) mode is given, the
                   new directory will have that mode (note, however, that DDAACCSS
                   always set the process uummaasskk to 07).

                7. file(readlink, _f_i_l_e)

                   If _f_i_l_e is a symbolic link, print its contents.

                8. file(remove, _f_i_l_e)

                   Remove (delete) _f_i_l_e.

                9. file(rename, _s_o_u_r_c_e_-_f_i_l_e, _t_a_r_g_e_t_-_f_i_l_e)

                   Rename (mv) _s_o_u_r_c_e_-_f_i_l_e to _t_a_r_g_e_t_-_f_i_l_e.

               10. file(rmdir, _d_i_r_e_c_t_o_r_y)

                   Remove (delete) _d_i_r_e_c_t_o_r_y, which must be empty.

               11. file(stat, _f_m_t, _f_i_l_e)

                   Similar to the ssttaatt((11))[50] command available on some
                   systems, this makes the functionality of the ssttaatt((22))[51]
                   system call available. The _f_m_t argument is a
                   pprriinnttff((33))[52]-type descriptor that indicates what file
                   status information is wanted and how it is to be printed.
                   Non-formatting characters, including \n, \t, and \\, are
                   copied to the output verbatim.

                   The following format specifiers are understood:

                   +o   %d

                       The value of _s_t___d_e_v.

                   +o   %i

                       The value of _s_t___i_n_o.

                   +o   %m

                       The value of _s_t___m_o_d_e in octal.

                   +o   %M

                       The value of _s_t___m_o_d_e as text.

                   +o   %l

                       The value of _s_t___n_l_i_n_k.

                   +o   %u

                       The value of _s_t___u_i_d in decimal.

                   +o   %U

                       The value of _s_t___u_i_d as text.

                   +o   %g

                       The value of _s_t___g_i_d in decimal.

                   +o   %G

                       The value of _s_t___g_i_d as text.

                   +o   %r

                       The value of _s_t___r_d_e_v.

                   +o   %s

                       The value of _s_t___s_i_z_e.

                   +o   %b

                       The value of _s_t___b_l_k_s_i_z_e.

                   +o   %n

                       The value of the _f_i_l_e argument.

                   +o   %N

                       If the argument is a symbolic link, print the contents
                       of the link, otherwise print the _f_i_l_e argument.

                   +o   %ta

                       The value of _s_t___a_t_i_m_e in decimal.

                   +o   %tA

                       The value of _s_t___a_t_i_m_e as text.

                   +o   %tm

                       The value of _s_t___m_t_i_m_e in decimal.

                   +o   %tM

                       The value of _s_t___m_t_i_m_e as text.

                   +o   %tc

                       The value of _s_t___c_t_i_m_e in decimal.

                   +o   %tC

                       The value of _s_t___c_t_i_m_e as text.

                   +o   %f

                       The name of the host (fileserver) where the file is
                       stored.

                   +o   %%

                       A literal '%' character.

                       This excerpt from an access control rule limits access
                       to authenticated users for every file greater than 999
                       bytes in length that it DDAACCSS-wraps:

                           <allow>
                             user("auth")
                           </allow>

                           <allow>
                             user("any") and file(stat, "%s", ${DACS::FILENAME}) lt 1000
                           </allow>


                   12. file(test, _o_p [, _a_r_g_s])

                       Most of the file-testing predicates of the tteesstt((11))[53]
                       command are available.

                       +o   --bb  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a block special file.

                       +o   --cc  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a character special
                           file.

                       +o   --dd  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a directory.

                       +o   --ee  _f_i_l_e

                           TTrruuee if _f_i_l_e exists, regardless of its type.

                       +o   --ff  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a regular file.

                       +o   --gg  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and its set group ID flag is
                           set.

                       +o   --kk  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and its sticky bit is set.

                       +o   --pp  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a named pipe (FIFO).

                       +o   --rr  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is readable (access(file,
                           R_OK) == 0).

                       +o   --ss  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and has a size greater than
                           zero bytes.

                       +o   --uu  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and its set user ID flag is
                           set.

                       +o   --ww  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is writable (access(file,
                           W_OK) == 0).

                       +o   --xx  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is executable (access(file,
                           X_OK) == 0).

                       +o   --LL  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a symbolic link.

                       +o   --OO  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and its owner matches the
                           effective user id of this process.

                       +o   --GG  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and its group matches the
                           effective group id of this process.

                       +o   --SS  _f_i_l_e

                           TTrruuee if _f_i_l_e exists and is a socket.

                       +o   --nntt  _f_i_l_e_1 _f_i_l_e_2

                           TTrruuee if _f_i_l_e_1 and _f_i_l_e_2 exist and the former is
                           newer than the latter.

                       +o   --oott  _f_i_l_e_1 _f_i_l_e_2

                           TTrruuee if _f_i_l_e_1 and _f_i_l_e_2 exist and the former is
                           older than the latter.

                       +o   --eeff  _f_i_l_e_1 _f_i_l_e_2

                           TTrruuee if _f_i_l_e_1 and _f_i_l_e_2 exist and refer to the same
                           file.

                   13. file(touch, _f_i_l_e [, _a_b_s_-_m_o_d_e])

                       If _f_i_l_e does not exist, it is created; if an absolute
                       (octal) mode is given, the new file will have that mode
                       (note, however, that DDAACCSS always set the process uummaasskk
                       to 07). If the file exists, its modification time will
                       be set to the current date and time.

                   ffiillee__ggrroouupp([_p_a_t_h])
                       Test if _p_a_t_h (defaults to _$_{_D_A_C_S_:_:_F_I_L_E_N_A_M_E_}, which is
                       equivalent to Apache's SSCCRRIIPPTT__FFIILLEENNAAMMEE or
                       _R_E_Q_U_E_S_T___F_I_L_E_N_A_M_E variables) has a group ownership with
                       which the user making the request is associated. This
                       is effectively the same as:

                           file(test, "-e", ${DACS::FILENAME})
                           and
                           user("%" . ${Conf::JURISDICTION_NAME} . ":" \
                             . file(stat, "%G", ${DACS::FILENAME}))

                       This predicate provides a simple way of limiting access
                       to a file to its group membership with respect to file
                       system permissions:

                           <allow>
                             file_group()
                           </allow>

                       For example, if the user requesting access has been
                       assigned the following roles by the current
                       jurisdiction (e.g., through llooccaall__uunniixx__rroolleess):

                           wheel,www,users

                       and the resource being requested is the file:

                           -rw-r--r--  1 bobo     www  75 Apr 11 12:41 htdocs/foo.html

                       then this predicate would return TTrruuee because the file
                       has group ownership www and the user is associated with
                       that role.

                       There is an implicit assumption that the file in
                       question is associated with the current jurisdiction;
                       this might be problematic if more than one jurisdiction
                       can claim this association.

                   ffiillee__oowwnneerr([_p_a_t_h])
                       Test if _p_a_t_h (defaults to _$_{_D_A_C_S_:_:_F_I_L_E_N_A_M_E_}, which is
                       equivalent to Apache's SSCCRRIIPPTT__FFIILLEENNAAMMEE or
                       _R_E_Q_U_E_S_T___F_I_L_E_N_A_M_E variables) is owned by the user making
                       the request. This is effectively the same as:

                           file(test, "-e", ${DACS::FILENAME})
                           and
                           user(${Conf::JURISDICTION_NAME} . ":" . file(stat, "%U", ${DACS::FILENAME}))

                       This predicate provides a simple way of limiting access
                       to a file to its owner with respect to file system
                       permissions:

                           <allow>
                             file_owner()
                           </allow>

                       There is an implicit assumption that the file in
                       question is associated with the current jurisdiction;
                       this might be problematic if more than one jurisdiction
                       can claim this association.

                   ffrroomm(_s_t_r_i_n_g)
                       This predicate is used to test where a request comes
                       from, based on the values of RREEMMOOTTEE__AADDDDRR and
                       RREEMMOOTTEE__HHOOSSTT. These environment variables are passed to
                       DDAACCSS from AAppaacchhee. The supported argument types are
                       similar to those recognized by the AAppaacchhee
                       mmoodd__aacccceessss[54] module's allow and deny directives. If
                       either RREEMMOOTTEE__HHOOSSTT or RREEMMOOTTEE__AADDDDRR are needed to
                       evaluate the argument but are not available, the result
                       will be FFaallssee.

                       The string argument may be:

                        1. a full or partially matching domain name:

                               from("metalogic.example.com")

                           Here, the function yields TTrruuee if the given domain
                           name matches RREEMMOOTTEE__HHOOSSTT or is a subdomain of
                           RREEMMOOTTEE__HHOOSSTT. Case-insensitive matching is performed
                           (RRFFCC 11003355[55]). Only complete components are
                           matched, so the above example will match
                           foo.metalogic.example.com but not
                           foonmetalogic.example.com. If RREEMMOOTTEE__AADDDDRR is
                           available but not RREEMMOOTTEE__HHOOSSTT, a reverse DNS lookup
                           will be performed on the domain name and all IP
                           addresses that result will be tested against
                           RREEMMOOTTEE__AADDDDRR; if this lookup results in an error
                           (i.e., it fails), then the function raises an error
                           condition.

                        2. a full IPv4 address in standard dot notation:

                               from("10.0.0.123")

                        3. a partial IPv4 address (the first one, two, or
                           three bytes) in standard dot notation:

                               from("10.0")

                        4. a network/netmask pair:

                               from("10.0.0.0/255.255.0.0")

                        5. a network/nnn pair using CCIIDDRR nnoottaattiioonn[56] (RRFFCC
                           11333388[57]):

                               from("10.0.0.0/8")

                        6. a full or partial IPv4 address in standard dot
                           notation where any address element can be a decimal
                           number (0 through 255) or a rraannggee
                           ssppeecciiffiiccaattiioonn[58], similar to that used with
                           ssttrrcchhaarrss(())[15]; note that the range separator in
                           this context is ":" instead of "..": :

                               from("10.0.[0:100,255]")

                           In the example above, the two high-order octets of
                           _$_{_D_A_C_S_:_:_R_E_M_O_T_E___A_D_D_R_} must be 10 and 0, the value of
                           the next octet must be between 0 and 100
                           (inclusive) or be 255 (decimal), and the value of
                           the fourth octet is unimportant. The following
                           expressions are equivalent:

                               from("10")
                               from("10.")
                               from("[10]")
                               from("[10].")
                               from("10.0.0.0/8")
                               from("10.0.0.0/255.0.0.0")


                        7. "all" (always yields TTrruuee and is included for
                           compatibility with AAppaacchhee):

                               from("all")
                           An alternative method is to perform a regular
                           expression match against _$_{_D_A_C_S_:_:_R_E_M_O_T_E___A_D_D_R_} using
                           rreeggmmaattcchh(())[59].

                               TTiipp
                               To test where a client authenticated from,
                               which is not necessarily the same as the place
                               from which a request is sent, use the
                               uusseerr(())[60] function.

                       ggeett(_v_f_s_-_r_e_f [,_k_e_y])
                           The file or item specified by _v_f_s_-_r_e_f, which may be
                           followed by a _k_e_y if it is an indexed filestore, is
                           read and returned. The _v_f_s_-_r_e_f may be an absolute
                           pathname, an item type, or a vvffss__uurrii[61], except if
                           called from a standalone application without a _k_e_y
                           argument, in which case _v_f_s_-_r_e_f may also be a
                           relative pathname.

                               NNoottee
                               A proper I/O subsystem does not exist yet, but
                               until then you may use the special item type
                               stdin to read the standard input until end of
                               file. This function will probably not work if a
                               special file is used (e.g., /dev/stdin).

                       hhaasshh(_m_s_g, _m_s_g_-_l_e_n [,_h_a_s_h_-_n_a_m_e])
                           This function computes a fast hash of _m_s_g, a string
                           or bstring. The _m_s_g_-_l_e_n is the length of _m_s_g in
                           bytes; if it is 0, its length is computed. The
                           _h_a_s_h_-_n_a_m_e can be the 32-bit hash "hash32" (the
                           default) or the 64-bit hash "hash64". The result is
                           a string. Although the algorithms have been used
                           extensively with very good results, they should not
                           be used for cryptographic purposes; see
                           ddiiggeesstt(())[62].

                               > hash("Hello, world", 0)
                               "3696529580"
                               > hash("Hello, world", 0, hash64)
                               "462009511995194717"


                       hhmmaacc(_m_s_g, _m_s_g_-_l_e_n, _k_e_y, _k_e_y_-_l_e_n [, _d_i_g_e_s_t_-_n_a_m_e])
                           This function computes a cryptographic mmeessssaaggee
                           aauutthheennttiiccaattiioonn ccooddee[63] - specifically, the
                           KKeeyyeedd--HHaasshh MMeessssaaggee AAuutthheennttiiccaattiioonn CCooddee ((HHMMAACC))[64] -
                           of _m_s_g (a string or bstring), using _k_e_y (a string
                           or bstring). The _m_s_g_-_l_e_n is the length of _m_s_g in
                           bytes; if it is 0, its length is computed.
                           Similarly, _k_e_y_-_l_e_n is the length of _k_e_y in bytes
                           and if it is 0, its length is computed. Any of the
                           available SSeeccuurree HHaasshh SSttaannddaarrdd ffuunnccttiioonnss[65], as
                           well as MMDD55 ((RRFFCC 22110044))[66], may be specified as
                           _d_i_g_e_s_t_-_n_a_m_e (case insensitively), otherwise SHA1 is
                           used. The list of available digest algorithms is
                           subject to change, but is likely to include md5,
                           sha1, sha224, sha256, sha384, and sha512. The
                           function value is a bstring. Note that the function
                           is not commutative; the key is the third argument,
                           not the first. Although the MD5 hash function is
                           deprecated for some purposes, it is still
                           considered adequate in some applications and is
                           required by many older protocols that are still in
                           widespread use.

                               > hmac("Sample #2", 0,
                                 decode(hex, "303132333435363738393a3b3c3d3e3f40414243"), 0)
                               "0922d3405faa3d194f82a45830737d5cc6c75d24"


                       hhttttpp(_u_r_l, [_m_e_t_h_o_d [,_a_r_g_l_i_s_t]])
                           This function sends an HTTP request to _u_r_l, using a
                           given method (GET, POST, HEAD, PUT, DELETE, or
                           OPTIONS, case insensitively), and optionally
                           passing parameters. If no method is given (and no
                           arguments), GET is assumed. The value of the
                           function is the message returned by the request.
                           The _u_r_l is in the usual syntax and must use either
                           the http or https scheme (case insensitive). The
                           argument list, if present, consists of some number
                           of pairs, the first being the name of the parameter
                           and the second the value of the parameter.

                           The first statement sends an HTTP request to
                           example.com and sets the variable to the message
                           body (if any) that is returned. The second
                           statement makes a GET request to port 8443 of
                           example.com over SSL, passing it two parameters,
                           FOO=17 and FOO=2:

                               > ${x} = http("http://example.com")
                               > http("https://example.com:8443/cgi-bin/dacs_prenv.cgi", "GET", "FOO", 17,
                                     "BAZ", 1+1)


                       iinnddeexx(_s_t_r_i_n_g, _c_h_a_r_a_c_t_e_r_-_c_l_a_s_s [, nocase])
                       iinnddeexx(_l_i_s_t, _s_e_a_r_c_h___o_p_e_r_a_n_d [, nocase])
                           If the first argument is a string, this function
                           returns the first position in _s_t_r_i_n_g (counting from
                           1) where the first character in _c_h_a_r_a_c_t_e_r_-_c_l_a_s_s was
                           found, or 0. Case-sensitive character comparison is
                           used unless the optional _n_o_c_a_s_e literal argument is
                           present.

                           If the first argument is a list, the position of
                           element _s_e_a_r_c_h___o_p_e_r_a_n_d (counting from 1) in _l_i_s_t is
                           returned, or 0 if it is not found. During
                           comparison, types are automatically converted as
                           necessary. Case-sensitive character comparison is
                           used unless the optional _n_o_c_a_s_e literal argument is
                           present.

                           Examples:

                               > index("abcdef", "abc")
                               1
                               > index("abcdef", "e")
                               5
                               > index("zzz", "abc")
                               0
                               > index([a, b, c, d, e], d)
                               4
                               > index(["hello", world, 2009, qUAKe], "quake", nocase)
                               4
                               > index([1.0, 2.2, 3.3, 4.4, 5.0, 6.6], "1")
                               1
                               > index(["apple", ["orange", "banana"], ["peach", "mango"]], "orange")
                               0
                               > index(["apple", ["orange", "banana"], ["peach", "mango"]], ["orange", "banana"])
                               2


                       iinnffoo(namespaces)
                       iinnffoo(namespace, _n_a_m_e_s_p_a_c_e_-_n_a_m_e)
                           Return a string containing information about
                           variables and namespaces. The first form returns a
                           comma-separated list of known namespaces. The
                           second form returns a list containing all variables
                           in the given namespace and their values, one per
                           line. This can be useful for debugging.

                           Examples:

                               info(namespaces)
                               info(namespace, "Conf")


                       kkeeyyssooff(_a_l_i_s_t)
                           If its argument is a single pair, the pair's key is
                           returned. If there is more than one pair in the
                           argument, a list of keys is returned. To get the
                           value component of a pair or set of pairs, use
                           vvaalluueessooff(())[18].

                           Examples:

                               > keysof({red, 17})
                               "red"
                               > keysof({red, 17, blue, 100})
                               ["red", "blue"]


                       llddaapp(dn_length, _d_n_-_s_t_r_i_n_g)
                       llddaapp(dn_index, _d_n_-_s_t_r_i_n_g, _n_t_h)
                       llddaapp(rdn_length, _r_d_n_-_s_t_r_i_n_g)
                       llddaapp(rdn_index, _r_d_n_-_s_t_r_i_n_g, _n_t_h)
                       llddaapp(rdn_attrtype, _r_d_n_-_s_t_r_i_n_g [, _n_t_h])
                       llddaapp(rdn_attrvalue, _r_d_n_-_s_t_r_i_n_g [, _n_t_h])
                           The llddaapp function is used to extract components of
                           LDAP names. Its first argument, a literal,
                           determines the operation mode to be used and the
                           semantics of the following arguments. Distinguished
                           Name (DN) and Relative Distinguished Name (RDN)
                           strings are as defined in RRFFCC 22225533[67].

                           The dn_length mode returns the number of RDN
                           components in its DN argument; -1 is returned if
                           the argument is not a valid DN. The dn_index mode
                           returns the _n_t_h RDN component of the DN, where _n_t_h
                           is an integer greater than zero. If _n_t_h is greater
                           than the number of components, the last component
                           is returned.

                           The rdn_length mode returns the number of
                           AttributeTypeAndValue elements in its RDN argument;
                           -1 is returned if the argument is not a valid RDN.
                           The rdn_index mode returns the _n_t_h
                           AttributeTypeAndValue component of the RDN, where
                           _n_t_h is an integer greater than zero. If _n_t_h is
                           greater than the number of components, the last
                           component is returned.

                           The rdn_attrtype mode returns the AttributeType of
                           the _n_t_h AttributeTypeAndValue component of the RDN,
                           where _n_t_h is an integer greater than zero. If _n_t_h
                           is missing, it is taken to be 1. If _n_t_h is greater
                           than the number of components, the last component
                           is selected. The rdn_attrvalue mode is similar
                           except that it returns the AttributeValue.

                           The first and second expressions below return 2,
                           the third expression returns Administrator:

                               ldap(dn_length, "dc=example,dc=com")
                               ldap(rdn_length, "foo=bar+bar=baz")
                               ldap(rdn_attrvalue, ldap(dn_index, \
                                   "CN=Administrator,CN=Users,DC=example,DC=com", 1))


                       lleennggtthh(_s_t_r_i_n_g)
                       lleennggtthh(_b_s_t_r_i_n_g)
                       lleennggtthh(_l_i_s_t)
                       lleennggtthh(_a_l_i_s_t)
                           This function returns the length, in characters, of
                           _s_t_r_i_n_g, the number of bytes in binary string
                           _b_s_t_r_i_n_g, the number of elements in _l_i_s_t, or the
                           number of pairs in _a_l_i_s_t.

                       lliisstt([_v_a_l_u_e [, ...])
                           This function is equivalent to the lliisstt
                           ccoonnssttrruuccttiioonn ooppeerraattoorr[68].

                               list(1, 2, [hello, world], 5)

                           is equivalent to the expression:

                               [1, 2, [hello, world], 5]


                       lliissttrreeff(_l_i_s_t, _l_i_s_t_-_r_e_f [, ...])
                           This function provides an alternate syntax to the
                           language's list/array notation. For example, the
                           function call:

                               listref([1, 2, [3, 4], 5], 2, 1)

                           is equivalent to the expression:

                               [1, 2, [3, 4], 5][2][1]

                           Note that a list reference may follow a list-valued
                           expression (e.g., a list constructor, a list-valued
                           variable, a function that returns a list) this
                           syntax is valid:

                               ($a . $b)[0]

                           The parentheses are necessary here because the
                           subscript binds more tightly than the concatenation
                           operator. This expression can also be written as:

                               listref($a . $b, 0)


                       oonn__ssuucccceessss(_l_i_s_t_-_n_a_m_e [, _e_x_p_r])
                           The _l_i_s_t_-_n_a_m_e argument must be either acs or auth
                           (case insensitive) to select the post-authorization
                           list or the post-authentication list, respectively.
                           For the former case, if authorization is
                           successful, the _e_x_p_r argument (a string) will be
                           evaluated by ddaaccss__aaccss immediately after any
                           AACCSS__SSUUCCCCEESSSS[30] directive, and just prior to
                           program termination. These expressions are not
                           evaluated if authorization is denied, an
                           authorization processing error occurs, or a
                           _D_A_C_S___A_C_S argument prevents execution of the
                           request. For the latter case, if authentication is
                           successful, the _e_x_p_r argument (a string) will be
                           evaluated by ddaaccss__aauutthheennttiiccaattee((88))[8] immediately
                           after any AAUUTTHH__SSUUCCCCEESSSS[29] directive, and just
                           prior to program termination. These expressions are
                           not evaluated if authentication fails or an
                           authentication processing error occurs.

                           Once added to either list, an entry cannot be
                           removed. The expressions are evaluated in the order
                           in which oonn__ssuucccceessss(()) was called. The values
                           returned by the expressions are discarded and
                           errors are ignored.

                           If no _e_x_p_r is given, the current list of
                           expressions is returned, one per line, in order of
                           evaluation. With an expression argument, it returns
                           the number of expressions in the list after any
                           addition.

                       ppaasssswwoorrdd(_o_p [, _o_p_-_a_r_g_s])
                           This function performs a variety of read-only
                           operations on DDAACCSS accounts and their passwords.
                           See ddaaccssppaasssswwdd((11))[69] and directives
                           PPAASSSSWWOORRDD__DDIIGGEESSTT[70] and PPAASSSSWWOORRDD__SSAALLTT__PPRREEFFIIXX[71]
                           for additional information.

                           The following operations are available:

                           ppaasssswwoorrdd(check, _g_i_v_e_n_-_p_a_s_s_w_o_r_d, _p_a_s_s_w_o_r_d_-_d_i_g_e_s_t
                           [,_a_l_g_-_n_a_m_e])
                               With the check operation, the digest of
                               _g_i_v_e_n_-_p_a_s_s_w_o_r_d is computed (as computed by the
                               hash operation) and compared to
                               _p_a_s_s_w_o_r_d_-_d_i_g_e_s_t, which was previously generated
                               by the hash operation of this function,
                               retrieved by the getdigest operation, or
                               obtained using ddaaccssppaasssswwdd. This algorithm is
                               identical to the one used by
                               llooccaall__ppaasssswwdd__aauutthheennttiiccaattee[72] to validate
                               passwords. If _a_l_g_-_n_a_m_e is given, it names the
                               digest algorithm to use instead of the one
                               specified within _p_a_s_s_w_o_r_d_-_d_i_g_e_s_t. If
                               _g_i_v_e_n_-_p_a_s_s_w_o_r_d is correct (i.e., the same
                               passwords were used to generate the two digest
                               values), TTrruuee (1) is returned, otherwise FFaallssee
                               (0) is returned.

                           ppaasssswwoorrdd(getdata, _u_s_e_r_n_a_m_e [,_v_f_s_-_r_e_f])
                               The getdata operation returns the private data
                               associated with the account for _u_s_e_r_n_a_m_e. The
                               result is a bstring. If there is no private
                               data, the length of the result will be zero
                               (the length of the empty string is one). If a
                               _v_f_s_-_r_e_f is given, it identifies the virtual
                               filestore to use, otherwise the item type
                               passwds is used. It is an error if the account
                               does not exist, so a test operation will often
                               be performed first.

                           ppaasssswwoorrdd(getdigest, _u_s_e_r_n_a_m_e [,_v_f_s_-_r_e_f])
                               The getdigest operation is similar to getdata
                               except that the digest string for the account
                               is returned; this digest string can be used
                               with the check operation.

                           ppaasssswwoorrdd(hash, _p_l_a_i_n_-_p_a_s_s_w_o_r_d [,_a_l_g_-_n_a_m_e])
                               With the hash operation, a digest of the string
                               _p_l_a_i_n_-_p_a_s_s_w_o_r_d is returned as a printable
                               string. The password hashing algorithm is
                               identical to the one used by ddaaccssppaasssswwdd((11))[69].
                               If _a_l_g_-_n_a_m_e is given (see ddiiggeesstt(())[62]), it
                               names the digest algorithm to use instead of
                               the configured default.

                           ppaasssswwoorrdd(list [, _v_f_s_-_r_e_f])
                               The list operation returns a list of account
                               names, one per line. An empty string is
                               returned if there are no accounts. If a _v_f_s_-_r_e_f
                               is given, it identifies the virtual filestore
                               to use, otherwise the item type passwds is
                               used. To test if a password file exists, use
                               vvffss(())[73].

                           ppaasssswwoorrdd(syntax, _p_a_s_s_w_o_r_d [,_c_o_n_s_t_r_a_i_n_t_s])
                               The syntax operation tests if _p_a_s_s_w_o_r_d
                               satisfies the _c_o_n_s_t_r_a_i_n_t_s argument, if
                               provided, otherwise the value of the
                               PPAASSSSWWOORRDD__CCOONNSSTTRRAAIINNTTSS[74] directive. The
                               _c_o_n_s_t_r_a_i_n_t_s are specified in the same syntax as
                               the PASSWORD_CONSTRAINTS directive. The
                               function returns TTrruuee (1) if the constraints
                               are satisfied, otherwise FFaallssee (0).

                           ppaasssswwoorrdd(test, _t_e_s_t_-_o_p, _u_s_e_r_n_a_m_e [,_v_f_s_-_r_e_f])
                               The test operation applies _t_e_s_t_-_o_p to the
                               account entry for _u_s_e_r_n_a_m_e in the virtual
                               filestore _v_f_s_-_r_e_f (or item type passwds). It is
                               an error if the password file does not exist or
                               is unreadable. It returns TTrruuee if the test is
                               successful, otherwise the result is FFaallssee. The
                               recognized values of _t_e_s_t_-_o_p are (case
                               insensitively): data (to test if the account
                               exists and has private data), disabled (to test
                               if the account exists and is disabled), enabled
                               (to test if the account exists and is enabled),
                               or exists (to test if the account exists).

                           Examples:

                               > password(hash, "bobo")
                               "2|XYZZYxBhU/7VgJAt2lc.G|HL4RQ2vo0uNoXlXnv.GcY3Vlf9."
                               > password(check, "bobo", "2|XYZZYxBhU/7VgJAt2lc.G|HL4RQ2vo0uNoXlXnv.GcY3Vlf9.")
                               1


                       ppaatthhnnaammee(_p_a_t_h, _h_o_s_t_n_a_m_e, _p_o_r_t)
                           Perform string interpolation on _p_a_t_h based on the
                           other arguments. For details, please see
                           ddaaccss..ccoonnff((55))[75] (where _h_o_s_t_n_a_m_e is SSEERRVVEERR__NNAAMMEE).

                       ppbbkkddff22(_p_a_s_s_w_o_r_d, _s_a_l_t, _c_o_u_n_t, _d_k_l_e_n)
                           Apply a pseudorandom function (HMAC-SHA-1) to
                           _p_a_s_s_w_o_r_d and _s_a_l_t (both binary strings, or
                           converted as required), modified by _c_o_u_n_t
                           iterations, returning a binary string of length
                           _d_k_l_e_n bytes. For details, please see RRFFCC 22889988[76]
                           and RRFFCC 33996622[77].

                               > pbkdf2("password", "ATHENA.MIT.EDUraeburn", 1200, 32)
                               "5c08eb61fdf71e4e4ec3cf6ba1f5512ba7e52ddbc5e5142f708a31e2e62b1e13"
                               > pbkdf2("password", decode(hex,"1234567878563412"), 5, 16)
                               "d1daa78615f287e6a1c8b120d7062a49"


                       pprriinntt(_._._.)
                           Each argument is converted to a string, the strings
                           are concatenated, a newline is appended, and the
                           result is printed. The return type is void. If
                           called from ddaaccsseexxpprr((11))[1], the string is printed
                           to the standard output; otherwise, it is printed to
                           the DDAACCSS log file (or stderr), which can be useful
                           for debugging purposes. These log messages are
                           associated with the user class (see the
                           LLOOGG__FFIILLTTEERR[78] directive).

                       pprriinnttff(_f_m_t, _._._.)
                           This is a slightly scaled-down version of the
                           pprriinnttff((33))[52] library function. If called from
                           ddaaccsseexxpprr((11))[1], the string is printed to the
                           standard output; otherwise, it is printed to the
                           DDAACCSS log file (or stderr), which can be useful for
                           debugging purposes. These log messages are
                           associated with the user class (see the
                           LLOOGG__FFIILLTTEERR[78] directive). This can be useful for
                           debugging purposes. If necessary and possible,
                           arguments are converted to the type requested by a
                           formatting specification. The return type is void.

                       rraannddoomm(bytes, _n_b_y_t_e_s)
                       rraannddoomm(uint, _l_o, _h_i)
                       rraannddoomm(string, _n_b_y_t_e_s [, _s_p_e_c])
                       rraannddoomm(stringc, _n_b_y_t_e_s, _s_p_e_c)
                           The various forms of this function, distinguished
                           by the first argument, return ccrryyppttooggrraapphhiiccaallllyy
                           ssttrroonngg ppsseeuuddoo--rraannddoomm vvaalluueess[79] in various formats.
                           The starting point (seed value) for the
                           pseudo-random sequence cannot be set, meaning that
                           the sequence cannot be (intentionally) reproduced.

                           The bytes operation requests _n_b_y_t_e_s bytes of random
                           material. The result is a bstring of that length.

                           The uint operation requests an unsigned random
                           integer between _l_o and _h_i (both unsigned integers),
                           inclusive. It is an error if _l_o is not greater than
                           _h_i. The result is an (unsigned) integer.

                           The string operation requests _n_b_y_t_e_s of random
                           material, returned as a hex-encoded string. If a
                           _s_p_e_c argument is present, it uses the character
                           specification syntax of ssttrrttrr(())[80] to indicate the
                           characters that can be used to encode the result.
                           Only printable characters, excluding the space, are
                           allowed in the result, regardless of the _s_p_e_c
                           argument. Example:

                               > random(string,12,"a-zA-Z0-9")
                               "LgROshy6SMMH"
                               > random(string,12,"a-z")
                               "kehhvwydhhbk"

                           The functionality of the stringc operation is
                           identical to that of the three-argument instance of
                           the string operation except that the sense of the
                           _s_p_e_c argument is complemented to indicate those
                           characters that may _n_o_t be used in the encoding of
                           the result.

                       rreeddiirreecctt(_e_r_r_o_r_-_c_o_d_e, _t_a_r_g_e_t)
                       rreeddiirreecctt(_t_a_r_g_e_t)
                           Permitted only within the context of an access
                           control rule's deny clause, this function causes
                           expression evaluation and rule processing to stop
                           immediately, access to be denied, and the client to
                           be redirected to _t_a_r_g_e_t, a URL that may contain a
                           query component. If the _e_r_r_o_r_-_c_o_d_e is present, it
                           must be an ACS error name or number (see the
                           AACCSS__EERRRROORR__HHAANNDDLLEERR[81] directive), otherwise
                           "BY_REDIRECT" is used.

                               NNoottee
                               The URL must be properly escaped if it appears
                               within an XML document, such as an access
                               control rule; for example, if an ampersand
                               occurs in the query component in a context
                               where it must be escaped, it must appear as the
                               five characters "&amp;".
                           The _t_a_r_g_e_t string is expected to have one of the
                           syntaxes of the document component of AAppaacchhee''ss
                           EErrrroorrDDooccuummeenntt ddiirreeccttiivvee[82]. In essence, this
                           function causes an ACS_ERROR_HANDLER directive to
                           be created and triggered. The function returns the
                           _t_a_r_g_e_t string, although because of the function's
                           run time behaviour the value cannot be used.

                               TTiipp
                               One application of this function is to create a
                               short link, which is a relatively concise URL
                               that acts as an "alias" for another, usually
                               much longer URL (here, the _t_a_r_g_e_t). The short
                               link is made public. It must be DDAACCSS-wrapped;
                               the _t_a_r_g_e_t does not need to be. Any attempt to
                               access the short link is denied by its rule,
                               but the rule uses the rreeddiirreecctt(()) function,
                               probably with BY_SIMPLE_REDIRECT as the
                               _e_r_r_o_r_-_c_o_d_e (see ddaaccss..ccoonnff((55))[81]), to redirect
                               the user agent to the _t_a_r_g_e_t.

                               The following rule demonstrates how this can be
                               done:

                                   <acl_rule status="enabled">
                                    <services>
                                     <service url_pattern="/id/*"/>
                                    </services>

                                    <rule order="allow,deny">
                                     <deny>
                                       setvar(split, "X", ${Env::REQUEST_URI}, "/");
                                       ${x} = var(get, X, ${X::#} - 1);
                                       redirect(BY_SIMPLE_REDIRECT, "https://example.com/docs/${x}.html");
                                     </deny>
                                    </rule>
                                   </acl_rule>

                               With this rule in place, a request like:

                                   https://example.com/id/17795821

                               would result in a redirect to this target:

                                   https://example.com/docs/17795821.html

                               The target URL can depend on contextual
                               elements, and it is straightforward to do
                               things like make the target URL depend on the
                               time of day, identity of the user, and so on.
                               The technique can also be used with RRlliinnkkss[83].

                               Because the rule associated with the short link
                               can be changed at any time, this feature can be
                               used to implement smart ppeerrmmaalliinnkkss[84].

                       rreeggmmaattcchh(_s_t_r_i_n_g, _r_e_g_e_x [, _n_a_m_e_s_p_a_c_e] [, nocase])
                           This is a pattern matching function. The first two
                           arguments are coerced to strings, with the second
                           one taken to be the regular expression, with a "^"
                           (the start-of-string anchor) implicitly prepended.
                           The _s_t_r_i_n_g argument is then matched against the
                           regular expression, which may contain
                           subexpressions enclosed between '(' and ')' (or
                           '\(' and '\)'). If the match fails, the result is
                           0. If the match succeeds there are several
                           possibilities:

                           +o   if there are no subexpressions in _r_e_g_e_x, the
                               result is an integer that is the number of
                               characters matched.

                           +o   if there is at least one subexpression in _r_e_g_e_x
                               but no _n_a_m_e_s_p_a_c_e (a string argument) is given,
                               the result is the substring of _s_t_r_i_n_g that was
                               matched by the entire regular expression.

                           +o   if there is at least one subexpression in _r_e_g_e_x
                               and a namespace argument is given, the result
                               is an integer that is the number of characters
                               matched by the entire regular expression. The
                               value of the first matching subexpression is
                               assigned to the variable named "_1" in the
                               namespace, the value of the second
                               subexpression is assigned to a variable named
                               "_2" in the namespace, and so on up to the ninth
                               subexpression. The variable named "_0" in the
                               namespace is assigned the substring of string
                               that was matched by the entire regular
                               expression. Following function evaluation in
                               the context of ACL rule processing, _n_a_m_e_s_p_a_c_e
                               is accessible only within the predicate, allow,
                               or deny element in which it appears.
                               If the optional _n_o_c_a_s_e literal argument is
                               given, then matching is done
                               case-insensitively. Only one parenthesized pair
                               can be used. IEEE Std 1003.2 ("POSIX.2")
                               "extended" regular expressions are supported
                               (rreeggeexx((33))[85], rree__ffoorrmmaatt((77))[86]).

                               Examples:

                                   > ${X} = "abfoo"
                                   "abfoo"
                                   > regmatch(${X}, ".*foo", nocase)
                                   5
                                   > regmatch("abcdefgzz", "(.*)g")
                                   "abcdefg"
                                   > regmatch("foo", "(bar)|(baz)|(foo)")
                                   "foo"
                                   > regmatch("abcdefgzz", "ab(.*)efg(.*)", "x")
                                   9
                                   > ${x::0}
                                   "abcdefgzz"
                                   > ${x::1}
                                   "cd"
                                   > ${x::2}
                                   "zz"
                                   > $addr = "192.168.7.3"
                                   "192.168.7.3"
                                   > regmatch($addr, "192\\.168\\.(.*)\\..*", "X")
                                   11
                                   > ${X::1}
                                   "7"


                           rreeggssuubb(_s_t_r_i_n_g, _r_e_g_e_x, _r_e_p_l_a_c_e_m_e_n_t [,nocase]
                           [,repeat])
                               This function matches _r_e_g_e_x against _s_t_r_i_n_g,
                               like rreeggmmaattcchh(())[59] does, and returns the
                               string that results when the substitution
                               specified by _r_e_p_l_a_c_e_m_e_n_t is applied to the
                               matched text. This is similar to the eedd/vvii/sseedd
                               command "s/regex/replacement/" applied to
                               _s_t_r_i_n_g. If no match is found, the empty string
                               is returned.

                               The optional _r_e_p_e_a_t literal argument causes the
                               replacement to be applied to all matches; i.e.,
                               like the eedd/vvii/sseedd command
                               "s/regex/replacement/g".

                               Examples:

                                   > regsub("hello world", "world", "auggie")
                                   "hello auggie"
                                   > regsub("hello world", "auggie", "world")
                                   ""
                                   > regsub("hello", ".*", "& &")
                                   "hello hello"
                                   > regsub("one two three", "(.*) (.*) (.*)", "\${3} \${2} \${1}")
                                   "three two one"
                                   > regsub("one two three", "(.*) (.*) (.*)", '${3} ${2} ${1}')
                                   "three two one"
                                   > strtr(regsub("https://BOB.Example.com",
                                       "\([^:]*\)://\([^.]*\)\\.\(.*\)", '${1}-${2}@${3}'),
                                         "A-Z", "a-z")
                                   "https-bob@example.com"
                                   > regsub("one, bone, cone, hone", "one", "two", repeat)
                                   "two, btwo, ctwo, htwo"


                           rreeqquueesstt__mmaattcchh(_u_r_i_-_s_t_r_i_n_g)
                               This function is used to inspect the current
                               request. The argument is either a valid URI or
                               a path component that begins with a slash. In
                               the latter case, the scheme and authority
                               components of the current request are
                               effectively prepended to the given path. The
                               path component is like the _u_r_l___p_a_t_t_e_r_n
                               attribute used in aacccceessss ccoonnttrrooll rruulleess[87] in
                               that it can either specify an exact match or,
                               by ending in "/*", a wildcard match. A query
                               component is allowed but ignored. The function
                               returns 0 if _u_r_i_-_s_t_r_i_n_g does not match the
                               current request, otherwise it returns the
                               number of path components of _u_r_i_-_s_t_r_i_n_g that
                               match the current request. If the scheme and
                               authority components are given in _u_r_i_-_s_t_r_i_n_g,
                               they count as one naming component.

                               Assuming that the current request is
                               http://example.com:18123/a/b/c, we get:

                                   > request_match("http://example.com:18123/a/b/c")
                                   4
                                   > request_match("https://example.com:18123/a/b/c")
                                   0
                                   > request_match("http://example.com:18123/a/b/c/d")
                                   0
                                   > request_match("http://example.com:18123/a/b")
                                   0
                                   > request_match("http://example.com:18123/a/b/*")
                                   4
                                   > request_match("http://example.com:18123/*")
                                   2
                                   > request_match("http://example.com:18123")
                                   0
                                   > request_match("http://example.com")
                                   0
                                   > request_match("http://example.com/*")
                                   2
                                   > request_match("/*")
                                   1
                                   > request_match("/a/b/c")
                                   3
                                   > request_match("/a/b/*")
                                   3
                                   > request_match("/")
                                   0


                           rreettuurrnn(_r_e_s_u_l_t)
                               Equivalent to eexxiitt, this function causes
                               evaluation of the expression to terminate and
                               returns _r_e_s_u_l_t as the value of the expression.

                           rruullee(_o_b_j_e_c_t, _r_u_l_e_s_e_t___v_f_s)
                               The rruullee predicate is an interface to the DDAACCSS
                               rule processing engine. It is used to test if
                               the rule set _r_u_l_e_s_e_t___v_f_s authorizes _o_b_j_e_c_t,
                               much as ddaaccsscchheecckk((11))[36] does. The _o_b_j_e_c_t
                               argument is the name to match against the
                               services specified in access control rules and
                               can either be a URI or an absolute pathname
                               (one that begins with a slash character). It
                               can have an optional query string component
                               attached. An absolute pathname _p_a_t_h is mapped
                               internally to a URI as file://_p_a_t_h; e.g.,
                               /myapp is interpreted as file:///myapp (see RRFFCC
                               11773388[43]).

                               One application of this predicate is for a rule
                               associated with a program to check that the
                               user requesting access is entitled to use a
                               data file needed by the program.

                                   NNoottee
                                   Only the _p_a_t_h component of the URI is
                                   considered when DDAACCSS matches an object's
                                   name against the url_pattern of an access
                                   control rule. At present, the object name
                                   is not automatically canonicalized or
                                   resolved (see RRFFCC 33998866[45]), as is usually
                                   done by a web server, so relative path
                                   components should be avoided.
                               The _r_u_l_e_s_e_t___v_f_s is a URI in the syntax of the
                               VVFFSS[25] configuration directive.

                               The various components of the URI that names
                               the object are available as DDAACCSS variables and
                               environment variables (see below). If a query
                               string is given, it is parsed and the
                               individual arguments are made available to
                               rules through the _A_r_g_s namespace, just as for
                               DDAACCSS-wrapped web services.

                               Many variables normally set by a web server are
                               instantiated based on the object name and the
                               execution environment. These variables are
                               available in the _D_A_C_S namespace. For example,
                               if the object name is
                               https://example.com:8443/myapp/edit-menu?entry=item1,
                               the following variables will be set as
                               indicated:

                                   ${DACS::HTTPS}=on
                                   ${DACS::SERVER_NAME}=example.com
                                   ${DACS::SERVER_ADDR}=142.179.101.118
                                   ${DACS::HTTP_HOST}=example.com:8443
                                   ${DACS::SERVER_PORT}=8443
                                   ${DACS::REQUEST_URI}=/myapp/edit-menu
                                   ${DACS::DOCUMENT_ROOT}=/
                                   ${DACS::REQUEST_METHOD}=GET
                                   ${DACS::SERVER_SOFTWARE}=dacsexpr-1.4.14
                                   ${DACS::QUERY_STRING}=entry=item1
                                   ${DACS::ARG_COUNT}=1
                                   ${DACS::CURRENT_URI}=/myapp/edit-menu?entry=item1
                                   ${DACS::CURRENT_URI_NO_QUERY}=/myapp/edit-menu

                               The value of _$_{_A_r_g_s_:_:_e_n_t_r_y_} will be item1. The
                               request method is always GET. The variable
                               _$_{_D_A_C_S_:_:_R_E_M_O_T_E___U_S_E_R_} will be set if credentials
                               are available in the execution environment.

                               For example, assuming that the file
                               /usr/local/exams/acls/acl-exams.17 contains:

                                   <acl_rule status="enabled">
                                     <services>
                                       <service url_pattern="/exam1.html"/>
                                     </services>

                                     <rule order="allow,deny">
                                       <precondition><predicate>
                                         ${Args::user} eq "teacher"
                                       </predicate></precondition>

                                       <allow>
                                         time(hour) eq 17
                                       </allow>
                                     </rule>
                                   </acl_rule>

                               The following call would only return TTrruuee (11)
                               any day between 5:00pm and 5:59pm:

                                   rule("/exam1.html?user=teacher", "dacs-fs:/usr/local/exams/acls");


                                   NNoottee
                                   +o   Since any rule can call the rruullee
                                       function, take care to avoid infinite
                                       recursion.

                                   +o   Although this function is similar in
                                       concept to the ddaaccsscchheecckk((11))[36]
                                       command, there are some significant
                                       differences, particularly with respect
                                       to the context available during rule
                                       evaluation.

                                   +o   The _E_n_v namespace is not reinitialized
                                       or altered during evaluation of rules
                                       processed by rruullee. That is, the _E_n_v
                                       namespace is the same as the outer-most
                                       one.

                               sseettvvaarr(_o_p, _d_s_t_-_n_a_m_e_s_p_a_c_e [, _a_r_g_s ...])
                                   This function, which performs various
                                   operations on namespaces, has several
                                   different syntaxes. The first argument
                                   always specifies the operation (case
                                   insensitively) and determines the meaning
                                   of the arguments that follow it. The second
                                   argument always specifies a namespace that
                                   is created or modified. If successful, the
                                   function returns the number of variables
                                   created (or replaced) in _d_s_t_-_n_a_m_e_s_p_a_c_e.

                                   The _d_s_t_-_n_a_m_e_s_p_a_c_e cannot be a rreeaadd--oonnllyy
                                   nnaammeessppaaccee[88]. Unless otherwise specified,
                                   if _d_s_t_-_n_a_m_e_s_p_a_c_e exists, variables are
                                   added to it, with any existing variable
                                   assigned its new value.

                                   The following operations are recognized:

                                   sseettvvaarr(authorization, _d_s_t_-_n_a_m_e_s_p_a_c_e,
                                   _a_u_t_h_-_s_t_r)
                                       The _a_u_t_h_-_s_t_r argument, which is the
                                       value of an Authorization HTTP request
                                       header, is parsed into its component
                                       fields and assigned to variables in the
                                       destination namespace _d_s_t_-_n_a_m_e_s_p_a_c_e. If
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e exists, its contents are
                                       deleted first. Corresponding to the
                                       field names used in RRFFCC 22661177[89]
                                       Section 3.2.2, the following variables
                                       are created: _A_U_T_H___S_C_H_E_M_E, _U_S_E_R_N_A_M_E,
                                       _P_A_S_S_W_O_R_D, _R_E_A_L_M, _N_O_N_C_E, _D_I_G_E_S_T___U_R_I,
                                       _R_E_S_P_O_N_S_E, _A_L_G_O_R_I_T_H_M, _C_N_O_N_C_E, _O_P_A_Q_U_E,
                                       _M_E_S_S_A_G_E___Q_O_P, _N_O_N_C_E___C_O_U_N_T, and
                                       _A_U_T_H___P_A_R_A_M. Any variable that
                                       corresponds to a non-existent field is
                                       assigned the empty string.

                                       The following call sets
                                       _$_{_F_o_o_:_:_A_U_T_H___S_C_H_E_M_E_} to Basic,
                                       _$_{_F_o_o_:_:_U_S_E_R_N_A_M_E_} to Bobo, and
                                       _$_{_F_o_o_:_:_P_A_S_S_W_O_R_D_} to myPassWord.

                                           setvar(authorization, Foo, "Basic Qm9ibzpteVBhc3NXb3Jk")


                                   sseettvvaarr(copy, _d_s_t_-_n_a_m_e_s_p_a_c_e, _s_r_c_-_n_a_m_e_s_p_a_c_e)
                                       With the copy operation, all variables
                                       in an existing namespace _s_r_c_-_n_a_m_e_s_p_a_c_e
                                       are copied to _d_s_t_-_n_a_m_e_s_p_a_c_e. If the
                                       latter exists, its contents are
                                       deleted, otherwise the namespace is
                                       created.

                                   sseettvvaarr(delete, _d_s_t_-_n_a_m_e_s_p_a_c_e)
                                       The delete operation is used to delete
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e and its contents.

                                   sseettvvaarr(kwv, _d_s_t_-_n_a_m_e_s_p_a_c_e, _a_s_s_i_g_n_-_c_h_a_r,
                                   _s_e_p_-_c_h_a_r_s, _s_t_r_i_n_g)
                                       For the kwv operation, _s_t_r_i_n_g is
                                       parsed, creating (or replacing)
                                       variables in _d_s_t_-_n_a_m_e_s_p_a_c_e. The _s_t_r_i_n_g
                                       consists of zero or more keyword/value
                                       pairs. The keyword, which is used as
                                       the variable name, is separated by the
                                       value by the character _a_s_s_i_g_n_-_c_h_a_r. A
                                       keyword/value pair is separated from
                                       the next by any character that appears
                                       in _s_e_p_-_c_h_a_r_s. Here is an example:

                                           setvar(kwv, "Foo", "=", ", ", "a=b, c=d, e=f")

                                       The value of this call is 3 and it sets
                                       _$_{_F_o_o_:_:_a_} to "b", _$_{_F_o_o_:_:_c_} to "d", and
                                       _$_{_F_o_o_:_:_e_} to "f".

                                   sseettvvaarr(load, _d_s_t_-_n_a_m_e_s_p_a_c_e, _f_i_l_e_n_a_m_e)
                                   sseettvvaarr(load, _d_s_t_-_n_a_m_e_s_p_a_c_e, _i_t_e_m___t_y_p_e, _k_e_y)
                                   sseettvvaarr(load, _d_s_t_-_n_a_m_e_s_p_a_c_e, _v_f_s_-_r_e_f, _k_e_y)
                                       The contents of a text object, which
                                       can be specified using a filename, as
                                       an _i_t_e_m___t_y_p_e, or using a _v_f_s_-_r_e_f (see
                                       vvffss(())[73]), is split into newline
                                       separated lines. The first line is
                                       assigned index 0 in _d_s_t_-_n_a_m_e_s_p_a_c_e, the
                                       second index 1, and so on.

                                       Consider the following example:

                                           > setvar(load, PASSWD, "/etc/passwd")
                                           25
                                           > ${PASSWD::2}
                                           "root:*:0:0:Charlie &amp;:/root:/bin/csh"

                                       Here, there are 25 lines in /etc/passwd
                                       and the third line is printed.

                                   sseettvvaarr(loadi, _d_s_t_-_n_a_m_e_s_p_a_c_e, _v_f_s_-_r_e_f)
                                       Each item in the indexed text object
                                       specified by _v_f_s_-_r_e_f (an absolute
                                       pathname, an item type, or a VVFFSS
                                       UURRII[61]) is copied to _d_s_t_-_n_a_m_e_s_p_a_c_e,
                                       with the same index. The index must be
                                       a valid _v_a_r_i_a_b_l_e_-_n_a_m_e.



                                           > setvar(loadi, PASSWD, "dacs-kwv-fs:/etc/passwd")
                                           23
                                           > ${PASSWD::root}
                                           "*:0:0:Charlie &amp;:/root:/bin/csh"
                                           > ${PASSWD::bobo}
                                           "bobo:*:1001:1001:Bobo &amp;:/home/bobo:/bin/tcsh"

                                       Here, 23 items are copied into the
                                       _P_A_S_S_W_D namespace (the first two lines
                                       in this particular /etc/passwd are
                                       ignored because they are comments that
                                       are not recognized as items). The lines
                                       indexed by the keys root and bobo are
                                       printed.

                                   sseettvvaarr(merge, _d_s_t_-_n_a_m_e_s_p_a_c_e, _s_r_c_-_n_a_m_e_s_p_a_c_e)
                                       The merge operation is similar to
                                       ccooppyy[90] except that if _d_s_t_-_n_a_m_e_s_p_a_c_e
                                       exists its contents are not deleted.

                                   sseettvvaarr(post, _d_s_t_-_n_a_m_e_s_p_a_c_e [, _c_o_n_t_e_n_t_-_t_y_p_e,
                                   _s_t_r_i_n_g])
                                       Like qquueerryy[91], this operation parses
                                       its input into arguments in
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e. The function reads its
                                       standard input, unless a _s_t_r_i_n_g
                                       argument is given. The input is
                                       expected to be a correctly formatted
                                       application/x-www-form-urlencoded or
                                       multipart/form-data content type. If
                                       the standard input is read, both the
                                       _C_O_N_T_E_N_T___T_Y_P_E and _C_O_N_T_E_N_T___L_E_N_G_T_H
                                       environment variables must be set (as
                                       they are when Apache runs a script that
                                       is passed an entity-body).

                                       The form that takes _s_t_r_i_n_g is not yet
                                       implemented.

                                   sseettvvaarr(query, _d_s_t_-_n_a_m_e_s_p_a_c_e, _q_u_e_r_y_-_s_t_r_i_n_g)
                                       For the query operation, _q_u_e_r_y_-_s_t_r_i_n_g
                                       is parsed, creating variables in
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e. This uses the same
                                       parsing algorithm employed by
                                       ccggiippaarrssee((88))[92]. In the case of a
                                       malformed query string, like "a&b",
                                       variables will be created but will have
                                       the empty string as their value. If
                                       successful, the function returns the
                                       number of variables created. The
                                       following call returns 3 and sets
                                       _$_{_F_o_o_:_:_a_} to "b", _$_{_F_o_o_:_:_c_} to "d", and
                                       _$_{_F_o_o_:_:_e_} to "f":

                                           setvar(query, "Foo", "a=b&c=d&e=f")

                                       One application of this function it to
                                       distinguish query arguments (which are
                                       part of the requested resource's URI
                                       and made available through the
                                       environment variable QQUUEERRYY__SSTTRRIINNGG) from
                                       arguments supplied in the body of a
                                       POST method (or other such method). For
                                       example:

                                           setvar(query, "Qargs", "${Env::QUERY_STRING}")
                                           if (${Qargs::foo:e}) {
                                               /* "foo" is a query argument */
                                           }
                                           else {
                                               /* "foo" is not a query argument */
                                           }

                                           if (${Args::foo:e} and not ${Qargs::foo:e}) {
                                               /* "foo" is a POST argument */
                                           }
                                           else {
                                               /* "foo" is not a POST argument */
                                           }


                                   sseettvvaarr(regsplit, _d_s_t_-_n_a_m_e_s_p_a_c_e, _s_t_r_i_n_g,
                                   _d_e_l_i_m_i_t_e_r_-_r_e_g_e_x [,_l_i_m_i_t])
                                       The regsplit operation is similar to
                                       sspplliitt[93] except that substrings are
                                       separated by the regular expression
                                       _d_e_l_i_m_i_t_e_r_-_r_e_g_e_x. IEEE Std 1003.2
                                       ("POSIX.2") "extended" regular
                                       expressions are used (rreeggeexx((33))[85]).

                                   sseettvvaarr(rename, _d_s_t_-_n_a_m_e_s_p_a_c_e,
                                   _s_r_c_-_n_a_m_e_s_p_a_c_e)
                                       The rename operation deletes
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e, if it exists, and
                                       changes the name of _s_r_c_-_n_a_m_e_s_p_a_c_e to
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e. The two namespace
                                       arguments must be different.

                                   sseettvvaarr(split, _d_s_t_-_n_a_m_e_s_p_a_c_e, _s_t_r_i_n_g,
                                   _d_e_l_i_m_i_t_e_r [,_l_i_m_i_t [,_d_f_l_a_g]])
                                       The split operation extracts substrings
                                       from _s_t_r_i_n_g. Substrings are separated
                                       by the string _d_e_l_i_m_i_t_e_r. For example,
                                       this call separates a composite role
                                       string into individual basic roles:

                                           setvar(split, "ROLES", ${DACS::ROLES}, ",")

                                       If the variable reference
                                       _$_{_D_A_C_S_:_:_R_O_L_E_S_} has the value
                                       "root,wheel,www,users", then the
                                       example would return 4 and set
                                       _$_{_R_O_L_E_S_:_:_0_} to "root", _$_{_R_O_L_E_S_:_:_1_} to
                                       "wheel", and so on.

                                       If a _l_i_m_i_t is given, it is an integer
                                       that specifies the maximum number of
                                       substrings to extract. Once the maximum
                                       has been reached, the remainder of
                                       _s_t_r_i_n_g that has not been split will be
                                       assigned to the last element. A _l_i_m_i_t
                                       of zero is equivalent to the default,
                                       which is for there to be no maximum.
                                       For instance, setvar(split, X,
                                       "a,b,c,d", ",", 2) will assign "a" to
                                       _$_{_X_:_:_0_} and "b,c,d" to _$_{_X_:_:_1_}.

                                       Here is another example:

                                           > setvar(split, "X", "a\nb\nc\n", "\n")
                                           "3"
                                           > ${X::0}
                                           "a"
                                           > ${X::#}
                                           "3"

                                       This function can be used to break a
                                       pathname into its individual
                                       components. For instance, the following
                                       call results in _$_{_X_:_:_0_} set to the
                                       empty string, _$_{_X_:_:_1_} set to "a",
                                       _$_{_X_:_:_2_} set to "long", and _$_{_X_:_:_3_} set
                                       to "path":

                                           > setvar(split, "X", "/a/long/path", "/")
                                           4

                                       (You may need to first remove redundant
                                       slashes in _s_t_r_i_n_g using ssttrrttrr(())[80].)

                                       A _d_f_l_a_g argument may follow the _l_i_m_i_t
                                       argument to indicate whether _d_e_l_i_m_i_t_e_r
                                       should not be included in substrings
                                       (_d_f_l_a_g == 0, which is the default
                                       behavior), whether it should be
                                       included at the start of substrings
                                       with the possible exception of the
                                       first one (_d_f_l_a_g > 0), or whether it
                                       should be included at the end of
                                       substrings with the possible exception
                                       of the last one (_d_f_l_a_g < 0).

                                           > setvar(split, P, "/a/long/path", "/", 0, 1)
                                           3
                                           > ${P::0}
                                           "/a"
                                           > ${P::1}
                                           "/long"
                                           > ${P::2}
                                           "/path"
                                           > setvar(split, P, "/a/long/path", "/", 0, -1)
                                           4
                                           > ${P::0}
                                           "/"
                                           > ${P::1}
                                           "a/"
                                           > ${P::2}
                                           "long/"
                                           > ${P::3}
                                           "path"


                                   sseettvvaarr(uri, _d_s_t_-_n_a_m_e_s_p_a_c_e, _u_r_i)
                                       The given _u_r_i, a URI conforming to RRFFCC
                                       22339966[44] or RRFFCC 33998866[45], is parsed
                                       into its components. Variables in
                                       _d_s_t_-_n_a_m_e_s_p_a_c_e are set accordingly:
                                       _S_C_H_E_M_E (mapped to lower case), _H_O_S_T
                                       (mapped to lower case), _A_U_T_H_O_R_I_T_Y,
                                       _P_O_R_T, _S_E_R_V_E_R, _U_S_E_R_I_N_F_O, _P_A_T_H, _Q_U_E_R_Y,
                                       and _F_R_A_G_M_E_N_T. If a component is absent
                                       from _u_r_i, the corresponding variable
                                       will not be defined.

                                           SSeeccuurriittyy
                                           It is possible for _U_S_E_R_I_N_F_O to
                                           include a plaintext password.
                                       In addition, the URI's path component
                                       is split into its slash-delimited
                                       pieces. The variable _P_A_T_H___L_E_N_G_T_H is set
                                       to the number of such pieces (it will
                                       be zero if there are none), and
                                       variables _P_A_T_H___0, _P_A_T_H___1, and so on are
                                       set to the first, second, and
                                       successive pieces. An "empty" path
                                       component is treated as a piece
                                       consisting of the empty string.

                                           > setvar(uri, "X", "https://bar@foo.example.com:8443/cgi-bin/prog?a=17")
                                           11
                                           > info(namespace,X)
                                           "SCHEME="https"
                                           AUTHORITY="bar@foo.example.com:8443"
                                           HOST="foo.example.com"
                                           PORT="8443"
                                           SERVER="foo.example.com:8443"
                                           USERINFO="bar"
                                           PATH="/cgi-bin/prog"
                                           PATH_COUNT="2"
                                           PATH_0="cgi-bin"
                                           PATH_1="prog"
                                           QUERY="a=17"
                                           "



                               ssiizzeeooff(_t_y_p_e_n_a_m_e)
                                   This function returns the amount of memory
                                   in bytes, as an integer, used by _t_y_p_e_n_a_m_e,
                                   the name of a bbaassiicc ddaattaa ttyyppee[20]. For the
                                   string and binary types, the returned value
                                   is the number of bytes used by each element
                                   of that type (1, typically). To find the
                                   number of elements in string or binary
                                   data, use lleennggtthh(())[14].



                                       > sizeof(real)
                                       8


                               sslleeeepp(_s_e_c_o_n_d_s)
                                   The process is suspended for approximately
                                   _s_e_c_o_n_d_s seconds, or until a signal is
                                   received and caught or the process
                                   terminated. It returns the "unslept" number
                                   of seconds, which will be zero if the
                                   process slept for the requested interval.
                                   This is an interface to sslleeeepp((33))[94]. It
                                   can be useful for inserting delays in
                                   conjunction with error handlers, for
                                   instance.

                               ssoouurrccee(_v_f_s_-_r_e_f [,_k_e_y])
                                   The expressions in the file or item
                                   specified by _v_f_s_-_r_e_f, which may be followed
                                   by a _k_e_y if it is an indexed filestore, are
                                   read and evaluated as a block. The _v_f_s_-_r_e_f
                                   can be an absolute pathname, an item type,
                                   or a VVFFSS UURRII[61]. The value returned is
                                   that of the evaluated block. The following
                                   two expressions are essentially equivalent:

                                       source("/usr/local/dacs/scripts/script17")
                                       eval(get("/usr/local/dacs/scripts/script17"))

                                   This function is handy when a lengthy
                                   expression is needed but one does not want
                                   to clutter a configuration file or a rule.

                               sspprriinnttff(_f_m_t, _._._.)
                                   This is a slightly scaled-down version of
                                   the sspprriinnttff((33))[95] library function. If
                                   necessary and possible, arguments are
                                   converted to the type requested by a
                                   formatting specification. The formatted
                                   string is returned.

                                       ${a} = sprintf("Hello") . ", world."
                                       "Hello, world."
                                       length(sprintf("Hello") . ", world.")
                                       13


                               ssttrrcchhaarrss(_s_t_r, _r_a_n_g_e_-_s_p_e_c [,...])
                                   This function returns a new string by
                                   selecting characters from _s_t_r according to
                                   a sequence of one or more range
                                   specifications (each one a _r_a_n_g_e_-_s_p_e_c). A
                                   _r_a_n_g_e_-_s_p_e_c is a string argument that
                                   determines the indexes of characters to
                                   select within _s_t_r. Indexes start at zero.
                                   The result of each successive range
                                   specification is appended to the previous
                                   result.

                                   A _r_a_n_g_e_-_s_p_e_c is an unordered set of one or
                                   more comma-separated elements, each of
                                   which is either an _i_n_d_e_x or a _r_a_n_g_e. An
                                   _i_n_d_e_x may either be a non-negative integer
                                   or "#", which means "all indexes". A _r_a_n_g_e
                                   represents a sequence of indexes and has
                                   the syntax:

                                       _r_a_n_g_e_-_s_t_a_r_t ".." _r_a_n_g_e_-_e_n_d

                                   A _r_a_n_g_e_-_s_t_a_r_t may be a non-negative
                                   integer, the character "#" (which means
                                   "from the beginning"), or may be elided
                                   (also meaning "from the beginning"). A
                                   _r_a_n_g_e_-_e_n_d may be a non-negative integer
                                   (not less than _r_a_n_g_e_-_s_t_a_r_t, if it is also a
                                   non-negative integer), the character "#"
                                   (which means "to the end"), or may be
                                   omitted (also meaning "to the end").

                                       > $a = "abcdef"
                                       "abcdef"
                                       > strchars($a, 2)
                                       "c"
                                       > strchars($a, "1..4", "0")
                                       "bcdea"
                                       > strchars($a . $a, "5..#")
                                       "fabcdef"
                                       > strchars($a, "#")
                                       "abcdef"
                                       > strchars($a, "#..#")
                                       "abcdef"
                                       > strchars($a, "#..3")
                                       "abcd"
                                       > strchars($a, "..3")
                                       "abcd"
                                       > strchars($a, "..3", "#")
                                       "abcdabcdef"


                               ssttrrffttiimmee(_f_o_r_m_a_t)
                                   This function is an interface to the
                                   ssttrrffttiimmee((33))[96] function. It is applied to
                                   the current date and time.

                               ssttrrppttiimmee(_d_a_t_e_-_s_t_r, _d_a_t_e_-_f_o_r_m_a_t, _n_a_m_e_s_p_a_c_e)
                               ssttrrppttiimmee(_n_a_m_e_s_p_a_c_e)
                                   This function is an interface to the
                                   ssttrrppttiimmee((33))[97] function. The _d_a_t_e_-_s_t_r
                                   argument is a string representation of a
                                   date and/or time, with _d_a_t_e_-_f_o_r_m_a_t
                                   describing its syntax. If the parse of
                                   _d_a_t_e_-_s_t_r succeeds, the following elements
                                   of _n_a_m_e_s_p_a_c_e are set from the corresponding
                                   fields of struct tm: _t_m___s_e_c, _t_m___m_i_n,
                                   _t_m___h_o_u_r, _t_m___m_d_a_y, _t_m___m_o_n, _t_m___y_e_a_r, _t_m___w_d_a_y,
                                   _t_m___y_d_a_y, _t_m___i_s_d_s_t, _t_m___z_o_n_e, and _t_m___g_m_t_o_f_f.
                                   Additionally, a variable named _c_l_o_c_k is set
                                   to the Unix time that corresponds to the
                                   parsed date and time. Any existing elements
                                   of _n_a_m_e_s_p_a_c_e are not modified. If _d_a_t_e_-_s_t_r
                                   does not fully describe a date and time, it
                                   is taken to be relative to the current date
                                   and time (e.g., if only a time is given,
                                   "today's date" is used).

                                   In the single-argument usage, the current
                                   date and time are parsed and _n_a_m_e_s_p_a_c_e is
                                   assigned values as previously described.

                                   The return value is the "Unix time"
                                   equivalent of the resulting time and date.



                                       > strptime("6 Dec 2001 12:33:45", "%d %b %Y %H:%M:%S", tm)
                                       1007670825
                                       > "${tm::tm_mon} ${tm::tm_mday} ${tm::tm_hour} ${tm::tm_min}"
                                       "11 6 12 33"
                                       > ${tm::clock}
                                       1007670825


                               ssttrrrrssttrr(_s_t_r_i_n_g, _s_u_b_s_t_r_i_n_g)
                                   Return the start of the last occurrence of
                                   _s_u_b_s_t_r_i_n_g within _s_t_r_i_n_g. The empty string
                                   is returned if _s_t_r_i_n_g is empty or if no
                                   occurrence of _s_u_b_s_t_r_i_n_g is found. If
                                   _s_u_b_s_t_r_i_n_g is empty, _s_t_r_i_n_g is returned.

                               ssttrrssttrr(_s_t_r_i_n_g, _s_u_b_s_t_r_i_n_g)
                                   Return the start of the first occurrence of
                                   _s_u_b_s_t_r_i_n_g within _s_t_r_i_n_g. The empty string
                                   is returned if _s_t_r_i_n_g is empty or if no
                                   occurrence of _s_u_b_s_t_r_i_n_g is found. If
                                   _s_u_b_s_t_r_i_n_g is empty, _s_t_r_i_n_g is returned.

                                       > strstr("foobazbar", "baz")
                                       "bazbar"
                                       > strstr("foobazbar", "")
                                       "foobazbar"
                                       > strstr("foobazbar", "zzz")
                                       ""
                                       > strstr("", "zzz")
                                       ""
                                       > strstr("afoofoofooz", "foo")
                                       "foofoofooz"
                                       > strrstr("afoofoofooz", "foo")
                                       "fooz"


                               ssttrrttoolloowweerr(_s_t_r_i_n_g)
                                   A new string is returned where each
                                   uppercase character in _s_t_r_i_n_g is mapped to
                                   lowercase and all other characters are
                                   mapped to themselves. These two expressions
                                   are equivalent and have the value "hello,
                                   world 2008":

                                       strtolower("Hello, World 2008")
                                       strtr("Hello, World 2008", "A-Z", "a-z")


                               ssttrrttoouuppppeerr(_s_t_r_i_n_g)
                                   A new string is returned where each
                                   lowercase character in _s_t_r_i_n_g is mapped to
                                   uppercase and all other characters are
                                   mapped to themselves. These two expressions
                                   are equivalent and have the value "HELLO,
                                   WORLD 2008":

                                       strtoupper("Hello, World 2008")
                                       strtr("Hello, World 2008", "a-z", "A-Z")


                               ssttrrttrr(_i_n_p_u_t_-_s_t_r_i_n_g, _s_t_r_i_n_g_1, [_s_t_r_i_n_g_2 [,cds]])
                                   This function performs string
                                   transliteration, like the ttrr((11))[98] command
                                   and PPeerrll's tr and y operators. The result
                                   is the transliterated string. The first
                                   argument is the input string to be
                                   transliterated (stdin in the ttrr command).
                                   The second argument is the search list
                                   ("string1" in the ttrr command). The third
                                   argument is the (possibly empty)
                                   replacement list ("string2" in the ttrr
                                   command); it may be omitted if no flag
                                   string argument follows.

                                   The fourth, optional argument is a literal
                                   flag string made of the characters 'c',
                                   'd', and 's' (in any order), which
                                   correspond to the flags of the same name in
                                   the ttrr command:

                                   cc
                                       Complement the set of values in
                                       _s_t_r_i_n_g_1.

                                   dd
                                       Delete characters in _s_t_r_i_n_g_1 from the
                                       input string.

                                   ss
                                       Squeeze multiple occurrences of the
                                       characters listed in the last operand
                                       (either _s_t_r_i_n_g_1 or _s_t_r_i_n_g_2) in the
                                       input into a single instance of the
                                       character. This occurs after all
                                       deletion and translation is completed.


                                       > strtr("AbCdEf", "A-Z", "a-z")
                                       "abcdef"
                                       > strtr("/a//b///c", "/", "", "s")
                                       "/a/b/c"


                               ssuubbsseett(_f_o_r_m_a_t, _p_u_r_p_o_r_t_e_d_-_s_u_b_s_e_t, _s_u_p_e_r_s_e_t [,
                               nocase])
                                   This function returns TTrruuee if every element
                                   of the purported-subset appears in
                                   superset. The _f_o_r_m_a_t indicates how to parse
                                   the set arguments. It can be the space,
                                   tab, or newline character, or any
                                   punctuation character. It is currently
                                   interpreted as the character that separates
                                   elements. If the optional nocase literal
                                   argument is given, then set elements are
                                   compared case-insensitively.

                                   Example:

                                       subset(",", ${Args::LAYERS:i}, "RELIEF:Foundation,GTOPO30:Foundation")

                                   This call returns TTrruuee if every element of
                                   the LAYERS parameter (case insensitive)
                                   appears in the given list, otherwise the
                                   expression is FFaallssee.

                               ssuubbssttrr(_s_t_r_i_n_g, _s_t_a_r_t_-_p_o_s_i_t_i_o_n, _l_e_n_g_t_h)
                                   This function returns the substring of
                                   _s_t_r_i_n_g beginning at _s_t_a_r_t_-_p_o_s_i_t_i_o_n with
                                   length at most _l_e_n_g_t_h characters. The first
                                   character is in position one. If
                                   _s_t_a_r_t_-_p_o_s_i_t_i_o_n is negative, the position is
                                   relative to the end of _s_t_r_i_n_g (-1 specifies
                                   the last character in _s_t_r_i_n_g). If the
                                   effective starting position is outside of
                                   _s_t_r_i_n_g, an empty string is returned. If
                                   _l_e_n_g_t_h is negative, it means "the remainder
                                   of the string". It is an error if either
                                   numeric argument is zero. It is not an
                                   error if _l_e_n_g_t_h exceeds the actual number
                                   of characters returned.

                                       > substr("foozle", 3, 4)
                                       "ozle"
                                       > substr("foobar", -3, 2)
                                       "ba"
                                       > substr("foobar", -5, -1)
                                       "oobar"
                                       > substr("foobar", 10, -1)
                                       ""
                                       > substr("foobar", -10, 3)
                                       ""


                               ssyynnttaaxx(_t_y_p_e, _n_a_m_e [, _f_l_a_g])
                                   This function performs a syntax test,
                                   specified by _t_y_p_e, on _n_a_m_e. It returns 0 if
                                   the test fails, 1 or a _t_y_p_e-dependent,
                                   non-zero value if the test is successful.
                                   It can be useful for testing, catching
                                   errors, recognizing when a string must be
                                   mapped, and for learning about DDAACCSS. Note
                                   that these are purely syntactical checks.
                                   They do not test whether an object called
                                   _n_a_m_e exists or is configured.

                                   The following tests are recognized:

                                   ssyynnttaaxx(charset, _n_a_m_e, _c_h_a_r_s_e_t___s_p_e_c)
                                       Test if each of the characters in _n_a_m_e
                                       is specified by _c_h_a_r_s_e_t___s_p_e_c, which is
                                       a character set specification as used
                                       by ssttrrttrr(())[80] ("the search list").

                                   ssyynnttaaxx(dacsname, _n_a_m_e)
                                       Test if _n_a_m_e is valid as a DDAACCSS
                                       name[99]. If the string is recognized,
                                       one of the following values is returned
                                       to classify it:

                                       +o   1 if it is a DDAACCSS identity

                                       +o   2 if it is a group name

                                       +o   3 if it is a jurisdiction name

                                       +o   4 if it is a federation name

                                       +o   5 if it is an IP address in numeric
                                           dot notation

                                       ssyynnttaaxx(emailaddr, _n_a_m_e)
                                           Test if _n_a_m_e is a syntactically
                                           valid RRFFCC 882222[100] email address. A
                                           successful test does not imply that
                                           a message can be delivered to the
                                           address.

                                               NNoottee
                                               The implementation does not
                                               currently recognize valid
                                               addresses where the local-part
                                               (the substring to the left of
                                               the '@' character) contains a
                                               quoted-string component.

                                       ssyynnttaaxx(expr, _n_a_m_e)
                                           Test if _n_a_m_e is a syntactically
                                           valid expression. The expression is
                                           not actually evaluated. A
                                           successful test does not imply that
                                           evaluation of the expression will
                                           necessarily be successful or
                                           error-free.

                                       ssyynnttaaxx(domainname, _n_a_m_e)
                                           Test if _n_a_m_e is a syntactically
                                           valid domain name (RRFFCC 995522[101]). A
                                           successful test does not imply that
                                           _n_a_m_e exists or has a DNS entry.

                                       ssyynnttaaxx(federation, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a
                                           federation name (e.g., as the value
                                           of FFEEDDEERRAATTIIOONN__NNAAMMEE[102]).

                                       ssyynnttaaxx(group, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a group
                                           name.

                                       ssyynnttaaxx(hostname, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a host
                                           name (an alphanumeric, followed by
                                           any number of alphanumerics and
                                           hyphens, but not ending with a
                                           hyphen; see RRFFCC 995522[101] and RRFFCC
                                           11112233[103]).

                                       ssyynnttaaxx(ipaddr, _n_a_m_e)
                                           Test if _n_a_m_e is a valid Class C
                                           IPv4 address (RRFFCC 779900[104]).

                                       ssyynnttaaxx(jurisdiction, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a
                                           jurisdiction name (e.g., as the
                                           value of JJUURRIISSDDIICCTTIIOONN__NNAAMMEE[105]).

                                       ssyynnttaaxx(namespace, _n_a_m_e)
                                           Test if _n_a_m_e is valid as the name
                                           of a nnaammeessppaaccee[21].

                                       ssyynnttaaxx(role, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a rroollee
                                           ddeessccrriippttoorr ssttrriinngg[99].

                                       ssyynnttaaxx(uri, _n_a_m_e)
                                           Test if _n_a_m_e is a valid URI (RRFFCC
                                           22339966[44], but partially RRFFCC
                                           33998866[45]). It must consist of a
                                           scheme, authority component, path
                                           component, and optional query and
                                           fragment components.

                                       ssyynnttaaxx(username, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a username
                                           (e.g., as the value of the _U_S_E_R_N_A_M_E
                                           argument to many DDAACCSS web
                                           services).

                                       ssyynnttaaxx(variable, _n_a_m_e)
                                           Test if _n_a_m_e is valid as a vvaarriiaabbllee
                                           rreeffeerreennccee[21]. This does not test
                                           if the named variable exists.

                                       ssyynnttaaxx(varname, _n_a_m_e)
                                           Test if _n_a_m_e is a syntactically
                                           correct vvaarriiaabbllee nnaammee[21], with or
                                           without a namespace. This does not
                                           test if the named variable exists.



                                           > syntax(federation, "FOO")
                                           1
                                           > syntax(dacsname, "FOO::BAZ:bar")
                                           1
                                           > syntax(dacsname, "FOO::")
                                           4
                                           > syntax(charset, "bobo17+", "a-z0-9")
                                           0
                                           > syntax(expr, '1 + 1 + 1')
                                           1
                                           > syntax(variable, '${1$}')
                                           0
                                           > syntax(variable, '${Foo::baz:z}')
                                           0
                                           > syntax(varname, 'Foo::baz')
                                           1
                                           > syntax(varname, "17")
                                           1
                                           > syntax(username, "/bobo/")
                                           0
                                           > syntax(group, "blop")
                                           1
                                           > syntax(group, "%blop")
                                           0
                                           > syntax(dacsname, "%blop:flop")
                                           1
                                           > syntax(uri,"https://foo.example.com:8443/cgi-bin/prog?a=17")
                                           1


                                   ttiimmee(_f_o_r_m_a_t [, _t_i_m_e_v_a_l])
                                   ttiimmee(_f_o_r_m_a_t, _n_a_m_e_s_p_a_c_e)
                                       This function returns time and date
                                       information, as specified by the first
                                       argument. The second argument, if
                                       present, either specifies the "Unix
                                       time" from which to obtain the time and
                                       date or a namespace that was returned
                                       by ssttrrppttiimmee(())[106]. If the second
                                       argument is absent, the result is the
                                       same as if a second argument were given
                                       as time("now"). The llooccaallttiimmee((33))[107]
                                       library function is used internally to
                                       perform the date calculations.

                                       The _f_o_r_m_a_t argument, which is treated
                                       case-insensitively, can be any of the
                                       following:

                                       +o   If the argument is "now", the
                                           function's value is the current
                                           "Unix time" (the value of time in
                                           seconds since 0 hours, 0 minutes, 0
                                           seconds, January 1, 1970,
                                           Coordinated Universal Time). If the
                                           second argument is present,
                                           however, it is the function's
                                           value.

                                       +o   If the argument is "sec" or "secs"
                                           or "seconds", the function's value
                                           is the system clock's seconds
                                           reading.

                                       +o   If the argument is "min" or "mins"
                                           or "minutes", the function's value
                                           is the system clock's minutes
                                           reading.

                                       +o   If the argument is "hour", the
                                           function's value is the system
                                           clock's hour reading (0 - 23).

                                       +o   If the argument is "mday", the
                                           function's value is the day of the
                                           month (1 - 31).

                                       +o   If the argument is "ismdaylast",
                                           the function's value is non-zero if
                                           this is the last day of the month.

                                       +o   If the argument is "mon" or
                                           "month", the function's value is
                                           the month of the year (0 - 11).

                                       +o   If the argument is "year", the
                                           function's value is the year (from
                                           1900 onward).

                                       +o   If the argument is "isleapyear",
                                           the function's value is non-zero if
                                           this is a leap year.

                                       +o   If the argument is "wday", the
                                           function's value is the day of the
                                           week (Sunday is 0).

                                       +o   If the argument is "yday", the
                                           function's value is the day of the
                                           year (0 - 365).

                                       +o   If the argument is "isdst", the
                                           function's value is non-zero if
                                           daylight saving time is in effect.

                                       +o   If the argument is "zone", the
                                           function's value is system clock's
                                           time zone, abbreviated. If the time
                                           zone is not known, the value will
                                           be the empty string.

                                       +o   If the argument is "gmtoff", the
                                           function's value is the offset (in
                                           seconds) of the system clock's time
                                           represented from UTC, with positive
                                           values indicating east of the Prime
                                           Meridian.

                                               NNoottee
                                               A more powerful function is
                                               planned to test whether the
                                               current time and date satisfy a
                                               predicate. It might, for
                                               example, understand arguments
                                               such as "Tuesday" (TTrruuee on any
                                               Tuesday), "last day of the
                                               month", "between midnight and
                                               8:30am", "January 30, 2004 at
                                               1:23pm", "between March 2 and
                                               April 1", "the second Tuesday
                                               of the month", or "within 15
                                               days of April 30".

                                       ttrraannssffoorrmm(_i_n_p_u_t,_n_a_m_e,_r_u_l_e_s,_d_o_c_s
                                       [,_i_d_e_n_t_s])
                                       ttrraannssffoorrmm(_i_n_p_u_t,_c_o_n_f_i_g,_n_a_m_e,_r_u_l_e_s,_d_o_c_s
                                       [,_i_d_e_n_t_s])
                                           This function provides a simplified
                                           API for ddaaccssttrraannssffoorrmm((11))[108] -
                                           refer to its description for
                                           additional details. The first form
                                           of the function uses compile-time
                                           defaults, unless they are
                                           overridden by configuration
                                           variables (e.g.,
                                           _$_{_C_o_n_f_:_:_t_r_a_n_s_f_o_r_m___p_r_e_f_i_x_}). The
                                           second form passes a configuration
                                           object returned by
                                           ttrraannssffoorrmm__ccoonnffiigg(())[109]. The _i_n_p_u_t
                                           argument is the text to be passed
                                           through the function. The _n_a_m_e
                                           argument is equivalent to the value
                                           of the ddaaccssttrraannssffoorrmm --nnaammee flag,
                                           _r_u_l_e_s is equivalent to the value of
                                           the --rr flag, _d_o_c_s is equivalent to
                                           the value of the --ddooccss flag, and
                                           the optional _i_d_e_n_t_s argument is a
                                           whitespace-separated list of
                                           identities in the ccoonncciissee uusseerr
                                           ssyynnttaaxx[110]. The function returns
                                           the transformed _i_n_p_u_t.

                                       ttrraannssffoorrmm__ccoonnffiigg(_f_l_a_g_s)
                                           This function returns a
                                           configuration object that is passed
                                           to subsequent calls to
                                           ttrraannssffoorrmm(())[111] so that defaults
                                           can be overridden. The single
                                           string argument is parsed into
                                           whitespace-separated words. If a
                                           flag is repeated, the right-most
                                           occurrence is used.

                                           The following flags are recognized:

                                           +o   --pprreeffiixx _p_r_e_f_i_x_-_s_t_r_i_n_g: The
                                               string used to introduce a
                                               directive, which must appear at
                                               the beginning of a line.

                                           +o   --ssuuffffiixx _s_u_f_f_i_x_-_s_t_r_i_n_g: The
                                               string used to end a directive.

                                           +o   --rrpprreeffiixx _r_e_g_e_x_-_p_r_e_f_i_x: A line
                                               whose beginning matches the
                                               specified regular expression
                                               introduces a directive.

                                           +o   --rrssuuffffiixx _r_e_g_e_x_-_s_u_f_f_i_x: The end
                                               of a directive is found by
                                               matching the specified regular
                                               expression.

                                           ttrriimm(_s_t_r_i_n_g, _d_e_l_e_t_e_-_s_e_t [,_l_i_m_i_t])
                                               Delete each character in
                                               _d_e_l_e_t_e_-_s_e_t that appears at the
                                               end of _s_t_r_i_n_g, up to _l_i_m_i_t
                                               characters. The _d_e_l_e_t_e_-_s_e_t is a
                                               search list specification as
                                               used by ssttrrttrr(())[80]. If _l_i_m_i_t
                                               is missing or zero, all of the
                                               characters in _s_t_r_i_n_g can
                                               potentially be deleted (leaving
                                               the empty string). The new
                                               string is returned.



                                                   > trim("abceffff", "f")
                                                   "abce"
                                                   > trim("abceffff", abf)
                                                   "abce"
                                                   > trim("a\n\n\n", "\n")
                                                   "a"
                                                   > trim("a", "a-z")
                                                   ""


                                           ttyyppeeooff([_t_y_p_e_n_a_m_e,] _e_x_p_r_e_s_s_i_o_n)
                                               If there are two arguments and
                                               the first is a recognized ddaattaa
                                               ttyyppee nnaammee[20], the return value
                                               is 1 (TTrruuee) if _e_x_p_r_e_s_s_i_o_n has
                                               that type and 0 (FFaallssee)
                                               otherwise. If there is one
                                               argument, the function yields a
                                               string that is the data type
                                               name of the evaluated
                                               expression.



                                                   > typeof(4.5)
                                                   "real"
                                                   > typeof(integer, 4.5)
                                                   0


                                           uunnddeeff()
                                               This function returns a special
                                               value that represents the
                                               "undefined" value. It is used
                                               in certain circumstances to
                                               undefine a symbol. See
                                               ddaaccss..ccoonnff((55))[9].

                                           uusseerr(_s_t_r_i_n_g)
                                               This function compares its
                                               argument against each set of
                                               current credentials and returns
                                               the number of credentials that
                                               match. The argument is a user
                                               filter expression that must
                                               evaluate to TTrruuee for a set of
                                               credentials for those
                                               credentials to match. See
                                               ddaaccss((11))[99] for information
                                               about naming.

                                                   NNoottee
                                                   In typical usage, each user
                                                   will have only one set of
                                                   credentials or will be
                                                   unauthenticated. One should
                                                   keep in mind, however, that
                                                   multiple concurrent
                                                   identities are allowed,
                                                   subject to
                                                   AACCSS__CCRREEDDEENNTTIIAALLSS__LLIIMMIITT[112].
                                               The _s_t_r_i_n_g argument (_E_X_P) has
                                               the following syntax:

                                               FFiigguurree 22.. UUsseerr FFiilltteerr
                                               EExxpprreessssiioonn GGrraammmmaarr

                                                   _E_X_P -> _E_1
                                                   _E_1  -> _E_2 | _E_2 _O_R _E_2
                                                   _E_2  -> _E_3 | _E_3 _A_N_D _E_2
                                                   _E_3  -> _E_4 | _N_O_T _E_3
                                                   _E_4  -> _p_r_i_m_a_r_y | "(" _E_1 ")"

                                                   _O_R  -> "or"  | "||"
                                                   _A_N_D -> "and" | "&&"
                                                   _N_O_T -> "not" | "!"

                                               Whitespace (spaces and tabs) is
                                               permitted before and after
                                               lexical elements. Keywords are
                                               case sensitive except when
                                               otherwise stated.

                                               A _p_r_i_m_a_r_y, which evaluates to
                                               TTrruuee or FFaallssee, is one of the
                                               following:

                                               _u_s_e_r_n_a_m_e
                                                   TTrruuee if the DDAACCSS identity
                                                   _u_s_e_r_n_a_m_e matches.

                                                       user("METALOGIC:auggie")
                                                       user(":bobo")

                                                   If the jurisdiction name or
                                                   federation name components
                                                   are omitted, the ccuurrrreenntt
                                                   ffeeddeerraattiioonn aanndd
                                                   jjuurriissddiiccttiioonn[99] are
                                                   implied. The jurisdiction
                                                   name component may be
                                                   specified as "*" (e.g.,
                                                   *:_u_s_e_r_n_a_m_e), in which case
                                                   it will match _a_n_y
                                                   jurisdiction name in the
                                                   current federation. In
                                                   addition, both the
                                                   federation name and the
                                                   jurisdiction name
                                                   components may be specified
                                                   as "*" (e.g.,
                                                   *::*:_u_s_e_r_n_a_m_e), in which
                                                   case it will match _a_n_y
                                                   federation name and _a_n_y
                                                   jurisdiction name.

                                               _j_u_r_i_s_d_i_c_t_i_o_n
                                                   TTrruuee if _j_u_r_i_s_d_i_c_t_i_o_n
                                                   matches the name of the
                                                   jurisdiction that created
                                                   the credentials.

                                                       user("METALOGIC:")
                                                       user("DEMO::METALOGIC:")


                                               _f_e_d_e_r_a_t_i_o_n
                                                   TTrruuee if _f_e_d_e_r_a_t_i_o_n matches
                                                   the name of the federation
                                                   that created the
                                                   credentials.

                                                       user("DEMO::")


                                               _a_d_d_r_e_s_s
                                                   Given an argument
                                                   acceptable to the
                                                   ffrroomm(())[113] predicate, the
                                                   result is TTrruuee if the
                                                   credentials were generated
                                                   by a user apparently
                                                   located at _a_d_d_r_e_s_s.

                                                       user("10.0.0.123")
                                                       user("10.0.0.0/24")
                                                       user("example.com")


                                               _g_r_o_u_p
                                                   TTrruuee if the identity is a
                                                   member of _g_r_o_u_p, which is a
                                                   DDAACCSS group.

                                                       user("%METALOGIC:admin")

                                                   A group name may reference
                                                   an explicit group
                                                   membership list or a
                                                   role-based group. Also, it
                                                   is possible for an explicit
                                                   group membership list to
                                                   have the same name as a
                                                   role-based group; if the
                                                   name is referenced in a
                                                   rule, the rule processing
                                                   engine will first check if
                                                   the user is associated with
                                                   the role. If he's not, it
                                                   will go on to check for an
                                                   explicit group membership
                                                   list with the same name.
                                                   This allows an
                                                   administrator to easily
                                                   supplement the membership
                                                   associated with a
                                                   role-based group. Refer to
                                                   ddaaccss..ggrroouuppss((55))[114].

                                               namespace _n_s
                                                   The value of each element
                                                   in _n_s (a namespace) is
                                                   evaluated as a _p_r_i_m_a_r_y. The
                                                   order in which the list is
                                                   evaluated is unspecified.
                                                   Processing of the list
                                                   terminates with the first
                                                   _p_r_i_m_a_r_y that evaluates to
                                                   TTrruuee or when the list is
                                                   exhausted. This _p_r_i_m_a_r_y can
                                                   appear in an element (so
                                                   that one list can reference
                                                   other lists) but beware of
                                                   infinite recursion.

                                                   For example, if
                                                   /usr/local/dacs/app_users
                                                   consists of usernames, one
                                                   per line, an access control
                                                   rule can grant permission
                                                   to any of the users by
                                                   having an allow element
                                                   containing the statements:

                                                       setvar(load, APP_USERS, "/usr/local/dacs/app_users");
                                                       user("namespace APP_USERS")


                                               style _s_t_y_l_e_-_l_i_s_t
                                                   The keyword style is
                                                   followed by a list of one
                                                   or more comma-separated,
                                                   case-insensitive style
                                                   keywords, described below.
                                                   Each style keyword may be
                                                   abbreviated up to the
                                                   indicated minimum number of
                                                   initial characters. Every
                                                   set of credentials has one
                                                   or more ssttyylleess[115]
                                                   associated with it that
                                                   indicate which
                                                   authentication method or
                                                   methods were successfully
                                                   applied and how (by what
                                                   means) the credentials were
                                                   generated within DDAACCSS. A
                                                   primary is TTrruuee if the
                                                   tested credentials satisfy
                                                   _a_l_l of the keywords in the
                                                   _s_t_y_l_e_-_l_i_s_t.

                                                   For example, this
                                                   expression tests if both
                                                   the passwd and certificate
                                                   styles are associated with
                                                   it:

                                                       user("style passwd,cert")

                                                   This is equivalent to the
                                                   following expression, which
                                                   tests if the user was
                                                   authenticated via a
                                                   username/password style of
                                                   authentication and a valid
                                                   X.509 client certificate
                                                   was presented:

                                                       user("style passwd") and user("style CERT")

                                                   The following style
                                                   keywords are understood:

                                                   acs
                                                       TTrruuee if the credentials
                                                       were created during an
                                                       authorization check by
                                                       ddaaccss__aaccss

                                                   admin
                                                       TTrruuee if the credentials
                                                       were created for use
                                                       internal to DDAACCSS.

                                                   alien
                                                       TTrruuee if the credentials
                                                       were imported by
                                                       ddaaccss__aauutthh__aaggeenntt((88))[116]
                                                       in its "alien" mode, or
                                                       by
                                                       ddaaccss__aauutthh__ttrraannssffeerr((88))[117].

                                                   cas
                                                       TTrruuee if the user was
                                                       authenticated using
                                                       CAS.

                                                   cert[ificate]
                                                       TTrruuee if the user
                                                       authenticated using an
                                                       X.509 certificate.

                                                   digest
                                                       TTrruuee if the user
                                                       authenticated using RRFFCC
                                                       22661177[89] Digest
                                                       authentication.

                                                   expr
                                                       TTrruuee if the user was
                                                       authenticated using an
                                                       expression.

                                                   gen[erated]
                                                       TTrruuee if the credentials
                                                       were generated by a
                                                       DDAACCSS utility (e.g.,
                                                       ddaaccssccooookkiiee((11))[118]).

                                                   import[ed]
                                                       TTrruuee if the credentials
                                                       were imported by
                                                       ddaaccss__aauutthh__aaggeenntt((88))[116]
                                                       or
                                                       ddaaccss__aauutthh__ttrraannssffeerr((88))[117].

                                                   infocard
                                                       TTrruuee if the user was
                                                       authenticated using an
                                                       InfoCard.

                                                   nat[ive]
                                                       TTrruuee if the user was
                                                       authenticated using the
                                                       native authentication
                                                       style.

                                                   managed_infocard
                                                       TTrruuee if the user was
                                                       authenticated using a
                                                       managed InfoCard.

                                                   pass[word]
                                                   passwd
                                                       TTrruuee if the user
                                                       authenticated using a
                                                       password.

                                                   prompt[ed]
                                                       TTrruuee if the user was
                                                       authenticated using the
                                                       prompted authentication
                                                       style.

                                                   rlink
                                                       TTrruuee if the user was
                                                       authenticated using an
                                                       RRlliinnkk[83].

                                                   selfissued_infocard
                                                       TTrruuee if the user was
                                                       authenticated using a
                                                       self-issued InfoCard.

                                                   simple
                                                       TTrruuee if the user
                                                       authenticated without
                                                       using a password.

                                                   This test can be used as
                                                   part of a risk-based
                                                   authentication
                                                   configuration; a user with
                                                   credentials obtained
                                                   through an authentication
                                                   style deemed not to be
                                                   sufficiently secure with
                                                   respect to a resource could
                                                   be forced to reauthenticate
                                                   using a stronger
                                                   authentication method. See
                                                   ddaaccss__aauutthheennttiiccaattee((88))[8] for
                                                   additional information.

                                               importedby _j_u_r_i_s_d_i_c_t_i_o_n
                                                   The keyword importedby is
                                                   followed by the name of a
                                                   jurisdiction within the
                                                   current federation; the
                                                   result is TTrruuee if the
                                                   credentials were imported
                                                   using
                                                   ddaaccss__aauutthh__ttrraannssffeerr((88))[117]
                                                   at that jurisdiction.

                                                       user("importedby METALOGIC")


                                               version _p_r_o_t_o_c_o_l_-_v_e_r_s_i_o_n
                                                   The keyword version is
                                                   followed by a DDAACCSS protocol
                                                   version number (every
                                                   release of DDAACCSS defines
                                                   this as the value of the
                                                   compile-time symbol
                                                   DACS_VERSION_NUMBER); the
                                                   result is TTrruuee if the
                                                   credentials match that
                                                   protocol version number.

                                                       user("version 1.4")


                                               authenticated, unauthenticated
                                                   Either of two keywords:
                                                   authenticated (or simply
                                                   auth) or unauthenticated
                                                   (or simply unauth). The
                                                   former is TTrruuee if the user
                                                   is authenticated, while the
                                                   latter is TTrruuee if the user
                                                   is not authenticated. A
                                                   case-insensitive string
                                                   comparison is used to match
                                                   these special names.

                                                       user("auth")
                                                       user("unauth")


                                               mine
                                                   The keyword "mine" (case
                                                   insensitive) is TTrruuee if the
                                                   user was authenticated by
                                                   the current jurisdiction.

                                                       user("mine")


                                               any
                                                   The keyword "any" (case
                                                   insensitive) is always
                                                   TTrruuee.

                                                       user("any")


                                               none
                                                   The keyword "none" (case
                                                   insensitive) is always
                                                   FFaallssee.

                                                       user("none")


                                               By default, an exact string
                                               comparison (case sensitive) is
                                               used to match name components
                                               other than the special names;
                                               this default behaviour can be
                                               overridden using the
                                               NAME_COMPARE configuration
                                               directive (ddaaccss..ccoonnff((55))[9]).
                                               The method used to compare
                                               federation names, jurisdiction
                                               names, and usernames can also
                                               be specified by following the
                                               _p_r_i_m_a_r_y with a _m_o_d_e. If the
                                               value of _m_o_d_e (which is itself
                                               case insensitive) is case, then
                                               case-sensitive comparisons are
                                               used, if its value is nocase,
                                               then case-insensitive
                                               comparisons are used, and if
                                               its value is default, then the
                                               value of the NAME_COMPARE
                                               directive will be used if
                                               present, otherwise the
                                               application default is used
                                               (either case or the value
                                               selected by the application).

                                                   IImmppoorrttaanntt
                                                   Keep in mind that uusseerr(())
                                                   can return FFaallssee because no
                                                   credentials matched the
                                                   user filter expression and
                                                   because there are no
                                                   credentials at all (i.e.,
                                                   the user is
                                                   unauthenticated). For
                                                   example,

                                                       user("not METALOGIC:rmorriso")

                                                   will return TTrruuee if the
                                                   user's identity is not
                                                   METALOGIC:rmorriso, even if
                                                   the user is not
                                                   authenticated. It may
                                                   therefore be necessary to
                                                   explicitly test for an
                                                   authenticated user:

                                                       user("not METALOGIC:rmorriso and auth")
                                               Here are examples of the uusseerr(())
                                               function. Note that any
                                               non-zero expression value
                                               implies TTrruuee.



                                                1.

                                                       user("METALOGIC:")

                                                   Return TTrruuee if the client
                                                   was authenticated by the
                                                   jurisdiction METALOGIC in
                                                   this federation

                                                2.

                                                       user("METALOGIC:rmorriso")

                                                   Return TTrruuee if the client
                                                   was authenticated as the
                                                   user METALOGIC:rmorriso

                                                3.

                                                       user("DEMO::METALOGIC:rmorriso")

                                                   Return TTrruuee if the client
                                                   was authenticated by the
                                                   given federation and
                                                   jurisdiction as rmorriso

                                                4.

                                                       user("%METALOGIC:admin")

                                                   Return TTrruuee if the client
                                                   is a member of the group
                                                   METALOGIC:admin

                                                5.

                                                       user("*:rmorriso")

                                                   Return TTrruuee if the client
                                                   was authenticated as the
                                                   username rmorriso by any
                                                   jurisdiction in this
                                                   federation

                                                6.

                                                       user("auth")

                                                   Return TTrruuee if the client
                                                   was authenticated anywhere

                                                7.

                                                       user("UnAuthenticated")

                                                   Return TTrruuee if the client
                                                   is not authenticated

                                                8.

                                                       user("10.0.0.123")

                                                   Return TTrruuee if the client
                                                   was authenticated through a
                                                   request from a host having
                                                   the IP address 10.0.0.123

                                                9.

                                                       user("not 10.0.0.123")

                                                   Return TTrruuee if the client
                                                   is unauthenticated or was
                                                   not authenticated through a
                                                   request from a host having
                                                   the IP address 10.0.0.123
                                                   (use user("auth and not
                                                   10.0.0.123") to remove the
                                                   unauthenticated case)

                                               10.

                                                       user("ANY")

                                                   Always return TTrruuee

                                               11.

                                                       user("any") gt 1

                                                   Return TTrruuee if the client
                                                   has more than one set of
                                                   current credentials (i.e.,
                                                   has authenticated as two or
                                                   more identities)

                                               12.

                                                       user(":rmorriso")

                                                   Return TTrruuee if the client
                                                   was authenticated as
                                                   rmorriso by this
                                                   jurisdiction

                                               13.

                                                       user(":rmorriso nocase")

                                                   Return TTrruuee if the client
                                                   was authenticated as
                                                   rmorriso,
                                                   case-insensitively, by this
                                                   jurisdiction

                                               14.

                                                       user("metalogic:RMORRISO nocase")

                                                   Return TTrruuee if the client
                                                   was authenticated as the
                                                   user metalogic:RMORRISO,
                                                   but comparing the
                                                   jurisdiction name,
                                                   username, and implied
                                                   federation name
                                                   case-insensitively

                                               15.

                                                       user("METALOGIC:rmorriso default")

                                                   Equivalent to
                                                   user("METALOGIC:rmorriso"),
                                                   return TTrruuee if the client
                                                   was authenticated as the
                                                   user METALOGIC:rmorriso,
                                                   but comparing the
                                                   jurisdiction name,
                                                   username, and implied
                                                   federation name according
                                                   to the NAME_COMPARE
                                                   directive, otherwise using
                                                   the application's default

                                                       TTiipp
                                                       The following two tests
                                                       are not equivalent:

                                                           user("auth")
                                                           user("DSS:auth")

                                                       The first is TTrruuee if
                                                       the user making the
                                                       request has been
                                                       authenticated; it does
                                                       matter which
                                                       jurisdiction
                                                       authenticated the user
                                                       or what the username
                                                       is. The second test
                                                       requires the user
                                                       making the request to
                                                       have a specific
                                                       identity; she must have
                                                       been authenticated by
                                                       the jurisdiction DSS as
                                                       the username auth.

                                               uussttaammpp(_o_p, _v_f_s_-_r_e_f [,_a_r_g_s ...])
                                                   This function generates a
                                                   string called a _s_t_a_m_p that
                                                   is globally unique and
                                                   sequenced, with high
                                                   probability. It has the
                                                   following syntax:

                                                       h=_h_o_s_t_i_d, s=_s_e_q_n_o

                                                   A _h_o_s_t_i_d consists of one or
                                                   more characters from the
                                                   same set used for a DDAACCSS
                                                   uusseerrnnaammee[119]. A _s_e_q_n_o
                                                   consists of two elements,
                                                   separated by a colon, each
                                                   of which is an unsigned
                                                   decimal value.

                                                   The first component of a
                                                   stamp, the _h_o_s_t_i_d, is
                                                   intended to be uniquely
                                                   associated with the host
                                                   that generates the stamp.
                                                   By default, it is a
                                                   128-bit, cryptographically
                                                   strong pseudo-random value.
                                                   This value is stored in
                                                   _v_f_s_-_r_e_f, which may be an
                                                   absolute pathname, an item
                                                   type, or a VVFFSS UURRII[61]. If
                                                   _v_f_s_-_r_e_f does not exist, it
                                                   is created and a new value
                                                   is stored in it.

                                                   Note that by default,
                                                   _h_o_s_t_i_d identifies a host,
                                                   not a jurisdiction. If
                                                   required, it is possible to
                                                   configure unique stamps for
                                                   each jurisdiction on a
                                                   host.

                                                   The second component
                                                   (_s_e_q_n_o) is a sequence
                                                   number string relative to
                                                   _h_o_s_t_i_d. Sequence numbers
                                                   should never repeat with
                                                   respect to a host and
                                                   always increase in value so
                                                   that any two sequence
                                                   numbers created by the same
                                                   host must be different.
                                                   Successive sequence numbers
                                                   need not increase by
                                                   uniform steps. If _s_t_a_m_p_1
                                                   compares less than _s_t_a_m_p_2,
                                                   then _s_t_a_m_p_1 was created
                                                   before _s_t_a_m_p_2. Comparison
                                                   of sequence numbers is
                                                   performed on matching
                                                   elements numerically, left
                                                   to right. Two _h_o_s_t_i_d
                                                   components are compared
                                                   case insensitively. No
                                                   ordering is necessarily
                                                   implied by stamps created
                                                   by different hosts.

                                                   Sequence number state
                                                   information is stored in a
                                                   file that must be specified
                                                   using the configuration
                                                   variable
                                                   _$_{_C_o_n_f_:_:_u_s_t_a_m_p___s_e_q_n_o_};
                                                   e.g.,

                                                       EVAL ${Conf::ustamp_seqno} = "${Conf::DACS_HOME}/seqno"

                                                   The variable must be set to
                                                   the absolute pathname of a
                                                   file that is readable and
                                                   writable by any process
                                                   that needs to generate a
                                                   stamp. If this file is
                                                   deleted, the sequence will
                                                   be reinitialized. Note that
                                                   updates to the state
                                                   information are unlikely to
                                                   be atomic, which means that
                                                   in the event of a system
                                                   crash the state information
                                                   should be deleted so that a
                                                   new stream of sequence
                                                   numbers is generated.

                                                   One application of these
                                                   stamps is to provide an
                                                   efficient way to detect
                                                   replayed messages. A
                                                   recipient may only need to
                                                   keep track of the stamp
                                                   sent with the last message
                                                   received from a
                                                   jurisdiction to detect an
                                                   invalid stamp in any
                                                   subsequent message.
                                                   Cryptographic techniques
                                                   can be employed to prevent
                                                   a stamp from being altered
                                                   or forged.

                                                   The following operations
                                                   are recognized:

                                                   uussttaammpp(clock, _v_f_s_-_u_r_i)
                                                       The host's system clock
                                                       is used for the stamp's
                                                       sequence number. Its
                                                       first element is the
                                                       number of seconds since
                                                       the start of the epoch
                                                       and the second is a
                                                       counter value. Note
                                                       that if the system
                                                       clock is reset to an
                                                       earlier time, sequence
                                                       numbers may repeat with
                                                       unpredictable
                                                       consequences; a future
                                                       version of this
                                                       function may detect a
                                                       reset clock.

                                                   uussttaammpp(ntpclock, _v_f_s_-_u_r_i,
                                                   _n_t_p___h_o_s_t)
                                                       _T_h_i_s _o_p_e_r_a_t_i_o_n _i_s _n_o_t
                                                       _i_m_p_l_e_m_e_n_t_e_d. Rather
                                                       than using the system
                                                       clock, this operation
                                                       obtains the current
                                                       time from _n_t_p___h_o_s_t,
                                                       which is assumed to be
                                                       more reliable than the
                                                       system clock in that it
                                                       will never be reset to
                                                       an earlier time. The
                                                       _n_t_p___h_o_s_t argument is a
                                                       hostname or IP address.
                                                       The default port number
                                                       (123) may be overridden
                                                       by appending a colon
                                                       and the port number to
                                                       use.

                                                   uussttaammpp(user, _v_f_s_-_u_r_i,
                                                   _s_e_q_n_o)
                                                       Instead of
                                                       incorporating the
                                                       current time into the
                                                       stamp's sequence
                                                       number, this operation
                                                       uses a user-supplied
                                                       string that is assumed
                                                       to have the necessary
                                                       syntax and
                                                       characteristics.

                                                   Examples:

                                                       > ustamp(clock, "${Conf::DACS_HOME}/hostid")
                                                       "h=2fbae312ddc1d2ae388cea1b57a47c66, s=1185565675:9"


                                               vvaalluueessooff(_a_l_i_s_t)
                                                   If its argument is a single
                                                   pair, the pair's value is
                                                   returned. If there is more
                                                   than one pair in the
                                                   argument, a list of values
                                                   is returned. To get the key
                                                   component of a pair or set
                                                   of pairs, use kkeeyyssooff(())[17].

                                                   Examples:

                                                       > valuesof({red, 17})
                                                       17
                                                       > valuesof({red, 17, blue, 100})
                                                       [17, 100]


                                               vvaarr(_o_p, _n_a_m_e_s_p_a_c_e,
                                               _v_a_r_i_a_b_l_e_-_n_a_m_e [, _a_r_g_s ...])
                                                   This function performs
                                                   various operations on a
                                                   variable, some of which are
                                                   awkward or impossible to do
                                                   using the more concise
                                                   variable reference syntax.
                                                   For example, the namespace
                                                   or variable name argument
                                                   to vvaarr(()) can be specified
                                                   by an expression.

                                                   The following operations
                                                   are available:

                                                   vvaarr(delete, _n_a_m_e_s_p_a_c_e,
                                                   _v_a_r_i_a_b_l_e_-_n_a_m_e)
                                                       Delete (undefine) the
                                                       variable named
                                                       _v_a_r_i_a_b_l_e_-_n_a_m_e within
                                                       _n_a_m_e_s_p_a_c_e. If the
                                                       variable is deleted, 1
                                                       is returned, and if it
                                                       does not exist, 0 is
                                                       returned.

                                                   vvaarr(exists, _n_a_m_e_s_p_a_c_e,
                                                   _v_a_r_i_a_b_l_e_-_n_a_m_e)
                                                       Test if the variable
                                                       named _v_a_r_i_a_b_l_e_-_n_a_m_e
                                                       within _n_a_m_e_s_p_a_c_e
                                                       exists, returning 1 if
                                                       so and 0 if not.

                                                   vvaarr(get, _n_a_m_e_s_p_a_c_e,
                                                   _v_a_r_i_a_b_l_e_-_n_a_m_e [, _a_l_t_v_a_l])
                                                       Return the value of the
                                                       variable named
                                                       _v_a_r_i_a_b_l_e_-_n_a_m_e within
                                                       _n_a_m_e_s_p_a_c_e. If the
                                                       variable does not
                                                       exist, _a_l_t_v_a_l is
                                                       returned if given,
                                                       otherwise the empty
                                                       string is returned
                                                       (which could
                                                       potentially be confused
                                                       with a legitimate
                                                       value).

                                                   vvaarr(set, _n_a_m_e_s_p_a_c_e,
                                                   _v_a_r_i_a_b_l_e_-_n_a_m_e, _v_a_l_u_e)
                                                       Set the value of the
                                                       variable named
                                                       _v_a_r_i_a_b_l_e_-_n_a_m_e within
                                                       _n_a_m_e_s_p_a_c_e to _v_a_l_u_e. If
                                                       _n_a_m_e_s_p_a_c_e or
                                                       _v_a_r_i_a_b_l_e_-_n_a_m_e do not
                                                       exist they are created.
                                                       If the variable already
                                                       exists, its value is
                                                       replaced. The function
                                                       returns _v_a_l_u_e.

                                                   Examples:

                                                       > ${Y::foo} = 17
                                                       17
                                                       > setvar(split, X, "/a/b/c/Y", "/")
                                                       5
                                                       > var(get, X, 4)
                                                       "Y"
                                                       > var(get, X, ${X::#} - 1)
                                                       "Y"
                                                       > var(get, var(get, X, "4"), "foo")
                                                       "17"
                                                       > var(set, Y, "f" . "o" . "o", 2007)
                                                       2007
                                                       > ${Y::foo}
                                                       2007


                                               vvffss(_o_p, _v_f_s_-_r_e_f [, _a_r_g_u_m_e_n_t
                                               ...])
                                                   This function is an
                                                   interface to the DDAACCSS
                                                   virtual filestore
                                                   subsystem, described in
                                                   ddaaccss..vvffss((55))[120]. Please
                                                   refer to ddaaccss..ccoonnff((55))[25]
                                                   and ddaaccssvvffss((11))[121] for
                                                   details and examples.

                                                   The first argument
                                                   specifies the operation to
                                                   be performed. The second
                                                   argument identifies a
                                                   filestore (typically a file
                                                   or database); it can be an
                                                   absolute pathname, an
                                                   item_type that has been
                                                   configured through a
                                                   VVFFSS[25] directive, or a VVFFSS
                                                   UURRII[61]. Zero or more
                                                   arguments may follow,
                                                   depending on _o_p. For most
                                                   operations, the third
                                                   argument will be the key
                                                   that identifies the object
                                                   of interest. The underlying
                                                   filestore is implicitly
                                                   opened and closed.

                                                   An operation that fails
                                                   abnormally triggers a fatal
                                                   error.

                                                   The following operations
                                                   (_o_p) are available:

                                                   vfs(control, _v_f_s_-_r_e_f, _c___o_p
                                                   [, _a_r_g_u_m_e_n_t]
                                                       Perform a configuration
                                                       operation on the
                                                       underlying storage
                                                       scheme. Returns TTrruuee.

                                                   vfs(defined, _i_t_e_m_-_t_y_p_e)
                                                       Test if the specified
                                                       _i_t_e_m_-_t_y_p_e has been
                                                       defined by a VVFFSS[61]
                                                       directive.

                                                           vfs(defined, "passwds")


                                                   vfs(delete, _v_f_s_-_r_e_f [,
                                                   _k_e_y])
                                                       Delete the referenced
                                                       object.

                                                   vfs(enabled [, _s_t_o_r_e_-_n_a_m_e])
                                                       With an argument, test
                                                       if the specified
                                                       _s_t_o_r_e_-_n_a_m_e can be used.
                                                       With no argument,
                                                       return a lliisstt[68] of
                                                       enabled store names.

                                                           vfs(enabled, "db") ? print("yes") : print("no");


                                                   vfs(exists, _v_f_s_-_r_e_f [,
                                                   _k_e_y])
                                                       Test whether the
                                                       referenced object
                                                       exists, returning TTrruuee
                                                       or FFaallssee.

                                                           vfs(exists, "/usr/local/dacs/conf/passwd")
                                                           vfs(exists, "file:///usr/local/dacs/conf/passwd")


                                                   vfs(get, _v_f_s_-_r_e_f [, _k_e_y])
                                                       Retrieve the referenced
                                                       object.

                                                   vfs(getsize, _v_f_s_-_r_e_f [,
                                                   _k_e_y])
                                                       Return the length, in
                                                       bytes, of the
                                                       referenced object.

                                                   vfs(list, _v_f_s_-_r_e_f)
                                                       List the keys of all
                                                       objects in the store.

                                                   vfs(put, _v_f_s_-_r_e_f, _v_a_l_u_e)
                                                   vfs(put, _v_f_s_-_r_e_f, _k_e_y,
                                                   _v_a_l_u_e)
                                                       Store an item under the
                                                       given key, replacing
                                                       any existing instance.
                                                       The value is
                                                       null-terminated.

                                                   vfs(rename, _v_f_s_-_r_e_f,
                                                   _o_l_d_k_e_y, _n_e_w_k_e_y)
                                                       Change the key
                                                       associated with an
                                                       existing item from
                                                       _o_l_d_k_e_y to _n_e_w_k_e_y.

                                                   vfs(uri, _i_t_e_m_-_t_y_p_e)
                                                       If _i_t_e_m_-_t_y_p_e has been
                                                       defined by a VVFFSS[61]
                                                       directive, return its
                                                       URI, otherwise the
                                                       empty string.

                                                           > vfs(uri, "passwds")
                                                           "[passwds]dacs-kwv-fs:/usr/local/dacs/conf/passwd?field_sep=:"


                                                   This statement sets a
                                                   variable to the contents of
                                                   the file /tmp/somefile:

                                                       ${somefile} = vfs(get, "file:///tmp/somefile")

                                                   As do this equivalent
                                                   statements:

                                                       ${somefile} = vfs(get, "/tmp/somefile")
                                                       ${somefile} = get("/tmp/somefile")

                                                   This expression lists the
                                                   files in the /tmp
                                                   directory:

                                                       vfs(list,"dacs-fs:/tmp")

                                                   These expressions 1) add a
                                                   key/value pair to a
                                                   Berkeley DB database
                                                   (/tmp/mydb.db), creating
                                                   the database file if
                                                   necessary, 2) retrieve the
                                                   value, 3) rename the key,
                                                   and 4) list the keys in the
                                                   database:

                                                       vfs(put, "dacs-db:/tmp/mydb.db", "foo", "baz");
                                                       vfs(get, "dacs-db:/tmp/mydb.db", "foo");
                                                       vfs(rename, "dacs-db:/tmp/mydb.db", "foo", "bar");
                                                       vfs(list, "dacs-db:/tmp/mydb.db");

                                                   This rule fragment denies
                                                   access if the user has
                                                   already been granted access
                                                   five times:

                                                       <deny>
                                                         if (user("auth")) {
                                                           if (vfs(exists, counter_db, ${DACS::IDENTITY})) {
                                                             ${count} = vfs(get, counter_db, ${DACS::IDENTITY});
                                                           }
                                                           else {
                                                             ${count} = 0;
                                                           }
                                                           if (${count} gt 5) {
                                                             return(1);
                                                           }
                                                           vfs(put, counter_db, ${DACS::IDENTITY}, ++${count});
                                                           return(0);
                                                         }
                                                       </deny>

                                                   The item type counter_db
                                                   would be configured in
                                                   dacs.conf; e.g.,

                                                       VFS "[counter_db]dacs-db:/usr/local/dacs/federations/counters.db"


SSEEEE AALLSSOO
       ddaaccsseexxpprr((11))[1]

BBUUGGSS
       Assorted clunky aspects of the language are likely to be replaced by
       simplified or more general approaches once requirements are clearer.
       The list and alist data types have not been fully developed and
       integrated. Assignment to a namespace would be a useful extension.

       A way to handle errors and exceptions (such as with try/catch/throw
       statements) would be nice. A switch statement and dynamically loaded
       functions are planned. A foreach statement might be useful, although
       the language has so far successfully avoided loop constructs as a way
       to limit its complexity.

       Various aspects of variables and namespaces are not implemented. A
       namespace cannot be copied by assignment; use sseettvvaarr(()).

       Input and output processing is still rather limited.

       Having to use ":" instead of ".." when matching octet ranges with
       ffrroomm(())[113] is unfortunate but avoids pesky period proliferation.

       Some of the more esoteric functions and modes of operation exist
       primarily to expose DDAACCSS core code for testing purposes.

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[122])

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[123] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

        2. Perl
           http://www.perl.org/

        3. PHP
           http://www.php.net

        4. Tcl
           http://www.tcl.tk/about

        5. isprint(3)
           http://www.freebsd.org/cgi/man.cgi?query=isprint&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        6. print()
           http://dacs.dss.ca/man/#print

        7. cast
           http://dacs.dss.ca/man/#cast

        8. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        9. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       10. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       11. environ(7)
           http://www.freebsd.org/cgi/man.cgi?query=environ&apropos=0&sektion=7&manpath=FreeBSD+7.2-RELEASE&format=html

       12. exec()
           http://dacs.dss.ca/man/#exec

       13. list()
           http://dacs.dss.ca/man/#list

       14. length()
           http://dacs.dss.ca/man/#length

       15. strchars()
           http://dacs.dss.ca/man/#strchars

       16. expression grammar
           http://dacs.dss.ca/man/#expression_grammar

       17. keysof()
           http://dacs.dss.ca/man/#keysof

       18. valuesof()
           http://dacs.dss.ca/man/#valuesof

       19. alist()
           http://dacs.dss.ca/man/#alist

       20. supported data types
           http://dacs.dss.ca/man/#data_types

       21. variable reference
           http://dacs.dss.ca/man/#variables

       22. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       23. alist construction operator
           http://dacs.dss.ca/man/#alists

       24. listref()
           http://dacs.dss.ca/man/#listref

       25. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       26. revocation list
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       27. access control rule
           http://dacs.dss.ca/man/dacs.acls.5.html

       28. on_success()
           http://dacs.dss.ca/man/#on_success

       29. AUTH_SUCCESS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS

       30. ACS_SUCCESS
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_SUCCESS

       31. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

       32. approval stamp
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

       33. dacs64 decoding
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

       34. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       35. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       36. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

       37. encode()
           http://dacs.dss.ca/man/#encode

       38. cryptographic hash
           http://en.wikipedia.org/wiki/Message_digest

       39. hash()
           http://dacs.dss.ca/man/#hash

       40. decode()
           http://dacs.dss.ca/man/#decode

       41. radix-85
           http://en.wikipedia.org/wiki/Ascii85

       42. RFC 2045
           http://www.rfc-editor.org/rfc/rfc2045.txt

       43. RFC 1738
           http://www.rfc-editor.org/rfc/rfc1738.txt

       44. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       45. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       46. execv(3)
           http://www.freebsd.org/cgi/man.cgi?query=execv&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       47. basename(1)
           http://www.freebsd.org/cgi/man.cgi?query=basename&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       48. dirname(1)
           http://www.freebsd.org/cgi/man.cgi?query=dirname&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       49. stat
           http://dacs.dss.ca/man/#stat

       50. stat(1)
           http://www.freebsd.org/cgi/man.cgi?query=stat&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       51. stat(2)
           http://www.freebsd.org/cgi/man.cgi?query=stat&apropos=0&sektion=2&manpath=FreeBSD+7.2-RELEASE&format=html

       52. printf(3)
           http://www.freebsd.org/cgi/man.cgi?query=printf&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       53. test(1)
           http://www.freebsd.org/cgi/man.cgi?query=test&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       54. mod_access
           http://httpd.apache.org/docs-2.2/mod/mod_access.html

       55. RFC 1035
           http://www.rfc-editor.org/rfc/rfc1035.txt

       56. CIDR notation
           http://en.wikipedia.org/wiki/CIDR_notation

       57. RFC 1338
           http://www.rfc-editor.org/rfc/rfc1338.txt

       58. range specification
           http://dacs.dss.ca/man/#range-spec

       59. regmatch()
           http://dacs.dss.ca/man/#regmatch

       60. user()
           http://dacs.dss.ca/man/#user

       61. vfs_uri
           http://bsd6.dss.ca/dacs/man/dacs.conf.5.html#VFS

       62. digest()
           http://dacs.dss.ca/man/#digest

       63. message authentication code
           http://en.wikipedia.org/wiki/Message_Authentication_Code

       64. Keyed-Hash Message Authentication Code (HMAC)
           http://csrc.nist.gov/publications/fips/fips198-1/FIPS-198-1_final.pdf

       65. Secure Hash Standard functions
           http://dacs.dss.ca/man/dacs.conf.5.html#SHA_functions

       66. MD5 (RFC 2104)
           http://www.rfc-editor.org/rfc/rfc2104.txt

       67. RFC 2253
           http://www.rfc-editor.org/rfc/rfc2253.txt

       68. list construction operator
           http://dacs.dss.ca/man/#lists

       69. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       70. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       71. PASSWORD_SALT_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_SALT_PREFIX

       72. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

       73. vfs()
           http://dacs.dss.ca/man/#vfs

       74. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       75. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#interpolation

       76. RFC 2898
           http://www.rfc-editor.org/rfc/rfc2898.txt

       77. RFC 3962
           http://www.rfc-editor.org/rfc/rfc3962.txt

       78. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

       79. cryptographically strong pseudo-random values
           http://www.openssl.org/docs/crypto/RAND_bytes.html

       80. strtr()
           http://dacs.dss.ca/man/#strtr

       81. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

       82. ErrorDocument directive
           http://httpd.apache.org/docs-2.2/mod/core.html#errordocument

       83. Rlinks
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       84. permalinks
           http://en.wikipedia.org/wiki/Permalink

       85. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&esektion=3&emanpath=FreeBSD+7.2-RELEASE&format=html

       86. re_format(7)
           http://www.freebsd.org/cgi/man.cgi?query=re_format&sektion=7&apropos=0&manpath=FreeBSD+7.2-RELEASE&format=html

       87. access control rules
           http://dacs.dss.ca/man/dacs.acls.5.html#elements

       88. read-only namespace
           http://dacs.dss.ca/man/#reserved_namespaces

       89. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       90. copy
           http://dacs.dss.ca/man/#setvar-copy

       91. query
           http://dacs.dss.ca/man/#setvar-query

       92. cgiparse(8)
           http://dacs.dss.ca/man/cgiparse.8.html

       93. split
           http://dacs.dss.ca/man/#setvar-split

       94. sleep(3)
           http://www.freebsd.org/cgi/man.cgi?query=sleep&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       95. sprintf(3)
           http://www.freebsd.org/cgi/man.cgi?query=sprintf&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       96. strftime(3)
           http://www.freebsd.org/cgi/man.cgi?query=strftime&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       97. strptime(3)
           http://www.freebsd.org/cgi/man.cgi?query=strptime&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       98. tr(1)
           http://www.freebsd.org/cgi/man.cgi?query=tr&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       99. DDAACCSS name
           http://dacs.dss.ca/man/dacs.1.html#naming

       00. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

       01. RFC 952
           http://www.rfc-editor.org/rfc/rfc952.txt

       02. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       03. RFC 1123
           http://www.rfc-editor.org/rfc/rfc1123.txt

       04. RFC 790
           http://www.rfc-editor.org/rfc/rfc790.txt

       05. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       06. strptime()
           http://dacs.dss.ca/man/#strptime

       07. localtime(3)
           http://www.freebsd.org/cgi/man.cgi?query=localtime&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       08. dacstransform(1)
           http://dacs.dss.ca/man/dacstransform.1.html

       09. transform_config()
           http://dacs.dss.ca/man/#transform_config

       10. concise user syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       11. transform()
           http://dacs.dss.ca/man/#transform

       12. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_CREDENTIALS_LIMIT

       13. from()
           http://dacs.dss.ca/man/#from

       14. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       15. styles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#STYLE

       16. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       17. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       18. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

       19. DACS username
           http://dacs.dss.ca/man/dacs.1.html#dacs_identity

       20. dacs.vfs(5)
           http://dacs.dss.ca/man/dacs.vfs.5.html

       21. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

       22. www.dss.ca
           http://www.dss.ca

       23. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                     DACS.EXPRS(5)
