DACS(1)                      DACS Commands Manual                      DACS(1)



NNAAMMEE
       dacs - a distributed access control system

SSYYNNOOPPSSIISS
       ddaaccss [--vv | ----vveerrbboossee] [----dduummppeennvv] [----lliicceennssee] [----vveerrssiioonn]

       ddaaccss _d_a_c_s_-_c_o_m_m_a_n_d [ddaaccssooppttiioonnss[1]] [...]

       _d_a_c_s_-_c_o_m_m_a_n_d [--uu _u_r_i_-_p_r_e_f_i_x | --uujj _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e | --uunn | --uuss]
                    [--cc _d_a_c_s_._c_o_n_f]
                    [--sscc _s_i_t_e_._c_o_n_f] [--llll _l_o_g_g_i_n_g_-_l_e_v_e_l] [--ffoorrmmaatt _f_m_t] [--qq]
                    [--tt] [--DD_n_a_m_e==_v_a_l_u_e]
                    [--vv | ----vveerrbboossee] [----dduummppeennvv] [----eennaabbllee--dduummpp] [----lliicceennssee]
                    [----ssttdd] [----vveerrssiioonn]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       DDAACCSS is a general-purpose, Web-based authentication and access control
       system. It provides single sign-on functionality and flexible access
       control to content and services provided by web servers.  DDAACCSS consists
       of an AAppaacchhee module (mmoodd__aauutthh__ddaaccss[2]) through which AAppaacchhee
       communicates with DDAACCSS to make access control decisions, a suite of CGI
       programs that provide DDAACCSS web services, and a collection of utility
       commands that provide various support and administrative functions for
       DDAACCSS. Some of these utilities, such as hhttttpp((11))[3] and ssssllcclliieenntt((11))[4],
       are completely general-purpose.

       The DDAACCSS access control engine and authentication components can also
       be used from the command line, within a CGI environment or completely
       independently of the Web.

       For important information about DDAACCSS, including installation
       instructions, please see ddaaccss..rreeaaddmmee((77))[5] and ddaaccss..iinnssttaallll((77))[6].

   AAbboouutt DDAACCSS
           NNOO WWAARRRRAANNTTYY
           This software is provided by Dss "as is" and any express or implied
           warranties, including, but not limited to, the implied warranties
           of merchantability, fitness for a particular purpose, or
           non-infringement, are disclaimed. In no event shall Dss be liable
           for any direct, indirect, incidental, special, exemplary, or
           consequential damages (including, but not limited to, procurement
           of substitute goods or services; loss of use, data, or profits; or
           business interruption) however caused and on any theory of
           liability, whether in contract, strict liability, or tort
           (including negligence or otherwise) arising in any way out of the
           use of this software, even if advised of the possibility of such
           damage.

       By convention, the names of all DDAACCSS web services begin with the prefix
       "dacs_" (e.g., ddaaccss__ccoonnff). Starting with release 1.4.17, all commands
       that implement DDAACCSS functionality begin with the prefix "dacs" (e.g.,
       ddaaccssccoonnff). Many DDAACCSS web services have command analogues. The names of
       web services that are used internally by DDAACCSS (i.e., they are never
       called directly by users) begin with "local_" (e.g.,
       llooccaall__ppaasssswwdd__aauutthheennttiiccaattee). General-purpose web services and commands
       do not follow a naming convention, other than not using any of the
       previously mentioned prefixes.

       The document type definitions (DTDs) that are maintained in the dtd-xsd
       directory are used to document file formats or describe the arguments
       to a DDAACCSS web service or its reply. In the current implementation,
       these DTD files are not used during XML validation. Attributes of type
       CDATA may have additional constraints on their values; consult the
       relevant documentation. The files are technically not valid DTDs,
       because they lack a document type declaration (DOCTYPE); an appropriate
       DOCTYPE is generated programmatically at the time a DTD is emitted.

           IImmppoorrttaanntt
           DDAACCSS does not prevent certain kinds of attacks against web sites,
           such as DDeenniiaall ooff sseerrvviiccee aattttaacckkss[7], CCrroossss--ssiittee ssccrriippttiinngg ((XXSSSS))[8]
           or CCrroossss--ssiittee rreeqquueesstt ffoorrggeerryy ((CCSSRRFF))[9]. When combined with
           appropriate web site protective measures, however, DDAACCSS does
           provide mechanisms to make these types of attacks more difficult.

   AAbboouutt tthhee MMaannuuaall PPaaggeess
       The technical documentation for DDAACCSS consists of a set of manual pages.
       In the HTML collection, an iinnddeexx ppaaggee[10] includes a table of contents,
       links to special annotations within the technical documentation, and
       lists of variables, configuration directives, and XML Document Type
       Definitions.

           TTiipp
           Each HTML manual page contains a font size selection tool near its
           bottom. If JavaScript is enabled, the currently selected font size
           can be changed and a global preference set. To choose a font size
           for the current page, click on one of the four boxes. To make the
           current selection your preference across manual pages, site visits,
           and browser sessions, click on the "set" button, which will set an
           HTTP cookie. If a preference has not been set in this way (i.e.,
           there is no cookie) and a manual page is visited with the query
           parameter _D_A_C_S_M_A_N_F_O_N_T set to 0, 1, 2, or 3 (representing smallest
           to largest point sizes), the corresponding font will be selected
           and the preference automatically set (if a preference has been set,
           the parameter is ignored).

       Areas of the documentation labeled "Security" discuss important
       security considerations; please pay special attention to them. Areas
       labeled "Tip" provide pointers to time-saving (and sometimes
       aggravation-reducing) techniques and recommended practices.

       In pathnames and URLs that appear in examples, the text "..."
       represents text that has been omitted because it is not relevant to the
       discussion at hand, or which may vary depending on configuration
       details, such as where something has been installed (e.g.,
       .../dacs/bin/http).

       Unless otherwise stated, URLs used in examples are fictitious and most
       likely will not work. The reserved domain name example.com is often
       used (RRFFCC 22660066[11]).

       In instructions and examples, a '%' is generally used to signify a
       command line prompt:

           % date
           Sun Apr  1 15:33:11 PDT 2007

       Sometimes another character is used to signify a prompt, however, such
       as when demonstrating the interactive mode of ddaaccsseexxpprr((11))[12]:

           > 1 + 1
           2

       An extended form of BBNNFF nnoottaattiioonn[13] is used to describe syntax
       concisely. We hope it is both understandable and familiar, but some
       inconsistencies and ambiguities may occur throughout the documentation;
       this is being improved slowly. A term in a production may include a
       regular expression type specification, with '+' meaning one or more
       occurrences of the term, and '*' zero or more occurrences. Any one of a
       set of characters is specified within square brackets, and a range of
       consecutive characters (in ASCII code sequence) is separated by a
       hyphen (e.g., [A-Za-z0-9\-_]+ means "one or more alphabetic characters,
       digits, hyphens, or underscores"). In other contexts, square brackets
       indicate an optional term. Single and double quotes specify literal
       characters. Note that XML DTDs use their own syntax, which is somewhat
       different, and in some cases grammars followed in relevant RFCs are
       respected for clarity or in examples.

   KKeeyy CCoonncceeppttss
       Some of the key concepts used throughout the DDAACCSS documentation are
       defined in this section.


       _a_c_c_o_u_n_t
           A persistent record that associates an identity (or username) with
           state information about the account (such as whether the account is
           enabled or disabled), information that is required to authenticate
           the identity (such as a digest of a password string), and possibly
           other sign-on related information. Note that DDAACCSS identities do not
           necessarily have a corresponding account.  DDAACCSS does not provide
           mechanisms to administer "foreign" account types; for instance,
           although it can authenticate against them, it cannot create or list
           Unix or Windows accounts.

       _a_u_t_h_e_n_t_i_c_a_t_i_o_n
           The procedure by which a person or program obtains credentials that
           represent a DDAACCSS identity, usually by asserting a DDAACCSS username
           that represents an identity and providing information that only
           that identity is likely to know or possess. After successful
           authentication, a person or program is said to have authenticated.
           DDAACCSS can interface with a wide variety of authentication methods
           and provides some of its own; new methods can easily be added.

       _a_u_t_h_o_r_i_z_a_t_i_o_n
           The procedure that determines, in a particular context, whether a
           request for a given resource or object should be allowed. If an
           identity is authorized to perform a certain operation on the
           object, access is granted, otherwise it is denied. Access control
           rules are one method of describing which identity or identities
           should be granted - or denied - access to a particular resource.
           Coarse-grained access control involves making a high-level decision
           of whether access to an object should be granted; this is usually
           an all-or-nothing decision. Fine-grained access control is used
           within a program to decide whether access to a lower-level resource
           (some data, an administrative function, a menu) should be granted.

           Note that unlike some systems, DDAACCSS does not predetermine which
           resources a particular user (identity) can and cannot access; that
           is, an administrator does not make a list of what rights each user
           has. Authorization is always determined by rule evaluation, in real
           time, when a user requests a resource. The only exemptions to this
           are some optional features: AAuutthhoorriizzaattiioonn CCaacchhiinngg[14] and
           RRlliinnkkss[15].

       _c_r_e_d_e_n_t_i_a_l_s
           If _a_u_t_h_e_n_t_i_c_a_t_i_o_n is successful, DDAACCSS returns information that can
           be used in subsequent operations to represent the authenticated
           identity. Credentials contain information about the identity, such
           as its name, and meta information, such as the time at which the
           credentials expire and become invalid. Credentials are protected
           cryptographically so that they are difficult to forge or alter.
           They must be kept secret, so that the identity cannot be used by
           anyone other than its owner, and must accompany a request made to a
           server so that DDAACCSS knows who is making the request. The particular
           mechanism used for this is not important provided credentials
           cannot be copied and reused; transporting credentials using the
           payload of an HTTP cookie over an SSL connection is typical,
           although sending credentials as the value of an HTTP extension
           header is another possibility.

           Although there is no specific limit on the size of credentials as
           far as DDAACCSS is concerned, since they can be encapsulated within an
           HTTP cookie and returned to a browser, constraints on cookies
           imposed by browsers should be carefully considered.

           Any jurisdiction can understand credentials produced by any other
           jurisdiction within the same federation. Therefore, a user only
           needs to be authenticated once to access web services at any
           jurisdiction using that identity.

           Note that in DDAACCSS, credentials do not give their owner any rights
           or convey any authorization; DDAACCSS is not a ccaappaabbiilliittyy--bbaasseedd
           ssyysstteemm[16]. Credentials simply represent a DDAACCSS identity.

           Refer to ddaaccss__aauutthheennttiiccaattee((88))[17] for details.

       _c_u_r_r_e_n_t _r_e_q_u_e_s_t
           The event that has triggered the authorization check being
           processed by ddaaccss__aaccss((88))[18] is referred to as the current request.
           For a request for a DDAACCSS-wrapped web resource, this will be the
           HTTP request that is received by the web server for the resource.
           In situations where ddaaccss__aaccss is not involved, such as when
           ddaaccsscchheecckk((11))[19] or ddaaccsseexxpprr((11))[12] are used, the current request
           and its context are specified by command line arguments or are
           obtained from the eexxeeccuuttiioonn eennvviirroonnmmeenntt[20].

           ddaaccss__aaccss uses _$_{_D_A_C_S_:_:_U_R_I_} as the path component of the current
           request. It is obtained from Apache's _u_r_i element of the current
           request_rec. This is the string that is used to match against
           access control rules.

           Other DDAACCSS components determine the current HTTP request by
           examining several environment variables: HHTTTTPP__HHOOSSTT (or SSEERRVVEERR__NNAAMMEE
           and SSEERRVVEERR__PPOORRTT), RREEQQUUEESSTT__UURRII, QQUUEERRYY__SSTTRRIINNGG, and HHTTTTPPSS.

           The value of _$_{_D_A_C_S_:_:_U_R_I_} and the path component of
           _$_{_E_n_v_:_:_R_E_Q_U_E_S_T___U_R_I_} are not necessarily the same. After an internal
           redirect, for example, the latter's value is from the original URL,
           while the former's is from the target of the redirection.

           The current request string is important because it may be used to
           determine the ccuurrrreenntt ffeeddeerraattiioonn[21] and ccuurrrreenntt jjuurriissddiiccttiioonn[22],
           and because it is used when searching for the access control rule
           to apply to the request.

       DDAACCSS
           Consisting of CGI-based web services, an AAppaacchhee 2.0/2.2 module, and
           a collection of utilities, DDAACCSS provides authentication and
           authorization functionality. Transparent, coarse-grained role-based
           access control is available for web resources.

           Programmatic, general-purpose role-based access control is
           available for virtually any program (using ddaaccsscchheecckk((11))[19]). This
           is completely decoupled from Apache.

       DDAACCSS _a_d_m_i_n_i_s_t_r_a_t_o_r
           An individual (or individuals) responsible for managing the
           operation of DDAACCSS is called a DDAACCSS administrator (sometimes just
           "the administrator"). This individual is not necessarily a system
           administrator (e.g., superuser or root), although a small number of
           optional components of DDAACCSS must execute as user or group root. The
           DDAACCSS administrator need not be an AAppaacchhee administrator; once AAppaacchhee
           has been configured for DDAACCSS it typically requires very few
           modifications thereafter. The DDAACCSS administrator is responsible for
           configuring and testing DDAACCSS (probably installing and upgrading it,
           too), managing user accounts and access control rules, safeguarding
           security, backing up configuration and data files, and so on. The
           design of DDAACCSS allows some delegation of responsibility, largely
           based on file permissions. When invoked as a web service, each of
           the identities configured as a AADDMMIINN__IIDDEENNTTIITTYY[23] is effectively a
           DDAACCSS administrator; in this context, the system superuser has no
           significance.

       DDAACCSS _i_d_e_n_t_i_t_y
           Each authenticated user is assigned a name that consists of the
           name of the authenticating jurisdiction, its federation name, and a
           username. Each of these naming components must be syntactically
           correct. In some contexts the federation name is implicit;
           sometimes the jurisdiction name is also implicit. Entities such as
           individuals (people, but also programs, devices, etc.),
           federations, jurisdictions, and groups have names. It is the
           responsibility of jurisdictions to authenticate users. The syntax,
           meanings, and uniqueness of names is also a jurisdictional issue,
           and perhaps a federation-wide issue as well.

           Each real world entity typically has a unique DDAACCSS identity, but
           this is left up to authenticating jurisdictions. Two or more
           identities are distinct if they do not refer to the same real world
           individual.  Federated identity or single sign-on (SSO) is the
           ability to recognize a user identity across jurisdictions and even
           across federations.

               IImmppoorrttaanntt
               Keep in mind that regardless of the authentication method and
               account information used, two identical usernames (relative to
               the same jurisdiction and taking into account NNAAMMEE__CCOOMMPPAARREE[24])
               are _i_m_p_l_i_c_i_t_l_y _a_s_s_u_m_e_d _t_o _r_e_f_e_r _t_o _t_h_e _s_a_m_e _i_d_e_n_t_i_t_y by DDAACCSS.
               For instance, someone who authenticated as auggie by providing
               the correct Unix password is virtually indistinguishable from
               someone who authenticated as auggie using an Information Card.
               User credentials include information about the authentication
               method involved in their creation and the uusseerr(())[25] function
               can be used to obtain this information, but it would be unwise
               to base identities on this. It is strongly advised that a new
               DDAACCSS jurisdiction carefully develop an extensible plan for user
               naming.

       DDAACCSS-_w_r_a_p_p_e_d
           A web resource is said to be DDAACCSS-wrapped if the web server
           responsible for the resource calls DDAACCSS (more specifically,
           ddaaccss__aaccss((88))[18]) to make an access control decision whenever it
           receives a request for the resource.

       _f_e_d_e_r_a_t_i_o_n
           A DDAACCSS federation consists of one or more jurisdictions. The
           jurisdictions comprising a federation coordinate information
           sharing through light-weight business practices implemented as a
           requirement of membership in a DDAACCSS federation; in other words, the
           members of a federation typically agree to observe certain rules of
           conduct to preserve overall security and so that users can obtain
           maximum benefit. A federation consisting of just one jurisdiction
           is not unusual.

       _i_t_e_m _t_y_p_e
           An item type is a name that maps to a VVFFSS[26] (virtual filestore)
           specification that configures how and where data is stored. The
           level of indirection that they provide means that access control
           rules, for example, can be configured to be in regular files, a
           Berkeley DB database, a remote database accessed by HTTP, and so on
           - all that is required is that the item type acls be properly
           configured. Some item types (like acls) are reserved and have
           special meaning to DDAACCSS, while others can be used by a DDAACCSS
           administrator for other purposes. An item type name is case
           sensitive and consists of alphanumerics, hyphens, and underscores,
           but must begin with an alphabetic character.

       _j_u_r_i_s_d_i_c_t_i_o_n
           A DDAACCSS jurisdiction is an autonomous administrative entity that
           authenticates its users, provides web services, or both. It may
           correspond to an organization, department, web server, or virtual
           host. Jurisdictions are sometimes created simply as an
           administrative convenience. Each jurisdiction is assigned a unique
           name within a federation.

           A user's home jurisdiction is a jurisdiction that can authenticate
           that user. In situations where a user has multiple credentials
           obtained from different jurisdictions, the effective home
           jurisdiction for a request depends on which credentials are
           selected during authorization processing. Configuration directives
           are available to restrict the number of sets of credentials that
           may accompany a request.

   NNaammiinngg
       DDAACCSS needs to name a variety of things so that they can be referred to
       in expressions, access control rules, configuration directives, and so
       on. While the URI syntax is used to name some kinds of objects within
       DDAACCSS, DDAACCSS also has its own concise naming schemes.

           NNoottee
           The terms current federation (current jurisdiction) and this
           federation (this jurisdiction) are used in the documentation to
           refer to the federation (jurisdiction) associated with the
           configuration context in effect while DDAACCSS processes a request.

           In general, the _f_e_d_e_r_a_t_i_o_n_-_n_a_m_e component of a name is optional; if
           absent, the current federation is assumed. Similarly, the
           _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e may be elided and the current jurisdiction is
           implied.

       Federations
           Syntax:

               _f_e_d_e_r_a_t_i_o_n_-_n_a_m_e::

           Example:

               DEMO::

           The _f_e_d_e_r_a_t_i_o_n_-_n_a_m_e (usually obtained from a FFEEDDEERRAATTIIOONN__NNAAMMEE[27]
           configuration directive) must begin with an alphabetic character
           and is followed by zero or more alphanumerics, hyphens, and
           underscores. A _f_e_d_e_r_a_t_i_o_n_-_n_a_m_e is ordinarily treated case
           sensitively (but see the NNAAMMEE__CCOOMMPPAARREE[24] configuration directive
           and the uusseerr(())[25] function for alternate behaviours). There is no
           _a _p_r_i_o_r_i limit on its length.

           The FFEEDDEERRAATTIIOONN__DDOOMMAAIINN[28] directive specifies the domain name
           suffix common to all jurisdictions in a federation.

       Jurisdictions
           Syntax:

               [[_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e:: | [::]] _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e:

           Examples:

               DEMO::DSS:
               ::DSS:
               DSS:

           The _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e (usually obtained from a
           JJUURRIISSDDIICCTTIIOONN__NNAAMMEE[29] configuration directive) must begin with an
           alphabetic character and is followed by zero or more alphanumerics,
           hyphens, and underscores. A _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e is ordinarily treated
           case sensitively (but see the NNAAMMEE__CCOOMMPPAARREE[24] configuration
           directive and the uusseerr(())[25] function for alternate behaviours).
           There is no _a _p_r_i_o_r_i limit on its length.

       Users
           Syntax:

               [[[_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e:: | [::]] _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e]:_u_s_e_r_n_a_m_e

           Examples:

               DEMO::DSS:auggie
               ::DSS:auggie
               DSS:auggie
               :auggie

           A full DDAACCSS identity includes a federation name component and a
           jurisdiction name component, in addition to the _u_s_e_r_n_a_m_e. It is
           provided to DDAACCSS-wrapped programs as the value of the
           DDAACCSS__IIDDEENNTTIITTYY[30] environment variable.

           The username component, which is available to CGI programs as the
           value of the DDAACCSS__UUSSEERRNNAAMMEE[31] environment variable, consists of
           one or more ASCII characters from the set of upper and lower case
           alphabetics, digits, and the following punctuation characters:

               ! # $ % & ' - . ; ? @ [ ^ _ ` { }

           All characters having a value less than 041 (octal) or greater than
           0176 (octal) are _i_n_v_a_l_i_d, as are the following characters:

               * , : + ( ) ~ < > = | \ / "


               NNootteess
               +o   In addition to the alphanumeric characters, RRFFCC 22339966[32]
                   allows only the following characters ("_p_c_h_a_r") to appear in
                   the path component of a URI:

                       - _ . ! ~ * ' ( ) % : @ & = + $ ,


               +o   Some valid email addresses are not valid DDAACCSS usernames.
                   For example, *bob*@example.com, "(bob)"@example.com, and
                   \(bob\)@example.com are valid mailbox names as defined by
                   RRFFCC 882222[33] (Appendix D) and discussed in RRFFCC 33669966[34]
                   (Section 3), but both are invalid as DDAACCSS usernames. Unless
                   quoted, the local-part component of an email address, which
                   precedes the "@" character in the addr-spec, may not
                   contain any of:

                       ( ) <  > @ , ; : \ " . [ ]

                   Additionally, the space and all US-ASCII control characters
                   (octets 0 - 31) and DEL (127) are disallowed. Without
                   quotes, the local-part may consist of any combination of
                   alphabetics, digits, or any of the following characters:

                       ! # $ % & ' * + - / = ?  ^ _ ` . { | } ~

                   A period (".") may be used, but may not start or end the
                   local-part, nor may two or more consecutive periods appear.
                   Within double quotes, any ASCII character may appear if
                   properly quoted (e.g., Auggie."
                   ".O."\'".Doggie@example.com). The maximum length of the
                   local-part is 64 characters, and the maximum length of the
                   domain component that appears after the "@" character is
                   255 characters.

                   There is currently no way to "quote" a DDAACCSS username, so
                   some safe encoding method or transformation must be applied
                   to these names.

               +o   DDAACCSS may create identities for internal use having username
                   components that include characters that are normally
                   invalid.

               +o   A _u_s_e_r_n_a_m_e is case sensitive (but see the NNAAMMEE__CCOOMMPPAARREE[24]
                   configuration directive and the uusseerr(())[25] function for
                   alternate behaviours). There is no _a _p_r_i_o_r_i limit on its
                   length.

               +o   The recommended practice is for jurisdictions to map their
                   DDAACCSS usernames to lower case during the authentication
                   procedure where possible and when the mappings are unique.
                   The EEXXIITT**[35] directive may be used for this purpose.

           Groups
               Syntax:

                   [[_f_e_d_e_r_a_t_i_o_n_-_n_a_m_e:: | [::]] %[_j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e]:_g_r_o_u_p_n_a_m_e

               A _g_r_o_u_p_n_a_m_e must begin with an alphabetic character and may be
               followed by any number of alphanumeric, hyphen ("-"), and
               underscore ("_") characters.

               Examples:

                   %DEMO::DSS:friends
                   %::DSS:friends
                   %DSS:friends
                   %:friends


           Roles and Role Descriptors
               Syntax:

                   _R_o_l_e_-_D_e_s_c_r_i_p_t_o_r -> _E_m_p_t_y_-_S_t_r_i_n_g | _R_o_l_e_-_L_i_s_t

                   _R_o_l_e_-_L_i_s_t       -> _R_o_l_e | _R_o_l_e "," _R_o_l_e_-_L_i_s_t

                   _R_o_l_e            -> _B_a_s_i_c_-_R_o_l_e | _C_o_m_p_o_s_i_t_e_-_R_o_l_e

                   _B_a_s_i_c_-_R_o_l_e      -> [A-Za-z0-9\-_]+
                   _C_o_m_p_o_s_i_t_e_-_R_o_l_e  -> _B_a_s_i_c_-_R_o_l_e "/" _B_a_s_i_c_-_R_o_l_e | _B_a_s_i_c_-_R_o_l_e "/" _C_o_m_p_o_s_i_t_e_-_R_o_l_e

                   _E_m_p_t_y_-_S_t_r_i_n_g    -> ""

               A role descriptor string (also called a role string or a role
               descriptor) consists of a comma separated list of roles. The
               name of a role (a _B_a_s_i_c_-_R_o_l_e) is constructed from upper and
               lower case letters, digits, hyphens, and underscores. A
               _C_o_m_p_o_s_i_t_e_-_R_o_l_e is constructed from two or more _B_a_s_i_c_-_R_o_l_e
               terms, separated by a slash character. Here are three examples
               of a role descriptor:

                   admin,wheel,root
                   admin/hardware
                   networks/programming,computer-science/systems/Project_X


                   NNoottee
                   A role descriptor string contains no white space characters
                   and may not begin or end with a comma or slash character.
                   Two or more consecutive commas are illegal, as are two or
                   more consecutive slashes.
               The sseettvvaarr(())[36] function can be used to separate a composite
               role into its basic roles.

               Please refer to ddaaccss..ggrroouuppss((55))[37] for additional information.

           Concise User Syntax
               Syntax:

                   _i_d_e_n_t     -> '{' _k_w_v_-_l_i_s_t '}' | _u_s_e_r
                   _k_w_v_-_l_i_s_t  -> _k_w_v [',' _k_w_v]*
                   _k_w_v       -> _k_w_v_-_u_s_e_r | _k_w_v_-_g_r_o_u_p | _k_w_v_-_a_t_t_r | _k_w_v_-_i_p | _k_w_v_-_e_x_p_i_r_e_s
                   _k_w_v_-_u_s_e_r    -> 'u=' [Q] _u_s_e_r [Q]
                   _k_w_v_-_g_r_o_u_p   -> 'g=' [Q] _g_r_o_u_p_s [Q]
                   _k_w_v_-_a_t_t_r    -> 'a=' [Q] _a_t_t_r [Q]
                   _k_w_v_-_e_x_p_i_r_e_s -> 'e=' [Q] _e_x_p_i_r_e_s [Q]
                   _k_w_v_-_i_p      -> 'ip=' [Q] _i_p_-_a_d_d_r [Q]

                   _u_s_e_r      -> _s_i_m_p_l_e_-_n_a_m_e | _D_A_C_S_-_i_d_e_n_t_i_t_y
                   _g_r_o_u_p_s    -> _g_r_o_u_p [',' _g_r_o_u_p]*
                   _g_r_o_u_p     -> _g_r_o_u_p_n_a_m_e | _r_o_l_e_-_d_e_s_c_r_i_p_t_o_r
                   _a_t_t_r      -> _a_n_y_-_a_l_p_h_a_b_e_t_i_c
                   _i_p_-_a_d_d_r   -> _a_n_y_-_I_P_-_a_d_d_r
                   _e_x_p_i_r_e_s   -> +_r_e_l_-_s_e_c_s | _d_a_t_e

               where:

               +o   Q is an optional (matched) quote character;

               +o   whitespace may optionally precede most tokens;

               +o   a _D_A_C_S_-_i_d_e_n_t_i_t_y is a full or abbreviated DDAACCSS iiddeennttiittyy[38]

               +o   a _s_i_m_p_l_e_-_n_a_m_e is the _u_s_e_r_n_a_m_e component of a DDAACCSS identity
                   (i.e., without any colons); consequently in this context a
                   "special" name, such as auth, is treated as :auth

               +o   _r_o_l_e_-_d_e_s_c_r_i_p_t_o_r must be a valid DDAACCSS role string and
                   _g_r_o_u_p_n_a_m_e must be a valid DDAACCSS group name (see
                   ddaaccss__aauutthheennttiiccaattee((88))[39] and ddaaccss..ggrroouuppss((55))[40]);

               +o   an IP address is expressed in the Internet standard numeric
                   dot notation (e.g., 10.0.0.1); and

               +o   the lifetime of credentials derived from the identity can
                   be expressed either as a given number of seconds (e.g,
                   "e=+3600") or a given date in one of the following formats
                   (see ssttrrppttiimmee((33))[41]):

                       %a, %d-%b-%Y %H:%M:%S GMT
                       %d-%b-%Y
                       %b %d, %Y
                       %b %d
                       %Y-%m-%dT%H:%M:%SZ

                   When necessary, dates are interpreted relative to the
                   current time or date. The lifetime is converted to its
                   canonical form, which is the absolute time and date in
                   seconds since the Epoch, based on the jurisdiction's clock.
                   A date in the past can be specified; this might be useful
                   for testing, for instance. If the identity is not used to
                   create credentials, the expiry date is ignored, although it
                   must be syntactically correct.

               +o   the only supported attribute value is "a", which means that
                   the identity should be treated as an AADDMMIINN__IIDDEENNTTIITTYY[23]
                   (refer to the --aaddmmiinn flag of ddaaccsscchheecckk((11))[19]).

                   A name expressed in the concise syntax, gives a username
                   and, optionally, roles and attributes for the identity. It
                   is used by ddaaccsscchheecckk((11))[19], for instance.

   TThhee ddaaccss UUttiilliittyy
       DDAACCSS utility commands are usually installed as separate binaries, but
       DDAACCSS can (also or instead) be built with most of them combined into a
       single binary that is installed as ddaaccss. The various utility programs
       may then be run as:

           % dacs _d_a_c_s_-_c_o_m_m_a_n_d [_d_a_c_s_o_p_t_i_o_n_s] [_c_o_m_m_a_n_d_-_o_p_t_i_o_n_s]

       For example:

           % dacs dacskey -u foo.myfed.com outfile

       Running the ddaaccss utility without arguments will show the list of
       available sub-commands.

   SSttaarrtt--uupp PPrroocceessssiinngg
       Most DDAACCSS programs perform the following actions when they start:

        1. Process a standard set of command line arguments (_d_a_c_s_o_p_t_i_o_n_s[42])

        2. Set the process umask to 007 to disallow world access for any
           created files

        3. Disable a core dump so that sensitive information cannot be
           revealed by examining them (but see ----eennaabbllee--dduummpp[43])

        4. Refuse to operate if any configuration file cannot be found or has
           an error

        5. For web services, make the DDAACCSS home directory the current working
           directory

        6. If "secure mode" has been enabled, web services will only process
           HTTPS requests

        7. Verify that the version required by a request is compatible with
           the version of DDAACCSS receiving the request

        8. Process any program-specific command line arguments.


       DDAACCSS programs make an effort to destroy sensitive information (such as
       passwords) as soon as it is no longer needed and not to write
       potentially sensitive information to log files unless specifically
       configured to do so.

   IInntteerrnnaallss
       Some DDAACCSS components may call other components using HTTP (possibly
       over SSL, depending on configuration). For example, authentication
       modules may be invoked as web services by ddaaccss__aauutthheennttiiccaattee((88))[39]. In
       all cases, these "internal" HTTP calls may not result in a redirection,
       such as through a 302 Found status code. Although this can sometimes be
       an inconvenience, it is, in part, a security measure.

           TTiipp
           When debugging a problem that may involve an internal HTTP request
           (especially related to authentication), verify that DDAACCSS is not
           receiving a redirect. Internal HTTP requests may also fail
           mysteriously because of incorrect or incomplete configuration of
           SSL parameters. Internal HTTP requests over SSL use
           ssssllcclliieenntt((11))[4], as does the hhttttpp((11))[3] command. If you suspect
           that an https-schemed URL may not be working, debug the problem
           using ssssllcclliieenntt and then hhttttpp.

       To maintain data consistency, DDAACCSS creates exclusive locks using the
       ffccnnttll((22))[44] system call on files written in the directory configured
       through the TTEEMMPP__DDIIRREECCTTOORRYY[45] directive.

   LLooggggiinngg
       Most DDAACCSS services and utilities write various kinds of messages to one
       or more log files. These messages can be invaluable when trying to
       figure out what DDAACCSS is doing, for security audits, or to see which
       DDAACCSS-wrapped resources are being accessed and in what ways.

       Please refer to ddaaccss..ccoonnff((55))[46] for information about configuration
       directives related to logging. An assortment of command line flags,
       described below, are also related to logging.

           NNoottee
           +o   DDAACCSS can emit log messages before configuration processing is
               complete and configuration directives associated with logging
               are not in effect during this startup interval.

           +o   Because mmoodd__aauutthh__ddaaccss[2] is an AAppaacchhee module, the AAppaacchhee
               logging directives apply to it (and not the DDAACCSS directives)
               and its log messages are written to AAppaacchhee log files.

           +o   Log files can quickly become large, especially when the logging
               level is set to debug or trace levels. Consider daily rotation
               or truncation.

           +o   The text of a log message may occasionally span several lines.

       The default value of the LLOOGG__FFOORRMMAATT[47] directive, which controls the
       appearance of log messages, is defined in include/local.h as
       LOG_FORMAT_DEFAULT_WEB for DDAACCSS web services and LOG_FORMAT_DEFAULT_CMD
       for everything else. Here is a typical log message:

           [Wed Jul 12 12:37:09 2006] [trace] [83648,1060,-] [dacs_acs:"acslib"] Allow
           clause grants access

       AAuuddiitt--CCllaassss LLoogg MMeessssaaggeess
           In the case of audit-class messages, a string within parentheses
           may sometimes follow an identity, as in the examples below. This
           string, called a tracker, associates log messages with a particular
           origin and can be used to trace a user's sequence of service
           requests using log messages throughout a federation. This can be
           useful when debugging, looking for security problems, or forensic
           analysis.

           For an unauthenticated user, the tracker can only be derived
           heuristically, from elements of the execution context. The user's
           IP address, user agent string, and SSL client certificate, when
           available, are used. If two of these tracker strings differ, the
           requests are typically coming from different hosts, browsers, or
           users, but this is not necessarily always the case. Similarly, if
           the same tracker string is associated with two log messages, the
           service requests are not necessarily being issued by the same user.

           For an authenticated user, the tracker string consists of the
           heuristically-derived string, followed by a comma, followed by a
           string uniquely associated with the user's credentials. This
           tracker has a high probability of being unique and having a
           one-to-one mapping with a particular user.

           Consider these (condensed) log file entries:

               [Wed Jul 12 15:56:24 2006] [notice] [83963,1067,A] [dacs_acs:"authlib"]
                *** Access granted to unauthenticated user (7vJLWzv5) from 10.0.0.124
                for /cgi-bin/dacs/dacs_current_credentials

               [Wed Jul 12 15:56:27 2006] [notice] [83965,1073,A] [dacs_acs:"authlib"]
                *** Access granted to unauthenticated user (7vJLWzv5) from 10.0.0.124
                for /cgi-bin/dacs/dacs_authenticate

               [Wed Jul 12 15:56:27 2006] [debug] [83966,172,A] [dacs_authenticate:"authlib"]
                Authentication succeeded for HOME:bobo (7vJLWzv5,wA/Pudyp3f0)

               [Wed Jul 12 15:56:30 2006] [notice] [83973,1078,A] [dacs_acs:"authlib"]
                *** Access granted to DSS::HOME:bobo (7vJLWzv5,wA/Pudyp3f0)
                from 10.0.0.124 for /cgi-bin/dacs/dacs_current_credentials

           In the first two of the log messages above, the tracker 7vJLWzv5
           appears, meaning that the two requests probably came from the same
           (unauthenticated) user. With the third log message, the user has
           been authenticated and the tracker 7vJLWzv5,wA/Pudyp3f0 is used.
           Because these trackers all share the same prefix, the first two
           requests probably also came from someone who authenticated as
           DSS::HOME:bobo. The last request, for
           /cgi-bin/dacs/dacs_current_credentials, definitely came from that
           user. If this user were to signout and then issue more service
           requests anywhere in the federation DSS, each log message would
           contain the tracker 7vJLWzv5.

               SSeeccuurriittyy
               Tracking the requests of anonymous users reliably is difficult
               to do well. A cookie-based approach may do better in some
               situations but has its own drawbacks (such as being totally
               ineffective when the user has disabled cookies).

   TTrraacckkiinngg UUsseerr AAccttiivviittyy
       DDAACCSS includes a feature, enabled as a build-time option (see
       ddaaccss..iinnssttaallll((77))[48]), whereby a jurisdiction can track the activity of
       all of its users (i.e., those users that authenticate at the
       jurisdiction). Each successful authentication event, explicit signout
       event, and user-submitted web service request event can be recorded at
       the user's home jurisdiction in the format defined by
       ddaaccss__uusseerr__iinnffoo..ddttdd[49]. This information can be valuable for getting a
       better understanding of what is happening in a federation, including
       helping to diagnose performance and security issues. It is the basis of
       features like displays of recent account activity, and it might also be
       used to create new capabilities, such as a concurrent login limit or an
       adaptive authentication component to implement layered authentication
       or risk-based authentication.

       To specify where and how a home jurisdiction should maintain these
       records, the user_info item type must be defined at that jurisdiction;
       if it is not defined, no records will be written at that jurisdiction,
       although the jurisdiction will still try to send event records to other
       jurisdictions. For maximum benefit, the feature should be enabled at
       all jurisdictions in a federation since all user activity throughout
       the federation can then be logged.

       If a jurisdiction wants to monitor the activity of its users at other
       jurisdictions, it must allow those jurisdictions to invoke its
       ddaaccss__vvffss((88))[50] service by adding an appropriate access control rule.

           SSeeccuurriittyy
           It is critical for any such rule to require the ddaaccss__aaddmmiinn(())[51]
           predicate.

           NNoottee
           +o   The ddaaccss__aaddmmiinn((88))[52] tools provides an interface to these
               records. It should eventually be extended to collect and
               organize records found at all jurisdictions in a federation to
               facilitate analysis. Because they are text files with a
               relatively simple format, administrators should not find it
               difficult to apply common text processing tools or write short,
               custom programs for this purpose. Commands analogous to
               llaasstt((11))[53], wwhhoo((11))[54], and ssaa((88))[55] are being considered.

           +o   Each jurisdiction should write records to its own place (i.e.,
               jurisdictions should not share the same VFS object for
               user_info).

           +o   This database will grow indefinitely; an administrator is
               responsible for rotating or truncating it. If previous and
               active sign on information is important (see
               ddaaccss__ccuurrrreenntt__ccrreeddeennttiiaallss((88))[56]), prune only the request
               records (i.e., the acs elements). Another acceptable method is
               to discard (or archive) some proportion of older records (say,
               half) and keep some of the newer records.

           +o   The data format is subject to change.

           +o   A directive to enable or disable this feature at run-time may
               be added.

           +o   Internal administrative events are not recorded.

           +o   Because logging off (via ddaaccss__ssiiggnnoouutt((88))[57]) is optional, the
               end of a session can sometimes only be inferred or approximated
               from the expiry of credentials or the time of the last recorded
               event.


OOPPTTIIOONNSS
       DDAACCSS programs and web services get much of their run-time configuration
       information by reading configuration files and examining environment
       variables. Some configuration information can be provided at
       compile-time. Several command line flags may be used to override
       default behaviour.

           NNoottee
           +o   All _d_a_c_s_o_p_t_i_o_n_s flags are processed left-to-right and must
               appear before any command-specific flag or argument. The first
               flag or argument that is not recognized as one of the
               _d_a_c_s_o_p_t_i_o_n_s terminates the list.

           +o   The most important _d_a_c_s_o_p_t_i_o_n_s are those that specify the
               location of configuration files and identify the jurisdiction
               section to use within a configuration file. Depending on the
               program and how it is used, configuration information may not
               be needed, may be optional, or may be required.

           +o   At most one of the command line flags to select a jurisdiction
               section can be specified. Refer to ddaaccss..ccoonnff((55))[46] for
               additional information on the configuration file and
               configuration processing.

       Many DDAACCSS utilities recognize the following standard options, which are
       called _d_a_c_s_o_p_t_i_o_n_s:

       --cc _d_a_c_s_._c_o_n_f
           This tells DDAACCSS where it can find a configuration file for the
           jurisdiction on whose behalf it is acting. If this argument is not
           present, depending on how it was built, DDAACCSS may either try to use
           a compile-time specified file or it will try to use the value of
           the environment variable DDAACCSS__CCOONNFF[58]. For details, refer to
           LLooccaattiinngg ddaaccss..ccoonnff aanndd ssiittee..ccoonnff[59].

       --DD_n_a_m_e==_v_a_l_u_e
           The effect of this flag is to define variable _n_a_m_e (which must be
           syntactically valid) in the _D_A_C_S namespace to have the value _v_a_l_u_e.
           Any quotes around _v_a_l_u_e are retained, provided the shell has not
           already stripped them off. This flag may be repeated. These
           variables can subsequently be tested during configuration
           processing and rule processing; for example, the value of a
           configuration directive might depend on the value of a _d_a_c_s_o_p_t_i_o_n_s
           flag. Defining a _n_a_m_e that happens to correspond to a _d_a_c_s_o_p_t_i_o_n_s
           flag has no effect other than to create the variable.

           All _d_a_c_s_o_p_t_i_o_n_s flags (_e_x_c_l_u_d_i_n_g _t_h_i_s _o_n_e) are automatically added
           to the _D_A_C_S namespace as they are processed. A flag that is a
           "singleton" (e.g., --qq) is initially assigned a value of one and is
           incremented on each subsequent appearance. A flag of the form _-_f_l_a_g
           _v_a_l_u_e is equivalent to --DD_-_f_l_a_g==_v_a_l_u_e. Unused flags are undefined;
           if --qq is not given, _$_{_D_A_C_S_:_:_-_q_} will not be defined. For those
           flags that have synonyms, a variable for each synonym is created.
           If the _n_a_m_e is used, explicitly or implicitly, later values replace
           earlier ones.

           For example, if the _d_a_c_s_o_p_t_i_o_n_s are:

               -c www.example.com -v --verbose -Dfoo="baz" -ll debug -D-ll=trace

           then variables will be defined as follows:

               ${DACS::-c} is "www.example.com"
               ${DACS::-v} is "2"
               ${DACS::--verbose} is "2"
               ${DACS::foo} is "\"baz\""
               ${DACS::-ll} is "trace"

           The debugging level will be debug and not trace.

       ----dduummppeennvv
           Print all environment variables to stdout and then exit
           immediately.

       ----eennaabbllee--dduummpp
           By default, DDAACCSS web services and most commands disable core dump
           generation as a security precaution. Because a core dump can be
           useful when debugging, this flag allows it to be created. As
           programs that are allowed to produce a core dump must change to the
           _D_A_C_S___H_O_M_E directory, core dumps will be written there. Use this
           flag with care.

       --ffoorrmmaatt _f_m_t
           The output format is set to _f_m_t, which is one of the following
           keywords (case insensitive): file, html, json, php, plain, text,
           xml, xmldtd, xmlsimple, or xmlschema. Not all output formats are
           supported by all programs. This flag overrides any FFOORRMMAATT[60]
           argument to a web service, which in turn overrides a program's
           default format. The default format depends on the particular
           program and way it is invoked. For additional information, refer to
           the ddeessccrriippttiioonn ooff tthhee _F_O_R_M_A_T argument[60].

       --llll _l_o_g_g_i_n_g_-_l_e_v_e_l
           The logging level is set to _l_o_g_-_l_e_v_e_l, which is one of the keywords
           recognized by the LLOOGG__FFIILLTTEERR[61] directive.

       ----lliicceennssee
           Print the license for DDAACCSS to stdout and then exit immediately.

       --qq
           Be quiet. This is equivalent to setting the logging level to warn.

       --sscc _s_i_t_e_._c_o_n_f
           This tells DDAACCSS that it can find a configuration file for the
           jurisdiction on whose behalf it is acting. If this argument is not
           present, depending on how it was built, DDAACCSS may either try to use
           a compile-time specified file or it will try to use the value of
           the environment variable DDAACCSS__CCOONNFF[58]. For details, refer to
           LLooccaattiinngg ddaaccss..ccoonnff aanndd ssiittee..ccoonnff[59].

       ----ssttdd
           This flags the end of the common arguments. The next command line
           argument, if any, is specific to the program.

       --tt
           Emit tracing information. This is equivalent to setting the logging
           level to trace. (Also see ddeebbuugg__ddaaccss[62].)

       --uu _c_o_n_f_i_g_-_u_r_i
           This instructs DDAACCSS to use _c_o_n_f_i_g_-_u_r_i to select the jurisdiction
           section to use in the configuration file. For details, refer to TThhee
           JJuurriissddiiccttiioonn SSeeccttiioonn[63].

       --uujj _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e
           This instructs DDAACCSS to use the jurisdiction name _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e
           to select the jurisdiction section to use in the configuration
           file. For details, refer to TThhee JJuurriissddiiccttiioonn SSeeccttiioonn[63].

       --uunn
           This instructs DDAACCSS not to process site.conf or dacs.conf. This may
           only be used with a small number of commands, such as
           ddaaccssaaccll((11))[64] and ssssllcclliieenntt((11))[4].

       --uuss
           This instructs DDAACCSS to use the one-and-only jurisdiction section
           that appears in the configuration file. That is, the configuration
           file must contain exactly one jurisdiction section and that is the
           one that should be used. For details, refer to TThhee JJuurriissddiiccttiioonn
           SSeeccttiioonn[63].

       --vv
       ----vveerrbboossee
           Be more verbose, relative to the current logging level. This flag
           may be repeated.

       ----vveerrssiioonn
           Print version information to stderr immediately and then exit. If
           --vv appeared earlier on the command line, also print version
           information for each DDAACCSS source code file in this program.

               NNoottee
               Complete version information is available only for statically
               linked programs. Also see ddaaccssvveerrssiioonn((11))[65] and
               ddaaccss__vveerrssiioonn((88))[66].

           TTiipp
           If no command line flag is given to specify the jurisdiction
           section, the value of the environment variable DDEEFFAAUULLTT__JJUURRIISSDDIICCTTIIOONN
           will be used as if given with the --uujj flag. This can be
           particularly useful when a host has only one jurisdiction
           configured because it makes it unnecessary to always specify the
           jurisdiction for DDAACCSS commands.

EENNVVIIRROONNMMEENNTT
       SSEERRVVEERR__NNAAMMEE, SSEERRVVEERR__PPOORRTT, RREEQQUUEESSTT__UURRII
           May be used to determine the applicable jurisdiction.

FFIILLEESS
       dacs.conf

       site.conf

SSEEEE AALLSSOO
       DDAACCSS mmaannuuaall ppaaggeess[67], ddaaccss__aaddmmiinn((88))[52], ddaaccss..iinnssttaallll((77))[6],
       ddaaccss..rreeaaddmmee((77))[5]

BBUUGGSS
       There should be some assistance for administering uusseerr aaccttiivviittyy
       rreeccoorrddss[68].

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[69])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[70] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

        3. http(1)
           http://dacs.dss.ca/man/http.1.html

        4. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

        5. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

        6. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        7. Denial of service attacks
           http://en.wikipedia.org/wiki/Denial-of-service_attack

        8. Cross-site scripting (XSS)
           http://en.wikipedia.org/wiki/Cross-site_scripting

        9. Cross-site request forgery (CSRF)
           http://en.wikipedia.org/wiki/Cross-site_request_forgery

       10. index page
           http://dacs.dss.ca/man/index.html

       11. RFC 2606
           http://www.rfc-editor.org/rfc/rfc2606.txt

       12. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       13. BNF notation
           http://en.wikipedia.org/wiki/Backus%E2%80%93Naur_form

       14. Authorization Caching
           http://dacs.dss.ca/man/dacs_acs.8.html#authorization_caching

       15. Rlinks
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       16. capability-based system
           http://en.wikipedia.org/wiki/Capabilities

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#credentials

       18. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       19. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

       20. execution environment
           http://www.freebsd.org/cgi/man.cgi?query=environ&apropos=0&sektion=7&manpath=FreeBSD+7.2-RELEASE&format=html

       21. current federation
           http://dacs.dss.ca/man/#current_federation

       22. current jurisdiction
           http://dacs.dss.ca/man/#current_jurisdiction

       23. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

       24. NAME_COMPARE
           http://dacs.dss.ca/man/dacs.conf.5.html#NAME_COMPARE

       25. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       26. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       27. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       28. FEDERATION_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_DOMAIN

       29. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       30. DACS_IDENTITY
           http://dacs.dss.ca/man/dacs_acs.8.html#var_env_dacs_identity

       31. DACS_USERNAME
           http://dacs.dss.ca/man/dacs_acs.8.html#var_env_dacs_username

       32. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       33. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

       34. RFC 3696
           http://www.rfc-editor.org/rfc/rfc3696.txt

       35. EXIT*
           http://dacs.dss.ca/man/dacs_authenticate.8.html#auth_directive_index

       36. setvar()
           http://dacs.dss.ca/man/dacs.exprs.5.html#setvar

       37. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#roles

       38. DACS identity
           http://dacs.dss.ca/man/#dacs_identity

       39. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       40. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       41. strptime(3)
           http://www.freebsd.org/cgi/man.cgi?query=strptime&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       42. _d_a_c_s_o_p_t_i_o_n_s
           http://dacs.dss.ca/man/#dacsoptions

       43. --enable-dump
           http://dacs.dss.ca/man/#enable-dump-arg

       44. fcntl(2)
           http://www.freebsd.org/cgi/man.cgi?query=fcntl&apropos=0&sektion=2&manpath=FreeBSD+7.2-RELEASE&format=html

       45. TEMP_DIRECTORY
           http://dacs.dss.ca/man/dacs.conf.5.html#TEMP_DIRECTORY

       46. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       47. LOG_FORMAT
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FORMAT

       48. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html#configure_options

       49. dacs_user_info.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_user_info.dtd

       50. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

       51. dacs_admin()
           http://dacs.dss.ca/man/dacs.exprs.5.html#DACS_ADMIN

       52. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       53. last(1)
           http://www.freebsd.org/cgi/man.cgi?query=last&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       54. who(1)
           http://www.freebsd.org/cgi/man.cgi?query=who&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       55. sa(8)
           http://www.freebsd.org/cgi/man.cgi?query=sa&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

       56. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       57. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       58. DACS_CONF
           http://dacs.dss.ca/man/dacs_acs.8.html#var_env_dacs_conf

       59. Locating dacs.conf and site.conf
           http://dacs.dss.ca/man/dacs.conf.5.html#locating_dacs.conf

       60. FORMAT
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       61. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#logging_levels

       62. debug_dacs
           http://dacs.dss.ca/man/dacs_acs.8.html#debug_dacs

       63. The Jurisdiction Section
           http://dacs.dss.ca/man/dacs.conf.5.html#jurisdiction_section

       64. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       65. dacsversion(1)
           http://dacs.dss.ca/man/dacsversion.1.html

       66. dacs_version(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       67. DACS manual pages
           http://dacs.dss.ca/man/../man/index.html

       68. user activity records
           http://dacs.dss.ca/man/#tracking_user_activity

       69. www.dss.ca
           http://www.dss.ca

       70. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                           DACS(1)
