IF(NOT QtMobility_FOUND)
  FIND_PACKAGE(QtMobility QUIET NO_MODULE)
ENDIF()

IF(NOT QtMobility_FOUND)
  SET(QtMobility_DIR "/usr/include/qtmobility/" CACHE PATH "Root of QtMobility source tree")
  MARK_AS_ADVANCED(QtMobility_DIR)

  FIND_PATH(QTMOBILITY_QTSERVICEFW_INCLUDE_DIR QServiceManager
            PATHS ${QtMobility_DIR}/include NO_DEFAULT_PATH)

  FIND_LIBRARY(QTMOBILITY_QTSERVICEFW_LIBRARY_DEBUG QtServiceFrameworkd
               PATHS ${QtMobility_DIR} NO_DEFAULT_PATH)

  FIND_LIBRARY(QTMOBILITY_QTSERVICEFW_LIBRARY_RELEASE QtServiceFramework
               PATHS ${QTMOBILITY_LIBRARY_DIR} NO_DEFAULT_PATH)

  SET(QTMOBILITY_QTSERVICEFW_LIBRARIES )
  IF(QTMOBILITY_QTSERVICEFW_LIBRARY_RELEASE AND QTMOBILITY_QTSERVICEFW_LIBRARY_DEBUG)
    SET(QTMOBILITY_QTSERVICEFW_LIBRARIES 
        optimized ${QTMOBILITY_QTSERVICEFW_LIBRARY_RELEASE} 
        debug     ${QTMOBILITY_QTSERVICEFW_LIBRARY_DEBUG})
  ELSEIF(QTMOBILITY_QTSERVICEFW_LIBRARY_DEBUG)
    SET(QTMOBILITY_QTSERVICEFW_LIBRARIES ${QTMOBILITY_QTSERVICEFW_LIBRARY_DEBUG})
  ELSEIF(QTMOBILITY_QTSERVICEFW_LIBRARY_RELEASE)
    SET(QTMOBILITY_QTSERVICEFW_LIBRARIES ${QTMOBILITY_QTSERVICEFW_LIBRARY_RELEASE})
  ENDIF()

  SET(QtMobility_LIBRARIES ${QTMOBILITY_QTSERVICEFW_LIBRARIES})
  SET(QtMobility_INCLUDE_DIRS ${QTMOBILITY_QTSERVICEFW_INCLUDE_DIR})

  IF(QtMobility_INCLUDE_DIRS AND QtMobility_LIBRARIES)
    SET(QtMobility_FOUND 1)
  ENDIF()
ENDIF()
