/*

 Disclaimer: IMPORTANT:  This Apple software is supplied to you by Apple
 Computer, Inc. ("Apple") in consideration of your agreement to the
 following terms, and your use, installation, modification or
 redistribution of this Apple software constitutes acceptance of these
 terms.  If you do not agree with these terms, please do not use,
 install, modify or redistribute this Apple software.

 In consideration of your agreement to abide by the following terms, and
 subject to these terms, Apple grants you a personal, non-exclusive
 license, under Apple's copyrights in this original Apple software (the
 "Apple Software"), to use, reproduce, modify and redistribute the Apple
 Software, with or without modifications, in source and/or binary forms;
 provided that if you redistribute the Apple Software in its entirety and
 without modifications, you must retain this notice and the following
 text and disclaimers in all such redistributions of the Apple Software.
 Neither the name, trademarks, service marks or logos of Apple Computer,
 Inc. may be used to endorse or promote products derived from the Apple
 Software without specific prior written permission from Apple.  Except
 as expressly stated in this notice, no other rights or licenses, express
 or implied, are granted by Apple herein, including but not limited to
 any patent rights that may be infringed by your derivative works or by
 other works in which the Apple Software may be incorporated.

 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE
 MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION
 THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND
 OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.

 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION,
 MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED
 AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE),
 STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE
 POSSIBILITY OF SUCH DAMAGE.

 Copyright  2004 Apple Computer, Inc., All Rights Reserved

 */

#ifndef __ComplexPlayThru_H__
#define __ComplexPlayThru_H__

#define RT_BUFFERSIZE 512

#define checkErr( err) \
if(err) {\
        OSStatus error = static_cast<OSStatus>(err);\
                fprintf(stderr, "ComplexPlayThru Error: %ld ->  %s:  %d\n",  error,\
                           __FILE__, \
                           __LINE__\
                           );\
                                   fflush(stdout);\
}

#include <CoreAudio/CoreAudio.h>
#include <AudioToolbox/AudioToolbox.h>
#include <AudioUnit/AudioUnit.h>
#include "AudioRingBuffer2.h"
#include "AudioDevice.h"

class ComplexPlayThru
{
public:
        ComplexPlayThru(); // adding this to use default devices -ma++
        ComplexPlayThru(AudioDeviceID input, AudioDeviceID output);
        ~ComplexPlayThru();
        OSStatus Init(AudioDeviceID input, AudioDeviceID output);
        OSStatus Start();
        OSStatus Stop();
        Boolean IsRunning();
        OSStatus SetInputDeviceAsCurrent(AudioDeviceID in);
        OSStatus SetOutputDeviceAsCurrent(AudioDeviceID out);
private:
        OSStatus SetupGraph(AudioDeviceID out);
        OSStatus MakeGraph();

        OSStatus SetupAUHAL(AudioDeviceID in);
        OSStatus EnableIO();
        OSStatus CallbackSetup();
        OSStatus SetupBuffers();
        OSStatus MapChannels();

        void ComputeThruOffset();

        static OSStatus InputProc(void *inRefCon,
                                                          AudioUnitRenderActionFlags *ioActionFlags,
                                                          const AudioTimeStamp *inTimeStamp,
                                                          UInt32                                inBusNumber,
                                                          UInt32                                inNumberFrames,
                                                          AudioBufferList *             ioData);

        static OSStatus OutputProc(void *inRefCon,
                                                           AudioUnitRenderActionFlags *ioActionFlags,
                                                           const AudioTimeStamp *inTimeStamp,
                                                           UInt32                               inBusNumber,
                                                           UInt32                               inNumberFrames,
                                                           AudioBufferList *    ioData);

        static OSStatus DeviceSampleRateListener(AudioDeviceID  inDevice,
                                                                UInt32                                  inChannel,
                                                                Boolean                                 isInput,
                                                                AudioDevicePropertyID   inPropertyID,
                                                                void*                                   inClientData);

        AudioUnit mInputUnit;
        AudioBufferList *mInputBuffer;
        AudioDevice mInputDevice, mOutputDevice;
        AudioRingBuffer *mBuffer;

        //AudioUnits and Graph
        AUGraph mGraph;
        AUNode mVarispeedNode;
        AudioUnit mVarispeedUnit;
        AUNode mOutputNode;
        AudioUnit mOutputUnit;

        //Buffer sample info
        Float64 mFirstInputTime;
        Float64 mFirstOutputTime;
        Float64 mInToOutSampleOffset;
};

#endif //__ComplexPlayThru_H__
