/*
 * TagLib C# bindings
 * by Clemens Koppensteiner
 *
 * This work is hereby released into the Public Domain. To view a copy of the
 * public domain dedication, visit
 * http://creativecommons.org/licenses/publicdomain/ or send a letter to
 * Creative Commons, 543 Howard Street, 5th Floor, San Francisco, California,
 * 94105, USA.
 */

using System;
using System.Runtime.InteropServices;

namespace TagLib 
{
	public class AudioProperties : Object
	{
		public AudioProperties(IntPtr ptr) : base (ptr)
		{
			length = taglib_audioproperties_length(ptr);
			bitrate = taglib_audioproperties_bitrate(ptr);
			sampleRate = taglib_audioproperties_samplerate(ptr);
			channels = taglib_audioproperties_channels(ptr);
		}
		
		[DllImport("libtag_c")]
		static extern int taglib_audioproperties_length(IntPtr audioproperties);
		
		[DllImport("libtag_c")]
		static extern int taglib_audioproperties_bitrate(IntPtr audioproperties);
		
		[DllImport("libtag_c")]
		static extern int taglib_audioproperties_samplerate(IntPtr audioproperties);
		
		[DllImport("libtag_c")]
		static extern int taglib_audioproperties_channels(IntPtr audioproperties);
		
		int length;
		public int Length {
			get { return length; }
		}
		
		int bitrate;
		public int Bitrate {
			get { return bitrate; }
		}
		
		int sampleRate;
		public int SampleRate {
			get { return sampleRate; }
		}
		
		int channels;
		public int Channels {
			get { return channels; }
		}
	}
}
