#include <ctype.h>
#include <string.h>
#include <vector>
#include <stdlib.h>
#include <searchhelper.h>
extern "C" {
#include <complearn/complearn.h>
};
#include <GL/glut.h>
#include <GL/glu.h>
#include <math.h>
#include <QGLViewer/vec.h>
#include <QGLViewer/camera.h>

using namespace std;

const unsigned int MAXLEN = 40;
const int SEARCHKEY = '/';
const int BACKSPACEKEY = 8;
const int SEARCHCYCLE = 9;
const int SEARCHRETURN = 13;

bool SearchHelperView::eat_character(char c)
{
  if (_infocus) {
    if (c == BACKSPACEKEY) {
      do_backspace();
      return true;
    }
    if (c == SEARCHRETURN) {
      _infocus = false;
      return true;
    }
    if (c == SEARCHCYCLE) {
      //cycle_search();
      return true;
    }
    add_character(c);
    return true;
  }
  if (c == SEARCHKEY) {
    _infocus = true;
    return true;
  }
  return false;
}

bool SearchHelperView::can_eat_character(char c)
{
  return _infocus || c == SEARCHKEY;
}

void SearchHelperView::update_dispstr(void)
{
  free(_dispstr);
  _dispstr = (char *) calloc(MAXLEN+10, 1);
  sprintf(_dispstr, "[%s]", _str);
}


bool SearchHelperView::do_backspace(void)
{
  bool didit = false;
  if (_str[0] != '\0') {
    _str[strlen(_str)-1] = '\0';
    didit = true;
  }
  update_dispstr();
  return didit;
}

void SearchHelperView::add_character(char c)
{
  if (strlen(_str) < MAXLEN) {
    char *ns = (char *) calloc(strlen(_str)+2, 1);
    sprintf(ns, "%s%c", _str, c);
    free(_str);
    _str = ns;
    update_dispstr();
  }
}

void SearchHelperView::draw(QGLViewer &qgl)
{
  qgl.drawText(_posx, _posy, _str);
}

SearchHelperView::SearchHelperView(int posx, int posy)
{
  _infocus = false;
  _posx = posx;
  _posy = posy;
  _str = strdup("");
  _dispstr = strdup("");
}

SearchHelperView::~SearchHelperView()
{
  free(_str);
}

char *normfunc(const char *inpstr)
{
  char *res = strdup(inpstr);
  int i;
  for (i = 0; inpstr[i]; i += 1)
    res[i] = tolower(inpstr[i]);
  return res;
}

struct WordHolder {
  double score;
  int i;
  public:
    WordHolder(int ui) { i = ui; }
};

/*
static void order_strings(const char *baseword, const char *strs, int *res)
{
  char *targetstr = normfunc(baseword);
  int i, sc;
  vector<WordHolder> v;
  for (i = 0; strs[i]; i += 1) {
    WordHolder w = WordHolder(i);
//    w.score = ncdfunc(targetstr,  public:
 //   WordHolder(int ui) { i = ui; }  public:
 //   WordHolder(int ui) { i = ui; }
    v.push_back(WordHolder(i));
  }
    res[i] = i;
  sc = i;
  
  free(targetstr);
}
*/

