/* colord.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Cd", lower_case_cprefix = "cd_", gir_namespace = "Colord", gir_version = "1.0")]
namespace Cd {
	[CCode (cheader_filename = "colord.h")]
	public class Client : GLib.Object {
		public Cd.ClientPrivate priv;
		[CCode (has_construct_function = false)]
		public Client ();
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Device create_device (string id, Cd.ObjectScope scope, GLib.HashTable<weak void*,weak void*> properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Device create_device_sync (string id, Cd.ObjectScope scope, GLib.HashTable<weak void*,weak void*> properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile create_profile (string id, Cd.ObjectScope scope, GLib.HashTable<weak void*,weak void*> properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile create_profile_sync (string id, Cd.ObjectScope scope, GLib.HashTable<weak void*,weak void*> properties, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool delete_device (Cd.Device device, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool delete_device_sync (Cd.Device device, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool delete_profile (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool delete_profile_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public static GLib.Quark error_quark ();
		public async Cd.Device find_device (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Device find_device_by_property (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Device find_device_by_property_sync (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Device find_device_sync (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile find_profile (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile find_profile_by_filename (string filename, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile find_profile_by_filename_sync (string filename, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile find_profile_sync (string id, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_connected ();
		public unowned string get_daemon_version ();
		public async GLib.GenericArray<Cd.Device> get_devices (GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.GenericArray<Cd.Device> get_devices_by_kind (Cd.DeviceKind kind, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<void*> get_devices_by_kind_sync (Cd.DeviceKind kind, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<void*> get_devices_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.GenericArray<Cd.Profile> get_profiles (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<void*> get_profiles_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.GenericArray<Cd.Sensor> get_sensors (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<void*> get_sensors_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.Profile get_standard_space (Cd.StandardSpace standard_space, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile get_standard_space_sync (Cd.StandardSpace standard_space, GLib.Cancellable? cancellable) throws GLib.Error;
		public string connected { get; }
		public string daemon_version { get; }
		public virtual signal void changed ();
		public virtual signal void device_added (Cd.Device client);
		public virtual signal void device_changed (Cd.Device client);
		public virtual signal void device_removed (Cd.Device client);
		public virtual signal void profile_added (Cd.Profile client);
		public virtual signal void profile_changed (Cd.Profile client);
		public virtual signal void profile_removed (Cd.Profile client);
		public virtual signal void sensor_added (Cd.Sensor client);
		public virtual signal void sensor_changed (Cd.Sensor client);
		public virtual signal void sensor_removed (Cd.Sensor client);
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cd_color_rgb_get_type ()", cheader_filename = "colord.h")]
	public class ColorRGB {
		public double B;
		public double G;
		public double R;
		public Cd.ColorRGB dup ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cd_color_xyz_get_type ()", cheader_filename = "colord.h")]
	public class ColorXYZ {
		public double X;
		public double Y;
		public double Z;
		public Cd.ColorXYZ dup ();
	}
	[Compact]
	[CCode (copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cd_color_yxy_get_type ()", cheader_filename = "colord.h")]
	public class ColorYxy {
		public double Y;
		public double x;
		public double y;
		public Cd.ColorYxy dup ();
	}
	[CCode (cheader_filename = "colord.h")]
	public class Device : GLib.Object {
		public Cd.DevicePrivate priv;
		[CCode (has_construct_function = false)]
		public Device ();
		public async bool add_profile (Cd.DeviceRelation relation, Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool add_profile_sync (Cd.DeviceRelation relation, Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (Cd.Device device2);
		public static GLib.Quark error_quark ();
		public Cd.Colorspace get_colorspace ();
		public bool get_connected ();
		public uint64 get_created ();
		public Cd.Profile get_default_profile ();
		public unowned string get_format ();
		public unowned string get_id ();
		public Cd.DeviceKind get_kind ();
		public GLib.HashTable<void*,void*> get_metadata ();
		public unowned string get_metadata_item (string key);
		public Cd.DeviceMode get_mode ();
		public unowned string get_model ();
		public uint64 get_modified ();
		public unowned string get_object_path ();
		public async Cd.Profile get_profile_for_qualifiers (string qualifiers, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.Profile get_profile_for_qualifiers_sync (string qualifiers, GLib.Cancellable? cancellable) throws GLib.Error;
		public async Cd.DeviceRelation get_profile_relation (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.DeviceRelation get_profile_relation_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Cd.Profile> get_profiles ();
		public Cd.ObjectScope get_scope ();
		public unowned string get_serial ();
		public unowned string get_vendor ();
		public static Cd.DeviceKind kind_from_string (string kind);
		public static Cd.ProfileKind kind_to_profile_kind (Cd.DeviceKind device_kind);
		public static unowned string kind_to_string (Cd.DeviceKind kind_enum);
		public async bool make_profile_default (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool make_profile_default_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.DeviceMode mode_from_string (string device_mode);
		public static unowned string mode_to_string (Cd.DeviceMode device_mode);
		public async bool profiling_inhibit (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool profiling_inhibit_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool profiling_uninhibit (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool profiling_uninhibit_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.DeviceRelation relation_from_string (string device_relation);
		public static unowned string relation_to_string (Cd.DeviceRelation device_relation);
		public async bool remove_profile (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool remove_profile_sync (Cd.Profile profile, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_colorspace_sync (Cd.Colorspace colorspace, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_kind_sync (Cd.DeviceKind kind, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_mode_sync (Cd.DeviceMode mode, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_model_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_object_path (string object_path);
		public async bool set_property (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_property_sync (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_serial_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_vendor_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public string to_string ();
		[CCode (has_construct_function = false)]
		public Device.with_object_path (string object_path);
		public uint colorspace { get; }
		public string connected { get; }
		public uint64 created { get; }
		public string format { get; }
		public string id { get; }
		public uint kind { get; }
		public uint mode { get; }
		public string model { get; }
		public uint64 modified { get; }
		public string object_path { get; set construct; }
		public uint scope { get; }
		public string serial { get; }
		public string vendor { get; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "colord.h")]
	public class Profile : GLib.Object {
		public Cd.ProfilePrivate priv;
		[CCode (has_construct_function = false)]
		public Profile ();
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (Cd.Profile profile2);
		public static GLib.Quark error_quark ();
		public int64 get_age ();
		public Cd.Colorspace get_colorspace ();
		public bool get_connected ();
		public int64 get_created ();
		public unowned string get_filename ();
		public unowned string get_format ();
		public bool get_has_vcgt ();
		public unowned string get_id ();
		public bool get_is_system_wide ();
		public Cd.ProfileKind get_kind ();
		public GLib.HashTable<void*,void*> get_metadata ();
		public unowned string get_metadata_item (string key);
		public unowned string get_object_path ();
		public unowned string get_qualifier ();
		public Cd.ObjectScope get_scope ();
		public unowned string get_title ();
		public async bool install_system_wide (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool install_system_wide_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public static Cd.ProfileKind kind_from_string (string profile_kind);
		public static unowned string kind_to_string (Cd.ProfileKind profile_kind);
		public bool set_filename_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_object_path (string object_path);
		public async bool set_property (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_property_sync (string key, string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_qualifier_sync (string value, GLib.Cancellable? cancellable) throws GLib.Error;
		public string to_string ();
		[CCode (has_construct_function = false)]
		public Profile.with_object_path (string object_path);
		public string colorspace { get; }
		public string connected { get; }
		public int64 created { get; }
		public string filename { get; }
		public string format { get; }
		public string has_vcgt { get; }
		public string id { get; }
		public string is_system_wide { get; }
		public string kind { get; }
		public string object_path { get; set construct; }
		public string qualifier { get; }
		public uint scope { get; }
		public string title { get; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "colord.h")]
	public class Sensor : GLib.Object {
		public Cd.SensorPrivate priv;
		[CCode (has_construct_function = false)]
		public Sensor ();
		public static Cd.SensorCap cap_from_string (string sensor_cap);
		public static unowned string cap_to_string (Cd.SensorCap sensor_cap);
		public async bool connect (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool connect_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (Cd.Sensor sensor2);
		public static GLib.Quark error_quark ();
		public uint get_caps ();
		public bool get_connected ();
		public Cd.SensorKind get_kind ();
		public bool get_locked ();
		public Cd.SensorCap get_mode ();
		public unowned string get_model ();
		public bool get_native ();
		public unowned string get_object_path ();
		public async Cd.ColorXYZ get_sample (Cd.SensorCap cap, GLib.Cancellable? cancellable) throws GLib.Error;
		public Cd.ColorXYZ get_sample_sync (Cd.SensorCap cap, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned string get_serial ();
		public Cd.SensorState get_state ();
		public unowned string get_vendor ();
		public bool has_cap (Cd.SensorCap cap);
		public static Cd.SensorKind kind_from_string (string sensor_kind);
		public static unowned string kind_to_string (Cd.SensorKind sensor_kind);
		public async bool @lock (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool lock_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_object_path (string object_path);
		public static Cd.SensorState state_from_string (string sensor_state);
		public static unowned string state_to_string (Cd.SensorState sensor_state);
		public string to_string ();
		public async bool unlock (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool unlock_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Sensor.with_object_path (string object_path);
		public string connected { get; }
		public string kind { get; }
		public string locked { get; }
		public string mode { get; }
		public string model { get; }
		public string native { get; }
		public string object_path { get; set construct; }
		public string serial { get; }
		public string state { get; }
		public string vendor { get; }
		public virtual signal void button_pressed ();
	}
	[CCode (type_id = "CD_TYPE_CLIENT_PRIVATE", cheader_filename = "colord.h")]
	public struct ClientPrivate {
	}
	[CCode (type_id = "CD_TYPE_COLOR_LAB", cheader_filename = "colord.h")]
	public struct ColorLab {
		public double L;
		public double a;
		public double b;
	}
	[CCode (type_id = "CD_TYPE_COLOR_RG_B8", cheader_filename = "colord.h")]
	public struct ColorRGB8 {
		public uint8 R;
		public uint8 G;
		public uint8 B;
	}
	[CCode (type_id = "CD_TYPE_DEVICE_PRIVATE", cheader_filename = "colord.h")]
	public struct DevicePrivate {
	}
	[CCode (type_id = "CD_TYPE_PROFILE_PRIVATE", cheader_filename = "colord.h")]
	public struct ProfilePrivate {
	}
	[CCode (type_id = "CD_TYPE_SENSOR_PRIVATE", cheader_filename = "colord.h")]
	public struct SensorPrivate {
	}
	[CCode (cprefix = "CD_CLIENT_ERROR_", cheader_filename = "colord.h")]
	public enum ClientError {
		FAILED,
		LAST
	}
	[CCode (cprefix = "CD_COLORSPACE_", cheader_filename = "colord.h")]
	public enum Colorspace {
		UNKNOWN,
		XYZ,
		LAB,
		LUV,
		YCBCR,
		YXY,
		RGB,
		GRAY,
		HSV,
		CMYK,
		CMY,
		LAST
	}
	[CCode (cprefix = "CD_DEVICE_ERROR_", cheader_filename = "colord.h")]
	public enum DeviceError {
		FAILED,
		LAST
	}
	[CCode (cprefix = "CD_DEVICE_KIND_", cheader_filename = "colord.h")]
	public enum DeviceKind {
		UNKNOWN,
		DISPLAY,
		SCANNER,
		PRINTER,
		CAMERA,
		WEBCAM,
		LAST
	}
	[CCode (cprefix = "CD_DEVICE_MODE_", cheader_filename = "colord.h")]
	public enum DeviceMode {
		UNKNOWN,
		PHYSICAL,
		VIRTUAL,
		LAST
	}
	[CCode (cprefix = "CD_DEVICE_RELATION_", cheader_filename = "colord.h")]
	public enum DeviceRelation {
		UNKNOWN,
		SOFT,
		HARD,
		LAST
	}
	[CCode (cprefix = "CD_OBJECT_SCOPE_", cheader_filename = "colord.h")]
	public enum ObjectScope {
		UNKNOWN,
		NORMAL,
		TEMP,
		DISK,
		LAST
	}
	[CCode (cprefix = "CD_PROFILE_ERROR_", cheader_filename = "colord.h")]
	public enum ProfileError {
		FAILED,
		LAST
	}
	[CCode (cprefix = "CD_PROFILE_KIND_", cheader_filename = "colord.h")]
	public enum ProfileKind {
		UNKNOWN,
		INPUT_DEVICE,
		DISPLAY_DEVICE,
		OUTPUT_DEVICE,
		DEVICELINK,
		COLORSPACE_CONVERSION,
		ABSTRACT,
		NAMED_COLOR,
		LAST
	}
	[CCode (cprefix = "CD_RENDERING_INTENT_", cheader_filename = "colord.h")]
	public enum RenderingIntent {
		UNKNOWN,
		PERCEPTUAL,
		RELATIVE_COLORIMETRIC,
		SATURATION,
		ABSOLUTE_COLORIMETRIC,
		LAST
	}
	[CCode (cprefix = "CD_SENSOR_CAP_", cheader_filename = "colord.h")]
	public enum SensorCap {
		UNKNOWN,
		LCD,
		CRT,
		PRINTER,
		SPOT,
		PROJECTOR,
		AMBIENT,
		CALIBRATION,
		LAST
	}
	[CCode (cprefix = "CD_SENSOR_ERROR_", cheader_filename = "colord.h")]
	public enum SensorError {
		FAILED,
		LAST
	}
	[CCode (cprefix = "CD_SENSOR_KIND_", cheader_filename = "colord.h")]
	public enum SensorKind {
		UNKNOWN,
		DUMMY,
		HUEY,
		COLOR_MUNKI,
		SPYDER,
		DTP20,
		DTP22,
		DTP41,
		DTP51,
		DTP94,
		SPECTRO_SCAN,
		I1_PRO,
		COLORIMTRE_HCFR,
		LAST
	}
	[CCode (cprefix = "CD_SENSOR_STATE_", cheader_filename = "colord.h")]
	public enum SensorState {
		UNKNOWN,
		STARTING,
		IDLE,
		MEASURING,
		LAST
	}
	[CCode (cprefix = "CD_STANDARD_SPACE_", cheader_filename = "colord.h")]
	public enum StandardSpace {
		UNKNOWN,
		SRGB,
		ADOBE_RGB,
		PROPHOTO_RGB,
		LAST
	}
	[CCode (cheader_filename = "colord.h")]
	public const string CLIENT_PROPERTY_DAEMON_VERSION;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_METADATA_XRANDR_NAME;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_COLORSPACE;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_CREATED;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_FORMAT;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_ID;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_KIND;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_METADATA;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_MODE;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_MODEL;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_MODIFIED;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_PROFILES;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_SCOPE;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_SERIAL;
	[CCode (cheader_filename = "colord.h")]
	public const string DEVICE_PROPERTY_VENDOR;
	[CCode (cheader_filename = "colord.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "colord.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "colord.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_CMF_BINARY;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_CMF_PRODUCT;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_CMF_VERSION;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_DATA_SOURCE;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_DATA_SOURCE_CALIB;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_DATA_SOURCE_EDID;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_EDID_MD5;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_EDID_MNFT;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_EDID_MODEL;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_EDID_SERIAL;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_EDID_VENDOR;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_FILE_CHECKSUM;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_MAPPING_FORMAT;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_MAPPING_QUALIFIER;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_METADATA_STANDARD_SPACE;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_COLORSPACE;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_CREATED;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_FILENAME;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_FORMAT;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_HAS_VCGT;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_ID;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_IS_SYSTEM_WIDE;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_KIND;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_METADATA;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_QUALIFIER;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_SCOPE;
	[CCode (cheader_filename = "colord.h")]
	public const string PROFILE_PROPERTY_TITLE;
	[CCode (cheader_filename = "colord.h")]
	public static void color_clear_xyz (Cd.ColorXYZ dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_rgb8_to_rgb (Cd.ColorRGB8 src, Cd.ColorRGB dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_rgb_to_rgb8 (Cd.ColorRGB src, Cd.ColorRGB8 dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_xyz_to_yxy (Cd.ColorXYZ src, Cd.ColorYxy dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_convert_yxy_to_xyz (Cd.ColorYxy src, Cd.ColorXYZ dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_copy_rgb (Cd.ColorRGB src, Cd.ColorRGB dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_copy_xyz (Cd.ColorXYZ src, Cd.ColorXYZ dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_copy_yxy (Cd.ColorYxy src, Cd.ColorYxy dest);
	[CCode (cheader_filename = "colord.h")]
	public static void color_set_rgb (Cd.ColorRGB dest, double R, double G, double B);
	[CCode (cheader_filename = "colord.h")]
	public static void color_set_xyz (Cd.ColorXYZ dest, double X, double Y, double Z);
	[CCode (cheader_filename = "colord.h")]
	public static void color_set_yxy (Cd.ColorYxy dest, double Y, double x, double y);
	[CCode (cheader_filename = "colord.h")]
	public static Cd.Colorspace colorspace_from_string (string colorspace);
	[CCode (cheader_filename = "colord.h")]
	public static unowned string colorspace_to_string (Cd.Colorspace colorspace);
	[CCode (cheader_filename = "colord.h")]
	public static Cd.ObjectScope object_scope_from_string (string object_scope);
	[CCode (cheader_filename = "colord.h")]
	public static unowned string object_scope_to_string (Cd.ObjectScope object_scope);
	[CCode (cheader_filename = "colord.h")]
	public static Cd.RenderingIntent rendering_intent_from_string (string rendering_intent);
	[CCode (cheader_filename = "colord.h")]
	public static unowned string rendering_intent_to_string (Cd.RenderingIntent rendering_intent);
	[CCode (cheader_filename = "colord.h")]
	public static Cd.StandardSpace standard_space_from_string (string standard_space);
	[CCode (cheader_filename = "colord.h")]
	public static unowned string standard_space_to_string (Cd.StandardSpace standard_space);
}
