unit unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, Menus,
  SynEdit, ExtCtrls,
  ulex, umorpho, PairSplitter, Buttons, Process, SynMemo;

type
  TForm1 = class(TForm)
    Mainmenu1: TMAINMENU;
    MenuFichier: TMENUITEM;
    Menuhtml: TMENUITEM;
    MenuAide: TMENUITEM;
    MenuAide2: TMENUITEM;
    MenuAPropos: TMENUITEM;
    MenuEffLemm: TMENUITEM;
    MenuVocAnalyses: TMENUITEM;
    MenuTexte: TMENUITEM;
    MenuToutLemmatiser: TMENUITEM;
    MenuLemmatisation: TMENUITEM;
    MenuVocSeul: TMENUITEM;
    MenuLemmatiserPhrase: TMENUITEM;
    MenuEffacerLaLigne: TMENUITEM;
    MenuColler: TMENUITEM;
    MenuToutCopier: TMENUITEM;
    MenuEdition: TMENUITEM;
    MenuQuitter: TMENUITEM;
    menulatex: TMENUITEM;
    MenuOuvrir: TMENUITEM;
    MenuNouveau: TMENUITEM;
    Opendialog1: TOPENDIALOG;
    Pairsplitter1: TPAIRSPLITTER;
    Pairsplitterside1: TPAIRSPLITTERSIDE;
    Pairsplitterside2: TPAIRSPLITTERSIDE;
    Panel1: TPANEL;
    Process1: TPROCESS;
    Savedialog1: TSAVEDIALOG;
    sbNouveau: TSPEEDBUTTON;
    sbOuvrir: TSPEEDBUTTON;
    sbEffLemm: TSPEEDBUTTON;
    sbLemm: TSPEEDBUTTON;
    Synedit1: TSYNEDIT;
    Synedit2: TSYNEDIT;
    procedure Form1CLOSE(Sender: TObject; var Action: TCloseAction);
    procedure Form1CLOSEQUERY(Sender: TObject; var CanClose: boolean);
    procedure Form1CREATE(Sender: TObject);
    procedure MenuAProposCLICK(Sender: TObject);
    procedure MenuAide2CLICK(Sender: TObject);
    procedure MenuCollerCLICK(Sender: TObject);
    procedure MenuEffLemmCLICK(Sender: TObject);
    procedure MenuEffacerLaLigneCLICK(Sender: TObject);
    procedure MenuNouveauCLICK(Sender: TObject);
    procedure MenuOuvrirCLICK(Sender: TObject);
    procedure MenuQuitterCLICK(Sender: TObject);
    procedure MenuTexteCLICK(Sender: TObject);
    procedure MenuToutCopierCLICK(Sender: TObject);
    procedure MenuToutLemmatiserCLICK(Sender: TObject);
    procedure MenuVocSeulCLICK(Sender: TObject);
    procedure MenuhtmlCLICK(Sender: TObject);
    procedure Synedit1CLICK(Sender: TObject);
    procedure Synedit1MOUSEMOVE(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure menulatexCLICK(Sender: TObject);
  private
    { private declarations }
    modeL : integer;
    function precaution : boolean;
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

uses uhtml, ulatex, utiles;

{ TForm1 }

{nouveau texte : effacer l'diteur 1}
procedure TForm1.MenuNouveauCLICK(Sender: TObject);
begin
  // prcaution ?
  SynEdit1.ClearAll;
  SynEdit2.ClearAll;
end;

{Cration de la forme : vider les diteurs, les aligner ; charger le lexique}
procedure TForm1.Form1CREATE(Sender: TObject);
var
   chemin : string;
begin
    SynEdit1.ClearAll;
    SynEdit1.Align := alClient;
    SynEdit2.ClearAll;
    SynEdit2.Align := alClient;
    PairSplitter1.align := alClient;
    PairSplitter1.position := ClientWidth div 3;
    // gliphes
    if fileexists (share + 'img/filenew.xpm')
      then chemin := share
    else chemin := extractfilepath(paramstr(0));
    sbNouveau.glyph.loadfromxpmfile( chemin + 'img/filenew.xpm');
    sbOuvrir.glyph.loadfromxpmfile(chemin + 'img/fileopen.xpm');
    sbEffLemm.glyph.loadfromxpmfile(chemin + 'img/cut.xpm');
    sbLemm.glyph.loadfromxpmfile(chemin + 'img/execute.xpm');
    
    Lislexique_xml;
    modeL := maVocSeul;
    
    // charger un texte
    if paramstr(1) > ''
       then Synedit1.lines.loadfromfile(paramstr(1));
end;

procedure TForm1.MenuAProposCLICK(Sender: TObject);
begin
   ShowMessage (
     'COLLATINVS' + #10
     + 'version 7.4-3'#10
     + 'Lemmatiseur et analyseur morphologique du latin' + #10
     + 'Licence GPL' + #10
     + 'Yves Ouvrard, t 2003' + #10
     + 'http://www.collatinus.org' + #10);
end;

procedure TForm1.MenuAide2CLICK(Sender: TObject);
begin
   Process1.execute;
end;

{coller dans l'diteur 1 le contenu du presse-papier}
procedure TForm1.MenuCollerCLICK(Sender: TObject);
begin
   Synedit1.PasteFromClipBoard;
end;

{efface le contenu de l'diteur 2 o sont crits les lemmes}
procedure TForm1.MenuEffLemmCLICK(Sender: TObject);
begin
   Synedit2.Clearall;
end;

{Supprimer la ligne}
procedure TForm1.MenuEffacerLaLigneCLICK(Sender: TObject);
var
   editeur : Tsynedit;
begin
   if Synedit1.focused
      then editeur := synedit1
   else editeur := synedit2;
   with editeur do lines.delete(caretY - 1);
end;

{Fermeture de l'appli : librer le lexique}
procedure TForm1.Form1CLOSE(Sender: TObject; var Action: TCloseAction);
begin
  Lexique.free;
end;

procedure TForm1.Form1CLOSEQUERY(Sender: TObject; var CanClose: boolean);
begin
  CanClose := precaution;
end;

{Ouvrir un texte latin}
procedure TForm1.MenuOuvrirCLICK(Sender: TObject);
begin
 if not precaution then exit;
  with Opendialog1 do if execute
     then Synedit1.lines.Loadfromfile(FileName);
  Synedit1.lines.Add(#10);
  Synedit1.modified := false;
end;

{quitter}
procedure TForm1.MenuQuitterCLICK(Sender: TObject);
begin
   Close;
end;

{enregistrer tout au format texte}
procedure TForm1.MenuTexteCLICK(Sender: TObject);
var
   texte : TStringList;
begin
   with SaveDialog1 do if execute then
      begin
         Texte := TStringList.Create;
         Texte.AddStrings (Synedit1.Lines);
         Texte.Add('-- ');
         Texte.AddStrings (Synedit2.Lines);
         Texte.SaveToFile (FileName);
         Texte.Free;
      end;
end;

{copier le texte + voc dans le presse-papier}
procedure TForm1.MenuToutCopierCLICK(Sender: TObject);
begin
   Synedit1.DoCopyToClipboard(Synedit1.Text + #10#10 + Synedit2.text);
end;

{effacer l'diteur 2 et ajouter la lemmatisation de tout le texte }
procedure TForm1.MenuToutLemmatiserCLICK(Sender: TObject);
var
   analyses : TStringlist;
begin
   analyses := AnalyseTexte(Synedit1.text);
   Synedit2.ClearAll;
   Synedit2.Lines.Addstrings(analyses);
   analyses.free;
end;

{ Changer l'tat du bouton radio, et fixer le mode d'analyse
  (vocabulaire seul, ou vocabulaire + morphologie }
procedure TForm1.MenuVocSeulCLICK(Sender: TObject);
begin
    if MenuVocSeul.Checked
       then ModeL := maVocSeul
    else ModeL := MaAnalyses;
end;

{enregistrer en html}
procedure TForm1.MenuhtmlCLICK(Sender: TObject);
var
   analyses : TStringList;
begin
   analyses := formate_html (Synedit1.lines, Synedit2.lines);
   with Savedialog1 do if execute then
       analyses.Savetofile(FileName);
   analyses.free;
end;

{clic dans l'diteur 1 : ajouter le lemme dans l'diteur 2}
procedure TForm1.Synedit1CLICK(Sender: TObject);
var
   forme : string;
   p : tpoint;
   analyses : TStringList;
   inuentum : boolean;
begin
   forme := '';
   with SynEdit1 do
      begin
         p := prevwordPos;
         forme := GetWordAtRowCol(p);
      end;
   if forme > '' then
      begin
         Analyses := AnalysesDe(forme, inuentum, modeL);
         SynEdit2.lines.AddStrings(Analyses);
         Analyses.free;
      end;
end;

{ lemmatisation  la vole : afficher les infobulles }
procedure TForm1.Synedit1MOUSEMOVE(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
   p : TPoint;
   forme : string;
   analyses : TStringList;
   inuentum : boolean;
begin
   // chercher la forme
   p := Synedit1.Pixelstorowcolumn(Point(X,Y));
   forme := Synedit1.GetWordAtRowCol(p);
   if forme = '' then exit;
   analyses := AnalysesDe(forme, inuentum, maAnalyses);
   Synedit1.hint := analyses.text;
   analyses.free;
end;

{enregistrer (LaTeX) }
procedure TForm1.menulatexCLICK(Sender: TObject);
var
   analyses : TStringList;
begin
   analyses := formate_latex (Synedit1.lines, Synedit2.lines);
   with Savedialog1 do if execute then
       analyses.Savetofile(FileName);
   analyses.free;
end;

function TForm1.precaution: boolean;
begin
   result := not ((synedit1.modified) or (synedit2.modified)) or
     (MessageDlg (
       'Ton travail n''a pas t enregistr. Confirmes-tu ton intention ?',
       mtWarning, [mbYes,mbNo], 0) = mrYes);
end;

initialization
  {$I unit1.lrs}

end.

