#!/bin/sh

if [ ! -f /usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp ] ; then
  cat <<EOF
$0: cannot find the common-lisp-controller source.
This should not happen. Please report this
as a bug.
EOF
  exit 0
fi

# did the config file get upgraded?
if `grep -q common-lisp-controller.lisp /etc/common-lisp/cmucl/site-init.lisp /var/lib/cmucl/site-init.lisp 2> /dev/null`  ; then
  cat <<EOF2
The /etc/common-lisp/cmucl/site-init.lisp file is still using the 
old common-lisp-controller system. Please upgrade the file to the
new system, as used in the new config file that should be at
/etc/common-lisp/cmucl/site-init.lisp.dpkg-new
EOF2
  exit 0
fi

DIR=cmucl
IMAGESSE=/usr/lib/cmucl/lisp-sse2.core
IMAGEx86=/usr/lib/cmucl/lisp-x87.core

case $1 in
    install-defsystem|install-clc)
    	    echo "Installing Common Lisp Controller in CMU CL ..."
	    ( cd /usr/lib/cmucl
	      [ -f $IMAGESSE ] && rm -f $IMAGESSE
	      /usr/bin/cmucl  -fpu sse2 \
	        -core ${IMAGESSE%.core}-dist.core -load /usr/lib/cmucl/install-clc.lisp \
	        -nositeinit -noinit -batch  && \
             mv new-lisp.core $IMAGESSE || (echo FAILED ; ln ${IMAGESSE%.core}-dist.core $IMAGESSE ) )
	    ( cd /usr/lib/cmucl
	      [ -f $IMAGEx86 ] && rm -f $IMAGEx86
	      /usr/bin/cmucl  -fpu sse2 \
	        -core ${IMAGEx86%.core}-dist.core -load /usr/lib/cmucl/install-clc.lisp \
	        -nositeinit -noinit -batch  && \
             mv new-lisp.core $IMAGEx86 || (echo FAILED ; ln ${IMAGEx86%.core}-dist.core $IMAGEx86 ) )
    	    ;;
    remove-clc)
	echo "Removing Common Lisp Controller from CMU CL ..."
	if [ -f ${IMAGESSE%.core}-dist.core ]; then
	    cp ${IMAGESSE%.core}-dist.core $IMAGESSE;
	fi
	if [ -f ${IMAGEx86%.core}-dist.core ]; then
	    cp ${IMAGEx86%.core}-dist.core $IMAGEx86;
	fi
	;;
    *)
	    echo $0 unkown command $1
	    echo known commands: install-clc
	    exit 1
	    ;;
esac

exit 0
