/*
//
//  Copyright 2009-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 3945 $
//
//  $LastChangedDate: 2012-02-29 11:33:37 -0800 (Wed, 29 Feb 2012) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include "cmtkImageOperationMedialSkeleton.h"

#include <Base/cmtkEigenSystemSymmetricMatrix3x3.h>

cmtk::UniformVolume::SmartPtr  
cmtk::ImageOperationMedialSkeleton
::Apply( cmtk::UniformVolume::SmartPtr& volume )
{
  UniformVolume::SmartPtr iMap = DistanceMapType( *volume, DistanceMap::INSIDE ).Get();  

  UniformVolume::SmartPtr skeleton( iMap->CloneGrid() );
  skeleton->CreateDataArray( TYPE_COORDINATE );
  skeleton->GetData()->ClearArray();

  const int* dims = iMap->GetDims().begin();
#pragma omp parallel for
  for ( int k = 2; k < dims[2]-2; ++k )
    {
    for ( int j = 2; j < dims[1]-2; ++j )
      {
      for ( int i = 2; i < dims[0]-2; ++i )
	{
// Ridgeness operator implemented following http://en.wikipedia.org/wiki/Ridge_detection#Definition_of_ridges_and_valleys_in_N_dimensions
	
	Matrix3x3<Types::DataItem> hessian;
	iMap->GetHessianAt( hessian, i, j, k );
	
	EigenSystemSymmetricMatrix3x3<Types::DataItem> eigenSystem( hessian, false /*sortAbsolute*/ );
	
	Types::DataItem result = iMap->GetDataAt( i, j, k );
	if ( eigenSystem.GetNthEigenvalue( 2-this->m_Dimensionality ) < 0 )
	  {
	  const UniformVolume::CoordinateVectorType gradient = iMap->GetGradientAt( i, j, k );

	  for ( int n = 0; n < 3-this->m_Dimensionality; ++n )
	    {
	    const UniformVolume::CoordinateVectorType ev = eigenSystem.GetNthEigenvector( n );

	    if ( fabs( ev * gradient ) > 1e-2 )
	      result = 0;
	    }
	  }
	else
	  {
	  result = 0;
	  }
	skeleton->SetDataAt( result, i, j, k );
	}
      }
    }
  
  return skeleton;
}
