# +========================================================================+
# || Copyright (C) 2009 by Christian Kuelker                              ||
# ||                                                                      ||
# || License: GNU General Public License - GNU GPL - version 2            ||
# ||          or (at your opinion) any later version.                     ||
# +========================================================================+
#  ID:       $Id$
#  Revision: $Revision$
#  Head URL: $HeadURL$
#  Date:     $Date$
#  Source:   $Source$

package CipUX::CAT::Web::Action;

use 5.008001;
use warnings;
use strict;
use Class::Std;
use CGI::Carp qw(carpout fatalsToBrowser warningsToBrowser cluck);
use Date::Manip;
use Data::Dumper;
use English qw( -no_match_vars);
use Log::Log4perl qw(get_logger :levels);
use Readonly;

use base qw(CipUX);
{

    use version; our $VERSION = qv('3.4.0.3');
    use re 'taint';    # Keep data captured by parens tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safer

    # CONST
    Readonly::Scalar my $EMPTY_STRING => q{};



    sub create_object {

        my ( $self, $arg_r ) = @_;
        my $form
            = exists $arg_r->{form} ? $arg_r->{form} : $self->perr('form');
        my $rpc
            = exists $arg_r->{rpc_obj}
            ? $arg_r->{rpc_obj}
            : $self->perr('rpc_obj');
        my $cipux_entity
            = exists $arg_r->{cipux_entity}
            ? $arg_r->{cipux_entity}
            : $self->perr('cipux_entity');
        my $t
            = exists $arg_r->{task}
            ? $self->l( $arg_r->{task} )
            : $self->perr('task');

        my $l = get_logger(__PACKAGE__);
        $l->debug( 'form: ',         $form );
        $l->debug( 'cipux_entity: ', $cipux_entity );
        $l->debug( 'task: ',         $t );
        $l->debug( 'rcp obj:',       $rpc );
        my $letter = undef;

        my $id = $form->field('id');
        confess 'No object ID (OID) given' if not defined $id;
        $l->debug( 'id: ', $id );

        my $firstname
            = ( defined $form->field('cipuxFirstname')
                and $form->field('cipuxFirstname') )
            ? $self->l( $form->field('cipuxFirstname') )
            : "Basic";
        $l->debug( 'firstname: ', $firstname );

        my $lastname
            = ( defined $form->field('cipuxLastname')
                and $form->field('cipuxLastname') )
            ? $form->field('cipuxLastname')
            : 'Group';
        $l->debug( 'lastname: ', $lastname );

        # no_password_given
        my $p1 = $form->field('password')
            || confess 'No password given (first password)';
        $l->debug('password: (not printed)');

        # no_password_given (repeat)
        my $p2 = $form->field('password_repeat')
            || confess 'No password given (second password)';
        $l->debug('password repeat: (not printed)');

        # ACTION
        if ( $p1 eq $p2 ) {

            $l->debug('passwords match');
            my $p_hr = {
                object         => $id,
                userPassword   => $p1,
                cipuxFirstname => $firstname,
                cipuxLastname  => $lastname,
            };

            $l->debug('create object new RPC object ...');
            my $a_hr = $rpc->xmlrpc( { cmd => $t, param_hr => $p_hr } )
                or confess "execution of task [$t] was not successful";

            if ( $a_hr->{status} eq 'TRUE' ) {

                $l->debug('... object was created');
                my $msg = $self->get('The object %s has been created.');
                $letter = ucfirst( substr $id, 0, 1 );
            }
            else {    # not able to create object
                $l->debug('... object was NOT created');
                $self->wwarn( { number => '2-017-0024-016' } );
            }

        }
        else {        # passwords_not_equal
            $l->debug('passwords did NOT match');
            croak 'Given passwords are not equal!';
        }
        $l->debug("out letter: [$letter]");
        return { letter => $letter, };
    }

    sub destroy_object {

        my ( $self, $arg_r ) = @_;
        my $form
            = exists $arg_r->{form} ? $arg_r->{form} : $self->perr('form');
        my $rpc
            = exists $arg_r->{rpc_obj}
            ? $arg_r->{rpc_obj}
            : $self->perr('rpc_obj');
        my $cipux_entity
            = exists $arg_r->{cipux_entity}
            ? $arg_r->{cipux_entity}
            : $self->perr('cipux_entity');
        my $t
            = exists $arg_r->{task}
            ? $self->l( $arg_r->{task} )
            : $self->perr('task');

        my $l = get_logger(__PACKAGE__);

        # no_oid_given
        my $id = $form->field('id')
            || confess 'No object id (OID) given';

        # ACTION
        my $a_hr = $rpc->xmlrpc(
            {
                cmd      => $t,
                param_hr => { object => $id },
            }
        ) or confess 'Failed to execute task [$t]!';

        if ( $a_hr->{status} eq 'TRUE' ) {
            my $msg = 'The object %s has been deleted.';
            $l->debug($msg);
        }
        else {

            # not able to delete object
            my $msg = 'Was not able to delete object!';
            $l->debug($msg);
            croak $msg;
        }

        return {};

    }


    sub set_object_password {

        my ( $self, $arg_r ) = @_;

        my $form
            = exists $arg_r->{form} ? $arg_r->{form} : $self->perr('form');
        my $rpc
            = exists $arg_r->{rpc_obj}
            ? $arg_r->{rpc_obj}
            : $self->perr('rpc_obj');
        my $cipux_entity
            = exists $arg_r->{cipux_entity}
            ? $arg_r->{cipux_entity}
            : $self->perr('cipux_entity');
        my $t
            = exists $arg_r->{task}
            ? $self->l( $arg_r->{task} )
            : $self->perr('task');

        my $l = get_logger(__PACKAGE__);

        # no_oid_given
        my $id = $form->field('id')
            || confess 'No object id (OID) given!';

        # no_password_given
        my $p1 = $form->field('password')
            || confess 'No (first) password given!';

        # no_password_given
        my $p2 = $form->field('password_repeat')
            || confess 'No (second) password given!';

        # password not equal
        if ( $p1 eq $p2 ) {

            my $a_hr = $rpc->xmlrpc(
                {
                    cmd      => $t,
                    param_hr => { object => $id, value => $p1 },
                }
            ) or confess "Execution of RPC task [$t] failed!";

            if ( $a_hr->{status} eq 'TRUE' ) {
                my $msg = 'The password for %s has been changed.';
                $l->debug($msg);
            }
            else {

                # not able to set password
                my $msg = 'Was not able to set the password!';
                $l->debug($msg);
                croak $msg;
            }
        }
        else {

            # passwords_not_equal
            my $msg = 'Given passwords are not equal!';
            $l->debug($msg);
            croak $msg;
        }

        return {};

    }

}

1;

__END__


