// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Created by postproc-shortwords 1.8 on 2010-01-18 13:17:33
// From input file /export/hda3/cld/text_2008_quads_plus_sort.utf8
// See compact_lang_det.cc for usage
//

#include "encodings/compact_lang_det/cldutil.h"

// Included:
//      af-Latn ar-Arab be-Cyrl bg-Cyrl bs-Latn ca-Latn cs-Latn cy-Latn da-Latn de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn ga-Latn hi-Deva hr-Latn hu-Latn id-Latn is-Latn is-Latn it-Latn iw-Hebr ja-Hani ko-Hani lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn pl-Latn pt-Latn ro-Latn ru-Cyrl sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn xxx-Latn yi-Hebr zh-Hani zh-TW

// Remapped:
//      xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl

static const int kQuadTableBuildDate = 20100118;    // yyyymmdd

COMPILE_ASSERT(MONTENEGRIN == 160, k_montenegrin_changed);
COMPILE_ASSERT(EXT_NUM_LANGUAGES == 209, k_ext_num_languages_changed);

// Nil-grams: 18 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC ORIYA INUKTITUT

// Uni-grams: 6 languages
//     Japanese Korean Chinese VIETNAMESE ChineseT ZHUANG

// Words/Quads/Gibberish: 47 languages in range ENGLISH..AFRIKAANS:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Ignore BULGARIAN CROATIAN SERBIAN IRISH TAGALOG TURKISH
//     UKRAINIAN HINDI MACEDONIAN INDONESIAN LATIN MALAY WELSH
//     BELARUSIAN ARABIC CATALAN SWAHILI SLOVENIAN MARATHI VIETNAMESE
//     SLOVAK PERSIAN NORWEGIAN_N YIDDISH AFRIKAANS

//  ENGLISH 5057
//  DANISH 3791
//  DUTCH 3895
//  FINNISH 4759
//  FRENCH 4398
//  GERMAN 4886
//  HEBREW 6248
//  ITALIAN 3006
//  NORWEGIAN 3700
//  POLISH 5221
//  PORTUGUESE 3767
//  RUSSIAN 5175
//  SPANISH 3710
//  SWEDISH 4463
//  CZECH 5205
//  ICELANDIC 4863
//  LATVIAN 4966
//  LITHUANIAN 4805
//  ROMANIAN 4283
//  HUNGARIAN 5354
//  ESTONIAN 4866
//  Ignore 92
//  BULGARIAN 5082
//  CROATIAN 4742
//  SERBIAN 5201
//  IRISH 3764
//  TAGALOG 2869
//  TURKISH 4921
//  UKRAINIAN 5466
//  HINDI 5512
//  MACEDONIAN 4869
//  INDONESIAN 3454
//  LATIN 2
//  MALAY 3279
//  WELSH 4716
//  BELARUSIAN 5553
//  ARABIC 6104
//  CATALAN 3578
//  SWAHILI 2845
//  SLOVENIAN 4145
//  MARATHI 449
//  VIETNAMESE 4102
//  SLOVAK 4577
//  PERSIAN 5665
//  NORWEGIAN_N 696
//  YIDDISH 4602
//  AFRIKAANS 3357


static const int kQuadTableSize = 65536;    // Bucket count
static const int kQuadTableKeyMask = 0xffff0000;    // Mask hash key

// 521808 possible entries:
// 195135 filled (37%), 925 merged (0%), 325748 dropped (62%)
static const cld::IndirectProbBucket4 kQuadTable[kQuadTableSize] = {
  // key[4], words[4] in UTF-8
  // value[4]
  { {0xcb670001,0x69260002,0xbddb0003,0x00000000}},	// [000] шате_, имаа, rtèr,
  { {0x20070004,0xbddb0005,0x7bc40006,0x00000000}},	//   _kuni_, stèr, sniu,
  { {0x65630007,0xddc40008,0xbddb0003,0x00000000}},	//   denh, _križ, ptèr,
  { {0x63bb0009,0x07a6000a,0x2007000b,0x00000000}},	//   jiun, јадн, _muni_,
  { {0x2007000c,0xa773000d,0x63a9000e,0x00000000}},	//   _luni_, ўліч, dhen,
  { {0xef1f000f,0x6fdd0010,0x64430011,0x00000000}},	//   tjük_, léct, funi,
  { {0x64430012,0x24510013,0x63a90014,0x00000000}},	//   guni, _cơm_, fhen,
  { {0xef1f000f,0x63bb0015,0xdb0d0016,0x00000000}},	//   rjük_, giun, riaç,
  { {0x36670017,0x65630018,0x32060003,0x00000000}},	//   _като_, benh, _quoy_,
  { {0x63a90019,0x2007001a,0x3f730013,0x00000000}},	//   ahen, _buni_, _ệu_,
  { {0x2b9c001b,0x3ff9000a,0x7528001c,0x00000000}},	//   _tích_, лноќ_, _iedz,
  { {0x63bb000c,0x63a9001d,0x6f1d001e,0x00000000}},	//   ciun, chen, ubsc,
  { {0x69c5001f,0x6fdd0003,0x69dc0020,0x00000000}},	//   ynhe, xécu, _okre,
  { {0x71730021,0x75280022,0x23640023,0x00000000}},	//   _وهنا, _jedz, lemj_,
  { {0x75280024,0x212c0025,0x6d470026,0x00000000}},	//   _medz, madh_, rgja,
  { {0x212c0027,0x6d470026,0x69dc0028,0x00000000}},	//   ladh_, sgja, _akre,
  { {0x6b8d0029,0xafb8002a,0x6e24002b,0x00000000}},	// [010] rjag, _خطوط_, _gwib,
  { {0x212c0027,0x6443002c,0x63bb000c,0x00000000}},	//   nadh_, yuni, ziun,
  { {0x6563002d,0x63a9002e,0x27ed002f,0x00000000}},	//   venh, yhen, _phen_,
  { {0x63bb000c,0x212c0025,0x69dc0030,0x00000000}},	//   xiun, hadh_, _ekre,
  { {0x63a90031,0xd6ab0032,0x65630033,0x00000000}},	//   vhen, خدام_, tenh,
  { {0x27ed0034,0x26df0035,0x64430036,0x00000000}},	//   _when_, _vyuo_, tuni,
  { {0x27ed0037,0x63bb0038,0x65630039,0x00000000}},	//   _then_, tiun, renh,
  { {0x7e6d003a,0xdce5003b,0x6563003c,0x00000000}},	//   _osap, _zahă, senh,
  { {0x6729003d,0x63a9003e,0x212c0025,0x00000000}},	//   _ieej, rhen, fadh_,
  { {0x212c0027,0x2475001c,0xdb090026,0x00000000}},	//   gadh_, _tām_, _ánæg,
  { {0xddc4003f,0x2a690040,0xc50c0041,0x00000000}},	//   _priž, hwab_, _סלאָ,
  { {0xedb20042,0xf3740043,0x23740044,0x00000000}},	//   ुच्छ, _وطند, _وانح,
  { {0x66010045,0x7e6d000f,0x67ea0046,0x00000000}},	//   _kilk, _csap, nýja,
  { {0x212c0027,0xb2760047,0xd5f90047,0x00000000}},	//   cadh_, _לענג_, רפֿר,
  { {0x5cb7000d,0x66010048,0x10150049,0x00000000}},	//   блёў_, _milk, _ابتد,
  { {0xee3f004a,0x645c004b,0x98ab004c,0x00000000}},	//   brý_, _ärie, ůměr_,
  { {0x6d410025,0x68e3004d,0x2d8c004e,0x00000000}},	// [020] ólac, ündn, ödes_,
  { {0x0ae90021,0x4425004f,0x66010050,0x00000000}},	//   شرقي_, _owl_, _nilk,
  { {0x7528003d,0x79950051,0x2a690052,0x00000000}},	//   _redz, _dozw, awab_,
  { {0xbb860032,0xa3e70053,0xf62a0054,0x00000000}},	//   _الحي, _मील_, гіки_,
  { {0x65940055,0x67290056,0x65a60014,0x00000000}},	//   жалу, _deej, _aðha,
  { {0x69dc0057,0x291e0026,0xdb160026,0x00000000}},	//   _ukre, _ýta_, ábær,
  { {0xb8960021,0xe6440058,0x212c0059,0x00000000}},	//   _الزع, ğlığ, vadh_,
  { {0x5398005a,0xe644005b,0xdb0d0026,0x00000000}},	//   рвия_, şlığ, nnað,
  { {0x212c0025,0x6601005c,0xb355005d,0x00000000}},	//   tadh_, _filk, تینا_,
  { {0xdbde003b,0x316a005e,0x27ea005f,0x00000000}},	//   nţân, ушио_, šinė_,
  { {0x212c0027,0xdb0d0014,0x98b80058,0x00000000}},	//   radh_, knað, _karı_,
  { {0x212c0027,0x7bc80060,0xee3f0061,0x00000000}},	//   sadh_, édul, trý_,
  { {0x27fc0024,0x212c0025,0x6ea80062,0x00000000}},	//   ívny_, padh_, бърг_,
  { {0x81670062,0x98b8005b,0xe56e000d,0x00000000}},	//   _гръб_, _ları_, дзi_,
  { {0x79950045,0xdb0d0026,0x71bb0063,0x00000000}},	//   _rozw, fnað, _תצוג,
  { {0x2d8c0064,0xdb0d0014,0x80370044,0x00000000}},	//   öder_, gnað, _اسوأ_,
  { {0x79950045,0x7e6d002c,0xedd50044,0x00000000}},	// [030] _pozw, _usap, _ويبد,
  { {0x67290019,0x5a340065,0x67ea0066,0x00000000}},	//   _seej, янут, výja,
  { {0xe7190067,0x66010068,0xa3ca0042,0x00000000}},	//   ليات_, _rilk, ोवा_,
  { {0xe00b0053,0x66010069,0xddc4005f,0x00000000}},	//   _संसद_, _silk, _isiš,
  { {0xd246006a,0x6601006b,0xbddb006c,0x00000000}},	//   _تن_, _pilk, crèc,
  { {0x75ed006d,0x4415006e,0xa2cc0042,0x00000000}},	//   dúzc, офит, _तख़्,
  { {0x2d91006f,0x66010070,0x6729004e,0x00000000}},	//   ijze_, _vilk, _teej,
  { {0x13090071,0xe3b1002a,0x66090072,0x00000000}},	//   шний_, برت_, _tuek,
  { {0x6609004b,0x66010073,0x6790005d,0x00000000}},	//   _uuek, _tilk, _سیوط,
  { {0x11d60021,0x86980074,0x98b80075,0x00000000}},	//   يوية_, _укус_, _zarı_,
  { {0x98b8005b,0xe2a8005d,0xfbd90042,0x00000000}},	//   _yarı_, لاین_, भकाम,
  { {0x22590076,0x14d60047,0x9f06005d,0x00000000}},	//   _виды_, _וועל_, توحو,
  { {0xddc40077,0xc8e60042,0x00000000,0x00000000}},	//   _asiš, _कर्म_,   ,
  { {0x853c0078,0xa156005e,0x8024005d,0x00000000}},	//   _alėj, _даљу_, _کروم,
  { {0x3b960079,0xdb0d007a,0x8fe60032,0x00000000}},	//   ојат, tnað, _وأعم,
  { {0x69cb0003,0x3b95007b,0x7c3a007c,0x00000000}},	//   égen, пјут, štro,
  { {0xdb0d0014,0x7c29007d,0xda660021,0x00000000}},	// [040] rnað, ćera, غاري,
  { {0x2b58007e,0x99920066,0x98b80058,0x00000000}},	//   _گیرد_, kryť_, _sarı_,
  { {0xd90d007e,0xd70a007f,0x9f42004c,0x00000000}},	//   ایف_, анее_, elké_,
  { {0xddcd0080,0xe8e00013,0xa6e60081,0x00000000}},	//   _vrať, hiệu_, ожел,
  { {0x3ce80082,0x00000000,0x00000000,0x00000000}},	//   ज़ेरे_,   ,   ,
  { {0x7aeb004d,0xdb210072,0x45b70083,0x00000000}},	//   ügte, ätöv, огію_,
  { {0x07a60084,0x53460085,0x00000000,0x00000000}},	//   _давн, охпа,   ,
  { {0xd3260086,0x957c0022,0xd3d70044,0x00000000}},	//   цьки, _skąd, يبيا_,
  { {0xdcfe003d,0x67220087,0x32660054,0x00000000}},	//   _kopē, mboj, ітив,
  { {0xd2570088,0x2a620089,0x27e6008a,0x00000000}},	//   іцы_, _mpkb_, llon_,
  { {0xdb06000f,0xc0ca0001,0x2610008b,0x00000000}},	//   _elké, рупе_, _hào_,
  { {0x75ed008c,0x9f490046,0x28bd0042,0x00000000}},	//   púzc, _thaí_, ्पति,
  { {0xa2d6006a,0xd2500032,0x5f94005a,0x00000000}},	//   _بيشت, _أنت_, фият,
  { {0x2610008d,0x27e6008e,0x98a3008f,0x00000000}},	//   _mào_, hlon_, _lejā_,
  { {0x2610008b,0x2ca50090,0xac950091,0x00000000}},	//   _lào_, áld_, чавш,
  { {0x68e3004b,0x7dc90066,0x7b880092,0x00000000}},	//   ündm, oľsk, ољуб_,
  { {0x2610001b,0x27e6001f,0xdc3c008f,0x00000000}},	// [050] _nào_, dlon_, kšķe,
  { {0x27e60003,0xceb20047,0x3ea40093,0x00000000}},	//   elon_, _ניי_, ømte_,
  { {0x9783005d,0x984b0094,0xfeb80043,0x00000000}},	//   ویسه, ряза_, _هایت_,
  { {0x201e0006,0x2610008b,0xdc880063,0x00000000}},	//   ipti_, _bào_, _וְשָ,
  { {0x79a70095,0xff7c0047,0x26100013,0x00000000}},	//   _дрве, יטאמ, _cào_,
  { {0x27e60096,0x5a340097,0x99640098,0x00000000}},	//   alon_, _інст, _отсл,
  { {0x96bb0053,0x27e60099,0xf992009a,0x00000000}},	//   _शेरॉ, blon_, _ארם_,
  { {0xf773009b,0x00000000,0x00000000,0x00000000}},	//   _غاز_,   ,   ,
  { {0x76420003,0xf677007e,0x2610008d,0x00000000}},	//   croy, _بازخ, _gào_,
  { {0xd6c6007e,0x14190021,0x31a9009c,0x00000000}},	//   _عملی, _هيئة_, _búza_,
  { {0xe8e00013,0x3cdb0042,0x77f5009d,0x00000000}},	//   riệu_, _खुले_, ּמָד_,
  { {0x6d410026,0x645c004b,0x9404009e,0x00000000}},	//   ólan, _äria, _قوله,
  { {0xd5c8008b,0xdb0d004b,0x2610008d,0x00000000}},	//   iền_, nnaõ, _xào_,
  { {0xdd92006a,0x67e3004b,0x427a009f,0x00000000}},	//   روز_, mõju, _לאנג,
  { {0xa0a500a0,0xdb0d00a1,0xc0e20086,0x00000000}},	//   _хайд, chaë, _пошк,
  { {0x5f76007e,0xeef60085,0x09d40082,0x00000000}},	//   _رابر, _няпэ, थव्य,
  { {0x4a46000d,0x672200a2,0x0b43000d,0x00000000}},	// [060] янав, vboj, энтн,
  { {0x26100013,0xfa490021,0x27e600a3,0x00000000}},	//   _rào_, تشفى_, wlon_,
  { {0x661b00a4,0x3ea200a5,0x6d5c00a6,0x00000000}},	//   _atuk, lykt_, mfra,
  { {0x2d9a0034,0x764200a7,0x644300a8,0x00000000}},	//   _hope_, troy, drni,
  { {0x6722003d,0xa6130086,0x644300a9,0x00000000}},	//   rboj, еміч, erni,
  { {0x261000aa,0x63ab0019,0x6d5c00ab,0x00000000}},	//   _vào_, _algn, nfra,
  { {0x6d4e00ac,0x291800ad,0x661b0072,0x00000000}},	//   igba, _ifra_, _etuk,
  { {0x764200ae,0x2d9a00af,0x34370021,0x00000000}},	//   proy, _lope_, أسود_,
  { {0x6d5c00b0,0x41e6000d,0x644300b1,0x00000000}},	//   kfra, зіна, arni,
  { {0x6d4e006f,0x644300b2,0x56370047,0x00000000}},	//   jgba, brni, _מאמע_,
  { {0x30a3005a,0xf9930063,0xe8df008b,0x00000000}},	//   еряв, תרת_, _trục_,
  { {0xd36f00b3,0x201e0006,0x69de00b4,0x00000000}},	//   _مهم_, rpti_, hope,
  { {0xe3b300b5,0x644a007c,0x69de00b6,0x00000000}},	//   _אױף_, lufi, kope,
  { {0x72eb00b7,0xdb0d0003,0x6d4e00b8,0x00000000}},	//   _פֿאַ, phaë, ggba,
  { {0xd5c8001b,0x3ce500b9,0x645800ba,0x00000000}},	//   yền_, ælv_, ntvi,
  { {0x6d4e00bb,0x69de00bc,0x6d5c0026,0x00000000}},	//   agba, eope, afra,
  { {0x6d5c00bd,0xdb0d00be,0x4a550085,0x00000000}},	// [070] bfra, nhaé, ькас,
  { {0x5c0700bf,0x7ae600c0,0xc1780006,0x00000000}},	//   _няма, _dykt, ndė_,
  { {0x3ea6003d,0x661b00c1,0x661c00c2,0x00000000}},	//   _ļoti_, _stuk, _črka,
  { {0x644300c3,0x7c3a0003,0x2d9a008d,0x00000000}},	//   vrni, âtre, _zope_,
  { {0xa5090002,0xb5fd008f,0xc1780078,0x00000000}},	//   оела_, _apša, kdė_,
  { {0x69de00c4,0x7bdf00c5,0x7bcd00c6,0x00000000}},	//   cope, loqu, lnau,
  { {0x645800c7,0x644300c8,0x7bcd00c9,0x00000000}},	//   gtvi, urni, onau,
  { {0x61e800ca,0x7bcd00cb,0x8235005d,0x00000000}},	//   eldl, nnau, ورخا,
  { {0x6d5c001f,0x645800cc,0x645c004b,0x00000000}},	//   yfra, atvi, _ärin,
  { {0x644300c2,0xeeeb0013,0x81f60021,0x00000000}},	//   prni, ýờng_, وفير_,
  { {0xbddb00cd,0x7bcd0078,0xc9480063,0x00000000}},	//   trèn, knau, הֲרֹ,
  { {0xd24e007e,0xe291007e,0x201800ce,0x00000000}},	//   دنی_, _لذت_, íria_,
  { {0x2d9a0034,0x69de0035,0xbddb00cd,0x00000000}},	//   _pope_, yope, rrèn,
  { {0x7ae600cf,0xdce50066,0xdb0400ca,0x00000000}},	//   _rykt, _dohľ, skië,
  { {0x6d5c00d0,0xed57005a,0x7e7d00d1,0x00000000}},	//   rfra, ьор_, avsp,
  { {0x8ffa007e,0x6c070021,0x6d5c00d2,0x00000000}},	//   _برتر_, ِيِّ_, sfra,
  { {0x69de00d3,0x2d9a00d4,0x8f8b009a,0x00000000}},	// [080] tope, _tope_, _וְיֵ,
  { {0x7bcd00d5,0x7ae60078,0x4c6a00d6,0x00000000}},	//   anau, _vykt, _дион_,
  { {0x8b2600d7,0x69de00d8,0xeb9a00d9,0x00000000}},	//   _одне, rope, _дин_,
  { {0x46ea00da,0xfaa60085,0x7bdf00db,0x00000000}},	//   оден_, _жамо, coqu,
  { {0x69de00dc,0xe67700dd,0xd61700de,0x00000000}},	//   pope, _aţâţ, وتوا_,
  { {0x645800df,0x644a00e0,0x5ee9009d,0x00000000}},	//   ttvi, tufi, הַצְ,
  { {0x645800d1,0xd90d007e,0x799c002b,0x00000000}},	//   utvi, _ایم_, _iorw,
  { {0xc27400e1,0x02a600e2,0x74690054,0x00000000}},	//   елиј, дром, ярів_,
  { {0x6aa400e3,0x200e00e4,0x026a0054,0x00000000}},	//   nyif, _sufi_, іший_,
  { {0xb5aa0021,0xc1780078,0x680c0058,0x00000000}},	//   _بارك_, udė_, _eşde,
  { {0xc1780006,0x61e800e5,0x799c00e6,0x00000000}},	//   rdė_, rldl, _morw,
  { {0xdce50024,0xd5c80013,0x68e300e7,0x00000000}},	//   _pohľ, iềm_, ündi,
  { {0x799c00e8,0x7bdf00e9,0x69cb00ea,0x00000000}},	//   _oorw, voqu, égek,
  { {0x290700eb,0x6282004b,0x799c00ec,0x00000000}},	//   žnai_, _iroo, _norw,
  { {0x7bcd0006,0x7bdf00ed,0x3a2b00ee,0x00000000}},	//   tnau, toqu, _swcp_,
  { {0x628200ef,0x442c002b,0x26ee0042,0x00000000}},	//   _kroo, _mwd_, _जरूर_,
  { {0x2aab0086,0x8ff8007e,0x7bcd00f0,0x00000000}},	// [090] цтво_, _ترور_, rnau,
  { {0xdb0d0003,0x799c00f1,0xf99300f2,0x00000000}},	//   chaî, _corw, خبر_,
  { {0x200900f3,0x7bdf00f4,0xddcd0078,0x00000000}},	//   _kiai_, poqu, _kraž,
  { {0x6e2d00f5,0xa6350086,0x99890066,0x00000000}},	//   _kwab, енді, dsať_,
  { {0x799c00f6,0x68e70022,0xcfb8009a,0x00000000}},	//   _forw, _wyjd, ולאי_,
  { {0xba430006,0xc58b0076,0x799c001f,0x00000000}},	//   žįst, ющее_, _gorw,
  { {0x645c0019,0x7659001f,0xc01c008b,0x00000000}},	//   _äril, stwy, rước_,
  { {0x6f0d00f7,0x58050021,0x7c3a00f8,0x00000000}},	//   _ngac, _أورك, átri,
  { {0x628200f9,0x6b9d00fa,0x020500fb,0x00000000}},	//   _croo, _mosg, нзин,
  { {0x69c5007a,0x7c3a00fc,0xe5c400fd,0x00000000}},	//   nihe, štri, _исхо,
  { {0x69c500fe,0xf99200ff,0x3cf90042,0x00000000}},	//   iihe, ארי_, ंधों_,
  { {0x62820100,0x32070022,0x43840044,0x00000000}},	//   _froo, _winy_, _للمق,
  { {0xee370101,0x62820102,0x32070034,0x00000000}},	//   ння_, _groo, _tiny_,
  { {0x63a90103,0x00000000,0x00000000,0x00000000}},	//   lken,   ,   ,
  { {0x61d60063,0xe3c90013,0x6b9d0104,0x00000000}},	//   _אוסף_, hằm_, _bosg,
  { {0xebe30086,0x2009008b,0x63a90105,0x00000000}},	//   госп, _giai_, nken,
  { {0x799c0106,0x661c00c3,0x7bc4004b,0x00000000}},	// [0a0] _porw, _črko, riiu,
  { {0xf2d200b5,0x61e10107,0x63a90108,0x00000000}},	//   װעב_, noll, hken,
  { {0x799c00bd,0x7c960021,0x63a90109,0x00000000}},	//   _vorw, _أشخا, kken,
  { {0x63a9006f,0x69c500fe,0xf4f30086,0x00000000}},	//   jken, aihe, _якiй_,
  { {0x63a9010a,0x99800006,0x7d11004c,0x00000000}},	//   dken, usių_, řesň,
  { {0x63a9010b,0x61e1010c,0xcb0a005d,0x00000000}},	//   eken, joll, _ويگن_,
  { {0x61e100fe,0x1867010d,0xb198008b,0x00000000}},	//   doll, _пари_, _nhưỡ,
  { {0x6282010e,0x645c004b,0x61e10072,0x00000000}},	//   _proo, _ärim, eoll,
  { {0x81c60062,0x61e1010f,0x660800b8,0x00000000}},	//   ещне, foll, _tidk,
  { {0x6282006f,0xbddb0110,0x7abb0063,0x00000000}},	//   _vroo, trèm, פציו,
  { {0x69cb00ea,0x79b70047,0xddcd0111,0x00000000}},	//   égei, גליד_, _praž,
  { {0x62820112,0x657a0113,0xd3790086,0x00000000}},	//   _troo, _hath, _очі_,
  { {0x71a60088,0xddcd0114,0x657a0115,0x00000000}},	//   _падз, _vraž, _kath,
  { {0xd12f006a,0x61e10116,0x40940021,0x00000000}},	//   _همه_, coll, _للتر,
  { {0xddcd0117,0x6b9d0118,0x62800119,0x00000000}},	//   _traž, _posg, lvmo,
  { {0x657a011a,0xddcd011b,0x00000000,0x00000000}},	//   _lath, _uraž,   ,
  { {0x3df5011c,0xef64005a,0xb9550062,0x00000000}},	// [0b0] _изис, _също, кващ,
  { {0xdb0d0025,0xd944005e,0x3eb30058,0x00000000}},	//   mhaí, леђи, ıntı_,
  { {0xf84b000d,0x69c5011d,0x63a9011e,0x00000000}},	//   ячай_, rihe, yken,
  { {0x07a40054,0x2eab009a,0xdc88009a,0x00000000}},	//   лаєн, ּשַּ, _נְתָ,
  { {0x8b9a0063,0x657a011f,0x61e10058,0x00000000}},	//   _חברת, _bath, yoll,
  { {0x65940086,0x657a0120,0xb6a20121,0x00000000}},	//   лачу, _cath, ришл,
  { {0x69d50122,0x657a0123,0x20180124,0x00000000}},	//   _ijze, _dath, íril_,
  { {0x68e300bd,0xc1780006,0x657a0025,0x00000000}},	//   ündu, klės_, _eath,
  { {0x657a0125,0x853c0006,0x63a90126,0x00000000}},	//   _fath, _plėt, rken,
  { {0x657a0127,0x61e10072,0x36040021,0x00000000}},	//   _gath, uoll, _موقف,
  { {0x63a900ac,0x61e10128,0x9f42004c,0x00000000}},	//   pken, roll, elká_,
  { {0x61e100fe,0x43740129,0x00000000,0x00000000}},	//   soll, _бушт,   ,
  { {0x61e1012a,0x63a6012b,0xe298012c,0x00000000}},	//   poll, ökne, _паї_,
  { {0x6145012d,0xddcd0022,0x67f8011b,0x00000000}},	//   _река, _graż, míje,
  { {0xb024001b,0xfce6012e,0xc1780078,0x00000000}},	//   _trườ, тово, alės_,
  { {0x1e86012f,0x69d50130,0xbb430131,0x00000000}},	//   _алим, _ajze, иеск,
  { {0xc3320132,0xdcfe008f,0x7f7700ff,0x00000000}},	// [0c0] יון_, _kopī, _יעקב_,
  { {0xe9d70133,0xa96a0044,0xadfa0044,0x00000000}},	//   вку_, ظمام_, _تربط_,
  { {0xdd05000c,0x657a0134,0x777b0135,0x00000000}},	//   ăsăt, _rath, _baux,
  { {0x62840006,0xe3b8005b,0x7bda0003,0x00000000}},	//   _šiom, _atın_, étud,
  { {0x657a0136,0x0af60085,0x29050046,0x00000000}},	//   _path, _шчоў, _úlan_,
  { {0x7c3a0024,0x645c0019,0xdce7008f,0x00000000}},	//   štru, _ärik, lejā,
  { {0xd4670001,0xe5a3005e,0x629d0137,0x00000000}},	//   вије_, рији, äson,
  { {0x07a30138,0xdb040139,0x853c0078,0x00000000}},	//   _касн, dhiú, _plės,
  { {0xa665013a,0x657a013b,0xe2840043,0x00000000}},	//   _مطلو, _tath, اطبی,
  { {0x601e003d,0x657a0027,0x7c3e00c2,0x00000000}},	//   _līme, _uath, _ovpr,
  { {0x9f35013c,0xdb04013d,0x8937009a,0x00000000}},	//   лені, ghiú, כריע_,
  { {0xdb0d0027,0xddcd0051,0x67f8004c,0x00000000}},	//   thaí, _wraż, bíje,
  { {0x7c220066,0xc1780078,0xdce7008f,0x00000000}},	//   _čora, ulės_, dejā,
  { {0xdcf5001c,0x3134013e,0xc237009a,0x00000000}},	//   edzā, _секр, _ירדו_,
  { {0x3ead004c,0xc1780078,0xa3d60042,0x00000000}},	//   šet_, slės_, _सदा_,
  { {0x644a0025,0xbddb0003,0xc1780078,0x00000000}},	//   irfi, guèr, plės_,
  { {0x62840006,0xdd910021,0x8ae70054,0x00000000}},	// [0d0] _šioj, _هوة_, тівл,
  { {0x23b10024,0x3ea40137,0x4c95013f,0x00000000}},	//   _mája_, ämte_, _биос,
  { {0x98140021,0x29070140,0x645c004b,0x00000000}},	//   لبنا, äna_, _ärih,
  { {0xc8640141,0x47350142,0x8c1a009a,0x00000000}},	//   ртфи, ундс, _רורי,
  { {0x7bda0003,0x644a0143,0x9f440003,0x00000000}},	//   étue, erfi, ômé_,
  { {0x2731001b,0x6d550144,0x601e001c,0x00000000}},	//   ạn_, ngza, _zīme,
  { {0xe8940076,0x87db007e,0x19580145,0x00000000}},	//   _карь, _قبرس_, _шары_,
  { {0x29070078,0xb8f70042,0xe3e9005d,0x00000000}},	//   žnas_, ाप_, رکان_,
  { {0x443e0146,0x11e50062,0x38780051,0x00000000}},	//   _evt_, лжим, _zsrr_,
  { {0x443e0147,0x67f80066,0xdb040139,0x00000000}},	//   _fvt_, ríje, thiú,
  { {0x8fa60148,0xcea90149,0x9fca014a,0x00000000}},	//   гане, _צי_, егна_,
  { {0x2619008d,0x99de014b,0xa8a8009a,0x00000000}},	//   _kèo_, бiла_, דֹשִ,
  { {0xe1ee014c,0x29cf0023,0x2bc60042,0x00000000}},	//   _гг_, aļai_, रोफा,
  { {0x26190013,0xd00e005d,0x2bc60082,0x00000000}},	//   _mèo_, _کلي_, रोना,
  { {0x225f00ea,0x26190013,0xec16014d,0x00000000}},	//   ltuk_, _lèo_, اورد,
  { {0xc052014e,0x753800a8,0x8b08011b,0x00000000}},	//   _הזה_, zavz, jpří,
  { {0x225f014f,0xdd04005b,0x5b350085,0x00000000}},	// [0e0] ntuk_, ırıs, рэсу,
  { {0x6e24005b,0x44270150,0x62840078,0x00000000}},	//   _itib, kpn_, _šiok,
  { {0x601e003d,0x574a0062,0x31360041,0x00000000}},	//   _tīme, езем_, רנעם_,
  { {0x645c0019,0xbddb0003,0x26190013,0x00000000}},	//   _ärii, quèr, _bèo_,
  { {0x47330086,0x443e0151,0xe5c60152,0x00000000}},	//   сніс, _svt_, лско,
  { {0x225f00ea,0x8b080080,0x2816007e,0x00000000}},	//   dtuk_, apří, _موسس,
  { {0x67dc00a8,0xf8780063,0xb4660044,0x00000000}},	//   ečje, _בְּל, ادته,
  { {0x7f440153,0x722a0154,0x5c370041,0x00000000}},	//   _ndiq, нцов_, ארקן_,
  { {0xd214005e,0x8556002a,0x27e60155,0x00000000}},	//   јмоћ, _مخاط, moon_,
  { {0x104a0156,0x27e60157,0x9a420013,0x00000000}},	//   нями_, loon_, _đẳn,
  { {0x2a600019,0x645e00cd,0x6e240035,0x00000000}},	//   htib_, àpid, _atib,
  { {0x27e60158,0x236600a8,0x41b4005d,0x00000000}},	//   noon_, _uboj_, امگر,
  { {0x63a20159,0xf194015a,0x6234015b,0x00000000}},	//   _ioon, _виль, _телу,
  { {0x63a20019,0x27e6015c,0x3cb5000d,0x00000000}},	//   _hoon, hoon_, айгр,
  { {0x63a20019,0x27e6015d,0x14d8009d,0x00000000}},	//   _koon, koon_, דַּמ,
  { {0x63a20019,0x764b001f,0x30130062,0x00000000}},	//   _joon, yrgy, _удър,
  { {0x63a2015e,0x27e6015f,0xc9870160,0x00000000}},	// [0f0] _moon, doon_, лужи,
  { {0x7e6d00bb,0x2bc60161,0x60d3001c,0x00000000}},	//   _ipap, रोबा, ņemš,
  { {0x27e60162,0x6d450035,0x225f0163,0x00000000}},	//   foon_, _idha, ztuk_,
  { {0x63a2002c,0xd5b60001,0xbddb0164,0x00000000}},	//   _noon, cикл, ssèd,
  { {0x69cb00ea,0xbb3a0165,0xe6c7005d,0x00000000}},	//   éges, _בערי, دتاي,
  { {0x3a290089,0xd5bb000d,0x64a50121,0x00000000}},	//   mpap_, эсе_, иала,
  { {0x63a20166,0x9f420167,0x27e60168,0x00000000}},	//   _boon, soké_, boon_,
  { {0x225f00ea,0xc2450169,0xdb04013d,0x00000000}},	//   ttuk_, аник, lkiá,
  { {0xa3d6016a,0x6d45016b,0x63a2016c,0x00000000}},	//   _सदर_, _odha, _doon,
  { {0x6d450035,0xb5fd007d,0x7c250139,0x00000000}},	//   _ndha, _opši, _othr,
  { {0x229a00eb,0x4049005a,0x225f016d,0x00000000}},	//   ešką_, ъпно_, stuk_,
  { {0x225f00ea,0x3861002b,0xc49a016e,0x00000000}},	//   ptuk_, ithr_, _בשעת,
  { {0x7c25016f,0x69c7007d,0x00000000,0x00000000}},	//   _athr, _omje,   ,
  { {0x63a20170,0x27e60171,0x291f0058,0x00000000}},	//   _zoon, zoon_, _şuan_,
  { {0x4174006a,0x2d840080,0x30790047,0x00000000}},	//   _دانس, ěme_, _יאַנ,
  { {0x4b26000d,0x69c70130,0x63a20172,0x00000000}},	//   рмав, _amje, _xoon,
  { {0x9a250021,0xdce7003b,0xba230062,0x00000000}},	// [100] معلن, tejă, ждук,
  { {0x1e3b014e,0x64410080,0x27e60173,0x00000000}},	//   _שגיא, _ovli, woon_,
  { {0xa3e50053,0xe73a0174,0xb607008f,0x00000000}},	//   पका_, вее_, _mašī,
  { {0x78a300fe,0xd8230086,0xd62a0175,0x00000000}},	//   änva, ідчи, воде_,
  { {0x27e60176,0x6d410026,0x64410177,0x00000000}},	//   roon_, ðlag, _avli,
  { {0x224d004b,0x3619000d,0xef1f0058,0x00000000}},	//   drek_, уццю_, zcü_,
  { {0xb7960001,0x63a20178,0x9423005e,0x00000000}},	//   _краћ, _poon, омје,
  { {0x67f80066,0x987b016e,0x224d0046,0x00000000}},	//   bíja, _באלט, frek_,
  { {0xe57a0001,0xfbb70063,0x64410058,0x00000000}},	//   _иза_, יפקת_, _evli,
  { {0x63a20179,0x2bc60053,0xdce70022,0x00000000}},	//   _woon, रोता, leją,
  { {0x63a2017a,0x09f70063,0x60f70121,0x00000000}},	//   _toon, שמים_, инья_,
  { {0x3f800016,0x224d017b,0x9f530058,0x00000000}},	//   _caiu_, brek_, _ödül_,
  { {0x539b0063,0xef1f0058,0x6253017c,0x00000000}},	//   _שידו, rcü_, ržoá,
  { {0xdb0d017d,0x3ea40137,0x7bd6017e,0x00000000}},	//   lhaç, ämta_, enyu,
  { {0xab950138,0xd1380051,0xddc4003b,0x00000000}},	//   бављ, ając_, _spiţ,
  { {0x69c7017f,0xbf35005a,0xdb0d017d,0x00000000}},	//   _smje, _унищ, nhaç,
  { {0x6d410014,0xe3b80075,0x2bc60042,0x00000000}},	// [110] ólas, _atık_, रोधा,
  { {0x6d450035,0xdcb1008b,0x2887005e,0x00000000}},	//   _udha, ở_, ићев,
  { {0xcd760063,0xa34c0078,0x4dda0063,0x00000000}},	//   _העתק_, dėžė_, _תחתו,
  { {0x2d8300ea,0x645700cd,0x44250180,0x00000000}},	//   ldje_, àxim, _rtl_,
  { {0x2d810019,0x7bcd0006,0x65b400cd,0x00000000}},	//   _kahe_, miau, _sàha,
  { {0x69c7017f,0x7bcd0006,0x85e80086,0x00000000}},	//   _umje, liau, адів_,
  { {0x23b1000f,0x69d700ac,0x628600b9,0x00000000}},	//   _fájl_, mnxe, ækon,
  { {0x2d810019,0x224d0181,0x7bcd0182,0x00000000}},	//   _lahe_, trek_, niau,
  { {0x27ed0058,0x61e8002b,0x11390183,0x00000000}},	//   _iken_, fodl, ляны_,
  { {0x224d00e8,0x3f800016,0x2d8100bd,0x00000000}},	//   rrek_, _saiu_, _nahe_,
  { {0x600a0184,0x7bcd0006,0xa069005e,0x00000000}},	//   лном_, kiau, ћама_,
  { {0x25a50185,0x224d0186,0xdb0d017d,0x00000000}},	//   _holl_, prek_, chaç,
  { {0x21690187,0x73c40021,0x25a50188,0x00000000}},	//   _били_, _بينم, _koll_,
  { {0x2d83017f,0x41260189,0xdce70022,0x00000000}},	//   gdje_, _лошо_, zeją,
  { {0x645c0019,0x27ed018a,0x765d00a5,0x00000000}},	//   _ärit, _oken_, _åsyf,
  { {0x7bcd0006,0x8b95018b,0x25a5004b,0x00000000}},	//   giau, оруч, _loll_,
  { {0xdb1d00b9,0x3946000d,0x63bb004d,0x00000000}},	// [120] _omsæ, йнаг, ihun,
  { {0x25a500c7,0x2fc900c2,0x645c018c,0x00000000}},	//   _noll_, _zmag_, _årig,
  { {0x6c860032,0xddd60006,0x7bcd0006,0x00000000}},	//   _الجم, _kryž, biau,
  { {0x27ff018d,0xb73a0021,0x7bcd0003,0x00000000}},	//   _chun_, اثاء_, ciau,
  { {0x95ca018e,0x66e60086,0x25a5018f,0x00000000}},	//   лука_, щода, _boll_,
  { {0x27ed0190,0x63bb00bd,0x7a410080,0x00000000}},	//   _eken_, ehun, sátý,
  { {0x628b0191,0x29cf008f,0x6e36002b,0x00000000}},	//   _argo, aļas_, _lwyb,
  { {0x29150058,0x6b840192,0xb8cc0042,0x00000000}},	//   ğdaş_, ndig, गह_,
  { {0xd1300032,0x1a9a00b5,0x61e80058,0x00000000}},	//   ومة_, ריִע, todl,
  { {0x361b0063,0x25a5001f,0x2fc900b9,0x00000000}},	//   _עובד, _goll_, _smag_,
  { {0x63bb0025,0x2d83007d,0x9f990193,0x00000000}},	//   bhun, vdje_, авну_,
  { {0xf8b3014e,0x753a0194,0x6b84006f,0x00000000}},	//   פשר_, _hetz, jdig,
  { {0x753a004d,0xddc40195,0x7bcd00d5,0x00000000}},	//   _ketz, _spiš, viau,
  { {0x753a00bd,0x645c0019,0x6b840196,0x00000000}},	//   _jetz, _äris, edig,
  { {0x7bcd0197,0x2d810019,0xe0d3005e,0x00000000}},	//   tiau, _vahe_, _ношњ,
  { {0xddc40198,0x753a0199,0x6b84006f,0x00000000}},	//   _vpiš, _letz, gdig,
  { {0x6e360185,0x7bcd019a,0xaa59019b,0x00000000}},	// [130] _gwyb, riau, ризу_,
  { {0x753a0199,0x7bcd0006,0x26360051,0x00000000}},	//   _netz, siau, dło_,
  { {0xddc4017f,0x90d5008b,0x213e0139,0x00000000}},	//   _upiš, hàn, iath_,
  { {0x25a50199,0xaa95019c,0x2bf40085,0x00000000}},	//   _soll_, _димч, _няўр,
  { {0xb5fd0117,0x9599019d,0x25a5019e,0x00000000}},	//   _opšt, итку_, _poll_,
  { {0x7afd019f,0x5e580063,0xe9180054,0x00000000}},	//   _izst, מידע_, _горі_,
  { {0x799500bd,0x25a500bd,0x27ff004d,0x00000000}},	//   _inzw, _voll_, _thun_,
  { {0x27ed0031,0x213e01a0,0x63bb01a1,0x00000000}},	//   _uken_, eath_, uhun,
  { {0x25a5010e,0xdcfc008f,0x63bb01a2,0x00000000}},	//   _toll_, idrā, rhun,
  { {0xdb1d0014,0x63bb01a3,0x504501a4,0x00000000}},	//   _umsæ, shun, оеоб,
  { {0xc952014e,0x00e20088,0x32050034,0x00000000}},	//   ומי_, джэн, rmly_,
  { {0x661b01a5,0x628b01a6,0xe3b301a7,0x00000000}},	//   _kuuk, _trgo, _عرض_,
  { {0x644300c7,0x333f0164,0x645c0019,0x00000000}},	//   lsni, maux_, _ärir,
  { {0x333f01a8,0x661b01a9,0x1167005d,0x00000000}},	//   laux_, _muuk, _طلبی_,
  { {0x8fa601aa,0x644301ab,0x70520021,0x00000000}},	//   _маке, nsni, _قنوا,
  { {0x333f0164,0x6b840173,0x26360051,0x00000000}},	//   naux_, udig, yło_,
  { {0x49ca0001,0x6b8401ac,0xba290021,0x00000000}},	// [140] алан_, rdig, مسلم_,
  { {0x6b8401ad,0x644301ae,0x00000000,0x00000000}},	//   sdig, ksni,   ,
  { {0x2d950088,0x3e6400fe,0x644301af,0x00000000}},	//   _хрыс, löt_, jsni,
  { {0x753a00bd,0x644301b0,0x6d5c01b1,0x00000000}},	//   _setz, dsni, lgra,
  { {0x7c2e00e8,0x96b70001,0x3e6401b2,0x00000000}},	//   lpbr, жују_, nöt_,
  { {0x64430146,0x2738001b,0xc7b900ea,0x00000000}},	//   fsni, ẩn_, _elő_,
  { {0x26360045,0x291801b3,0xe73a01b4,0x00000000}},	//   sło_, _igra_, _веб_,
  { {0x6d5c001f,0x333f0003,0x8c1b0063,0x00000000}},	//   hgra, gaux_, סופי,
  { {0x82a6000d,0xd6250021,0x644301b5,0x00000000}},	//   юшке, _فعلي, asni,
  { {0x62840006,0x644301b6,0xa158005e,0x00000000}},	//   _šios, bsni, љану_,
  { {0x333f0003,0x6d5c01b7,0xdfd100f2,0x00000000}},	//   baux_, dgra, فيد_,
  { {0x442e00bd,0x333f0164,0x4fc7000d,0x00000000}},	//   mpf_, caux_, існа,
  { {0x2294005a,0x645801b8,0x9f4e013d,0x00000000}},	//   _хиля, luvi, ónál_,
  { {0x6d5c01b9,0x64580080,0xe2a9007e,0x00000000}},	//   ggra, ouvi, _دامن_,
  { {0xe0d40047,0x6021001c,0x2ba70095,0x00000000}},	//   _מײַ_, _tēma, ојав,
  { {0x6d5c01ba,0x3f85001c,0x2d9e01bb,0x00000000}},	//   agra, ēlus_, öter_,
  { {0x201c0019,0xaa550062,0x6443008f,0x00000000}},	// [150] _huvi_, яваш, zsni,
  { {0x644301bc,0x645800fe,0xdce70051,0x00000000}},	//   ysni, kuvi, zeję,
  { {0x7d7a0063,0x333f0003,0xe7190021,0x00000000}},	//   _הנתו, yaux_, ميات_,
  { {0x644301b9,0x6c7a0047,0x2cac0137,0x00000000}},	//   vsni, _פארפ, ädde_,
  { {0x333f0164,0x7afd003d,0xcb9a0063,0x00000000}},	//   vaux_, _uzst, _הסרט,
  { {0x201c017d,0xae7c0063,0x3d190053,0x00000000}},	//   _ouvi_, שְׁת, _दलों_,
  { {0x333f0164,0x8cd10053,0xe3b10021,0x00000000}},	//   taux_, _डेमो, فرة_,
  { {0x644301bd,0xdb1d004d,0x3e640072,0x00000000}},	//   rsni, _umsä, yöt_,
  { {0x333f0164,0x644301be,0x6d5c01bf,0x00000000}},	//   raux_, ssni, ygra,
  { {0x644300eb,0x23b10066,0x64580078,0x00000000}},	//   psni, _máji_, buvi,
  { {0x333f0164,0x645c0019,0xc9520047,0x00000000}},	//   paux_, _ärip, עמט_,
  { {0xb4fa0063,0x3e640072,0x6d5c01c0,0x00000000}},	//   _הפעי, töt_, wgra,
  { {0x3fc9007e,0x6d5c01c1,0xcaea0042,0x00000000}},	//   تگوی_, tgra, _झुंड_,
  { {0xd1840054,0xda1f0042,0x91f700de,0x00000000}},	//   _олій, _बढ़त_, _بأصا,
  { {0x3e6400fe,0x9f9201c2,0x224600c2,0x00000000}},	//   söt_, lší_, _zvok_,
  { {0x6d5c01c3,0xba260085,0x9f42011b,0x00000000}},	//   sgra, здак, boká_,
  { {0x6e460032,0x6d5c01c4,0x9f920114,0x00000000}},	// [160] _عندم, pgra, nší_,
  { {0x7c2e01c5,0x67f80066,0x2b4001c6,0x00000000}},	//   ppbr, ríjm, saic_,
  { {0x9f920066,0x08c6005e,0x9d1b016e,0x00000000}},	//   hší_, џбен, _לויט,
  { {0x78720026,0x9f4b01a8,0xd70a0121,0x00000000}},	//   _aðvö, gocè_, бнее_,
  { {0x9f920114,0x9b17009a,0x28de0082,0x00000000}},	//   jší_, _מחכה_, _मशवि,
  { {0x8afb0063,0x645801c7,0x9f9201c8,0x00000000}},	//   _להכי, tuvi, dší_,
  { {0x69ce01c9,0xdd570047,0x986c008f,0x00000000}},	//   _imbe, לבסט_, rķēt_,
  { {0x7d0701ca,0x645801cb,0x03c30121,0x00000000}},	//   léré, ruvi, есьм,
  { {0x645801cc,0x201c01cd,0x518601ce,0x00000000}},	//   suvi, _suvi_, пуна,
  { {0x7d070164,0x645801cf,0x9f42004c,0x00000000}},	//   néré, puvi, voká_,
  { {0x9f920080,0x601e001c,0xf9930063,0x00000000}},	//   aší_, _zīmj, גרת_,
  { {0x60280080,0x78fb0047,0xb4fb0047,0x00000000}},	//   _něme, מפיו, _פלאר,
  { {0x69ce01d0,0x7e7d006f,0x7d0700ea,0x00000000}},	//   _ombe, uwsp, kéré,
  { {0x127b0041,0x9f4201d1,0x256f0075,0x00000000}},	//   _לאדע, roká_, cılı_,
  { {0x7d070164,0x6b8601d2,0x9f42004a,0x00000000}},	//   déré, _bakg, soká_,
  { {0x442c0089,0x69ce01d3,0x60db009a,0x00000000}},	//   _mtd_, _ambe, _לקונ,
  { {0xdcf2001c,0x7d0701d4,0x6a1501d5,0x00000000}},	// [170] īgāk, féré, дмау,
  { {0xceb20047,0x6e2d01d6,0x7d070003,0x00000000}},	//   _סיי_, _itab, géré,
  { {0xdcee000c,0xf1b30047,0x9f92004c,0x00000000}},	//   rebă, עסע_, zší_,
  { {0x256f005b,0x69ce01d7,0x6282004b,0x00000000}},	//   zılı_, _embe, _osoo,
  { {0x442c0080,0x644800c2,0xeafa0053,0x00000000}},	//   _atd_, _avdi, ्धृत_,
  { {0xcb1201d8,0x93b5001b,0x9f9201d9,0x00000000}},	//   _שלך_, _cũn, vší_,
  { {0x628200e8,0x6592007b,0x9f42004c,0x00000000}},	//   _asoo, тају, elký_,
  { {0x9f9201da,0xdcfe001c,0x442c01db,0x00000000}},	//   tší_, _japā, _dtd_,
  { {0x256f005b,0xa3be0053,0x69ce01dc,0x00000000}},	//   tılı_, ीफ़_, _ymbe,
  { {0xdcfe003d,0xab5b00bd,0x9f920114,0x00000000}},	//   _lapā, _flüg, rší_,
  { {0x41050055,0xd3710032,0x256f005b,0x00000000}},	//   ьзов, _لها_, rılı_,
  { {0x256f005b,0x9f920114,0x2252005b,0x00000000}},	//   sılı_, pší_, ünkü_,
  { {0xee3700a0,0xa29401dd,0x256f0058,0x00000000}},	//   мня_, _паці, pılı_,
  { {0x79870045,0x63ab01de,0x6e2d0025,0x00000000}},	//   _najw, _hogn, _dtab,
  { {0x2c870080,0x6e2d01df,0x7d0701e0,0x00000000}},	//   vídá_, _etab, véré,
  { {0x7076007e,0x672901e1,0xeb9701e2,0x00000000}},	//   _آميز_, _nfej, мис_,
  { {0x63a601e3,0x7d0701ca,0xc9aa000d,0x00000000}},	// [180] ökni, téré, овае_,
  { {0xc8d60044,0x00000000,0x00000000,0x00000000}},	//   وزاع,   ,   ,
  { {0x1d0a0002,0x07a60121,0x2a69004b,0x00000000}},	//   _фени_, мажн, atab_,
  { {0x7d070003,0xe73701e4,0x2d8a009c,0x00000000}},	//   séré, дец_, ldbe_,
  { {0x7d070164,0x47330086,0x442c01e5,0x00000000}},	//   péré, тніс, _std_,
  { {0x442c0089,0x69ce01e6,0x2d8a013d,0x00000000}},	//   _ptd_, _umbe, ndbe_,
  { {0xd8230062,0x644d008f,0xd75a0044,0x00000000}},	//   _адси, ņain, _ولست_,
  { {0x63ab01e7,0x8c1b009a,0xdc89009a,0x00000000}},	//   _cogn, חוקי, לְפָ,
  { {0x63ab00a8,0xa2940085,0x5313005d,0x00000000}},	//   _dogn, хапі, پذير,
  { {0x442c0150,0x60280080,0x2d8a00a8,0x00000000}},	//   _ttd_, _němc, jdbe_,
  { {0x63ab00ea,0x19570063,0xf9570063,0x00000000}},	//   _fogn, וביל_, וסית_,
  { {0xe29a01e8,0x33930021,0x78a301e9,0x00000000}},	//   _мае_, _للمز, änvi,
  { {0x31c601ea,0xc333009a,0x81a60044,0x00000000}},	//   _оскв, _סוס_, _يحتل,
  { {0xe0cf006a,0x12fb0063,0x00000000,0x00000000}},	//   ازی_, _והדב,   ,
  { {0xdb06000f,0xfbab0085,0x1df801eb,0x00000000}},	//   _elkü, отай_, феры_,
  { {0x9fe70021,0x2a6901ec,0x2cac0137,0x00000000}},	//   _تسته, ttab_, ädda_,
  { {0xdd950088,0x9e070086,0x6e2d0035,0x00000000}},	// [190] _запы, _очол, _utab,
  { {0x3df40121,0x6f000058,0x89340044,0x00000000}},	//   _изыс, ümce, نعما,
  { {0x2a690004,0x917b001b,0x22510051,0x00000000}},	//   stab_, _hệ_, ązki_,
  { {0xaad00042,0x957c0022,0xf093009a,0x00000000}},	//   _सेवक, _skąp, כנע_,
  { {0xcb36014e,0xc5f50062,0x63ab01ed,0x00000000}},	//   _ראשי_, някъ, _rogn,
  { {0x63ab01ee,0x659401ef,0xd7c9005d,0x00000000}},	//   _sogn, качу, _کوره_,
  { {0x917b001b,0x63ab01f0,0x7bdf01f1,0x00000000}},	//   _lệ_, _pogn, onqu,
  { {0xd2a90121,0x9992014b,0xf804014b,0x00000000}},	//   зкие_, лiзм_, _ачун,
  { {0x63ab01f2,0x7bda0003,0x645c00cf,0x00000000}},	//   _vogn, étui, _årin,
  { {0xd1c60121,0x1515000d,0xe50701f3,0x00000000}},	//   елье_, _здзя, _قباي,
  { {0x63ab01f4,0x672401f5,0xddcb0075,0x00000000}},	//   _togn, žije, _şişe,
  { {0x8fa601f6,0xa856009a,0xdd92005d,0x00000000}},	//   хаме, עירה_, گوس_,
  { {0xf1a8005d,0xeef50085,0x00000000,0x00000000}},	//   سایه_, вярэ,   ,
  { {0x92c101f7,0xc0e501f8,0xd245005d,0x00000000}},	//   ığın, _полк, یچ_,
  { {0xddcd000c,0x61e600ea,0x1d070002,0x00000000}},	//   _spaţ, ékle, еери_,
  { {0xfaa6014b,0xba1a00de,0x00000000,0x00000000}},	//   набо, كيرا_,   ,
  { {0x3956000a,0xc33201f9,0xf4120047,0x00000000}},	// [1a0] ењет, טון_, רפן_,
  { {0xac860079,0xdcfe000c,0x7bdf01fa,0x00000000}},	//   _згол, _capă, anqu,
  { {0xc1720063,0xa81a01fb,0xbb4601fc,0x00000000}},	//   רחב_, ستار_, _пенк,
  { {0xfaa601fd,0x999f008f,0xe66601f6,0x00000000}},	//   _замо, āršo_, етко,
  { {0x3c3e004c,0xcb150085,0xd5c50054,0x00000000}},	//   lův_, _афры, _кiмн,
  { {0xa4d4013c,0xe3b80058,0xe5a301fe,0x00000000}},	//   колі, _atıp_, личи,
  { {0x3c3e004c,0xa3cc0042,0xe44f0044,0x00000000}},	//   nův_, रफल_, مضي_,
  { {0x76690072,0x6f0401ff,0xc2980200,0x00000000}},	//   ösyö, _ozic, дких_,
  { {0xdac20054,0x66e30201,0x28020023,0x00000000}},	//   кцiя_, _бота, ārnē_,
  { {0x64a60202,0x2fc0013d,0x98ba003b,0x00000000}},	//   _паза, _alig_, capă_,
  { {0x7bd60089,0x8f35000d,0x320c002b,0x00000000}},	//   kiyu, кенц, rmdy_,
  { {0x83360021,0x3c3e004c,0x83690044,0x00000000}},	//   _أراض, dův_, _يصنف_,
  { {0x644a0203,0xddcd0078,0x82b3007e,0x00000000}},	//   lsfi, _apaš, _محوط,
  { {0x9f4b0080,0x917b008b,0x661a004c,0x00000000}},	//   mocí_, _vệ_, _jitk,
  { {0x661a00fe,0x644a0196,0x4c840085,0x00000000}},	//   _mitk, nsfi, ллёв,
  { {0xd13800eb,0x7bdf0204,0x749b0047,0x00000000}},	//   lbą_, unqu, הילפ,
  { {0x66d3000f,0x9f4b006d,0x4fd80063,0x00000000}},	// [1b0] _műkö, nocí_, _רוחב_,
  { {0x644a0205,0x317e0206,0x661a0207,0x00000000}},	//   ksfi, netz_, _nitk,
  { {0x20090208,0x6d470209,0x2fc000d1,0x00000000}},	//   _khai_, maja, _ylig_,
  { {0x6d47020a,0x7bc4020b,0x644a020c,0x00000000}},	//   laja, chiu, dsfi,
  { {0x6b9d00bd,0x46a40086,0x661a020d,0x00000000}},	//   _insg, лаїв, _bitk,
  { {0xab5b00bd,0x6d47020e,0x6b8d020f,0x00000000}},	//   _flüc, naja, ldag,
  { {0xab5b00bd,0x6d470210,0x6b8d0003,0x00000000}},	//   _glüc, iaja, odag,
  { {0xe65d005b,0x6d470211,0x6b8d0212,0x00000000}},	//   ştığ, haja, ndag,
  { {0x7412007e,0x6b8d0019,0x64580213,0x00000000}},	//   جويا, idag, arvi,
  { {0x27fd001f,0x93bc003b,0x6d470214,0x00000000}},	//   llwn_, _stăt, jaja,
  { {0x6d470215,0xf992014e,0x7659001f,0x00000000}},	//   daja, ברי_, lrwy,
  { {0x6b8d006f,0x20090216,0x1fb60217,0x00000000}},	//   jdag, _chai_, тсор,
  { {0x63a90117,0x93b6014e,0xddcd007d,0x00000000}},	//   mjen, _שלנו_, _spaš,
  { {0x6b8d0218,0x63a90219,0x865a0063,0x00000000}},	//   edag, ljen, ודשי,
  { {0x22510051,0xc5f20063,0x6b8d0014,0x00000000}},	//   ązku_, ידך_, fdag,
  { {0x6b8d00bb,0x69d7021a,0x63a9021b,0x00000000}},	//   gdag, eixe, njen,
  { {0x4b23019d,0x6d47021c,0x63bb0035,0x00000000}},	// [1c0] рмув, baja, ikun,
  { {0xfe1e0053,0x6b8d021d,0x63a9021e,0x00000000}},	//   _यूएस_, adag, hjen,
  { {0x7659021f,0x63a90220,0x8c43005b,0x00000000}},	//   erwy, kjen, üşte,
  { {0x69d700cd,0x6e240035,0x7659002b,0x00000000}},	//   aixe, _kuib, frwy,
  { {0x76590185,0x661a00fe,0x443e003e,0x00000000}},	//   grwy, _pitk, _swt_,
  { {0x69c50221,0x799c0222,0x6458007d,0x00000000}},	//   chhe, _unrw, trvi,
  { {0xd5b1008b,0x7659002b,0x661a0223,0x00000000}},	//   _tín_, arwy, _vitk,
  { {0x63a90224,0x64a30001,0xfe1e0053,0x00000000}},	//   gjen, раћа, _यूऍस_,
  { {0x20090185,0xfbd3014e,0x6d470035,0x00000000}},	//   _rhai_, יתה_, yaja,
  { {0xa3f50080,0x661a0173,0xdcfe0024,0x00000000}},	//   ější_, _uitk, _dopĺ,
  { {0xd1380006,0x6d470225,0x20090013,0x00000000}},	//   rbą_, vaja, _phai_,
  { {0x63bb00bd,0x317e00bd,0x63a90226,0x00000000}},	//   ckun, setz_, cjen,
  { {0x6d470227,0x42540021,0x6e24003b,0x00000000}},	//   taja, _إنتر, _cuib,
  { {0x3df40094,0x20d600de,0x00000000,0x00000000}},	//   изяс, _لتعج,   ,
  { {0x6d470228,0x80a3007e,0x6b8d0229,0x00000000}},	//   raja, _نمون, tdag,
  { {0x7659002b,0x5f7701fb,0x6d47022a,0x00000000}},	//   yrwy, _شاعر, saja,
  { {0xbf9b00ac,0x6b8d022b,0xf96b022c,0x00000000}},	// [1d0] glêe, rdag, дрей_,
  { {0x68fc022d,0x6b8d022e,0x49540044,0x00000000}},	//   _byrd, sdag, لخمس,
  { {0x6b8d022f,0x3eb90230,0xf795000d,0x00000000}},	//   pdag, lyst_, лажэ,
  { {0x76590185,0x98b8003b,0x3dcf0022,0x00000000}},	//   trwy, _seră_, żową_,
  { {0x61e1001f,0x6d450231,0xe736005e,0x00000000}},	//   ynll, _keha, ћеш_,
  { {0xe6180086,0x63bb006f,0x66d2005b,0x00000000}},	//   вді_, wkun, _sıkç,
  { {0x63a90232,0x7659001f,0x63bb0233,0x00000000}},	//   tjen, srwy, tkun,
  { {0x93bc000c,0x7c250150,0x7afd0234,0x00000000}},	//   _stăr, _muhr, _kyst,
  { {0x59b70235,0x63a90236,0x63bb0237,0x00000000}},	//   _आकार, rjen, rkun,
  { {0x6d4500c3,0x7afd0238,0xf0a90239,0x00000000}},	//   _neha, _myst, екол_,
  { {0x7afd023a,0xf1c30006,0x0467023b,0x00000000}},	//   _lyst, _ryšį_, _штам,
  { {0xdb0f017d,0xdb06023c,0x08760047,0x00000000}},	//   _você, _loká, נערט_,
  { {0x4425021f,0x69d50122,0x4e270062,0x00000000}},	//   _hul_, _omze, лоян_,
  { {0x6145000a,0x4ed50086,0x4425023d,0x00000000}},	//   _сека, рюют, _kul_,
  { {0x224d0150,0x4425023e,0xe0550021,0x00000000}},	//   lsek_, _jul_, _إختب,
  { {0x44250019,0xdcf5001c,0x7afd023f,0x00000000}},	//   _mul_, edzē, _byst,
  { {0xdcfc0240,0x7afd0241,0xa95a0242,0x00000000}},	// [1e0] merč, _cyst, فجار_,
  { {0x3f820004,0xd5b1001b,0x386100bd,0x00000000}},	//   leku_, _nó_, fuhr_,
  { {0x9f4b017d,0xdb06004a,0x31ba0047,0x00000000}},	//   locá_, _doká, עזענ,
  { {0x224d01f7,0x3f820019,0xc66a0001,0x00000000}},	//   ksek_, neku_, ешке_,
  { {0x7f3b00b5,0x7afd001f,0x68fc002b,0x00000000}},	//   גענו, _gyst, _wyrd,
  { {0xd5b100aa,0x4425005b,0x6441002b,0x00000000}},	//   _có_, _bul_, _bwli,
  { {0xd4670001,0x44250243,0x7afd0244,0x00000000}},	//   гије_, _cul_, _zyst,
  { {0x44250027,0x3f82017f,0x53980245,0x00000000}},	//   _dul_, jeku_, твия_,
  { {0x9f4b00cd,0xdb0600ea,0x316a0062,0x00000000}},	//   vocà_, _elkö, ншно_,
  { {0x6021001c,0xdb0f00cd,0x6441002b,0x00000000}},	//   _lēmu, _docè, _fwli,
  { {0x09f70063,0x44250246,0x798e002b,0x00000000}},	//   רמים_, _gul_, _mabw,
  { {0x6d45014f,0xdcf5001c,0x98b80006,0x00000000}},	//   _seha, zdzē, _gerą_,
  { {0x6d450247,0x44250248,0x00000000,0x00000000}},	//   _peha, _zul_,   ,
  { {0xbb1b0164,0xeb9f00d1,0x7afd000e,0x00000000}},	//   _maît, _snø_, _ryst,
  { {0x6c540054,0x6d450130,0x3f820249,0x00000000}},	//   йкру, _veha, beku_,
  { {0x7afd024a,0xdb06013d,0xa09b0063,0x00000000}},	//   _pyst, _soká, _טיוט,
  { {0x6d450019,0x79d50086,0xbb1b0003,0x00000000}},	// [1f0] _teha, ажає, _naît,
  { {0xdcf5008f,0x5d67005e,0x85420078,0x00000000}},	//   udzē, _стиз, šėja,
  { {0x7afd0045,0xd7c8007e,0xdb06024b,0x00000000}},	//   _wyst, گونه_, _voká,
  { {0x31e1024c,0x4425024d,0xe7190021,0x00000000}},	//   _पद्ध, _rul_, نيات_,
  { {0x4425024e,0x98aa001c,0xb6a50121,0x00000000}},	//   _sul_, ējām_, рилл,
  { {0x93bc000c,0x2d83024f,0x69d500ac,0x00000000}},	//   _stăp, neje_, _umze,
  { {0xe3b10032,0x75d2005d,0xf8b90042,0x00000000}},	//   قرة_, تيوا, _इथिय,
  { {0xdb1d0026,0x44250250,0x224d00a4,0x00000000}},	//   _umsó, _vul_, tsek_,
  { {0x290c0025,0xa235000d,0xdcfc0006,0x00000000}},	//   _údar_, шэйш, verč,
  { {0x601f0078,0x41b50251,0x224d0252,0x00000000}},	//   _rūma, рсит, rsek_,
  { {0x3f820253,0x66ca00ea,0xa069005e,0x00000000}},	//   teku_, _töké, њама_,
  { {0xe0d6005a,0x52d90121,0xdb1d0046,0x00000000}},	//   рвю_, _имею_, _alsí,
  { {0xab5b004d,0x3f8200a8,0x2d830254,0x00000000}},	//   _plün, reku_, feje_,
  { {0xae870002,0x3f820255,0x7bc8008f,0x00000000}},	//   јбрз_, seku_, īdum,
  { {0xdd0e005b,0x8c460256,0x7bc80023,0x00000000}},	//   _dışa, ребе, ūdum,
  { {0xc0520063,0xb92b0013,0x3ff30044,0x00000000}},	//   _וזה_, _thuỵ_, _وكور,
  { {0xeab70257,0x39460258,0xaae50044,0x00000000}},	// [200] айт_, инаг, مسكو,
  { {0xc8960259,0x2896005e,0x7d09004c,0x00000000}},	//   ирењ, ијес, řesa,
  { {0xc8ca01fb,0x8726025a,0xfeba005d,0x00000000}},	//   خوان_, амеж, _ساکت_,
  { {0x628b001f,0xeef60047,0x6d410046,0x00000000}},	//   _osgo, ֱמַר_, ðlav,
  { {0x6b84025b,0xb8fd0042,0x20020046,0x00000000}},	//   meig, _ते_, ilki_,
  { {0x6b84025c,0x9980005f,0xd5e30054,0x00000000}},	//   leig, rpių_, ожчи,
  { {0x29270024,0x26c0025d,0x6feb0022,0x00000000}},	//   ávať_, šio_, hęca,
  { {0x6b84025e,0x25b20078,0x290a025f,0x00000000}},	//   neig, _žalą_, _izba_,
  { {0xc1a600e1,0xbddb006c,0xa3c70042,0x00000000}},	//   ајни, isèr, _उतर_,
  { {0x6299002b,0xda160053,0x22590260,0x00000000}},	//   _drwo, थगित_, áska_,
  { {0xc95301f9,0x629900bd,0x2d830261,0x00000000}},	//   חמת_, _erwo, veje_,
  { {0x27e60262,0x03a30263,0x04db009a,0x00000000}},	//   nnon_, _михо, _בקבל,
  { {0x5f94011c,0x22580076,0x2005001c,0x00000000}},	//   цият, _силы_, ēli_,
  { {0x7bc6024a,0x27e60089,0x6b84004d,0x00000000}},	//   _alku, hnon_, eeig,
  { {0x6b840264,0x2d830265,0x705401fb,0x00000000}},	//   feig, reje_, _انبا,
  { {0x628b0185,0x2ba4000a,0xe0fb0063,0x00000000}},	//   _ysgo, ојув, _שלהל,
  { {0x0a6b0062,0x29050266,0x8ed8007e,0x00000000}},	// [210] ърви_, _šla_, _پذير_,
  { {0x7bc6013d,0x780f0042,0x99d40044,0x00000000}},	//   _elku, िष्क_, يتلا,
  { {0x6b84003d,0x6d410014,0x63a20267,0x00000000}},	//   beig, ðlau, _onon,
  { {0x20140268,0x27e60269,0x7d08004b,0x00000000}},	//   _èxit_, gnon_, üdse,
  { {0x23da0053,0xdcfc0023,0x4b7a009d,0x00000000}},	//   _बग़द, merā, _גארו,
  { {0xce38014e,0x63a2026a,0xdcfe004c,0x00000000}},	//   סאות_, _anon, _napě,
  { {0xd795005a,0x97a7026b,0x0574007e,0x00000000}},	//   _ливъ, _крал, تاند,
  { {0xc2450086,0xdcfc008f,0x69c7007d,0x00000000}},	//   бник, nerā, _hlje,
  { {0x248c0150,0xdd2c0078,0x6587026c,0x00000000}},	//   _esdm_, vėži, _выез,
  { {0x6b840199,0xbec40078,0x63a2026d,0x00000000}},	//   zeig, šūki, _enon,
  { {0x7dc20024,0x69c7007d,0xeae40042,0x00000000}},	//   _dôsl, _mlje, _गश्त_,
  { {0x7dc20024,0x87790047,0x20020072,0x00000000}},	//   _pôso, נאָי, ulki_,
  { {0x69c7026e,0xdcfc008f,0x8287005d,0x00000000}},	//   _olje, derā, _خجال,
  { {0xb6da0047,0x6b84026f,0x8e070054,0x00000000}},	//   אַלט, weig, йняв_,
  { {0x7d090080,0xdb1d01a8,0x27e600f1,0x00000000}},	//   řesn, _alsà, ynon_,
  { {0x6fc60139,0xdcfe017c,0x69c70270,0x00000000}},	//   _fóca, _topľ, _alje,
  { {0x7f3b0047,0x6b840271,0x69c7007d,0x00000000}},	// [220] _געפו, reig, _blje,
  { {0x6b840272,0xbddb0003,0x5d860021,0x00000000}},	//   seig, ssèr, _الدل,
  { {0x6d4e00bb,0x3f92003e,0x291c0140,0x00000000}},	//   maba, _kayu_, äva_,
  { {0x6d4e0273,0x78a30137,0x3a2601a8,0x00000000}},	//   laba, ånva, íops_,
  { {0xef1f0058,0x27e60274,0xdd070075,0x00000000}},	//   ldür_, rnon_, _köşk,
  { {0x6d4e0275,0x3f920150,0x225f0276,0x00000000}},	//   naba, _layu_, druk_,
  { {0xef1f005b,0x225f0089,0x2bbf0053,0x00000000}},	//   ndür_, eruk_, _एकमा,
  { {0x6d4e0277,0xa3d20053,0x69de0278,0x00000000}},	//   haba, हों_, lipe,
  { {0xe6430079,0x6d4e0279,0x7dcb005b,0x00000000}},	//   _нетп, kaba, _hüse,
  { {0x018a015a,0x6d4e027a,0x9f420240,0x00000000}},	//   ущий_, jaba, roký_,
  { {0x6d4e027b,0x672d027c,0x9f42027d,0x00000000}},	//   daba, žaje, soký_,
  { {0x69de027e,0x225f027f,0x926a0002,0x00000000}},	//   hipe, bruk_, _брка_,
  { {0x69de0280,0x394a007d,0x2bbf0042,0x00000000}},	//   kipe, _oebs_, _एकबा,
  { {0x6d4e0281,0x3fc9007e,0xbd450021,0x00000000}},	//   gaba, ادگی_, تنسي,
  { {0x69de0282,0x2a600019,0xdcfc008f,0x00000000}},	//   dipe, erib_, terā,
  { {0x69c70117,0x69de006f,0x6e460014,0x00000000}},	//   _slje, eipe, ðubú,
  { {0x6d4e00bb,0x59d9000d,0xddeb007e,0x00000000}},	// [230] baba, адаў_, _مرده_,
  { {0x24890051,0x49bb007e,0x6d4e0283,0x00000000}},	//   łami_, دارد_, caba,
  { {0x20100051,0x6d410058,0xdcfc008f,0x00000000}},	//   łnił_, ılad, perā,
  { {0x61fa006f,0x645700f8,0x225f0058,0x00000000}},	//   hotl, áxim, yruk_,
  { {0x7bdf0284,0xe611005d,0x7bcd0285,0x00000000}},	//   miqu, وشت_, mhau,
  { {0x7bdf0286,0x69c7007d,0x69de0287,0x00000000}},	//   liqu, _ulje, cipe,
  { {0xddcc00eb,0x9965004c,0xf992009a,0x00000000}},	//   _žiūr, _kůži_, _קרל_,
  { {0x61e80288,0x7bdf0289,0x7bcd028a,0x00000000}},	//   endl, niqu, nhau,
  { {0x66030024,0x3f920089,0x6d4e028b,0x00000000}},	//   plnk, _rayu_, yaba,
  { {0x7bdf0164,0x225f00d1,0x3f920089,0x00000000}},	//   hiqu, rruk_, _sayu_,
  { {0xbddb0268,0x0fda0021,0x6d4e028c,0x00000000}},	//   ipèd, لبحث_, vaba,
  { {0x6d4e028d,0x61fa0019,0x69de0035,0x00000000}},	//   waba, aotl, zipe,
  { {0x7bdf028e,0x6d4e028f,0xbf9b017d,0x00000000}},	//   diqu, taba, plên,
  { {0x112b0086,0x7bcd004d,0xf1940121,0x00000000}},	//   _сюди_, ehau, _ничь,
  { {0x6d4e027b,0x7f4f0290,0xdcfc003b,0x00000000}},	//   raba, bacq, deră,
  { {0x7bdf0291,0x6d410026,0x27ed01b3,0x00000000}},	//   giqu, ðlar, _njen_,
  { {0x6d4e0292,0x2d9300b9,0x69de0293,0x00000000}},	// [240] paba, _faxe_, tipe,
  { {0xdcfc000c,0xdcf5005b,0x6f040058,0x00000000}},	//   geră, _çağr, _iyic,
  { {0x881a000d,0x32050294,0x7bdf01fa,0x00000000}},	//   аўду_, illy_, biqu,
  { {0x394a0295,0xfaa6000d,0x7bcd0296,0x00000000}},	//   _webs_, _дамо, chau,
  { {0xdcfc003b,0x7f8d0047,0x61e80046,0x00000000}},	//   beră, טנאַ, yndl,
  { {0x27ed00e3,0xfc4b0080,0xfe9b0041,0x00000000}},	//   _ejen_, říž_, יינמ,
  { {0x60280080,0x69dc0025,0xab5b004d,0x00000000}},	//   _těmi, _imre, _blüh,
  { {0x78a10297,0x442200c7,0xd3770076,0x00000000}},	//   _álva, ök_, очь_,
  { {0x61fa0298,0x7bc40078,0x41ea0299,0x00000000}},	//   totl, ikiu, ифом_,
  { {0x2fc9029a,0x443c01f4,0x61e8029b,0x00000000}},	//   _slag_, ppv_, undl,
  { {0x6f0d0051,0xdb0f029c,0x399b0047,0x00000000}},	//   _szac, _rocí, בייד,
  { {0x32050037,0x9325006a,0x7bdf0164,0x00000000}},	//   ally_, _فرهن, xiqu,
  { {0x2fc90179,0x69dc029d,0x6b96001f,0x00000000}},	//   _vlag_, _omre, ddyg,
  { {0x72e90047,0x6e3d029e,0x442c029f,0x00000000}},	//   _פֿײַ, rpsb, _kud_,
  { {0x7bdf02a0,0x3a23006f,0x4c9402a1,0x00000000}},	//   tiqu, _rijp_, мирс,
  { {0x5a3502a2,0x6e3d00df,0xbf9b00be,0x00000000}},	//   знат, ppsb, olêm,
  { {0x7bdf02a3,0x2d9302a4,0x6d41005b,0x00000000}},	// [250] riqu, _taxe_, ılab,
  { {0x442c0173,0x7bdf02a5,0x7bcd02a6,0x00000000}},	//   _oud_, siqu, shau,
  { {0x7bdf02a7,0x442c02a8,0x20ca0042,0x00000000}},	//   piqu, _nud_, ानिध,
  { {0xdcfc003b,0x69dc0058,0x5a470085,0x00000000}},	//   seră, _emre, _мэга,
  { {0xd6db02a9,0x6448002b,0xdcfc003b,0x00000000}},	//   јте_, _awdi, peră,
  { {0x442c02aa,0x3aba0063,0xdcf5008f,0x00000000}},	//   _bud_, _המשנ, jdzī,
  { {0x27ed02ab,0xdd7c0047,0x6d5a0139,0x00000000}},	//   _tjen_, יטגל, ótai,
  { {0xdcf5008f,0x398a0022,0xc24502ac,0x00000000}},	//   edzī, rósł_, пник,
  { {0x2362000f,0x69dc002b,0xe6880044,0x00000000}},	//   ókja_, _ymre, _ونفى_,
  { {0xdb060024,0x69c500bd,0x442c0025,0x00000000}},	//   _pokú, nkhe, _fud_,
  { {0x7bc40006,0x442c02ad,0xddc60078,0x00000000}},	//   ykiu, _gud_, sukū,
  { {0x27fd0034,0x764902ae,0x547a0063,0x00000000}},	//   nown_, _kwey, _לטעו,
  { {0xadf80053,0x69c502af,0xf2a501ce,0x00000000}},	//   ंकलन_, kkhe, _хилп,
  { {0x69c502b0,0x79950045,0x64600078,0x00000000}},	//   jkhe, _nazw, ūziš,
  { {0xdca302b1,0x61e102b2,0x1d0a02b3,0x00000000}},	//   нари, mill, севи_,
  { {0x61e102b4,0x67290150,0x60d60063,0x00000000}},	//   lill, _ngej, _מוצא_,
  { {0x3c190088,0x6b63000d,0x61e102b5,0x00000000}},	// [260] іўся_, экта, oill,
  { {0x6d41005b,0x3ea00150,0xa96a0021,0x00000000}},	//   ılac, _irit_, إمام_,
  { {0x7995004d,0x778602b6,0x61e10072,0x00000000}},	//   _dazw, злез, iill,
  { {0x442c0027,0x2d9802b7,0x2d8a02b8,0x00000000}},	//   _rud_, ldre_, lebe_,
  { {0x96b70001,0xd5ba026c,0x61e102b9,0x00000000}},	//   зују_, йск_, kill,
  { {0x2d9802ba,0x61e102bb,0x46390086,0x00000000}},	//   ndre_, jill, іччя_,
  { {0x7c260035,0x9553007e,0x628202bc,0x00000000}},	//   _kikr, رخوا, _spoo,
  { {0x9f590164,0x82380002,0x79950051,0x00000000}},	//   posé_, озис_, _zazw,
  { {0x6033000c,0x63b902bd,0xe3af0044,0x00000000}},	//   _răma, _down, ارى_,
  { {0xe1d80086,0xdcf5001c,0x61e102be,0x00000000}},	//   ідні_, udzī, gill,
  { {0x442c00f3,0xdcf5001c,0x61ef0003,0x00000000}},	//   _uud_, rdzī, écla,
  { {0x61e102bf,0x2d9802c0,0x3ea002c1,0x00000000}},	//   aill, edre_, _brit_,
  { {0x61e102c2,0x1ee7007e,0x3ea002c3,0x00000000}},	//   bill, سوسی_, _crit_,
  { {0x44260035,0x61e102c4,0x2d8a0244,0x00000000}},	//   _hio_, cill, gebe_,
  { {0x317b0063,0x717b0063,0x7c2602c5,0x00000000}},	//   _הרומ, _הנוס, _bikr,
  { {0x2d9802c6,0x3ea002c7,0xcf270021,0x00000000}},	//   adre_, _frit_, _عربي,
  { {0x61eb000f,0x442602c8,0x7c26017e,0x00000000}},	// [270] _állí, _mio_, _dikr,
  { {0x2d8a0016,0xeb9f01e1,0xdb0f01a8,0x00000000}},	//   cebe_, _skød_, _vocà,
  { {0x27fd02c9,0x9d190092,0x7c2602ca,0x00000000}},	//   town_, _фонт_, _fikr,
  { {0x629b0006,0xc794000d,0x442602cb,0x00000000}},	//   yvuo, ершы, _nio_,
  { {0x27fd0034,0x63b9001f,0x0f580063,0x00000000}},	//   rown_, _rown, ליאם_,
  { {0xd1260032,0x06f4007e,0x7c2602cc,0x00000000}},	//   _لم_, رسنج, _zikr,
  { {0x44260117,0x9475007e,0x61e102cd,0x00000000}},	//   _bio_, بگذا, vill,
  { {0x61e102ce,0x7c38006c,0x29110077,0x00000000}},	//   will, _évre, _izza_,
  { {0x61e102cf,0x442602d0,0x3f8b007d,0x00000000}},	//   till, _dio_, decu_,
  { {0x61e102d1,0x629b0078,0x7dd002d2,0x00000000}},	//   uill, rvuo, _käse,
  { {0x7dd0024a,0x63b90034,0x4426017d,0x00000000}},	//   _jäse, _town, _fio_,
  { {0x3ea00164,0x2d8a004d,0x442602d3,0x00000000}},	//   _prit_, webe_, _gio_,
  { {0x7dd000c7,0x61e102d4,0x2f55014b,0x00000000}},	//   _läse, pill, этэс,
  { {0x7c2602ab,0x44260290,0x3e7600b9,0x00000000}},	//   _sikr, _zio_, ræt_,
  { {0x3e760146,0x3b96000a,0x9fa000ac,0x00000000}},	//   sæt_, мјат, _léés_,
  { {0x6ff60021,0xea010013,0x2d8a02d5,0x00000000}},	//   _تستط, _đạp_, sebe_,
  { {0x3b07011c,0x7c2602d6,0x3a2602d7,0x00000000}},	// [280] дето_, _vikr, дмаг,
  { {0x60280080,0xc9860021,0x7dcb0058,0x00000000}},	//   _těmt, بشري, _hüsn,
  { {0x8cb50161,0x7c2600eb,0xbddb0110,0x00000000}},	//   _उपयो, _tikr, spèc,
  { {0x672d017f,0xb0b60047,0xebe602d8,0x00000000}},	//   žajn, ופעס_, _цомп,
  { {0x442602d9,0x667302da,0x501b009a,0x00000000}},	//   _rio_, ندور, קונו,
  { {0x44260035,0x15140085,0x00000000,0x00000000}},	//   _sio_, ндля,   ,
  { {0x442602db,0xe5a3005e,0xd49702dc,0x00000000}},	//   _pio_, тији, дры_,
  { {0xc1780078,0x29180022,0xdb0d0014,0x00000000}},	//   ynės_, ągać_, okað,
  { {0x442602dd,0xd166005a,0x8cb50053,0x00000000}},	//   _vio_, мъни, _उपभो,
  { {0xe29f007a,0x7c3e017f,0x7dd00137,0x00000000}},	//   æða_, _otpr, _läsb,
  { {0x442602de,0xf9930063,0xf946000d,0x00000000}},	//   _tio_, דרת_, чнiк_,
  { {0xdb0d0026,0x443e02df,0x442600d1,0x00000000}},	//   kkað, _itt_, _uio_,
  { {0x441b0047,0x645802e0,0xff0402e1,0x00000000}},	//   _וואס, lsvi, вярн,
  { {0x7ae900c3,0x443e0150,0x3f8b02e2,0x00000000}},	//   _žeto, _ktt_, secu_,
  { {0xc1780006,0x7e6600d1,0x645802ad,0x00000000}},	//   snės_, arkp, nsvi,
  { {0x5f95005a,0x69ce02e3,0x6fc60139,0x00000000}},	//   _чиит, _albe, _nóch,
  { {0x6feb0045,0xda150095,0xda7802e4,0x00000000}},	// [290] jęci, едањ, дях_,
  { {0x62770063,0x645802e5,0x443e02e6,0x00000000}},	//   וגמא_, ksvi, _ott_,
  { {0xab5b00bd,0x6d5502e7,0x443e02e8,0x00000000}},	//   _blüt, maza, _ntt_,
  { {0x6d5502e9,0x645802ea,0x7dd00137,0x00000000}},	//   laza, dsvi, _väse,
  { {0x443e02eb,0x6fc60025,0x4648000d,0x00000000}},	//   _att_, _dóch, дзін_,
  { {0x6d5502ec,0xdcee0006,0x6b8d02ed,0x00000000}},	//   naza, gebė, leag,
  { {0x26c9017f,0xd1380051,0x67d50121,0x00000000}},	//   šao_, dcą_, _зову,
  { {0x6d5502ee,0xa3d90053,0x6b8d02ef,0x00000000}},	//   haza, डों_, neag,
  { {0x443e02f0,0x645802f1,0x6d5502f2,0x00000000}},	//   _ett_, asvi, kaza,
  { {0xf1b10021,0x6d5502f3,0x66e4005e,0x00000000}},	//   اءة_, jaza, _рођа,
  { {0x672402f4,0x657c0137,0x6d5502f5,0x00000000}},	//   žijt, _örha, daza,
  { {0x72d50002,0xd4360047,0x649a0063,0x00000000}},	//   _поеф, _טרעק_, _מסעד,
  { {0xe1ee005a,0x63ab002c,0x3f9e0080,0x00000000}},	//   _бг_, _ingn, ětu_,
  { {0x7bcf02f6,0x443e00df,0x200b02f7,0x00000000}},	//   _alcu, _ytt_, alci_,
  { {0xb042001b,0xc5f20063,0x6feb0022,0x00000000}},	//   _trưở, אדם_, zęci,
  { {0x212b004c,0x8b2602f8,0x9f99013d,0x00000000}},	//   ěchu_, едбе, _táás_,
  { {0xada602f9,0x7dd000a5,0x4d3a02fa,0x00000000}},	// [2a0] _запл, _väsb, _няня_,
  { {0xdb0d007a,0x6d5e00b9,0x200200fe,0x00000000}},	//   rkað, _udpa, loki_,
  { {0x7c3e02fb,0x7dcb005b,0x7dc20066,0x00000000}},	//   _utpr, _müsl, _dôst,
  { {0x2ca50146,0x601602fc,0x645802fd,0x00000000}},	//   ælde_, lámb, vsvi,
  { {0xdcee0006,0x569402fe,0x69d1008f,0x00000000}},	//   tebė, талт, _ūdeņ,
  { {0xab5b00bd,0x245a001c,0x443e02ff,0x00000000}},	//   _flüs, tīm_, _ptt_,
  { {0x64580072,0x7d09004c,0x2d9a0300,0x00000000}},	//   usvi, řesv, _mape_,
  { {0xf753007e,0x987b0047,0xd1380051,0x00000000}},	//   _منفج, _מאלט, wcą_,
  { {0x20020301,0x249c0078,0x9f420072,0x00000000}},	//   doki_, _žymė_, inkä_,
  { {0x27e60302,0x91e30001,0x64580303,0x00000000}},	//   lion_, лоње, psvi,
  { {0x443e001c,0xc0570304,0xc32a0021,0x00000000}},	//   _utt_, нія_, _فكان_,
  { {0x27e60305,0xde59000d,0xd65e0054,0x00000000}},	//   nion_, мамі_, _вiдд,
  { {0x0e340076,0x6d550306,0xdb060066,0x00000000}},	//   лняю, taza, _poký,
  { {0x7d030307,0x27e6001f,0xbbc90053,0x00000000}},	//   _ønsk, hion_, रस्क,
  { {0x5ff5005a,0xfc640062,0x6d550308,0x00000000}},	//   _изку, лътн, raza,
  { {0xfc300032,0x6d5a0026,0x2cac0137,0x00000000}},	//   صحف_, ótar, ådda_,
  { {0x27e60309,0x6b8d030a,0x7dc200be,0x00000000}},	// [2b0] dion_, reag, _pôst,
  { {0x601602dd,0xd91b030b,0x22f7009d,0x00000000}},	//   ráme, пье_, תזמן_,
  { {0x27e6001f,0x6fc6017d,0x4ddc0063,0x00000000}},	//   fion_, _sóci, _מחזו,
  { {0x7659001f,0x27e60287,0xbcb60063,0x00000000}},	//   tswy, gion_, _ספרו_,
  { {0xa3b40161,0x601600ea,0x9f4b006d,0x00000000}},	//   ञान_, lámc, locó_,
  { {0x8578005a,0x7e7d030c,0x7d09004c,0x00000000}},	//   есът_, itsp, řesu,
  { {0x27e60185,0xcd980063,0xa8020058,0x00000000}},	//   bion_, גדות_, ğıra,
  { {0x27e6030d,0x7e7d030e,0x6443030f,0x00000000}},	//   cion_, ktsp, rpni,
  { {0x7dd000c7,0xdb160072,0xe7840094,0x00000000}},	//   _läsa, shyö, _щуро,
  { {0x7e7d01e1,0x64430310,0x10a502f8,0x00000000}},	//   dtsp, ppni, вион,
  { {0x63ab00a4,0x2d9a00e5,0x20020311,0x00000000}},	//   _tngn, _rape_, toki_,
  { {0x34b60063,0x7e7d0312,0xe4580054,0x00000000}},	//   _בפעם_, ftsp, _їжі_,
  { {0x2d9a0313,0x66030019,0x7e7d01e1,0x00000000}},	//   _pape_, oonk, gtsp,
  { {0x27e60314,0x66030315,0x2259004c,0x00000000}},	//   zion_, nonk, ásku_,
  { {0x7e7d030c,0x7dd0004d,0x40320131,0x00000000}},	//   atsp, _cäsa, _кејс,
  { {0x27e60316,0x66030317,0x290a0318,0x00000000}},	//   xion_, honk, _ryba_,
  { {0x3ae8006a,0x2d9a0319,0x27e6031a,0x00000000}},	// [2c0] ربری_, _tape_, vion_,
  { {0xdcfc001c,0x24920051,0x2b4900c6,0x00000000}},	//   ndrī, łymi_, abac_,
  { {0xdcfc001c,0x27e6031b,0xdb060051,0x00000000}},	//   idrī, tion_, _pokó,
  { {0x6c57009a,0x4c79009a,0x00000000,0x00000000}},	//   _ביטא_, _אָשׁ,   ,
  { {0x6441031c,0xa3ab0161,0x7d090080,0x00000000}},	//   _atli, खाई_, řest,
  { {0x27e6031d,0xdb060051,0xd943031e,0x00000000}},	//   sion_, _wokó, _вери,
  { {0x27e6031f,0x9f59013d,0x09e30320,0x00000000}},	//   pion_, őzés_, _торн,
  { {0xc274000a,0x32980002,0xdcfc001c,0x00000000}},	//   глиј, евиќ_, edrī,
  { {0x877b0047,0x64410321,0xdb0d0014,0x00000000}},	//   _קאמי, _etli, skaö,
  { {0x75d3007e,0xc05a0085,0x6453013d,0x00000000}},	//   _پيما, мім_, údió,
  { {0x799c0322,0xc60e0053,0x43860044,0x00000000}},	//   _marw, ितीय_, _للاق,
  { {0x9f4b006d,0x6d41005b,0x7e7d0323,0x00000000}},	//   vocó_, ılam, ttsp,
  { {0x7ee40054,0xdbdc0046,0x2e4b030b,0x00000000}},	//   ацре, _ráðn, ьяно_,
  { {0x2d850195,0x3d950121,0x644100a5,0x00000000}},	//   ýle_, ыигр, _ytli,
  { {0x61e802ab,0x2ca50026,0x9f5900cd,0x00000000}},	//   midl, íld_, posà_,
  { {0xef67011c,0x3ec70088,0xa3ab0053,0x00000000}},	//   _ръко, _асоб, खाए_,
  { {0x799c0324,0x5b1502e4,0x2009008f,0x00000000}},	// [2d0] _barw, умат, _ikai_,
  { {0xc27b0063,0x799c002b,0xdb1d0325,0x00000000}},	//   ורמי, _carw, _josé,
  { {0x2d910326,0x6f0d0327,0xa9280085,0x00000000}},	//   meze_, _hyac, віце_,
  { {0x2d91000c,0x1b4b0021,0x7bd601a8,0x00000000}},	//   leze_, _تؤدي_, chyu,
  { {0x799c001f,0x7bcd0328,0xd24601f3,0x00000000}},	//   _farw, mkau, _دن_,
  { {0x2d91000c,0xca7a0047,0x7bcb0014,0x00000000}},	//   neze_, _אנשט, öguf,
  { {0x60160026,0x66030329,0x2009013d,0x00000000}},	//   háma, ronk, _okai_,
  { {0xe2b90001,0xddc60078,0x61e8008f,0x00000000}},	//   ећој_, iukš, eidl,
  { {0x2fc0032a,0x56f50002,0x6603032b,0x00000000}},	//   _roig_, _спаѓ, ponk,
  { {0x2d83006f,0x2d91001a,0xe573002a,0x00000000}},	//   jfje_, jeze_, _خطر_,
  { {0x7bcd00fe,0x9f4b0290,0x2d91032c,0x00000000}},	//   kkau, vocò_, deze_,
  { {0xeb9f00b9,0xbb1b0003,0x5275032d,0x00000000}},	//   _skøn_, _abîm, _буку,
  { {0xee370062,0x61e80139,0xd5a70054,0x00000000}},	//   лня_, bidl, _пiдп,
  { {0x63bb032e,0x6da6005e,0x61e8032f,0x00000000}},	//   ljun, ћива, cidl,
  { {0xdca10086,0x8fa60330,0x6f0d0331,0x00000000}},	//   остi_, _байе, _eyac,
  { {0x6b9d0185,0x7bcd002c,0xdb0f017d,0x00000000}},	//   _casg, gkau, _incê,
  { {0xc3320132,0x4b550062,0xa3b40053,0x00000000}},	// [2e0] מון_, ръст, ञात_,
  { {0xfd4a0086,0x7bcd0332,0x63bb004b,0x00000000}},	//   _язок_, akau, hjun,
  { {0x63bb0026,0xe4e30053,0x6b9d002b,0x00000000}},	//   kjun, _केलि_, _fasg,
  { {0x6b9d0333,0x6033003b,0x18670002,0x00000000}},	//   _gasg, _cămi, ѓачи_,
  { {0x63bb0334,0x799c0335,0xdcfe0078,0x00000000}},	//   djun, _tarw, _papė,
  { {0xd49a0336,0x6b840337,0x09e6030b,0x00000000}},	//   ери_, lfig, _согн,
  { {0x61e80114,0x395a0338,0xdb1d00f4,0x00000000}},	//   vidl, maps_, _rosé,
  { {0x2d910339,0x7dcb0058,0x6f090022,0x00000000}},	//   zeze_, _püsk, żeci,
  { {0xd1300032,0xdb0f0003,0xdb1d00f4,0x00000000}},	//   يمة_, _ancê, _posé,
  { {0xfa970047,0x2d91000c,0xda7b0047,0x00000000}},	//   נדיש_, xeze_, עניר,
  { {0xe475000d,0x33860062,0x2d91033a,0x00000000}},	//   _вучэ, _булв, veze_,
  { {0x2d910035,0x61e8033b,0x8f4702dc,0x00000000}},	//   weze_, sidl, ыход,
  { {0x61e8033c,0x2d91033d,0x6b9d033e,0x00000000}},	//   pidl, teze_, _rasg,
  { {0x7dcb0004,0x60160025,0x6aa9007d,0x00000000}},	//   _küsi, ráma, _šefo,
  { {0x6b9d0186,0x6b84033f,0xa1570063,0x00000000}},	//   _pasg, ffig, _גבוה_,
  { {0x2d910340,0x7bcd0341,0x62800229,0x00000000}},	//   seze_, ukau, otmo,
  { {0x6b9d00e8,0x63bd0137,0xb9550062,0x00000000}},	// [2f0] _vasg, ösni, иващ,
  { {0x7bcd0342,0x6b9d002b,0x00000000,0x00000000}},	//   skau, _wasg,   ,
  { {0x6b9d002b,0x61ef0343,0xdbdc013d,0x00000000}},	//   _tasg, écli, _ráön,
  { {0x3ea90344,0x6b9d0139,0xf77300f2,0x00000000}},	//   _krat_, _uasg, صاص_,
  { {0x9f82006f,0x29180345,0x9f4c013d,0x00000000}},	//   _zóó_, _ezra_, élék_,
  { {0xb5fd0080,0x4ade0161,0x628000d1,0x00000000}},	//   _ovše, _नेटव, dtmo,
  { {0xdb0600ea,0xb465007e,0x628000ca,0x00000000}},	//   _inká, شگاه, etmo,
  { {0xea01008b,0xd2650330,0x63bb0346,0x00000000}},	//   _đẹp_, акий, ujun,
  { {0x7c2f0347,0x63bb0348,0xd7f80349,0x00000000}},	//   _micr, rjun, _сур_,
  { {0x6ff2008f,0x7dcb004b,0x98a10058,0x00000000}},	//   māci, _füsi, lahı_,
  { {0x7dd000c7,0x6ff2001c,0xf9920063,0x00000000}},	//   _säso, lāci, חרי_,
  { {0x3ea9034a,0x08760041,0xff26034b,0x00000000}},	//   _brat_, סערט_, имно,
  { {0x6ff2001c,0x9404007e,0x3205034c,0x00000000}},	//   nāci, _اونه, poly_,
  { {0xc5f20047,0x69c30058,0x8e0701d5,0x00000000}},	//   ַדן_, önel, иняв_,
  { {0x2d9e034d,0x442f0146,0xa3cc0053,0x00000000}},	//   ľte_, _kig_, _रकम_,
  { {0x6ff2003d,0x2d9e0114,0xaec60054,0x00000000}},	//   kāci, žte_, _вбил,
  { {0x3ea9034e,0x3e7f003b,0x601600ea,0x00000000}},	// [300] _grat_, cît_, lámo,
  { {0x442f034f,0x6ff2008f,0xdb1d013d,0x00000000}},	//   _lig_, dāci, _alsó,
  { {0x6d4e00ea,0x6fcd0003,0xd910007e,0x00000000}},	//   mbba, _bûch, سیر_,
  { {0x6d5c0350,0xc60e0042,0x6016013d,0x00000000}},	//   lara, ित्य_, zámn,
  { {0xeb97005a,0x6ff2001c,0x2d8500cd,0x00000000}},	//   _тия_, gāci, òleg_,
  { {0x7dcb0019,0x6594000a,0x6d5c0351,0x00000000}},	//   _püsi, саку, nara,
  { {0x601d0164,0x442f0352,0x39580353,0x00000000}},	//   léme, _big_, _iers_,
  { {0x395800f6,0x442f001f,0x62800354,0x00000000}},	//   _hers_, _cig_, ttmo,
  { {0x442f0355,0x6d5c0356,0x601d0164,0x00000000}},	//   _dig_, kara, néme,
  { {0x6d5c0357,0x91b80002,0x6033003b,0x00000000}},	//   jara, угот_, _lămu,
  { {0xdfd10021,0x225f014f,0x54730021,0x00000000}},	//   كيد_, asuk_, _وهكذ,
  { {0x3ea90358,0x644a0359,0x442f035a,0x00000000}},	//   _prat_, mpfi, _gig_,
  { {0x6d5c035b,0x7c2f0290,0x7c24035c,0x00000000}},	//   fara, _ricr, dmir,
  { {0x7c2f0185,0x6d5c035d,0x3f55008b,0x00000000}},	//   _sicr, gara, ấu_,
  { {0x6ff2003d,0x61ef0164,0x69c30058,0x00000000}},	//   zāci, ècle, önem,
  { {0x3ea900bd,0x60290051,0xc1780078,0x00000000}},	//   _trat_, _ośmi, lgė_,
  { {0x6d5c035e,0xba550021,0x6d57035f,0x00000000}},	// [310] bara, صناع, _texa,
  { {0xe29f007a,0xc1780006,0x6d990076,0x00000000}},	//   æði_, ngė_, _своё_,
  { {0x2a600360,0x39580361,0x9f42004c,0x00000000}},	//   asib_, _ders_, liká_,
  { {0x395800e8,0x6ff2001c,0x7c24003b,0x00000000}},	//   _eers_, tāci, cmir,
  { {0x601600ea,0x442f015e,0xb6a50086,0x00000000}},	//   zámo, _rig_, силл,
  { {0x6ff2003d,0x442f0362,0xe5780054,0x00000000}},	//   rāci, _sig_, изі_,
  { {0xe3b10021,0x6ff2008f,0xd4660363,0x00000000}},	//   كرة_, sāci, бище_,
  { {0x1bf90053,0x3941004d,0x6d5c0364,0x00000000}},	//   ्किल_, lchs_, zara,
  { {0x6d5c0365,0x36d40366,0xa567007e,0x00000000}},	//   yara, _дотр, _ندان,
  { {0x6d5c0367,0x7c240368,0xd628005e,0x00000000}},	//   xara, zmir, _вође_,
  { {0x442f0025,0x3941004d,0x225f00ea,0x00000000}},	//   _tig_, ichs_, ssuk_,
  { {0xcdc9014e,0x6d5c0369,0x672d007d,0x00000000}},	//   _אך_, wara, žaju,
  { {0x6d5c0357,0xdb24005b,0x1e83000d,0x00000000}},	//   tara, üsün, плям,
  { {0x32b80032,0x7dd000fe,0xddd40066,0x00000000}},	//   _خدمة_, _täsm, ťažo,
  { {0x2fd7006a,0x8c46036a,0x6d5c036b,0x00000000}},	//   _گويد_, себе, rara,
  { {0x6d5c036c,0x9f820026,0x6bb50086,0x00000000}},	//   sara, _góð_, осує,
  { {0x3958036d,0x7c24036e,0x09360021,0x00000000}},	// [320] _pers_, rmir, مراج,
  { {0x6016000f,0x601d0164,0x8d560001,0x00000000}},	//   záml, réme, _утич,
  { {0x88860076,0x601d0164,0x3958036f,0x00000000}},	//   слеж, séme, _vers_,
  { {0x39410370,0x3958002b,0xc8850058,0x00000000}},	//   achs_, _wers_, daşı_,
  { {0xe5c60371,0x39580058,0x6d410058,0x00000000}},	//   йско, _ters_, ılav,
  { {0xa5f8005e,0xa3ca0053,0x7bc60372,0x00000000}},	//   јеку_, रॉन_, _hoku,
  { {0xe9d702a1,0x22460373,0x7bc60374,0x00000000}},	//   _укр_, _stok_, _koku,
  { {0x7dcb004e,0xebd6009a,0x00000000,0x00000000}},	//   _hüst, מֵ֥י_,   ,
  { {0x7ae9007a,0x7dcb0375,0x60290051,0x00000000}},	//   _þett, _küst, _uśmi,
  { {0xdcfc001c,0x104a0376,0xba9b0063,0x00000000}},	//   nerē, лями_, נסיי,
  { {0x672d00c2,0xe4520049,0xdb1d0061,0x00000000}},	//   žajt, _رضا_, _rosí,
  { {0x7bc600e8,0x601600ea,0x9f420066,0x00000000}},	//   _noku, lámj, tiká_,
  { {0xdb1d02f4,0x7f5d006c,0x5f940062,0x00000000}},	//   _posí, rasq, чият,
  { {0x270700aa,0x63a20139,0xdb110003,0x00000000}},	//   ống_, _haon, _âgée,
  { {0x7a290006,0xb1e50021,0xdcfc001c,0x00000000}},	//   _užti, _بأنه, derē,
  { {0x4a55000d,0x7c150054,0x2737004c,0x00000000}},	//   жкас, ідає, ižní_,
  { {0x63a20009,0x39410164,0x200b01f5,0x00000000}},	// [330] _maon, tchs_, moci_,
  { {0x200b0377,0x39a7005e,0x3941004d,0x00000000}},	//   loci_, љшав, uchs_,
  { {0xdcf5008f,0x7dcb0378,0x6016013d,0x00000000}},	//   iezī, _düst, zámm,
  { {0x61c50161,0xc885005b,0x63a20139,0x00000000}},	//   _लक्ष, vaşı_, _naon,
  { {0x4ae4000d,0xb5fd0240,0x7dcb013d,0x00000000}},	//   _еўра, _avša, _füst,
  { {0x96280021,0x7bc600ac,0xdcfc001c,0x00000000}},	//   مكنك_, _zoku, cerē,
  { {0xdb060137,0x7bc60379,0x200b037a,0x00000000}},	//   _enkä, _yoku, koci_,
  { {0xc245032d,0x7dcb02d2,0x04560044,0x00000000}},	//   оник, _küss, آلية_,
  { {0x69c70117,0x63a20025,0x85b9037b,0x00000000}},	//   _koje, _daon, _клас_,
  { {0x7dcb0199,0x91e50086,0x8065037c,0x00000000}},	//   _müss, іоне, овож,
  { {0x7e640026,0x8c43005b,0x76490072,0x00000000}},	//   _svip, üşle, _htey,
  { {0x200b0268,0x6d45037d,0x2465001c,0x00000000}},	//   goci_, _afha, mēm_,
  { {0xa2940097,0x2465001c,0x68e1004b,0x00000000}},	//   _наці, lēm_, _üldf,
  { {0x7dd0037e,0xe29f0026,0x63a20035,0x00000000}},	//   _käsi, æðu_, _zaon,
  { {0x7bc6037f,0x63a20380,0x7dcb0378,0x00000000}},	//   _poku, _yaon, _rüst,
  { {0x7dcb0004,0x1b4a000a,0xb06801fb,0x00000000}},	//   _süst, рзаи_, _اصول_,
  { {0x7e640035,0x7dcb0019,0x39ea0001,0x00000000}},	// [340] _uvip, _püst, адао_,
  { {0xfd120021,0x7dcb0381,0x27ef0046,0x00000000}},	//   _يجد_, _düss, eign_,
  { {0x764900a4,0x291c0137,0x2d980382,0x00000000}},	//   _atey, åva_, mere_,
  { {0x510c00b7,0x2465001c,0x7dcb004d,0x00000000}},	//   נהאַ, dēm_, _wüst,
  { {0xd5ba0055,0x63a20268,0x601d0003,0x00000000}},	//   иск_, _raon, néma,
  { {0xe4520032,0x2d980383,0x69c70384,0x00000000}},	//   وضع_, nere_, _goje,
  { {0x26090053,0xf7460002,0x291c004b,0x00000000}},	//   ाक़ी_, _мево, üvad_,
  { {0x2d980385,0x98ba00eb,0x9faf0080,0x00000000}},	//   here_, lapį_, tří_,
  { {0x2d980386,0x200b0387,0xa294000d,0x00000000}},	//   kere_, voci_, чапі,
  { {0x2d980388,0x601d0164,0x27330013,0x00000000}},	//   jere_, déma, _ảng_,
  { {0x63a20389,0x2d98038a,0x200b038b,0x00000000}},	//   _taon, dere_, toci_,
  { {0x8c430058,0x7a290078,0x683a005f,0x00000000}},	//   üşme, _užtv, _cįdi,
  { {0x2d98038c,0x200b038d,0x57fb009a,0x00000000}},	//   fere_, roci_, שלכו,
  { {0x2d98038e,0xddcf000c,0x68e1004b,0x00000000}},	//   gere_, ducţ, _üldg,
  { {0xa1770063,0x69c7038f,0xa802005b,0x00000000}},	//   _ועוד_, _roje, şıya,
  { {0x69c700b2,0x320c0390,0x7dcb004b,0x00000000}},	//   _soje, lody_, _püss,
  { {0x2465001c,0x539b0063,0x61fa00ac,0x00000000}},	// [350] zēm_, סימו, ontl,
  { {0x2d980391,0x61fa004d,0x3f990392,0x00000000}},	//   cere_, nntl, lesu_,
  { {0xdb1d0080,0x69c7004a,0x61fa0206,0x00000000}},	//   _dosá, _voje, intl,
  { {0x69c70045,0x3f990393,0x4c9a0063,0x00000000}},	//   _woje, nesu_, _פברו,
  { {0x9bba0063,0x320c0022,0x501c009a,0x00000000}},	//   _הצרפ, kody_, בואו,
  { {0x53a30394,0x85e80086,0x2465001c,0x00000000}},	//   _खोजश, одів_, tēm_,
  { {0x6aa30023,0xf77301f3,0x94790085,0x00000000}},	//   ānfu, _يار_, ёску_,
  { {0x3f99007d,0x7dd0004b,0x2d980395,0x00000000}},	//   jesu_, _väsi, zere_,
  { {0x2d980031,0x27ed00c3,0x2465001c,0x00000000}},	//   yere_, _imen_, sēm_,
  { {0x320c0051,0x2d980396,0x2465008f,0x00000000}},	//   gody_, xere_, pēm_,
  { {0x224d0397,0x601602dd,0x2d980398,0x00000000}},	//   spek_, lámi, vere_,
  { {0x25a50399,0x224d00ea,0xd8d60063,0x00000000}},	//   _hall_, ppek_, פורט_,
  { {0x25a5039a,0x320c039b,0x6016039c,0x00000000}},	//   _kall_, body_, námi,
  { {0x7bcb0026,0x44d70013,0x2d98039d,0x00000000}},	//   ögun, õ_, uere_,
  { {0x2d98039e,0x81bc001c,0xdb1d039f,0x00000000}},	//   rere_, kmēj, _rosá,
  { {0x2d9803a0,0x9e6600e1,0x6376005b,0x00000000}},	//   sere_, _евид, münü,
  { {0x6d4101f7,0x6376005b,0xdb1d027d,0x00000000}},	// [360] ılar, lünü, _posá,
  { {0xddcf000c,0xdb0403a1,0x8d560121,0x00000000}},	//   rucţ, ndié, _этич,
  { {0x6d5e003d,0x6376005b,0x9c830066,0x00000000}},	//   _iepa, nünü, éčti,
  { {0xf1ba0013,0x6d5e03a2,0x7bdf0206,0x00000000}},	//   _nhơn_, _hepa, chqu,
  { {0x6d5e0397,0x44d7008b,0xbddb0003,0x00000000}},	//   _kepa, ẽ_, mpèr,
  { {0x6d5e00f3,0xdb1d00b9,0x25a503a3,0x00000000}},	//   _jepa, _bosæ, _call_,
  { {0x25a502f6,0x320c0114,0x39130085,0x00000000}},	//   _dall_, vody_, _змёр,
  { {0x6d5e0397,0x320c0051,0x53340121,0x00000000}},	//   _lepa, wody_, мейт,
  { {0x44d7008b,0x320c03a4,0xdb040003,0x00000000}},	//   ã_, tody_, udiè,
  { {0x67200117,0x20030117,0x6d5e03a5,0x00000000}},	//   _izmj, čkim_, _nepa,
  { {0x6376005b,0x3f99007d,0x9f9903a6,0x00000000}},	//   günü, tesu_, овну_,
  { {0x68e1004b,0x2d8103a7,0x67200053,0x00000000}},	//   _ülde, _sche_, _बराक_,
  { {0x6d5e03a8,0xb80d0161,0x7c3e0164,0x00000000}},	//   _bepa, िकतम_, _aupr,
  { {0x6d5e003e,0x224b0024,0x7ae40024,0x00000000}},	//   _cepa, ícke_, dzit,
  { {0x7c3e000c,0x3f990019,0x6d5e03a9,0x00000000}},	//   _cupr, pesu_, _depa,
  { {0xec340086,0x69dc03aa,0x601d0003,0x00000000}},	//   енсь, _alre, mémo,
  { {0x5a35010d,0x25ed0053,0x9f4b004c,0x00000000}},	// [370] днат, _अगली_, nicí_,
  { {0x443e03ab,0x11590047,0x6d5e03ac,0x00000000}},	//   _out_, ַדױע, _gepa,
  { {0xdb0d004b,0xdcfc005f,0x99d40044,0x00000000}},	//   ljaü, derė, رتكا,
  { {0x69dc00ea,0x81bc0023,0x37890054,0x00000000}},	//   _elre, umēj, ібло_,
  { {0x81bc001c,0x999f00ea,0x63760058,0x00000000}},	//   rmēj, őről_, zünü,
  { {0x443e0034,0xf6500032,0x601603ad,0x00000000}},	//   _but_, ائن_, rámi,
  { {0x64a2005a,0x443e03ae,0x25a503af,0x00000000}},	//   ваща, _cut_, _vall_,
  { {0x7dd003b0,0x25a50127,0x443e0005,0x00000000}},	//   _häst, _wall_, _dut_,
  { {0x443e0164,0x25a503b1,0x6d470051,0x00000000}},	//   _eut_, _tall_, kcja,
  { {0x443e03b2,0x6376005b,0xdb04004d,0x00000000}},	//   _fut_, tünü, heiß,
  { {0x656303b3,0x443e0359,0x7dd00137,0x00000000}},	//   manh, _gut_, _mäst,
  { {0x7bcb007a,0x637601f7,0x6d5e03a2,0x00000000}},	//   ögul, rünü, _sepa,
  { {0x2e2400bd,0x6d5e0360,0x7dcb00ea,0x00000000}},	//   höfe_, _pepa, _püsp,
  { {0x7dd001e3,0x63a903b4,0x3f5c0013,0x00000000}},	//   _näst, lden, ậu_,
  { {0x628903b5,0x31780022,0x63a903b6,0x00000000}},	//   lteo, órze_, oden,
  { {0x7bc40035,0x63a903b7,0x62890072,0x00000000}},	//   ujiu, nden, oteo,
  { {0x7dd000c7,0x6d5e014f,0x628903b8,0x00000000}},	// [380] _bäst, _tepa, nteo,
  { {0x673b03b9,0x63a900fe,0xbddb00f4,0x00000000}},	//   _aguj, hden, spèr,
  { {0xdb0f00cd,0xd7ef03ba,0xbddb0003,0x00000000}},	//   _encà, ву_, ppèr,
  { {0xf98900b5,0x63a903bb,0xdb1d0137,0x00000000}},	//   יר_, jden, _bosä,
  { {0x443e0185,0x7dd000c7,0x96b7005e,0x00000000}},	//   _sut_, _fäst, дују_,
  { {0x63a903bc,0x443e03bd,0x7dd003be,0x00000000}},	//   eden, _put_, _gäst,
  { {0xa4d80086,0x78450006,0x6feb0051,0x00000000}},	//   ядку_, _tėva, ręcz,
  { {0x7a290006,0x63a903bf,0x60080058,0x00000000}},	//   _užtr, gden, nımd,
  { {0xa80201f7,0x6563017d,0x443e004d,0x00000000}},	//   ğıda, banh, _wut_,
  { {0x63a903c0,0x9f4b0139,0x7abb0063,0x00000000}},	//   aden, ricí_, קציו,
  { {0x7dd000bd,0x443e03c1,0x60080058,0x00000000}},	//   _läss, _uut_, kımd,
  { {0x601d0164,0x291803c2,0xd25a0094,0x00000000}},	//   rémo, _myra_, _дцк_,
  { {0x62890331,0x03d703c3,0x7dd003c4,0x00000000}},	//   cteo, _קודם_, _näss,
  { {0xdb04004d,0x76400075,0x9999011b,0x00000000}},	//   weiß, _mumy, _rusů_,
  { {0x2ba7000a,0xab950001,0x2bbb0021,0x00000000}},	//   мјав, нављ, يارة_,
  { {0x6e2001a8,0x8b5b0044,0xe451009a,0x00000000}},	//   ïmbr, تجسس_, רֶם_,
  { {0x160e0053,0x6b8d03c5,0xdb04004d,0x00000000}},	// [390] ाकार_, rfag, reiß,
  { {0x442603c6,0x6aad004b,0x63a903c7,0x00000000}},	//   _lho_, rvaf, zden,
  { {0x7dd003c8,0x60080058,0x63a903c9,0x00000000}},	//   _väst, bımd, yden,
  { {0x291803ca,0x4426008b,0xb794005e,0x00000000}},	//   _dyra_, _nho_, вршћ,
  { {0xda67006a,0x20030117,0x7dd0024a,0x00000000}},	//   _تاجي, čkih_, _täst,
  { {0x291800c7,0x7c2d03cb,0x7e60003b,0x00000000}},	//   _fyra_, lmar, âmpi,
  { {0xfc460024,0x683a0080,0x656303cc,0x00000000}},	//   žíva_, _vůdc, ranh,
  { {0x442600aa,0x628903cd,0x7c2d03ce,0x00000000}},	//   _cho_, tteo, nmar,
  { {0x66f30235,0x65630016,0x9f4b00cd,0x00000000}},	//   _अधिक_, panh, dicà_,
  { {0x7e7d0019,0x63a903cf,0x628903d0,0x00000000}},	//   dusp, sden, rteo,
  { {0x94a803d1,0x9f4b00cd,0x628903d2,0x00000000}},	//   _отца_, ficà_, steo,
  { {0x2a690019,0x644103d3,0x656103d4,0x00000000}},	//   ksab_, _iuli, _helh,
  { {0x644103d5,0x201e001c,0x81d503d6,0x00000000}},	//   _huli, ēti_, _подх,
  { {0x270e001b,0x644103d7,0x442d03d8,0x00000000}},	//   ộng_, _kuli, lme_,
  { {0x656103d9,0x442d03da,0x644103db,0x00000000}},	//   _melh, ome_, _juli,
  { {0xf062005a,0x644103dc,0x442d005b,0x00000000}},	//   _скъп, _muli, nme_,
  { {0x291e0117,0x160f0161,0x442d03dd,0x00000000}},	// [3a0] _šta_, िवार_, ime_,
  { {0xdb0602f4,0x442d03de,0x7c2d03df,0x00000000}},	//   _jaké, hme_, amar,
  { {0x644103e0,0x7c2d03e1,0x442d03e2,0x00000000}},	//   _nuli, bmar, kme_,
  { {0x7dd0024a,0x3f820397,0xe853007e,0x00000000}},	//   _täss, ngku_, انند,
  { {0xceb30063,0x442d03e3,0x4426008e,0x00000000}},	//   ָיו_, dme_, _rho_,
  { {0x99160088,0x442d03e4,0x659403e5,0x00000000}},	//   _зьбі, eme_, таку,
  { {0xdcfc003d,0xb7960001,0xd49703e6,0x00000000}},	//   derī, _праћ, еры_,
  { {0x9f4b00cd,0x442d03e7,0x68e1004b,0x00000000}},	//   xicà_, gme_, _ülda,
  { {0x656103e8,0x179b0047,0x2327005e,0x00000000}},	//   _felh, _צימב, ноћи_,
  { {0x442603e9,0x7e7d0019,0xef1f03ea,0x00000000}},	//   _who_, vusp, ngüe_,
  { {0x33d6019d,0x9f4b00cd,0xdfd103eb,0x00000000}},	//   _підт, ticà_, ليد_,
  { {0xa2e603ec,0x9f4b017d,0x442d0025,0x00000000}},	//   _поед, ficá_, cme_,
  { {0x9f4b0268,0x7c2d0137,0x644103ed,0x00000000}},	//   ricà_, vmar, _zuli,
  { {0x2d85005b,0x69ce03ee,0x3f710013,0x00000000}},	//   üle_, _nobe, ễu_,
  { {0x7e7d03ef,0x246c004c,0xac1903f0,0x00000000}},	//   susp, něm_, дову_,
  { {0x7e7d00a4,0x7c2d03f1,0xdb06013d,0x00000000}},	//   pusp, umar, _zaké,
  { {0x7c2d03f2,0x9f4b0019,0x99630066,0x00000000}},	// [3b0] rmar, öjõu_, ríži_,
  { {0x69ce03f3,0x7c2d03f4,0x601d004c,0x00000000}},	//   _cobe, smar, kémk,
  { {0xe3c301f7,0x69ce03f5,0x99840021,0x00000000}},	//   ngıç_, _dobe, المو,
  { {0x64410034,0x2d8303f6,0x65610080,0x00000000}},	//   _ruli, lgje_, _selh,
  { {0x644103f7,0xe72e0001,0xb6a50076,0x00000000}},	//   _suli, ре_, тилл,
  { {0x69ce03f8,0x644103f9,0x7b07003b,0x00000000}},	//   _gobe, _puli, ăptă,
  { {0x656103fa,0xdb06013d,0xd61800f2,0x00000000}},	//   _velh, _raké, رتها_,
  { {0x7bcf000c,0x656103fb,0x442d03fc,0x00000000}},	//   _jocu, _welh, ume_,
  { {0x69d8000f,0x1309019d,0x442d03fd,0x00000000}},	//   öveg, ьний_, rme_,
  { {0x7bcf03fe,0x442d03ff,0x64410400,0x00000000}},	//   _locu, sme_, _tuli,
  { {0xdb1d0027,0x644100a4,0xf8e10053,0x00000000}},	//   _cosú, _uuli, पनिय,
  { {0x13a7007e,0x6008005b,0x3165004d,0x00000000}},	//   _سنتی_, dımc, salz_,
  { {0xdb060024,0x3f8c0051,0x69c40053,0x00000000}},	//   _také, ędu_, रामी,
  { {0x82760047,0x63ab0026,0x7e6d0401,0x00000000}},	//   _יענע_, _hagn, _dvap,
  { {0xa0a50086,0xa3d50053,0x69ce0287,0x00000000}},	//   _райд, _सका_, _robe,
  { {0x7ff6007e,0x69ce0402,0xd00f00f2,0x00000000}},	//   _جستا, _sobe, _ولو_,
  { {0xd9460001,0x69ce0403,0x63ab01e7,0x00000000}},	// [3c0] вези, _pobe, _magn,
  { {0xdb0d0026,0x7e60003b,0x38560062,0x00000000}},	//   rjað, âmpu, въдс,
  { {0x7bcf00d8,0xfeba007e,0x81bc008f,0x00000000}},	//   _focu, _راکت_, mmēt,
  { {0x69ce0404,0x27e00405,0x63ab0406,0x00000000}},	//   _wobe, óin_, _nagn,
  { {0x68e1004b,0xe7f30042,0x20020407,0x00000000}},	//   _üldn, _आगरा_, inki_,
  { {0xa613000d,0x69d8013d,0x6b84004e,0x00000000}},	//   аміч, öved, lgig,
  { {0x63ab0408,0x44a30021,0x9f420066,0x00000000}},	//   _bagn, لموق, ahké_,
  { {0x63ab0409,0x6016013d,0x6b84040a,0x00000000}},	//   _cagn, zámr, ngig,
  { {0x41e6000d,0x81bc008f,0x99830078,0x00000000}},	//   віна, kmēt, _gijų_,
  { {0xdb1d0024,0x6008005b,0xf1ba0013,0x00000000}},	//   _posú, yımc, _khơi_,
  { {0xb97b014e,0x601d040b,0x30a30062,0x00000000}},	//   וניי, lémi, аряв,
  { {0x63ab040c,0xfe7f01a8,0xe3c30058,0x00000000}},	//   _gagn, tuï_, rgıç_,
  { {0xd3360088,0xd2500021,0x7bcf017d,0x00000000}},	//   _рэжы, _انت_, _rocu,
  { {0x63ab040d,0x6b84004b,0x6280040e,0x00000000}},	//   _zagn, egig, mumo,
  { {0x7dcb00ea,0x9f42004c,0x601d040f,0x00000000}},	//   _küsz, liký_, hémi,
  { {0x63a00410,0x60080058,0x313700ff,0x00000000}},	//   nemn, rımc, _ברוך_,
  { {0x3b640062,0x7c34007b,0x63a00022,0x00000000}},	// [3d0] ръсв, ретх, iemn,
  { {0x6b8400a4,0x6016006d,0x3ea900a4,0x00000000}},	//   agig, lámp, _isat_,
  { {0xf1ba008b,0xf775013c,0x62800411,0x00000000}},	//   _chơi_, гулю, humo,
  { {0xf09300b5,0x2e240026,0x63a00412,0x00000000}},	//   ינע_, nöfn_, jemn,
  { {0x6280001c,0x6008005b,0xdb04017d,0x00000000}},	//   jumo, nıma, rdiã,
  { {0x27e600a4,0x68e1004b,0x16a60413,0x00000000}},	//   ahon_, _üldo, увши_,
  { {0x63ab0414,0x478b0001,0x7c3d0150,0x00000000}},	//   _pagn, _осам_, _kisr,
  { {0x2496007e,0x3d3c0063,0x3ea900fe,0x00000000}},	//   انيد_, וגוס, _osat_,
  { {0x62800006,0x63ab0415,0x25ac01a8,0x00000000}},	//   gumo, _vagn, _fadl_,
  { {0x228b00d1,0xb0ae0053,0x3f89002b,0x00000000}},	//   røk_, टिंग, _acau_,
  { {0x228b0031,0xf484000d,0x7052007e,0x00000000}},	//   søk_, _вучн, ینیا,
  { {0xdb0d0019,0x5f76007e,0x653a0041,0x00000000}},	//   ljaõ, دادر, _װענד,
  { {0x3ea9003b,0x7f190054,0xfeba005d,0x00000000}},	//   _csat_, віру_, راحت_,
  { {0xdb1d006c,0x81bc0023,0xc332009a,0x00000000}},	//   _insè, umēt, _הוד_,
  { {0x3ea9003d,0x7c3d0150,0x81bc001c,0x00000000}},	//   _esat_, _bisr, rmēt,
  { {0xfaa60416,0x81bc0417,0xdb04017c,0x00000000}},	//   лабо, smēt, ediá,
  { {0xac070076,0x7c3d0034,0xda650021,0x00000000}},	// [3e0] унта_, _disr, لالي,
  { {0x7a220024,0x443d002b,0xf1ba0013,0x00000000}},	//   rôto, _liw_, _phơi_,
  { {0x81bc0418,0x6d5c0419,0x68e1004b,0x00000000}},	//   slēg, mbra, _üldl,
  { {0x4b55005a,0xd70a0121,0x601d0003,0x00000000}},	//   _върт, ннее_, témi,
  { {0xddc400c3,0xcc3b0047,0x6d5c041a,0x00000000}},	//   _zviš, _רעכט, obra,
  { {0xe9df0027,0x8675000d,0x7d1e01cf,0x00000000}},	//   _dtús_, рыцц, _kyps,
  { {0xe0c7041b,0x601d0003,0x63a0041c,0x00000000}},	//   _از_, sémi, temn,
  { {0xb9080235,0xc274041d,0x443d002b,0x00000000}},	//   यन_, алиј, _ciw_,
  { {0x26c200c2,0x6d5c041e,0x63a0041f,0x00000000}},	//   _škof_, kbra, remn,
  { {0x81bc001c,0xe617000d,0x63a00420,0x00000000}},	//   emēr, _бду_, semn,
  { {0x4386007e,0xe97b0047,0xb97b0047,0x00000000}},	//   _ملاق, ענטש, ענטי,
  { {0x7528003d,0x273a005b,0x7525004d,0x00000000}},	//   _izdz, _günü_, ühze,
  { {0x7a2b02d2,0x6d5c0244,0x74130043,0x00000000}},	//   lüte, fbra, _اونا,
  { {0x2fc00421,0x656a0229,0xf1a30062,0x00000000}},	//   _enig_, nafh, _грън,
  { {0xdb1d0164,0x721b0063,0x61fa0422,0x00000000}},	//   _insé, _רווח, mitl,
  { {0x3b55000a,0x81bc001c,0x61fa0423,0x00000000}},	//   ркар, slēd, litl,
  { {0x6d5c0424,0x3ea900cd,0xef1f004d,0x00000000}},	// [3f0] bbra, _usat_, afür_,
  { {0x6d5c0016,0x61fa0425,0xdcfc001c,0x00000000}},	//   cbra, nitl, sgrā,
  { {0xdb04006d,0xa8020058,0xa3d50042,0x00000000}},	//   rdiá, ğına, _सकल_,
  { {0x7e7d0229,0xa802005b,0x68e1004b,0x00000000}},	//   orsp, şına, _üldm,
  { {0xa6350054,0xa7640085,0x61fa0426,0x00000000}},	//   анді, скід, kitl,
  { {0xaaa8005a,0xab5b004d,0x81bc001c,0x00000000}},	//   _съюз_, _unüb, zmēr,
  { {0x7aed0427,0x7e7d004d,0x7a2b004d,0x00000000}},	//   lzat, hrsp, güte,
  { {0x7bcd0397,0x6d5c040d,0x6d41005b,0x00000000}},	//   njau, zbra, ılay,
  { {0x7aed0428,0x11e50429,0xd1b901fb,0x00000000}},	//   nzat, ижим, نادا_,
  { {0x8467011c,0x4375006a,0x20090089,0x00000000}},	//   _бъде, _چهار, _ajai_,
  { {0x23c50053,0xe5c4042a,0x7e7d042b,0x00000000}},	//   वादद, _усто, ersp,
  { {0x2295042c,0x61fa0139,0x7aed013d,0x00000000}},	//   _видя, aitl, kzat,
  { {0x81bc001c,0x78450078,0x1e830330,0x00000000}},	//   rmēr, _dėvi, олям,
  { {0x61fa033c,0xdb04017d,0x7aed0066,0x00000000}},	//   citl, ldiç, dzat,
  { {0x6d5c042d,0x8f7601dd,0xabf60330,0x00000000}},	//   rbra, _купі, ачащ,
  { {0xdb0403d9,0x2fc00185,0x35c70161,0x00000000}},	//   ndiç, _unig_, लाड़,

  { {0x4b55005a,0x896602a9,0x68e1042e,0x00000000}},	// [400] съст, икаж, _üldj,
  { {0x48b6005a,0x7edb0047,0x7d1e01bb,0x00000000}},	//   ищет, _סקיצ, _typs,
  { {0x32050034,0x9874004c,0x672900a8,0x00000000}},	//   inly_, _týče_, _azej,
  { {0x2cac0014,0x7bdf042f,0xa6e7008d,0x00000000}},	//   æddu_, ckqu, _trứ,
  { {0x46f60002,0xe5c60430,0xbad50085,0x00000000}},	//   јчет, иско, _ліры,
  { {0x5d7a00b5,0xd49a0431,0x6729008f,0x00000000}},	//   דאַק, ври_, _dzej,
  { {0x53e60432,0x26c2004c,0x94aa0121,0x00000000}},	//   ициа, _škod_, ттла_,
  { {0x656a01b0,0x7a2b0433,0x7afb0130,0x00000000}},	//   safh, rüte, _žuti,
  { {0x61fa0434,0x31670435,0x7a2b013d,0x00000000}},	//   titl, _benz_, süte,
  { {0x645800b8,0x6b96002b,0x9f59006c,0x00000000}},	//   ppvi, hfyg, misé_,
  { {0x7aed02f6,0x9f5903b2,0x30150054,0x00000000}},	//   zzat, lisé_, йдор,
  { {0x61fa0436,0xf8b30063,0x44200437,0x00000000}},	//   sitl, קשר_, _ói_,
  { {0x7e7d0438,0x9f590003,0x64480439,0x00000000}},	//   ursp, nisé_, _hudi,
  { {0x752d0080,0x6008005b,0xdef8000d,0x00000000}},	//   řaze, lıml, рыю_,
  { {0x7b670076,0x7bcd001c,0x31570063,0x00000000}},	//   итае, tjau, _דיון_,
  { {0x7aed0268,0x600801f7,0x8bc4043a,0x00000000}},	//   tzat, nıml, осуд,
  { {0x6e95043b,0x7bcd024a,0x5e950032,0x00000000}},	// [410] _الخا, rjau, _الخط,
  { {0x68e10019,0xa802005b,0x2019043c,0x00000000}},	//   _üldk, şıla, losi_,
  { {0x7aed00ea,0x5887000d,0x60080058,0x00000000}},	//   szat, рыза, kıml,
  { {0x2019043d,0x2769007e,0xd874043e,0x00000000}},	//   nosi_, اشای_, زامب,
  { {0xef1f005b,0x60080058,0x79a70002,0x00000000}},	//   zgün_, dıml, _крве,
  { {0xe6180086,0x2019043f,0xbb3a0063,0x00000000}},	//   аді_, hosi_, _תעשי,
  { {0x20190440,0x656803a7,0x33f50054,0x00000000}},	//   kosi_, _dedh, йчис,
  { {0xd77403eb,0x31670290,0x6448006c,0x00000000}},	//   _واقع, _senz_, _dudi,
  { {0x6d450025,0x65680441,0xdb04017d,0x00000000}},	//   _ogha, _fedh, rdiç,
  { {0x6d450185,0x27fd001f,0xdb04017d,0x00000000}},	//   _ngha, liwn_, sdiç,
  { {0x2733001b,0xa87900b5,0x20190290,0x00000000}},	//   _ảnh_, װאָר, fosi_,
  { {0x6d450027,0xdb060442,0xfaff00ac,0x00000000}},	//   _agha, _inkö, _reën_,
  { {0xc2cb0021,0x1dc30042,0x64480023,0x00000000}},	//   _جبال_, शांत, _zudi,
  { {0x9f5900fe,0x64480150,0x27fd002b,0x00000000}},	//   ensä_, _yudi, hiwn_,
  { {0x76410443,0x68e10019,0xe0550021,0x00000000}},	//   _mily, _üldh, _اختب,
  { {0x66180240,0x2d8c0051,0x201901f4,0x00000000}},	//   zovk, żde_, cosi_,
  { {0x4a430444,0xdd110445,0x27fd00a3,0x00000000}},	// [420] знув, _výši, diwn_,
  { {0x9f590164,0x7bcb0026,0xe9d70446,0x00000000}},	//   visé_, ögur, бку_,
  { {0xb8650021,0x6008005b,0xa802005b,0x00000000}},	//   قانو, yıml, şıma,
  { {0x64480009,0x9f590003,0x263d0066,0x00000000}},	//   _rudi, tisé_, _dňom_,
  { {0x764100a4,0xd5b10013,0x64480447,0x00000000}},	//   _bily, _bá_, _sudi,
  { {0x644802dd,0x9f590164,0xd5b1008b,0x00000000}},	//   _pudi, risé_, _cá_,
  { {0xd4670138,0x65680146,0x76410185,0x00000000}},	//   бије_, _vedh, _dily,
  { {0x94730032,0x32540448,0xdb060240,0x00000000}},	//   أدوا, овир, _zaká,
  { {0x6008005b,0xdb0600a5,0xdce7017c,0x00000000}},	//   rıml, _enkö, vajč,
  { {0x9098000a,0x7641001f,0x31c60076,0x00000000}},	//   авот_, _gily, ссив,
  { {0x64480449,0x2019044a,0x3ea00150,0x00000000}},	//   _uudi, tosi_, _apit_,
  { {0x7c24007d,0x20190072,0x5f390054,0x00000000}},	//   jlir, uosi_, ипня_,
  { {0x2019044b,0x2d98044c,0x2257007e,0x00000000}},	//   rosi_, ffre_, _هلند_,
  { {0xddcd0045,0xa1580086,0x93250021,0x00000000}},	//   _stał, _таку_, _برمن,
  { {0x9cc8000d,0x2019044d,0xe4780063,0x00000000}},	//   быта_, posi_, יָּש,
  { {0x68e10004,0xdb0f006d,0xa4fb0041,0x00000000}},	//   _üldi, _hacé, אללט,
  { {0x7769044e,0xdd910021,0x69d50114,0x00000000}},	// [430] _reex, _قوة_, _poze,
  { {0xceb40047,0x9e150054,0x6280044f,0x00000000}},	//   _זיץ_, _єдні, irmo,
  { {0x7afb0024,0xdb0f0003,0x7c240450,0x00000000}},	//   _ľutu, _macé, blir,
  { {0xdb0f0003,0xdcfc0078,0xe76b005d,0x00000000}},	//   _lacé, ugrą, احان_,
  { {0xdb23006a,0xdb060451,0x69d500a8,0x00000000}},	//   _روسی, _taká, _toze,
  { {0x27fd0185,0x4efc0063,0x442400a5,0x00000000}},	//   siwn_, נהגו, elm_,
  { {0xdb1d0139,0x62800452,0xdb070014,0x00000000}},	//   _tosó, ermo, álæg,
  { {0xd7940062,0xdc6c009d,0x843600de,0x00000000}},	//   _нисъ, נ֣וֹ, يكور_,
  { {0x72c50054,0x00000000,0x00000000,0x00000000}},	//   ібоз,   ,   ,
  { {0xfaff00e8,0xbb3c00b5,0xef1f005b,0x00000000}},	//   _reël_, נעזי, rgül_,
  { {0xa0690138,0xe5c4026c,0x2379007e,0x00000000}},	//   јама_, _эсто, _نماد_,
  { {0x64420453,0xd9a60053,0xcdc90063,0x00000000}},	//   _gioi, _ऑस्ट, _בך_,
  { {0x8db60086,0x11d50454,0x51f5009e,0x00000000}},	//   осві, _мікр, _وستر,
  { {0x73040085,0x11440044,0xc0e50131,0x00000000}},	//   _эпіз, _فَهُ, _молк,
  { {0x7a300137,0x10d50085,0xfce601d5,0x00000000}},	//   näte, _філё, цово,
  { {0xdb0d0025,0x7c240455,0xec16007e,0x00000000}},	//   adaí, ulir, آورد,
  { {0x533600b5,0x3ea0017f,0xdde9005d,0x00000000}},	// [440] ַנען_, _upit_, _گريه_,
  { {0x998a0078,0xc9860021,0x3ead0058,0x00000000}},	//   _ribų_, تشري, çete_,
  { {0xa17a0047,0xb17a0047,0xe8fa0141,0x00000000}},	//   שטעט, שטער, јле_,
  { {0x7a3000fe,0xb09a0047,0x87260456,0x00000000}},	//   däte, ייער, омеж,
  { {0xdce7001c,0xc7a30002,0xdb040139,0x00000000}},	//   majā, ќичк, hdiú,
  { {0x78af024a,0xdce7001c,0xfa670457,0x00000000}},	//   äivä, lajā, _фарк_,
  { {0x37e60086,0x14ca0121,0x00000000,0x00000000}},	//   _довг, рыли_,   ,
  { {0x68e301f2,0xdce7001c,0x7dd00072,0x00000000}},	//   ønde, najā, _väsy,
  { {0xc1a600e1,0x64420072,0x320a01ce,0x00000000}},	//   ојни, _vioi, ихон_,
  { {0x68e90080,0x81bc008f,0x60160014,0x00000000}},	//   _ředi, alēn, mámy,
  { {0xc9530063,0xa0540086,0xdce7001c,0x00000000}},	//   ומת_, явні, kajā,
  { {0x6831018c,0x645a0458,0x429a0044,0x00000000}},	//   rådg, _itti, _ننصح_,
  { {0xf7730063,0x2ef4000d,0x68e1004b,0x00000000}},	//   וקר_, дзяр, _üldv,
  { {0x69d800ea,0x683100b9,0x7bc602d2,0x00000000}},	//   övel, måde, _anku,
  { {0xdb0d0027,0x9f590025,0x9b6b000a,0x00000000}},	//   rdaí, lisí_, ишаа_,
  { {0x3eb000fe,0xaa550062,0xda670021,0x00000000}},	//   ältä_, зваш, قائي,
  { {0x2aab0459,0x161a0053,0x20120066,0x00000000}},	// [450] штво_, धवार_, ézie_,
  { {0x645a02f6,0x7c3a0006,0x7bc6045a,0x00000000}},	//   _otti, įtra, _enku,
  { {0x6d550051,0x9f590025,0xd604045b,0x00000000}},	//   mcza, hisí_, _лiкв,
  { {0x99980006,0x27e900ea,0x68310137,0x00000000}},	//   _virš_, óan_, kåde,
  { {0x645a045c,0x6b8d00a4,0x68e300b9,0x00000000}},	//   _atti, mgag, øndb,
  { {0x7a3000bd,0x6b8d004b,0xbb3a0063,0x00000000}},	//   täte, lgag, _לערי,
  { {0x69c7045d,0x05760021,0x3552005d,0x00000000}},	//   _inje, سمية_, رنيز,
  { {0x7a30045e,0x6d550022,0x6b8d045f,0x00000000}},	//   räte, hcza, ngag,
  { {0x645a01f7,0xdb0f0460,0xf6470054,0x00000000}},	//   _etti, _incó, _єхан,
  { {0x200b0051,0x7a300461,0x22970066,0x00000000}},	//   enci_, päte, eľká_,
  { {0x6d550045,0x68310137,0xc6170053,0x00000000}},	//   dcza, pådd, दकीय_,
  { {0x2477003b,0xd00a0002,0xdd92007e,0x00000000}},	//   măm_, семе_, کوس_,
  { {0x63a90462,0x2477000c,0xdce7008f,0x00000000}},	//   meen, lăm_, vajā,
  { {0x63a90463,0x645a01f2,0x225f017e,0x00000000}},	//   leen, _ytti, mpuk_,
  { {0xdce7003d,0x2477000c,0xdb0f0058,0x00000000}},	//   tajā, năm_, _encü,
  { {0x60dc0464,0x78ba00ea,0x6b8d0465,0x00000000}},	//   ärme, _átvi, ggag,
  { {0x20020311,0x2477008b,0xdce7008f,0x00000000}},	// [460] miki_, hăm_, rajā,
  { {0x6b8d00a4,0x63a90466,0x4efb0063,0x00000000}},	//   agag, heen, _להפו,
  { {0x02a80235,0x4ddb014e,0x63a90467,0x00000000}},	//   _कन्न, _החיו, keen,
  { {0x63a9006f,0x20020468,0x2477003b,0x00000000}},	//   jeen, niki_, dăm_,
  { {0xdb0600c7,0xa3cf0053,0x869a0363,0x00000000}},	//   _bakå, शान_, стет_,
  { {0xf1d0008b,0xe5b3000d,0x69c7007d,0x00000000}},	//   _mạch_, ейшы, _gnje,
  { {0x24770469,0xd4670001,0x2451008b,0x00000000}},	//   găm_, пије_, _cám_,
  { {0x20020035,0x6d550051,0xdb0f00cd,0x00000000}},	//   jiki_, zcza, _incò,
  { {0x6d550051,0x3667046a,0xdce5001c,0x00000000}},	//   ycza, _нато_, _mehā,
  { {0x6831046b,0x2b460066,0x51f80054,0x00000000}},	//   råde, ľoch_, інню_,
  { {0x2002046c,0x2477000c,0x68e10019,0x00000000}},	//   fiki_, căm_, _üldt,
  { {0x6d550051,0xf1d0008b,0xa263008b,0x00000000}},	//   wcza, _bạch_, _khố,
  { {0x27e6046d,0xf19401d5,0x41e6046e,0x00000000}},	//   ikon_, _жиль, _ніка,
  { {0x7a2b005b,0x127b0047,0x7524004c,0x00000000}},	//   gütl, _פאוע, řizu,
  { {0x6d550051,0x24510013,0x819b009a,0x00000000}},	//   rcza, _xám_, _הסוצ,
  { {0x69c7007d,0x1bd4046f,0x321e0470,0x00000000}},	//   _snje, нося, loty_,
  { {0x2477000c,0xf1d0008b,0x59d9000d,0x00000000}},	// [470] zăm_, _gạch_, одаў_,
  { {0xdce7003b,0x96b30053,0x321e0471,0x00000000}},	//   gajă, _इनबॉ, noty_,
  { {0x67d50472,0x4ddc0063,0x2477003b,0x00000000}},	//   можу, _לחזו, xăm_,
  { {0xdb0f02dd,0x2477000c,0xeabf0013,0x00000000}},	//   _hací, văm_, _trù_,
  { {0xa263008b,0x9f4b006d,0x2451004a,0x00000000}},	//   _chố, licó_, _sám_,
  { {0x2477000c,0x20020473,0x63a90474,0x00000000}},	//   tăm_, ziki_, ween,
  { {0x58840475,0x9f4b006d,0x63a90476,0x00000000}},	//   _пыта, nicó_, teen,
  { {0x24770477,0xf8b20063,0x7a300478,0x00000000}},	//   răm_, _בשל_, mäta,
  { {0x2477000c,0x27ff0089,0x63a90479,0x00000000}},	//   săm_, _imun_, reen,
  { {0x13060055,0x81bc003d,0x68e10004,0x00000000}},	//   ьный_, blēm, _ülds,
  { {0x1faa000a,0xf1d0008b,0x2002047a,0x00000000}},	//   окни_, _sạch_, tiki_,
  { {0x9f4b02dd,0x320c047b,0x6603047c,0x00000000}},	//   dicó_, andy_, link,
  { {0x2002047d,0x69d800ea,0x62890283,0x00000000}},	//   riki_, övek, queo,
  { {0xc332014e,0x9f4b02dd,0xdca6047e,0x00000000}},	//   _סוג_, ficó_, маги,
  { {0x81bc003d,0x27ed047f,0x2d840058,0x00000000}},	//   klēj, _olen_, ğme_,
  { {0x2d84005b,0x7a2b004b,0x224700ca,0x00000000}},	//   şme_, sütl, _hink_,
  { {0x66030480,0xe9da0481,0x1ee8005d,0x00000000}},	// [480] kink, ока_, _رودی_,
  { {0xbf9b017d,0x66030482,0x6286007d,0x00000000}},	//   niên, jink, škog,
  { {0xdce7003b,0x66030483,0x27e60072,0x00000000}},	//   rajă, dink, tkon_,
  { {0xdb0f0080,0x9f4b0290,0xa263008b,0x00000000}},	//   _zací, licò_, _phố,
  { {0x27e600fe,0xdb1d00b9,0xfbdf008b,0x00000000}},	//   rkon_, _ansæ, _kiên_,
  { {0x66030484,0x27e60485,0x27ed0486,0x00000000}},	//   gink, skon_, _elen_,
  { {0x64a30001,0xbf9b0016,0x81bc001c,0x00000000}},	//   ваја, diên, blēj,
  { {0xfbdf00aa,0xa263001b,0x69dc0487,0x00000000}},	//   _liên_, _thố, _hore,
  { {0x23270001,0x7ae40488,0x66030489,0x00000000}},	//   моћи_, nyit, bink,
  { {0xfbdf008b,0x66030051,0xdce70051,0x00000000}},	//   _niên_, cink, lają,
  { {0x2247048a,0x69dc048b,0x9f4b0290,0x00000000}},	//   _dink_, _more, dicò_,
  { {0x69dc02e3,0xdce70051,0xe3630336,0x00000000}},	//   _lore, nają, _акци,
  { {0x69dc00e8,0xfbdf001b,0x9f4b0290,0x00000000}},	//   _oore, _biên_, ficò_,
  { {0xbf9b048c,0x69dc048d,0x9f4b006d,0x00000000}},	//   ciên, _nore, ticó_,
  { {0xdb0f048e,0xdce70051,0x26c2004c,0x00000000}},	//   _vací, kają, _škol_,
  { {0xdb0d0016,0x6603048f,0xdb21027d,0x00000000}},	//   ndaç, zink, štív,
  { {0xdce70045,0x63a20490,0x69dc0491,0x00000000}},	// [490] dają, _mbon, _bore,
  { {0x69dc0492,0x7e6d0035,0x58870085,0x00000000}},	//   _core, _iwap, дыда,
  { {0x69dc0493,0x27ed0494,0x66030495,0x00000000}},	//   _dore, _plen_, vink,
  { {0xdd0d0051,0xdce70051,0x66030496,0x00000000}},	//   półp, gają, wink,
  { {0x660300eb,0x7af60045,0xcff8014e,0x00000000}},	//   tink, czyt, וצאה_,
  { {0x04b5005a,0x69dc0497,0x66030072,0x00000000}},	//   есия, _gore, uink,
  { {0xdcfe01f7,0x66030498,0x24e90054,0x00000000}},	//   _yapı, rink, ямки_,
  { {0x4788000a,0xdb060024,0xdce70051,0x00000000}},	//   _осум_, _rakú, cają,
  { {0x52a6026c,0xc2450499,0x2247049a,0x00000000}},	//   евым_, нник, _pink_,
  { {0x7bdd0045,0xdb1d00c7,0x63a2049b,0x00000000}},	//   _losu, _insä, _ebon,
  { {0xbf9b0016,0x22470122,0x0596007e,0x00000000}},	//   riên, _vink_, _سالگ,
  { {0x6e2500e3,0x34bd0053,0x35c70053,0x00000000}},	//   _akhb, ्मीद, लाक़,
  { {0x62640086,0x63b9001f,0x63bb049c,0x00000000}},	//   _авіа, _iawn, mdun,
  { {0x63bb0199,0xdce70051,0xf1d0008b,0x00000000}},	//   ldun, zają, _hạnh_,
  { {0x32050037,0xfbdf001b,0x63bb005b,0x00000000}},	//   mily_, _viên_, odun,
  { {0xc4d200b5,0x63bb049d,0x69dc049e,0x00000000}},	//   נגן_, ndun, _sore,
  { {0xfbdf001b,0x63bb00bd,0x7bdd0080,0x00000000}},	// [4a0] _tiên_, idun, _dosu,
  { {0xdce70051,0x629b0006,0x645c0003,0x00000000}},	//   wają, ituo, _érig,
  { {0x69dc010a,0x629b0019,0xdb1d00bd,0x00000000}},	//   _vore, htuo, _ansä,
  { {0x629b0006,0xe73a049f,0x291704a0,0x00000000}},	//   ktuo, пее_, رقند_,
  { {0xdce70045,0x63bb04a1,0x69dc04a2,0x00000000}},	//   rają, ddun, _tore,
  { {0x3205004c,0x63bb004d,0x69dc0072,0x00000000}},	//   jily_, edun, _uore,
  { {0x68e10019,0x320504a3,0xf7720021,0x00000000}},	//   _üldp, dily_, _ماء_,
  { {0x764804a4,0xf1d0001b,0xd3700021,0x00000000}},	//   _widy, _cạnh_, جهة_,
  { {0xeb9f0031,0x75280051,0xdb0d04a5,0x00000000}},	//   _kjør_, _wydz, rdaç,
  { {0x75280051,0xfa970047,0x51f70121,0x00000000}},	//   _tydz, עדיש_, енью_,
  { {0x68150051,0xdb1d0137,0xdb0f0139,0x00000000}},	//   ląda, _inså, _macá,
  { {0x63a20035,0x20d50006,0x44200046,0x00000000}},	//   _ubon, džią_, _ði_,
  { {0xe04a006a,0x44260035,0x2d8504a6,0x00000000}},	//   _کشته_, _iko_, óleo_,
  { {0x92f2005b,0x320500e5,0x7c2604a7,0x00000000}},	//   ığım, cily_, _akkr,
  { {0x7bdd04a8,0x7c8404a9,0x63b90168,0x00000000}},	//   _posu, луте, _yawn,
  { {0x7e6d0035,0x7a2b004d,0x68380014,0x00000000}},	//   _twap, müti, nídd,
  { {0xe9870001,0xeb9f04aa,0xdb26005d,0x00000000}},	// [4b0] ећен, _sjøs_, پولی,
  { {0x99990006,0xafdb01e1,0xd6d1005d,0x00000000}},	//   _rusų_, smød, یقا_,
  { {0x44260117,0x78ba0024,0xef200051,0x00000000}},	//   _oko_, _štvr, ążek_,
  { {0xdb1d00c7,0x6b670003,0xfbdf0013,0x00000000}},	//   _anså, _dégâ, _kiêm_,
  { {0x7c2d04ab,0x212b00aa,0x68e50072,0x00000000}},	//   mlar, ́ch_, syhd,
  { {0xeb9f0031,0xdcee001c,0x85e80086,0x00000000}},	//   _gjør_, labā, ндів_,
  { {0x34bd0161,0x66e7001c,0x320504ac,0x00000000}},	//   ्मेद, _sīkā, vily_,
  { {0x7c2d04ab,0x629b04ad,0xd7c901f3,0x00000000}},	//   nlar, ttuo, _توره_,
  { {0x52a90086,0x62650062,0xfbdf0013,0x00000000}},	//   євом_, ъвпа, _niêm_,
  { {0x3d1a0053,0x2292007e,0x629b04ae,0x00000000}},	//   _मुझे_, گلیس, rtuo,
  { {0x32050037,0x7c2d04af,0x23e7019d,0x00000000}},	//   rily_, klar, _підв,
  { {0x3205033c,0x7c2d005b,0x629b04b0,0x00000000}},	//   sily_, jlar, ptuo,
  { {0x442d04b1,0x443f04b2,0x7c2d04b3,0x00000000}},	//   mle_, mmu_, dlar,
  { {0x644b00bb,0x7c2d04b4,0x62890025,0x00000000}},	//   _higi, elar, mreo,
  { {0x7b96019d,0x7c2d01f7,0x644b0035,0x00000000}},	//   краї, flar, _kigi,
  { {0x442d01f7,0x443f04b5,0x7c2d04b6,0x00000000}},	//   nle_, nmu_, glar,
  { {0x3b07005a,0xdb0f0025,0x442d04b7,0x00000000}},	// [4c0] вето_, _pacá, ile_,
  { {0x443f0360,0x644b04b8,0x69c00078,0x00000000}},	//   hmu_, _ligi, _ėmes,
  { {0x7db50088,0x443f0150,0x442d04b9,0x00000000}},	//   _ёсьц, kmu_, kle_,
  { {0x7aeb000f,0x7a300066,0x7c2d04ba,0x00000000}},	//   ölté, päto, clar,
  { {0x969604bb,0x7c2404bc,0x442d04bd,0x00000000}},	//   треш, moir, dle_,
  { {0x6d480006,0x7c240003,0x628904be,0x00000000}},	//   ždau, loir, dreo,
  { {0xeb9f0031,0x442d04bf,0x69ce04c0,0x00000000}},	//   _kjøp_, fle_, _inbe,
  { {0xe4e3019d,0x68e304c1,0x644b0139,0x00000000}},	//   рішн, ände, _cigi,
  { {0x644b04c2,0x26c4004b,0xf74304c3,0x00000000}},	//   _digi, _urmo_, _вето,
  { {0x644b007a,0x442d04c4,0x7c2d005b,0x00000000}},	//   _eigi, ale_, zlar,
  { {0x4426017f,0xf9930063,0x7c2d04c5,0x00000000}},	//   _tko_, ברת_, ylar,
  { {0xb4fb00b5,0x62890025,0x44260035,0x00000000}},	//   _קלאר, breo, _uko_,
  { {0x69ce04c6,0xfaff00e8,0x7c2d0058,0x00000000}},	//   _onbe, _leër_, vlar,
  { {0x827700b5,0x2458008b,0xfbdf0013,0x00000000}},	//   _יעדע_, _kém_, _viêm_,
  { {0x7c2d01f7,0x7c240025,0x2d580156,0x00000000}},	//   tlar, foir, тись_,
  { {0x69ce02ab,0x683104c7,0x24580080,0x00000000}},	//   _anbe, vådo, _mém_,
  { {0x7c2d01f7,0x6d5c010a,0x644000fe,0x00000000}},	// [4d0] rlar, bcra, immi,
  { {0x442d01f7,0x7c2d005b,0x442404c8,0x00000000}},	//   zle_, slar, hom_,
  { {0x7c2d01f7,0x394700c7,0xd1410051,0x00000000}},	//   plar, äns_, cząć_,
  { {0x3b64005a,0x442404c9,0xa9270078,0x00000000}},	//   _върв, jom_, _rožė,
  { {0x68e30137,0x644b04ca,0xc1780078,0x00000000}},	//   ändb, _rigi, nkės_,
  { {0x69d8000f,0xdb060080,0xf6240086,0x00000000}},	//   övet, _jaký, адіо,
  { {0x18b80076,0x644b04cb,0xe3b10021,0x00000000}},	//   _игры_, _pigi, مرة_,
  { {0x442404cc,0x628904cd,0x442d04ce,0x00000000}},	//   gom_, treo, ule_,
  { {0x32d4000d,0x644b04cf,0x11d90021,0x00000000}},	//   ацэс, _vigi, فوظة_,
  { {0x644000fe,0x628904d0,0x7e7d04d1,0x00000000}},	//   ammi, rreo, dssp,
  { {0x644b04d2,0x91050076,0xdb0f017d,0x00000000}},	//   _tigi, упне, _facç,
  { {0x442404c9,0x629c003b,0xd00f0044,0x00000000}},	//   com_, ăror, كلٍ_,
  { {0x7c240164,0x7e7d04d3,0x3f9e0022,0x00000000}},	//   voir, gssp, ętu_,
  { {0xdb04017d,0xa0c5007e,0x8e750054,0x00000000}},	//   leiç, _ميتو, шуюч,
  { {0x7c2403b2,0x6d5c0034,0x201904d4,0x00000000}},	//   toir, rcra, éric_,
  { {0xf0920063,0x6d5c04d5,0xabf504d6,0x00000000}},	//   _הנה_, scra, ачущ,
  { {0x7c2404d7,0xed5a01f6,0xbb750094,0x00000000}},	// [4e0] roir, _поп_, русъ,
  { {0x7bcf048e,0x7a2b0019,0x7e6400a4,0x00000000}},	//   _encu, kütu, _itip,
  { {0x2fd7007e,0xfce604d8,0x7c240003,0x00000000}},	//   _شوید_, _соно, poir,
  { {0x61e00235,0x27e0007a,0xdb040016,0x00000000}},	//   _पक्ष, ðin_, jeiç,
  { {0x4a750475,0x442404d9,0x69d800ea,0x00000000}},	//   _выст, vom_, öves,
  { {0x69ce04da,0x44240022,0xe8560044,0x00000000}},	//   _unbe, wom_, _منسد,
  { {0xdb04017d,0x54a60021,0x6ab6002b,0x00000000}},	//   feiç, احتف, lwyf,
  { {0xd90d006a,0x2676005d,0x7e640130,0x00000000}},	//   _تیم_, _مهرآ, _otip,
  { {0x81bc003d,0x6596007e,0x99630066,0x00000000}},	//   klēt, _مجار, líši_,
  { {0xdd1f0024,0x68380080,0x24580124,0x00000000}},	//   _líši, bídc, _tém_,
  { {0xf993014e,0x30a3005a,0xddcd000c,0x00000000}},	//   זרת_, бряв, _ataş,
  { {0xde590088,0x1e1d0053,0x7e7d04db,0x00000000}},	//   камі_, पक्ष_, tssp,
  { {0x7e7d004d,0x68150022,0x81d404dc,0x00000000}},	//   ussp, ządo, _волх,
  { {0xdb07000f,0x52830021,0xdb0600ea,0x00000000}},	//   ámít, _الوك, _lakó,
  { {0x7e7d004d,0x7c0901f3,0xa0c30044,0x00000000}},	//   sssp, نيسف_, _هيوو,
  { {0x7a2b00bd,0xf1d20053,0xdb060058,0x00000000}},	//   hütt, तावन, _fakü,
  { {0x200b04dd,0xdb060024,0x09750121,0x00000000}},	// [4f0] mici_, _taký, игаю,
  { {0xdd9104de,0xd91b0076,0x200b04df,0x00000000}},	//   _بود_, нье_, lici_,
  { {0x6d480006,0xd7e7013c,0x48ab000d,0x00000000}},	//   ždar, лідо, этам_,
  { {0xf3f1001b,0x200b04e0,0x69d804e1,0x00000000}},	//   _mục_, nici_, över,
  { {0xb5fd00eb,0x7c3a0164,0xf3f10013,0x00000000}},	//   _atša, ître, _lục_,
  { {0xdb1f0019,0x200b04e2,0xdb0e0014,0x00000000}},	//   övõi, hici_, _þjál,
  { {0xdb1d010a,0x200b005b,0x62860114,0x00000000}},	//   _ansø, kici_, ákon,
  { {0x200b0392,0x81bc008f,0x73e504e3,0x00000000}},	//   jici_, klēs, роиз,
  { {0x91d50086,0x200b04e4,0x7a2b0244,0x00000000}},	//   ацні, dici_, bütt,
  { {0x7a3000fe,0xdb060195,0x7d08004c,0x00000000}},	//   vätk, _zakó, údsk,
  { {0x200b04e5,0xf3f10013,0x7e6404e6,0x00000000}},	//   fici_, _cục_, _stip,
  { {0x200b04e7,0x76430150,0xf3f10013,0x00000000}},	//   gici_, lmny, _dục_,
  { {0x201904e8,0xddd60066,0x3f8c0058,0x00000000}},	//   éria_, _avyš, ğdu_,
  { {0x7e6404e9,0x752d004c,0xb7c400dd,0x00000000}},	//   _vtip, řazu, ăţir,
  { {0x200b04ea,0xf1d20082,0x00000000,0x00000000}},	//   bici_, तारन,   ,
  { {0x61e300ea,0x78450078,0x7a3004eb,0x00000000}},	//   _honl, _tėvy, mäti,
  { {0x39560079,0x7e64007d,0xb956005e,0x00000000}},	// [500] ањет, _utip, атећ,
  { {0x2fc004ec,0x8e7b0063,0xa96a04ed,0x00000000}},	//   _haig_, _שניה, тижа_,
  { {0xd8260062,0x2cba04ee,0x8ba604ef,0x00000000}},	//   аджи, _uspd_, _кинж,
  { {0x443d0185,0x68e301e3,0x46ea005a,0x00000000}},	//   _nhw_, ända, кден_,
  { {0x2fc00268,0xa6b6005a,0xddd60240,0x00000000}},	//   _maig_, рсещ, _zvyš,
  { {0x645e0016,0x2d9804f0,0xd6cf007e,0x00000000}},	//   ípio, ngre_, بقه_,
  { {0x7a3000fe,0x200b005b,0xa5f7005a,0x00000000}},	//   jäti, yici_, рещу_,
  { {0x25a00080,0xd7f20021,0xe8d70063,0x00000000}},	//   řil_, _بكر_, _דולר_,
  { {0xf8050121,0x78af007c,0x9f490058,0x00000000}},	//   _учён, čivš, _ilaç_,
  { {0xc05a0088,0x61e304f1,0x95c704f2,0x00000000}},	//   кім_, _conl, _клуб_,
  { {0x3a37014e,0x200b04f3,0x39570063,0x00000000}},	//   שרים_, tici_, ישים_,
  { {0x82a60145,0x00000000,0x00000000,0x00000000}},	//   _вадж,   ,   ,
  { {0xe1fa0001,0x61e3005b,0xbe8b0062,0x00000000}},	//   _игд_, _fonl, ъсне_,
  { {0xf3f1001b,0x200b04f4,0x62820104,0x00000000}},	//   _tục_, sici_, _ivoo,
  { {0x52b60161,0x2fc000cd,0x200b04f5,0x00000000}},	//   _अनुस, _faig_, pici_,
  { {0x2d980031,0x62820019,0xd0f70063,0x00000000}},	//   agre_, _kvoo, _כמות_,
  { {0xa3a80235,0xe8e0008b,0x61fa004b,0x00000000}},	// [510] ख्य_, ưới_, ohtl,
  { {0x683802f4,0xf99304f6,0x628004f7,0x00000000}},	//   vída, تبر_, ismo,
  { {0xb9c40021,0xf75500de,0xd77700de,0x00000000}},	//   تقلي, مناج, لاشع,
  { {0x62800203,0x3f9904f8,0xd7880021,0x00000000}},	//   ksmo, ngsu_, لنمو_,
  { {0x27e4003b,0x7d1b0058,0xc7b80121,0x00000000}},	//   _domn_, ğusu, рёх_,
  { {0x443d04f9,0x660804fa,0x628004fb,0x00000000}},	//   _shw_, _cmdk, dsmo,
  { {0xfc3f001b,0x20090290,0x628004fc,0x00000000}},	//   _khí_, _omai_, esmo,
  { {0xd794005a,0x61e3005b,0x248904fd,0x00000000}},	//   _мисъ, _sonl, čam_,
  { {0xfc3f0025,0x7aed04fe,0xdb1d0164,0x00000000}},	//   _mhí_, nyat, _basé,
  { {0x61fa04ff,0x7a300461,0x7aed0058,0x00000000}},	//   ghtl, täti, iyat,
  { {0xafdb0093,0xfbdf0013,0xb8750500,0x00000000}},	//   rmøn, _hiêu_, алiз,
  { {0x7aed003e,0xafdb01f2,0xfbdf0013,0x00000000}},	//   kyat, smøn, _kiêu_,
  { {0x7a30024a,0x2fc000cd,0x0cd00053,0x00000000}},	//   säti, _vaig_, हम्म,
  { {0xfc3f02dd,0x6da60001,0x61fa0501,0x00000000}},	//   _ahí_, љива, chtl,
  { {0x4095043b,0xfc3f0027,0x9c590001,0x00000000}},	//   _العر, _bhí_, ишту_,
  { {0xfc3f001b,0x3ce500c7,0x7a3000c7,0x00000000}},	//   _chí_, älva_, nätv,
  { {0x68e30502,0x89aa0002,0xbb430503,0x00000000}},	// [520] ändn, лкав_, зетк,
  { {0xc3320063,0x200e0051,0xdb040003,0x00000000}},	//   לון_, ślić_, nfié,
  { {0xe93a018e,0x9f4900cd,0x224b0066,0x00000000}},	//   учај_, _plaç_, ícky_,
  { {0x60dc0504,0x8b9602a1,0x7d1b0058,0x00000000}},	//   ärmi, _уроч, ğust,
  { {0x68380080,0x661a0150,0x673b0051,0x00000000}},	//   bídn, _pjtk, _czuj,
  { {0x99d603eb,0xd49a00fb,0xd6270505,0x00000000}},	//   _اتحا, гри_, боче_,
  { {0x75890086,0xdb0400be,0xdb1d006c,0x00000000}},	//   рсів_, rdiõ, _rasé,
  { {0x62860006,0x20dc0066,0x7bc40506,0x00000000}},	//   škom, nšiť_, ndiu,
  { {0x44f30013,0x6aa40507,0x7bc4004e,0x00000000}},	//   ạ_, ntif, idiu,
  { {0x2d8c01a8,0x61fa004b,0x645c006c,0x00000000}},	//   ódel_, uhtl, _ério,
  { {0x20190016,0x546a0002,0x320c0195,0x00000000}},	//   ério_, _саем_, ridy_,
  { {0x6282006f,0x6aa40508,0x7a300072,0x00000000}},	//   _tvoo, ktif, mätu,
  { {0x7336007e,0xde59000d,0x657a0509,0x00000000}},	//   _ارائ, рагі_, _keth,
  { {0x831b0047,0x645a050a,0x2327005e,0x00000000}},	//   _גודז, _kuti, _уочи_,
  { {0xf1a9006a,0xfc3f001b,0x657a050b,0x00000000}},	//   _خانه_, _phí_, _meth,
  { {0x317e050c,0x9994004c,0x657a050d,0x00000000}},	//   latz_, _češi_, _leth,
  { {0x1a5b0021,0x4a540062,0x7c3a0003,0x00000000}},	// [530] اشرة_, зкус, îtra,
  { {0x645a03b2,0x9f4b0080,0x657a050e,0x00000000}},	//   _outi, nkcí_, _neth,
  { {0xe8e000aa,0x7a30024a,0x31780045,0x00000000}},	//   ười_, jätu, órzy_,
  { {0x4735050f,0x317e0206,0xd7580021,0x00000000}},	//   онес, hatz_, مجها_,
  { {0x20190164,0x62860006,0x6aa40510,0x00000000}},	//   insi_, škoj, ctif,
  { {0x1958000d,0x25a9007d,0x645a0511,0x00000000}},	//   _гары_, đalo_, _buti,
  { {0x69d50512,0x657a001f,0x44f3008b,0x00000000}},	//   _inze, _deth, ụ_,
  { {0xfbdf001b,0x645a0513,0x69c50514,0x00000000}},	//   _tiêu_, _duti, ldhe,
  { {0x657a0515,0xdb1d0516,0x645a0517,0x00000000}},	//   _feth, _insó, _euti,
  { {0x69c50518,0xf0a90085,0x80a90519,0x00000000}},	//   ndhe, акол_, авов_,
  { {0xf9920132,0x7a3000fe,0x32f4001b,0x00000000}},	//   ורי_, mätt, ày_,
  { {0x26cd0150,0x7a30051a,0x81bc001c,0x00000000}},	//   _kreo_, lätt, slēp,
  { {0x3f890185,0xeef50088,0x69d5051b,0x00000000}},	//   _ddau_, пярэ, _onze,
  { {0x20190150,0x27fd002b,0x22590014,0x00000000}},	//   ansi_, hhwn_, ísku_,
  { {0x68e3051c,0xb147005d,0x69c5013d,0x00000000}},	//   ändl, _دیدم_, ddhe,
  { {0x69d5051d,0x6aa4051e,0x69c500ca,0x00000000}},	//   _anze, ttif, edhe,
  { {0x6aa40034,0x63a9051f,0x261a0053,0x00000000}},	// [540] utif, ifen, _बदली_,
  { {0x69c5016d,0x238c0006,0x20f50013,0x00000000}},	//   gdhe, mėjų_, ói_,
  { {0x20dc0024,0x7a3000fe,0x02b60053,0x00000000}},	//   pšiť_, dätt, _अन्न,
  { {0x6aa40003,0xc66a005e,0x645a0520,0x00000000}},	//   ptif, ашке_, _ruti,
  { {0x777b0164,0x26cd0521,0x645a0522,0x00000000}},	//   _deux, _creo_, _suti,
  { {0x62860006,0x7aeb004d,0x7641001f,0x00000000}},	//   škok, ägte, _chly,
  { {0x63a90523,0x7880004c,0xd6d90022,0x00000000}},	//   ffen, _dává, _mgły_,
  { {0x0443000a,0x63a9001f,0x657a0524,0x00000000}},	//   мејн, gfen, _weth,
  { {0x7a3003c8,0x442f00ea,0x32f4008b,0x00000000}},	//   bätt, _dkg_, ùy_,
  { {0x238c0078,0x51f80525,0x645a0526,0x00000000}},	//   dėjų_, сною_, _tuti,
  { {0x645a00fe,0x4254007e,0x69b70063,0x00000000}},	//   _uuti, _کنتر, חליף_,
  { {0x317e00bd,0x69c500ea,0x8007012c,0x00000000}},	//   satz_, zdhe, ічне,
  { {0x41e6000d,0x7a300137,0x238c0078,0x00000000}},	//   _міка, näts, gėjų_,
  { {0x81f80049,0x7c36013d,0x6d5a005f,0x00000000}},	//   _دفتر_, elyr, žtan,
  { {0x271c001b,0x1bd5005a,0x644204aa,0x00000000}},	//   ỉnh_, повя, _khoi,
  { {0xdfd10032,0x60240095,0x929d0022,0x00000000}},	//   _أية_, _одја, szłe,
  { {0x68380066,0x34b70042,0xc95b0085,0x00000000}},	// [550] rídl, _आन्द, аўе_,
  { {0x78a50026,0x69c500ca,0xadb9005d,0x00000000}},	//   tthv, udhe, _اهدا_,
  { {0x9f400026,0x7a300527,0x69c50528,0x00000000}},	//   _hlið_, vätt, rdhe,
  { {0x080b0044,0x00000000,0x00000000,0x00000000}},	//   جزئي_,   ,   ,
  { {0x7a3000bd,0x7bda0063,0xc6680002,0x00000000}},	//   tätt, _הקרו, ошје_,
  { {0x7c2d0529,0x26cd000c,0x29070139,0x00000000}},	//   loar, _vreo_, únas_,
  { {0x7a30052a,0xdb1d052b,0x63a90244,0x00000000}},	//   rätt, _masí, tfen,
  { {0xc2c50032,0x7a30052c,0x26cd052d,0x00000000}},	//   كيبي, sätt, _treo_,
  { {0xd5bb052e,0x69c10026,0x64420139,0x00000000}},	//   _все_, _óles, _dhoi,
  { {0x238c0006,0x13060121,0x63a904a7,0x00000000}},	//   vėjų_, яный_, sfen,
  { {0xf99200b5,0x64420027,0x3eb200ac,0x00000000}},	//   ערט_, _fhoi, _spyt_,
  { {0xa3bb006a,0xb4d70053,0x60160006,0x00000000}},	//   _خاطر_, ामी_, kšme,
  { {0x7c2d052f,0xdb1d0530,0x64490531,0x00000000}},	//   doar, _basí, mmei,
  { {0x7c2d000c,0x442d0532,0x238c0078,0x00000000}},	//   eoar, loe_, rėjų_,
  { {0xf1b2014e,0x7c3a0003,0x64490229,0x00000000}},	//   _נסה_, îtro, omei,
  { {0x7c2d000c,0x442d0533,0x1e86032d,0x00000000}},	//   goar, noe_, _елим,
  { {0x442d002b,0x2e360014,0x3f820534,0x00000000}},	// [560] ioe_, hæfi_, maku_,
  { {0x3f82014f,0x7d27013d,0x64490535,0x00000000}},	//   laku_, érsé, hmei,
  { {0x23bd0161,0x64490019,0x9f590331,0x00000000}},	//   ्याद, kmei, cisó_,
  { {0xdb1d0080,0x7a3000bd,0x3f82017f,0x00000000}},	//   _zasí, täts, naku_,
  { {0x64490019,0xf3f1008b,0x29070014,0x00000000}},	//   dmei, _cụm_, únar_,
  { {0x7bc60536,0x6e2e0290,0x3f8200fe,0x00000000}},	//   _haku, nobb, haku_,
  { {0x7bc60537,0x64420025,0xdb0d0014,0x00000000}},	//   _kaku, _phoi, ldað,
  { {0x7bc60538,0x29370047,0x3f820539,0x00000000}},	//   _jaku, _זאלן_, jaku_,
  { {0x7bc6053a,0x683101f2,0xdb0d0014,0x00000000}},	//   _maku, rådt, ndað,
  { {0x7bc6053b,0x7c2d053c,0x6e2e02af,0x00000000}},	//   _laku, zoar, jobb,
  { {0x64420027,0x65680150,0x6e2e053d,0x00000000}},	//   _thoi, _ifdh, dobb,
  { {0x04db014e,0x3f820509,0x7bc6053e,0x00000000}},	//   _לקבל, gaku_, _naku,
  { {0xdb0d017d,0x7c2d000c,0x63a2053f,0x00000000}},	//   meaç, voar, _icon,
  { {0x61140540,0x60dc0137,0x7bc600a4,0x00000000}},	//   _одлу, ärms, _aaku,
  { {0x7c2d0529,0xa0a30141,0x3f82017c,0x00000000}},	//   toar, _зајд, baku_,
  { {0x7bc60150,0x6c540541,0x80a30044,0x00000000}},	//   _caku, ексу, _أمين,
  { {0xba55005e,0x7c2d0542,0xdd0c0022,0x00000000}},	// [570] двај, roar, góła,
  { {0x5a340138,0x68380080,0x7c2d000c,0x00000000}},	//   енут, bídk, soar,
  { {0x7c2d0529,0x7bc60543,0x64490072,0x00000000}},	//   poar, _faku, ymei,
  { {0x2d9c01e3,0x27e9007a,0x33f1017d,0x00000000}},	//   _över_, ðan_, _táxi_,
  { {0x7e69000c,0x6fa50053,0xe69b0022,0x00000000}},	//   _împă, _कानू, _żołą,
  { {0x2d830544,0x63a20545,0xddc4003b,0x00000000}},	//   naje_, _acon, _itiţ,
  { {0x64490546,0x442d0547,0x7bc60548,0x00000000}},	//   tmei, toe_, _yaku,
  { {0x3cfc0047,0x644902d2,0x7e6d007d,0x00000000}},	//   מלונ, umei, _otap,
  { {0xdcfc00c2,0x64490549,0x442d054a,0x00000000}},	//   varč, rmei, roe_,
  { {0xa87900b5,0x78a10137,0x63a203e1,0x00000000}},	//   ֿאָר, _älvs, _econ,
  { {0x9327007e,0x7e6d054b,0x0519005d,0x00000000}},	//   _کران, _atap, _بياب_,
  { {0x63a20025,0xddc4003b,0x6838004c,0x00000000}},	//   _gcon, _otiţ, vídk,
  { {0x63bb054c,0xa2e40054,0x3f82054d,0x00000000}},	//   meun, _поїд, raku_,
  { {0x69c7054e,0x7bc6054f,0x63bb0550,0x00000000}},	//   _naje, _saku, leun,
  { {0x7bc60551,0x7e6d0552,0xa00a0021,0x00000000}},	//   _paku, _etap, _وقتل_,
  { {0x63bb0553,0x8c4304c3,0x69c70050,0x00000000}},	//   neun, весе, _aaje,
  { {0x69c700e3,0x62860554,0xf4120063,0x00000000}},	// [580] _baje, škov, דפן_,
  { {0x7bc60009,0xfe460086,0x68380555,0x00000000}},	//   _waku, _інно, mídi,
  { {0x7bc60556,0x1c4602d8,0x69c70557,0x00000000}},	//   _taku, _оном, _daje,
  { {0x63bb0558,0xd6d90022,0x3f80005f,0x00000000}},	//   jeun, _szła_, _jeiu_,
  { {0xa3e10235,0x63bb0559,0x6b84055a,0x00000000}},	//   दान_, deun, maig,
  { {0x6b840027,0x63a2055b,0x69c7055c,0x00000000}},	//   laig, _scon, _gaje,
  { {0xe9a3055d,0xf79a0044,0x9e49009a,0x00000000}},	//   _шарп, _ونسب_, הֲקִ,
  { {0x6b84018d,0x69c7055e,0x828a03d1,0x00000000}},	//   naig, _zaje, особ_,
  { {0x752d005b,0x27e6055f,0xdb1d0260,0x00000000}},	//   ğaza, mjon_, _kasá,
  { {0x6b840560,0x24f6047e,0x27e60561,0x00000000}},	//   haig, _очер, ljon_,
  { {0x20d3000d,0x2d830562,0x7e6d0479,0x00000000}},	//   віўс, vaje_, _stap,
  { {0x2d830035,0x68e30563,0x27e60564,0x00000000}},	//   waje_, ändi, njon_,
  { {0x6b840027,0xe46a0014,0x2d830565,0x00000000}},	//   daig, blöð_, taje_,
  { {0x2e360046,0x828b009a,0xdb1d0566,0x00000000}},	//   kæfu_, _וְהֶ, _nasá,
  { {0x6b840025,0xebc70001,0x2d830567,0x00000000}},	//   faig, мљан, raje_,
  { {0x2d830568,0xa0080021,0x25a9007d,0x00000000}},	//   saje_, _يقول_, đali_,
  { {0x7e6d0035,0x68380569,0x27e600ea,0x00000000}},	// [590] _utap, cídi, djon_,
  { {0x2fc9056a,0xdb1d056b,0x6815056c,0x00000000}},	//   _haag_, _casá, jądr,
  { {0x6b8400eb,0x61e700c7,0x321e0034,0x00000000}},	//   baig, öjli, inty_,
  { {0x69c70035,0xf7700021,0x6b84056d,0x00000000}},	//   _waje, لاه_, caig,
  { {0xdb1d056e,0x2fc9056f,0x69c70570,0x00000000}},	//   _ansö, _maag_, _taje,
  { {0x7a2b00bd,0x2fc90179,0xa594005a,0x00000000}},	//   hütz, _laag_, връщ,
  { {0x63bb03a8,0x2d810019,0xd4660330,0x00000000}},	//   teun, _mehe_, нище_,
  { {0xee3f0024,0x2d810019,0xdb1d0080,0x00000000}},	//   dtým_, _lehe_, _zasá,
  { {0xb06500fe,0xc6a40571,0x63bb0572,0x00000000}},	//   kyää, _архи, reun,
  { {0xdb040016,0xddc4017f,0x6b8400ea,0x00000000}},	//   nfiá, _otiš, zaig,
  { {0x83fc017f,0x27ed0573,0x86080044,0x00000000}},	//   _suđe, _koen_, _تقلق_,
  { {0x27ed0072,0xb5fd0574,0x321e0575,0x00000000}},	//   _joen_, _duše, anty_,
  { {0x79850089,0x92a7005e,0x6b840576,0x00000000}},	//   kahw, _цјел, vaig,
  { {0x27ff0185,0x62890025,0x68380577,0x00000000}},	//   _llun_, mseo, rídi,
  { {0x27ff01f7,0x62860578,0x6b840579,0x00000000}},	//   _olun_, škot, taig,
  { {0x27ed0031,0x6b840139,0x83fc0130,0x00000000}},	//   _noen_, uaig, _tuđe,
  { {0x6b84057a,0x64590035,0x6289057b,0x00000000}},	// [5a0] raig, _miwi, nseo,
  { {0x6b840027,0x2d81004d,0x6459057c,0x00000000}},	//   saig, _gehe_, _liwi,
  { {0x27ed002b,0xdb1d013d,0x6b84057d,0x00000000}},	//   _boen_, _vasá, paig,
  { {0xc6a60081,0xe108009a,0x08090044,0x00000000}},	//   ерки, וּנָ, وزني_,
  { {0x27ed0102,0x27e600ea,0xc0530047,0x00000000}},	//   _doen_, rjon_, אזא_,
  { {0x27e6057e,0x3e660013,0x7af60072,0x00000000}},	//   sjon_, _môt_, myyt,
  { {0x7af60072,0x62890360,0x64a3005e,0x00000000}},	//   lyyt, eseo, гаја,
  { {0x27ed0150,0x3447000d,0xa3d40062,0x00000000}},	//   _goen_, нчын_, тоич,
  { {0x6459001f,0x7af60072,0xe3af0044,0x00000000}},	//   _diwi, nyyt, صري_,
  { {0x2258007a,0x44ce0045,0x84e60076,0x00000000}},	//   örk_, _tę_, _позж,
  { {0x7a2b0199,0x5a170063,0x89970041,0x00000000}},	//   tütz, תקין_, עכטס_,
  { {0x6d5e002c,0x2d81004d,0xdcfc005f,0x00000000}},	//   _agpa, _sehe_, egrį,
  { {0x69dc057f,0x2fc900ca,0xb0650072,0x00000000}},	//   _onre, _vaag_, tyää,
  { {0xbf9b017d,0x2fc90104,0x30a60054,0x00000000}},	//   chên, _waag_, _зрив,
  { {0x11e90021,0x61f50580,0x2fc900be,0x00000000}},	//   _تعني_, özle, _taag_,
  { {0x69dc00bd,0xc1780078,0xdcfc0078,0x00000000}},	//   _anre, lbė_, agrį,
  { {0x5a350581,0x600c0063,0xd5b8008f,0x00000000}},	// [5b0] внат, _מִזְ, _ajām_,
  { {0x20fc0013,0x61fa0582,0xd6d90022,0x00000000}},	//   ỏi_, nktl, _szło_,
  { {0xdcfc001c,0x2e360583,0x61fa0137,0x00000000}},	//   parā, ræft_, iktl,
  { {0x69dc0584,0x6d450585,0xe7190021,0x00000000}},	//   _enre, _izha, ويات_,
  { {0x7bdd0586,0x02bc0042,0xb7f20042,0x00000000}},	//   _insu, ्टोन, _अकरम_,
  { {0x27e0003d,0x0c74007e,0xceb4009f,0x00000000}},	//   ķina_, _جدید, ריס_,
  { {0x27ed02b0,0xdb040026,0xf4b3007e,0x00000000}},	//   _toen_, leið, اشتگ,
  { {0x7bcd007a,0x6aad0035,0x62890019,0x00000000}},	//   ndau, otaf, tseo,
  { {0x2480017f,0x7c3a0164,0x6aad0587,0x00000000}},	//   ćima_, îtri, ntaf,
  { {0x929d0051,0x6aad0035,0x62890588,0x00000000}},	//   szło, itaf, rseo,
  { {0x62890589,0xa3e10053,0x7bdd058a,0x00000000}},	//   sseo, दाद_, _onsu,
  { {0x339b0032,0xdb040026,0x6289058b,0x00000000}},	//   _رخصة_, keið, pseo,
  { {0x7648024a,0x6d45058c,0x20fc008b,0x00000000}},	//   _yhdy, _azha, ải_,
  { {0x7bdd0089,0x7af600fe,0x8e59005e,0x00000000}},	//   _ansu, vyyt, ејсу_,
  { {0x201900cd,0x15f40053,0xbd83058d,0x00000000}},	//   èric_, _अवसर_, ргск,
  { {0x3e660164,0x20190003,0xdca3007b,0x00000000}},	//   _tôt_, érit_, јати,
  { {0x09fa0021,0x3205004c,0xab630094,0x00000000}},	// [5c0] وفرة_, ohly_, рвул,
  { {0xfe9b014e,0x7bdd04bc,0x7bcd001f,0x00000000}},	//   _קיימ, _ensu, adau,
  { {0x7af600fe,0x7e6400fe,0x18a6026c,0x00000000}},	//   syyt, _huip, таем,
  { {0x66010019,0xdb040026,0x765a058e,0x00000000}},	//   _allk, beið, _sity,
  { {0xc1780006,0xf62a0086,0xc7a3058f,0x00000000}},	//   ybė_, міки_, ричк,
  { {0x68380016,0x69dc0359,0x9633000d,0x00000000}},	//   vídu, _unre, аніц,
  { {0x7e640104,0xafdb01e1,0x48e30590,0x00000000}},	//   _luip, lløe, _корв,
  { {0xdcfe007d,0xccf3009a,0xa7da0044,0x00000000}},	//   _nepč, שכה_, _تورط_,
  { {0x2a660025,0xe7370121,0xd4030591,0x00000000}},	//   íobh_, _ает_, рящи,
  { {0x32050592,0xa9b8014b,0x88ca009d,0x00000000}},	//   ghly_, дзiр, ֵמָ֖,
  { {0xbb1b000c,0xa99b0047,0x6838017d,0x00000000}},	//   _neîn, וביר, sídu,
  { {0xc0580088,0xdfd10593,0x3205017c,0x00000000}},	//   кія_, حيح_, ahly_,
  { {0xa294000d,0x82fa005d,0x92940092,0x00000000}},	//   _салі, _تراز_, _салц,
  { {0x2731008b,0xdb040014,0x32050594,0x00000000}},	//   ỡng_, veið, chly_,
  { {0xab950193,0xde580086,0xdcfc003b,0x00000000}},	//   ливі, тарі_, vară,
  { {0x6aad0595,0x6d4500a8,0xb5fd0596,0x00000000}},	//   ttaf, _vzha, _muša,
  { {0xab840597,0x7bcd0598,0x6aad0035,0x00000000}},	// [5d0] руск, rdau, utaf,
  { {0xdb04007a,0x66180599,0xd91b0076,0x00000000}},	//   reið, jivk, мье_,
  { {0x67d5000a,0x4426059a,0x5887000d,0x00000000}},	//   ложу, _ojo_, тыза,
  { {0xc7940088,0x442600c3,0x7bdd059b,0x00000000}},	//   аршы, _njo_, _unsu,
  { {0xd639000d,0x7cfc0072,0x4b7a0132,0x00000000}},	//   някі_, pärö, _ראשו,
  { {0x68e300c7,0xa2b80161,0xd12603eb,0x00000000}},	//   änds, ्बन्, _هم_,
  { {0x64b50021,0x2019059c,0x60060046,0x00000000}},	//   احتر, kisi_, _hóme,
  { {0x2019005b,0xb5fd059d,0x42c90363,0x00000000}},	//   jisi_, _duša, егин_,
  { {0x2019059e,0x3205059f,0xdb0f004c,0x00000000}},	//   disi_, thly_, _obcí,
  { {0x2019004b,0x3f9e0078,0x60e905a0,0x00000000}},	//   eisi_, ėtum_, емом_,
  { {0xafdb00b9,0x7c2900b2,0xfbdf002b,0x00000000}},	//   dløb, čerj, _phêl_,
  { {0xbb1b000c,0xdee605a1,0x320500e5,0x00000000}},	//   _reîn, гоми, shly_,
  { {0x443f05a2,0x201900cd,0x2cba0150,0x00000000}},	//   mlu_, èria_, _sppd_,
  { {0x22920021,0x201905a3,0x91e20002,0x00000000}},	//   _الوس, érir_, _гоше,
  { {0x201905a4,0xafdb05a5,0x443f05a6,0x00000000}},	//   bisi_, rmør, olu_,
  { {0x3ec900fe,0x201905a7,0xeb9f000e,0x00000000}},	//   ättä_, cisi_, _smør_,
  { {0x8eb3007e,0x8c430189,0x62950051,0x00000000}},	// [5e0] _هميش, сете, ązow,
  { {0x7a30004d,0x443f05a8,0x99860044,0x00000000}},	//   lätz, hlu_, الاو,
  { {0x3ea205a9,0x3ce50137,0x443f05aa,0x00000000}},	//   lukt_, älvt_, klu_,
  { {0xdc9b0063,0x443f007d,0xad1b0047,0x00000000}},	//   _איטל, jlu_, _טויר,
  { {0x443f0185,0x68e300c7,0x600605ab,0x00000000}},	//   dlu_, ändr, _góme,
  { {0x7a3000bd,0x629b0006,0x7c24000c,0x00000000}},	//   hätz, druo, lnir,
  { {0x2955011c,0x2480007d,0xd49705ac,0x00000000}},	//   _вътр, ćimo_, гры_,
  { {0x68e305ad,0x69ce05ae,0x443f05af,0x00000000}},	//   ånde, _habe, glu_,
  { {0x2d8a05b0,0x201905b1,0x629b0078,0x00000000}},	//   kabe_, visi_, gruo,
  { {0x32b70021,0x443f05b2,0x201905b3,0x00000000}},	//   ادية_, alu_, wisi_,
  { {0x69ce05b4,0xaa370047,0x629b05b5,0x00000000}},	//   _mabe, רטיק_, aruo,
  { {0x7c24017f,0x69ce05b6,0x20190150,0x00000000}},	//   jnir, _labe, uisi_,
  { {0xa3e10053,0x743b0047,0xb5fd00a8,0x00000000}},	//   दार_, _װעגװ, _mušn,
  { {0x20190357,0x7c2405b7,0x2fcd007d,0x00000000}},	//   sisi_, enir, žeg_,
  { {0xafdb00b9,0x02170063,0x201905b8,0x00000000}},	//   rløb, _תחום_, pisi_,
  { {0xfbdf00aa,0x69ce05b9,0x38ae0014,0x00000000}},	//   _thêm_, _aabe, dýr_,
  { {0x7c280164,0x60dc00b9,0x44240025,0x00000000}},	// [5f0] édra, ærmf, inm_,
  { {0x69ce05ba,0xceb40047,0x443f05bb,0x00000000}},	//   _cabe, _היץ_, zlu_,
  { {0x69ce0199,0x7a300072,0x443f05bc,0x00000000}},	//   _dabe, näty, ylu_,
  { {0x8d74006a,0x7c24003b,0x629b0078,0x00000000}},	//   _پایا, cnir, yruo,
  { {0x68e30093,0x66e505bd,0x69ce05be,0x00000000}},	//   åndb, рола, _fabe,
  { {0x44a50021,0x69ce05bf,0x644005c0,0x00000000}},	//   لمتق, _gabe, elmi,
  { {0xfdf80063,0x443f05c1,0x7bcf0089,0x00000000}},	//   רצות_, tlu_, _kacu,
  { {0x7a300072,0x7bcf05c2,0x69ce05c3,0x00000000}},	//   däty, _jacu, _zabe,
  { {0x443f0397,0x020500e1,0xf3490062,0x00000000}},	//   rlu_, изин, ъпил_,
  { {0x443f05c4,0x6440003a,0x51550121,0x00000000}},	//   slu_, almi, итну,
  { {0xd00a05c5,0x443f05c6,0x629b0050,0x00000000}},	//   вене_, plu_, sruo,
  { {0x2d8a002c,0xdcfe001c,0x78ba0137,0x00000000}},	//   wabe_, _nepā, _ätve,
  { {0x629d00ea,0x79950051,0x91e505c7,0x00000000}},	//   ásod, _odzw, _воле,
  { {0x44d50418,0x7a300199,0x3ea205c8,0x00000000}},	//   _kā_, sätz, rukt_,
  { {0x2d8a05c9,0x6b66011c,0x44d5001c,0x00000000}},	//   rabe_, иква, _jā_,
  { {0x69ce05ca,0x8b260141,0x9e6601ce,0x00000000}},	//   _sabe, адбе, _квид,
  { {0x78bc0599,0x7c2405cb,0xcb000053,0x00000000}},	// [600] _sprv, rnir, लैंड_,
  { {0x7e7600a4,0x0b5902dc,0x7c2400dd,0x00000000}},	//   _ityp, урсы_, snir,
  { {0xa7660079,0x44c700ea,0x61ee004b,0x00000000}},	//   акед, _nő_, öbli,
  { {0x69ce05cc,0xb5fd007d,0xf0b60047,0x00000000}},	//   _wabe, _bušo, ילער_,
  { {0x7bc4003b,0x69ce05cd,0x16a705ce,0x00000000}},	//   meiu, _tabe, ивци_,
  { {0xa613019d,0x96f7000a,0x2888005d,0x00000000}},	//   оміч, решт_, _مصری_,
  { {0x291e0137,0x628200e5,0x68d50062,0x00000000}},	//   _äta_, _swoo, _лютф,
  { {0xf3f8008f,0x39470058,0x07a305cf,0x00000000}},	//   _kuģi_, ünse_, _масн,
  { {0x52140055,0x41e6000d,0x3f8b007d,0x00000000}},	//   йдит, аіна, vacu_,
  { {0x44c700ea,0x717805ac,0x7a300050,0x00000000}},	//   _fő_, ыбор_, täty,
  { {0xf993014e,0x6aa4006f,0xbb1b003b,0x00000000}},	//   חרת_, huif, _reîm,
  { {0xdb1d00ea,0xa2b80053,0x7a300072,0x00000000}},	//   _vasú, ्बद्, räty,
  { {0x7a300072,0x88570041,0x7bcf05d0,0x00000000}},	//   säty, ישטע_, _racu,
  { {0x2723008b,0x7bcf05d1,0x8233009b,0x00000000}},	//   ằng_, _sacu, _وروا,
  { {0x4094043b,0x4c940076,0x7bcf0052,0x00000000}},	//   _البر, жисс, _pacu,
  { {0x3ced007d,0x27230066,0x515b0063,0x00000000}},	//   ćev_, nčnú_, _בכוו,
  { {0x2012006f,0x996705d2,0x1a5b0021,0x00000000}},	// [610] ëzie_, ател, نشطة_,
  { {0x2b85008b,0xac9501ce,0x0357009a,0x00000000}},	//   ặc_, _лаош, שימש_,
  { {0x6d5a0078,0x27230066,0x7bcf05d3,0x00000000}},	//   žtar, kčnú_, _tacu,
  { {0xf7f4007e,0x7bc4003b,0x6e880043,0x00000000}},	//   يسند, ceiu, _حنیف_,
  { {0xa3ea0235,0xd6d90045,0x6b8d004b,0x00000000}},	//   मान_, _była_, maag,
  { {0x85780062,0x99910022,0x6b8d05d4,0x00000000}},	//   асът_, żały_, laag,
  { {0x69c50019,0x18a4000d,0xcd980063,0x00000000}},	//   mehe, _маём, בדות_,
  { {0x69c50004,0x68f80137,0xe45f004b,0x00000000}},	//   lehe, ävde, öö_,
  { {0x6032001c,0x600605d5,0xe299005e,0x00000000}},	//   lāmg, _nóma, ћао_,
  { {0x44d5003d,0x9f590139,0x69c505d6,0x00000000}},	//   _tā_, bhsú_, nehe,
  { {0x3f8905d7,0x629d027d,0xa3d70053,0x00000000}},	//   _beau_, ásob, ायद_,
  { {0x69c500bd,0x6b8d006f,0xdcfe003b,0x00000000}},	//   hehe, jaag, _lepă,
  { {0x69c505d8,0x63a905d9,0x6b8d0229,0x00000000}},	//   kehe, mgen, daag,
  { {0x3f9e005b,0x63a905da,0xdcfe003b,0x00000000}},	//   ştu_, lgen, _nepă,
  { {0x61e305db,0xddcd000c,0x61fc05dc,0x00000000}},	//   _innl, _staţ, örle,
  { {0x60dc05dd,0x63a905de,0xb09a0047,0x00000000}},	//   ærme, ngen, _עיפר,
  { {0xfe720032,0x63a905df,0x6da605e0,0x00000000}},	// [620] _عدة_, igen, _липа,
  { {0x200200fe,0x69c505e1,0x443d004d,0x00000000}},	//   lkki_, gehe, _lkw_,
  { {0xa3d70161,0x395c00c7,0xdcfe000c,0x00000000}},	//   ाया_, ävs_, _depă,
  { {0x2002024a,0xa6e9001b,0x63a9006f,0x00000000}},	//   nkki_, _trự, jgen,
  { {0xadec0394,0x69c505e2,0xddcd003b,0x00000000}},	//   ञापन_, behe, _utaţ,
  { {0x63a905e3,0x6032001c,0x47330086,0x00000000}},	//   egen, lāmd, чніс,
  { {0x7d7b0047,0x63a905e4,0x18a3000d,0x00000000}},	//   אנצו, fgen, _нарм,
  { {0x3a3a01e3,0x63a905e5,0x68150051,0x00000000}},	//   lopp_, ggen, ządz,
  { {0xfbd30063,0x443d00be,0x4254009b,0x00000000}},	//   לתה_, _dkw_, ينبر,
  { {0x63a905e6,0x60060090,0x3f89006c,0x00000000}},	//   agen, _róma, _seau_,
  { {0x3f890164,0x660805e7,0x60060046,0x00000000}},	//   _peau_, _ildk, _sóma,
  { {0x82a6047e,0x61e300d1,0x443d05e8,0x00000000}},	//   _гадж, _ennl, _gkw_,
  { {0x60dc0146,0x3f890003,0xddcd00a8,0x00000000}},	//   ærmb, _veau_, _ataš,
  { {0xddcd0051,0x6b8d05e9,0xcd740062,0x00000000}},	//   _uważ, waag, згръ,
  { {0xf0b7007e,0x321e05ea,0x1df80121,0x00000000}},	//   _هايش_, mity_, щеры_,
  { {0x321e05eb,0x600605ec,0x68150022,0x00000000}},	//   lity_, _tóma, sądz,
  { {0x6b8d016d,0x69c505ed,0xeab00021,0x00000000}},	// [630] raag, tehe, فعل_,
  { {0x996705ee,0xddab05ef,0x321e05f0,0x00000000}},	//   стал, _стил_, nity_,
  { {0x69c50400,0x321e0072,0x094b05f1,0x00000000}},	//   rehe, iity_, учаи_,
  { {0xb8f10235,0x69c50199,0xad1a0063,0x00000000}},	//   _वन_, sehe, _כותר,
  { {0xcf940047,0xe739005e,0xa0260072,0x00000000}},	//   פטס_, јел_, ltöä,
  { {0x2009001f,0x60160130,0x75d500de,0x00000000}},	//   _llai_, ršmi, زيعا,
  { {0x20020026,0x63a903ac,0xa0260072,0x00000000}},	//   ykki_, tgen, ntöä,
  { {0xdb0d006d,0x63a905f2,0x320c004c,0x00000000}},	//   leañ, ugen, ehdy_,
  { {0x63a905f3,0x4209005e,0x23290193,0x00000000}},	//   rgen, инио_, ропи_,
  { {0xb5fd017f,0x31250076,0x6232005e,0x00000000}},	//   _mušk, ждог, мењу,
  { {0x443d0150,0x63a9006f,0xd4980092,0x00000000}},	//   _tkw_, pgen, _грч_,
  { {0xa3ea0053,0x2056000d,0xb4d50053,0x00000000}},	//   माण_, ўтор, िटी_,
  { {0x2002024a,0xce4a05f4,0x321e05f5,0x00000000}},	//   rkki_, изме_, bity_,
  { {0x2738001b,0x321e05f6,0x27e0001c,0x00000000}},	//   ứng_, city_, ķini_,
  { {0xdbc7007a,0xed5a05f7,0x3e6f004b,0x00000000}},	//   töðu, ров_, _eüt_,
  { {0xcb670062,0x1c4601dd,0x2004008f,0x00000000}},	//   жате_, інам, ījis_,
  { {0xdbc70026,0x3a3a05f8,0x00000000,0x00000000}},	// [640] röðu, topp_,   ,
  { {0x497a0088,0x718c0047,0x68fe0244,0x00000000}},	//   рсаў_, ָװאַ, typd,
  { {0xd6d90045,0x3a3a00df,0x00000000,0x00000000}},	//   _było_, ropp_,   ,
  { {0x321e0195,0x6e3c0244,0x386d011b,0x00000000}},	//   zity_, lorb, _čert_,
  { {0x6e3c0179,0x62860080,0x2441017c,0x00000000}},	//   oorb, škoz, nómu_,
  { {0x2ba80053,0xd49a05f9,0x321e00e5,0x00000000}},	//   गलवा, ари_, xity_,
  { {0x25a001f7,0x1db20053,0x321e05fa,0x00000000}},	//   ğil_, _जानत, vity_,
  { {0x6e3c0025,0x18670002,0x25a0005b,0x00000000}},	//   horb, _фати_, şil_,
  { {0x6ab60045,0x2489007d,0x320c002b,0x00000000}},	//   ntyf, ćama_, thdy_,
  { {0x6acb009a,0x3abb009d,0xa57300de,0x00000000}},	//   בֶטַ, סמינ, _يُقت,
  { {0x104b0055,0xb3ca05fb,0x321e05fc,0x00000000}},	//   иями_, _влез_, rity_,
  { {0x321e0034,0xdb2101c8,0x8f3505fd,0x00000000}},	//   sity_, _štíh, земц,
  { {0x6e3c0205,0x1439007e,0xa3d70053,0x00000000}},	//   forb, _اينک_, ायर_,
  { {0x6e3c02f5,0x40940044,0x00000000,0x00000000}},	//   gorb, _فلتر,   ,
  { {0x317b0063,0x3174056c,0x59d50082,0x00000000}},	//   _דרומ, ądzą_, _डोगर,
  { {0x80c70053,0x7e7d05fe,0xb5fd05ff,0x00000000}},	//   ़बरे, ppsp, _pušk,
  { {0xf96b0363,0x6e3c0600,0x00000000,0x00000000}},	// [650] арей_, borb,   ,
  { {0x527b00b5,0xa2b20053,0x600d006c,0x00000000}},	//   ינמא, _आमन्, _dûme,
  { {0x81bc001c,0x602400ea,0x18a40086,0x00000000}},	//   tnēj, sőme, даєм,
  { {0x2d91017f,0x61f801f2,0x600d0003,0x00000000}},	//   laze_, _lovl, _fûme,
  { {0xeb760047,0x76c70049,0x501c009a,0x00000000}},	//   _מערץ_, تغال, סודו,
  { {0xe6180086,0x19a80601,0x2d910602,0x00000000}},	//   оді_, _мтсп_, naze_,
  { {0x7e6d0509,0xf5050603,0xd4d90085,0x00000000}},	//   _luap, язко, сьлі_,
  { {0x60060066,0x69d50604,0xb5fd0605,0x00000000}},	//   _rómo, _haze, _muši,
  { {0x69d50606,0x29ff0051,0x2d910607,0x00000000}},	//   _kaze, ałań_, kaze_,
  { {0x11d50032,0xddc4017f,0x69d50608,0x00000000}},	//   ستخد, _stiž, _jaze,
  { {0x38b50609,0x61fc0137,0xcea90149,0x00000000}},	//   når_, örla, _תי_,
  { {0x6e3c00bd,0x69d5060a,0xafdb01e1,0x00000000}},	//   worb, _laze, lløj,
  { {0x63bb060b,0xdb1d006d,0x932701fb,0x00000000}},	//   mfun, _masó, _بران,
  { {0x2d8c03d9,0xa2f60063,0x38b502c0,0x00000000}},	//   úde_, _ממנה_, kår_,
  { {0xe166007e,0x6142060c,0x1d07060d,0x00000000}},	//   _عضوی, _пеша, пери_,
  { {0xc4d200b5,0xbc63060e,0xd2ef005e,0x00000000}},	//   עגן_, евск, _пoдр,
  { {0x2fc000bb,0x63bb0035,0x02b60047,0x00000000}},	// [660] _ibig_, ifun, ּלעך_,
  { {0xa3e20053,0x4a43060f,0x6ab60051,0x00000000}},	//   _फोन_, енув, rtyf,
  { {0xa967005a,0x63bb0610,0x38b50611,0x00000000}},	//   чиха_, kfun, går_,
  { {0xde6d008b,0x46ea0612,0x83fc007d,0x00000000}},	//   _hươn, йден_, _tuđi,
  { {0x69d503d9,0x073a0032,0x6d40005b,0x00000000}},	//   _faze, حساب_, şmad,
  { {0x69d50613,0x6b84004d,0x63bb0614,0x00000000}},	//   _gaze, lbig, efun,
  { {0xdb0f03b2,0xdb1d00cd,0x2d8500ea,0x00000000}},	//   _accè, _absè, űleg_,
  { {0xde6d008b,0x02a60615,0x929d0022,0x00000000}},	//   _lươn, пром, zyłe,
  { {0x6b84002c,0x61f802e2,0x6aa40616,0x00000000}},	//   ibig, _povl, nrif,
  { {0x27e0003d,0x9098000a,0xdb0d017d,0x00000000}},	//   ķinu_, овот_, sfaç,
  { {0x2ee0003e,0x6aa40617,0x63bb0618,0x00000000}},	//   _arif_, hrif, bfun,
  { {0xe45a0619,0x2ee0001f,0x38a0003b,0x00000000}},	//   _уже_, _brif_, mără_,
  { {0xf206011c,0xeb9f00b9,0x2d910066,0x00000000}},	//   _няко, _fløj_, taze_,
  { {0x9c83061a,0x6aa4061b,0x32050034,0x00000000}},	//   účov, drif, ckly_,
  { {0xde6d008b,0xc1bb0063,0x2d91061c,0x00000000}},	//   _dươn, _המוש, raze_,
  { {0x6aa40185,0x6b8400bb,0xdfd10049,0x00000000}},	//   frif, gbig, _شيخ_,
  { {0x6aa4061d,0x8f9c0063,0x69d5001c,0x00000000}},	// [670] grif, _היחי, _paze,
  { {0x6b84061e,0xde6d008b,0x6f0f005b,0x00000000}},	//   abig, _gươn, ıncı,
  { {0x6032003d,0x799c001f,0xe3c70006,0x00000000}},	//   lāma, _ddrw, ščių_,
  { {0x38b5061f,0x290f0051,0x6aa40620,0x00000000}},	//   rår_, ąga_, brif,
  { {0x290702e2,0x16a90086,0xdb04017d,0x00000000}},	//   šna_, івки_, rgiã,
  { {0x45d20001,0x38b50137,0x68e100ea,0x00000000}},	//   вољс, pår_, _áldo,
  { {0x2489017f,0x63bb0621,0x7c2d0622,0x00000000}},	//   ćamo_, tfun, onar,
  { {0xdb0f0623,0x63bb0035,0x13090065,0x00000000}},	//   _accé, ufun, жний_,
  { {0x2d9e0026,0x35b5005e,0x63bb0624,0x00000000}},	//   ótek_, _обар, rfun,
  { {0x3eab0625,0xaa7b0066,0x63bb0246,0x00000000}},	//   duct_, _zrýc, sfun,
  { {0x7c2d0626,0x33b50121,0xc6090053,0x00000000}},	//   knar, _жёлт, वसीय_,
  { {0x2ee00185,0xde6d0013,0x001a0085,0x00000000}},	//   _prif_, _sươn, іўны_,
  { {0x64490627,0x7c2d00c3,0xa3ea0053,0x00000000}},	//   mlei, dnar, मार_,
  { {0x442d0628,0x7c2d0629,0x3f820051,0x00000000}},	//   lne_, enar, dłuż_,
  { {0x442d062a,0x3eb90122,0x9e63041d,0x00000000}},	//   one_, atst_, тврд,
  { {0x442d062b,0x443f062c,0x6449062d,0x00000000}},	//   nne_, nou_, nlei,
  { {0x442d062e,0xde6d001b,0x8c43036a,0x00000000}},	// [680] ine_, _tươn, тете,
  { {0x2b8c001b,0x6449062f,0x2eff004d,0x00000000}},	//   ếc_, hlei, äufe_,
  { {0x442d0630,0x6b8400a4,0xe947007e,0x00000000}},	//   kne_, pbig, ورمی,
  { {0x798e021f,0x442d0631,0x443f0632,0x00000000}},	//   _webw, jne_, jou_,
  { {0x7c240332,0x629d00ea,0xb865007e,0x00000000}},	//   miir, ásol, رامو,
  { {0x44ce0080,0x442d0633,0x64490634,0x00000000}},	//   _př_, ene_, elei,
  { {0x3e7400c7,0x55e30635,0x94aa0636,0x00000000}},	//   _lät_, тојб, ітка_,
  { {0x443f0016,0x442d0637,0x68e30146,0x00000000}},	//   gou_, gne_, ænde,
  { {0x61fc0137,0x3e740137,0x00000000,0x00000000}},	//   örlo, _nät_,   ,
  { {0x60dc00b9,0x442d0638,0xf12601d5,0x00000000}},	//   ærmo, ane_, дьмо,
  { {0x8506006a,0x64490639,0x443f063a,0x00000000}},	//   _توان, blei, bou_,
  { {0x443f063b,0x6032008f,0x628000a5,0x00000000}},	//   cou_, tāma, ppmo,
  { {0x64400006,0x4424063c,0xdefb000d,0x00000000}},	//   momi, mim_, цын_,
  { {0x6032001c,0x6440063d,0x4424063e,0x00000000}},	//   rāma, lomi, lim_,
  { {0x6440004b,0x7c2d063f,0x6032008f,0x00000000}},	//   oomi, tnar, sāma,
  { {0x44240640,0x64400641,0x7c2d0642,0x00000000}},	//   nim_, nomi, unar,
  { {0x7c2d0643,0xcd040080,0x8fa40001,0x00000000}},	// [690] rnar, vněž_, _рање,
  { {0x443f0644,0x44240645,0x442d0646,0x00000000}},	//   zou_, him_, zne_,
  { {0x39470146,0x5a44000d,0x64400647,0x00000000}},	//   æns_, тэта, komi,
  { {0x443f0016,0x64400006,0x27e9006d,0x00000000}},	//   xou_, jomi, ñan_,
  { {0x443f027d,0x7bcd0003,0x442d0648,0x00000000}},	//   vou_, meau, vne_,
  { {0x442d0045,0x9f5900c7,0x44240649,0x00000000}},	//   wne_, ckså_, eim_,
  { {0xe3b10032,0x60060025,0x443f064a,0x00000000}},	//   هرة_, _fómh, tou_,
  { {0x442d0529,0x645b0035,0x36d5064b,0x00000000}},	//   une_, umui, _побр,
  { {0x6449064c,0x442d064d,0x645b064e,0x00000000}},	//   rlei, rne_, rmui,
  { {0xe1f10032,0x442d064f,0x443f0650,0x00000000}},	//   اسة_, sne_, sou_,
  { {0x2c750137,0x65940651,0x44240652,0x00000000}},	//   _nåd_, _раху, bim_,
  { {0x44240631,0x64400653,0x61ea0654,0x00000000}},	//   cim_, comi, _enfl,
  { {0x2ac3001c,0x7bcd0655,0xdd020066,0x00000000}},	//   nībā_, deau, ľuču,
  { {0x2d9e0164,0xa3d70053,0xb5fd007d,0x00000000}},	//   ûte_, ायक_, _gušt,
  { {0xd00a0001,0x7c240656,0xa3b60042,0x00000000}},	//   _неке_, tiir, _जाम_,
  { {0x7bcd0657,0x3e7400a5,0x711a009a,0x00000000}},	//   geau, _tät_, _מוצפ,
  { {0xf4120047,0x60060658,0x1f660086,0x00000000}},	// [6a0] אפן_, _rómh, _яким,
  { {0x7c240659,0xed5a005e,0x4424065a,0x00000000}},	//   siir, _ноп_, zim_,
  { {0x4424005b,0x1bea065b,0x7c24065c,0x00000000}},	//   yim_, _едни_, piir,
  { {0x4424065d,0x7bcd006c,0x7d01065e,0x00000000}},	//   xim_, ceau, älse,
  { {0x4424065f,0x6006006d,0xdb060244,0x00000000}},	//   vim_, _cómi, _abkö,
  { {0x4424001f,0x999a0022,0x600605ec,0x00000000}},	//   wim_, żyły_, _dómi,
  { {0x7c2f0025,0x44240660,0x81bc001c,0x00000000}},	//   _áirí, tim_, inēt,
  { {0xd4670138,0x644000fe,0xb5fd007d,0x00000000}},	//   није_, uomi, _sušt,
  { {0x07b70032,0x44240661,0x2ac3001c,0x00000000}},	//   _سهلة_, rim_, cībā_,
  { {0x44240662,0x64400663,0x6613056c,0x00000000}},	//   sim_, somi, ądkó,
  { {0x44240664,0xe9f90013,0x64400665,0x00000000}},	//   pim_, huế_, pomi,
  { {0x929d0045,0x2c750666,0x28970063,0x00000000}},	//   syła, _råd_, עדכן_,
  { {0x7bcd0667,0xb5fd0078,0x93fb0063,0x00000000}},	//   veau, _tušt, _מלאי,
  { {0x91e3005e,0x81bc008f,0xaa7b0014,0x00000000}},	//   _боље, gnēt, _brýn,
  { {0x7bcd0668,0x2ac3008f,0x8c250044,0x00000000}},	//   teau, zībā_, نفسه,
  { {0x7c84000a,0x59c60042,0xdbf2004c,0x00000000}},	//   ѓусе, _रॉबर, třás,
  { {0x7bcd0669,0x49cb05ac,0x7b740021,0x00000000}},	// [6b0] reau, зуем_, اطفا,
  { {0x7bcd066a,0x6d41066b,0x1a65005d,0x00000000}},	//   seau, ülas, ئیسی_,
  { {0x48ab066c,0x5d550095,0x7bcd066d,0x00000000}},	//   ятам_, _шкот, peau,
  { {0xfbab0055,0x629d000f,0x200b0080,0x00000000}},	//   _этой_, ások, nkci_,
  { {0x79a700e1,0xc66b0121,0xe56e0141,0x00000000}},	//   _прве, чшее_, из_,
  { {0x2ac3001c,0xb5fd0078,0x60060331,0x00000000}},	//   rībā_, _aušr, _vómi,
  { {0x2ac3008f,0xda34066e,0x69c10042,0x00000000}},	//   sībā_, _серы, र्णी,
  { {0x73e5066f,0x00000000,0x00000000,0x00000000}},	//   тоиз,   ,   ,
  { {0x961d008f,0x27ed0670,0xe3b1005d,0x00000000}},	//   _atņe, _inen_, هرک_,
  { {0x96df0088,0x85b8018e,0xd5d40044,0x00000000}},	//   _нiву_, _плус_, _متمث,
  { {0x76430671,0x21690002,0x93b502d8,0x00000000}},	//   mony, ќини_, _абец,
  { {0x7d070051,0x27ed004d,0x76430672,0x00000000}},	//   dyjs, _jnen_, lony,
  { {0x93940021,0x441a00ff,0x6024013d,0x00000000}},	//   _إجما, _קונס, sőmo,
  { {0x76430673,0x6f060022,0xed5a01ce,0x00000000}},	//   nony, rykc, дог_,
  { {0xdcfc003d,0xdde400ea,0x629b0078,0x00000000}},	//   varē, ésőb, lsuo,
  { {0xd1640062,0x27ff00e5,0x76430674,0x00000000}},	//   _съчи, _noun_, hony,
  { {0xee3a0675,0xab270676,0xab66066c,0x00000000}},	// [6c0] _они_, вота_, твал,
  { {0x48e60001,0x7d01004d,0x27ed04aa,0x00000000}},	//   козв, älsc, _anen_,
  { {0x2d980677,0x7d070022,0x76430678,0x00000000}},	//   mare_, cyjs, dony,
  { {0x661d0006,0x2d980679,0x8b26000d,0x00000000}},	//   _įska, lare_, _адме,
  { {0x2d98003b,0x7643002b,0x4b550094,0x00000000}},	//   oare_, fony, _бърт,
  { {0x2d98067a,0x8f1b0063,0xceb50041,0x00000000}},	//   nare_, וונת, ריװ_,
  { {0xd5e9008b,0x6d480058,0x4c9b009d,0x00000000}},	//   _qué, üdah, ֵ֑הו,
  { {0x6459067b,0x98360088,0x2000000c,0x00000000}},	//   _chwi, _рэгі, _noii_,
  { {0x69dc067c,0x20d30529,0x2d9801e3,0x00000000}},	//   _kare, _aţi_, kare_,
  { {0x69dc02b0,0x76430051,0x69de067d,0x00000000}},	//   _jare, cony, ndpe,
  { {0x2d98067e,0x50f3000d,0x69dc067f,0x00000000}},	//   dare_, азэт, _mare,
  { {0x69dc0680,0x03a302b6,0x2d930681,0x00000000}},	//   _lare, _вицо, _sexe_,
  { {0x63a20682,0xdcf5003d,0x4ea7005a,0x00000000}},	//   _idon, pazī, ърна,
  { {0x2d98067e,0x69dc01a6,0xc0aa00b3,0x00000000}},	//   gare_, _nare, _قابل_,
  { {0x6d400683,0x7ae60684,0x2000003b,0x00000000}},	//   şman, _arkt, _foii_,
  { {0xec340685,0x7d070051,0x76430686,0x00000000}},	//   ансь, ryjs, zony,
  { {0x7d070051,0x69de006f,0x2d980687,0x00000000}},	// [6d0] syjs, fdpe, bare_,
  { {0x2d980688,0x69dc0689,0x3f99068a,0x00000000}},	//   care_, _care, lasu_,
  { {0x63a2068b,0x7ae6068c,0x7c300014,0x00000000}},	//   _odon, _erkt, ðirð,
  { {0xac190086,0xc7c40121,0xafdb05e7,0x00000000}},	//   _чому_, исчи, mløs,
  { {0x07a40088,0x7c3a000f,0xf77003eb,0x00000000}},	//   раін, étre, زان_,
  { {0x62720051,0x76430035,0x63a2068d,0x00000000}},	//   _młod, uony, _adon,
  { {0x62820250,0x7bdd068e,0x5e580047,0x00000000}},	//   _atoo, _kasu, דיגע_,
  { {0x2d980529,0x27ed068f,0x3f99007d,0x00000000}},	//   zare_, _unen_, jasu_,
  { {0x3f99001f,0x7bdd035d,0x36d40690,0x00000000}},	//   dasu_, _masu, _котр,
  { {0x2d98000c,0x8185000d,0x386d0691,0x00000000}},	//   xare_, ыгож, _hier_,
  { {0x2d980692,0x63ae0025,0x9848003b,0x00000000}},	//   vare_, áiné, _uşă_,
  { {0x7bdd0693,0xafdb05b9,0x2d980694,0x00000000}},	//   _nasu, dløs, ware_,
  { {0x7e600122,0x765a00fe,0x69de00ac,0x00000000}},	//   ïmpo, _yhty, ydpe,
  { {0xb7c2001c,0x386d0695,0x60060331,0x00000000}},	//   ēģin, _lier_, _rómu,
  { {0x2d9803f2,0x7bdd0696,0x69dc0697,0x00000000}},	//   rare_, _basu, _rare,
  { {0x69dc0698,0x44e301f7,0x59c60053,0x00000000}},	//   _sare, _mı_, र्नर,
  { {0x2d9803f2,0x44e30058,0xdee60699,0x00000000}},	// [6e0] pare_, _lı_, _сопи,
  { {0xeef7069a,0x3d07013d,0x38bc0046,0x00000000}},	//   _עמיר_, ívvá_, tír_,
  { {0x3ea000d1,0x44e3005b,0x61fc069b,0x00000000}},	//   _hvit_, _nı_, örli,
  { {0xe73a0055,0x3ea0069c,0xb8dc0053,0x00000000}},	//   нее_, _kvit_, _आम_,
  { {0xc7a3005a,0x386d0179,0x69dc069d,0x00000000}},	//   сичк, _dier_, _tare,
  { {0x386d069e,0x799505e4,0xc4da005e,0x00000000}},	//   _eier_, _gezw, еђи_,
  { {0x6282015e,0x68e3069f,0x7ae406a0,0x00000000}},	//   _stoo, åndt, lvit,
  { {0x28030080,0x79950051,0x7ae406a1,0x00000000}},	//   ěrná_, _zezw, ovit,
  { {0x7ae406a2,0x7bc40290,0x660106a3,0x00000000}},	//   nvit, ifiu, _folk,
  { {0x660100f3,0xddcd0080,0x7e60006f,0x00000000}},	//   _golk, _staž, ïmpl,
  { {0xddcd000c,0x463b00b5,0x5ff505fb,0x00000000}},	//   _luaţ, _טעמע, азну,
  { {0x63a20035,0x66010089,0xb84a000d,0x00000000}},	//   _udon, _zolk, млiв,
  { {0x7bdd0397,0x6d4001f7,0xcf270021,0x00000000}},	//   _rasu, şmal, ارجي,
  { {0xd2b7014e,0x2731001b,0x44e3005b,0x00000000}},	//   _עלות_, ạng_, _yı_,
  { {0xdb0d0025,0x7bdd06a4,0x62720022,0x00000000}},	//   rgaí, _pasu, _włod,
  { {0x60060014,0xafdb05e7,0x60c5004b,0x00000000}},	//   _dóms, rløs, _ähma,
  { {0x7ac7000d,0xafdb06a5,0xdcfc0078,0x00000000}},	// [6f0] ысве, sløs, karė,
  { {0x386d0031,0xafdb02ab,0xdb160026,0x00000000}},	//   _sier_, pløs, reyð,
  { {0x7bdd0004,0x442606a6,0xdcfc0006,0x00000000}},	//   _tasu, _omo_, darė,
  { {0x2ee90089,0x79950051,0xe84b0593,0x00000000}},	//   _kraf_, _wezw, رجان_,
  { {0x6b8d06a7,0x2d940024,0xf7450001,0x00000000}},	//   mbag, ždeň_, јело,
  { {0x6b8d06a8,0x68e306a9,0x386d06aa,0x00000000}},	//   lbag, ånds, _wier_,
  { {0x386d06ab,0x224506ac,0x660106ad,0x00000000}},	//   _tier_, volk_, _volk,
  { {0x660106ae,0xf2d90043,0x92f500de,0x00000000}},	//   _wolk, نبخش_, لأخض,
  { {0x21f5019d,0x660106af,0xe299005e,0x00000000}},	//   аїнс, _tolk, њао_,
  { {0x03220088,0x20c50086,0x442606b0,0x00000000}},	//   ідэн, айом, _emo_,
  { {0x2ee9001f,0x7ae406b1,0x6032008f,0x00000000}},	//   _araf_, zvit, lāmi,
  { {0xa4fa00b7,0x2ee9001f,0x7ae400fe,0x00000000}},	//   _בלעט, _braf_, yvit,
  { {0x636b01f7,0x7d0100c7,0x6032001c,0x00000000}},	//   _dönü, älsn, nāmi,
  { {0x91fc0418,0x628906b2,0x6b8d003e,0x00000000}},	//   rmāc, mpeo, ebag,
  { {0x3b9606b3,0x8b9606b4,0x2ee900ca,0x00000000}},	//   ијат, ирач, _eraf_,
  { {0x6b8d002c,0xe8e0001b,0xafdb01f2,0x00000000}},	//   gbag, _hiệp_, slør,
  { {0x6aad06b5,0x6da606b6,0x6032008f,0x00000000}},	// [700] graf, _кипа, jāmi,
  { {0x6b8d00a4,0xac76007e,0x7ae406b7,0x00000000}},	//   abag, _پادش, rvit,
  { {0xa3b60161,0x636b005b,0x6b8d06b8,0x00000000}},	//   _जाल_, _yönü, bbag,
  { {0xdb2000ea,0x3ead06b9,0x929d0051,0x00000000}},	//   ítóg, šete_, szły,
  { {0x6aad06ba,0xdcfc0078,0x2c7c013d,0x00000000}},	//   craf, tarė, _híd_,
  { {0x7aeb0146,0x442606bb,0xe4a6006e,0x00000000}},	//   ægte, _smo_, арио,
  { {0xd49706bc,0x44260019,0xdcfe008f,0x00000000}},	//   ары_, _pmo_, _iepē,
  { {0x7c36001f,0xa68606bd,0x9f910046,0x00000000}},	//   nnyr, _влад, _núðu_,
  { {0xd467005e,0xa3e701ce,0xf74a02da,0x00000000}},	//   шиће_, рдња_, _شجره_,
  { {0xafdb00d1,0xdb0d0026,0x69c80058,0x00000000}},	//   eløp, ngaá, _öded,
  { {0x9f910026,0xe3ba06be,0xe8e00013,0x00000000}},	//   _búðu_, _абе_, _diệp_,
  { {0x1073000d,0x2ee9003b,0x6f1d06bf,0x00000000}},	//   ўляю, _praf_, tzsc,
  { {0x2475008f,0x2bba0042,0xd622014b,0x00000000}},	//   _rāmi_, इलना, _лiда,
  { {0x6f1d06c0,0xf0b7005d,0xd24f0054,0x00000000}},	//   rzsc, دایش_, _єц_,
  { {0xac19018b,0x61fc0137,0xdde1013d,0x00000000}},	//   гову_, örlu, ítői,
  { {0xb068000d,0x2ee906c1,0xa3b60042,0x00000000}},	//   _крыж_, _traf_, जलि_,
  { {0x6b8d06c2,0xda7806c3,0xf9930021,0x00000000}},	// [710] rbag, аях_, قبض_,
  { {0xd9990032,0x6b8d06c4,0x6aad06c5,0x00000000}},	//   انات_, sbag, rraf,
  { {0x6aad005b,0x2907000c,0xf0930047,0x00000000}},	//   sraf, âna_, ַנס_,
  { {0x6aad06c6,0x6032008f,0x7d0800a5,0x00000000}},	//   praf, tāmi, ädse,
  { {0x7c2d06c7,0x929d0022,0xa6c9030b,0x00000000}},	//   miar, ryłk, улла_,
  { {0x929d0051,0x7c2d06c8,0x5a440085,0x00000000}},	//   syłk, liar, _дэса,
  { {0x6032008f,0x361a005d,0x588406c9,0x00000000}},	//   sāmi, درنگ_, _мыта,
  { {0xa9540086,0xf77f01f7,0xad38009f,0x00000000}},	//   _єкті, _üç_, ינוס_,
  { {0xa7150001,0xa3d60053,0x26cd0035,0x00000000}},	//   _удаљ, ाज़_, _upeo_,
  { {0xe61300b3,0x7c2d06ca,0xe1f905ef,0x00000000}},	//   _بشر_, hiar, уго_,
  { {0xafdb00d1,0xd24e007e,0x62720022,0x00000000}},	//   tløp, رچه_, _płoc,
  { {0x9f060032,0x6d40005b,0x6006006d,0x00000000}},	//   موجو, şmak, _cómp,
  { {0x201e00eb,0x91e506cb,0x52850032,0x00000000}},	//   ėti_, _голе, _التك,
  { {0xe29f007a,0x62720051,0x64490229,0x00000000}},	//   áðu_, _włoc, loei,
  { {0x7c2d06cc,0x0c790076,0x442d06cd,0x00000000}},	//   fiar, исты_, oie_,
  { {0x442d06ce,0x7c2d06cf,0x2c7c004c,0x00000000}},	//   nie_, giar, _víd_,
  { {0x63a606d0,0xc27a0047,0x442d06d1,0x00000000}},	// [720] ókni, ָרעי, iie_,
  { {0x442d06d2,0x7c360046,0x7c2d004e,0x00000000}},	//   hie_, snyr, aiar,
  { {0xf8aa0001,0x2d9a00ac,0x442d06d3,0x00000000}},	//   увек_, _iepe_, kie_,
  { {0x442d06d4,0x7c2d06d5,0xdcfc008f,0x00000000}},	//   jie_, ciar, harī,
  { {0xdcfc003d,0xf62a0086,0xf7460076,0x00000000}},	//   karī, ліки_, щедо,
  { {0x442d0019,0x9e7b0047,0x27e006d6,0x00000000}},	//   eie_, אנספ, žin_,
  { {0xdcfc003d,0x485a000d,0x442d06d7,0x00000000}},	//   darī, _браў_, fie_,
  { {0x2d9a06d8,0x442d06d9,0x3ea20046,0x00000000}},	//   _lepe_, gie_, kskt_,
  { {0x386600c7,0xe73a06da,0x6032008f,0x00000000}},	//   mmor_, _сеа_, nāmu,
  { {0x7c2d051e,0x442d06db,0x7ae90066,0x00000000}},	//   ziar, aie_, _šetk,
  { {0x38660150,0xa15806dc,0x7c2d0089,0x00000000}},	//   omor_, рану_, yiar,
  { {0x3957014e,0x442d06dd,0xa93b0047,0x00000000}},	//   משים_, cie_, רײטי,
  { {0x7c2d06de,0xdcf5056c,0x00000000,0x00000000}},	//   viar, iczą,   ,
  { {0xdb0d017d,0x633b0047,0x60dc00b9,0x00000000}},	//   lgaç, _געדױ, ærms,
  { {0x3ea200d1,0x6a690078,0x0ba7000d,0x00000000}},	//   askt_, _užfi, йшам,
  { {0x388100eb,0x00000000,0x00000000,0x00000000}},	//   _nėra_,   ,   ,
  { {0xdb0d017d,0x7c2d06df,0x999906e0,0x00000000}},	// [730] igaç, riar, икат_,
  { {0x6fb5006a,0x7c2d06e1,0x127b0047,0x00000000}},	//   _امکا, siar, טאמע,
  { {0x7c2d06e2,0x58d90094,0x75e9013d,0x00000000}},	//   piar, рдея_, nöző,
  { {0x2a790089,0xc1c40053,0x69d80066,0x00000000}},	//   _tusb_, वभुग, ôver,
  { {0xb6c70121,0x442d06e3,0x6449017d,0x00000000}},	//   ссей, vie_, voei,
  { {0x442d06e4,0x2d830051,0x853c0006,0x00000000}},	//   wie_, ncje_, _idėj,
  { {0x442d06e5,0xf650007e,0xdcfc008f,0x00000000}},	//   tie_, رئه_, varī,
  { {0x24090076,0xd2a90121,0x52a906e6,0x00000000}},	//   рнии_, акие_, авим_,
  { {0x764a0035,0x2d830051,0x13060076,0x00000000}},	//   bofy, kcje_, жный_,
  { {0x442d06e7,0xaadc0047,0x69d706e8,0x00000000}},	//   sie_, רחזר, nexe,
  { {0x7bd60035,0xdbc6004b,0x644906e9,0x00000000}},	//   yeyu, mööd, poei,
  { {0xa3b60161,0x62860066,0xe29f0014,0x00000000}},	//   _जाए_, íkoc, áðs_,
  { {0x2d9a0009,0xb7da0063,0x6d58004c,0x00000000}},	//   _pepe_, בקרי, _úvaz,
  { {0xf267005e,0xdcf50022,0x3ea206ea,0x00000000}},	//   _уђем, zczą, rskt_,
  { {0xd24e0032,0xc5f20063,0x69d706eb,0x00000000}},	//   _جنو_, ודם_, dexe,
  { {0x6ab60026,0x63bb06ec,0x3ea20014,0x00000000}},	//   tuyf, ngun, pskt_,
  { {0x61e306ed,0x63bb06ee,0x8d7601fb,0x00000000}},	// [740] _kanl, igun, _وادا,
  { {0x63bb003e,0x3866002b,0x200202f7,0x00000000}},	//   hgun, wmor_, ljki_,
  { {0x3935000d,0x69d90053,0x61e306ef,0x00000000}},	//   пэцс, नज़ी, _manl,
  { {0xb8f20161,0x46ea06f0,0x6d5e019f,0x00000000}},	//   _वह_, иден_, _izpa,
  { {0x4e0e0053,0x87030121,0x764a06f1,0x00000000}},	//   _हवाई_, дяще, tofy,
  { {0x61e300a4,0x63bb06f2,0xa3cc0042,0x00000000}},	//   _nanl, egun, श्न_,
  { {0x9f450080,0x38810078,0x62720022,0x00000000}},	//   ělé_, _tėra_, _błon,
  { {0x61e30250,0x63bb053b,0x799c06f3,0x00000000}},	//   _aanl, ggun, _herw,
  { {0x6aa406f4,0x62720022,0x61e306f5,0x00000000}},	//   nsif, _dłon, _banl,
  { {0x27e402eb,0x32180045,0x61e306f6,0x00000000}},	//   _hamn_, óry_, _canl,
  { {0xb97b0063,0x799c06f7,0x27e606f8,0x00000000}},	//   יניי, _merw, odon_,
  { {0x68e30146,0x27e606f9,0x69ca0053,0x00000000}},	//   ændi, ndon_, स्ती,
  { {0xee3f0080,0x69ce06fa,0x91780013,0x00000000}},	//   krýt_, _obbe, hởi_,
  { {0x61e30185,0xd344006a,0x2e4b02e4,0x00000000}},	//   _ganl, _ویژه_, рямо_,
  { {0x2cb806fb,0x660801e1,0x63a000dd,0x00000000}},	//   gurd_, _modk, oamn,
  { {0x27e402eb,0x6aa40035,0x63a006fc,0x00000000}},	//   _namn_, fsif, namn,
  { {0x9b6b005a,0x61e3005b,0xa3cc0053,0x00000000}},	// [750] ршва_, _yanl, श्य_,
  { {0x3eb90019,0x63a006fd,0xdb0406fe,0x00000000}},	//   must_, hamn, egió,
  { {0x3eb90004,0xb86b000a,0x63bb0058,0x00000000}},	//   lust_, ајде_, ygun,
  { {0x69ce06ff,0x63a0007d,0xaa7b0014,0x00000000}},	//   _ebbe, jamn, _brýt,
  { {0xf7700032,0x3eb90019,0xdbc60019,0x00000000}},	//   ناه_, nust_, tööd,
  { {0x62720051,0x6b9d002b,0x799c0700,0x00000000}},	//   _słon, _hesg, _gerw,
  { {0x1c0f0161,0x7985001f,0x3eb9004b,0x00000000}},	//   _सवाल_, mchw, hust_,
  { {0x32070701,0xd7c9006a,0x3eb90702,0x00000000}},	//   _sony_, _دوره_, kust_,
  { {0x61e3002c,0x63bb0703,0x3eb90704,0x00000000}},	//   _panl, rgun, just_,
  { {0x3eb90705,0x321e0706,0x660806a3,0x00000000}},	//   dust_, ghty_, _godk,
  { {0x61e30707,0x7985004d,0x00850062,0x00000000}},	//   _vanl, ichw, ялно,
  { {0xd3b80086,0x5437007e,0x3dd8002b,0x00000000}},	//   _душі_, _برطر, werw_,
  { {0xdbd9007a,0x3eb90708,0x6d410003,0x00000000}},	//   væðu, gust_, ûlan,
  { {0x32130013,0x2738008d,0xb5fd0078,0x00000000}},	//   _ôxy_, ẩng_, _pušy,
  { {0xdbd90026,0x7aef0709,0xed5a070a,0x00000000}},	//   tæðu, _arct, сов_,
  { {0x799c070b,0x6c360021,0x3eb9070c,0x00000000}},	//   _serw, أفرا, bust_,
  { {0x799c014f,0xdbd90026,0x6b9d070d,0x00000000}},	// [760] _perw, ræðu, _desg,
  { {0xa3ab0161,0x6aa4070e,0x19b9000d,0x00000000}},	//   कृत_, rsif, жуць_,
  { {0x799c070f,0x48b60062,0x88ca0002,0x00000000}},	//   _verw, ящат, слев_,
  { {0x799c00e8,0xdcf50051,0x79850710,0x00000000}},	//   _werw, jczę, achw,
  { {0x799c0711,0x27e60712,0x17790054,0x00000000}},	//   _terw, rdon_, ісць_,
  { {0x26c600fe,0x69ce006f,0xd49a0713,0x00000000}},	//   rtoo_, _ubbe, бри_,
  { {0x628b001f,0xa507005e,0x63a00714,0x00000000}},	//   _atgo, зеја_, tamn,
  { {0xb603003d,0xb4ac0042,0x493b009a,0x00000000}},	//   īšan, _कटी_, _הגלו,
  { {0x27f70114,0x63a00715,0x68e301e1,0x00000000}},	//   šení_, ramn, ændv,
  { {0x3eb90004,0x63a00716,0xe8e00013,0x00000000}},	//   vust_, samn, _nhịp_,
  { {0x3eb90717,0x63a0013d,0xbfd9012c,0x00000000}},	//   wust_, pamn, однє_,
  { {0x3eb90004,0x8fa400e1,0x9f350086,0x00000000}},	//   tust_, наџе, демі,
  { {0x6b9d0718,0x7985001f,0xb4ac0042,0x00000000}},	//   _resg, ychw, _कटु_,
  { {0x6b9d0331,0x3eb90719,0x7e280085,0x00000000}},	//   _sesg, rust_, піса_,
  { {0x3eb90019,0x61f80173,0x463b0041,0x00000000}},	//   sust_, _invl, צעלע,
  { {0x5c74071a,0xb1570063,0xafdb00b9,0x00000000}},	//   елст, _מסוג_, dnøg,
  { {0x7cf60014,0xdce70058,0x7985071b,0x00000000}},	// [770] týrð, rajı, tchw,
  { {0xdce7005b,0xdcf50051,0xf1cf0042,0x00000000}},	//   sajı, zczę, त्पन,
  { {0xdb0d0026,0x7985071c,0x20190078,0x00000000}},	//   ngaú, rchw, ūriu_,
  { {0x79850199,0x69c8005b,0x7658004c,0x00000000}},	//   schw, _öden, elvy,
  { {0x7985002b,0xf7730044,0xe68800de,0x00000000}},	//   pchw, راص_, كننى_,
  { {0x8afa0063,0x7aed00ca,0x00000000,0x00000000}},	//   _והשי, mvat,   ,
  { {0x7bcd0035,0xa5060062,0x7aed071d,0x00000000}},	//   ofau, деща_, lvat,
  { {0xfcaa00b7,0x3ea9024a,0x657a00ac,0x00000000}},	//   קיפּ, _ovat_, _egth,
  { {0x7aed071e,0x69ca0053,0x6612013d,0x00000000}},	//   nvat, स्वी, ükkö,
  { {0x7aed00ea,0x80a90121,0xa229071f,0x00000000}},	//   ivat, овов_, іжна_,
  { {0x7aed0720,0x3494005a,0xafdb00d1,0x00000000}},	//   hvat, _захр, lløy,
  { {0x7aed0721,0xa295012c,0x00000000,0x00000000}},	//   kvat, _жаді,   ,
  { {0x6d49000c,0x628b002b,0x442f0722,0x00000000}},	//   şeal, _utgo, _img_,
  { {0x7a20000f,0x7bcd0723,0x7aed065e,0x00000000}},	//   _köte, efau, dvat,
  { {0x7aed0724,0x3ea90229,0xc0a8007e,0x00000000}},	//   evat, _evat_, _فايل_,
  { {0x7a2000c7,0x8fa6007e,0xa09a0063,0x00000000}},	//   _möte, _کمکه, _ויקט,
  { {0x2eff00bd,0x6d450725,0xdd990066,0x00000000}},	// [780] äuft_, _exha, ŕňa_,
  { {0xe9d70726,0x9f9d0014,0x4a430727,0x00000000}},	//   мку_, læði_, внув,
  { {0x49990086,0xd7e60086,0x18a30062,0x00000000}},	//   яття_, діло, вахм,
  { {0x6d4001f7,0x9f400728,0x2ef200ac,0x00000000}},	//   şmas, _unió_, _kryf_,
  { {0xc7a3041d,0xafdb00b9,0x7aed0729,0x00000000}},	//   тичк, snøg, cvat,
  { {0x3eaf00b9,0x442f072a,0xe8df0013,0x00000000}},	//   _ægte_, _amg_, _luộc_,
  { {0x68e305b9,0x442f072b,0xa5c40042,0x00000000}},	//   ændt, _bmg_, _राठौ,
  { {0xd4670001,0x6b96072c,0x690b0063,0x00000000}},	//   мије_, nbyg, _וּמְ,
  { {0x9402007e,0xc274005e,0xd403072d,0x00000000}},	//   فوژه, нлиј, тящи,
  { {0xf8d20161,0xdb15072e,0x8afb0047,0x00000000}},	//   _सहाय, ébéc, קהיי,
  { {0xd1300032,0x9f450080,0xe8df008b,0x00000000}},	//   امج_, ělí_, _buộc_,
  { {0xe8df001b,0xeb9f00d1,0x7aed004a,0x00000000}},	//   _cuộc_, _fløy_, yvat,
  { {0xd6d90045,0x6b96072f,0x2ef2001f,0x00000000}},	//   _były_, dbyg, _cryf_,
  { {0x6ab600e8,0x2ef200ac,0xe7310063,0x00000000}},	//   dryf, _dryf_, אֵל_,
  { {0x1bd5005a,0xfe240076,0x645c001c,0x00000000}},	//   новя, тьян, _īrij,
  { {0xec680086,0x6b960730,0x2019008f,0x00000000}},	//   друк_, gbyg, īris_,
  { {0xcb340062,0x2ef20731,0xafdb05b9,0x00000000}},	// [790] ветъ, _gryf_, rnød,
  { {0xe9d30021,0xc95b000d,0xdcfc003b,0x00000000}},	//   ضغط_, оўе_, ucră,
  { {0x7aed065c,0x5c7506c3,0x20190072,0x00000000}},	//   svat, _плот, oksi_,
  { {0x201900f3,0x7aed006f,0xad26005d,0x00000000}},	//   nksi_, pvat, _سرپو,
  { {0x201900fe,0x16a90054,0x59c70042,0x00000000}},	//   iksi_, ївки_, _लापर,
  { {0x644200fe,0x0608000d,0x68e300b9,0x00000000}},	//   _ajoi, мнік_, ænds,
  { {0x57b700de,0xbd9c009d,0x00000000,0x00000000}},	//   _يحرز, חסות,   ,
  { {0xe739001f,0xe795007e,0x13090086,0x00000000}},	//   _ddŵr_, _سارک, зний_,
  { {0x9f9d007a,0x7c3a0732,0xeb920063,0x00000000}},	//   væði_, étri, נָה_,
  { {0x201900fe,0x7a2000bd,0x41050733,0x00000000}},	//   eksi_, _töte, езов,
  { {0x20890062,0x6e350734,0xd5a6005d,0x00000000}},	//   яйни_, dizb, _سلنی,
  { {0xcdc9014e,0x59cf0042,0x80a00042,0x00000000}},	//   _לך_, स्तर, _खबरे,
  { {0xef170055,0x9f9d007a,0x443f0735,0x00000000}},	//   емя_, ræði_, mnu_,
  { {0x20190736,0x443f0737,0xc6920149,0x00000000}},	//   aksi_, lnu_, ראם_,
  { {0xa3cc0053,0x5274007e,0x621a00ff,0x00000000}},	//   श्व_, _شاهز, _מוסק,
  { {0x443f0738,0x98ac008f,0xc87f0075,0x00000000}},	//   nnu_, ūlīt_, ışla_,
  { {0xdd2f0080,0x645b0072,0x6b960739,0x00000000}},	// [7a0] _měře, ilui, rbyg,
  { {0x2b9e008b,0x6b96073a,0x8e970063,0x00000000}},	//   ắc_, sbyg, _רדיו_,
  { {0x69c801f7,0x2d98073b,0x7d010137,0x00000000}},	//   _ödem, mbre_, älst,
  { {0xad370063,0x443f073c,0x96ea01dd,0x00000000}},	//   _טניס_, jnu_, зька_,
  { {0x68e30146,0x2d98073d,0x443f073e,0x00000000}},	//   ændr, obre_, dnu_,
  { {0xd49a073f,0x645b00ca,0x7c240740,0x00000000}},	//   при_, elui, lhir,
  { {0x24e7000a,0x645b0741,0x443f0742,0x00000000}},	//   емји_, flui, fnu_,
  { {0x6b7b0047,0x443f0743,0x66e60744,0x00000000}},	//   ּרינ, gnu_, _поба,
  { {0xe7d501f7,0x7c240745,0xf7460002,0x00000000}},	//   lığı, ihir, _џезо,
  { {0xe8df0013,0xd5e90021,0x443f0746,0x00000000}},	//   _nuớc_, _يعلن_, anu_,
  { {0x3a37014e,0x7c24003e,0x9f400026,0x00000000}},	//   תרים_, khir, _snið_,
  { {0x645b0747,0x69de0748,0x2d98032a,0x00000000}},	//   clui, hepe, ebre_,
  { {0x7c240035,0x4ea7000d,0x6e35004d,0x00000000}},	//   dhir, эрна, tizb,
  { {0x127b0047,0x7bc600a5,0x7c240433,0x00000000}},	//   _זאגע, _acku, ehir,
  { {0xc0e300d7,0x69de0749,0x7c240046,0x00000000}},	//   _бојк, depe, fhir,
  { {0xe7d501f7,0x515b0063,0x91780013,0x00000000}},	//   dığı, _מכוו, mời_,
  { {0xc87f005b,0x61ea0026,0xb603017c,0x00000000}},	// [7b0] ışma_, _kafl, úško,
  { {0xa93d000d,0x69de074a,0x63a202e3,0x00000000}},	//   одзi, gepe, _leon,
  { {0x443f074b,0xe578008f,0x4c9502d8,0x00000000}},	//   ynu_, _kaķu_, _шинс,
  { {0x63a2074c,0x7c24074d,0xf773005d,0x00000000}},	//   _neon, chir, هاش_,
  { {0x44240027,0x69de006f,0x443f074e,0x00000000}},	//   dhm_, bepe, vnu_,
  { {0x3eb90034,0x69de000c,0x27e9074f,0x00000000}},	//   irst_, cepe, žan_,
  { {0x443f0750,0xdb0d0026,0x9f4c004c,0x00000000}},	//   tnu_, ngaþ, ědé_,
  { {0x443f0751,0xb6f5005e,0x645b0050,0x00000000}},	//   unu_, _избј, ului,
  { {0x645b0752,0x320e0035,0x04560021,0x00000000}},	//   rlui, _bofy_, خلية_,
  { {0x645b04c6,0x443f0753,0xd24e0754,0x00000000}},	//   slui, snu_, يني_,
  { {0x443f0755,0x3eb90756,0x61ea002b,0x00000000}},	//   pnu_, erst_, _dafl,
  { {0x63a20757,0x69de0758,0x7a200137,0x00000000}},	//   _geon, zepe, _möta,
  { {0x69c7017f,0xdb06027d,0x7bdf0759,0x00000000}},	//   _ocje, _odká, dequ,
  { {0xdd9201fb,0xc58e0013,0xc33203c3,0x00000000}},	//   شور_, hồng_, _דוד_,
  { {0x6da30138,0x7c24075a,0x2731008b,0x00000000}},	//   риса, thir, ạnh_,
  { {0x8c43000a,0x69d5004d,0xc1780078,0x00000000}},	//   аесе, _abze, adės_,
  { {0xf9920593,0x69de075b,0x7c24075c,0x00000000}},	// [7c0] لبا_, tepe, rhir,
  { {0xceb90080,0xba23000d,0xe7d5005b,0x00000000}},	//   áře_, адук, tığı,
  { {0x7bdf0016,0x291c027d,0x69de075d,0x00000000}},	//   bequ, áva_, repe,
  { {0x69de075e,0xe73a075f,0xca29009a,0x00000000}},	//   sepe, мее_, חם_,
  { {0x62720051,0xa6fa0021,0x91780013,0x00000000}},	//   _głow, بعاء_, iới_,
  { {0x4a750076,0x63a20019,0xceb30063,0x00000000}},	//   _быст, _seon, שיג_,
  { {0x04c70021,0x7a200137,0x7ae40760,0x00000000}},	//   نووي_, _göta, lwit,
  { {0x61ea0185,0x94230001,0x7bc40761,0x00000000}},	//   _safl, имје, ngiu,
  { {0x7c230529,0x325406da,0x59cf0053,0x00000000}},	//   _înre, лвир, स्वर,
  { {0x3f80017d,0x7aeb01e1,0x66250022,0x00000000}},	//   _agiu_, ægti, ątkó,
  { {0x859b0132,0x9f4e0240,0x3ea000a4,0x00000000}},	//   _חשבו, čným_, _awit_,
  { {0xc953014e,0x94a90021,0x7d0301a8,0x00000000}},	//   ימת_, _أطلق_, _ànsi,
  { {0x3eb90474,0x61ea0762,0xf38f0013,0x00000000}},	//   urst_, _tafl, oảng_,
  { {0x6e940076,0x7bc40763,0xf7730132,0x00000000}},	//   риру, egiu, יקר_,
  { {0x62720045,0xfb870088,0x7bdf0764,0x00000000}},	//   _słow, вызн, tequ,
  { {0x7bc402f6,0xd10f0161,0x5fa70161,0x00000000}},	//   ggiu, ाहरण_, _ख़िल,
  { {0x7bdf0765,0xc3340063,0x49cb0766,0x00000000}},	// [7d0] requ, אוּ_, дуем_,
  { {0xf7f4007e,0x4d99013c,0x2ee90767,0x00000000}},	//   یسند, _якою_, _isaf_,
  { {0x6d410066,0x7bdf0331,0x5fa70042,0x00000000}},	//   úlad, pequ, _ख़ाल,
  { {0x787a0080,0xd78901fb,0xc8640768,0x00000000}},	//   _důvo, رنتو_, атчи,
  { {0x17540054,0xc58e008d,0xdb0d004b,0x00000000}},	//   авця, rồng_, ngaü,
  { {0x26360051,0xc9870769,0x1994076a,0x00000000}},	//   słon_, _шуми, _варя,
  { {0x6aad076b,0xc9580085,0x7a20013d,0x00000000}},	//   lsaf, _аўт_, _kötn,
  { {0x32cb076c,0xd46602e4,0x6b8d076d,0x00000000}},	//   tøy_, лище_, ncag,
  { {0x6aad076e,0x27ff0072,0x6595076f,0x00000000}},	//   nsaf, _inun_, _базу,
  { {0x2d81001b,0x95d80121,0x32cb069f,0x00000000}},	//   _nghe_, _идут_, røy_,
  { {0xe4cb006a,0x69c50770,0x32cb04aa,0x00000000}},	//   _زبان_, ighe, søy_,
  { {0x25a50771,0xf3f00021,0x91fc008f,0x00000000}},	//   _hell_, _وأن_, elād,
  { {0x27ed0185,0x25a50772,0x2fdf0019,0x00000000}},	//   _maen_, _kell_, õuga_,
  { {0x7643017e,0x63a90773,0x27ed0774,0x00000000}},	//   nnny, laen, _laen_,
  { {0x91fc003d,0xdcee005b,0x27ff005b,0x00000000}},	//   rmāt, tabı, _onun_,
  { {0x61e1024a,0x63a90775,0x69c501f4,0x00000000}},	//   lell, naen, eghe,
  { {0xab660776,0x4a460777,0xab27015b,0x00000000}},	// [7e0] увал, гнав, гота_,
  { {0x25a502f6,0xdcee01f7,0x787a0080,0x00000000}},	//   _nell_, sabı, _půvo,
  { {0x63a90778,0x60c10779,0x32360047,0x00000000}},	//   kaen, nulm, נטען_,
  { {0x63a90035,0x6b8d077a,0x7e7e0136,0x00000000}},	//   jaen, ccag, _hipp,
  { {0x61e1077b,0x25a50127,0x6d5e077c,0x00000000}},	//   kell, _bell_, _hypa,
  { {0xf38f001b,0x25a5077d,0x60c1077e,0x00000000}},	//   uảng_, _cell_, kulm,
  { {0x61e1077f,0x25a5055b,0x83fd00ea,0x00000000}},	//   dell, _dell_, klőd,
  { {0x4422000f,0x7643003e,0x61e100fe,0x00000000}},	//   ók_, anny, eell,
  { {0x25a50780,0x57460781,0xe3af0021,0x00000000}},	//   _fell_, _снаб, سري_,
  { {0xf1c60080,0x2000000c,0x2fc90025,0x00000000}},	//   _část_, _anii_, _scag_,
  { {0xdb0600b9,0x63a9033b,0x3178004d,0x00000000}},	//   _udkæ, baen, ärz_,
  { {0x0eeb0076,0xd259008f,0x82a60782,0x00000000}},	//   ньги_, ruņa_, _бадж,
  { {0xe296000a,0x69c501e1,0x62720022,0x00000000}},	//   _среќ, yghe, _błot,
  { {0x6d5e0783,0x61e10784,0x7a2000a5,0x00000000}},	//   _bypa, cell, _sötn,
  { {0x7e7e00e5,0x91fc008f,0xec6b0785,0x00000000}},	//   _dipp, rlād, ерак_,
  { {0xdb060137,0x60df013d,0x9b9501a4,0x00000000}},	//   _odkä, őzmé, риац,
  { {0x91fc001c,0xdfd80062,0x5a350786,0x00000000}},	// [7f0] plād, _същ_, анат,
  { {0x6b8d0787,0x321e0051,0xc7b9013d,0x00000000}},	//   scag, nkty_, _elől_,
  { {0x69c50788,0x2967005e,0x99670789,0x00000000}},	//   rghe, уњав, утал,
  { {0x25a50034,0x765a078a,0x6272078b,0x00000000}},	//   _sell_, _akty, _złot,
  { {0x65640080,0x61e1066d,0x63a9078c,0x00000000}},	//   řihl, yell, vaen,
  { {0x76430150,0x60c1005b,0xf77004f6,0x00000000}},	//   unny, yulm, سان_,
  { {0x25a5078d,0x63a9078e,0x61e1078f,0x00000000}},	//   _vell_, taen, vell,
  { {0x25a504bf,0x321e0022,0x61e10790,0x00000000}},	//   _well_, ekty_, well,
  { {0x25a50034,0x74120032,0xcb1200b5,0x00000000}},	//   _tell_, تويا, ַלט_,
  { {0xdb0d006d,0x61e10791,0x60c10792,0x00000000}},	//   ngañ, uell, tulm,
  { {0xc5fa0047,0xb5fa0047,0x3547000d,0x00000000}},	//   _שפעט, _שלעכ, _схав,
  { {0x60c101f7,0x43750793,0x7339005e,0x00000000}},	//   rulm, _култ, _изер_,
  { {0x2055000d,0x83fd00ea,0x61e10238,0x00000000}},	//   стэр, rlőd, pell,
  { {0x5332000a,0x387f0089,0x6da30794,0x00000000}},	//   _фељт, _liur_, жира,
  { {0xed5a0795,0x62860240,0x92680092,0x00000000}},	//   тов_, íkov, _срца_,
  { {0x6d5e0114,0x20000796,0x83fd013d,0x00000000}},	//   _vypa, _unii_, llőb,

  { {0x62720051,0x6d5e0051,0xdcfc001c,0x00000000}},	// [800] _głos, _wypa, obrī,
  { {0x6d5e0797,0x1daa0161,0x3c3f00fe,0x00000000}},	//   _typa, _क़ित, tävä_,
  { {0x77860798,0xdcfc0023,0x387f056c,0x00000000}},	//   алез, ibrī, _biur_,
  { {0x386d0799,0x7d1c0072,0xd90d005d,0x00000000}},	//   _cher_, myrs, ریق_,
  { {0xc6a30065,0x66f4079a,0xa6c701ce,0x00000000}},	//   орщи, сплу, илца_,
  { {0x386d00bd,0xc8960092,0x68fa013d,0x00000000}},	//   _eher_, _врањ, _átdo,
  { {0x29070137,0x75890086,0xd943079b,0x00000000}},	//   änat_, усів_, _дери,
  { {0x6a6b00bd,0x6e3c079c,0x68e20022,0x00000000}},	//   rüfe, hirb, łods,
  { {0xf5ea026b,0x9294005e,0x33730062,0x00000000}},	//   _имал_, љаоц, огър,
  { {0xd4d60088,0xb0660072,0x51f70121,0x00000000}},	//   _відэ, yvää, анью_,
  { {0xdcb1008b,0x6e3c079d,0x7a20004d,0x00000000}},	//   ởi_, dirb, _rötl,
  { {0x6e3c0025,0x7d1c01e1,0x853b009a,0x00000000}},	//   eirb, dyrs, _בגבי,
  { {0x32940032,0x2294079e,0xfe73009e,0x00000000}},	//   _التأ, _التس, قدس_,
  { {0x76580066,0x91e30121,0xf1a30062,0x00000000}},	//   novy, _моче, _дрън,
  { {0x2ba7041d,0x62720051,0x44260736,0x00000000}},	//   ијав, _włos, _klo_,
  { {0x5bb80076,0x717b014e,0xd0080001,0x00000000}},	//   ился_, _בנוס, _веће_,
  { {0xe9870001,0xb0660019,0xaed50001,0x00000000}},	// [810] аћен, svää, _уопш,
  { {0x387f0150,0x7d1c06a5,0x7ac4079f,0x00000000}},	//   _siur_, byrs, юссе,
  { {0xda7803d6,0x442607a0,0xa3d60042,0x00000000}},	//   рят_, _olo_, िभा_,
  { {0xe8df00aa,0x7aeb00b9,0x6d49003b,0x00000000}},	//   _quốc_, ægts, şeas,
  { {0xd6390085,0x8b030022,0x6a6b0244,0x00000000}},	//   лякі_, łębs, rüfb,
  { {0x2d910022,0xe5a207a1,0x442607a2,0x00000000}},	//   ncze_, пиши, _alo_,
  { {0x29070137,0x386d00e5,0xe8df008d,0x00000000}},	//   ånad_, _ther_, _tuốc_,
  { {0xd4e40086,0x436907a3,0x442607a4,0x00000000}},	//   юючи, лайн_, _clo_,
  { {0x32d0008b,0xdcfc008f,0xd8380085,0x00000000}},	//   gày_, tbrī, _тэр_,
  { {0x76580066,0x69c807a5,0x32d40085,0x00000000}},	//   covy, _ödet, іцыс,
  { {0x6d40005b,0x442607a6,0x786a0061,0x00000000}},	//   şmaz, _flo_, lýva,
  { {0x442607a7,0x6e3c004d,0x9f42004c,0x00000000}},	//   _glo_, wirb, leké_,
  { {0x2bcb0053,0x9dba0085,0x7bc3005f,0x00000000}},	//   िलना, лыву_, ėnul,
  { {0x23740024,0x51950021,0xe29c0041,0x00000000}},	//   ňajú_, _الغذ, _ישׂר,
  { {0x1d19019d,0x82340242,0x6e3c0014,0x00000000}},	//   ають_, _برنا, rirb,
  { {0x711a0063,0x20d1013d,0x6096005d,0x00000000}},	//   _תוקפ, mái_, _انيس_,
  { {0x629b00fe,0x3b070189,0xc0530063,0x00000000}},	// [820] npuo, бето_, _מזה_,
  { {0x7dea0076,0xdb0d0014,0xf9c40043,0x00000000}},	//   _смог_, rgað, تحری,
  { {0xd23a0047,0x8c26005d,0x7cd60044,0x00000000}},	//   נגעל, _هفده, _اتخذ,
  { {0xa967005a,0xdb0600ea,0x20f7003b,0x00000000}},	//   щиха_, _leké, _măi_,
  { {0x29070137,0x20d1008b,0x628f07a8,0x00000000}},	//   änar_, hái_, ícol,
  { {0x442600d1,0xa5f80416,0x20d1013d,0x00000000}},	//   _slo_, реку_, kái_,
  { {0xd497000d,0x6f1d0051,0x442607a9,0x00000000}},	//   бры_, zysc, _plo_,
  { {0x94180076,0x786a01c2,0x2d910051,0x00000000}},	//   ржит_, býva, zcze_,
  { {0x59cf0053,0x6a700137,0x7a200137,0x00000000}},	//   स्कर, räff, _nötk,
  { {0x6d4001f7,0xf238000a,0x69da0058,0x00000000}},	//   şmay, рпош_, _öted,
  { {0x20f7003b,0x69dc0025,0x4426007d,0x00000000}},	//   _căi_, _mbre, _tlo_,
  { {0x4420008b,0x43860021,0x44260332,0x00000000}},	//   _ôi_, _الإق, _ulo_,
  { {0x69dc07aa,0x316b0022,0x3c27004e,0x00000000}},	//   _obre, ęcza_, _nõva_,
  { {0x44f80013,0x2ceb0085,0x27e607ab,0x00000000}},	//   _kĩ_, льбо_, heon_,
  { {0x786a027d,0xb4250051,0x2d910022,0x00000000}},	//   zýva, łżeń, rcze_,
  { {0x44f80013,0x69dc06d5,0xd0110044,0x00000000}},	//   _mĩ_, _abre, _آلة_,
  { {0x7b6707ac,0x27e607ad,0x7a2007ae,0x00000000}},	// [830] стве, deon_, _köth,
  { {0x3da7030b,0x00000000,0x00000000,0x00000000}},	//   _уриб,   ,   ,
  { {0x44f80013,0xdd92007e,0x7c23003b,0x00000000}},	//   _nĩ_, _توپ_, _înro,
  { {0x7aee00fe,0x69dc07af,0x7c670242,0x00000000}},	//   äntä, _ebre, _داخل,
  { {0x958507b0,0x7c2d07b1,0xdcf50058,0x00000000}},	//   олле, mhar, mazı,
  { {0x7c2d07b2,0x7a20004d,0xc1b70042,0x00000000}},	//   lhar, _nöth, _आयेग,
  { {0x44f8001b,0xafdb00b9,0x240907b3,0x00000000}},	//   _cĩ_, rnøj, инки_,
  { {0x7afd07b4,0x7c2d07b5,0x44f8008b,0x00000000}},	//   _krst, nhar, _dĩ_,
  { {0x20f7000c,0xc7b900ea,0x7c2d07b6,0x00000000}},	//   _săi_, _idő_, ihar,
  { {0xdcf5005b,0x7c2d07b7,0x20f700dd,0x00000000}},	//   hazı, hhar, _păi_,
  { {0x7c2d07b8,0x7bcf07b9,0x629b07ba,0x00000000}},	//   khar, _occu, spuo,
  { {0x629b0072,0x20f7003b,0x20d107bb,0x00000000}},	//   ppuo, _văi_, rái_,
  { {0x442d0027,0x7c2d07bc,0xdcb1008b,0x00000000}},	//   mhe_, dhar, ẩn_,
  { {0x442d0016,0x7c2d014f,0x7bcf07bd,0x00000000}},	//   lhe_, ehar, _accu,
  { {0x7afd0019,0x442d07be,0xa06a07bf,0x00000000}},	//   _arst, ohe_, _кака_,
  { {0x442d07c0,0x628b0035,0x645b07c1,0x00000000}},	//   nhe_, _kugo, noui,
  { {0x63ab07c2,0x628b07c3,0x628307c4,0x00000000}},	// [840] _megn, _jugo, _kino,
  { {0x62830080,0x63ab07c5,0x644907c6,0x00000000}},	//   _jino, _legn, hnei,
  { {0x7afd07c7,0x7c2d0027,0x443f0006,0x00000000}},	//   _erst, bhar, kiu_,
  { {0x62990051,0x645b0003,0x7c2d031d,0x00000000}},	//   _otwo, joui, char,
  { {0x629900e8,0x44f8001b,0x98ab001c,0x00000000}},	//   _ntwo, _sĩ_, āmās_,
  { {0x7c240004,0xafdb00d1,0x63ab004b,0x00000000}},	//   lkir, tnøk, _aegn,
  { {0x7a2000bd,0x443f0024,0x291c0019,0x00000000}},	//   _nöti, fiu_, ävad_,
  { {0x6283024a,0x64490146,0x443f07c8,0x00000000}},	//   _aino, gnei, giu_,
  { {0x63ab0290,0xafdb00d1,0x7c2407c9,0x00000000}},	//   _degn, snøk, ikir,
  { {0x386607ca,0x442d07cb,0x628b07cc,0x00000000}},	//   llor_, ahe_, _dugo,
  { {0x72330032,0xf99301f9,0x442d0025,0x00000000}},	//   بريط, ורת_, bhe_,
  { {0x442d07cd,0x443f07ce,0x63ab07cf,0x00000000}},	//   che_, ciu_, _gegn,
  { {0xe1ef006a,0xd5b1001b,0x3866000c,0x00000000}},	//   رسی_, _hóa_, ilor_,
  { {0x628307d0,0x7c2407d1,0x644007d2,0x00000000}},	//   _gino, ekir, limi,
  { {0x56370047,0x7c2d07d3,0x644007d4,0x00000000}},	//   קאלע_, thar, oimi,
  { {0x7c2d07d5,0x628307d6,0x59dd0053,0x00000000}},	//   uhar, _zino, न्नर,
  { {0xdceb01f7,0x7c2d07d7,0x8d8707d8,0x00000000}},	// [850] ınız, rhar, _мунд,
  { {0x7c2d0009,0x7afd01a6,0x7c2400fe,0x00000000}},	//   shar, _vrst, akir,
  { {0x7c380026,0x644900fe,0xab950086,0x00000000}},	//   ðará, ynei, _нині,
  { {0x443f0268,0xdce5001b,0x7be5027d,0x00000000}},	//   xiu_, _nghĩ, íruč,
  { {0x443f07d9,0x660507da,0x63ab07db,0x00000000}},	//   viu_, зпла, _regn,
  { {0x63ab02f6,0x61e80117,0x65650019,0x00000000}},	//   _segn, jedl, ühho,
  { {0x442d018d,0x443f07dc,0x628307dd,0x00000000}},	//   the_, tiu_, _rino,
  { {0x628307de,0x644007df,0x7bcd07e0,0x00000000}},	//   _sino, gimi, ngau,
  { {0x442d07e1,0x63ab07e2,0xe2990001,0x00000000}},	//   rhe_, _vegn, љао_,
  { {0x442d07e3,0xd6280001,0x7c240089,0x00000000}},	//   she_, _дође_, zkir,
  { {0x63ab07e4,0x442d07e5,0x91fc001c,0x00000000}},	//   _tegn, phe_, plān,
  { {0x6440048e,0x628b002c,0x63ab07e6,0x00000000}},	//   cimi, _tugo, _uegn,
  { {0x62990045,0x7c2400d1,0xeef50085,0x00000000}},	//   _utwo, vkir, мярэ,
  { {0x863500b5,0x60c80137,0x7aed059f,0x00000000}},	//   לאָג_, budm, dwat,
  { {0xd5b1001b,0x32070051,0xdd8f0021,0x00000000}},	//   _xóa_, _inny_, اوف_,
  { {0x7aed0035,0xdddc0240,0x8c460062,0x00000000}},	//   fwat, zorň, чебе,
  { {0x443d00e8,0x7c2407c9,0x38660137,0x00000000}},	// [860] _mmw_, rkir, vlor_,
  { {0x4efb0047,0x7c2407e7,0x644007e8,0x00000000}},	//   _פליג, skir, zimi,
  { {0x7aed0089,0x6440005b,0xae1b07e9,0x00000000}},	//   awat, yimi, _הויכ,
  { {0x644007ea,0x7a2000a5,0x00000000,0x00000000}},	//   ximi, _nötv,   ,
  { {0x386607eb,0x644007ec,0xabfb0063,0x00000000}},	//   rlor_, vimi, _ההכר,
  { {0x6440002b,0xe4a607ed,0x00000000,0x00000000}},	//   wimi, прио,   ,
  { {0x25ac0080,0x443d03a2,0x80c00053,0x00000000}},	//   _vedl_, _bmw_, _विधे,
  { {0x3298000a,0x60c80137,0x61e8001f,0x00000000}},	//   овиќ_, vudm, wedl,
  { {0x61e807ee,0x644007ef,0x62340062,0x00000000}},	//   tedl, rimi, депу,
  { {0x80c00161,0x248c0089,0x4b3700ff,0x00000000}},	//   _विदे, _tudm_, פריל_,
  { {0x66080146,0x64a307f0,0x61e807f1,0x00000000}},	//   _indk, _заха, redl,
  { {0x7aed0045,0xdcb1008b,0xa3e30053,0x00000000}},	//   ywat, ẩm_, _पॉप_,
  { {0xd5b10013,0x82fa007e,0x661a07f2,0x00000000}},	//   _món_, _دراز_, _kotk,
  { {0x661a024a,0xb4b60082,0x00000000,0x00000000}},	//   _jotk, _जिफ़_,   ,
  { {0x61db0063,0xcd740062,0x0d840121,0x00000000}},	//   _הקוד, егръ, елён,
  { {0x7e60003b,0x7aed07f3,0x7bcd0078,0x00000000}},	//   împr, twat, ugau,
  { {0x20090089,0x7bcd07f4,0xa3de0053,0x00000000}},	// [870] _inai_, rgau, द्य_,
  { {0x91fc0418,0x661a007a,0x2bcb0161,0x00000000}},	//   klām, _notk, िलहा,
  { {0x7aed07f5,0x9f52006c,0x7bcd005f,0x00000000}},	//   swat, _rayé_, pgau,
  { {0x6608004b,0xa2bd0042,0x6fbf0042,0x00000000}},	//   _andk, _शिल्, ्लिं,
  { {0xd6db07f6,0x9f520003,0xa6c90054,0x00000000}},	//   сте_, _payé_, ілка_,
  { {0x7a200137,0x9aa4005d,0x6499005e,0x00000000}},	//   _sötv, _سمفو, отир_,
  { {0xcd980063,0xf8ae005d,0x661a07f7,0x00000000}},	//   הדות_, _نکن_, _dotk,
  { {0x3e64013d,0x442b07f8,0x6608004d,0x00000000}},	//   lött_, óc_, _endk,
  { {0x661a01c2,0x15f50042,0x26360022,0x00000000}},	//   _fotk, _इसपर_, głos_,
  { {0x80d90086,0x20090089,0x45d406da,0x00000000}},	//   оєму_, _anai_, _поус,
  { {0xb7bd000c,0x764307f9,0x7a200014,0x00000000}},	//   _alţi, miny, _götu,
  { {0x59dd0161,0xa3ae0053,0x764307fa,0x00000000}},	//   न्तर, करण_, liny,
  { {0x9f5f0026,0xdb06006d,0x7a2007fb,0x00000000}},	//   ðuð_, _pekí, _kött,
  { {0x1e830088,0xfce60086,0x3e6400ea,0x00000000}},	//   клям, мого, jött_,
  { {0x91fc001c,0x3e6400ea,0x7a200137,0x00000000}},	//   klāj, dött_, _mött,
  { {0x69c3006d,0x6ab607fc,0x764307fd,0x00000000}},	//   ónen, tsyf, hiny,
  { {0xcb6707fe,0x09ba0021,0x764307ff,0x00000000}},	// [880] дате_, قطاع_, kiny,
  { {0x67220035,0x76430800,0x3e64013d,0x00000000}},	//   vyoj, jiny, gött_,
  { {0x76430801,0x6ab60137,0x661a0802,0x00000000}},	//   diny, ssyf, _rotk,
  { {0xfbb20161,0x2d980803,0x661a0072,0x00000000}},	//   _ज़िम, lcre_, _sotk,
  { {0x76430150,0x661a0804,0x9e65005d,0x00000000}},	//   finy, _potk, _زاین,
  { {0x2486001f,0xceb90080,0x2d980805,0x00000000}},	//   _siom_, áři_, ncre_,
  { {0xf9830806,0x7a200137,0xa5070092,0x00000000}},	//   _агро, _dött, деја_,
  { {0xa803005a,0x7d010807,0xa957009a,0x00000000}},	//   _изсл, ålsi, _חילק_,
  { {0xa01b007a,0x7a200137,0x76430808,0x00000000}},	//   lmög, _fött, biny,
  { {0x7a200809,0x76430150,0x660800a5,0x00000000}},	//   _gött, ciny, _undk,
  { {0x644b0026,0xa01b004d,0xd46a005e,0x00000000}},	//   ðmið, nmög, _диже_,
  { {0x3e64000f,0x5346080a,0xc326080b,0x00000000}},	//   zött_, _охла, _омек,
  { {0x80c00053,0xe1fa014b,0xa2d30044,0x00000000}},	//   _विवे, _мгд_, _لينت,
  { {0x2009002b,0xfc3f004c,0xe24600f2,0x00000000}},	//   _wnai_, _smí_, _تخصي,
  { {0x463b0047,0x7a200244,0x0cd40505,0x00000000}},	//   קעלע, _löts, корю,
  { {0x69de006f,0x764300ac,0x2009002b,0x00000000}},	//   efpe, ziny, _unai_,
  { {0x3e6400ea,0x76430150,0x61f80150,0x00000000}},	// [890] tött_, yiny, _kavl,
  { {0x61f8074f,0x61fa080c,0x9987004c,0x00000000}},	//   _javl, ndtl, ónů_,
  { {0x7a200137,0x91fc001c,0x18a40054,0x00000000}},	//   _rött, elāk, ваєм,
  { {0x2c27019d,0x38c40026,0x7643080d,0x00000000}},	//   _цьог, _sérð_, winy,
  { {0x7643014f,0x78710137,0x91fc008f,0x00000000}},	//   tiny, gåva, glāk,
  { {0xf770006a,0x61f8080e,0x3eb9080f,0x00000000}},	//   جام_, _navl, isst_,
  { {0x9f4e0080,0x76430810,0xa01b0244,0x00000000}},	//   čném_, riny, omöd,
  { {0x764306a7,0x91fc008f,0x2903004b,0x00000000}},	//   siny, blāk, _irja_,
  { {0xa3de0235,0x786a0066,0xd5b10013,0x00000000}},	//   द्ध_, zývk, _hóm_,
  { {0x80c00235,0xaac70082,0x7ac70082,0x00000000}},	//   _विशे, _लिनक, _लिनअ,
  { {0x64450003,0xa87907e9,0xe0460811,0x00000000}},	//   éhis, ּאָר, енни,
  { {0x44f10812,0xdb060024,0xb4fa0063,0x00000000}},	//   _iš_, _leká, _מפעי,
  { {0xd24e006a,0x69d50051,0xd12e007e,0x00000000}},	//   _گنو_, _ocze, لمی_,
  { {0x69c3006d,0x2d980813,0x2d8c06a5,0x00000000}},	//   ónel, ucre_, øde_,
  { {0xdb040814,0x68e20022,0x1d070815,0x00000000}},	//   mbié, łodz, нери_,
  { {0x224500a4,0x3c2e0066,0xd259008f,0x00000000}},	//   lilk_, _býva_, ruņu_,
  { {0x5aca0085,0x2f550085,0xa9a60816,0x00000000}},	// [8a0] ялам_, _атэс, еизд,
  { {0x4a430817,0x224500a4,0xa01b004d,0x00000000}},	//   гнув, nilk_, tmög,
  { {0x4c860818,0x442f06aa,0xd8260330,0x00000000}},	//   _плов, _olg_, нджи,
  { {0x7641001f,0xdc9b0047,0xa01b0649,0x00000000}},	//   _amly, _מיטל, rmög,
  { {0x44f100eb,0x224500a4,0x45d406b4,0x00000000}},	//   _aš_, kilk_, волс,
  { {0xdcfc04ab,0xceb30819,0xd4910013,0x00000000}},	//   ları, ניו_, _bù_,
  { {0xb5a50054,0x64c300de,0x85b700de,0x00000000}},	//   трій, هيول, راوس_,
  { {0x6f040529,0xd4910013,0x7641002b,0x00000000}},	//   _oric, _dù_, _emly,
  { {0x3254005e,0x61f8081a,0x9961008f,0x00000000}},	//   квир, _pavl, _cīņa_,
  { {0x2d8c0024,0x442f069f,0xdb04006c,0x00000000}},	//   ždej_, _elg_, rbiè,
  { {0xdcfc01f7,0x6d49000c,0x3a370063,0x00000000}},	//   karı, şeaz, גרים_,
  { {0x6f04081b,0xf9460085,0x00000000,0x00000000}},	//   _bric, ьнiк_,   ,
  { {0x6d48006d,0xdcfc005b,0x7641002b,0x00000000}},	//   údan, darı, _ymly,
  { {0xbe880076,0x6f04081c,0x68e20022,0x00000000}},	//   ессе_, _dric, łody,
  { {0xf1b30063,0x2d85081d,0x6f04081e,0x00000000}},	//   _עסק_, äle_, _eric,
  { {0x6565004b,0xac18081f,0xb0620072,0x00000000}},	//   ühhi, носу_, ääte,
  { {0xf9c70820,0x628a013d,0x6f0400f1,0x00000000}},	// [8b0] ещен, _kifo, _gric,
  { {0x60c80821,0x78710137,0x201900a8,0x00000000}},	//   ordm, gåvn, ljsi_,
  { {0xa928000d,0xbc790086,0xdcfc0058,0x00000000}},	//   ніце_, _обох_, barı,
  { {0x69d50051,0x628a002b,0x612b013d,0x00000000}},	//   _wcze, _lifo, lölö,
  { {0xe8df001b,0x799c001f,0x80380047,0x00000000}},	//   _thỏa_, _ffrw, ענדע_,
  { {0x69d50051,0xdb0600b9,0xd5b1008b,0x00000000}},	//   _ucze, _bekæ, _tóm_,
  { {0x224500c3,0x442f0822,0xe8df0013,0x00000000}},	//   vilk_, _plg_, _muịc_,
  { {0xd1380051,0x13090156,0xb8e70053,0x00000000}},	//   dzą_, дний_, ों_,
  { {0x5695005a,0x95d9000a,0x628a0823,0x00000000}},	//   _разт, _одат_, _bifo,
  { {0xdcfc005b,0x76410014,0x02020085,0x00000000}},	//   zarı, _umly, азьн,
  { {0x628a0824,0xdcfc005b,0xa2bd0053,0x00000000}},	//   _difo, yarı, _शिक्,
  { {0x7d1a0137,0x5046005e,0x6f040825,0x00000000}},	//   ätsm, темб, _pric,
  { {0x63a90826,0xdcfc005b,0x60c800ca,0x00000000}},	//   mben, varı, ardm,
  { {0x78780827,0x6fa20053,0x63a90828,0x00000000}},	//   míve, _क्रू, lben,
  { {0xdcfc005b,0x63a900c3,0xd1380051,0x00000000}},	//   tarı, oben, czą_,
  { {0x218800b5,0xec16007e,0x31560047,0x00000000}},	//   _אָפּ, خورد, _שיקן_,
  { {0x787803d9,0x27fd0185,0xea8a018e,0x00000000}},	// [8c0] níve, ddwn_, дбал_,
  { {0xdcfc005b,0x26cf007d,0x5ee90063,0x00000000}},	//   sarı, dugo_, _נַפְ,
  { {0xdcfc005b,0x7d010829,0x63a900a5,0x00000000}},	//   parı, ålst, kben,
  { {0xc7c30076,0x63a9007d,0xb6a606da,0x00000000}},	//   асши, jben, видл,
  { {0x63a9082a,0xfaa60092,0x56f30044,0x00000000}},	//   dben, _јаго, لأوز,
  { {0x78780080,0x9f420072,0xd5e30054,0x00000000}},	//   díve, mekä_, ижчи,
  { {0x628a051e,0xdb0f017d,0xd946082b,0x00000000}},	//   _rifo, _recé, _реви,
  { {0xa5070138,0x7c360185,0x63a9082c,0x00000000}},	//   ђења_, nhyr, gben,
  { {0x26dd0051,0x7878017d,0x9f4b0331,0x00000000}},	//   ctwo_, gíve, pecé_,
  { {0x62060086,0x0676082d,0x50f401ce,0x00000000}},	//   тчиз, _рубя, гзот,
  { {0x63a9082e,0x64570331,0x628a00dd,0x00000000}},	//   bben, éxic, _vifo,
  { {0x7878017d,0xd1380051,0x03a602b6,0x00000000}},	//   bíve, rzą_, _ридо,
  { {0xd1380045,0x628a082f,0x787800be,0x00000000}},	//   szą_, _tifo, cíve,
  { {0xa3de0161,0xdd1c004c,0xf425004e,0x00000000}},	//   द्र_, láře, _ääre_,
  { {0x69c8005b,0x7d240131,0x26dd056c,0x00000000}},	//   _ödey, афте, ztwo_,
  { {0xdfd10021,0xe8e00013,0xdb0f003b,0x00000000}},	//   _اية_, ýời_, _decî,
  { {0xba5501ce,0x4a550085,0xe451009a,0x00000000}},	// [8d0] гвај, гкас, צֶל_,
  { {0x63a90830,0xbdf502f8,0x5b340044,0x00000000}},	//   zben, _спој, جعفر,
  { {0x27ef0831,0x9848005b,0x09e40054,0x00000000}},	//   tegn_, _ağı_, роєн,
  { {0xdcb1001b,0xdb060832,0x3e760014,0x00000000}},	//   ẩu_, _bekä, mæta_,
  { {0x7878017d,0x27ef0119,0x27fd00a3,0x00000000}},	//   xíve, regn_, rdwn_,
  { {0x7c2d0833,0xd7740021,0x26cf02f7,0x00000000}},	//   lkar, جامع, rugo_,
  { {0x245a001c,0x26dd0051,0xd4690184,0x00000000}},	//   zīme_, stwo_, нике_,
  { {0x63a90834,0x7c2d0835,0x78780836,0x00000000}},	//   uben, nkar, tíve,
  { {0x63a90837,0x1755000d,0xdb06004d,0x00000000}},	//   rben, _свая, _gekä,
  { {0x7d080838,0x63a90839,0x7878017d,0x00000000}},	//   ådsk, sben, ríve,
  { {0x78780016,0x9f4e0080,0xd5b1008b,0x00000000}},	//   síve, čním_, _nói_,
  { {0xddd50080,0xdb0a0240,0x7c2d083a,0x00000000}},	//   mozř, šnéh, jkar,
  { {0x91e5083b,0x442d083c,0x7c2d083d,0x00000000}},	//   _боле, mke_, dkar,
  { {0xf77600b5,0xdd920067,0x7c2d083e,0x00000000}},	//   טערי_, صور_, ekar,
  { {0x8c7a005a,0x7c2d083f,0x5184005e,0x00000000}},	//   ещат_, fkar, _кућа,
  { {0x7c2d00bb,0x442d0840,0x6449003b,0x00000000}},	//   gkar, nke_, niei,
  { {0x9b930032,0x442d0841,0x69da0058,0x00000000}},	// [8e0] إلكت, ike_, _ötek,
  { {0xe9d70842,0x3e760026,0x7c2d0843,0x00000000}},	//   лку_, bæta_, akar,
  { {0x442d0844,0xd5b10013,0x08c60727,0x00000000}},	//   kke_, _gói_, убен,
  { {0x442d0845,0xdbd700bd,0x3c350137,0x00000000}},	//   jke_, mäßi, _påve_,
  { {0x442d0846,0xd7070121,0xdd1c004c,0x00000000}},	//   dke_, лнце_, váře,
  { {0x442d0847,0x7af6002b,0x38c8005d,0x00000000}},	//   eke_, mwyt, _لاری_,
  { {0x64490185,0x7af6001f,0x54e60021,0x00000000}},	//   fiei, lwyt, استق,
  { {0xd4670001,0x25f00053,0x442d0848,0x00000000}},	//   лије_, _इसकी_, gke_,
  { {0x7af6001f,0xa6ca007e,0x91fc001c,0x00000000}},	//   nwyt, _سوال_, klāt,
  { {0xe29f007a,0xd6cf01a7,0x38660849,0x00000000}},	//   íða_, _رقم_, loor_,
  { {0xf5930032,0xddce0078,0x20d3000d,0x00000000}},	//   _المج, albū, біўс,
  { {0x38660186,0x557700b5,0xe29a026b,0x00000000}},	//   noor_, _געבן_, _зад_,
  { {0x80c00053,0x6d5a006c,0x6e95084a,0x00000000}},	//   _विके, ûtan, ригу,
  { {0x38660438,0x764a002b,0x6e940121,0x00000000}},	//   hoor_, nify, сиру,
  { {0x7c2d003d,0x16d10161,0x28c90042,0x00000000}},	//   tkar, _सम्ब, ांछि,
  { {0x3866006f,0x7c2d084b,0xd175000d,0x00000000}},	//   joor_, ukar, _тычы,
  { {0x7c2d084c,0x38660625,0xc3340063,0x00000000}},	// [8f0] rkar, door_, בוּ_,
  { {0x7f3c00b7,0x442d084d,0x386600ca,0x00000000}},	//   _רעזו, zke_, eoor_,
  { {0x442d084e,0x2907084f,0x6449002b,0x00000000}},	//   yke_, ína_, yiei,
  { {0x38660850,0x80d70047,0x00000000,0x00000000}},	//   goor_, רואװ_,   ,
  { {0x76ab0138,0x6f1b00bd,0x442d0851,0x00000000}},	//   хтев_, äuch, vke_,
  { {0x19940086,0xa3e70053,0xa5940062,0x00000000}},	//   _гаря, म्न_, бръщ,
  { {0x3d080053,0x84590852,0x442d0648,0x00000000}},	//   हिये_, крит_, tke_,
  { {0xdd1d0024,0x6a6b00bd,0x91fc001c,0x00000000}},	//   ráňt, rüfu, klās,
  { {0x442d0853,0x42550854,0x7cec013d,0x00000000}},	//   rke_, итот, _körö,
  { {0x27ff00fe,0x442d0855,0x3eb2002b,0x00000000}},	//   _haun_, ske_, _rwyt_,
  { {0x787807a8,0x442d0008,0x30760002,0x00000000}},	//   líva, pke_, иумс,
  { {0xdb0f017d,0x649a07e9,0x6495005f,0x00000000}},	//   _mecâ, _סינה, _ašig,
  { {0x92b70021,0x02a70856,0xdb16006c,0x00000000}},	//   _إحصا, _срем, payé,
  { {0xed5a0138,0x3cfa0857,0xdb0f0858,0x00000000}},	//   вог_, _pspv_, _cecí,
  { {0xdb0f02dd,0x32f60022,0x629b00ca,0x00000000}},	//   _decí, _zły_, lquo,
  { {0xbb76005a,0x63bb0859,0x7c3a008f,0x00000000}},	//   аузъ, naun, ītro,
  { {0x38660122,0x4a4601e8,0x199602d8,0x00000000}},	// [900] voor_, анав, ајер,
  { {0x78780080,0x7af6001f,0xdebb0063,0x00000000}},	//   díva, rwyt, _שמיל,
  { {0x386600ac,0xf1dd0053,0x91fc001c,0x00000000}},	//   toor_, _मानन, olār,
  { {0x63bb003d,0xdb0f0529,0xa9670330,0x00000000}},	//   jaun, _decâ, шиха_,
  { {0x386600e8,0x27ff003e,0x8f9b0063,0x00000000}},	//   roor_, _daun_, דיני,
  { {0x7cec00ea,0xddc7085a,0x3866085b,0x00000000}},	//   _görö, oljš, soor_,
  { {0xa3e70053,0x764a085c,0x38660524,0x00000000}},	//   म्भ_, rify, poor_,
  { {0x63bb085d,0x27ff0360,0x8ba9009a,0x00000000}},	//   gaun, _gaun_, ְׁתִ,
  { {0xd3770121,0x46a3085e,0xd6cf0044,0x00000000}},	//   ичь_, _матв, _يقف_,
  { {0x27ff004d,0x2258004b,0xa01b0046,0x00000000}},	//   _zaun_, õrk_, gmön,
  { {0xd1300021,0xdb0f07a8,0x73c6005d,0x00000000}},	//   سمح_, _recí, _نيام,
  { {0x27e60185,0x9202001c,0x2000003b,0x00000000}},	//   nfon_, _šāda, _caii_,
  { {0x20050080,0xa8570063,0x629b006c,0x00000000}},	//   ěli_, שיכה_, cquo,
  { {0x20050045,0x7a320146,0x290a085f,0x00000000}},	//   śli_, _sætn, _orba_,
  { {0x2ca500ac,0xcd040121,0x41270002,0x00000000}},	//   ëld_, очти, _војо_,
  { {0x7055006a,0x69dc0860,0xec340086,0x00000000}},	//   _دنبا, _acre, онсь,
  { {0x290a0812,0x207c0047,0x5a35065b,0x00000000}},	// [910] _arba_, _באהא, бнат,
  { {0xe9190054,0x27ff004b,0x7a380861,0x00000000}},	//   лозі_, _saun_, апур_,
  { {0x7cec00ea,0x27e60862,0xa3e70042,0x00000000}},	//   _vörö, ffon_, म्ड_,
  { {0x78780863,0xb7bd00dd,0xb8ef0042,0x00000000}},	//   tíva, _boţa, _शि_,
  { {0x7cec000f,0x290a0290,0x3c350137,0x00000000}},	//   _törö, _erba_, _gåva_,
  { {0x248f0150,0x69dc0139,0x63a20864,0x00000000}},	//   _sigm_, _gcre, _afon,
  { {0x44f8008b,0xe8020053,0x290a0734,0x00000000}},	//   _cũ_, _रोका_, _grba_,
  { {0xed580063,0xd64d000d,0x6d480025,0x00000000}},	//   יבור_, _лiпе, údai,
  { {0xdb060865,0x63bb0866,0x86980867,0x00000000}},	//   _sekú, raun, _вкус_,
  { {0xe4e7019d,0x629b0164,0xb06300fe,0x00000000}},	//   _відн, rquo, äänt,
  { {0x63a2001f,0x63bb00a4,0x9f5e0080,0x00000000}},	//   _ffon, paun, ětí_,
  { {0x44e103ad,0xaac70053,0x66010868,0x00000000}},	//   mó_, _लिंक, _halk,
  { {0x69c70869,0x44e1086a,0x6601086b,0x00000000}},	//   _odje, ló_, _kalk,
  { {0x660100fe,0xf6790047,0x6da3086c,0x00000000}},	//   _jalk, טאָמ, зира,
  { {0x44e1086d,0x6601086e,0x2d8c086f,0x00000000}},	//   nó_, _malk, äde_,
  { {0x69dc0870,0xdb0a0080,0x44e10871,0x00000000}},	//   _scre, šníh, ió_,
  { {0x63b90185,0x290a017f,0x62990150,0x00000000}},	// [920] _mewn, _srba_, _juwo,
  { {0xbf9b03d9,0x386d0872,0x49960330,0x00000000}},	//   ndên, _aker_, сшат,
  { {0x31ba00b5,0x44e10873,0x497a000d,0x00000000}},	//   רזענ, jó_, усаў_,
  { {0xe73a0055,0x387f0027,0xf3f9003b,0x00000000}},	//   лее_, _chur_, boţi_,
  { {0x27e6001f,0xa01b004b,0x66010874,0x00000000}},	//   rfon_, dmöl, _balk,
  { {0x63a2051e,0x7ae40875,0xceb3009f,0x00000000}},	//   _sfon, mtit, ליד_,
  { {0x44e10876,0x96c40053,0x26cf0877,0x00000000}},	//   gó_, _रिकॉ, argo_,
  { {0x44f8001b,0xd5b10013,0x39570063,0x00000000}},	//   _vũ_, _sót_, _השלם_,
  { {0x32660878,0x8c1b0063,0x8506007e,0x00000000}},	//   йтов, רופי, _گوان,
  { {0x11d80032,0x3e7f0164,0x44e10879,0x00000000}},	//   جودة_, oîte_, bó_,
  { {0x04960032,0x44e102dd,0x71740032,0x00000000}},	//   _الصح, có_, تهدا,
  { {0x7c26087a,0x6e25005b,0xbfab0121,0x00000000}},	//   _nokr, _sohb, ытое_,
  { {0x447b00b7,0x7878013d,0x1fa40085,0x00000000}},	//   _ענדע, hívo, ярэг,
  { {0xbc95000a,0x63b90045,0x39dd0053,0x00000000}},	//   жавј, _zewn, न्फ़ि,
  { {0x90a60242,0x7c26087b,0x7ae4087c,0x00000000}},	//   _احتم, _bokr, etit,
  { {0x98c5001c,0x7d03013d,0x7a20087d,0x00000000}},	//   ūtīt_, eírá, _götz,
  { {0x44e1000f,0x78780024,0x2fc901b9,0x00000000}},	// [930] zó_, tívn, _idag_,
  { {0x44e102dd,0x98b8005b,0x386d087e,0x00000000}},	//   yó_, _ayrı_, _sker_,
  { {0xda780257,0x291e01a8,0x442604f9,0x00000000}},	//   сят_, _àtal_, _ooo_,
  { {0x44e102dd,0x6f0d087f,0x78780195,0x00000000}},	//   vó_, _krac, sívn,
  { {0xfaff001c,0x7d030880,0x66010881,0x00000000}},	//   šību_, bírá, _palk,
  { {0x44e10882,0xd12601a7,0x69c70883,0x00000000}},	//   tó_, _قم_, _udje,
  { {0x63b90045,0xe3b10032,0x66010884,0x00000000}},	//   _pewn, ورة_, _valk,
  { {0x386d0031,0x44e10885,0x66010886,0x00000000}},	//   _uker_, ró_, _walk,
  { {0x44e10885,0x66010887,0xe299005e,0x00000000}},	//   só_, _talk, јао_,
  { {0x63b90051,0x44e1006d,0x60e90888,0x00000000}},	//   _wewn, pó_, амом_,
  { {0x6f0d01f7,0xfbdf0016,0x3ea9003b,0x00000000}},	//   _arac, _ocê_, _atat_,
  { {0x7ae40889,0xa01b0137,0x44c5001c,0x00000000}},	//   ytit, lmöj, mē_,
  { {0x44c5001c,0x6da60121,0x6f0d088a,0x00000000}},	//   lē_, жига, _crac,
  { {0x44260625,0x7c26088b,0x6f0d088c,0x00000000}},	//   _zoo_, _sokr, _drac,
  { {0x27ed00bd,0x44c5001c,0xafdb01f2,0x00000000}},	//   _oben_, nē_, giøs,
  { {0x6a7000bd,0xeb970076,0x7ae4088d,0x00000000}},	//   häft, жит_, ttit,
  { {0x3b07026b,0xdb04017d,0x3a26088e,0x00000000}},	// [940] оето_, ibiç, омаг,
  { {0x32050034,0x7878088f,0x7ae40890,0x00000000}},	//   ndly_, tívo, rtit,
  { {0xd23a0047,0xdb1d00b9,0x7c260891,0x00000000}},	//   סגעל, _ndsæ, _tokr,
  { {0x44c5001c,0x7d03013d,0x7ae40892,0x00000000}},	//   dē_, sírá, ptit,
  { {0xc7a30893,0x7d03004c,0xfaa60894,0x00000000}},	//   фичк, pírá, _фаго,
  { {0xe4a6000a,0x3af900b5,0x27ed00bd,0x00000000}},	//   орио, _פּרע, _eben_,
  { {0xc7a60062,0xd4970895,0xc8b50085,0x00000000}},	//   _мивк, оры_, _нсты,
  { {0xe4660058,0x320500e5,0xf2c60896,0x00000000}},	//   _önüş, edly_, осон,
  { {0x83fd00ea,0x69da005b,0x442600be,0x00000000}},	//   rlőp, _ötes, _voo_,
  { {0x26c00078,0x44260897,0xc5160044,0x00000000}},	//   šios_, _woo_, _وبات,
  { {0x4a7b00b5,0x64950080,0x44260898,0x00000000}},	//   שריב, _všic, _too_,
  { {0x320500e5,0x40340121,0x6f0d07f7,0x00000000}},	//   adly_, деюс, _prac,
  { {0xe67b008b,0x3d950899,0x9ed8089a,0x00000000}},	//   _hưở, зигр, омят_,
  { {0xdef80088,0x6f0d089b,0x68e500a3,0x00000000}},	//   цыю_, _vrac, ythd,
  { {0x6ce4019d,0xbc4b000d,0x6288004b,0x00000000}},	//   міте, ачае_, mmdo,
  { {0x6f0d089c,0xafdb0093,0x26110053,0x00000000}},	//   _trac, riøs, _धोनी_,
  { {0x44c5001c,0x97ea005b,0x5a3502b6,0x00000000}},	// [950] zē_, ışlı, пнат,
  { {0x78a300ea,0xf8b1007e,0xda78089d,0x00000000}},	//   ínvo, فکر_, оях_,
  { {0x57f50062,0x6e210244,0x00000000,0x00000000}},	//   зпет, ölbu,   ,
  { {0x68e504bf,0x44c5008f,0x9cd60063,0x00000000}},	//   rthd, vē_, _צורה_,
  { {0xafdb00b9,0x8c1a089e,0x8bc40085,0x00000000}},	//   chøe, _הורי, _ўсюд,
  { {0xafdb0031,0x1efc0047,0x44c5008f,0x00000000}},	//   rnøy, ילדע, tē_,
  { {0x6a70089f,0xafdb00d1,0x7af90058,0x00000000}},	//   räft, snøy, şatı,
  { {0x57f4018e,0xa01b0137,0x44c5001c,0x00000000}},	//   _опст, smöj, rē_,
  { {0xf7490032,0xe3b1007e,0x44c5001c,0x00000000}},	//   _الذي_, ورک_, sē_,
  { {0x3637006a,0x44c5001c,0xd5b10013,0x00000000}},	//   _بررس, pē_, _góp_,
  { {0x216908a0,0x32050034,0xdb1d00b9,0x00000000}},	//   сини_, rdly_, _udsæ,
  { {0x29360047,0x644b051c,0x3ea401c8,0x00000000}},	//   פארן_, _umgi, ímto_,
  { {0x20040024,0xf3f900dd,0x3e760014,0x00000000}},	//   ľmi_, meţ_, læti_,
  { {0xf3f9003b,0x200408a1,0x645b004e,0x00000000}},	//   leţ_, žmi_, lnui,
  { {0xc692014e,0xafdb0093,0x91ba0063,0x00000000}},	//   תאם_, riør, _המצי,
  { {0xc0a80021,0x01340049,0x7aa60121,0x00000000}},	//   _باول_, _تعهد, зиаз,
  { {0x9983004c,0x9205008f,0xf093009a,0x00000000}},	// [960] _bojů_, apāņ, _אנה_,
  { {0xb4bb0053,0x97ea0058,0x499a066e,0x00000000}},	//   _अबू_, ışmı, стая_,
  { {0x7d0100b9,0xd7ef08a2,0x9e650044,0x00000000}},	//   ælst, ну_, _تاين,
  { {0xdb040122,0xfc320032,0x7a320014,0x00000000}},	//   ncië, _أحد_, _mæti,
  { {0xfbd3014e,0x7c360137,0xf3f9003b,0x00000000}},	//   _אתר_, mkyr, deţ_,
  { {0xe8df001b,0xdb0f017d,0xd6a9007e,0x00000000}},	//   _giữa_, _secç, زدهم_,
  { {0x4dfb0041,0x9f42017c,0x9abe0085,0x00000000}},	//   מפסא, veký_, вiча_,
  { {0xe73a06da,0x7c2408a3,0x7c3601e9,0x00000000}},	//   _леб_, njir, nkyr,
  { {0xdb0600ea,0xf7430896,0x75960044,0x00000000}},	//   _nekü, _зето, _فجاء,
  { {0x7a320026,0x443f08a4,0x645b006f,0x00000000}},	//   _bæti, ahu_, anui,
  { {0x26190053,0x443f08a5,0xf1dd0053,0x00000000}},	//   पारी_, bhu_, _मारन,
  { {0xc48608a6,0xdb0600ea,0x73e6000d,0x00000000}},	//   _элек, _bekü, _ходз,
  { {0x7a3200b9,0xee870121,0xbf340330,0x00000000}},	//   _tæth, зыво, енящ,
  { {0x13170063,0xf0b7007e,0x6ca708a7,0x00000000}},	//   _מחדל_, _کاوش_, зраж,
  { {0x7a32007a,0xc27b0063,0xe9ff008b,0x00000000}},	//   _gæti, _הרגי, _ngạc_,
  { {0x415b014e,0x31c60080,0x2d580086,0x00000000}},	//   _לדוג, bízí_, чись_,
  { {0xdb040164,0xdb06004d,0xdb0d0003,0x00000000}},	// [970] nciè, _gekü, rbaï,
  { {0x61fa0436,0xe29f0014,0x79a408a8,0x00000000}},	//   netl, íði_, ерце,
  { {0x24890024,0x60da005b,0x6ca402fa,0x00000000}},	//   ňami_, nutm, _пряж,
  { {0xf770006a,0x61fa08a9,0xf775071f,0x00000000}},	//   گام_, hetl, мулю,
  { {0x61fa01f7,0x64400025,0x7c3a0003,0x00000000}},	//   ketl, dhmi, être,
  { {0x61fa017f,0xf3f9003b,0xf77008aa,0x00000000}},	//   jetl, inţe_, دام_,
  { {0x443f08ab,0x91b3008d,0xf3f900dd,0x00000000}},	//   thu_, _đèn_, teţ_,
  { {0xc9520063,0x52a908ac,0xd2a905f4,0x00000000}},	//   _סמן_, овим_, окие_,
  { {0x13060076,0xf3f9003b,0xa3df0053,0x00000000}},	//   дный_, reţ_, तलब_,
  { {0x68e100c7,0x6440005b,0x645b08ad,0x00000000}},	//   _älds, ahmi, snui,
  { {0x95c4007e,0xf3f9003b,0xdb0401a8,0x00000000}},	//   _سينه, enţe_, aciè,
  { {0xcdc9014e,0x78a900c2,0x644008ae,0x00000000}},	//   _כך_, _čevl, chmi,
  { {0xdb040122,0x4374018e,0x61fa08af,0x00000000}},	//   rcië, _пушт, betl,
  { {0x291101f4,0xa2940054,0x0caa0044,0x00000000}},	//   _orza_, _зачі, قطري_,
  { {0xf3f9003b,0x1d0708b0,0xebe60054,0x00000000}},	//   anţe_, мери_, мовп,
  { {0x6e210014,0x00000000,0x00000000,0x00000000}},	//   ölbr,   ,   ,
  { {0x29030019,0x7c240089,0xfaff001c,0x00000000}},	// [980] _asja_, rjir, šīnu_,
  { {0x6f0400ac,0x7c3608b1,0x2911007d,0x00000000}},	//   _isic, skyr, _brza_,
  { {0x32070037,0xac860086,0x3ea00164,0x00000000}},	//   _many_, _огол, _huit_,
  { {0x68e300cd,0x999a0078,0x648500be,0x00000000}},	//   ànda, tipų_, nóid,
  { {0x61fa0779,0x46a3000d,0x87030200,0x00000000}},	//   yetl, вачв, вяще,
  { {0x443d001f,0x26c6004b,0x28db0042,0x00000000}},	//   _alw_, rsoo_, मूहि,
  { {0x5e5700b5,0xe0c7007e,0x3ea008b2,0x00000000}},	//   ויסע_, _جز_, _luit_,
  { {0x61fa08b3,0x47d30021,0xdb040331,0x00000000}},	//   wetl, _ليفر, ecié,
  { {0x3ea00164,0x68e100c7,0x61fa00ea,0x00000000}},	//   _nuit_, _äldr, tetl,
  { {0x443d001f,0xdb040003,0xa6830141,0x00000000}},	//   _elw_, rciè, _алуд,
  { {0x60da0019,0x61fa08b4,0x320708b5,0x00000000}},	//   uutm, retl, _dany_,
  { {0x68e100c7,0x3ea008b6,0xf9930063,0x00000000}},	//   _ålde, _buit_, כרת_,
  { {0x3ead00f5,0xc7b30063,0x69ce08b7,0x00000000}},	//   ëet_, כבר_, _odbe,
  { {0x3ea008b8,0x799c002b,0x52130085,0x00000000}},	//   _duit_, _ngrw, _адшт,
  { {0xd308001b,0x6e9408b9,0x64850139,0x00000000}},	//   _hệ_, тиру, bóid,
  { {0x3ea00003,0xd3080013,0x1bbb0021,0x00000000}},	//   _fuit_, _kệ_, تاسع_,
  { {0x661a0250,0x629800ea,0x7a320026,0x00000000}},	// [990] _ontk, _kivo, _lætu,
  { {0x20090229,0xdcfc0075,0x660808ba,0x00000000}},	//   _haai_, abrı, _nadk,
  { {0xd308001b,0xb86b0002,0x7a320014,0x00000000}},	//   _lệ_, ојде_, _nætu,
  { {0xa2cf0161,0xec350047,0x31570047,0x00000000}},	//   _दिल्, _נאָר_, ויבן_,
  { {0xd7580044,0x386f0023,0xe7240044,0x00000000}},	//   وجها_, rogr_, َّمَ,
  { {0x2009021f,0xdb1d0024,0x629801b3,0x00000000}},	//   _laai_, _odsú, _nivo,
  { {0x67d50001,0x69c508bb,0x32070022,0x00000000}},	//   _пову, mahe, _rany_,
  { {0x69c50019,0x2ca10089,0xdcb1008b,0x00000000}},	//   lahe, _muhd_, ẩy_,
  { {0xb7bd003b,0x2fc001a8,0x629808bc,0x00000000}},	//   _noţi, _reig_, _bivo,
  { {0x64950006,0x7a320014,0x69c508bd,0x00000000}},	//   _išim, _fætu, nahe,
  { {0x3ea004bc,0x7a320026,0x2009006f,0x00000000}},	//   _suit_, _gætu, _baai_,
  { {0x7a32007a,0x78780240,0xd00a0002,0x00000000}},	//   _hætt, tívi, чеме_,
  { {0x648508be,0x2fc000cd,0x200900ac,0x00000000}},	//   róid, _veig_, _daai_,
  { {0xe29f007a,0x3ea000cd,0x64850025,0x00000000}},	//   íðu_, _vuit_, sóid,
  { {0x75f3005b,0x7a3208bf,0x69c508c0,0x00000000}},	//   mızı, _mætt, dahe,
  { {0x98a70080,0x6f040025,0x629808c1,0x00000000}},	//   šně_, _tsic, _zivo,
  { {0xfc3f0025,0x6f040035,0xada608c2,0x00000000}},	// [9a0] _dlí_, _usic, _папл,
  { {0x75f301f7,0x19b90088,0x69c508c3,0x00000000}},	//   nızı, дуць_, gahe,
  { {0xa3df016a,0xba3b00cd,0x27fd001f,0x00000000}},	//   तला_, _suïc, fewn_,
  { {0xe7860086,0xc18c0047,0x248d08c4,0x00000000}},	//   нуло, קטאָ, jmem_,
  { {0x7a3208c5,0x660800ac,0x63a908c6,0x00000000}},	//   _bætt, _padk, dcen,
  { {0x69ce0146,0x63a908c7,0x672d0072,0x00000000}},	//   _udbe, ecen, äaja,
  { {0x6298051e,0xa5070131,0x00000000,0x00000000}},	//   _rivo, ееја_,   ,
  { {0x63a900b9,0x55030121,0xdb0401a8,0x00000000}},	//   gcen, учша, nciï,
  { {0xa01b007a,0x200900ac,0xdb080003,0x00000000}},	//   llög, _raai_, élèv,
  { {0x24860037,0x63a908c8,0xd308001b,0x00000000}},	//   _whom_, acen, _vệ_,
  { {0xb7bd000c,0x629808c9,0xa01b0014,0x00000000}},	//   _soţi, _vivo, nlög,
  { {0x44cc0080,0xd308008b,0x63a908ca,0x00000000}},	//   mě_, _tệ_, ccen,
  { {0x629808cb,0x84570041,0x00000000,0x00000000}},	//   _tivo, _אבאס_,   ,
  { {0x61460164,0xfc3f0025,0x200900ac,0x00000000}},	//   _célé, _slí_, _waai_,
  { {0x44cc0080,0x69c50004,0x61460164,0x00000000}},	//   ně_, vahe, _délé,
  { {0x9f52006d,0x8aa70076,0x69c500a4,0x00000000}},	//   _cayó_, ержд, wahe,
  { {0x657a001f,0x69c508cc,0x3e760046,0x00000000}},	// [9b0] _lyth, tahe, tætt_,
  { {0xbbeb007e,0xf3f9003b,0x248d0051,0x00000000}},	//   _کردم_, inţa_, zmem_,
  { {0xe61f001b,0xa01b0137,0x7878013d,0x00000000}},	//   _đô_, rlöf, hívu,
  { {0x44cc0080,0x7a320146,0xd759002a,0x00000000}},	//   dě_, _sætt, ولات_,
  { {0x657a0137,0x245a008f,0xd763005d,0x00000000}},	//   _ayth, nīmu_, دنشی,
  { {0x64950114,0x657a001f,0xc8f50094,0x00000000}},	//   _všim, _byth, _изгъ,
  { {0xf3f9000c,0x63a908cd,0x7aed08ce,0x00000000}},	//   enţa_, tcen, ltat,
  { {0x657e0058,0x612a0058,0x6d5808cf,0x00000000}},	//   üpha, zölç, _žvak,
  { {0x4864005a,0x7a3205b9,0x1422000d,0x00000000}},	//   _сърб, _tætt, рдым,
  { {0x25ac08d0,0x44cc0080,0xdb080003,0x00000000}},	//   _gfdl_, bě_, élév,
  { {0x63a908d1,0x387d001f,0xf3f9003b,0x00000000}},	//   pcen, olwr_, anţa_,
  { {0x321c08d2,0x6146006c,0x7aed08d3,0x00000000}},	//   _envy_, _sélé, ktat,
  { {0xe28e08d4,0x387d002b,0x7aed013d,0x00000000}},	//   _ва_, ilwr_, jtat,
  { {0x7aed08d5,0x2d9e00d1,0xc0a8007e,0x00000000}},	//   dtat, øte_, بایل_,
  { {0x7aed06c6,0xa01b0137,0x442f007d,0x00000000}},	//   etat, flöd, _kog_,
  { {0x442f08d6,0xb06300fe,0xe8df0013,0x00000000}},	//   _jog_, äätt, _nhựa_,
  { {0x614603b2,0x7aed00bb,0x442f017f,0x00000000}},	// [9c0] _télé, gtat, _mog_,
  { {0x4a4308d7,0x442f08d8,0x7878013d,0x00000000}},	//   анув, _log_, hívt,
  { {0x4dd900b5,0x442f016d,0x2dd90047,0x00000000}},	//   _אַרױ, _oog_, _אַרב,
  { {0x44cc0080,0x657a0003,0xa01b0014,0x00000000}},	//   vě_, _ryth, rlög,
  { {0x7aed08d9,0x657a002b,0xb6060062,0x00000000}},	//   ctat, _syth, вяйк,
  { {0x44cc0080,0x98a7000c,0xdb0600ea,0x00000000}},	//   tě_, ână_, _bekö,
  { {0xe976007e,0x0466005e,0x442f08da,0x00000000}},	//   _شهرد, ктим, _bog_,
  { {0x2465001c,0xd467005e,0x764108db,0x00000000}},	//   tēma_, кије_, _elly,
  { {0x657a0185,0xa01b0026,0x442f08dc,0x00000000}},	//   _wyth, kmör, _dog_,
  { {0x44cc004c,0x442f002b,0x00000000,0x00000000}},	//   pě_, _eog_,   ,
  { {0x7aed03e8,0x320a0024,0x442f000f,0x00000000}},	//   ztat, ľby_, _fog_,
  { {0x76580009,0xe5370047,0x320a0114,0x00000000}},	//   livy, _שטאט_, žby_,
  { {0x76410072,0x6d5a0066,0x2d8c004c,0x00000000}},	//   _ylly, útan, ýden_,
  { {0x442f00bd,0x7c2f08dd,0x6f1608de,0x00000000}},	//   _zog_, _socr, _dryc,
  { {0xbca50032,0xe29b0063,0x9f5901a8,0x00000000}},	//   امري, _קשור, mesí_,
  { {0x7aed08df,0x76580035,0xbf670021,0x00000000}},	//   ttat, hivy, _لدخو,
  { {0x4c9407b0,0x7aed08e0,0x5b150085,0x00000000}},	// [9d0] ритс, utat, ымат,
  { {0x7aed08e1,0x201e001c,0x27140013,0x00000000}},	//   rtat, ētie_, _ình_,
  { {0x7aed08e2,0x39a40817,0xda7803d6,0x00000000}},	//   stat, ршув, тят_,
  { {0x7aed08e3,0xdd3a0063,0x87d40085,0x00000000}},	//   ptat, _נערכ, аўшч,
  { {0x1635005a,0x442f000c,0xd7ee0021,0x00000000}},	//   ледя, _rog_, سكو_,
  { {0x6442024a,0x6d580006,0x442f00bd,0x00000000}},	//   _aloi, _žvai, _sog_,
  { {0x7878034d,0x56920001,0xb7bd003b,0x00000000}},	//   tívt, љајт, _soţu,
  { {0x13090619,0x84580076,0x644208e4,0x00000000}},	//   ений_, крыт_, _cloi,
  { {0x628a0027,0x97ea01f7,0x26cd007d,0x00000000}},	//   _bhfo, ıştı, _uveo_,
  { {0x64420050,0x442f0244,0x422508e5,0x00000000}},	//   _eloi, _wog_, удов,
  { {0xe4e40086,0xf3f5007e,0x442f08e6,0x00000000}},	//   _вічн, _متشک, _tog_,
  { {0x64420164,0x61380025,0xab5b00ca,0x00000000}},	//   _gloi, _súlú, _reün,
  { {0x63bb08e7,0xa3e80053,0x60da0170,0x00000000}},	//   mbun, _बात_, artm,
  { {0xb0630019,0xa2d80053,0x63bb08e8,0x00000000}},	//   äärt, _मित्, lbun,
  { {0xdb1d0080,0xa01b08e9,0x63bb0130,0x00000000}},	//   _desí, rmör, obun,
  { {0x6e3c08ea,0x6f1608eb,0x4095000d,0x00000000}},	//   skrb, _tryc, _крыт,
  { {0x63bb00bd,0x6f160080,0xc0530063,0x00000000}},	// [9e0] ibun, _uryc, _לזה_,
  { {0x200208ec,0x996c008f,0xde060131,0x00000000}},	//   leki_, _vēža_, _спои,
  { {0xafdb00b9,0x291e08ed,0x9c66005d,0x00000000}},	//   dhøj, _štab_, _مهدو,
  { {0x46a6000d,0xdb1d004c,0x200208ee,0x00000000}},	//   гадв, _zesí, neki_,
  { {0x601b0072,0x6d69003b,0x29070014,0x00000000}},	//   _hämä, ăpaţ, ænar_,
  { {0x63bb00bd,0x64420025,0xa5f808ef,0x00000000}},	//   ebun, _sloi, теку_,
  { {0xa3e80161,0x7bc608f0,0xbf9b00ac,0x00000000}},	//   _बाद_, _keku, ndêr,
  { {0x20020150,0x765808f1,0x63bb08f2,0x00000000}},	//   jeki_, sivy, gbun,
  { {0x3855011c,0xc1ea0088,0x200201f7,0x00000000}},	//   _търс, ньне_, deki_,
  { {0x64a60086,0x27e60137,0x7bc60150,0x00000000}},	//   _бажа, lgon_, _leku,
  { {0xdb1d017d,0x601b0072,0x27e608f3,0x00000000}},	//   _resí, _nämä, ogon_,
  { {0xa3bb016a,0x27e608f4,0x648508f5,0x00000000}},	//   _अभय_, ngon_, lóin,
  { {0xa857014e,0x27e6002b,0x73360044,0x00000000}},	//   ריכה_, igon_, _حرائ,
  { {0xdb1d017d,0x539b009f,0xa19401fc,0x00000000}},	//   _lesã, _ניגו, _калч,
  { {0xdd950088,0xe7a40161,0x523b0047,0x00000000}},	//   равы, _ओलंप, _אײגנ,
  { {0x200201f7,0x7bc60150,0x5b2708f6,0x00000000}},	//   ceki_, _ceku, льза,
  { {0xba550095,0x63a205b3,0xadd5005e,0x00000000}},	// [9f0] авај, _mgon, _копљ,
  { {0x27e6006f,0x63bb003b,0xa01b004d,0x00000000}},	//   egon_, zbun, blöc,
  { {0x3eb9001c,0x64850405,0x63bb0051,0x00000000}},	//   lpst_, dóin, ybun,
  { {0x64b1003d,0x63a202ae,0x27e9004b,0x00000000}},	//   _jāie, _ngon, üan_,
  { {0x291800e3,0x67d4000a,0x7c2b0019,0x00000000}},	//   _erra_, сочу, ögru,
  { {0x200208f7,0xbada0063,0x64850025,0x00000000}},	//   zeki_, _בקשת, góin,
  { {0xce38014e,0xafdb00b9,0x91f5008b,0x00000000}},	//   ראות_, rhøj, híc,
  { {0x7c2d08f8,0x63a20139,0xd3f9000d,0x00000000}},	//   njar, _cgon, тэкі_,
  { {0x63bb08f9,0x200200ac,0x69c70052,0x00000000}},	//   rbun, veki_, _keje,
  { {0x63bb08fa,0xdb0408fb,0x994a0058,0x00000000}},	//   sbun, nciá, nışa_,
  { {0xd567000a,0xafdb0146,0x10210053,0x00000000}},	//   _стап, dkøb, यांश_,
  { {0xdd2f0080,0x7afd08fc,0x84640062,0x00000000}},	//   _běže, _opst, _лъче,
  { {0x387e03b2,0x644908fd,0x343a0047,0x00000000}},	//   _être_, mhei, _שײנע,
  { {0x442d08fe,0x644908ff,0x7bc60900,0x00000000}},	//   lje_, lhei, _seku,
  { {0x7afd003d,0x31790047,0x27e6001f,0x00000000}},	//   _apst, _באַד, ygon_,
  { {0xef1a06be,0x442d0901,0x443f0902,0x00000000}},	//   _ами_, nje_, nku_,
  { {0x69c7000f,0x442d017f,0x207b0047,0x00000000}},	// [a00] _beje, ije_, _באקא,
  { {0x601b024a,0x628100cd,0x6f09005b,0x00000000}},	//   _tämä, nllo, çece,
  { {0x443f0004,0x6449021f,0x442d0903,0x00000000}},	//   kku_, khei, kje_,
  { {0x1ae60055,0x64490122,0x27e600a4,0x00000000}},	//   _комм, jhei, ugon_,
  { {0x69c700ea,0x442d0904,0x648500ea,0x00000000}},	//   _feje, dje_, tóin,
  { {0x442d0051,0xaa460905,0x443f0368,0x00000000}},	//   eje_, _тегл, eku_,
  { {0x44f1001b,0x7ae40906,0x442d0907,0x00000000}},	//   _cơ_, luit, fje_,
  { {0x64490102,0x62810908,0x443f0909,0x00000000}},	//   ghei, ello, gku_,
  { {0x23380055,0xdc370047,0x7794007e,0x00000000}},	//   уппы_, שאפט_, _ایشا,
  { {0x442d090a,0x443f090b,0x11d80021,0x00000000}},	//   aje_, aku_, دودة_,
  { {0x8506006a,0x442d00c3,0x7ae40025,0x00000000}},	//   _خوان, bje_, huit,
  { {0x442d0045,0x68e300cd,0x63a2090c,0x00000000}},	//   cje_, àndi, _ugon,
  { {0xfe7f090d,0x11f8007e,0x6d4e00dd,0x00000000}},	//   juïc_, _موشک_, ezba,
  { {0x7ae4090e,0x30a6090f,0x66fa008f,0x00000000}},	//   duit, _крив, mākā,
  { {0x69c70910,0x7c2d0911,0xc0e30141,0x00000000}},	//   _reje, tjar, _дојк,
  { {0xe5170161,0x69c70912,0x64400760,0x00000000}},	//   थिति_, _seje, nkmi,
  { {0x7ae40913,0x228b0031,0xdb0f0857,0x00000000}},	// [a10] guit, søke_, _recó,
  { {0x443f0114,0x6f0d01f4,0x7c2d0914,0x00000000}},	//   zku_, _isac, sjar,
  { {0x442d0915,0x69c70916,0x64490917,0x00000000}},	//   yje_, _veje, yhei,
  { {0x7ae40918,0x3ea9053b,0x38660314,0x00000000}},	//   buit, _kuat_, gnor_,
  { {0x3b64005a,0x442d00c3,0x44f1001b,0x00000000}},	//   _дърв, vje_, _sơ_,
  { {0x3ea90089,0x2fc90139,0x85e80054,0x00000000}},	//   _muat_, _leag_, идів_,
  { {0x442d0919,0x6449091a,0x3ea9000c,0x00000000}},	//   tje_, thei, _luat_,
  { {0x442d091b,0x44f10013,0x443f091c,0x00000000}},	//   uje_, _vơ_, uku_,
  { {0xa3e80053,0x442d091d,0x66fa008f,0x00000000}},	//   _बार_, rje_, gākā,
  { {0x62810014,0x44f10013,0x442d091e,0x00000000}},	//   ullo, _tơ_, sje_,
  { {0x8467011c,0x2fc90025,0x628100cd,0x00000000}},	//   _къде, _beag_, rllo,
  { {0x3ea90397,0x66fa008f,0x6440091f,0x00000000}},	//   _buat_, bākā, ckmi,
  { {0x14740021,0x6f63026c,0x91fc001c,0x00000000}},	//   _بالج, звяз, onāl,
  { {0x6d4e00bd,0x3ea90089,0x28d80053,0x00000000}},	//   tzba, _duat_, _डिलि,
  { {0x6f0d00f3,0x32050034,0x6efd00c7,0x00000000}},	//   _esac, mely_, _påbö,
  { {0xa01b00fe,0x2fc900ac,0x320507ee,0x00000000}},	//   llön, _geag_, lely_,
  { {0xfb8a000d,0x6d4e013d,0xddce00a8,0x00000000}},	// [a20] убак_, szba, aobš,
  { {0x239b0006,0x32050920,0x7ae40921,0x00000000}},	//   mąjį_, nely_, ruit,
  { {0x6459006f,0x7ae40922,0x3979000d,0x00000000}},	//   _omwi, suit, асцю_,
  { {0x7ae40923,0xb17a0047,0x2bba0044,0x00000000}},	//   puit, אטער, _حادة_,
  { {0x32050034,0x38660924,0x46f603d1,0x00000000}},	//   kely_, rnor_, счет,
  { {0xdb1d00b9,0x2bd00053,0x91fc001c,0x00000000}},	//   _besæ, तःका, gnāl,
  { {0x32050920,0x186a0925,0x2a6f00ea,0x00000000}},	//   dely_, _бави_, égbe_,
  { {0xfbdf001f,0x91fc001c,0xe8e0008b,0x00000000}},	//   _llên_, anāl, _chụp_,
  { {0x64400026,0x661100fe,0x239b0006,0x00000000}},	//   rkmi, ökkä, jąjį_,
  { {0x64400019,0xd6cf0021,0x66fa001c,0x00000000}},	//   skmi, _أقل_, rākā,
  { {0x5316006a,0x2012003e,0x66fa008f,0x00000000}},	//   _گذار, _bayi_, sākā,
  { {0xfe7f00cd,0xa2e6000d,0xf3f9003b,0x00000000}},	//   duïa_, _годд, tiţe_,
  { {0xa01b0046,0x3205011b,0xddce011b,0x00000000}},	//   blön, bely_, libř,
  { {0xf3f900dd,0x32050926,0x6d140042,0x00000000}},	//   riţe_, cely_, डिंग_,
  { {0x7bcd0026,0x463b0047,0x725b0063,0x00000000}},	//   taau, נעלע, _תכופ,
  { {0xe165007e,0xafdb01e1,0x91fc008f,0x00000000}},	//   _بدهي, ehøv, inām,
  { {0x6a350138,0x765a0137,0x213e002b,0x00000000}},	// [a30] онађ, _omty, lyth_,
  { {0x91f5008b,0xa381004b,0x27ed0927,0x00000000}},	//   hín, öõig, _scen_,
  { {0xc0b2008d,0xa3e80042,0xdb040046,0x00000000}},	//   _rưởi_, बला_, sbið,
  { {0xac190928,0xb9010053,0xc0b20013,0x00000000}},	//   _тому_, _दि_, _sưởi_,
  { {0xb06600fe,0x68e50072,0x76460078,0x00000000}},	//   ltää, suhd, _įkyr,
  { {0xf7700929,0x1a94000d,0x79c9005d,0x00000000}},	//   ران_, _наяў, _خوسف_,
  { {0x32050037,0xb066024a,0x91fc001c,0x00000000}},	//   vely_, ntää, rnāl,
  { {0x68e300cd,0xb0660072,0x3205002b,0x00000000}},	//   àndu, itää, wely_,
  { {0x32050037,0xb0660072,0xdb1d00be,0x00000000}},	//   tely_, htää, _desç,
  { {0xe4e70086,0x239b0078,0xc59501ce,0x00000000}},	//   _гідн, vąjį_, _дизј,
  { {0x386d0198,0x32050034,0x69d8017d,0x00000000}},	//   _kjer_, rely_, óvei,
  { {0x76430831,0x44f30016,0xdb1d00fe,0x00000000}},	//   lkny, mã_, _kesä,
  { {0x2d85092a,0x31790022,0x3205092b,0x00000000}},	//   ülen_, łsz_, pely_,
  { {0xdca6006e,0x239b0078,0xa01b0072,0x00000000}},	//   жави, rąjį_, llöl,
  { {0xf3f90529,0x2d8c092c,0x76430052,0x00000000}},	//   enţi_, åde_, ikny,
  { {0xac86071f,0x4c860085,0x6fb600de,0x00000000}},	//   ігал, ілав, _بمظا,
  { {0x49ca0001,0xe7ff0053,0xdcef008f,0x00000000}},	// [a40] илан_, ोजना_, ījāt,
  { {0x5e570021,0x387f0089,0xceb9004c,0x00000000}},	//   _وليس_, _akur_, íře_,
  { {0xf3f9003b,0xad590062,0x291c092d,0x00000000}},	//   anţi_, _грях_, íva_,
  { {0x225e00c3,0xfe7f00cd,0xdb1d092e,0x00000000}},	//   zitk_, nuïn_, _besä,
  { {0x7c26092f,0x98a30930,0x6009009a,0x00000000}},	//   _inkr, фице, מִסְ,
  { {0x386d0146,0x96330088,0xc4da0001,0x00000000}},	//   _ejer_, мніц, ађи_,
  { {0x8675000d,0x44f3017d,0xdb070014,0x00000000}},	//   чыцц, gã_, élög,
  { {0x9cd70063,0x7e7c0931,0x66e60932,0x00000000}},	//   קופה_, horp, _моба,
  { {0x1666005a,0x213e001f,0xf20607da,0x00000000}},	//   _двам, wyth_, ояно,
  { {0x7af600eb,0xb06600fe,0x3a3800a8,0x00000000}},	//   ityt, ytää, _jorp_,
  { {0xf21f0053,0x7c260933,0x7e7c0934,0x00000000}},	//   बाज़_, _onkr, dorp,
  { {0x91fc008f,0xc05b012c,0x00000000,0x00000000}},	//   onāk, ріо_,   ,
  { {0x64b1008f,0x289b0041,0xdefb0085,0x00000000}},	//   _jāin, ייטא, шын_,
  { {0x3f85003d,0xb06600fe,0x7c260935,0x00000000}},	//   ālu_, ttää, _ankr,
  { {0x91bb0063,0xf3f9003b,0xdfdb0062,0x00000000}},	//   _דמוי, liţa_, _къп_,
  { {0x1bbb0021,0xb0660072,0x2bbb0044,0x00000000}},	//   شارع_, rtää, شارة_,
  { {0x44260035,0xb06600fe,0xe8df008b,0x00000000}},	// [a50] _mno_, stää, _thừa_,
  { {0x7c2600c3,0x539b0063,0x3a380936,0x00000000}},	//   _enkr, שימו, _corp_,
  { {0x3a380179,0x7af60006,0xf3f9003b,0x00000000}},	//   _dorp_, atyt, hiţa_,
  { {0xa6c90021,0x3835000d,0xdb1d0072,0x00000000}},	//   موصل_, янер, _pesä,
  { {0xab840699,0x290e0014,0x2b520022,0x00000000}},	//   _журк, æfar_, czyc_,
  { {0x44260937,0xd1260021,0xc1780078,0x00000000}},	//   _ano_, _كم_, ngės_,
  { {0x91fc008f,0x044502fe,0x6a140062,0x00000000}},	//   anāk, зейн, _юмру,
  { {0x44f3017d,0x387f017e,0x9479005e,0x00000000}},	//   rã_, _ukur_, љску_,
  { {0x44f300be,0x44260938,0x782400de,0x00000000}},	//   sã_, _dno_, _تعّل,
  { {0x44260198,0xe680003b,0x64aa004c,0x00000000}},	//   _eno_, ălţă, _břid,
  { {0xfe7f01a8,0x7e7c0939,0x051900de,0x00000000}},	//   tuïn_, vorp, _دياب_,
  { {0x44d70529,0xe8df001b,0x7e7c006f,0x00000000}},	//   mă_, _chứa_, worp,
  { {0x44d70529,0x7d1e093a,0x644b093b,0x00000000}},	//   lă_, _srps, _ilgi,
  { {0x629d0080,0x539a009a,0xb2ba009a,0x00000000}},	//   ůsob, _פיסו, _המסר,
  { {0x44d70529,0x44260185,0xa8bc0058,0x00000000}},	//   nă_, _yno_, örüş_,
  { {0xdb0d0025,0x7e7c093c,0x7c95071f,0x00000000}},	//   acaí, sorp, друц,
  { {0x78bb017f,0xaa46000a,0x290300ea,0x00000000}},	// [a60] _čuva, пеал, _apja_,
  { {0x7af6015e,0x3af40137,0x6996093d,0x00000000}},	//   rtyt, räp_, прех,
  { {0x44d7000c,0x18a6093e,0xe8fa093f,0x00000000}},	//   jă_, чаем, сле_,
  { {0xafdb02ab,0x44d7000c,0x3a38006f,0x00000000}},	//   lhør, dă_, _worp_,
  { {0xf7430940,0x91fc008f,0x7bc40046,0x00000000}},	//   нецо, unāk, mbiu,
  { {0x7bc40006,0x76a90086,0xf3f9003b,0x00000000}},	//   lbiu, ітів_, viţa_,
  { {0x44d7000c,0x69dc0941,0xdb07013d,0x00000000}},	//   gă_, _idre, ömör,
  { {0xb6030418,0x68e30942,0x64a3000a,0x00000000}},	//   ēšan, ánde, наја,
  { {0x69ce06a7,0xf363000d,0x7ae40943,0x00000000}},	//   _kebe, етэн, nrit,
  { {0x64aa0080,0x44d7000c,0xf3f9003b,0x00000000}},	//   _přid, bă_, riţa_,
  { {0x44d70529,0x7ae400bd,0x64b30080,0x00000000}},	//   că_, hrit, _přiř,
  { {0x69ce0199,0x44260944,0x6f040025,0x00000000}},	//   _lebe, _uno_, _bpic,
  { {0x69dc055e,0xa8570063,0x9f600014,0x00000000}},	//   _odre, ליטה_, órðu_,
  { {0x539b0063,0x8cb10053,0x6266007e,0x00000000}},	//   _הידו, _आंदो, _عاشق,
  { {0x01fb0063,0x7ae40945,0x51fb0063,0x00000000}},	//   _הפול, erit, _ההוצ,
  { {0x7ae40946,0x69dc0947,0x3cf60042,0x00000000}},	//   frit, _adre, ँढ़ें_,
  { {0x44d70469,0x69ce014f,0x62880948,0x00000000}},	// [a70] ză_, _bebe, oldo,
  { {0x19ab000a,0x69ce0949,0xab840002,0x00000000}},	//   стап_, _cebe, хуск,
  { {0x3d240088,0xdb1d094a,0x69ce094b,0x00000000}},	//   _зьяв, _jesú, _debe,
  { {0xf9900032,0x44d7000c,0x1ab50062,0x00000000}},	//   ابك_, vă_, _обмя,
  { {0x7ae4094c,0x200b0051,0x69ce094d,0x00000000}},	//   crit, ieci_, _febe,
  { {0x44d70469,0x69ce094e,0xcb120063,0x00000000}},	//   tă_, _gebe, _שלם_,
  { {0xdb1d0024,0x7bcf003e,0x78a2004a,0x00000000}},	//   _nesú, _kecu, ňova,
  { {0x44d70529,0x200b017f,0xa01b00c7,0x00000000}},	//   ră_, jeci_, slöj,
  { {0xd5b100aa,0x44d70529,0x7d1c082a,0x00000000}},	//   _các_, să_, zvrs,
  { {0x44d7000c,0xd5d5005d,0x61450782,0x00000000}},	//   pă_, _آقاخ, деоа,
  { {0x7ae40024,0x69c50139,0xd00a0062,0x00000000}},	//   zrit, ibhe, оене_,
  { {0x7bcf000c,0x7ae400fe,0x6aa7006f,0x00000000}},	//   _necu, yrit, _lijf,
  { {0x99830078,0xe1ee0363,0x73c40044,0x00000000}},	//   _kojų_, _иг_, _أيهم,
  { {0xf2d20063,0x91fc001c,0x01650259,0x00000000}},	//   _יעד_, riāc, _окло,
  { {0x7ae4094f,0x7bcf0950,0x69ce0951,0x00000000}},	//   writ, _becu, _rebe,
  { {0x69ce0952,0x7bcf000c,0x7ae40953,0x00000000}},	//   _sebe, _cecu, trit,
  { {0xd5b1001b,0x6d550290,0x7bcf0954,0x00000000}},	// [a80] _xác_, azza, _decu,
  { {0xff5f03b2,0x6aa70122,0xe8df008b,0x00000000}},	//   raît_, _cijf, _chữa_,
  { {0xa90a0021,0x27fd001f,0x7bcf0955,0x00000000}},	//   تيال_, ffwn_, _fecu,
  { {0x313600b5,0xab2a0956,0x7ae40957,0x00000000}},	//   ונעם_, _дома_, prit,
  { {0x3946001c,0xa09b0149,0x69ce0958,0x00000000}},	//   ņos_, קינט, _tebe,
  { {0x69dc0959,0xd5b1008b,0x69ce004d,0x00000000}},	//   _udre, _rác_, _uebe,
  { {0x6935004c,0xdb0601e1,0xaaa70042,0x00000000}},	//   _přeš, _afkø, _कूटक,
  { {0x64aa0080,0xe314000a,0xd7060001,0x00000000}},	//   _přib, емињ, _озби,
  { {0xb66a0002,0x41e60304,0x200b095a,0x00000000}},	//   _диаз_, міна, veci_,
  { {0xd25003eb,0xd62601a7,0x51f80086,0x00000000}},	//   اند_, _تعري, чною_,
  { {0xa01b00fe,0x92570021,0x63b9002b,0x00000000}},	//   llöi, بشير_, _ffwn,
  { {0xc32a0032,0xd5b1001b,0xb84a014b,0x00000000}},	//   _وكان_, _tác_, йлiв,
  { {0x200b005b,0x20190019,0x7bcf095b,0x00000000}},	//   reci_, rdsi_, _recu,
  { {0x200b074f,0x7bcf095c,0x44cc0022,0x00000000}},	//   seci_, _secu, oś_,
  { {0x320c0706,0x1df805ac,0x7bcf095d,0x00000000}},	//   medy_, ьеры_, _pecu,
  { {0x28d80042,0x320c004c,0x5f950217,0x00000000}},	//   _डिजि, ledy_, _пийт,
  { {0x7b6700e1,0x7bcf008f,0xa3b30042,0x00000000}},	// [a90] фтве, _vecu, जुट_,
  { {0x6485095e,0x9967060d,0x16000042,0x00000000}},	//   lóit, мтел, ल्मर_,
  { {0xa3c30235,0x6aa70122,0xba3b00cd,0x00000000}},	//   ्रम_, _vijf, _suïs,
  { {0x6aa7006f,0x99830078,0x7ae2008f,0x00000000}},	//   _wijf, _sojų_, šota,
  { {0x320c0024,0xe70b005d,0x44cc0022,0x00000000}},	//   kedy_, تتان_, eś_,
  { {0x7aed0397,0x24510114,0x88c70044,0x00000000}},	//   muat, _máme_, _يتأل,
  { {0x7aed095f,0x7c3d0960,0xf8b40085,0x00000000}},	//   luat, _kosr, _абсэ,
  { {0xdb1d02ab,0x00000000,0x00000000,0x00000000}},	//   _besø,   ,   ,
  { {0x64aa0080,0x25a9007e,0x13060121,0x00000000}},	//   _přic, _فضای_, еный_,
  { {0x291e0006,0x320c00e5,0xcb120063,0x00000000}},	//   _štai_, gedy_, נלי_,
  { {0x50b5000d,0x1a160047,0x7aed0961,0x00000000}},	//   эспу, ײַיש_, huat,
  { {0x7aed003e,0xa9240066,0xdee60962,0x00000000}},	//   kuat, _ôžet, номи,
  { {0x644900bd,0x64aa0080,0x201e0080,0x00000000}},	//   mkei, _třic, ěti_,
  { {0x443d0034,0x24510240,0x64490963,0x00000000}},	//   _how_, _dáme_, lkei,
  { {0x644900fe,0x7c3d00ca,0x27e0013d,0x00000000}},	//   okei, _bosr, óink_,
  { {0x7aed0009,0x78a90964,0x7c3d032a,0x00000000}},	//   fuat, _niev, _cosr,
  { {0x3b07011c,0x7aed0965,0x644900fe,0x00000000}},	// [aa0] нето_, guat, ikei,
  { {0x443d0034,0x9b930032,0x2fe80022,0x00000000}},	//   _low_, الكت, ługą_,
  { {0x6449024a,0xef18001c,0x62810966,0x00000000}},	//   kkei, āļu_, iolo,
  { {0x443d0034,0x7aed014f,0x68e3006d,0x00000000}},	//   _now_, buat, ánda,
  { {0x0c23005a,0x62810967,0x6843000d,0x00000000}},	//   _смян, kolo, ынца,
  { {0x25fb0161,0x7bd60968,0x246c004c,0x00000000}},	//   ल्ली_, layu, měmi_,
  { {0x443d0969,0x6281096a,0x91fc008f,0x00000000}},	//   _bow_, dolo, ināt,
  { {0x64490199,0x6281096b,0x443d096c,0x00000000}},	//   gkei, eolo, _cow_,
  { {0xa3b70021,0x78a3006f,0x68e10137,0x00000000}},	//   راير_, ïnve, _åldr,
  { {0x644900eb,0x7bd60089,0x24510066,0x00000000}},	//   akei, hayu, _ráme_,
  { {0xa01b00a5,0xd4c50085,0x320c096d,0x00000000}},	//   ilöv, _асіп, redy_,
  { {0xa3c30053,0xd250007e,0x3866096e,0x00000000}},	//   ्रण_, انگ_, nior_,
  { {0xc43b0063,0xe29a005a,0x64850025,0x00000000}},	//   _מתאי, _еад_, róit,
  { {0x661a024a,0x6281096f,0x44fa00ac,0x00000000}},	//   _jatk, colo, oë_,
  { {0xdcb1001b,0x7c3d0970,0x661a0971,0x00000000}},	//   ể_, _posr, _matk,
  { {0x60da02e0,0x661a0972,0x7aed081b,0x00000000}},	//   mstm, _latk, tuat,
  { {0x78a90973,0xde790062,0xeab3009e,0x00000000}},	// [ab0] _riev, _обич_, اعر_,
  { {0x83fd00ea,0xf09f00cd,0x7bd600a4,0x00000000}},	//   lnőt, lmà_, aayu,
  { {0xdd9104de,0x78a9003d,0x7aed0974,0x00000000}},	//   _خود_, _piev, suat,
  { {0x64850025,0x38660290,0x8c440141,0x00000000}},	//   hóir, gior_, _беџе,
  { {0x44fa00e8,0xab5b0122,0xdb0700fe,0x00000000}},	//   eë_, _geüp, ämäs,
  { {0x443d00e3,0xa5090079,0x3866017d,0x00000000}},	//   _sow_, дека_, aior_,
  { {0x64850025,0x62810975,0x443d0976,0x00000000}},	//   dóir, volo, _pow_,
  { {0x3866003b,0xd5b10013,0x62810022,0x00000000}},	//   cior_, _gán_, wolo,
  { {0x64490977,0xf7730021,0x443d00e5,0x00000000}},	//   rkei, _صار_, _vow_,
  { {0x64850025,0x64490978,0xf09f00cd,0x00000000}},	//   góir, skei, emà_,
  { {0x443d0979,0x2127005d,0x6281097a,0x00000000}},	//   _tow_, ريحی_, rolo,
  { {0xa3d20161,0x20040512,0x64850025,0x00000000}},	//   वरण_, ými_, róis,
  { {0x60c400c3,0x6281097b,0x249f0014,0x00000000}},	//   _čime, polo, mmum_,
  { {0x63bb097c,0x248d097d,0x3f8c001c,0x00000000}},	//   lcun, llem_, ādu_,
  { {0x7bd6002c,0x8d63006e,0x957c0022,0x00000000}},	//   tayu, авре, _idąc,
  { {0x3ce500ea,0x63bb097e,0xa3c30042,0x00000000}},	//   álva_, ncun, ्रि_,
  { {0x38660034,0x248d097f,0xcb670980,0x00000000}},	// [ac0] vior_, ilem_, вате_,
  { {0x7bd60981,0x6fa70042,0x3cea0042,0x00000000}},	//   sayu, _गणतं, _छिपे_,
  { {0xa3c30235,0x7bd600a4,0x661a0982,0x00000000}},	//   ्रा_, payu, _ratk,
  { {0xd5b1001b,0x60dc00ea,0x83fd00ea,0x00000000}},	//   _báo_, ármi, inős,
  { {0xd5b100aa,0x69ca007a,0x2ca00019,0x00000000}},	//   _cáo_, ðfes, mmid_,
  { {0xe7370001,0x629d0983,0x2ca0004b,0x00000000}},	//   тељ_, ïsol, lmid_,
  { {0x386600c7,0xbf9b00ac,0xd5b1008d,0x00000000}},	//   pior_, neêr, _tán_,
  { {0x291802e8,0x74670121,0x248d0575,0x00000000}},	//   _isra_, крыв_, glem_,
  { {0x6d470045,0xdb0d0016,0x2ca00025,0x00000000}},	//   zyja, rcaç, imid_,
  { {0x91fc003d,0x60c40734,0xe61a0054,0x00000000}},	//   ciāl, _čimb, _іде_,
  { {0x67220984,0x248d0985,0xb6a3030b,0x00000000}},	//   lvoj, blem_, _тифл,
  { {0xdb04048e,0x64850139,0xf09f01a8,0x00000000}},	//   nció, sóir, umà_,
  { {0xf09f0268,0xdb04006d,0x67220986,0x00000000}},	//   rmà_, ició, nvoj,
  { {0x2ca00019,0xc6940047,0x67220987,0x00000000}},	//   emid_, טאָ_, ivoj,
  { {0xdb0400ea,0x7e67006f,0x4fc70988,0x00000000}},	//   kció, rijp, _испа,
  { {0x30a4000d,0x55770041,0x67220078,0x00000000}},	//   _крыв, דעלן_, kvoj,
  { {0x6e450021,0xddc700c2,0xe29a008d,0x00000000}},	// [ad0] _منظم, anjš, _khư_,
  { {0x68e303ad,0x672202e2,0x2ca00019,0x00000000}},	//   ándo, dvoj, amid_,
  { {0x249f0014,0xb8b40021,0xab62004b,0x00000000}},	//   ymum_, لإنت, üürn,
  { {0x69ca0026,0xa01b0989,0x7ce8009a,0x00000000}},	//   ðfer, mlös, _בַשֶ,
  { {0x64aa0080,0xa01b00fe,0x7c2f0725,0x00000000}},	//   _přin, llös, _incr,
  { {0xe29a00aa,0xdb04048e,0xf3f90529,0x00000000}},	//   _như_, ació, miţi_,
  { {0x91fc003d,0xf3f9000c,0x58d4098a,0x00000000}},	//   riāl, liţi_, _вост,
  { {0xdb04048e,0x63bb0003,0xc984005e,0x00000000}},	//   cció, ucun, _ђури,
  { {0x69d5000f,0xf3f9000c,0x63bb098b,0x00000000}},	//   _keze, niţi_, rcun,
  { {0xa3c30235,0x63bb098c,0x248d098d,0x00000000}},	//   ्रह_, scun, slem_,
  { {0x10a6098e,0xfe7f00cd,0x69d5098f,0x00000000}},	//   лион, nuïu_, _meze,
  { {0x69d50122,0xcea900b5,0x24840990,0x00000000}},	//   _leze, _זי_, comm_,
  { {0xe28e0991,0xa2e50071,0xa01b004d,0x00000000}},	//   _га_, _солд, elös,
  { {0xa01b00bd,0xf3f9003b,0x7c2f0992,0x00000000}},	//   flös, diţi_, _ancr,
  { {0x2d8c0146,0xdc9a0002,0x67220993,0x00000000}},	//   æde_, еташ_, zvoj,
  { {0xfe7f0994,0x2ca0004b,0x61f1003b,0x00000000}},	//   duïu_, umid_, şelă,
  { {0x69d50995,0x2ca00019,0xf3f9003b,0x00000000}},	// [ae0] _beze, rmid_, giţi_,
  { {0xa01b0137,0x442f0996,0x2ca00997,0x00000000}},	//   slöt, _lng_, smid_,
  { {0x69d50998,0x2d8500ea,0x442f0999,0x00000000}},	//   _deze, ület_, _ong_,
  { {0xf3f9003b,0x3e6d0195,0x20d10130,0x00000000}},	//   biţi_, ržte_, iši_,
  { {0xdb0402dd,0xf3f9003b,0x69d5099a,0x00000000}},	//   rció, ciţi_, _feze,
  { {0x442f099b,0xdd25001c,0x69d5099c,0x00000000}},	//   _ang_, līša, _geze,
  { {0x20d10198,0xdb04099d,0x764100a4,0x00000000}},	//   jši_, pció, _doly,
  { {0xdd25001c,0x6d5c008f,0x20d1099e,0x00000000}},	//   nīša, izra, dši_,
  { {0x78a2099f,0x91a90013,0x7641013d,0x00000000}},	//   mmov, _đá_, _foly,
  { {0x76410185,0xfe7f00cd,0x78a209a0,0x00000000}},	//   _goly, nuït_, lmov,
  { {0x2d8c0051,0xd48f07da,0x7413007e,0x00000000}},	//   żdej_, _гр_, _گونا,
  { {0x78a2006d,0x4254005d,0xe3b702d8,0x00000000}},	//   nmov, انگر, _ббц_,
  { {0xe29a001b,0xdd25003d,0x20d109a1,0x00000000}},	//   _thư_, dīša, aši_,
  { {0x98bc0080,0xf3f9003b,0x20d100c2,0x00000000}},	//   ávě_, viţi_, bši_,
  { {0x442f0185,0xfe7f0994,0x3d0f0161,0x00000000}},	//   _yng_, duït_, ाबें_,
  { {0xf3f90529,0x78a2017f,0x859b0063,0x00000000}},	//   tiţi_, jmov, תשלו,
  { {0x909800b3,0x6442006f,0x4c9407b0,0x00000000}},	// [af0] _حضور_, _mooi, ситс,
  { {0xf3f90529,0xa01b0137,0x78a209a2,0x00000000}},	//   riţi_, plös, emov,
  { {0xf3f90529,0x98510045,0x64aa0080,0x00000000}},	//   siţi_, nąć_, _přil,
  { {0x64420162,0xdddc000c,0xf3f9000c,0x00000000}},	//   _nooi, porţ, piţi_,
  { {0xfe7f00cd,0x752809a3,0x2d9c0066,0x00000000}},	//   buït_, _ardz, _úver_,
  { {0xb5c20086,0x7aed09a4,0x7bcd0206,0x00000000}},	//   ойшл, mrat, lbau,
  { {0x442f09a5,0xe3b10032,0x7a410080,0x00000000}},	//   _png_, يرة_, _vítě,
  { {0x1309019d,0x20d1074f,0x29010025,0x00000000}},	//   вний_, vši_, mtha_,
  { {0x644200e8,0x76410006,0x4423004c,0x00000000}},	//   _dooi, _toly, ěj_,
  { {0x24800117,0x20090089,0x7aed09a6,0x00000000}},	//   čima_, _abai_, irat,
  { {0x27e00026,0xdddc007d,0x6f0d09a7,0x00000000}},	//   ðing_, jorš, _apac,
  { {0x6442006f,0xa06a0001,0x442f09a8,0x00000000}},	//   _gooi, тама_, _ung_,
  { {0x083a0047,0x8db60054,0x7aed013d,0x00000000}},	//   דערל, исві, jrat,
  { {0x7aed09a9,0x20d100b2,0x7bcd004d,0x00000000}},	//   drat, pši_, ebau,
  { {0xdd25003d,0xabd60001,0x7bcd00bd,0x00000000}},	//   tīša, ицај, fbau,
  { {0x672909aa,0x417a0063,0x7aed09ab,0x00000000}},	//   _orej, _שנקב, frat,
  { {0xfe7f0268,0x290109ac,0x2d8509ad,0x00000000}},	// [b00] tuït_, etha_, üler_,
  { {0xdd25001c,0x99580066,0x32050168,0x00000000}},	//   sīša, ráža_, nfly_,
  { {0xaa7b0080,0x29010027,0x7aed09ae,0x00000000}},	//   _svýc, gtha_, arat,
  { {0xafdb0146,0x64aa0080,0x672909af,0x00000000}},	//   lkør, _přim, _brej,
  { {0x2bd30053,0x644200f5,0x29010025,0x00000000}},	//   तररा, _rooi, atha_,
  { {0x672909b0,0x78a209b1,0x3916005d,0x00000000}},	//   _drej, smov, _پورز,
  { {0xafdb02ab,0x29010025,0x98a60086,0x00000000}},	//   ljøe, ctha_, _виве,
  { {0x32050034,0x9168008b,0x94180121,0x00000000}},	//   efly_, _lực_, ужит_,
  { {0xa2b30121,0x672909b2,0xd1ca09b3,0x00000000}},	//   обыч, _grej, кунд_,
  { {0x26c0003b,0x166309b4,0xb254005e,0x00000000}},	//   ţios_, _двум, скољ,
  { {0x91a900aa,0x67290024,0x6f0d09b5,0x00000000}},	//   _đã_, _zrej, _spac,
  { {0x506701f6,0x7aed09b6,0x90e70044,0x00000000}},	//   ртоа, yrat, جَّل_,
  { {0xfe7f00cd,0xd2520044,0x00000000,0x00000000}},	//   duïr_, _ونص_,   ,
  { {0x69d8007a,0x9f4000bd,0x7ea000bd,0x00000000}},	//   ðvel, _weiß_, höpf,
  { {0xdd95000d,0x7ea0004d,0x7bcd004d,0x00000000}},	//   савы, köpf, tbau,
  { {0x228b0031,0x7aed09b7,0x31330062,0x00000000}},	//   søkt_, trat, _феър,
  { {0x7bcd003d,0x64aa0080,0x6f0d014f,0x00000000}},	// [b10] rbau, _přij, _upac,
  { {0xab840459,0xe9ab006a,0x7aed09b8,0x00000000}},	//   цуск, ندان_, rrat,
  { {0x3947003b,0x3d240121,0x7aed09b9,0x00000000}},	//   âns_, _дьяв, srat,
  { {0x672909ba,0x2901057a,0x7aed09bb,0x00000000}},	//   _prej, rtha_, prat,
  { {0xdd28003d,0xdc36069a,0x628809bc,0x00000000}},	//   mēša, _הארט_, kodo,
  { {0xdd28003d,0x29010025,0xb6070928,0x00000000}},	//   lēša, ptha_, рядк,
  { {0xd46908ef,0xafdb00d1,0xddd50078,0x00000000}},	//   лике_, shøy, enzū,
  { {0xdd28001c,0xd5b10013,0x9cd80063,0x00000000}},	//   nēša, _mái_, בוהה_,
  { {0x67290198,0x62880185,0x9f44005b,0x00000000}},	//   _urej, fodo, ümü_,
  { {0x628809bd,0x8b580063,0xe7300044,0x00000000}},	//   godo, ייחס_, _تصف_,
  { {0xf5950593,0xd6980085,0xdd28008f,0x00000000}},	//   _الاج, _лiто, kēša,
  { {0x320504aa,0xb7bd00dd,0x7ae20130,0x00000000}},	//   sfly_, _faţe, šoti,
  { {0x443f001c,0xdd28001c,0x316b0051,0x00000000}},	//   mju_, dēša, ńcz_,
  { {0xddc30259,0x443f09be,0x628809bf,0x00000000}},	//   збри, lju_, codo,
  { {0x9168008b,0xafdb06a5,0x443f09c0,0x00000000}},	//   _vực_, rkør, oju_,
  { {0x443f09c1,0x645b0122,0x78a30179,0x00000000}},	//   nju_, nhui, ïnvl,
  { {0x8c4306be,0x4e7a0021,0xcff7009d,0x00000000}},	// [b20] чете, _محدد_, _הצפה_,
  { {0x443f0019,0x64aa0080,0x4a4309c2,0x00000000}},	//   hju_, _přik, пнув,
  { {0xafdb00d1,0x645b006f,0x090609c3,0x00000000}},	//   sjøe, khui, спен,
  { {0xdd28001c,0x628809c4,0xb7d70044,0x00000000}},	//   cēša, zodo, موما_,
  { {0x62880035,0xeb75000d,0x645b006f,0x00000000}},	//   yodo, _дырэ, dhui,
  { {0x7c2409c5,0x89f50088,0x645b006f,0x00000000}},	//   ldir, _мясц, ehui,
  { {0x628809a0,0x89db0063,0x6d4e09c6,0x00000000}},	//   vodo, _תחלי, nyba,
  { {0x62880051,0x7c240508,0x2480082a,0x00000000}},	//   wodo, ndir, čimo_,
  { {0x7c240035,0x628809c7,0x55e609c8,0x00000000}},	//   idir, todo, _гозб,
  { {0xdd28001c,0x628800fe,0x69de09c9,0x00000000}},	//   zēša, uodo, nape,
  { {0x443f00c3,0x212a0025,0x628809ca,0x00000000}},	//   bju_, íbh_, rodo,
  { {0x628809cb,0x645b09cc,0x32020080,0x00000000}},	//   sodo, chui, řky_,
  { {0x69de09cd,0x7c24001f,0x628809ce,0x00000000}},	//   kape, ddir, podo,
  { {0xdce50024,0x69de09cf,0xd0d40062,0x00000000}},	//   _vzhľ, jape, _докъ,
  { {0x64aa02f4,0x200400cd,0xdd28001c,0x00000000}},	//   _přih, òmic_, tēša,
  { {0x60c709d0,0x3cec013d,0xa177009a,0x00000000}},	//   íjme, ádva_, _לעוד_,
  { {0xdd28003d,0xeabf0013,0xe9d90002,0x00000000}},	// [b30] rēša, _trùm_, имач_,
  { {0x443f00c3,0x61fa00a4,0x7b740021,0x00000000}},	//   zju_, ngtl, أطفا,
  { {0xd5b10013,0xdd28008f,0x7c2409d1,0x00000000}},	//   _tái_, pēša, bdir,
  { {0x19a809d2,0x69de0656,0x64460072,0x00000000}},	//   ступ_, aape, ökil,
  { {0x443f09d3,0x7bdf01fa,0xac240085,0x00000000}},	//   vju_, maqu, _эфэк,
  { {0xdb1d01e3,0xd62907a1,0x7bdf09d4,0x00000000}},	//   _besö, роке_, laqu,
  { {0xf5320079,0x443f09d5,0x645b09d6,0x00000000}},	//   дејќ, tju_, thui,
  { {0x94790001,0x443f005f,0x645e005f,0x00000000}},	//   јску_, uju_, ūpin,
  { {0xa5f90001,0x645b0173,0x443f09d7,0x00000000}},	//   _везу_, rhui, rju_,
  { {0x645b09d8,0x7bdf0153,0xdd1c01c8,0x00000000}},	//   shui, haqu, váže,
  { {0x9327007e,0x443f09d9,0xf4870601,0x00000000}},	//   _گران, pju_, _лудн,
  { {0x6d4e0066,0x78fa009f,0x1faa09da,0x00000000}},	//   vyba, ספרו, икни_,
  { {0x7bdf01a8,0x7c2409db,0x92b7009e,0x00000000}},	//   daqu, vdir, _احصا,
  { {0xdd1c01da,0x7ea00137,0xda0b0042,0x00000000}},	//   ráže, köpe, स्मत_,
  { {0xa3bd016a,0x7bdf00be,0x69de09dc,0x00000000}},	//   _आला_, faqu, vape,
  { {0xdb1d09dd,0x69de0983,0x6d4e09de,0x00000000}},	//   _lesõ, wape, ryba,
  { {0xf4120132,0x7c2409df,0x69de09e0,0x00000000}},	// [b40] ופן_, rdir, tape,
  { {0x224700ac,0x4996007b,0x290f00dd,0x00000000}},	//   _jonk_, ошет, ăgan_,
  { {0x8c4609e1,0xdd0f01f7,0x2f040026,0x00000000}},	//   _дене, mışt, lög_,
  { {0x394700c7,0xdd0f01f7,0x9f480013,0x00000000}},	//   änsa_, lışt, _điêu_,
  { {0x69de09e2,0x64aa004c,0x66e302d8,0x00000000}},	//   pape, _křiv, доча,
  { {0xf4ea0076,0x645909e3,0x7ae409e4,0x00000000}},	//   афий_, _alwi, msit,
  { {0xd90d006a,0x7ae409e4,0x69dc09e5,0x00000000}},	//   _میل_, lsit, _iere,
  { {0xfc570047,0x7bc409e6,0xdb1d004b,0x00000000}},	//   ַביש_, nciu, _eesõ,
  { {0x69dc09e7,0xdd0f005b,0x2f040014,0x00000000}},	//   _kere, kışt, jög_,
  { {0x7bdf0016,0x24510025,0x3cf8069f,0x00000000}},	//   zaqu, _lámh_, kurv_,
  { {0x69dc09e8,0xd2570088,0x224709e9,0x00000000}},	//   _mere, іць_, _donk_,
  { {0xe0cf007e,0x661809ea,0x69dc056a,0x00000000}},	//   کزی_, levk, _lere,
  { {0x20050051,0x7bdf09eb,0xf487005d,0x00000000}},	//   ęli_, vaqu, _بالی,
  { {0x24890024,0x7bc400dd,0x69dc09ec,0x00000000}},	//   čame_, eciu, _nere,
  { {0x76480051,0x7bdf09ed,0x7d1c002b,0x00000000}},	//   _mody, taqu, gwrs,
  { {0x69dc051e,0x3ced082a,0xa0680095,0x00000000}},	//   _aere, čev_, _маја_,
  { {0xb6060024,0x764500fe,0xc3340063,0x00000000}},	// [b50] _kráľ, öhyk, הוּ_,
  { {0x69dc09ee,0x7648001f,0x7bdf09ef,0x00000000}},	//   _cere, _nody, saqu,
  { {0x69dc09f0,0x481509f1,0x7ae409f2,0x00000000}},	//   _dere, змес, asit,
  { {0x9d1a014e,0x765a09f3,0xb17b00b5,0x00000000}},	//   _פורט, _alty, סטאר,
  { {0x27e0007a,0x69dc09f4,0xd5b10013,0x00000000}},	//   ðina_, _fere, _lát_,
  { {0x201909f5,0x2ca90019,0x69dc09f6,0x00000000}},	//   hesi_, lmad_, _gere,
  { {0x7bdd0397,0x67d5014c,0x201909f7,0x00000000}},	//   _kesu, _нову, kesi_,
  { {0x69c509f8,0x68e3006d,0x4d7c0063,0x00000000}},	//   lche, ándu, ירוע,
  { {0x69dc01f7,0x7bdd09f9,0x2ca9004b,0x00000000}},	//   _yere, _mesu, imad_,
  { {0x7bdd09fa,0x2ca90231,0xd5b10013,0x00000000}},	//   _lesu, hmad_, _sáu_,
  { {0x69c50199,0x201909fb,0xddce0078,0x00000000}},	//   iche, fesi_, sibū,
  { {0x7bdd09fc,0x69c509fd,0x2d84005b,0x00000000}},	//   _nesu, hche, şmek_,
  { {0x64aa0080,0x24510080,0xdd0f0058,0x00000000}},	//   _přiv, _námi_, tışt,
  { {0x20190290,0x248d09fe,0x2ca9004b,0x00000000}},	//   aesi_, loem_, emad_,
  { {0x61e109ff,0x7bdd0199,0x2d9e0031,0x00000000}},	//   mall, _besu, åte_,
  { {0x248d00e8,0x0d990088,0x2ca9017f,0x00000000}},	//   noem_, ітры_, gmad_,
  { {0x7bdd0a00,0xdd0f005b,0x2d9e0240,0x00000000}},	// [b60] _desu, pışt, ťte_,
  { {0x7bc4051e,0xada60095,0x61e10a01,0x00000000}},	//   sciu, _напл, nall,
  { {0x764800eb,0x61e10a02,0x7bdd001f,0x00000000}},	//   _rody, iall, _fesu,
  { {0x69dc0a03,0x69c50a04,0x7bdd0a05,0x00000000}},	//   _were, ache, _gesu,
  { {0x61e10a06,0x387f00c7,0xafdb00d1,0x00000000}},	//   kall, _djur_, kjøn,
  { {0x6594000a,0x69c50a07,0x61e10a08,0x00000000}},	//   малу, cche, jall,
  { {0x7bdd00f3,0x20c1001b,0x7c2600c3,0x00000000}},	//   _yesu, _nói_, _kakr,
  { {0x6d410072,0x661800a8,0x04630505,0x00000000}},	//   älai, sevk, етьм,
  { {0x66180024,0x6720017f,0xd5b1008b,0x00000000}},	//   pevk, _usmj, _sát_,
  { {0x201900f3,0x3f85005b,0x20c10013,0x00000000}},	//   wesi_, şluk_, _bói_,
  { {0x69c300c3,0x20190a09,0x60cd007d,0x00000000}},	//   žneg, tesi_, _čamc,
  { {0x34aa005e,0x60c70066,0x2bb80042,0x00000000}},	//   _увео_, íjma, _अलगा,
  { {0xaa7b0080,0x61e10a0a,0x8fe4000d,0x00000000}},	//   _svým, ball, эцэд,
  { {0x61e10a0b,0x7bdd08f0,0x20190a0c,0x00000000}},	//   call, _sesu, sesi_,
  { {0x44260a0d,0x7c260a0e,0x7bdd0a0f,0x00000000}},	//   _kao_, _bakr, _pesu,
  { {0x7c2600f3,0xfad90062,0x6abd0a10,0x00000000}},	//   _cakr, ждащ_, _pusf,
  { {0x76430051,0x2d8c00bd,0x69c50a11,0x00000000}},	// [b70] yjny, üder_, tche,
  { {0x24510080,0x27e0007a,0x68e3000c,0x00000000}},	//   _vámi_, ðinn_, ândo,
  { {0x291903eb,0xa01b0026,0x69c5031d,0x00000000}},	//   تقاد_, rnöf, rche,
  { {0x69c50a12,0x44260a13,0xd75900f2,0x00000000}},	//   sche, _nao_, يلات_,
  { {0x69c50025,0x7ea00137,0x79950051,0x00000000}},	//   pche, löpa, _wyzw,
  { {0xf1ba0013,0x7c260a14,0x61e101a8,0x00000000}},	//   _ngơ_, _zakr, xall,
  { {0x4426001b,0x7c3a0025,0x61e10a15,0x00000000}},	//   _bao_, _úcrá, vall,
  { {0x4426001b,0x45180086,0x24580003,0x00000000}},	//   _cao_, яція_, _démo_,
  { {0xe73f0016,0x61e107db,0xddc700c2,0x00000000}},	//   _çõ_, tall, zijš,
  { {0x25a00080,0x81bc008f,0x60e90a16,0x00000000}},	//   řila_, ldēj, омом_,
  { {0x44260a17,0x64aa0080,0x26cd007d,0x00000000}},	//   _fao_, _přit, _hteo_,
  { {0xd36e006a,0x61e10a18,0x81bc008f,0x00000000}},	//   اهی_, sall, ndēj,
  { {0x81bc001c,0x61e10a19,0xb0660072,0x00000000}},	//   idēj, pall, erää,
  { {0x44260a1a,0x644b001f,0x7c260a1b,0x00000000}},	//   _zao_, _hogi, _sakr,
  { {0x44260035,0x7c260a1c,0xb60601c2,0x00000000}},	//   _yao_, _pakr, _uráž,
  { {0x27ed0a1d,0x44260013,0xddc70a1e,0x00000000}},	//   _nden_, _xao_, rijš,
  { {0x7c2600d1,0xeb970a1f,0x644b0a20,0x00000000}},	// [b80] _vakr, дит_, _mogi,
  { {0x248000c3,0x7c260035,0x63bc004c,0x00000000}},	//   čimi_, _wakr, ěrni,
  { {0xa8060088,0x7c260a21,0xafdb04aa,0x00000000}},	//   дзел, _takr, kjøl,
  { {0x649e006f,0xdb0d0195,0xd7ef0044,0x00000000}},	//   eëin, škán, لكم_,
  { {0xdb1d00b9,0x47360021,0x44260a22,0x00000000}},	//   _afsæ, براز, _rao_,
  { {0x4426001b,0xdd1d0114,0x27ed0a23,0x00000000}},	//   _sao_, lášt, _eden_,
  { {0x7af601e1,0x44260a24,0x34940a25,0x00000000}},	//   lryt, _pao_, накр,
  { {0xfc3f0013,0x7af60051,0xd4970085,0x00000000}},	//   _khía_, oryt, мры_,
  { {0xd703005a,0xb286000d,0x84ea0042,0x00000000}},	//   _изти, дынк, _टिकट_,
  { {0x64aa0080,0x65790025,0x44260035,0x00000000}},	//   _přis, ábhá, _wao_,
  { {0x442600bb,0x09f7014e,0x6d480a26,0x00000000}},	//   _tao_, ומים_, ädal,
  { {0xdbd6021e,0x644b0a27,0x7af60a28,0x00000000}},	//   _jääd, _gogi, kryt,
  { {0xd5b10013,0x93430a29,0xfe730049,0x00000000}},	//   _háp_, _инце, ندس_,
  { {0x7ea000fe,0x7af60022,0x539b009a,0x00000000}},	//   töpa, dryt, _וידו,
  { {0xdd940088,0x387d001f,0x7af60022,0x00000000}},	//   вары, ynwr_, eryt,
  { {0xaa7b004c,0x629a0a2a,0x00000000,0x00000000}},	//   _zvýh, llto,   ,
  { {0x5a35005a,0xda670032,0x629a0a2b,0x00000000}},	// [b90] ннат, وائي, olto,
  { {0x7ea00137,0xa01b00ca,0x26000042,0x00000000}},	//   löpn, coör, _राषी_,
  { {0x7af60078,0x29070a2c,0x629a0a2d,0x00000000}},	//   aryt, îna_, ilto,
  { {0x7af60a2e,0xc19b0063,0x81bc008f,0x00000000}},	//   bryt, חשבי, udēj,
  { {0x387d001f,0x6d5500ea,0x3e6d0078,0x00000000}},	//   rnwr_, lyza, ežti_,
  { {0x629a01af,0xe5a50a2f,0xf5050a30,0x00000000}},	//   jlto, нили, езко,
  { {0x63a2000f,0x98c3001c,0xd5b10013,0x00000000}},	//   _azon, ēvēt_, _cáp_,
  { {0x27ed010a,0x64a2005a,0x332d0a31,0x00000000}},	//   _uden_, лаща, tvex_,
  { {0xe610007e,0x64aa0080,0x662800fe,0x00000000}},	//   _چشم_, _přir, öskä,
  { {0x64b1003d,0x60c701d9,0xdcff004c,0x00000000}},	//   _jāiz, íjmo, ívěj,
  { {0xafdb00d1,0x6f160022,0x00000000,0x00000000}},	//   lkøy, _spyc,   ,
  { {0x7e75008f,0x2004004e,0x629a0a32,0x00000000}},	//   eizp, ümi_, alto,
  { {0x83640044,0xa856009a,0x00000000,0x00000000}},	//   _لدول, גירה_,   ,
  { {0x60c400c2,0x42550044,0x024500de,0x00000000}},	//   _čimv, _سنعر, _سَبَ,
  { {0xdd92013a,0x409601f6,0x5096005e,0x00000000}},	//   اوز_, _прит, _приђ,
  { {0xfc3f001b,0x7e750023,0x6aa80042,0x00000000}},	//   _phía_, aizp, कग्र,
  { {0xa089009a,0x539a009d,0x7c9300de,0x00000000}},	// [ba0] _קְצִ, ִיעו, القص,
  { {0xdbd600fe,0x9f420114,0x7af60072,0x00000000}},	//   _sääd, jaké_, rryt,
  { {0xdbd601cf,0x8d7604a0,0xd7ef071f,0x00000000}},	//   _pääd, _سادا, лу_,
  { {0x27e00a33,0x2002017e,0x66e60a34,0x00000000}},	//   úin_, ngki_, еода,
  { {0x2d9a0a35,0x5ac7012c,0x00000000,0x00000000}},	//   _hype_, _плям_,   ,
  { {0xf52605ce,0x96b7005e,0x8b0b009a,0x00000000}},	//   ефин, нују_, _מִלֵ,
  { {0x63a2013d,0x24510014,0x88c50044,0x00000000}},	//   _szon, _náms_, _لتقل,
  { {0x7ea0024a,0x25a00080,0x68fe0244,0x00000000}},	//   köpo, řilo_, mupd,
  { {0x08770047,0xa686000d,0xf2060a36,0x00000000}},	//   _נעמט_, _злад, няно,
  { {0x629a0a37,0xaa16000d,0xe60e005e,0x00000000}},	//   ulto, дзiц, вдe_,
  { {0x629a0a38,0xf5060054,0x64a60a39,0x00000000}},	//   rlto, _їздо, _зажа,
  { {0x20b4000d,0x25a1004d,0x8386030b,0x00000000}},	//   лёўс, ühle_, _пыле,
  { {0x8cd90042,0x67220022,0xbfa80a3a,0x00000000}},	//   _फौजो, nwoj, етре_,
  { {0xfc3f008b,0x27e600a4,0x6114000d,0x00000000}},	//   _chín_, haon_, _адку,
  { {0xdd95000d,0x321e0a3b,0xeca7005e,0x00000000}},	//   тавы, mety_, ејан,
  { {0x6d550051,0x2d9a00d1,0xc19b0063,0x00000000}},	//   ryza, _dype_, _משוי,
  { {0x7bf80085,0x27e6013d,0x30840044,0x00000000}},	// [bb0] энтр_, daon_, _حليف,
  { {0x67220022,0x6d410050,0x321e0a3c,0x00000000}},	//   dwoj, älas, nety_,
  { {0xfe7f00cd,0xa3c20053,0x4de60082,0x00000000}},	//   duïx_, ्डा_, _क़तई_,
  { {0xab5b017d,0x69d80014,0x80a70042,0x00000000}},	//   _agüe, ðver, _टीमे,
  { {0x38a70019,0xe7580086,0x58b80021,0x00000000}},	//   võrd_, ниці_, رامج_,
  { {0x7c2d007a,0xf6d4007e,0xe7360062,0x00000000}},	//   ldar, ازند, теш_,
  { {0x64aa0080,0xc9840a3d,0x7c2d0a3e,0x00000000}},	//   _přip, _бути, odar,
  { {0x248905c9,0x93590002,0x7c2d0a3f,0x00000000}},	//   čamo_, дроу_, ndar,
  { {0x13060076,0x321e06b8,0x7c2d0a40,0x00000000}},	//   вный_, fety_, idar,
  { {0x68e10146,0x321e0066,0x7c2d002b,0x00000000}},	//   _ælds, gety_, hdar,
  { {0x320b0051,0x3eba00a4,0xb1420085,0x00000000}},	//   ęcy_, _ript_, анэл,
  { {0x7c2d003d,0x6455005e,0x64460050,0x00000000}},	//   jdar, _швеђ, ökit,
  { {0x442d0a41,0xf8b200b5,0x7c2d0a42,0x00000000}},	//   mde_, ישט_, ddar,
  { {0x645b00fe,0x442d0a43,0x78bb0a44,0x00000000}},	//   lkui, lde_, _liuv,
  { {0x7c2d006f,0x442d0a45,0x67220051,0x00000000}},	//   fdar, ode_, zwoj,
  { {0x64490a46,0x7c2d0a47,0x442d02e0,0x00000000}},	//   njei, gdar, nde_,
  { {0xc0530063,0x645b0072,0x442d0a48,0x00000000}},	// [bc0] _כזה_, ikui, ide_,
  { {0x442d024a,0x64490659,0x60c30a49,0x00000000}},	//   hde_, hjei, _kunm,
  { {0x27e600bb,0xbf9b017d,0x61e30a4a,0x00000000}},	//   taon_, ngên, _menl,
  { {0x38600027,0x78a904bc,0x442d0a4b,0x00000000}},	//   óir_, _chev, jde_,
  { {0xe1e7006a,0xf11e0053,0x68fe006f,0x00000000}},	//   _پس_, _बन्द_, supd,
  { {0x442d0a4c,0xd627005e,0x644900be,0x00000000}},	//   ede_, воље_, ejei,
  { {0x442d0173,0x60c3004d,0xd5d50085,0x00000000}},	//   fde_, _nunm, уючы,
  { {0x442d0a4d,0xd6d20021,0x78a900ca,0x00000000}},	//   gde_, _نقر_, _ghev,
  { {0x68e10146,0x799c001f,0xdc9b0047,0x00000000}},	//   _ældr, _hyrw, ויקל,
  { {0x443d0185,0x386603d9,0x442d0a4e,0x00000000}},	//   _enw_, lhor_, ade_,
  { {0x26c40a4f,0x38660089,0xd1660062,0x00000000}},	//   _humo_, ohor_, тъпи,
  { {0x38660016,0xf99301f9,0x68e30a50,0x00000000}},	//   nhor_, ירת_, ândi,
  { {0x2d9e0378,0x69ce0014,0x2458013d,0x00000000}},	//   üten_, _ofbe, _némi_,
  { {0xdce5061a,0x425600e1,0xd3570063,0x00000000}},	//   _vyhľ, _штет, _בידי_,
  { {0xac190a51,0x61e8033b,0x7c2d0a52,0x00000000}},	//   нову_, madl, tdar,
  { {0xfbd3006a,0x69ce0a53,0xdd25001c,0x00000000}},	//   شتر_, _afbe, gūša,
  { {0x7c2d0a54,0xfaf30021,0xeeab0a55,0x00000000}},	// [bd0] rdar, ؤثر_, _оток_,
  { {0xf09f0268,0x442d0a56,0xa2c30053,0x00000000}},	//   llà_, zde_, रदत्,
  { {0x442d0a57,0xdbd1004b,0x9f4e013d,0x00000000}},	//   yde_, _küüd, önöm_,
  { {0x61e80a58,0x2486007d,0x7c3d004d,0x00000000}},	//   hadl, _njom_, _unsr,
  { {0x442d0a59,0xdbd10019,0xe72e03d6,0x00000000}},	//   vde_, _müüd, ще_,
  { {0x442d0122,0x6a600026,0x7aed0a5a,0x00000000}},	//   wde_, _höfn, msat,
  { {0x9f4000cd,0x799c001f,0x7aed0a5b,0x00000000}},	//   _veié_, _gyrw, lsat,
  { {0x2901002c,0xdbd10019,0x26c40a5c,0x00000000}},	//   muha_, _nüüd, _fumo_,
  { {0x442d0a5d,0x3e660164,0x7aed0a5e,0x00000000}},	//   rde_, _hôte_, nsat,
  { {0xb7bd0529,0x645b0a5f,0x442d0a60,0x00000000}},	//   _naţi, skui, sde_,
  { {0x61e3010a,0x290100a4,0x628105b9,0x00000000}},	//   _venl, nuha_, rnlo,
  { {0x44e10812,0xbf9b0016,0x8335007e,0x00000000}},	//   mų_, rgên, _مرتض,
  { {0xa3c20235,0x44e10006,0x6b9d0093,0x00000000}},	//   ्डर_, lų_, _nysg,
  { {0x290100bb,0x3f9e003d,0x249f0a61,0x00000000}},	//   kuha_, ātu_, llum_,
  { {0x44e100eb,0x10f5000d,0x7aed0a62,0x00000000}},	//   nų_, _сяля, esat,
  { {0x44e10006,0x7aed004d,0x6b9d002b,0x00000000}},	//   ių_, fsat, _bysg,
  { {0xfc3f0a63,0x6b9d001f,0x7aed0a64,0x00000000}},	// [be0] _dní_, _cysg, gsat,
  { {0x32050037,0x6b9d0185,0x44e100eb,0x00000000}},	//   ngly_, _dysg, kų_,
  { {0x44e100eb,0x3e660a65,0x38660a66,0x00000000}},	//   jų_, _côte_, thor_,
  { {0x44e10006,0x6abc071c,0x7aed0a67,0x00000000}},	//   dų_, _wirf, bsat,
  { {0xdd1d0024,0xd7f90086,0x81bc001c,0x00000000}},	//   ráťt, тує_, ldēt,
  { {0xfe360047,0x249f0052,0xfc3f004c,0x00000000}},	//   ראַך_, elum_, _zní_,
  { {0x44e10006,0x81bc001c,0xb9b50062,0x00000000}},	//   gų_, ndēt, _встъ,
  { {0x249f0026,0x545406be,0x2876093e,0x00000000}},	//   glum_, рвит, _сыгр,
  { {0x18670001,0x41e60500,0x2ca0004b,0x00000000}},	//   _сати_, ліна, ilid_,
  { {0xdbd10019,0x471b0047,0x44e10006,0x00000000}},	//   _süüd, _אומג, bų_,
  { {0xdbd10019,0x2ca004b4,0xb7bd003b,0x00000000}},	//   _püüd, klid_, _raţi,
  { {0xfc3f008b,0xc0ab0049,0x61e80244,0x00000000}},	//   _phím_, عادل_, sadl,
  { {0x543b00b5,0x08770047,0xf09f01a8,0x00000000}},	//   _רעדא, רעכט_, rlà_,
  { {0x6a600026,0x929d0022,0xfc3f011b,0x00000000}},	//   _söfn, tułe, _sní_,
  { {0xf09f00cd,0xf518009a,0x00000000,0x00000000}},	//   plà_, כֵּל,   ,
  { {0x2ca00019,0x7aed0a68,0x6b9d001f,0x00000000}},	//   glid_, tsat, _pysg,
  { {0x0ca80076,0x44e10078,0xba750062,0x00000000}},	// [bf0] утри_, zų_, агащ,
  { {0x2bb80021,0x7aed0a69,0x7bcd0a6a,0x00000000}},	//   طاقة_, rsat, scau,
  { {0x7aed0a6b,0x49750002,0x47d501fb,0x00000000}},	//   ssat, јлес, ليار,
  { {0x2c27019d,0x44e10006,0xab950086,0x00000000}},	//   _сьог, vų_, _вимі,
  { {0x66b5000a,0xd6db00a0,0xd5e50086,0x00000000}},	//   абду, хте_, ажли,
  { {0x44e100eb,0x2458004c,0x56940054,0x00000000}},	//   tų_, _mému_, бачт,
  { {0x249f0026,0x36660062,0xdb1d01e1,0x00000000}},	//   tlum_, ращо_, _afsø,
  { {0x99840032,0x60c400c3,0x44e10006,0x00000000}},	//   _الفو, _čimp, rų_,
  { {0x44e10006,0x32c90013,0xc8640a6c,0x00000000}},	//   sų_, _qúy_, _утри,
  { {0x249f0026,0xaa7b0240,0xe4e70086,0x00000000}},	//   slum_, _zvýr, _бідн,
  { {0x764100ac,0x9a760063,0x249f0779,0x00000000}},	//   _inly, שתתף_, plum_,
  { {0xb4c10161,0x32c9008b,0xcea90063,0x00000000}},	//   ंदी_, _túy_, _חי_,
  { {0x00000000,0x00000000,0x00000000,0x00000000}},	//     ,   ,   ,
  { {0x3ebe000f,0x442f0a6d,0x3f850075,0x00000000}},	//   ött_, _hag_, ğlup_,
  { {0x81bc001c,0xbda50021,0xee3702f8,0x00000000}},	//   udēt, محفو, јнс_,
  { {0x442f01e3,0xbc630a6e,0xa01b00fe,0x00000000}},	//   _jag_, овск, nnöl,

  { {0x91fc003d,0x442f0a6f,0x6b850021,0x00000000}},	// [c00] bkād, _mag_, مشكل,
  { {0xda660032,0x442f0a70,0x25a00080,0x00000000}},	//   جاري, _lag_, řili_,
  { {0x2cba0021,0xa9260a71,0xdca60a72,0x00000000}},	//   _لاحظ_, рдел, _вани,
  { {0x442f0a73,0x7c96007e,0x97c50021,0x00000000}},	//   _nag_, _خشخا, متهم,
  { {0x7c2403d9,0x2813009e,0x45d40a74,0x00000000}},	//   meir, تونس, болс,
  { {0xb4c10235,0x7c240a75,0x7c2f007d,0x00000000}},	//   ंदू_, leir, _zacr,
  { {0x394700c7,0x442f0a76,0x6d5c0a77,0x00000000}},	//   änst_, _bag_, nyra,
  { {0x7c2403d9,0x2c67004b,0x73d70062,0x00000000}},	//   neir, _tõde_, адър_,
  { {0x442f0a78,0xd5b1001b,0x27e00026,0x00000000}},	//   _dag_, _máy_, ðinu_,
  { {0x80ca0235,0x7d1e0031,0x7c240a79,0x00000000}},	//   _संदे, _opps, heir,
  { {0xba370063,0xd5750086,0x3a370a7a,0x00000000}},	//   בטיח_, _луць, ברים_,
  { {0xd409006a,0x320a0051,0x7c24039f,0x00000000}},	//   _متهم_, żby_, jeir,
  { {0x7c240a7b,0x236d0051,0x44240a7c,0x00000000}},	//   deir, czej_, mem_,
  { {0xa2c30161,0x442f0122,0xbe880a7d,0x00000000}},	//   रदर्, _zag_, ассе_,
  { {0x7c240185,0xd0870076,0x44240474,0x00000000}},	//   feir, _выпи, oem_,
  { {0x24580024,0x7c240a7e,0x2d580376,0x00000000}},	//   _tému_, geir, шись_,
  { {0x6a600026,0xdee4005e,0xf9c701f8,0x00000000}},	// [c10] _töfl, _доњи, ащен,
  { {0x78a20a7f,0x24890a80,0x44240a81,0x00000000}},	//   elov, čami_, hem_,
  { {0x7c240a82,0x39150a83,0x4c950002,0x00000000}},	//   beir, смер, _гинс,
  { {0x78a20198,0x7c24017d,0x87d4000d,0x00000000}},	//   glov, ceir, оўшч,
  { {0xafdb00d1,0x8c1a0063,0x44240a84,0x00000000}},	//   ljøs, _גורי, dem_,
  { {0x64420027,0x44240250,0x442f0a85,0x00000000}},	//   _anoi, eem_, _sag_,
  { {0x442f0273,0xb4c1016a,0x9608000d,0x00000000}},	//   _pag_, ंदे_, рэча_,
  { {0x44240a86,0x64420025,0xe894000d,0x00000000}},	//   gem_, _cnoi, _дась,
  { {0x442f00dd,0x753a0a87,0x83fd013d,0x00000000}},	//   _vag_, _ertz, lhők,
  { {0x442f0a88,0x7c240a89,0x9f4201c2,0x00000000}},	//   _wag_, zeir, jaká_,
  { {0x442f0a8a,0x236d0045,0x25570080,0x00000000}},	//   _tag_, szej_, _dělá_,
  { {0x7c240016,0x387d002b,0x291301a8,0x00000000}},	//   xeir, niwr_, itxa_,
  { {0x7c240a8b,0x6d410a8c,0x6d5c0a8d,0x00000000}},	//   veir, ålan, wyra,
  { {0x387d001f,0x93c2003b,0xea000013,0x00000000}},	//   hiwr_, ţăto, _đắn_,
  { {0x7c240a8e,0x98a7004c,0x6da60a8f,0x00000000}},	//   teir, íně_, сива,
  { {0x3fe60a90,0xeb9a0a91,0x7c2400be,0x00000000}},	//   _ужив, гиб_, ueir,
  { {0x64aa02f4,0x387d0185,0x7c240a92,0x00000000}},	// [c20] _přiz, diwr_, reir,
  { {0x7c240a93,0x0f370063,0x78a20a94,0x00000000}},	//   seir, _פריט_, wlov,
  { {0x7d1e0a95,0x97c60021,0x1e570063,0x00000000}},	//   _upps, مقاو, _השיר_,
  { {0x673b04d0,0x18a6047e,0x387d002b,0x00000000}},	//   _bruj, щаем, giwr_,
  { {0x673b0331,0x78a2073c,0x44240a96,0x00000000}},	//   _cruj, rlov, vem_,
  { {0x44240045,0x78a20a97,0x64420a98,0x00000000}},	//   wem_, slov, _snoi,
  { {0x78a20a99,0x26090053,0x27e00014,0x00000000}},	//   plov, _सारी_, ðins_,
  { {0x44240a9a,0xb8de0053,0x387d002b,0x00000000}},	//   uem_, ुआ_, ciwr_,
  { {0xe7370055,0xafdb0031,0xc1ea0086,0x00000000}},	//   _лет_, kjør, льне_,
  { {0x3d190053,0x6f060a9b,0x44240a9c,0x00000000}},	//   _पहले_, dukc, sem_,
  { {0x3a370063,0x1a9b0047,0x44240a9d,0x00000000}},	//   זרים_, רייע, pem_,
  { {0x9f4b0164,0x20050078,0xc9530063,0x00000000}},	//   lacé_, ėlio_, למת_,
  { {0xa01b00ea,0x80ca0053,0x321a005d,0x00000000}},	//   lnök, _संवे, _ميشد_,
  { {0x63a20273,0xafdb0031,0x9f4b0003,0x00000000}},	//   _iyon, gjør, nacé_,
  { {0xdd3a000c,0x127b0047,0x629a0a9e,0x00000000}},	//   văţa, _גאגע, moto,
  { {0x69d800ea,0x63a20a9f,0x629a0aa0,0x00000000}},	//   űvel, _kyon, loto,
  { {0x62880441,0x6d480137,0x5ea50021,0x00000000}},	// [c30] ondo, ädar, _ومعل,
  { {0xe9ab014d,0x629a0aa1,0x1ed80044,0x00000000}},	//   هدان_, noto, _ابيب_,
  { {0xdd3a003b,0x63a20aa2,0x62880aa3,0x00000000}},	//   răţa, _lyon, indo,
  { {0x27e9006d,0xbd88007e,0xf770007e,0x00000000}},	//   úan_, _چنین_, کام_,
  { {0x387d001f,0x63a20aa4,0x629a0aa5,0x00000000}},	//   riwr_, _nyon, koto,
  { {0xddc50080,0x34b30053,0xa565005d,0x00000000}},	//   _pohř, ुद्द, يگان,
  { {0x69c70031,0x63a20003,0x629a0aa6,0x00000000}},	//   _igje, _ayon, doto,
  { {0x673b0aa7,0xe459032d,0x62880aa8,0x00000000}},	//   _truj, ржи_, endo,
  { {0x60ca00bd,0x27ef0014,0x61ea004d,0x00000000}},	//   _aufm, magn_, _befl,
  { {0x629a0aa9,0x6e21004b,0x99580066,0x00000000}},	//   goto, õlbl, láša_,
  { {0xdddc0006,0x63a20aaa,0x60260aab,0x00000000}},	//   sirū, _eyon, одна,
  { {0x50460138,0xe45f0019,0x62880aac,0x00000000}},	//   цемб, ööd_, ando,
  { {0xe1ee0aad,0x629a0aae,0x8e5a005e,0x00000000}},	//   _ог_, boto, ајву_,
  { {0x61ea087d,0x629a0aaf,0x6f060ab0,0x00000000}},	//   _gefl, coto, rukc,
  { {0x8c7a005a,0x2c67004b,0xdb1d0014,0x00000000}},	//   ащат_, _sõda_, _ofsó,
  { {0x69d5006f,0x8c430ab1,0x6097005d,0x00000000}},	//   _afze, месе, _ونوس_,
  { {0x20e7013d,0x6a60004d,0x4bd90085,0x00000000}},	// [c40] lői_, _höfi, сься_,
  { {0x89f5000d,0x7d150046,0x6dfa01ce,0x00000000}},	//   зяцц, éfsá, _тхис_,
  { {0xc92a005a,0x38cb007e,0x6a600046,0x00000000}},	//   роеж_, لانی_, _jöfi,
  { {0x186a000a,0x629a0ab2,0x69da0053,0x00000000}},	//   јади_, zoto, _प्री,
  { {0x629a0035,0x41c90053,0x3ced007d,0x00000000}},	//   yoto, रशास, ćeve_,
  { {0x4733019d,0xd1380006,0x6d4f003b,0x00000000}},	//   ьніс, yvą_, ţiaţ,
  { {0x27ef00a4,0xafdb00d1,0x629a0ab3,0x00000000}},	//   bagn_, kjøp, voto,
  { {0x60c4004b,0x63a20ab4,0xa01b013d,0x00000000}},	//   _niim, _pyon, rnök,
  { {0x629a0ab5,0x2451011b,0xf3f50043,0x00000000}},	//   toto, _jámy_, ستيک,
  { {0x629a0ab6,0x628800ed,0xfb1b0063,0x00000000}},	//   uoto, undo, סוימ,
  { {0x61ea0026,0x6e21004b,0xfc3f008d,0x00000000}},	//   _vefl, õlbm, _khít_,
  { {0x7ea00137,0x6d4100a5,0x629a0ab7,0x00000000}},	//   köps, ålam, soto,
  { {0x60c4053b,0xdfa70021,0x628f0003,0x00000000}},	//   _diim, تحدي, écoc,
  { {0xb2370044,0x6dc700de,0x00000000,0x00000000}},	//   _وكنا_, تزحل,   ,
  { {0xa6e90013,0xeda40054,0x271e0023,0x00000000}},	//   _giươ, дшто, lānā_,
  { {0x3e540058,0x4bdb005d,0xb4fb069a,0x00000000}},	//   _aştı_, شبرد_, יפלי,
  { {0x27ef0137,0x00000000,0x00000000,0x00000000}},	// [c50] vagn_,   ,   ,
  { {0x0b880086,0x3cfe01b3,0x19950062,0x00000000}},	//   істи_, štva_, пазя,
  { {0x0a680092,0x320c0022,0xd6220085,0x00000000}},	//   црти_, igdy_, _мiка,
  { {0x88c80086,0x48780054,0x00000000,0x00000000}},	//   ілів_, осія_,   ,
  { {0x87270021,0x69c704aa,0xe73904e3,0x00000000}},	//   تعام, _tgje, сел_,
  { {0x27ef06a5,0x69c700d1,0xd6290a8f,0x00000000}},	//   sagn_, _ugje, соке_,
  { {0xb0660072,0x673e008f,0xc984005e,0x00000000}},	//   nsää, āpja, _жути,
  { {0xb06600fe,0x17f80021,0x20e7013d,0x00000000}},	//   isää, _ورقة_, vői_,
  { {0x66f40001,0xc6a70092,0xa3b50042,0x00000000}},	//   _опту, _држи, छें_,
  { {0x27ed016d,0x20e700ea,0xe6640076,0x00000000}},	//   _heen_, tői_, _отхо,
  { {0x60c40019,0x27ed00e5,0x61450ab8,0x00000000}},	//   _piim, _keen_, чена,
  { {0xc4d20063,0x26c50ab9,0x4375007b,0x00000000}},	//   _נגד_, _hilo_, _нулт,
  { {0x60c40aba,0x27ed00f5,0x92a40051,0x00000000}},	//   _viim, _meen_, ółcz,
  { {0xed5a0abb,0x25a5004b,0x27ed0abc,0x00000000}},	//   бог_, _kyll_, _leen_,
  { {0x60c4024a,0x26c50abd,0x62810abe,0x00000000}},	//   _tiim, _milo_, milo,
  { {0x62810abf,0x27ed006f,0xec7706da,0x00000000}},	//   lilo, _neen_, ппс_,
  { {0x2d850003,0xb066004b,0x628100dd,0x00000000}},	// [c60] ûler_, asää, oilo,
  { {0x62810529,0x26c50ac0,0x7c360ac1,0x00000000}},	//   nilo, _nilo_, sdyr,
  { {0x27ed03e9,0x2f160146,0x62810ac2,0x00000000}},	//   _been_, læg_, iilo,
  { {0xa8000080,0x64590ac3,0x62810ac4,0x00000000}},	//   příč_, _nowi, hilo,
  { {0x6281007a,0x26c5065f,0x16340ac5,0x00000000}},	//   kilo, _bilo_, деля,
  { {0x6b890ac6,0x98ac005b,0xdef7009a,0x00000000}},	//   _þega, ılır_, למנט_,
  { {0x628100c3,0x34940088,0x64590ac7,0x00000000}},	//   dilo, макр, _bowi,
  { {0x27ed0ac8,0xc955000d,0x64590ac9,0x00000000}},	//   _geen_, _ўтры, _cowi,
  { {0x64590051,0x87f9000d,0x26c50aca,0x00000000}},	//   _dowi, _фэст_, _filo_,
  { {0x25a50a2e,0x62810acb,0x271e001c,0x00000000}},	//   _fyll_, gilo, rānā_,
  { {0x76480051,0xecbe0042,0xc5690044,0x00000000}},	//   _indy, ्दाफ, _وحمل_,
  { {0xa3e60161,0x7af6024a,0xdfd80062,0x00000000}},	//   _बजट_, ksyt, зър_,
  { {0x6a60007a,0x53340189,0x62810acc,0x00000000}},	//   _höfu, _целт, bilo,
  { {0x6447003d,0x6281000c,0x7af60acd,0x00000000}},	//   ējie, cilo, dsyt,
  { {0x386600ea,0x6e940ace,0x7ea00072,0x00000000}},	//   kkor_, хиру, töpr,
  { {0x9f4b0080,0xea00008b,0x765a0acf,0x00000000}},	//   lací_, _đạn_, _loty,
  { {0xb06600fe,0x7af600d1,0xddca003b,0x00000000}},	// [c70] ssää, gsyt, _înşi,
  { {0x27ed0034,0x9f4b0080,0xa01b00ea,0x00000000}},	//   _seen_, nací_, gnöv,
  { {0x80a4007e,0x32d2008b,0xacb5005e,0x00000000}},	//   _زمین, _lây_, _обољ,
  { {0x2c09007e,0x62810ad0,0x26c50ad1,0x00000000}},	//   _بعدی_, zilo, _silo_,
  { {0x9f4b0080,0x765a001f,0xcc560063,0x00000000}},	//   kací_, _boty, _חברי_,
  { {0x64590ad2,0xdd1c0080,0x627901c2,0x00000000}},	//   _sowi, láše, lňov,
  { {0x64590045,0x765a0ad3,0x27ed015e,0x00000000}},	//   _powi, _doty, _teen_,
  { {0x386600c7,0x32d2001b,0x2ca9002c,0x00000000}},	//   ckor_, _bây_, nlad_,
  { {0x2ca9001f,0x32d2008b,0x62810ad4,0x00000000}},	//   ilad_, _cây_, tilo,
  { {0x32d2008b,0x2ca90ad5,0x2f1601e1,0x00000000}},	//   _dây_, hlad_, væg_,
  { {0x62810529,0x386d04aa,0x2ca90ad6,0x00000000}},	//   rilo, _kler_, klad_,
  { {0x627901d9,0x62810ad7,0x7af60072,0x00000000}},	//   jňov, silo, ysyt,
  { {0x32d2001b,0x2ca90ad8,0x6281055b,0x00000000}},	//   _gây_, dlad_, pilo,
  { {0x7cd500eb,0x248d00c3,0x2f1601e1,0x00000000}},	//   _sąra, lnem_, ræg_,
  { {0x6da30ad9,0x2d950ada,0x248d0adb,0x00000000}},	//   вира, ертс, onem_,
  { {0x248d0adc,0x3cfe0add,0x6a600137,0x00000000}},	//   nnem_, štvo_, _löft,
  { {0x248d00bd,0x32d2001b,0x3ced007d,0x00000000}},	// [c80] inem_, _xây_, ćeva_,
  { {0x7af60051,0x2bde0053,0x77f80053,0x00000000}},	//   rsyt, _फ्रा, ुल्क_,
  { {0x2ca90ade,0x386d007d,0x9f420066,0x00000000}},	//   blad_, _bler_, jakú_,
  { {0x9f4b0080,0xe7aa03d1,0x20d3008b,0x00000000}},	//   zací_, овел_, _mãi_,
  { {0xfc3f0025,0x20d3008b,0x248d0adf,0x00000000}},	//   _thír_, _lãi_, dnem_,
  { {0xa3c10053,0x38660ae0,0xa01b00a5,0x00000000}},	//   ंधन_, skor_, lnöt,
  { {0x386d01e3,0x9f4b016b,0xceb300b5,0x00000000}},	//   _fler_, vací_, דיג_,
  { {0x628f0003,0x29180089,0x83340330,0x00000000}},	//   écon, _iqra_, ених,
  { {0x41c90053,0xd6260021,0x9f4b0260,0x00000000}},	//   रशंस, _يعطي, tací_,
  { {0x20d3008b,0x41540376,0x32d2008b,0x00000000}},	//   _bãi_, евос, _vây_,
  { {0x9f4b0080,0x248d0ae1,0x20d3008b,0x00000000}},	//   rací_, bnem_, _cãi_,
  { {0x32d2001b,0xc1780078,0x246c0051,0x00000000}},	//   _tây_, lbėk_, yśmy_,
  { {0x80ca0053,0x6d480137,0x6d5a0ae2,0x00000000}},	//   _संके, ådan, ätan,
  { {0x8d6b000a,0x2ca9001f,0x2005005b,0x00000000}},	//   ојба_, wlad_, şli_,
  { {0x44fa001c,0x27e600ca,0x62790061,0x00000000}},	//   nī_, kbon_, tňov,
  { {0x2ca900a4,0xbae50021,0x4fc70121,0x00000000}},	//   ulad_, فكري, _оспа,
  { {0x7b180076,0x2ca90ae3,0x2d9e004d,0x00000000}},	// [c90] мотр_, rlad_, üter_,
  { {0x248d0ae4,0xce6b0a29,0x387f006c,0x00000000}},	//   znem_, _фрид_, _smur_,
  { {0x2ca900a5,0x321e00e5,0xdb06004c,0x00000000}},	//   plad_, ifty_, _vzká,
  { {0x3a380345,0xf8b1005d,0x59df0042,0x00000000}},	//   _earp_, اکس_, _प्रर,
  { {0x290c0146,0x248d00c3,0xcc760063,0x00000000}},	//   _ådan_, vnem_, _נעשה_,
  { {0x8cb90161,0xb0cf0053,0x45350062,0x00000000}},	//   ्दको, _संलग, ехит,
  { {0x248d00c3,0xe5a20086,0xa01b0072,0x00000000}},	//   tnem_, лиши, nnös,
  { {0x387f053b,0x20d3008b,0x7c2d0ae5,0x00000000}},	//   _umur_, _rãi_, near,
  { {0x248d0ae6,0x20d30013,0xa01b0050,0x00000000}},	//   rnem_, _sãi_, tiön,
  { {0x248d00c3,0x26df0035,0x7c2d0ae7,0x00000000}},	//   snem_, _ituo_, hear,
  { {0x00860ae8,0x248d0ae9,0x3219056c,0x00000000}},	//   елно, pnem_, ęsy_,
  { {0x7c2d0aea,0xcea90aeb,0x72d50094,0x00000000}},	//   jear, _הי_, _зодф,
  { {0x644b0aec,0x2ca000e5,0xf8b20047,0x00000000}},	//   _ingi, void_, טשט_,
  { {0x442d0aed,0x8235005d,0x27e60075,0x00000000}},	//   lee_, _سرتا, zbon_,
  { {0xfcb60076,0x7c2d0025,0x6fa00042,0x00000000}},	//   ещаю, fear, _गुरू,
  { {0x7c2d0aee,0x442d0aef,0xdca60af0,0x00000000}},	//   gear, nee_, хаби,
  { {0xac070088,0x2ca00af1,0xab270af2,0x00000000}},	// [ca0] энта_, roid_, нота_,
  { {0x27ff00e3,0x7c2d002b,0x442d0af3,0x00000000}},	//   _adun_, aear, hee_,
  { {0x442d0af4,0xa8060002,0x27e00331,0x00000000}},	//   kee_, езел, ñino_,
  { {0x7c2d0af5,0x7d0e00a4,0x6e2e00ea,0x00000000}},	//   cear, mubs, lebb,
  { {0x3a3800eb,0x27e60af6,0xf7430699,0x00000000}},	//   _tarp_, rbon_, лецо,
  { {0xe45f00fe,0x644b02ea,0x20000150,0x00000000}},	//   öön_, _angi, _ldii_,
  { {0x7ae40af7,0x442d0af8,0x2b400af9,0x00000000}},	//   lpit, fee_, lvic_,
  { {0x7ae40009,0x442d0afa,0x44fa001c,0x00000000}},	//   opit, gee_, rī_,
  { {0x7ae400fe,0x44fa008f,0xb05b0072,0x00000000}},	//   npit, sī_, nmäe,
  { {0x75d60021,0x644b0afb,0xda100053,0x00000000}},	//   _أيضا, _engi, ालित_,
  { {0xd48f0afc,0x018a015a,0x7c2d04aa,0x00000000}},	//   _бр_, ящий_, year,
  { {0x7f440003,0x442d0afd,0xf9930063,0x00000000}},	//   _briq, cee_, טרת_,
  { {0x69dc048e,0x387b0047,0x69ce0afe,0x00000000}},	//   _ofre, לטטױ, _ogbe,
  { {0x6e2e00ea,0x9f4b00cd,0x78a2004e,0x00000000}},	//   gebb, racà_, hoov,
  { {0x3ced007d,0xceeb007e,0xa01b0072,0x00000000}},	//   ćevo_, _کربن_, liöm,
  { {0xa01b0354,0x69dc0aff,0x7f850044,0x00000000}},	//   rnös, _afre, _للعن,
  { {0xddc50024,0x9f530051,0x7c2d0b00,0x00000000}},	// [cb0] _dlhš, ędów_, rear,
  { {0x442d0b01,0x6f0f01f4,0x7c2d0b02,0x00000000}},	//   zee_, mucc, sear,
  { {0x7c2d0037,0x6f0f0b03,0x6f1d004d,0x00000000}},	//   pear, lucc, ltsc,
  { {0xdddc0006,0x6f1d06aa,0x7658004c,0x00000000}},	//   mirš, otsc, ejvy,
  { {0x442d0b04,0x6f0f0314,0x69dc002b,0x00000000}},	//   vee_, nucc, _ffre,
  { {0x6d4a0027,0x442d0b05,0x6f1d0b06,0x00000000}},	//   _áfac, wee_, itsc,
  { {0xdd03001c,0x9181008b,0x628f0003,0x00000000}},	//   ērķa, iệc_, écom,
  { {0x6e2e013d,0x20ee004c,0x04450142,0x00000000}},	//   zebb, dři_, теин,
  { {0x36d5019d,0x442d0034,0x2ba70053,0x00000000}},	//   _розр, ree_, _कुमा,
  { {0x6f0f0b07,0xb1450086,0x69dc0b08,0x00000000}},	//   ducc, внол, _xfre,
  { {0x442d0b09,0xd00a0b0a,0x8ccd0053,0x00000000}},	//   pee_, мене_, _दंगो,
  { {0x6f1d0b0b,0x6e2e0b0c,0x59c30042,0x00000000}},	//   ftsc, webb, वेयर,
  { {0x3e740137,0x547a0063,0x6d450b0d,0x00000000}},	//   _läte_, _קטנו, _arha,
  { {0xdee30b0e,0x33760063,0xe72e01ce,0x00000000}},	//   рори, _בתנך_, сеy_,
  { {0x6e2e02f6,0xada60b0f,0x6f1d0122,0x00000000}},	//   rebb, тавл, atsc,
  { {0x2c7502fb,0x69dc0b10,0x6e2e00ea,0x00000000}},	//   _nådd_, _sfre, sebb,
  { {0x6d450199,0x7d1c00c3,0x6b6301e8,0x00000000}},	// [cc0] _erha, strs, акта,
  { {0x5db60021,0xbb430121,0x09e60505,0x00000000}},	//   _لإجر, шеук, тожн,
  { {0x1bea0121,0x7ae40b11,0xb05b078c,0x00000000}},	//   _одни_, spit, smäe,
  { {0xe45f004b,0xe7860320,0x7ae40b12,0x00000000}},	//   ööl_, куло, ppit,
  { {0x62830066,0x78a2004b,0xb05b004d,0x00000000}},	//   _omno, roov, lmäc,
  { {0x20ee0080,0x78a2004b,0xa9060021,0x00000000}},	//   yři_, soov, _لبرن,
  { {0x91fc001c,0x6e23005b,0xafdb00b9,0x00000000}},	//   skāk, _önbe, ldøe,
  { {0x39470146,0x63ab0831,0x04630121,0x00000000}},	//   ænse_, _bygn, итым,
  { {0x7eb200d1,0xe61a0690,0xd4330021,0x00000000}},	//   væpn, _ода_, شعيب,
  { {0x63ab0b13,0x20ee004c,0x8556005d,0x00000000}},	//   _dygn, tři_, _لیتر_,
  { {0x60f80088,0xb505007e,0x7c2600c2,0x00000000}},	//   эння_, _مظنو, _obkr,
  { {0x30a4005a,0xdddc0006,0x64a3000d,0x00000000}},	//   иряв, virš, _каха,
  { {0x6f1d0375,0xd36f00f2,0xa01b0072,0x00000000}},	//   utsc, _وهم_, liök,
  { {0x2c75010a,0x6f1d051d,0x6f0f0b14,0x00000000}},	//   _måde_, rtsc, rucc,
  { {0xeca7000a,0x6f0f0b15,0x62880b16,0x00000000}},	//   вјан, succ, mido,
  { {0x62880b17,0x20050078,0x26cc0b18,0x00000000}},	//   lido, ėlis_, _lido_,
  { {0x09bd0053,0x2c750b19,0xfe6e007e,0x00000000}},	// [cd0] ्ख्य, _nåde_, زگی_,
  { {0xadbd0088,0x62880b1a,0x99670002,0x00000000}},	//   _напi, nido, ктел,
  { {0x49a400e1,0x67290b1b,0x60cd0b1c,0x00000000}},	//   ајца, _spej, _kiam,
  { {0x24580024,0x2c7506a3,0xd5e8008b,0x00000000}},	//   _témy_, _både_, _đón,
  { {0xef1f005b,0x62880b1d,0xf77000f2,0x00000000}},	//   ntü_, kido, ياه_,
  { {0x7c3d0228,0xa3ac016a,0x98b3005b,0x00000000}},	//   _hasr, _गरज_, ıdır_,
  { {0x62880b1e,0x85780062,0x63ab0051,0x00000000}},	//   dido, ксът_, _sygn,
  { {0x6288001c,0xef1f0058,0x60cd0960,0x00000000}},	//   eido, ktü_, _niam,
  { {0x7c3d005b,0x26cc0b1f,0x99830078,0x00000000}},	//   _masr, _fido_, _tajų_,
  { {0x62880b20,0x3cfe00c2,0x7c3d0139,0x00000000}},	//   gido, štvi_, _lasr,
  { {0x65940002,0x64150021,0x6d40008f,0x00000000}},	//   _кафу, _مواط, āmak,
  { {0x7c3d0b21,0x60cd0b22,0x82d90062,0x00000000}},	//   _nasr, _ciam, _зддс_,
  { {0x69aa016a,0x62880b23,0x443f0026,0x00000000}},	//   _जुनी, bido, mdu_,
  { {0x62880b24,0x443f0b25,0x62830b26,0x00000000}},	//   cido, ldu_, _umno,
  { {0x60cd0290,0x443d00a4,0xe8140053,0x00000000}},	//   _fiam, _kaw_, _डाला_,
  { {0x60cd0b27,0x645b0b28,0xb05b004d,0x00000000}},	//   _giam, njui, rmäc,
  { {0x4bd90b29,0x8c43005a,0x3b0705fb,0x00000000}},	// [ce0] ться_, щете, лето_,
  { {0x443d04bf,0x443f0072,0x2c750b2a,0x00000000}},	//   _law_, hdu_, _råde_,
  { {0x2bc50053,0xb05b0072,0x63ae0022,0x00000000}},	//   लेबा, lmäa, ębni,
  { {0x3860007a,0x26cc0b2b,0x78bb0016,0x00000000}},	//   ðir_, _sido_, _chuv,
  { {0x443f0742,0x26cc006d,0x4bfb0063,0x00000000}},	//   ddu_, _pido_, _אלכס,
  { {0x0f37014e,0x443f0b2c,0x5694007b,0x00000000}},	//   טרנט_, edu_, јакт,
  { {0x62880b2d,0x443d057c,0xb05b0072,0x00000000}},	//   vido, _baw_, hmäa,
  { {0xdd0400eb,0x38b50137,0x44b40002,0x00000000}},	//   ūrėt, påra_, јбис,
  { {0x60cd0025,0xb27400d7,0x26cc017d,0x00000000}},	//   _riam, илиш, _tido_,
  { {0x60cd0b2e,0x645b00fe,0x443f0b2f,0x00000000}},	//   _siam, ajui, adu_,
  { {0xa0550086,0x62880b30,0x443d00f1,0x00000000}},	//   авні, rido, _faw_,
  { {0xf5370063,0x62880b31,0xdfd10021,0x00000000}},	//   _תנאי_, sido, تيح_,
  { {0x62880b32,0x00000000,0x00000000,0x00000000}},	//   pido,   ,   ,
  { {0x64400026,0x6b890046,0xef1f0075,0x00000000}},	//   ldmi, _þegi, rtü_,
  { {0xdcbb005a,0x64400b33,0xef1f005b,0x00000000}},	//   еща_, odmi, stü_,
  { {0xaed5000a,0x64400b34,0x61fa0b35,0x00000000}},	//   _коиш, ndmi, latl,
  { {0x3b550001,0x6d4a007a,0x6e950086,0x00000000}},	// [cf0] шкар, _áfan, _випу,
  { {0xdb2400ea,0x61fa0b36,0x443f0b37,0x00000000}},	//   ásán, natl, zdu_,
  { {0xd7d50001,0x39470026,0x628f072e,0x00000000}},	//   ажењ, íns_, écoi,
  { {0xfe7f002b,0xc1780078,0x61fa0b38,0x00000000}},	//   opïo_, lbės_, hatl,
  { {0x07a502a9,0xe7390b39,0x443f073c,0x00000000}},	//   јалн, тел_, vdu_,
  { {0x443d0b3a,0x64400b3b,0x6a720014,0x00000000}},	//   _saw_, edmi, _hæfn,
  { {0x3e74004b,0x443f01e1,0x443d0b3c,0x00000000}},	//   _jäta_, tdu_, _paw_,
  { {0x443f0b3d,0x3e740b3e,0xb05b0072,0x00000000}},	//   udu_, _mäta_, ymäa,
  { {0x43750b3f,0x645b068f,0xfc3f0026,0x00000000}},	//   руйт, rjui, _maí_,
  { {0xc6a7041d,0x2ef2001f,0x64400b40,0x00000000}},	//   _срби, _rwyf_, admi,
  { {0x6e3e00f3,0x7c24007a,0x443d001f,0x00000000}},	//   _rapb, yfir, _taw_,
  { {0x44f3003b,0x3f6a0b41,0x61fa0b42,0x00000000}},	//   mţ_, вимо_, aatl,
  { {0x61fa0058,0x8234005d,0x00000000,0x00000000}},	//   batl, _گرنا,   ,
  { {0x91e50001,0x61450766,0x200c0058,0x00000000}},	//   _токе, _века, şdi_,
  { {0x44f3000c,0x7c240b43,0xa3dc0053,0x00000000}},	//   nţ_, tfir, तुक_,
  { {0xb05b0b44,0x3e7b0080,0x9ce5000d,0x00000000}},	//   lmän, eště_, сцёл,
  { {0xfc3f0016,0xb05b0137,0x7c240b45,0x00000000}},	// [d00] _daí_, omän, rfir,
  { {0x7c240b46,0xab270b47,0x7bdf0b48,0x00000000}},	//   sfir, рофа_, acqu,
  { {0xd00f006a,0x19b90088,0x673b0b49,0x00000000}},	//   _علی_, гуць_, _asuj,
  { {0xc18c0047,0x8c460b4a,0xa01b0072,0x00000000}},	//   עטאָ, _теме, tiöi,
  { {0x27e902dd,0xbb430086,0x9168008b,0x00000000}},	//   ñana_, _деяк, _mức_,
  { {0xbb43000a,0x3cfe027c,0xa01b00fe,0x00000000}},	//   _ќерк, štvu_, riöi,
  { {0x44240089,0x61fa0b4b,0xa5070002,0x00000000}},	//   tfm_, vatl, аеја_,
  { {0x98a30b4c,0x64400b4d,0x656a00a3,0x00000000}},	//   _дисе, udmi, ryfh,
  { {0xc1780006,0x61fa00ea,0xd2500021,0x00000000}},	//   ybės_, tatl, كنة_,
  { {0x67220078,0x27e1004c,0xdd1c0066,0x00000000}},	//   mtoj, ěhne_, _záťa,
  { {0x2c750137,0x67220b4e,0x91680013,0x00000000}},	//   _låda_, ltoj, _bức_,
  { {0x67220b4f,0x61fa0b50,0x44320013,0x00000000}},	//   otoj, satl, _úy_,
  { {0x90980062,0x67220b51,0x61fa0b52,0x00000000}},	//   рвят_, ntoj, patl,
  { {0xea0000aa,0x672200eb,0x645d00fe,0x00000000}},	//   _đến_, itoj, ösiv,
  { {0x672200fe,0x1df80076,0x6e940121,0x00000000}},	//   htoj, ресы_, циру,
  { {0x2c7500c7,0x5c740ae8,0x115b0063,0x00000000}},	//   _båda_, олст, _ידוע,
  { {0xa9e70021,0xdb230058,0x9bc7030b,0x00000000}},	// [d10] لثان, _örüm, рёвк,
  { {0xd1380051,0x3e740137,0x2019004e,0x00000000}},	//   ową_, _täta_, lgsi_,
  { {0x67220b53,0xdd910049,0xb7d5009e,0x00000000}},	//   etoj, _روح_, مقاب,
  { {0x20190397,0x315700b5,0x286b0062,0x00000000}},	//   ngsi_, ייבן_, ързо_,
  { {0x6d5a0072,0x27200013,0xb05b0072,0x00000000}},	//   ätav, gòn_, ymän,
  { {0x78a20512,0xbb3a00b5,0x5a47000d,0x00000000}},	//   čova, _געשי, _тэма,
  { {0x19940062,0x28f80499,0x6e350022,0x00000000}},	//   _даря, _весь_, iezb,
  { {0xd7c9007e,0x0d980063,0xfbdf00be,0x00000000}},	//   _موزه_, יכום_, _inês_,
  { {0xb05b01bb,0xd2a90121,0xf7850044,0x00000000}},	//   tmän, лкие_, _الذَ,
  { {0x27fd001f,0x9168008b,0x2ca9002b,0x00000000}},	//   lawn_, _sức_, hoad_,
  { {0x61f801f7,0x29010b54,0xb05b0b55,0x00000000}},	//   _devl, nsha_, rmän,
  { {0x45b60063,0x307a0021,0xf9920063,0x00000000}},	//   _הפעל_, احدة_, לרי_,
  { {0x248d003d,0xb05b0072,0x889a0149,0x00000000}},	//   miem_, mmäl, רברי,
  { {0xd5b1001b,0x248d001c,0x27fd001f,0x00000000}},	//   _ký_, liem_, hawn_,
  { {0x9168008b,0x628f0003,0x2d9e0058,0x00000000}},	//   _tức_, écou, çte_,
  { {0x672200eb,0x248d0b56,0xb05b0137,0x00000000}},	//   ytoj, niem_, nmäl,
  { {0xd5b1001b,0xf1bf0080,0x6e350b57,0x00000000}},	// [d20] _lý_, řád_, bezb,
  { {0xb05b0b58,0x6f040b59,0x764106f1,0x00000000}},	//   hmäl, _ivic, _naly,
  { {0xfe37014e,0x248d0b5a,0x69260002,0x00000000}},	//   _פרטי_, kiem_, смеа,
  { {0x248d003d,0x91fc003d,0x17fa0021,0x00000000}},	//   jiem_, nkār, اراة_,
  { {0x248d003d,0xd1380051,0x366a0002,0x00000000}},	//   diem_, zwą_, ладо_,
  { {0x27200013,0x67220b51,0x47330085,0x00000000}},	//   ròn_, rtoj, яніс,
  { {0x764100eb,0x9f590003,0x91fc008f,0x00000000}},	//   _daly, rasé_, kkār,
  { {0xb176008b,0x248d0b5b,0x76430022,0x00000000}},	//   _ngượ, giem_, adny,
  { {0xa3a80042,0xa01b00a5,0x988b009a,0x00000000}},	//   _खुश_, lhög, _עָלֵ,
  { {0xda7b0047,0xd1380022,0x7c360b5c,0x00000000}},	//   ָנטר, twą_, heyr,
  { {0x909906b4,0x7c360072,0xd011002a,0x00000000}},	//   ивот_, keyr, ولد_,
  { {0xbec3008f,0xd1380022,0x248d0b5d,0x00000000}},	//   ķīmi, rwą_, ciem_,
  { {0x5f94005a,0x3e970021,0x94bb009a,0x00000000}},	//   зият, مؤسس, _עמדת,
  { {0x64420025,0x539b0063,0x7d15008f,0x00000000}},	//   _haoi, _גידו, tuzs,
  { {0xb05b00fe,0x52750002,0xa1930085,0x00000000}},	//   lmäm, _ќучу, _нашч,
  { {0x7d15013d,0x9c390131,0x7643056c,0x00000000}},	//   ruzs, јпат_, zdny,
  { {0x2ca90b5e,0x64420b5f,0xd9f902d8,0x00000000}},	// [d30] road_, _maoi, инац_,
  { {0x7f4d0b60,0xf9c7047e,0xacf80051,0x00000000}},	//   _iraq, бщен, _żółt,
  { {0xb05b00fe,0x78a20195,0x2901007d,0x00000000}},	//   ymäl, čovn, usha_,
  { {0x6d40003d,0xdb0f0164,0x644200a4,0x00000000}},	//   āmat, _lycé, _naoi,
  { {0x76410006,0x248d0b61,0xbc1a0063,0x00000000}},	//   _paly, viem_, _דורש,
  { {0xf1c80161,0x248d0051,0x91fc001c,0x00000000}},	//   रधान, wiem_, zkār,
  { {0x248d003d,0x9f40007a,0x2b490150,0x00000000}},	//   tiem_, _leið_, lvac_,
  { {0x7b08007a,0x13090b62,0x7aed0b63,0x00000000}},	//   _ástæ, аний_, opat,
  { {0xb7bd0529,0x64420027,0x248d0b61,0x00000000}},	//   _obţi, _daoi, riem_,
  { {0x248d003d,0x2f100026,0xbb3c0047,0x00000000}},	//   siem_, _lögð_, רעזי,
  { {0x64420027,0x645d0b64,0x91fc001c,0x00000000}},	//   _faoi, ösis, tkār,
  { {0x9fca026b,0x7aed0104,0xb1840066,0x00000000}},	//   игна_, kpat, íťaz,
  { {0x98c50006,0xe28e07f0,0x083a0047,0x00000000}},	//   štės_, _жа_, בערל,
  { {0xc5f90047,0x91fc008f,0x539a069a,0x00000000}},	//   יפֿט, skār, _דינו,
  { {0xa01b0b65,0xa3c10053,0x7aed0b66,0x00000000}},	//   giös, ंधक_, epat,
  { {0x6f00000f,0x7f4d017d,0xa01b00a5,0x00000000}},	//   ámcs, _fraq, vhög,
  { {0x7aed00bb,0x2ab4004b,0xa01b0072,0x00000000}},	// [d40] gpat, läbi_, riöt,
  { {0x63b600d1,0x6d5a0072,0xf2210042,0x00000000}},	//   _øyne, ätas, _माफ़_,
  { {0x7aed0b67,0x6ee5007e,0x6497001c,0x00000000}},	//   apat, _وسیل, rģij,
  { {0x628600ea,0xa01b0b68,0xd7ef0021,0x00000000}},	//   ékoz, rhög, نكم_,
  { {0x6d430014,0xa01b0137,0x2c7c0046,0x00000000}},	//   _ánar, shög, _vídd_,
  { {0x64420025,0x6b63000d,0x6497003b,0x00000000}},	//   _saoi, _ўкра, nţif,
  { {0x2aaf004d,0x69230b69,0x9e5b069a,0x00000000}},	//   rübt_, _омра, יכסט,
  { {0xe8140053,0x9998008f,0xa3e50053,0x00000000}},	//   _डाटा_, _garš_, बुल_,
  { {0xa01b0244,0xd5a4005d,0x66e50044,0x00000000}},	//   ziös, _کلای, _فألق,
  { {0x026a0086,0x3f820b6a,0x9f400014,0x00000000}},	//   рший_, dzku_, _reið_,
  { {0x3a37014e,0x2ee90b6b,0x7aed0051,0x00000000}},	//   חרים_, _staf_, zpat,
  { {0xb05b00fe,0x232a0336,0x628f0b6c,0x00000000}},	//   mmäk, _води_, écor,
  { {0xe29a0138,0xb05b0072,0xd2520044,0x00000000}},	//   _кад_, lmäk, _ينص_,
  { {0x2907000f,0x628a004d,0x2f100014,0x00000000}},	//   ának_, _umfo, _sögð_,
  { {0xdb060072,0x12a90021,0xdc8b0239,0x00000000}},	//   _lykä, _ادنى_, асал_,
  { {0xe57100b5,0x69d80006,0x7f4d0b6d,0x00000000}},	//   ײַל_, žvel, _traq,
  { {0x7aed0035,0xb05b0072,0x6d5a0b6e,0x00000000}},	// [d50] upat, hmäk, ätar,
  { {0x7aed0b6f,0x8e84005e,0x7d010046,0x00000000}},	//   rpat, _огње, álss,
  { {0xdc2f001c,0x629a0b70,0x7aed089c,0x00000000}},	//   ažād, into, spat,
  { {0x7aed0b71,0xf8070054,0x7c590044,0x00000000}},	//   ppat, ічен, _الحر_,
  { {0x78ab00b9,0x8cba0053,0xfc5a0063,0x00000000}},	//   rogv, ्षरो, _הכרמ,
  { {0x1af6009a,0x7f3c009d,0x00000000,0x00000000}},	//   _ממשל_, יעדו,   ,
  { {0xa5060062,0x2d830022,0x929d0022,0x00000000}},	//   пеща_, nzje_, jsła,
  { {0x629a0b72,0xc952009d,0xbd9c009d,0x00000000}},	//   ento, _אמל_, יסות,
  { {0xafdb01f2,0x383401dd,0xf773014d,0x00000000}},	//   gdøm, _інфр, _غار_,
  { {0xb05b0b73,0x7d08004c,0xaabd0042,0x00000000}},	//   lmäh, ádsk, ्गिक,
  { {0x02020088,0xe45f0019,0x91fc001c,0x00000000}},	//   эзэн, öös_, rkāp,
  { {0x629a0b74,0x55ba0063,0x92a40022,0x00000000}},	//   anto, _המעו, ółrz,
  { {0xc4840085,0x929d056c,0xaabd0082,0x00000000}},	//   _ўлік, asła, ्गाक,
  { {0xb05b0b75,0x92b70044,0x02450044,0x00000000}},	//   hmäh, _بحصا, _رَبَ,
  { {0x7c2f000c,0xa01b0137,0x9993004c,0x00000000}},	//   _bbcr, riör, dexů_,
  { {0x8fa60054,0xaf0601f6,0xa7fd013d,0x00000000}},	//   _найе, _епил, _elűz,
  { {0x207b0047,0x8e560086,0x20020b76,0x00000000}},	// [d60] _לאקא, _етні, maki_,
  { {0x7c2f0146,0x20020b77,0xdb060051,0x00000000}},	//   _ebcr, laki_, _szkó,
  { {0xceb300b7,0x4ddb0063,0xe853007e,0x00000000}},	//   _איז_, _לחיו, کنند,
  { {0x38cb006a,0x18a30062,0x6f0600b9,0x00000000}},	//   مانی_, нахм, oskc,
  { {0x29130268,0x629a00f1,0x99f60085,0x00000000}},	//   arxa_, ynto, _няві,
  { {0xd6d90086,0x929d0051,0x20020075,0x00000000}},	//   іті_, ysła, haki_,
  { {0x20020b78,0x442f0b79,0xa6e9008d,0x00000000}},	//   kaki_, _bbg_, _nhươ,
  { {0x629a0b7a,0x20020211,0x399b0063,0x00000000}},	//   wnto, jaki_, _הילד,
  { {0x200201f7,0x6b8400bd,0x291a0b7b,0x00000000}},	//   daki_, nzig, lupa_,
  { {0xb05b024a,0xafdb01f2,0x877b0063,0x00000000}},	//   mmäi, rdøm, _האמי,
  { {0x2497006a,0xa6e9001b,0xdb2300ea,0x00000000}},	//   _کنند_, _chươ, _öröm,
  { {0x60c407b9,0x27e60b7c,0x35e20042,0x00000000}},	//   _chim, ncon_, _पलड़,
  { {0x6b840b7d,0x60c40035,0x3a3a00a5,0x00000000}},	//   jzig, _dhim, kepp_,
  { {0x291a0b7e,0xd3570063,0x539b0063,0x00000000}},	//   kupa_, _מידי_, _פיגו,
  { {0x20020009,0xeda40086,0xdddc005f,0x00000000}},	//   baki_, ешто, birž,
  { {0x30a40088,0x5cb9000d,0x60c4003b,0x00000000}},	//   _прыв, ілаў_, _ghim,
  { {0x3f9e01f7,0xcb340062,0x290e0046,0x00000000}},	// [d70] ştur_, нетъ, áfan_,
  { {0x99d70021,0x6d410046,0x2a6a0b7f,0x00000000}},	//   ستطا, ælas, _cobb_,
  { {0x290701da,0x291a00a4,0x6d410058,0x00000000}},	//   éna_, gupa_, çlad,
  { {0x3869007a,0x6a73005b,0x6b84004d,0x00000000}},	//   ðar_, _sıfı, bzig,
  { {0x6497000c,0xf72b000d,0x7c2d0b80,0x00000000}},	//   nţie, сцей_, mfar,
  { {0x442f0150,0x20020b81,0x7c2d0b82,0x00000000}},	//   _sbg_, zaki_, lfar,
  { {0x6f090080,0xa9340651,0x291a0b83,0x00000000}},	//   šech, _перш, cupa_,
  { {0x200200ac,0x7c2d0b84,0xb4b70042,0x00000000}},	//   xaki_, nfar, छते_,
  { {0x7c2d0b85,0x20020b86,0xd408005d,0x00000000}},	//   ifar, vaki_, ستيم_,
  { {0xa6e9001b,0x7c2d0616,0x60c40b87,0x00000000}},	//   _phươ, hfar, _shim,
  { {0x20020b88,0xb97a0047,0x213e001f,0x00000000}},	//   taki_, ַנשי, gwth_,
  { {0x66030b89,0xf4b6005d,0x00000000,0x00000000}},	//   lank, _قشنگ,   ,
  { {0x64490185,0x20020b8a,0x64590b8b,0x00000000}},	//   mdei, raki_, _inwi,
  { {0xa6e9001b,0x442d0b8c,0x200207b8,0x00000000}},	//   _thươ, lfe_, saki_,
  { {0x20020b8d,0x7c2d0036,0x6497003b,0x00000000}},	//   paki_, ffar, aţie,
  { {0xf1a7007e,0x27ff00bd,0x6b84004d,0x00000000}},	//   _واژه_, _neun_, tzig,
  { {0x6497000c,0x442d0359,0x3e740019,0x00000000}},	// [d80] cţie, ife_, _läti_,
  { {0x6b84004d,0x1996005e,0x66030b8e,0x00000000}},	//   rzig, мјер, jank,
  { {0x66030b8f,0xb80a0021,0x6459006f,0x00000000}},	//   dank, قيام_, _onwi,
  { {0x224700e8,0x2ee000ac,0x291a0b90,0x00000000}},	//   _lank_, _kuif_, rupa_,
  { {0x6449001f,0x2ee00003,0x7d1c0b91,0x00000000}},	//   ddei, _juif_, lurs,
  { {0x442d0b92,0x66030b93,0x6e3c05b2,0x00000000}},	//   efe_, gank, nerb,
  { {0x69dc0016,0x442d069e,0x6e3c0b94,0x00000000}},	//   _igre, ffe_, ierb,
  { {0x3ae400c7,0x660300fe,0xb05b00fe,0x00000000}},	//   _köp_, aank, lmäv,
  { {0x7ae20025,0x22470b95,0x66030b96,0x00000000}},	//   íoth, _bank_, bank,
  { {0x38660137,0x64490b97,0x442d0b98,0x00000000}},	//   ljor_, adei, afe_,
  { {0x018a0076,0x7c2d001f,0x6e3c0b99,0x00000000}},	//   ющий_, yfar, derb,
  { {0x7d1c007a,0x73c60021,0x1c1d0042,0x00000000}},	//   durs, _قيام, _फाइल_,
  { {0x7d1c00e8,0xdfd8005a,0x69dc0b9a,0x00000000}},	//   eurs, дър_, _ogre,
  { {0x53330086,0x69dc0b9b,0x764a00b9,0x00000000}},	//   _решт, _ngre, ndfy,
  { {0x76480089,0xc348008b,0xec6b0abb,0x00000000}},	//   _mady, _hổ_, орак_,
  { {0x6497003b,0x69dc03e1,0x660301f0,0x00000000}},	//   pţie, _agre, zank,
  { {0x7c2d0b9c,0x765a0b9d,0x6e3c0b9e,0x00000000}},	// [d90] rfar, _onty, berb,
  { {0x27ff00e8,0x68fc001f,0x7c2d0b9f,0x00000000}},	//   _seun_, _bwrd, sfar,
  { {0x5e5600b5,0x7d1c0ba0,0x6449001f,0x00000000}},	//   _װירע_, curs, ydei,
  { {0x6d450ba1,0x929d0022,0x765a0ba2,0x00000000}},	//   _isha, ysło, _anty,
  { {0x61ea0ba3,0x764800bb,0xc348008b,0x00000000}},	//   _offl, _bady, _nổ_,
  { {0x6f1d0290,0x68fc001f,0x8afa0063,0x00000000}},	//   iusc, _fwrd, _מהשי,
  { {0x66030ba4,0x68fc002b,0x629d0003,0x00000000}},	//   rank, _gwrd, ésom,
  { {0x765a0609,0xc348001b,0x6d450035,0x00000000}},	//   _enty, _bổ_, _msha,
  { {0xc348008b,0x628104bf,0x22470ba5,0x00000000}},	//   _cổ_, thlo, _pank_,
  { {0x272902dd,0xe1f10021,0xda0f0053,0x00000000}},	//   mún_, دسة_, ाणित_,
  { {0x442d00bd,0x9f5e005b,0x386d004b,0x00000000}},	//   pfe_, ştü_, _koer_,
  { {0x6e3c0ba6,0xf09f00cd,0x6f1d0b27,0x00000000}},	//   werb, gnà_, fusc,
  { {0x24180086,0x6d450ba7,0x22470ba8,0x00000000}},	//   _цією_, _asha, _tank_,
  { {0x387f00cd,0x386d00ac,0x7bdd00a4,0x00000000}},	//   _llur_, _loer_, _agsu,
  { {0x387f005b,0x7afd001f,0x66010ba9,0x00000000}},	//   _olur_, _awst, _melk,
  { {0x249f0026,0x660100ea,0x7d1c0baa,0x00000000}},	//   nnum_, _lelk, rurs,
  { {0x249f0026,0x6e3c0bab,0x1fb601dd,0x00000000}},	// [da0] inum_, perb, _яскр,
  { {0x387f017e,0x672b04aa,0x3205004c,0x00000000}},	//   _alur_, dtgj, naly_,
  { {0x76480bac,0x249f0bad,0x386600cd,0x00000000}},	//   _rady, knum_, tjor_,
  { {0x7648002c,0x3f7a0149,0x3205004c,0x00000000}},	//   _sady, ּאַס, haly_,
  { {0x2729048e,0x6136000f,0x386d0bae,0x00000000}},	//   gún_, _külö, _doer_,
  { {0x6601016b,0xc3480013,0xe769004c,0x00000000}},	//   _celk, _rổ_, nářů,
  { {0x249f007a,0x76480006,0xc348008b,0x00000000}},	//   fnum_, _vady, _sổ_,
  { {0x249f007a,0x66010019,0x54540795,0x00000000}},	//   gnum_, _eelk, твит,
  { {0xb05b00c7,0xcc3b00b5,0x6497001c,0x00000000}},	//   lläg, לעקט, eģis,
  { {0x2c7c006d,0x2ca00025,0x389800c2,0x00000000}},	//   _oído_, hnid_, ačrt_,
  { {0x2b910024,0xb05b00c7,0xd6cf0593,0x00000000}},	//   môcť_, nläg, _اقل_,
  { {0xc348001b,0x33f60021,0x69c30051,0x00000000}},	//   _tổ_, _أساس, żneg,
  { {0xb05b00bd,0xf09f00cd,0x9326007e,0x00000000}},	//   hläg, rnà_, _سرشن,
  { {0x6f1d0027,0xa01b087d,0xddde011b,0x00000000}},	//   rusc, chön, _kopř,
  { {0xac950071,0x6f1d0baf,0x4c950054,0x00000000}},	//   вавш, susc, вивс,
  { {0xdcb8011c,0xb05b0137,0x91bb009a,0x00000000}},	//   ещу_, dläg, _ממוי,
  { {0x64970529,0x613600ea,0x386d0bb0,0x00000000}},	// [db0] nţia, _fülö, _roer_,
  { {0xb05b0bb1,0x2ca0004b,0x6e25004d,0x00000000}},	//   amät, anid_, _uchb,
  { {0x6d450035,0x249f0014,0xb05b00a5,0x00000000}},	//   _usha, ynum_, gläg,
  { {0x660100fe,0xb05b00fe,0xb06600fe,0x00000000}},	//   _selk, mmäs, mpää,
  { {0xf7450bb2,0xd6db0bb3,0x386d04c6,0x00000000}},	//   тело, чте_, _voer_,
  { {0x29070139,0x64970078,0xe9d3007e,0x00000000}},	//   ánas_, dţia, _مغز_,
  { {0x32050080,0x386d00e8,0x27290025,0x00000000}},	//   valy_, _toer_, sún_,
  { {0x660103a8,0x249f0026,0xddde004c,0x00000000}},	//   _welk, unum_, _dopř,
  { {0xb05b00fe,0x249f0bb4,0x66010bb5,0x00000000}},	//   hmäs, rnum_, _telk,
  { {0x42550002,0x249f0014,0x44260bb6,0x00000000}},	//   ттит, snum_, _eco_,
  { {0x249f0026,0xb05b0bb7,0xa01b0014,0x00000000}},	//   pnum_, ymät, rhön,
  { {0x3e7400c7,0xdee60bb8,0xa01b0014,0x00000000}},	//   _lätt_, коми, shön,
  { {0x443f0bb9,0xab5b00ea,0x10a30a36,0x00000000}},	//   meu_, _szün, риян,
  { {0x63a400eb,0x644b0bba,0x6f0d0080,0x00000000}},	//   _žing, _hagi, _dvac,
  { {0x644b0bbb,0x2907003b,0x27ed004d,0x00000000}},	//   _kagi, ânal_, _ofen_,
  { {0x443f0bbc,0xb05b0137,0x7f860021,0x00000000}},	//   neu_, vläg, _للبن,
  { {0x443f0bbd,0x644b0bbe,0x7c2b00cd,0x00000000}},	// [dc0] ieu_, _magi, ògra,
  { {0xaa7b0026,0x644b0bbf,0x6a830002,0x00000000}},	//   _stýr, _lagi, алуа,
  { {0xb05b0bc0,0xa926047e,0x984a0062,0x00000000}},	//   mmär, тдел, дяла_,
  { {0x644b0bc1,0xb05b0bc2,0x63a40014,0x00000000}},	//   _nagi, rläg, _þing,
  { {0x443f0bc3,0xb05b00c7,0x27e00bc4,0x00000000}},	//   deu_, släg, žino_,
  { {0x7bc600c3,0xb05b0bc5,0xddde0080,0x00000000}},	//   _izku, pläg, _popř,
  { {0x644b06a7,0x443f0268,0x8546000d,0x00000000}},	//   _bagi, feu_, тэле,
  { {0x38c8006a,0x443f0bc6,0x644b0290,0x00000000}},	//   _سازی_, geu_, _cagi,
  { {0xb05b00c7,0xf2c60bc7,0x03c30200,0x00000000}},	//   kmär, ксон, исьм,
  { {0x6497000c,0xb05b00fe,0x7af60078,0x00000000}},	//   rţia, ymäs, ipyt,
  { {0x443f0bc8,0x78a201b3,0x644b0bc9,0x00000000}},	//   beu_, onov, _fagi,
  { {0x04460138,0x443f0bca,0x61f5005b,0x00000000}},	//   _једн, ceu_, ızla,
  { {0x6440005b,0x9f590137,0x44240bcb,0x00000000}},	//   memi, kaså_, mgm_,
  { {0x64970529,0x64400bcc,0x644b0022,0x00000000}},	//   nţin, lemi, _zagi,
  { {0x3e7400c7,0xac27000a,0xf708008b,0x00000000}},	//   _rätt_, кфак, hủ_,
  { {0x3e7401e3,0x7c240290,0x64400bcd,0x00000000}},	//   _sätt_, ggir, nemi,
  { {0x5a350431,0xb05b01bb,0xb0660072,0x00000000}},	// [dd0] лнат, smäs, spää,
  { {0x443f0bce,0xdce70051,0x753a003b,0x00000000}},	//   zeu_, zyję, _optz,
  { {0x64400bcf,0x83fd00ea,0x7af60051,0x00000000}},	//   kemi, rkőz, apyt,
  { {0x443f0268,0x6497003b,0xc19b0063,0x00000000}},	//   xeu_, eţin, ושבי,
  { {0x443f0bd0,0x3b640062,0x3e740137,0x00000000}},	//   veu_, _кърв, _tätt_,
  { {0x76240054,0x64400526,0xd626005e,0x00000000}},	//   иміз, eemi, гоше_,
  { {0x443f0bd1,0x644b0bd2,0x27ee004c,0x00000000}},	//   teu_, _pagi, émní_,
  { {0x64400004,0x69c7082a,0x03250002,0x00000000}},	//   gemi, _izje, гдин,
  { {0x443f0bd3,0x6497003b,0xd299071f,0x00000000}},	//   reu_, bţin, етні_,
  { {0x443f0bd1,0x644b0bd4,0x36d50bd5,0x00000000}},	//   seu_, _wagi, _созр,
  { {0xe4e7019d,0x44f5005a,0x443f0bc8,0x00000000}},	//   _різн, _спес, peu_,
  { {0xa3550049,0xa3ea0042,0x64400bd6,0x00000000}},	//   _مختص, _मलय_, cemi,
  { {0x6d41005b,0x99750051,0xb05b0bd7,0x00000000}},	//   çlan, nęła_, tmär,
  { {0x78a20008,0x539a009f,0xdee30bd8,0x00000000}},	//   znov, _אינו, сори,
  { {0x6497000c,0x81bc008f,0xc6920bd9,0x00000000}},	//   nţio, sfēr, זאם_,
  { {0xb05b0004,0xdd8f0021,0x3e740bda,0x00000000}},	//   smär, سوق_, _päts_,
  { {0xb05b00c7,0x7c240bdb,0x99750051,0x00000000}},	// [de0] pmär, rgir, jęła_,
  { {0x2d9e0003,0x7af60078,0xb05b0072,0x00000000}},	//   ûtes_, rpyt, lmäp,
  { {0xdce8001c,0x82960047,0xaf36007e,0x00000000}},	//   ēlēt, נדעס_, _شرکت,
  { {0xe3a7006a,0x6440017d,0x6d40003b,0x00000000}},	//   _هر_, xemi, ămad,
  { {0x4733007e,0x2bba0044,0x78a20bdc,0x00000000}},	//   مروز, _ساحة_, rnov,
  { {0x78a201b3,0x96b7005e,0x6497003b,0x00000000}},	//   snov, лују_, uţin,
  { {0xafdb02ab,0x6497000c,0x64400bdd,0x00000000}},	//   ndør, rţin, temi,
  { {0x6497000c,0xe3140002,0x78a201d1,0x00000000}},	//   sţin, амињ, čovs,
  { {0x6497003b,0xeb970047,0x64400bde,0x00000000}},	//   aţio, ָדיר_, remi,
  { {0x67220006,0x6497003b,0x64400708,0x00000000}},	//   muoj, lţil, semi,
  { {0xd657014e,0x6497000c,0x3cf80024,0x00000000}},	//   _תיבת_, cţio, jprv_,
  { {0x6497000c,0x26de0bdf,0x9f590025,0x00000000}},	//   nţil, _hito_, masú_,
  { {0x26de0006,0x67220006,0x7ae60035,0x00000000}},	//   _kito_, nuoj, _nukt,
  { {0xb05b0199,0xc7b3014e,0x0cbf0053,0x00000000}},	//   fläc, מבר_, ्ष्म,
  { {0x6d580026,0x765e00fe,0x26de0be0,0x00000000}},	//   _ával, öpyy, _mito_,
  { {0x7ae6053b,0x67220006,0x1f750ac5,0x00000000}},	//   _bukt, kuoj, _влия,
  { {0x26de0016,0xafdb07e6,0x67220006,0x00000000}},	// [df0] _oito_, rdøs, juoj,
  { {0x44ea03b2,0x26de00bb,0x200b0be1,0x00000000}},	//   _où_, _nito_, laci_,
  { {0x60cd0be2,0x629a0be3,0x62880072,0x00000000}},	//   _kham, iito, ihdo,
  { {0x89340032,0x7ae600df,0xa565007e,0x00000000}},	//   إعلا, _fukt, یگان,
  { {0x67220006,0xe7580086,0xd6d50121,0x00000000}},	//   guoj, лиці_, ажды,
  { {0x8704015a,0x629a0be4,0x44ea008b,0x00000000}},	//   сяце, jito, _bù_,
  { {0x200b02f4,0x26de0be5,0x6f1d00bd,0x00000000}},	//   kaci_, _dito_, hrsc,
  { {0x628800fe,0x44ea001b,0x200b04c9,0x00000000}},	//   ehdo, _dù_, jaci_,
  { {0xd6270032,0xc482019d,0x200b0743,0x00000000}},	//   _معاي, ільк, daci_,
  { {0xa7740be6,0x6497000c,0x26de0150,0x00000000}},	//   _улуч, pţio, _gito_,
  { {0x6497000c,0x4254000d,0x78a900d1,0x00000000}},	//   lţim, стыт, _kjev,
  { {0x628800fe,0xa01b004d,0x200b0be7,0x00000000}},	//   ahdo, nhöh, gaci_,
  { {0x60cd0035,0x2329047e,0xdee60be8,0x00000000}},	//   _dham, _роли_, роги,
  { {0x62880be9,0x78a9007d,0x629a0bea,0x00000000}},	//   chdo, _ljev, cito,
  { {0x6f1d0194,0x67220006,0x200b017f,0x00000000}},	//   arsc, zuoj, baci_,
  { {0x200b0beb,0x3ceb0061,0x60cd0168,0x00000000}},	//   caci_, _živí_, _gham,
  { {0x4e1a0076,0x3ae8007e,0xb05b0137,0x00000000}},	// [e00] _июня_, ابری_, släc,
  { {0xda790086,0xef1f00ea,0x67220078,0x00000000}},	//   ляє_, zzük_, vuoj,
  { {0x26de0bec,0xfe370047,0x2bb80053,0x00000000}},	//   _rito_, _דריי_, _आडवा,
  { {0x26de02f6,0x31360047,0x09c60053,0x00000000}},	//   _sito_, ינעם_, _वरीय,
  { {0x6497000c,0x87030bed,0x3eb80250,0x00000000}},	//   rţil, ояще, oort_,
  { {0x200b02f4,0x75230009,0x67220006,0x00000000}},	//   zaci_, funz, ruoj,
  { {0x32180045,0x629a0bee,0x67220341,0x00000000}},	//   órym_, vito, suoj,
  { {0x660a0146,0x3eb80bef,0x67220078,0x00000000}},	//   safk, hort_, puoj,
  { {0x200b0bf0,0x69e3003b,0x764301a8,0x00000000}},	//   vaci_, şteş, beny,
  { {0xab5b000f,0x44ea008b,0x629a017d,0x00000000}},	//   _szük, _tù_, uito,
  { {0x32070034,0x60cd00ac,0xa446042c,0x00000000}},	//   _deny_, _pham, _внед,
  { {0x6d41005b,0x757b0047,0x859b0063,0x00000000}},	//   çlam, _שטאפ, _בשבו,
  { {0x6f1d0717,0x629a0bf1,0x200b0bf2,0x00000000}},	//   ursc, pito, raci_,
  { {0x6f1d0199,0x660800a8,0x32070bf3,0x00000000}},	//   rrsc, _jedk, _geny_,
  { {0x6d47006f,0x200b0bf4,0xbc070bf5,0x00000000}},	//   uwja, paci_, ичай,
  { {0x60cd0035,0x320c0bf6,0x7d1a0014,0x00000000}},	//   _uham, lady_, átsa,
  { {0x6a150121,0x3eb80bf7,0x929d0022,0x00000000}},	// [e10] ймау, bort_, asłu,
  { {0x78a9017f,0x929d0051,0x660805a5,0x00000000}},	//   _sjev, bsłu, _nedk,
  { {0x78a9017f,0x7ed40021,0x29670001,0x00000000}},	//   _pjev, _بزيا, шњав,
  { {0x76430009,0x254700ea,0x320c004a,0x00000000}},	//   weny, _ről_, hady_,
  { {0xa01b00bd,0x98480062,0x629800ca,0x00000000}},	//   rhöh, ряха_, _omvo,
  { {0x75230035,0x7bda0063,0xa01b004d,0x00000000}},	//   tunz, _תקשו, shöh,
  { {0xbe3c0063,0x660800a8,0x24860bf8,0x00000000}},	//   דעות, _dedk, _blom_,
  { {0x76430bf9,0x63a40078,0x320c00e5,0x00000000}},	//   seny, _žina, eady_,
  { {0x75230290,0x76430bfa,0x43750299,0x00000000}},	//   sunz, peny, суйт,
  { {0x254700ea,0xf6740021,0x16380021,0x00000000}},	//   _től_, _والخ, _نسمة_,
  { {0x3eb80026,0x248604aa,0x7c36002b,0x00000000}},	//   vort_, _flom_, yfyr,
  { {0xb7bd0529,0x3eb800bd,0x200900dd,0x00000000}},	//   _acţi, wort_, _ceai_,
  { {0xd12e006a,0x42d50086,0x998c0022,0x00000000}},	//   ومی_, _ліку, _łoże_,
  { {0x201e0bfb,0xddde00dd,0x63a40046,0x00000000}},	//   şti_, _copş, _þina,
  { {0x3eb80bfc,0x70f50021,0x62810bfd,0x00000000}},	//   rort_, _استئ, mklo,
  { {0x6f040034,0x27e0082a,0xb05b03be,0x00000000}},	//   _twic, žini_, llän,
  { {0x7c360bfe,0x3eb80bff,0xcb670074,0x00000000}},	// [e20] rfyr, port_, бате_,
  { {0xb05b0832,0xa96a05bd,0x62810c00,0x00000000}},	//   nlän, лиза_, nklo,
  { {0x660800c3,0x628100c2,0xb05b092e,0x00000000}},	//   _redk, iklo, ilän,
  { {0x510a0047,0xb05b0244,0x80ce0082,0x00000000}},	//   רהײַ, hlän, _धीमे,
  { {0x68fb02f7,0x4cbb0063,0x62810c01,0x00000000}},	//   _čude, _תזכו, kklo,
  { {0xfd65001b,0x2486007d,0x07070044,0x00000000}},	//   _nguồ, _slom_, حيوي_,
  { {0x99860032,0x5d7a00b5,0x27e9027c,0x00000000}},	//   _الأو, טאַק, žana_,
  { {0x320c0c02,0xb05b0244,0xa2f40c03,0x00000000}},	//   wady_, elän, опич,
  { {0x77860001,0xc445007e,0xf3ef0021,0x00000000}},	//   _улаз, زیون_, رأي_,
  { {0x2732000c,0xb1140002,0x9f52006d,0x00000000}},	//   mân_, омош, _leyó_,
  { {0x3abb00b5,0xd257000d,0xaabb0047,0x00000000}},	//   רמינ, сцы_, רזיכ,
  { {0x629d0003,0x320c0c04,0x62810c05,0x00000000}},	//   ésor, sady_, aklo,
  { {0xff040062,0xdb0f00be,0x7d1a0014,0x00000000}},	//   зясн, _excê, átsn,
  { {0xacf90541,0xa2d30044,0x62810c06,0x00000000}},	//   ингу_, _فينت, cklo,
  { {0x40350c07,0x27320c08,0xf5180063,0x00000000}},	//   _дейс, hân_, יֵּל,
  { {0xa0a40c09,0xa01b00c7,0xce33007e,0x00000000}},	//   _најд, ehöv, _کودک,
  { {0xf09f00cd,0xba750121,0x3a7508a8,0x00000000}},	// [e30] mià_, огащ, олар,
  { {0xf09f0268,0x9e0705f1,0x51f8009a,0x00000000}},	//   lià_, _учил, שִּׂ,
  { {0x28150c0a,0xe291009d,0x00000000,0x00000000}},	//   قواس, וְא_,   ,
  { {0xf09f00cd,0x17fb0021,0x62810384,0x00000000}},	//   nià_, ارضة_, zklo,
  { {0xf1050161,0x2732008b,0xd5e50c0b,0x00000000}},	//   _शब्द_, gân_, ожли,
  { {0x45190432,0xb05b0137,0x2ca900a5,0x00000000}},	//   ация_, xlän, lnad_,
  { {0x2ca90c0c,0x22450023,0x1a68005d,0x00000000}},	//   onad_, velk_, _دیلی_,
  { {0x2ca90004,0x8339000a,0xf1c30080,0x00000000}},	//   nnad_, ачот_, _liší_,
  { {0xf09f00cd,0x6497000c,0xb05b01bb,0x00000000}},	//   dià_, nţii, tlän,
  { {0xe2990001,0x2ca9001f,0x92e80044,0x00000000}},	//   рао_, hnad_, حريق_,
  { {0xc6680079,0x63a40ac6,0x13f50088,0x00000000}},	//   _уште_, _þinn, _дзея,
  { {0x61fc005b,0xb05b089f,0x62810c0d,0x00000000}},	//   ırla, slän, sklo,
  { {0x249f0c0e,0xb05b092e,0x2ca90c0f,0x00000000}},	//   mium_, plän, dnad_,
  { {0x3f8c0051,0x248d0c10,0xb7da0063,0x00000000}},	//   ądu_, lhem_, יקרי,
  { {0x3f840024,0x1d0a01ef,0x6e210014,0x00000000}},	//   šmu_, реби_, ólba,
  { {0xf09f0268,0x90c30c07,0x2ca900c7,0x00000000}},	//   cià_, _обще, gnad_,
  { {0xdca30699,0x2002004b,0x2d910c11,0x00000000}},	// [e40] фати, mbki_, azze_,
  { {0x4a430002,0x768f00d1,0xa01b004d,0x00000000}},	//   мнув, _høyf, nkön,
  { {0xdb060137,0x6497003b,0x02b60047,0x00000000}},	//   _nykö, aţii, קלעך_,
  { {0xd7f00021,0xa01b01e9,0xaf35005d,0x00000000}},	//   ركت_, shöv, _بویژ,
  { {0x6497000c,0x2732008b,0xa01b0072,0x00000000}},	//   cţii, uân_, kkön,
  { {0x63a400eb,0x6d5e01f0,0x0576013a,0x00000000}},	//   _žino, _krpa, قاعد,
  { {0x442f0c12,0x2907003b,0x98a700dd,0x00000000}},	//   _bcg_, ânat_, înă_,
  { {0x69ce05c9,0x248d0c13,0x7d7b069a,0x00000000}},	//   _izbe, ghem_, ינצו,
  { {0x68430088,0xd7ef0021,0xf09f00cd,0x00000000}},	//   _інфа, _شكل_, vià_,
  { {0xa5f70001,0xc2170086,0x68fe0829,0x00000000}},	//   _међу_, оєю_, oppd,
  { {0xf09f00cd,0xdb0f00f4,0xe3af007e,0x00000000}},	//   tià_, _excè, فری_,
  { {0x6e3e00e3,0x249f0c14,0x27e00c15,0x00000000}},	//   _abpb, cium_, žinu_,
  { {0xf09f0268,0x98b3017f,0x5f94005a,0x00000000}},	//   rià_, žeća_, дият,
  { {0xf09f00cd,0x6722008f,0xc6940041,0x00000000}},	//   sià_, iroj, לאָ_,
  { {0x66cd0024,0xb05b0c16,0x2ca90137,0x00000000}},	//   núka, lläm, tnad_,
  { {0xbca50032,0x67220c17,0x9f61003b,0x00000000}},	//   أمري, kroj, ăpân_,
  { {0xcb34005a,0x2ca90c18,0x2d850c19,0x00000000}},	// [e50] метъ, rnad_, šle_,
  { {0x249f0c1a,0x6497003b,0x67220c1b,0x00000000}},	//   zium_, rţii, droj,
  { {0x2ca90137,0xb05b0072,0xdcef008f,0x00000000}},	//   pnad_, yläl, ēdēt,
  { {0x63ad0026,0x6497003b,0x20d2013d,0x00000000}},	//   _þang, pţii, ráig_,
  { {0xae1f0053,0x17980121,0x27e908ed,0x00000000}},	//   _बयान_, овцы_, žano_,
  { {0x7bda0063,0x5b7a0063,0x442f0c1c,0x00000000}},	//   _לקרו, _הרשא, _scg_,
  { {0x20020051,0xe9180054,0x67220072,0x00000000}},	//   ybki_, _морі_, aroj,
  { {0xddc70024,0x7c2d0c1d,0x628a04cf,0x00000000}},	//   rejň, ngar, _alfo,
  { {0xec79008b,0xe5e5005d,0x7c2d0c1e,0x00000000}},	//   _độc_, _فزای, igar,
  { {0x7c2d001f,0xc879005b,0x249f0c1f,0x00000000}},	//   hgar, _hoş_, sium_,
  { {0xb05b0072,0x6b890022,0xa01b00a6,0x00000000}},	//   lmäy, _żegl, rkön,
  { {0x628a000f,0xdb0f0c20,0x44f10013,0x00000000}},	//   _elfo, _excé, _iá_,
  { {0x44f10c21,0xb4b7016a,0x26c70c22,0x00000000}},	//   _há_, चकी_, olno_,
  { {0x442d0c23,0x7c2d0c24,0x12fa0063,0x00000000}},	//   lge_, egar, _ההסב,
  { {0x44f10c25,0x442d0c26,0x7c2d0c27,0x00000000}},	//   _já_, oge_, fgar,
  { {0x768f0031,0x7c2d0c28,0x64490c29,0x00000000}},	//   _høyd, ggar, neei,
  { {0x20d20025,0x44f10c2a,0x442d0c2b,0x00000000}},	// [e60] ráid_, _lá_, ige_,
  { {0x20d20025,0x78ab0078,0x7c2d0c2c,0x00000000}},	//   sáid_, engv, agar,
  { {0xc879005b,0x44f10c2d,0xc4cb0053,0x00000000}},	//   _boş_, _ná_, ाताओ,
  { {0xc879000c,0x9f59006d,0xa01b01bb,0x00000000}},	//   _coş_, casó_, lhör,
  { {0x6d5c00e8,0x27e0024a,0x442d0c2e,0x00000000}},	//   lvra, äin_, dge_,
  { {0x67220c2f,0x442d0c30,0xa96a0794,0x00000000}},	//   rroj, ege_, _лига_,
  { {0x6d5c0179,0x44f10c31,0x9c8300b2,0x00000000}},	//   nvra, _cá_, ščev,
  { {0x442d0c32,0x26c702e2,0x44f10c33,0x00000000}},	//   gge_, alno_, _dá_,
  { {0x78a20c34,0x684302fa,0x00000000,0x00000000}},	//   miov, _янта,   ,
  { {0x44f10c35,0x442d0c36,0xb05b0137,0x00000000}},	//   _fá_, age_, rläm,
  { {0x44f10027,0x7c2d0c37,0x6449004d,0x00000000}},	//   _gá_, ygar, beei,
  { {0x66cd0024,0xa01b0c38,0x78a20445,0x00000000}},	//   núkn, ehör, niov,
  { {0x4abe0161,0xaabe0053,0x768f00d1,0x00000000}},	//   ्ताव, ्ताक, _føyd,
  { {0x2ee500bd,0x68fc0c39,0x64b300dd,0x00000000}},	//   ölf_, _otrd, răie,
  { {0xdb1d0080,0x44f1008b,0x6497003b,0x00000000}},	//   _vysí, _xá_, aţiu,
  { {0x5d54000d,0x7c2d0c3a,0xd1380c3b,0x00000000}},	//   экст, ugar, mtą_,
  { {0x768f0031,0x6497000c,0x6d5c0c3c,0x00000000}},	// [e70] _høye, cţiu, avra,
  { {0x6ce70086,0xd1380078,0x7bc60078,0x00000000}},	//   _німе, otą_, _dyku,
  { {0xd13800eb,0x7bc60026,0x442d0c3d,0x00000000}},	//   ntą_, _eyku, yge_,
  { {0xd13800eb,0x6497003b,0xc864005e,0x00000000}},	//   itą_, nţit, етљи,
  { {0x2d8300eb,0xb8f40053,0x44f10c3e,0x00000000}},	//   lyje_, _सी_, _sá_,
  { {0xd1380006,0xb05b0072,0xf62b0054,0x00000000}},	//   ktą_, rmäy, сіди_,
  { {0x442d0c3f,0x2d830006,0xb05b0072,0x00000000}},	//   tge_, nyje_, smäy,
  { {0x44f10c40,0x78a20240,0x442d0c41,0x00000000}},	//   _vá_, ciov, uge_,
  { {0xafdb0093,0x644900e5,0x26c70061,0x00000000}},	//   nfød, reei, plno_,
  { {0x44f1018d,0x6d450c42,0x768f00d1,0x00000000}},	//   _tá_, _opha, _bøye,
  { {0x442d00c7,0x672b0026,0xd1380078,0x00000000}},	//   pge_, lugj, gtą_,
  { {0xa06a0001,0x7afd0019,0x2d830078,0x00000000}},	//   цама_, _otst, dyje_,
  { {0xd1380c3b,0x66cd017c,0x6d450c43,0x00000000}},	//   atą_, núko, _apha,
  { {0xafdb000e,0x6497003b,0xdd92007e,0x00000000}},	//   dfød, rţiu, پور_,
  { {0x6d4e0122,0x32050c44,0x929200d7,0x00000000}},	//   uwba, mbly_, _јајц,
  { {0x6d5c00c7,0x69da0016,0x6497000c,0x00000000}},	//   rvra, _útei, pţiu,
  { {0xa01b00c7,0x7ae7006f,0x6d5c0983,0x00000000}},	// [e80] phör, _bijt, svra,
  { {0xdddc00c2,0x6d5c0104,0xed630066,0x00000000}},	//   akrš, pvra, ôžé_,
  { {0xceb300b5,0x7bc60022,0x6abe004d,0x00000000}},	//   _ביז_, _wyku, ropf,
  { {0x6abe004d,0x5ca60505,0xcb6a0a29,0x00000000}},	//   sopf, _цимб, _даме_,
  { {0x9b030062,0x7bc60058,0x98a3005e,0x00000000}},	//   _изяд, _uyku, њиче,
  { {0xd138091b,0xa9260141,0x3e740066,0x00000000}},	//   ytą_, _одгл, _päty_,
  { {0x68fc00c2,0x764a002b,0x98a60c45,0x00000000}},	//   _utrd, refy, _живе,
  { {0x764a001f,0x7ae700ca,0xb05b00a5,0x00000000}},	//   sefy, _zijt, rläk,
  { {0xb05b0137,0xa226007e,0xed590023,0x00000000}},	//   släk, ورده, āži_,
  { {0x60c40006,0xa01b004d,0x325401dd,0x00000000}},	//   _akim, rköm, хвор,
  { {0x60f8013c,0xd1380078,0x40350c46,0x00000000}},	//   яння_, utą_, ненс,
  { {0xd1380c47,0x60d6001f,0x2d830006,0x00000000}},	//   rtą_, _chym, vyje_,
  { {0xd1380c48,0x6497003b,0x6d450c49,0x00000000}},	//   stą_, rţit, _spha,
  { {0x2d830006,0x6d4500d1,0xd1380078,0x00000000}},	//   tyje_, _ppha, ptą_,
  { {0x7ae7006f,0x7afd0850,0x6497003b,0x00000000}},	//   _rijt, _stst, mţir,
  { {0x2d830006,0xbf350086,0x6497003b,0x00000000}},	//   ryje_, _знищ, lţir,
  { {0x3ea3006f,0x9f630137,0xa01b0072,0x00000000}},	// [e90] pijt_, åväl_, hkök,
  { {0x2d8300eb,0x6497003b,0x0ab8005d,0x00000000}},	//   pyje_, nţir, وطلب_,
  { {0xb05b0072,0xf7700043,0x00000000,0x00000000}},	//   eläi, یاه_,   ,
  { {0x386902dd,0xc87901f7,0x3cfe00ea,0x00000000}},	//   ñar_, _kişi_, ítve_,
  { {0xfc3f000f,0x7afd0c4a,0x69c70051,0x00000000}},	//   _amíg_, _utst, _wyje,
  { {0xaa4500fe,0x6288006f,0x7ae7006f,0x00000000}},	//   ävää_, jkdo, _uijt,
  { {0xafdb00d1,0xaabe0082,0x00000000,0x00000000}},	//   rdøy, ्तरक,   ,
  { {0x6288006f,0x6aa50150,0x7d1a0014,0x00000000}},	//   ekdo, lihf, átsi,
  { {0x27ed0c4b,0x60d60c4c,0xa2e50c4d,0x00000000}},	//   _igen_, _rhym, ноид,
  { {0xe3b6000d,0x69c301a8,0x60c40c4e,0x00000000}},	//   эбы_, ünew, _skim,
  { {0x68e90045,0x32050c4f,0x60d6002b,0x00000000}},	//   _kied, rbly_, _phym,
  { {0x037b007e,0x62880c50,0x4395014b,0x00000000}},	//   _وحشت_, akdo, _паес,
  { {0x68e90c51,0x6497003b,0xb3870021,0x00000000}},	//   _mied, bţir, _تجاه,
  { {0x523900b5,0x64590a9f,0x645b0c52,0x00000000}},	//   _זײַנ, _hawi, ldui,
  { {0x27ed0122,0x7bcb00bd,0x64590c53,0x00000000}},	//   _ogen_, ügun, _kawi,
  { {0x63a40006,0x68e90c54,0x60c40035,0x00000000}},	//   _žini, _nied, _ukim,
  { {0x6d4101f7,0x64590c55,0x443f05b3,0x00000000}},	// [ea0] çlar, _mawi, ifu_,
  { {0x27ed0c56,0x6b960022,0x64590c57,0x00000000}},	//   _agen_, rzyg, _lawi,
  { {0x68e90c58,0x9c83085a,0x6da60c59,0x00000000}},	//   _bied, ščav, _чина,
  { {0x64590045,0x7e7e0c5a,0x645b08ad,0x00000000}},	//   _nawi, _hopp, jdui,
  { {0x17540076,0x7e7e0c5b,0x68e90c5c,0x00000000}},	//   твля, _kopp, _died,
  { {0x27ed06a3,0x645b0c5d,0xcfb70041,0x00000000}},	//   _egen_, edui, עלסי_,
  { {0x443f001f,0x64590c5e,0x7e7e0c5f,0x00000000}},	//   ffu_, _bawi, _mopp,
  { {0x7e7e024a,0xd4970076,0x645b0104,0x00000000}},	//   _lopp, ерь_, gdui,
  { {0x68e30173,0x82a6026c,0x7e7e0072,0x00000000}},	//   ïnde, ешне, _oopp,
  { {0xdbc70019,0x68e9001c,0x87170063,0x00000000}},	//   _tööi, _zied, _נקבע_,
  { {0x6497003b,0xc5690021,0x61ee0078,0x00000000}},	//   rţir, _يحمل_, žblo,
  { {0x645900bb,0xa98b009a,0x00000000,0x00000000}},	//   _gawi, לָכִ,   ,
  { {0xdfd80062,0x768f04aa,0x6d58007d,0x00000000}},	//   еър_, _høya, _švap,
  { {0xa6e700aa,0x64590045,0x7e7e055b,0x00000000}},	//   _nhữ, _zawi, _copp,
  { {0x765a00eb,0x20d20025,0xa01b00fe,0x00000000}},	//   _maty, máin_, hköi,
  { {0x765a0c60,0x6ca4026c,0x27e90c61,0x00000000}},	//   _laty, груж, žani_,
  { {0x5a3505fb,0x68e90c62,0x6a35005e,0x00000000}},	// [eb0] кнат, _ried, кнађ,
  { {0x20d20025,0x645b000c,0x765a0051,0x00000000}},	//   náin_, zdui, _naty,
  { {0x768f0031,0x3947090d,0x48150ac5,0x00000000}},	//   _nøya, ïns_, вмес,
  { {0x20d20027,0x7e7e01f4,0x26c50195,0x00000000}},	//   háin_, _zopp, _sklo_,
  { {0x20d90025,0xed59001c,0x64590c63,0x00000000}},	//   méid_, āžu_, _rawi,
  { {0x64590c64,0x68e90c65,0x945d0045,0x00000000}},	//   _sawi, _wied, końc,
  { {0x68e909ff,0x64590c5e,0xe1f1007e,0x00000000}},	//   _tied, _pawi, یسد_,
  { {0x27ed00b9,0x929d0051,0x20d20139,0x00000000}},	//   _ugen_, dpła, eáin_,
  { {0x645b0c66,0x660c00ea,0xb05b004d,0x00000000}},	//   rdui, élkü, nläu,
  { {0x387f0592,0x23620026,0x20d90025,0x00000000}},	//   _hour_, ækja_, héid_,
  { {0x645900a4,0xb05b004d,0x273b002b,0x00000000}},	//   _tawi, hläu, lên_,
  { {0x387f03b2,0x7e7e0c67,0x7e0a0042,0x00000000}},	//   _jour_, _sopp, वर्ग_,
  { {0xa4d4019d,0x386d000e,0x08760047,0x00000000}},	//   _соці, _mner_, דערט_,
  { {0x9f9e0016,0x273b001b,0xe0df0290,0x00000000}},	//   _ação_, iên_, amò_,
  { {0x71640021,0x2d8c0066,0xdca60092,0x00000000}},	//   _مايك, áde_, вави,
  { {0xeaed0053,0xed570002,0xa0c6009b,0x00000000}},	//   जदूत_, њот_, _جيبو,
  { {0xf41200b5,0x7e7e0c68,0x69d501f4,0x00000000}},	// [ec0] יפן_, _topp, _azze,
  { {0x7e7e00d1,0x64950139,0xdee6049f,0x00000000}},	//   _uopp, _fáig, _шопи,
  { {0xceb9004c,0x765a0022,0x649501c8,0x00000000}},	//   éře_, _raty, _káid,
  { {0x387f0164,0x20d90139,0xb05b004d,0x00000000}},	//   _cour_, céid_, bläu,
  { {0x69d5000f,0x765a0006,0x929d0051,0x00000000}},	//   _ezze, _paty, zpła,
  { {0x64950025,0x6f02005b,0xa6340086,0x00000000}},	//   _láid, _çocu, ункі,
  { {0x387f0034,0x64b3000c,0x69c300ea,0x00000000}},	//   _four_, răin, ünet,
  { {0xa01b013d,0xc7b9013d,0x765a0022,0x00000000}},	//   lköv, _időn_, _waty,
  { {0x20d20025,0xd2500021,0x6ac70014,0x00000000}},	//   táin_, منة_, _örfá,
  { {0xa01b00c7,0xe3af0021,0x7c29008f,0x00000000}},	//   nköv, ترى_, _ķerm,
  { {0x387f0c69,0x63ad0026,0xb05b0137,0x00000000}},	//   _your_, _þann, klät,
  { {0x63a400eb,0x20d20027,0x443200d1,0x00000000}},	//   _žinu, sáin_, _øy_,
  { {0xe0df0290,0x20d20c6a,0xa0a4000d,0x00000000}},	//   rmò_, máil_, раўд,
  { {0x6fe9001c,0x661800c2,0x2fcd0051,0x00000000}},	//   _rīcī, navk, żego_,
  { {0xfcc7005e,0x9c830124,0x929d0022,0x00000000}},	//   вљам, áčov, jsły,
  { {0x273b00aa,0x7059000a,0x3cfe00ea,0x00000000}},	//   yên_, _чаир_, ítva_,
  { {0x20190c6b,0x44f80c6c,0x66180c6d,0x00000000}},	// [ed0] masi_, _lé_, kavk,
  { {0x20d20027,0x7e55019d,0xb05b00bd,0x00000000}},	//   háil_, _своє, rläu,
  { {0x387f0c6e,0x20d90027,0x69c802ab,0x00000000}},	//   _pour_, péid_, _ødel,
  { {0xdb1d00fe,0x5c040062,0x20190c6f,0x00000000}},	//   _pysä, _вяра, nasi_,
  { {0x20d20025,0xb05b00fe,0xfeb8007e,0x00000000}},	//   dáil_, lläs, _سایت_,
  { {0x2ca90c70,0x44f80c71,0x273b001b,0x00000000}},	//   liad_, _bé_, rên_,
  { {0x44f80027,0x20190801,0x8883007e,0x00000000}},	//   _cé_, kasi_, _پیشن,
  { {0x23660117,0x2ca90185,0x20d20027,0x00000000}},	//   _broj_, niad_, gáil_,
  { {0x20190551,0x69da0c72,0xb05b004d,0x00000000}},	//   dasi_, _úter, hläs,
  { {0x2ca9001f,0x44f80c73,0x6f1d0c74,0x00000000}},	//   hiad_, _fé_, dssc,
  { {0x20190c75,0xb05b0072,0xe4d6005d,0x00000000}},	//   fasi_, ylät, ضویت_,
  { {0x20d20027,0x20190c76,0x6f1d004d,0x00000000}},	//   cáil_, gasi_, fssc,
  { {0x2ca90185,0x3245032d,0x44f80c77,0x00000000}},	//   diad_, _белг, _zé_,
  { {0xed5a0138,0x248d0080,0xf2070071,0x00000000}},	//   ног_, lkem_, _рядо,
  { {0x2ca90185,0x64950025,0x44f80013,0x00000000}},	//   fiad_, _táid, _xé_,
  { {0x2ca90c78,0x6abe0053,0x1bea0ab1,0x00000000}},	//   giad_, ्त्र, едби_,
  { {0xb05b0137,0xb2f60047,0x7c2b0c79,0x00000000}},	// [ee0] rlät, ָצעס_, ógra,
  { {0x248d0004,0xb05b0354,0xdde400ea,0x00000000}},	//   hkem_, slät, űrűs,
  { {0x2ca9001f,0xb05b00e0,0x60c60c7a,0x00000000}},	//   biad_, plät, ookm,
  { {0x7643001f,0x98c5000d,0x2ca9001f,0x00000000}},	//   efny, асіл, ciad_,
  { {0x44f80c7b,0x248d0080,0x66180c7c,0x00000000}},	//   _sé_, dkem_, tavk,
  { {0xbb430001,0x44f80c7d,0x39580078,0x00000000}},	//   _ћерк, _pé_, _tsrs_,
  { {0x20d20027,0x2019005b,0x66180c7e,0x00000000}},	//   táil_, yasi_, ravk,
  { {0x66180c7f,0x2b400af9,0x44f80c80,0x00000000}},	//   savk, otic_, _vé_,
  { {0xb05b0199,0x20d20025,0x20190c6f,0x00000000}},	//   klär, ráil_, vasi_,
  { {0x44f80c81,0x20d20025,0x68e2060b,0x00000000}},	//   _té_, sáil_, lmod,
  { {0x3263000d,0x68e20c82,0x201907fa,0x00000000}},	//   стыв, omod, tasi_,
  { {0x68e20c83,0x6f1d0c84,0x201901f4,0x00000000}},	//   nmod, tssc, uasi_,
  { {0x20190c85,0x6f1d00bd,0x03a30a91,0x00000000}},	//   rasi_, ussc, _лицо,
  { {0x20190c86,0x256301f7,0x3eaa00bd,0x00000000}},	//   sasi_, _yıl_, gibt_,
  { {0x2ca90185,0x69ce0c87,0x6f040c88,0x00000000}},	//   tiad_, _nybe, _etic,
  { {0xb05b00bd,0xd1380051,0xa01b013d,0x00000000}},	//   rläs, rząd_, gköt,
  { {0x2ca90185,0xda15005e,0x768f00d1,0x00000000}},	// [ef0] riad_, идањ, _bøyl,
  { {0x69ce0c89,0x2ca9001f,0x8f9c0047,0x00000000}},	//   _bybe, siad_, _ריזי,
  { {0xb9b50021,0x2d8a0c8a,0x2b400c8b,0x00000000}},	//   جماع, cybe_, atic_,
  { {0x69ce000e,0x5d7a0041,0x76480022,0x00000000}},	//   _dybe, _סארק, _abdy,
  { {0xdc3600b5,0x65680035,0x248d004c,0x00000000}},	//   _דארט_, _ardh, vkem_,
  { {0x83fd00ea,0x68e2040d,0xab66001c,0x00000000}},	//   zdőd, amod, _daļē,
  { {0x291c0080,0x248d0c8c,0xd61800f2,0x00000000}},	//   ávat_, tkem_, اتها_,
  { {0x03250c8d,0x06b1004c,0x443900ca,0x00000000}},	//   адин, _řídí_, üs_,
  { {0x67d40086,0xd2990054,0x6568004d,0x00000000}},	//   _готу, втні_, _erdh,
  { {0x78ab0c8e,0x6f040c8f,0x248d0c90,0x00000000}},	//   ligv, _rtic, skem_,
  { {0xe0da0c91,0x39410034,0x26c70c92,0x00000000}},	//   кво_, nths_, mono_,
  { {0x78ab006f,0x6f04074f,0x2d8a0078,0x00000000}},	//   nigv, _ptic, vybe_,
  { {0x7d050025,0xa8560063,0x60c60066,0x00000000}},	//   _aths, בירה_, rokm,
  { {0x539a0165,0x68e20c93,0x1167005d,0x00000000}},	//   _בינו, zmod, _ملتی_,
  { {0x26c70290,0x62830c94,0x68e2002b,0x00000000}},	//   iono_, _iono, ymod,
  { {0x768f00d1,0x62830c95,0x26c7002b,0x00000000}},	//   _søyl, _hono, hono_,
  { {0x6f04017f,0x26c70035,0x62830c96,0x00000000}},	// [f00] _utic, kono_, _kono,
  { {0xb05b00fe,0x26c70c97,0x62830c98,0x00000000}},	//   lläp, jono_, _jono,
  { {0x26c70c99,0x20d90016,0x2b400c9a,0x00000000}},	//   dono_, léia_, stic_,
  { {0x69ce0512,0x2a610025,0x2b400c9b,0x00000000}},	//   _vybe, adhb_, ptic_,
  { {0x47330086,0xe737019c,0x20d900be,0x00000000}},	//   жніс, иец_, néia_,
  { {0x628302f6,0x26c70c9c,0xafdb06a5,0x00000000}},	//   _nono, gono_, dføl,
  { {0xa01b01bb,0x997c0023,0xdaa70896,0x00000000}},	//   ljöe, lāža_, _тврд_,
  { {0xd70603d6,0xd5b1008b,0x69d8008f,0x00000000}},	//   _взаи, _séc_, ļved,
  { {0xa2c20161,0xf749006a,0x62830c9d,0x00000000}},	//   रकल्, _مجله_, _bono,
  { {0x62830c9e,0x26c70c9f,0x20d9017d,0x00000000}},	//   _cono, cono_, déia_,
  { {0x09f7014e,0xd1380051,0x99f70063,0x00000000}},	//   ימים_, dząc_, יזיה_,
  { {0x75d3006a,0xdcee0006,0xdb1d0066,0x00000000}},	//   _بيما, mybė, _vysú,
  { {0x44260ca0,0xdcee0078,0xbfa80a71,0x00000000}},	//   _ido_, lybė, атре_,
  { {0x7dc70021,0x62830ca1,0x8027005d,0x00000000}},	//   لتأك, _gono, درگم,
  { {0x442608c4,0xdcee0078,0x6ca70603,0x00000000}},	//   _kdo_, nybė, араж,
  { {0x1bf5000d,0x30150002,0x26c70ca2,0x00000000}},	//   спаў, _удир, zono_,
  { {0x26c700f3,0x7de000ea,0x60cd0058,0x00000000}},	// [f10] yono_, tásé, _ikam,
  { {0xdcee0006,0x996707ac,0xd4910013,0x00000000}},	//   kybė, ител, _mùa_,
  { {0xd36604de,0x26c7051e,0x161a0053,0x00000000}},	//   _که_, vono_, _नज़र_,
  { {0x26c70150,0x39410ca3,0x83fd013d,0x00000000}},	//   wono_, rths_, zdőb,
  { {0xcc760063,0x39a70066,0x7c48013d,0x00000000}},	//   _הערה_, dísť_, éprő,
  { {0x26c707a0,0x1af60ca4,0x394100e5,0x00000000}},	//   uono_, _למשל_, pths_,
  { {0x45180088,0x26c702f6,0xb9950021,0x00000000}},	//   ацыя_, rono_, _الأب,
  { {0x629a024a,0xe570007e,0xa8a40726,0x00000000}},	//   ehto, بطه_, _друк,
  { {0x26c70ca5,0x13060121,0x6b8d0ca6,0x00000000}},	//   pono_, бный_, nyag,
  { {0xafdb0205,0x60cd0ca7,0x44260ca8,0x00000000}},	//   rføl, _akam, _edo_,
  { {0xb5a70878,0x60ea0074,0x1c170042,0x00000000}},	//   _трай, лмом_, तराल_,
  { {0x656e0027,0x628300f3,0xafdb0ca9,0x00000000}},	//   _ábha, _wono, pføl,
  { {0xafdb010a,0xdee60086,0x443d0150,0x00000000}},	//   lføj, йоми, _icw_,
  { {0x20d90016,0xde0307da,0x78bb0415,0x00000000}},	//   réia_, зпри, _ljuv,
  { {0x753c00bd,0x69a70053,0xd1380051,0x00000000}},	//   _ärzt, _टेली, rząc_,
  { {0x20d90016,0xa9240066,0xd1380051,0x00000000}},	//   péia_, _úžit, sząc_,
  { {0xc9f60032,0xa01b013d,0x60970043,0x00000000}},	// [f20] مساع, pkör, _دنيس_,
  { {0x78100053,0xe8100053,0x4b230054,0x00000000}},	//   ार्क_, ार्थ_, ямув,
  { {0x6b8d00a4,0xe9da005e,0x186a0caa,0x00000000}},	//   ayag, ћке_, лажи_,
  { {0xdcee0006,0xa01b0cab,0x38cb007e,0x00000000}},	//   vybė, nköp, هانی_,
  { {0xb8650cac,0x07ba00de,0x00000000,0x00000000}},	//   تالو, دهشة_,   ,
  { {0xa01b024a,0xdcee0006,0xd627005e,0x00000000}},	//   hköp, tybė, боље_,
  { {0xd6390054,0xa01b00a5,0xdcfc005f,0x00000000}},	//   рячі_, kköp, tyrę,
  { {0xa4d80002,0x69dc0cad,0xdcee0078,0x00000000}},	//   јдиу_, _izre, rybė,
  { {0x649c0025,0xc3270021,0xb8de0053,0x00000000}},	//   _léig, مكين_, ीक_,
  { {0x32180024,0xddc50024,0x20d90139,0x00000000}},	//   úry_, _zahŕ, géin_,
  { {0xa0550086,0x6722008f,0x64a60141,0x00000000}},	//   овні, lsoj, _лажа,
  { {0x557700b5,0x661a037e,0x672200c2,0x00000000}},	//   _לעבן_, _hetk, osoj,
  { {0x7e2b000d,0xbf9b00ac,0xbfab019b,0x00000000}},	//   ліва_, ebêr, утне_,
  { {0x768f00d1,0xd3570063,0x0dcb0ab1,0x00000000}},	//   _røyk, _לידי_, губи_,
  { {0x629801f4,0xc2ed004c,0x321e0cae,0x00000000}},	//   _ilvo, řící, maty_,
  { {0x7b150062,0x6b8d0caf,0x67220cb0,0x00000000}},	//   ждах, tyag, ksoj,
  { {0x6f16001f,0x6d5e0283,0xd5b10013,0x00000000}},	// [f30] _gwyc, _espa, _nén_,
  { {0x661a0cb1,0x2486016c,0x321e0022,0x00000000}},	//   _netk, _loom_, naty_,
  { {0x6f160051,0x3a840085,0x79590cb2,0x00000000}},	//   _zwyc, чытв, риер_,
  { {0xd7d50001,0xe3c70078,0x2907008f,0x00000000}},	//   ожењ, ūčių_, īna_,
  { {0x69cb00bd,0x69dc00ea,0x321e0022,0x00000000}},	//   ßgeb, _ezre, katy_,
  { {0xda7b000d,0x64950139,0x321e004c,0x00000000}},	//   _сям_, _cáin, jaty_,
  { {0x7d020024,0x20020022,0x78bb00a5,0x00000000}},	//   _čosk, ycki_, _tjuv,
  { {0x62980cb3,0xcd980063,0x6d410058,0x00000000}},	//   _alvo, מדות_, çlay,
  { {0x24860cb4,0xdc8c009a,0x00000000,0x00000000}},	//   _doom_, רְוָ,   ,
  { {0x52a90cb5,0x321e0cb6,0x31250cb7,0x00000000}},	//   рвом_, gaty_, одог,
  { {0x6f160051,0xdb060014,0xd5bb0131,0x00000000}},	//   _swyc, _ómög, _сса_,
  { {0x649c0025,0x493a0149,0x62980cb8,0x00000000}},	//   _réig, סגרו, _elvo,
  { {0x661a01f7,0x644900d1,0xd5b1008b,0x00000000}},	//   _yetk, mfei, _kéo_,
  { {0xfc3f00cd,0xddde003b,0x21690cb9,0x00000000}},	//   _ací_, _nopţ, _вики_,
  { {0x649c018d,0xed5a0cba,0xcc8a0cbb,0x00000000}},	//   _féid, шов_, абве_,
  { {0x1c46000d,0x64490cbc,0x6f160022,0x00000000}},	//   ўнам, nfei, _twyc,
  { {0x6d5e0051,0x8b260121,0xf2000042,0x00000000}},	// [f40] _wspa, юдае, लुक़_,
  { {0x649c0027,0x1ae30cbd,0x00000000,0x00000000}},	//   _téig, доум,   ,
  { {0xa9670062,0x6281003b,0x661a0cbe,0x00000000}},	//   жиха_, ijlo, _retk,
  { {0x50ca0161,0x661a03a4,0x67220072,0x00000000}},	//   रविष, _setk, tsoj,
  { {0x24860034,0x67220006,0xe8e00013,0x00000000}},	//   _room_, usoj, hiệt_,
  { {0x6b8b0cbf,0x9991013d,0x64490cc0,0x00000000}},	//   ägge, _edző_, efei,
  { {0x69dc001c,0x64490cc1,0xa5070002,0x00000000}},	//   _uzre, ffei, оеја_,
  { {0x672d001c,0xe9d70086,0xb198008b,0x00000000}},	//   šaja, _єкт_, _ngưỡ,
  { {0x649c0025,0xc445007e,0x76b20051,0x00000000}},	//   _réid, سیون_, głyc,
  { {0x38660cc2,0x68fc0cc3,0xfbd3009a,0x00000000}},	//   ldor_, _kurd, ותח_,
  { {0xe45a019d,0xdd1c0024,0x321e0471,0x00000000}},	//   _вже_, yšše, raty_,
  { {0x68fc010e,0x765800fe,0x6d5c0cc4,0x00000000}},	//   _murd, levy, dwra,
  { {0x6101003d,0x38660cc5,0xff040062,0x00000000}},	//   _vēla, idor_, дясн,
  { {0x68fc006c,0x62980050,0x6d5c00a3,0x00000000}},	//   _ourd, _ulvo, fwra,
  { {0x68fc0cc6,0xbd680a91,0x6d5c002b,0x00000000}},	//   _nurd, орте_, gwra,
  { {0x90c400e1,0x90e7005d,0xbb4b012c,0x00000000}},	//   _обје, _بستن, иїзд_,
  { {0x1eab0021,0x68fc00d1,0x38660cc7,0x00000000}},	// [f50] _نادي_, _aurd, ddor_,
  { {0x768f00d1,0x68fc0cc8,0xc96b005e,0x00000000}},	//   _høyv, _burd, ијед_,
  { {0xad27006a,0x64490185,0xe9f80086,0x00000000}},	//   _برخو, yfei, інці_,
  { {0x68fc01f7,0xe8f80304,0x64950025,0x00000000}},	//   _durd, ілі_, _cáil,
  { {0xcb44082b,0x64950139,0x2d9100e5,0x00000000}},	//   _охри, _dáil, lyze_,
  { {0x8afa0063,0x386600c5,0x6d47004b,0x00000000}},	//   _להשי, ador_, otja,
  { {0xceb400b5,0x64950025,0x7afd0cc9,0x00000000}},	//   ויס_, _fáil, _hust,
  { {0x6d470268,0x7afd0cca,0xe4c80044,0x00000000}},	//   itja, _kust, يبين_,
  { {0xe3b10032,0x7afd0ccb,0x13060121,0x00000000}},	//   عرب_, _just, пный_,
  { {0xe2990138,0x64490ccc,0x68fc0058,0x00000000}},	//   сао_, sfei, _yurd,
  { {0x76b20051,0xd5b10013,0x20d200ea,0x00000000}},	//   słyc, _kém_, káit_,
  { {0x7afd0ccd,0x7b09017c,0x76b20022,0x00000000}},	//   _oust, _kľud, płyc,
  { {0x7afd00eb,0xbf9b017d,0xb4c90042,0x00000000}},	//   _nust, scên, ोती_,
  { {0x649c0139,0x998c0066,0x6d5c00a3,0x00000000}},	//   _géib, _čože_, twra,
  { {0x7c960304,0x64950025,0xe7eb0053,0x00000000}},	//   прац, _láim, जेता_,
  { {0x249f03d9,0x6d5c002b,0x7af5008f,0x00000000}},	//   nhum_, rwra, _aizt,
  { {0x7af5000f,0x7afd0cce,0x68fc0ccf,0x00000000}},	// [f60] _bizt, _cust, _surd,
  { {0x64950139,0x7afd0cd0,0x68fc0cd1,0x00000000}},	//   _sáil, _dust, _purd,
  { {0xb9060054,0x2bac0042,0x7afd0cd2,0x00000000}},	//   їздк, _घेरा, _eust,
  { {0x68fc02ab,0x7afd0cd3,0xf7460002,0x00000000}},	//   _vurd, _fust, зедо,
  { {0x68fc0cd4,0x7afd0cd5,0x78a300ac,0x00000000}},	//   _wurd, _gust, ënva,
  { {0xba55005a,0x35d40076,0x2d8701a8,0x00000000}},	//   _отсъ, молё, _ànec_,
  { {0x64950025,0x7afd05e4,0xd5b00021,0x00000000}},	//   _táil, _zust, ضفة_,
  { {0x7de7000f,0x957c0051,0x2ca000a4,0x00000000}},	//   lésé, _rząd, nhid_,
  { {0x07a30131,0xa7860044,0xe77a009d,0x00000000}},	//   _затн, _عشرو, _לָ֑ך,
  { {0x7de700ea,0xcb130063,0x6d470014,0x00000000}},	//   nésé, עלת_, ytja,
  { {0xdc3f0066,0x30350121,0x40350cd6,0x00000000}},	//   víľk, менё, менс,
  { {0x7bc3000c,0x64a3000d,0x20d20331,0x00000000}},	//   şnui, _паха, dáis_,
  { {0x68e300f5,0x7ee70062,0x91fc008f,0x00000000}},	//   ïndi, зцве, ldām,
  { {0xc7b900ea,0x6d47087b,0x7afd0cd7,0x00000000}},	//   _időt_, ttja, _rust,
  { {0x20d20cd8,0x7de700ea,0x7afd0cd9,0x00000000}},	//   táit_, désé, _sust,
  { {0x768f00d1,0x6d4700ea,0x113b0063,0x00000000}},	//   _høyt, rtja, _התהל,
  { {0x69d8005b,0x83fd00ea,0x6108004c,0x00000000}},	// [f70] üven, zdőo, _děle,
  { {0x6f0d0cda,0x7de7013d,0x20d200a3,0x00000000}},	//   _itac, gésé, sáit_,
  { {0x7afd0244,0xbbeb005d,0x7af5011b,0x00000000}},	//   _wust, _گردم_, _vizt,
  { {0x69d50024,0xddde017f,0xddc70051,0x00000000}},	//   _vyze, _uopš, zejś,
  { {0x7afd004b,0x69d50022,0xf7450cdb,0x00000000}},	//   _uust, _wyze, фело,
  { {0x768f00d1,0x20d20025,0x672d008f,0x00000000}},	//   _nøyt, náir_, šajo,
  { {0x24e902a1,0x249f0550,0xa5f601ce,0x00000000}},	//   омки_, thum_, мељу_,
  { {0x64950025,0x9f650024,0x200901f4,0x00000000}},	//   _táim, _štýl_, _nfai_,
  { {0x249f0cdc,0x7d1a00ea,0x823504a0,0x00000000}},	//   rhum_, átsz, وردا,
  { {0x628a0cdd,0x20d20014,0xe3b60766,0x00000000}},	//   _cofo, jáir_, ьбы_,
  { {0x6101001c,0x6f0d0cde,0x67290014,0x00000000}},	//   _vēlo, _atac, _hvej,
  { {0x7de7000f,0x64420025,0xf485007e,0x00000000}},	//   zésé, _gcoi, _تائی,
  { {0xe3ae0088,0x10a30cdf,0x628a00be,0x00000000}},	//   _рб_, тиян, _fofo,
  { {0x83fd000f,0x6f0d0025,0x628a002b,0x00000000}},	//   zdől, _dtac, _gofo,
  { {0x768f00d1,0x2ca00139,0x6f0d0331,0x00000000}},	//   _høys, thid_, _etac,
  { {0x6729006d,0x443f0ce0,0x236d0066,0x00000000}},	//   _ovej, ngu_, ovej_,
  { {0x7de7000f,0x9f44024a,0x236d0261,0x00000000}},	// [f80] tésé, ämä_, nvej_,
  { {0x2ca00ce1,0x6b8b0137,0x8d76007e,0x00000000}},	//   shid_, ägga, _قاجا,
  { {0x7de700ea,0x4866005a,0x61080080,0x00000000}},	//   résé, дълб, _těle,
  { {0x7de700ea,0x00000000,0x00000000,0x00000000}},	//   sésé,   ,   ,
  { {0x7c240ce2,0x7de7013d,0xa6ca01ce,0x00000000}},	//   mair, pésé, олда_,
  { {0x9f400122,0x64420025,0x443f0ce3,0x00000000}},	//   _azië_, _scoi, egu_,
  { {0xa01b0026,0xd82600e1,0x645b0ce4,0x00000000}},	//   fjöl, _одви, feui,
  { {0x7c240ce5,0x628a0b92,0xa01b0026,0x00000000}},	//   nair, _sofo, gjöl,
  { {0x68e300dd,0x63ad0ce6,0x00000000,0x00000000}},	//   înde, _žanr,   ,
  { {0x7c240ce7,0x443f0ce8,0x4b7b009a,0x00000000}},	//   hair, agu_, קאיו,
  { {0x3a370a7a,0x60cf003b,0x6f0d0ce9,0x00000000}},	//   ורים_, tocm, _stac,
  { {0x10740086,0x78a20cea,0xe7f50053,0x00000000}},	//   влюю, nhov, ुँचा_,
  { {0x7c24066d,0x44240ceb,0x23e20053,0x00000000}},	//   dair, mam_, _परिद,
  { {0x768f076c,0x44240cec,0x00000000,0x00000000}},	//   _høyr, lam_,   ,
  { {0x20d20026,0x7c2404bc,0x20c70afc,0x00000000}},	//   ráir_, fair, _осиг,
  { {0x7c240027,0x63a40078,0x44240ced,0x00000000}},	//   gair, _žiny, nam_,
  { {0xfbd00032,0x7b090066,0xba2b0021,0x00000000}},	// [f90] لتك_, _sľub, قسام_,
  { {0x44240cee,0xdb040003,0xb05b004e,0x00000000}},	//   ham_, iziè, snäd,
  { {0x44240cef,0x443f0185,0x7c240025,0x00000000}},	//   kam_, ygu_, bair,
  { {0xd0f90047,0xdbd90026,0x7c240cf0,0x00000000}},	//   פּער, _fæði, cair,
  { {0xdbd90014,0xf3f900dd,0x44240cf1,0x00000000}},	//   _gæði, neţe_, dam_,
  { {0x45190905,0xa01b00ea,0x7f3c0047,0x00000000}},	//   пция_, gköz, קעוו,
  { {0xddde0051,0x645b0cf2,0xe5760062,0x00000000}},	//   _zapł, teui, езщ_,
  { {0xfdf8014e,0x78a20114,0x44240cf3,0x00000000}},	//   וצות_, chov, gam_,
  { {0x6101001c,0x645b0cf4,0x443f0cf5,0x00000000}},	//   _vēlm, reui, rgu_,
  { {0x57780032,0x443f0185,0x44240162,0x00000000}},	//   _تصفح_, sgu_, aam_,
  { {0x44240cf6,0xa06a0cf7,0xe2a80044,0x00000000}},	//   bam_, пана_, باين_,
  { {0x44240cf8,0x649c0139,0x20050051,0x00000000}},	//   cam_, _héin, ślin_,
  { {0xb7bd003b,0x9f4c005b,0xa2950054,0x00000000}},	//   _feţe, _ölüm_, _паді,
  { {0x78a20114,0xdbd90046,0xed6001c8,0x00000000}},	//   zhov, _ræði, ážou_,
  { {0x7c240cf9,0x6b8b00c7,0xc692009f,0x00000000}},	//   tair, äggn, נאל_,
  { {0xa01b000f,0x7c240025,0x649c0025,0x00000000}},	//   zköz, uair, _léin,
  { {0x7c240cfa,0x69cb0058,0x945d0022,0x00000000}},	// [fa0] rair, şgel, lońs,
  { {0x4a4305fb,0x44240cfb,0x636a013d,0x00000000}},	//   лнув, zam_, löná,
  { {0x7c240cfc,0xf2960047,0x44240bbf,0x00000000}},	//   pair, עכער_, yam_,
  { {0xafdb0205,0x442403cc,0xb05b004d,0x00000000}},	//   mfør, xam_, mnäc,
  { {0xafdb02ab,0xa01b00ea,0x78a20cfd,0x00000000}},	//   lfør, tköz, rhov,
  { {0x44240cfe,0x78a20cff,0x945d056c,0x00000000}},	//   wam_, shov, końs,
  { {0xb7bd0529,0x78a200c7,0xafdb02ab,0x00000000}},	//   _reţe, phov, nfør,
  { {0x60c401b3,0x6440007d,0x945d0022,0x00000000}},	//   _njim, ugmi, dońs,
  { {0x64400004,0x73d7005a,0x44240d00,0x00000000}},	//   rgmi, ндър_, ram_,
  { {0x44240d01,0x39580150,0xafdb00d1,0x00000000}},	//   sam_, _kprs_, kfør,
  { {0xb145007e,0x5a9b0047,0xf3f9003b,0x00000000}},	//   نیوم_, פשטא, veţe_,
  { {0xafdb02ab,0x859b009a,0x00000000,0x00000000}},	//   dfør, _משבו,   ,
  { {0x61080080,0xf3f9003b,0x94a90021,0x00000000}},	//   _děla, teţe_, _تطلق_,
  { {0xd36f007e,0x71260021,0x2a6a00a5,0x00000000}},	//   _دهه_, _كربل, _nabb_,
  { {0xafdb0d02,0xf3f9003b,0xbdd502fa,0x00000000}},	//   gfør, reţe_, товщ,
  { {0xf3f9003b,0x768f04aa,0x11db0063,0x00000000}},	//   seţe_, _løyp, _מחוב,
  { {0x6fb90086,0x629a0d03,0xcb340062,0x00000000}},	// [fb0] _ігор_, okto, летъ,
  { {0x213e0034,0x629a0d04,0x60dd00cf,0x00000000}},	//   outh_, nkto, llsm,
  { {0x649c0164,0x629a0d05,0x76b20022,0x00000000}},	//   _réin, ikto, głym,
  { {0x89340032,0x90d6008d,0x99640085,0x00000000}},	//   اعلا, hùn, ытул,
  { {0x649c0025,0x213e004d,0x48040054,0x00000000}},	//   _péin, huth_, упів,
  { {0xd1380006,0x386908ed,0x368b089a,0x00000000}},	//   krą_, žar_, ясен_,
  { {0x6abf0161,0x569200e1,0xf5320002,0x00000000}},	//   ्वीर, рајт, аејќ,
  { {0x629a0d06,0x25ba0139,0xd1380d07,0x00000000}},	//   ekto, úpla_, drą_,
  { {0x2005004c,0x03220085,0xd138005f,0x00000000}},	//   ělil_, адын, erą_,
  { {0x68fb0290,0x649c0025,0x290305b3,0x00000000}},	//   _hiud, _héil, _kuja_,
  { {0x10a60d08,0x2bd80042,0x68fb004e,0x00000000}},	//   винн, _भुना, _kiud,
  { {0x629a0d09,0x40960d0a,0xf8b30042,0x00000000}},	//   akto, трот, ूचिय,
  { {0x6f630088,0xd1380022,0x68e900a3,0x00000000}},	//   авяз, arą_, _mhed,
  { {0x764308f0,0xafdb00d1,0x945d0051,0x00000000}},	//   ngny, tfør, pońs,
  { {0xb05b004d,0x63a9004d,0x62870072,0x00000000}},	//   unäc, lzen, öjou,
  { {0xafdb02ab,0x649c0025,0x6fb60021,0x00000000}},	//   rfør, _néil, _لمعا,
  { {0x63a90d0b,0x4a460002,0xab270a72,0x00000000}},	// [fc0] nzen, кнав, кота_,
  { {0xafdb076c,0x63a90d0c,0x6108011b,0x00000000}},	//   pfør, izen, _měln,
  { {0x68fb00eb,0x29030016,0x39460121,0x00000000}},	//   _biud, _cuja_, тнег,
  { {0x68fb0d0d,0x6f040035,0x649c0139,0x00000000}},	//   _ciud, _kuic, _céil,
  { {0x63a90d0e,0x6f040d0f,0xf7430002,0x00000000}},	//   jzen, _juic, иецо,
  { {0x63a90d10,0xf793000d,0xd1380078,0x00000000}},	//   dzen, рашэ, yrą_,
  { {0x649c0025,0x6d4e0d11,0x2bd80042,0x00000000}},	//   _féil, ntba, _भँडा,
  { {0x68fb051e,0x649c0025,0x3eb80d12,0x00000000}},	//   _giud, _géil, hirt_,
  { {0x69dc072f,0x6d4e0d13,0x44f70021,0x00000000}},	//   _hyre, htba, خروج_,
  { {0xd138091b,0x6d4e0d14,0x6108004c,0x00000000}},	//   trą_, ktba, _děln,
  { {0x7afc0498,0x68e900b9,0x63a90d15,0x00000000}},	//   _mirt, _yhed, azen,
  { {0x40350088,0x69dc0d16,0x213e0d17,0x00000000}},	//   ыемс, _myre, ruth_,
  { {0x63a90045,0x69dc0d18,0xdfd80062,0x00000000}},	//   czen, _lyre, вър_,
  { {0x7afc0150,0xf7730063,0xa2930086,0x00000000}},	//   _nirt, בקש_, _ваші,
  { {0x6d4e0d19,0x69dc0d1a,0x5c070895,0x00000000}},	//   gtba, _nyre, вяза,
  { {0x672d003d,0xec340086,0x3eb80139,0x00000000}},	//   šaji, инсь, airt_,
  { {0x68e9001f,0x7afc0b9c,0x2903017d,0x00000000}},	// [fd0] _rhed, _birt, _suja_,
  { {0xe0df0290,0x64950025,0xdee40259,0x00000000}},	//   llò_, _háit, _коњи,
  { {0x2d8c000e,0x3f99001f,0x68e9002b,0x00000000}},	//   ødet_, lysu_, _phed,
  { {0x08d40086,0x9981004c,0x69dc0d1b,0x00000000}},	//   ація, sahů_, _dyre,
  { {0x649c0025,0x68fb0871,0x6101001c,0x00000000}},	//   _céim, _viud, _vēli,
  { {0x64950027,0x4aa70161,0xf77003eb,0x00000000}},	//   _láit, _गतिव, غان_,
  { {0x20d904cd,0x54d50131,0x955501f3,0x00000000}},	//   néis_, лциу, اختا,
  { {0x20050045,0xe89401e8,0x63a90d1c,0x00000000}},	//   ślij_, _кась, tzen,
  { {0x61080080,0xe8940121,0x63a90d1d,0x00000000}},	//   _bělo, _тать, uzen,
  { {0x454504f6,0xed6001d9,0x386d0d1e,0x00000000}},	//   _منطق, ážku_, _haer_,
  { {0x386d0089,0x63a90d1f,0x6108004c,0x00000000}},	//   _kaer_, szen, _dělo,
  { {0x71a2000d,0x20d90331,0x3eb8004d,0x00000000}},	//   саюз, déis_, wirt_,
  { {0xd12e007e,0x6f040d20,0x386d0335,0x00000000}},	//   يمی_, _quic, _maer_,
  { {0x386d00e8,0x61450699,0x2d9803d4,0x00000000}},	//   _laer_, _бека, tyre_,
  { {0x2d9e027d,0xb05b0137,0x387f0058,0x00000000}},	//   áte_, mnän, _onur_,
  { {0x6d4e0d21,0x7afc0d22,0x3f99002b,0x00000000}},	//   rtba, _sirt, bysu_,
  { {0x30db0047,0x2d9e04d9,0x0aea0062,0x00000000}},	// [fe0] _אַזע, šte_, едай_,
  { {0x9a6a0032,0x20d9006d,0x649c0d23,0x00000000}},	//   عمال_, béis_, _réim,
  { {0xd5b1001b,0x2d850137,0x7afc0d24,0x00000000}},	//   _xét_, älet_, _virt,
  { {0x7afc0d25,0x20d90025,0x386d0d26,0x00000000}},	//   _wirt, léir_, _caer_,
  { {0x386d0d27,0x7afc0d28,0x7bdd002b,0x00000000}},	//   _daer_, _tirt, _gysu,
  { {0x7afc0025,0x20d90025,0x96e70054,0x00000000}},	//   _uirt, néir_, льща_,
  { {0x2aa4000f,0x64950025,0x7c260150,0x00000000}},	//   _több_, _náis, _kekr,
  { {0x938a0002,0x386d002b,0xb4be0053,0x00000000}},	//   есоа_, _gaer_, ँचे_,
  { {0x64950025,0x5c370047,0xb356005d,0x00000000}},	//   _ráit, ארפן_, ایتا_,
  { {0x59b80053,0xa5da0021,0xa01b00a5,0x00000000}},	//   _आधार, _كبار_, njöv,
  { {0x7c260250,0x6e25005b,0xdd120058,0x00000000}},	//   _oekr, _rehb, _rüşv,
  { {0x7d050058,0x69c30022,0x7c260d29,0x00000000}},	//   _ruhs, źneg, _nekr,
  { {0xe0df0290,0xe29a0d2a,0x6108004c,0x00000000}},	//   rlò_, _пад_, _tělo,
  { {0x7bdd0051,0x44260013,0x64950d2b,0x00000000}},	//   _rysu, _heo_, _fáis,
  { {0x7c260d2c,0x4426055f,0xc2c3014d,0x00000000}},	//   _bekr, _keo_, _ديوي,
  { {0x64950025,0x20d90d2d,0x2fc600a8,0x00000000}},	//   _háir, réis_, _žoge_,
  { {0x2d8c05b9,0x20d9006d,0x44260d2e,0x00000000}},	// [ff0] øder_, séis_, _meo_,
  { {0x20d90d2f,0x44260d30,0x386d002b,0x00000000}},	//   péis_, _leo_, _saer_,
  { {0xedf3007e,0x64950025,0x7bdd0051,0x00000000}},	//   _ديدگ, _máir, _wysu,
  { {0xddde0080,0x7c2603ac,0x44260d31,0x00000000}},	//   _např, _gekr, _neo_,
  { {0xd366041b,0x2ca90027,0x44290066,0x00000000}},	//   _به_, mhad_, _ľa_,
  { {0xca49007e,0x64950139,0x3a87000d,0x00000000}},	//   _جلسه_, _náir, _сымв,
  { {0x44260025,0x95c801ce,0xaa58012c,0x00000000}},	//   _beo_, лућа_, _щиру_,
  { {0x44260d32,0x2ca900a3,0xf7950085,0x00000000}},	//   _ceo_, nhad_, _кабэ,
  { {0x64950025,0x44260d33,0x73050d34,0x00000000}},	//   _báir, _deo_, јпоз,
  { {0xe2990001,0x64950139,0x72950062,0x00000000}},	//   тао_, _páis, рших,
  { {0x20c60086,0x067a0047,0x00860ad9,0x00000000}},	//   ийом, _שנעל, ално,
  { {0x44260d35,0x2c150053,0x672d007d,0x00000000}},	//   _geo_, _फ्लू_, šaju,
  { {0x20d90025,0x7c260d36,0x53390041,0x00000000}},	//   téir_, _rekr, _סײַד,
  { {0x64950025,0x2ca900f5,0x248d0d37,0x00000000}},	//   _táis, ehad_, ljem_,
  { {0x20d90025,0xb606027d,0x7c2600c2,0x00000000}},	//   réir_, _uváž, _pekr,
  { {0x248d065f,0x2ca90025,0xb05b0072,0x00000000}},	//   njem_, ghad_, nnäl,

  { {0x3b07071a,0x249f0d38,0xdca30121,0x00000000}},	// [1000] ието_, ikum_, цати,
  { {0x248d0d39,0x249f0058,0x3ce00807,0x00000000}},	//   hjem_, hkum_, sliv_,
  { {0x7c2601f7,0x249f0026,0xb4f70053,0x00000000}},	//   _tekr, kkum_, ुदाय_,
  { {0x31560047,0xb17a0047,0x2ca9080f,0x00000000}},	//   ייען_, כטער, chad_,
  { {0x248d00c3,0x91fc001c,0x44260d3a,0x00000000}},	//   djem_, ndār, _reo_,
  { {0x4426018d,0xdcfc0078,0xe6930049,0x00000000}},	//   _seo_, tyrė, يلند,
  { {0xfc3f0066,0x4426004b,0xda5b009a,0x00000000}},	//   _ulíc_, _peo_, _שכלל,
  { {0xd4970121,0x94170062,0xd37a0d3b,0x00000000}},	//   иры_, ажът_, вчо_,
  { {0xb8dc016a,0x64950027,0x44260d3c,0x00000000}},	//   ेच_, _páir, _veo_,
  { {0xd2570086,0x68e20cc7,0x291a0d3d,0x00000000}},	//   ацю_, llod, oppa_,
  { {0x672d0add,0x64a60d3e,0x248d0a80,0x00000000}},	//   šajt, _кажа, bjem_,
  { {0xd83f0114,0xdfa70002,0xe0440002,0x00000000}},	//   _účtu_, ајго, онџи,
  { {0x64950025,0x6d5e07b9,0x58f70047,0x00000000}},	//   _táir, _appa, ימטע_,
  { {0xd5b10013,0x3ea5013d,0x539b009a,0x00000000}},	//   _kép_, ólt_, _בידו,
  { {0xa2d30053,0x6143018e,0x6113003b,0x00000000}},	//   डवर्, _деја, _căld,
  { {0x76b20051,0xbd440021,0x51fb0063,0x00000000}},	//   pływ, تنفي, _בהוצ,
  { {0x2ca90d3f,0x5a35005a,0x68e2001f,0x00000000}},	// [1010] rhad_, йнат, dlod,
  { {0xda780055,0x657a057a,0x213e00f6,0x00000000}},	//   иях_, _orth, orth_,
  { {0xceb200b5,0xe987005e,0x83fd013d,0x00000000}},	//   _זיי_, шћан, ndőr,
  { {0x213e00e5,0x68e20d40,0x89340044,0x00000000}},	//   irth_, glod, زعما,
  { {0x96b90001,0x248d00c2,0x291a0d41,0x00000000}},	//   луку_, vjem_, appa_,
  { {0x68e2001c,0x7c2d017a,0x23ca0053,0x00000000}},	//   alod, laar, ापनद,
  { {0x248d00c3,0xce380063,0x25a1004c,0x00000000}},	//   tjem_, באות_, áhl_,
  { {0x7c2d0d42,0x64950025,0x249f0052,0x00000000}},	//   naar, _cáip, ukum_,
  { {0x248d00c3,0xf773006a,0x657a0185,0x00000000}},	//   rjem_, _باز_, _erth,
  { {0x249f0d43,0xe610005d,0x7c2d0d44,0x00000000}},	//   skum_, _قشم_, haar,
  { {0x6f160d45,0x7c2d0d46,0x63ad0022,0x00000000}},	//   _styc, kaar, _żand,
  { {0x84640062,0x7c2d0d47,0xd3080013,0x00000000}},	//   _мъче, jaar, _iện_,
  { {0x999100ea,0x442d0d48,0x26c70d49,0x00000000}},	//   _mező_, mae_, onno_,
  { {0x442d0d4a,0x64490d4b,0xc7d60aeb,0x00000000}},	//   lae_, lgei, מורי_,
  { {0x6da30d4c,0x62830d4d,0xada30d4e,0x00000000}},	//   пира, _inno, парл,
  { {0x64490d4f,0x442d0d50,0x7c2d0d51,0x00000000}},	//   ngei, nae_, gaar,
  { {0x2ca00d52,0x4ed60d53,0x7e9a043e,0x00000000}},	// [1020] rkid_, _гюнт, _منظر_,
  { {0x7c2d00bb,0x2ca00d54,0x442d0d55,0x00000000}},	//   aaar, skid_, hae_,
  { {0x9e7b00b5,0x68e2001c,0x38cb007e,0x00000000}},	//   _ענטפ, tlod, گالی_,
  { {0x6c860032,0xb05b0072,0x777b0d56,0x00000000}},	//   _الحم, enäj, _brux,
  { {0xddd50080,0x62830229,0x30db0047,0x00000000}},	//   dezř, _onno, אַגע,
  { {0xa01b0137,0x7e7a0047,0xcd29007e,0x00000000}},	//   njör, ראַז, _حسین_,
  { {0xb9960032,0x64950139,0x68e20d57,0x00000000}},	//   _الزب, _páip, plod,
  { {0x26c70290,0xe3140001,0x442d00f6,0x00000000}},	//   anno_, омињ, gae_,
  { {0x213e0185,0x657a0185,0xdc9b0047,0x00000000}},	//   wrth_, _wrth, טיקל,
  { {0x2d7808ea,0x78a2027d,0x2b400139,0x00000000}},	//   _oče_, lkov, iric_,
  { {0x290a0004,0x442d002c,0xd4d6000d,0x00000000}},	//   _juba_, bae_, _лідэ,
  { {0x290a0150,0x78a20d58,0x442d0d59,0x00000000}},	//   _muba_, nkov, cae_,
  { {0x290a0019,0x4394018e,0x623400e1,0x00000000}},	//   _luba_, _фалс, _делу,
  { {0x2918048e,0x7c2d0173,0x9e140086,0x00000000}},	//   _otra_, waar, здрі,
  { {0x6102003d,0x7095000a,0xb05b00fe,0x00000000}},	//   _vēlr, _макф, nnäk,
  { {0x2b4004aa,0x78a2059d,0x929d056c,0x00000000}},	//   fric_, jkov, dpły,
  { {0x40540032,0x38660d5a,0xfe6e007e,0x00000000}},	// [1030] _رئيس, deor_, رگی_,
  { {0x5a350086,0x539b0063,0x7c2d0d5b,0x00000000}},	//   інет, אימו, saar,
  { {0x290a0d5c,0x6d410d5d,0x7c2d0d5e,0x00000000}},	//   _cuba_, álad, paar,
  { {0x6d5500bd,0xec6b03d6,0x2b4000e5,0x00000000}},	//   mtza, _срок_, bric_,
  { {0x442d0d5f,0x2b4001a8,0x6108004c,0x00000000}},	//   vae_, cric_, _děli,
  { {0xb7c6003d,0x290700f8,0x6f1d006f,0x00000000}},	//   diģē, ínas_, ipsc,
  { {0x6d4700c3,0x64490d60,0x442d0d61,0x00000000}},	//   nuja, tgei, tae_,
  { {0x94790d62,0x6e2e00ea,0xf359005e,0x00000000}},	//   рску_, zabb, ашој_,
  { {0x442d0d63,0x290a007d,0x52a908ac,0x00000000}},	//   rae_, _zuba_, ивим_,
  { {0x6d55006f,0x6e2e004d,0x29180014,0x00000000}},	//   ktza, xabb, _ytra_,
  { {0x71b50076,0x208a0d64,0x6113003b,0x00000000}},	//   ющих, айни_, _sălb,
  { {0x25d600b5,0xafdb00d1,0x6d470d65,0x00000000}},	//   _ווען_, lføy, duja,
  { {0xa8560063,0x60cd0d66,0xa01b0014,0x00000000}},	//   חירה_, _djam, tjör,
  { {0x78a90d67,0x78a2027d,0x6113003b,0x00000000}},	//   _llev, zkov, _călc,
  { {0xde03019d,0x78a90d68,0x6d470d69,0x00000000}},	//   дпри, _olev, guja,
  { {0x8b260ac5,0x2b400d6a,0x6e2e0d21,0x00000000}},	//   ждае, tric_, sabb,
  { {0x765c0026,0x6d470006,0x20050080,0x00000000}},	// [1040] _öryg, auja, ělit_,
  { {0xe8220053,0x6d470d6b,0x61e30014,0x00000000}},	//   मर्थ_, buja, _kynl,
  { {0x78a9010a,0x6abe0186,0x89160021,0x00000000}},	//   _blev, ripf, زبائ,
  { {0x78a90d6c,0x814c0047,0x80370047,0x00000000}},	//   _clev, רעאַ, ַנצע_,
  { {0x2907007a,0x78a20d6d,0x69cb0244,0x00000000}},	//   ínar_, rkov, ßger,
  { {0x649c0025,0xeb9f0093,0x7b09007d,0x00000000}},	//   _léit, _tfør_, _džud,
  { {0x27ed000f,0xd6390086,0x78a90717,0x00000000}},	//   _ezen_, сячі_, _flev,
  { {0xd91b0063,0xf9b7009a,0x09b7009d,0x00000000}},	//   _כולל, _והלך_, _ופלט_,
  { {0xb05b0072,0xf3660054,0xccf3089e,0x00000000}},	//   snäk, ітин, וכה_,
  { {0xb7c6001c,0x60cd0d6e,0x78a9004c,0x00000000}},	//   riģē, _sjam, _zlev,
  { {0x61e30185,0x26dc0d6f,0x27e40d70,0x00000000}},	//   _cynl, movo_, _hymn_,
  { {0x6d4700fe,0x26dc0d71,0x29040d72,0x00000000}},	//   vuja, lovo_, _jima_,
  { {0x248601e3,0xb05b0072,0x649c0d73,0x00000000}},	//   _inom_, nnäi, _déit,
  { {0x26dc055e,0x6d470d74,0x29040d75,0x00000000}},	//   novo_, tuja, _lima_,
  { {0xdcbb011c,0x61e3001f,0x361b0047,0x00000000}},	//   аща_, _gynl, שולד,
  { {0x290400c3,0x62980a63,0x26dc0d76,0x00000000}},	//   _nima_, _hovo, hovo_,
  { {0x63a0027d,0x2486007d,0x26dc0d77,0x00000000}},	// [1050] nymn, _mnom_, kovo_,
  { {0x6d470d78,0x60dd0d79,0x78a90d7a,0x00000000}},	//   puja, losm, _slev,
  { {0xdfd1006a,0x89d90021,0x2d8c01e9,0x00000000}},	//   _زيگ_, حوار_, ädet_,
  { {0xf7710067,0x6f0d0035,0x6b8b0137,0x00000000}},	//   فات_, _kuac, äggs,
  { {0x7c22006d,0x0a6b0001,0x78a90080,0x00000000}},	//   ñore, _крви_, _vlev,
  { {0xd6db02a9,0x26dc02e2,0x62980d7b,0x00000000}},	//   ште_, govo_, _novo,
  { {0x6f0d0025,0xa9540086,0xf5920021,0x00000000}},	//   _luac, _окрі, فلوج,
  { {0x442b008b,0x20090d7c,0xf3f900dd,0x00000000}},	//   úc_, _ngai_, leţi_,
  { {0x6f0d0027,0x649c0025,0x61e30d7d,0x00000000}},	//   _nuac, _réit, _synl,
  { {0xf3f90529,0xd2a90055,0x649c006d,0x00000000}},	//   neţi_, ское_, _béis,
  { {0x1a9c0047,0x6113003b,0x21690cdf,0x00000000}},	//   ייזע, _băla, щини_,
  { {0x6f0d0139,0x6113003b,0x95c4005d,0x00000000}},	//   _buac, _căla, _تيمه,
  { {0x7ea20164,0x61fe0240,0xb7bd003b,0x00000000}},	//   _hôpi, _úpln, _beţi,
  { {0x62980add,0x52390047,0xe3b001fb,0x00000000}},	//   _govo, _הײַנ, _جرم_,
  { {0xf3f90529,0xb7bd000c,0x91e20932,0x00000000}},	//   deţi_, _deţi, _поше,
  { {0x649c0025,0x236d0051,0xac0a0002,0x00000000}},	//   _héir, owej_, снаа_,
  { {0x6f0d0d7e,0x29040d7f,0x6b630d80,0x00000000}},	// [1060] _guac, _rima_, нкта,
  { {0xf3f90529,0x645b0027,0x6d410025,0x00000000}},	//   geţi_, hfui, álac,
  { {0x7e9b0063,0xa9670062,0x0e9b0063,0x00000000}},	//   _הסיו, зиха_, _השיל,
  { {0x649c0027,0x6f57005d,0xa2bb0082,0x00000000}},	//   _léir, _بلیز_, षोत्,
  { {0x7c240d81,0x26dc0869,0x66e60d82,0x00000000}},	//   mbir, tovo_, пода,
  { {0xf3f90529,0x26dc051e,0x649c0139,0x00000000}},	//   ceţi_, uovo_, _néir,
  { {0x29040d83,0xb05b004b,0x26dc0d84,0x00000000}},	//   _tima_, snäi, rovo_,
  { {0x7b070025,0x493b0063,0x39570063,0x00000000}},	//   _órtá, _לגלו, _משלם_,
  { {0x7d060659,0xf743006e,0x62980114,0x00000000}},	//   _miks, _пето, _povo,
  { {0x7d060d85,0x649c0139,0x2cfa0053,0x00000000}},	//   _liks, _péis, ्दुल_,
  { {0xb7bd000c,0xf1a301d5,0x81c60121,0x00000000}},	//   _reţi, ерян, ящие,
  { {0x6298004d,0x7d060d86,0x00000000,0x00000000}},	//   _wovo, _niks,   ,
  { {0x7c240d87,0xdfdb005a,0x629800c2,0x00000000}},	//   dbir, сън_, _tovo,
  { {0xd24f0032,0xb2d30021,0x69c10014,0x00000000}},	//   _منه_, _كينغ, _ýleg,
  { {0xf3f9000c,0x7d060150,0xa2d90053,0x00000000}},	//   veţi_, _biks, नकर्,
  { {0x6f0d0139,0x2a7f0075,0x6108011b,0x00000000}},	//   _tuac, _şub_, _dělt,
  { {0xf3f90469,0x2d8c0d88,0x7d060d89,0x00000000}},	// [1070] teţi_, äder_, _diks,
  { {0x7c240d8a,0x7d06005f,0x0dcb0d8b,0x00000000}},	//   abir, _eiks, _гуми_,
  { {0xf3f9000c,0xa9070593,0x7d060d8c,0x00000000}},	//   reţi_, سبان, _fiks,
  { {0x6ef200b9,0xe9f80086,0x2d9e004e,0x00000000}},	//   ræbe, їнці_, ätee_,
  { {0x3b64011c,0xf3f9000c,0xe738000d,0x00000000}},	//   _първ, peţi_, зеі_,
  { {0x644700eb,0x45190062,0xcd340043,0x00000000}},	//   ėjim, оция_, _تریب,
  { {0x6724001c,0xdb08013d,0x45180085,0x00000000}},	//   ģija, ölöt, пцыя_,
  { {0x0319007e,0x649c0139,0xc9520063,0x00000000}},	//   يتخت_, _séir, _שמן_,
  { {0x2d570058,0x649c0139,0x33650054,0x00000000}},	//   hçe_, _péir, євог,
  { {0x7c2400c3,0x2d57005b,0x957c0051,0x00000000}},	//   zbir, kçe_, _cząs,
  { {0x9046006a,0x94190094,0xf4870083,0x00000000}},	//   ونده, _джет_, _нудн,
  { {0xcea900b7,0xb6030066,0x7c2f0d8d,0x00000000}},	//   _די_, _vtáč, _necr,
  { {0x7d0601d0,0xe2a80043,0x9836009d,0x00000000}},	//   _riks, زاین_, וטרו_,
  { {0xa1c50086,0x442f00ac,0x7d060d8e,0x00000000}},	//   _облд, _heg_, _siks,
  { {0x2d9e003b,0x7d060d8f,0x7c240605,0x00000000}},	//   âte_, _piks, tbir,
  { {0x442f02ab,0xb05b0d90,0x5f460021,0x00000000}},	//   _jeg_, liän, _قنبل,
  { {0x442f0d91,0x200f0066,0xa08b0063,0x00000000}},	// [1080] _meg_, ámiť_, _וְיִ,
  { {0x4a43000a,0xda660021,0x7c240d92,0x00000000}},	//   кнув, باري, sbir,
  { {0x7d060d93,0x442f0438,0xd910007e,0x00000000}},	//   _tiks, _oeg_, ایر_,
  { {0x3ce901c2,0x291c001c,0x7c2f05df,0x00000000}},	//   clav_, īva_, _gecr,
  { {0xafdb00b9,0x69d5004d,0xd7f706da,0x00000000}},	//   lgør, _exze, муш_,
  { {0x442f0004,0xb05b0137,0xd7f90086,0x00000000}},	//   _aeg_, lnät, чує_,
  { {0xafdb05b9,0x442f0d94,0xa9260085,0x00000000}},	//   ngør, _beg_, _ідал,
  { {0x2a780d95,0x54540062,0x9855000d,0x00000000}},	//   _harb_, хвит, _птуш,
  { {0x442f0d96,0xbc1b0063,0xfc3f0026,0x00000000}},	//   _deg_, חופש, _slík_,
  { {0xb92b0013,0x442f0d97,0xa79b009a,0x00000000}},	//   _nguỵ_, _eeg_, _ושמח,
  { {0x6722003d,0xb05b0137,0xe1340085,0x00000000}},	//   lpoj, knät, энны,
  { {0x3cfa0161,0x14170021,0xafdb01e1,0x00000000}},	//   ्दों_, _قيمة_, dgør,
  { {0x5f94005a,0x7c2f04bc,0x26ce0290,0x00000000}},	//   вият, _recr, onfo_,
  { {0x2d5701f7,0x442f006f,0xafdb00b9,0x00000000}},	//   tçe_, _zeg_, fgør,
  { {0xafdb0146,0x443d001f,0x26ce0d98,0x00000000}},	//   ggør, _ydw_, info_,
  { {0x9f550086,0x2cb2001f,0x55770047,0x00000000}},	//   _звич, ghyd_, ועלן_,
  { {0x7c22006d,0xd1380078,0x7e770d99,0x00000000}},	// [1090] ñora, lsą_, _taxp,
  { {0x2a780d2e,0xe9ab00f2,0x3ce90d9a,0x00000000}},	//   _carb_, يدان_, slav_,
  { {0x2a780025,0x7eab0019,0x7c2f005b,0x00000000}},	//   _darb_, _hüpo, _tecr,
  { {0x2cb20185,0xd1380006,0x6e35007d,0x00000000}},	//   chyd_, isą_, lazb,
  { {0x442f0d9b,0xddd500ea,0xbc1a0063,0x00000000}},	//   _reg_, mező, _מורש,
  { {0x442f0031,0xd1380006,0xddd500ea,0x00000000}},	//   _seg_, ksą_, lező,
  { {0x26c9007d,0xb05b0d9c,0xd9140085,0x00000000}},	//   đao_, nnäs, _адсы,
  { {0x628a0d9d,0x6d470d9e,0x2ca90137,0x00000000}},	//   _anfo, irja, nkad_,
  { {0x442f0d9f,0xe3b10021,0xd1380078,0x00000000}},	//   _veg_, طرة_, esą_,
  { {0x442f0da0,0x673b0072,0xeb92089e,0x00000000}},	//   _weg_, _ivuj, רָה_,
  { {0x2f140137,0xddd500ea,0x68eb006f,0x00000000}},	//   _säg_, kező, olgd,
  { {0xddd500ea,0x628a0da1,0x3f6a0da2,0x00000000}},	//   jező, _enfo, пимо_,
  { {0x6d470da3,0x6d410da4,0x2ca90da5,0x00000000}},	//   erja, álan, dkad_,
  { {0x2f1400c7,0xafdb00b9,0xd2510021,0x00000000}},	//   _väg_, tgør, _صنع_,
  { {0x98a70080,0xacf600d7,0x9f63004c,0x00000000}},	//   éně_, ечај, ěvák_,
  { {0xafdb0146,0x91ba009a,0x00000000,0x00000000}},	//   rgør, _ממצי,   ,
  { {0xcb670da6,0x6d470da7,0xab660085,0x00000000}},	// [10a0] нате_, arja, эвал,
  { {0xb05b00c7,0xafdb00b9,0x8c430058,0x00000000}},	//   snät, pgør, ışab,
  { {0xc879005b,0x29110da8,0xc8660da9,0x00000000}},	//   _baş_, _cuza_, етли,
  { {0xd491001b,0x60c6003e,0x2ca900c7,0x00000000}},	//   _tùy_, nikm, ckad_,
  { {0x60c60019,0x7c360332,0xb05b0daa,0x00000000}},	//   iikm, mayr, onär,
  { {0x26ce0297,0x2f3b0047,0x6d5c0dab,0x00000000}},	//   unfo_, לגנד, otra,
  { {0x6d4e0dac,0x6d5c03e1,0x23660dad,0x00000000}},	//   nuba, ntra, _spoj_,
  { {0x67220072,0x6d5c0dae,0x6745013d,0x00000000}},	//   ppoj, itra, ütjü,
  { {0x7afe0bbd,0x68e20019,0x6d4e00a4,0x00000000}},	//   ompt, mood, huba,
  { {0x6d4e0009,0x6d470014,0x9bbb0063,0x00000000}},	//   kuba, yrja, פציפ,
  { {0xd46a0daf,0xd1380006,0x51f80086,0x00000000}},	//   _ниже_, usą_, ьною_,
  { {0xe61f008b,0x68e2056f,0xd1380078,0x00000000}},	//   _đôi_, nood, rsą_,
  { {0xdefb0121,0x6d5c0db0,0xddd5009c,0x00000000}},	//   зыв_, etra, vező,
  { {0x628a0034,0x6d5c00bd,0x60c60078,0x00000000}},	//   _unfo, ftra, aikm,
  { {0x68e20d9e,0x6d5c0db1,0x6d4e0db2,0x00000000}},	//   kood, gtra, guba,
  { {0x61430001,0x60c6005b,0xb05b0137,0x00000000}},	//   _сећа, cikm, rnäs,
  { {0x6d4e004b,0xfbd00021,0x2ca90db3,0x00000000}},	// [10b0] auba, متك_, rkad_,
  { {0x2ca90db4,0x6d4e0db5,0x6d5c0db6,0x00000000}},	//   skad_, buba, btra,
  { {0xc9840d34,0xb8350062,0xe8590085,0x00000000}},	//   луци, веещ, даеш_,
  { {0x7afe00ac,0xd3080013,0xcd960063,0x00000000}},	//   ampt, _iệu_, _סדרת_,
  { {0xb05b0072,0x4c9a089e,0xe6950121,0x00000000}},	//   jiäm, _חברו, киды,
  { {0xc6680001,0x6446013d,0x7eb0004e,0x00000000}},	//   ешће_, ókin, _käpa,
  { {0x68e200e8,0x20e10053,0xc8790058,0x00000000}},	//   bood, नवाध, _taş_,
  { {0xe8d5009d,0x00000000,0x00000000,0x00000000}},	//   _סוּר_,   ,   ,
  { {0x6d5c0db7,0x60c60014,0x6d4e004d,0x00000000}},	//   ztra, vikm, zuba,
  { {0x63a600d1,0x6d4e0150,0x6d5c0db8,0x00000000}},	//   økna, yuba, ytra,
  { {0x61ea0185,0x60c60006,0x4a5c0047,0x00000000}},	//   _cyfl, tikm, לדזו,
  { {0x26c70db9,0x6d5c0dba,0x387d002b,0x00000000}},	//   lino_, vtra, ndwr_,
  { {0xb05b0137,0x3f8401c2,0x6d5c002b,0x00000000}},	//   tnär, ímu_, wtra,
  { {0x6d4e0dbb,0x6d5c0dbc,0x60c60dbd,0x00000000}},	//   tuba, ttra, sikm,
  { {0x61ea0185,0xed5705a1,0x6d5c0dbe,0x00000000}},	//   _gyfl, кор_, utra,
  { {0x8c43000a,0x6d4e0dbf,0x26c70dc0,0x00000000}},	//   иесе, ruba, hino_,
  { {0x6d4e00bb,0x387d001f,0x6d5c03db,0x00000000}},	// [10c0] suba, ddwr_, stra,
  { {0x26c70dc1,0x6d5c0dc2,0x0f370041,0x00000000}},	//   jino_, ptra, _שריט_,
  { {0x68e20019,0xda650021,0x26c70dc3,0x00000000}},	//   tood, طالي, dino_,
  { {0xdb0d00ea,0xd3080013,0xa01b0014,0x00000000}},	//   szaá, _hệt_, rdög,
  { {0x26c70dc4,0x68e20dc5,0xcee9005d,0x00000000}},	//   fino_, rood, _زرین_,
  { {0x68e20019,0x26c70dc6,0xb05b0072,0x00000000}},	//   sood, gino_, viäm,
  { {0xceb30063,0xd3080013,0x95530021,0x00000000}},	//   שיו_, _mệt_, لخيا,
  { {0xe6f20013,0xd308008d,0x18a30085,0x00000000}},	//   _dườ, _lệt_, _касм,
  { {0x26c70198,0xd4670001,0x6ef200b9,0x00000000}},	//   bino_, тиње_, væbn,
  { {0x26c70dc7,0x60c400a4,0xc1740121,0x00000000}},	//   cino_, _amim, глощ,
  { {0xaa370047,0xe6f20013,0x40350dc8,0x00000000}},	//   כטיק_, _gườ, ленс,
  { {0x7ccc005b,0x94260002,0x7eb0004b,0x00000000}},	//   oğru, _рмде, _räpa,
  { {0x2d9e0dc9,0x2d8c0dca,0xddce005f,0x00000000}},	//   äten_, åden_, bebū,
  { {0x41dd0053,0x62340dcb,0x6d4109b6,0x00000000}},	//   _नुकस, _секу, šlam,
  { {0x2d850dcc,0xd308008b,0x9e340121,0x00000000}},	//   íle_, _dệt_, ресч,
  { {0x2b4901a8,0xf0470085,0x26c70dcd,0x00000000}},	//   trac_, _рэко, zino_,
  { {0x9be70086,0x09bd0053,0x80a4007e,0x00000000}},	// [10d0] тівк, ्प्य, _خمين,
  { {0xdd03005b,0x7a35007e,0x387d002b,0x00000000}},	//   ırıc, افاص, wdwr_,
  { {0x26c70dce,0x77690137,0x6cd5002a,0x00000000}},	//   vino_, _spex, _مقدا,
  { {0x64420dcf,0xe6f2008d,0x26c700a3,0x00000000}},	//   _ndoi, _rườ, wino_,
  { {0x3ea10019,0x26c70dd0,0x7b090078,0x00000000}},	//   _koht_, tino_, _užuo,
  { {0xe7eb0042,0x66f4046e,0xc7320044,0x00000000}},	//   ड़ेगा_, апчу, حفوظ,
  { {0x26c70dd1,0x95c8005e,0xf999009a,0x00000000}},	//   rino_, кућа_, _אֱ֭ל,
  { {0x94750021,0x26c70dd2,0x3f8600c2,0x00000000}},	//   ادثا, sino_, _šoum_,
  { {0x26c70dd3,0xdce5001c,0x13090065,0x00000000}},	//   pino_, _arhī, нний_,
  { {0x6b67001c,0xe6f20013,0x7dd2013d,0x00000000}},	//   mīgā, _tườ, nűsé,
  { {0x27fa0051,0xd3080013,0x2455002a,0x00000000}},	//   ępne_, _rệt_, _مناس,
  { {0x629a0dd4,0xd308008d,0x351a0063,0x00000000}},	//   ajto, _sệt_, _טוענ,
  { {0x7ae5037e,0x6b67008f,0x239b0021,0x00000000}},	//   koht, nīgā, _تخضع_,
  { {0x7ae500fe,0x91fc008f,0xe39a0063,0x00000000}},	//   joht, teāt, _רֹאש,
  { {0x92560dd5,0x290d006d,0x63bb004d,0x00000000}},	//   _сајт_, _oiea_, lzun,
  { {0x63a90003,0x27ed0331,0x4f960dd6,0x00000000}},	//   oyen, _oyen_, _броу,
  { {0x8b260088,0x63bb00bd,0xf4120047,0x00000000}},	// [10e0] удзе, nzun, מפן_,
  { {0xfeba006a,0x290d0ccf,0x7e56005e,0x00000000}},	//   _ساخت_, _aiea_, _стиц,
  { {0x09f6047e,0x91fc0023,0x6da60dcb,0x00000000}},	//   учая, leār, _сина,
  { {0x27ed04b1,0x7e7e01a0,0xd7fa0076,0x00000000}},	//   _byen_, _happ, нул_,
  { {0x7c95000d,0xddc70124,0x7e7e0dd7,0x00000000}},	//   _трэц, mejš, _kapp,
  { {0x66e302dc,0xddc70dd8,0xaf770041,0x00000000}},	//   боча, lejš, טענס_,
  { {0x7b09017f,0x6b84056f,0x7e7e0dd9,0x00000000}},	//   _ožuj, lvig, _mapp,
  { {0xddc70dda,0x63bb004d,0x3a3a0ddb,0x00000000}},	//   nejš, fzun, lapp_,
  { {0x6b67001c,0xa5070001,0x63a900ea,0x00000000}},	//   cīgā, ћења_, gyen,
  { {0x3a3a0ddc,0x6b84004b,0xf12609b3,0x00000000}},	//   napp_, ivig, льмо,
  { {0x6b840019,0x63bb0035,0xa52602d8,0x00000000}},	//   hvig, azun, _смед,
  { {0x7a48001c,0x629a0104,0x7e7e0ddd,0x00000000}},	//   lītē, sjto, _aapp,
  { {0x7e7e0dde,0x4fc70ddf,0xdfd80062,0x00000000}},	//   _bapp, усна, гър_,
  { {0x7e7e0de0,0x6b840de1,0x7a480023,0x00000000}},	//   _capp, dvig, nītē,
  { {0xccfb0138,0x7e7e0de2,0x7eb0004b,0x00000000}},	//   ећа_, _dapp, _täpn,
  { {0x61f50058,0x61f80de3,0x00000000,0x00000000}},	//   üzle, _izvl,   ,
  { {0x5a350581,0x6bd40021,0x68fb002b,0x00000000}},	// [10f0] инат, متكر, _rhud,
  { {0x68e90de4,0x68fb00e5,0x20040066,0x00000000}},	//   _sked, _shud, ýmie_,
  { {0xb815000a,0x7dd200ea,0x2d9e04aa,0x00000000}},	//   адеј, rűsé, øtet_,
  { {0x7e7e0de5,0xf77108aa,0xddc70a80,0x00000000}},	//   _zapp, قات_, cejš,
  { {0x7c2d076b,0x4e190042,0xcc5603c3,0x00000000}},	//   mbar, _दलाई_, _דברי_,
  { {0x6b67001c,0x63a90b88,0x7c2d0de6,0x00000000}},	//   rīgā, vyen, lbar,
  { {0x5e580047,0x68fb001f,0x7d0f00ea,0x00000000}},	//   טיגע_, _thud, _kics,
  { {0x63bb0199,0x58d50086,0x68e900d1,0x00000000}},	//   tzun, _тобт, _uked,
  { {0x7c2d00ac,0x63bb004d,0x657a0de7,0x00000000}},	//   ibar, uzun, _esth,
  { {0x63bb00bd,0x79820051,0xd2a90121,0x00000000}},	//   rzun, łowe, ткое_,
  { {0x3f890089,0x7c2d0de8,0x63a906ed,0x00000000}},	//   _arau_, kbar, syen,
  { {0x7c2d0051,0x7e7e0de9,0xd59a0063,0x00000000}},	//   jbar, _sapp, _בבעל,
  { {0x442d0dea,0xddc703f5,0x7e7e0deb,0x00000000}},	//   mbe_, vejš, _papp,
  { {0x7c2d0089,0x7d0f0025,0x6b840290,0x00000000}},	//   ebar, _aics, vvig,
  { {0x3f89000c,0x3c4200ea,0xddc70dec,0x00000000}},	//   _erau_, _lévő_, tejš,
  { {0xed570079,0x3f890ded,0x7c2d0dee,0x00000000}},	//   јот_, _frau_, gbar,
  { {0xddc70def,0x3f890df0,0x442d004d,0x00000000}},	// [1100] rejš, _grau_, ibe_,
  { {0x62810886,0x7c2d0df1,0x6b840df2,0x00000000}},	//   ndlo, abar, rvig,
  { {0x3af50076,0x2d8502ea,0x442d00ea,0x00000000}},	//   сятс, ålet_, kbe_,
  { {0x387f003d,0x442d0df3,0x6e3c0df4,0x00000000}},	//   _caur_, jbe_, larb,
  { {0x442d01a6,0xdddc00ea,0xf7170021,0x00000000}},	//   dbe_, merő, لينغ_,
  { {0x6b8b0146,0xdb04000f,0x442d0df5,0x00000000}},	//   ægge, rzió, ebe_,
  { {0x3856005a,0x6281002b,0x7d040df6,0x00000000}},	//   _възс, ddlo, omis,
  { {0x6d410025,0x48e3013c,0x442d013d,0x00000000}},	//   álai, _досв, gbe_,
  { {0x9ae90086,0x6d4e004d,0x2b4000e5,0x00000000}},	//   нiше_, hrba, nsic_,
  { {0x7d040df7,0x29180df8,0x6d410df9,0x00000000}},	//   hmis, _kura_, šlai,
  { {0x442d02f6,0xf42600fe,0x6e3c0dfa,0x00000000}},	//   bbe_, ääsi_, darb,
  { {0x38660dfb,0x649c0268,0x29180dfc,0x00000000}},	//   nfor_, _néix, _mura_,
  { {0x7d040dfd,0xdfdb005a,0x6e3c0dfe,0x00000000}},	//   dmis, тън_, farb,
  { {0x6e3c0dff,0x7d040e00,0x752a0244,0x00000000}},	//   garb, emis, opfz,
  { {0x7d0f0123,0x42fb0063,0x51930021,0x00000000}},	//   _pics, _שהוס, _ولهذ,
  { {0xdddc000f,0x6e3c0179,0xc035018e,0x00000000}},	//   gerő, aarb, _униј,
  { {0x5c07005a,0x2fcf00c7,0x29180e01,0x00000000}},	// [1110] рява, _ägg_, _aura_,
  { {0x9be4000d,0xe9870001,0x29180e02,0x00000000}},	//   ціск, ићен, _bura_,
  { {0x442d0e03,0x29180741,0x7c2d0e04,0x00000000}},	//   ybe_, _cura_, pbar,
  { {0x7c950021,0x29180e05,0x6d550e06,0x00000000}},	//   _الحص, _dura_, muza,
  { {0x7bd801f7,0x6281002b,0x442d0e07,0x00000000}},	//   şvur, ydlo, vbe_,
  { {0x36c40054,0xdbdd013d,0x7a40004c,0x00000000}},	//   обіг, jáér, rátí,
  { {0x20d20024,0x27fa0051,0x442d0e08,0x00000000}},	//   lšie_, ępna_, tbe_,
  { {0x442d0e09,0x9dd80063,0xadd80063,0x00000000}},	//   ube_, יווק_, יווח_,
  { {0x7c22006d,0x442d0e0a,0x20d20066,0x00000000}},	//   ñori, rbe_, nšie_,
  { {0x7d0402e2,0x3f840014,0x6d550e0b,0x00000000}},	//   zmis, æmum_, kuza,
  { {0x20d20024,0xd298000d,0x7d040e0c,0x00000000}},	//   hšie_, ртыі_, ymis,
  { {0x6d5500be,0xdcfc003b,0xcea903c3,0x00000000}},	//   duza, ivră, _אי_,
  { {0x20d2034d,0xd308008b,0xb606008f,0x00000000}},	//   jšie_, _tệp_, rkšņ,
  { {0x6d55000c,0x249f007a,0xed5a0e0d,0x00000000}},	//   fuza, ljum_, лог_,
  { {0x7d040004,0x6e3c0e0e,0xb4f90047,0x00000000}},	//   tmis, rarb, ָפּי,
  { {0x3a3800cd,0xa01b0058,0x7d04078c,0x00000000}},	//   _serp_, ldön, umis,
  { {0x29180035,0x22470089,0x6a160021,0x00000000}},	// [1120] _sura_, _kdnk_, مبار,
  { {0x3f8f0016,0x29180e0f,0x249f004b,0x00000000}},	//   _água_, _pura_, hjum_,
  { {0x249f0026,0x5d860021,0x2b400e10,0x00000000}},	//   kjum_, _الجل, ssic_,
  { {0x20d20066,0xe73d011b,0x98c5045b,0x00000000}},	//   bšie_, aříž, осіл,
  { {0x386602ab,0xdd8f007e,0x69d9004d,0x00000000}},	//   rfor_, _قوی_, ßwer,
  { {0x66e30086,0xb05b004d,0x38660e11,0x00000000}},	//   поча, chäf, sfor_,
  { {0xceb30063,0x249f0014,0xa56a00de,0x00000000}},	//   היג_, fjum_, اصتك_,
  { {0x249f0026,0x65b20046,0xd5370044,0x00000000}},	//   gjum_, eðhö, حثوا_,
  { {0xdbdd013d,0x5c5b0041,0x3636005d,0x00000000}},	//   táér, װדיק, _هراس,
  { {0x2561000f,0xafdb01e1,0xa01b013d,0x00000000}},	//   ból_, naøe, gdön,
  { {0xf09f0268,0x76480185,0x6a9b0047,0x00000000}},	//   tjà_, _iddy, אשינ,
  { {0xdbdd00ea,0x26ce002b,0x44200075,0x00000000}},	//   sáér, lifo_, _üi_,
  { {0x2ca00150,0x33f603eb,0x2e4b0062,0x00000000}},	//   djid_, _اساس, ляво_,
  { {0x20d20024,0xd1300021,0x3d950e12,0x00000000}},	//   všie_, _قمت_, оигр,
  { {0x7e7500c2,0x82630044,0x212600de,0x00000000}},	//   rezp, _رهين, _اعتُ,
  { {0x853b00b5,0x8cf50726,0x20d20066,0x00000000}},	//   טגלי, ізац, tšie_,
  { {0xab870062,0xab940054,0x5b1401a4,0x00000000}},	// [1130] щувк, питі, змут,
  { {0x20d20024,0x7055007e,0x249f0022,0x00000000}},	//   ršie_, _انکا, zjum_,
  { {0x249f0014,0xb05b00a5,0xceb2089e,0x00000000}},	//   yjum_, rhäf, _חיי_,
  { {0x20d20024,0x76480185,0xb05b0072,0x00000000}},	//   pšie_, _addy, miäs,
  { {0xb05b00fe,0x46a5005a,0x7528008f,0x00000000}},	//   liäs, жалв, _atdz,
  { {0x79820051,0x256107c2,0x7f3c0047,0x00000000}},	//   łowa, tól_, נעוו,
  { {0x249f0026,0x04590021,0x6592005e,0x00000000}},	//   tjum_, للغة_, дају,
  { {0x2561000f,0xc32503d6,0x44390025,0x00000000}},	//   ról_, омик, ús_,
  { {0x249f0026,0xd2990086,0x00000000,0x00000000}},	//   rjum_, атні_,   ,
  { {0x02c5019d,0x63a60137,0x68eb0e13,0x00000000}},	//   ійно, äkna, logd,
  { {0xd4e7019d,0x21690e14,0x2bd00053,0x00000000}},	//   _люди, шини_, _सेना,
  { {0xd00a0062,0x629c00a5,0x439501f6,0x00000000}},	//   иене_, öror, _маес,
  { {0x443f0185,0xb4e50053,0x10a30062,0x00000000}},	//   mau_, पकी_, фиян,
  { {0xdcb1001b,0x67290035,0x443f0e15,0x00000000}},	//   ển_, _mtej, lau_,
  { {0xa1560001,0x2d8c0066,0x386d0e16,0x00000000}},	//   _дају_, íde_, _ober_,
  { {0x443f0e17,0x645b0e18,0x62830e19,0x00000000}},	//   nau_, ngui, _hano,
  { {0x645b0e1a,0x62830e1b,0x7eb000fe,0x00000000}},	// [1140] igui, _kano, _läpi,
  { {0x386d0199,0x2ca00974,0x443f0e1c,0x00000000}},	//   _aber_, sjid_, hau_,
  { {0x6d41000f,0xb05b0137,0x443f07ff,0x00000000}},	//   álat, miär, kau_,
  { {0xb05b0e1d,0x186a0e1e,0x872a000d,0x00000000}},	//   chäd, ради_, аўка_,
  { {0x443f0c70,0x27e001f7,0x47330086,0x00000000}},	//   dau_, çin_, дніс,
  { {0x9f61000f,0x645b0e1f,0xe6660054,0x00000000}},	//   ését_, egui, ітло,
  { {0x443f001f,0x26ce001f,0x7c2400b2,0x00000000}},	//   fau_, rifo_, ocir,
  { {0x443f0185,0x62830dac,0x7c240e20,0x00000000}},	//   gau_, _aano, ncir,
  { {0x62830e21,0x6d4801c8,0xdc8b009a,0x00000000}},	//   _bano, ádaj, בְיָ,
  { {0x62830e22,0x764800b9,0x78a20e23,0x00000000}},	//   _cano, _uddy, ljov,
  { {0xe29a001b,0x81c60076,0xa1940002,0x00000000}},	//   _chưa_, ющие, чанч,
  { {0x443f0e24,0xb05b0072,0xb97b009a,0x00000000}},	//   cau_, viäs, בנטי,
  { {0x3f8d00cd,0x64400e25,0x62830e26,0x00000000}},	//   íeu_, mami, _fano,
  { {0x7c260146,0x62830e27,0xb05b0072,0x00000000}},	//   _afkr, _gano, tiäs,
  { {0x9c830e28,0xeca70dd5,0x31c30062,0x00000000}},	//   íčov, ојан, _осъв,
  { {0x4c940076,0x6aaa00bd,0xac940200,0x00000000}},	//   мисс, öffn, масш,
  { {0xa01b0137,0xd108007e,0xdfd10049,0x00000000}},	// [1150] ndöm, _بقيه_, _سيد_,
  { {0x6d41000f,0xba980086,0x64400e29,0x00000000}},	//   álas, овує_, hami,
  { {0xceb200b7,0xe2a6007a,0x67290080,0x00000000}},	//   _ניט_, _áður_, _stej,
  { {0x5d7a0e2a,0xdcef0078,0xdbdd013d,0x00000000}},	//   _פארק, _įdėj, láír,
  { {0x386d004d,0x64400e2b,0x20d20066,0x00000000}},	//   _vber_, dami, nšia_,
  { {0x443f001f,0xcf580063,0xb7d20021,0x00000000}},	//   wau_, קבות_, عقوب,
  { {0x7c3d0150,0x644f017d,0x60cd0e2c,0x00000000}},	//   _kesr, ócio, _omam,
  { {0x64400e2d,0x6283024a,0xb4e50161,0x00000000}},	//   gami, _sano, पके_,
  { {0x443f0185,0x7c3d0228,0x20d20024,0x00000000}},	//   rau_, _mesr, jšia_,
  { {0x44260185,0x78a90173,0x60cd0e2e,0x00000000}},	//   _efo_, _hoev, _amam,
  { {0x64400019,0x443f0e2f,0x62830e30,0x00000000}},	//   bami, pau_, _vano,
  { {0x64400e31,0x628300ca,0x7c3d0e32,0x00000000}},	//   cami, _wano, _nesr,
  { {0x628300bb,0xa2950086,0xdd0c0051,0x00000000}},	//   _tano, _наді, różn,
  { {0x78bb02dd,0xe29a008b,0x78a90e33,0x00000000}},	//   _lluv, _thưa_, _loev,
  { {0x6da60e34,0xb05b0504,0x61ee01d1,0x00000000}},	//   чива, riär, čilé,
  { {0x61fc01f7,0x8b260076,0x443d00e5,0x00000000}},	//   ürle, здае, _jew_,
  { {0x305b0063,0x905b0063,0x7c3d0e35,0x00000000}},	// [1160] _הדפד, _הכפת, _desr,
  { {0x7c240e36,0x09e60c45,0x64400e37,0x00000000}},	//   scir, позн, zami,
  { {0xe9da0001,0xfbc90063,0x3c450078,0x00000000}},	//   љке_, נת_, _būvį_,
  { {0x443d0e38,0x7eab0019,0xb4e50053,0x00000000}},	//   _new_, _hüpp, पको_,
  { {0x64400e39,0x945d0022,0x28bd0042,0x00000000}},	//   vami, hińs, ्फ़ि,
  { {0xab27011c,0xd94600d7,0x78bb0019,0x00000000}},	//   _хора_, _неги, _eluv,
  { {0x6440010e,0x78bb0e3a,0x3ea5013d,0x00000000}},	//   tami, _fluv, ölti_,
  { {0x89db0063,0x64400150,0xd4c3014b,0x00000000}},	//   _החלי, uami, есьп,
  { {0x64400e3b,0xe737070a,0x8cc10053,0x00000000}},	//   rami, _нет_, रोटो,
  { {0x64400e3c,0xa01b0137,0x20d20066,0x00000000}},	//   sami, rdöm, všia_,
  { {0x443d0037,0xdbdd00ea,0x395a0e3d,0x00000000}},	//   _few_, váír, nups_,
  { {0x69c10019,0xdfd5000d,0x98ba0078,0x00000000}},	//   _ülee, домы, rupė_,
  { {0xdcb1001b,0x2d8c00b9,0xb465005d,0x00000000}},	//   ểm_, æden_, _آدمه,
  { {0x20d20066,0x945d0022,0x7bc4056c,0x00000000}},	//   ršia_, bińs, dziu,
  { {0x7eb00019,0x945d0051,0x6e3e0150,0x00000000}},	//   _näpu, cińs, _depb,
  { {0x20d20024,0x60cd005f,0x41db009a,0x00000000}},	//   pšia_, _umam, _לחוס,
  { {0x9f54000d,0x2bc70053,0xfbd301fb,0x00000000}},	// [1170] _звыч, _रेखा, رتر_,
  { {0x7b090117,0x62880e3e,0x78a90d1e,0x00000000}},	//   _ažur, nddo, _soev,
  { {0x2d8c0e3f,0x2d9e0137,0x60dd0e40,0x00000000}},	//   ådet_, ätet_, onsm,
  { {0x18690086,0x60dd0e41,0x315707e9,0x00000000}},	//   іали_, nnsm, ליבן_,
  { {0x62980179,0x9be40086,0x3ebe0078,0x00000000}},	//   _onvo, _зірк, šytų_,
  { {0x6d550e42,0x6d47056c,0x00000000,0x00000000}},	//   orza, osja,   ,
  { {0x78a90a53,0x58d50086,0xb925007e,0x00000000}},	//   _toev, _жовт, _آفري,
  { {0x6288001f,0x6d480025,0xcd9803c3,0x00000000}},	//   eddo, ádai, לדות_,
  { {0x27ff005b,0x62880d27,0x6d55004d,0x00000000}},	//   _uzun_, fddo, hrza,
  { {0x6d470019,0x25e80053,0x6288002b,0x00000000}},	//   ksja, _चुकी_, gddo,
  { {0x6d550051,0x76430e43,0x35f5000d,0x00000000}},	//   jrza, many, _ўпер,
  { {0x644b010a,0x6d55017f,0x62980e44,0x00000000}},	//   _udgi, drza, _envo,
  { {0x6d47006f,0x7d1e007d,0x945d0022,0x00000000}},	//   esja, _sups, sińs,
  { {0x76430e45,0x945d0022,0xad3a0054,0x00000000}},	//   nany, pińs, жчає_,
  { {0x6d470e46,0xf2e6005d,0x6d41013d,0x00000000}},	//   gsja, _تکيه_, álap,
  { {0x7643014f,0xc1060c0a,0x00000000,0x00000000}},	//   hany, _توبي,   ,
  { {0x6d470019,0x76430e47,0xcb670e48,0x00000000}},	// [1180] asja, kany, мате_,
  { {0x0f570063,0x76430e49,0x6d550022,0x00000000}},	//   _קיים_, jany, brza,
  { {0xa967005a,0x76430e4a,0x7e7c0e4b,0x00000000}},	//   диха_, dany, merp,
  { {0x395a0e4c,0x6d5c0e4d,0x0c26000d,0x00000000}},	//   rups_, mura, _імгн,
  { {0x76430009,0x62880185,0xb9060161,0x00000000}},	//   fany, yddo, _पद_,
  { {0x07a30856,0x7e7c0e4e,0x76430e4f,0x00000000}},	//   таљн, nerp, gany,
  { {0x6d5c0e50,0xf9830e51,0x7e7c0e52,0x00000000}},	//   nura, _игро, ierp,
  { {0x2ebb0235,0x764300a4,0x7e7c06aa,0x00000000}},	//   _उत्त, aany, herp,
  { {0x76430e53,0x7e7c03fb,0x6d5c0e54,0x00000000}},	//   bany, kerp, hura,
  { {0xd250006a,0xeb9100b5,0xcb9b0047,0x00000000}},	//   دند_, אָט_, קסיט,
  { {0x62880185,0x6d5c053b,0xf1aa007e,0x00000000}},	//   rddo, jura, زاده_,
  { {0x04930021,0x6d5c0e55,0xe5e7005d,0x00000000}},	//   _للمح, dura, _غزلی,
  { {0x6d5c024a,0x7c3600b9,0xef640062,0x00000000}},	//   eura, dbyr, къро,
  { {0x7e7c0e56,0xdcfe0080,0x629800bd,0x00000000}},	//   gerp, _trpě, _unvo,
  { {0x6d5c0e57,0x9f9900ca,0xd0d50094,0x00000000}},	//   gura, _dáár_, _покъ,
  { {0x20c20139,0x76430e58,0x6d470e59,0x00000000}},	//   _cóid_, zany, rsja,
  { {0x2d8c0e5a,0x2d9e0199,0x3f85003d,0x00000000}},	// [1190] åder_, äter_, ālus_,
  { {0x6d5c0e5b,0x7e7c00e5,0x69c50206,0x00000000}},	//   bura, cerp, tzhe,
  { {0x644f000f,0xe0df01f4,0x6d5c0e5c,0x00000000}},	//   ócik, onò_, cura,
  { {0x2bd00161,0x76430e5d,0x2bcb0001,0x00000000}},	//   _सेवा, wany, _дуго_,
  { {0x76430397,0xf388008b,0x36d50e5e,0x00000000}},	//   tany, _nợ_, нодр,
  { {0x764300cd,0xddde007d,0x7d0d0e5f,0x00000000}},	//   uany, _hapš, lmas,
  { {0x76430e60,0x6d480078,0xc6a40062,0x00000000}},	//   rany, šdav, ърци,
  { {0x7d0d01f7,0x7643076b,0x9fa000ac,0x00000000}},	//   nmas, sany, _wéér_,
  { {0x76430e61,0x6d5c0e62,0x7d0d0e63,0x00000000}},	//   pany, zura, imas,
  { {0x13060055,0x6d5c0859,0x7d0d0e64,0x00000000}},	//   нный_, yura, hmas,
  { {0xe1f9000d,0xd12e007e,0x7d0d04b3,0x00000000}},	//   яго_, یمی_, kmas,
  { {0xe0df051e,0xf9920e2a,0x3cfb0053,0x00000000}},	//   gnò_, ארט_, ्षों_,
  { {0x76410078,0x7e7c0897,0x7d0d0e65,0x00000000}},	//   _kely, terp, dmas,
  { {0x3ebe0026,0x7d0d027a,0x83fd00ea,0x00000000}},	//   ótt_, emas, ggőe,
  { {0xc5f200b5,0x224500c2,0x76410e66,0x00000000}},	//   ָדן_, malk_, _mely,
  { {0x6d5c0e67,0x7eb0004d,0x7d0d0e68,0x00000000}},	//   rura, _päps, gmas,
  { {0x245a005b,0x7e7c0e69,0x207b0041,0x00000000}},	// [11a0] lümü_, perp, _זאפא,
  { {0xb05b0c38,0x6d5c0e6a,0xea870e6b,0x00000000}},	//   nhän, pura, нбул_,
  { {0xcee9006a,0x6d5c0150,0x245a005b,0x00000000}},	//   _ترين_, qura, nümü_,
  { {0x7eb00004,0x645c013d,0xe8f6005d,0x00000000}},	//   _täps, őriz, رساخ,
  { {0x20d200c2,0x76410e6c,0x22450e6d,0x00000000}},	//   jšim_, _bely, kalk_,
  { {0x7641002b,0xf388008d,0x46a30085,0x00000000}},	//   _cely, _rợ_, лачв,
  { {0xceb30063,0xf388008b,0x7641001f,0x00000000}},	//   ריו_, _sợ_, _dely,
  { {0x69c10019,0x7521006d,0xdce80078,0x00000000}},	//   _ülea, _dulz, ėlėt,
  { {0x7641002b,0xb05b004d,0x8c1b0063,0x00000000}},	//   _fely, fhän, הופי,
  { {0x76410e6e,0xf388008b,0x7d0d0e6f,0x00000000}},	//   _gely, _vợ_, zmas,
  { {0x83fd00ea,0x25a1004d,0x7d0d0e70,0x00000000}},	//   ggőb, ählt_, ymas,
  { {0x254c0080,0x20d200a8,0x61f8004c,0x00000000}},	//   měl_, bšim_, _vyvl,
  { {0x224504c6,0xb05b00bd,0xe0df051e,0x00000000}},	//   balk_, bhän, rnò_,
  { {0x245a0058,0x7f5d0003,0x539b009f,0x00000000}},	//   bümü_, rusq, _מידו,
  { {0x3f840014,0x7d0d0e71,0x254c004c,0x00000000}},	//   æmur_, tmas, něl_,
  { {0xccf80001,0x7d0d0e72,0x628a002b,0x00000000}},	//   ећу_, umas, _hafo,
  { {0x7d0d0e73,0x3ea5013d,0x7e2b0e74,0x00000000}},	// [11b0] rmas, ölts_, _ніна_,
  { {0x7d0d0a68,0x7e65004d,0x2b490003,0x00000000}},	//   smas, _uchp, rsac_,
  { {0x7d0d005b,0x764100e5,0x2b490e75,0x00000000}},	//   pmas, _rely, ssac_,
  { {0x254c0080,0x628a0558,0x7641056b,0x00000000}},	//   děl_, _lafo, _sely,
  { {0x81bc001c,0x245a0058,0x76410e76,0x00000000}},	//   ucēj, zümü_, _pely,
  { {0x81bc008f,0x20d2007d,0x2ca9065e,0x00000000}},	//   rcēj, všim_, ljad_,
  { {0xb5c20086,0x2f0400a5,0x81bc008f,0x00000000}},	//   ийшл, nöga_, scēj,
  { {0x69cc0024,0x64420025,0x3af40137,0x00000000}},	//   ôlež, _ceoi, läpp_,
  { {0x9998000c,0xe3b10021,0x13090156,0x00000000}},	//   _terţ_, شرة_, мний_,
  { {0x628a0185,0x7eb00659,0x20d200c2,0x00000000}},	//   _cafo, _näpp, ršim_,
  { {0xd702000d,0x628a002b,0xb05b0e77,0x00000000}},	//   _лiта, _dafo, rhän,
  { {0x245a005b,0x290f00a4,0xe3b0007e,0x00000000}},	//   rümü_, nmga_, _گرم_,
  { {0xb05b01bb,0x22450e78,0x22950021,0x00000000}},	//   mhäl, palk_, _للإس,
  { {0x628a0185,0x79820045,0xe3b0007e,0x00000000}},	//   _gafo, łowi, _درم_,
  { {0xbea3018e,0xb05b00bd,0x248d0e79,0x00000000}},	//   шарк, chäo, odem_,
  { {0x248d0e7a,0xb05b0e7b,0x1d070094,0x00000000}},	//   ndem_, nhäl, веси_,
  { {0x8fa606da,0x248d004c,0x00000000,0x00000000}},	// [11c0] _рапе, idem_,   ,
  { {0x248d004d,0x63a60137,0x3ced08ed,0x00000000}},	//   hdem_, äkni, čeva_,
  { {0x19b9000d,0xae570063,0x7d0a005e,0x00000000}},	//   нуць_, _בסיס_, _оног_,
  { {0x248d03f5,0x79950051,0x290f00a4,0x00000000}},	//   jdem_, _drzw, gmga_,
  { {0x248d001f,0x7995004d,0x60dd0e7c,0x00000000}},	//   ddem_, _erzw, érmi,
  { {0x254c0080,0x64420025,0x645c0078,0x00000000}},	//   těl_, _seoi, ėrim,
  { {0xa01b00ea,0xd9430121,0xb05b004d,0x00000000}},	//   ldöt, _веси, fhäl,
  { {0x628a0185,0xb86601fb,0xd467005e,0x00000000}},	//   _safo, _جاسو, виће_,
  { {0x2c6d000f,0xaa820026,0xd3a3000d,0x00000000}},	//   lódó_, _þýsk, арэп,
  { {0x254c004c,0x68e20e7d,0xe737012c,0x00000000}},	//   pěl_, lnod, _реф_,
  { {0x64420e7e,0xe3af005d,0x9f4f0046,0x00000000}},	//   _teoi, مری_, _ágú_,
  { {0xd5d90047,0xe3ba0175,0x68e20e7f,0x00000000}},	//   _אַנש, _обе_, nnod,
  { {0xe703001b,0x68e20e80,0x628a002b,0x00000000}},	//   _hướ, inod, _tafo,
  { {0x7a48001c,0x11d60021,0x9f340054,0x00000000}},	//   nūtē, _لتعد, рері,
  { {0x2ca90019,0xb05b0137,0x20d20130,0x00000000}},	//   tjad_, lhäm, kših_,
  { {0x20d200c3,0xa263008d,0x68e200a8,0x00000000}},	//   jših_, _luồ, jnod,
  { {0x3a750076,0x68e20512,0x2ca903b0,0x00000000}},	// [11d0] ллар, dnod, rjad_,
  { {0x2ca9004b,0x6a34005e,0x5a340e81,0x00000000}},	//   sjad_, инуђ, инут,
  { {0x68e20185,0x68e302dd,0xe703008b,0x00000000}},	//   fnod, éndo, _nướ,
  { {0xc864005e,0x236d0022,0x0cd40e82,0x00000000}},	//   атљи, ytej_, _воюю,
  { {0xdcb1001b,0x20c2017d,0xe9ff0013,0x00000000}},	//   ểu_, _jóia_, _trắc_,
  { {0xe703001b,0x20d202e2,0xda34000d,0x00000000}},	//   _bướ, aših_, _веры,
  { {0xb05b00bd,0x4519042c,0x248d00bd,0x00000000}},	//   thäl, нция_, tdem_,
  { {0xe703001b,0x05760021,0x7c2d0e83,0x00000000}},	//   _dướ, امية_, ncar,
  { {0xb05b00bd,0x7d1d0e84,0x248d0e85,0x00000000}},	//   rhäl, _miss, rdem_,
  { {0x7c2d00e5,0x27e00139,0xa01b0072,0x00000000}},	//   hcar, úine_, hdös,
  { {0x291e03b2,0x01650076,0x9259007e,0x00000000}},	//   _état_, ыкно, وشگر_,
  { {0x7d1d0e86,0x2f040026,0x6b8400ac,0x00000000}},	//   _niss, gögn_, ywig,
  { {0xe28e0e87,0xddc7013d,0x442d0e88,0x00000000}},	//   _ла_, dejű, mce_,
  { {0x7c2d003e,0x64490025,0x442d0e89,0x00000000}},	//   ecar, laei, lce_,
  { {0x62810529,0x5de6005a,0x68e2001f,0x00000000}},	//   melo, ужва, ynod,
  { {0x62810e8a,0x442d0e8b,0x27e90022,0x00000000}},	//   lelo, nce_, żany_,
  { {0x69030019,0x7d1d0e8c,0x442d0e8d,0x00000000}},	// [11e0] tõen, _diss, ice_,
  { {0x26c700c3,0xee3a000d,0xdd04005b,0x00000000}},	//   jhno_, _яно_, ırır,
  { {0x68e204c6,0x442d0080,0x2d9602a9,0x00000000}},	//   tnod, kce_, _српс,
  { {0x7c2d0e8e,0xdca60e8f,0xccfa0086,0x00000000}},	//   ccar, _сами, _їхні_,
  { {0x62810e90,0x60c40035,0x442d0e91,0x00000000}},	//   kelo, _mlim, dce_,
  { {0xaf770047,0x62810e92,0x60c400cd,0x00000000}},	//   רעסס_, jelo, _llim,
  { {0x62810e93,0x60c40e94,0x6d4e0246,0x00000000}},	//   delo, _olim, nsba,
  { {0x6f1e0051,0x290700cd,0x44980121,0x00000000}},	//   _lipc, ïnat_, твию_,
  { {0xb4e40235,0x6d5c004d,0x6906008f,0x00000000}},	//   _नदी_, hrra, ārdē,
  { {0x3866001f,0x62810e95,0x0377007e,0x00000000}},	//   lgor_, gelo, احيت_,
  { {0x764a0014,0x442d0e96,0x7c2d0e97,0x00000000}},	//   mafy, bce_, ycar,
  { {0x442d051e,0x38660e98,0x6d4e02c0,0x00000000}},	//   cce_, ngor_, dsba,
  { {0x2d9e02f0,0x62810e99,0x6d5c0e9a,0x00000000}},	//   åten_, belo, erra,
  { {0x7d1d0004,0x3866001f,0x60c40e9b,0x00000000}},	//   _siss, hgor_, _elim,
  { {0x7c2d02b0,0xd130007e,0x7d1d0e9c,0x00000000}},	//   tcar, _بمب_, _piss,
  { {0xd1380006,0xed580066,0xf0470121,0x00000000}},	//   mpą_, áľa_, _сэко,
  { {0x7c2d0e9d,0xafdb00b9,0x6d5c0e9e,0x00000000}},	// [11f0] rcar, dbøg, arra,
  { {0x6e670001,0x442d0e9f,0x7d1d0ea0,0x00000000}},	//   _стиж, zce_, _wiss,
  { {0x60c400fe,0xaae80086,0x7d1d0ea1,0x00000000}},	//   _ylim, уєте_, _tiss,
  { {0x69c10019,0x7f5d0164,0x38660137,0x00000000}},	//   _ülem, orsq, ggor_,
  { {0x64490ea2,0x07a50793,0x442d0ea3,0x00000000}},	//   vaei, ралн, vce_,
  { {0x0555005a,0x442d0051,0x62810ea4,0x00000000}},	//   атия, wce_, xelo,
  { {0x442d03a4,0x6281008a,0x64a50121,0x00000000}},	//   tce_, velo, иака,
  { {0x9479005e,0xed64004a,0x47350cdf,0x00000000}},	//   тску_, leží_, _внас,
  { {0x62810ea5,0x442d0ea6,0x56670049,0x00000000}},	//   telo, rce_, _مداف,
  { {0x6d5c0ea7,0x442d0ea8,0x60c40ea9,0x00000000}},	//   yrra, sce_, _slim,
  { {0x68e900d1,0x62810eaa,0x42060062,0x00000000}},	//   _kjed, relo, иньо_,
  { {0x65630016,0x272b00b9,0x62810eab,0x00000000}},	//   munh, _køn_, selo,
  { {0x20c20139,0x62810eac,0x65630ead,0x00000000}},	//   _fóin_, pelo, lunh,
  { {0x6d4e021f,0xed5a0138,0x272b00b9,0x00000000}},	//   tsba, ког_, _møn_,
  { {0x272b00b9,0x68fb005b,0x66c60014,0x00000000}},	//   _løn_, _okud, _uðke,
  { {0xdcfc017f,0x60c40035,0x224709fe,0x00000000}},	//   tvrđ, _ulim, _henk_,
  { {0x69c10019,0x1eca0001,0x3f8c001c,0x00000000}},	// [1200] _ülej, _алпи_, ādus_,
  { {0x63a90268,0x68e9006d,0x19960001,0x00000000}},	//   ixen, _ajed, ијер,
  { {0x7bcd008f,0xae5b009a,0x0e5b009a,0x00000000}},	//   azau, _בכיר, _בדיב,
  { {0x26c5051e,0x272b01e1,0xe73a0eae,0x00000000}},	//   _allo_, _bøn_, вед_,
  { {0x1634005a,0xf1ba0013,0x290d04aa,0x00000000}},	//   беля, _ngơn_, _dhea_,
  { {0xafdb0146,0x68e900b9,0x290701a8,0x00000000}},	//   sbøg, _ejed, ïnar_,
  { {0x20d20024,0x09fa0021,0x3866002b,0x00000000}},	//   lšiu_, _شفرة_, pgor_,
  { {0x44220031,0x26c502dd,0xd4970076,0x00000000}},	//   øk_, _ello_, арь_,
  { {0x20d20066,0x82a60eaf,0xdc89009a,0x00000000}},	//   nšiu_, ашне, רְצָ,
  { {0x291f0529,0x9f4f0003,0xb273014c,0x00000000}},	//   _ziua_, _âgé_, ольш,
  { {0x63bb002c,0x21630086,0x6563017d,0x00000000}},	//   ayun, отяг, cunh,
  { {0xddc50080,0xd1380078,0x26dc0eb0,0x00000000}},	//   _schů, rpą_, livo_,
  { {0x7648034d,0xa2940088,0x20d20024,0x00000000}},	//   _kedy, _галі, jšiu_,
  { {0x76480045,0x7b1000bd,0x26dc0066,0x00000000}},	//   _jedy, läuf, nivo_,
  { {0xdddc0eb1,0xc5340063,0xec6b0002,0x00000000}},	//   adrž, מָּה_, крак_,
  { {0xc05b019d,0x26dc02dd,0x76480eb2,0x00000000}},	//   _рік_, hivo_, _ledy,
  { {0x75280045,0x2bba0051,0x60dd0eb3,0x00000000}},	// [1210] _ludz, jącą_, mism,
  { {0x69c10019,0x68e90755,0x26dc02e2,0x00000000}},	//   _ülek, _sjed, jivo_,
  { {0xc8ab005a,0x272b05dd,0x2d8c00b9,0x00000000}},	//   къде_, _søn_, ædet_,
  { {0xf7710032,0x60dd0eb4,0x2cad004b,0x00000000}},	//   كات_, nism, _õed_,
  { {0x2bde0053,0x7648002b,0x7528008f,0x00000000}},	//   _नेपा, _bedy, _audz,
  { {0x656304aa,0x75280eb5,0x60dd0eb6,0x00000000}},	//   tunh, _budz, hism,
  { {0x68e9017f,0xcb120063,0x2247005b,0x00000000}},	//   _tjed, _מלך_, _renk_,
  { {0x68e90eb7,0x60dd0331,0x20d2004c,0x00000000}},	//   _ujed, jism, nšit_,
  { {0x60dd0eb8,0x27ff0058,0x764800f1,0x00000000}},	//   dism, _uyun_, _fedy,
  { {0x6563017d,0xfbd20063,0x26dc0d6f,0x00000000}},	//   punh, פתי_, civo_,
  { {0x63bb002c,0x20c20025,0x60dd0eb9,0x00000000}},	//   syun, _fóil_, fism,
  { {0x224700e8,0x397a014e,0x297a0e2a,0x00000000}},	//   _wenk_, נטרנ, נטרא,
  { {0x660100fe,0x443f0eba,0x22470ebb,0x00000000}},	//   _hylk, mbu_, _tenk_,
  { {0x20d20066,0x7d18013d,0x24180054,0x00000000}},	//   všiu_, _évsz, _тією_,
  { {0x7196006a,0xdca60ebc,0x2d95090f,0x00000000}},	//   _هنوز_, бави, ортс,
  { {0x386d0089,0x60dd0ebd,0x9c260002,0x00000000}},	//   _ncer_, cism, сдад,
  { {0x443f0ebe,0x1d070794,0x2d84004c,0x00000000}},	// [1220] ibu_, сети_, ňme_,
  { {0x386d0ebf,0x20d20066,0x8e860021,0x00000000}},	//   _acer_, ršiu_, _الده,
  { {0x91fc008f,0x499a0766,0x7648056c,0x00000000}},	//   egāj, ытая_, _redy,
  { {0x20d20024,0x61fc004d,0x443f007c,0x00000000}},	//   pšiu_, ürli, jbu_,
  { {0x26dc0ec0,0x4b55005a,0x67210ec1,0x00000000}},	//   tivo_, _мърт, _bilj,
  { {0x672106bb,0x386d00e3,0x7d040ec2,0x00000000}},	//   _cilj, _ecer_, llis,
  { {0x26dc0ec3,0xb05b0ec4,0x7d040ec5,0x00000000}},	//   rivo_, mhäv, olis,
  { {0x7648001f,0x39570063,0x2d980ec6,0x00000000}},	//   _wedy, _לשלם_, ivre_,
  { {0x47c6000a,0x7d040ec7,0x60dd0ec8,0x00000000}},	//   _убав, ilis, vism,
  { {0x66010ec9,0x52d80086,0x7d040eca,0x00000000}},	//   _fylk, рмою_, hlis,
  { {0x8afb0149,0x7d040ecb,0x60dd0ecc,0x00000000}},	//   רהיי, klis, tism,
  { {0xef260058,0x60dd006c,0xe0190054,0x00000000}},	//   ğüne_, uism, ижні_,
  { {0x6d5a0024,0x833a0076,0x44260c12,0x00000000}},	//   átan, _счет_, _igo_,
  { {0x60dd0ecd,0x7d160024,0x7d040ece,0x00000000}},	//   sism, emys, elis,
  { {0x6d5a0ecf,0xb6bb0063,0x60dd0ed0,0x00000000}},	//   štan, נצלי, pism,
  { {0xd904006a,0x7d040ed1,0x69c1004b,0x00000000}},	//   _سی_, glis, _ülei,
  { {0x2d8c0146,0x88bd0051,0x5c070ed2,0x00000000}},	// [1230] æder_, _liśc, сява,
  { {0x2d980ed3,0x61ff013d,0x443f073e,0x00000000}},	//   bvre_, _ízlé, zbu_,
  { {0x20d20080,0x7d040ed4,0x3ebe0ed5,0x00000000}},	//   pšit_, blis, ötte_,
  { {0x44260ed6,0x67210ed7,0xdddc00dd,0x00000000}},	//   _ngo_, _silj, serţ,
  { {0x6729006d,0xdddc003b,0x68f900e5,0x00000000}},	//   _quej, perţ, rowd,
  { {0xe80f0053,0x98aa001c,0xe0df01f4,0x00000000}},	//   ़ेगा_, ājām_, hiò_,
  { {0x443f0512,0x0319007e,0x67210ed8,0x00000000}},	//   tbu_, یتخت_, _vilj,
  { {0xe5760085,0x00000000,0x00000000,0x00000000}},	//   ізы_,   ,   ,
  { {0x7b1000bd,0xe0df0290,0xb05b004d,0x00000000}},	//   bäud, diò_, nhäu,
  { {0x66010045,0x799c002b,0x798e002b,0x00000000}},	//   _tylk, _yrrw, _ysbw,
  { {0xdddc0ed9,0x7d040eda,0x7b10004d,0x00000000}},	//   kerš, ylis, säug,
  { {0xe0df0290,0xb05b0072,0xcea900ff,0x00000000}},	//   giò_, tkäa, _בי_,
  { {0x7d040058,0x644b005f,0xc2c50044,0x00000000}},	//   vlis, _iegi, _ويصي,
  { {0x61450edb,0x31650124,0x7f750085,0x00000000}},	//   _дека, pulz_, чуюц,
  { {0x7e23000a,0x644b014f,0x2d980edc,0x00000000}},	//   ддрж, _kegi, uvre_,
  { {0xe0df0290,0x691100b9,0xb05b01e9,0x00000000}},	//   ciò_, nåed, lkän,
  { {0x7d04018d,0x8b26019d,0xeb970edd,0x00000000}},	// [1240] rlis, ідже, оит_,
  { {0xda660021,0xb05b0ede,0x7d16004c,0x00000000}},	//   تاري, nkän, smys,
  { {0x64590045,0x7d040edf,0xe9da0001,0x00000000}},	//   _odwi, plis, јке_,
  { {0xa8a30095,0xb17a0047,0xa17a0047,0x00000000}},	//   дршк, יטער, יטעט,
  { {0xb05b01bb,0x16340ee0,0x4733005d,0x00000000}},	//   phäv, пеля, وروز,
  { {0xe0df051e,0xd7f90086,0x8f9b0ee1,0x00000000}},	//   ziò_, щує_, ייני,
  { {0xb05b01e3,0x2bde0053,0xe5a30001,0x00000000}},	//   dkän, _नेता, дији,
  { {0x644b0ee2,0x64400ee3,0x5454066f,0x00000000}},	//   _cegi, ubmi, чвит,
  { {0xe0df0290,0x644b0ee4,0xa6e60ee5,0x00000000}},	//   viò_, _degi, _джал,
  { {0x3ce00019,0x442600ac,0xa2a70053,0x00000000}},	//   hiiv_, _wgo_, फ़ॉल्,
  { {0x2730008b,0x644b00cd,0xe1340766,0x00000000}},	//   _hàn_, _fegi, янны,
  { {0x44260ee6,0xa346000d,0x6ab70053,0x00000000}},	//   _ugo_, _дэкл, _आक्र,
  { {0x69c10019,0x6d5a0ee7,0x3947013d,0x00000000}},	//   _ülev, štal, ánsz_,
  { {0x2005003d,0x2730008b,0xdefb026c,0x00000000}},	//   āli_, _màn_, рым_,
  { {0x2730008b,0x62880dd1,0x853c0078,0x00000000}},	//   _làn_, medo, _drėg,
  { {0x5ce70086,0x27300013,0x62880ee8,0x00000000}},	//   іюва, _oàn_, ledo,
  { {0x27300013,0x60c00ee9,0x10170044,0x00000000}},	// [1250] _nàn_, ömme, _ببغد,
  { {0x501c0063,0x7f84007e,0xb05b004d,0x00000000}},	//   _דוחו, _کلین, rhäu,
  { {0xdc3f0a63,0x62880eea,0xb05b004d,0x00000000}},	//   líčk, iedo, shäu,
  { {0x2730008b,0xb05b00bd,0xb17b0047,0x00000000}},	//   _bàn_, chät, שטאר,
  { {0x6d55000f,0x644b0eeb,0x27300013,0x00000000}},	//   lsza, _regi, _càn_,
  { {0x62880743,0x853c0006,0x644b0bad,0x00000000}},	//   jedo, _orėd, _segi,
  { {0x62880eec,0x645d0006,0x6e350051,0x00000000}},	//   dedo, ųsim, iczb,
  { {0x28f80086,0x628800ca,0x6d550740,0x00000000}},	//   _десь_, eedo, isza,
  { {0xf41f00fe,0x6b8d0b06,0x644b0eed,0x00000000}},	//   ää_, nwag, _vegi,
  { {0x62880eee,0xeb920063,0xb5950456,0x00000000}},	//   gedo, תָה_, _низш,
  { {0x644b0eef,0xb05b01e9,0x6b8d0206,0x00000000}},	//   _tegi, rkän, hwag,
  { {0xb05b0137,0x69c1004b,0xef260058,0x00000000}},	//   skän, _üleu, şüme_,
  { {0x2004007a,0xb05b0137,0x21b8007e,0x00000000}},	//   æmi_, mkäl, مپیک_,
  { {0x6d5a0ef0,0x539a07e9,0x141a0041,0x00000000}},	//   štam, _לינו, _פוסב,
  { {0x2d9e016b,0x6d5500ea,0x76430089,0x00000000}},	//   íte_, gsza, ibny,
  { {0x6b8d0917,0x91ba0063,0xb05b0ef1,0x00000000}},	//   fwag, _למצי, nkäl,
  { {0x6b8d0ef2,0xb05b0072,0xab6602e1,0x00000000}},	// [1260] gwag, ikäl, явал,
  { {0x0e660055,0x3f92002c,0xff24007e,0x00000000}},	//   _экон, _isyu_, _تبعی,
  { {0xdebb0063,0x3ebb0063,0x27300013,0x00000000}},	//   _המיל, _הציב, _sàn_,
  { {0xeb9f000e,0x186a0ef3,0x6b8d0244,0x00000000}},	//   _frø_, сади_, bwag,
  { {0x47330086,0xfc3f006d,0x6563004d,0x00000000}},	//   еніс, _unía_, ernh,
  { {0x99640080,0x29060019,0x628801a8,0x00000000}},	//   může_, sloa_, xedo,
  { {0x673b0072,0xf1c2008d,0x62880ef4,0x00000000}},	//   _etuj, _chở_, vedo,
  { {0x62880185,0x77620cfc,0x2730008b,0x00000000}},	//   wedo, prox, _tàn_,
  { {0x2f040014,0x62880ef5,0x6d550022,0x00000000}},	//   lögu_, tedo, zsza,
  { {0x7afe0ef6,0x68e2001f,0x86ea0021,0x00000000}},	//   nopt, liod, _اعرف_,
  { {0x6d5a0117,0x69c10019,0x6a9b0047,0x00000000}},	//   štaj, _ület, זשינ,
  { {0x62880ef7,0xeafa0053,0x68e20a8d,0x00000000}},	//   sedo, ्तुत_, niod,
  { {0x04430b3f,0xa4b70063,0x98a7007d,0x00000000}},	//   _чечн, _מלאה_, šići_,
  { {0x68e2001f,0x0eeb0200,0x6d550ef8,0x00000000}},	//   hiod, сьми_, tsza,
  { {0x7afe0ef9,0x68eb002b,0xdcfe004c,0x00000000}},	//   dopt, yngd, _uspě,
  { {0x6d550efa,0x6b8d0d13,0x27f20051,0x00000000}},	//   rsza, twag, żyny_,
  { {0x6d5503e8,0x68e20efb,0x9a87007b,0x00000000}},	// [1270] ssza, diod, зуел,
  { {0x6b8d0007,0xb05b004d,0x88bd0022,0x00000000}},	//   rwag, chär, _ciśn,
  { {0xc1780006,0xceb20047,0x6b8d0efc,0x00000000}},	//   ntė_, _סיט_, swag,
  { {0x2ee3006f,0xa3cc0053,0x26cc0efd,0x00000000}},	//   lijf_, रना_, _aldo_,
  { {0x69d80026,0x2058009f,0x7afe0efe,0x00000000}},	//   úver, ליאל_, bopt,
  { {0x60cd0eff,0x2557003b,0x7b10004d,0x00000000}},	//   _llam, tăl_, räuc,
  { {0x60cd005b,0xf6500049,0xb05b0f00,0x00000000}},	//   _olam, ائه_, tkäl,
  { {0x2ee30122,0xe8940088,0x68e2000c,0x00000000}},	//   hijf_, _пась, ciod,
  { {0xc1780006,0xd702000d,0xd3be0121,0x00000000}},	//   etė_, _кiра, а́ть,
  { {0x66cf076c,0x69c10004,0x78bb0f01,0x00000000}},	//   _bøke, _üles, _houv,
  { {0x60cd0034,0x208a005a,0xf78b0058,0x00000000}},	//   _blam, ойни_, şçı_,
  { {0xafe6019d,0xd00a000a,0x5558000d,0x00000000}},	//   домл, жеме_, _хаця_,
  { {0x78bb0164,0x92b50021,0x3438005d,0x00000000}},	//   _mouv, _يحتا, _رسند_,
  { {0x60cd0019,0x78bb0f02,0xa01b00a5,0x00000000}},	//   _elam, _louv, dföd,
  { {0x78a9006f,0x60cd0136,0xb05b0ae2,0x00000000}},	//   _onev, _flam, rhär,
  { {0x78bb03b2,0x60cd0f03,0x7c85005e,0x00000000}},	//   _nouv, _glam, нуђе,
  { {0xa2d40053,0x3207002b,0x7afe0f04,0x00000000}},	// [1280] योक्, _hyny_, topt,
  { {0x273b000c,0x68e20051,0x78a900dd,0x00000000}},	//   _mână_, wiod, _anev,
  { {0xdce9005b,0x2d9c00ea,0x2241004b,0x00000000}},	//   _çoğu, _éve_, _õhku_,
  { {0x78bb0164,0x7afe0f05,0x5883066e,0x00000000}},	//   _couv, sopt, выша,
  { {0x78a906bb,0xba56005a,0x69030019,0x00000000}},	//   _dnev, _отвъ, võet,
  { {0x46a30062,0x68e20f06,0x78a90f07,0x00000000}},	//   качв, siod, _enev,
  { {0x68e20674,0x78660044,0xf600014b,0x00000000}},	//   piod, _يدرك, ымкi_,
  { {0x78bb0f08,0x6abc0014,0x78a90130,0x00000000}},	//   _gouv, _horf, _gnev,
  { {0x66cf0d96,0x69c10019,0x128a0062,0x00000000}},	//   _søke, _üler, ощни_,
  { {0x60cd0f09,0xc17a0086,0xf7430f0a,0x00000000}},	//   _slam, оїм_, _рефо,
  { {0x6abc0f0b,0xa2d40042,0x60cd0f0c,0x00000000}},	//   _morf, योग्, _plam,
  { {0xc1780006,0xe4a50086,0xd4c60021,0x00000000}},	//   rtė_, _пріо, _تغطي,
  { {0xc1780006,0x60cd006f,0x60c00137,0x00000000}},	//   stė_, _vlam, ömma,
  { {0x32070185,0xd3b70086,0x63a20f0d,0x00000000}},	//   _fyny_, _юлії_, _iron,
  { {0x2ee3006f,0x27fa0051,0x12fb0063,0x00000000}},	//   rijf_, ępny_, _והגב,
  { {0x629a0438,0x6ee9017f,0x62980d11,0x00000000}},	//   ldto, džbe, _havo,
  { {0x660801f2,0x629a01e1,0x62980078,0x00000000}},	// [1290] _lydk, odto, _kavo,
  { {0x2904002c,0x6abc001f,0x78bb0f0e,0x00000000}},	//   _akma_, _corf, _souv,
  { {0x78bb03b2,0x25de024c,0x2d9e00c7,0x00000000}},	//   _pouv, _केली_, åtet_,
  { {0x629802f6,0x20090150,0xa01b0137,0x00000000}},	//   _lavo, _kyai_, pföd,
  { {0x6abc0f0f,0x21290089,0x57480085,0x00000000}},	//   _forf, _miah_, дзім_,
  { {0x6abc0185,0x66cf0031,0x62980f10,0x00000000}},	//   _gorf, _søkb, _navo,
  { {0xd5b1002a,0x63a20f11,0x66360044,0x00000000}},	//   افع_, _aron, ركيس_,
  { {0x273b0529,0xb9250021,0x78a900e5,0x00000000}},	//   _până_, _أفري, _unev,
  { {0x63a20f12,0x13e90086,0x20090150,0x00000000}},	//   _cron, ямий_, _nyai_,
  { {0x7dee00ea,0x63a20109,0x99980078,0x00000000}},	//   nősé, _dron, _gerų_,
  { {0x629800bd,0x63a20f13,0xafdb05a5,0x00000000}},	//   _davo, _eron, sbøl,
  { {0x0ef80053,0xe0d2007e,0xea000013,0x00000000}},	//   ंक्स_, ازد_, hiếu_,
  { {0xafdb00b9,0x63a20f14,0x62980f15,0x00000000}},	//   lbøj, _gron, _favo,
  { {0x62980006,0x248d0f16,0xe3b0007e,0x00000000}},	//   _gavo, leem_, _خرم_,
  { {0xddc10086,0x3f4d0f17,0x1d160131,0x00000000}},	//   аттi_, ažu_, еќар,
  { {0x248d00e8,0x91fc001c,0x62980f18,0x00000000}},	//   neem_, rgāt, _zavo,
  { {0xc4d20047,0x6abc0f19,0x4c350085,0x00000000}},	// [12a0] אגן_, _porf, тэст,
  { {0x19f6018e,0x89f6000d,0x88bd0022,0x00000000}},	//   нџер, няец, _wiśl,
  { {0xa84a0021,0x91fc008f,0x6abc0f1a,0x00000000}},	//   كلام_, lgār, _vorf,
  { {0xa2a1024c,0x7ae500fe,0x00000000,0x00000000}},	//   _कोस्, aiht,   ,
  { {0x66080f1b,0x66e60f1c,0x91fc008f,0x00000000}},	//   _sydk, нода, ngār,
  { {0x69c500ac,0xb05b0072,0xda650044,0x00000000}},	//   byhe, tkäk, _لافي,
  { {0x67280117,0x69c1004b,0xf52607ed,0x00000000}},	//   _vidj, _ülep, нфин,
  { {0x62980f1d,0x63a20f1e,0x67280150,0x00000000}},	//   _savo, _pron, _widj,
  { {0x62980f1f,0xe3b20593,0x53e60085,0x00000000}},	//   _pavo, ارع_, эцка,
  { {0x629a00b9,0x63a20f20,0xeb91009a,0x00000000}},	//   udto, _vron, בָט_,
  { {0x63a20f21,0x64a6000d,0x21670002,0x00000000}},	//   _wron, _пажа, ниќи_,
  { {0x63a200aa,0x7dee013d,0x34560044,0x00000000}},	//   _tron, zősé, _أنشأ,
  { {0x09dd0235,0x62980f22,0xbfa80cb5,0x00000000}},	//   _मध्य, _tavo, нтре_,
  { {0xb3e90021,0x79820051,0x61eb00ea,0x00000000}},	//   _تعمل_, łowy, állá,
  { {0x7ae500c2,0xe29b0149,0xa1940330,0x00000000}},	//   viht, _זשור, _райч,
  { {0xb05b00fe,0x2f1600b9,0x88bd0022,0x00000000}},	//   kkäi, væge_, _piśm,
  { {0x7dee000f,0xea670138,0x2d9e0a2e,0x00000000}},	// [12b0] tősé, ењен, åter_,
  { {0x63bd05dd,0x69110666,0x3a740121,0x00000000}},	//   øsni, gåen, ллур,
  { {0x1df90076,0x7ae5005b,0xafdb04aa,0x00000000}},	//   _цены_, riht, kbøk,
  { {0xf77108aa,0x7dee013d,0x7ae50bda,0x00000000}},	//   لات_, sősé, siht,
  { {0x257a00ac,0xafdb00d1,0x7d0d0f23,0x00000000}},	//   eël_, dbøk, mlas,
  { {0x7d0d0f24,0x67d202f8,0x9f38009a,0x00000000}},	//   llas, рољу, תנגד_,
  { {0x6d5a017f,0x8aa4005a,0xa2a10053,0x00000000}},	//   štav, _сряд, _कोष्,
  { {0x4518000d,0x7d0d0f25,0x5925005d,0x00000000}},	//   нцыя_, nlas, _شکاف,
  { {0x83fd013d,0x7d0d0f26,0x07350f27,0x00000000}},	//   egőr, ilas, _резю,
  { {0x7d0d016b,0x3f85003b,0xc3c80021,0x00000000}},	//   hlas, ălul_, عظيم_,
  { {0x7d0d0f28,0x8602007e,0x63ad0f29,0x00000000}},	//   klas, _پژوه, _šand,
  { {0x3495018e,0xa2a10053,0xf9920063,0x00000000}},	//   _јадр, _कोर्, ברט_,
  { {0xf3670076,0x7d0d0f2a,0xe28e058f,0x00000000}},	//   _чтен, dlas, _ка_,
  { {0x601e0024,0x200c001c,0x7d0d0f2b,0x00000000}},	//   _rámč, ādi_, elas,
  { {0xfc3f0024,0x691100d1,0x7d0d05b2,0x00000000}},	//   _kníh_, våen, flas,
  { {0x7d0d0f2c,0x98b8001c,0x753c013d,0x00000000}},	//   glas, _otrā_, _érze,
  { {0x69110f2d,0x1d070f2e,0x64490f2f,0x00000000}},	// [12c0] tåen, тети_, ibei,
  { {0x4a430f30,0x7d0d021e,0x692c00dd,0x00000000}},	//   инув, alas, _aşea,
  { {0x442f0f31,0x7d0d0f32,0x27e90046,0x00000000}},	//   _ogg_, blas, úann_,
  { {0x7d0d0f33,0x6d5c0e77,0xf7460f34,0x00000000}},	//   clas, msra, ведо,
  { {0xe73706f0,0x09290021,0x7d040f35,0x00000000}},	//   веч_, رسمي_, mois,
  { {0x6d5a0066,0xa714000d,0x7d040f36,0x00000000}},	//   štau, ымлі, lois,
  { {0xafdb00d1,0xb05b004b,0x6d5c0f37,0x00000000}},	//   tbøk, skäi, nsra,
  { {0x69c300fe,0x7d040f38,0x60c0004d,0x00000000}},	//   änee, nois, ömml,
  { {0xb8d6016a,0x64a30635,0x62810f39,0x00000000}},	//   जा_, рања, fflo,
  { {0x02a6019d,0x442f03b1,0x7d0d0f3a,0x00000000}},	//   трим, _egg_, zlas,
  { {0x7d04024a,0xd48f037c,0xf484007e,0x00000000}},	//   kois, _кр_, _ماشی,
  { {0x7d0400fe,0x6d5c02e0,0x7c2b0078,0x00000000}},	//   jois, dsra, žgri,
  { {0xfbdf00e8,0x7d040f3b,0xc0e4000d,0x00000000}},	//   _leêr_, dois, роўк,
  { {0x76580009,0x645d0078,0x7f9402d8,0x00000000}},	//   navy, ųsit, јарх,
  { {0x2fcd0117,0x6d5c0f3c,0x7d0d0f3d,0x00000000}},	//   šeg_, gsra, tlas,
  { {0x8c3b00bd,0x656a0025,0x69110093,0x00000000}},	//   _maßg, irfh, gåel,
  { {0x5c07005a,0x7d0d0f3e,0x76580f3f,0x00000000}},	// [12d0] тява, rlas, kavy,
  { {0x7d0d0f40,0xf09f00cd,0x7b10004d,0x00000000}},	//   slas, ldà_, bäum,
  { {0x7d0d0f41,0x6f020139,0x7d040f42,0x00000000}},	//   plas, _íoca, bois,
  { {0x01350047,0xf09f00cd,0x71d7009d,0x00000000}},	//   אָסט_, ndà_, כובד_,
  { {0x9735006a,0x6d5a0f43,0x62810ac9,0x00000000}},	//   اکرا, štat, yflo,
  { {0x76580078,0xfc3f004c,0x2ed10042,0x00000000}},	//   gavy, _sníh_, _हतोत,
  { {0xceb400ff,0x05540085,0xa5090f44,0x00000000}},	//   ייס_, атыя, нека_,
  { {0x26190053,0x38a40699,0x8a18030b,0x00000000}},	//   येगी_, _кјуб, _росс_,
  { {0x64490f45,0xf7940088,0x27e00025,0x00000000}},	//   rbei, _катэ, úint_,
  { {0xf09f01a8,0x64490f46,0x6d5c0072,0x00000000}},	//   edà_, sbei, ysra,
  { {0xfad6014e,0x290f0ad5,0x27390013,0x00000000}},	//   רותך_, olga_, _hèn_,
  { {0x20c20025,0x27390013,0x3f6a0f47,0x00000000}},	//   _cóip_, _kèn_, нимо_,
  { {0xe3650086,0x7d040f48,0x249f0f49,0x00000000}},	//   _скли, vois, mdum_,
  { {0x249f007a,0x6d5c0f4a,0xe29609da,0x00000000}},	//   ldum_, tsra, _баш_,
  { {0x7d04024a,0x69110f4b,0x6d5c0527,0x00000000}},	//   tois, tåel, usra,
  { {0x6d5c003d,0x7b1000bd,0x249f0f4c,0x00000000}},	//   rsra, räum, ndum_,
  { {0xcb670184,0x6d5c0f4d,0x2d850058,0x00000000}},	// [12e0] лате_, ssra, çler_,
  { {0x66cf0031,0x7d0400fe,0x6d5c0f4e,0x00000000}},	//   _søkn, sois, psra,
  { {0x38cb005d,0x7d040f4f,0x98a60f50,0x00000000}},	//   کالی_, pois, лиже,
  { {0x237f0051,0x27390013,0x28df0042,0x00000000}},	//   ktuj_, _bèn_, पोलि,
  { {0x4b55005a,0x76580f51,0x249f0014,0x00000000}},	//   _въст, tavy, ddum_,
  { {0x3b0a0076,0x4e7a00b5,0xb8cb0053,0x00000000}},	//   _чего_, גאַצ, _को_,
  { {0x45d40ac5,0x2ca0004b,0xf5200085,0x00000000}},	//   ройс, odid_, онкi_,
  { {0x2ca00f52,0x76580006,0x28090066,0x00000000}},	//   ndid_, savy, ätný_,
  { {0x765800eb,0xe6460f53,0x18670062,0x00000000}},	//   pavy, _безп, _щати_,
  { {0x63ad004a,0x4b7b0047,0xa01b0014,0x00000000}},	//   _šanc, עטיג, ffön,
  { {0x7f440089,0x5ab70047,0xe57a0054,0x00000000}},	//   _atiq, אליע_, _їзд_,
  { {0x2ca00089,0x1074071f,0x853b009a,0x00000000}},	//   jdid_, блюю, _נגדי,
  { {0xf09f0268,0x2ca0002b,0x9f350054,0x00000000}},	//   rdà_, ddid_, регі,
  { {0x539b0063,0x66cf00d1,0x8c3b004d,0x00000000}},	//   _ניוו, _nøkl, _maße,
  { {0x7f440f54,0x56370047,0xbdd401d5,0x00000000}},	//   _etiq, ראלע_, борщ,
  { {0x2bd9005d,0x361b009d,0x00000000,0x00000000}},	//   پارک_, תולד,   ,
  { {0xba550095,0x6d470026,0x4a550f55,0x00000000}},	// [12f0] ивај, spja, икас,
  { {0xb05b00bd,0x2ca0004b,0x27390013,0x00000000}},	//   rkäu, adid_, _rèn_,
  { {0x6d5a0024,0x38350071,0xe8590085,0x00000000}},	//   štar, анер, ваеш_,
  { {0x237f0045,0x5c070062,0x7a32013d,0x00000000}},	//   ytuj_, _бяга, tűtí,
  { {0x0a6b0459,0xb05b00fe,0xe72e0376,0x00000000}},	//   _први_, lkäs, же_,
  { {0x0f58009f,0xe7360f56,0xff580041,0x00000000}},	//   ניום_, шеш_, נבוך_,
  { {0xa5640032,0xb05b0b58,0x3ebe0f57,0x00000000}},	//   مدين, nkäs, ötti_,
  { {0x91f5008b,0x38600139,0x33650160,0x00000000}},	//   hác, óirt_, авиг,
  { {0x249f0f58,0xc603008f,0xd7fb0f59,0x00000000}},	//   rdum_, dzēš_, _чув_,
  { {0x68eb0122,0x6d450025,0xa01b0026,0x00000000}},	//   ligd, _otha, tfön,
  { {0x25b901fb,0x237f0022,0x0477005d,0x00000000}},	//   _جهاد_, stuj_, _ملاک_,
  { {0x68eb0173,0xa01b0137,0x61ee0025,0x00000000}},	//   nigd, rfön, úbla,
  { {0x443f0f5a,0xa01b0626,0x6d450f5b,0x00000000}},	//   mcu_, sfön, _atha,
  { {0x443f0f5c,0x71a50085,0x50d6005d,0x00000000}},	//   lcu_, _вакз, ازگر,
  { {0x1c3a0088,0x91e20612,0xa01b00ea,0x00000000}},	//   вязь_, _моше, lföl,
  { {0x645b004d,0x443f0f5d,0x236d00c2,0x00000000}},	//   naui, ncu_, orej_,
  { {0x2ca00019,0xdcb7008b,0x68eb0f5e,0x00000000}},	// [1300] rdid_, ởng_, digd,
  { {0xc3320063,0xb05b004b,0xe5e5004c,0x00000000}},	//   קוב_, skät, íměř,
  { {0x2d9a02f7,0x8c3b004d,0x89f50085,0x00000000}},	//   _uspe_, _saße, бяцц,
  { {0x270e0161,0x76410f5f,0x6d3b0149,0x00000000}},	//   ित्र_, _afly, _שײכו,
  { {0x443f0f60,0xa01b013d,0x60c40022,0x00000000}},	//   dcu_, jföl, _moim,
  { {0xa01b0137,0x316b0051,0x60c40072,0x00000000}},	//   dföl, ńczy_, _loim,
  { {0x3f85003b,0xd6da007e,0x60d60f61,0x00000000}},	//   ălui_, _یورش_, _olym,
  { {0x399b00b5,0x3864032c,0x499b0063,0x00000000}},	//   _בילד, _udmr_, _בשלב,
  { {0x96960054,0x78a200a8,0x8696005e,0x00000000}},	//   _вреш, mdov, _вјеч,
  { {0x78a20f62,0xdce70051,0xf2c60f63,0x00000000}},	//   ldov, mują, рсин,
  { {0xaa370047,0x2178000d,0x3a370132,0x00000000}},	//   יטיק_, ыйны_, ירים_,
  { {0xd4f5000d,0xd4670f64,0x60c40f65,0x00000000}},	//   _лячы, _вице_, _coim,
  { {0xdce70051,0x68e300cd,0x60c40f66,0x00000000}},	//   nują, èndi, _doim,
  { {0x0eeb0065,0xb05b0072,0xa6f8009d,0x00000000}},	//   тьми_, tkäs, אִֽי,
  { {0xdef80088,0xeda40193,0x3f820f67,0x00000000}},	//   рыя_, ошто, atku_,
  { {0xdce70045,0x60d6001f,0x78a208c1,0x00000000}},	//   kują, _glym, jdov,
  { {0x78a20290,0x68eb0e04,0xb05b0f68,0x00000000}},	// [1310] ddov, vigd, skäs,
  { {0x6e950032,0x443f00c3,0xdce70051,0x00000000}},	//   _الدا, zcu_, dują,
  { {0x68eb016d,0xdb040003,0xa01b013d,0x00000000}},	//   tigd, iviè, zföl,
  { {0xdce7056c,0xa3c70082,0xcd340043,0x00000000}},	//   fują, _उथल_, _گریب,
  { {0x2d830f69,0xdce70051,0x443f0f6a,0x00000000}},	//   ltje_, gują, vcu_,
  { {0x68eb00ac,0x98bc008f,0x6723007d,0x00000000}},	//   sigd, īvā_, umnj,
  { {0x3ea10019,0x2d830f6b,0x443f0f6c,0x00000000}},	//   _maht_, ntje_, tcu_,
  { {0xfdf80f6d,0x66cf00b9,0x7bcd0003,0x00000000}},	//   ימוש_, _køkk, oyau,
  { {0x60c40027,0x290d0f6e,0xe3e9007e,0x00000000}},	//   _roim, _ikea_, دکان_,
  { {0x443f0f6f,0xa01b0f70,0xe299005e,0x00000000}},	//   scu_, rföl, ћан_,
  { {0x60c40f71,0xe3a5007e,0x66cf0093,0x00000000}},	//   _poim, _گشای, _løkk,
  { {0x236d0198,0xa01b0f72,0xfd1f008b,0x00000000}},	//   prej_, pföl, _nhì_,
  { {0x66cf0031,0x60c4024a,0x78fa0047,0x00000000}},	//   _nøkk, _voim, רפרו,
  { {0x68fb0f73,0x3f820f74,0xc3320063,0x00000000}},	//   _ljud, rtku_, _זוג_,
  { {0x68e900c7,0x60c40f75,0xdce70051,0x00000000}},	//   _omed, _toim, zują,
  { {0x64590034,0xb05b03c8,0xfd1f0013,0x00000000}},	//   _jewi, skär, _chì_,
  { {0x3f9e003d,0x2d83006f,0xdb04006d,0x00000000}},	// [1320] ātus_, atje_, lvié,
  { {0x68fb0f76,0x7e560001,0x68e90f77,0x00000000}},	//   _ajud, _утиц, _amed,
  { {0x68fb00c7,0x2722008b,0xdb040e1a,0x00000000}},	//   _bjud, _hưng_, nvié,
  { {0x64590185,0x291f0f78,0xdce70051,0x00000000}},	//   _newi, _chua_, tują,
  { {0x26c50024,0x96ea013c,0x78a20f79,0x00000000}},	//   _bolo_, лька_, rdov,
  { {0x96f8000a,0xdce70051,0xd7f90086,0x00000000}},	//   јект_, rują, шує_,
  { {0xdce70051,0x6b840f7a,0x27220013,0x00000000}},	//   sują, ltig, _lưng_,
  { {0x6b8400cd,0xdce70051,0xd4970121,0x00000000}},	//   otig, pują, брь_,
  { {0x64590185,0xd2500021,0xa5070001,0x00000000}},	//   _dewi, ونة_, љења_,
  { {0x6b840f7b,0xdb9b0047,0x68e900c2,0x00000000}},	//   itig, נסיר, _zmed,
  { {0x6b8405e4,0xf2020053,0xe4a60002,0x00000000}},	//   htig, _रुख़_, _грло,
  { {0x6b8402f0,0x64590f7c,0x27220013,0x00000000}},	//   ktig, _gewi, _bưng_,
  { {0xdfd8005a,0x2d8300ca,0x2722008d,0x00000000}},	//   бър_, wtje_, _cưng_,
  { {0x27220013,0x2d83013d,0xd9fa0042,0x00000000}},	//   _dưng_, ttje_, ्थात_,
  { {0x691802dd,0x6b840f7d,0xfd1f0013,0x00000000}},	//   víen, etig, _phì_,
  { {0x2d830f7e,0x5c070121,0x6b840f7f,0x00000000}},	//   rtje_, бяза, ftig,
  { {0x6b840f80,0x2d830907,0x692c0058,0x00000000}},	// [1330] gtig, stje_, _eşek,
  { {0x433b0047,0x63bd0137,0xfaa7005e,0x00000000}},	//   טעמב, äsni, љшан,
  { {0x753a0199,0xfd1f001b,0x7bcd00f3,0x00000000}},	//   _nutz, _thì_, syau,
  { {0x26c50f81,0xa8150001,0xdced0078,0x00000000}},	//   _solo_, одеш, _įkėl,
  { {0x660401f7,0x6c7a0047,0x765a06a3,0x00000000}},	//   şikl, _דארפ, _bety,
  { {0x2f5c009f,0x35c90f82,0x64590f83,0x00000000}},	//   נדונ, игло_, _sewi,
  { {0x26c5051e,0x64590051,0xddd50051,0x00000000}},	//   _volo_, _pewi, lazł,
  { {0x753a004d,0x6d5a0003,0x68e90f84,0x00000000}},	//   _dutz, âtai, _umed,
  { {0xdcfc001c,0x26c5017d,0x03a50f85,0x00000000}},	//   ntrā, _tolo_, ципо,
  { {0x765a006f,0xdddc00ea,0x1287007e,0x00000000}},	//   _gety, zerű, حمدی_,
  { {0x27220013,0xb05b0072,0x63a40f86,0x00000000}},	//   _sưng_, tkäp, _šint,
  { {0x7985001f,0x7b1000bd,0xa8790047,0x00000000}},	//   ithw, läut, סאָר,
  { {0xa3bb006a,0x940501fb,0xc50c0041,0x00000000}},	//   _حاضر_, _بوشه, _גלאָ,
  { {0x73040054,0x613e0023,0x63a90f87,0x00000000}},	//   _епіз, _gīlo, mven,
  { {0x63a90f88,0x6da305ef,0x69c30656,0x00000000}},	//   lven, мира, änel,
  { {0x63a90f89,0x60dd087d,0x6b840739,0x00000000}},	//   oven, chsm, ttig,
  { {0xab660086,0x6b8400bd,0x7985001f,0x00000000}},	// [1340] ювал, utig, ethw,
  { {0x6b840f8a,0x6023000d,0xaa160141,0x00000000}},	//   rtig, _ідэа, офеј,
  { {0x18a60612,0x6b840f8b,0x88e60121,0x00000000}},	//   жаем, stig, ожже,
  { {0x765a00a4,0x63a90f8c,0xe7aa0f8d,0x00000000}},	//   _sety, kven, ивел_,
  { {0x63a90122,0xd90d005d,0x765a056c,0x00000000}},	//   jven, ایق_, _pety,
  { {0x7d1600fe,0x2d8500cd,0x501b0063,0x00000000}},	//   llys, àleg_, בונו,
  { {0xd5470079,0x8c3b00bd,0xa9670e34,0x00000000}},	//   опје_, _maßn, _мира_,
  { {0x63a900b9,0x387f0139,0x7d160d1a,0x00000000}},	//   fven, _gcur_, nlys,
  { {0x63a9006f,0x7d160f8e,0x00000000,0x00000000}},	//   gven, ilys,   ,
  { {0x6f020025,0x7d16001f,0xc17401d5,0x00000000}},	//   _íoch, hlys, площ,
  { {0x63a90f8f,0x7b10004d,0x7d160f90,0x00000000}},	//   aven, läus, klys,
  { {0x63a90f91,0x4035082d,0x859b009a,0x00000000}},	//   bven, яемс, _כשבו,
  { {0x63a90529,0x6918006d,0x66cf04aa,0x00000000}},	//   cven, víel, _søki,
  { {0xe2970f92,0x7985001f,0xb0340085,0x00000000}},	//   _мач_, ythw, ьняш,
  { {0x7b1000bd,0x3ceb0002,0x99800066,0x00000000}},	//   häus, аќам_, eďže_,
  { {0x69c30546,0xdcee001c,0xdcb80505,0x00000000}},	//   änem, tubā, ощу_,
  { {0x28ab0053,0x7b100072,0xc104005d,0x00000000}},	// [1350] _घोषि, jäus, _تويي,
  { {0x42370047,0x7d160f93,0x69370130,0x00000000}},	//   ַנדל_, alys, _oćet,
  { {0xdcfc003d,0x3958001f,0xf3f9003b,0x00000000}},	//   strā, _cwrs_, iaţa_,
  { {0x23660117,0x63a90f94,0x6ee9007d,0x00000000}},	//   _ovoj_, yven, džbi,
  { {0xba770032,0x7d0d000c,0xf680004c,0x00000000}},	//   _واست, moas, ěžně_,
  { {0x63a90290,0x7d0d0f95,0x98aa004c,0x00000000}},	//   vven, loas, _kubě_,
  { {0x3958001f,0x7b100244,0x00000000,0x00000000}},	//   _gwrs_, räut,   ,
  { {0x63a906bb,0x7d0d0be3,0x75220f96,0x00000000}},	//   tven, noas, _choz,
  { {0x63a90164,0xf3f9003b,0x69370130,0x00000000}},	//   uven, faţa_, _ećet,
  { {0x396400fe,0x23660066,0x63a90f97,0x00000000}},	//   _ässä_, _dvoj_, rven,
  { {0x7d0d00fe,0x63a90f98,0xdcfc00dd,0x00000000}},	//   koas, sven, ntră,
  { {0x21060161,0x63a900e8,0x7d0d003b,0x00000000}},	//   रवेश_, pven, joas,
  { {0xe4560047,0x08760047,0x2055000d,0x00000000}},	//   _זינט_, הערט_, ьтэр,
  { {0x75290f99,0xb14502f8,0xb3080044,0x00000000}},	//   lmez, _енкл, _وغول_,
  { {0x412a0854,0xe1f60131,0x471a009d,0x00000000}},	//   _локо_, _нгш_, מושג,
  { {0x01360063,0xb05b00fe,0x75290058,0x00000000}},	//   _צרפת_, ljän, nmez,
  { {0xfc030f9a,0x98a4005f,0x7d160f9b,0x00000000}},	// [1360] епто, _gimę_, rlys,
  { {0x7d1600e8,0xb05b0137,0x7529004d,0x00000000}},	//   slys, njän, hmez,
  { {0x7d160f9c,0xbe3b0063,0x2d9c0003,0x00000000}},	//   plys, _לעית, _ève_,
  { {0x80bf0053,0x7b10004d,0x7d0d0f9d,0x00000000}},	//   षाये, täus, coas,
  { {0xdc3700b5,0xa01b0026,0x20ef004c,0x00000000}},	//   _מאכט_, rgög, dřil_,
  { {0x6594000d,0x7b10004d,0x66e301dd,0x00000000}},	//   даку, räus, ноча,
  { {0xceb30063,0x7aee00a4,0x23660648,0x00000000}},	//   תיו_, _imbt, _svoj_,
  { {0x68130051,0x98a30b3f,0xd37a06da,0x00000000}},	//   _będą, _писе, бчо_,
  { {0xd3b80054,0x363604a0,0x366a0129,0x00000000}},	//   ілої_, _فراس, _газо_,
  { {0x246c0013,0x51f80054,0x20050058,0x00000000}},	//   ớm_, жною_, şlik_,
  { {0x7aee0150,0xd2570085,0x21630094,0x00000000}},	//   _mmbt, чцы_, нтяг,
  { {0x6937017f,0xe53b0063,0x55bb0063,0x00000000}},	//   _kćer, _התאר, _למבו,
  { {0x7d0d0529,0xdfd80062,0xa3cd0053,0x00000000}},	//   voas, пър_, रहण_,
  { {0x63a20f9e,0x3d950f9f,0x57fb009a,0x00000000}},	//   _ison, мигр, מלכו,
  { {0x629a0fa0,0x7d0d0fa1,0x7e28014b,0x00000000}},	//   meto, toas, зіта_,
  { {0x7aee006f,0xfc3f017d,0x51fb0063,0x00000000}},	//   _ambt, _baía_, _להוצ,
  { {0x7d0d0fa2,0xfc3f0460,0xab94005e,0x00000000}},	// [1370] roas, _caía_, натљ,
  { {0x7529004c,0x7f4d00be,0x629a0fa3,0x00000000}},	//   zmez, _itaq, neto,
  { {0x629a0fa4,0x69da004b,0x3eb7005f,0x00000000}},	//   ieto, _ütel, četė_,
  { {0x3ce00080,0x63a20fa5,0x629a0fa6,0x00000000}},	//   chiv_, _oson, heto,
  { {0xdcfc000c,0xf09f008b,0x629a0fa7,0x00000000}},	//   stră, goài_, keto,
  { {0x7b10004d,0x2ca90fa8,0x629a0fa9,0x00000000}},	//   säur, ldad_, jeto,
  { {0x65920001,0x20ef004c,0x629a0faa,0x00000000}},	//   вају, třil_, deto,
  { {0x33d50086,0x2ca90fa8,0x443905e7,0x00000000}},	//   діот, ndad_, øs_,
  { {0xe7390185,0xb05b00c7,0x63a200ea,0x00000000}},	//   _grŵp_, tjän, _cson,
  { {0x290f0fab,0xe299005e,0x2ca9055f,0x00000000}},	//   loga_, цао_, hdad_,
  { {0x7f4d0fac,0x63a20fad,0xdb2400ea,0x00000000}},	//   _ataq, _eson, ésén,
  { {0x290f0fae,0x3cf90053,0xa988009a,0x00000000}},	//   noga_, ्कों_, הָשִ,
  { {0x2ca90137,0x629a0faf,0xdddc0023,0x00000000}},	//   ddad_, beto, pgrū,
  { {0x2ca9006d,0xb05b0072,0x853c0078,0x00000000}},	//   edad_, ljäl, _grės,
  { {0x386d0cd4,0x290f017f,0xfc3f017d,0x00000000}},	//   _oder_, koga_, _saía_,
  { {0x2ca90fb0,0xb05b0072,0x386d0fb1,0x00000000}},	//   gdad_, njäl, _nder_,
  { {0x394d00c2,0xcaca0085,0x3ce00605,0x00000000}},	// [1380] _česa_, огае_, rhiv_,
  { {0x89f60fb2,0x7d0900c2,0xb05b0137,0x00000000}},	//   وثائ, česa, hjäl,
  { {0x290f0140,0xbfa30013,0xdebb0063,0x00000000}},	//   foga_, hiể, _ומיל,
  { {0x69da00ea,0x38cb007e,0x61ee0e57,0x00000000}},	//   _ütem, يانی_, úbli,
  { {0x872a000d,0x98a4004c,0xab2a0854,0x00000000}},	//   оўка_, _zimě_, _мома_,
  { {0x47330086,0x386d0fb3,0x569302f8,0x00000000}},	//   вніс, _eder_, вашт,
  { {0x69d800b9,0xa96a06da,0xb05b0137,0x00000000}},	//   øved, _фиба_, fjäl,
  { {0x66cf0031,0x98a600c2,0x636a0fb4,0x00000000}},	//   _søkt, omoč_, орог_,
  { {0xd90d04de,0x629a0fb5,0x22490058,0x00000000}},	//   _این_, teto, _şaka_,
  { {0x6629013d,0xa823005d,0x68e20fb6,0x00000000}},	//   áskö, _شکنن, lhod,
  { {0x02a30088,0x386d01b0,0xe3af007e,0x00000000}},	//   трым, _yder_, هری_,
  { {0x754900ea,0x63a20fb7,0x62830fb8,0x00000000}},	//   őszö, _tson, _ecno,
  { {0x26cc0fb9,0x629a0fba,0x04430152,0x00000000}},	//   _kodo_, peto, _речн,
  { {0xe1ef006a,0x7ce30004,0x37d900b5,0x00000000}},	//   اسی_, _kõrg, פֿרע,
  { {0x9f34019d,0xdc3a01f7,0xc3270032,0x00000000}},	//   тері, _açık, _تكون_,
  { {0xe7ab0024,0x26cc0516,0x00000000,0x00000000}},	//   _ďaľš, _lodo_,   ,
  { {0x2ca90fbb,0x290f017f,0x386d00ac,0x00000000}},	// [1390] rdad_, voga_, _rder_,
  { {0x26cc0fbc,0xcf270049,0x7a540044,0x00000000}},	//   _nodo_, _تربي, نضما,
  { {0x7ce30019,0x63a0002b,0x290f0fbd,0x00000000}},	//   _nõrg, hwmn, toga_,
  { {0x26de0fbe,0xf8b10043,0x00000000,0x00000000}},	//   _alto_, دکس_,   ,
  { {0x26cc0fbf,0x290f0fc0,0xf7480044,0x00000000}},	//   _bodo_, roga_, وجوه_,
  { {0xdb0600b9,0x26cc006d,0x6f020139,0x00000000}},	//   _arkæ, _codo_, _íoct,
  { {0x66cf00d1,0x66f20022,0x04450af2,0x00000000}},	//   _søks, ałko, нейн,
  { {0x2f160fc1,0x27e60058,0x68e20fc2,0x00000000}},	//   lægt_, bzon_, chod,
  { {0xe3b10593,0xf7730593,0x58840085,0x00000000}},	//   ارب_, _جاز_, _шыра,
  { {0x16db0032,0xbfa30013,0xd5b1008d,0x00000000}},	//   _بذرة_, riể, _tŕ_,
  { {0x78a90019,0xb05b0527,0xcb120063,0x00000000}},	//   _kaev, lkäy, רלי_,
  { {0x98b8003d,0xe4540088,0x26c701b3,0x00000000}},	//   _kurā_, _акцы, ljno_,
  { {0x9522006a,0xb05b00fe,0x60cd000c,0x00000000}},	//   _حکوم, nkäy, _doam,
  { {0x78a90019,0x68e2016b,0x6da60fc3,0x00000000}},	//   _laev, zhod, нига,
  { {0x27e6000f,0x7bcb004d,0x60cd0fc4,0x00000000}},	//   zzon_, ägun, _foam,
  { {0xc06f0080,0x7693005b,0x64490fc5,0x00000000}},	//   íští, lıyı, ncei,
  { {0x628100c2,0x68e20240,0x6836005b,0x00000000}},	// [13a0] oglo, vhod, _müdü,
  { {0x62810fc6,0x76930058,0x09e60fc7,0x00000000}},	//   nglo, nıyı, нозн,
  { {0x26cc0006,0xae5b0063,0x984a0062,0x00000000}},	//   _rodo_, _מכיר, пяла_,
  { {0xa01b01e3,0x38600027,0x68e20080,0x00000000}},	//   mför, úir_, uhod,
  { {0x68e20fc8,0x26cc00a4,0xa01b0fc9,0x00000000}},	//   rhod, _podo_, lför,
  { {0x644b01b0,0x7ce3004b,0xb5a60456,0x00000000}},	//   _afgi, _põrg, ерий,
  { {0x68e2017f,0xa01b0502,0x26cc00c2,0x00000000}},	//   phod, nför, _vodo_,
  { {0x7ce30019,0xd37a000a,0xb05b0137,0x00000000}},	//   _võrg, пчо_, tjäm,
  { {0x26cc0fca,0x29040fcb,0xd467005e,0x00000000}},	//   _todo_, _ijma_, хиње_,
  { {0xa01b0137,0x026a0076,0xd2570054,0x00000000}},	//   kför, чший_, нцю_,
  { {0x7ce3004b,0x6d48011b,0x6611005d,0x00000000}},	//   _hõre, ídal, _پژوا,
  { {0xa01b00c7,0x644900cd,0x68360058,0x00000000}},	//   dför, ccei, _güdü,
  { {0xf8b30063,0xaf37007e,0x4e160042,0x00000000}},	//   אשר_, فرست, _दुबई_,
  { {0x661a00fe,0xdddc056c,0x00000000,0x00000000}},	//   _kytk, darł,   ,
  { {0x673a0994,0x6d5e001f,0x2f1600b9,0x00000000}},	//   _mitj, _cwpa, vægt_,
  { {0x51830fcc,0xa1830085,0x3e3400de,0x00000000}},	//   _суша, _сышл, افِر,
  { {0x2f1600b9,0xb05b00fe,0x78a9004b,0x00000000}},	// [13b0] tægt_, hjäk, _raev,
  { {0x3f640062,0x7c14012c,0x3e690043,0x00000000}},	//   _стъб, удує, _کجکی_,
  { {0x6d5e002b,0x78a9004e,0x00000000,0x00000000}},	//   _gwpa, _paev,   ,
  { {0x6ee20024,0x6d5500ca,0xf9900044,0x00000000}},	//   _vôbe, mpza, إبل_,
  { {0x7ce30004,0x98140088,0x317e00bd,0x00000000}},	//   _võrd, льшч, hutz_,
  { {0x26c700c2,0x6b8d0137,0xcf940149,0x00000000}},	//   ujno_, mtag, רטס_,
  { {0xceb4014e,0x6b8d0fcd,0x2729008b,0x00000000}},	//   טיס_, ltag, húng_,
  { {0xdb060d88,0x673a006f,0x94790fce,0x00000000}},	//   _erkä, _eitj, фску_,
  { {0x64490860,0xf5060062,0x14250062,0x00000000}},	//   rcei, ънъл_, ъдим,
  { {0x57f407b0,0xb05b004d,0x6b8d0fcf,0x00000000}},	//   _спут, ljäh, itag,
  { {0x0574006a,0x04950021,0x95570021,0x00000000}},	//   _ماند, _للاح, _أخطا,
  { {0x3f6a0fd0,0xb05b004d,0xa01b0137,0x00000000}},	//   мимо_, njäh, vför,
  { {0xefc70121,0xb05b004d,0xa8560063,0x00000000}},	//   влял_, ijäh, כירה_,
  { {0x6b8d010a,0xa01b01e3,0xe1f1006a,0x00000000}},	//   dtag, tför, _پست_,
  { {0x8d6302a9,0x92580021,0x213b0fd1,0x00000000}},	//   ивре, _أشهر_, _fiqh_,
  { {0xa01b0fd2,0xdddc0022,0xc339004c,0x00000000}},	//   rför, tarł, řídá,
  { {0xa01b0d88,0x6b8d0fd3,0xcb670713,0x00000000}},	// [13c0] sför, gtag, кате_,
  { {0xa01b00c7,0x7bc401a8,0xed460121,0x00000000}},	//   pför, rxiu, _иноп,
  { {0xa01b0026,0xef1f00ea,0xa9670062,0x00000000}},	//   ngön, ztük_, виха_,
  { {0xb05b004d,0xe874007e,0x6b8d0fd4,0x00000000}},	//   gjäh, انشگ, btag,
  { {0x2ca00019,0x27290024,0x673a0fd5,0x00000000}},	//   meid_, kúnd_, _pitj,
  { {0x2ca00fd6,0xc1780006,0x46f60062,0x00000000}},	//   leid_, yrė_, ъчет,
  { {0x442000eb,0x673a0fd7,0x8884007e,0x00000000}},	//   _ši_, _vitj, _میان,
  { {0xef1f00ea,0x2ca00019,0x44200013,0x00000000}},	//   ttük_, neid_, _ơi_,
  { {0xccf301d8,0x2b460025,0x656a0025,0x00000000}},	//   יכה_, íoch_, ssfh,
  { {0x2ca00102,0x21290fd8,0x2d9a01f2,0x00000000}},	//   heid_, _shah_, _oppe_,
  { {0x60f90fd9,0xf1a3005a,0x98b8003b,0x00000000}},	//   ення_, арян, _gură_,
  { {0x64a60141,0xdb040072,0x85f7009a,0x00000000}},	//   _јада, lviä, _בצבע_,
  { {0x99620080,0x2ca00019,0xf09f00cd,0x00000000}},	//   _níže_, deid_, reà_,
  { {0x2d47099a,0x2cab0fda,0x6b8d0a8c,0x00000000}},	//   _põe_, _sacd_, vtag,
  { {0x224e00a5,0xe297007b,0xc0cb01ce,0x00000000}},	//   _iffk_, _рај_, _жупе_,
  { {0x6b8d0fdb,0x5c7402b6,0xd5b8008f,0x00000000}},	//   ttag, илст, _azāk_,
  { {0xfc640062,0x6e460014,0xbab90fdc,0x00000000}},	// [13d0] ръсн, íubú, нгах_,
  { {0x7a400a63,0x6b8d0fdd,0xab940086,0x00000000}},	//   vští, rtag, рифі,
  { {0x6b8d0fde,0x2ca00fdf,0x99850021,0x00000000}},	//   stag, beid_, الصو,
  { {0x98ad0045,0xf7710fe0,0x25b90080,0x00000000}},	//   _mieć_, مات_, _čsl_,
  { {0xb05b004d,0x60dd0fe1,0x7a40004c,0x00000000}},	//   rjäh, iksm, uští,
  { {0xd6db0b0f,0x6f15006d,0x06840086,0x00000000}},	//   ьте_, nozc, игін,
  { {0x6d450004,0xf3f90529,0x29880fe2,0x00000000}},	//   _juha, maţi_, _исто_,
  { {0xf3f90529,0x60dd006f,0x6d450fe3,0x00000000}},	//   laţi_, jksm, _muha,
  { {0x42d5000d,0xe796007e,0xf495007e,0x00000000}},	//   гіну, _مالک, نشکد,
  { {0xdb0403d9,0xf3f90529,0x2fd90185,0x00000000}},	//   rviç, naţi_, dysg_,
  { {0xf3f9003b,0x442600ac,0x333c0fe4,0x00000000}},	//   iaţi_, _ezo_, _divx_,
  { {0xf1c30080,0x61fc0025,0xf4870d34,0x00000000}},	//   _alší_, úrla, _јужн,
  { {0xe2a8007e,0x2ca0004b,0x645b00ca,0x00000000}},	//   راین_, veid_, mbui,
  { {0x201e003d,0x6d450fe5,0xf3f9000c,0x00000000}},	//   āti_, _buha, jaţi_,
  { {0xe296005a,0xf3f9000c,0x2ca00fe6,0x00000000}},	//   _сащ_, daţi_, teid_,
  { {0x645b006f,0x61d60063,0x98b80078,0x00000000}},	//   nbui, _תוקף_, _kurą_,
  { {0xf3f9000c,0x2ca00fe7,0xeb2a0f8d,0x00000000}},	// [13e0] faţi_, reid_, ежал_,
  { {0x2ca00004,0xf3f90529,0x7641002b,0x00000000}},	//   seid_, gaţi_, _ngly,
  { {0x3f820fe8,0x2d9a0137,0x499a0085,0x00000000}},	//   luku_, _uppe_, этая_,
  { {0xa3e30053,0xb78a005e,0x7d7b00ff,0x00000000}},	//   नना_, ељке_, _אנטו,
  { {0xf3f9000c,0x7c26001c,0x3f820fe9,0x00000000}},	//   baţi_, _uzkr, nuku_,
  { {0xf3f90529,0x7d0400bd,0x645b0c8b,0x00000000}},	//   caţi_, lnis, ebui,
  { {0x7d040fea,0xdcfc00a8,0x44260feb,0x00000000}},	//   onis, hurč, _szo_,
  { {0x645b0dac,0x33740fec,0x7d040fed,0x00000000}},	//   gbui, агир, nnis,
  { {0xd70a026b,0x98ad0051,0x48060a25,0x00000000}},	//   _знае_, _sieć_, _спав,
  { {0x3f820035,0x7d040fee,0x92b600f2,0x00000000}},	//   duku_, hnis, احظا,
  { {0x7d040fef,0xe3b2007e,0x6f15004c,0x00000000}},	//   knis, _گرا_, vozc,
  { {0xf3f90529,0x2ba50053,0x0446032d,0x00000000}},	//   zaţi_, _ऑनला, _седн,
  { {0x6d450ff0,0x44260035,0x60dd0ff1,0x00000000}},	//   _suha, _uzo_, rksm,
  { {0xf3f9000c,0x6d450ff2,0x02a30062,0x00000000}},	//   xaţi_, _puha, _гръм,
  { {0xf3f90529,0x7d040ff3,0x78a20ff4,0x00000000}},	//   vaţi_, fnis, keov,
  { {0x4fd50086,0xd904007e,0x7d040ff5,0x00000000}},	//   _вжит, _ری_, gnis,
  { {0xf3f90529,0xdbc600bd,0x69d801f2,0x00000000}},	// [13f0] taţi_, röße, øven,
  { {0x6d450ff6,0xf3f9003b,0x7d040ff7,0x00000000}},	//   _tuha, uaţi_, anis,
  { {0x7d040199,0xf3f90529,0xad27005d,0x00000000}},	//   bnis, raţi_, _مرحو,
  { {0xf3f90529,0x78a20146,0x48390021,0x00000000}},	//   saţi_, geov, نكاح_,
  { {0xf3f9000c,0x0b8b0062,0x2d830ff8,0x00000000}},	//   paţi_, _ясни_, luje_,
  { {0x4b7a0047,0x645b00ca,0xe7330044,0x00000000}},	//   _באשו, wbui, حصص_,
  { {0x2d910ff9,0x645b0c5f,0x2d830ffa,0x00000000}},	//   ntze_, tbui, nuje_,
  { {0x09e10161,0xe7250013,0x8c3b004d,0x00000000}},	//   पनीय, _dưỡ, _faßt,
  { {0xe78700d7,0x443900c7,0x2d83016b,0x00000000}},	//   _љубо, äs_, huje_,
  { {0x3ae400c7,0x7d040ffb,0x645b0104,0x00000000}},	//   _köpa_, znis, sbui,
  { {0x2d830ffc,0x645b059f,0xd5bb0054,0x00000000}},	//   juje_, pbui, _яса_,
  { {0xf5300032,0x96340699,0x3f820078,0x00000000}},	//   _فإن_, _унхц, tuku_,
  { {0x8c3b004d,0x3ae400a5,0xe3a5005d,0x00000000}},	//   _maßs, _löpa_, _خشای,
  { {0x3f820117,0xc8e20053,0x0efa0085,0x00000000}},	//   ruku_, _खत्म_, тэмы_,
  { {0x3f820ffd,0x20ef0080,0xacf60d34,0x00000000}},	//   suku_, třit_, ачај,
  { {0x3f820ffe,0x7ce3004b,0xdb0f00cd,0x00000000}},	//   puku_, _põra, _arcà,

  { {0x0b1a0021,0xac050021,0x78a20261,0x00000000}},	// [1400] نقرة_, مذكو, veov,
  { {0x2d830fff,0xba26000d,0x7d041000,0x00000000}},	//   buje_, адзк, snis,
  { {0xc8661001,0x7e7b0063,0x2d830aa3,0x00000000}},	//   атли, _באיז, cuje_,
  { {0x3ae40137,0xd7fa1002,0x7c961003,0x00000000}},	//   _döpa_, кул_, _троц,
  { {0x27e0018d,0x78a21004,0x4b550062,0x00000000}},	//   áin_, reov, _гъст,
  { {0xb05b0072,0x78a21005,0xb882004c,0x00000000}},	//   ljät, seov, _řídk,
  { {0xafdb0146,0x27e00392,0x5f090042,0x00000000}},	//   ncør, šin_, _सदस्_,
  { {0x63b900a3,0xd9431006,0xd49a012c,0x00000000}},	//   _brwn, _фети, трк_,
  { {0x6676006a,0x63b9001f,0xa507005e,0x00000000}},	//   _ندار, _crwn, јења_,
  { {0xd5b8008f,0xeb97009a,0xb1e600de,0x00000000}},	//   _trā_, סדיר_, لأجه,
  { {0x2d8301d9,0x3ce0004b,0xb5ca00de,0x00000000}},	//   xuje_, kkiv_, _جوام_,
  { {0xd5fb0063,0x2d8301f5,0xb92a0054,0x00000000}},	//   _בפבר, vuje_, нкiв,
  { {0x89370047,0x2d830051,0x29370047,0x00000000}},	//   ירטע_, wuje_, יאטן_,
  { {0xdefb06bc,0x539b0063,0x2ee50014,0x00000000}},	//   тым_, _סיוו, ólf_,
  { {0x27290025,0xcf8e007e,0x69d805e7,0x00000000}},	//   núna_, وژی_, øvel,
  { {0x9fe7006a,0x2c780086,0xd6d90022,0x00000000}},	//   _نسخه, ийсь_, _pułk_,
  { {0x6f950021,0x2d831007,0xdb0f1008,0x00000000}},	// [1410] _الخض, suje_, _arcá,
  { {0x62881009,0x2d83100a,0x5c040085,0x00000000}},	//   ngdo, puje_, іята,
  { {0xaf34006a,0x3ce900d1,0xf9f90021,0x00000000}},	//   _بريت, phav_, دفاع_,
  { {0xb4d50053,0x20040022,0x99280054,0x00000000}},	//   _सके_, źmie_, аюча_,
  { {0xe72e000d,0x97a70121,0xb05b0072,0x00000000}},	//   зе_, ррел, ljäs,
  { {0x9a840d34,0x2d73007d,0xbae50044,0x00000000}},	//   _мусл, oće_, _اكسي,
  { {0xb9e4012c,0x2729009c,0x5e78009a,0x00000000}},	//   _діти, gúna_, בתון_,
  { {0xe9190086,0x2d73007d,0xccf2009a,0x00000000}},	//   _собі_, iće_, ּ֛ה_,
  { {0x36d50001,0x368b100b,0xa825007e,0x00000000}},	//   _лоар, _асен_, _اکان,
  { {0x628800d1,0xa2e50002,0x24770013,0x00000000}},	//   ggdo, соод, ểm_,
  { {0xd9f70053,0xf1bf017c,0xa06a0d4e,0x00000000}},	//   ंछित_, čšom_, лана_,
  { {0xaac90053,0xf494012c,0xa535014b,0x00000000}},	//   राडक, _мрію, _унеч,
  { {0x2d73017f,0xc4840085,0x10160085,0x00000000}},	//   eće_, _флік, сьня,
  { {0x63a90035,0xfe7a0085,0xd9f90042,0x00000000}},	//   mwen, ыёмы_, ्पात_,
  { {0x8db50086,0xdef9000d,0x63a9100c,0x00000000}},	//   ості, рыў_, lwen,
  { {0x6b84100d,0x6c59005e,0xa5da0041,0x00000000}},	//   tuig, ијус_, אַמי,
  { {0x60c4100e,0xdcfc001c,0x3ce00e6c,0x00000000}},	// [1420] _inim, gurā, rkiv_,
  { {0x98a6007d,0x4bd90121,0xb05b0ef1,0x00000000}},	//   omoć_, шься_, sjät,
  { {0x60d6005b,0xbed70047,0x63a90a67,0x00000000}},	//   _koym, _הויז_, hwen,
  { {0xe894019d,0x6d5c100f,0x63a91010,0x00000000}},	//   іаль, mpra, kwen,
  { {0xb7960001,0x6d5c1011,0x628801e1,0x00000000}},	//   срећ, lpra, ygdo,
  { {0x63a90186,0x6ffc001c,0xef1f005b,0x00000000}},	//   dwen, mācī, ltür_,
  { {0x60c4017f,0x6d5c1012,0x7f3b0047,0x00000000}},	//   _onim, npra, נעצו,
  { {0xdbdd034d,0x63a9004d,0xb05b0137,0x00000000}},	//   zšír, fwen, hjär,
  { {0xb7f20053,0x96960ad9,0x6ffc008f,0x00000000}},	//   _आइटम_, _греш, nācī,
  { {0x6eeb1013,0xf2c60a91,0x60c41014,0x00000000}},	//   _kübe, ссин, _anim,
  { {0x5a9b0047,0xef1f0058,0xba9b07e9,0x00000000}},	//   נשטא, ktür_, נסטי,
  { {0x692c000c,0x7afe005b,0x6d5c1015,0x00000000}},	//   _aşez, hipt, dpra,
  { {0x7afe0ac6,0x6d5c1016,0xb05b0137,0x00000000}},	//   kipt, epra, fjär,
  { {0x60c40213,0xff07000d,0x39581017,0x00000000}},	//   _enim, сямн, _otrs_,
  { {0x68e21018,0xab5b087d,0x2d730130,0x00000000}},	//   kkod, _krüg, uće_,
  { {0x99860045,0x657c02ea,0x69de00d1,0x00000000}},	//   łoś_, _århu, dype,
  { {0x8b580021,0x68e20b2a,0x6d5c1019,0x00000000}},	// [1430] مجلس_, dkod, apra,
  { {0xe509008b,0x2d73007d,0xa9c70086,0x00000000}},	//   oặc_, pće_, йсек,
  { {0x7f3c00b5,0x394a00e5,0x96f9005d,0x00000000}},	//   _געזו, _cubs_, یعتر_,
  { {0xad27006a,0x0cab026b,0x38690026,0x00000000}},	//   _درخو, _стои_, úar_,
  { {0x78a4004b,0xab840002,0x17c90a91,0x00000000}},	//   õiva, _нурк, ргли_,
  { {0xab5b00bd,0x7afe053b,0xe739101a,0x00000000}},	//   _prüf, cipt, шел_,
  { {0x68e201e1,0xd5750054,0x6104013d,0x00000000}},	//   bkod, цуль, lőle,
  { {0x63a900bd,0xe894000d,0x68e20137,0x00000000}},	//   twen, _нась, ckod,
  { {0x63a90194,0x42e90001,0x59e10053,0x00000000}},	//   uwen, имио_, पनकर,
  { {0x63a90199,0x68e90080,0x60c4017f,0x00000000}},	//   rwen, _hled, _snim,
  { {0x68e9101b,0x5455026b,0x63a9004d,0x00000000}},	//   _kled, _двет, swen,
  { {0x6d5c00c2,0x6112008f,0x00000000,0x00000000}},	//   vpra, kāle,   ,
  { {0xb05b0137,0x2b59101c,0x7fd6045b,0x00000000}},	//   tjär, _ntsc_, ціні,
  { {0x68e9001f,0x539a0063,0x68e2101d,0x00000000}},	//   _lled, _כינו, zkod,
  { {0x3d28007e,0x98a40078,0xdcfc003b,0x00000000}},	//   متری_, _gimė_, jură,
  { {0xb05b003a,0x6eeb004d,0x68e90137,0x00000000}},	//   sjär, _rübe, _nled,
  { {0x2a780150,0x6d5c101e,0x68e205a5,0x00000000}},	// [1440] _pdrb_, spra, vkod,
  { {0x68e9006d,0x69de0246,0x6d5c101f,0x00000000}},	//   _aled, type, ppra,
  { {0xdcfc000c,0x68e21020,0x6f1c1021,0x00000000}},	//   gură, tkod, morc,
  { {0xab5b00bd,0x718c0047,0x6f1c1022,0x00000000}},	//   _brüd, רװאַ, lorc,
  { {0x7d0905c9,0x68e21023,0x4c36007f,0x00000000}},	//   čest, rkod, _фэнт,
  { {0x68e21024,0x290d0035,0x6f1c1025,0x00000000}},	//   skod, _ejea_, norc,
  { {0xab5b0019,0xc448007e,0xdcfc003b,0x00000000}},	//   _prüg, میان_, cură,
  { {0x68e901a6,0x15170032,0xd250007e,0x00000000}},	//   _gled, يزية_, کند_,
  { {0xdcfc001c,0x442200b9,0x3e57004c,0x00000000}},	//   ltrē, æk_, nětí_,
  { {0x3f9e00dd,0x35a60085,0xe5a60816,0x00000000}},	//   ătul_, _мазг, _мизи,
  { {0x610400ea,0xdcfc001c,0x7ce3004b,0x00000000}},	//   zőle, ntrē, _sõrm,
  { {0x6b9600c7,0x23660022,0xdcf50022,0x00000000}},	//   ktyg, _twoj_, orzą,
  { {0xf044000d,0x6f1c0b02,0xc49b0063,0x00000000}},	//   дэро, forc, _כשאת,
  { {0x6f1c007d,0xe29701ce,0x8e8400de,0x00000000}},	//   gorc, _даљ_, ولُه,
  { {0x52130001,0xccfb0001,0x2732000c,0x00000000}},	//   _одшт, аћа_, mând_,
  { {0x9f6b0001,0x8b670021,0x610400ea,0x00000000}},	//   _кроз_, قائم, tőle,
  { {0x2d68003b,0x6f1c1026,0xe81a0082,0x00000000}},	// [1450] aşe_, borc, _फुला_,
  { {0xf43b014e,0x2732000c,0x6f1c1027,0x00000000}},	//   שתמש, nând_, corc,
  { {0xfc3f1028,0x68e91029,0xdcf50051,0x00000000}},	//   _país_, _pled, erzą,
  { {0xaac90053,0x394400cd,0x63a2102a,0x00000000}},	//   राहक, _cims_, _opon,
  { {0x99540080,0xdcfc000c,0x69ca087d,0x00000000}},	//   _výše_, sură, äfer,
  { {0x7bda0063,0x68e9001f,0xb345017d,0x00000000}},	//   _הקשו, _wled, _liçã,
  { {0x63a20016,0x2732003b,0x7ce3004b,0x00000000}},	//   _apon, dând_, _nõrk,
  { {0xe9180086,0x2ca90139,0x68fb0058,0x00000000}},	//   _досі_, nead_, _umud,
  { {0x291d0051,0x3995102b,0x2732003b,0x00000000}},	//   mowa_, lås_, fând_,
  { {0x386d102c,0x2732000c,0x291d0051,0x00000000}},	//   _heer_, gând_, lowa_,
  { {0x386d0102,0x42250086,0x3995102d,0x00000000}},	//   _keer_, ядов, nås_,
  { {0x7cf103d4,0x291d102e,0xd59a0063,0x00000000}},	//   _hårf, nowa_, _לבעל,
  { {0x386d102f,0x7ce30019,0x273200dd,0x00000000}},	//   _meer_, _tõrj, bând_,
  { {0x2732000c,0x386d1030,0x442f00a8,0x00000000}},	//   când_, _leer_, _izg_,
  { {0x2ca90025,0x291d0051,0xa9280240,0x00000000}},	//   fead_, kowa_, ližš,
  { {0x2732000c,0xf0660076,0x386d1031,0x00000000}},	//   mâne_, _экип, _neer_,
  { {0x2d8300c7,0x6f1c1032,0x291d0051,0x00000000}},	// [1460] arje_, porc, dowa_,
  { {0x4b23000a,0x8b230076,0x6b9600c7,0x00000000}},	//   емув, едуе, rtyg,
  { {0x6edb014e,0x386d1033,0x39951034,0x00000000}},	//   _החיפ, _beer_, gås_,
  { {0x2732000c,0x3eaa004d,0xdcf50051,0x00000000}},	//   zând_, lebt_, trzą,
  { {0xdcfc003d,0x386d0034,0x4cbb0063,0x00000000}},	//   strē, _deer_, _הזכו,
  { {0x2d980164,0x6d460b67,0xddc71035,0x00000000}},	//   otre_, _hika, lajš,
  { {0x6b841036,0x6d461037,0x2732003b,0x00000000}},	//   lrig, _kika, vând_,
  { {0x2d980164,0x6b841038,0x61e11039,0x00000000}},	//   itre_, orig, dyll,
  { {0x2732000c,0x6b8400b9,0x6d46103a,0x00000000}},	//   tând_, nrig, _mika,
  { {0x386d0122,0xdb0d03d9,0x248d0016,0x00000000}},	//   _zeer_, rvaç, agem_,
  { {0x2732000c,0x6b84103b,0x6d4600fe,0x00000000}},	//   rând_, hrig, _oika,
  { {0x2fc00185,0x2d9800d1,0x6d46103c,0x00000000}},	//   _brig_, dtre_, _nika,
  { {0x2732000c,0x38690026,0x613f001c,0x00000000}},	//   pând_, ðari_, _jūli,
  { {0x6d46024a,0x442600bb,0x61360026,0x00000000}},	//   _aika, _iyo_, jálf,
  { {0x06fd0080,0x6b84103d,0xe29b009a,0x00000000}},	//   _říká_, erig, _השור,
  { {0x6d46103e,0xe5090013,0x6b840f15,0x00000000}},	//   _cika, hặn_, frig,
  { {0x2d9c01e3,0x6d460e53,0x0f270086,0x00000000}},	// [1470] _även_, _dika, _ньом,
  { {0x7cea0a63,0x6112001c,0x0ab40002,0x00000000}},	//   _výra, māla, нбуџ,
  { {0xab5b00bd,0x291d0051,0x752200ea,0x00000000}},	//   _brüc, towa_, _okoz,
  { {0xddde0080,0xf77101a7,0x3995103f,0x00000000}},	//   _nepř, نات_, rås_,
  { {0x3f8b005b,0xab5b00bd,0x44261040,0x00000000}},	//   nucu_, _drüc, _nyo_,
  { {0x386d0102,0xd2460032,0x291d1041,0x00000000}},	//   _weer_, _لن_, sowa_,
  { {0x67210198,0x248d00cd,0x9f440080,0x00000000}},	//   _vklj, tgem_, ámé_,
  { {0x7d0d1042,0x6112008f,0x61e10072,0x00000000}},	//   nnas, kāla, vyll,
  { {0x61e1001f,0x248d1043,0x7d0d1044,0x00000000}},	//   wyll, rgem_, inas,
  { {0x67210117,0x7d0d0185,0x610400ea,0x00000000}},	//   _uklj, hnas, dőla,
  { {0x2d980003,0x7d0d1045,0x63bb1046,0x00000000}},	//   xtre_, knas, svun,
  { {0x63a4000c,0x6b841047,0x63c8013d,0x00000000}},	//   _ţine, yrig, érnö,
  { {0x61e10185,0xdb0f0871,0x644b00ac,0x00000000}},	//   syll, _escé, _iggi,
  { {0x6d46014f,0x2d981048,0x75291049,0x00000000}},	//   _sika, ttre_, llez,
  { {0x2d980164,0xddc700c3,0x3eaa004d,0x00000000}},	//   utre_, tajš, rebt_,
  { {0x7d0d0bad,0xa01b0137,0x2d98104a,0x00000000}},	//   gnas, tgöt, rtre_,
  { {0x2d98104b,0x83b500b5,0xddc7104c,0x00000000}},	// [1480] stre_, ופּע_, rajš,
  { {0x6d460bc1,0xa01b0cbf,0x2d98104d,0x00000000}},	//   _wika, rgöt, ptre_,
  { {0x6d46003d,0x7c260051,0x644b104e,0x00000000}},	//   _tika, _wykr, _oggi,
  { {0x18670138,0x395c001c,0xfd45000d,0x00000000}},	//   даци_, īvs_, _пэўн,
  { {0x7d040072,0xa01b0b68,0x7529007d,0x00000000}},	//   miis, lgör, dlez,
  { {0x644b104f,0x64590122,0x752200c3,0x00000000}},	//   _aggi, _afwi, _skoz,
  { {0xdcf50051,0x7ae31050,0xa01b1051,0x00000000}},	//   erzę, önte, ngör,
  { {0x290201e3,0x75291052,0x7cf10666,0x00000000}},	//   _öka_, glez, _gård,
  { {0x38661053,0xddde004c,0x2286012c,0x00000000}},	//   mbor_, _vepř, мунг,
  { {0x6d5e017f,0x65c60905,0x75290080,0x00000000}},	//   _otpa, _обза, alez,
  { {0x752902dd,0xdcf50051,0xe8df0013,0x00000000}},	//   blez, arzę, _hiền_,
  { {0xf503005a,0x6ef00137,0x752901f4,0x00000000}},	//   _изхо, _näbb, clez,
  { {0x7ce30004,0xc0e4000d,0x64a3005e,0x00000000}},	//   _kõrv, тоўк, _јача,
  { {0xe8df001b,0x3f8b005b,0x6112008f,0x00000000}},	//   _miền_, rucu_, rāla,
  { {0xdd940088,0xc348001b,0xe8df008b,0x00000000}},	//   кары, _nổi_, _liền_,
  { {0x201e000c,0x30a702a9,0x61e700b9,0x00000000}},	//   ştia_, _цркв, øjle,
  { {0xfd440088,0x7d0d1054,0x6ef0004d,0x00000000}},	// [1490] тэрн, rnas, _säbe,
  { {0x0dcb011c,0x4ac90053,0x19eb0593,0x00000000}},	//   _думи_, राइव, يراً_,
  { {0xceb20047,0x212b0616,0x7d0d0014,0x00000000}},	//   _גיי_, olch_, pnas,
  { {0x7cf105e7,0xe8df008d,0xc348008d,0x00000000}},	//   _båre, _biền_, _dổi_,
  { {0x7cf10137,0x78ab00ac,0x27e90014,0x00000000}},	//   _vård, regv, áan_,
  { {0x6d580003,0x38661055,0xc1780078,0x00000000}},	//   _évac, abor_, ksė_,
  { {0x38660137,0x27e90869,0x69d804aa,0x00000000}},	//   bbor_, šan_, øvet,
  { {0xdb040014,0x7cf10b2a,0xdcf50022,0x00000000}},	//   lvið, _fåre, trzę,
  { {0x68e40072,0x613601c2,0x24090121,0x00000000}},	//   öide, nále, янии_,
  { {0xe299005e,0x7529004c,0xe161014b,0x00000000}},	//   чао_, slez, лямi_,
  { {0x753b00ca,0x290f1056,0xf647005e,0x00000000}},	//   pmuz, onga_, _цхан,
  { {0x2732003b,0xa01b0137,0x68f90058,0x00000000}},	//   mâna_, vgör, _çadı,
  { {0x7d04021e,0x290f1057,0xdb040014,0x00000000}},	//   viis, inga_, kvið,
  { {0x61360080,0xa01b0137,0x38661058,0x00000000}},	//   dále, tgör, zbor_,
  { {0x7d04021e,0x6da30713,0xa0a609b3,0x00000000}},	//   tiis, лира, _зайд,
  { {0x7cea004a,0xe058007e,0x6112008f,0x00000000}},	//   _výro, _زیست_, mālo,
  { {0x7d04003a,0xdb040014,0x249f0014,0x00000000}},	// [14a0] riis, fvið, ifum_,
  { {0x290f1059,0x7d040ff2,0xda650021,0x00000000}},	//   enga_, siis, نامي,
  { {0xf9690086,0x7cf1105a,0xdc3c00c2,0x00000000}},	//   дрій_, _såre, _iščo,
  { {0xdd2f0080,0x7cf100b9,0xcb09016e,0x00000000}},	//   pěšn, _påre, זל_,
  { {0x3866105b,0x569402fe,0x387f002b,0x00000000}},	//   rbor_, валт, _ddur_,
  { {0x290f105c,0x7cf100df,0xa824007e,0x00000000}},	//   anga_, _våre, _یکشن,
  { {0x212b001f,0x6b490078,0x9597005e,0x00000000}},	//   ylch_, _užga, етњу_,
  { {0xe8df001b,0x7cf105a5,0x2907006c,0x00000000}},	//   _tiền_, _tåre, énat_,
  { {0x7ce3004b,0x6d3b009a,0x00000000,0x00000000}},	//   _tõrv, התקנ,   ,
  { {0x13f30076,0xdb970047,0x877b0063,0x00000000}},	//   узья, עדיט_, _מאמי,
  { {0xe6d90026,0x27e6105d,0xc1780078,0x00000000}},	//   _þráð, lyon_, usė_,
  { {0xef1f0244,0x28c60082,0x25d7009d,0x00000000}},	//   grün_, _रोमि, _רואן_,
  { {0xe8df001b,0x27e60465,0x201e003b,0x00000000}},	//   _hiển_, nyon_, ştin_,
  { {0x9f350086,0x26de0035,0xf09f00cd,0x00000000}},	//   тегі, _joto_, sfà_,
  { {0x26de105e,0x7e7500c2,0xd72d0054,0x00000000}},	//   _moto_, razp, _лiце,
  { {0x6b8d0a5c,0x7cf1011d,0x26de105f,0x00000000}},	//   tuag, _sårb, _loto_,
  { {0x3eba000c,0x60cd1060,0xfa87005e,0x00000000}},	// [14b0] _fapt_, _inam, ећем,
  { {0x26de051e,0x27e60a9f,0x3ce900c2,0x00000000}},	//   _noto_, dyon_, skav_,
  { {0xab5b0199,0x7b0b001c,0x249f0026,0x00000000}},	//   _grün, kļuv, yfum_,
  { {0xa954019d,0x6c790047,0xdb040026,0x00000000}},	//   укці, _קאָפ, svið,
  { {0x60cd0035,0x26de1061,0x69d80093,0x00000000}},	//   _mnam, _boto_, øver,
  { {0x8698005a,0xe8df008b,0xd6db07da,0x00000000}},	//   етът_, _biển_, яте_,
  { {0x27e60414,0x5b1402a9,0x60cd08ee,0x00000000}},	//   ayon_, _смрт, _onam,
  { {0x27e61062,0xe8df008d,0x00000000,0x00000000}},	//   byon_, _diển_,   ,
  { {0xf6990138,0x249f1063,0x26de1064,0x00000000}},	//   _овај_, rfum_, _foto_,
  { {0x929d0047,0x6112008f,0x60cd1065,0x00000000}},	//   _פֿון_, tālo, _anam,
  { {0xe4e70086,0x9f44004c,0x67230130,0x00000000}},	//   _підн, ámí_, monj,
  { {0x23b50032,0xd00a000a,0x67231066,0x00000000}},	//   _لمؤس, деме_, lonj,
  { {0x78bb0164,0xe299036a,0x3ae40137,0x00000000}},	//   _mauv, _жал_, _köpt_,
  { {0x78bb1067,0x67230397,0x60cd1068,0x00000000}},	//   _lauv, nonj, _enam,
  { {0x7c96005a,0x27e6005b,0x8c96000d,0x00000000}},	//   крац, zyon_, краі,
  { {0xfbe700aa,0xe6d90026,0x7c85005e,0x00000000}},	//   _thể_, _þræð, луђе,
  { {0x3eba0031,0x67231069,0x1c46106a,0x00000000}},	// [14c0] _tapt_, konj, тнам,
  { {0x60cd106b,0x00000000,0x00000000,0x00000000}},	//   _znam,   ,   ,
  { {0x7c2900b9,0x26de106c,0xd946106d,0x00000000}},	//   _øern, _roto_, вежи,
  { {0xe7860088,0x26de106e,0x09060062,0x00000000}},	//   вуко, _soto_, ъпен,
  { {0x38cb007e,0x67230ee9,0x6455004c,0x00000000}},	//   ظامی_, fonj, ězil,
  { {0xdb0f0016,0x67230a1a,0xc9860021,0x00000000}},	//   _escâ, gonj, _لشري,
  { {0x27e6106f,0x66e300d7,0x26de1070,0x00000000}},	//   syon_, роја, _voto_,
  { {0x399c00cd,0x44b4018e,0xef1f00ea,0x00000000}},	//   mís_, убис, erül_,
  { {0x26de0512,0x96960086,0x399c1071,0x00000000}},	//   _toto_, _ареш, lís_,
  { {0x78bb0253,0x26cc1072,0x6723032c,0x00000000}},	//   _zauv, _undo_, conj,
  { {0x399c0857,0x68e00014,0x6abc1073,0x00000000}},	//   nís_, _komd, _marf,
  { {0xb97b0063,0x7bc61074,0x7cf8013d,0x00000000}},	//   ונטי, _orku, _hírf,
  { {0x399c0025,0x68e3017d,0x53b60042,0x00000000}},	//   hís_, êndi, _अनिश,
  { {0x6ee200be,0x3d9501fe,0x00000000,0x00000000}},	//   _sôbr, лигр,   ,
  { {0x5e58019d,0xdef80088,0x7bc60051,0x00000000}},	//   тися_, тыя_, _arku,
  { {0x60cd1075,0x68e00331,0x853c0078,0x00000000}},	//   _unam, _nomd, _spėj,
  { {0x6d580164,0x7b0b008f,0x6abc1076,0x00000000}},	// [14d0] _évan, kļut, _barf,
  { {0x8c440138,0x78bb0164,0x61360026,0x00000000}},	//   ређе, _sauv, mála,
  { {0x6136000f,0x78bb0164,0x69d80d02,0x00000000}},	//   lála, _pauv, øvep,
  { {0xfc64011c,0xfc3f006d,0x39150085,0x00000000}},	//   _върн, _maíz_, ымер,
  { {0x6136000f,0xd366006a,0x9cd60063,0x00000000}},	//   nála, _ده_, _עושה_,
  { {0x2d910080,0xa5b90001,0x273b008b,0x00000000}},	//   ouze_, ећих_, iêng_,
  { {0x61360027,0xdb1d017d,0x399c032a,0x00000000}},	//   hála, _ersã, cís_,
  { {0x38c200ea,0x69c70150,0x91fc001c,0x00000000}},	//   térő_, _irje, abāk,
  { {0xdb040072,0x67230516,0xd2990054,0x00000000}},	//   rviö, ponj, нтні_,
  { {0x61e80185,0xe8df001b,0x61361077,0x00000000}},	//   fydl, _diễn_, dála,
  { {0x394d04c6,0xb14606f0,0x04950593,0x00000000}},	//   _kies_, лнол, _ملاح,
  { {0xa6e2007a,0x6d5a1078,0x201e0058,0x00000000}},	//   _öðru, ítam, ştim_,
  { {0x2d91006f,0x61361079,0x2d85004c,0x00000000}},	//   euze_, gála, álen_,
  { {0x394d0780,0xe299107a,0x6d410003,0x00000000}},	//   _lies_, _чак_, ïlan,
  { {0x523900b5,0xd3360063,0x7cf10137,0x00000000}},	//   _אײַנ, _גרסה_, _såra,
  { {0x399c0268,0xacf5005e,0x6abc107b,0x00000000}},	//   vís_, ачуј, _sarf,
  { {0x6abc107c,0xdc75000d,0x69c300b9,0x00000000}},	// [14e0] _parf, рысь, ænen,
  { {0x89f60088,0x80a00161,0x7cf10137,0x00000000}},	//   ляец, ग्रे, _våra,
  { {0x6abc00c7,0x7ce30004,0xcd360021,0x00000000}},	//   _varf, _võrr, _مرحب,
  { {0xdb0f00cd,0x399c107d,0x6abc107e,0x00000000}},	//   _escà, rís_, _warf,
  { {0x6283107f,0x394d1080,0x399c01a8,0x00000000}},	//   _odno, _dies_, sís_,
  { {0x394d0c29,0x3f72001c,0xd5b00021,0x00000000}},	//   _eies_, iņu_, قفت_,
  { {0xdb23013d,0x69c7007d,0xc7b9013d,0x00000000}},	//   _óráj, _grje, _eső_,
  { {0x29040009,0xfc3f02dd,0xc448007e,0x00000000}},	//   _umma_, _raíz_, نیان_,
  { {0xd2500032,0x9cd70063,0xe78a007e,0x00000000}},	//   ينة_, רופה_, _سپاه_,
  { {0x6136000f,0x61e81081,0x61fa00bd,0x00000000}},	//   vála, tydl, tztl,
  { {0x62340259,0xe6160002,0xf1a301d5,0x00000000}},	//   рену, _сфаќ, брян,
  { {0x61360025,0xe8df0013,0x62831082,0x00000000}},	//   tála, _tiễn_, _edno,
  { {0x8cbf0053,0xe47b0047,0x29370047,0x00000000}},	//   _लोगो, _טראכ, טאטן_,
  { {0x43830032,0xb3bb0063,0xff040062,0x00000000}},	//   _الوق, _נמוכ, бясн,
  { {0x61361083,0xeca7000a,0x6d580164,0x00000000}},	//   sála, лјан, _éval,
  { {0x55770047,0x61361084,0x6ef000a5,0x00000000}},	//   טעלן_, láln, _fäbo,
  { {0xe8df00aa,0x1bd400a0,0xab5b004d,0x00000000}},	// [14f0] _hiện_, ботя, _trüm,
  { {0xe8df001b,0x63bd00b9,0x394d0c29,0x00000000}},	//   _kiện_, æsni, _sies_,
  { {0x394d1085,0x127b0041,0xc333089e,0x00000000}},	//   _pies_, גאבע, צוע_,
  { {0x2fc900e8,0xd7f10021,0x69c70130,0x00000000}},	//   _krag_, يكا_, _vrje,
  { {0xdb0f05d5,0x61360114,0x394d1086,0x00000000}},	//   _escá, káln, _vies_,
  { {0x6b8d000e,0x394d004d,0x7bc8069a,0x00000000}},	//   mrag, _wies_, _עֶרֶ,
  { {0x8aa4019d,0x45191087,0x6d4f0035,0x00000000}},	//   _уряд, кция_, _kica,
  { {0x7cf81088,0x394d01a8,0xf4290519,0x00000000}},	//   _vírg, _uies_, койл_,
  { {0x28f80b3f,0x54a40021,0x61360260,0x00000000}},	//   _сеть_, صحيف, fáln,
  { {0x42550fe2,0xe8df008b,0x03a800f2,0x00000000}},	//   штит, _biện_, اديو_,
  { {0x6b8d028d,0x7cf800ea,0xab5b0058,0x00000000}},	//   hrag, _híre, _brük,
  { {0xe8df001b,0x3f72001c,0x6b8d0850,0x00000000}},	//   _diện_, tņu_, krag,
  { {0x6112001c,0x613d00ea,0x61361089,0x00000000}},	//   nāli, zélg, báln,
  { {0xdcee0080,0x7cf80025,0x6b8d108a,0x00000000}},	//   ědče, _míre, drag,
  { {0x6d4f0974,0x2d9e03b2,0x6b8d028d,0x00000000}},	//   _bica, îte_, erag,
  { {0x3fe60086,0x6b8d108b,0xb05b051c,0x00000000}},	//   _вжив, frag, rdäc,
  { {0x6136000f,0xca560002,0x6d4f0cf8,0x00000000}},	// [1500] lálo, атењ, _dica,
  { {0xff7b0047,0x7bc4108c,0x7cf10d1a,0x00000000}},	//   _שטימ, rviu, _hårl,
  { {0x6d4f03d9,0x6b8d108d,0x6136108e,0x00000000}},	//   _fica, arag, nálo,
  { {0x3ead017f,0xdbdc108f,0x2c5c0051,0x00000000}},	//   đete_, lšíc, _bądź_,
  { {0x69c500d1,0x26350013,0x6b8d1090,0x00000000}},	//   avhe, _áo_, crag,
  { {0x7cf80027,0x6d44001f,0x613d00ea,0x00000000}},	//   _díre, lmia, méle,
  { {0x7e7c0089,0x613600ea,0xd5b00021,0x00000000}},	//   iarp, váln, سفة_,
  { {0x54b8005a,0x6136004c,0x442f01e1,0x00000000}},	//   угия_, dálo, _byg_,
  { {0x2bc90053,0x7e7c1091,0x61361092,0x00000000}},	//   रिया, karp, táln,
  { {0xdbdc0240,0x41c6000d,0x6eeb1093,0x00000000}},	//   jšíc, аёма, _tübi,
  { {0x613d1094,0xdcf6004c,0x20d50021,0x00000000}},	//   héle, ýběr, مقدس,
  { {0xab5b0199,0x7e6e00c7,0xe8df001b,0x00000000}},	//   _früh, ebbp, _viện_,
  { {0x7cf102ab,0x6d4f1095,0x395801a8,0x00000000}},	//   _dårl, _rica, _lurs_,
  { {0x7e7c00c7,0x6b8d1096,0x6d57017d,0x00000000}},	//   garp, vrag, _puxa,
  { {0x13b60161,0xab5b042e,0x5186005e,0x00000000}},	//   _अनुभ, _trük, _ђука,
  { {0x6b8d1097,0x613600ea,0xccf8005e,0x00000000}},	//   trag, náll, аћу_,
  { {0x113c0063,0xdd2f004c,0x6b8d1098,0x00000000}},	// [1510] _בתהל, _těžb, urag,
  { {0xf9c71099,0x7e7c109a,0x7d16002b,0x00000000}},	//   ищен, carp, anys,
  { {0x6d4f005b,0x3958109b,0x6b8d004d,0x00000000}},	//   _tica, _curs_, srag,
  { {0x6112001c,0x3958109c,0x58870085,0x00000000}},	//   tāli, _durs_, рыжа,
  { {0x7d0d109d,0xa7a9005e,0x9cd6009a,0x00000000}},	//   mias, укла_, _הורה_,
  { {0x6136000f,0x7cf80025,0xb8820026,0x00000000}},	//   eáll, _víre, _þíni,
  { {0x395800c2,0xa509006e,0x0568005e,0x00000000}},	//   _gurs_, лека_, ајњи_,
  { {0x201e000c,0x6136109e,0x78a9000e,0x00000000}},	//   ştii_, gáll, _ubev,
  { {0x57f5000a,0xe5040021,0x387d002b,0x00000000}},	//   _упат, تبوي, mawr_,
  { {0x6d440051,0x7d0d0e67,0x387d002b,0x00000000}},	//   zmia, hias, lawr_,
  { {0x7e7c0026,0x6d440a8d,0x613d00ea,0x00000000}},	//   varp, ymia, zéle,
  { {0x3f6a0138,0x387d001f,0x7d0d0035,0x00000000}},	//   лимо_, nawr_, jias,
  { {0x7e7c109f,0x320b0051,0x7d0d10a0,0x00000000}},	//   tarp, ńcy_, dias,
  { {0x083a0047,0x613d10a1,0x752900ca,0x00000000}},	//   טערל, véle, loez,
  { {0x51950021,0x7e7c0354,0x527a0041,0x00000000}},	//   _العذ, rarp, _ענקא,
  { {0x4bda0076,0x1d07000a,0x7d0d10a2,0x00000000}},	//   льзя_, беси_, gias,
  { {0x4aaa10a3,0x61360024,0x395810a4,0x00000000}},	// [1520] лкан_, nálm, _surs_,
  { {0x613600ea,0xca56005e,0x6d4410a5,0x00000000}},	//   záll, стањ, smia,
  { {0xc879005b,0x7cf80297,0x387d001f,0x00000000}},	//   _beş_, _círc, fawr_,
  { {0x2732000c,0x7d0d10a6,0x3f820051,0x00000000}},	//   mâni_, cias, osku_,
  { {0xa03a0047,0x2bc90053,0x613610a7,0x00000000}},	//   װײַז, रिणा, váll,
  { {0xb8ef0161,0x3b0a0121,0x6112008f,0x00000000}},	//   _वो_, _сего_, mālu,
  { {0xceb30063,0x6136013d,0xa4d80505,0x00000000}},	//   פיה_, táll, идку_,
  { {0xdb1d00c7,0x8a170063,0x18a3050f,0x00000000}},	//   _ersä, _החלו_, _насм,
  { {0xe73a0079,0x6112001c,0x3f8210a8,0x00000000}},	//   _беа_, nālu, jsku_,
  { {0x27f90019,0x2bc90053,0x3f8210a9,0x00000000}},	//   _üsna_, रिता, dsku_,
  { {0x7d0d0089,0x394610aa,0xd2500049,0x00000000}},	//   yias, omos_, بند_,
  { {0xca370063,0x613600ea,0x463b0047,0x00000000}},	//   מניה_, lálj, _געבע,
  { {0xdcee001c,0x394605d5,0xdb0d0014,0x00000000}},	//   arbī, imos_, kvað,
  { {0x6136000f,0xdb1d017d,0x28cf0053,0x00000000}},	//   nálj, _essê, _सोनि,
  { {0xc27b00b5,0x427b0063,0x645d0078,0x00000000}},	//   _גרוי, _גאוג, žsie,
  { {0xe2170063,0xdcf5008f,0xdb06013d,0x00000000}},	//   _לקוח_, muzī, _eskü,
  { {0x212b0024,0x99620066,0x672a10ab,0x00000000}},	// [1530] moch_, _ríše_, kofj,
  { {0x394610ac,0xda670021,0x6e950021,0x00000000}},	//   emos_, صائي, _بلدا,
  { {0xdcfc001c,0x99620114,0x4879000d,0x00000000}},	//   gurē, _píše_, асля_,
  { {0x212b10ad,0x9cb50021,0x383510ae,0x00000000}},	//   noch_, _بمحت, онер,
  { {0x7d1d10af,0x69d80072,0xe72e10b0,0x00000000}},	//   _ijss, äver, де_,
  { {0x613600ea,0x212b10b1,0x7c3d00c2,0x00000000}},	//   gálj, hoch_, _izsr,
  { {0x212b0024,0x2d8310b2,0x05790021,0x00000000}},	//   koch_, nsje_, جمعة_,
  { {0x212b0024,0xe9190086,0x2d83006f,0x00000000}},	//   joch_, _тобі_, isje_,
  { {0x613600ea,0x212b10b3,0x290f10b4,0x00000000}},	//   bálj, doch_, miga_,
  { {0x290f10b5,0xf6f5006a,0x13090076,0x00000000}},	//   liga_, _بزرگ, рной_,
  { {0x61460601,0x799710b6,0x7cf8013d,0x00000000}},	//   жена, nuxw, _líra,
  { {0xa2a90235,0xa4f7007e,0x3f820743,0x00000000}},	//   _जॉर्, _دکتر_, tsku_,
  { {0x613600ea,0x3f840114,0x290f004b,0x00000000}},	//   lálk, ému_, iiga_,
  { {0x7cea0026,0x3f8210b7,0x236d007d,0x00000000}},	//   _nýrr, rsku_, mpej_,
  { {0x6ab710b8,0x2ca90137,0xdd920049,0x00000000}},	//   dexf, ffad_, ظور_,
  { {0x290f01b3,0x6112001c,0x613600ea,0x00000000}},	//   jiga_, tālu, zálj,
  { {0x6ef00004,0x290f10b9,0xdd2f004c,0x00000000}},	// [1540] _läbi, diga_, běžn,
  { {0xdcfc003d,0x2d910051,0x60c40e7e,0x00000000}},	//   turē, brze_, _haim,
  { {0x613600ea,0x60c40576,0xed5a005e,0x00000000}},	//   válj, _kaim, _њом_,
  { {0x290f0019,0x613610ba,0x60c40877,0x00000000}},	//   giga_, dálk, _jaim,
  { {0x394610bb,0xdb040122,0x87ba0076,0x00000000}},	//   rmos_, ntië, рует_,
  { {0x6b840027,0x3eb810bc,0xc58a0076,0x00000000}},	//   msig, nert_, ащие_,
  { {0x613600ea,0x290f004b,0x3eb810bd,0x00000000}},	//   rálj, biga_, iert_,
  { {0x443d0199,0x3eb800bd,0x2d9801a8,0x00000000}},	//   _bzw_, hert_, iure_,
  { {0x6b8410be,0x212b0066,0x69ce1035,0x00000000}},	//   nsig, voch_, _hrbe,
  { {0x613610bf,0xd25a0001,0x20020051,0x00000000}},	//   lálh, шци_, dzki_,
  { {0xd62a0076,0x3eb810c0,0x212b10c1,0x00000000}},	//   _тоже_, dert_, toch_,
  { {0x6136000f,0xdb1d00cd,0x613d0026,0x00000000}},	//   nálh, _essè, féla,
  { {0x60c410c2,0x2d980bbd,0x212b10c3,0x00000000}},	//   _daim, eure_, roch_,
  { {0x6b8410c4,0x212b10c1,0x2d910051,0x00000000}},	//   dsig, soch_, trze_,
  { {0xfe54000d,0x60c4003b,0x212b0066,0x00000000}},	//   дкрэ, _faim, poch_,
  { {0x2d830051,0x01fb0063,0x2d8d00a8,0x00000000}},	//   rsje_, _כפול, čee_,
  { {0x6b84002c,0x20020051,0x3eb810c5,0x00000000}},	// [1550] gsig, czki_, bert_,
  { {0xdb040164,0xad670021,0x3eb810c6,0x00000000}},	//   ntiè, _واجه, cert_,
  { {0x63bb00bd,0x6b840455,0x2ca9004d,0x00000000}},	//   zwun, asig, pfad_,
  { {0x63670024,0x61e700b9,0x6b84006d,0x00000000}},	//   nčný, øjli, bsig,
  { {0x3f99005b,0x290f10c7,0xd7f8005e,0x00000000}},	//   nusu_, riga_, жуј_,
  { {0x290f10c8,0xb5790121,0x613610c9,0x00000000}},	//   siga_, бщих_, tálk,
  { {0x3f9910ca,0x63670024,0x290f09c9,0x00000000}},	//   husu_, kčný, piga_,
  { {0xd5ae0021,0x9f4400ea,0xf7bb007e,0x00000000}},	//   افي_, ámú_, _پدرش_,
  { {0x13090086,0x48fa0047,0xb8ff0053,0x00000000}},	//   йний_, _פּלא, ता_,
  { {0xa2050086,0x63bb00bd,0xe2990856,0x00000000}},	//   зпод, rwun, љан_,
  { {0x3eb810cb,0x6136017d,0xe8df0013,0x00000000}},	//   vert_, láli, _nhịn_,
  { {0x3eb800bd,0x443d0051,0x79850035,0x00000000}},	//   wert_, _tzw_, ishw,
  { {0x3eb810cc,0x26c500f3,0x60c4021e,0x00000000}},	//   tert_, _kalo_, _vaim,
  { {0x3eb800bd,0x2d980399,0x7d0100ac,0x00000000}},	//   uert_, ture_, ëlsn,
  { {0x3eb8076c,0x2732000c,0x57b80053,0x00000000}},	//   rert_, mânt_, _इन्ह,
  { {0x3eb810cd,0x26c5002c,0x3ea110ce,0x00000000}},	//   sert_, _lalo_, _echt_,
  { {0x3f99005b,0x613600ea,0x2d980399,0x00000000}},	// [1560] cusu_, válh, sure_,
  { {0x2d9802f6,0x6b840f80,0x628110cf,0x00000000}},	//   pure_, rsig, nalo,
  { {0x68e910d0,0x3a990085,0xc4bd0042,0x00000000}},	//   _boed, ўтую_, ्याओ,
  { {0xc7c60076,0xb05b00fe,0x26c710d1,0x00000000}},	//   зски, ydäm, edno_,
  { {0x68e9001f,0x6d5e0035,0x613600ea,0x00000000}},	//   _doed, _hupa, gáli,
  { {0x6d5e10d2,0x26c510d3,0x628110d4,0x00000000}},	//   _kupa, _calo_, jalo,
  { {0x628110d5,0x613d0080,0x7e7e00ca,0x00000000}},	//   dalo, déln, _mepp,
  { {0x68e910d6,0x68fb001f,0x7cf80080,0x00000000}},	//   _goed, _glud, _míro,
  { {0xd4670001,0x26c5017d,0x61360516,0x00000000}},	//   чиње_, _falo_, cáli,
  { {0x98b800eb,0xe3af01a7,0x7e7e10d7,0x00000000}},	//   _kurį_, اري_, _nepp,
  { {0xdb040003,0x6d5e008f,0xdceb007d,0x00000000}},	//   rtiè, _nupa, _žiča,
  { {0x63a4000c,0xdb040003,0x6281004b,0x00000000}},	//   _ţinu, stiè, aalo,
  { {0x6d5e10d8,0xe505007e,0xdb040003,0x00000000}},	//   _aupa, _تبلي, ptiè,
  { {0x6d5e00f3,0x628a0146,0x7e7e0290,0x00000000}},	//   _bupa, _udfo, _cepp,
  { {0xdd910021,0x271b0041,0x7cf8017c,0x00000000}},	//   ضوء_, צולײ, _vírn,
  { {0x291c0b6d,0x65c7004c,0x26c700a8,0x00000000}},	//   éval_, léhá, zdno_,
  { {0x68e90c70,0x201e01f7,0xd0080138,0x00000000}},	// [1570] _roed, ştir_, _неће_,
  { {0x613610d9,0x3ea10025,0x798510da,0x00000000}},	//   váli, _ucht_, tshw,
  { {0xed580079,0x68fb10db,0x68e9006f,0x00000000}},	//   _ноќ_, _plud, _poed,
  { {0xf9900242,0xd8390085,0x613610dc,0x00000000}},	//   ابل_, опец_, táli,
  { {0x2b93006a,0x68e90179,0x6d5e00c2,0x00000000}},	//   _سیاس, _voed, _zupa,
  { {0x68e9006f,0x8f9c00ff,0x657a002b,0x00000000}},	//   _woed, מידי, _bwth,
  { {0x27320529,0x26c702e2,0x7cf8006d,0x00000000}},	//   vânt_, rdno_, _oírl,
  { {0x62810022,0x613601c8,0x657a00a3,0x00000000}},	//   walo, páli, _dwth,
  { {0xf794000d,0xa2a10053,0xd7940062,0x00000000}},	//   _патэ, _खाद्, _питъ,
  { {0x613600ea,0x628101f4,0x7bcd0003,0x00000000}},	//   nálv, ualo, ivau,
  { {0x63a40529,0x387f00e8,0x657a002b,0x00000000}},	//   _ţint, _keur_, _gwth,
  { {0xdb04006d,0x7e7e10dd,0x6d5e10de,0x00000000}},	//   rtié, _sepp, _rupa,
  { {0x6d5e10df,0x628110e0,0x73e40086,0x00000000}},	//   _supa, palo, _поїз,
  { {0x387f03b2,0x249f10e1,0x63a910e2,0x00000000}},	//   _leur_, lgum_, mten,
  { {0x63a910e3,0x613d013d,0x6da30af0,0x00000000}},	//   lten, célo, кира,
  { {0x249f0ac6,0x205610e4,0x63a910e5,0x00000000}},	//   ngum_, _отпр, oten,
  { {0xe8df001b,0x38c60078,0x7e7e10e6,0x00000000}},	// [1580] _chọn_, _jūrų_, _tepp,
  { {0x63a910e7,0x6d5e10e8,0x6a16005d,0x00000000}},	//   iten, _tupa, وبار,
  { {0x8ca60053,0x89f5000d,0x7cf8013d,0x00000000}},	//   _छापो, няцц, _hírm,
  { {0x63a90323,0xef1f0075,0xa934005d,0x00000000}},	//   kten, nsün_, رباچ,
  { {0x387f10e9,0x69da08c1,0x2d85004c,0x00000000}},	//   _deur_, _šted, šlet_,
  { {0x61360026,0xdcfc0006,0x386601a8,0x00000000}},	//   málu, turė, scor_,
  { {0xceb30063,0x613600ea,0x63a910ea,0x00000000}},	//   דיו_, lálu, eten,
  { {0x2ca00019,0x249f0026,0x63a910eb,0x00000000}},	//   ngid_, ggum_, ften,
  { {0x2ca00019,0x63a910ec,0x69e3003b,0x00000000}},	//   igid_, gten, ăteş,
  { {0x2732003b,0x7cf110ed,0x57430854,0x00000000}},	//   râns_, _hårt, _ануб,
  { {0x6128005b,0x63a910ee,0x61150a71,0x00000000}},	//   kıld, aten, едну,
  { {0x7bcd0006,0x63a910ef,0x6136013d,0x00000000}},	//   yvau, bten, zálv,
  { {0xf09f00cd,0x24f7000d,0xfebb007e,0x00000000}},	//   rgà_, _іншы_, ياست_,
  { {0x2ca0004b,0x6b960022,0x24840244,0x00000000}},	//   egid_, dryg, lamm_,
  { {0xfcc70001,0x7c87005e,0x613600ea,0x00000000}},	//   мљам, дузе, válv,
  { {0x6c550002,0xa2d60082,0x00000000,0x00000000}},	//   екбу, बाक्,   ,
  { {0x7bcd0072,0x8aa70794,0x6136013d,0x00000000}},	// [1590] uvau, дред, gálu,
  { {0xab940086,0x2d85029c,0x7bcd10f0,0x00000000}},	//   тифі, áles_, rvau,
  { {0x387f0164,0x6136013d,0xe3c8008d,0x00000000}},	//   _peur_, rálv, _lự_,
  { {0x6f15005b,0xa2150047,0xdcf5008f,0x00000000}},	//   lizc, ײַעס_, irzī,
  { {0x63a910f1,0x320510f2,0x6d4d10f3,0x00000000}},	//   xten, zzly_, mmaa,
  { {0xd24610f4,0x613600ea,0xc879003b,0x00000000}},	//   _من_, lált, _roşu_,
  { {0x386010f5,0x6d4d06f8,0xa8a710f6,0x00000000}},	//   žira_, omaa, _орак,
  { {0x6d4d10f7,0x613600ea,0xc9840259,0x00000000}},	//   nmaa, nált, _јури,
  { {0x249f007a,0x6d4d00fe,0xe3c80013,0x00000000}},	//   rgum_, imaa, _cự_,
  { {0xe3c8001b,0x63a910d0,0x6d4d10f8,0x00000000}},	//   _dự_, rten, hmaa,
  { {0x6d4d10f9,0x613d00ea,0x63a910fa,0x00000000}},	//   kmaa, mélj, sten,
  { {0xcea9014e,0x63a910fb,0xd576009a,0x00000000}},	//   _לי_, pten, _נתנה_,
  { {0x6d4d0250,0xdb1d0858,0x251a0047,0x00000000}},	//   dmaa, _assí, _צונא,
  { {0x201e000c,0x6d4d0f5e,0x69ca01e1,0x00000000}},	//   ăti_, emaa, æfek,
  { {0x65610016,0x6128005b,0xe8160053,0x00000000}},	//   _julh, tıld, _देना_,
  { {0x656103d9,0x6d4d10fc,0x613610fd,0x00000000}},	//   _mulh, gmaa, gált,
  { {0xac0a000a,0xf1c9008b,0x6128005b,0x00000000}},	// [15a0] чнаа_, _hạ_, rıld,
  { {0x6d4d10fe,0x61280058,0xef1f0075,0x00000000}},	//   amaa, sıld, nsül_,
  { {0x6128005b,0x613600ea,0x91fc008f,0x00000000}},	//   pıld, bált, ecāj,
  { {0x6d4600fe,0xe973007e,0xc7ca0121,0x00000000}},	//   _uhka, اهند, зыке_,
  { {0x69c300b9,0xf1c9008b,0xe73a0448,0x00000000}},	//   æner, _lạ_, пед_,
  { {0x8f9b00b5,0x7bc610ff,0xe5c60980,0x00000000}},	//   פיצי, _isku, есио,
  { {0xe3c800aa,0xd5b70121,0xf1c90013,0x00000000}},	//   _sự_, есы_, _nạ_,
  { {0x273b008b,0x2d981100,0x35c50053,0x00000000}},	//   hênh_, irre_, विज़,
  { {0xd90d006a,0xe8b501f7,0x7d0400fe,0x00000000}},	//   _بین_, lışı, ihis,
  { {0x55e60086,0x51f80086,0x78a2085a,0x00000000}},	//   _позб, дною_, lgov,
  { {0x7cf80080,0x7d041101,0x78a208ea,0x00000000}},	//   _círk, khis, ogov,
  { {0xe3c8001b,0x753b000c,0x7bc60ba5,0x00000000}},	//   _tự_, cluz, _osku,
  { {0x6136000f,0x04570032,0x65610089,0x00000000}},	//   vált, _كلمة_, _zulh,
  { {0x3ea5000f,0x1ee7006a,0x7d041102,0x00000000}},	//   ült_, روزی_, ehis,
  { {0x6d4d1103,0x7bc60ef1,0x613d013d,0x00000000}},	//   tmaa, _asku, nélk,
  { {0x563700b5,0xd904006a,0x23b70053,0x00000000}},	//   גאלע_, _طی_, _अहमद,
  { {0x78a201b3,0x628e0051,0x6d4d1104,0x00000000}},	// [15b0] dgov, óbow, rmaa,
  { {0xadf50088,0xab180086,0x6d4d1105,0x00000000}},	//   _апош, нієї_, smaa,
  { {0x6d4d0250,0xf1c9008b,0x7d0400d1,0x00000000}},	//   pmaa, _xạ_, bhis,
  { {0x57f50002,0xf0940047,0x6d580003,0x00000000}},	//   кпет, ָנס_, _évap,
  { {0xdddc1106,0x46a502b3,0xdbcd00ca,0x00000000}},	//   parţ, валв, _vóór,
  { {0x78a200b2,0x613d013d,0x00000000,0x00000000}},	//   agov, félk,   ,
  { {0x2bc90053,0xd626005e,0x3ce900a8,0x00000000}},	//   रिका, коше_, ojav_,
  { {0x69c7007d,0x3ce900a8,0x9ddc0063,0x00000000}},	//   _isje, njav_, לקוח,
  { {0x3f8b0051,0x443900b9,0xf7080013,0x00000000}},	//   jscu_, æs_, hủy_,
  { {0x69d50051,0xdcfc001c,0xdddc00a2,0x00000000}},	//   _krze, turī, harš,
  { {0x3f8b000c,0x3f990046,0xc2420505,0x00000000}},	//   escu_, ersu_, иньк,
  { {0xdddc007d,0xf1c90013,0x7d041107,0x00000000}},	//   jarš, _vạ_, xhis,
  { {0xc95200b5,0xc2c50044,0xa78c009a,0x00000000}},	//   ימט_, _ليشي, ּאלֹ,
  { {0x78a20117,0x69c7017f,0xe8b5005b,0x00000000}},	//   zgov, _osje, yışı,
  { {0x7d160058,0x3f9900a8,0x386d1108,0x00000000}},	//   tiys, arsu_, _ofer_,
  { {0x7aee00cd,0xad390086,0x61360066,0x00000000}},	//   _sobt, ечує_, ráls,
  { {0xc0c9005e,0x69d51109,0x7d16107b,0x00000000}},	// [15c0] _чује_, _arze, riys,
  { {0x69d50051,0x6283110a,0xe8b5005b,0x00000000}},	//   _brze, _jeno, tışı,
  { {0x3ce900c2,0x62830fa9,0x7bc60051,0x00000000}},	//   bjav_, _meno, _wsku,
  { {0x69d50051,0x2900017d,0xe8b5005b,0x00000000}},	//   _drze, óia_, rışı,
  { {0x69d500bd,0xdb080139,0x7bc6110b,0x00000000}},	//   _erze, ólót, _usku,
  { {0x47330454,0x7cf10b19,0x6283110c,0x00000000}},	//   аніс, _hårp, _neno,
  { {0x27e00529,0x69d80146,0xdb0f017d,0x00000000}},	//   ţin_, æved, _escó,
  { {0x23ab0146,0x2cb2002b,0xb8650044,0x00000000}},	//   føj_, nfyd_, _ماكو,
  { {0x7d03000c,0x6283110d,0x69d50022,0x00000000}},	//   _înse, _beno, _zrze,
  { {0x6e29005b,0x7cf80025,0x613d110e,0x00000000}},	//   şebi, _díri, méli,
  { {0x26de0034,0x31c3005a,0xe8160053,0x00000000}},	//   _into_, асяв, _देता_,
  { {0x7cf80139,0x51f70183,0xf946014b,0x00000000}},	//   _fíri, тнюю_, ннiк_,
  { {0x62830aa8,0x7cf800be,0x69d801e1,0x00000000}},	//   _feno, _gíri, åvej,
  { {0x2cb2001f,0x6283110f,0x63a0004b,0x00000000}},	//   efyd_, _geno, mumn,
  { {0x6288094c,0xd788001b,0x8233007e,0x00000000}},	//   mado, hể_, _پروا,
  { {0x26cc04a6,0x7e62003b,0x3ead004c,0x00000000}},	//   _lado_, _şopt, řet_,
  { {0xac180001,0x26de1110,0x7c841111,0x00000000}},	// [15d0] воту_, _onto_, русе,
  { {0x69d51112,0x613d1113,0x62881114,0x00000000}},	//   _prze, déli, nado,
  { {0xf9c7005a,0x6128005b,0x60cd1115,0x00000000}},	//   ъщан, lıla, _kaam,
  { {0xf1b30047,0x63a01116,0x60cd0bda,0x00000000}},	//   יסע_, kumn, _jaam,
  { {0x26cc0009,0x612801f7,0x6d5d002c,0x00000000}},	//   _bado_, nıla, _iisa,
  { {0x69d50045,0xdb0f00cd,0x62881117,0x00000000}},	//   _trze, _escò, jado,
  { {0x26cc06b2,0x7cf80367,0x62881118,0x00000000}},	//   _dado_, _síri, dado,
  { {0x23ab0146,0x61360026,0x6b4b00ea,0x00000000}},	//   tøj_, jálp, függ,
  { {0x6b8d03d9,0xed11001b,0x6d5d1119,0x00000000}},	//   nsag, _đối_, _misa,
  { {0xa3d5016a,0x6d5d0436,0x26cc017d,0x00000000}},	//   हिब_, _lisa, _gado_,
  { {0x3495000a,0xa189000d,0x6283111a,0x00000000}},	//   _баер, эбна_, _veno,
  { {0xd5fa0047,0xd00a111b,0x6d5d111c,0x00000000}},	//   _אפער, ееме_, _nisa,
  { {0x6128005b,0x6288111d,0x60cd004e,0x00000000}},	//   gıla, bado, _daam,
  { {0x33920032,0x6b8d10c4,0x62881114,0x00000000}},	//   _الوز, dsag, cado,
  { {0xb1760013,0x6d5d111e,0xdef9000d,0x00000000}},	//   _trượ, _bisa, тыў_,
  { {0x6128005b,0x6d5d111f,0x6b8d0014,0x00000000}},	//   bıla, _cisa, fsag,
  { {0x612801f7,0x6b8d1120,0x6d5d1121,0x00000000}},	// [15e0] cıla, gsag, _disa,
  { {0x78a90331,0x09e61122,0x613d1123,0x00000000}},	//   _acev, лозн, véli,
  { {0x6b8d00a4,0x26cc1124,0x6d5d1125,0x00000000}},	//   asag, _rado_, _fisa,
  { {0x62881126,0x613d1127,0xa9260121,0x00000000}},	//   zado, téli, ыдел,
  { {0x62881128,0xbcfb0003,0x01370047,0x00000000}},	//   yado, _siég, אָגט_,
  { {0x62880367,0x613d1129,0xbcfb0003,0x00000000}},	//   xado, réli, _piég,
  { {0xe1e7006a,0x7d030529,0x6128005b,0x00000000}},	//   _اس_, _însc, zıla,
  { {0x612801f7,0x443d0185,0x63a0112a,0x00000000}},	//   yıla, _byw_, tumn,
  { {0x60cd0004,0x6288112b,0x2904112c,0x00000000}},	//   _raam, tado, _ilma_,
  { {0x26de0034,0x443d001f,0x63a00dde,0x00000000}},	//   _unto_, _dyw_, rumn,
  { {0x22580019,0xba9b0047,0x63a0007d,0x00000000}},	//   ärk_, עסטי, sumn,
  { {0x612801f7,0x443d001f,0x6b8d0164,0x00000000}},	//   tıla, _fyw_, ysag,
  { {0x6b4b004d,0x6d5d112d,0xe3af007e,0x00000000}},	//   lüge, _risa, _فرو_,
  { {0x6d5d0551,0x612801f7,0x69c50034,0x00000000}},	//   _sisa, rıla, ywhe,
  { {0xbcfb03b2,0xb816016a,0x6b4b00bd,0x00000000}},	//   _liée, _देसम_, nüge,
  { {0x612801f7,0xab5b004b,0x563b0047,0x00000000}},	//   pıla, _tsük, געלײ,
  { {0x6d5d112e,0xaae00053,0x30780021,0x00000000}},	// [15f0] _visa, नांक, _صحية_,
  { {0x6d5d00f3,0xa3d50053,0x2904112f,0x00000000}},	//   _wisa, हित_, _alma_,
  { {0x6b8d1130,0x6d5d1131,0xbcfb006c,0x00000000}},	//   ssag, _tisa, _piéd,
  { {0xd7d5000a,0x69c50034,0x317b0047,0x00000000}},	//   ижењ, rwhe, גראמ,
  { {0xdb041132,0x17550054,0xdb07013d,0x00000000}},	//   stiá, авдя, álód,
  { {0x6b4b00bd,0x443d001f,0x61fa0061,0x00000000}},	//   füge, _ryw_, kytl,
  { {0x5a440088,0x00000000,0x00000000,0x00000000}},	//   _гэта,   ,   ,
  { {0xd6180021,0x2d9e007d,0x2129004b,0x00000000}},	//   دتها_, šteg_, _njah_,
  { {0xab5b0019,0x76a70021,0x320c0066,0x00000000}},	//   _psüh, _محاك, ezdy_,
  { {0x57f40001,0x6620004c,0xdb160050,0x00000000}},	//   _упут, ázká, svyö,
  { {0x21290150,0xf8c90042,0x324505a0,0x00000000}},	//   _bjah_, _रसाय, ренг,
  { {0x33d50454,0xa3d50042,0x3a36009a,0x00000000}},	//   _вікт, हिद_, ירתם_,
  { {0x955401fb,0x320c0022,0xa9360063,0x00000000}},	//   _اخلا, azdy_, שטרה_,
  { {0x394d0016,0xa8560063,0xd1390022,0x00000000}},	//   _lhes_, יירה_, stąp_,
  { {0xad3a0054,0x764e01c8,0xff050085,0x00000000}},	//   вчає_, _úbyt, сяўн,
  { {0x25ed0053,0xc5f20063,0x6f660141,0x00000000}},	//   _अपनी_, חדל_, _квиз,
  { {0xed571133,0x6b4b004d,0xca86072d,0x00000000}},	// [1600] рот_, züge, игай,
  { {0x0d861134,0x1e961135,0xbf130044,0x00000000}},	//   _клон, _трир, _وويب,
  { {0x395f0150,0x6b4b004d,0x7e9b0063,0x00000000}},	//   _bius_, fügb, _בסיו,
  { {0x4069009a,0x00000000,0x00000000,0x00000000}},	//   ְיוּ_,   ,   ,
  { {0x67d400e1,0x6f1c0139,0x613d013d,0x00000000}},	//   солу, oirc, mélt,
  { {0x7cf81136,0xd7370054,0xc178005f,0x00000000}},	//   _víru, апії_, ypė_,
  { {0x4420000c,0x95ca1137,0x2abb009a,0x00000000}},	//   _ţi_, тула_, _שמלא,
  { {0x5e570047,0x95d70062,0x6b4b004d,0x00000000}},	//   סיקע_, рдът_, rüge,
  { {0x6f1c00bd,0xdcef007d,0x76480022,0x00000000}},	//   kirc, žeće, _wzdy,
  { {0x21290e46,0x32660896,0xf7461138,0x00000000}},	//   _sjah_, штив, _тезо,
  { {0x6f1c0290,0x98af001c,0xd62701d5,0x00000000}},	//   dirc, logā_, _кофе_,
  { {0xd5fb0047,0x23660078,0x799e002b,0x00000000}},	//   _שפאר, _tuoj_, irpw,
  { {0x69da00c2,0x9f590003,0x4432008d,0x00000000}},	//   _štel, lysé_, _ây_,
  { {0x65680035,0xa2d30021,0xada80066,0x00000000}},	//   _kudh, _وينت, zdĺž,
  { {0xe2970001,0x63390041,0x613d013d,0x00000000}},	//   _тај_, _געװױ, félt,
  { {0x65681139,0x6f1c0139,0xa3ca0082,0x00000000}},	//   _mudh, airc, _लना_,
  { {0xea670001,0x395f00cd,0x2d580376,0x00000000}},	// [1610] ањен, _rius_, рить_,
  { {0x6738007d,0x65680983,0x6f1c113a,0x00000000}},	//   jovj, _oudh, circ,
  { {0xdb06013d,0xdb1d0014,0x63b500dd,0x00000000}},	//   émáb, _orsö, ăzni,
  { {0x1869005e,0x7bcb0014,0xc7950044,0x00000000}},	//   ћали_, ægus, مشتب,
  { {0x69ca00b9,0x395f00cd,0x2d910051,0x00000000}},	//   æfer, _vius_, lsze_,
  { {0x16a906be,0x2ca90019,0x6568113b,0x00000000}},	//   увки_, lgad_, _budh,
  { {0x394d113c,0xe8df0013,0x2ca9013d,0x00000000}},	//   _thes_, _nhện_, ogad_,
  { {0x7af500ea,0x2ca9113d,0xb92500f2,0x00000000}},	//   _hozt, ngad_, _افري,
  { {0x291d0009,0x673800a8,0x6f1c0058,0x00000000}},	//   miwa_, bovj, yirc,
  { {0x291d113e,0x13060076,0xddde0240,0x00000000}},	//   liwa_, йный_, _lepš,
  { {0xdb040016,0x2d910051,0x63b60072,0x00000000}},	//   stiç, jsze_, _äynn,
  { {0x291d0035,0x14ca007e,0x91fc008f,0x00000000}},	//   niwa_, _مهمی_, ecās,
  { {0xc50c00b5,0x2ca9113f,0xb05b0050,0x00000000}},	//   _בלאָ, dgad_, seän,
  { {0x65681140,0x644b085a,0x613d00ea,0x00000000}},	//   _yudh, _izgi, féls,
  { {0x291d0009,0x6b5000c7,0xf2d20047,0x00000000}},	//   kiwa_, lägg, _מעג_,
  { {0x3c660088,0x2ca900c7,0x291d0035,0x00000000}},	//   скаг, ggad_, jiwa_,
  { {0x291d0035,0x6128005b,0x2d910022,0x00000000}},	// [1620] diwa_, nılm, asze_,
  { {0x2ca91141,0x1eca0121,0x2d910022,0x00000000}},	//   agad_, _слои_, bsze_,
  { {0x8db60086,0x60c60229,0x67380130,0x00000000}},	//   _успі, oekm, vovj,
  { {0x718a00b5,0x6128005b,0xc9850021,0x00000000}},	//   רװײַ, kılm, تشكي,
  { {0x31b100ea,0xc7a30a90,0x6738007d,0x00000000}},	//   ház_, зичк, tovj,
  { {0x6d4404bf,0x09e60062,0x98af008f,0x00000000}},	//   llia, _логн, rogā_,
  { {0x6d441142,0x291d0035,0xfb1b0063,0x00000000}},	//   olia, biwa_, _עולמ,
  { {0x539800a0,0xdb040072,0x337405ce,0x00000000}},	//   авия_, stiä, огир,
  { {0x2d851143,0x6d441144,0x6738017f,0x00000000}},	//   ález_, ilia, povj,
  { {0x6d441145,0x91b80002,0x656800ea,0x00000000}},	//   hlia, агот_, _tudh,
  { {0xe3af006a,0x69da00c3,0xf5390080,0x00000000}},	//   وری_, _štej, boť_,
  { {0xd3e4006a,0x4a5b0063,0xd46a005e,0x00000000}},	//   _وقای, טדיו, _сиде_,
  { {0x2d910045,0x6d441146,0xa01b0137,0x00000000}},	//   wsze_, dlia, dböc,
  { {0x291d1147,0x6d441148,0x644200a4,0x00000000}},	//   ziwa_, elia, _iyoi,
  { {0x2d850164,0xde590086,0xb05b0072,0x00000000}},	//   èle_, раві_, meäm,
  { {0x6d4402f6,0x91e3005e,0x2d911149,0x00000000}},	//   glia, _хоће, rsze_,
  { {0x2d9100ea,0x69d800b9,0x2ca910c8,0x00000000}},	// [1630] ssze_, æven, rgad_,
  { {0xdb510021,0x2d910051,0xbb840021,0x00000000}},	//   ذَا_, psze_, سلمي,
  { {0x291d0009,0x7d03000c,0x6128005b,0x00000000}},	//   tiwa_, _înso, zılm,
  { {0x6128005b,0xe8940086,0x628a00ea,0x00000000}},	//   yılm, заць, _lefo,
  { {0x291d113e,0x69dc114a,0x6298114b,0x00000000}},	//   riwa_, _erre, _odvo,
  { {0x7d0d03e8,0x291d114c,0x6b5000c7,0x00000000}},	//   lhas, siwa_, vägg,
  { {0xdb0d0025,0x291d0035,0x24e9114d,0x00000000}},	//   ntaí, piwa_, имки_,
  { {0x612801f7,0xa835005e,0x6298114e,0x00000000}},	//   tılm, _дебљ, _advo,
  { {0x628a114f,0x13090d82,0x248d00be,0x00000000}},	//   _befo, иний_, raem_,
  { {0x6128005b,0xe29900e1,0x69ce1150,0x00000000}},	//   rılm, јан_, _ysbe,
  { {0x60c6001c,0x6d44001f,0x90c6015a,0x00000000}},	//   tekm, ylia, обне,
  { {0x612801f7,0x7bcf1151,0x320b0051,0x00000000}},	//   pılm, _oscu, ący_,
  { {0x7529000c,0x60c6005b,0x6b500502,0x00000000}},	//   mnez, rekm, läge,
  { {0x26c710ca,0x6d44001f,0x628a1152,0x00000000}},	//   neno_, wlia, _gefo,
  { {0x7bcf000c,0x7529003b,0x62811153,0x00000000}},	//   _ascu, onez, mblo,
  { {0x26c71154,0x62811155,0x7d0d1156,0x00000000}},	//   heno_, lblo, ghas,
  { {0x6d441157,0x62811158,0x8c431159,0x00000000}},	// [1640] rlia, oblo, дете,
  { {0x98ad0024,0x26c7115a,0x0ae70062,0x00000000}},	//   _cieľ_, jeno_, одуй_,
  { {0x7bcf094c,0x26c7115b,0x6d44115c,0x00000000}},	//   _escu, deno_, plia,
  { {0x31ba0047,0xdb040025,0x7d0d115d,0x00000000}},	//   יזענ, ntiú, chas,
  { {0x6281115e,0xdb040139,0xa6ca0074,0x00000000}},	//   kblo, itiú, илда_,
  { {0x7d04024a,0x26c7115f,0x75291160,0x00000000}},	//   lkis, geno_, enez,
  { {0x62811161,0xb0aa0053,0x69ce1162,0x00000000}},	//   dblo, _कांग, _usbe,
  { {0x888607b0,0x62811163,0x7d041164,0x00000000}},	//   _флаж, eblo, nkis,
  { {0x26c70def,0x39461165,0xd94302d8,0x00000000}},	//   beno_, mlos_, _цети,
  { {0x39461166,0x7d0d00ea,0x20d70013,0x00000000}},	//   llos_, zhas, _ủi_,
  { {0xfd4d008b,0xdb040331,0xa1740085,0x00000000}},	//   ghiệ, guié, ягні,
  { {0x3946004d,0x10740054,0x38600130,0x00000000}},	//   nlos_, млюю, žiru_,
  { {0x39461167,0x645d0078,0x68e40072,0x00000000}},	//   ilos_, žsir, öidy,
  { {0xf1a61168,0xdb040003,0x7d040072,0x00000000}},	//   _дрин, quiè, ekis,
  { {0x61fc00c7,0x98af0006,0xc27b0047,0x00000000}},	//   ärld, logą_, _דרוי,
  { {0xdb040027,0x459b0047,0x26c70be1,0x00000000}},	//   ctiú, יסלע, zeno_,
  { {0x7d0d1169,0xdb0d0025,0x3946004d,0x00000000}},	// [1650] rhas, staí, dlos_,
  { {0x39460b23,0x657a00ea,0x7d04116a,0x00000000}},	//   elos_, _otth, akis,
  { {0x7d0d116b,0x3946004d,0xceb203c3,0x00000000}},	//   phas, flos_, _איי_,
  { {0x3946116c,0xcdda00b5,0xed58000a,0x00000000}},	//   glos_, _פֿיר, _моќ_,
  { {0x60dc00b5,0x69d80137,0x66e50062,0x00000000}},	//   יקאנ, åver, зола,
  { {0x3946116d,0x26c70331,0xff7c07e9,0x00000000}},	//   alos_, ueno_, סטומ,
  { {0x3946116e,0x26c7116f,0xa5f6005e,0x00000000}},	//   blos_, reno_, зеју_,
  { {0x6b5000bd,0x613600ea,0xcdaa0047,0x00000000}},	//   räge, bály, ציפֿ,
  { {0x6b500137,0x62810109,0x657a04aa,0x00000000}},	//   säge, tblo, _etth,
  { {0x753b0080,0x1309014c,0x7d04009c,0x00000000}},	//   souz, сной_, zkis,
  { {0x753b007c,0xcb120063,0x7d040246,0x00000000}},	//   pouz, גלי_, ykis,
  { {0x62811170,0xbcfb0331,0x3d050042,0x00000000}},	//   sblo, _sién, रसों_,
  { {0xb4d70053,0x62811171,0x7fd50054,0x00000000}},	//   ायी_, pblo, мірі,
  { {0x3f9e016b,0x3ebe0026,0x61280058,0x00000000}},	//   čtu_, ýtt_, zılh,
  { {0x63a91172,0xdb040164,0xbcfb006d,0x00000000}},	//   luen, quié, _vién,
  { {0xa01b0026,0x25710026,0x61fc01bb,0x00000000}},	//   mbön, _mál_, ärle,
  { {0x7d040bcf,0xfbdf017d,0x63a90399,0x00000000}},	// [1660] rkis, _crê_, nuen,
  { {0xe8160161,0xa3dc0042,0x7d041173,0x00000000}},	//   _देगा_, डित_, skis,
  { {0x257100ea,0x3946004d,0x7d040058,0x00000000}},	//   _nál_, tlos_, pkis,
  { {0x63a9028d,0x39460d90,0x57ea0456,0x00000000}},	//   kuen, ulos_, йдем_,
  { {0x2efa00bd,0x39461174,0xdcf7000c,0x00000000}},	//   _kopf_, rlos_, şcăr,
  { {0xc58a0121,0x39461175,0x60d600e5,0x00000000}},	//   бщие_, slos_, _laym,
  { {0x3946039f,0x5554005d,0x7d15013d,0x00000000}},	//   plos_, وپتر, _ügsé,
  { {0xd3a60086,0x25710080,0x63a90331,0x00000000}},	//   проп, _dál_, fuen,
  { {0x63a902f6,0x07a3000a,0x94730021,0x00000000}},	//   guen, _патн, رديا,
  { {0xa3ab0053,0x957c0022,0xa3180054,0x00000000}},	//   गढ़_, _prąd, іжну_,
  { {0xbcfb0003,0x645d0078,0x29060050,0x00000000}},	//   _biél, žsip, okoa_,
  { {0x63a91176,0x29060072,0x60d61177,0x00000000}},	//   buen, nkoa_, _caym,
  { {0x63a9048e,0x5f94011c,0xdbf1004c,0x00000000}},	//   cuen, ният, tříc,
  { {0x6b960618,0x2efa009c,0x41730043,0x00000000}},	//   dsyg, _copf_, بایس,
  { {0x290600fe,0x2d9e027c,0xb2bb0063,0x00000000}},	//   kkoa_, šten_, _המור,
  { {0x6144000a,0x645d0014,0x5cb90085,0x00000000}},	//   _пеја, ýsig, ўлаў_,
  { {0xa3d50053,0xdb990054,0xec3402fa,0x00000000}},	// [1670] हिए_, ювач_, енть,
  { {0x7bcd002b,0x2bb80044,0x00000000,0x00000000}},	//   rwau, ثافة_,   ,
  { {0x60d60058,0x5d55080b,0x66f00082,0x00000000}},	//   _yaym, _окот, चानक_,
  { {0x5fb10042,0x25e00042,0x6d88009a,0x00000000}},	//   _जमाल, किनी_, _מָשְ,
  { {0xd7f8005e,0x98f40021,0x78a4013d,0x00000000}},	//   зуј_, عثما, óiva,
  { {0x85790076,0x257100ea,0xd00c0063,0x00000000}},	//   осит_, _pál_, מּוֹ,
  { {0x69da0198,0x20020051,0x28a70085,0x00000000}},	//   _štev, zyki_, _ншаг,
  { {0x6b4b00bd,0xb4d70053,0x2907008f,0x00000000}},	//   zügl, ाये_, īnas_,
  { {0x2f0f00bd,0x68e91178,0x2be00053,0x00000000}},	//   _züge_, _ined, निया,
  { {0x68fb02b0,0xdddc0006,0x68e90066,0x00000000}},	//   _houd, varž, _hned,
  { {0x67231179,0x60d6117a,0x68fb117b,0x00000000}},	//   minj, _paym, _koud,
  { {0x6723117c,0x20020051,0x68fb0072,0x00000000}},	//   linj, tyki_, _joud,
  { {0x212200e3,0x68fb117d,0x63a9117e,0x00000000}},	//   rikh_, _moud, quen,
  { {0x6723117f,0x7f19000d,0x20020051,0x00000000}},	//   ninj, пісу_, ryki_,
  { {0x68e90024,0x6e430d34,0xdd1c004a,0x00000000}},	//   _oned, верз, _vážn,
  { {0xdb0d00bd,0x7bc3000c,0x6723082a,0x00000000}},	//   traß, ănun, hinj,
  { {0x6723082a,0xe3b900ea,0x2f560121,0x00000000}},	// [1680] kinj, ntű_, _отос,
  { {0x68e91180,0x290d003b,0x6b9601e1,0x00000000}},	//   _aned, _alea_, rsyg,
  { {0x67231181,0x3ebe0019,0x29060072,0x00000000}},	//   dinj, õttu_, tkoa_,
  { {0x66030051,0x58ba0021,0x07a6000d,0x00000000}},	//   dynk, تائج_, дадн,
  { {0x4c360088,0x67231182,0x29060072,0x00000000}},	//   _цэнт, finj, rkoa_,
  { {0x8f890063,0xdddc0051,0x68e9057c,0x00000000}},	//   פְנֵ, karż, _ened,
  { {0xd5af005a,0x68fb1183,0x66e3007b,0x00000000}},	//   ъс_, _foud, тоја,
  { {0x68fb1184,0x25a00fff,0x88c60021,0x00000000}},	//   _goud, čil_, _تتسل,
  { {0x7afc1185,0x644e0051,0x67231186,0x00000000}},	//   _kort, ębio, binj,
  { {0x68fb0122,0x6723007d,0x3944004e,0x00000000}},	//   _zoud, cinj, _hkms_,
  { {0x2d9e0080,0x36060242,0x7afc0e5c,0x00000000}},	//   átel_, _تواف, _mort,
  { {0xbcfb0003,0x957c0022,0xe5060044,0x00000000}},	//   _piém, _trąb, _تبطي,
  { {0x7afc00e8,0xd467005e,0x2d9e0077,0x00000000}},	//   _oort, _жице_, štel_,
  { {0x7afc095b,0x15f20082,0xa6f8009a,0x00000000}},	//   _nort, _अपार_, הִֽי,
  { {0xccfb0001,0x64550051,0xdb0d017d,0x00000000}},	//   оћа_, ęzie, ltaç,
  { {0x6b5000c7,0xdb04006f,0xa115007e,0x00000000}},	//   väga, brië, _سوخت,
  { {0xdb0d03d9,0x7afc1187,0x66030022,0x00000000}},	// [1690] ntaç, _bort, zynk,
  { {0x68fb1188,0xdb0d017d,0x7afc1189,0x00000000}},	//   _soud, itaç, _cort,
  { {0x68fb118a,0x6723074f,0x7afc118b,0x00000000}},	//   _poud, vinj, _dort,
  { {0x2d83006f,0x08d40054,0xe7f30042,0x00000000}},	//   mpje_, кція, _आपदा_,
  { {0x68fb0164,0x26170053,0x6723118c,0x00000000}},	//   _voud, _भेजी_, tinj,
  { {0x68fb006f,0x6b500137,0x7afc118d,0x00000000}},	//   _woud, lägn, _gort,
  { {0xe81f0053,0x6723118e,0x7648001f,0x00000000}},	//   _मेरा_, rinj, _cydy,
  { {0x68e9035a,0x7648001f,0x6128005b,0x00000000}},	//   _uned, _dydy, nılt,
  { {0x3735000d,0x386d118f,0x67231190,0x00000000}},	//   _знаё, _iger_, pinj,
  { {0xcb1200b5,0xf7720063,0xfbd20063,0x00000000}},	//   ָלט_, _עקב_, נתי_,
  { {0x03220088,0x3f990026,0x7d0f013d,0x00000000}},	//   удэн, essu_, _olcs,
  { {0xdb04006f,0xe8df0013,0x2d9e004c,0x00000000}},	//   trië, _khốn_, átem_,
  { {0x13f4005a,0x6d5a00cd,0x2d83006f,0x00000000}},	//   _изця, ïtam, epje_,
  { {0x2d9e007d,0xdb04006f,0x61ee0139,0x00000000}},	//   štem_, rrië, óilí,
  { {0x2f1401e3,0x63bb1191,0x2d8c0164,0x00000000}},	//   _lägg_, ltun, ède_,
  { {0xc5f200b5,0x386d0137,0x7afc1192,0x00000000}},	//   נדן_, _nger_, _sort,
  { {0x63bb1193,0x7afc1194,0xe81f0042,0x00000000}},	// [16a0] ntun, _port, _मेला_,
  { {0x63bb1195,0x7fd70063,0x7d0f013d,0x00000000}},	//   itun, _טופס_, _elcs,
  { {0x7afc07c7,0xfd4a0062,0xfbdf0013,0x00000000}},	//   _vort, _нзок_, _uyên_,
  { {0x76480185,0x7afc0359,0xb17a0047,0x00000000}},	//   _rydy, _wort, לטער,
  { {0x7afc057a,0x3913007e,0x6d461196,0x00000000}},	//   _tort, دونز, _ikka,
  { {0x98c5001c,0x6b841197,0xcf930063,0x00000000}},	//   ītās_, mpig, נטו_,
  { {0xceb30149,0xdb040003,0x60c4007d,0x00000000}},	//   טיג_, vriè, _obim,
  { {0x63bb00bd,0x1543007b,0x95c3005d,0x00000000}},	//   ftun, лејм, اييه,
  { {0xd4e30055,0xdb040164,0x63bb1198,0x00000000}},	//   ующи, triè, gtun,
  { {0xdb0d0016,0x0bb70063,0x6b840c55,0x00000000}},	//   rtaç, עלים_, ipig,
  { {0x6d46007a,0xdb040164,0xdb0d0016,0x00000000}},	//   _okka, rriè, staç,
  { {0xdb0d017d,0x76440075,0xf946014b,0x00000000}},	//   ptaç, ğiyd, мнiк_,
  { {0xa01b013d,0x76440075,0x389b009a,0x00000000}},	//   mbök, şiyd, היכנ,
  { {0x5453019d,0x32050080,0xc2c40049,0x00000000}},	//   _світ, byly_, _شيعي,
  { {0x7c870001,0xac950f63,0x0dc81199,0x00000000}},	//   еузе, кавш, нути_,
  { {0x2d83006f,0x38690734,0x22620022,0x00000000}},	//   rpje_, žari_, ęskę_,
  { {0x6b8400a4,0x8aa70928,0xfaa70f34,0x00000000}},	// [16b0] gpig, еред, ешен,
  { {0x2fc900a4,0x60dd119a,0x69d5119b,0x00000000}},	//   _ipag_, ldsm, _psze,
  { {0x6b84119c,0xf9930242,0x798e002b,0x00000000}},	//   apig, ابط_, _cwbw,
  { {0x2fc900a4,0x7d0f00ea,0xd23b0063,0x00000000}},	//   _kpag_, _ulcs, הגבל,
  { {0xb8c90161,0x69d50045,0x9e67007e,0x00000000}},	//   _गए_, _wsze, _تاکن,
  { {0x6d4d0d9e,0x2f140137,0x66b20002,0x00000000}},	//   llaa, _vägg_, абљу,
  { {0x798e001f,0x6d460026,0x05a90054,0x00000000}},	//   _gwbw, _ykka, євий_,
  { {0x386d0146,0x60dd00b9,0x6d4d119d,0x00000000}},	//   _uger_, jdsm, nlaa,
  { {0x7d03000c,0x63bb051a,0xdcfc001c,0x00000000}},	//   _însu, utun, nprā,
  { {0x75220290,0x613d10fd,0x6b4b004d,0x00000000}},	//   _emoz, mély, fügi,
  { {0x6d4d0004,0x2fc9002c,0x63bb119e,0x00000000}},	//   klaa, _apag_, stun,
  { {0xbcfb017d,0x6d5a0006,0x63bb119f,0x00000000}},	//   _fiéi, įtak, ptun,
  { {0x2f140cbf,0x6b8401db,0x889a0063,0x00000000}},	//   _läge_, xpig, וברי,
  { {0xdb0403b2,0x656b11a0,0x6d4d11a1,0x00000000}},	//   prié, _high, elaa,
  { {0x7e230001,0x6d4d0072,0x644b11a2,0x00000000}},	//   адрж, flaa, _hygi,
  { {0x657c00ea,0x63a911a3,0x6d4d11a4,0x00000000}},	//   _érhe, oren, glaa,
  { {0x656b0037,0x63a911a5,0x765c0061,0x00000000}},	// [16c0] _migh, nren, _úryv,
  { {0x656b0034,0x613d00ea,0x63a911a6,0x00000000}},	//   _ligh, dély, iren,
  { {0xdb1d0146,0x63a909f8,0x644b00eb,0x00000000}},	//   _opsæ, hren, _lygi,
  { {0x656b0034,0x6b8411a7,0xdcfc001c,0x00000000}},	//   _nigh, ppig, bprā,
  { {0xab660051,0x63a911a8,0x6843066e,0x00000000}},	//   _pożą, jren, анца,
  { {0xfaa60121,0x501b0063,0x6d44003b,0x00000000}},	//   _шаго, וונו, loia,
  { {0xdb0402dd,0x63a911a9,0xe8df008d,0x00000000}},	//   stió, eren, _chồn_,
  { {0x6d4401f4,0x7d03003b,0x7d16002b,0x00000000}},	//   noia, _înst, nhys,
  { {0x63a911aa,0x656b01f4,0xd8770044,0x00000000}},	//   gren, _digh, _شملت_,
  { {0x656b0034,0x86ea0021,0x51f80086,0x00000000}},	//   _eigh, _تعرف_, еною_,
  { {0x656b0034,0x63a911ab,0xe80e0042,0x00000000}},	//   _figh, aren, ़ैरा_,
  { {0x94260055,0x452a0062,0x63a911ac,0x00000000}},	//   _имее, _южен_, bren,
  { {0x6d4411ad,0x60dd11ae,0x63a911af,0x00000000}},	//   doia, rdsm, cren,
  { {0x9f600026,0x7d160072,0xdb25013d,0x00000000}},	//   ærðu_, ehys, épül,
  { {0x6d4d11b0,0xce940062,0x6b500e77,0x00000000}},	//   tlaa, расъ, rägl,
  { {0x1bd50062,0x7d16002b,0x2d580505,0x00000000}},	//   лобя, ghys, вись_,
  { {0xdc5501aa,0x6d4d0250,0xfbd00021,0x00000000}},	// [16d0] увањ, rlaa, يتك_,
  { {0x6d4d0a53,0xf1b60053,0xab28005e,0x00000000}},	//   slaa, _अमान, вођа_,
  { {0x6d4d11b1,0x2578013d,0x38bd013d,0x00000000}},	//   plaa, _nél_, járó_,
  { {0xe0df051e,0x6d4401a8,0x63a911b2,0x00000000}},	//   ndò_, coia, yren,
  { {0x656b11b3,0xfd5611b4,0x7d0d11b5,0x00000000}},	//   _righ, _תשרי_, mkas,
  { {0x656b11b6,0xe8df0013,0x63a911b7,0x00000000}},	//   _sigh, _phồn_, vren,
  { {0x257800ea,0x1994000d,0x7d0d11b8,0x00000000}},	//   _cél_, _вася, okas,
  { {0x63a911b9,0x257811ba,0x693c007d,0x00000000}},	//   tren, _dél_, včeg,
  { {0x63a911bb,0xbcfb006c,0x7d0d11bc,0x00000000}},	//   uren, _fiév, ikas,
  { {0xe1f90055,0x257800ea,0x63a909b7,0x00000000}},	//   его_, _fél_, rren,
  { {0x7d0d11bd,0x656b11be,0x9afa0063,0x00000000}},	//   kkas, _tigh, תפתח,
  { {0x7fb6000d,0x63a90399,0x656b11bf,0x00000000}},	//   лёгі, pren, _uigh,
  { {0x7d0d11c0,0x6d4400dd,0x03a50133,0x00000000}},	//   dkas, voia, _сило,
  { {0x7d0d11c1,0xfd65008d,0x752911c2,0x00000000}},	//   ekas, _truồ, liez,
  { {0x7d0d11c3,0xdb04017d,0xdd1d004c,0x00000000}},	//   fkas, luiç, lářs,
  { {0x9f4000cd,0x7d0d11c4,0x7e7c007d,0x00000000}},	//   _triï_, gkas, scrp,
  { {0x38bd00ea,0xdb04017d,0xdd1d004c,0x00000000}},	// [16e0] záró_, nuiç, nářs,
  { {0x7d0d11c5,0x8a3a0076,0x945d0051,0x00000000}},	//   akas, няет_, leńs,
  { {0x8886005a,0xb05b004d,0x5d6a0002,0x00000000}},	//   глеж, nfän, _пиом_,
  { {0x7aeb001c,0xb866005d,0x7d0d11c6,0x00000000}},	//   ēgta, هاشو, ckas,
  { {0xa3d20053,0xdd1d0080,0x7529003b,0x00000000}},	//   _हैं_, jářs, diez,
  { {0xdd1d0080,0x05b40021,0x6b4b087d,0x00000000}},	//   dářs, لمتح, fügu,
  { {0x645d0ac6,0xceb3014e,0xe5c611c7,0x00000000}},	//   ýsin, ציה_, усло,
  { {0x25780014,0x61fc00a5,0x7c29017c,0x00000000}},	//   _vél_, ärlm, _žeri,
  { {0xdb04017d,0x2578006f,0x28dd0053,0x00000000}},	//   guiç, _wél_, _नोटि,
  { {0x9bbb00b5,0x394611c8,0x20e1008d,0x00000000}},	//   עציפ, loos_, _ỗi_,
  { {0xaac60161,0xd250006a,0x7bc3003b,0x00000000}},	//   र्यक, تند_, ănui,
  { {0xdb040016,0xd257000d,0x752911c9,0x00000000}},	//   buiç, ыцы_, ciez,
  { {0xa3b30161,0xe0df0290,0x7d0d11ca,0x00000000}},	//   जूद_, rdò_, vkas,
  { {0x26de11cb,0x3dda004d,0x1ee7005d,0x00000000}},	//   _jato_, _bspw_, دوسی_,
  { {0xc27b00b5,0x7d0d11cc,0xb352008d,0x00000000}},	//   _ארוי, tkas, củab,
  { {0x26de11cd,0xf1a90161,0x629a0d11,0x00000000}},	//   _lato_, _कितन, lato,
  { {0x7d0d11ce,0x394611cf,0x2aab005e,0x00000000}},	// [16f0] rkas, doos_, етео_,
  { {0x212b0199,0x6eb20053,0x7d0d11d0,0x00000000}},	//   lich_, _जाएँ, skas,
  { {0x6907000d,0x7d0d11d1,0x212b0022,0x00000000}},	//   лядз, pkas, oich_,
  { {0x629a11d2,0x212b11d3,0xdb040046,0x00000000}},	//   hato, nich_, stið,
  { {0x6b4b004d,0x6d5d11d4,0xab5b01a8,0x00000000}},	//   fügt, _ihsa, _aqüe,
  { {0x212b0037,0x7ceb00c7,0x945d0051,0x00000000}},	//   hich_, _förä, zeńs,
  { {0x212b0045,0x629a11d5,0x9f440080,0x00000000}},	//   kich_, dato, ímé_,
  { {0xdb040016,0x212b016b,0xa5f6005e,0x00000000}},	//   tuiç, jich_, рећу_,
  { {0x26de0016,0x7529001c,0xab5b01a8,0x00000000}},	//   _fato_, riez, _eqüe,
  { {0xa1c50088,0x13090076,0xdb040016,0x00000000}},	//   абод, тной_, ruiç,
  { {0x752911d6,0xcb140063,0x2745004c,0x00000000}},	//   piez, מלץ_, ríně_,
  { {0x9567011c,0x26de11d7,0x212b0051,0x00000000}},	//   _създ, _zato_, gich_,
  { {0x248d017d,0x6446004b,0x629a11d8,0x00000000}},	//   mbem_, ükit, bato,
  { {0x6d5d0035,0xb05b11d9,0x629a071d,0x00000000}},	//   _ahsa, pfän, cato,
  { {0xb05b089f,0x7c9611da,0xde0311db,0x00000000}},	//   lfäl, ирац, опри,
  { {0x212b034d,0xdb0400fe,0x3f8d003b,0x00000000}},	//   cich_, ntiö, ţeua_,
  { {0xb05b00bd,0x998d007d,0x6b50004d,0x00000000}},	// [1700] nfäl, _ćeš_, lägi,
  { {0x305b0063,0x9f9b0063,0xdb040072,0x00000000}},	//   _בדפד, _שסיפ, htiö,
  { {0xbcfb0003,0x26de11dc,0x693c00a8,0x00000000}},	//   _piét, _rato_, jčec,
  { {0xb05b00c7,0xe7860086,0x629a11dd,0x00000000}},	//   kfäl, ауко, zato,
  { {0x26de11de,0x87ba0121,0xa81a0049,0x00000000}},	//   _pato_, тует_, ختار_,
  { {0x248d00cd,0xc986007e,0xb5a600a0,0x00000000}},	//   ebem_, _نشري, арий,
  { {0xb05b0244,0x629a11df,0x96f70044,0x00000000}},	//   efäl, vato, شعور_,
  { {0xbcfb0003,0xd94305c5,0xdb04017d,0x00000000}},	//   _hiér, _деси, briã,
  { {0x5397000d,0xbcfb00ea,0x26de11e0,0x00000000}},	//   авыя_, _kiér, _tato_,
  { {0x68e011e1,0xe5a60054,0x68e2004b,0x00000000}},	//   _hamd, _вижи, ldod,
  { {0xd25a005a,0x290411e2,0x212b11e3,0x00000000}},	//   ъци_, _koma_, tich_,
  { {0x64460019,0x2d570058,0xddd40022,0x00000000}},	//   ükis, eçen_, łaśn,
  { {0x2f1400c7,0x212b11e4,0xa3dc0053,0x00000000}},	//   _säga_, rich_, डिओ_,
  { {0x69dc00c3,0x69ce11e5,0x23270002,0x00000000}},	//   _osre, _opbe, _кочи_,
  { {0x4d27000a,0x2d8503a8,0x70950062,0x00000000}},	//   аќаа, ële_, _лайф,
  { {0x2f140004,0x5c7511e6,0x68e000d1,0x00000000}},	//   _väga_, слат, _namd,
  { {0x68e20185,0xa3dc0161,0xfc670062,0x00000000}},	// [1710] ddod, डिट_, ръвн,
  { {0xf1da0053,0xbcfb0331,0x4ea70cd6,0x00000000}},	//   _बनान, _ciér, _триа,
  { {0x3f8b00c3,0xf8750021,0xceb20041,0x00000000}},	//   lpcu_, مهاج, _ציט_,
  { {0x32370047,0xc879005b,0x68e011e7,0x00000000}},	//   סטאן_, _başa_, _camd,
  { {0x27e902dd,0x68e0002c,0x6298006f,0x00000000}},	//   ían_, _damd, _oevo,
  { {0x62980f6f,0xc7240086,0x7bdd11e8,0x00000000}},	//   _nevo, одій, _issu,
  { {0xe7f30053,0x63a211e9,0x27e6004d,0x00000000}},	//   _आपका_, _avon, avon_,
  { {0xce380063,0x68e0001f,0x290407a8,0x00000000}},	//   יאות_, _gamd, _goma_,
  { {0xa3d20053,0xb815005e,0xd7e40054,0x00000000}},	//   हौल_, _удај, _міфо,
  { {0xf7700032,0xb05b0832,0x63a200a8,0x00000000}},	//   _قال_, rfäl, _dvon,
  { {0x7c3b007a,0xb05b0502,0x321101d9,0x00000000}},	//   _þurf, sfäl, ázy_,
  { {0x80fa0002,0x628e0014,0x68f9009a,0x00000000}},	//   ухот_, ðbor, אלֹה,
  { {0x43850032,0x63850001,0x61ea00f5,0x00000000}},	//   _التق, _угла, _erfl,
  { {0x62980102,0x68e20c39,0x8e8311ea,0x00000000}},	//   _gevo, zdod, згре,
  { {0x321e0051,0x9f40017d,0x7bdd11eb,0x00000000}},	//   czty_, _criá_, _assu,
  { {0x31a301f7,0x614311ec,0x628111ed,0x00000000}},	//   mız_, _неща, lclo,
  { {0xed570079,0x290411ee,0x3f5601e1,0x00000000}},	// [1720] сот_, _roma_, læum_,
  { {0x29040009,0x68e011ef,0x7ed50086,0x00000000}},	//   _soma_, _samd, _діюч,
  { {0x31a304ab,0xe0df0268,0xea5a0002,0x00000000}},	//   nız_, clòs_, урај_,
  { {0xa9670062,0xc87911f0,0x61fc092e,0x00000000}},	//   биха_, _paşa_, ärli,
  { {0xe1e7007e,0x68e211f1,0x765a0022,0x00000000}},	//   _کس_, rdod, _szty,
  { {0x27e611f2,0x47330054,0xa0570041,0x00000000}},	//   rvon_, пніс, זױנס_,
  { {0x290411f3,0x69dc017f,0x76a90086,0x00000000}},	//   _toma_, _usre, ртів_,
  { {0x25610026,0x7644005b,0x31a30058,0x00000000}},	//   hólf_, şiyo, dız_,
  { {0x7d060006,0x2613008b,0x97bd0500,0x00000000}},	//   _moks, ạo_, _архi,
  { {0x31a30058,0x7d0611f4,0x8c1b009a,0x00000000}},	//   fız_, _loks, טופי,
  { {0x14ca0055,0x60f90fd9,0x2d9e11f5,0x00000000}},	//   _были_, ання_, âtel_,
  { {0x7d0611f6,0x056611f7,0x320c0022,0x00000000}},	//   _noks, _увен, rydy_,
  { {0x657a0035,0x321e0051,0x62980229,0x00000000}},	//   _huth, szty_, _tevo,
  { {0x657a0474,0x543b0047,0x98bd0051,0x00000000}},	//   _kuth, _געדא, mową_,
  { {0x7d0611f8,0x98bd0051,0x91860242,0x00000000}},	//   _boks, lową_, _اجتم,
  { {0xf2370063,0xdb160072,0x5d5501dd,0x00000000}},	//   _לרוץ_, htyä, ікат,
  { {0xba990086,0x657a11f9,0x2d9e11fa,0x00000000}},	// [1730] иває_, _luth, áter_,
  { {0x9f530051,0x6d5a00ca,0xdb04013d,0x00000000}},	//   ądów_, ïtar, triá,
  { {0xc27b00b5,0x7bc400cd,0xdb0d0014,0x00000000}},	//   ארבי, atiu, ptaþ,
  { {0x7644005b,0x98bd0051,0x35c20042,0x00000000}},	//   ğiyl, kową_, _शहज़,
  { {0x7bc411fb,0x2b93007e,0x657a081b,0x00000000}},	//   ctiu, _ریاس, _auth,
  { {0x8f9c0047,0xdb16008b,0x31a3005b,0x00000000}},	//   ריגי, huyê, yız_,
  { {0x395f0037,0x7d06005b,0x6b8d0f89,0x00000000}},	//   _thus_, _yoks, lpag,
  { {0x2a7b0006,0x69c511fc,0xb38511fd,0x00000000}},	//   šybą_, mthe, олил,
  { {0x6b8d0122,0x693c00c2,0x657a11fe,0x00000000}},	//   npag, očen, _euth,
  { {0xf1c30080,0x6b8d11ff,0xe2990001,0x00000000}},	//   _naší_, ipag, шао_,
  { {0x3f89014f,0x657a1200,0x69c51201,0x00000000}},	//   _atau_, _guth, nthe,
  { {0xe56e019d,0x6b8d0122,0x69c51202,0x00000000}},	//   _із_, kpag, ithe,
  { {0x31a3005b,0xb05b004d,0x69c5030c,0x00000000}},	//   sız_, nfäh, hthe,
  { {0x6b8d006f,0x60cd0019,0x69c51203,0x00000000}},	//   dpag, _ebam, kthe,
  { {0xec9a00d7,0x693c0240,0x6b8d1204,0x00000000}},	//   итај_, dčen, epag,
  { {0xa01b01bb,0x69c51205,0x7bc41206,0x00000000}},	//   rbör, dthe, ttiu,
  { {0x7d0602ab,0x6b8d1207,0x69c51208,0x00000000}},	// [1740] _voks, gpag, ethe,
  { {0x78a91209,0xdb04017d,0xab5b004d,0x00000000}},	//   _adev, iriç, _spür,
  { {0x69c5120a,0x6b8d002c,0x7bc4120b,0x00000000}},	//   gthe, apag, stiu,
  { {0x6b8d120c,0x7bc4120d,0x693c00c2,0x00000000}},	//   bpag, ptiu, ačen,
  { {0x2ca00eef,0xdb1600fe,0x69c5120e,0x00000000}},	//   maid_, ttyä, athe,
  { {0x291d00f3,0x69c5004d,0x2ca0120f,0x00000000}},	//   ahwa_, bthe, laid_,
  { {0x27ed1210,0xd5b00021,0x69c500ca,0x00000000}},	//   _eren_, رفة_, cthe,
  { {0x291d0009,0xa5070001,0x98bd0051,0x00000000}},	//   chwa_, жећа_, tową_,
  { {0xdddc007d,0x27ed0a3f,0xb05b00a5,0x00000000}},	//   jbrž, _gren_, rfäk,
  { {0xbcfb0025,0x2ca00123,0x657a1211,0x00000000}},	//   _mhéa, haid_, _tuth,
  { {0x6603000a,0xdcfc0006,0x2ca00019,0x00000000}},	//   _опфа, sprę, kaid_,
  { {0x2ca01212,0x612b1213,0x98bd0022,0x00000000}},	//   jaid_, рцог_, pową_,
  { {0xdb040016,0xada20024,0x5f94005a,0x00000000}},	//   criç, _šúpl, мият,
  { {0xa3d70053,0xadbd0085,0x69c51214,0x00000000}},	//   ाबर_, лагi, ythe,
  { {0xf1c302f4,0x2ca0001f,0xdb0d0003,0x00000000}},	//   _vaší_, faid_, fraî,
  { {0xbcfb0025,0x6b8d006f,0xccf80001,0x00000000}},	//   _bhéa, tpag, оћу_,
  { {0xbcfb0027,0x0ca8005a,0x693c0080,0x00000000}},	// [1750] _chéa, ютри_, tčen,
  { {0xbcfb0027,0x6b8d1215,0x693c0be1,0x00000000}},	//   _dhéa, rpag, učen,
  { {0x6b8d0122,0x291d00ac,0x69c80137,0x00000000}},	//   spag, thwa_, _ädel,
  { {0xbcfb0025,0x27ed1216,0x69c51217,0x00000000}},	//   _fhéa, _pren_, rthe,
  { {0x6cfa014e,0x6d4d0923,0x69c51218,0x00000000}},	//   _הפרס, moaa, sthe,
  { {0x291d10ca,0xb05b004d,0x5a47000d,0x00000000}},	//   shwa_, rfäh, _дэба,
  { {0xb05b00bd,0x693c007d,0x27ed1219,0x00000000}},	//   sfäh, očel, _wren_,
  { {0xd4d9019d,0xdb04017d,0x27ed121a,0x00000000}},	//   ські_, triç, _tren_,
  { {0x249f121b,0x27ed0122,0xe3b10021,0x00000000}},	//   raum_, _uren_, ررة_,
  { {0x6b500137,0xb2250f8d,0x20e8008d,0x00000000}},	//   lägr, змол, _ởi_,
  { {0xdb0d02dd,0x06760047,0x25710130,0x00000000}},	//   ntañ, _זײער_, _ušlo_,
  { {0xdb0d0250,0x6908009a,0x00000000,0x00000000}},	//   kraï, ַּרְ,   ,
  { {0x2ca00004,0x645d0019,0x2458000d,0x00000000}},	//   vaid_, üsid, _даць_,
  { {0x656900bd,0xdb1c121c,0x693c08b7,0x00000000}},	//   lmeh, özün, ečel,
  { {0xdb0d0164,0xbcfb0025,0x2ca0121d,0x00000000}},	//   traî, _shéa, taid_,
  { {0x6d4d00a4,0x6569004d,0x3b8608a7,0x00000000}},	//   goaa, nmeh, злаг,
  { {0x65690035,0x1d07121e,0x2ca0121f,0x00000000}},	// [1760] imeh, чети_, raid_,
  { {0x6b5000c7,0x693c02f7,0x98bd0022,0x00000000}},	//   vägs, ačel, mowę_,
  { {0x1e970063,0x2ca01220,0xdb0d003b,0x00000000}},	//   _מכיל_, paid_, praî,
  { {0xbcfb0027,0xa9670062,0xdb0d10a1,0x00000000}},	//   _théa, пиха_, braï,
  { {0xdb0400e8,0x48790054,0x61e6008f,0x00000000}},	//   nsië, ісця_, ākli,
  { {0x7d040031,0xdbc70019,0x96ba02fe,0x00000000}},	//   ljis, tööt, суду_,
  { {0xdb0400c7,0x9f4000ac,0xd5af000d,0x00000000}},	//   rriä, _asië_, эс_,
  { {0xdce4017f,0x7d160006,0x27f7004c,0x00000000}},	//   kmič, nkys, ádný_,
  { {0xdb0d0026,0xd9430336,0x7c241221,0x00000000}},	//   otað, _чети, nzir,
  { {0x65690024,0xdb0d0026,0x98bd0051,0x00000000}},	//   ameh, ntað, dowę_,
  { {0x656200f3,0x86750088,0xdb0d0014,0x00000000}},	//   _thoh, _жыцц, itað,
  { {0x2d57005b,0x7aeb008f,0xaa370149,0x00000000}},	//   rçek_, ēgti, לטיק_,
  { {0x50640138,0xdb0400ac,0xdb0d0014,0x00000000}},	//   етра, rsiê, ktað,
  { {0x7c2402e2,0x941e0058,0xbcfb1222,0x00000000}},	//   dzir, ığıy, _chén,
  { {0x9f44004c,0x7d040014,0x7e440074,0x00000000}},	//   ímá_, fjis, ехте,
  { {0x693c017f,0x91bb0063,0xd23b009a,0x00000000}},	//   učel, _המהי, _לגול,
  { {0xdb0d017d,0x7f840021,0x6f01013d,0x00000000}},	// [1770] nuaç, _كلين, ölcs,
  { {0xdb0d00cd,0x501c0063,0x7d041223,0x00000000}},	//   rraï, _לוחו, ajis,
  { {0xceb200b5,0xdb040164,0x89d9007e,0x00000000}},	//   _ביי_, isiè, توار_,
  { {0xdb0d0025,0x7c24007d,0x79241224,0x00000000}},	//   mraí, bzir, ньчж,
  { {0xdb0d02dd,0xe72e1225,0xe7a80086,0x00000000}},	//   stañ, ве_, звіл_,
  { {0x8ae4019d,0x3ce90019,0xdb0d017d,0x00000000}},	//   _післ, ldav_, duaç,
  { {0xdb0d0025,0x2d781035,0x45d20092,0x00000000}},	//   nraí, _hčer_, војс,
  { {0x3ce90019,0x7ae700ea,0xfdf80063,0x00000000}},	//   ndav_, _hajt, לצות_,
  { {0xdb0d1226,0x65690b64,0x7ae700c2,0x00000000}},	//   hraí, rmeh, _kajt,
  { {0x3f840014,0x394f1227,0x23290054,0x00000000}},	//   ímum_, logs_, іони_,
  { {0xb209005a,0x98af0078,0xc1780078,0x00000000}},	//   ценз_, angą_, dvės_,
  { {0xcea9014e,0xdce40734,0x8fa6019c,0x00000000}},	//   _כי_, tmič, маме,
  { {0xbcfb0164,0xdb0d017d,0x25a0007d,0x00000000}},	//   _phén, cuaç, ćile_,
  { {0xdb0400e8,0x69d5006f,0x7ae71228,0x00000000}},	//   rsië, _opze, _najt,
  { {0xdb0d0027,0xdb04006f,0x7d160093,0x00000000}},	//   graí, ssië, tkys,
  { {0x2f14004b,0x1d5501ce,0xad65009b,0x00000000}},	//   _mägi_, еђус, فاقه,
  { {0x3ce6034d,0x5f2a0121,0xbcfb00f4,0x00000000}},	// [1780] ľov_, _моим_, _thén,
  { {0x3ce60024,0x7d161229,0xd910007e,0x00000000}},	//   žov_, skys, گیر_,
  { {0x78a20d19,0xdb0d0139,0x2f14004b,0x00000000}},	//   taov, craí, _nägi_,
  { {0xdb0d007a,0x693c0024,0x44240022,0x00000000}},	//   stað, mček, yzm_,
  { {0x98a30c07,0x31da0053,0xdb040025,0x00000000}},	//   тиче, _बन्ध, iriú,
  { {0x66e30001,0x758a0156,0xc58a0062,0x00000000}},	//   воља, осив_, ощие_,
  { {0xf1dd0042,0xd5ba046e,0x0f37009d,0x00000000}},	//   _फैलन, іск_, ורסט_,
  { {0xdb0d0016,0x7ae7122a,0xb906014b,0x00000000}},	//   tuaç, _zajt, _ўзак,
  { {0x63bb0035,0xa7a70002,0x693c004c,0x00000000}},	//   guun, _окта_, yčej,
  { {0x60c40016,0x2545001c,0x1bfb0047,0x00000000}},	//   _acim, vēle_, קליב,
  { {0xe135122b,0xdb04122c,0x63bb00a4,0x00000000}},	//   енны, friú, auun,
  { {0xdb040164,0x2d85004c,0x26dc122d,0x00000000}},	//   ssiè, ílem_, levo_,
  { {0xb5a00001,0x78a00150,0xc1780078,0x00000000}},	//   _енcи, _memv, tvės_,
  { {0xdb0d122e,0xd80b009d,0x00000000,0x00000000}},	//   traí, חִלָ,   ,
  { {0xdb040025,0x7ae70758,0xb2bb009a,0x00000000}},	//   briú, _rajt, _ומור,
  { {0x6f1e006f,0x7ae7122f,0xdb0d1230,0x00000000}},	//   _elpc, _sajt, rraí,
  { {0x3f670055,0x60dd0474,0xbbb90086,0x00000000}},	// [1790] _отоб, mesm, ягає_,
  { {0xbcfb0164,0x60dd1231,0xc879000c,0x00000000}},	//   _théo, lesm, _iaşi_,
  { {0x7ac4005a,0x394f0137,0x26dc1232,0x00000000}},	//   ъсте, togs_, devo_,
  { {0x25f40053,0x60dd1233,0x25610014,0x00000000}},	//   ्मनी_, nesm, kóla_,
  { {0x22590022,0x394f1234,0x7aca0082,0x00000000}},	//   ęski_, rogs_, _सॉकॅ,
  { {0x5fbc0047,0x25711235,0x63bb0072,0x00000000}},	//   קצונ, _išli_, vuun,
  { {0x6d480164,0x96940086,0xc879003b,0x00000000}},	//   édag, тріш, _laşi_,
  { {0x3ea10019,0x628a04ca,0x60dd1236,0x00000000}},	//   _leht_, _affo, jesm,
  { {0x60dd1237,0x25610046,0x36d51238,0x00000000}},	//   desm, góla_, _поар,
  { {0x60c41239,0x26dc123a,0x68e9001f,0x00000000}},	//   _scim, cevo_, _haed,
  { {0x68e900e3,0x68fb05b9,0x9f400025,0x00000000}},	//   _kaed, _knud, _triú_,
  { {0x628a04bc,0x4acf0053,0xaacf0053,0x00000000}},	//   _effo, स्तव, स्तक,
  { {0x653a0047,0xbcfb0066,0x68e90f20,0x00000000}},	//   _צענד, _chém, _maed,
  { {0x63a9123b,0x6d41123c,0xf76704a0,0x00000000}},	//   msen, élan, طا_,
  { {0x523900b5,0x63a9123d,0x68fb085a,0x00000000}},	//   _מײַנ, lsen, _onud,
  { {0x693c0066,0x21670363,0xfce3123e,0x00000000}},	//   rček, _пищи_, лосо,
  { {0x63a9123f,0xab661240,0x657c0046,0x00000000}},	// [17a0] nsen, евал, _érhv,
  { {0x3ea100bd,0x63a91241,0xba260085,0x00000000}},	//   _geht_, isen, ндзк,
  { {0x63a9004d,0x6459002b,0x68e91242,0x00000000}},	//   hsen, _lywi, _baed,
  { {0xc7c60245,0x63a91243,0xb05b0137,0x00000000}},	//   ески, ksen, mfär,
  { {0x64590035,0x63a91244,0x26dc1232,0x00000000}},	//   _nywi, jsen, tevo_,
  { {0x26dc02dd,0x63a91245,0x7bcb0063,0x00000000}},	//   uevo_, dsen, _מֶלֶ,
  { {0x68e900e3,0xd910006a,0x78a000c3,0x00000000}},	//   _faed, _پیش_, _temv,
  { {0x63a900b9,0x44f40095,0x6459002b,0x00000000}},	//   fsen, тпис, _bywi,
  { {0x64591246,0x96960054,0xd467005e,0x00000000}},	//   _cywi, _зреш, ниће_,
  { {0x2120003e,0x64590051,0x2f14004b,0x00000000}},	//   _alih_, _dywi, _kägu_,
  { {0x2258010a,0x5ab70047,0x7d0b0137,0x00000000}},	//   ærk_, עלטע_, ögsk,
  { {0x010b007e,0x2d81004d,0x859b0047,0x00000000}},	//   ستجو_, _ruhe_, _זשאו,
  { {0xc879000c,0x6459001f,0x60dd1247,0x00000000}},	//   _paşi_, _gywi, resm,
  { {0xb05b01bb,0x2d810072,0x93fb009d,0x00000000}},	//   ffär, _puhe_, _מלדי,
  { {0xa01b000f,0x2f14004b,0xdcef003b,0x00000000}},	//   nböz, _nägu_, _nică,
  { {0xbcfb0164,0x5d780076,0xdde3013d,0x00000000}},	//   _thém, ейся_, érőe,
  { {0x5c75005a,0x7ff70021,0x68e91248,0x00000000}},	// [17b0] тлат, _أسعا, _raed,
  { {0x68fb00d1,0x291f0139,0xb05b0137,0x00000000}},	//   _snud, _slua_, sfäs,
  { {0xc3330063,0x63a91249,0x68e9124a,0x00000000}},	//   נוע_, zsen, _paed,
  { {0x63a9124b,0x68e9124c,0x5dc8009a,0x00000000}},	//   ysen, _qaed, _אֶשְ,
  { {0x2571007d,0x34dd0053,0xfc640062,0x00000000}},	//   _ušli_, _मसौद, _бърн,
  { {0x45d51001,0x61260014,0x64590ee2,0x00000000}},	//   вцит, _gólf, _rywi,
  { {0xd7580021,0x66180066,0x7d0f013d,0x00000000}},	//   رجها_, _čaká, _kocs,
  { {0xa5f60001,0x3169006d,0x63a9124d,0x00000000}},	//   ђењу_, _nhaz_, tsen,
  { {0x777a0994,0x25a0007d,0x4944000d,0x00000000}},	//   _fitx, ćila_, _сэрб,
  { {0x63a9124e,0x7bcd124f,0x82f50094,0x00000000}},	//   rsen, itau, тчиц,
  { {0x7bcd00fe,0x64590051,0x63a91250,0x00000000}},	//   htau, _wywi, ssen,
  { {0x0596007e,0x7bcd0e77,0x63a91251,0x00000000}},	//   _شامگ, ktau, psen,
  { {0x61e10185,0xa023004b,0x81bc008f,0x00000000}},	//   swll, ööpr, nzēj,
  { {0x81bc003d,0xb05b00c7,0xb4640086,0x00000000}},	//   izēj, tfär, _скіл,
  { {0x2d9e0164,0x6da3005a,0xed5a1252,0x00000000}},	//   ète_, иира, дов_,
  { {0x693c1253,0x7bcd004d,0xb05b0354,0x00000000}},	//   lčev, ftau, rfär,
  { {0xed5709e1,0xb05b0d88,0xa05a0021,0x00000000}},	// [17c0] тот_, sfär, _تؤثر_,
  { {0x81bc001c,0x693c027c,0x27f800a8,0x00000000}},	//   dzēj, nčev, _črn_,
  { {0x18a61254,0x99f5013c,0xb05b004d,0x00000000}},	//   ваем, ляці, ngän,
  { {0x67211255,0xe995007e,0xdcfe1035,0x00000000}},	//   _allj, اهنگ, _kupč,
  { {0x2ba90053,0xb05b004d,0x765a1256,0x00000000}},	//   _चौपा, hgän, _syty,
  { {0xdcef003b,0xa0270014,0x61260046,0x00000000}},	//   _tică, _hröð, _fólg,
  { {0x19b90076,0xe9a3005e,0xceb30063,0x00000000}},	//   _путь_, _васп, ביו_,
  { {0x2545001c,0x291c001c,0xaa431257,0x00000000}},	//   tēla_, īvas_, _тесл,
  { {0x9836000d,0x765a0051,0x288b007e,0x00000000}},	//   _рэві, _wyty, _آصفی_,
  { {0x6d580026,0x764d00ea,0xd764007e,0x00000000}},	//   _ívaf, ényé, _صنای,
  { {0x691304ab,0x71e3000d,0x3abb0063,0x00000000}},	//   _içer, ацяж, ומינ,
  { {0x7bcd0078,0x56370041,0x25450023,0x00000000}},	//   ytau, _באבע_, pēla_,
  { {0xc0580086,0xe0df0290,0xa9230066,0x00000000}},	//   вір_, reò_, úžia,
  { {0xdb2301f7,0x21f40021,0x8233005d,0x00000000}},	//   örün, _مكتس, اریا,
  { {0xde740044,0x912b0044,0xde58012c,0x00000000}},	//   لدفع, _يسبق_, варі_,
  { {0x7bcd1258,0xdb21005b,0x61260139,0x00000000}},	//   ttau, ştür, _rólg,
  { {0x2d580bb3,0x8aa71259,0x2139125a,0x00000000}},	// [17d0] тить_, вред, mish_,
  { {0xdd11003d,0xbcfb0025,0x2139125b,0x00000000}},	//   _kļūd, _mhéi, lish_,
  { {0x6d480164,0x9f49005b,0x7bcd125c,0x00000000}},	//   édac, _araç_, stau,
  { {0x9f4900cd,0x2139125d,0x7bcd125e,0x00000000}},	//   _braç_, nish_, ptau,
  { {0x8c67000d,0x2ca9004b,0x37ab066f,0x00000000}},	//   _штод, maad_, фтен_,
  { {0x366905bd,0xdb0d00be,0x81bc008f,0x00000000}},	//   нало_, draç, rzēj,
  { {0x62860080,0x44290066,0x693c00b2,0x00000000}},	//   ěkol, _ťa_, včev,
  { {0xa3e9005a,0xdb0d017d,0x04c90021,0x00000000}},	//   едиа_, fraç, روخي_,
  { {0xbcfb0027,0xdb0d0016,0x2139077d,0x00000000}},	//   _chéi, graç, dish_,
  { {0x693c00c2,0x8c44005b,0x20190124,0x00000000}},	//   učev, _öğey, dysi_,
  { {0xbbd00161,0x693c02f7,0x21390345,0x00000000}},	//   _सङ्क, rčev, fish_,
  { {0xbcfb0027,0xb05b00bd,0xdb0d017d,0x00000000}},	//   _fhéi, rgän, braç,
  { {0x2ca900f5,0xf5390066,0xbcfb0139,0x00000000}},	//   daad_, miť_, _ghéi,
  { {0xf539034d,0x248d0473,0x2d8c125f,0x00000000}},	//   liť_, lcem_, ídeo_,
  { {0x63bb001c,0x693c074f,0x2f140137,0x00000000}},	//   lrun, očet, _sägs_,
  { {0xf5390024,0x693c1260,0x63bb1261,0x00000000}},	//   niť_, nčet, orun,
  { {0x3ce01262,0xaaba007e,0x612600f8,0x00000000}},	// [17e0] reiv_, فدار_, _cóle,
  { {0x291d0035,0x63bb1263,0x7dea0085,0x00000000}},	//   ekwa_, irun, _змог_,
  { {0x63bb0199,0xeb750088,0x25610046,0x00000000}},	//   hrun, рытэ, tóll_,
  { {0xb95a0032,0xf5390024,0x2d981264,0x00000000}},	//   رجاء_, jiť_, mpre_,
  { {0xf539034d,0x645d0019,0xb8dc0053,0x00000000}},	//   diť_, üsil, _आय_,
  { {0x96b70001,0x6d441265,0x6d561266,0x00000000}},	//   гућу_, lnia, loya,
  { {0x63bb1267,0x25a0007d,0x6d441268,0x00000000}},	//   erun, ćilo_, onia,
  { {0xdb0d0016,0x3eaa00bd,0x9f4900cd,0x00000000}},	//   traç, habt_, _traç_,
  { {0xdb0d017d,0x7792007e,0x3eaa01e1,0x00000000}},	//   uraç, _ایتا, kabt_,
  { {0x6d4400e3,0x21390034,0x693c00c3,0x00000000}},	//   hnia, wish_, ačet,
  { {0xf5390024,0xe3af006a,0x21391269,0x00000000}},	//   biť_, يری_, tish_,
  { {0x63bb00c7,0x7522007d,0xfc3f006d,0x00000000}},	//   brun, _uloz, _leía_,
  { {0x613600c3,0x21390c69,0x6d440051,0x00000000}},	//   ošlj, rish_, dnia,
  { {0x69dc126a,0xa294126b,0x6d44126c,0x00000000}},	//   _opre, _такі, enia,
  { {0x65600025,0xde590086,0x6d44001f,0x00000000}},	//   olmh, таві_, fnia,
  { {0x5c07005a,0x6d560150,0x693c00a8,0x00000000}},	//   ляза, goya, ičes,
  { {0x69dc126d,0x2ca9126e,0x68e2126f,0x00000000}},	// [17f0] _apre, raad_, deod,
  { {0xf539034d,0x2ca9002c,0x63a20035,0x00000000}},	//   ziť_, saad_, _mwon,
  { {0xdced00c2,0x63bb008f,0xdb041270,0x00000000}},	//   lmač, zrun, erió,
  { {0xdced00c2,0x6d440022,0xf1b30063,0x00000000}},	//   omač, cnia, מסע_,
  { {0xf539061a,0xe6c50021,0x69dc0003,0x00000000}},	//   viť_, لتغي, _epre,
  { {0x645d0019,0x7d0d1271,0xf7960021,0x00000000}},	//   üsim, ljas, جنوب_,
  { {0xf5390024,0x7c2d1272,0x7d0d1273,0x00000000}},	//   tiť_, lzar, ojas,
  { {0x7d0d024a,0xb60500ea,0xdb040331,0x00000000}},	//   njas, _aláí, brió,
  { {0xf5390024,0xf5760021,0xed130013,0x00000000}},	//   riť_, جميع_, _đội_,
  { {0xc6a40079,0xf5390024,0xadf70053,0x00000000}},	//   _грци, siť_, ुमान_,
  { {0x6d440185,0x7d0d007a,0xf5390024,0x00000000}},	//   ynia, kjas, piť_,
  { {0x7bdd00b9,0x63bb1274,0x5455000d,0x00000000}},	//   _opsu, prun, _квет,
  { {0x7d0d1275,0x6d561276,0x6d440066,0x00000000}},	//   djas, voya, vnia,
  { {0xdb040019,0x8235007e,0x08760047,0x00000000}},	//   uriü, _پرتا, יערט_,
  { {0x7d0d0026,0x6d560805,0x6d440051,0x00000000}},	//   fjas, toya, tnia,
  { {0x7aee003e,0x2d980003,0x7d0d0014,0x00000000}},	//   _sabt, rpre_, gjas,

  { {0x2d980529,0x69dc1277,0x6d441278,0x00000000}},	// [1800] spre_, _spre, rnia,
  { {0x69dc0031,0x6d440498,0x442d1279,0x00000000}},	//   _ppre, snia, ize_,
  { {0xfc3f006d,0x2d850080,0x68e211ad,0x00000000}},	//   _veía_, ílet_, teod,
  { {0x7d0b00c7,0x26c70290,0x9c83027d,0x00000000}},	//   ögst, egno_, účtu,
  { {0x442d0122,0x7aee00b9,0xec470076,0x00000000}},	//   jze_, _tabt, _взял_,
  { {0x69960086,0x442d127a,0x501b0063,0x00000000}},	//   _врах, dze_, כונו,
  { {0x69dc0024,0x98a60086,0x442d127b,0x00000000}},	//   _upre, _вибе, eze_,
  { {0x752906c6,0x98af003b,0x6283127c,0x00000000}},	//   ghez, rigă_, _agno,
  { {0x43060086,0x3946127d,0x6d41006c,0x00000000}},	//   аїна, mnos_, élai,
  { {0xf36600d7,0x3946127e,0x7d0d0f0c,0x00000000}},	//   јтин, lnos_, zjas,
  { {0x7c2d055b,0x79800035,0x442d127f,0x00000000}},	//   zzar, _kimw, aze_,
  { {0x75290009,0x39460b58,0x442d0058,0x00000000}},	//   chez, nnos_, bze_,
  { {0x442d0045,0xc0e40088,0x33940021,0x00000000}},	//   cze_, цоўк, _التز,
  { {0x3946001f,0xdced0240,0x6d480003,0x00000000}},	//   hnos_, rmač, édan,
  { {0x7d0d1280,0xeca70fe2,0x28d70042,0x00000000}},	//   tjas, ијан, ण्डि,
  { {0x7c2d1281,0x394600ea,0x427b0063,0x00000000}},	//   tzar, jnos_, _באוג,
  { {0x29e80529,0xfa870001,0x67da001c,0x00000000}},	// [1810] _aşa_, аћем, nājā,
  { {0x7c2d1282,0x2bc80002,0x39461283,0x00000000}},	//   rzar, јуто_, enos_,
  { {0x7c2d0051,0x3946001f,0x442d1284,0x00000000}},	//   szar, fnos_, zze_,
  { {0x645d0019,0x39461285,0xbcfb0003,0x00000000}},	//   üsik, gnos_, _chét,
  { {0x6aa7013d,0xa91d007d,0x78ab1286,0x00000000}},	//   _tejf, _niže, ragv,
  { {0x8698005a,0x394604a6,0x3f81004c,0x00000000}},	//   атът_, anos_, _jihu_,
  { {0x98af0006,0x3f81003b,0x691a0003,0x00000000}},	//   eigą_, _mihu_, _aïeu,
  { {0x442d1287,0x7ae5003a,0x00000000,0x00000000}},	//   tze_, leht,   ,
  { {0xf7940088,0xc95201f9,0x442d071e,0x00000000}},	//   _матэ, _זמן_, uze_,
  { {0x442d1288,0x60cd1289,0x27ed128a,0x00000000}},	//   rze_, _acam, _isen_,
  { {0x442d128b,0x568c0047,0xdce40051,0x00000000}},	//   sze_, _סטאַ, amię,
  { {0x2d6800bd,0x61360066,0x78a9128c,0x00000000}},	//   eßen_, ošli, _jeev,
  { {0x95540021,0xdb040014,0x69c5004d,0x00000000}},	//   _بخلا, krið, huhe,
  { {0x612606b2,0x254c0080,0x249f128d,0x00000000}},	//   _dóla, měla_, lbum_,
  { {0xe164007e,0x69c50019,0x853c0078,0x00000000}},	//   _وضعی, juhe, _kvėp,
  { {0x6136109f,0x63a4005b,0x91ba0047,0x00000000}},	//   kšli, _çinc, _עמפי,
  { {0xdb040016,0xbcfb0003,0xf3880013,0x00000000}},	// [1820] nsiç, _rhét, _lợn_,
  { {0xdb04017d,0x09e60054,0x6d5d128e,0x00000000}},	//   isiç, йозн, _eksa,
  { {0x1efb00b5,0xd9460363,0x80cf0042,0x00000000}},	//   _עלטע, бежи, _थामे,
  { {0x256100ea,0x1d0a128f,0x7ae50050,0x00000000}},	//   bóli_, _семи_, aeht,
  { {0x39461290,0xaab8007e,0x2ca0004b,0x00000000}},	//   rnos_, _نگار_, mbid_,
  { {0xe9aa007e,0x254c004c,0x25a5002b,0x00000000}},	//   _مدرن_, děla_, _bwll_,
  { {0x2d820035,0x29e8003b,0x81bc008f,0x00000000}},	//   _kike_, _uşa_, nzēt,
  { {0x2ca000ac,0x77861291,0x25a5002b,0x00000000}},	//   nbid_, _глаз, _dwll_,
  { {0x442200ea,0x2d821292,0xccf3089e,0x00000000}},	//   ák_, _mike_, לכה_,
  { {0x2d821293,0x78a91294,0xaaa80053,0x00000000}},	//   _like_, _zeev, गरिक,
  { {0xd5b9019d,0x3f8900cd,0x61260026,0x00000000}},	//   _всі_, _suau_, _sóla,
  { {0x81bc003d,0x59c90053,0xc5f30063,0x00000000}},	//   dzēt, ांतर, _מדע_,
  { {0xd8d700b5,0xa2d30053,0x69c50244,0x00000000}},	//   זוכט_, _बॉक्, zuhe,
  { {0x4374006a,0x6e940076,0x2d6800bd,0x00000000}},	//   _بهتر, зиру, ußen_,
  { {0xe189008b,0x2d821295,0xddc5004c,0x00000000}},	//   _hẳn_, _bike_, _vzhů,
  { {0x61260026,0x628e00c2,0x61360066,0x00000000}},	//   _tóla, žbod, yšli,
  { {0xdb041296,0xdcfe003b,0x7ae51297,0x00000000}},	// [1830] trið, _supă, teht,
  { {0x69c50026,0xbcfb0003,0x78a91298,0x00000000}},	//   tuhe, _chér, _seev,
  { {0x7ae51299,0xd91b129a,0x78a90168,0x00000000}},	//   reht, льд_, _peev,
  { {0x69c5129b,0x7ae5129c,0x5c07129d,0x00000000}},	//   ruhe, seht, _ляга,
  { {0xf771043b,0x78a9004b,0x69c5004b,0x00000000}},	//   وات_, _veev, suhe,
  { {0x69c500fe,0x25a5001f,0xbcfb006c,0x00000000}},	//   puhe, _pwll_, _thés,
  { {0xf5920032,0x2129003e,0x1efa00b5,0x00000000}},	//   ولوج, _olah_, ילװע,
  { {0x254c004c,0x321e0022,0xfd8a0041,0x00000000}},	//   těla_, dyty_, סטפּ,
  { {0x9817006a,0x27ed0857,0xa8a401ce,0x00000000}},	//   _ابزا, _usen_, _хрск,
  { {0xdb16024a,0x15ab0062,0x247f008f,0x00000000}},	//   styö, _бъди_, _rāmī_,
  { {0x81bc003d,0x21290025,0x9f49004d,0x00000000}},	//   dzēs, _blah_, _spaß_,
  { {0x254c004c,0x9136012c,0x3ce30082,0x00000000}},	//   pěla_, іхні, ख़ों_,
  { {0xd24e007e,0x2d82129e,0x28d10042,0x00000000}},	//   فنی_, _rike_, _हानि,
  { {0x321e0185,0x040e0013,0xd5dd0042,0x00000000}},	//   byty_, _lýợn, _महाज,
  { {0xad3a0086,0x395f00a8,0x2d82129f,0x00000000}},	//   ачає_, _okus_, _pike_,
  { {0xc5f20063,0x8d66000d,0x81bc008f,0x00000000}},	//   ודל_, івае, rzēt,
  { {0x25a0017f,0xcb050042,0x2ca012a0,0x00000000}},	// [1840] ćili_, रांड_, rbid_,
  { {0x4a9a0085,0x5de6089d,0x3a9a014b,0x00000000}},	//   ртаў_, _джоа, ртаю_,
  { {0xa3a90053,0x386d12a1,0x7f5c0003,0x00000000}},	//   गीत_, _azer_, morq,
  { {0x61fc06a5,0x6d410003,0xdd0f005b,0x00000000}},	//   årli, élat, mışs,
  { {0xbcfb12a2,0x7d0612a3,0x321e0022,0x00000000}},	//   _thér, _inks, zyty_,
  { {0xab2a0138,0x27e900cd,0x394d12a4,0x00000000}},	//   _тога_, çana_, _ejes_,
  { {0x76a90086,0x386d00ea,0x333e00cd,0x00000000}},	//   стів_, _ezer_, vitx_,
  { {0xb6030066,0xdb0d0014,0x1de20042,0x00000000}},	//   úšal, luað, _पहनत,
  { {0x25a9007d,0xd90d007e,0x96960062,0x00000000}},	//   ćala_, _حین_, _дреш,
  { {0x63bd00ea,0xd370013a,0x395f004c,0x00000000}},	//   ásna, عهد_, _zkus_,
  { {0xd2570054,0x28d10042,0x925812a5,0x00000000}},	//   жця_, _हामि, сант_,
  { {0x69c300c3,0x94d40021,0x254c004c,0x00000000}},	//   šneg, _ريتش, mělo_,
  { {0xb0340076,0xf8b30063,0xdfdb0062,0x00000000}},	//   дняш, ושר_, шън_,
  { {0x7d0600eb,0x2545001c,0x543b0041,0x00000000}},	//   _anks, vēli_, _דעדא,
  { {0xdef80088,0x645d004b,0x98af0078,0x00000000}},	//   цыя_, üsiv, aigę_,
  { {0x2545001c,0x21290150,0x6126013d,0x00000000}},	//   tēli_, _ulah_, _jóll,
  { {0xa91d00c2,0xac77005d,0xbe870044,0x00000000}},	// [1850] _niža, زارش, _وجدو,
  { {0x78a2004a,0x539b0165,0xea67005e,0x00000000}},	//   ebov, יימו, оњен,
  { {0x6136005f,0x7875013d,0x386d12a6,0x00000000}},	//   ašlu, küvé, _szer_,
  { {0xdb0d0025,0x254c004c,0xec150044,0x00000000}},	//   msaí, dělo_, _فوجد,
  { {0x07a5065b,0x18690856,0xe8380054,0x00000000}},	//   чалн, љали_, опці_,
  { {0x37070055,0x8c1a009a,0xb9c700de,0x00000000}},	//   ючев, _הושי, _وتأه,
  { {0xf6250156,0x78a2011b,0x9782005d,0x00000000}},	//   ядко, bbov, ریمه,
  { {0xf50912a7,0x395f12a8,0x00000000,0x00000000}},	//   снил_, _ukus_,   ,
  { {0x7f5c0331,0x29d500a5,0x612601d1,0x00000000}},	//   yorq, låa_, _sólo,
  { {0x395d0034,0x69d700cd,0xdb04017d,0x00000000}},	//   lows_, otxe, briõ,
  { {0xeccb0161,0x644d0006,0x4add0042,0x00000000}},	//   िलाफ, _žaid, न्यव,
  { {0x69d700cd,0x395d12a9,0xa4d50054,0x00000000}},	//   itxe, nows_, _ході,
  { {0xa3f40086,0x4f96000d,0x7f5c12aa,0x00000000}},	//   _опці, ярну, torq,
  { {0x539a0063,0x2d9612ab,0x07350041,0x00000000}},	//   _היסו, зрас, לאָם_,
  { {0x78bb007d,0x78a2004a,0x61260014,0x00000000}},	//   _oduv, ybov, _hólm,
  { {0xc5f20149,0x621a0041,0x91ba0063,0x00000000}},	//   עדן_, _לוצק, _המקי,
  { {0x5046005e,0xe8df0013,0xdb0d0014,0x00000000}},	// [1860] _хепб, _ngựa_, tuað,
  { {0x6d4112ac,0xdb59012c,0x3057009d,0x00000000}},	//   élar, оює_, _משפך_,
  { {0x273000aa,0xe9da12ad,0xdb0d0025,0x00000000}},	//   _hàng_, ске_, csaí,
  { {0xd910007e,0xb05b0137,0x27ff12ae,0x00000000}},	//   خیر_, rgäv, _brun_,
  { {0x78a212af,0xdb040139,0xd8230062,0x00000000}},	//   rbov, isiú, ндци,
  { {0x78a2006f,0x7bc400cd,0x27300013,0x00000000}},	//   sbov, mriu, _màng_,
  { {0x2730008b,0xa5d70021,0xb9b50062,0x00000000}},	//   _làng_, كبير_, _остъ,
  { {0x5398042c,0xa507005e,0xd4c3014b,0x00000000}},	//   овия_, зећа_, нсьп,
  { {0x27300013,0xb8e20042,0x27ff0046,0x00000000}},	//   _nàng_, ूल_, _grun_,
  { {0x59d00394,0x798e0009,0xa91d0080,0x00000000}},	//   _हमार, _kubw, _jižn,
  { {0x2000003b,0x41e60054,0xc48612b0,0x00000000}},	//   _arii_, чіпа, _елек,
  { {0xa91d00c2,0x27300013,0x63660014,0x00000000}},	//   _ližn, _bàng_, iðni,
  { {0x2730001b,0x645d0019,0x63ae004c,0x00000000}},	//   _càng_, üsit, áhně,
  { {0x2730008b,0x3f850026,0x7bc412b1,0x00000000}},	//   _dàng_, ölu_, driu,
  { {0x7bc40004,0x7af500c3,0xd24f0085,0x00000000}},	//   eriu, _razt, _чц_,
  { {0xf549008b,0xdb0d0139,0xfaf3005d,0x00000000}},	//   hấn_, rsaí, کثر_,
  { {0x7055006a,0x6c5406dc,0x2bb80021,0x00000000}},	// [1870] _زندا, екту, كالة_,
  { {0x60dd087d,0x539b009a,0xbbb8012c,0x00000000}},	//   lfsm, ציבו, ягує_,
  { {0x79a40076,0x7bc40271,0x6562008d,0x00000000}},	//   ерче, ariu, _okoh,
  { {0x637400cd,0x7bc400e5,0xcdb6009d,0x00000000}},	//   lànd, briu, _קפרה_,
  { {0x7bc40268,0x6d4d12b2,0x395d12b3,0x00000000}},	//   criu, mnaa, rows_,
  { {0x6d4d006f,0x27ff00dd,0xf773043e,0x00000000}},	//   lnaa, _vrun_, راش_,
  { {0x6d4d12b4,0x80bf0053,0x25a9007d,0x00000000}},	//   onaa, ्लाइ, ćalo_,
  { {0x6d4d12b5,0x26d80137,0x62980229,0x00000000}},	//   nnaa, _öron_, _afvo,
  { {0x23d40088,0x6d480003,0x27ff0150,0x00000000}},	//   нцэр, édai, _urun_,
  { {0x2730008b,0x68eb0983,0x69c5004d,0x00000000}},	//   _ràng_, legd, orhe,
  { {0x2730008b,0x69c5001f,0x6d4d12b6,0x00000000}},	//   _sàng_, nrhe, knaa,
  { {0xd7d10161,0x2545003d,0x6d4d0122,0x00000000}},	//   _समाच, tēlu_, jnaa,
  { {0x69c500bd,0x6d4d006f,0x316c008f,0x00000000}},	//   hrhe, dnaa, ēdz_,
  { {0x2730008b,0x68eb00ac,0x656912b7,0x00000000}},	//   _vàng_, hegd, lleh,
  { {0xa91d007d,0x69c501e1,0xa3a90042,0x00000000}},	//   _nižo, jrhe, गीर_,
  { {0x2730008b,0x656912b8,0x1d0712b9,0x00000000}},	//   _tàng_, nleh, меси_,
  { {0x6b8702b0,0x7bc40006,0x5fd20053,0x00000000}},	// [1880] _bijg, uriu, _तमिल,
  { {0xdcfd003d,0x6d4d12ba,0x637400cd,0x00000000}},	//   _visā, anaa, cànd,
  { {0x2005001c,0x2d950062,0xfe720021,0x00000000}},	//   ālie_, _пряс, _جدة_,
  { {0x7bc4000c,0xeb9f000e,0x6aae12bb,0x00000000}},	//   priu, _brød_, _webf,
  { {0x69c512bc,0xeb9a0a74,0x6569004c,0x00000000}},	//   arhe, _фиг_, dleh,
  { {0xf5490013,0x65620b2a,0x69c3004c,0x00000000}},	//   uấn_, _skoh, ánec,
  { {0xf5490013,0xb05b051c,0x799c0022,0x00000000}},	//   rấn_, ngär, _utrw,
  { {0x6ba501e3,0xdce408ea,0xb9030a74,0x00000000}},	//   _åtgä, klič, _изск,
  { {0xd8d700b5,0xbcfb0080,0x7c2412bd,0x00000000}},	//   _קומט_, _okén, nyir,
  { {0x61260026,0x52140ac5,0x657b00a4,0x00000000}},	//   _fólk, едот, amuh,
  { {0x6d4d12be,0xdce412bf,0x656912c0,0x00000000}},	//   ynaa, elič, bleh,
  { {0xf388001b,0x403512c1,0x03a612c2,0x00000000}},	//   _lợi_, еемс, _жидо,
  { {0x63740268,0xb05b00c7,0xdce40240,0x00000000}},	//   tànd, egär, glič,
  { {0x44240051,0x656000ea,0x636f01f2,0x00000000}},	//   mym_, lomh, lønn,
  { {0x200d000c,0x6d4d12c3,0xf1c50053,0x00000000}},	//   ţei_, tnaa, _वियन,
  { {0xdce412c4,0x69c5004c,0x5cc4007b,0x00000000}},	//   blič, vrhe, ксуз,
  { {0x6d4d12c5,0x442412c6,0x2d8c12c7,0x00000000}},	// [1890] rnaa, nym_, íder_,
  { {0x6d4d0179,0x65600025,0xb05b01bb,0x00000000}},	//   snaa, homh, sgäs,
  { {0x6d4d006f,0x272b00d1,0x637401a8,0x00000000}},	//   pnaa, _bønn_, càne,
  { {0x44240024,0x636f00d1,0x69c512c8,0x00000000}},	//   kym_, jønn, rrhe,
  { {0x6b87006f,0x25ac002b,0x7c840893,0x00000000}},	//   _tijg, _awdl_, _ауре,
  { {0x7d1d000f,0x44240106,0x28d10082,0x00000000}},	//   _hoss, dym_, _हावि,
  { {0xdce401a6,0xf388008b,0x3cf90019,0x00000000}},	//   zlič, _gợi_, _kasv_,
  { {0x7d1d024a,0x657b00a4,0xa565007e,0x00000000}},	//   _joss, umuh, رگان,
  { {0x13e60076,0x7d1d12c9,0x657b12ca,0x00000000}},	//   емый_, _moss, rmuh,
  { {0x2545001c,0x7d1d12cb,0x69c104aa,0x00000000}},	//   tēls_, _loss, _åles,
  { {0x7d1d00ac,0x636f05a5,0xf41f004b,0x00000000}},	//   _ooss, bønn, ääb_,
  { {0x7d1d03d9,0xdce41035,0x442412cc,0x00000000}},	//   _noss, tlič, bym_,
  { {0x44240051,0x442701fb,0x7529013d,0x00000000}},	//   cym_, _تراف, mkez,
  { {0x7529000f,0xb05b00c7,0x798900ac,0x00000000}},	//   lkez, tgär, _liew,
  { {0x8db50086,0xc69212cd,0x2d9e0003,0x00000000}},	//   ксті, ראל_, ëte_,
  { {0x79890045,0x2d9e001c,0x7d1d12ce,0x00000000}},	//   _niew, īte_, _coss,
  { {0x7d1d12cf,0x7ff60021,0x7d1600b9,0x00000000}},	// [18a0] _doss, _أسبا, rjys,
  { {0x272b0031,0x7c360022,0xe8030082,0x00000000}},	//   _sønn_, rzyr, लिना_,
  { {0x44240051,0x3f920035,0xda660021,0x00000000}},	//   zym_, _huyu_, راطي,
  { {0x69c302dd,0xdcfd00dd,0x612605ec,0x00000000}},	//   ánea, _visă, _bóli,
  { {0xa7fd000f,0x9d1b0047,0x637400cd,0x00000000}},	//   _szűr, _זוכט, nànc,
  { {0x57f30001,0x254c0080,0x44240066,0x00000000}},	//   упшт, měli_, vym_,
  { {0x44240045,0x61260516,0x38c8005d,0x00000000}},	//   wym_, _eóli, _ياری_,
  { {0x752900ea,0xc448007e,0x89db0063,0x00000000}},	//   gkez, ویان_, _מחלי,
  { {0x84970032,0x394610ac,0x636f0093,0x00000000}},	//   رئيس_, mios_, rønn,
  { {0x65600307,0xa91d00c3,0x394612d0,0x00000000}},	//   somh, _nižj, lios_,
  { {0xa1590690,0x75d60044,0xb5a50054,0x00000000}},	//   дану_, _سيشا, _арій,
  { {0x637400cd,0x394612d1,0xd257000d,0x00000000}},	//   fànc, nios_, эцы_,
  { {0xc9530063,0x7d1d12d2,0x637400cd,0x00000000}},	//   רמר_, _ross, gànc,
  { {0x254c0080,0xdefb000d,0x7d1d12d3,0x00000000}},	//   děli_, чым_, _soss,
  { {0x39460006,0x7d1d12d4,0x80a20053,0x00000000}},	//   kios_, _poss, _क्वे,
  { {0x63660026,0x9d1812d5,0x00000000,0x00000000}},	//   rðnu, ност_,   ,
  { {0xdb0d12d6,0x7d1d12d7,0x394612d8,0x00000000}},	// [18b0] nsaç, _voss, dios_,
  { {0xdb0d12d9,0x394600be,0x79890022,0x00000000}},	//   trañ, eios_, _siew,
  { {0xa2d80235,0x3946039f,0x612612da,0x00000000}},	//   _मान्, fios_, _sóli,
  { {0x394612d1,0x6d480153,0x61e5004d,0x00000000}},	//   gios_, édat, _ähle,
  { {0x79890034,0x7c6701fb,0x2ca912db,0x00000000}},	//   _view, _ساحل, mbad_,
  { {0x2d8b006d,0x798912dc,0xd618005d,0x00000000}},	//   _hice_, _wiew, کتها_,
  { {0x752903e8,0x56920001,0x394612dd,0x00000000}},	//   tkez, шајт, bios_,
  { {0x39460747,0x61260014,0x2ca912de,0x00000000}},	//   cios_, _tóli, nbad_,
  { {0x80a20161,0x442b12df,0xa6f50001,0x00000000}},	//   _क्षे, ác_, _изаш,
  { {0x3eb30034,0x69ca0016,0x63740268,0x00000000}},	//   _next_, áfeg, vànc,
  { {0x68fb047f,0x3f92005b,0x7529013d,0x00000000}},	//   _kaud, _suyu_, pkez,
  { {0x2eaa0161,0x63740268,0x291f0003,0x00000000}},	//   कर्त, tànc, _joua_,
  { {0x68fb12e0,0x200412e1,0x644f12e2,0x00000000}},	//   _maud, ími_, úcid,
  { {0x63bb12e3,0x80a20161,0x2d8b0025,0x00000000}},	//   msun, _क्रे, _aice_,
  { {0x6d5b00a8,0x2d8b12e4,0x63bb12e5,0x00000000}},	//   čuan, _bice_, lsun,
  { {0x68fb12e6,0x291f000c,0x254c0080,0x00000000}},	//   _naud, _noua_, těli_,
  { {0x69c30024,0x63bb12e7,0x2d8b12e8,0x00000000}},	// [18c0] ánen, nsun, _dice_,
  { {0x5fb70063,0x63bb12e9,0xffb7009a,0x00000000}},	//   _שהיא_, isun, _שליש_,
  { {0x3946048e,0x3ebe0026,0x3eb812ea,0x00000000}},	//   tios_, óttu_, mart_,
  { {0x1e570063,0x68fb0877,0x3eb812eb,0x00000000}},	//   _ישיר_, _caud, lart_,
  { {0x68fb003d,0x291f000c,0x394612ec,0x00000000}},	//   _daud, _doua_, rios_,
  { {0x394600eb,0x2d8b000c,0x290d12ed,0x00000000}},	//   sios_, _zice_, _enea_,
  { {0x39460297,0x68fb12ee,0x7afc12ef,0x00000000}},	//   pios_, _faud, _iart,
  { {0x29dc048e,0x68fb12f0,0x44f4005e,0x00000000}},	//   mía_, _gaud, упис,
  { {0x3eb812f1,0x63bb12f2,0x29dc12f3,0x00000000}},	//   kart_, gsun, lía_,
  { {0xdb0d017d,0x68fb001c,0xa6c70899,0x00000000}},	//   rsaç, _zaud, _алфа_,
  { {0x29dc12f4,0x63bb061e,0xdb04006d,0x00000000}},	//   nía_, asun, lsió,
  { {0x68e2001f,0x2d800051,0x216402a1,0x00000000}},	//   nfod, jmie_, итяг,
  { {0xdb0402dd,0x4fc7005a,0x3eb812f5,0x00000000}},	//   nsió, ъсна, fart_,
  { {0x63a200bb,0x69de12f6,0x2d8b0080,0x00000000}},	//   _iton, ktpe, _sice_,
  { {0x29dc006d,0xdb0412f7,0x2d8b12f8,0x00000000}},	//   jía_, mpiè, _pice_,
  { {0x29dc02dd,0x3eb8056f,0x7afc12f9,0x00000000}},	//   día_, aart_, _aart,
  { {0x68fb12fa,0x25a9017f,0x3eb812fb,0x00000000}},	// [18d0] _raud, ćali_, bart_,
  { {0x29dc048e,0x1fa4005a,0x79a7000a,0x00000000}},	//   fía_, _тръг, врде,
  { {0x29dc048e,0x68e2001f,0xdbd1004d,0x00000000}},	//   gía_, ffod, _füße,
  { {0x63a212fc,0x23c2016a,0x08d40054,0x00000000}},	//   _oton, _शिंद, иція,
  { {0xb8db0161,0x63a212fd,0x68fb12fe,0x00000000}},	//   _आज_, _nton, _vaud,
  { {0x29dc048e,0x68e2001f,0x7afc0d9d,0x00000000}},	//   bía_, afod, _gart,
  { {0x29dc048e,0x69de0122,0x3a84000d,0x00000000}},	//   cía_, ctpe, _вытв,
  { {0x7afc004d,0x63bb12ff,0x254c0022,0x00000000}},	//   _zart, tsun, yśle_,
  { {0xbcfb034d,0xe3b10032,0x63bb1300,0x00000000}},	//   _akék, حرب_, usun,
  { {0x63bb1301,0x2d800022,0x7880004c,0x00000000}},	//   rsun, zmie_, _dívč,
  { {0x63bb1302,0xe8df008b,0x3eb81303,0x00000000}},	//   ssun, _ngừa_, vart_,
  { {0x34950138,0x7fd60454,0x3eb81304,0x00000000}},	//   _садр, лігі, wart_,
  { {0x67211305,0xf487005e,0x3eb81306,0x00000000}},	//   _kolj, _ружн, tart_,
  { {0x08760047,0xdbd1004d,0x6126013d,0x00000000}},	//   טערט_, _süße, _rólu,
  { {0x68e2001f,0xa2d80053,0xf3880013,0x00000000}},	//   yfod, _मात्, _vợt_,
  { {0x5c160055,0x29dc02dd,0xfc3f006d,0x00000000}},	//   льзу, vía_, _reír_,
  { {0x3eb81307,0x2d801308,0x69c30078,0x00000000}},	// [18e0] part_, rmie_, šnel,
  { {0x2d800024,0x0eaa0088,0x29dc1309,0x00000000}},	//   smie_, _якой_, tía_,
  { {0x7afc130a,0x8e76000a,0x18a6047e,0x00000000}},	//   _vart, _љупч, гаем,
  { {0x29dc048e,0x386d0205,0x61fc01f2,0x00000000}},	//   ría_, _byer_, ærli,
  { {0x29dc130b,0x68e2001f,0x672101b3,0x00000000}},	//   sía_, rfod, _bolj,
  { {0xdb04048e,0xbcfb0024,0x29dc130c,0x00000000}},	//   rsió, _akéh, pía_,
  { {0xf41f024a,0xe9a30088,0x6721017f,0x00000000}},	//   ään_, _гасп, _dolj,
  { {0x186a02b6,0xaa43130d,0x95d70062,0x00000000}},	//   _заби_, _уесл, удът_,
  { {0x68e40019,0x83340062,0x14d50042,0x00000000}},	//   õidu, иних, _धारण,
  { {0x672100c2,0x79820051,0x236500a8,0x00000000}},	//   _golj, lmow, golj_,
  { {0xe6930032,0x0656000d,0x22580121,0x00000000}},	//   _المد, _стаў, тины_,
  { {0x644f017c,0x6ed70082,0xd59b009a,0x00000000}},	//   úcic, _बाहु, _נבדל,
  { {0x236500c2,0x60c400a3,0xe4760085,0x00000000}},	//   bolj_, _ddim, _сужэ,
  { {0x88bd0045,0x343b0047,0x2fc000c2,0x00000000}},	//   _kośc, _אײדע, _dvig_,
  { {0x2fc0130e,0xd2b70149,0x98bd0022,0x00000000}},	//   _evig_, _גלות_, liwą_,
  { {0x79820051,0x316900b2,0x88bd0022,0x00000000}},	//   jmow, _ukaz_, _mośc,
  { {0x79820022,0xfaa70054,0x8aa7130f,0x00000000}},	// [18f0] dmow, гшен, гред,
  { {0x69c300c2,0x20090003,0x66081310,0x00000000}},	//   šnem, _irai_, _ordk,
  { {0xdb580076,0xeb9f0146,0x7bcb0026,0x00000000}},	//   уют_, _grøn_, águb,
  { {0x20091311,0xf09f00cd,0x7bdf004d,0x00000000}},	//   _krai_, ncà_, ptqu,
  { {0x672106bb,0x27c70076,0xdcef0022,0x00000000}},	//   _polj, ущег, _chcą,
  { {0x386d0137,0xd705030b,0x7982056c,0x00000000}},	//   _vyer_, рзки, amow,
  { {0x67211312,0x236500c3,0x7bcd007a,0x00000000}},	//   _volj, volj_, lrau,
  { {0x7bcd004d,0x20090078,0x64a51313,0x00000000}},	//   orau, _orai_, јапа,
  { {0xa3b0016a,0x7bcd045e,0x36d51314,0x00000000}},	//   टील_, nrau, _возр,
  { {0x82350021,0x7bcd1315,0x2b0e0042,0x00000000}},	//   لرجا, irau, साएँ_,
  { {0x7bcd00bd,0xf7840021,0x88bd0051,0x00000000}},	//   hrau, _اللَ, _gośc,
  { {0x291d0035,0x2b170053,0x7bcd1316,0x00000000}},	//   njwa_, नाडु_, krau,
  { {0x2365007d,0x20091317,0xa3a7005e,0x00000000}},	//   polj_, _crai_, _сјек,
  { {0x82a50055,0x79820051,0x63a91318,0x00000000}},	//   _такж, zmow, mpen,
  { {0x69c303f5,0x7e230141,0x63a91319,0x00000000}},	//   šnej, одрж, lpen,
  { {0x7600000f,0xf388001b,0x63a9131a,0x00000000}},	//   lázá, _hợp_, open,
  { {0x4d630086,0x6a960054,0x0b460785,0x00000000}},	// [1900] ікув, ареє, анан,
  { {0xbd46007e,0x63a90ebe,0x3c19000d,0x00000000}},	//   _چندي, ipen, ыўся_,
  { {0xe9da131b,0x27ed006f,0x7bcd131c,0x00000000}},	//   тке_, _apen_, arau,
  { {0x88e60055,0x7bcd131d,0xa3e60053,0x00000000}},	//   ржде, brau, _पहल_,
  { {0x79820051,0x76000080,0x63a9006f,0x00000000}},	//   rmow, kázá, jpen,
  { {0xf549008d,0x88bd0022,0x68e90058,0x00000000}},	//   iấu_, _pośc, _ebed,
  { {0x63a9131e,0xd5b7066e,0xf549008d,0x00000000}},	//   epen, асы_, hấu_,
  { {0x55060002,0x2ca00c8b,0x5ca9009a,0x00000000}},	//   рчка, ncid_, ְׁתַ,
  { {0xa5070259,0x27e902a5,0x07a30002,0x00000000}},	//   рења_, çant_, _матн,
  { {0x3d0d0042,0x00000000,0x00000000,0x00000000}},	//   _ढोने_,   ,   ,
  { {0xd2570086,0x2d9e0080,0x63a9131f,0x00000000}},	//   ицю_, ítel_, apen,
  { {0xc05b000d,0xf539004c,0x73e60085,0x00000000}},	//   віг_, chť_, _водз,
  { {0xe53b0063,0xc05b0086,0xf09f00cd,0x00000000}},	//   _בתאר, тін_, rcà_,
  { {0x20090164,0x6d561320,0xf09f00cd,0x00000000}},	//   _vrai_, enya, scà_,
  { {0xd337009a,0x637b009a,0x7052005d,0x00000000}},	//   _דרגה_, _שנוד, قچیا,
  { {0xc0cb1321,0x7bcd1322,0x20091323,0x00000000}},	//   _руке_, trau, _trai_,
  { {0x20090488,0x2d9c013d,0x2bb80044,0x00000000}},	// [1910] _urai_, _éven_, لالة_,
  { {0x6d561324,0x7bcd1325,0xfb38005e,0x00000000}},	//   anya, rrau, азуј_,
  { {0x7bcd00e0,0x0b881326,0xc987013f,0x00000000}},	//   srau, рсти_, ауди,
  { {0x637d02a7,0x27390003,0x63a91327,0x00000000}},	//   mène, _mène_, ypen,
  { {0x98e40021,0x63a900e5,0x6d4d1328,0x00000000}},	//   تكنو, xpen, miaa,
  { {0xf549008b,0xc7c8000d,0x57a4000d,0x00000000}},	//   hất_, рыце_, ішча,
  { {0x0f380047,0x76001329,0x7c2d132a,0x00000000}},	//   שרוט_, vázá, lyar,
  { {0x1e58014e,0x63a9132b,0x68e9007d,0x00000000}},	//   ישור_, tpen, _ubed,
  { {0xe6c7007e,0x63a9132c,0x637d0003,0x00000000}},	//   _نتاي, upen, hène,
  { {0xf5e7019d,0x6d4d004b,0x7c2d132d,0x00000000}},	//   _відм, hiaa, iyar,
  { {0xa2d80161,0x7c2d132e,0x61e100cd,0x00000000}},	//   _मार्, hyar, utll,
  { {0x04950021,0x645e0051,0x63a9132f,0x00000000}},	//   _الإح, _śpie, ppen,
  { {0x6d4d0d36,0x84670094,0xd496009a,0x00000000}},	//   diaa, _тъже, _הכנת_,
  { {0xe4500021,0x7c2d1330,0xf412009a,0x00000000}},	//   _تضم_, dyar, _מפד_,
  { {0x9f4b00ea,0x442d1331,0x637d109c,0x00000000}},	//   óját_, lye_, rènd,
  { {0xe0da0138,0x6d4d0b45,0xad390054,0x00000000}},	//   _сви_, giaa, ачує_,
  { {0x442d10ca,0x6d5606c2,0x4f5a007e,0x00000000}},	// [1920] nye_, rnya, _مجدد_,
  { {0x8a3a0055,0x442d0058,0x6c550054,0x00000000}},	//   ляет_, iye_, іттє,
  { {0xd910007e,0x7c2d1332,0x628e1333,0x00000000}},	//   ویس_, ayar, žbov,
  { {0x6d4d0122,0x442d0474,0xf9690054,0x00000000}},	//   ciaa, kye_, арій_,
  { {0x3eba0034,0x307a00b5,0x2912005b,0x00000000}},	//   _kept_, װאַנ, ıya_,
  { {0x443f0418,0x7bd600a4,0x29001334,0x00000000}},	//   dzu_, muyu, žia_,
  { {0x443f007d,0x98a61335,0x7abb0063,0x00000000}},	//   ezu_, _гибе, _תצלו,
  { {0x7d041336,0x442d0035,0x3e830003,0x00000000}},	//   ndis, fye_, lété_,
  { {0xfc4a004c,0x7d041337,0x78a21338,0x00000000}},	//   blíž_, idis, mcov,
  { {0x7d04024a,0xdced027c,0xd6d2014d,0x00000000}},	//   hdis, vlač, _رقص_,
  { {0x443f1339,0x7d040838,0x36060044,0x00000000}},	//   azu_, kdis, _دواف,
  { {0xd257126b,0xdced0240,0xf549008b,0x00000000}},	//   сць_, tlač, uất_,
  { {0x7d04133a,0x443f0051,0x6d4d0914,0x00000000}},	//   ddis, czu_, viaa,
  { {0xa8570063,0x7d04133b,0x6d5a0003,0x00000000}},	//   מיכה_, edis, étan,
  { {0x81a60021,0xdced007d,0x6d4d133c,0x00000000}},	//   _احتل, slač, tiaa,
  { {0xbd6b0076,0xdced08ea,0x7d04133d,0x00000000}},	//   урге_, plač, gdis,
  { {0x7bd600f3,0x6440004d,0xbab901d5,0x00000000}},	// [1930] guyu, nzmi, игах_,
  { {0x6440001c,0x637d01a8,0x7d04133e,0x00000000}},	//   izmi, mènc, adis,
  { {0x7c2d08f0,0x637d0268,0x636f00b9,0x00000000}},	//   syar, lènc, mønt,
  { {0x2730001b,0x26de0942,0x7c2d133f,0x00000000}},	//   _hành_, _acto_, pyar,
  { {0x637d00cd,0x186900e1,0x98c50058,0x00000000}},	//   nènc, јали_, çtır_,
  { {0x637d00cd,0x442d0058,0xe7361340,0x00000000}},	//   iènc, vye_, жеш_,
  { {0x442d00e8,0xf77003eb,0x656900fe,0x00000000}},	//   wye_, راه_, toeh,
  { {0x442d1341,0xb3c903d6,0x2730008b,0x00000000}},	//   tye_, ализ_, _lành_,
  { {0x753b00ea,0x03a8007e,0xf359005e,0x00000000}},	//   rhuz, یدیو_, ишој_,
  { {0x637d0268,0x442d048a,0x2d9e0080,0x00000000}},	//   dènc, rye_, ítek_,
  { {0x442d00ac,0x443f0051,0x64401342,0x00000000}},	//   sye_, szu_, azmi,
  { {0xd00a000a,0x208a005a,0x394f00bd,0x00000000}},	//   аеме_, ийни_, nigs_,
  { {0x637d0268,0x41c50053,0x27300013,0x00000000}},	//   gènc, _विकस, _bành_,
  { {0x78bb1343,0xdfcf0021,0x27300013,0x00000000}},	//   _leuv, ضيف_, _cành_,
  { {0x2730008b,0x78bb1344,0x88bd0022,0x00000000}},	//   _dành_, _oeuv, _rośn,
  { {0x2fcd0198,0x853c0078,0x7d041345,0x00000000}},	//   šega_, _atėj, udis,
  { {0x637d0268,0x78a2027d,0x8b260154,0x00000000}},	// [1940] cènc, vcov, одае,
  { {0x636f0205,0x63a40025,0x7bd60058,0x00000000}},	//   møns, _éine, ruyu,
  { {0x3e830003,0x09e30a91,0x78bb1346,0x00000000}},	//   rété_, дохн, _beuv,
  { {0xcb090063,0x69c312a1,0x64400022,0x00000000}},	//   כל_, ânea, yzmi,
  { {0x98a303d1,0x3e830003,0x38600058,0x00000000}},	//   фиче, pété_, çir_,
  { {0x2cb200b9,0x78a21347,0xb5a61348,0x00000000}},	//   lbyd_, scov, орий,
  { {0x78a20124,0x7bc41349,0xa3dc0042,0x00000000}},	//   pcov, lsiu, तंभ_,
  { {0x6abc0ac6,0x63740268,0x7bc40078,0x00000000}},	//   _herf, màni, osiu,
  { {0x6abc007a,0x7bc4134a,0x53970088,0x00000000}},	//   _kerf, nsiu, овыя_,
  { {0x637d00cd,0x128a0062,0x27e6134b,0x00000000}},	//   vènc, ищни_, mton_,
  { {0x290410ca,0xba9b0063,0x2ef800f5,0x00000000}},	//   _kama_, יסיי, derf_,
  { {0x637d0268,0x29060009,0x799c0035,0x00000000}},	//   tènc, ndoa_, _murw,
  { {0x2904134c,0x2cbf0066,0x27e6134d,0x00000000}},	//   _mama_, _ľud_, nton_,
  { {0x637d0994,0x29040e53,0xfe790080,0x00000000}},	//   rènc, _lama_, řům_,
  { {0x637d0268,0xce94005a,0x3135134e,0x00000000}},	//   sènc, даръ, _некр,
  { {0x5c990475,0x2904134f,0x628e00c2,0x00000000}},	//   ская_, _nama_, žbos,
  { {0xdfdb005a,0x3fc9007e,0x7af71350,0x00000000}},	// [1950] _тъй_, _ادبی_, text,
  { {0x7ff4007e,0xf549008b,0x6b400026,0x00000000}},	//   _آسيا, hấp_, _lögf,
  { {0x78bb03b2,0x7bc40019,0x6abc1351,0x00000000}},	//   _peuv, asiu, _derf,
  { {0x7af71352,0x60dd06f1,0x29041353,0x00000000}},	//   sext, ngsm, _cama_,
  { {0x78bb0003,0x29040955,0x46a50062,0x00000000}},	//   _veuv, _dama_, палв,
  { {0x46a5005a,0x637400cd,0x394f01a8,0x00000000}},	//   чакв, bàni, sigs_,
  { {0x6728017f,0x637400cd,0x6b9d1354,0x00000000}},	//   _dodj, càni, _husg,
  { {0x6b9d00ac,0x5887000d,0x6abc00bd,0x00000000}},	//   _kusg, _дыза, _zerf,
  { {0x27ff0019,0x69c51355,0xc7c7005e,0x00000000}},	//   _usun_, lshe, _фсби,
  { {0xeb9f0146,0x6b9d1356,0x934201d5,0x00000000}},	//   _esøg_, _musg, енье,
  { {0xe8030161,0x6aa5004d,0x29041357,0x00000000}},	//   लिका_, ichf, _yama_,
  { {0x69c50034,0x2ef80438,0x672302e2,0x00000000}},	//   ishe, werf_, ljnj,
  { {0x88bd0051,0x69c50025,0x200f1358,0x00000000}},	//   _rośl, hshe, _ágil_,
  { {0x2d9c000f,0x395f00c7,0x69c7017f,0x00000000}},	//   _évek_, _ljus_, _ovje,
  { {0x6b9d0199,0x69c5006f,0x636f00d1,0x00000000}},	//   _ausg, jshe, søns,
  { {0x69c51359,0xdb0d0058,0x7bc4135a,0x00000000}},	//   dshe, asaü, tsiu,
  { {0x27e6135b,0x7bc40006,0x2cb2135c,0x00000000}},	// [1960] xton_, usiu, rbyd_,
  { {0x7bc40529,0x799c00f3,0x63740268,0x00000000}},	//   rsiu, _purw, tàni,
  { {0x387f135d,0x6abc135e,0x672800b2,0x00000000}},	//   _azur_, _verf, _rodj,
  { {0x6abc135f,0x637400cd,0x27e61360,0x00000000}},	//   _werf, ràni, tton_,
  { {0x2904017f,0x67281361,0x2906035e,0x00000000}},	//   _vama_, _podj, rdoa_,
  { {0x47330086,0x394d01a8,0x7d060058,0x00000000}},	//   нніс, _emes_, _haks,
  { {0x7d0601a5,0x29041362,0x27e60bcf,0x00000000}},	//   _kaks, _tama_, ston_,
  { {0x7d061363,0xda5b0063,0x6b9d1364,0x00000000}},	//   _jaks, _הכלל, _yusg,
  { {0x69c7017f,0xad1b0063,0x7d061365,0x00000000}},	//   _zvje, מוקר, _maks,
  { {0x883b014e,0x7d061366,0xb7d70021,0x00000000}},	//   _התמו, _laks, _روما_,
  { {0x76430045,0x26cc0185,0x65870026,0x00000000}},	//   czny, _iddo_, árhæ,
  { {0x867b0047,0xf487005d,0x84e61367,0x00000000}},	//   _פראו, _کامی, _ходж,
  { {0x60dd1368,0xcfa70121,0xdb0d004b,0x00000000}},	//   rgsm, яшни, tsaü,
  { {0x69c500fe,0x3da71369,0x81f60044,0x00000000}},	//   yshe, зраб, _فأعط,
  { {0xdef8000d,0x9e140086,0x7d06136a,0x00000000}},	//   чыя_, ндрі, _baks,
  { {0x7607004c,0x88bd0022,0x625b009d,0x00000000}},	//   lézá, _pośm, _לכוה,
  { {0x69c7017f,0xd11a0053,0x60cd136b,0x00000000}},	// [1970] _svje, धारण_, _idam,
  { {0x69c3017d,0x69c5136c,0x6aa5004d,0x00000000}},	//   âneo, tshe, uchf,
  { {0x6aa5136d,0xf9f90593,0x7d06136e,0x00000000}},	//   rchf, تفاع_, _faks,
  { {0x26cc001f,0x6aa5004d,0xe2930047,0x00000000}},	//   _addo_, schf, גװע_,
  { {0x394d00c3,0xfc64005a,0x69c5136f,0x00000000}},	//   _vmes_, _зърн, sshe,
  { {0xe29a0013,0xb9e70054,0x8c1a0063,0x00000000}},	//   _ngư_, _ніби, _וושי,
  { {0x69c70117,0x945d0051,0xba77007e,0x00000000}},	//   _uvje, kańc, _راست,
  { {0xbe3c0063,0x76430051,0x27f0004c,0x00000000}},	//   מעות, rzny, ílný_,
  { {0xb4ad0053,0x387f0089,0x67d40b4c,0x00000000}},	//   _कभी_, _uzur_, _поту,
  { {0xd75b006a,0x81c90e12,0xe0df01f4,0x00000000}},	//   _اجرا_, огов_, egò_,
  { {0x776400cd,0xa51d000d,0xb6350044,0x00000000}},	//   éixe, _вялi, _تفاع,
  { {0x2d9c013d,0x00000000,0x00000000,0x00000000}},	//   _évei_,   ,   ,
  { {0x7d06003d,0x6b4000c7,0x60cd001f,0x00000000}},	//   _raks, _höge, _ddam,
  { {0x6d4f1370,0x7d061371,0xf456089e,0x00000000}},	//   _amca, _saks, _קיסר_,
  { {0x2d9e03b2,0x4df5019d,0x7d061372,0x00000000}},	//   ête_, нятт, _paks,
  { {0x6b400e77,0xee370054,0xf236005d,0x00000000}},	//   _möge, єнт_, _تبهک,
  { {0xed57000a,0x7d061373,0x98ad0022,0x00000000}},	// [1980] фот_, _vaks, _zleć_,
  { {0x4c830002,0x7c2b00a5,0x5aca0083,0x00000000}},	//   тлув, ägra, ілем_,
  { {0x637400cd,0x63510080,0x823a0047,0x00000000}},	//   mànt, měně, ֿענצ,
  { {0x637400cd,0x7d0600d1,0x00000000,0x00000000}},	//   lànt, _uaks,   ,
  { {0x661d0078,0xa09b009f,0x07fa00f2,0x00000000}},	//   _ąska, קיסט, تراع_,
  { {0xeb9f0307,0xd5b0007e,0xf1c00066,0x00000000}},	//   _prøv_, هفت_, úšky_,
  { {0x8a030794,0x00000000,0x00000000,0x00000000}},	//   _изре,   ,   ,
  { {0x3ce00146,0xa926000d,0xdb0d0014,0x00000000}},	//   ngiv_, _ўдал, lsað,
  { {0x671e0053,0x14180021,0xb3660062,0x00000000}},	//   पादक_, سيدة_, дънк,
  { {0xf7720021,0xdb0d0014,0x6b4000a5,0x00000000}},	//   _شاء_, nsað, _högb,
  { {0x2fc91374,0xcad70063,0x945d0051,0x00000000}},	//   _svag_, ווית_, tańc,
  { {0x914b01dd,0xd2570766,0x7bcb013d,0x00000000}},	//   ічна_, ьцы_, águk,
  { {0x3ce000b9,0x6b40004d,0xf41f0072,0x00000000}},	//   dgiv_, _zöge, äät_,
  { {0x6374051e,0x2d8c006f,0x5f940062,0x00000000}},	//   tànu, ïden_, кият,
  { {0xf206005a,0x254c0051,0x9f52013d,0x00000000}},	//   _цяло, eśli_, óbát_,
  { {0x9d18005a,0x00000000,0x00000000,0x00000000}},	//   мост_,   ,   ,
  { {0xfd1f0013,0x7b1506da,0x62850066,0x00000000}},	// [1990] _chìa_, ндах, _úhor,
  { {0xdb0d0014,0x7a39009c,0xea630043,0x00000000}},	//   gsað, jútö, نپذی,
  { {0x69c800b9,0xe9ab0043,0x00000000,0x00000000}},	//   _ædel, زدان_,   ,
  { {0xeb9f00d1,0xdce4005b,0x98f4000d,0x00000000}},	//   _brøt_, mliğ, вяшч,
  { {0xdce4005b,0x7ac71375,0xe894012c,0x00000000}},	//   lliğ, _осве, ваць,
  { {0x6d910066,0xd5e50062,0x254c004c,0x00000000}},	//   _sťah, ежки, měly_,
  { {0xd5b10032,0xdce401f7,0x58d51376,0x00000000}},	//   دفع_, nliğ, _повт,
  { {0x6b4000bd,0xd61800f2,0xd7fb1377,0x00000000}},	//   _vöge, بتها_, _муз_,
  { {0x6d5a0164,0x65620150,0x44391378,0x00000000}},	//   étai, _djoh, ás_,
  { {0xdce4005b,0x42251379,0x6d4300dd,0x00000000}},	//   kliğ, едов, _înaf,
  { {0x78a402e2,0x63a40025,0x4439001c,0x00000000}},	//   žive, _éinn, šs_,
  { {0xa06a0001,0x64a50002,0x254c0022,0x00000000}},	//   зама_, _џала, yśli_,
  { {0x2c6c004c,0x98a4008f,0x9259005d,0x00000000}},	//   _kódů_, _jomā_, تشکر_,
  { {0x2d990003,0x254c004c,0x657b004e,0x00000000}},	//   _aise_, děly_, lluh,
  { {0x2d99006c,0x72050044,0x975a009a,0x00000000}},	//   _bise_, _أوبم, לדשט,
  { {0x62830117,0x20040026,0xa1c20062,0x00000000}},	//   _izno, æmis_, _сбъд,
  { {0x60c60360,0xbea6137a,0x2d99137b,0x00000000}},	// [19a0] makm, _папк, _dise_,
  { {0x539a0063,0x2d9900ac,0x1ae312b9,0x00000000}},	//   פיעו, _eise_, лоум,
  { {0x533600b5,0xdebb0063,0xe8fa137c,0x00000000}},	//   ענען_, _ממיל, зле_,
  { {0xe1ff0045,0xdb1d00c7,0x5976007e,0x00000000}},	//   łów_, _avsä, رداز,
  { {0x6d5605b4,0x69d700cd,0x3f9a004e,0x00000000}},	//   miya, arxe, _kipu_,
  { {0x2d99000c,0x657b0150,0x6d56137d,0x00000000}},	//   _zise_, eluh, liya,
  { {0xceb3014e,0xfe79011b,0x6b63137e,0x00000000}},	//   ניה_, řův_, _скра,
  { {0x6d56137f,0x6d44017d,0x7afe1380,0x00000000}},	//   niya, nhia, lept,
  { {0x75d4006a,0xa3e70001,0xe3af006a,0x00000000}},	//   ريکا, едња_, یری_,
  { {0xfd1f001b,0x6d561381,0x7afe1382,0x00000000}},	//   _nhìn_, hiya, nept,
  { {0xf41f0019,0x6d44017e,0xd25a0062,0x00000000}},	//   äär_, khia, яци_,
  { {0x8466005a,0x88bd0051,0x64a3005e,0x00000000}},	//   _пъле, _dośw, _баца,
  { {0x557700b5,0x6d56028d,0x2d990034,0x00000000}},	//   _װעגן_, diya, _rise_,
  { {0x637400cd,0x69de1383,0x2d991384,0x00000000}},	//   ràns, kupe, _sise_,
  { {0x63a21385,0xe2130021,0xa2bb0066,0x00000000}},	//   _huon, _مبيع, äčše,
  { {0x63a20009,0xdce401f7,0x6d441386,0x00000000}},	//   _kuon, rliğ, ghia,
  { {0x2d991387,0x63a200fe,0xdce40058,0x00000000}},	// [19b0] _vise_, _juon, sliğ,
  { {0x2d9904bf,0xdce4005b,0x5f950092,0x00000000}},	//   _wise_, pliğ, _шипт,
  { {0x63a2024a,0xda6708aa,0x69de0019,0x00000000}},	//   _luon, رائي, gupe,
  { {0xacbb0164,0x6d441388,0xe8590085,0x00000000}},	//   _coût, chia, маеш_,
  { {0x63a2002c,0xe72e000d,0x7afe0058,0x00000000}},	//   _nuon, ае_, bept,
  { {0xf72b000d,0x7d0d1389,0x7afe138a,0x00000000}},	//   яцей_, ldas, cept,
  { {0xc1790078,0x69de0530,0x7bdf138b,0x00000000}},	//   ntės_, cupe, luqu,
  { {0x63a2138c,0x7d0d138d,0xacbb0003,0x00000000}},	//   _buon, ndas, _goût,
  { {0x59640062,0x6b400137,0x7d0d138e,0x00000000}},	//   _съра, _höga, idas,
  { {0x7d0d00fe,0x88bd0051,0xf6470154,0x00000000}},	//   hdas, _pośw, _пхен,
  { {0x60c6138f,0x61460ab1,0x26c708c9,0x00000000}},	//   takm, вена, mano_,
  { {0x7afe00bd,0x26c71390,0x81d4000d,0x00000000}},	//   zept, lano_, ыцьц,
  { {0xf99200b5,0x60c6005b,0x62830051,0x00000000}},	//   ירט_, rakm, _wzno,
  { {0x7529074f,0x26c71391,0x7bdf1392,0x00000000}},	//   ljez, nano_, duqu,
  { {0x26c71393,0x6449004d,0x6d561394,0x00000000}},	//   iano_, lzei, tiya,
  { {0xdcf60078,0x3207004d,0x7c360072,0x00000000}},	//   plyč, _isny_, tyyr,
  { {0x7afe0529,0x644900bd,0x6d4408a4,0x00000000}},	// [19c0] tept, nzei, rhia,
  { {0x60c40627,0x6d561395,0xdb590086,0x00000000}},	//   _heim, siya, нює_,
  { {0x644900bd,0x3ed900b5,0x6d5600a4,0x00000000}},	//   hzei, _אַרא, piya,
  { {0x7afe1396,0x7989035a,0x39401397,0x00000000}},	//   sept, _chew, óis_,
  { {0x87e30076,0x68e21398,0xacbb0164,0x00000000}},	//   ающе, rgod, _voût,
  { {0x26c71399,0xa77302fe,0x68e2139a,0x00000000}},	//   gano_, аліч, sgod,
  { {0x63a2051e,0x2480003d,0x644900bd,0x00000000}},	//   _suon, _šim_, ezei,
  { {0x644900bd,0x26c700a4,0x60c4139b,0x00000000}},	//   fzei, aano_, _neim,
  { {0x26c7139c,0x6449004d,0xdced007d,0x00000000}},	//   bano_, gzei, slać,
  { {0x394603d9,0x63a2024a,0xdced017f,0x00000000}},	//   lhos_, _vuon, plać,
  { {0xf549008b,0x60c4004d,0xfb150041,0x00000000}},	//   hấy_, _beim, אַרט_,
  { {0x394603d9,0x51870001,0x60c40025,0x00000000}},	//   nhos_, ђуна, _ceim,
  { {0x60c4139d,0x9346139e,0x14d7009f,0x00000000}},	//   _deim, _инде, _יואל_,
  { {0x533300e1,0xee870121,0x6b9c004d,0x00000000}},	//   _вешт, выбо, _nirg,
  { {0x2fc0135f,0xc7c8008b,0xa3a80053,0x00000000}},	//   _ewig_, hố_, _खंड_,
  { {0x6b9c057a,0xc1790006,0x6da40002,0x00000000}},	//   _airg, rtės_, риѓа,
  { {0x7d0d06a7,0xc1790006,0x26c7139f,0x00000000}},	// [19d0] rdas, stės_, yano_,
  { {0x7cde000c,0x16020053,0x6b9c0025,0x00000000}},	//   tărâ, लबार_, _cirg,
  { {0x26c713a0,0x995c004c,0x6b9c13a1,0x00000000}},	//   vano_, líř_, _dirg,
  { {0x26c70045,0x09e40054,0xc98413a2,0x00000000}},	//   wano_, роїн, аучи,
  { {0x9bc4000d,0x386913a3,0x26c713a4,0x00000000}},	//   _вёск, çar_, tano_,
  { {0xa03c0063,0x69d8004c,0x9665030b,0x00000000}},	//   ועדפ, ávec, лкле,
  { {0x78a413a5,0x26c713a6,0x7bcd13a7,0x00000000}},	//   živa, rano_, lsau,
  { {0xf3ff13a8,0x24090055,0x394613a9,0x00000000}},	//   ção_, ении_, chos_,
  { {0x60c413aa,0xf2a50121,0x26c713ab,0x00000000}},	//   _reim, липп, pano_,
  { {0x64490199,0x2b1c0161,0x753b0080,0x00000000}},	//   rzei, नाएँ_, skuz,
  { {0x644913ac,0xd4f5000d,0x7ae513ad,0x00000000}},	//   szei, _бялы, ight,
  { {0x26c5001f,0xe4cb007e,0x7bcd13ae,0x00000000}},	//   _helo_, _آبان_, ksau,
  { {0xb4df016a,0x25a513af,0xdb0f006d,0x00000000}},	//   तली_, _hull_, _etcé,
  { {0x7bcd01e1,0x26c5007c,0xe8e00042,0x00000000}},	//   dsau, _jelo_, _पञ्च,
  { {0x60c40185,0x20090150,0x26c50552,0x00000000}},	//   _teim, _esai_, _melo_,
  { {0x6b9c004b,0x7bcd004d,0xf1b2009f,0x00000000}},	//   _sirg, fsau, _פסח_,
  { {0x61e10556,0x7bcd13b0,0x7ff60021,0x00000000}},	// [19e0] lull, gsau, _إسبا,
  { {0x68e90016,0xec7713b1,0x909b0063,0x00000000}},	//   _aced, упу_, _אספק,
  { {0x21200080,0x637d00cd,0x25a513b2,0x00000000}},	//   _knih_, gèni, _null_,
  { {0x6b400026,0x07a6000d,0x68e913b3,0x00000000}},	//   _gögn, гадн, _cced,
  { {0x6b9c001c,0x7e7e13b4,0x26c513b5,0x00000000}},	//   _tirg, _hypp, _belo_,
  { {0x26c508ea,0x2d8013b6,0x25a513b7,0x00000000}},	//   _celo_, llie_, _bull_,
  { {0x2120017f,0x26c5082a,0xaa460062,0x00000000}},	//   _onih_, _delo_, _севл,
  { {0x61e113b8,0x25a504bf,0x29560062,0x00000000}},	//   dull, _dull_, _съгр,
  { {0xdd040006,0xb8660021,0x786613b9,0x00000000}},	//   ūrės, _صارو, _сказ,
  { {0x26c513ba,0x25a513bb,0x61e113bc,0x00000000}},	//   _gelo_, _full_, full,
  { {0x61e1076d,0x9f420072,0x7bcd008f,0x00000000}},	//   gull, itkä_, zsau,
  { {0x26c50198,0xa15913bd,0x248604fa,0x00000000}},	//   _zelo_, таму_, _tzom_,
  { {0xd0e60161,0x2d800066,0x61e10072,0x00000000}},	//   _कारण_, dlie_, aull,
  { {0xa2940500,0x20d5008d,0x6b400046,0x00000000}},	//   _калі, ụi_, _sögn,
  { {0x61e113be,0x1df802dc,0x3d8b0094,0x00000000}},	//   cull, леры_, ещан_,
  { {0x637d00cd,0x2d8004e4,0x7bcd13bf,0x00000000}},	//   vèni, glie_, tsau,
  { {0x200900f3,0xcb55005e,0xbed50141,0x00000000}},	// [19f0] _usai_, аваћ, _копј,
  { {0x7ae50034,0x6d5a0003,0x7bcd13c0,0x00000000}},	//   ught, étar, rsau,
  { {0x2d8013c1,0x7d0e0072,0x9b6808a8,0x00000000}},	//   blie_, önsä, ушта_,
  { {0x7bcd09ff,0xb815000a,0xfd1f0290,0x00000000}},	//   psau, идеј, _unì_,
  { {0x26c503d9,0x25a502f6,0xf77101a7,0x00000000}},	//   _pelo_, _sull_, يات_,
  { {0x25a50465,0x7bda0063,0x7d0f013d,0x00000000}},	//   _pull_, _בקשו, _hacs,
  { {0x6b400199,0x65c20ac5,0x26c513c2,0x00000000}},	//   _mögl, обща, _velo_,
  { {0x61e1024a,0xb4df016a,0x25a50268,0x00000000}},	//   vull, तले_, _vull_,
  { {0xa3e50053,0x2d160047,0x26c50648,0x00000000}},	//   बंध_, בֿים_, _telo_,
  { {0x61e113c3,0x25a513c4,0xe29913c5,0x00000000}},	//   tull, _tull_, кап_,
  { {0xcb12009f,0x61e10072,0xe12613c6,0x00000000}},	//   קלט_, uull, амни,
  { {0x61e113c7,0xa3e50042,0x98a40078,0x00000000}},	//   rull, बंद_, _tomą_,
  { {0x22590022,0x4fa60062,0x61e113c8,0x00000000}},	//   ńsk_, ригв, sull,
  { {0x61e100fe,0xd007005e,0x3f9e13c9,0x00000000}},	//   pull, јере_, ötu_,
  { {0x3f84001c,0xef17018e,0xed5a0160,0x00000000}},	//   ēmu_, јмс_, вов_,
  { {0xdca30071,0x205613ca,0x2d8013cb,0x00000000}},	//   жати, _втор, ulie_,
  { {0xebe60054,0x7d0f00a3,0x2d8013cc,0x00000000}},	// [1a00] розп, _dacs, rlie_,
  { {0xa03b0063,0x2d8013cd,0x7e7e1256,0x00000000}},	//   _סעיפ, slie_, _typp,
  { {0x6edb0063,0xa3e50053,0x2d8013ce,0x00000000}},	//   _בחיפ, बूत_, plie_,
  { {0xd9460001,0xebe60f50,0xcc8a0043,0x00000000}},	//   једи, _комп, _لنجه_,
  { {0x88bd0051,0x7d0413cf,0x98560002,0x00000000}},	//   _pośr, meis, јтеш,
  { {0xed590024,0x5777000d,0x63a40003,0x00000000}},	//   ďže_, абіў_, _éini,
  { {0x94d4000d,0x76a90054,0xe737007b,0x00000000}},	//   бойц, утів_, реј_,
  { {0x7d04024a,0x940404a0,0xb7da04a0,0x00000000}},	//   neis, موعه, _لورا_,
  { {0xc34a005a,0x66e6018e,0x6b400026,0x00000000}},	//   вяне_, _воза, _lögm,
  { {0x79820034,0x16760001,0x973c007d,0x00000000}},	//   llow, _кћер, _biće,
  { {0x7d0413d0,0x6d460072,0x3218004c,0x00000000}},	//   keis, _olka, íry_,
  { {0x7d0400fe,0x92570121,0x69de00e5,0x00000000}},	//   jeis, рают_, irpe,
  { {0x60d6001f,0x32020080,0x7522007d,0x00000000}},	//   _ddym, ňky_, _inoz,
  { {0xc0580086,0x6d4613d1,0x76670078,0x00000000}},	//   рію_, _alka, šryš,
  { {0xd3780117,0x7d0413d2,0x79820022,0x00000000}},	//   moć_, feis, klow,
  { {0x929b014e,0xe29b0063,0x7c870fd0,0x00000000}},	//   _ביות, _בשור, аузе,
  { {0x75220080,0xfaa713d3,0x69de13d4,0x00000000}},	// [1a10] _mnoz, ашен, erpe,
  { {0x6d460122,0x78a4027c,0x6e3c00b9,0x00000000}},	//   _elka, živl, byrb,
  { {0x3f83027c,0xce680121,0x7d0f13d5,0x00000000}},	//   mlju_, _вряд_, _tacs,
  { {0x97c50021,0x4978000d,0x79820022,0x00000000}},	//   مقصو, асіў_, glow,
  { {0x69de13d6,0x3f8302f7,0xd37813d7,0x00000000}},	//   arpe, olju_, koć_,
  { {0xd246006a,0x907a0047,0xdb23007e,0x00000000}},	//   _فن_, נטװי, _بوسی,
  { {0x5a44000d,0x798213d8,0x317913d9,0x00000000}},	//   _дэта, blow, kosz_,
  { {0x7bdf0b23,0x893813da,0x00000000,0x00000000}},	//   orqu, _кпсс_,   ,
  { {0x1422000d,0x4615005d,0x2eb70042,0x00000000}},	//   здым, _گوار, _अभूत,
  { {0x51b90085,0xf7850044,0x7d040c57,0x00000000}},	//   лымя_, _الطَ, zeis,
  { {0x27e90078,0x00000000,0x00000000,0x00000000}},	//   šinę_,   ,   ,
  { {0x4254000d,0x64580051,0xcea9009f,0x00000000}},	//   ітэт, _ściś, _טי_,
  { {0x05740021,0x442913db,0xd91a0047,0x00000000}},	//   _بالد, _ça_, אורל,
  { {0x7d040199,0x6e3c02f0,0x63bb13dc,0x00000000}},	//   weis, tyrb, mpun,
  { {0xeb9f0031,0x7bdf0268,0x7d0413dd,0x00000000}},	//   _esøk_, erqu, teis,
  { {0x90c61001,0x3f830ba5,0x27ff003b,0x00000000}},	//   _убие, alju_, _opun_,
  { {0x3f83017f,0x6d580078,0x7d0413de,0x00000000}},	// [1a20] blju_, _įvad, reis,
  { {0x7d040d68,0x63bb13df,0x637d00cd,0x00000000}},	//   seis, ipun, cènt,
  { {0xe9da1321,0x6b400137,0x7d0413e0,0x00000000}},	//   уке_, _högk, peis,
  { {0x63bb1203,0x6d460050,0xf1b2009a,0x00000000}},	//   kpun, _ulka, פסד_,
  { {0x1867005e,0x645d0066,0xe73a13e1,0x00000000}},	//   баци_, úsil, лед_,
  { {0x63bb13e2,0x78250021,0xa09b0063,0x00000000}},	//   dpun, تعمل, אינט,
  { {0xd6d90086,0xceb3009f,0xa96a0818,0x00000000}},	//   рті_, היו_, _бива_,
  { {0x93b40054,0x63bb0285,0xd90e005d,0x00000000}},	//   обиц, fpun, _سیت_,
  { {0x63bb13e3,0xa5070002,0xe56f0044,0x00000000}},	//   gpun, сења_, عطى_,
  { {0xaaba0161,0x51f80086,0x68fb13e4,0x00000000}},	//   ेरिक, аною_, _zbud,
  { {0x3f83017f,0x63bb00a4,0x62340002,0x00000000}},	//   vlju_, apun, цену,
  { {0x73e60088,0x71470076,0x1a9b0047,0x00000000}},	//   _годз, схож, טייע,
  { {0x637d00cd,0x3179013d,0x7afc08ed,0x00000000}},	//   tènt, rosz_, _obrt,
  { {0x85040043,0x00000000,0x00000000,0x00000000}},	//   _دوچن,   ,   ,
  { {0x637d00cd,0xd5d8009a,0xa226005d,0x00000000}},	//   rènt, יַּש, _درشه,
  { {0x78a4007d,0x3f8300c2,0x6b400137,0x00000000}},	//   živj, slju_, _högh,
  { {0xfd4f008b,0x3f83007d,0x3ce913e5,0x00000000}},	// [1a30] _khiế, plju_, rgav_,
  { {0xd5b80023,0x00000000,0x00000000,0x00000000}},	//   _otā_,   ,   ,
  { {0x27ff13e6,0x3ce913e7,0x63bb004d,0x00000000}},	//   _spun_, pgav_, zpun,
  { {0x28f90121,0x6b400014,0x6f070022,0x00000000}},	//   редь_, _lögh, lejc,
  { {0x6aa9000c,0x6d5f00ac,0x63bb13e8,0x00000000}},	//   _şefu, miqa, xpun,
  { {0xfd4f008b,0x6d4d13e9,0x68fb0022,0x00000000}},	//   _nhiế, lhaa, _wbud,
  { {0xc5d50086,0xaa5d012c,0xf6f60043,0x00000000}},	//   ціль, _ревi, تزنگ,
  { {0x63bb13ea,0x68fb007d,0xcdaa0041,0x00000000}},	//   tpun, _ubud, סיפֿ,
  { {0x69da01e3,0x14250086,0x68e4017d,0x00000000}},	//   _åter, ідом, óide,
  { {0xfd4f00aa,0x27e00025,0x63bb13eb,0x00000000}},	//   _chiế, áine_, rpun,
  { {0x63bb13ec,0x6f070080,0x6d4813ed,0x00000000}},	//   spun, dejc, ūdai,
  { {0xd24e006a,0xdced017f,0x27e007b4,0x00000000}},	//   خچه_, klađ, šine_,
  { {0x297a0047,0x6d4d0089,0x232913ee,0x00000000}},	//   שטרא, dhaa, _воли_,
  { {0x63ab00a4,0x69d500c2,0x656913ef,0x00000000}},	//   _iugn, _ovze, lneh,
  { {0x4176006a,0x6d5f0089,0x8d5a02b6,0x00000000}},	//   _وابس, fiqa, ашат_,
  { {0x63a3047f,0x6d43000c,0x6283002c,0x00000000}},	//   _hinn, _înal, _iyno,
  { {0x63a30004,0x3c660088,0x6283001f,0x00000000}},	// [1a40] _kinn, цкаг, _hyno,
  { {0xbad5000d,0x63ab13f0,0x657b0066,0x00000000}},	//   зіцы, _mugn, houh,
  { {0x443f014f,0x63ab0137,0x63a313f1,0x00000000}},	//   hyu_, _lugn, _minn,
  { {0x6d4d0122,0x63a30449,0x27e600a4,0x00000000}},	//   chaa, _linn, tuon_,
  { {0x65690024,0x63a30025,0x38cb007e,0x00000000}},	//   dneh, _oinn, شانی_,
  { {0x6d440006,0x501b0063,0x17540376,0x00000000}},	//   lkia, יונו, явля,
  { {0x63ab007a,0x656900bd,0xdce402e2,0x00000000}},	//   _augn, fneh, hnič,
  { {0x6d4400eb,0x63a30025,0xdb04006d,0x00000000}},	//   nkia, _ainn, mpiñ,
  { {0x63a30102,0xfd4f008b,0x6d440006,0x00000000}},	//   _binn, _phiế, ikia,
  { {0x63a30027,0x5fa50235,0xdce413f2,0x00000000}},	//   _cinn, _गूगल, dnič,
  { {0x63a30034,0x6283001f,0x6d4400fe,0x00000000}},	//   _dinn, _cyno, kkia,
  { {0x63a313f3,0x6283001f,0x443f00a4,0x00000000}},	//   _einn, _dyno, byu_,
  { {0xfd4f001b,0x61e1001f,0x7d160731,0x00000000}},	//   _thiế, arll, ddys,
  { {0x63a313f4,0x6d4413f5,0x6283002b,0x00000000}},	//   _ginn, ekia, _fyno,
  { {0x26cc0016,0x6d5f0089,0xdd95000d,0x00000000}},	//   _medo_, tiqa, завы,
  { {0x91b7007e,0x63a313f6,0x1bb5000d,0x00000000}},	//   _بطور_, _zinn, збаў,
  { {0x6d5f0089,0x317200ea,0x6d4d13f7,0x00000000}},	// [1a50] riqa, ézze_, rhaa,
  { {0xce95005a,0x6d440ddd,0x7c2d01a8,0x00000000}},	//   _напъ, akia, rxar,
  { {0x60cd014f,0x657b0035,0x7d160078,0x00000000}},	//   _keam, youh, bdys,
  { {0x644000fe,0x89a80054,0x6ee7005d,0x00000000}},	//   kymi, іків_, _اسکل,
  { {0x65690024,0x8807007e,0xb80701fb,0x00000000}},	//   vneh, تظام, تباه,
  { {0x26cc13f8,0xdc3a0063,0x60cd0d17,0x00000000}},	//   _cedo_, _העשר, _leam,
  { {0x656913f9,0x63a313fa,0x26cc00f8,0x00000000}},	//   tneh, _rinn, _dedo_,
  { {0x60cd13fb,0x442d00cd,0x63ab13fc,0x00000000}},	//   _neam, txe_, _pugn,
  { {0x3f980185,0x656913fd,0xb4bb0053,0x00000000}},	//   ymru_, rneh, _अभी_,
  { {0xaacb0161,0x657b0080,0x6d9304a5,0x00000000}},	//   िरिक, souh, lçad,
  { {0x171a0063,0x443f00a4,0x63a313fe,0x00000000}},	//   _לֵאמ, syu_, _vinn,
  { {0x6d9313ff,0xdce40c61,0x63a31400,0x00000000}},	//   nçad, tnič, _winn,
  { {0x8235006a,0x62830051,0x63ab00a4,0x00000000}},	//   زرگا, _wyno, _uugn,
  { {0x61e81401,0x20dc008b,0x63a31402,0x00000000}},	//   budl, ửi_, _uinn,
  { {0xdce4055e,0x61461403,0xddde011b,0x00000000}},	//   snič, _нека, _vypů,
  { {0x6d441404,0x60cd032c,0xdce40734,0x00000000}},	//   ukia, _geam, pnič,
  { {0x2fc9001f,0x945d0022,0x6d441405,0x00000000}},	// [1a60] _gwag_, mańs, rkia,
  { {0x8eea0086,0x78a90290,0xbcfb0003,0x00000000}},	//   _умов_, _agev, _améd,
  { {0x26cc1101,0x64400051,0xb05b004d,0x00000000}},	//   _redo_, zymi, nbän,
  { {0x4c6a0121,0x64400050,0xc9590085,0x00000000}},	//   _гимн_, yymi, оўі_,
  { {0x2d8202ab,0x0c23000d,0xad1b0063,0x00000000}},	//   _ikke_, _змян, _הוכר,
  { {0x6d93017d,0x98a30456,0xeb971406,0x00000000}},	//   açad, хиче, _ния_,
  { {0x78ad0add,0x945d0051,0x8b23005a,0x00000000}},	//   žava, kańs, _ядре,
  { {0xe5a30001,0x945d0051,0x64401407,0x00000000}},	//   нији, jańs, tymi,
  { {0x7bd60150,0x60cd1408,0xd37a0062,0x00000000}},	//   nsyu, _ream, йчо_,
  { {0x60cd1409,0xcc570063,0x6440057c,0x00000000}},	//   _seam, פסיק_, rymi,
  { {0x60cd0004,0x78a900ac,0x91e30002,0x00000000}},	//   _peam, _ygev, ноќе,
  { {0xf8cc0161,0x39460006,0x7bd600a4,0x00000000}},	//   ारिय, nkos_, ksyu,
  { {0x60cd140a,0xb97b0063,0xb4e80042,0x00000000}},	//   _veam, מנטי, बली_,
  { {0xd14b006a,0x90980062,0xdfa40002,0x00000000}},	//   _گشتن_, явят_, ејсо,
  { {0x7bd60089,0xfe700021,0x60cd140b,0x00000000}},	//   esyu, هدف_, _team,
  { {0x2d580055,0x6b40007a,0xe21300de,0x00000000}},	//   пись_, _mögu, _أبوع,
  { {0x2fc90bc1,0x6b400026,0x6728007d,0x00000000}},	// [1a70] _uwag_, _lögu, _ondj,
  { {0x2aab0138,0xe451009a,0x7ff400de,0x00000000}},	//   стао_, כֶב_, _أسيا,
  { {0x442b008b,0x7f3c0063,0x62860051,0x00000000}},	//   ̣c_, _לעזו, ękow,
  { {0xbcfb02dd,0x39460150,0x67280019,0x00000000}},	//   _ejér, gkos_, _andj,
  { {0x16a90076,0xe7391001,0x6d930367,0x00000000}},	//   овли_, жел_, rçad,
  { {0x945d0022,0x2be20042,0x2d89140c,0x00000000}},	//   zańs, _पिता, llae_,
  { {0x25a6140d,0x75390022,0x00000000,0x00000000}},	//   _biol_, _powz,   ,
  { {0x6b400026,0xf993007e,0xe3b9140e,0x00000000}},	//   _dögu, _سبز_, оби_,
  { {0x56f50002,0x395f059f,0x0ebf0042,0x00000000}},	//   _опаѓ, _imus_, ्राड,
  { {0xaadd0053,0xc245140f,0xf8680044,0x00000000}},	//   मणिक, днок, _عملي_,
  { {0x945d0051,0x7790007e,0x66f20042,0x00000000}},	//   tańs, _حیوا, _घातक_,
  { {0x69d80016,0xb05b00bd,0x6b400137,0x00000000}},	//   ávei, rbän, _högt,
  { {0x34940141,0x657c013d,0x6f17008d,0x00000000}},	//   _зацр, _írha, _baxc,
  { {0x2d8900ac,0x2268004c,0x6265012d,0x00000000}},	//   elae_, átká_, _овла,
  { {0xdef9000d,0x945d0051,0x8fa31410,0x00000000}},	//   чыў_, pańs, таре,
  { {0xa187005a,0xdb240043,0x00000000,0x00000000}},	//   _обща_, کوئی,   ,
  { {0x31600075,0xad6500de,0x50db009d,0x00000000}},	// [1a80] _imiz_, رافه, _וחפצ,
  { {0x7bd60397,0x32ba0047,0x394d1411,0x00000000}},	//   rsyu, ַזנד, _ales_,
  { {0x6b5210c4,0x394d00ac,0xceb312cd,0x00000000}},	//   _lægg, _bles_, _בית_,
  { {0x39460006,0x78ad01b3,0x9cb6007e,0x00000000}},	//   ukos_, žavn, _زمست,
  { {0x6b400026,0xeb9a06da,0x39461412,0x00000000}},	//   _sögu, _мим_, rkos_,
  { {0x394d03d9,0xd5ba0187,0x46140021,0x00000000}},	//   _eles_, оси_, فوتر,
  { {0xda650021,0x394d00ca,0x00000000,0x00000000}},	//   _كافي, _fles_,   ,
  { {0xe947007e,0xb4e80053,0x38790003,0x00000000}},	//   _قرقی, बले_, égré_,
  { {0xd90d007e,0x25a61413,0x03c3014b,0x00000000}},	//   _دین_, _viol_, ксэм,
  { {0x628f0051,0x2129004c,0x25f60042,0x00000000}},	//   ęcon, _snah_, _एमपी_,
  { {0x6b4001e3,0xcb130063,0x394d004e,0x00000000}},	//   _högs, דלת_, _yles_,
  { {0x2d4700be,0x27e61414,0x05661415,0x00000000}},	//   _põem_, oron_, _ювен,
  { {0x6d430529,0x104b0086,0x27e601f4,0x00000000}},	//   _înai, іями_, nron_,
  { {0x4034005e,0x2bb50042,0x63bd1416,0x00000000}},	//   њерс, _अंबा, ísne,
  { {0x3da70088,0x6b400014,0x27e61417,0x00000000}},	//   драб, _lögs, hron_,
  { {0x3f8a005f,0x00000000,0x00000000,0x00000000}},	//   albu_,   ,   ,
  { {0x1eab0021,0x2bbb0044,0x00000000,0x00000000}},	// [1a90] _وادي_, تازة_,   ,
  { {0xa3e60161,0x2d8900ac,0x1b780021,0x00000000}},	//   _बटन_, slae_, وصلة_,
  { {0x27e602dd,0x6b4000ea,0x27e00139,0x00000000}},	//   eron_, _rögt, áinn_,
  { {0xab5b0058,0x61fa1418,0x7e9a009a,0x00000000}},	//   _stüd, ittl, _מסתו,
  { {0x7d0d13e6,0x78ad007d,0x7643002b,0x00000000}},	//   meas, žavo, wyny,
  { {0x7d0d1419,0xf77301a7,0x764300fe,0x00000000}},	//   leas, خاص_, tyny,
  { {0x27e6141a,0xfbb50042,0x2bb50082,0x00000000}},	//   aron_, _अंडम, _अंडा,
  { {0x7d0d141b,0x27e6141c,0x1a68005d,0x00000000}},	//   neas, bron_, _تیمی_,
  { {0xa775000d,0x998500ea,0x61fa141d,0x00000000}},	//   _злач, _élő_, ettl,
  { {0x6b4000c7,0x6b5200b9,0xdb0600ea,0x00000000}},	//   _högr, _vægg, _kuká,
  { {0x26c700c3,0x7d0d00fe,0x59990063,0x00000000}},	//   mbno_, keas, ּשָׁ,
  { {0x361a0063,0x200500dd,0x7d0d00dd,0x00000000}},	//   _מועד, ălin_, jeas,
  { {0x61fa0034,0x2d80141e,0xab640058,0x00000000}},	//   attl, voie_, lmüş,
  { {0x6d4f141f,0x3eac06a5,0x03a50002,0x00000000}},	//   _alca, ødt_, _џико,
  { {0x236500c7,0x6b5200b9,0xfd960121,0x00000000}},	//   milj_, _jæge, ешаю,
  { {0x7d0d1420,0x27e61421,0x65a7013d,0x00000000}},	//   geas, yron_, _műho,
  { {0x6b520146,0xed571001,0xbf9b00ac,0x00000000}},	// [1aa0] _læge, хот_, rwêr,
  { {0x78ad082a,0xdb06013d,0x27e61422,0x00000000}},	//   žavl, _buká, vron_,
  { {0x7d0d1423,0x2d73007d,0x27e61424,0x00000000}},	//   beas, mćen_, wron_,
  { {0x7d0d09ee,0x6d930058,0x27e61425,0x00000000}},	//   ceas, rçac, tron_,
  { {0x58830be6,0x6846000d,0x27e61426,0x00000000}},	//   лыша, энда, uron_,
  { {0x7bc41427,0xf09300b5,0x27e000c3,0x00000000}},	//   mpiu, אנד_, šino_,
  { {0x3872000c,0xd5b10013,0xe1e701fb,0x00000000}},	//   _ţară_, _cú_, _حس_,
  { {0x69dc1428,0x88c50021,0x76a90054,0x00000000}},	//   _ivre, _لتكل, фтів_,
  { {0x8881006a,0xb603003d,0xd7ca0044,0x00000000}},	//   _پیون, āšan, _رواه_,
  { {0xb7d70021,0x7d0d003b,0x41e60454,0x00000000}},	//   _أولا_, zeas, німа,
  { {0xf6290021,0xf7770063,0xc2980054,0x00000000}},	//   _يسمى_, _טעמי_, ькох_,
  { {0x29020137,0x914b012c,0xb5050044,0x00000000}},	//   _ökad_, їчна_, _لظهو,
  { {0x30a7000d,0x7d0d000c,0xe53b0063,0x00000000}},	//   эров, veas, _מתאר,
  { {0x69dc1429,0x4ea7142a,0x23780044,0x00000000}},	//   _ovre, ерба, _تمتد_,
  { {0x7d0d142b,0x3ea5142c,0x831b0063,0x00000000}},	//   teas, ält_, _מוגז,
  { {0x2bb50053,0xdb060061,0x6286011b,0x00000000}},	//   _अंदा, _ruká, řkos,
  { {0x69dc142d,0xe7cf0053,0x7d0d142e,0x00000000}},	// [1ab0] _avre, _सौंप, reas,
  { {0x7d0d142f,0x61e81430,0xfaa5005d,0x00000000}},	//   seas, ordl, نجای,
  { {0x5ee80063,0xdcfd001c,0x7d0d1431,0x00000000}},	//   _אַרְ, _eksā, peas,
  { {0x64c41035,0x20090150,0x63aa0014,0x00000000}},	//   nčič, _kpai_, _lifn,
  { {0x69dc1432,0x399e0080,0xe894045b,0x00000000}},	//   _evre, _růst_, гаць,
  { {0x3f830249,0x7af50022,0xe7580054,0x00000000}},	//   noju_, _uczt, ничі_,
  { {0xc8f5011c,0x26c70384,0xe7360062,0x00000000}},	//   _извъ, rbno_, тещ_,
  { {0xab640058,0x6b4000a5,0x69c51433,0x00000000}},	//   rmüş, _högp, mphe,
  { {0x290f1434,0x3f831435,0x03950330,0x00000000}},	//   mega_, koju_, кроя,
  { {0x290f0b9c,0x628a01e1,0x42250054,0x00000000}},	//   lega_, _byfo, вдов,
  { {0x628a001f,0x7bcf001f,0x2d68005b,0x00000000}},	//   _cyfo, _lwcu, iğer_,
  { {0x290f0198,0x50460138,0x291d0009,0x00000000}},	//   nega_, вемб, ndwa_,
  { {0x30760699,0xc8da0063,0x628e01c8,0x00000000}},	//   тунс, וקרט, ýbor,
  { {0xdf15019d,0x5f060062,0x290f1436,0x00000000}},	//   льсь, ъзга, hega_,
  { {0x290f1437,0x628a001f,0x02190054,0x00000000}},	//   kega_, _gyfo, _ціль_,
  { {0x290f1312,0x2d680058,0x78ad00c2,0x00000000}},	//   jega_, eğer_, žavj,
  { {0x290f0004,0xc4d20e2a,0x8c430076,0x00000000}},	// [1ac0] dega_, יגן_, аете,
  { {0x7bc40078,0x290f004b,0x7fd70041,0x00000000}},	//   rpiu, eega_, _שויס_,
  { {0xe8fa0088,0xa9a6005a,0xab5b00bd,0x00000000}},	//   дле_, вижд, _stüc,
  { {0x290f1438,0x81bc008f,0x48660062,0x00000000}},	//   gega_, lvēc, кълб,
  { {0xd943005e,0xe7b3043e,0x981300de,0x00000000}},	//   јечи, لمند, لبوا,
  { {0xbcfb0080,0x6d931439,0x69d8004a,0x00000000}},	//   _jmén, nçan, áves,
  { {0x6f0301f7,0xceb30063,0x69dc007d,0x00000000}},	//   _önce, סיה_, _uvre,
  { {0x94180121,0x38c8005d,0x15140456,0x00000000}},	//   ежит_, _ساری_, удия,
  { {0xa5070001,0x98a300e2,0xa96702b3,0x00000000}},	//   тења_, _вите, _рита_,
  { {0x5fdc0053,0x926a0002,0xf5390066,0x00000000}},	//   _बिजल, дрма_, ajť_,
  { {0x973c007d,0x3f83143a,0xe737032d,0x00000000}},	//   _nići, voju_, _шеф_,
  { {0xbcfb0164,0x27e908ed,0x3f830022,0x00000000}},	//   _amén, šane_, woju_,
  { {0x3f83143b,0x5064143c,0x10740054,0x00000000}},	//   toju_, атра, илюю,
  { {0x20e3008b,0x3f830078,0x643b0047,0x00000000}},	//   ổi_, uoju_, _קעגנ,
  { {0x7e440001,0xaed405ac,0x291d0022,0x00000000}},	//   ахте, росш, ydwa_,
  { {0xf1a40088,0x6d93017d,0xb0630072,0x00000000}},	//   _крын, açan, ääss,
  { {0x290f143d,0x9da80062,0xdb0700cd,0x00000000}},	// [1ad0] vega_, търа_, ŀlíc,
  { {0x3b54000d,0xdca40001,0x69c510f9,0x00000000}},	//   акур, рађи, tphe,
  { {0x2bdf016a,0x7c2600bd,0x290f143e,0x00000000}},	//   _फटका, _erkr, tega_,
  { {0x4426143f,0xdced007c,0x69c51440,0x00000000}},	//   _oro_, onač, rphe,
  { {0x69c50034,0x290f1441,0x44260072,0x00000000}},	//   sphe, rega_, _nro_,
  { {0x290f1442,0x77840097,0x6d4d1443,0x00000000}},	//   sega_, аліз, lkaa,
  { {0x64460031,0x69d80078,0x7d1d1444,0x00000000}},	//   økin, šver, _kass,
  { {0xdb0d048e,0x44260185,0x6d4d1445,0x00000000}},	//   mpañ, _bro_, nkaa,
  { {0xb465007e,0x7d1d053f,0x6b520014,0x00000000}},	//   دگاه, _mass, _hæga,
  { {0x44261446,0xdced017f,0x7d1d1447,0x00000000}},	//   _dro_, dnač, _lass,
  { {0x6d4d024a,0xe6590021,0x44261448,0x00000000}},	//   kkaa, _ثلاث_, _ero_,
  { {0x6d4d1449,0x4426144a,0x7d1d144b,0x00000000}},	//   jkaa, _fro_, _nass,
  { {0xd9e00161,0x656900fe,0x73e50002,0x00000000}},	//   _पट्ट, mieh, _солз,
  { {0x7d1d00a4,0x6569144c,0x9264005d,0x00000000}},	//   _aass, lieh, ادیم,
  { {0xd3360063,0xb0630019,0x7d1d144d,0x00000000}},	//   _תרצה_, äärs, _bass,
  { {0x6d4d002c,0x8d550002,0x7d1d144e,0x00000000}},	//   gkaa, атуч, _cass,
  { {0x0c260088,0x5f76007e,0x7d1d144f,0x00000000}},	// [1ae0] ыман, _مادر, _dass,
  { {0x656900bd,0xc7b9013d,0x6d4d1450,0x00000000}},	//   hieh, _erők_, akaa,
  { {0xeb970001,0x0e75000d,0x60d61451,0x00000000}},	//   ћих_, _выяў, _keym,
  { {0x3940007a,0x6d931452,0x7d1d0853,0x00000000}},	//   ðis_, nçal, _gass,
  { {0x6f1e03e8,0x48e30878,0xf74600fd,0x00000000}},	//   _kapc, сочв, ледо,
  { {0xe737005a,0x4426017d,0x7791007e,0x00000000}},	//   леч_, _rro_, قیقا,
  { {0xf6e5000d,0x7c241453,0x7d1d1454,0x00000000}},	//   рцін, lvir, _yass,
  { {0x44261455,0x398e004c,0xdb0d0014,0x00000000}},	//   _pro_, kýsi_, lpað,
  { {0x3856005a,0x136a026b,0x7c241456,0x00000000}},	//   _съвс, ешни_, nvir,
  { {0xbcfb03b2,0x07a60138,0xa3e50053,0x00000000}},	//   _amél, _сазн, _फिर_,
  { {0xe1350055,0x65690024,0x22940121,0x00000000}},	//   анны, bieh, риня,
  { {0x6569034d,0x51870079,0xd2570088,0x00000000}},	//   cieh, ѓуна, уць_,
  { {0x64460019,0x44261457,0xa3d4007f,0x00000000}},	//   äkid, _uro_, _толч,
  { {0x2b8f0199,0x7c241458,0x7d1d1459,0x00000000}},	//   rück_, dvir, _sass,
  { {0xadd50001,0x41e6000d,0x6d4d145a,0x00000000}},	//   робљ, _сіла, tkaa,
  { {0x60d6007a,0x7c24007a,0x6d4d00fe,0x00000000}},	//   _geym, fvir, ukaa,
  { {0x6d4d145b,0x7d1d145c,0xdce40130,0x00000000}},	// [1af0] rkaa, _vass, znić,
  { {0x65690199,0x7d1d145d,0xda7b000d,0x00000000}},	//   zieh, _wass, няе_,
  { {0x7d1d145e,0xda15000a,0x6d9300cd,0x00000000}},	//   _tass, рдењ, lçam,
  { {0xdce40045,0x6b9c004d,0x316b0022,0x00000000}},	//   knię, _ehrg, nicz_,
  { {0x6d930bc8,0xdb0d0871,0x69de145f,0x00000000}},	//   nçam, spañ, aspe,
  { {0x6d580006,0x5fbc0047,0xd6a9007e,0x00000000}},	//   _įvai, עצונ, نگام_,
  { {0xf8c903b2,0x65691460,0x05550062,0x00000000}},	//   _créé_, tieh, ития,
  { {0x79a4000a,0x15450076,0x7bdf0516,0x00000000}},	//   _груе, реим, osqu,
  { {0x645b0035,0xdb0f05ab,0x7bdf1461,0x00000000}},	//   uzui, _lucí, nsqu,
  { {0x7bdf0732,0x33650b3f,0x645b006f,0x00000000}},	//   isqu, рвог, rzui,
  { {0x291f0019,0x7d041462,0x7c241463,0x00000000}},	//   _kaua_, yfis, zvir,
  { {0xc4f80021,0xdb0f00dd,0x216a1464,0x00000000}},	//   _معها_, _jucâ, тими_,
  { {0xb4c30394,0x6d93005b,0x68e40025,0x00000000}},	//   ्री_, rçal, óidi,
  { {0x2d8b0080,0x64460072,0xab5b004d,0x00000000}},	//   _akce_, äkie, _stün,
  { {0x6d930268,0x7bdf048c,0x60d60026,0x00000000}},	//   pçal, esqu, _teym,
  { {0x7c2400eb,0x27e001b3,0x69de1465,0x00000000}},	//   tvir, šini_, vspe,
  { {0x7d040026,0x6b660002,0x3ab6005e,0x00000000}},	// [1b00] rfis, акаа, аљет,
  { {0x69de1466,0x9e660071,0xd00f007e,0x00000000}},	//   tspe, _ввод, _کلی_,
  { {0x399c0025,0x20020019,0x2be20053,0x00000000}},	//   híse_, ltki_, _पिका,
  { {0x6d43000c,0x929a0063,0x69de1467,0x00000000}},	//   _înap, דיעת, rspe,
  { {0x27e00025,0xdb0f003b,0x69de1468,0x00000000}},	//   éin_, _ducâ, sspe,
  { {0x35e60001,0x69de0137,0xbf360047,0x00000000}},	//   ацив, pspe, שאַץ_,
  { {0x09e30095,0xe9d70062,0x65c3007b,0x00000000}},	//   _морн, _вкс_, обја,
  { {0x27e9003d,0xa5340459,0x399c0025,0x00000000}},	//   šana_, снич, físe_,
  { {0xc955000d,0x93460021,0xa98b0063,0x00000000}},	//   _утры, لخدم, _יָמִ,
  { {0x316b0976,0x9f4b004c,0xe7630330,0x00000000}},	//   wicz_, tucí_, _двуп,
  { {0x394400ac,0x236b0066,0x8ab71469,0x00000000}},	//   _koms_, _žijú_, יליג_,
  { {0x26dc146a,0x7bc60d83,0x39440078,0x00000000}},	//   lavo_, _otku, _joms_,
  { {0xb4d20053,0x64a605c5,0x3944146b,0x00000000}},	//   वरी_, _тада, _moms_,
  { {0x6d930555,0x26dc146c,0xe72e0085,0x00000000}},	//   rçam, navo_, зеi_,
  { {0xc1790006,0x7bc60b4f,0x539b0063,0x00000000}},	//   urės_, _atku, _שיוו,
  { {0x39440bbd,0xac1901d5,0x06570063,0x00000000}},	//   _noms_, лобу_, בילך_,
  { {0x7bdf146d,0x26dc146e,0x4bd80044,0x00000000}},	// [1b10] usqu, kavo_, لبلد_,
  { {0x7bdf03b2,0x26dc146f,0x68fb1470,0x00000000}},	//   rsqu, javo_, _scud,
  { {0x26dc0006,0x49a70141,0x6f150331,0x00000000}},	//   davo_, ајда, mezc,
  { {0x8c4801f7,0x58d90054,0xdb0e109c,0x00000000}},	//   _bağı, уддя_, _libè,
  { {0xdc3500b7,0xd7fb000d,0x9be40054,0x00000000}},	//   _האָט_, туе_, _мірк,
  { {0x8c4801f7,0x6f15006d,0x26dc0006,0x00000000}},	//   _dağı, nezc, gavo_,
  { {0x6b5200b9,0xcf580063,0x60dd1471,0x00000000}},	//   _mægl, שבות_, kasm,
  { {0x74150032,0x5e780063,0x20020022,0x00000000}},	//   موعا, יתון_, ytki_,
  { {0x69c7017f,0xb345017d,0x21201472,0x00000000}},	//   _htje, _noçã, _raih_,
  { {0x43740086,0x26dc0290,0xda0e0053,0x00000000}},	//   жуют, cavo_, _सहमत_,
  { {0xe6950032,0x6f15006d,0x399c0139,0x00000000}},	//   _الاد, dezc, síse_,
  { {0xf65201f9,0x8c48005b,0x60dd1473,0x00000000}},	//   _מצב_, _yağı, gasm,
  { {0x98790047,0x657e013d,0xf48702d8,0x00000000}},	//   ראָט, éphe, _тужн,
  { {0x200213d7,0x69c7007d,0x8f760054,0x00000000}},	//   rtki_, _otje, сумі,
  { {0x67211474,0x6b6f0078,0x60dd0150,0x00000000}},	//   _malj, _mėgė, basm,
  { {0x26dc146f,0xc2120063,0x5f76005d,0x00000000}},	//   zavo_, _זהה_, _گابر,
  { {0x0ab60021,0x39441475,0xdca30054,0x00000000}},	// [1b20] محاد, _roms_, зати,
  { {0xb05b01e3,0xef1a0138,0x39440162,0x00000000}},	//   rbät, _смо_, _soms_,
  { {0x26dc0006,0x8c480058,0x72da0041,0x00000000}},	//   vavo_, _sağı, רקעג,
  { {0xb4c3024c,0x69c31476,0xd910005d,0x00000000}},	//   ्रो_, ínea, بیر_,
  { {0xdb0e0ec6,0x26dc1477,0x81bc008f,0x00000000}},	//   _libé, tavo_, evēl,
  { {0x66e30001,0x6d461478,0xa09b00ff,0x00000000}},	//   поља, _hoka, ניסט,
  { {0x67210add,0x8626000d,0x6d461479,0x00000000}},	//   _dalj, сьле, _koka,
  { {0x6d46024a,0x6723082a,0xdb0e00cd,0x00000000}},	//   _joka, adnj, _sibè,
  { {0x6d460006,0x3f8a007d,0x26dc147a,0x00000000}},	//   _moka, kobu_, pavo_,
  { {0x8c1b014e,0x69c103b2,0x6d46147b,0x00000000}},	//   נויי, _élec, _loka,
  { {0x6d4600e8,0x6d5a001c,0xdd210078,0x00000000}},	//   _ooka, ītaj, _rįžk,
  { {0x6721074f,0x6d46147c,0x27e0147d,0x00000000}},	//   _zalj, _noka, šinu_,
  { {0x60dd147e,0x7d16005b,0xc058013c,0x00000000}},	//   rasm, deys, бір_,
  { {0x93fb0063,0x60dd147f,0xc0580454,0x00000000}},	//   _עלוי, sasm, сію_,
  { {0x6f1502dd,0x6d461480,0xde580054,0x00000000}},	//   rezc, _boka, барі_,
  { {0x2b940989,0x2d980044,0x88bd056c,0x00000000}},	//   bäck_, مَّد_, _maśc,
  { {0x81bc003d,0xc1740063,0x6d9302a7,0x00000000}},	// [1b30] zvēl, _מחק_, nçai,
  { {0x8aa70699,0x6b520014,0x1aa7005e,0x00000000}},	//   бред, _hægj, бјег,
  { {0x83fd013d,0xc8b50766,0xdb26005d,0x00000000}},	//   mzőe, ослы, تولی,
  { {0x75220024,0x6dbc007d,0x67211481,0x00000000}},	//   _naoz, _očaj, _salj,
  { {0x67210aba,0xf7450121,0xbcfb0139,0x00000000}},	//   _palj, жело, _nméi,
  { {0x7bcd1482,0x27e91483,0x81bc008f,0x00000000}},	//   mpau, šano_, tvēl,
  { {0x69c7017f,0x6723017f,0x67211484,0x00000000}},	//   _utje, rdnj, _valj,
  { {0x67210089,0x6b520014,0x2d680075,0x00000000}},	//   _walj, _nægj, vşek_,
  { {0xe3b61485,0x27e00027,0x6b4000ea,0x00000000}},	//   обы_, áint_, _rögz,
  { {0x98ad0024,0xd6d80002,0x798b1486,0x00000000}},	//   _hneď_, _гтц_, logw,
  { {0x81bc008f,0x4427007e,0x6dbc00a8,0x00000000}},	//   lvēj, _گراف, _ečaj,
  { {0x798b002b,0xe435007e,0x75221098,0x00000000}},	//   nogw, _وفاد, _gaoz,
  { {0x6d461487,0xbf9b017d,0x7d1600fe,0x00000000}},	//   _roka, rtên, veys,
  { {0xbf9b0016,0x83fd00ea,0x20ea008b,0x00000000}},	//   stên, rződ, ời_,
  { {0x7d16024a,0x6d461488,0x83fd013d,0x00000000}},	//   teys, _poka, sződ,
  { {0xb05b0137,0x2b94004d,0x3f8a1026,0x00000000}},	//   rbär, päck_, sobu_,
  { {0xed57000a,0x7bcd00a4,0x0b461489,0x00000000}},	// [1b40] цот_, gpau, онан,
  { {0x6d460022,0x68e90058,0x7c2b0046,0x00000000}},	//   _woka, _aded, ægra,
  { {0x32050037,0x6d46148a,0x7bcd00fe,0x00000000}},	//   ntly_, _toka, apau,
  { {0xc27a0047,0x6d460072,0x00000000,0x00000000}},	//   ברעי, _uoka,   ,
  { {0x6dbc0024,0x68e9001f,0x57a6036a,0x00000000}},	//   _očak, _dded, ошка,
  { {0xe3a70021,0x05ea148b,0x68e9148c,0x00000000}},	//   _زر_, афии_, _eded,
  { {0xd6d9148d,0xd5b70055,0xda0e0053,0x00000000}},	//   сті_, осы_, _सहित_,
  { {0x7c29148e,0xceb3009a,0xe5a301ce,0x00000000}},	//   _šeri, ויו_, мији,
  { {0x8d5b0047,0x320500e5,0x83fd013d,0x00000000}},	//   יכקי, etly_, ezőb,
  { {0x46a60088,0x6d930003,0xc7b900ea,0x00000000}},	//   _дазв, rçai, _erős_,
  { {0x2b94004d,0x7bcd008f,0xd377000d,0x00000000}},	//   räch_, zpau, ўчы_,
  { {0x81bc003d,0xdbd20058,0xa2ae0042,0x00000000}},	//   lvēk, _güçt, ीशब्,
  { {0x32050034,0x00000000,0x00000000,0x00000000}},	//   atly_,   ,   ,
  { {0xdefb0088,0x6d930858,0x389b0047,0x00000000}},	//   шым_, nçav, ייכנ,
  { {0x32050037,0xd2500032,0x6d580078,0x00000000}},	//   ctly_, _سنة_, _įvar,
  { {0x6ecb0161,0x5cb9000d,0xd1310044,0x00000000}},	//   _त्रु, слаў_, _أمة_,
  { {0x4c940076,0x351b0063,0x0cab148f,0x00000000}},	// [1b50] дитс, סומנ, ртви_,
  { {0x7f19007e,0x7bcd1490,0x69c30516,0x00000000}},	//   _ايدز_, rpau, íneo,
  { {0x7bcd0812,0x99870080,0xdb0e00ea,0x00000000}},	//   spau, ínů_, óján,
  { {0x7bcd00fe,0x58d40054,0x28f80054,0x00000000}},	//   ppau, доцт, жець_,
  { {0xdd3a0063,0x5d3a0063,0x3d3a0063,0x00000000}},	//   _הערכ, _התרא, _הגרס,
  { {0x9f530003,0x70b70053,0x3205004c,0x00000000}},	//   écès_, ःशुल, ytly_,
  { {0x644601a9,0x00000000,0x00000000,0x00000000}},	//   äkin,   ,   ,
  { {0x6d93017d,0xea000013,0xab5b0244,0x00000000}},	//   açav, _hiếp_, _stüh,
  { {0xf3f10021,0x657e00f4,0xea000013,0x00000000}},	//   رأة_, épha, _kiếp_,
  { {0x6d5a001c,0xdce40058,0xe7330044,0x00000000}},	//   ītai, kniğ, _تصر_,
  { {0x672e0046,0x83640044,0x3d0c0082,0x00000000}},	//   _óbja, بديل, ड्डे_,
  { {0x32050034,0xa5c60026,0xd24e0021,0x00000000}},	//   rtly_, slóð, انَ_,
  { {0x3205033c,0x9f4201c2,0x40960085,0x00000000}},	//   stly_, lské_, ярот,
  { {0x320500e5,0x657b004b,0x80cc0042,0x00000000}},	//   ptly_, lnuh, _थ्रे,
  { {0x6da61491,0x9f420114,0xd24e007e,0x00000000}},	//   зива, nské_, _منو_,
  { {0xf8b9008b,0xc6920047,0x3cf60053,0x00000000}},	//   _ngũ_, גאל_, इलें_,
  { {0x27e91253,0x657b00a4,0xf3f9003b,0x00000000}},	// [1b60] šanj_, inuh, nuţ_,
  { {0x8b230076,0x8b260088,0x0c79000d,0x00000000}},	//   ндуе, ядзе, істы_,
  { {0xdebb0063,0x2d9e0813,0x9f420114,0x00000000}},	//   _למיל, ïtes_, jské_,
  { {0x442f1492,0x9f420114,0xf9690086,0x00000000}},	//   _org_, dské_, орій_,
  { {0x1818007e,0x9f42004c,0x28cb0042,0x00000000}},	//   تراک_, eské_, ाड़ि,
  { {0xbb4a0032,0x7bcb1493,0x38330085,0x00000000}},	//   _الآن_, ígue, энір,
  { {0x6b520026,0x6d931494,0x442f1495,0x00000000}},	//   _nægi, rçav, _arg_,
  { {0xa824007e,0x6d441496,0xd90d007e,0x00000000}},	//   _يکشن, njia, _نیم_,
  { {0x9f591497,0x6d441498,0xdc3a0054,0x00000000}},	//   ltså_, ijia, ицiї_,
  { {0xdb1d017d,0x32541499,0x442f149a,0x00000000}},	//   _ausê, двор, _drg_,
  { {0x442f0173,0x27e6149b,0xdb21013d,0x00000000}},	//   _erg_, lson_, ötés,
  { {0x6d93149c,0x463b0047,0x3cf60042,0x00000000}},	//   nçat, _לעבע, इलों_,
  { {0xdb0e0025,0x9054000d,0xdb050139,0x00000000}},	//   _aibí, евяц, smhé,
  { {0xd370007e,0x27e60269,0xbf9b0003,0x00000000}},	//   _جهت_, ison_, ptêm,
  { {0xdd95000d,0x26de149d,0x639b009a,0x00000000}},	//   давы, _meto_, _הסגנ,
  { {0x5d990088,0x26de08ea,0xebd90062,0x00000000}},	//   ікаў_, _leto_, ждаш_,
  { {0x7bc00003,0x68e20078,0x9f42004c,0x00000000}},	// [1b70] _émul, daod, zské_,
  { {0x6d56053b,0x7ac4149e,0x32130051,0x00000000}},	//   akya, есце, łbyś_,
  { {0x98bf0529,0x61fa149f,0x25a9017c,0x00000000}},	//   _nouă_, nutl, ňali_,
  { {0x1a68007e,0xdb06004d,0x9f420114,0x00000000}},	//   سیقی_, _zukü, vské_,
  { {0xea00001b,0x7b0200fe,0x7d0d14a0,0x00000000}},	//   _tiếp_, äytö, mfas,
  { {0x7c2d14a1,0x9f420114,0x26de01f4,0x00000000}},	//   mvar, tské_, _ceto_,
  { {0x7c2d14a2,0x61fa004b,0xa3df0053,0x00000000}},	//   lvar, jutl, धीन_,
  { {0x98bf0529,0x53c90184,0x9f420114,0x00000000}},	//   _două_, огим_, rské_,
  { {0xb4bd016a,0xbcfb00ea,0x61fa004d,0x00000000}},	//   _आली_, _elég, eutl,
  { {0x9f420080,0xdb1d0137,0xa774000d,0x00000000}},	//   pské_, _utsä, _злуч,
  { {0x7d0d08a5,0x6d5d005b,0x7c2d004b,0x00000000}},	//   kfas, _olsa, hvar,
  { {0x442f082a,0x65600025,0x2d680058,0x00000000}},	//   _trg_, chmh, nşet_,
  { {0x995c0124,0xdb0e0066,0xcfaa009e,0x00000000}},	//   níš_, _sibí, قاسم_,
  { {0x61fa1472,0x7c2d14a3,0x6d5d14a4,0x00000000}},	//   butl, dvar, _alsa,
  { {0x7d0d00bd,0xe607007e,0x7c2d14a5,0x00000000}},	//   ffas, خش_, evar,
  { {0x78bb0035,0xf8a5007e,0x752914a6,0x00000000}},	//   _nguv, _مک_, ndez,
  { {0x9f520026,0x7529004d,0x7c2d14a7,0x00000000}},	// [1b80] ðbót_, idez, gvar,
  { {0xeb9f00d1,0x7d0d0035,0x0aea0054,0x00000000}},	//   _spør_, afas, ідей_,
  { {0x2fc00025,0x26de14a8,0x6f1c14a9,0x00000000}},	//   _huig_, _reto_, merc,
  { {0x442d0117,0x26de14aa,0x98a000c2,0x00000000}},	//   kve_, _seto_, žič_,
  { {0x510d0047,0x6d930110,0x752901f4,0x00000000}},	//   מהאַ, rçat, ddez,
  { {0x64460019,0x61fa005b,0x442d14ab,0x00000000}},	//   äkim, yutl, dve_,
  { {0x27e614ac,0x442d14ad,0x657e0003,0x00000000}},	//   sson_, eve_, épho,
  { {0x6f1c14ae,0x442d14af,0x27e614b0,0x00000000}},	//   herc, fve_, pson_,
  { {0xea00008b,0x26de0827,0xa8030062,0x00000000}},	//   _khắp_, _teto_, _изтл,
  { {0x6d9314b1,0x6f1c006d,0x61fa0089,0x00000000}},	//   nçar, jerc, tutl,
  { {0x7d0d01f7,0x442d14b2,0xf74306b4,0x00000000}},	//   yfas, ave_, _шефо,
  { {0x2fc000ac,0xdb1d0003,0x7c2d0078,0x00000000}},	//   _buig_, _eusè, yvar,
  { {0x61fa05e7,0x386614b3,0x232a14b4,0x00000000}},	//   sutl, nzor_, _моди_,
  { {0xcddb0001,0x68e00150,0x69c300ea,0x00000000}},	//   жња_, _lemd, ínek,
  { {0x672814b5,0x6e940e51,0x42fb0063,0x00000000}},	//   _madj, виру, _והוס,
  { {0x672800c3,0x7c2d14b6,0xbcfb14b7,0x00000000}},	//   _ladj, tvar, _amér,
  { {0x7d0d00bd,0x25a60025,0x7c2d14b8,0x00000000}},	// [1b90] rfas, _mhol_, uvar,
  { {0x6f1c14b9,0x672814ba,0x3866082a,0x00000000}},	//   cerc, _nadj, dzor_,
  { {0xfe350047,0x442d14bb,0x6b520014,0x00000000}},	//   _װאָך_, zve_, _nægu,
  { {0xdb1d0164,0x6d9314bc,0x7c2d069f,0x00000000}},	//   _musé, rças, pvar,
  { {0x27e914bd,0xe73914be,0x69dc004d,0x00000000}},	//   éan_, зел_, _ewre,
  { {0x25a6000f,0x9f590164,0xd8220121,0x00000000}},	//   _ahol_, fusé_, удши,
  { {0xe611006a,0xdb050025,0x69dc001f,0x00000000}},	//   اشت_, nmhí, _gwre,
  { {0x442d14bf,0x94250581,0x6f1c14c0,0x00000000}},	//   tve_, емие, zerc,
  { {0x442d03b2,0xdb0e00ea,0x752900ea,0x00000000}},	//   uve_, _hibá, rdez,
  { {0x6298021f,0x291d0009,0x7ae501f7,0x00000000}},	//   _byvo, lewa_, naht,
  { {0x9f590003,0x442d08cf,0x63b814c1,0x00000000}},	//   cusé_, sve_, _divn,
  { {0x2fc002c3,0x291d0dde,0x1a160041,0x00000000}},	//   _puig_, newa_, ײַטש_,
  { {0x394d14c2,0x25ad14c3,0xdbd7021e,0x00000000}},	//   _moes_, mmel_, _jäät,
  { {0x7ae5003e,0x291d0035,0xdb1d0003,0x00000000}},	//   jaht, hewa_, _fusé,
  { {0x291d0035,0x6b5200b9,0xdbd7004b,0x00000000}},	//   kewa_, _mægt, _läät,
  { {0x6f1c14c4,0xa0a60085,0x291d0022,0x00000000}},	//   serc, _пайд, jewa_,
  { {0x68e00006,0xdde3001c,0x6f1c14c5,0x00000000}},	// [1ba0] _remd, ērša, perc,
  { {0x6b520146,0xe625001b,0x395f11d0,0x00000000}},	//   _nægt, _đông_, _alus_,
  { {0xfce614c6,0x68e000f3,0x4ae10053,0x00000000}},	//   _поно, _pemd, _फ़रव,
  { {0xab5b00bd,0x7077007e,0x672814c7,0x00000000}},	//   _stüt, _آمیز_, _sadj,
  { {0x394d04bf,0x672814c8,0xea000013,0x00000000}},	//   _does_, _padj, _thắp_,
  { {0x2d800efa,0x395f0019,0x7c26034a,0x00000000}},	//   lnie_, _elus_, _iskr,
  { {0x69ce0c4a,0x63b80137,0x56930193,0x00000000}},	//   _utbe, _rivn, лашт,
  { {0x291d0397,0x394d00f6,0x2d8014c9,0x00000000}},	//   cewa_, _goes_, nnie_,
  { {0x672814ca,0x63b814cb,0x2d8014cc,0x00000000}},	//   _tadj, _pivn, inie_,
  { {0x21290035,0xd62a06da,0x7c3b1358,0x00000000}},	//   _saah_, _нозе_, _áure,
  { {0x7d0601e3,0xd0d5005a,0x6fa70053,0x00000000}},	//   _ocks, конъ, _गठबं,
  { {0xea00001b,0x2d800051,0x25d9007e,0x00000000}},	//   _nhập_, jnie_, _آهنگ_,
  { {0x2d800045,0xe5a314cd,0xbfab0085,0x00000000}},	//   dnie_, _сици, зтве_,
  { {0x2d800045,0x291d14ce,0xab64005b,0x00000000}},	//   enie_, zewa_, nlüğ,
  { {0xbe8814cf,0x6b520014,0x6e950054,0x00000000}},	//   есте_, _lægs, тиву,
  { {0x5eb40076,0x2d8014d0,0xe29b0063,0x00000000}},	//   уйст, gnie_, _משור,
  { {0x7ae50019,0xacf8000d,0xab640058,0x00000000}},	// [1bb0] taht, энту_, klüğ,
  { {0x7c2600b9,0x2d800051,0x200c003b,0x00000000}},	//   _dskr, anie_, ădit_,
  { {0x2d800051,0x395f04bc,0xdbd700fe,0x00000000}},	//   bnie_, _plus_, _säät,
  { {0xdbd7024a,0x2d800045,0xd8790032,0x00000000}},	//   _päät, cnie_, ومات_,
  { {0x7ae5024a,0xbcfb0942,0xd705030b,0x00000000}},	//   paht, _eléc, взли,
  { {0xbcfb0003,0x291d14d1,0x23a20014,0x00000000}},	//   _fléc, sewa_, yðja_,
  { {0x291d0009,0x8698005a,0x6b5200b9,0x00000000}},	//   pewa_, нтът_, _vægt,
  { {0x1da70053,0xdb08013d,0x9f420066,0x00000000}},	//   _कीमत, ülöt, vskí_,
  { {0x42d5000d,0x442601db,0xe4c80049,0x00000000}},	//   кіну, _cso_, ربين_,
  { {0x6b520026,0x9874000d,0x6d4f14d2,0x00000000}},	//   _hægr, _слуц, _loca,
  { {0x36d40055,0x2d800045,0x442614d3,0x00000000}},	//   _сохр, ynie_, _eso_,
  { {0x27e9003d,0x27ed14d4,0x29020137,0x00000000}},	//   šanu_, _kven_, _ökat_,
  { {0xd24e007e,0x25fd0053,0x2d9200a1,0x00000000}},	//   منی_, रूरी_, voye_,
  { {0x6b520026,0x2d800886,0x3ebe00d1,0x00000000}},	//   _lægr, wnie_, øtt_,
  { {0x2d800efa,0xdee308b9,0x6d4f0e0f,0x00000000}},	//   tnie_, роси, _boca,
  { {0x27ed08dc,0x6dbc14d5,0xee370062,0x00000000}},	//   _oven_, _sčas, ънс_,
  { {0x752b013d,0x2d8014d6,0x9cb30044,0x00000000}},	// [1bc0] _magz, rnie_, لمفت,
  { {0xab5b00bd,0x2ca70002,0x998d085a,0x00000000}},	//   _stür, ткуп_, _češ_,
  { {0x6d4f0027,0xeb970138,0xea00008b,0x00000000}},	//   _foca, њих_, _thập_,
  { {0x81bc001c,0xb8f30044,0xba1714d7,0x00000000}},	//   ovēr, لكمب, ضيها_,
  { {0xf74601aa,0x7c2614d8,0x4c830062,0x00000000}},	//   кедо, _uskr, _вляв,
  { {0x7bd60009,0x7d0414d9,0x00000000,0x00000000}},	//   mpyu, lgis,   ,
  { {0x27ed14da,0xab64005b,0x7c24004d,0x00000000}},	//   _even_, rlüğ, lwir,
  { {0xa507005e,0x6d4f01a8,0x83fd013d,0x00000000}},	//   већа_, _xoca, mzőj,
  { {0x7c2400bd,0x7d041013,0x4426008d,0x00000000}},	//   nwir, igis, _qso_,
  { {0x442600c3,0xdb050025,0xa263008b,0x00000000}},	//   _vso_, omhá, _trố,
  { {0xa266005a,0x81bc001c,0x79820051,0x00000000}},	//   тъпл, evēr, onow,
  { {0x92570076,0xd5e90021,0x427314db,0x00000000}},	//   тают_, _أعلن_, ргюс,
  { {0x442614dc,0x6d4f14dd,0x76450072,0x00000000}},	//   _uso_, _roca, ähyv,
  { {0x64a3005e,0xc7b40047,0x7520013d,0x00000000}},	//   _тача, רבֿ_, lemz,
  { {0x79820034,0x6d4f14de,0x4424001f,0x00000000}},	//   know, _poca, lwm_,
  { {0x2d550146,0x79820051,0x9f59004a,0x00000000}},	//   _nået_, jnow, musí_,
  { {0x81bd008f,0x5b150142,0x31790022,0x00000000}},	// [1bd0] svēs, лмат, misz_,
  { {0x765800fe,0xf0e30053,0xd37814df,0x00000000}},	//   kyvy, _ख़ुद_, nić_,
  { {0xdb050027,0xfdb907da,0x6d4f00c5,0x00000000}},	//   gmhá, _площ_, _toca,
  { {0x79820051,0x317914e0,0xbcfb0003,0x00000000}},	//   gnow, nisz_, _fléa,
  { {0xbcfb0025,0x9f420114,0xd378007d,0x00000000}},	//   _gléa, lská_, kić_,
  { {0xd378007d,0x9f59004c,0x628a14e1,0x00000000}},	//   jić_, kusí_, _oxfo,
  { {0x2d550146,0xd378017f,0x9f42004a,0x00000000}},	//   _fået_, dić_, nská_,
  { {0x2d550146,0xdb1d0512,0xc3d90086,0x00000000}},	//   _gået_, _musí, ньої_,
  { {0x5435006a,0xd37814d8,0xe705007e,0x00000000}},	//   اربر, fić_, _مسای,
  { {0x290200c7,0x399c0026,0xd378007d,0x00000000}},	//   _ökar_, vísi_, gić_,
  { {0x3f83017f,0x9f42027d,0x2fd200ac,0x00000000}},	//   dnju_, jská_, _styg_,
  { {0x44240185,0xf5300032,0x7412007e,0x00000000}},	//   bwm_, _وإن_, جویا,
  { {0x81bd001c,0xa3df0053,0xd37814e2,0x00000000}},	//   tvēr, धीश_, bić_,
  { {0xd3780045,0x40850001,0x2d9914e3,0x00000000}},	//   cić_, руџб, _akse_,
  { {0x81bd001c,0x79820051,0xdb15004c,0x00000000}},	//   rvēr, ynow, _cizí,
  { {0x7c2414e4,0x91060002,0x31790051,0x00000000}},	//   twir, _спие, cisz_,
  { {0x3f83007d,0x8c430092,0x7d0414e5,0x00000000}},	// [1be0] bnju_, бете, rgis,
  { {0x7c2414e6,0x4f260062,0x79820051,0x00000000}},	//   rwir, _сдоб, wnow,
  { {0x7c2414e7,0x200214e8,0xe8fa14e9,0x00000000}},	//   swir, luki_, еле_,
  { {0xd3780045,0x88e6047e,0xea000013,0x00000000}},	//   zić_, ужде, _chạp_,
  { {0xe3c8008b,0x79820051,0x83fd00ea,0x00000000}},	//   _mực_, rnow, szőj,
  { {0xe3c8001b,0xdbd2004b,0x79820022,0x00000000}},	//   _lực_, _müüt, snow,
  { {0xd3780117,0x6b6314ea,0x7bc614eb,0x00000000}},	//   vić_, _укра, _huku,
  { {0x44240185,0xd3780045,0xbf9b00ac,0x00000000}},	//   twm_, wić_, ntêr,
  { {0xd378017f,0xe644005b,0x88860001,0x00000000}},	//   tić_, ılığ, _слаж,
  { {0x31790051,0x4424001f,0x61fa00c2,0x00000000}},	//   wisz_, rwm_, trtl,
  { {0x4424001f,0xd378017f,0x7bc60213,0x00000000}},	//   swm_, rić_, _luku,
  { {0xe3c8008b,0x6ae10053,0x9f42027d,0x00000000}},	//   _cực_, _फ़्र, vská_,
  { {0x69c10164,0xf5930021,0x7bc614ec,0x00000000}},	//   _élev, _النج, _nuku,
  { {0x31790045,0x9f42004a,0x8cba0042,0x00000000}},	//   sisz_, tská_, ्शनो,
  { {0x31790045,0x3f83007d,0xddab0e5e,0x00000000}},	//   pisz_, rnju_, етал_,
  { {0x9f42004a,0xac19005e,0x7bc614ed,0x00000000}},	//   rská_, кобу_, _buku,
  { {0x7bc6014f,0x3f83017f,0xbb75007b,0x00000000}},	// [1bf0] _cuku, pnju_, агај,
  { {0x7bc614ee,0x9f420080,0xbcfb006c,0x00000000}},	//   _duku, pská_, _glén,
  { {0xb60a000d,0x0b8808a8,0x75c3013d,0x00000000}},	//   _жнiв, усти_, _kőze,
  { {0xdc340240,0x2d99004b,0xf1c90013,0x00000000}},	//   _zúča, _ukse_, _hạc_,
  { {0x83fd013d,0xdb1500dd,0x88c80054,0x00000000}},	//   rzők, _vizâ, улів_,
  { {0x6d4d0019,0x38ba0058,0x2b140053,0x00000000}},	//   ljaa, _sürü_, न्दु_,
  { {0x200214ef,0x7bc600bd,0xcf580063,0x00000000}},	//   zuki_, _zuku, רבות_,
  { {0xf1c9001b,0xdb1d017d,0x7ae7004c,0x00000000}},	//   _lạc_, _fusã, _hejt,
  { {0x68eb002c,0xe3c80013,0x6d4d0072,0x00000000}},	//   magd, _rực_, ijaa,
  { {0x466b0086,0x69c70035,0xdced005b,0x00000000}},	//   _прем_, _kuje, ynağ,
  { {0x672306bb,0x38ba01f7,0xdbd20019,0x00000000}},	//   menj, _türü_, _süüt,
  { {0x69c702dd,0xdc340024,0x27e00529,0x00000000}},	//   _muje, _súča, ţine_,
  { {0xe3c8001b,0xf1c9008b,0xfc3f00ea,0x00000000}},	//   _vực_, _bạc_, _szín_,
  { {0x23ab00b9,0x200214f0,0xc484000d,0x00000000}},	//   føje_, ruki_, _улік,
  { {0x7bc613d0,0x2002003e,0xbcfb0003,0x00000000}},	//   _suku, suki_, _cléo,
  { {0x7bc614f1,0x64460137,0x200200a4,0x00000000}},	//   _puku, åkig, puki_,

  { {0x68eb00bb,0x672314f2,0x98a4003b,0x00000000}},	// [1c00] dagd, kenj, _mamă_,
  { {0x6723065f,0xdb590086,0xaae50021,0x00000000}},	//   jenj, лює_, مسمو,
  { {0x67230198,0x66030006,0x78a9017d,0x00000000}},	//   denj, junk, _azev,
  { {0xe3c8001b,0x7bc614f3,0xd7fa000d,0x00000000}},	//   _lựa_, _tuku, вук_,
  { {0x386014f4,0xd8f70054,0x7ae7013d,0x00000000}},	//   áir_, рнії_, _fejt,
  { {0x672314f5,0x61e314f6,0x7ae7007d,0x00000000}},	//   genj, _ownl, _gejt,
  { {0xf62a0086,0xf6e5000d,0x386014f7,0x00000000}},	//   тіли_, сцін, šir_,
  { {0xa6e9001b,0x3f980080,0xdb050137,0x00000000}},	//   _ngươ, horu_, amhä,
  { {0x65880080,0x53460062,0xdb0714f8,0x00000000}},	//   běhn, ахна, _gijó,
  { {0xdb15000f,0x44970076,0x672301b3,0x00000000}},	//   _kizá, рвью_, cenj,
  { {0x69c1000f,0xe3c8008b,0x69c014f9,0x00000000}},	//   _élet, _dựa_, _kime,
  { {0x2c5e001c,0x69c014fa,0x6446078c,0x00000000}},	//   _kādā_, _jime, äkis,
  { {0x938a005a,0x69c014fb,0x60dd004d,0x00000000}},	//   _иска_, _mime, rbsm,
  { {0x69c014fc,0x6d4d006f,0x3f9814fd,0x00000000}},	//   _lime, wjaa, goru_,
  { {0xdef80088,0xdb1d0139,0x9ce70074,0x00000000}},	//   шыя_, _nusá, ицал,
  { {0x67230c61,0x69c014fe,0x7ae7013d,0x00000000}},	//   zenj, _nime, _sejt,
  { {0x2ac70001,0x7ae700b9,0x65a500ea,0x00000000}},	// [1c10] аљев, _pejt, zóho,
  { {0x69c014ff,0xdb15013d,0x6d4d1500,0x00000000}},	//   _aime, _bizá, sjaa,
  { {0xc879003b,0x5e591501,0x67231502,0x00000000}},	//   _ieşi_, _синя_, venj,
  { {0x49980054,0x69c01503,0x66030050,0x00000000}},	//   атія_, _cime, vunk,
  { {0x68eb00bb,0x7ae70024,0x68270076,0x00000000}},	//   ragd, _tejt, рьез,
  { {0x69c700c2,0x21cc004c,0x66031504,0x00000000}},	//   _tuje, _něho_, tunk,
  { {0x67230117,0x68eb002c,0x69d5004d,0x00000000}},	//   renj, pagd, _utze,
  { {0xe6160088,0x99850032,0x1994000d,0x00000000}},	//   ёды_, _الرو, _дася,
  { {0x681a003d,0x44391505,0x67231506,0x00000000}},	//   gādā, ís_, penj,
  { {0x69c00009,0xe7300032,0x660301db,0x00000000}},	//   _zime, _يصل_, punk,
  { {0x69c100ea,0xb0630072,0x64460072,0x00000000}},	//   _éles, ääns, äkir,
  { {0x3f980324,0x35b50e82,0x00000000,0x00000000}},	//   woru_, _убер,   ,
  { {0xbcfb0003,0x2d5c00cd,0xe3c80013,0x00000000}},	//   _clém, _kíev_, _tựa_,
  { {0xdb1c0003,0x20f8008b,0x98a0007d,0x00000000}},	//   _tiré, ọi_, žić_,
  { {0xc879000c,0x59b90053,0x25fd0053,0x00000000}},	//   _deşi_, ेदार, रंटी_,
  { {0x68e90034,0xbf9b0016,0x3f981507,0x00000000}},	//   _need, quên, soru_,
  { {0x7d16001f,0x69c01508,0x3f981261,0x00000000}},	// [1c20] rfys, _rime, poru_,
  { {0x290d000c,0xaf060a91,0x69c01509,0x00000000}},	//   _acea_, _упол, _sime,
  { {0xcf5701f9,0x0f570047,0x3205004c,0x00000000}},	//   _הבית_, _היים_, nuly_,
  { {0xea00008b,0xb4e60053,0xc7c6150a,0x00000000}},	//   _nhấp_, _बजे_, бски,
  { {0x69c00b54,0x68e9059f,0xad37009a,0x00000000}},	//   _vime, _deed, _הנכס_,
  { {0xaa4605bd,0x681a008f,0x32050061,0x00000000}},	//   _легл, vādā, kuly_,
  { {0x1b7b0047,0x65880080,0x6b63026c,0x00000000}},	//   _עטלע, běhl, _экра,
  { {0xea00001b,0x2c5e001c,0x3205004a,0x00000000}},	//   _chấp_, _tādā_, duly_,
  { {0x786605f7,0x23b40044,0x3ce90082,0x00000000}},	//   _указ, يمبس, जरते_,
  { {0x681a003d,0x68e900ca,0x3f72008f,0x00000000}},	//   rādā, _zeed, iņus_,
  { {0x6b9b0047,0xcb9b03c3,0x2d85013d,0x00000000}},	//   רשיד, רסיט, élek_,
  { {0xa0b9005e,0xb0630072,0x91fc008f,0x00000000}},	//   игну_, ääos, dzāt,
  { {0xf8ba0053,0x91ca0042,0xdc1d0023,0x00000000}},	//   ेशिय, _संवै, kņāt,
  { {0x995c0080,0x98a4005f,0xbed401ce,0x00000000}},	//   jíž_, _gamą_, зорј,
  { {0xf1c9001b,0x995c004c,0x15f80063,0x00000000}},	//   _hạn_, díž_, יִּמ,
  { {0x2fc9001f,0x9d150085,0x0dc8150b,0x00000000}},	//   _tuag_, ўдач, сури_,
  { {0x68e9150c,0x636d0139,0x83fd013d,0x00000000}},	// [1c30] _reed, _dúnf, szőv,
  { {0x68e9010e,0x9aab0021,0xf1c90013,0x00000000}},	//   _seed, هداف_, _mạn_,
  { {0x799900ac,0x6aba0014,0x68e9004e,0x00000000}},	//   toww, _útfl, _peed,
  { {0xad2701fb,0xe9190054,0x8ed8005d,0x00000000}},	//   _اردو, роді_, _پذیر_,
  { {0xf1c9008b,0x98a90066,0xb4e60053,0x00000000}},	//   _nạn_, ľaď_, _बड़े_,
  { {0x7c2f150d,0x6d81003d,0x45d51259,0x00000000}},	//   _iscr, rķau, оцит,
  { {0x636d0460,0x68e9150e,0x27e0008f,0x00000000}},	//   _húng, _teed, ģina_,
  { {0xf1c900aa,0xf773006a,0x160b0161,0x00000000}},	//   _bạn_, _کار_, संबर_,
  { {0xf1c90013,0x6d5a0003,0x2d8904aa,0x00000000}},	//   _cạn_, êtai, inae_,
  { {0x43740376,0xf1c90013,0x23b2007e,0x00000000}},	//   зуют, _dạn_, وميس,
  { {0xea00001b,0xe126150f,0x00000000,0x00000000}},	//   _thấp_, омни,   ,
  { {0x26130016,0x24190be6,0xd1c6000d,0x00000000}},	//   mão_, _воды_, ўляе_,
  { {0x26130016,0x7c2f1510,0x9f42017c,0x00000000}},	//   lão_, _nscr, mskú_,
  { {0x2613017d,0x53340121,0x7f75000d,0x00000000}},	//   oão_, _нечт, пусц,
  { {0x3ebe1511,0x26130016,0x3eac06a5,0x00000000}},	//   ätt_, não_, ådt_,
  { {0x9f420066,0xf1c9008d,0x75f0013d,0x00000000}},	//   nskú_, _hạo_, _hózá,
  { {0x636d0025,0x2613017d,0x3cd9000d,0x00000000}},	// [1c40] _cúng, hão_, сьсю_,
  { {0x8a3a0076,0x442f1512,0x8b26000d,0x00000000}},	//   ияет_, _msg_, юдзе,
  { {0x7c2f1513,0x2613017d,0x2d9e0003,0x00000000}},	//   _escr, jão_, îtes_,
  { {0x26130016,0xc879003b,0x9f420066,0x00000000}},	//   dão_, _leşu_, jskú_,
  { {0x6d461514,0x274a0980,0x9f42017c,0x00000000}},	//   _inka, ичко_, dskú_,
  { {0x2613017d,0xdb1d0058,0xf1c9008d,0x00000000}},	//   fão_, _rusç, _nạo_,
  { {0x26130016,0xf1c9008b,0x443d002b,0x00000000}},	//   gão_, _sạn_, _arw_,
  { {0x69de00fe,0x54541515,0xa923005e,0x00000000}},	//   mppe, звит, _одсл,
  { {0xf1c9008b,0x68e21516,0xe947005d,0x00000000}},	//   _bạo_, mbod, _ظرفی,
  { {0x2613017d,0xf1c90013,0x69de1517,0x00000000}},	//   bão_, _vạn_, oppe,
  { {0x26130016,0x8b030080,0xf1c90013,0x00000000}},	//   cão_, _úřed, _dạo_,
  { {0xdb1d00bd,0x69de0d11,0x77a401a8,0x00000000}},	//   _zusä, ippe, dòxi,
  { {0xf5770044,0x50670054,0x1074030b,0x00000000}},	//   _بمنع_, ітма, дляю,
  { {0xf1c9008b,0x83fd00ea,0x533405ce,0x00000000}},	//   _gạo_, rzőt, _хект,
  { {0xcdd80001,0xdb1c0680,0x9e340363,0x00000000}},	//   жњу_, _cirí, мерч,
  { {0xdb1c006d,0xd6570063,0x3169007d,0x00000000}},	//   _dirí, חילת_, _ulaz_,
  { {0x26130016,0x2b5813d5,0x68e2004d,0x00000000}},	// [1c50] zão_, _borc_, dbod,
  { {0x1aa7005e,0xfaa71518,0x6a670021,0x00000000}},	//   ојег, ошен, يطال,
  { {0x26130016,0x539b0063,0x7e2b012c,0x00000000}},	//   xão_, סיבו, _тіпа_,
  { {0xdeb6014e,0x2613017d,0x49c8000d,0x00000000}},	//   _מפתח_, vão_, ілін_,
  { {0x9f420024,0x7d0d092a,0x9cd60063,0x00000000}},	//   vskú_, mgas, _מורה_,
  { {0x261303d9,0x6fdc0047,0x7d0d1519,0x00000000}},	//   tão_, סקוס, lgas,
  { {0x9f420066,0xa9550054,0x68e2013d,0x00000000}},	//   tskú_, _екві, bbod,
  { {0x261303d9,0x7d0d151a,0x7c2d13d8,0x00000000}},	//   rão_, ngas, owar,
  { {0x261303d9,0xbcfb0139,0x9f420066,0x00000000}},	//   são_, _cléi, rskú_,
  { {0x26130016,0x7c2d0089,0x31b60042,0x00000000}},	//   pão_, iwar, ृद्ध,
  { {0x636d0025,0x7c2d0790,0xe299151b,0x00000000}},	//   _rúnd, hwar, сан_,
  { {0x22580504,0x7c2d151c,0x661c004b,0x00000000}},	//   ärka_, kwar, _ärka,
  { {0xf1c9001b,0x645d00bd,0xd788008b,0x00000000}},	//   _tạo_, äsid, iển_,
  { {0x442d0035,0x69de00fe,0xf1c90013,0x00000000}},	//   mwe_, yppe, _hạm_,
  { {0x442d00e8,0xf2d200b5,0x68e204bf,0x00000000}},	//   lwe_, _טעג_, ybod,
  { {0x7d0d002c,0xfc3f0025,0x3cca0001,0x00000000}},	//   ggas, _brí_, слао_,
  { {0xed57000a,0x2b58151d,0x2bba0021,0x00000000}},	// [1c60] чот_, _porc_, مائة_,
  { {0xf1c9008b,0x636d07a8,0x103b0063,0x00000000}},	//   _lạm_, _fúne, _פגיע,
  { {0xa926151e,0xdb1c017d,0x7c2d151f,0x00000000}},	//   здел, _pirâ, awar,
  { {0xc7c60fe2,0x442d0757,0x31b201c2,0x00000000}},	//   пски, kwe_, báze_,
  { {0x68e21520,0x6d3b0063,0x07340054,0x00000000}},	//   rbod, _התכנ, делю,
  { {0xe3a703eb,0x501b0063,0x656b1521,0x00000000}},	//   _سر_, מונו, _algh,
  { {0x442d1522,0xbcfb0139,0x00000000,0x00000000}},	//   ewe_, _sléi,   ,
  { {0xb06300fe,0x6b9e00b9,0x15130076,0x00000000}},	//   ääks, lopg, едъя,
  { {0x69ce1523,0x7ae3013d,0xe3af005d,0x00000000}},	//   _hube, űnte, گري_,
  { {0x27f70080,0x79821524,0x51f80086,0x00000000}},	//   ření_, liow, оною_,
  { {0x29f81525,0x22580121,0x32630062,0x00000000}},	//   nča_, цины_, етяв,
  { {0x79820045,0x7aee00bd,0xe3b8005b,0x00000000}},	//   niow, _lebt, smı_,
  { {0xafe4000d,0x69ce1526,0x43461527,0x00000000}},	//   ноўл, _lube, _недв,
  { {0x4fc41528,0x69dc1529,0x33940044,0x00000000}},	//   есса, _otre, _تلتز,
  { {0xd788001b,0x798b0185,0x69ce006d,0x00000000}},	//   yển_, yngw, _nube,
  { {0x7c2d0886,0x7d0d0089,0xbcfb0331,0x00000000}},	//   twar, ugas, _llév,
  { {0x2d580619,0x7c2d09fe,0x212b152a,0x00000000}},	// [1c70] чить_, uwar, mech_,
  { {0x636d06d5,0x7c2d152b,0x7d0d152c,0x00000000}},	//   _túne, rwar, sgas,
  { {0x20190019,0x442d00ac,0xbdb50001,0x00000000}},	//   ltsi_, zwe_, _обој,
  { {0x798b0035,0xfc3f152d,0x442d00ac,0x00000000}},	//   ungw, _trí_, ywe_,
  { {0xf770006a,0x7e6100c7,0x2019152e,0x00000000}},	//   گان_, älpf, ntsi_,
  { {0x80a00161,0xf09400b5,0x3f83152f,0x00000000}},	//   _ऐडसे, ענס_, niju_,
  { {0x442d00e8,0x644602fb,0x69ce1530,0x00000000}},	//   wwe_, åkin, _gube,
  { {0x79820051,0x3f83007d,0xbcfb013d,0x00000000}},	//   ciow, hiju_, _elév,
  { {0x442d0a53,0x200b017f,0x212b1531,0x00000000}},	//   uwe_, juci_, dech_,
  { {0x442d021f,0x200b1532,0xe1f91533,0x00000000}},	//   rwe_, duci_, ого_,
  { {0xc2c50032,0x290f00c7,0xf1c9001b,0x00000000}},	//   بيدي, ogga_, _tạm_,
  { {0x7bdd0004,0x290f1534,0xdb1c006d,0x00000000}},	//   _otsu, ngga_, _mirá,
  { {0xbf9b0016,0x3f831535,0x7bcf00dd,0x00000000}},	//   rrên, fiju_, _nucu,
  { {0x3f83017f,0x79820022,0x94ba009d,0x00000000}},	//   giju_, ziow, _ומנת,
  { {0x7bcf03b2,0xddd40024,0xada6015a,0x00000000}},	//   _aucu, ňažn, давл,
  { {0x7bcf0529,0x212b004c,0x29f81536,0x00000000}},	//   _bucu, cech_, vča_,
  { {0x3f83017f,0xdb1c00cd,0x672108ea,0x00000000}},	// [1c80] biju_, _pirà, _oblj,
  { {0x3f831537,0x3c19000d,0x69ce1538,0x00000000}},	//   ciju_, яўся_, _pube,
  { {0x7bc7003e,0x7982006d,0x639a0047,0x00000000}},	//   _diju, tiow, קסענ,
  { {0x7aee1539,0x6b9e153a,0xdb1c0331,0x00000000}},	//   _webt, sopg, _dirá,
  { {0x63a8000e,0x7641001f,0x87d7007e,0x00000000}},	//   yldn, _arly, وبوس_,
  { {0x212b03a4,0x7e610137,0x69ce153b,0x00000000}},	//   zech_, älpg, _tube,
  { {0x8b030080,0x79820051,0x69dc153c,0x00000000}},	//   _úřad, piow, _utre,
  { {0x3f831535,0xd82602a9,0xafdb01e1,0x00000000}},	//   ziju_, _одби, lvøe,
  { {0x212b0080,0x7641001f,0xf8b20053,0x00000000}},	//   vech_, _erly, _जरिय,
  { {0xd37003eb,0x212b001f,0x22860002,0x00000000}},	//   اهد_, wech_, думг,
  { {0x3f83017f,0x636400cd,0x9f5900ea,0x00000000}},	//   viju_, _jòni, pusú_,
  { {0x7c260146,0xf6530063,0xd788008b,0x00000000}},	//   _opkr, _בצע_, iểm_,
  { {0x32050034,0x3f830c61,0x55bb0063,0x00000000}},	//   arly_, tiju_, _ומאו,
  { {0xa2940088,0x200b017f,0x20190019,0x00000000}},	//   _палі, ruci_, rtsi_,
  { {0x212b027d,0x3f83153d,0x7bcf153e,0x00000000}},	//   pech_, riju_, _sucu,
  { {0x7bcf0397,0x3f83153f,0x200b00dd,0x00000000}},	//   _pucu, siju_, puci_,
  { {0x9f420114,0x3f831540,0x91b80021,0x00000000}},	// [1c90] lský_, piju_, _تطور_,
  { {0xdb1c1541,0xfbab000d,0x3196008f,0x00000000}},	//   _pirá, ітай_, rāze_,
  { {0x09e40086,0x9f420114,0x2d8500ea,0x00000000}},	//   воєн, nský_, éles_,
  { {0xaadf0394,0x4adf0161,0x3949048e,0x00000000}},	//   _प्रक, _प्रव, ñas_,
  { {0xba74006a,0x636d0025,0x9d1a0047,0x00000000}},	//   _یافت, _lúna, _צושט,
  { {0xbcfb0016,0x6d5d1542,0xbae50044,0x00000000}},	//   _elét, _hosa, _سكري,
  { {0x44261543,0x64420072,0x6d5d1544,0x00000000}},	//   _apo_, _aroi, _kosa,
  { {0x60cd1545,0x673f0022,0x9f4201d1,0x00000000}},	//   _ngam, _żyją, dský_,
  { {0x644203b2,0x44260150,0x3f8101e1,0x00000000}},	//   _croi, _cpo_, _omhu_,
  { {0x64421546,0x60cd014f,0xf1c9008b,0x00000000}},	//   _droi, _agam, _hại_,
  { {0x636d0025,0xdb050025,0x249b0006,0x00000000}},	//   _cúna, lmhó, _žymę_,
  { {0x64420164,0x6d5d1547,0x636d0025,0x00000000}},	//   _froi, _nosa, _dúna,
  { {0xf1c9008b,0x65691548,0x4f960200,0x00000000}},	//   _mại_, mkeh, ерву,
  { {0xf1c900aa,0x25710080,0x99710051,0x00000000}},	//   _lại_, _dále_, nął_,
  { {0xf8a5007e,0x443f1549,0x753b007d,0x00000000}},	//   _چک_, lvu_, oduz,
  { {0xf6520047,0x443f154a,0x753b154b,0x00000000}},	//   נצן_, ovu_, nduz,
  { {0xf1ca008b,0x6d5d154c,0xbcfb006c,0x00000000}},	// [1ca0] _nại_, _dosa, _alés,
  { {0x99710051,0x443f00fe,0x909b0063,0x00000000}},	//   jął_, ivu_, _מספק,
  { {0x9f5f00ea,0x6d5d0331,0x27ed002b,0x00000000}},	//   _órán_, _fosa, _awen_,
  { {0x7e6100c7,0x443f017f,0xf1ca008b,0x00000000}},	//   älpe, kvu_, _bại_,
  { {0x63a1154d,0x18670ae8,0x69c9154e,0x00000000}},	//   koln, наци_, _diee,
  { {0x636400cd,0xf1ca0013,0x78ad004b,0x00000000}},	//   _tòni, _dại_, üava,
  { {0xe5c6042c,0x443f154f,0xdb050139,0x00000000}},	//   нсио, evu_, amhó,
  { {0xdb1c005b,0x64421550,0x9f42004a,0x00000000}},	//   _birç, _proi, vský_,
  { {0xed5e0013,0x70af0053,0xe452002a,0x00000000}},	//   _đột_, _घरेल, اضع_,
  { {0xbf9b0164,0x2c170047,0x9f42004a,0x00000000}},	//   trêm, עקיש_, tský_,
  { {0x443f003d,0x2294130d,0x27ed004d,0x00000000}},	//   avu_, тиня, _zwen_,
  { {0x64421546,0x9f42027d,0x9f400026,0x00000000}},	//   _troi, rský_, _svið_,
  { {0x38661551,0x44260035,0x6d5d1552,0x00000000}},	//   nyor_, _upo_, _rosa,
  { {0xbf9b0164,0x9f420080,0x31b20124,0x00000000}},	//   prêm, pský_, ráza_,
  { {0x6447001c,0x6d5d1553,0x673a00c2,0x00000000}},	//   ājie, _posa, _matj,
  { {0x99710022,0x1cbb00de,0x00000000,0x00000000}},	//   zął_, كاذب_,   ,
  { {0x6d5d0268,0x63860003,0x7e610137,0x00000000}},	// [1cb0] _vosa, _génè, älpb,
  { {0x673a017f,0xbcfb1554,0x65690066,0x00000000}},	//   _natj, _clér, zkeh,
  { {0x69c9003d,0x6d5d0025,0x61fa1555,0x00000000}},	//   _piee, _tosa, nstl,
  { {0xbcfb000f,0x63a11556,0x443f1557,0x00000000}},	//   _elér, zoln, yvu_,
  { {0x673a003b,0xa3c00053,0x7a0a008d,0x00000000}},	//   _batj, ंगा_, ốtph,
  { {0xdb050025,0x21040006,0xd7020062,0x00000000}},	//   rmhó, mčių_, азши,
  { {0x38661558,0x63a101c2,0xab940086,0x00000000}},	//   ayor_, voln, _сирі,
  { {0xf1ca00aa,0x63a10045,0x75d1008f,0x00000000}},	//   _tại_, woln, _jāzi,
  { {0x210400eb,0x656900bd,0xe8940086,0x00000000}},	//   nčių_, rkeh, _бать,
  { {0x21040006,0xf1bf0061,0x65691559,0x00000000}},	//   ičių_, emá_, skeh,
  { {0x7790007e,0x443f021e,0x61fa0d13,0x00000000}},	//   _دیوا, svu_, gstl,
  { {0x63a100ea,0x63860003,0x46560047,0x00000000}},	//   soln, _pénè, _בױען_,
  { {0x63a1155a,0x61e4007d,0x25bf004e,0x00000000}},	//   poln, _čile, mmul_,
  { {0x25a0082a,0x25bf003b,0x25ad155b,0x00000000}},	//   čile_, lmul_, llel_,
  { {0x394d155c,0xe3c8008b,0x21040006,0x00000000}},	//   _ones_, _cựu_, ečių_,
  { {0x395f155d,0x63860003,0x27e0003b,0x00000000}},	//   _nous_, _ténè, ţini_,
  { {0x29d7155e,0x636d017c,0x2104005f,0x00000000}},	// [1cc0] _aça_, _júno, gčių_,
  { {0x7e6100c7,0x09ca0053,0x394d155f,0x00000000}},	//   älpc, िद्य, _anes_,
  { {0xc3320063,0x395f0813,0xb6d90085,0x00000000}},	//   שוב_, _bous_, _эмiг,
  { {0x02b60041,0xa9270054,0x8e97009a,0x00000000}},	//   דלעך_, віше_, _ידיו_,
  { {0x394d0114,0x395f1560,0x29d7017d,0x00000000}},	//   _dnes_, _dous_, _eça_,
  { {0xbf9b03b2,0x18670001,0x25ad1561,0x00000000}},	//   quêt, ђаји_, elel_,
  { {0xd6270001,0x2bd80053,0x6aa300bd,0x00000000}},	//   воје_, _भंडा, ünft,
  { {0x395f0089,0x2ef80206,0x746a0f9f,0x00000000}},	//   _gous_, harf_, дров_,
  { {0x47c60088,0xd0e30042,0x673a1562,0x00000000}},	//   _абав, _क्षण_, _tatj,
  { {0x6376003b,0x27e61563,0xc445005d,0x00000000}},	//   _mâng, mpon_, ایون_,
  { {0xcb13014e,0x6376000c,0x2ef800bd,0x00000000}},	//   בלת_, _lâng, darf_,
  { {0x25a600bb,0x21040078,0xf1bf004c,0x00000000}},	//   _ukol_, yčių_, umá_,
  { {0xf1bf0827,0x69d8004c,0x61fa1564,0x00000000}},	//   rmá_, ívej, sstl,
  { {0x2d920035,0x27e600a4,0x61fa004d,0x00000000}},	//   enye_, ipon_, pstl,
  { {0x3da7000a,0x26060042,0x2571009c,0x00000000}},	//   враб, सूची_, _hála_,
  { {0xc115005e,0x463b0047,0x3ebe0014,0x00000000}},	//   _смиј, ועלע, ýtta_,
  { {0xc05b0086,0x0dc81565,0x21040078,0x00000000}},	// [1cd0] _цій_, тури_, učių_,
  { {0x395f03b2,0x201e000c,0xbb740001,0x00000000}},	//   _sous_, ătit_, агуј,
  { {0x210400eb,0x395f00cd,0xe8050053,0x00000000}},	//   sčių_, _pous_, _रिहा_,
  { {0x200b1566,0x21040078,0x67d51567,0x00000000}},	//   orci_, pčių_, году,
  { {0x395f0c6e,0x6d4f1568,0x637600be,0x00000000}},	//   _vous_, _inca, _gâng,
  { {0xf1ca008b,0x394d001f,0x2d89005f,0x00000000}},	//   _hạt_, _wnes_, liae_,
  { {0x395f03b2,0x6376003b,0x25bf003b,0x00000000}},	//   _tous_, _mând, tmul_,
  { {0x84590079,0x2249017f,0x394d1569,0x00000000}},	//   ерот_, _čak_, _unes_,
  { {0x69940121,0xf1ca0013,0x25bf156a,0x00000000}},	//   _трёх, _mạt_, rmul_,
  { {0x25bf000c,0x69d5005b,0xb8820024,0x00000000}},	//   smul_, _kuze, číto,
  { {0x200b0051,0x9f590331,0xe2850854,0x00000000}},	//   erci_, husó_, улни,
  { {0x9f5e0080,0xdb1d00bd,0xd00a05fb,0x00000000}},	//   čtí_, _ausü, неме_,
  { {0x636400cd,0xe44e047e,0x69d5156b,0x00000000}},	//   _còns, _уж_, _luze,
  { {0x6376156c,0x6d4f156d,0x7af5004c,0x00000000}},	//   _când, _anca, _nezt,
  { {0x27e600c3,0x6376156e,0x3eac00b9,0x00000000}},	//   zpon_, _sâng, ædt_,
  { {0x7e610137,0xcd36005d,0x00000000,0x00000000}},	//   älpa, درآب,   ,
  { {0x2d9200d1,0x1c46000d,0x69d511ad,0x00000000}},	// [1ce0] rnye_, ынам, _auze,
  { {0x6376000c,0x6d4f156f,0x69d51570,0x00000000}},	//   _gând, _enca, _buze,
  { {0xa96a12b9,0x48e60131,0x3f8a0023,0x00000000}},	//   нижа_, гоев, mibu_,
  { {0xfe370063,0x69d51571,0xf1ca0013,0x00000000}},	//   _ערכי_, _duze, _gạt_,
  { {0x776100cd,0xf3f9003b,0x58d70054,0x00000000}},	//   _bolx, byţi_, удія_,
  { {0x321e00fe,0x3f8a0035,0xc7a30f56,0x00000000}},	//   ytty_, nibu_, бичк,
  { {0x27e61572,0x36870062,0xeb970a8f,0x00000000}},	//   spon_, лсън_, _сир_,
  { {0x7bce0974,0x636d0139,0x78b10014,0x00000000}},	//   _hibu, _dúnm, ðkvæ,
  { {0xa3c2016a,0x3494000d,0xb7160021,0x00000000}},	//   ्दल_, рапр, _مباش,
  { {0x3f8a0009,0x69c2006f,0x41e6013c,0x00000000}},	//   jibu_, lmoe, ліма,
  { {0x6376000c,0x6b7b0047,0x200b002b,0x00000000}},	//   _rând, גרינ, wrci_,
  { {0x257800ac,0x7bce1573,0xdb1c017d,0x00000000}},	//   _sélf_, _libu, _cirú,
  { {0x200b0003,0x63760f84,0x7d16002b,0x00000000}},	//   urci_, _pând, dgys,
  { {0x447b00b5,0x84170063,0xf487005d,0x00000000}},	//   _אנדע, _עקוב_, _حامی,
  { {0x6376000c,0x63030021,0x6da50044,0x00000000}},	//   _vând, _طويل, لمسم,
  { {0xfbdf002b,0x7d161574,0x3d0f0042,0x00000000}},	//   _drên_, ggys, िलें_,
  { {0x0fb9005e,0x69d51575,0xf1ca008d,0x00000000}},	// [1cf0] _илић_, _suze, _vạt_,
  { {0x59d90053,0x320c1566,0x76481576,0x00000000}},	//   _बंदर, ordy_, _ordy,
  { {0x7bce0d75,0x5a350257,0x5f74005d,0x00000000}},	//   _dibu, рнет, _داير,
  { {0xe9ab007e,0xd788008b,0xe0df0290,0x00000000}},	//   ردان_, iểu_, ncò_,
  { {0x68f90045,0x69da0164,0x21290150,0x00000000}},	//   rawd, _éten, _mbah_,
  { {0x68f9001f,0x9665055d,0xf7451577,0x00000000}},	//   sawd, икле, реко,
  { {0x7f3c0047,0x870401d5,0x2d9e009c,0x00000000}},	//   געוו, сяче, éteg_,
  { {0x49bb007e,0x24920078,0x05651578,0x00000000}},	//   _سازد_, _žyma_, рвин,
  { {0x320b0051,0x23d40085,0x00000000,0x00000000}},	//   ącym_, йцэр,   ,
  { {0x25a00198,0xb7bd0529,0x42251579,0x00000000}},	//   čila_, _opţi, адов,
  { {0x67250019,0x45d50878,0xe299157a,0x00000000}},	//   õhju, _тоес, тан_,
  { {0x69d80016,0x798b001f,0xa06a05c5,0x00000000}},	//   ívei, nigw, вама_,
  { {0x3f8a0035,0x671c0053,0xdb1c0013,0x00000000}},	//   tibu_, _नामक_, _virú,
  { {0xb4c10053,0x747a009a,0x926500de,0x00000000}},	//   ंधी_, _שנסג, _ندعم,
  { {0x3f8a10ca,0x0fc3019d,0x7bce003e,0x00000000}},	//   ribu_, ійсн, _ribu,
  { {0xe0df0290,0x3f8a0035,0x7bce157b,0x00000000}},	//   ccò_, sibu_, _sibu,
  { {0x3b86000d,0x798b002b,0x9c870124,0x00000000}},	// [1d00] алаг, digw, vočí,
  { {0xfbdf00aa,0xdcf60058,0x6ffb069a,0x00000000}},	//   _trên_, ıcın, _שפיג,
  { {0x69c20162,0xca56018e,0xe8fa157c,0x00000000}},	//   tmoe, штањ, вле_,
  { {0x5ca60141,0xc8ca013a,0xfd1214d7,0x00000000}},	//   _вимб, نوان_, _بجد_,
  { {0xa01b00bd,0x69c2157d,0x7bce157e,0x00000000}},	//   rzög, rmoe, _tibu,
  { {0x6376000c,0x6e3300ea,0xa01b0740,0x00000000}},	//   _mânc, _újbó, szög,
  { {0xd6d90086,0x9c87004a,0xb633005d,0x00000000}},	//   уті_, počí, قعيت,
  { {0x2904017c,0x342602f9,0xe9a30085,0x00000000}},	//   _udma_, афов, _дасп,
  { {0xa3e70001,0xa967157f,0xd49a0094,0x00000000}},	//   адња_, _тита_, ърк_,
  { {0xd6f80063,0xf3660f50,0x3374030b,0x00000000}},	//   _תִּש, ртин, сгор,
  { {0xd0d50062,0x0bb7089e,0x7d06056c,0x00000000}},	//   йонъ, שלים_, _odks,
  { {0x240a0062,0x51f70766,0x672d0130,0x00000000}},	//   _анди_, шнюю_, đaje,
  { {0x63760016,0xe0df0290,0x50641580,0x00000000}},	//   _cânc, rcò_, отра,
  { {0x93fb0063,0x547b0063,0x2578004c,0x00000000}},	//   _ילדי, _שְׁנ, _déle_,
  { {0x63a8010a,0x59a60042,0x03bb009a,0x00000000}},	//   modn, गकार, _שצול,
  { {0x21290397,0x2578013d,0x63a81581,0x00000000}},	//   _ubah_, _féle_, lodn,
  { {0x91bc0063,0x5cb90085,0x8c190044,0x00000000}},	// [1d10] _במהי, улаў_, طيار_,
  { {0x8ae7019d,0x2d8c0164,0xf1ca008d,0x00000000}},	//   ріал, éder_, _hạp_,
  { {0x69da013d,0x83370041,0x2bc81006,0x00000000}},	//   _étel, שאבס_, руто_,
  { {0x63a81582,0x645d0656,0x2bd9005d,0x00000000}},	//   hodn, äsik, _ماسک_,
  { {0x8d5a0063,0x798b002b,0x63a81583,0x00000000}},	//   _עכשי, rigw, kodn,
  { {0xcc3a00b5,0xdc3a00b5,0xf1ca008b,0x00000000}},	//   _געשט, _געשר, _lạp_,
  { {0x798b0035,0x64460026,0xb9e40086,0x00000000}},	//   pigw, ækin, _міти,
  { {0xf1ca008b,0x1e98009a,0xd5e80044,0x00000000}},	//   _nạp_, יכול_, جعون_,
  { {0x79890035,0x26130053,0xe8180044,0x00000000}},	//   _imew, _धमकी_, _نزلت_,
  { {0xf773006a,0xc6a702a9,0x83390121,0x00000000}},	//   _بار_, _креи, учит_,
  { {0x636d1584,0x614602b6,0x81ca0121,0x00000000}},	//   _júni, бена, лгов_,
  { {0x636d0857,0xdb050354,0xf1ca008d,0x00000000}},	//   _múni, llhä, _cạp_,
  { {0x2418000d,0x63a8073c,0x001a0085,0x00000000}},	//   _вочы_, bodn, ыўны_,
  { {0x2bdb0161,0xdee300e2,0x53341585,0x00000000}},	//   _बढ़ा, зори, _мечт,
  { {0x1d0a0d64,0xdb050003,0xdef9000d,0x00000000}},	//   леви_, cohé, шыў_,
  { {0xf1d00235,0xa19300e1,0xed46005e,0x00000000}},	//   _सूचन, _најч, љнап,
  { {0x442f1586,0x645d0072,0xd117009a,0x00000000}},	// [1d20] _jpg_, äsih, _הקפה_,
  { {0xcef6005e,0x636d0014,0x20021587,0x00000000}},	//   _учињ, _búni, mski_,
  { {0x20021588,0x6e46006a,0xc0a9007e,0x00000000}},	//   lski_, _انجم, _مایل_,
  { {0x9f49007a,0xf8fa0021,0x644b1589,0x00000000}},	//   _hvað_, اءات_, _orgi,
  { {0x2002065f,0xbf9b0003,0x9f490014,0x00000000}},	//   nski_, prêt, _kvað_,
  { {0x7c24001c,0x39400078,0x6d44158a,0x00000000}},	//   mtir, žis_, ldia,
  { {0x443d158b,0x644b158c,0x8afb01f9,0x00000000}},	//   _asw_, _argi, _תהלי,
  { {0x25a00198,0x657b002c,0x63a80051,0x00000000}},	//   čilo_, ghuh, wodn,
  { {0x7c24158d,0x6d44001f,0xf1ca0013,0x00000000}},	//   ntir, idia, _rạp_,
  { {0x2002158e,0xc1ea093e,0x68e2158f,0x00000000}},	//   dski_, льме_, lcod,
  { {0x442f00e3,0xdb1c0164,0xe1351485,0x00000000}},	//   _epg_, _chré, онны,
  { {0x68e2102c,0x5a9b0047,0xdb1c0025,0x00000000}},	//   ncod, רשטא, _dhré,
  { {0x6d440c70,0x60e4000d,0x63a80008,0x00000000}},	//   ddia, яцэз, podn,
  { {0x6d441590,0x40340141,0x7c24051f,0x00000000}},	//   edia, џерс, dtir,
  { {0x41e6006a,0xdb1c0027,0xf1ca001b,0x00000000}},	//   _استف, _ghré, _tạp_,
  { {0x7c240026,0x20021591,0xd011002a,0x00000000}},	//   ftir, bski_, _قلب_,
  { {0x68e2006f,0xe5200053,0xa01b013d,0x00000000}},	// [1d30] dcod, _यानि_, szöb,
  { {0x68e20122,0x2474008b,0xda7b000d,0x00000000}},	//   ecod, ìm_, ляе_,
  { {0x7a350032,0x6d441592,0x7c241593,0x00000000}},	//   تفاص, bdia, atir,
  { {0x7bc50139,0xac191594,0xc179005f,0x00000000}},	//   smhu, _кому_, mpės_,
  { {0xc88b0021,0xe9d00021,0xe8f8013c,0x00000000}},	//   دخال_, رغم_, слі_,
  { {0x7afe1595,0x636d1596,0x442f1597,0x00000000}},	//   capt, _túni, _rpg_,
  { {0x24740013,0xb5790054,0x85790121,0x00000000}},	//   èm_, ищих_, исит_,
  { {0x24090795,0x68e20290,0x20020ac3,0x00000000}},	//   ании_, ccod, yski_,
  { {0x75ca0045,0xdb20005b,0x9359018b,0x00000000}},	//   _języ, ütçe, арну_,
  { {0x387200d1,0x6d440066,0x83891598,0x00000000}},	//   øyre_, zdia, рбов_,
  { {0xa1ba1599,0x657b00ac,0xe6950021,0x00000000}},	//   иумф_, phuh, _بلاد,
  { {0x2002055e,0xa4f7007e,0x68fb0003,0x00000000}},	//   tski_, _اکثر_, _jeud,
  { {0x443d00bd,0x8447007e,0x2002159a,0x00000000}},	//   _usw_, _دخال, uski_,
  { {0xf7670032,0xe8df008b,0xdb1c0139,0x00000000}},	//   ذا_, _baịn_, _thré,
  { {0xfc3f048e,0x6449159b,0x2002004e,0x00000000}},	//   _así_, lvei, sski_,
  { {0x75290290,0x2002159c,0x64490078,0x00000000}},	//   nfez, pski_, ovei,
  { {0x6449087a,0xab6610e4,0x6fb60021,0x00000000}},	// [1d40] nvei, овал, _ومعا,
  { {0x2fd7006a,0x6d44159d,0x7c2413b3,0x00000000}},	//   _گوید_, sdia, rtir,
  { {0x7afe159e,0x68e20d13,0x39460121,0x00000000}},	//   rapt, tcod, жнег,
  { {0x7afe159f,0x7c2415a0,0x2d960c59,0x00000000}},	//   sapt, ptir, _фрос,
  { {0x68ed006d,0x68fb15a1,0xade00053,0x00000000}},	//   ñada, _deud, _खंडन_,
  { {0x68e215a2,0xbb560021,0x644915a3,0x00000000}},	//   scod, _بنسب, dvei,
  { {0xd95a0001,0x7afc003b,0x7e7a0047,0x00000000}},	//   _краљ_, _iert, יאַז,
  { {0x7afc15a4,0x3196008f,0xdb21013d,0x00000000}},	//   _hert, bāzi_, ütöt,
  { {0x644900d1,0x7afc15a5,0x3944005f,0x00000000}},	//   gvei, _kert, _iams_,
  { {0x69dc15a6,0xe3b20021,0x7afc15a7,0x00000000}},	//   _kure, برع_, _jert,
  { {0x394604a6,0x64490006,0x7afc15a8,0x00000000}},	//   odos_, avei, _mert,
  { {0x69dc15a9,0xe1ef007e,0x7afc15aa,0x00000000}},	//   _mure, کسی_, _lert,
  { {0x394615ab,0xf8ca0053,0x6281027c,0x00000000}},	//   idos_, िधिय, azlo,
  { {0x25a900b2,0x7afc0ea7,0xdced1333,0x00000000}},	//   čale_, _nert, rkač,
  { {0xccfb0001,0x2e48005a,0x645d00fe,0x00000000}},	//   ића_, оято_, äsiv,
  { {0xc1790078,0x39440023,0xfc3f01c8,0x00000000}},	//   rpės_, _nams_, _psí_,
  { {0x7afc15ac,0xdcef000c,0xef670062,0x00000000}},	// [1d50] _bert, _alcă, _дъно,
  { {0x394600ed,0x201915ad,0x7afc15ae,0x00000000}},	//   edos_, musi_, _cert,
  { {0x6449001c,0xea00008b,0x69dc09ee,0x00000000}},	//   zvei, _đảo_, _cure,
  { {0xe9d80088,0x69dc15af,0x3f910734,0x00000000}},	//   ікі_, _dure, lizu_,
  { {0x7afc15b0,0x8d5a0063,0x394400e5,0x00000000}},	//   _fert, _הכרי, _dams_,
  { {0x69dc0164,0x394604a6,0x37ab00e1,0x00000000}},	//   _fure, ados_, штен_,
  { {0x7c3901f7,0x20190035,0x7bdd0058,0x00000000}},	//   şarı, husi_, _husu,
  { {0x7afc00bd,0x7bdd15b1,0x644915b2,0x00000000}},	//   _zert, _kusu, tvei,
  { {0x7bd50009,0x752915b3,0xb345017d,0x00000000}},	//   _kizu, rfez, _naçã,
  { {0x25710026,0x644915b4,0x201915b5,0x00000000}},	//   _máli_, rvei, dusi_,
  { {0xcb1200b5,0xa91d0006,0x7bdd0089,0x00000000}},	//   עלט_, _amži, _lusu,
  { {0x291d0009,0x24190076,0xb6ba0063,0x00000000}},	//   ngwa_, _годы_, _הצעי,
  { {0x291d0035,0x201915b6,0x62810163,0x00000000}},	//   igwa_, gusi_, szlo,
  { {0x636d0025,0x39460078,0x3f9e004b,0x00000000}},	//   _cúnt, zdos_, õtu_,
  { {0x3ebe0e3f,0x272f01f7,0x20191404,0x00000000}},	//   ått_, mını_, ausi_,
  { {0x201915b7,0x69da0164,0x7afc15b8,0x00000000}},	//   busi_, _étei, _sert,
  { {0x7afc15b9,0xf5390066,0xdca315ba,0x00000000}},	// [1d60] _pert, ieť_, еати,
  { {0x272f005b,0x7bdd017e,0x69dc15bb,0x00000000}},	//   nını_, _dusu, _pure,
  { {0x7afc15bc,0x6edb0063,0x19ba0376,0x00000000}},	//   _vert, _לחיפ, будь_,
  { {0x7ae515bd,0x7afc09f8,0x7bdd003b,0x00000000}},	//   acht, _wert, _fusu,
  { {0x7afc08f0,0x25ad0438,0x7bdd0150,0x00000000}},	//   _tert, doel_, _gusu,
  { {0x4cbb0063,0x6d4615be,0x272f0058,0x00000000}},	//   _לזכו, _haka, jını_,
  { {0x6d4615bf,0x272f005b,0x2019013d,0x00000000}},	//   _kaka, dını_, zusi_,
  { {0x6d4615c0,0x7ec7000f,0x320500ac,0x00000000}},	//   _jaka, lépé, dsly_,
  { {0x6d4615c1,0x272f0058,0xb4c80042,0x00000000}},	//   _maka, fını_, ोखे_,
  { {0x6843011c,0xa87b0063,0x6d4615c2,0x00000000}},	//   _януа, _האמר, _laka,
  { {0x2d92005b,0x25ad00ca,0x0cb90042,0x00000000}},	//   kiye_, boel_, _आर्म,
  { {0x6d4615c3,0x20190c76,0x92c20058,0x00000000}},	//   _naka, tusi_, _ışın,
  { {0x2d92005b,0x272f005b,0x645d0213,0x00000000}},	//   diye_, bını_, äsit,
  { {0x2019058c,0x272f005b,0x08770047,0x00000000}},	//   rusi_, cını_, לעכט_,
  { {0x7bdd15c4,0xe3b8005b,0x2d92005b,0x00000000}},	//   _susu, mlı_, fiye_,
  { {0xf1a40088,0x6d460228,0xd2b70063,0x00000000}},	//   _прын, _caka, _מלות_,
  { {0xea00001b,0x6d4615c5,0x2004004c,0x00000000}},	// [1d70] _đạo_, _daka, ámit_,
  { {0xe3b801f7,0x7ae505e4,0x0bb40376,0x00000000}},	//   nlı_, ucht, ебую,
  { {0x6d4601f7,0x68ed02dd,0x7ae500bd,0x00000000}},	//   _faka, ñado, rcht,
  { {0x644209ff,0x7ae500bd,0xe3b8005b,0x00000000}},	//   _osoi, scht, hlı_,
  { {0xe3b801f7,0x272f005b,0x25ad0229,0x00000000}},	//   klı_, yını_, voel_,
  { {0x6d4615c6,0xe3b80075,0x32050260,0x00000000}},	//   _zaka, jlı_, ysly_,
  { {0x81bd003d,0xda34000d,0x25ad006f,0x00000000}},	//   ttēl, _перы, toel_,
  { {0xd11f0053,0xdb1c0014,0x13e90054,0x00000000}},	//   _भाषण_, _hirð, омий_,
  { {0x272f005b,0x2009001c,0xe3b80058,0x00000000}},	//   tını_, _nvai_, flı_,
  { {0xd3890086,0xe2990001,0xb2f40076,0x00000000}},	//   ійне_, жао_, няющ,
  { {0x272f04ab,0x32050037,0xda7a00b5,0x00000000}},	//   rını_, usly_, ַנשר,
  { {0x272f01f7,0x645d0072,0x81bd008f,0x00000000}},	//   sını_, äsis, ltēj,
  { {0xe3ae0088,0xa01b000f,0x32050034,0x00000000}},	//   _аб_, szön, ssly_,
  { {0xdb1c0025,0x81bd001c,0x753b0657,0x00000000}},	//   _phrí, ntēj, leuz,
  { {0x1d0a000a,0x53320635,0x6d4615c7,0x00000000}},	//   жеби_, _рејт, _paka,
  { {0x9f5900fe,0x24920078,0xed570b69,0x00000000}},	//   essä_, _žymi_, мос_,
  { {0xdb070026,0x2d92005b,0x65660137,0x00000000}},	// [1d80] _skjá, riye_, ökhi,
  { {0x6d4610ca,0x69cb0717,0x2d92005b,0x00000000}},	//   _waka, emge, siye_,
  { {0x2d8015c8,0x753b0122,0x637f0732,0x00000000}},	//   phie_, keuz, _gêne,
  { {0xe3b8005b,0x3ebe0014,0x81bd0023,0x00000000}},	//   zlı_, ýttu_, etēj,
  { {0xe3b8005b,0x7d0415c9,0xd90d007e,0x00000000}},	//   ylı_, mais, صیل_,
  { {0x75220290,0x7d0415ca,0xdc8b0063,0x00000000}},	//   _scoz, lais, _וְלָ,
  { {0x27ed0122,0x68e9001f,0x656b15cb,0x00000000}},	//   _eten_, _ffed, _bogh,
  { {0x7d0415cc,0xc966000d,0x25780003,0x00000000}},	//   nais, _ўвай, _vélo_,
  { {0xe3b8005b,0x87260002,0xdb05011b,0x00000000}},	//   tlı_, _омаж, lohá,
  { {0x656b0025,0x7d0415cd,0x3196008f,0x00000000}},	//   _eogh, hais, kāzs_,
  { {0x7d04024a,0x81bd003d,0x656b0027,0x00000000}},	//   kais, stēm, _fogh,
  { {0x2d9e000f,0x7d040659,0xc5f30063,0x00000000}},	//   étel_, jais, _ידע_,
  { {0x9f590072,0xe3b80058,0x31b9013d,0x00000000}},	//   yssä_, plı_, nézi_,
  { {0x81bd001c,0xc05815ce,0xe28f0043,0x00000000}},	//   otēk, фію_, اذی_,
  { {0xdfd415cf,0x671c016a,0xd904006a,0x00000000}},	//   торы, _नाईक_, _پی_,
  { {0x7d0415d0,0x27440078,0x31b9013d,0x00000000}},	//   gais, lūnė_, kézi_,
  { {0x4c940076,0xfbdf15d1,0x79820150,0x00000000}},	// [1d90] витс, _quê_, dhow,
  { {0x31a4005b,0x1bd50121,0x60c000e7,0x00000000}},	//   mıza_, хозя, ümme,
  { {0xc9150138,0xdb1c007a,0x27ed15d2,0x00000000}},	//   едећ, _virð, _sten_,
  { {0x7d0412f7,0x443f0022,0x28f80054,0x00000000}},	//   cais, ywu_, дець_,
  { {0x656b018d,0x31a401f7,0xa3c30161,0x00000000}},	//   _rogh, nıza_, ्षम_,
  { {0x656b0025,0xf1ca008b,0xdb070093,0x00000000}},	//   _sogh, _dạy_, _skjæ,
  { {0x45d515d3,0x81bd003d,0xbbbd0053,0x00000000}},	//   нцит, rtēj, ्गीक,
  { {0x79820045,0x81bd008f,0x443f0022,0x00000000}},	//   chow, stēj, twu_,
  { {0x27ed0031,0x81bd001c,0x656b01f4,0x00000000}},	//   _uten_, ptēj, _vogh,
  { {0x2d8c0164,0xd70801ce,0x443f056c,0x00000000}},	//   édez_, _онђе_, rwu_,
  { {0x0322000d,0x656b0025,0x68e4007c,0x00000000}},	//   ыдэн, _togh, žide,
  { {0x46380021,0x31a40058,0x63ba0046,0x00000000}},	//   _تأكد_, fıza_, altn,
  { {0x600715d4,0x7bc70072,0x3076005e,0x00000000}},	//   нням_, _ohju, хунс,
  { {0x00000000,0x00000000,0x00000000,0x00000000}},	//     ,   ,   ,
  { {0x6da60121,0xf772009f,0x7d0415d5,0x00000000}},	//   еива, נקל_, tais,
  { {0x7d04017d,0x3f83004b,0x61ee0331,0x00000000}},	//   uais, ahju_, íble,
  { {0xdee60e14,0xdb1e0072,0x7d0415d6,0x00000000}},	// [1da0] _попи, ympä, rais,
  { {0x7d0415d7,0x9b460021,0xdb1c0025,0x00000000}},	//   sais, عناو, _bhrá,
  { {0x61eb0529,0xe9da12ad,0x7e610137,0x00000000}},	//   _înlă, чке_, älpt,
  { {0xfbdf0164,0x307a0047,0x25710014,0x00000000}},	//   _prêt_, ּאַנ, _máls_,
  { {0x75c3013d,0x75e70058,0x63ba00a5,0x00000000}},	//   _főzz, _rıza, yltn,
  { {0x60c40009,0x38cb007e,0xdb1c0025,0x00000000}},	//   _mzim, سانی_, _fhrá,
  { {0xe2870021,0xdb1c0139,0xe60f0044,0x00000000}},	//   _إذ_, _ghrá, مشي_,
  { {0xe5540092,0xd6d9012c,0x99d600de,0x00000000}},	//   ткињ, фті_, _أقرت,
  { {0x60c40009,0x64a30001,0x98a30caa,0x00000000}},	//   _nzim, лаћа, _бите,
  { {0xb8f30053,0x54330021,0x88350085,0x00000000}},	//   हे_, ارير, _шэсц,
  { {0x26de00a4,0x60c415d8,0xf6560054,0x00000000}},	//   _igto_, _azim, _ятаю,
  { {0x546a005a,0xbcfb0003,0x4a9b0047,0x00000000}},	//   _наем_, _inég, לייג,
  { {0xc953014e,0x257100ea,0x74130cac,0x00000000}},	//   אמר_, _vált_, _مونا,
  { {0x25a00198,0xa3c30161,0x60c4001c,0x00000000}},	//   čilu_, ्षण_, _dzim,
  { {0x43770041,0xde580054,0xbdc70363,0x00000000}},	//   _אײגן_, нарі_, ещай,
  { {0x3eba00d1,0xdb23013d,0x315b0044,0x00000000}},	//   _dypt_, őrül, _رجعة_,
  { {0x2ef5011c,0xdb1c0139,0x321e0051,0x00000000}},	// [1db0] _изпр, _shrá, luty_,
  { {0x7e610137,0x200b15d9,0x8aa70571,0x00000000}},	//   älps, msci_, нред,
  { {0x321e03a4,0x314b0063,0xd5df0042,0x00000000}},	//   nuty_, ּתְּ, _पूंज,
  { {0x201915da,0x3978013c,0x62880a10,0x00000000}},	//   orsi_, нсію_, izdo,
  { {0x6d5d15db,0xa09c0041,0x6d4d0046,0x00000000}},	//   _insa, ּיוט, mdaa,
  { {0x6d4d15dc,0xb6590b3f,0x2b1e0053,0x00000000}},	//   ldaa, дших_, _पाएँ_,
  { {0xfbdf03d9,0x7c2d15dd,0x69c301a8,0x00000000}},	//   _três_, ltar, ïnes,
  { {0x6d4d15de,0x4904007e,0x25a915df,0x00000000}},	//   ndaa, _موفق, čalo_,
  { {0x6d4d00fe,0xd6db0002,0x200b007d,0x00000000}},	//   idaa, _ете_, jsci_,
  { {0x69da0164,0x7c2d15e0,0x25710046,0x00000000}},	//   _éter, itar, _páls_,
  { {0x6f070b33,0x60c400ea,0x7c2d15e1,0x00000000}},	//   dajc, _szim, htar,
  { {0x7c2d15e2,0x04b50062,0x2509007e,0x00000000}},	//   ktar, _исля, _آرای_,
  { {0x15180021,0xdce6008f,0x21a30121,0x00000000}},	//   _أزمة_, _nokā, риям,
  { {0x6d5d15e3,0x6d4d006f,0x7c2d15e4,0x00000000}},	//   _ansa, edaa, dtar,
  { {0x20190290,0xee15000d,0x7c2d15e5,0x00000000}},	//   arsi_, льтэ, etar,
  { {0x6d4d00a4,0x40960021,0x6d5d003b,0x00000000}},	//   gdaa, _للعر, _cnsa,
  { {0x60c4017f,0x1ae60edd,0x442d0dd1,0x00000000}},	// [1dc0] _uzim, возм, nte_,
  { {0x3eba0122,0x8ad60021,0x6376017d,0x00000000}},	//   _typt_, نتائ, _pâni,
  { {0x4dd60021,0xdce402f7,0xab270062,0x00000000}},	//   _لتحس, ljič, тоха_,
  { {0x442d0386,0x3f98003e,0x69c915e6,0x00000000}},	//   kte_, liru_, _chee,
  { {0xa3c30161,0x69db00cd,0xa3c10053,0x00000000}},	//   ्षा_, _diue, ंता_,
  { {0x69c90122,0xbb76005a,0x18670001,0x00000000}},	//   _ehee, _румъ, таљи_,
  { {0xbf9b0047,0xb5a61501,0x36870062,0x00000000}},	//   ויסש, крий, ксън_,
  { {0x657b15e7,0xe5c6005e,0x442d15e8,0x00000000}},	//   gkuh, њско, fte_,
  { {0x37e6019d,0x75e701f7,0xa3c00161,0x00000000}},	//   _розг, _hızl, ूगल_,
  { {0x637f017d,0x61e315e9,0x75e70058,0x00000000}},	//   _pêna, _bunl, _kızl,
  { {0x3f98007d,0x442d0641,0x2019002b,0x00000000}},	//   diru_, ate_, wrsi_,
  { {0x64460026,0x9293000d,0x96950095,0x00000000}},	//   ækis, раюц, _сруш,
  { {0x53340088,0x68ed02dd,0x442d15ea,0x00000000}},	//   _белт, ñadi, cte_,
  { {0x321e0034,0x29040e57,0xdce6008f,0x00000000}},	//   puty_, _lema_, _rokā,
  { {0x91e30001,0xcddb0001,0x7c2d0051,0x00000000}},	//   _које, дња_, wtar,
  { {0x7c2d067a,0x290415eb,0xed140086,0x00000000}},	//   ttar, _nema_, имсь,
  { {0x3f9815ec,0x6d4d15ed,0x7bdc15ee,0x00000000}},	// [1dd0] biru_, rdaa, _biru,
  { {0x2d820102,0x6d4d0250,0xbcfb0164,0x00000000}},	//   _elke_, sdaa, _poés,
  { {0x7bdc0397,0x6abc001f,0x69c9002b,0x00000000}},	//   _diru, _cyrf, _phee,
  { {0x27e400f3,0x442d15ef,0x7bdc002b,0x00000000}},	//   _bumn_, yte_, _eiru,
  { {0x69db00cd,0x442d15f0,0x7bdc095a,0x00000000}},	//   _viue, xte_, _firu,
  { {0x69c90034,0x442d0512,0x07090021,0x00000000}},	//   _whee, vte_, ريبي_,
  { {0x6abc001f,0xc794007e,0x69c915f1,0x00000000}},	//   _gyrf, جشنب, _thee,
  { {0x05540076,0x442d15f2,0x290415f3,0x00000000}},	//   атья, tte_, _gema_,
  { {0xf1bf15f4,0x7793007e,0x6569021e,0x00000000}},	//   dlá_, _پیغا, rjeh,
  { {0x442d15f5,0x2904001c,0x61e300a4,0x00000000}},	//   rte_, _zema_, _punl,
  { {0x3f9801b3,0x6569007d,0x442d15f6,0x00000000}},	//   viru_, pjeh, ste_,
  { {0x442d15f7,0xdd110058,0xeab2009a,0x00000000}},	//   pte_, _rüşd, מֹר_,
  { {0x394d0185,0x628e0024,0x3f9815f8,0x00000000}},	//   _maes_, úbor, tiru_,
  { {0x649a00b7,0x749a00b5,0xe7c30042,0x00000000}},	//   _אינה, _אינפ, षतिप,
  { {0xe1f104de,0x200000e5,0x6fc0004d,0x00000000}},	//   _است_, _wwii_, löck,
  { {0x22580146,0x7bdc15f9,0x6e930044,0x00000000}},	//   ærke_, _siru, حلفا,
  { {0x25bf000c,0xe0da0a36,0x3f98007d,0x00000000}},	// [1de0] ilul_, _яви_, piru_,
  { {0xdd0401f7,0xbb4a0021,0x25bf0150,0x00000000}},	//   ısın, علان_, hlul_,
  { {0xe37a07e9,0x7bdc15fa,0x2d8c006c,0x00000000}},	//   ערער, _viru, èdes_,
  { {0xdcf7003b,0x7bdc0051,0xfe9b0149,0x00000000}},	//   ăcăr, _wiru, _טיימ,
  { {0x7bdc15fb,0x8eda005d,0xed570094,0x00000000}},	//   _tiru, _تذکر_, _соя_,
  { {0xc808008b,0x81bd008f,0x47330054,0x00000000}},	//   rở_, ltēt, йніс,
  { {0x394d001f,0x290415fc,0x645d04c7,0x00000000}},	//   _faes_, _tema_, åsin,
  { {0x746a0160,0x5e570047,0x81bd001c,0x00000000}},	//   еров_, ריקע_, ntēt,
  { {0x69d80078,0xdb1c004d,0x7d0615fd,0x00000000}},	//   įved, _thrä, _meks,
  { {0x25bf003b,0xa265008d,0x7d0615fe,0x00000000}},	//   alul_, _trộ, _leks,
  { {0x25bf003b,0x877b0041,0x81bd008f,0x00000000}},	//   blul_, _ראבי, ktēt,
  { {0x25bf003b,0x6fc00354,0xd0d50062,0x00000000}},	//   clul_, böck, ионъ,
  { {0x637615ff,0x637f00be,0xbfab01ce,0x00000000}},	//   _sânu, _gêno, етве_,
  { {0x6376000c,0xf1bf1600,0x7d06005f,0x00000000}},	//   _cânt, slá_, _aeks,
  { {0xa3c30161,0xa3c10053,0xbed50699,0x00000000}},	//   ्षर_, ंतर_, ровј,
  { {0x8cf50002,0xbca50021,0x9e430061,0x00000000}},	//   рзац, لمزي, žďov,
  { {0xcb1b000a,0xbcfb006d,0x6376003b,0x00000000}},	// [1df0] еќе_, _anéc, _fânt,
  { {0x3ce60066,0xeb930044,0x75e70058,0x00000000}},	//   ľova_, حظر_, _sızm,
  { {0x7d06013d,0x394d00be,0x9a27005d,0x00000000}},	//   _feks, _paes_, طعان,
  { {0x4dfa00b5,0xa9070049,0x99d4009e,0x00000000}},	//   _שפרא, ابان, متنا,
  { {0xd7050867,0xa1ac009d,0x00000000,0x00000000}},	//   азли, עֱבִ,   ,
  { {0x07a5000a,0x91720013,0x17f80021,0x00000000}},	//   јакн, rở_, ارنة_,
  { {0x6d4f014f,0x25bf000c,0x27f800c2,0x00000000}},	//   _kaca, tlul_, _črne_,
  { {0x6d4f1601,0x6fc0004d,0x59a90082,0x00000000}},	//   _jaca, töck, _कदिर,
  { {0xb81c0053,0x64a5000d,0x27f80240,0x00000000}},	//   _नियम_, рапа, čený_,
  { {0x6d4f1602,0x25bf011b,0xd7f801ce,0x00000000}},	//   _laca, slul_, _љут_,
  { {0x25bf1603,0x3dc0002b,0xa2d00082,0x00000000}},	//   plul_, yliw_, डेल्,
  { {0x2496006a,0x6376003b,0x672d007d,0x00000000}},	//   انید_, _sânt, đaju,
  { {0x764e0026,0x7d060d38,0x6376156c,0x00000000}},	//   _ábyr, _reks, _pânt,
  { {0x6376000c,0x7d061604,0x64591605,0x00000000}},	//   _dâns, _seks, _irwi,
  { {0x3ebe0026,0x6376003b,0x645c001c,0x00000000}},	//   ætt_, _vânt, ārie,
  { {0xed460699,0x6d4f1606,0x64590022,0x00000000}},	//   јнап, _caca, _krwi,
  { {0x7d061607,0x81bd001c,0xcaf60021,0x00000000}},	// [1e00] _veks, rtēt, لساب,
  { {0xb8820080,0x6e2f00ea,0x25780014,0x00000000}},	//   říkl, önbö, _hélt_,
  { {0xeb970001,0x7d061608,0x590a0062,0x00000000}},	//   јих_, _teks, веем_,
  { {0x32360047,0xc236009a,0x010d009d,0x00000000}},	//   יטען_, ירעו_, ֲלוּ,
  { {0xa01b00ea,0x6d440f84,0x7b01013d,0x00000000}},	//   szöv, meia, éztü,
  { {0x2d800051,0xc7a306be,0x6d4f1100,0x00000000}},	//   lkie_, оичк, _zaca,
  { {0x7c2402dd,0xbb3b0063,0xdaba007e,0x00000000}},	//   luir, _שעלי, _شهرت_,
  { {0x2d80021f,0xdb071609,0x6d44155f,0x00000000}},	//   nkie_, _skjø, neia,
  { {0xb716007e,0x69c2004b,0x7c24160a,0x00000000}},	//   _نباش, mloe, nuir,
  { {0x6e3e0031,0x69c2160b,0x443d0509,0x00000000}},	//   _oppb, lloe, _dpw_,
  { {0x2d80160c,0x82a60002,0xdb1c0025,0x00000000}},	//   kkie_, ршпе, _bhrú,
  { {0x7c2400b2,0x2578013d,0x067b009a,0x00000000}},	//   kuir, _célt_, _שנאל,
  { {0x6d44017d,0x248d0051,0xdb050331,0x00000000}},	//   deia, czem_, rohú,
  { {0xdb0500c7,0x6d4f0297,0x7c2402a5,0x00000000}},	//   llhö, _saca, duir,
  { {0xf206005a,0xbcfb0003,0x6d4f160d,0x00000000}},	//   _тяло, _anéa, _paca,
  { {0xdb1c0027,0xccf80001,0x69c8001c,0x00000000}},	//   _ghrú, ићу_, _ūden,
  { {0x4424160e,0x7c240741,0x6562108f,0x00000000}},	// [1e10] num_, guir, _mnoh,
  { {0x6d4f014f,0x25a9160f,0x2d800022,0x00000000}},	//   _waca, čali_, akie_,
  { {0x6d4f0027,0x5a3506be,0x44241610,0x00000000}},	//   _taca, снет, hum_,
  { {0xac190086,0x7c241611,0x44241612,0x00000000}},	//   _йому_, buir, kum_,
  { {0x765a0045,0x44241613,0x7c24003b,0x00000000}},	//   _arty, jum_, cuir,
  { {0xbb850032,0x44241614,0x248d00c2,0x00000000}},	//   _السي, dum_, vzem_,
  { {0x69c21615,0xe28e0131,0xff18009a,0x00000000}},	//   bloe, _наi_, בקות_,
  { {0x4424007a,0x69c20268,0x248d0268,0x00000000}},	//   fum_, cloe, tzem_,
  { {0x44241616,0xe3b90ab1,0x00000000,0x00000000}},	//   gum_, лби_,   ,
  { {0xd7740032,0x8c1a0063,0xdb0506a5,0x00000000}},	//   _والع, נותי, gohø,
  { {0x237800c7,0x7c24000c,0x248d101d,0x00000000}},	//   örja_, zuir, szem_,
  { {0xa06a0001,0x7d0d0656,0x442407ab,0x00000000}},	//   гама_, jaas, bum_,
  { {0x44240529,0x645d0146,0xb09a0086,0x00000000}},	//   cum_, æsid, утнє_,
  { {0xa027007a,0x64491617,0x7d0d004b,0x00000000}},	//   _stöð, mwei, eaas,
  { {0x644900bd,0x2d800051,0x51f50242,0x00000000}},	//   lwei, tkie_, _استر,
  { {0xdb05017d,0x75291618,0x7d0d0019,0x00000000}},	//   ilhõ, ngez, gaas,
  { {0x644900bd,0x69c20173,0x2d800474,0x00000000}},	// [1e20] nwei, vloe, rkie_,
  { {0x7c241619,0xcb0a007e,0x2d80030f,0x00000000}},	//   ruir, ايان_, skie_,
  { {0x7d0d0019,0x6449161a,0x6e3e161b,0x00000000}},	//   baas, hwei, _uppb,
  { {0xed5f0024,0x7529006f,0x644906aa,0x00000000}},	//   ážte_, jgez, kwei,
  { {0xa3e70053,0x7c240f15,0x48130054,0x00000000}},	//   _मूल_, quir, зміс,
  { {0x6449001f,0x31b20066,0x69c205d4,0x00000000}},	//   dwei, rázy_, sloe,
  { {0x44240051,0x69c2006f,0x6449087d,0x00000000}},	//   wum_, ploe, ewei,
  { {0x644900bd,0x9f8400fe,0x7529161c,0x00000000}},	//   fwei, löä_, ggez,
  { {0x79820051,0x3946161d,0x161a0053,0x00000000}},	//   mkow, meos_, _नटवर_,
  { {0xd2140001,0x4424161e,0x7982161f,0x00000000}},	//   омоћ, rum_, lkow,
  { {0x44241620,0xd4e60062,0xb7d70593,0x00000000}},	//   sum_, _люли, _اولا_,
  { {0x79820045,0x4424007a,0x656200fe,0x00000000}},	//   nkow, pum_, _unoh,
  { {0x5433007e,0x7d0d0072,0x9f840072,0x00000000}},	//   _فرور, vaas, köä_,
  { {0xd5be0023,0x1ee7005d,0xc4c50044,0x00000000}},	//   žādo_, صوری_, _بتمو,
  { {0x7a1c0529,0x7d0d1621,0x877b0aeb,0x00000000}},	//   nătă, taas, נאלי,
  { {0x63ba1622,0xdd940088,0x3253005a,0x00000000}},	//   lotn, пасы, _хвър,
  { {0x79820051,0x2d580b3f,0x39460bea,0x00000000}},	// [1e30] dkow, щить_, deos_,
  { {0x7d0d0019,0x2d9e0153,0x63ba1623,0x00000000}},	//   saas, éter_, notn,
  { {0x7d0d00fe,0x644900bd,0x27f800c2,0x00000000}},	//   paas, zwei, _črna_,
  { {0xf1c90161,0x61ea1624,0x63ba1625,0x00000000}},	//   रतिन, _mufl, hotn,
  { {0x63ba1626,0x1869151b,0x6e2700dd,0x00000000}},	//   kotn, рали_, lujb,
  { {0x36190055,0xa09c0047,0xb09c0047,0x00000000}},	//   ацию_, ניגט, ניגר,
  { {0x994d0024,0x75290194,0x79821627,0x00000000}},	//   môžu_, tgez, bkow,
  { {0x64491628,0x0e9c0047,0x394605d5,0x00000000}},	//   twei, טשול, ceos_,
  { {0x61ea00bd,0xa3e9000a,0x75291629,0x00000000}},	//   _aufl, јдоа_, rgez,
  { {0x290f162a,0x6449162b,0x13090121,0x00000000}},	//   laga_, rwei, шной_,
  { {0x6449162c,0x7529006f,0x7a1c003b,0x00000000}},	//   swei, pgez, cătă,
  { {0x290f0214,0x15a80062,0x63a8004e,0x00000000}},	//   naga_, _лъчи_, andn,
  { {0x2bbe0161,0xafdb00d1,0x290f0089,0x00000000}},	//   ्तमा, lvøy, iaga_,
  { {0x3e8a000d,0x79820051,0x7989162d,0x00000000}},	//   айго_, zkow, _llew,
  { {0xaf990376,0x290f162e,0x79820051,0x00000000}},	//   стях_, kaga_, ykow,
  { {0xa3c30053,0x290f162f,0xa6e20014,0x00000000}},	//   ्षक_, jaga_, æðik,
  { {0x9f8400fe,0x0eb60053,0x290f1630,0x00000000}},	// [1e40] töä_, _आँकड, daga_,
  { {0x76411631,0x290f1632,0x79820022,0x00000000}},	//   _oply, eaga_, wkow,
  { {0x79820045,0x798900f1,0x61e401a9,0x00000000}},	//   tkow, _blew, _kiil,
  { {0x5f46006a,0xed5a10e4,0x9f840072,0x00000000}},	//   _انگل, _том_, söä_,
  { {0x79820051,0x39461633,0x91720013,0x00000000}},	//   rkow, reos_, iờ_,
  { {0x394602dd,0x79820051,0x79891147,0x00000000}},	//   seos_, skow, _elew,
  { {0x394602dd,0x290f0551,0x637f017d,0x00000000}},	//   peos_, baga_, _gêni,
  { {0x61e400fe,0x63ba1634,0x79890244,0x00000000}},	//   _niil, wotn, _glew,
  { {0x61ea000c,0x236a00e1,0x63ba1308,0x00000000}},	//   _sufl, ајно_, totn,
  { {0xe72a005d,0xbcfb013d,0x63a80046,0x00000000}},	//   _خسرو_, _anél, undn,
  { {0x32660086,0x63ba1635,0xa1591636,0x00000000}},	//   ітов, rotn, бану_,
  { {0x63ba00c3,0x656f00bd,0xe578008f,0x00000000}},	//   sotn, öcht, _puķu_,
  { {0x61e410a5,0x83f80062,0x63ba1637,0x00000000}},	//   _diil, _уелс_, potn,
  { {0x60cd00c2,0xa2940500,0xbcfb013d,0x00000000}},	//   _vzam, _налі, _enél,
  { {0x290f002c,0x3f830014,0x61e41638,0x00000000}},	//   yaga_, rkju_, _fiil,
  { {0x3f830046,0xd0110044,0x71f704a0,0x00000000}},	//   skju_, _كلب_, _بروس_,
  { {0xe57100b5,0x6ebb0053,0x290f10c8,0x00000000}},	// [1e50] ײַן_, _शुरु, vaga_,
  { {0x7e2b0088,0x6d5600a4,0xddeb007e,0x00000000}},	//   _кіма_, adya, _پرده_,
  { {0xdced017f,0xdb070014,0xfc3f0013,0x00000000}},	//   ljač, _skjó, _axít_,
  { {0x9981004c,0xdced0130,0xe81c0082,0x00000000}},	//   ruhů_, ojač, _निशा_,
  { {0xa8040088,0x290f1639,0xdced0734,0x00000000}},	//   дзіл, raga_, njač,
  { {0x637f017d,0x2009163a,0x69c00058,0x00000000}},	//   _têni, _mwai_, _ekme,
  { {0x64420016,0xf96b163b,0x91720013,0x00000000}},	//   _apoi, _край_, hớ_,
  { {0x76410024,0xe795007e,0x799b00a4,0x00000000}},	//   _vply, _کارک, _umuw,
  { {0xdced007d,0xd7f804f2,0xc952009a,0x00000000}},	//   jjač, _дух_, _אמן_,
  { {0xdced007d,0x61e4163c,0xe3b10044,0x00000000}},	//   djač, _siil, عرة_,
  { {0x61e400fe,0x4b7c00b5,0x76410240,0x00000000}},	//   _piil, יאזו, _uply,
  { {0xe8020161,0x644f0146,0x75e7013d,0x00000000}},	//   रीका_, æcis, _tűzb,
  { {0xe5c4000d,0x61e4163d,0x7fd60085,0x00000000}},	//   _ўсхо, _viil, зіві,
  { {0x22150062,0xf767014d,0xe0d70062,0x00000000}},	//   _ефир, را_, явя_,
  { {0x61e40072,0x63a1163e,0x27ed0050,0x00000000}},	//   _tiil, miln, _luen_,
  { {0x63a1163f,0x661c00b9,0x68e9006f,0x00000000}},	//   liln, _ærke, _nged,
  { {0x27f800c2,0x8b26000d,0x201a0021,0x00000000}},	// [1e60] _črno_, здзе, _اتبع_,
  { {0x645b00fe,0x63a11640,0xe7ef0042,0x00000000}},	//   ivui, niln, _चढ़ा_,
  { {0x7c361641,0xaac5007e,0x3f7b0063,0x00000000}},	//   styr, وتمن, _האיס,
  { {0x7e610146,0x27ed02dd,0x290d0529,0x00000000}},	//   ælpe, _buen_, _ceea_,
  { {0xa3cb0053,0x7d041642,0xbc190054,0x00000000}},	//   लता_, mbis, _мірі_,
  { {0x26c50080,0x68ed0024,0x63a100c2,0x00000000}},	//   _bylo_, ľada, jiln,
  { {0x68ed02f4,0x63a10198,0x6b630500,0x00000000}},	//   žada, diln, _якра,
  { {0xb6080080,0x442a000d,0x63a1004d,0x00000000}},	//   jišť, бцом_, eiln,
  { {0xdb05006d,0xbcfb0066,0x63a106f1,0x00000000}},	//   cohó, _poéz, filn,
  { {0x57fb0063,0xb882004c,0x53980054,0x00000000}},	//   _ללמו, řísl, івня_,
  { {0xa294046e,0x97310043,0xdb37009a,0x00000000}},	//   фані, _شکوا, הניח_,
  { {0x64420072,0x7c240130,0xa3e70082,0x00000000}},	//   _tpoi, krir, _मूक_,
  { {0x53340076,0x7d04007d,0x777a00cd,0x00000000}},	//   _желт, dbis, _kotx,
  { {0x63a11643,0x7d041644,0x62811645,0x00000000}},	//   ciln, ebis, bylo,
  { {0xe3b30047,0x433b0063,0x733b0063,0x00000000}},	//   _אױס_, _העוב, _העוס,
  { {0x7d04002c,0x7c241646,0x44241647,0x00000000}},	//   gbis, frir, orm_,
  { {0xb606007d,0x7c241648,0xdfb5005e,0x00000000}},	// [1e70] lošć, grir, _обињ,
  { {0x7d04061e,0x44240c0c,0x25a0004c,0x00000000}},	//   abis, irm_, čily_,
  { {0x7c241649,0xb606007d,0x7d04164a,0x00000000}},	//   arir, nošć, bbis,
  { {0x7c240e57,0x7c87005e,0x63a100a8,0x00000000}},	//   brir, _еуге, ziln,
  { {0x7c240003,0x27ed008b,0xdb1c164b,0x00000000}},	//   crir, _quen_, _chró,
  { {0x777a0268,0xf794000d,0x3dc9002b,0x00000000}},	//   _cotx, начэ, llaw_,
  { {0x63a1164c,0x4424164d,0x7d0f013d,0x00000000}},	//   viln, erm_, _kecs,
  { {0x4975000d,0xdb0500cd,0x27ed00fe,0x00000000}},	//   _ўлас, cohò, _tuen_,
  { {0x3dc900a4,0x69c30003,0x63a1164e,0x00000000}},	//   ilaw_, îneu, tiln,
  { {0x7d0400bd,0x645b006f,0x7d0f00ea,0x00000000}},	//   zbis, rvui, _lecs,
  { {0x3ce60024,0x63a1164f,0x3dc900a4,0x00000000}},	//   ľovi_, riln, klaw_,
  { {0x7c24007a,0x62811650,0xa0a6005e,0x00000000}},	//   yrir, rylo, дамд,
  { {0xbcfb0024,0x63a11651,0x25ad004e,0x00000000}},	//   _inéh, piln, mnel_,
  { {0x7df50006,0x3f8c027d,0x7c241652,0x00000000}},	//   _sąsa, ódu_, vrir,
  { {0x25ad0146,0x7d0f000f,0xb2220014,0x00000000}},	//   onel_, _becs, þætt,
  { {0x3cf50161,0x25ad0238,0x25bf1653,0x00000000}},	//   एँगे_, nnel_, noul_,
  { {0x7d0400bb,0xa01b00fe,0x629c0195,0x00000000}},	// [1e80] rbis, lyön, úrov,
  { {0x7c241654,0x7d041655,0x60c0004d,0x00000000}},	//   rrir, sbis, ümmu,
  { {0x3dc9001f,0x68ed0066,0x41b3005d,0x00000000}},	//   blaw_, ľadn, _سمیر,
  { {0x7c241656,0xdb1c0025,0x18a60ee5,0x00000000}},	//   prir, _phró, маем,
  { {0xb8f60161,0xd7ef0021,0x00000000,0x00000000}},	//   _हर_, لكن_,   ,
  { {0xa6340086,0x4b550062,0x25ad0058,0x00000000}},	//   енкі, _пъст, enel_,
  { {0x9f8d0026,0x97c50044,0x5ee9009a,0x00000000}},	//   nþá_, رتهم, הַפְ,
  { {0xa5340962,0xb606007d,0x54541657,0x00000000}},	//   хнич, vošć, евит,
  { {0x31b90066,0x9326005d,0x6b73056c,0x00000000}},	//   cézy_, وردن, _węgł,
  { {0x42740076,0x7c2b00cd,0x29061658,0x00000000}},	//   егос, àgri, lboa_,
  { {0xa159005e,0x2b581659,0x25bf006c,0x00000000}},	//   пану_, _marc_, boul_,
  { {0xc486019d,0x21670086,0x5a170047,0x00000000}},	//   _олек, фтог, וקטן_,
  { {0x10740071,0xdced0066,0xf5770021,0x00000000}},	//   вляю, tiaľ, _تمنع_,
  { {0x0efb0161,0x81bd0023,0xbefb0042,0x00000000}},	//   ्रेस_, ntēz, ्रेन_,
  { {0x3dc9059f,0x7d0f013d,0x4ea41313,0x00000000}},	//   tlaw_, _pecs, врта,
  { {0xcdd80001,0xa5d80aeb,0xe2870043,0x00000000}},	//   дњу_, לַּי, _تطهی,
  { {0x7d02006d,0x2b58002b,0x60c0004d,0x00000000}},	// [1e90] ñosa, _barc_, ümmt,
  { {0x3dc9165a,0x2bb80044,0x1a8b0044,0x00000000}},	//   slaw_, والة_, يضاً_,
  { {0x7d0f155f,0x2019165b,0xb50e0042,0x00000000}},	//   _tecs, lssi_, सराय_,
  { {0x68ed0024,0x7d1d004d,0x645c008f,0x00000000}},	//   ľado, _udss, ārij,
  { {0x6cfa0063,0x68ed0512,0x2b58165c,0x00000000}},	//   _מפרס, žado, _farc_,
  { {0x237c08ed,0x00000000,0x00000000,0x00000000}},	//   _novj_,   ,   ,
  { {0x7c2d165d,0xbcfb017d,0x2bbe0053,0x00000000}},	//   luar, _anéi, ्तरा,
  { {0xc8670062,0x6d4d165e,0x00000000,0x00000000}},	//   _отзи, neaa,   ,
  { {0x25bf003b,0x73e50062,0x7c2d165f,0x00000000}},	//   roul_, ноиз, nuar,
  { {0xe2990001,0x69cb1660,0x6d4d004b,0x00000000}},	//   зао_, llge, heaa,
  { {0x20190026,0x69cb010b,0x6d4d00fe,0x00000000}},	//   essi_, olge, keaa,
  { {0x7c2d0bda,0x865a009a,0xa3cf0042,0x00000000}},	//   kuar, _מדעי, _वीर_,
  { {0x656b051e,0xbcfb0025,0x1fb60002,0x00000000}},	//   _ingh, _gnéi, есвр,
  { {0x7c2d1661,0x69cb00bd,0x442d1662,0x00000000}},	//   duar, hlge, mue_,
  { {0x20191663,0x3c43001c,0x442d1664,0x00000000}},	//   assi_, hīvā_, lue_,
  { {0x7c2d0025,0x52740021,0x29e80058,0x00000000}},	//   fuar, _جاهز, _aşan_,
  { {0x442d04bc,0x7c2d1665,0x6aa80053,0x00000000}},	// [1ea0] nue_, guar, कप्र,
  { {0xe0d7000d,0x3a06007e,0x69cb1666,0x00000000}},	//   _явы_, فکری_, elge,
  { {0x6376003b,0x656b1667,0xa9260f34,0x00000000}},	//   _pânz, _ongh, едел,
  { {0xb17b00c7,0x6d4d006f,0x442d1668,0x00000000}},	//   rmåg, ceaa, kue_,
  { {0x63760529,0x442d0035,0x7c2d1669,0x00000000}},	//   _vânz, jue_, cuar,
  { {0x7d16166a,0x656b0185,0xdb070026,0x00000000}},	//   lays, _angh, _skjö,
  { {0x442d166b,0x3ce60066,0xb17b0137,0x00000000}},	//   eue_, ľovu_, lmåe,
  { {0xfa89000d,0x09e3166c,0x89da0044,0x00000000}},	//   _ўсёй_, _босн, _روذر_,
  { {0x6e2e0717,0xdb1e01a8,0x98af0078,0x00000000}},	//   hubb, topè, degė_,
  { {0x656b001f,0x96960925,0xa6960141,0x00000000}},	//   _engh, _преш, _преј,
  { {0xeb970063,0x7bde003b,0xbcfb0003,0x00000000}},	//   גדיר_, impu, _inév,
  { {0x7c2d0089,0x6e2e166d,0x442d166e,0x00000000}},	//   yuar, dubb, bue_,
  { {0x20190164,0xf1a4000d,0xe82a0063,0x00000000}},	//   ussi_, урэн, הוָֽ,
  { {0x20190cb0,0xa3cb0042,0xccf9056c,0x00000000}},	//   rssi_, लतः_, _żś_,
  { {0x6f1500c3,0x656b001f,0x2e480156,0x00000000}},	//   razc, _yngh, нято_,
  { {0x7bde053b,0x40950021,0x9981004c,0x00000000}},	//   empu, _للبر, vrhů_,
  { {0x6d4d166f,0xb81c0042,0xb17b00a5,0x00000000}},	// [1eb0] reaa, _निगम_, rmåd,
  { {0xb17b0146,0x69cb006f,0x764805a5,0x00000000}},	//   småd, wlge, _opdy,
  { {0x7c2d1670,0x6d4d1671,0x4939000d,0x00000000}},	//   suar, peaa, дзею_,
  { {0x4ac40021,0x3c43001c,0xa91d00c2,0x00000000}},	//   ديمق, tīvā_, _možg,
  { {0xe10c00b5,0xdee7007e,0x89340044,0x00000000}},	//   פּאָ, _تأکي, اعما,
  { {0x9be4000d,0x442d1672,0xa3cf0053,0x00000000}},	//   _біск, vue_, _वीं_,
  { {0xead40076,0x9732005d,0xcb12009a,0x00000000}},	//   _борь, شکلا, _כלם_,
  { {0x442d1673,0x68fb002b,0x9c870066,0x00000000}},	//   tue_, _ufud, cičí,
  { {0xe4320032,0x00000000,0x00000000,0x00000000}},	//   لفيد,   ,   ,
  { {0x394f1674,0x2d9e0003,0x442d1675,0x00000000}},	//   legs_, étez_, rue_,
  { {0x442d11e8,0x27f800c2,0xbb3c0047,0x00000000}},	//   sue_, _črni_, לעזי,
  { {0x656b08c8,0xe4d90021,0xdb1e1676,0x00000000}},	//   _ungh, _قوات_, ropé,
  { {0x442d1677,0x80d90054,0x7bde1678,0x00000000}},	//   que_, еєру_, ympu,
  { {0x6e2e1679,0xdb1c011b,0x00000000,0x00000000}},	//   tubb, _okrá,   ,
  { {0x7d02006d,0x6da60fec,0x5cf6014b,0x00000000}},	//   ñoso, вива, вязу,
  { {0x32050034,0x12e80149,0xc692069a,0x00000000}},	//   mply_, _אַפּ, באל_,
  { {0xa91d0117,0x2bf60076,0x5f06005a,0x00000000}},	// [1ec0] _možd, тябр, _изпа,
  { {0x6e2e051e,0x7d16002c,0x7bde0228,0x00000000}},	//   pubb, says, umpu,
  { {0xdee602d8,0xfeba0044,0x00000000,0x00000000}},	//   _јони, _زادت_,   ,
  { {0x99750121,0xdd05003b,0x637e004c,0x00000000}},	//   лучш, ăsăr, _záně,
  { {0x81bd001c,0xe995005d,0xc7ba014b,0x00000000}},	//   frēj, دهنگ, мёк_,
  { {0xc66a0121,0xe7180044,0x81bd0023,0x00000000}},	//   дшие_, ريبت_, grēj,
  { {0x98b201f7,0x092a0044,0xe93a0896,0x00000000}},	//   ıyı_, _يسري_, _очај_,
  { {0xceb30063,0xd6d90054,0x644700dd,0x00000000}},	//   ייו_, хті_, ăjin,
  { {0xdb1c0080,0x3205167a,0xa01b0050,0x00000000}},	//   _zkrá, eply_, työm,
  { {0xa91d00c2,0x3254167b,0x98750058,0x00000000}},	//   _požg, гвор, lüğe_,
  { {0xc56a0021,0xc5f60094,0x66e607ed,0x00000000}},	//   _يحصل_, _рязъ, _рожа,
  { {0xfbdf001f,0x316d0871,0x91fc0023,0x00000000}},	//   _apêl_, ñez_, evāc,
  { {0x9054000d,0x60d60022,0x71a40085,0x00000000}},	//   авяц, _czym, раўз,
  { {0x547b014e,0x9e3505ac,0xa382004e,0x00000000}},	//   _קטגו, легч, õõdu,
  { {0x63a8167c,0xdb06004c,0xdd950085,0x00000000}},	//   midn, ámýc, гавы,
  { {0x7bc7105a,0xf2d30047,0xa91d004c,0x00000000}},	//   _skju, _דעצ_, _kože,
  { {0xdb1c007a,0xfbd90259,0xa91d085a,0x00000000}},	// [1ed0] _skrá, едај_, _jože,
  { {0xa91d0117,0x8f55019d,0xfecb0021,0x00000000}},	//   _može, _свої, _يبدو_,
  { {0x75221401,0x61ed1037,0xdb050014,0x00000000}},	//   _odoz, _kial, nihé,
  { {0xeb9f00b9,0xafdb00b9,0x629a00ea,0x00000000}},	//   _stød_, stød, izto,
  { {0xa3c2016a,0x61ed0035,0x63a8007d,0x00000000}},	//   ंवा_, _mial, kidn,
  { {0x75220290,0x6d5d167d,0xab840154,0x00000000}},	//   _adoz, _hasa, _куск,
  { {0x6d5d0273,0x3f810080,0x27ec0034,0x00000000}},	//   _kasa, _mohu_, _didn_,
  { {0x7bc50035,0x63a8167e,0x62881566,0x00000000}},	//   lohu, eidn, dydo,
  { {0x6d5d167f,0x60cd091c,0x629a001c,0x00000000}},	//   _masa, _nyam, ezto,
  { {0x60d60051,0x6d5d1680,0xdb1c00b9,0x00000000}},	//   _rzym, _lasa, _ekræ,
  { {0x60d60022,0xe2070022,0x42541681,0x00000000}},	//   _szym, _ogół_, атят,
  { {0x74b9000a,0x61ed0025,0x6d5d1682,0x00000000}},	//   _пулс_, _cial, _nasa,
  { {0x343900b5,0x7bc50019,0x442905d5,0x00000000}},	//   _נײַע, kohu, _ía_,
  { {0x443f003d,0x947404f6,0x32051683,0x00000000}},	//   mtu_, _خدما, pply_,
  { {0x443f0884,0x225805b9,0x62880051,0x00000000}},	//   ltu_, ærkt_, cydo,
  { {0x2d950088,0x61ed051e,0x6d5d00c5,0x00000000}},	//   арус, _gial, _casa,
  { {0x443f1684,0x6d5d08f0,0x20040025,0x00000000}},	// [1ee0] ntu_, _dasa, ímid_,
  { {0x79800035,0x28b70053,0x6d5d0139,0x00000000}},	//   _somw, _आख़ि, _easa,
  { {0x443f0004,0x092a0076,0x69db0025,0x00000000}},	//   htu_, ежей_, _bhue,
  { {0x644b1685,0x7d560086,0x69db0331,0x00000000}},	//   _opgi, _стої, _chue,
  { {0x657b0019,0x443f0743,0xa2ca0053,0x00000000}},	//   djuh, jtu_, _सुन्,
  { {0xdb1c1686,0xcb760001,0xa91d00c2,0x00000000}},	//   _skræ, _сумњ, _rože,
  { {0x6d5d01f7,0xa01b00fe,0xbb3b0047,0x00000000}},	//   _yasa, työk, _רעלי,
  { {0x7df50812,0x6d440b16,0x7792007e,0x00000000}},	//   _sąsk, nfia, _گیتا,
  { {0x61ed0027,0x443f001c,0x63a80415,0x00000000}},	//   _rial, gtu_, tidn,
  { {0xf2060878,0xdb1e0240,0xb8930021,0x00000000}},	//   лямо, kopí, _الكع,
  { {0x61ed0397,0x60cd0397,0x443f1687,0x00000000}},	//   _pial, _syam, atu_,
  { {0x7bc50009,0x443f003e,0x6288001f,0x00000000}},	//   zohu, btu_, rydo,
  { {0x7bc50009,0x629a1688,0x6d5d1689,0x00000000}},	//   yohu, szto, _rasa,
  { {0x225800b9,0x60cd0035,0x6d5d168a,0x00000000}},	//   ærks_, _vyam, _sasa,
  { {0xcddb0459,0x6d5d168b,0x2d820130,0x00000000}},	//   ења_, _pasa, _boke_,
  { {0x2d580619,0x5d55000a,0x7ae11114,0x00000000}},	//   лись_, јкат, _últi,
  { {0x7bdc0027,0x65600025,0x6d5d168c,0x00000000}},	// [1ef0] _bhru, idmh, _vasa,
  { {0x7bdc0027,0xa01b00fe,0x39b10006,0x00000000}},	//   _chru, vyöh, mąsi_,
  { {0x63af00f8,0x6440004b,0xaa5509da,0x00000000}},	//   écni, htmi, рвеш,
  { {0xbcfb0460,0x7bc5004b,0x6d5d0139,0x00000000}},	//   _enér, sohu, _uasa,
  { {0x998700ea,0x443f016b,0x657b004b,0x00000000}},	//   énő_, xtu_, vjuh,
  { {0x6605000a,0x16390021,0x8ae70304,0x00000000}},	//   апка, نسبة_, _бібл,
  { {0x66240021,0x2d82077d,0x9675000d,0x00000000}},	//   مريك, _yoke_, рылі,
  { {0x7c2d051e,0x443f168d,0x7bdc0114,0x00000000}},	//   orar, ttu_, _zhru,
  { {0x99840032,0x765a168e,0xa91d00c2,0x00000000}},	//   _القو, _esty, _tožb,
  { {0xc245000a,0x657b0ff2,0x4734007e,0x00000000}},	//   анок, sjuh, _هرمز,
  { {0x7d0d00c7,0x395f0150,0xa2290062,0x00000000}},	//   kbas, _kaus_, ъжна_,
  { {0x9f49007a,0x7c2d168f,0x3f850014,0x00000000}},	//   _stað_, krar, ölun_,
  { {0x64590035,0x2d8200c2,0x95c4007e,0x00000000}},	//   _uswi, _roke_, _اينه,
  { {0x442d1690,0x23290086,0x765a0185,0x00000000}},	//   mre_, _роки_, _ysty,
  { {0x442d000f,0x7c2d1691,0xc3320041,0x00000000}},	//   lre_, erar, _ווו_,
  { {0x442d1692,0x7d0d0a9f,0x395f03ea,0x00000000}},	//   ore_, gbas, _naus_,
  { {0xed570002,0x7c2d1693,0x6db7007d,0x00000000}},	// [1f00] шот_, grar, pćan,
  { {0x442d1694,0xdb230026,0x8b260086,0x00000000}},	//   ire_, ærða, рдже,
  { {0x442d0199,0x2d9e0164,0x2d8200a4,0x00000000}},	//   hre_, ètes_, _toke_,
  { {0xdb1c00c7,0x442d1695,0x7c2d1696,0x00000000}},	//   _skrä, kre_, brar,
  { {0x442d0146,0xed57005a,0x7c2d1697,0x00000000}},	//   jre_, _тоя_, crar,
  { {0x442d04b1,0x7df51435,0xaa0601fb,0x00000000}},	//   dre_, _sąsi, _نظره,
  { {0x6603000a,0x442d02e3,0x6753005d,0x00000000}},	//   опја, ere_, زخور,
  { {0x395f0006,0x6f1c1698,0x69d80078,0x00000000}},	//   _gaus_, harc, įves,
  { {0x442d1699,0x765a0022,0x9f8d0014,0x00000000}},	//   gre_, _wsty, rþú_,
  { {0x46a6011c,0x883b014e,0x9378000a,0x00000000}},	//   _казв, _בתמו, убот_,
  { {0x6440169a,0x442d169b,0xd25701dd,0x00000000}},	//   stmi, are_, аця_,
  { {0xa50a0676,0x04460189,0x442d169c,0x00000000}},	//   _реда_, _ведн, bre_,
  { {0xdcef003d,0x9f840026,0x6f1c001f,0x00000000}},	//   ādīt, töð_, farc,
  { {0x7c2d169d,0x6f1c169e,0x6304005d,0x00000000}},	//   vrar, garc, _اوغل,
  { {0xa3110066,0xfda7005e,0x7d0d169f,0x00000000}},	//   äčšo, ајам, tbas,
  { {0x200400cd,0xb1150a74,0x527b0063,0x00000000}},	//   ímic_, _умиш, _ינוא,
  { {0xdce600eb,0x5ce70086,0x7d0d16a0,0x00000000}},	// [1f10] _mokė, рюва, rbas,
  { {0x7c2d16a1,0xea670001,0x7d0d0f8c,0x00000000}},	//   rrar, ињен, sbas,
  { {0x200b00c2,0x3866004d,0x395f0f7d,0x00000000}},	//   lpci_, evor_, _paus_,
  { {0x442d16a2,0xa91d074f,0x7c2d16a3,0x00000000}},	//   yre_, _boža, prar,
  { {0x67d5000a,0x9f40032a,0xdb1c060b,0x00000000}},	//   боду, _guió_, _skrå,
  { {0xd874006a,0x442d16a4,0x6747000d,0x00000000}},	//   تامب, vre_, рэдз,
  { {0x36180088,0x442d0089,0x386616a5,0x00000000}},	//   ацыю_, wre_, avor_,
  { {0x05620062,0x442d16a6,0xdeb8009a,0x00000000}},	//   звън, tre_, יפוח_,
  { {0x291d00bb,0x31600016,0x442d16a7,0x00000000}},	//   mawa_, _raiz_, ure_,
  { {0x442d16a8,0x316000e3,0x291d15e7,0x00000000}},	//   rre_, _saiz_, lawa_,
  { {0x442d000f,0xa91d16a9,0xb17b0a3f,0x00000000}},	//   sre_, _zoža, rmån,
  { {0x291d16aa,0x68ed0240,0x568c0047,0x00000000}},	//   nawa_, žadu, _שטאַ,
  { {0xa4d40086,0xafe60054,0x25ad16ab,0x00000000}},	//   _доці, йомл, miel_,
  { {0x291d00e3,0xb17b0b19,0xafe601e4,0x00000000}},	//   hawa_, lmål, согл,
  { {0x291d16ac,0x29dc01a8,0xc7d60063,0x00000000}},	//   kawa_, níac_, מושי_,
  { {0x6f1c16ad,0x6dac0058,0x3f8c004b,0x00000000}},	//   sarc, aşan, ödub_,
  { {0x248d00cd,0x291d16ae,0xdd8f0021,0x00000000}},	// [1f20] nyem_, dawa_, روك_,
  { {0xa91d00b2,0x61e616af,0x6dac003b,0x00000000}},	//   _roža, lmkl, cşan,
  { {0xa96a0138,0xdb07000f,0xb17b0d1a,0x00000000}},	//   лижа_, ámár, kmål,
  { {0xa91d016b,0x291d114c,0x38cb007e,0x00000000}},	//   _poža, gawa_, گامی_,
  { {0x25ad0024,0x53c70161,0xb17b0b19,0x00000000}},	//   diel_, रकाश, dmål,
  { {0x1853000d,0x38cb007e,0x6d560ca7,0x00000000}},	//   явіў, دامی_, leya,
  { {0x25ad03a8,0x291d16b0,0xd7f10013,0x00000000}},	//   fiel_, bawa_, _dĩ_,
  { {0xe5c60001,0x2d8000ac,0x6d5616b1,0x00000000}},	//   љско, njie_, neya,
  { {0x7643028d,0x03f8005e,0x53980330,0x00000000}},	//   atny, јној_, ивия_,
  { {0x388e003d,0x5c5b0e2a,0x61e6006f,0x00000000}},	//   _vērā_, נדיק, emkl,
  { {0x25ad0162,0x3f850026,0x91b90002,0x00000000}},	//   biel_, ölum_, игот_,
  { {0xf09f00cd,0x25ad16b2,0x7df50078,0x00000000}},	//   tzà_, ciel_, _mąst,
  { {0x7df50006,0x2d8000ac,0x200b16b3,0x00000000}},	//   _ląst, djie_, upci_,
  { {0xdbf10080,0xa2940088,0x9294026b,0x00000000}},	//   _příl, _малі, _малц,
  { {0x291d0e83,0x6d8a0014,0x6e9416b4,0x00000000}},	//   yawa_, _nýas, пиру,
  { {0x81bd008f,0x00000000,0x00000000,0x00000000}},	//   grēt,   ,   ,
  { {0x75e7013d,0x7dd30075,0x9f84004e,0x00000000}},	// [1f30] _tűzv, nçsi, vöö_,
  { {0x81bd001c,0x291d16b5,0xdea4007e,0x00000000}},	//   arēt, wawa_, _کیفی,
  { {0x9f840019,0x291d16b6,0x2d85006c,0x00000000}},	//   töö_, tawa_, êles_,
  { {0x8f55007e,0xd7f10013,0x6d560075,0x00000000}},	//   _انگش, _sĩ_, ceya,
  { {0xf770006a,0xc9740021,0x291d16b7,0x00000000}},	//   کان_, ثالث, rawa_,
  { {0x25ad0717,0x291d16b8,0xcc76009a,0x00000000}},	//   wiel_, sawa_, _ועשה_,
  { {0x1995000d,0xd7f10013,0x19590085,0x00000000}},	//   _давя, _vĩ_, _кавы_,
  { {0x6fd200b9,0x20090089,0x91fc001c,0x00000000}},	//   ræci, _otai_, rvāl,
  { {0x25ad16b9,0x764316ba,0xb17b02c0,0x00000000}},	//   riel_, stny, rmål,
  { {0xb17b02ea,0x25ad16bb,0x69cb13bb,0x00000000}},	//   smål, siel_, loge,
  { {0x09b500b5,0x25ad16bc,0xf486007e,0x00000000}},	//   ַפֿט_, piel_, مایی,
  { {0xe3b80058,0x69cb16bd,0x6a3a009a,0x00000000}},	//   anı_, noge, סגרפ,
  { {0x69cb001f,0x6d5600e5,0x61e60e46,0x00000000}},	//   ioge, veya, rmkl,
  { {0xaab90053,0x69cb16be,0x2d9900ca,0x00000000}},	//   _आशंक, hoge, _alse_,
  { {0x59c90161,0x2d8000e8,0x394d0222,0x00000000}},	//   िकार, tjie_, _obes_,
  { {0x753b0009,0xa01b0072,0xe627008d,0x00000000}},	//   nguz, työt, _đổ_,
  { {0x6d5616bf,0x81bd008f,0x8c4304c3,0x00000000}},	// [1f40] reya, arēs, мете,
  { {0x2d9916c0,0x6d560003,0xeab20044,0x00000000}},	//   _else_, seya, وعا_,
  { {0x386d00d1,0xe8fa16c1,0xa01b0072,0x00000000}},	//   _arer_, але_, syöt,
  { {0xfd120021,0xcd36005d,0x69cb16c2,0x00000000}},	//   _تجد_, _بردب, goge,
  { {0xe3b8005b,0x386d017d,0x7d0416c3,0x00000000}},	//   ynı_, _crer_, mcis,
  { {0x7c2416c4,0x7d0416c5,0x262a02d8,0x00000000}},	//   msir, lcis, ацио_,
  { {0x07a3000a,0xbf9b0003,0x41ca0053,0x00000000}},	//   ќајн, mpêt, रवास,
  { {0x69cb16c6,0x38aa0022,0x342602d8,0x00000000}},	//   coge, tórą_, офов,
  { {0xdb1e0146,0x7c2416c7,0xb866005d,0x00000000}},	//   ropæ, nsir, _بازو,
  { {0xa3e70001,0x7792007e,0x7c2416c8,0x00000000}},	//   одња_, _زیبا, isir,
  { {0x200908c8,0x6b830026,0x8afb16c9,0x00000000}},	//   _stai_, öngi, יליז,
  { {0x7c2416ca,0x96330454,0x78a2007c,0x00000000}},	//   ksir, _ініц, ozov,
  { {0xa2ca0161,0x7c241235,0xd5e90044,0x00000000}},	//   _सुर्, jsir, _اعلن_,
  { {0xc058019d,0x69cb00bd,0x09b70053,0x00000000}},	//   цію_, zoge, _अद्य,
  { {0x7c2604c7,0xdef4000d,0x44261186,0x00000000}},	//   _avkr, дпры, _hvo_,
  { {0x212900f3,0x7c2416cb,0x3f9a0023,0x00000000}},	//   _udah_, fsir, _elpu_,
  { {0x7dda00cd,0xe5710063,0xdfdb0062,0x00000000}},	// [1f50] aïso, עַל_, _вън_,
  { {0x78a20024,0x63ba00bd,0x79820022,0x00000000}},	//   dzov, nntn, ejow,
  { {0x7c2400eb,0x6b510014,0x69cb16cc,0x00000000}},	//   asir, _aðgæ, toge,
  { {0x4426055e,0x7d0416cd,0x91fc0023,0x00000000}},	//   _ovo_, ccis, evāk,
  { {0xdb1e004b,0x6c790047,0x69cb16ce,0x00000000}},	//   fopä, _האָפ, roge,
  { {0xbdf8007e,0x69cb16cf,0x7d1d16d0,0x00000000}},	//   _دریا_, soge, _hess,
  { {0x29dc006d,0x69cb0baf,0x442616d1,0x00000000}},	//   mían_, poge, _avo_,
  { {0x386d00d1,0x29dc006d,0x79820051,0x00000000}},	//   _trer_, lían_, cjow,
  { {0x7d1d1130,0x93790021,0x7d01013d,0x00000000}},	//   _mess, مصدر_, _záró,
  { {0x29dc02dd,0x79890173,0x645b00ac,0x00000000}},	//   nían_, _hoew, rwui,
  { {0x442616d2,0x7d040051,0x0322000d,0x00000000}},	//   _evo_, ycis, эдэн,
  { {0x7d1d16d3,0xe610007e,0xc19a0054,0x00000000}},	//   _ness, _ششم_, стої_,
  { {0xb4fa0063,0x764b0006,0x3076005e,0x00000000}},	//   _הפני, žnyč, чунс,
  { {0x6dac0058,0x798916d4,0x0ef90085,0x00000000}},	//   rşam, _loew, жэты_,
  { {0x29dc02dd,0x7d1d16d5,0x661c00b9,0x00000000}},	//   dían_, _bess, _ærkt,
  { {0xb8830e28,0x91e3005a,0x7c240218,0x00000000}},	//   _klíč, _поще, tsir,
  { {0xe319008b,0x7d0416d6,0x7d1d16d7,0x00000000}},	// [1f60] _điể, rcis, _dess,
  { {0x29dc006d,0x7c2416d8,0xa01b0072,0x00000000}},	//   gían_, rsir, pyör,
  { {0xafdb0146,0x4efb0063,0xc3320063,0x00000000}},	//   ktøj, _להיו, תוב_,
  { {0xfbc90063,0x7d1d13f4,0x7d01013d,0x00000000}},	//   את_, _gess, _váró,
  { {0x29dc02dd,0x61e40139,0xafdb01e1,0x00000000}},	//   bían_, _mhil, dtøj,
  { {0x29dc02dd,0x60d600fe,0xc7a316d9,0x00000000}},	//   cían_, _myym, ничк,
  { {0x4426007a,0x4e7a00b5,0xdb1e16da,0x00000000}},	//   _svo_, מאַצ, ropä,
  { {0x798900ac,0x2abb0063,0x442616db,0x00000000}},	//   _goew, _המלא, _pvo_,
  { {0xa5070001,0x18a30121,0x86c6005d,0x00000000}},	//   чења_, _затм, _کيان,
  { {0xe44f0032,0x389b0063,0x6f1e007d,0x00000000}},	//   اضي_, _הימנ, _nepc,
  { {0x7dda006f,0xa91d005f,0x60c416dc,0x00000000}},	//   eïsm, _alžy, _axim,
  { {0x44260026,0x61e40f15,0x867b0063,0x00000000}},	//   _tvo_, _chil, _לרבו,
  { {0xa91d027c,0x7d1d16dd,0x6d980014,0x00000000}},	//   _božj, _ress, _pían,
  { {0x6447003b,0x7a050078,0x7d1d16de,0x00000000}},	//   ăjit, _lėta, _sess,
  { {0x7d1d16df,0x29dc02dd,0x61e40025,0x00000000}},	//   _pess, vían_, _fhil,
  { {0x61e4000c,0xbcfb1554,0x5d6416e0,0x00000000}},	//   _ghil, _gaél, нтуз,
  { {0x29dc006d,0x7d1d16e1,0x6ecd0053,0x00000000}},	// [1f70] tían_, _vess, _दुरु,
  { {0x7e6100b9,0x798916e2,0x7d1d16e3,0x00000000}},	//   ælps, _soew, _wess,
  { {0x29dc02dd,0x7d1d16e4,0xbb840021,0x00000000}},	//   rían_, _tess, علمي,
  { {0x29dc0046,0x6f1e0022,0xbcfb013d,0x00000000}},	//   sían_, _zepc, _lnéz,
  { {0xa3cc0082,0x00000000,0x00000000,0x00000000}},	//   लवा_,   ,   ,
  { {0x6d4d00ca,0x212216e5,0x2d8b0130,0x00000000}},	//   lfaa, zakh_, _hoce_,
  { {0x79890122,0x6b830026,0xc7c8000d,0x00000000}},	//   _toew, öngu, чыце_,
  { {0x6d4d06a7,0x24090076,0x75d50044,0x00000000}},	//   nfaa, онии_, بيعا,
  { {0x29000024,0xafdb00b9,0xa834005e,0x00000000}},	//   žiac_, rtøj, _петљ,
  { {0x9f530003,0x69d916e6,0xeb9f01e1,0x00000000}},	//   _fixé_, llwe, _støj_,
  { {0x672306bb,0x6f1e00c2,0x61e40136,0x00000000}},	//   manj, _repc, _phil,
  { {0xa5c6007a,0x672316e7,0x27ff0072,0x00000000}},	//   rkóð, lanj, _kuun_,
  { {0x291f00cd,0xa5c60026,0x21a30121,0x00000000}},	//   _meua_, skóð, тиям,
  { {0x61e40034,0x27ff00fe,0x98b20051,0x00000000}},	//   _whil, _muun_, żyć_,
  { {0x644916e8,0xa01b0050,0x00000000,0x00000000}},	//   ltei, syöp,   ,
  { {0xf2d211b4,0x6449001c,0x672316e9,0x00000000}},	//   _שעה_, otei, hanj,
  { {0x67231312,0xbfc606be,0xab66000d,0x00000000}},	// [1f80] kanj, _обик, мвал,
  { {0x672316ea,0x68fb16eb,0xd9b80053,0x00000000}},	//   janj, _agud, ेक्ट,
  { {0x236700c3,0x64490d9e,0x67230add,0x00000000}},	//   _manj_, htei, danj,
  { {0x3a3a10b9,0x2d8b0e06,0xdcfd0022,0x00000000}},	//   rupp_, _goce_, _posą,
  { {0x2603048e,0xdb0e007a,0xdcb90076,0x00000000}},	//   _año_, þjón, _ещё_,
  { {0x69d900e8,0x236700c3,0x31bb0053,0x00000000}},	//   alwe, _nanj_, _उद्ध,
  { {0xc34e0013,0x88bd0051,0x644916ec,0x00000000}},	//   _bổng_, _odśw, etei,
  { {0xc34e008b,0x6449004d,0x3e48004d,0x00000000}},	//   _cổng_, ftei, ißt_,
  { {0x672316ed,0x3f980014,0x6e3c0058,0x00000000}},	//   banj, kkru_, hurb,
  { {0x6723074f,0xdb050058,0x68fb003b,0x00000000}},	//   canj, rihç, _zgud,
  { {0x7d1600ac,0x644916ee,0xa29401dd,0x00000000}},	//   kbys, atei, хані,
  { {0x6e3c0026,0x6449004d,0x9293000d,0x00000000}},	//   durb, btei, таюц,
  { {0x14e20161,0x2d8b0080,0x64490268,0x00000000}},	//   _परिण, _roce_, ctei,
  { {0x61ee0024,0x6e3c00e5,0x7052005d,0x00000000}},	//   _ďale, furb, اچيا,
  { {0x518716ef,0x69d9002b,0xfbbf0042,0x00000000}},	//   _жупа, ylwe, ्वसम,
  { {0x6723074f,0x236700c2,0xa2ad0082,0x00000000}},	//   zanj, _zanj_, ुपर्,
  { {0x2d8b104f,0xf1bf14c0,0xb6010046,0x00000000}},	// [1f90] _voce_, mná_, _þáve,
  { {0x291f0268,0x7f5c0268,0x3f150062,0x00000000}},	//   _seua_, cerq, _ядос,
  { {0x672316f0,0x6449008f,0xf1bf00be,0x00000000}},	//   vanj, ztei, oná_,
  { {0x672305b3,0xead80054,0xf1bf16f1,0x00000000}},	//   wanj, ємці_, nná_,
  { {0x6723055e,0x6449017d,0xd8b800f2,0x00000000}},	//   tanj, xtei, ودها_,
  { {0xf7710032,0xa3dd0053,0xe8f816f2,0x00000000}},	//   طات_, _थीं_, флі_,
  { {0xe9190086,0x291f00cd,0x672316f3,0x00000000}},	//   _нові_, _teua_, ranj,
  { {0x672316f4,0x644916f5,0xf1bf0114,0x00000000}},	//   sanj, ttei, jná_,
  { {0xf1bf0114,0x644916f6,0xe4560085,0x00000000}},	//   dná_, utei, ежы_,
  { {0x43740086,0x644916f7,0x656916f8,0x00000000}},	//   вуют, rtei, sdeh,
  { {0xc34e001b,0xb345017d,0x236700c2,0x00000000}},	//   _tổng_, _acçã, _vanj_,
  { {0x0efa0394,0x644916f9,0xa91d07b4,0x00000000}},	//   ्ड्स_, ptei, _boži,
  { {0x25bf000c,0x66010019,0x4395000d,0x00000000}},	//   mnul_, _hulk, _падс,
  { {0x2d8f0c38,0x660116fa,0xb4640636,0x00000000}},	//   ögen_, _kulk, _шкіл,
  { {0x6601024a,0xf1bf0240,0x25bf003b,0x00000000}},	//   _julk, bná_, onul_,
  { {0xf1bf0114,0xdb0e0b6c,0xac0a0002,0x00000000}},	//   cná_, _imbé, знаа_,
  { {0x45da00b5,0x81bd001c,0xdca316fb,0x00000000}},	// [1fa0] פֿלא, ksēj, гати,
  { {0x7d160185,0xa3c10053,0x6721065c,0x00000000}},	//   sbys, ्कि_, _nelj,
  { {0xdb1c0051,0xa91d00c2,0x25bf004c,0x00000000}},	//   _skró, _zoži, knul_,
  { {0x08c6000a,0xb8660021,0x6da60086,0x00000000}},	//   нбен, فاتو, _чима,
  { {0x672100b2,0xa3c10053,0x69c30003,0x00000000}},	//   _belj, ्का_, énea,
  { {0xd7ef0032,0xe66600d7,0x672100c2,0x00000000}},	//   مكن_, етио, _celj,
  { {0x6721082a,0xdb1c0051,0xfbc30076,0x00000000}},	//   _delj, _wkró, _сбро,
  { {0x25bf003b,0xa96716fc,0x660116fd,0x00000000}},	//   gnul_, _писа_, _dulk,
  { {0xe73a000a,0x9f4a00cd,0xf1bf027d,0x00000000}},	//   _неа_, ambé_, vná_,
  { {0x25bf003b,0x42740086,0xa91d16fe,0x00000000}},	//   anul_, вгос, _roži,
  { {0x3636007e,0xf1bf0a63,0xa91d00a8,0x00000000}},	//   _سراس, tná_, _soži,
  { {0xa91d16ff,0x67210b59,0xf484005d,0x00000000}},	//   _poži, _zelj, _لاتی,
  { {0x557700b5,0x66011700,0x4fc70062,0x00000000}},	//   _רעדן_, _zulk, есва,
  { {0xf1bf004a,0xe47b00ff,0x54970085,0x00000000}},	//   sná_, _מרדכ, _явіў_,
  { {0xade70062,0xf1bf16f1,0x7d090044,0x00000000}},	//   ецак, pná_, ِيرِ_,
  { {0xcdd80001,0xa91d00c2,0xdce60058,0x00000000}},	//   ењу_, _toži, _alkı,
  { {0x41c4013a,0x00000000,0x00000000,0x00000000}},	// [1fb0] _حقيق,   ,   ,
  { {0x09c90082,0xd9c90082,0xf411009d,0x00000000}},	//   िक्य, िक्ट, ׁ֤ב_,
  { {0x7cea013d,0x67211701,0x29120058,0x00000000}},	//   töré, _relj, ıyan_,
  { {0xd2b70063,0xc9841702,0xdd160066,0x00000000}},	//   עלאת_, лучи, _päťd,
  { {0x66011703,0x09040086,0x395d00e5,0x00000000}},	//   _sulk, упін, rews_,
  { {0xd7f8005e,0xb17b0137,0x66011704,0x00000000}},	//   нуј_, llåd, _pulk,
  { {0xbbbf0161,0x3666005a,0x19ab1705,0x00000000}},	//   ्वीक, ващо_, _етап_,
  { {0x25bf003b,0xdcfd0022,0x66011706,0x00000000}},	//   unul_, _posę, _vulk,
  { {0x9f530994,0x25bf000c,0x67211707,0x00000000}},	//   _així_, rnul_, _telj,
  { {0xe2990001,0x25bf1708,0x66011709,0x00000000}},	//   дао_, snul_, _tulk,
  { {0xb2f40076,0xb4e200cd,0x5282000d,0x00000000}},	//   ляющ, çàri, агэб,
  { {0x7afa0026,0x6dac003b,0x2d8f004d,0x00000000}},	//   _útte, nşat, ögel_,
  { {0x2ca9007d,0xd4690131,0xd00f0044,0x00000000}},	//   jzad_, _циле_, يلَ_,
  { {0x656b018d,0xf70e0013,0xdb1e0058,0x00000000}},	//   _hagh, hủng_, üyüy,
  { {0x443f0f3f,0xb17b01e1,0x7e23007b,0x00000000}},	//   luu_, flåd, идрж,
  { {0x3f850026,0xfce6170a,0x91fc008f,0x00000000}},	//   ölur_, вобо, rvāt,
  { {0x656b170b,0x443f0729,0x6f02003b,0x00000000}},	// [1fc0] _magh, nuu_, _şocu,
  { {0xb17b0031,0x91fc001c,0x656b170c,0x00000000}},	//   småt, mvār, _lagh,
  { {0x6a86011c,0x628700fe,0x2ca9007d,0x00000000}},	//   ължа, äjoh, azad_,
  { {0x656b00bb,0x64590186,0xafdb00b9,0x00000000}},	//   _nagh, _opwi, ruøe,
  { {0x91fc001c,0x443f170d,0x68430121,0x00000000}},	//   nvār, juu_, инца,
  { {0x244b01e1,0xeb9f05a5,0x6d44170e,0x00000000}},	//   døm_, _støv_, lgia,
  { {0xacbb0003,0x6d44004b,0x656b170f,0x00000000}},	//   _jeûn, ogia, _bagh,
  { {0x7ae300ea,0x6d441710,0xd5b70766,0x00000000}},	//   ünte, ngia, ксы_,
  { {0x91fc001c,0xa766005e,0x80e10042,0x00000000}},	//   jvār, _икад, _नरें,
  { {0x96b6005e,0x00000000,0x00000000,0x00000000}},	//   _исељ,   ,   ,
  { {0x3263005a,0xc7d70063,0xbb3b0063,0x00000000}},	//   атяв, _יומי_, ועיי,
  { {0x69c2001f,0xc05b0054,0x00000000,0x00000000}},	//   nnoe, міг_,   ,
  { {0x91fc003d,0x20840021,0x64a3014a,0x00000000}},	//   gvār, للَّ, _каца,
  { {0x64401711,0x4fc40a91,0x6d441712,0x00000000}},	//   mumi, асса, egia,
  { {0x75e5000f,0x7c3a001c,0xa3c10053,0x00000000}},	//   lóza, _ātra, ्कर_,
  { {0x6d4402f6,0x64400003,0x65601713,0x00000000}},	//   ggia, oumi, nemh,
  { {0x64401714,0x69c202f7,0x5c7505ac,0x00000000}},	// [1fd0] numi, dnoe, ылат,
  { {0x6d4400f3,0x765a0045,0x5b140086,0x00000000}},	//   agia, _opty, имут,
  { {0x63af00cd,0x5a350699,0x64401715,0x00000000}},	//   ècni, унет, humi,
  { {0x64401716,0x09d4000d,0x69c2002b,0x00000000}},	//   kumi, аціў, gnoe,
  { {0x6440003d,0x28f80086,0x7d0d1717,0x00000000}},	//   jumi, вець_, mcas,
  { {0x656b0025,0xb605016b,0x60da0047,0x00000000}},	//   _sagh, hláš, ײַנג,
  { {0x656b0273,0xc6a7005a,0x45d505fb,0x00000000}},	//   _pagh, ърди, лцит,
  { {0x4efc014e,0x443f00fe,0xa91d007d,0x00000000}},	//   ולוג, tuu_, _požu,
  { {0x656b0290,0x64401718,0x7c2d1719,0x00000000}},	//   _vagh, gumi, nsar,
  { {0xa774000a,0x8c1a0063,0x244b01f2,0x00000000}},	//   _клуч, עותי, røm_,
  { {0x6d44171a,0xb6070062,0x656b0f20,0x00000000}},	//   ygia, _рязк, _tagh,
  { {0xa1360021,0x443f021e,0x7c2d171b,0x00000000}},	//   دردش, puu_, ksar,
  { {0x7c2d00c7,0xad9b017d,0x645c003b,0x00000000}},	//   jsar, _miúd, ăric,
  { {0xafdb00d1,0x442d171c,0xe46a0014,0x00000000}},	//   dtøs, mse_, sröð_,
  { {0x442d171d,0x7c2d171e,0xed5a0811,0x00000000}},	//   lse_, esar, нов_,
  { {0x442d0498,0x69c300ea,0x6d440078,0x00000000}},	//   ose_, énel, ugia,
  { {0x6d44171f,0x442d1720,0x7c2d1721,0x00000000}},	// [1fe0] rgia, nse_, gsar,
  { {0x442d1722,0x6d440322,0x2bba0021,0x00000000}},	//   ise_, sgia, راءة_,
  { {0xb17b0146,0x8ad50088,0x442d0375,0x00000000}},	//   slåe, аюцц, hse_,
  { {0x442d1723,0xafdb0031,0xeb9f069f,0x00000000}},	//   kse_, støt, _støt_,
  { {0x69c20162,0x442d1724,0x64e20053,0x00000000}},	//   rnoe, jse_, _परेश,
  { {0x38cb006a,0x6440001c,0x69c20104,0x00000000}},	//   رانی_, vumi, snoe,
  { {0x4994007e,0x442d015e,0x7f3b0047,0x00000000}},	//   _پیشر, ese_, געצו,
  { {0x64401725,0xad9b0025,0x442d1726,0x00000000}},	//   tumi, _giúd, fse_,
  { {0xd3260928,0xb9930021,0x48e3065b,0x00000000}},	//   льни, _القب, _готв,
  { {0x64401727,0x53340856,0x39461728,0x00000000}},	//   rumi, јент, lgos_,
  { {0x66e60076,0x442d1729,0x7c2d001c,0x00000000}},	//   _сожа, ase_, zsar,
  { {0x3946172a,0x7c2d172b,0x6440172c,0x00000000}},	//   ngos_, ysar, pumi,
  { {0xc5f3014e,0x39460006,0x88bd0051,0x00000000}},	//   _הדף_, igos_, _leśn,
  { {0xa91d172d,0x7d0d172e,0x1fa7005e,0x00000000}},	//   _inže, wcas, урмг,
  { {0x7d0d00e5,0x7c2d0c5f,0x99780078,0x00000000}},	//   tcas, wsar, nčų_,
  { {0x7c870086,0x27ec0089,0x63ba172f,0x00000000}},	//   лузе, _lhdn_, litn,
  { {0x69c30164,0xdfd10021,0x200400cd,0x00000000}},	// [1ff0] énem, _ويب_, ímit_,
  { {0x3946006d,0x7c2d1730,0x212b1731,0x00000000}},	//   egos_, rsar, lach_,
  { {0x7c2d1732,0x61ed13dc,0x442d0779,0x00000000}},	//   ssar, _khal, zse_,
  { {0x212b1733,0x32350047,0x7c2d1734,0x00000000}},	//   nach_, שטײן_, psar,
  { {0x3949003d,0x63ba1735,0x61ed0025,0x00000000}},	//   ļas_, kitn, _mhal,
  { {0x212b0027,0x442d0019,0xb6590cb5,0x00000000}},	//   hach_, vse_, вших_,
  { {0x69ca0003,0x16a61736,0x212b1737,0x00000000}},	//   éfec, ивши_, kach_,
  { {0x212b0051,0x629a1738,0x442d1739,0x00000000}},	//   jach_, dyto, tse_,
  { {0x212b173a,0x442d04bc,0x291d0035,0x00000000}},	//   dach_, use_, mbwa_,
  { {0x442d173b,0x92f50086,0x63ba173c,0x00000000}},	//   rse_, ичні, gitn,
  { {0x61ed0025,0x442d173d,0xa2e5173e,0x00000000}},	//   _bhal, sse_, ронд,
  { {0x61ed031d,0x7643017e,0x63ba0139,0x00000000}},	//   _chal, muny, aitn,
  { {0xd83e034d,0x7643173f,0xc5f20063,0x00000000}},	//   _účte_, luny, _ודא_,
  { {0x3946006d,0x629a1740,0x63ba04a8,0x00000000}},	//   zgos_, byto, citn,
  { {0xc7b20063,0x39460006,0x7db60d64,0x00000000}},	//   קבל_, ygos_, асац,
  { {0x3d200161,0x7bc50016,0x4ad90053,0x00000000}},	//   बरें_, enhu, _बुधव,

  { {0x8b260076,0xac071741,0xafdb069f,0x00000000}},	// [2000] идае, инта_, rtør,
  { {0xafdb07e6,0x76431742,0x109b0063,0x00000000}},	//   stør, kuny, _סביב,
  { {0x32070268,0x7f3b0063,0x7dda00cd,0x00000000}},	//   _juny_, _בעיו, uïss,
  { {0x394600eb,0x26de0078,0x8c461743,0x00000000}},	//   ugos_, _ryto_, _кеме,
  { {0x394612d1,0x8eb3007e,0x629a0051,0x00000000}},	//   rgos_, _همیش, zyto,
  { {0x81bd003d,0x39461143,0x57b30086,0x00000000}},	//   lsēt, sgos_, обіт,
  { {0xd7190086,0x212b002b,0x76431744,0x00000000}},	//   уючі_, yach_, guny,
  { {0xe5c60259,0x0d960063,0x81bd008f,0x00000000}},	//   јско, יכֶם_, nsēt,
  { {0x88bd0045,0x2fd800c7,0xf746005e,0x00000000}},	//   _jeśl, korg_, _везо,
  { {0x61ed1745,0x26de0080,0x212b0051,0x00000000}},	//   _shal, _tyto_, wach_,
  { {0x81bd001c,0x63ba1746,0x212b1747,0x00000000}},	//   ksēt, ritn, tach_,
  { {0x29dc006d,0x629a1748,0x3d200053,0x00000000}},	//   mías_, ryto, बरों_,
  { {0x29dc006d,0x67280137,0x7bdc1749,0x00000000}},	//   lías_, _kedj, _okru,
  { {0x644f0994,0x61ed174a,0xd83f0114,0x00000000}},	//   àcie, _whal, _účet_,
  { {0x29dc02dd,0x6728074f,0x212b174b,0x00000000}},	//   nías_, _medj, pach_,
  { {0xdce6001c,0x02fb0149,0xaada0042,0x00000000}},	//   _sakā, _בלומ, _भड़क,
  { {0xdce6001c,0x1df80121,0x50b8007e,0x00000000}},	// [2010] _pakā, реты_, _پديد_,
  { {0x69db05dd,0x76430089,0x67281186,0x00000000}},	//   _skue, yuny, _nedj,
  { {0x7ff400b3,0x29dc0331,0x6ff40044,0x00000000}},	//   _بسيا, jías_, _بسيط,
  { {0x29dc006d,0x785a0023,0x6a14014b,0x00000000}},	//   días_, kāvā, імчу,
  { {0x68e00185,0x75c8004c,0xf84b0121,0x00000000}},	//   _cymd, tězn, тчей_,
  { {0x785a003d,0x29dc02dd,0x7643003e,0x00000000}},	//   dāvā, fías_, tuny,
  { {0x29dc02dd,0xf7700242,0x68e00046,0x00000000}},	//   gías_, بان_, _eymd,
  { {0x9f960026,0x2fd8006f,0x645c003b,0x00000000}},	//   hæð_, zorg_, ărin,
  { {0x68e0001f,0x69d90051,0x24520021,0x00000000}},	//   _gymd, mowe, كنيس,
  { {0x29dc048e,0x7643053b,0x69d90886,0x00000000}},	//   bías_, puny, lowe,
  { {0x29dc02dd,0xd575000d,0x6b9503c7,0x00000000}},	//   cías_, _гуль, _mozg,
  { {0x69d90051,0xdcfd005f,0x13a7005d,0x00000000}},	//   nowe, _ansč, انگی_,
  { {0xd24e006a,0x20090089,0x2fd80026,0x00000000}},	//   ونی_, _cuai_, torg_,
  { {0x443f0c70,0x386d002b,0x40950054,0x00000000}},	//   mru_, _mser_, ірят,
  { {0x69d90051,0xafdb00d1,0x236502f7,0x00000000}},	//   kowe, frøb, melj_,
  { {0xdced034d,0x29000006,0x69d90051,0x00000000}},	//   adač, žiai_, jowe,
  { {0x2009174c,0xc5f20047,0x69d9174d,0x00000000}},	// [2020] _guai_, לדל_, dowe,
  { {0x68e000c7,0x443f174e,0x3f9e004b,0x00000000}},	//   _rymd, iru_, ötud_,
  { {0x49060032,0x443f174f,0x6728130e,0x00000000}},	//   مواق, hru_, _redj,
  { {0x7053006a,0x5d860021,0x29dc006d,0x00000000}},	//   _بنیا, _الحل, vías_,
  { {0xa85600d7,0x783a0259,0x236500c2,0x00000000}},	//   стеј, уџет_, kelj_,
  { {0x29dc006d,0x0f7a0047,0x3f7a0041,0x00000000}},	//   tías_, ראַב, ראַס,
  { {0x9f52006d,0x386d092a,0x69d90ac3,0x00000000}},	//   _huyó_, _eser_, bowe,
  { {0x29dc02dd,0x76a90086,0x2904002c,0x00000000}},	//   rías_, штів_, _ugma_,
  { {0x29dc0118,0x443f1750,0x7a050078,0x00000000}},	//   sías_, gru_, _dėtu,
  { {0x29dc006d,0x21290089,0xa3b40054,0x00000000}},	//   pías_, _seah_, ібні,
  { {0x22580076,0x20090089,0x443f1751,0x00000000}},	//   шины_, _suai_, aru_,
  { {0x443f1752,0x2001004b,0x60f9012c,0x00000000}},	//   bru_, _sihi_, иння_,
  { {0x443f0529,0x236500c2,0x20091753,0x00000000}},	//   cru_, belj_, _quai_,
  { {0x33f60fe2,0x4fc70076,0x69d90051,0x00000000}},	//   _учес, ссма, zowe,
  { {0x69d90035,0x6b950051,0xee84007f,0x00000000}},	//   yowe, _rozg, пыто,
  { {0xd131006a,0x64401754,0xbd191755,0x00000000}},	//   _کمک_, ormi, ржах_,
  { {0xd011007e,0x7c870002,0xdd9405ac,0x00000000}},	// [2030] _تلخ_, љубе, чаты,
  { {0x6ac40161,0x69d90051,0x69ca0003,0x00000000}},	//   वपूर, wowe, éfen,
  { {0x69d91756,0xdd95000d,0x6440004d,0x00000000}},	//   towe, _даны, hrmi,
  { {0x8819000d,0x195902dc,0x443f1757,0x00000000}},	//   аўку_, рады_, yru_,
  { {0xf09f0268,0x684501dd,0xdd310022,0x00000000}},	//   nyà_, інка, _mężo,
  { {0x645c0529,0x69d91758,0x443f1759,0x00000000}},	//   ăril, sowe, vru_,
  { {0x8698005a,0x69d9175a,0x753d013d,0x00000000}},	//   йтът_, powe, ószo,
  { {0x443f175b,0x84591133,0xe6280021,0x00000000}},	//   tru_, арот_, حثون_,
  { {0x236506bb,0x386d0465,0xc7c8008b,0x00000000}},	//   telj_, _user_, uốc_,
  { {0x443f175c,0xdb0e0014,0x9f5a01a8,0x00000000}},	//   rru_, _embæ, _pipí_,
  { {0x6d5d0512,0x0166015a,0x6440175d,0x00000000}},	//   _obsa, окно, armi,
  { {0x7d020078,0x236500c2,0xf1bf175e,0x00000000}},	//   žosi, selj_, giá_,
  { {0x25bf003b,0xb17b0137,0x236500a8,0x00000000}},	//   miul_, plån, pelj_,
  { {0x6d4f175f,0x25bf000c,0x6d5d0832,0x00000000}},	//   _acca, liul_, _absa,
  { {0x1d0a0854,0x249f0058,0x44260244,0x00000000}},	//   иеви_, lyum_, _zwo_,
  { {0x25bf0529,0x0c2600d7,0xf1bf017d,0x00000000}},	//   niul_, жман, ciá_,
  { {0x249f1760,0x752b013d,0xfce311fd,0x00000000}},	// [2040] nyum_, _megz, дото,
  { {0x3dc900a4,0x25bf003b,0x248d00cd,0x00000000}},	//   anaw_, hiul_, ixem_,
  { {0xed5a0079,0x3dc900a4,0x75390022,0x00000000}},	//   _кон_, bnaw_, _odwz,
  { {0xe9da1321,0xad5a000d,0xba17005d,0x00000000}},	//   шке_, _трох_, زيها_,
  { {0x25bf000c,0x999c00ea,0x515b009d,0x00000000}},	//   diul_, évő_, שכנו,
  { {0x907b0063,0x207b0047,0x3869017d,0x00000000}},	//   יטני, יאנא, çara_,
  { {0x645c003b,0x61e60023,0xbcfb009c,0x00000000}},	//   ărim, klkl, _ebéd,
  { {0xdb07007a,0x25bf003b,0x7e9b0047,0x00000000}},	//   ámör, giul_, יסצו,
  { {0xf1bf017d,0x938a0789,0xa73a005d,0x00000000}},	//   viá_, асна_, _نثار_,
  { {0x7c29005b,0x25ad004b,0x442600ca,0x00000000}},	//   _çere, ahel_, _vwo_,
  { {0x25bf1761,0xcb130063,0x66100022,0x00000000}},	//   biul_, ולת_, ójką,
  { {0x44260034,0xb606017f,0x25bf000c,0x00000000}},	//   _two_, rišć, ciul_,
  { {0xf1bf0024,0xcf9b0092,0x8f0b0094,0x00000000}},	//   riá_, ајв_, ихва_,
  { {0x4374006a,0x4ea70899,0x33730054,0x00000000}},	//   _رهبر, орба, _огір,
  { {0x3ea500ea,0xd13b0085,0x98ad056c,0x00000000}},	//   ált_, _кхп_, _ideą_,
  { {0x321e0783,0x3dc9002b,0xdb0d009c,0x00000000}},	//   mpty_, unaw_, űkül,
  { {0x030e0053,0xc19c0063,0xf19c009a,0x00000000}},	// [2050] _सलाह_, _כשהי, _כשהש,
  { {0x673a00b9,0xda7b0062,0xee87007f,0x00000000}},	//   _ndtj, ияе_, _дымо,
  { {0xf0b8007e,0x9ff80044,0x00000000,0x00000000}},	//   _هایش_, _بريء_,   ,
  { {0x2ca01762,0x7aed008f,0x00000000,0x00000000}},	//   byid_, _ģitā,   ,
  { {0xb17c0047,0x98f4000d,0xdcef0006,0x00000000}},	//   יטאר, мяшч, _įdėk,
  { {0x6cfa0063,0x7b640fec,0x6d4d0d46,0x00000000}},	//   _לפרס, _отсе, lgaa,
  { {0x67ed00ea,0x2d991763,0x25ad1764,0x00000000}},	//   gúja, _kose_, thel_,
  { {0x6d4d1765,0x2d9908cd,0x391515ce,0x00000000}},	//   ngaa, _jose_, _хмар,
  { {0x25bf000c,0xd877007e,0x69cb0137,0x00000000}},	//   riul_, _بازب, mnge,
  { {0x2d990780,0x752b030c,0x249f1766,0x00000000}},	//   _lose_, _wegz, ryum_,
  { {0x69cb1767,0x95cb0cb5,0x25bf003b,0x00000000}},	//   onge, _куда_, piul_,
  { {0x2d9903bd,0xa06a005e,0x6d4d00ca,0x00000000}},	//   _nose_, бама_, jgaa,
  { {0x69cb1768,0x26110013,0x920b0042,0x00000000}},	//   inge, _háo_, _सूरज_,
  { {0x7bcb0003,0x69cb004d,0xa4fa0063,0x00000000}},	//   égul, hnge, _פלסט,
  { {0x6d4d0162,0x64491769,0x395f0003,0x00000000}},	//   fgaa, luei, _obus_,
  { {0x2d99051e,0x6d4d176a,0x395f00ac,0x00000000}},	//   _cose_, ggaa, _nbus_,
  { {0x644900cd,0x26110013,0x2d99176b,0x00000000}},	// [2060] nuei, _láo_, _dose_,
  { {0x6d4d1761,0x69cb1742,0x2d8f01bb,0x00000000}},	//   agaa, enge, öger_,
  { {0x2ca00397,0x4f9b0063,0xbf9b0063,0x00000000}},	//   syid_, _הביצ, _הייש,
  { {0x5f46005d,0xd23a0041,0xb5f90085,0x00000000}},	//   _بنگل, מגעל, _кнiг,
  { {0x3f9a001c,0x7643176c,0x98a30071,0x00000000}},	//   _kopu_, erny, нице,
  { {0x2611001b,0x64490268,0xdb1e00cd,0x00000000}},	//   _báo_, duei, xipè,
  { {0x261100aa,0xe5c60062,0xdbc7021e,0x00000000}},	//   _cáo_, зспо, töös,
  { {0x69c300ea,0x94180121,0x3f9a0050,0x00000000}},	//   énet, ожит_, _lopu_,
  { {0xdce40006,0x6449176d,0x27f10078,0x00000000}},	//   keič, guei, _šonų_,
  { {0x673a00b9,0xdc9b0047,0xdbc70072,0x00000000}},	//   _udtj, צייל, söös,
  { {0xe4d6007e,0xf7730063,0x65870014,0x00000000}},	//   _کتاب, _רקע_, érhæ,
  { {0x92570076,0x64490268,0xafdb000e,0x00000000}},	//   чают_, buei, grøn,
  { {0x644903b2,0x7bde00fe,0xad9b0025,0x00000000}},	//   cuei, kopu, _diúl,
  { {0x22590051,0x7c3600ac,0x6f150022,0x00000000}},	//   ńska_, dsyr, uczc,
  { {0xdb1e0027,0x6d4d166f,0x3da7000d,0x00000000}},	//   cipé, tgaa, праб,
  { {0x91e40001,0x91720013,0xdd170082,0x00000000}},	//   _поје, rợ_, धुंध_,
  { {0x6d4d176e,0x113c0063,0x69c2176f,0x00000000}},	// [2070] rgaa, _התחל, dioe,
  { {0x7bde1770,0x6d4d1771,0x2bbb0044,0x00000000}},	//   gopu, sgaa, حارة_,
  { {0x2cbf0066,0x6d4d00ca,0xcb080044,0x00000000}},	//   _ľudu_, pgaa, أيمن_,
  { {0x69cb1772,0xdb1e00fe,0x69c2006f,0x00000000}},	//   unge, enpä, gioe,
  { {0xe72e0054,0x26110013,0x320e0022,0x00000000}},	//   ке_, _sáo_, _lufy_,
  { {0xdb23007e,0x69da017d,0x7bde11ad,0x00000000}},	//   _سوری, _íten, copu,
  { {0xe9190054,0xe73001fb,0x7d0200a8,0x00000000}},	//   _мові_, اصه_, žost,
  { {0x64491773,0x69c21774,0x49b8014d,0x00000000}},	//   tuei, cioe, _فاقد_,
  { {0x29000066,0xa3b90044,0x87070044,0x00000000}},	//   žiar_, قادر_, _فبال,
  { {0xe2a2001b,0x799b04a1,0x26110013,0x00000000}},	//   _thử_, _houw, _táo_,
  { {0xf6550002,0x6dac0058,0xd6270049,0x00000000}},	//   _цвеќ, aşay, _رعاي,
  { {0x799b00f5,0xdb1e1775,0xf8a70044,0x00000000}},	//   _jouw, ripé, نة_,
  { {0x644913a3,0x29360047,0x7bde0035,0x00000000}},	//   quei, וארן_, yopu,
  { {0xa7fd013d,0x03950085,0xb4fa009a,0x00000000}},	//   _zsűr, _ірля, _ופני,
  { {0x5de6000d,0x0ef9000d,0xdce40078,0x00000000}},	//   джва, зэты_, reič,
  { {0x69bf0053,0x7c360046,0xcd36005d,0x00000000}},	//   लोमी, tsyr, برآب,
  { {0xa5c60026,0x61e41776,0x7bde1777,0x00000000}},	// [2080] ljóð, _ikil, topu,
  { {0x78a20035,0xafdb00d1,0x7c361778,0x00000000}},	//   vyov, ktøy, rsyr,
  { {0x799b0122,0x7bde1779,0x7c3a001c,0x00000000}},	//   _bouw, ropu, _ātru,
  { {0x08c60cf7,0x986c017c,0xfbc90aeb,0x00000000}},	//   мбен, _vôľa_, בת_,
  { {0x644f00cd,0x7bde177a,0x69c2002b,0x00000000}},	//   àcil, popu, rioe,
  { {0x7a0c0529,0x69c2177b,0x69c311fa,0x00000000}},	//   _aşte, sioe, éner,
  { {0x6b9c177c,0x69c200ca,0x66e301ce,0x00000000}},	//   _iorg, pioe, коља,
  { {0x799b006f,0x7989002b,0x6b9c013d,0x00000000}},	//   _gouw, _gnew, _horg,
  { {0x4c9b00b5,0x236a00d7,0x69c0177d,0x00000000}},	//   ַשטע, ојно_, _imme,
  { {0x6b9c177e,0x889b0063,0x61e4101f,0x00000000}},	//   _jorg, _ובמי, _akil,
  { {0xbcfb0025,0x6b9c050b,0x316b0051,0x00000000}},	//   _mbéa, _morg, tecz_,
  { {0x6b9c177f,0x61f61780,0xc693009a,0x00000000}},	//   _lorg, _chyl, _שאף_,
  { {0x6b9c0250,0xdb1c013d,0x9554005d,0x00000000}},	//   _oorg, _emré, _يخچا,
  { {0xe4c7007e,0x6b9c1781,0x61e40058,0x00000000}},	//   _تصمی, _norg, _ekil,
  { {0x2fc300ca,0x69c01782,0xa3cb0042,0x00000000}},	//   rijg_, _omme, रचर_,
  { {0xc5f8008f,0x31c4000d,0x00000000,0x00000000}},	//   _spēj_, _асьв,   ,
  { {0x6b9c1783,0x799b00ca,0xfc300044,0x00000000}},	// [2090] _borg, _rouw, لحل_,
  { {0x69c01784,0x21f20024,0xf092009a,0x00000000}},	//   _amme, máha_, _עני_,
  { {0xafdb00d1,0x61e40046,0x656201d1,0x00000000}},	//   nrøm, _ykil, _oboh,
  { {0x49b8007e,0x6b9c1785,0x6d4b0139,0x00000000}},	//   واند_, _eorg, ógad,
  { {0x6b9c0d11,0x799b00ca,0x2d8b1786,0x00000000}},	//   _forg, _vouw, _ince_,
  { {0xdce401f7,0xafdb00d1,0x7989001f,0x00000000}},	//   ldiğ, ttøy, _wnew,
  { {0x4ae40088,0x799b006f,0xdcfd0078,0x00000000}},	//   _аўта, _touw, _posė,
  { {0x6b9c1787,0xdce4005b,0xafdb01f2,0x00000000}},	//   _zorg, ndiğ, rtøy,
  { {0x44391788,0xeb9f00d1,0x6b9c0b42,0x00000000}},	//   és_, _støy_, _yorg,
  { {0x61e41789,0xafdb04aa,0x56670044,0x00000000}},	//   _skil, ptøy, _يداف,
  { {0x2d8b0037,0x98a4000c,0xd7940062,0x00000000}},	//   _once_, _temă_, _шифъ,
  { {0xa91d0078,0x22590051,0xe29a0013,0x00000000}},	//   _požy, ńsko_, _ngưu_,
  { {0x54a70044,0x2256005d,0x001a014b,0x00000000}},	//   _تحاف, ولید_, яўны_,
  { {0xdff50085,0x65620445,0xdce40075,0x00000000}},	//   вясь, _zboh, ediğ,
  { {0x645b178a,0x61f6178b,0x00000000,0x00000000}},	//   ltui, _thyl,   ,
  { {0x64460078,0x6b9c178c,0x657b178d,0x00000000}},	//   škie, _sorg, nduh,
  { {0x8b26000d,0xf390008b,0x6b9c178e,0x00000000}},	// [20a0] едзе, _mảnh_, _porg,
  { {0xda660021,0x69c30003,0x6abd0053,0x00000000}},	//   فاصي, ènen, ्पूर,
  { {0x6b9c0199,0x645b0ff2,0xfe72007e,0x00000000}},	//   _vorg, htui, _صدد_,
  { {0x645b178f,0xed5f0066,0x6b9c00a3,0x00000000}},	//   ktui, ížte_, _worg,
  { {0x645b006f,0x69da0857,0xd7e602fe,0x00000000}},	//   jtui, _ítem, ніко,
  { {0x7c241790,0x6b9c05e7,0x00000000,0x00000000}},	//   mpir, _uorg,   ,
  { {0x61fd007a,0x7c24104e,0x645b006f,0x00000000}},	//   ymsl, lpir, etui,
  { {0xf390001b,0x645b00ac,0xd5b71791,0x00000000}},	//   _cảnh_, ftui, есь_,
  { {0x7c2400a4,0xdce6001c,0x645b0983,0x00000000}},	//   npir, _nokļ, gtui,
  { {0xafdb06a5,0xdce40058,0xb8e60042,0x00000000}},	//   trøm, zdiğ, ॉप_,
  { {0xf8bf0ac6,0x6283017f,0x645b0466,0x00000000}},	//   _þér_, _crno, atui,
  { {0x645b00e8,0x6562004c,0x00000000,0x00000000}},	//   btui, _uboh,   ,
  { {0x53a6000d,0xdce40058,0xc0ab0044,0x00000000}},	//   _падб, vdiğ, ساحل_,
  { {0x7c2400c3,0x32940021,0x44f3000d,0x00000000}},	//   dpir, _للتأ, _спіс,
  { {0x777a0013,0x7bc51792,0x7c24008f,0x00000000}},	//   _matx, vihu, epir,
  { {0xa0c500de,0xbdf800de,0xf1bb009d,0x00000000}},	//   _ليعو, فرقا_, _מֶ֖ל,
  { {0xdce401f7,0xd164005a,0x7bc51793,0x00000000}},	// [20b0] rdiğ, _същи, tihu,
  { {0x657b1794,0xe1ff1795,0xa91d1796,0x00000000}},	//   zduh, lmó_, _inži,
  { {0xc3330063,0xdcef003b,0x7bc51797,0x00000000}},	//   רוע_, _bacă, rihu,
  { {0x00000000,0x00000000,0x00000000,0x00000000}},	//     ,   ,   ,
  { {0xed600080,0x777a00cd,0xf3900013,0x00000000}},	//   ížet_, _batx, _rảnh_,
  { {0x98a20a83,0x307c0149,0x7c2f002b,0x00000000}},	//   рише, פאונ, _iwcr,
  { {0xd9150088,0xafdb01e1,0x68e90022,0x00000000}},	//   _адбы, trøj, _wyed,
  { {0x645b1798,0xd6ce0021,0xdb1e00dd,0x00000000}},	//   ttui, تقى_, cipâ,
  { {0x75c80080,0x645b0072,0xa5f6005e,0x00000000}},	//   vězt, utui, њењу_,
  { {0x645b1799,0x43740054,0xd2a9030b,0x00000000}},	//   rtui, гуют, дкое_,
  { {0x645b179a,0xafdb01e1,0x3f9e0014,0x00000000}},	//   stui, prøj, ötum_,
  { {0xb6d80047,0x645b003b,0xcec4004c,0x00000000}},	//   _אַױט, ptui, hoří_,
  { {0x98a40006,0x7529179b,0x7c24179c,0x00000000}},	//   _temą_, mbez, xpir,
  { {0x64490ea7,0x645c003b,0x03a20141,0x00000000}},	//   mrei, ărit, _вишо,
  { {0x6449179d,0xd0070cb5,0x9f5300cd,0x00000000}},	//   lrei, тере_, _aixó_,
  { {0x661c000f,0xb6020026,0x7529050c,0x00000000}},	//   _érke, _þátt, nbez,
  { {0x973c017f,0x6449179e,0x4d630002,0x00000000}},	// [20c0] _hoće, nrei, јкув,
  { {0x4b230086,0x7c24179f,0x442f002b,0x00000000}},	//   имув, rpir, _mwg_,
  { {0x2d9e0164,0x3bd50076,0x644917a0,0x00000000}},	//   êtes_, уютс, hrei,
  { {0x644917a1,0x7c2412be,0xd94602d8,0x00000000}},	//   krei, ppir, теди,
  { {0x38cb007e,0x777a01a8,0x5cf50085,0x00000000}},	//   واهی_, _patx, _бяру,
  { {0xb17b01e3,0x644917a2,0x752917a3,0x00000000}},	//   llåt, drei, ebez,
  { {0x16370021,0xad9b0025,0x7bcb0003,0x00000000}},	//   نسية_, _siúi, ègue,
  { {0x5574026b,0xfa770063,0xadf80053,0x00000000}},	//   угит, _בעלת_, ंगटन_,
  { {0x4806000d,0xc7c8008b,0x644917a4,0x00000000}},	//   _апав, hối_, grei,
  { {0xafdb00b9,0x75c80080,0x752917a5,0x00000000}},	//   msøg, tězs, abez,
  { {0xafdb00b9,0xbcfb17a6,0x644917a7,0x00000000}},	//   lsøg, _abél, arei,
  { {0x673800c2,0x64490c00,0x442f002b,0x00000000}},	//   lavj, brei, _fwg_,
  { {0xe1ff02dd,0xafdb0146,0x644917a8,0x00000000}},	//   rmó_, nsøg, crei,
  { {0x9f530994,0x2618008b,0x533400fb,0x00000000}},	//   _això_, _kéo_, _сект,
  { {0x9f340086,0xcec40080,0xb17b00d1,0x00000000}},	//   ресі, voří_, flåt,
  { {0x26180013,0x63bd008f,0x248617a9,0x00000000}},	//   _méo_, īsne, _krom_,
  { {0x69c30164,0x6abd0053,0x261817aa,0x00000000}},	// [20d0] ènem, ्प्र, _léo_,
  { {0xafdb0146,0xdb0700ea,0x2d9e0003,0x00000000}},	//   dsøg, _aljá, êter_,
  { {0xafdb0146,0x26180003,0x5c040121,0x00000000}},	//   esøg, _néo_, рята,
  { {0xdd9517ab,0x3eac06a5,0xe9190086,0x00000000}},	//   _самы, ødte_, ході_,
  { {0xafdb0146,0x3944013c,0x764a002b,0x00000000}},	//   gsøg, рніг, erfy,
  { {0xdb0700ea,0x26180013,0x6838004c,0x00000000}},	//   _eljá, _béo_, _súdá,
  { {0x6449002b,0xcf940149,0xfc3f0014,0x00000000}},	//   wrei, יטס_, _hví_,
  { {0xafdb00b9,0x644917ac,0x248617ad,0x00000000}},	//   bsøg, trei, _brom_,
  { {0x752900e3,0x6738007d,0x248617ae,0x00000000}},	//   rbez, bavj, _crom_,
  { {0x7529050c,0x628100ca,0x248617af,0x00000000}},	//   sbez, tvlo, _drom_,
  { {0x644917b0,0xd1ca005e,0x248600ca,0x00000000}},	//   srei, елне_, _erom_,
  { {0x248603e9,0x64460006,0x645c000c,0x00000000}},	//   _from_, škia, ărir,
  { {0xf5390024,0x3fc8007e,0x2486147c,0x00000000}},	//   mať_, ندسی_, _grom_,
  { {0xf5390024,0x8e760299,0x00000000,0x00000000}},	//   lať_, лубч,   ,
  { {0xc7c8008b,0x213912a9,0x1eaa0c0a,0x00000000}},	//   uối_, bash_, راسي_,
  { {0xf5390024,0x25ad042b,0x213917b1,0x00000000}},	//   nať_, nkel_, cash_,
  { {0xb17b1310,0x3dd2002b,0x25ad00a8,0x00000000}},	// [20e0] rlåt, rnyw_, ikel_,
  { {0xb17b00d1,0x9f5e00fe,0xb346017d,0x00000000}},	//   slåt, ötä_, moçõ,
  { {0xf5390024,0x2ca9002c,0x53360047,0x00000000}},	//   kať_, ayad_, רנען_,
  { {0xf5390024,0xe9e50086,0xafdb00b9,0x00000000}},	//   jať_, аціо, tsøg,
  { {0xf5390024,0x07a617b2,0xc7c60794,0x00000000}},	//   dať_, ладн, лски,
  { {0xafdb010a,0x98a302d8,0x50db0041,0x00000000}},	//   rsøg, сиље, עקסא,
  { {0x673800c3,0xad9b017d,0xafdb00b9,0x00000000}},	//   ravj, _viúv, ssøg,
  { {0x442a0138,0x6d5600bb,0xafdb00b9,0x00000000}},	//   нцом_, ngya, psøg,
  { {0x6d56002c,0x61e617b3,0xa84a002a,0x00000000}},	//   igya, dokl, _سلام_,
  { {0x21f2004c,0x610c008f,0x21391098,0x00000000}},	//   sáhl_, _mēlī, wash_,
  { {0xf5390066,0x4422008f,0xe57900a3,0x00000000}},	//   bať_, ūk_, rlŷr_,
  { {0x24860025,0xf5390066,0xd9f60053,0x00000000}},	//   _trom_, cať_, ेषित_,
  { {0x2d8017b4,0x213917b5,0x439405e0,0x00000000}},	//   ddie_, rash_, _валс,
  { {0x14d70063,0x2a660051,0xad9b0139,0x00000000}},	//   _גודל_, łoby_, _liút,
  { {0xe3370047,0x5d67005e,0xe2460044,0x00000000}},	//   _גרופ_, лтаз, _إختي,
  { {0x7c290058,0x6d56013d,0x00000000,0x00000000}},	//   _çerk, ggya,   ,
  { {0xdfd5000d,0xd5b1008d,0x4c9405f4,0x00000000}},	// [20f0] _вопы, _húc_, битс,
  { {0xf5390024,0x91fd003d,0x6ee70032,0x00000000}},	//   zať_, stād, _مسجل,
  { {0x20d4007e,0x2ca9017e,0x25ad17b6,0x00000000}},	//   _نتیج, syad_, ykel_,
  { {0x7aee00b9,0xe9ce0636,0x3e41005f,0x00000000}},	//   _dybt, ік_, mėt_,
  { {0xf539061a,0xd5b1001b,0x3d3a0063,0x00000000}},	//   vať_, _lúc_, _בגרס,
  { {0x22590045,0xdd1c0006,0x98af003b,0x00000000}},	//   ński_, _iššo, eagă_,
  { {0xf5390024,0x25ad0019,0x83fd013d,0x00000000}},	//   tať_, tkel_, ntőe,
  { {0x1662000d,0xa44517b7,0x00000000,0x00000000}},	//   івым, анид,   ,
  { {0x9848011c,0xf5390024,0x644617b8,0x00000000}},	//   _бяха_, rať_, škin,
  { {0xf5390024,0x81bd001c,0xd265000d,0x00000000}},	//   sať_, spēl, акой,
  { {0x2249005a,0x25b000ea,0x27e70d17,0x00000000}},	//   ъпни_, álló_, monn_,
  { {0x69cb0199,0x61e60006,0x6aba005b,0x00000000}},	//   nige, uokl, _ütfe,
  { {0x6e250025,0x81bd001c,0x61e617b9,0x00000000}},	//   _athb, opēj, rokl,
  { {0x69cb00bd,0x6d4b0025,0x95a0003b,0x00000000}},	//   hige, ógan, ăşeş,
  { {0xa91d0512,0x6da60076,0x443f17ba,0x00000000}},	//   _každ, аива, lsu_,
  { {0x32da0063,0x63a317bb,0x973c007d,0x00000000}},	//   _שחקנ, _honn, _moća,
  { {0x2d8010e9,0x63a317bc,0xa91d17bd,0x00000000}},	// [2100] rdie_, _konn, _mažd,
  { {0xeab20021,0x69cb0b06,0xaec60054,0x00000000}},	//   يعا_, eige, _вбол,
  { {0x69cb17be,0x63a317bf,0x973c0130,0x00000000}},	//   fige, _monn, _noća,
  { {0x69cb00bd,0x291200d1,0x63a30d12,0x00000000}},	//   gige, øya_, _lonn,
  { {0x443f0051,0x76410829,0x91fd008f,0x00000000}},	//   jsu_, _avly, ltāc,
  { {0x98a40080,0xc66a0076,0x63a317c0,0x00000000}},	//   _země_, вшие_, _nonn,
  { {0x2956005a,0x69cb00bd,0xafdb0831,0x00000000}},	//   _възр, bige, prøv,
  { {0xd378017f,0x18a60086,0x443f07f9,0x00000000}},	//   moći_, _кабм, fsu_,
  { {0x26160161,0x63a304bc,0xb0c50053,0x00000000}},	//   _पूरी_, _bonn, _लेंग,
  { {0x63a302a0,0xdb0e0046,0x798217c1,0x00000000}},	//   _conn, _umbó, ldow,
  { {0x6d460512,0x63a307bd,0xd378007d,0x00000000}},	//   _odka, _donn, noći_,
  { {0x7c26017f,0x645d00cd,0x753b17c2,0x00000000}},	//   _otkr, àsic, cauz,
  { {0x8463005a,0x27ec0089,0xdfa702d8,0x00000000}},	//   _дъще, _kkdn_, ајво,
  { {0x44260273,0x69cb17c3,0x644217c4,0x00000000}},	//   _ito_, zige, _ivoi,
  { {0x7c26143b,0x644017c5,0x639b0063,0x00000000}},	//   _atkr, lsmi, _בסגנ,
  { {0x63a3006f,0xa91d02e2,0x79820051,0x00000000}},	//   _zonn, _kaže, jdow,
  { {0x61ed002c,0x69cb17c6,0xdb1e00fe,0x00000000}},	// [2110] _ikal, vige, kipä,
  { {0x44260009,0xa91d0006,0x69d80164,0x00000000}},	//   _mto_, _maže, éven,
  { {0x69cb17c7,0xdb0e0c77,0x386d17c8,0x00000000}},	//   tige, _albâ, _sper_,
  { {0x44261041,0x644017c9,0x443f0cc4,0x00000000}},	//   _oto_, ksmi, ysu_,
  { {0xbcfb0164,0x7980001f,0x61ed0035,0x00000000}},	//   _obéi, _damw, _mkal,
  { {0xdb1e0019,0x6d58005b,0x628a001f,0x00000000}},	//   gipä, ıbaş, _orfo,
  { {0x3f8100e3,0x644204bc,0x753b0035,0x00000000}},	//   _mahu_, _avoi, tauz,
  { {0x81bd0418,0xdddc074f,0x63a317ca,0x00000000}},	//   spēj, ovrš, _sonn,
  { {0x69c90035,0x628a001f,0x63a317cb,0x00000000}},	//   _imee, _arfo, _ponn,
  { {0x63ba17cc,0x61ed17cd,0x442600a4,0x00000000}},	//   ghtn, _akal, _dto_,
  { {0x443f007a,0x44260185,0x6d5d0025,0x00000000}},	//   ssu_, _eto_, _ocsa,
  { {0x443f17ce,0x3f830130,0xc19a0054,0x00000000}},	//   psu_, edju_, утої_,
  { {0x628a0199,0x973c017f,0x95c40021,0x00000000}},	//   _erfo, _moćn, _بينه,
  { {0x79820051,0x63ba030c,0x63a30072,0x00000000}},	//   zdow, chtn, _uonn,
  { {0xdfcf01a7,0xa91d17cf,0x79820022,0x00000000}},	//   ريف_, _zaže, ydow,
  { {0x451900b5,0x3d28007e,0x973c007d,0x00000000}},	//   רוּװ, شتری_, _noćn,
  { {0x6da317d0,0xada30081,0x8f76014b,0x00000000}},	// [2120] чита, чатл, _луні,
  { {0x69c904b4,0xdd3c0051,0xa3ca0053,0x00000000}},	//   _amee, lążk, रोप_,
  { {0x8e8617d1,0xdddc017f,0x0a4a0b3f,0x00000000}},	//   _الجه, avrš, узей_,
  { {0xe9da0076,0xe93a0021,0x6d4600b9,0x00000000}},	//   ыке_, اسات_, _udka,
  { {0x79820051,0x60000137,0xbcfb0003,0x00000000}},	//   rdow, römf, _ccéd,
  { {0x9873000d,0x207b0041,0xd0f7009a,0x00000000}},	//   яліц, טאנא, זמנת_,
  { {0xa91d017f,0x79820221,0x7791007e,0x00000000}},	//   _saže, pdow, ظیما,
  { {0xa91d0006,0xdb1e0ff2,0x644617d2,0x00000000}},	//   _paže, sipä, škim,
  { {0x2d820034,0x32f70013,0x81bd008f,0x00000000}},	//   _make_, _ãy_, spēk,
  { {0x61ed17d3,0xa91d017f,0xd4e30076,0x00000000}},	//   _skal, _važe, яющи,
  { {0x9f8d0080,0xe2f80086,0xdddc082a,0x00000000}},	//   uží_, рені_, zvrš,
  { {0xdb1c0026,0xad9b0025,0xa159000d,0x00000000}},	//   _umræ, _mhúc, шаму_,
  { {0xafdb0d02,0x673a00fe,0x3f810150,0x00000000}},	//   drør, _ketj, _pahu_,
  { {0x8233007e,0x4394157a,0xe8d7009a,0x00000000}},	//   _کروا, _факс, מוכר_,
  { {0x25a60180,0x673a17d4,0x60000137,0x00000000}},	//   _kool_, _metj, dömd,
  { {0x69d80003,0x463b0047,0x2d820783,0x00000000}},	//   ével, טעלע, _cake_,
  { {0x3f81014f,0xdb0e00cd,0x21f9004a,0x00000000}},	// [2130] _tahu_, _albà, lého_,
  { {0x673a00f5,0x69c909fe,0x75d3003b,0x00000000}},	//   _netj, _smee, răzi,
  { {0x21f90114,0x2d82059f,0x68fb013d,0x00000000}},	//   ného_, _fake_, _szud,
  { {0xd378017f,0xad9b0025,0x725b0047,0x00000000}},	//   moću_, _dhúc, רכאפ,
  { {0x673a17d5,0x21f90114,0x973c007d,0x00000000}},	//   _betj, hého_, _voćn,
  { {0x2d820035,0x21f9016b,0x7c2d12d4,0x00000000}},	//   _zake_, kého_, mpar,
  { {0x2d820009,0x56920001,0x628800a8,0x00000000}},	//   _yake_, дајт, jvdo,
  { {0x79a70141,0x1425123e,0x25a60cb4,0x00000000}},	//   _урге, одим, _cool_,
  { {0x57d5000a,0x7c2d17d6,0x28f80054,0x00000000}},	//   _доаѓ, npar, _геть_,
  { {0x7c2d17d7,0xd87404a0,0x87d704a0,0x00000000}},	//   ipar, _عاقب, _اغرا,
  { {0x69d90051,0x27e00139,0x25a6059f,0x00000000}},	//   onwe, éine_, _fool_,
  { {0x7c2d17d8,0x69d9004d,0x201301a8,0x00000000}},	//   kpar, nnwe, _aixi_,
  { {0x69d9004d,0xa8790047,0xdbc6004b,0x00000000}},	//   inwe, באָר, mööb,
  { {0x2d8217d9,0x7c2d17da,0x440717db,0x00000000}},	//   _sake_, dpar, _учеб,
  { {0x2d8200f3,0x442d17dc,0x764317dd,0x00000000}},	//   _pake_, lpe_, nsny,
  { {0x60000137,0x8d66000d,0x69d9006f,0x00000000}},	//   döme, ўвае, jnwe,
  { {0xfaf8003d,0x90c30055,0x7c2d002c,0x00000000}},	// [2140] _šī_, _объе, gpar,
  { {0xdb1c0d2c,0x2d82077d,0x76430822,0x00000000}},	//   _områ, _wake_, ksny,
  { {0x2d8217de,0xafdb00d1,0x65b5027d,0x00000000}},	//   _take_, prør, _náho,
  { {0x673a0627,0x7c2d12a9,0xf2d20041,0x00000000}},	//   _setj, bpar, ועב_,
  { {0x7c2d017d,0x673a14c7,0x442d00ca,0x00000000}},	//   cpar, _petj, jpe_,
  { {0xe7930001,0x69d917df,0x64460078,0x00000000}},	//   дишњ, anwe, škik,
  { {0x442d17e0,0x25a6010e,0xd5ba17e1,0x00000000}},	//   epe_, _pool_, иси_,
  { {0x21f9027d,0x746a0098,0x7a0c003b,0x00000000}},	//   vého_, аров_, _oşti,
  { {0x65b5004c,0x673a013d,0x684317e2,0x00000000}},	//   _táhn, _tetj, _онта,
  { {0x661a17e3,0x21f90114,0x25a617e4,0x00000000}},	//   _tutk, tého_, _wool_,
  { {0xe57a005a,0x7414007e,0x8546000d,0x00000000}},	//   _взе_, _کوتا, _дэле,
  { {0x21f90240,0x386617e5,0xd46a17e6,0x00000000}},	//   rého_, otor_, _виде_,
  { {0x55d900b5,0x386617e7,0x14c70076,0x00000000}},	//   _פֿענ, ntor_, _мыши_,
  { {0xa91d0006,0x386617e8,0x9f430061,0x00000000}},	//   _maža, itor_, pojí_,
  { {0xa187000d,0xdb210014,0x69d9002b,0x00000000}},	//   _дыпл, ótís, ynwe,
  { {0x65b501c2,0x22510066,0x7c2d17e9,0x00000000}},	//   _náhl, ázke_, tpar,
  { {0xf1bf0027,0xa91d0c61,0x3a2a00a4,0x00000000}},	// [2150] mhá_, _naža, _atbp_,
  { {0x7c2d17ea,0xf1bf17eb,0xfe500058,0x00000000}},	//   rpar, lhá_, üçük_,
  { {0x7a400405,0x7c2d17ec,0xd3780051,0x00000000}},	//   _rátá, spar, ieć_,
  { {0xa3ca0161,0x3eac00bd,0x4e7a0047,0x00000000}},	//   रोत_, ädte_, _פארצ,
  { {0xf1b401f9,0x69d917ed,0xc87b0002,0x00000000}},	//   וסף_, rnwe, рџе_,
  { {0xec360063,0x907c0063,0xa91d13ed,0x00000000}},	//   _מאשר_, שְׁפ, _daža,
  { {0xb935005e,0x1f38009a,0x386617ee,0x00000000}},	//   _невј, חרור_, ator_,
  { {0x31790045,0x65b50195,0x386600e5,0x00000000}},	//   jesz_, _váho, btor_,
  { {0x442d17ef,0x6569004d,0x386603db,0x00000000}},	//   upe_, rfeh, ctor_,
  { {0x442d17f0,0x75d3000c,0x65b50240,0x00000000}},	//   rpe_, văzu, _záhl,
  { {0xa3ca0161,0x656900bd,0x442d17f1,0x00000000}},	//   रोध_, pfeh, spe_,
  { {0x442d0386,0x216a0b3f,0xe8e0008b,0x00000000}},	//   ppe_, щими_, uyệt_,
  { {0x439517f2,0xafdb05e7,0x33950121,0x00000000}},	//   _надс, rsøn, _надё,
  { {0x3f6a005e,0x660917f3,0x21f201c8,0x00000000}},	//   љиво_, lmek, váhu_,
  { {0xa3b80049,0xe3b20041,0x5f03089a,0x00000000}},	//   _ظاهر_, _אױג_, езра,
  { {0x31790045,0x6da30001,0x9c2617f4,0x00000000}},	//   cesz_, ниса, здад,
  { {0x600001e9,0x1d070b4c,0x90460021,0x00000000}},	// [2160] römb, зети_, _عنده,
  { {0x386600c2,0x0e6617f5,0xab1a000d,0x00000000}},	//   vtor_, _екон, сцах_,
  { {0x660917f6,0x3866002b,0xdbd90014,0x00000000}},	//   kmek, wtor_, ræðs,
  { {0xd3780051,0xa91d0006,0x5886014c,0x00000000}},	//   zeć_, _paža, зыка,
  { {0x66090019,0xafdb00b9,0x0395008f,0x00000000}},	//   dmek, ksøl, _ķīnā_,
  { {0xa91d017f,0x386617f7,0x69c30110,0x00000000}},	//   _važa, rtor_, èner,
  { {0x200a003b,0xf1bf0066,0x3e87004c,0x00000000}},	//   imbi_, yhá_, mítá_,
  { {0x05760032,0x9adb0063,0xbcfb17f8,0x00000000}},	//   ساعد, _החלט, _ibér,
  { {0x6d4b0025,0xa91d007d,0x47c60094,0x00000000}},	//   ógai, _kažn, _ебав,
  { {0x644f17f9,0x88bb0063,0xad9b0013,0x00000000}},	//   ácia, _הזמי, _nhún,
  { {0x2c6617fa,0xdcfd008f,0x217901eb,0x00000000}},	//   hôd_, _masā, ойны_,
  { {0xa91d02e2,0xf1bf0080,0xdcfd001c,0x00000000}},	//   _lažn, uhá_, _lasā,
  { {0x44200529,0xbcfb17fb,0x7bce17fc,0x00000000}},	//   _îi_, _océa, _ombu,
  { {0xad9b17fd,0xf09f00cd,0x75380022,0x00000000}},	//   _chún, rxà_, ńczą,
  { {0xad9b0025,0x33fb0063,0x6e940121,0x00000000}},	//   _dhún, _ההגנ, ниру,
  { {0x22f70063,0xe4570047,0x7bce17fe,0x00000000}},	//   _מזון_, _אָנזאָ, _ambu,
  { {0xa91d0006,0x62850014,0x7c150054,0x00000000}},	// [2170] _bažn, _áhor, ддає,
  { {0x91fd008f,0x660917ff,0xd9b50042,0x00000000}},	//   itām, zmek, ंस्ट,
  { {0xa91d00eb,0x66091800,0xfe2405ac,0x00000000}},	//   _dažn, ymek, _пьян,
  { {0x6aaa00c7,0x63aa002b,0x7bce1801,0x00000000}},	//   äffa, _lofn, _embu,
  { {0xdbc700fe,0x2d990415,0xc794005d,0x00000000}},	//   töäs, _inse_, کشنب,
  { {0xbcb60063,0xbcfb0025,0xa69500e1,0x00000000}},	//   _חפשו_, _gcéa, дриј,
  { {0x25bf00ac,0x66091802,0xe664005e,0x00000000}},	//   thul_, tmek, етњо,
  { {0x25bf0019,0xafdb00d1,0x7de50078,0x00000000}},	//   uhul_, ruøy, bėse,
  { {0x91fd0418,0xed600080,0x66091803,0x00000000}},	//   rtāl, ížit_, rmek,
  { {0xe3b10021,0x63aa1246,0x25bf0509,0x00000000}},	//   ئرة_, _cofn, shul_,
  { {0x6609001c,0x2d99006f,0x91e60a71,0x00000000}},	//   pmek, _onse_, доне,
  { {0x44b51804,0xa91d0006,0x600000a5,0x00000000}},	//   _обес, _mažo, döma,
  { {0xa3ca0053,0x69d8006c,0x955400de,0x00000000}},	//   रोह_, évei, _أخما,
  { {0x2d8900ac,0x63aa001f,0x200a00b2,0x00000000}},	//   edae_, _gofn, umbi_,
  { {0x248d1805,0x61ef017d,0x394d1806,0x00000000}},	//   lvem_, bocl, _odes_,
  { {0xbcfb0027,0x217601dd,0xbdda0054,0x00000000}},	//   _scéa, _цукр, ієві_,
  { {0xa91d017f,0xdcfd001c,0xceb80006,0x00000000}},	// [2180] _pažn, _pasā, šę_,
  { {0x2d991807,0xaaba007e,0x394d1808,0x00000000}},	//   _ense_, يدار_, _ades_,
  { {0xa91d0117,0x4f9b009a,0xe6dc0046,0x00000000}},	//   _važn, _וביצ, jóðú,
  { {0xa91d001c,0x248d00b9,0xed5a005d,0x00000000}},	//   _dažo, kvem_, _بشدت_,
  { {0x6d441809,0x394d01dc,0x58370085,0x00000000}},	//   maia, _ddes_, дзія_,
  { {0x6283065f,0x98a30001,0x6d44180a,0x00000000}},	//   _osno, тиље, laia,
  { {0x5a55005a,0x248d017d,0xa91d00c2,0x00000000}},	//   _пъту, evem_, _gažo,
  { {0x77b40994,0x1dde0053,0x39490014,0x00000000}},	//   _màxi, नचित, óast_,
  { {0x186a013f,0xa01b0244,0xe76601ce,0x00000000}},	//   _фази_, iwöc, _овап,
  { {0x69c21294,0xc6760021,0x7bde04a7,0x00000000}},	//   lhoe, _يطاب, nnpu,
  { {0x6d44180b,0x394d01e1,0xcb570063,0x00000000}},	//   kaia, _ydes_, וסיה_,
  { {0x69c2102c,0xf5930021,0x22510114,0x00000000}},	//   nhoe, _للمج, ázka_,
  { {0x6d440360,0x22590022,0x4613005d,0x00000000}},	//   daia, ąska_, _شوهر,
  { {0xafdb00d1,0x60000072,0xe3af0044,0x00000000}},	//   msøk, töma, _نرى_,
  { {0xafdb0031,0xddab0121,0x6d4400be,0x00000000}},	//   lsøk, отал_, faia,
  { {0xe3b8005b,0x60000137,0xa91d001c,0x00000000}},	//   lkı_, röma, _ražo,
  { {0xafdb0093,0x8c19005d,0x81bd0023,0x00000000}},	// [2190] nsøk, سيار_, spēs,
  { {0x69c2006f,0x2d8900ac,0xe3b80058,0x00000000}},	//   ehoe, sdae_, nkı_,
  { {0xb17b02f0,0x248d0080,0x657b0150,0x00000000}},	//   pnåd, zvem_, yeuh,
  { {0x69c200f5,0xafdb069f,0x317c0041,0x00000000}},	//   ghoe, ksøk, ַרומ,
  { {0xe3b8005b,0xf3f9003b,0x67d5180c,0x00000000}},	//   kkı_, luţe_, ноду,
  { {0x65bc0003,0xafdb0093,0x91fd008f,0x00000000}},	//   _réha, dsøk, utāj,
  { {0xafdb0031,0x6f7a009a,0x00000000,0x00000000}},	//   esøk, לְקו,   ,
  { {0x91fd001c,0x644f0066,0x34a9005e,0x00000000}},	//   stāj, ácio, звио_,
  { {0x600000c7,0xafdb00d1,0xd7fb0a25,0x00000000}},	//   dömn, gsøk, _дуж_,
  { {0xf770006a,0x65600027,0xd5b10013,0x00000000}},	//   _نام_, agmh, _múi_,
  { {0xeb92180d,0xe299180e,0xc6a40002,0x00000000}},	//   אָר_, чан_, _ирци,
  { {0xdb07007a,0xafdb00d1,0x56b60041,0x00000000}},	//   _hljó, bsøk, _אפען_,
  { {0xb143000d,0x6d4400be,0xdb05004d,0x00000000}},	//   ынял, vaia, chhö,
  { {0x78a400fe,0xe4560047,0x75290290,0x00000000}},	//   äivi, _ניצט_, lcez,
  { {0xa91d017f,0x69c2001f,0x64460006,0x00000000}},	//   _pažl, yhoe, škit,
  { {0x6286001c,0x7529180f,0xdca61810,0x00000000}},	//   ākot, ncez, наби,
  { {0x64491811,0x6d441812,0x752901f4,0x00000000}},	// [21a0] nsei, raia, icez,
  { {0x799b0306,0x6d441813,0x7c2b1814,0x00000000}},	//   _anuw, saia, ígra,
  { {0x6d440397,0x69c21815,0xc0a9007e,0x00000000}},	//   paia, thoe, _فایل_,
  { {0x39400025,0x64491816,0xdca60794,0x00000000}},	//   úis_, ksei, _зами,
  { {0x69c20438,0x644f0331,0xd9170085,0x00000000}},	//   rhoe, ácil, ньш_,
  { {0x69c21817,0xc7a3012d,0x64490e64,0x00000000}},	//   shoe, личк, dsei,
  { {0x644b0a2e,0xb6050195,0x64491818,0x00000000}},	//   _avgi, znáš, esei,
  { {0xafdb0031,0xa91d00c3,0x38cb007e,0x00000000}},	//   tsøk, _lažj, _کافی_,
  { {0xdb07007a,0x91fd001c,0x69c01819,0x00000000}},	//   _fljó, stāk, _ilme,
  { {0xafdb0031,0x61e40009,0xa3ca0053,0x00000000}},	//   rsøk, _ajil, रों_,
  { {0xa1590138,0x26d800c7,0xafdb00d1,0x00000000}},	//   ману_, _äro_, ssøk,
  { {0x644900bd,0xe3b8005b,0xafdb00d1,0x00000000}},	//   bsei, skı_, psøk,
  { {0x60000137,0xe3b80058,0x240a0141,0x00000000}},	//   römn, pkı_, _енди_,
  { {0x69c000d1,0xdb1e004b,0xa01b0014,0x00000000}},	//   _llme, gipü, fvör,
  { {0x65bc0003,0xb605004c,0x63b5013d,0x00000000}},	//   _jého, snáš, özne,
  { {0xb7b50013,0x290412a9,0x7a47004c,0x00000000}},	//   _kịc, _ozma_, _létá,
  { {0xf3f9003b,0xa01b181a,0xfc30009b,0x00000000}},	// [21b0] suţe_, rvös, محل_,
  { {0x69c0181b,0x61fd06ea,0xe8000042,0x00000000}},	//   _alme, llsl, _लीला_,
  { {0xb7b5008b,0x3209008d,0x63ba181c,0x00000000}},	//   _lịc, _khay_, iktn,
  { {0x91f6008b,0x644900fe,0x32370047,0x00000000}},	//   hún, ysei, גטאן_,
  { {0x61fd00b9,0x18690002,0x6449004d,0x00000000}},	//   ilsl, фали_, xsei,
  { {0x2d8b048e,0xa6990001,0xa91d0006,0x00000000}},	//   _hace_, дњих_, _kažk,
  { {0x998d0022,0x7d020023,0x7a47009c,0x00000000}},	//   _pień_, ļose, _détá,
  { {0x6449181d,0x442f0d52,0x644f007d,0x00000000}},	//   tsei, _ptg_, šcim,
  { {0x75290290,0xdb070066,0xd5ae0021,0x00000000}},	//   rcez, _mojí, تفي_,
  { {0xb7b5001b,0x6449181e,0x2d8b00e5,0x00000000}},	//   _dịc, rsei, _lace_,
  { {0x443d181f,0x13090055,0xbcfb0003,0x00000000}},	//   _www_, ьной_, _scél,
  { {0x2d8b006d,0x201a00a4,0x3209008b,0x00000000}},	//   _nace_, _sipi_, _chay_,
  { {0x201a1820,0x9f4a0114,0xb05b004d,0x00000000}},	//   _pipi_, sobí_, nzäh,
  { {0xdce60066,0x61fd0046,0x00000000,0x00000000}},	//   ámče, alsl,   ,
  { {0x201a0035,0xdb07004c,0x2d8b0130,0x00000000}},	//   _vipi_, _bojí, _bace_,
  { {0xc69207e9,0xa91d008f,0xf652009d,0x00000000}},	//   סאן_, _dažk, יצל_,
  { {0x201a1821,0xdb070080,0x7bd7003b,0x00000000}},	// [21c0] _tipi_, _dojí, fixu,
  { {0x291f02dd,0xa01b0026,0xdce4001c,0x00000000}},	//   _agua_, svör, ediģ,
  { {0x68fb048e,0xcf570063,0x0f570e2a,0x00000000}},	//   _ayud, _בבית_, _ביים_,
  { {0xfbc90063,0xf1bb0013,0x29d5004c,0x00000000}},	//   חת_, _luơn_, sťan_,
  { {0x07a6000d,0x2d800493,0x63ba00d1,0x00000000}},	//   кадн, meie_, yktn,
  { {0x2d8000d1,0xd7f70062,0x7bc504a7,0x00000000}},	//   leie_, кущ_, chhu,
  { {0x69261822,0x2d8b0331,0x9634005e,0x00000000}},	//   _амба, _yace_, ћниц,
  { {0x5e5700b5,0xafdb00b9,0x96b70001,0x00000000}},	//   דיקע_, rsøi, ђују_,
  { {0x65b5006d,0x3944005f,0x8a17009a,0x00000000}},	//   _náhu, _iems_, _יחלו_,
  { {0x2d800529,0x21200089,0x65bc004c,0x00000000}},	//   heie_, _agih_, _tého,
  { {0x2d80021f,0xd7ef0021,0x0bb70063,0x00000000}},	//   keie_, _بكل_, דלים_,
  { {0xb6d90047,0x30350121,0x04960021,0x00000000}},	//   _אַנט, лемё, _للصح,
  { {0x2d8b1823,0x3eb80014,0x00000000,0x00000000}},	//   _race_, eyrt_,   ,
  { {0x040d0013,0x403401d5,0xa4b7009d,0x00000000}},	//   _mườn, рерс, _בלדה_,
  { {0x320900aa,0x2d8b15e5,0x040d0013,0x00000000}},	//   _thay_, _pace_, _lườn,
  { {0xdddc1824,0x1317009a,0xc536009d,0x00000000}},	//   avrž, _בחול_, דָ֑ה_,
  { {0x1df80076,0xf3f9003b,0x7afc1825,0x00000000}},	// [21d0] теты_, luţa_, _ayrt,
  { {0xf0920063,0x1b7b0021,0xad9b0025,0x00000000}},	//   _פני_, بصرة_, _mhúi,
  { {0x2d8b1826,0x7afc00a3,0xcb680044,0x00000000}},	//   _tace_, _cyrt, ضمنه_,
  { {0xe1ff00ea,0x83fd013d,0xa91d0734,0x00000000}},	//   nló_, rtői, _kaži,
  { {0x3da40088,0x040d008b,0x7c220025,0x00000000}},	//   _трэб, _cườn, íort,
  { {0xa91d00eb,0x040d008b,0xb05b004d,0x00000000}},	//   _maži, _dườn, rzäh,
  { {0xf7700929,0xb05b004d,0x36190121,0x00000000}},	//   تان_, szäh, нцию_,
  { {0xd5b1008b,0xdddc004c,0x394400e5,0x00000000}},	//   _nút_, zvrž, _gems_,
  { {0xad9b0025,0x5884000d,0x44150062,0x00000000}},	//   _chúi, _выха, лфот,
  { {0x69d914ce,0x3944001c,0x600017cb,0x00000000}},	//   liwe, _zems_, tömm,
  { {0xd5b10013,0x61461827,0x216a0f0a,0x00000000}},	//   _bút_, лена, нини_,
  { {0x60001828,0xe1ff0331,0x69d91829,0x00000000}},	//   römm, gló_, niwe,
  { {0xd24e006a,0xe3b3006a,0x753b0035,0x00000000}},	//   ينی_, _پرش_, mbuz,
  { {0xd8da0063,0x3eb800d1,0xe1ff00ea,0x00000000}},	//   תקשר, tyrt_, aló_,
  { {0x3ebe0026,0xe1ff182a,0x2eb50076,0x00000000}},	//   átt_, bló_, астс,
  { {0x45b50047,0x01660601,0x0c3a0044,0x00000000}},	//   נפּל_, _скио, فكرة_,
  { {0x672100c2,0x69d9001f,0x7afc001f,0x00000000}},	// [21e0] _oglj, diwe, _syrt,
  { {0x8b260a36,0x3ea6182b,0x9f860094,0x00000000}},	//   удже, _биог, _сгод,
  { {0x645b0027,0x2d8000be,0x7c36182c,0x00000000}},	//   hrui, peie_, spyr,
  { {0x91fd001c,0x645b0250,0x5cf6000d,0x00000000}},	//   stāv, krui, _бягу,
  { {0x6d4613ed,0x7afc002b,0x985616b4,0x00000000}},	//   _ieka, _wyrt, утеш,
  { {0x91fd003d,0xa6340086,0x645b182d,0x00000000}},	//   ltāt, анкі, drui,
  { {0x6d460397,0xf1c1027d,0x645b006f,0x00000000}},	//   _keka, ášky_, erui,
  { {0x040d008b,0x5454093f,0x645b01e7,0x00000000}},	//   _tườn, авит, frui,
  { {0x136a005a,0x645b006f,0xd5b1008b,0x00000000}},	//   ншни_, grui, _rút_,
  { {0x6d461588,0xf6260054,0x4274182e,0x00000000}},	//   _leka, _бджо, агос,
  { {0xb3450016,0x7c26120a,0x2bf70047,0x00000000}},	//   _seçã, _lukr, רמין_,
  { {0x645b182f,0xd2570088,0x6d461830,0x00000000}},	//   brui, ыць_, _neka,
  { {0x7c2600eb,0xf3f9000c,0xa91d0006,0x00000000}},	//   _nukr, suţa_, _paži,
  { {0xa3e80053,0x69d914ce,0x4fc70a91,0x00000000}},	//   _यदि_, ziwe, усма,
  { {0x44260009,0x6d461831,0x7c2604aa,0x00000000}},	//   _huo_, _beka, _aukr,
  { {0x44260006,0x6d461832,0x98c40042,0x00000000}},	//   _kuo_, _ceka, वनाए,
  { {0x44260006,0x69d90035,0x6d461833,0x00000000}},	// [21f0] _juo_, viwe, _deka,
  { {0xf1bf0080,0x69d80003,0x7c260078,0x00000000}},	//   lká_, èven, _dukr,
  { {0x4426024a,0x99350021,0x3f830130,0x00000000}},	//   _luo_, لفات, meju_,
  { {0x3ebe07e6,0x6d460007,0x19590085,0x00000000}},	//   øtte_, _geka, тады_,
  { {0x442600eb,0xa948007e,0x31580041,0x00000000}},	//   _nuo_, الهٔ_, רידן_,
  { {0x7bd500bd,0x65b50240,0x62981834,0x00000000}},	//   _umzu, _náhr, _orvo,
  { {0xdb050026,0x6d461835,0xf1bf10c9,0x00000000}},	//   rkhó, _yeka, kká_,
  { {0x4426002c,0x645b1836,0x370a0042,0x00000000}},	//   _buo_, trui, ाधड़ी_,
  { {0x6298024a,0x05a60076,0x645b172b,0x00000000}},	//   _arvo, рвый_, urui,
  { {0xe2990138,0x6721017f,0x60000137,0x00000000}},	//   вао_, _uglj, römk,
  { {0x645b1837,0xd5ae007e,0xdb07013d,0x00000000}},	//   srui, سفی_, _eljö,
  { {0x3f91008f,0x11d60054,0x62980130,0x00000000}},	//   edzu_, ріор, _drvo,
  { {0x62980122,0x628a1838,0xf3f900dd,0x00000000}},	//   _ervo, _esfo, erţe_,
  { {0x6d4617ba,0x25ad0019,0x91fd001c,0x00000000}},	//   _seka, ljel_, tuāc,
  { {0x6d461839,0xf233007e,0x7c26183a,0x00000000}},	//   _peka, _ابتک, _sukr,
  { {0xf1bf016b,0x25bf183b,0x3dc900a4,0x00000000}},	//   cká_, nkul_, ghaw_,
  { {0x6d46183c,0x8fc5007e,0x0b461702,0x00000000}},	// [2200] _veka, _گزين, инан,
  { {0x91fd183d,0x7dc3004b,0x1d19183e,0x00000000}},	//   grāf, _võsa, уюсь_,
  { {0x6d46053b,0xa926183f,0xa91d1840,0x00000000}},	//   _teka, адел, _mažu,
  { {0x61e61841,0x25ad013d,0xd3780130,0x00000000}},	//   nnkl, jjel_, miće_,
  { {0xdb070080,0x61e60006,0xa967005a,0x00000000}},	//   _vojá, inkl, рича_,
  { {0x91fd003d,0xd90d007e,0xf1bf01c2,0x00000000}},	//   ntār, ریل_, zká_,
  { {0x442602f6,0x64420045,0xdb0700ea,0x00000000}},	//   _suo_, _swoi, _tojá,
  { {0xafdb076c,0x44260290,0xbcfb0025,0x00000000}},	//   nsør, _puo_, _scéi,
  { {0xa4d4000d,0x98bd0022,0xdb1e004b,0x00000000}},	//   сопі, tawą_, gipö,
  { {0xa5070001,0xa91d0006,0x629804d9,0x00000000}},	//   шења_, _pažv, _prvo,
  { {0x3f830006,0xa91d001c,0x98bd0022,0x00000000}},	//   veju_, _dažu, rawą_,
  { {0x64420045,0x44261842,0xd378007d,0x00000000}},	//   _twoi, _tuo_, diće_,
  { {0xdb0e005b,0xe3af007e,0x3f831843,0x00000000}},	//   _albü, سری_, teju_,
  { {0xf1bf108f,0xdfdb0062,0x645d0066,0x00000000}},	//   ská_, тъм_, ásie,
  { {0x3f831844,0x753d013d,0xdeb40183,0x00000000}},	//   reju_, űsze, обры,
  { {0x7ae10066,0xdb1e004b,0x3da4130f,0x00000000}},	//   _žlto, nipõ, оруб,
  { {0x4c9407b0,0x91fd001c,0x7de50078,0x00000000}},	// [2210] оитс, stās, lėsk,
  { {0x60c002ab,0xde670062,0x2d8f00a8,0x00000000}},	//   ømme, _къмп, žge_,
  { {0x6e950032,0x2003074f,0x3a751845,0x00000000}},	//   _الجا, mlji_, слер,
  { {0x62860045,0x3915000d,0xaa58173e,0x00000000}},	//   łkow, бмер, рицу_,
  { {0x9f510080,0x6d4d1846,0x2003007d,0x00000000}},	//   hozí_, maaa, olji_,
  { {0x60000072,0x29d5017c,0x8a370044,0x00000000}},	//   tömi, zťah_, _نعرض,
  { {0x91fd001c,0x45d5005a,0xc7c8000d,0x00000000}},	//   orād, йцит, шыце_,
  { {0x59f90055,0x77bd0268,0x39400026,0x00000000}},	//   _себя_, _mèxi, ðist_,
  { {0x7bc71847,0x26c10024,0xa5f60001,0x00000000}},	//   _klju, šho_, љењу_,
  { {0x645d00cd,0x25bf1848,0xb8dd0053,0x00000000}},	//   àsiq, skul_, ुई_,
  { {0x6d4d0ddd,0xdb1e004b,0x57fa0047,0x00000000}},	//   kaaa, bipõ, _עלעו,
  { {0xd378007d,0xad9b0139,0x930d0058,0x00000000}},	//   viće_, _mhús, _ışık,
  { {0x34ab0021,0xb34600be,0xe3ae1849,0x00000000}},	//   _جداً_, unçõ, _еб_,
  { {0x6d4b0026,0xd378007d,0x91fd008f,0x00000000}},	//   ðgan, tiće_, erād,
  { {0xada6184a,0x6da6184b,0x63bc184c,0x00000000}},	//   бавл, бива, örne,
  { {0x6569184d,0x1d26005e,0xd378007d,0x00000000}},	//   ngeh, смам, riće_,
  { {0x69d80164,0x998d0051,0xafdb05e7,0x00000000}},	// [2220] èvem, _wieś_, rsør,
  { {0x91fd001c,0x7dda0080,0x65bc0164,0x00000000}},	//   arād, půso, _véhi,
  { {0xb05b0137,0x4a9a000d,0x16170042,0x00000000}},	//   tyäg, ытаў_, दगार_,
  { {0xdb1c00c7,0x6569006f,0x27e90025,0x00000000}},	//   _omrö, jgeh, éann_,
  { {0x28d20235,0x63a300ac,0x6569184e,0x00000000}},	//   _देखि, _onnn, dgeh,
  { {0xfaa60088,0xab271259,0x207b0047,0x00000000}},	//   _лаго, _гора_, ראסא,
  { {0x7bde0228,0x656900bd,0xdb1e004b,0x00000000}},	//   mipu, fgeh, tipõ,
  { {0x69cb136d,0x7bde184f,0x656906aa,0x00000000}},	//   chge, lipu, ggeh,
  { {0xc34a1850,0xdb0e00be,0xe73a1851,0x00000000}},	//   ляне_, _mobí, _без_,
  { {0x91fd001c,0xa91d0078,0x7bde1852,0x00000000}},	//   zrād, _važt, nipu,
  { {0xd5af1853,0x6d4d00a4,0x200302f7,0x00000000}},	//   _ес_, yaaa, vlji_,
  { {0x645d0942,0x31c70076,0x69c2006f,0x00000000}},	//   ásic, ссов, nkoe,
  { {0x644f0331,0x7bde1854,0x83fd013d,0x00000000}},	//   ácit, kipu, rtőr,
  { {0x6d4d00a4,0x7de50078,0x6ee70021,0x00000000}},	//   waaa, mėsi, مسأل,
  { {0x7de500eb,0x91fd001c,0x6d4d00a4,0x00000000}},	//   lėsi, trād, taaa,
  { {0x7bcb001c,0x91e4005e,0x83fd013d,0x00000000}},	//   īgum, _ноје, ltőp,
  { {0xcf8e006a,0x7bcb001c,0x7bc702f7,0x00000000}},	// [2230] رژی_, ūgum, _plju,
  { {0xad9b0025,0x2bbb0021,0xdfd1007e,0x00000000}},	//   _chúr, دارة_, _آيد_,
  { {0xc333014e,0x6d4d00a4,0x7bc700c2,0x00000000}},	//   פוף_, paaa, _vlju,
  { {0x7de50006,0x6b850244,0x00000000,0x00000000}},	//   kėsi, sehg,   ,
  { {0x27e9006d,0xa01b00ea,0xf8650054,0x00000000}},	//   éano_, dvöz, івко,
  { {0x7de50006,0xdb0e000c,0x9848014c,0x00000000}},	//   dėsi, _dobâ, сяца_,
  { {0x5fbc014e,0x65691855,0x61ed1856,0x00000000}},	//   רצונ, tgeh, _ojal,
  { {0xe4591857,0xa91d008f,0x0609007b,0x00000000}},	//   ажи_, _dažr, јник_,
  { {0x65691858,0x7de50078,0x00000000,0x00000000}},	//   rgeh, gėsi,   ,
  { {0x656900bd,0x61ed0449,0xd7fb15d4,0x00000000}},	//   sgeh, _ajal, _суб_,
  { {0xf77004de,0x65690104,0x69c91859,0x00000000}},	//   _سال_, pgeh, _klee,
  { {0x7de50006,0xb1da0086,0x216a0499,0x00000000}},	//   bėsi, рьох_, шими_,
  { {0x61ed185a,0xd00a185b,0xdb0e0195,0x00000000}},	//   _djal, иеме_, _robí,
  { {0x69c9006f,0xd9b60053,0xee3a0cd6,0x00000000}},	//   _llee, _अक्ट, инг_,
  { {0x61ed0026,0x98bd0051,0x9f58185c,0x00000000}},	//   _fjal, rawę_, noré_,
  { {0x61ed007a,0x91fd001c,0x2251004a,0x00000000}},	//   _gjal, nuāl, ázku_,
  { {0xd378007d,0xfc1a0021,0x7bde185d,0x00000000}},	// [2240] lića_, لقرب_, tipu,
  { {0x69c9185e,0x60000072,0x6abe0e77,0x00000000}},	//   _alee, tömu, typf,
  { {0xdcff001c,0x69c90625,0x7bde185f,0x00000000}},	//   īvāk, _blee, ripu,
  { {0x7ae30025,0x600000bd,0x38660003,0x00000000}},	//   únta, römu, tuor_,
  { {0x91fd001c,0x98470062,0x69c21860,0x00000000}},	//   duāl, ояща_, rkoe,
  { {0x69c21861,0xa09b0149,0xd378007d,0x00000000}},	//   skoe, יינט, kića_,
  { {0x69c90034,0xeb9100b5,0xd378007d,0x00000000}},	//   _flee, _אָן_, jića_,
  { {0xd378017f,0x35f7007e,0xa9670896,0x00000000}},	//   dića_, يريد_, _миса_,
  { {0x6b990139,0x386612a9,0xb7e61862,0x00000000}},	//   _éagó, quor_, _джак,
  { {0x7de50006,0x61ed0d9f,0x249d001f,0x00000000}},	//   rėsi, _sjal, _drwm_,
  { {0x69c900fe,0xc7b30063,0x51f90636,0x00000000}},	//   _ylee, _קבע_, йною_,
  { {0xc2b70054,0x7de5005f,0x645d005f,0x00000000}},	//   іляє_, pėsi, šsia,
  { {0xc95301f9,0x80db0053,0xa5070713,0x00000000}},	//   ומר_, _पेशे, _деца_,
  { {0xd378007d,0x3a240783,0xa2e60044,0x00000000}},	//   bića_, _limp_, _وأثن,
  { {0xcddb041d,0x91fd001c,0x61ed1863,0x00000000}},	//   ања_, grāc, _tjal,
  { {0xd1310044,0x29040075,0x61ed0566,0x00000000}},	//   _ثمة_, _oyma_, _ujal,
  { {0x61fd1864,0xdc98012c,0xfc300044,0x00000000}},	// [2250] mosl, овті_, نحل_,
  { {0xaac7006a,0x9f43006d,0x69c91865,0x00000000}},	//   يتان, rojó_, _slee,
  { {0x8ae7019d,0xaa950021,0x69c91860,0x00000000}},	//   ціал, ثلاث, _plee,
  { {0x99d4007e,0xbcfb0066,0xfbdf002b,0x00000000}},	//   وتنا, _dcér, _gwên_,
  { {0x69c91031,0x394f004d,0xc7a50062,0x00000000}},	//   _vlee, rags_, зилк,
  { {0x9f58034d,0x29040185,0xd629167b,0x00000000}},	//   toré_, _dyma_, боке_,
  { {0x91fd001c,0x21290150,0x6fc20066,0x00000000}},	//   tuāl, _ogah_, _dôch,
  { {0xd378017f,0x21290089,0x61fd001c,0x00000000}},	//   vića_, _ngah_, josl,
  { {0x478b0076,0x61fd1866,0x44390003,0x00000000}},	//   _всем_, dosl, ës_,
  { {0x4439001c,0xd378007d,0x4734005d,0x00000000}},	//   īs_, tića_, _قرمز,
  { {0x44391867,0x9f4e0080,0x7dca0026,0x00000000}},	//   ūs_, áním_, _lýsa,
  { {0x249d001f,0xd378007d,0x61fd1868,0x00000000}},	//   _trwm_, rića_, gosl,
  { {0x394d1869,0xd378007d,0x1016000d,0x00000000}},	//   _mees_, sića_, зьвя,
  { {0x78a6007a,0x394d04c6,0x437500b5,0x00000000}},	//   _ákve, _lees_, _זײַן_,
  { {0x443f186a,0x60120026,0xc7b20047,0x00000000}},	//   lpu_, væmd, ײבן_,
  { {0x7bc500ac,0x62830290,0x443f001c,0x00000000}},	//   ekhu, _ipno, opu_,
  { {0xdd8f0067,0x3c66000d,0xc0e6186b,0x00000000}},	// [2260] دوق_, якаг, _хопк,
  { {0x443f186c,0x2c740137,0x3a2401f4,0x00000000}},	//   ipu_, räd_, _simp_,
  { {0x394d00e5,0x09e6030b,0x3a240168,0x00000000}},	//   _bees_, пожн, _pimp_,
  { {0x6fcb005b,0x2d89186d,0x394d00ca,0x00000000}},	//   _tücc, ceae_, _cees_,
  { {0x6d44186e,0x18670caa,0xdb0e01c8,0x00000000}},	//   mbia, зачи_, _dobá,
  { {0x6d440006,0x3f8a001f,0x25b2001f,0x00000000}},	//   lbia, nebu_, _ŵyl_,
  { {0x3a240529,0x63b80a63,0x394d186f,0x00000000}},	//   _timp_, _rovn, _fees_,
  { {0x394d00e8,0x6fcb005b,0x99500066,0x00000000}},	//   _gees_, _müca, lúži_,
  { {0x6d441870,0x61fd1871,0x6283011b,0x00000000}},	//   ibia, vosl, _apno,
  { {0x883b0063,0x7de50006,0x60270003,0x00000000}},	//   _לתמו, lėst, hémè,
  { {0x443f0368,0xd6c4007e,0x9473005d,0x00000000}},	//   apu_, _تمای, ودیا,
  { {0x25a6001f,0x7c3a004c,0x3f981872,0x00000000}},	//   _unol_, _čtrn, edru_,
  { {0x77bd00cd,0xf3f9003b,0x9f58002b,0x00000000}},	//   _tèxt, zuţi_, gorï_,
  { {0xb7bd0529,0x3f8a0150,0x6d44002b,0x00000000}},	//   _puţi, gebu_, ebia,
  { {0x6b95055e,0x64400a53,0x61fd09a1,0x00000000}},	//   _razg, lpmi, posl,
  { {0x463b0041,0x3f9800dd,0x92f200dd,0x00000000}},	//   מעלע, adru_, ăşăm,
  { {0x7de50006,0x394d035a,0x0c390021,0x00000000}},	// [2270] dėst, _rees_, زكاة_,
  { {0xfe6e006a,0xbca40032,0x394d010e,0x00000000}},	//   دگی_, عملي, _sees_,
  { {0x6b95005b,0x660200ea,0x6d441873,0x00000000}},	//   _vazg, _okok, bbia,
  { {0x3eac02ab,0x7bc501a8,0x3ebe1874,0x00000000}},	//   ådte_, skhu, ätte_,
  { {0x315800b5,0x6d5d069f,0x8819000d,0x00000000}},	//   ליאן_, _idsa, оўку_,
  { {0x394d021f,0x46390121,0x98a2157f,0x00000000}},	//   _wees_, очия_, тише,
  { {0x6d4f003e,0x9f5e0003,0x4ac5007e,0x00000000}},	//   _keca, ôté_, _غيرق,
  { {0x84591875,0x1994000d,0x248d0051,0x00000000}},	//   орот_, _пася, twem_,
  { {0x6d4f1876,0x8554007e,0x6f09004c,0x00000000}},	//   _meca, ریور_, řech,
  { {0x443f1877,0x798b002b,0x6d4f123c,0x00000000}},	//   rpu_, legw, _leca,
  { {0x7c2f1878,0x6d44001f,0xd7580021,0x00000000}},	//   _lucr, ybia, _رجلا_,
  { {0x798b001f,0x71da0086,0x6d4f1879,0x00000000}},	//   negw, ієнт_, _neca,
  { {0x9554007e,0xc4fb007e,0x66090058,0x00000000}},	//   _سخنا, _اعضا_, mlek,
  { {0x7d0608b3,0x6609187a,0x6d44002b,0x00000000}},	//   _ryks, llek, wbia,
  { {0x6d4f0037,0x4427187b,0x3f8a187c,0x00000000}},	//   _beca, _iin_, rebu_,
  { {0x7e61007a,0x6d4f0089,0x661b00fe,0x00000000}},	//   álpa, _ceca, nmuk,
  { {0x1d070001,0xfce3006e,0x6d44187d,0x00000000}},	// [2280] дети_, вото, rbia,
  { {0x7d060006,0xabaa0021,0x6609187e,0x00000000}},	//   _vyks, غهام_, hlek,
  { {0x6eb50053,0x442f187f,0x7d060051,0x00000000}},	//   _उपयु, _lug_, _wyks,
  { {0x44271880,0xfc3f0139,0x5886000d,0x00000000}},	//   _lin_, _bríd_, дыка,
  { {0x91fd008f,0x9f580066,0x645d16f1,0x00000000}},	//   krān, horí_, ásil,
  { {0x442701f7,0x66091881,0x661b1882,0x00000000}},	//   _nin_, elek, emuk,
  { {0xd6d00032,0x9f5801f4,0x66091883,0x00000000}},	//   طقة_, vorì_, flek,
  { {0xd5b00032,0x661b00a4,0x7c27006f,0x00000000}},	//   افة_, gmuk, _zijr,
  { {0x39460877,0x44271884,0x7c29013d,0x00000000}},	//   mbos_, _bin_, _éert,
  { {0x394600eb,0xa3d80053,0xe8d70063,0x00000000}},	//   lbos_, ठों_, _חומר_,
  { {0xbcfb1885,0x66091886,0x44271887,0x00000000}},	//   _idée, blek, _din_,
  { {0x7dc30019,0x44271888,0x66020035,0x00000000}},	//   _tõsi, _ein_, _ukok,
  { {0x44271889,0x361b0047,0x29f8007d,0x00000000}},	//   _fin_, _וואד, mčad_,
  { {0x6d4f014f,0x250b007e,0x4427188a,0x00000000}},	//   _seca, _برمی_, _gin_,
  { {0x442f00bd,0x6d4f188b,0x7dd102e0,0x00000000}},	//   _zug_, _peca, _låse,
  { {0x4427188c,0xa1870085,0x7bce188d,0x00000000}},	//   _zin_, _цыкл, _albu,
  { {0x6d4f001c,0x42180044,0x4427188e,0x00000000}},	// [2290] _veca, _تزوج_, _yin_,
  { {0x2fc700aa,0x4427001b,0x60c00d88,0x00000000}},	//   _ông_, _xin_, ämme,
  { {0x61ef0bdb,0xf09f01a8,0x6600188f,0x00000000}},	//   oncl, lvà_, komk,
  { {0x6d5d00b9,0x38660cc7,0x660900b8,0x00000000}},	//   _udsa, fror_, xlek,
  { {0xdd3a014e,0x798b00ac,0x66091890,0x00000000}},	//   _מערכ, regw, vlek,
  { {0xe611007e,0xa6950095,0x9695005e,0x00000000}},	//   گشت_, ериј, ериш,
  { {0x44271891,0x6b6800ea,0x66091892,0x00000000}},	//   _rin_, ségü, tlek,
  { {0x9f580024,0xfc3f0025,0x44271893,0x00000000}},	//   vorí_, _tríd_, _sin_,
  { {0x661b1894,0x66091895,0x0efc0053,0x00000000}},	//   rmuk, rlek, _एड्स_,
  { {0xe3b10032,0x78a60026,0x9f580024,0x00000000}},	//   ارة_, _ákva, torí_,
  { {0x0394000d,0x44271896,0x2d991897,0x00000000}},	//   трыя, _vin_, _oase_,
  { {0x4427120f,0x764300a4,0x442f059f,0x00000000}},	//   _win_, mpny, _tug_,
  { {0x44271898,0x2ec80042,0xe5340121,0x00000000}},	//   _tin_, रन्त, _речь,
  { {0x44271899,0xe4560047,0x3cf30042,0x00000000}},	//   _uin_, _טינט_, ंपने_,
  { {0x39460006,0x249f0014,0xdb1c0058,0x00000000}},	//   ybos_, lvum_, üzün,
  { {0xdb1c0164,0x2d990399,0x386600a5,0x00000000}},	//   _forê, _case_, yror_,
  { {0x3dd20185,0x8fa60f27,0x61e6189a,0x00000000}},	// [22a0] rhyw_, _запе, mikl,
  { {0xfc3f0027,0x2d990034,0x395f000c,0x00000000}},	//   _dtí_, _ease_, _adus_,
  { {0xb17b00c7,0x160f0053,0x2d99189b,0x00000000}},	//   pnåt, ातार_, _fase_,
  { {0x61e6189c,0x523a0047,0x2d99189d,0x00000000}},	//   nikl, לײענ, _gase_,
  { {0xb3460016,0xa927019d,0x61e60019,0x00000000}},	//   niçõ, ніше_, iikl,
  { {0x6d56189e,0x2d99189f,0x386603e1,0x00000000}},	//   laya, _zase_, rror_,
  { {0x25bd18a0,0x3c3600b9,0x61e618a1,0x00000000}},	//   _bowl_, _hæv_, kikl,
  { {0x3f9a003d,0x6d5615c4,0xceb30132,0x00000000}},	//   _lapu_, naya, ריה_,
  { {0x1867000a,0x61e618a2,0x660018a3,0x00000000}},	//   _пати_, dikl, romk,
  { {0x660018a4,0xb346017d,0x61e60006,0x00000000}},	//   somk, diçõ, eikl,
  { {0x6d5618a5,0xd2570086,0x66000035,0x00000000}},	//   kaya, нця_, pomk,
  { {0x6d5618a6,0xab64005b,0x60120026,0x00000000}},	//   jaya, ldüğ, væma,
  { {0x7dca0512,0x6d56014f,0x2ca0007d,0x00000000}},	//   _výsl, daya, jvid_,
  { {0x20050024,0x2ca000c7,0xb4be0053,0x00000000}},	//   ôli_, dvid_, ीनी_,
  { {0x2d9918a7,0xdb1518a8,0x6d560089,0x00000000}},	//   _pase_, _pozí, faya,
  { {0x3253011c,0x6d5600bb,0x3ebe0140,0x00000000}},	//   _свър, gaya, ätta_,
  { {0x9f5800cd,0x2d9918a9,0xacf818aa,0x00000000}},	// [22b0] borà_, _vase_, енту_,
  { {0x9f5801a8,0x1cb80044,0x3dc9056c,0x00000000}},	//   corà_, راقب_, skaw_,
  { {0x6d5618ab,0x20030006,0x2d9918ac,0x00000000}},	//   baya, moji_, _tase_,
  { {0x2003005b,0xafdb00d1,0x6d5618ad,0x00000000}},	//   loji_, vsøy, caya,
  { {0xcf27007e,0xe72e026b,0x7dda0080,0x00000000}},	//   _ترکي, ие_, růst,
  { {0xa01b0026,0xa09c0047,0x69d80003,0x00000000}},	//   stöf, פיוט, èver,
  { {0x60c60066,0x91fd008f,0x61e60075,0x00000000}},	//   zykm, trāl, yikl,
  { {0x36180085,0xc4850782,0xb4be0042,0x00000000}},	//   нцыю_, влик, ीनू_,
  { {0x61e618ae,0x91a9008b,0x99870078,0x00000000}},	//   vikl, _giả_, ūnų_,
  { {0x799b0035,0x69cb00f5,0x20030006,0x00000000}},	//   _hauw, lkge, joji_,
  { {0x6d5600bb,0x27e70026,0x2d8008b3,0x00000000}},	//   yaya, minn_, yfie_,
  { {0x27e718af,0xe3b1007e,0xb346017d,0x00000000}},	//   linn_, ارک_, tiçõ,
  { {0x69cb006f,0x32020114,0xc9520063,0x00000000}},	//   ikge, roky_, סמך_,
  { {0x200300c3,0xb3460016,0x6d560277,0x00000000}},	//   goji_, riçõ, waya,
  { {0xb3460016,0x26c70006,0x6d560bbf,0x00000000}},	//   siçõ, nyno_, taya,
  { {0x799b0122,0x69cb006f,0x753b18b0,0x00000000}},	//   _nauw, jkge, ncuz,
  { {0x27e70026,0x91fd001c,0x645b066d,0x00000000}},	// [22c0] kinn_, krāj, nsui,
  { {0x201a0032,0x9f4a006d,0xfaa60376,0x00000000}},	//   _تتبع_, robó_, казо,
  { {0x6d5618b1,0x799b00bd,0x27e70014,0x00000000}},	//   paya, _bauw, dinn_,
  { {0x5e5700b5,0xd5af0086,0x186a0002,0x00000000}},	//   _ביטע_, _всi_, дади_,
  { {0x61e40035,0x27e70026,0x76410078,0x00000000}},	//   _mmil, finn_, _atly,
  { {0x27e707cf,0xf0930047,0xda660049,0x00000000}},	//   ginn_, ינד_, _لاري,
  { {0x7dc30019,0xab64005b,0xbcfb18b2,0x00000000}},	//   _tõst, rdüğ, _idéa,
  { {0x69cb00bd,0x6b9c014f,0xd378007d,0x00000000}},	//   ckge, _harg, mići_,
  { {0xb4cc0161,0xd467000a,0xb4be0161,0x00000000}},	//   रने_, виње_, ीने_,
  { {0x674502f4,0x43940001,0x799b0051,0x00000000}},	//   čují, ћанс, _zauw,
  { {0xd6c4007e,0xad9b0024,0xa3e30053,0x00000000}},	//   _حمای, _skúm, _नगर_,
  { {0xdb1c18b3,0x6b9c18b4,0x38690734,0x00000000}},	//   _coré, _larg, šare_,
  { {0xdb1c0003,0xa2630013,0x50670062,0x00000000}},	//   _doré, _huố, ътна,
  { {0x9f580024,0xbcfb0025,0x3f850024,0x00000000}},	//   torá_, _ndéa, ýlu_,
  { {0x9e07019d,0xb0620072,0x3ea50014,0x00000000}},	//   вчал, _äänn, ílt_,
  { {0xa263001b,0x69c018b5,0x200300c2,0x00000000}},	//   _muố, _nome, soji_,
  { {0x9d150612,0x320900a4,0x6b9c050b,0x00000000}},	// [22d0] удач, _ikay_, _barg,
  { {0x6b9c12d8,0xfc3f006d,0x8bd40085,0x00000000}},	//   _carg, _cría_, ажуц,
  { {0x69c0006f,0x65620066,0x6fcb004d,0x00000000}},	//   _bome, _odoh, _lück,
  { {0xceb20047,0x27e7004d,0x69c00764,0x00000000}},	//   _היט_, winn_, _come,
  { {0x6b9c1609,0x26c7001f,0xfc3f006d,0x00000000}},	//   _farg, wyno_, _fría_,
  { {0x628a0146,0xd7f8005e,0x6b9c0bea,0x00000000}},	//   _opfo, куј_, _garg,
  { {0x27e70c35,0xa263008b,0x0654000d,0x00000000}},	//   rinn_, _cuố, атыў,
  { {0x3f9100bd,0x645b18b6,0x69c018b7,0x00000000}},	//   hezu_, tsui, _gome,
  { {0xad9b0024,0x27e70026,0x6b9c005b,0x00000000}},	//   _akúk, pinn_, _yarg,
  { {0x69c00122,0x61e418b8,0x645b18b9,0x00000000}},	//   _zome, _smil, rsui,
  { {0xdb1c0016,0x645b18ba,0x76411310,0x00000000}},	//   _poré, ssui, _utly,
  { {0x66270032,0xc6da00b5,0xcb120063,0x00000000}},	//   _شراك, _אַדר, מלי_,
  { {0xa91d00eb,0x6fcb004d,0x629800be,0x00000000}},	//   _pažy, _küch, _esvo,
  { {0x3a2d0122,0x68e40139,0x69da005f,0x00000000}},	//   _liep_, úidi, _įtem,
  { {0xa263001b,0x7dca0026,0x2fc50014,0x00000000}},	//   _xuố, _hýsi, ölga_,
  { {0xa01b00ea,0x63b50006,0xd378007d,0x00000000}},	//   gtöb, šanč, vići_,
  { {0x69c018bb,0x6da3005a,0xb8860080,0x00000000}},	// [22e0] _rome, щита, _kníž,
  { {0xa01b00fe,0x69c018bc,0xd378007d,0x00000000}},	//   ttöe, _some, tići_,
  { {0x7794006a,0xc332014e,0x7dca0026,0x00000000}},	//   ییرا, צוא_, _lýsi,
  { {0x6b9c014f,0x9f580268,0xbcfb006d,0x00000000}},	//   _warg, forç_, _idén,
  { {0x2d9201f7,0x6fcb00bd,0x6b9c18bd,0x00000000}},	//   meye_, _büch, _targ,
  { {0x6fcb0199,0x69c00034,0x2d920058,0x00000000}},	//   _rück, _wome, leye_,
  { {0x96f80076,0xa263008b,0xb7650086,0x00000000}},	//   ъект_, _quố, ртій,
  { {0x7a8b0063,0x7c2e18be,0x2d92107b,0x00000000}},	//   _אָמַ, _hibr, neye_,
  { {0x7c2e0035,0x27e5006d,0xf74618bf,0x00000000}},	//   _kibr, _fmln_, _безо,
  { {0x54330021,0x7c2e0c12,0x66da0121,0x00000000}},	//   حرير, _jibr, _пьер_,
  { {0x3f91017f,0x2d92005b,0x0bb70063,0x00000000}},	//   vezu_, keye_, אלים_,
  { {0x6fcb004d,0x7c2e0653,0xc2b70054,0x00000000}},	//   _züch, _libr, улює_,
  { {0x7c2e0027,0x2d921357,0x3f91007d,0x00000000}},	//   _oibr, deye_, tezu_,
  { {0xddc700c2,0xed590078,0x403408a8,0x00000000}},	//   dujš, _žž_, серс,
  { {0x6298017f,0x3f910b59,0xa6f80063,0x00000000}},	//   _usvo, rezu_, דִּי,
  { {0xb8860024,0x7c2e0025,0xb03509c2,0x00000000}},	//   _zníž, _aibr, _книш,
  { {0x3a2d006f,0xdb6b0086,0xcb55005e,0x00000000}},	// [22f0] _riep_, ерел_, иваћ,
  { {0xcb68005e,0x00000000,0x00000000,0x00000000}},	//   лађе_,   ,   ,
  { {0x795902b3,0xfc3f0046,0x7c2e18c0,0x00000000}},	//   виер_, _grín_, _dibr,
  { {0x2d920058,0x442e18c1,0x0dcb0044,0x00000000}},	//   ceye_, _lif_, _أبدى_,
  { {0xbcfb0003,0x9984003b,0x6d4d18c2,0x00000000}},	//   _idéo, _simţ_, mbaa,
  { {0x6d4d0250,0xdcfd001c,0x3669005e,0x00000000}},	//   lbaa, _lasī, вако_,
  { {0x45d506cb,0x1995000d,0xd3780130,0x00000000}},	//   ицит, _кавя, niću_,
  { {0xb8860080,0x6d4d0173,0x05a90b3f,0x00000000}},	//   _sníž, nbaa, твий_,
  { {0xe456000d,0x9c890086,0x6fcb004d,0x00000000}},	//   ажы_, ерiа, _tüch,
  { {0x98170021,0xc4e2000d,0x442e18c3,0x00000000}},	//   _إبرا, іжэй, _cif_,
  { {0x6d4d0102,0x629e18c4,0x6b6000ea,0x00000000}},	//   kbaa, _špor, lágí,
  { {0x78a90031,0x601200b9,0x10a6042c,0x00000000}},	//   _krev, ræmm, аимн,
  { {0x21a30076,0x6d4d006f,0x442e0150,0x00000000}},	//   циям, dbaa, _fif_,
  { {0x7dd800ed,0x442e18c5,0x644918c6,0x00000000}},	//   _míse, _gif_, mpei,
  { {0x2d92005b,0x6d4d006f,0x644900d1,0x00000000}},	//   teye_, fbaa, lpei,
  { {0x6d4d18c7,0x3860074f,0x645d0078,0x00000000}},	//   gbaa, širi_, šsiu,
  { {0x61fd00ea,0x2d92005b,0x6281087d,0x00000000}},	// [2300] érle, reye_, ltlo,
  { {0x628100ca,0x2d9218c8,0x8e760094,0x00000000}},	//   otlo, seye_, _кумч,
  { {0xfc3f006d,0x7f5c13db,0x628117ed,0x00000000}},	//   _frío_, marq, ntlo,
  { {0x2251027d,0x78a90dd1,0x180e0053,0x00000000}},	//   ázky_, _brev, ित्व_,
  { {0x913b00b5,0x38600d23,0x4c670086,0x00000000}},	//   דענק, éir_, _киян_,
  { {0xe66606b6,0x6f09005b,0x7f5c18c9,0x00000000}},	//   атио, şece, narq,
  { {0x644900e8,0x442e18ca,0xd910005d,0x00000000}},	//   epei, _rif_, _کیش_,
  { {0x69d918cb,0x7e610026,0x7dd80025,0x00000000}},	//   chwe, álpi, _físe,
  { {0x62810051,0xdb1c0118,0x030b0053,0x00000000}},	//   etlo, _morí, _सुबह_,
  { {0x66e608ac,0x03c61849,0x2bfb0042,0x00000000}},	//   _коза, рсим, ्वयं_,
  { {0xe7370076,0x442e0003,0x69cd004b,0x00000000}},	//   _тех_, _vif_, öaeg,
  { {0x92570076,0xd378007d,0xb80e0082,0x00000000}},	//   шают_, viću_, ितकम_,
  { {0x909818cc,0x7dd118cd,0x10740071,0x00000000}},	//   авят_, _såso, оляю,
  { {0xdbcf0066,0x7f5c0e1f,0xc8840058,0x00000000}},	//   sľúb, garq, mağı_,
  { {0x6d4d0179,0x63bc0026,0xdb23005b,0x00000000}},	//   tbaa, örnu, ürün,
  { {0xcdd80138,0x6d4d00e8,0x629d008f,0x00000000}},	//   ању_, ubaa, āsot,
  { {0xdce601f7,0x7f5c18ce,0xd904007e,0x00000000}},	// [2310] _bakı, barq, _آی_,
  { {0x6d4d1038,0x2b58003b,0x6e2418cf,0x00000000}},	//   sbaa, _cerc_, amib,
  { {0xd8b8006a,0x6d4d0250,0xfc3f006d,0x00000000}},	//   یدها_, pbaa, _trío_,
  { {0xf99303eb,0x7dd80080,0x78a918d0,0x00000000}},	//   تبط_, _píse, _prev,
  { {0xe0df01f4,0xcdb60063,0xaf08005d,0x00000000}},	//   nzò_, _הפרה_, _مقیم_,
  { {0xec360063,0x2bc80002,0xf8070002,0x00000000}},	//   _לאשר_, _кусо_, шчен,
  { {0x5a44000d,0x6b60013d,0xb6580085,0x00000000}},	//   _мэта, ságí, ашых_,
  { {0x29f800c3,0x973c007d,0xdce80022,0x00000000}},	//   nčal_, _raće, śląs,
  { {0xdce601f7,0x7c250025,0x95c8018e,0x00000000}},	//   _yakı, omhr, руја_,
  { {0x3cff0161,0xe2990001,0xa3e10053,0x00000000}},	//   _रखने_, гао_, नों_,
  { {0x11d60032,0x644918d1,0x7c250025,0x00000000}},	//   متحد, spei, imhr,
  { {0x9f51000f,0x644918d2,0x395d002b,0x00000000}},	//   kozó_, ppei, naws_,
  { {0xc884005b,0xd4690184,0x7f5c0b6d,0x00000000}},	//   cağı_, _силе_, tarq,
  { {0xd91a0047,0x7dca0026,0xa01b0072,0x00000000}},	//   טורל, _lýst, ttöa,
  { {0x6fd000c7,0x7f5c0e57,0xdce60058,0x00000000}},	//   _häck, rarq, _rakı,
  { {0x6e2400a4,0x660918d3,0x25bf18d4,0x00000000}},	//   umib, noek, njul_,
  { {0x2b5800ea,0x6e2400ea,0x5b36009e,0x00000000}},	// [2320] _perc_, rmib, معار,
  { {0x660900e8,0x2f56018b,0x83fd00ea,0x00000000}},	//   hoek, _утис, lsőb,
  { {0x4e1a006a,0x7dd80026,0x6fd00137,0x00000000}},	//   _متحد_, _vísb, _läck,
  { {0x60120014,0x200a18d5,0xc8840058,0x00000000}},	//   dæmi, lobi_, yağı_,
  { {0xc7c60432,0xdce6005b,0x660900ca,0x00000000}},	//   йски, _takı, doek,
  { {0x9ad6000d,0xdb1c00be,0x7dca0195,0x00000000}},	//   _любі, _corã, _výsu,
  { {0xe0df051e,0x91fd008f,0x8f9b0063,0x00000000}},	//   zzò_, nsāc, ריצי,
  { {0xd6d90086,0xc884005b,0x6fd018d6,0x00000000}},	//   шті_, tağı_, _bäck,
  { {0xdb1c0268,0x200a18d7,0x288b0043,0x00000000}},	//   _horà, kobi_, _مصلی_,
  { {0x764a00cf,0x6fd00137,0x91fd008f,0x00000000}},	//   ppfy, _däck, ksāc,
  { {0x200a00c3,0x51f90086,0x9f5800ea,0x00000000}},	//   dobi_, иною_, ború_,
  { {0x38600130,0xe45a0054,0xe57900a3,0x00000000}},	//   širu_, _бжд_, ghŷd_,
  { {0xe3af007e,0x200a1310,0x91fd008f,0x00000000}},	//   ذری_, fobi_, drāt,
  { {0xe0df01f4,0xe47b009a,0x44f3014b,0x00000000}},	//   rzò_, _ערוכ, _эпіс,
  { {0x6fd000bd,0xe2460067,0x200f0078,0x00000000}},	//   _mäch, _اختي, _ūgis_,
  { {0x6fd0004d,0x9f5100ea,0x8e150454,0x00000000}},	//   _läch, tozó_, ідац,
  { {0x91a9001b,0xf1f8006a,0x320b0051,0x00000000}},	// [2330] _giá_, _دعوت_, mocy_,
  { {0x660902b0,0x6fd000bd,0x44d4008b,0x00000000}},	//   zoek, _näch, ì_,
  { {0x6fb5006a,0x3ce0007d,0xcb1b0002,0x00000000}},	//   _همکا, aziv_, уќа_,
  { {0x7dd10146,0x61ef18d8,0x60120026,0x00000000}},	//   _måsk, nicl, væmi,
  { {0x89340032,0x7dca0114,0x229a001c,0x00000000}},	//   أعما, _výst, _lūk_,
  { {0x6fd000c7,0x29f8085a,0x61ef18d9,0x00000000}},	//   _räck, nčaj_, hicl,
  { {0x9f580024,0xa01b18da,0x2ca918db,0x00000000}},	//   torú_, ytön, lvad_,
  { {0xe6190079,0x59f90076,0x3ebe00fe,0x00000000}},	//   јди_, _тебя_, ätti_,
  { {0x44390016,0x660918dc,0x6fd0004d,0x00000000}},	//   ês_, roek, _fäch,
  { {0x6609021f,0x6498011c,0xdb1c18dd,0x00000000}},	//   soek, стър_, _horá,
  { {0xdb1c000f,0x44d4001b,0x2ca9004b,0x00000000}},	//   _korá, à_, hvad_,
  { {0x6fd000c7,0x29f800a8,0x412a02f8,0x00000000}},	//   _täck, ečaj_, ионо_,
  { {0x349415ba,0xa01b18de,0xdb1c18df,0x00000000}},	//   _нацр, rtön, _morá,
  { {0x34b2006a,0x232918e0,0x8c42005b,0x00000000}},	//   _آموز, _коли_, üğme,
  { {0x443f0164,0xa01b0026,0x200a18e1,0x00000000}},	//   lqu_, mtöl, robi_,
  { {0xa01b000f,0x61ef18e2,0x63a318e3,0x00000000}},	//   ltöl, cicl, _hann,
  { {0x7dd80080,0x443f18e4,0x2f2318e5,0x00000000}},	// [2340] _císa, nqu_, tégé_,
  { {0x443f18e6,0xab660086,0xa01b1471,0x00000000}},	//   iqu_, івел, ntöl,
  { {0x2ca90019,0x5fb70063,0x3f9818e7,0x00000000}},	//   avad_, _והיא_, meru_,
  { {0x9f990026,0x63a318e8,0xdb1c006d,0x00000000}},	//   láðu_, _lann, _corá,
  { {0x91a0001b,0x26ce002b,0xdced008f,0x00000000}},	//   _chỉ_, wyfo_, reaģ,
  { {0x6d44051e,0x3cff0053,0x6fcb005b,0x00000000}},	//   lcia, _रखते_, _hücr,
  { {0xdb1c0331,0x6d4418e9,0xfa6718ea,0x00000000}},	//   _forá, ocia, _марк_,
  { {0x39420004,0x7bc70122,0x63a30250,0x00000000}},	//   _üks_, _zoju, _aann,
  { {0x224900c3,0xa01b0014,0x44d40013,0x00000000}},	//   _čaka_, ftöl, ù_,
  { {0x657b002c,0x69c204c6,0x7dd118eb,0x00000000}},	//   aguh, ljoe, _påsk,
  { {0x764800d1,0x61ef02a0,0x63a318ec,0x00000000}},	//   _utdy, ticl, _dann,
  { {0xa01b00fe,0x63a30025,0x51f8007f,0x00000000}},	//   ttöo, _eann, жнюю_,
  { {0x85f90047,0x2d8700ea,0x44f6007e,0x00000000}},	//   _פּעק, őnek_, _بساز,
  { {0x63a3035a,0x80270021,0xa3ce0042,0x00000000}},	//   _gann, ترجم, _रवि_,
  { {0xbcfb0016,0xfeb8006a,0x9f340086,0x00000000}},	//   _idéi, يافت_, дері,
  { {0x65600025,0x7dd801d9,0x7bca0026,0x00000000}},	//   namh, _písa, öfun,
  { {0xad9b0024,0x61ed017f,0x65600035,0x00000000}},	// [2350] _skús, _imal, iamh,
  { {0xdb1c00ea,0x7dd80026,0x2ca918ed,0x00000000}},	//   _sorá, _vísa, rvad_,
  { {0x61ed00c3,0x2ca9004b,0xdb1c0061,0x00000000}},	//   _kmal, svad_, _porá,
  { {0x6d4402f6,0xfe9a00b5,0xf1bf18ee,0x00000000}},	//   ccia, _פירמ, zmán_,
  { {0x6d5d003d,0xa01b0072,0x6aae004d,0x00000000}},	//   _iesa, ytöl, _erbf,
  { {0x6d5d04ab,0x65600025,0xb6590076,0x00000000}},	//   _hesa, eamh, бших_,
  { {0x69c200e8,0xba74006a,0x6d5d014f,0x00000000}},	//   bjoe, _يافت, _kesa,
  { {0xfb340088,0x9f4300fe,0xe7080021,0x00000000}},	//   _інтэ, lijä_, غتون_,
  { {0xa01b00fe,0x6d5d18ef,0x3f980089,0x00000000}},	//   ttöl, _mesa, yeru_,
  { {0x61ed18f0,0x7c3d0150,0x33d40054,0x00000000}},	//   _amal, _musr, діют,
  { {0x443f03b2,0xa01b0026,0x63a318f1,0x00000000}},	//   squ_, rtöl, _vann,
  { {0x63a30102,0xdb1c0146,0x6d5d18f2,0x00000000}},	//   _wann, _foræ, _nesa,
  { {0x63a318f3,0xe20b0026,0xddce00c2,0x00000000}},	//   _tann, _slóð_, jubš,
  { {0xf8a504de,0x69db0857,0xa01b0072,0x00000000}},	//   _یک_, _llue, ltöj,
  { {0x6d5d014f,0x7c3d00bd,0x9f99007a,0x00000000}},	//   _besa, _ausr, ráðu_,
  { {0xa01b00fe,0x60120026,0xf1bf0014,0x00000000}},	//   ntöj, væmu, nmál_,
  { {0x6d5d18f4,0xdd8f0021,0x6d4418f5,0x00000000}},	// [2360] _desa, طول_, rcia,
  { {0x6d44051e,0x69db024a,0xac830085,0x00000000}},	//   scia, _alue, эгул,
  { {0x6d4405ab,0xcf570063,0xdce80058,0x00000000}},	//   pcia, _מבית_, ğlıs,
  { {0x6d5d18f6,0xb23a00b5,0x79a30b3f,0x00000000}},	//   _gesa, צענז, ерше,
  { {0x2d8200c7,0x27ec0150,0x9f4a01a8,0x00000000}},	//   _icke_, _pmdn_, hibí_,
  { {0x69c212f9,0x569418f7,0x69db18f8,0x00000000}},	//   sjoe, дакт, _elue,
  { {0x644b0078,0x91fd008f,0x69db18f9,0x00000000}},	//   _atgi, krāp, _flue,
  { {0x75e6000d,0x7c3d0052,0x44b402d8,0x00000000}},	//   яўле, _yusr, дбис,
  { {0xdb1c005b,0x65600014,0x9f940072,0x00000000}},	//   _borç, ramh, _kää_,
  { {0xa01b00fe,0x656018fa,0x443d001f,0x00000000}},	//   ttöm, samh, _duw_,
  { {0x394605d5,0x656000a4,0x386618fb,0x00000000}},	//   ocos_, pamh, lsor_,
  { {0x394618fc,0x1a9b0047,0xd49a0141,0x00000000}},	//   ncos_, זיטע, _грк_,
  { {0xdb1c18fd,0x386618fe,0x7dd80080,0x00000000}},	//   _forç, nsor_, _písn,
  { {0x925704de,0x7a230019,0x6d5d0da3,0x00000000}},	//   _کشور_, mõte, _sesa,
  { {0x6d5d18ff,0x7c3d1900,0xb17b00b9,0x00000000}},	//   _pesa, _susr, rhåb,
  { {0x42fb014e,0x61ed1901,0x7c3d0078,0x00000000}},	//   _להוס, _umal, _pusr,
  { {0x6d5d13c7,0xc882003b,0x4c941902,0x00000000}},	// [2370] _vesa, nuşă_, нитс,
  { {0x3946006d,0x69db00ac,0x2d82004d,0x00000000}},	//   ecos_, _slue, _ecke_,
  { {0xdb580076,0x69da0006,0xdd0c0051,0x00000000}},	//   яют_, _įter, góło,
  { {0x61fd007a,0xa5bd0078,0xc3330063,0x00000000}},	//   nnsl, amųj, גוע_,
  { {0xe73906da,0x78a60066,0x271c0013,0x00000000}},	//   оел_, _škvr, _ản_,
  { {0x27c70076,0x443d006f,0x945d0051,0x00000000}},	//   ящег, _ruw_, zyńs,
  { {0x56920d34,0x25a60139,0x64460014,0x00000000}},	//   вајт, _baol_, íkin,
  { {0x25a60025,0x39461903,0xcb340062,0x00000000}},	//   _caol_, ccos_, _чесъ,
  { {0xdb1c017d,0xa01b0014,0xf1bf1904,0x00000000}},	//   _porç, gtök, rmál_,
  { {0xa3e90636,0xa01b0072,0x395f01a8,0x00000000}},	//   ідна_, stöj, _heus_,
  { {0x395f006f,0xf3f10013,0xfc3f0139,0x00000000}},	//   _keus_, rị_, _luí_,
  { {0x25a60d12,0xa01b0072,0x6721007d,0x00000000}},	//   _gaol_, ltöh, _izlj,
  { {0x644b02f0,0x395f0bc8,0x55ac0047,0x00000000}},	//   _utgi, _meus_, _ליאַ,
  { {0x7dd80024,0x61fd1905,0xe8200053,0x00000000}},	//   _píso, ansl, यतया_,
  { {0x39461906,0x43920141,0x7413005d,0x00000000}},	//   ycos_, _рајс, _قوچا,
  { {0xe1f2007e,0x2613017d,0x395f1907,0x00000000}},	//   _جست_, mãos_, _neus_,
  { {0x39a60812,0xfc3f0025,0x9f9400fe,0x00000000}},	// [2380] _jūsų_, _cuí_, _pää_,
  { {0x39a600eb,0xafdb0dfb,0x3ebe0137,0x00000000}},	//   _mūsų_, spør, ätts_,
  { {0xa5bd0078,0xbad5000d,0x9f9401cf,0x00000000}},	//   rmųj, ніцы, _vää_,
  { {0xa01b0072,0x3866013d,0x39460023,0x00000000}},	//   ytök, tsor_, ucos_,
  { {0x395f1908,0x39461909,0x9f940072,0x00000000}},	//   _deus_, rcos_, _tää_,
  { {0x77630268,0x7a230019,0x25a60025,0x00000000}},	//   ganx, võte, _saol_,
  { {0x61fd0026,0xa3b10053,0x395f01a8,0x00000000}},	//   ynsl, _ऑफ़_, _feus_,
  { {0x26130016,0x2d80190a,0xa01b190b,0x00000000}},	//   dãos_, ngie_, ttök,
  { {0xd49a0086,0xd4060505,0x211d0042,0x00000000}},	//   іри_, дяни, _नरेश_,
  { {0x9f580024,0x628800df,0x2613017d,0x00000000}},	//   torý_, ttdo, fãos_,
  { {0x26130016,0xdb1c0205,0xa01b190c,0x00000000}},	//   gãos_, _forå, stök,
  { {0x22ac004c,0x62880934,0xa01b0014,0x00000000}},	//   _věk_, rtdo, ptök,
  { {0x7dd101e3,0x9f580331,0x6288114f,0x00000000}},	//   _måst, joró_, stdo,
  { {0x7dd108a9,0x251b009a,0xd6e2056c,0x00000000}},	//   _låst, _וודא, pułą_,
  { {0x2ca0001f,0xfc3f0139,0xa01b0072,0x00000000}},	//   ewid_, _suí_, ntöi,
  { {0x442c006f,0x2d800caf,0x644f0139,0x00000000}},	//   lmd_, ggie_, ícig,
  { {0x395f190d,0xfc3f190e,0x442c00ca,0x00000000}},	// [2390] _reus_, _quí_, omd_,
  { {0x395f13ff,0xd83814d5,0x1b7b0044,0x00000000}},	//   _seus_, _nič_, تصرة_,
  { {0xe1ff006d,0x395f00cd,0x442c006f,0x00000000}},	//   onó_, _peus_, imd_,
  { {0x3ebe0031,0x2011017f,0x9f58006d,0x00000000}},	//   åtte_, lozi_, boró_,
  { {0x7b67184a,0x6e2d190f,0x395f00cd,0x00000000}},	//   _отве, mmab, _veus_,
  { {0x7b74007e,0x907c0047,0x39520058,0x00000000}},	//   _لطفا, קטוי, ıysa_,
  { {0x395f14b1,0xe7361910,0xe80e0042,0x00000000}},	//   _teus_, неш_, ाक़ा_,
  { {0x442c016d,0x38c30078,0xdcef0058,0x00000000}},	//   emd_, tūrą_, _hacı,
  { {0x66021911,0x601200b9,0x91fd008f,0x00000000}},	//   _djok, kæmp, rsāl,
  { {0x69d90104,0xa9230078,0x57270043,0x00000000}},	//   lkwe, įžda, _قراق,
  { {0xd24e006a,0x7dd81912,0xd6d10021,0x00000000}},	//   ینی_, _sísm, _حقا_,
  { {0xe1ff006d,0x7dd80240,0x442c006f,0x00000000}},	//   gnó_, _písm, amd_,
  { {0x764100a4,0xa3d50ac5,0xea00008b,0x00000000}},	//   _huly, _подч, hiết_,
  { {0x2011051e,0x661b0659,0x4033000d,0x00000000}},	//   gozi_, lluk, леўс,
  { {0x44270199,0x9f4a00cd,0x76410089,0x00000000}},	//   _ihn_, ribà_, _july,
  { {0x764100f3,0x45b500b5,0xb17b00d1,0x00000000}},	//   _muly, עפּל_, lhån,
  { {0x91fd003d,0x921700b5,0x0c260ae8,0x00000000}},	// [23a0] ksāj, _אַזױ_, еман,
  { {0xfc3f0027,0x4427004d,0x69d91913,0x00000000}},	//   _arís_, _jhn_, ekwe,
  { {0x2f5b0132,0x9f580290,0xdb1c0066,0x00000000}},	//   _מדינ, borò_, _horú,
  { {0x6a16007e,0x69d900a4,0xdb1c0066,0x00000000}},	//   ربار, gkwe, _korú,
  { {0x661b0388,0x442c1914,0x6d3b0063,0x00000000}},	//   dluk, ymd_, _מתכנ,
  { {0x660200d1,0xfb56007e,0x998d0066,0x00000000}},	//   _sjok, _سپرد, _vieš_,
  { {0x09e60086,0x69961915,0x661b1916,0x00000000}},	//   _зовн, _прах, fluk,
  { {0x7bce0019,0x7641002b,0x69d91917,0x00000000}},	//   _hobu, _duly, ckwe,
  { {0xa01b0cb0,0x44980054,0xb4da0042,0x00000000}},	//   stöi, євою_, ठने_,
  { {0x443801e3,0xa01b00fe,0xb8d40053,0x00000000}},	//   ör_, ltöv, जट_,
  { {0x45e400aa,0x442c1918,0x79820051,0x00000000}},	//   _đượ, rmd_, ogow,
  { {0x79820051,0xdb0e0137,0x04460002,0x00000000}},	//   ngow, _inbä, _зедн,
  { {0x9f580290,0xe1ff1919,0xd5e90021,0x00000000}},	//   vorò_, rnó_, _تعلن_,
  { {0x29f80024,0x644f03ea,0x6d43004c,0x00000000}},	//   očas_, ície, ěnam,
  { {0x6e940612,0xce940062,0x2004191a,0x00000000}},	//   лиру, ларъ, émia_,
  { {0x63aa007a,0x6e2d00a4,0xfc3f0014,0x00000000}},	//   _hafn, umab, _asía_,
  { {0x7dd8191b,0x6e2d191c,0x4427004d,0x00000000}},	// [23b0] _získ, rmab, _yhn_,
  { {0x63aa007a,0x64420290,0xfbd3007e,0x00000000}},	//   _jafn, _muoi, دتر_,
  { {0xa036014e,0x9f8f004b,0x29d70058,0x00000000}},	//   _שאתה_, _müü_, _uçak_,
  { {0x9f58007a,0xdb0e017d,0x91a00013,0x00000000}},	//   lorð_, _robô, _khí_,
  { {0x99140086,0x69d9191d,0x76410078,0x00000000}},	//   льші, rkwe, _suly,
  { {0x63aa007a,0x62980162,0x36950071,0x00000000}},	//   _nafn, _opvo, вшис,
  { {0xd7050062,0x67d20002,0x35a50085,0x00000000}},	//   ъзки, роју, вайг,
  { {0xceb411b4,0xa8490021,0xf9930049,0x00000000}},	//   ריק_, _يلزم_, _حبس_,
  { {0x661b191e,0x7dd80025,0x64420290,0x00000000}},	//   rluk, _dísh, _cuoi,
  { {0x91aa0053,0x7dd8004c,0x6724004c,0x00000000}},	//   _जोड़े, _písk, řija,
  { {0xd6db0055,0xb17b191f,0x386d1920,0x00000000}},	//   _эта_, rhån, _hver_,
  { {0x9998001c,0xb17b0093,0xdb1c0066,0x00000000}},	//   _kurš_, shån, _porú,
  { {0x91a0008b,0xb17b0137,0xd1320021,0x00000000}},	//   _chí_, mhål, شمس_,
  { {0xb4bf016a,0xa0a3018e,0x25ad000e,0x00000000}},	//   ीही_, јард, ldel_,
  { {0x91a0008b,0x25ad1921,0x7bce1014,0x00000000}},	//   _thì_, odel_, _robu,
  { {0xbcfb0003,0x386d1922,0xb17b0137,0x00000000}},	//   _adéq, _over_, nhål,
  { {0x9f580026,0xe7f20053,0x600a005e,0x00000000}},	// [23c0] borð_, _अगला_, _оним_,
  { {0x248d0f2f,0xeafa0593,0x80890044,0x00000000}},	//   item_, ورات_, _أضيف_,
  { {0x386d02f6,0x6f790047,0xaf770047,0x00000000}},	//   _aver_, _אָרג, _בעיס_,
  { {0xe9da0086,0xe8fa0076,0xc332089e,0x00000000}},	//   ьке_, мле_, בוב_,
  { {0x7bce0006,0x25ad1923,0x88e60062,0x00000000}},	//   _tobu, ddel_, ъжде,
  { {0x248d040d,0xa01b1924,0xb17b0137,0x00000000}},	//   dtem_, stöv, ehål,
  { {0x386d0034,0x7c3c0072,0x39840043,0x00000000}},	//   _ever_, _iirr, _میاف,
  { {0x63aa0026,0xdbe30003,0xa01b1925,0x00000000}},	//   _safn, _réél, ltöt,
  { {0x64420164,0x9987000c,0x248d004d,0x00000000}},	//   _quoi, ţiţi_, gtem_,
  { {0x3202034d,0x660d0599,0xa85703c3,0x00000000}},	//   enky_, čaka, _סיבה_,
  { {0x5b7b0063,0x51f901dd,0x7c3c1926,0x00000000}},	//   וריא, енню_, _mirr,
  { {0x91a0001b,0x91a9001b,0xcb130132,0x00000000}},	//   _phí_, _khả_, ילת_,
  { {0x248d03ea,0x7cda008f,0x9f8f0058,0x00000000}},	//   ctem_, _jārā, _tüü_,
  { {0xdb1c0d02,0x2005004b,0x320201d1,0x00000000}},	//   _forø, õli_, anky_,
  { {0x9f580ac6,0x9294000d,0xdef4000d,0x00000000}},	//   rorð_, _сайц, апры,
  { {0x3253011c,0x22510066,0x443c1927,0x00000000}},	//   _твър, ízke_, _hiv_,
  { {0x7c3c1928,0xbddb18e6,0xcfab0044,0x00000000}},	// [23d0] _birr, _lièg, _قادم_,
  { {0x7c84018e,0xcb54005e,0x9c190021,0x00000000}},	//   јуте, ивућ, رياء_,
  { {0x443c00e8,0x0b880062,0x248d1929,0x00000000}},	//   _miv_, ъсти_, ztem_,
  { {0x443c06a3,0xaa58005e,0xe2930047,0x00000000}},	//   _liv_, тицу_, יװע_,
  { {0x248d0080,0x75fe008f,0x20030130,0x00000000}},	//   xtem_, cīzi, onji_,
  { {0x6e3d192a,0x77840054,0x8c440058,0x00000000}},	//   _hisb, иліз, üşer,
  { {0xa01b00fe,0x2f980063,0xb17b0137,0x00000000}},	//   ltös, דכון_, thål,
  { {0x06960032,0x26c9017f,0x248d1929,0x00000000}},	//   انية_, ćao_, ttem_,
  { {0xb17b00c7,0x248d192b,0xdced007d,0x00000000}},	//   rhål, utem_, ogađ,
  { {0x7dd80026,0xb17b0137,0x6e3d192c,0x00000000}},	//   _vísi, shål, _lisb,
  { {0x2003065f,0x17f80021,0xf6550002,0x00000000}},	//   dnji_, _شركة_, _свеќ,
  { {0x248d192d,0x6e3d192e,0x64b50049,0x00000000}},	//   ptem_, _nisb, _محتر,
  { {0x69cb006f,0x2004017d,0xe3ae005e,0x00000000}},	//   ijge, émio_, _лб_,
  { {0x443c18a4,0x75fe001c,0x93bc003b,0x00000000}},	//   _giv_, vīzi, umăt,
  { {0x6e3d0268,0xf3f00032,0x93bc000c,0x00000000}},	//   _bisb, _بأن_, rmăt,
  { {0x62811360,0x2003192f,0x65690656,0x00000000}},	//   mulo, anji_, naeh,
  { {0x6e3d1930,0x6b560086,0x61e41931,0x00000000}},	// [23e0] _disb, гтех, _ilil,
  { {0xa01b004d,0xfc3f0139,0x62811932,0x00000000}},	//   eröf, _tsín_, oulo,
  { {0x61e40da5,0xdce40078,0x4a9a000d,0x00000000}},	//   _klil, maič, этаў_,
  { {0x7cda003d,0x8e7b0047,0x7c3c03a7,0x00000000}},	//   _pārā, _אנטה, _wirr,
  { {0xbddb0164,0xd9170304,0x24491933,0x00000000}},	//   _sièg, льш_, _núm_,
  { {0xf1bf00ea,0x62811934,0xbddb0003,0x00000000}},	//   lmát_, kulo, _pièg,
  { {0x1ae60076,0x998d0024,0x61f60114,0x00000000}},	//   _совм, _sieť_, _omyl,
  { {0xa01b00c7,0x7bde00c7,0x91a9008b,0x00000000}},	//   ntör, lkpu, _thả_,
  { {0xd910006a,0xdce41935,0x69c01936,0x00000000}},	//   _بیش_, kaič, _inme,
  { {0x644f1937,0x27f8005b,0x61e41938,0x00000000}},	//   ícia, _örn_, _alil,
  { {0x2c170047,0xa01b04b3,0x92940085,0x00000000}},	//   רקיש_, ktör, шанц,
  { {0xa01b024a,0xe1350076,0x15461939,0x00000000}},	//   ytös, инны, _седм,
  { {0x2003007d,0x6e3d00c2,0x63a1193a,0x00000000}},	//   tnji_, _risb, beln,
  { {0x7d1d00c7,0x6281193b,0x3cff0078,0x00000000}},	//   _ryss, bulo, _žuvo_,
  { {0x9f35019d,0x62811174,0x539b0063,0x00000000}},	//   реві, culo, _ניהו,
  { {0xa01b193c,0x5d55193d,0xddd500ea,0x00000000}},	//   gtör, ркат, tsző,
  { {0x20031253,0x8f55007e,0x6e3d193e,0x00000000}},	// [23f0] pnji_, _پنجش, _visb,
  { {0x9f4b00fe,0x2ef50121,0xb17b0137,0x00000000}},	//   äjät_, _взор, skåd,
  { {0xa01b00fe,0xddd500ea,0x61e40072,0x00000000}},	//   stös, ssző, _ylil,
  { {0x7bde00ac,0x316b0051,0x78a9085a,0x00000000}},	//   akpu, nacz_, _psev,
  { {0xad9b0026,0x42380047,0xa9680021,0x00000000}},	//   _ljúk, אנאל_, امهم_,
  { {0x69c00331,0x3858007e,0x2d840058,0x00000000}},	//   _enme, اشند_, _ömer_,
  { {0x65c50076,0x0f580063,0xbddb0003,0x00000000}},	//   ибка, ניהם_, _tièd,
  { {0x660d00c3,0x9f410024,0x0495000d,0x00000000}},	//   čako, _dlhé_, ароў,
  { {0x3a3f00a4,0x63a1193f,0xa78701fb,0x00000000}},	//   _iiup_, teln, _مشاو,
  { {0xb909016a,0x62811940,0x9cd8009a,0x00000000}},	//   मन_, tulo, טוחה_,
  { {0x21290089,0xdce40078,0xa2060363,0x00000000}},	//   _azah_, vaič, ипод,
  { {0xdb070080,0x93bc000c,0xb4950001,0x00000000}},	//   _nají, umăr, _видљ,
  { {0x7dd80080,0x7a230004,0x3d040161,0x00000000}},	//   _míst, võtl, _रखें_,
  { {0xdff5000d,0x25af1941,0x30750121,0x00000000}},	//   бясь, _hagl_, щуюс,
  { {0x316b0045,0xb7f80053,0xa01b1942,0x00000000}},	//   bacz_, ्चतम_, ttör,
  { {0x61e40035,0x9046005d,0x00000000,0x00000000}},	//   _ulil, _پنده,   ,

  { {0xdb0500b9,0xf1bf1092,0x75fe008f,0x00000000}},	// [2400] ndhæ, amás_, cīzu,
  { {0x8b260088,0xa01b1943,0x3ff30044,0x00000000}},	//   адзе, stör, _وكير,
  { {0xa01b0b35,0x20181944,0x2367013d,0x00000000}},	//   ptör, mori_, _menj_,
  { {0x20181945,0xf2960047,0x82960047,0x00000000}},	//   lori_, יכער_, ידעס_,
  { {0xc7c600d7,0x9f511946,0xaf36007e,0x00000000}},	//   иски, lizá_, _حرکت,
  { {0xdb070080,0x22400019,0x6aba013d,0x00000000}},	//   _zají, _liik_, _átfo,
  { {0xb765019d,0xa5f803ec,0xdb0500b9,0x00000000}},	//   стій, леку_, edhæ,
  { {0x2018001f,0xd5b709d2,0xba5700ff,0x00000000}},	//   hori_, ась_, _כסלו_,
  { {0xa4f8007e,0xad9b0026,0xe4e60054,0x00000000}},	//   دکار_, _sjúk, рійн,
  { {0x47aa0021,0x224700e5,0xe3b80058,0x00000000}},	//   _جارٍ_, _bunk_, alın_,
  { {0x91fd003d,0x20181947,0x0bb70063,0x00000000}},	//   ksāt, dori_, בלים_,
  { {0x7dd804a5,0x2251017c,0xd49a1948,0x00000000}},	//   _míss, ízka_, _арк_,
  { {0x764800a4,0xf9930063,0x20181949,0x00000000}},	//   _hudy, חרר_, fori_,
  { {0x7a230004,0xb7f80053,0x75fe008f,0x00000000}},	//   võtm, ्चिम_, rīzu,
  { {0x6235026b,0xbddb0003,0xdb1c194a,0x00000000}},	//   _леку, _nièc, _moró,
  { {0xaac7006a,0x5d780076,0xfe79004c,0x00000000}},	//   یتان, ийся_, čů_,
  { {0x40950021,0x2018194b,0x7dd80066,0x00000000}},	// [2410] _الخر, bori_, _ríst,
  { {0x61fd17f6,0x5ba7007b,0xdd2f004c,0x00000000}},	//   lisl, јраз, _těžc,
  { {0x2ac7005e,0x4ea70002,0xeb48071f,0x00000000}},	//   шљав, _трпа, рчук_,
  { {0x12f90047,0x29d70058,0x7bca0014,0x00000000}},	//   נהײב, _açar_, öfur,
  { {0xa8a70076,0x7dd81795,0x76480022,0x00000000}},	//   ррек, _víst, _audy,
  { {0x387d001f,0x9f580153,0x7648194c,0x00000000}},	//   rrwr_, tiré_, _budy,
  { {0x2ca9001f,0x61fd194d,0x3f7a0041,0x00000000}},	//   lwad_, kisl, אָפע,
  { {0x644f194e,0x61fd194f,0x2a640062,0x00000000}},	//   ício, jisl, _фърг,
  { {0x22400019,0x2ca9001f,0x224700e5,0x00000000}},	//   _riik_, nwad_, _sunk_,
  { {0x61fd0150,0x91fd001c,0x9f580003,0x00000000}},	//   eisl, ksās, piré_,
  { {0x7a230004,0x201804cc,0xdb1c01a8,0x00000000}},	//   võtj, vori_, _horò,
  { {0x515a000d,0x61fd1950,0x78bb1951,0x00000000}},	//   ышоў_, gisl, _kruv,
  { {0x201814b9,0x63c20080,0xa01b0072,0x00000000}},	//   tori_, ávní, ttöp,
  { {0x90d50088,0x20181952,0xe8df008b,0x00000000}},	//   іцяч, uori_, _ngọn_,
  { {0x20181386,0xdee301f6,0x799b0022,0x00000000}},	//   rori_, пори, _obuw,
  { {0xdb1c00bd,0x93bc000c,0x229100ea,0x00000000}},	//   _vorü, plăc, mák_,
  { {0xbddb03b2,0x7bd5005b,0xac0a0002,0x00000000}},	// [2420] _sièc, _bozu, гнаа_,
  { {0xbddb0164,0x6faa0001,0xdb0e006d,0x00000000}},	//   _pièc, _свог_, _habé,
  { {0xfe7201a7,0x3f980093,0x1c390499,0x00000000}},	//   _عدد_, mfru_, рять_,
  { {0xed5a005a,0xb635014b,0xda650044,0x00000000}},	//   _щом_, _кнiз, تاكي,
  { {0xdb1c0051,0xcdb70063,0xd7fa1953,0x00000000}},	//   _poró, _הפכה_, лук_,
  { {0x229100ea,0x78bb0137,0xa09b009f,0x00000000}},	//   kák_, _druv, ריסט,
  { {0x645b0164,0x22911954,0x1be70141,0x00000000}},	//   epui, ják_, _удри_,
  { {0x3ebe00fe,0x442e0865,0xfbc90053,0x00000000}},	//   ätty_, _shf_, राथम,
  { {0x92a80051,0x78bb00df,0x61fd004a,0x00000000}},	//   _małż, _gruv, visl,
  { {0x61fd0185,0x03f80001,0x13f40086,0x00000000}},	//   wisl, рној_, ізня,
  { {0xdb9b0e2a,0x17570063,0x61fd1955,0x00000000}},	//   נסטר, _הסבר_, tisl,
  { {0xd46a0079,0x60dd00fe,0x9293000d,0x00000000}},	//   _биде_, tysm, чаюц,
  { {0x682d0024,0x61fd1956,0x6e24004d,0x00000000}},	//   súde, risl, dlib,
  { {0x6d4600a4,0x6e241957,0x22911958,0x00000000}},	//   _agka, elib, bák_,
  { {0x6397014e,0xdd9b005a,0x7bd51959,0x00000000}},	//   _הדוא_, лша_, _rozu,
  { {0xbcfb00ea,0x7bd5004d,0x2ca900a3,0x00000000}},	//   _idéz, _sozu, twad_,
  { {0xe1ff006d,0x8bd5195a,0x83fd013d,0x00000000}},	// [2430] mió_, ожац, csős,
  { {0xe1ff195b,0x6e24195c,0xdb1c0331,0x00000000}},	//   lió_, alib, _enrí,
  { {0x9f35071f,0xe7c70042,0x539b009a,0x00000000}},	//   _фені, लासप, ריבו,
  { {0x3ebe0146,0xddab01e8,0xe1ff195d,0x00000000}},	//   ætte_, _стол_, nió_,
  { {0x2291195e,0x2bc90082,0x00000000,0x00000000}},	//   zák_, रादा,   ,
  { {0x67d202d8,0xe787195f,0x2bcb0a3a,0x00000000}},	//   дољу, судо, _сумо_,
  { {0x998501fb,0x20040124,0xad27005d,0x00000000}},	//   _ولسو, émii_, _خرگو,
  { {0x91a9001b,0x8af80062,0x7a2a0066,0x00000000}},	//   _nhà_, _унсс_, pýta,
  { {0xe1ff1960,0xb4e30053,0xa5090852,0x00000000}},	//   dió_, नने_, репа_,
  { {0x229100ea,0xe2910021,0xdb0e0331,0x00000000}},	//   ták_, وذج_, _sabé,
  { {0xd1ca0138,0xd5ae007e,0xdb15004d,0x00000000}},	//   алне_, رفی_, _unzä,
  { {0xe1ff1961,0x36340021,0x798b00a4,0x00000000}},	//   gió_, _فرنس, nggw,
  { {0x661b1962,0x6609004b,0x20d6000d,0x00000000}},	//   mouk, mnek, цінс,
  { {0x3eb8007c,0xb143046e,0x661b1963,0x00000000}},	//   tvrt_, ьнял, louk,
  { {0x7f430b0f,0xe1ff0521,0x66091964,0x00000000}},	//   держ, bió_, onek,
  { {0xe1ff1965,0x644300bb,0x644b0035,0x00000000}},	//   ció_, _hini, _kugi,
  { {0x656b000f,0x6e24053b,0x64431966,0x00000000}},	// [2440] _megh, rlib, _kini,
  { {0xdb07000f,0x9f580027,0x62811967,0x00000000}},	//   _sajá, oirí_, orlo,
  { {0x9d461968,0x9f510331,0x661b1969,0x00000000}},	//   _менд, anzó_, kouk,
  { {0x18a60086,0x661b00fe,0x6281006d,0x00000000}},	//   жадм, jouk, irlo,
  { {0x644b1848,0x9c870066,0x6281004d,0x00000000}},	//   _nugi, rečí, hrlo,
  { {0xdb1c0026,0x6443196a,0x6609196b,0x00000000}},	//   _forð, _nini, enek,
  { {0x644b0006,0xdb070014,0x98a30078,0x00000000}},	//   _augi, _snjö, _ąją_,
  { {0xe1ff0268,0x3633007e,0x4425196c,0x00000000}},	//   xió_, وريس, ell_,
  { {0x644300bb,0xe1ff02dd,0x644b0290,0x00000000}},	//   _bini, vió_, _cugi,
  { {0xa2f40086,0x644b007d,0x6443196d,0x00000000}},	//   зпоч, _dugi, _cini,
  { {0xe1ff02dd,0xe3b8005b,0x64430b95,0x00000000}},	//   tió_, llık_, _dini,
  { {0x644307c7,0x4425057a,0x644b196e,0x00000000}},	//   _eini, all_, _fugi,
  { {0xe1ff02dd,0xe3b8005b,0x6281196f,0x00000000}},	//   rió_, nlık_, arlo,
  { {0xe1ff0994,0xbddb0268,0xd2500032,0x00000000}},	//   sió_, _cièn, _كنت_,
  { {0x3a26085a,0x2ee50026,0x7a311310,0x00000000}},	//   klop_, álf_, låte,
  { {0xc3390080,0x62881970,0x2d8f00bd,0x00000000}},	//   čítá, mudo, üge_,
  { {0x7dd8006d,0x5ce70086,0x61ef0025,0x00000000}},	// [2450] _vísp, цюва, mhcl,
  { {0xbc680021,0x93bc003b,0x60c001e1,0x00000000}},	//   تمكن_, zlăn, æmme,
  { {0x62881971,0x66000022,0x7a2a0046,0x00000000}},	//   nudo, kimk, rýtn,
  { {0x66000080,0xda7801dd,0xe3b80058,0x00000000}},	//   jimk, іях_, flık_,
  { {0x998d0024,0x44251972,0x7d2501fb,0x00000000}},	//   _tiež_, yll_, _رفسن,
  { {0x27c70076,0x63a81973,0x1a5b0021,0x00000000}},	//   ющег, jedn, _نشرة_,
  { {0xfbd2014e,0x64590051,0xd6a80021,0x00000000}},	//   _אתם_, _stwi, قديم_,
  { {0x644b0baf,0x64431974,0xb9550062,0x00000000}},	//   _pugi, _sini, _хващ,
  { {0x64431975,0x9990000c,0x973c0022,0x00000000}},	//   _pini, ţaţi_, _waćp,
  { {0x44251976,0x682d0066,0x656b00ca,0x00000000}},	//   ull_, búda, _wegh,
  { {0x62810104,0x64431977,0x9f580139,0x00000000}},	//   urlo, _vini, uirí_,
  { {0x644b0019,0x7a3100d1,0x91a90013,0x00000000}},	//   _tugi, båte, _phá_,
  { {0x6443002c,0x628800eb,0x7bc71978,0x00000000}},	//   _tini, audo, _onju,
  { {0x3a2600ea,0xafe60854,0x682401a8,0x00000000}},	//   zlop_, чогл, tòdi,
  { {0xf1bf0027,0x62881979,0x3ebe0014,0x00000000}},	//   mlán_, cudo, ítt_,
  { {0x67ef0146,0x7bc70397,0xf1bf1919,0x00000000}},	//   _højd, _anju, llán_,
  { {0xdca3197a,0x5ca30062,0x320201d1,0x00000000}},	// [2460] нати, нитб, miky_,
  { {0x917a008b,0xa097009f,0x32020195,0x00000000}},	//   _hầu_, _צדיק_, liky_,
  { {0xca75000d,0x9f5800cd,0x6fdb0063,0x00000000}},	//   дучы, mirà_, _הקיס,
  { {0x8c460076,0x63a80045,0x7bc7006d,0x00000000}},	//   _неме, zedn, _enju,
  { {0xfc3f0014,0x29120058,0x8c46197b,0x00000000}},	//   _asíu_, çya_, _хеге,
  { {0xdb0e048e,0xe3b8005b,0x9f58197c,0x00000000}},	//   _habí, rlık_, nirà_,
  { {0xfbc90161,0xdb0e0066,0x63a804d9,0x00000000}},	//   रारम, _kabí, vedn,
  { {0x9aeb0063,0x682d0025,0xceb30063,0x00000000}},	//   _הַמִ, rúda, תיה_,
  { {0x6600197d,0x63a8197e,0xb86500de,0x00000000}},	//   rimk, tedn, _ياكو,
  { {0x6288197f,0xb05b0504,0x13f30121,0x00000000}},	//   tudo, lväg, езья,
  { {0x320201d9,0x9f58078d,0x63a80648,0x00000000}},	//   fiky_, dirà_, redn,
  { {0xdb0e0080,0x62880146,0x917a001b,0x00000000}},	//   _nabí, rudo, _cầu_,
  { {0x7a230019,0x4fc7005a,0x68e20150,0x00000000}},	//   mõtt, псва, nyod,
  { {0x9f580268,0x2d9c00ea,0xa01b00ea,0x00000000}},	//   girà_, ővel_, ltöz,
  { {0xb05b00c7,0x539b0165,0x24520013,0x00000000}},	//   kväg, _היוו, _hâm_,
  { {0xe3b801f7,0x3ebe0026,0xdb0e00ed,0x00000000}},	//   ldı_, ætta_, _cabí,
  { {0x61ed00bb,0x67ef0146,0xb0150001,0x00000000}},	// [2470] _ilal, _høje, _омиљ,
  { {0xe3b801f7,0x9f5801f4,0x68e20058,0x00000000}},	//   ndı_, cirà_, dyod,
  { {0x24521980,0xbd02006f,0x20031981,0x00000000}},	//   _lâm_, _éénm, miji_,
  { {0xa9540086,0x200301b3,0x9f580e7c,0x00000000}},	//   екці, liji_, mirá_,
  { {0x9f58006d,0xbc770066,0x7a150051,0x00000000}},	//   lirá_, ýšľa, jąte,
  { {0x20030add,0x7a230019,0x61ed001f,0x00000000}},	//   niji_, võtu, _llal,
  { {0x67ef00b9,0xdce6001c,0x8679000d,0x00000000}},	//   _nøje, _iekā, цёлу_,
  { {0x61ed00a4,0xb9c50067,0x20031982,0x00000000}},	//   _nlal, _تقري, hiji_,
  { {0xdcfd005b,0xf1bf1983,0x69c9006f,0x00000000}},	//   _kası, tlán_, _inee,
  { {0x13090076,0x20030ab2,0x61ed1984,0x00000000}},	//   жной_, jiji_, _alal,
  { {0x69c90034,0x442b001c,0x200301b3,0x00000000}},	//   _knee, ēc_, diji_,
  { {0xd6d80055,0x69db0164,0x471a00b5,0x00000000}},	//   _эту_, _joue, _וועג,
  { {0x250904de,0x917a008b,0x9f5800cd,0x00000000}},	//   _برای_, _cấu_, tirà_,
  { {0xdcfd01f7,0x67ef00b9,0xdce6003d,0x00000000}},	//   _nası, _føje, _nekā,
  { {0x9f581985,0x69c91986,0x50430fd0,0x00000000}},	//   rirà_, _onee, терб,
  { {0x69db1987,0xed5a0054,0xacb60044,0x00000000}},	//   _noue, іоз_, ومزغ,
  { {0xdcfd01f7,0x2003074f,0x2452008b,0x00000000}},	// [2480] _bası, biji_, _xâm_,
  { {0x200306bb,0x9f580297,0x68e20035,0x00000000}},	//   ciji_, birá_, vyod,
  { {0x9f58006d,0xfc3f006d,0x69db006c,0x00000000}},	//   cirá_, _asís_, _boue,
  { {0xef170088,0x79a302a9,0xe3b8005b,0x00000000}},	//   _імя_, врше, zdı_,
  { {0x7a230004,0xb05b00c7,0xe3b8005b,0x00000000}},	//   võtt, rväg, ydı_,
  { {0xb05b0504,0x78ad017d,0x68e20a9f,0x00000000}},	//   sväg, çava, ryod,
  { {0x7a230019,0x7bdc0025,0x69db1988,0x00000000}},	//   tõtt, _ioru, _foue,
  { {0xc883005b,0x200301b3,0x1dd10053,0x00000000}},	//   üğü_, ziji_, हायत,
  { {0x7bdc1989,0x9f58017d,0xe4520044,0x00000000}},	//   _koru, zirá_, خضع_,
  { {0x88bd0051,0xdb0e017d,0x91830013,0x00000000}},	//   _myśl, _gabã, _iểu_,
  { {0xe3b8005b,0x2003027c,0x7a310137,0x00000000}},	//   rdı_, viji_, låta,
  { {0xd2570088,0x2452001b,0xdb1c0137,0x00000000}},	//   ьць_, _tâm_, _inrä,
  { {0x2003074f,0xd5cf0013,0x60f8066e,0x00000000}},	//   tiji_, _kềnh_, дняя_,
  { {0x9f58198a,0x7bdc198b,0x67ef01e1,0x00000000}},	//   tirá_, _noru, _tøje,
  { {0x2003198c,0xcddb005e,0x200400cd,0x00000000}},	//   riji_, оња_, èmia_,
  { {0x63b802ab,0x9f580942,0x2003027c,0x00000000}},	//   _havn, rirá_, siji_,
  { {0x2003198d,0x229800ea,0x69db198e,0x00000000}},	// [2490] piji_, lék_, _roue,
  { {0x63b80add,0xbcfb00ea,0x21290150,0x00000000}},	//   _javn, _beér, _iyah_,
  { {0xdcfd005b,0x7bdc198f,0x629a01cf,0x00000000}},	//   _vası, _doru, ntto,
  { {0xf1bf1990,0xc3330063,0xdb0e00be,0x00000000}},	//   klám_, דוע_, _sabã,
  { {0x69db1991,0x7bdc1992,0x60090078,0x00000000}},	//   _voue, _foru, ažme,
  { {0x63b802ab,0xdb071993,0xf1bf1994,0x00000000}},	//   _navn, _majú, dlám_,
  { {0x26c102f4,0xd6d10032,0x2298013d,0x00000000}},	//   ího_, اقع_, jék_,
  { {0x7bdc005b,0x917a001b,0x229800ea,0x00000000}},	//   _zoru, _mẫu_, dék_,
  { {0xdb070024,0x21290089,0x7bdc1995,0x00000000}},	//   _najú, _nyah_, _yoru,
  { {0x44230024,0xf6e70962,0xdb0e013d,0x00000000}},	//   ôj_, _оцен, _habá,
  { {0x2129053b,0xe9ff008b,0x2bb20053,0x00000000}},	//   _ayah_, _giản_, ीयता,
  { {0xbbdc0042,0xe1f2043e,0x00000000,0x00000000}},	//   _मक्क, اسد_,   ,
  { {0x64a50088,0xb17b00d1,0x63b81996,0x00000000}},	//   _чала, rhåp, _favn,
  { {0xdb0e0137,0x63b805b9,0x7fd60083,0x00000000}},	//   _inbö, _gavn, хімі,
  { {0xada60076,0x248d017d,0x6da60175,0x00000000}},	//   навл, luem_, нива,
  { {0x7bdc01f7,0x25ad0162,0x3ec2008f,0x00000000}},	//   _soru, neel_, _īstā_,
  { {0x248d1997,0x7bdc1998,0x63a6013d,0x00000000}},	// [24a0] nuem_, _poru, őkne,
  { {0x394d0034,0xa09b00b5,0x25ad1999,0x00000000}},	//   _ages_, _צייט, heel_,
  { {0x88bd0045,0x25ad199a,0x7a2a0014,0x00000000}},	//   _wyśl, keel_, lýti,
  { {0x60c4199b,0x7bdc004d,0xb05b0072,0x00000000}},	//   _krim, _woru, sväe,
  { {0x25ad0162,0x317b0063,0x7ae50072,0x00000000}},	//   deel_, פרסמ, ayht,
  { {0x394d002b,0x75fe008f,0x207b0041,0x00000000}},	//   _eges_, mūzi, לאנא,
  { {0x2cb20185,0x63b802e2,0xa96a199c,0x00000000}},	//   lwyd_, _ravn, _нива_,
  { {0x0466000d,0x7a310137,0x63b8199d,0x00000000}},	//   нтом, låtn, _savn,
  { {0x2cb20185,0x248d14b1,0x22490089,0x00000000}},	//   nwyd_, guem_, _riak_,
  { {0x2298000f,0x22490150,0xa87b0063,0x00000000}},	//   ték_, _siak_, _מאמר,
  { {0x2cb2001f,0x7dd800ea,0x21290360,0x00000000}},	//   hwyd_, _dísz, _syah_,
  { {0x248d017d,0x629a119d,0x645d1289,0x00000000}},	//   buem_, rtto, ísic,
  { {0xc0cb0001,0x644f0283,0x63b8199e,0x00000000}},	//   чуне_, ícit, _tavn,
  { {0x2cb20185,0x60c4199f,0x629a0244,0x00000000}},	//   dwyd_, _drim, ptto,
  { {0x443e0199,0x6e260150,0x64930ef0,0x00000000}},	//   mmt_, _bkkb, ržiš,
  { {0x2cb20185,0x442c19a0,0x7c3e19a1,0x00000000}},	//   fwyd_, lld_, empr,
  { {0x443e19a2,0x2cb2001f,0x60c419a3,0x00000000}},	// [24b0] omt_, gwyd_, _grim,
  { {0xf1c00066,0x628819a4,0xdb150066,0x00000000}},	//   čšej_, ordo, _enzý,
  { {0x67ef0146,0x443e19a5,0x1df90121,0x00000000}},	//   _nøja, imt_, _жены_,
  { {0x443e004d,0x2cb2002b,0x7ae50072,0x00000000}},	//   hmt_, bwyd_, ryht,
  { {0xa17c00b5,0x644a0025,0x25ad0162,0x00000000}},	//   לטאט, _oifi, veel_,
  { {0x07a5018e,0x7d000014,0x6e2d1130,0x00000000}},	//   такн, _ýmsa, llab,
  { {0x79a70088,0xf6b20021,0x6e2d19a6,0x00000000}},	//   _прае, لموج, olab,
  { {0x6e2d19a7,0x248d0555,0x7aea06a5,0x00000000}},	//   nlab, tuem_, øfte,
  { {0x8cc40161,0x628819a8,0x25ad09fe,0x00000000}},	//   रियो, erdo, reel_,
  { {0x6e2d083f,0x03a5005e,0xf1bf19a9,0x00000000}},	//   hlab, њино, lláh_,
  { {0xe285005a,0x25ad00f5,0x6e2d0026,0x00000000}},	//   ълни, peel_, klab,
  { {0x442c19aa,0x2cb2001f,0x644a002b,0x00000000}},	//   ald_, ywyd_, _eifi,
  { {0x69d9006f,0x644a0035,0x248d19ab,0x00000000}},	//   ijwe, _fifi, quem_,
  { {0x6e2d19ac,0x65690246,0xa01b004d,0x00000000}},	//   elab, lbeh, nröh,
  { {0x91fd003d,0x7a3819ad,0xb05b00a5,0x00000000}},	//   mpān, líte, tväc,
  { {0xa6e9001b,0x6e2d19ae,0x60c409ee,0x00000000}},	//   _trươ, glab, _trim,
  { {0x44270150,0x7a3819af,0x2cb2002b,0x00000000}},	// [24c0] _kkn_, níte, uwyd_,
  { {0x2cb20185,0x6e2d19b0,0x26c501f4,0x00000000}},	//   rwyd_, alab, _orlo_,
  { {0x2cb2001f,0x6e2d0e1a,0xee3a19b1,0x00000000}},	//   swyd_, blab, _оно_,
  { {0x65690122,0x5886000d,0x2cb2002b,0x00000000}},	//   jbeh, выка, pwyd_,
  { {0x442c19b2,0x443e0026,0x656919b3,0x00000000}},	//   yld_, ymt_, dbeh,
  { {0x65690024,0x660219b4,0xc8650021,0x00000000}},	//   ebeh, _smok, اطني,
  { {0x644a051e,0x764b00bb,0x60090734,0x00000000}},	//   _rifi, _bigy, nžma,
  { {0x442c0122,0x7ae317cb,0x644a187c,0x00000000}},	//   wld_, änte, _sifi,
  { {0x7a3800ea,0x41d60053,0x44270150,0x00000000}},	//   gíte, धानस, _bkn_,
  { {0x442c0034,0x6e240025,0x6e2d001c,0x00000000}},	//   uld_, hoib, zlab,
  { {0x442c19b5,0x7a310137,0x764b00ea,0x00000000}},	//   rld_, kåtl, _figy,
  { {0x764b00a3,0x91fd0023,0x4427004e,0x00000000}},	//   _gigy, apān, _ekn_,
  { {0x7a380331,0x7a150022,0x61f80085,0x00000000}},	//   cíte, kątn, тняў_,
  { {0xa91d1844,0x6e9519b6,0xe3b80075,0x00000000}},	//   _udže, лигу, alır_,
  { {0xdbdc0026,0xd3780051,0xa2e30002,0x00000000}},	//   _ráðl, mać_, _војд,
  { {0xd3780051,0xbddb0003,0x6e2d0058,0x00000000}},	//   lać_, _lièv, ulab,
  { {0x6e2d19b7,0x31790051,0x6c54130d,0x00000000}},	// [24d0] rlab, masz_, икту,
  { {0xd3780051,0x6e2d019f,0x31790758,0x00000000}},	//   nać_, slab, lasz_,
  { {0xf09f0682,0xe28b0080,0x16220053,0x00000000}},	//   ltà_, _účtů_, मवार_,
  { {0xa01b0026,0xf1bf19b8,0x31790022,0x00000000}},	//   fsög, ndá_, nasz_,
  { {0xd3780045,0xf09f19b9,0x9d140054,0x00000000}},	//   kać_, ntà_, _вдяч,
  { {0x7a3800ea,0xf8070062,0xd3780022,0x00000000}},	//   víte, ъчен, jać_,
  { {0xd3780045,0x9f5102dd,0xa01b0014,0x00000000}},	//   dać_, lizó_, psöf,
  { {0x26c5017f,0xcb12009f,0xa87b0021,0x00000000}},	//   _vrlo_, _הלל_, _يحذر_,
  { {0x75f50080,0x9f51006d,0x31790051,0x00000000}},	//   _náze, nizó_, dasz_,
  { {0xd3780051,0x7a3819ba,0x68e40213,0x00000000}},	//   gać_, ríte, äide,
  { {0xf09f051e,0x420a19bb,0x7a3819bc,0x00000000}},	//   età_, енно_, síte,
  { {0xf1bf0016,0x7a3800ea,0x3179056c,0x00000000}},	//   gdá_, píte, gasz_,
  { {0x7c25007d,0x660919bd,0xdb1c1775,0x00000000}},	//   kohr, miek, _carê,
  { {0x25bd001f,0x25bf000c,0xd3780051,0x00000000}},	//   _hawl_, ldul_, cać_,
  { {0x9324006a,0x539a0063,0x6441004d,0x00000000}},	//   _پرون, _ניקו, mmli,
  { {0xe1f2006a,0x25bf19be,0x660919bf,0x00000000}},	//   _دست_, ndul_, niek,
  { {0xf09f00cd,0x6e2419c0,0xa3c80053,0x00000000}},	// [24e0] ctà_, roib, _लोड_,
  { {0x44250c70,0x249f0026,0xeb9706da,0x00000000}},	//   nol_, itum_, лиу_,
  { {0xb05b01e3,0x6b5900ea,0x660919c1,0x00000000}},	//   nvän, _súgó, kiek,
  { {0xd3780051,0x644100bd,0x442510c1,0x00000000}},	//   zać_, hmli, hol_,
  { {0x442519c2,0x660919c3,0xdc75000d,0x00000000}},	//   kol_, diek, _высь,
  { {0xa01b0026,0x93bc000c,0x442519c4,0x00000000}},	//   rsög, nlăt, jol_,
  { {0x386600f3,0x660904c6,0x442510c1,0x00000000}},	//   spor_, fiek, dol_,
  { {0xd3781112,0xb05b00c7,0x200a005b,0x00000000}},	//   wać_, dvän, hibi_,
  { {0x44250185,0xd3780051,0x200a005b,0x00000000}},	//   fol_, tać_, kibi_,
  { {0x442519c5,0x3a260162,0x31790022,0x00000000}},	//   gol_, loop_, wasz_,
  { {0xd3780051,0x16660001,0x25bf0222,0x00000000}},	//   rać_, _свем, bdul_,
  { {0xf09f02f6,0x2ca00004,0xd3780051,0x00000000}},	//   ttà_, ktid_, sać_,
  { {0x3dc0001f,0x442519c6,0xf1bf19c7,0x00000000}},	//   ddiw_, bol_, kláv_,
  { {0xc356011c,0xf09f19b9,0x442519c8,0x00000000}},	//   _съдъ, rtà_, col_,
  { {0xa36f0024,0xf09f19c9,0x3a260229,0x00000000}},	//   äčši, stà_, koop_,
  { {0x9f51006d,0xf09f00cd,0x443c19ca,0x00000000}},	//   tizó_, ptà_, _hhv_,
  { {0xdbd20019,0x682d0024,0x67ef00b9,0x00000000}},	// [24f0] _füüs, súdi, _bøjl,
  { {0x41c30161,0x660919cb,0x320b0924,0x00000000}},	//   षयवस, ziek, licy_,
  { {0xddd0005b,0x7c2519cc,0x9e3505ce,0x00000000}},	//   _çeşi, rohr, _венч,
  { {0x320b0051,0x249f0026,0x443c004b,0x00000000}},	//   nicy_, ytum_, _lhv_,
  { {0x2ca0001f,0xbddb0003,0x25bd19cd,0x00000000}},	//   ctid_, _dièt, _rawl_,
  { {0x25bd0185,0x66090051,0xa265008b,0x00000000}},	//   _sawl_, wiek, _buộ,
  { {0xec36014e,0xa265001b,0x44251505,0x00000000}},	//   _כאשר_, _cuộ, vol_,
  { {0x3ebe0026,0x25bf0150,0x249f19ce,0x00000000}},	//   ætti_, udul_, ttum_,
  { {0xfa34007e,0x442519cf,0x25bf19d0,0x00000000}},	//   _طرفد, tol_, rdul_,
  { {0x660919d1,0x13e60076,0x442519d2,0x00000000}},	//   siek, имый_, uol_,
  { {0x249f13f3,0x7a3800ea,0xddc70006,0x00000000}},	//   stum_, líta, gpjū,
  { {0x44250185,0xb05b00c7,0x249f0026,0x00000000}},	//   sol_, rvän, ptum_,
  { {0xb05b00c7,0x442519d3,0x7a38013d,0x00000000}},	//   svän, pol_, níta,
  { {0x88bd0045,0xb4fa0063,0xb05b0137,0x00000000}},	//   _wyśw, _בפני, mväl,
  { {0x645b048e,0x200a19d4,0x245b008b,0x00000000}},	//   lqui, ribi_, _hêm_,
  { {0x8e55019d,0x4d660088,0x67ef00b9,0x00000000}},	//   стрі, ркав, _søjl,
  { {0x93bc000c,0xb05b0072,0x645b13cd,0x00000000}},	// [2500] plăt, nväl, nqui,
  { {0x645b0268,0x27220024,0x307b014e,0x00000000}},	//   iqui, nčné_, _שאינ,
  { {0xdb150016,0x78bb021e,0xf1da0053,0x00000000}},	//   _razã, _asuv, _बचान,
  { {0xb17b0e5a,0x61e400fe,0x7ae303c8,0x00000000}},	//   lkår, _joil, änta,
  { {0xdb1c0164,0x27220024,0x61e40025,0x00000000}},	//   _maré, kčné_, _moil,
  { {0x18670001,0xdb07006d,0xb2270014,0x00000000}},	//   шаљи_, _cajó, _klæð,
  { {0x5b35000d,0xa01b0137,0xdb05004d,0x00000000}},	//   _гэту, pröv, gehä,
  { {0x78660086,0x68eb02fb,0x61e419d5,0x00000000}},	//   _вказ, bygd, _noil,
  { {0x9183001b,0x7a380331,0x248d0fda,0x00000000}},	//   _nếu_, cíta, grem_,
  { {0xdb1c00cd,0x69c219d6,0xdb05004d,0x00000000}},	//   _parè, ldoe, behä,
  { {0x4b7b180d,0x61e40120,0x248d19d7,0x00000000}},	//   כטיג, _boil, arem_,
  { {0x69c019d8,0x61e419d9,0x69c20421,0x00000000}},	//   _jame, _coil, ndoe,
  { {0x245b0185,0xfeb8006a,0x61e419d5,0x00000000}},	//   _gêm_, یافت_, _doil,
  { {0x7a310137,0xb17b069f,0x69c006d5,0x00000000}},	//   tåtk, gkår, _lame,
  { {0x69c00529,0x61e40d12,0x9f35000d,0x00000000}},	//   _oame, _foil, севі,
  { {0xdb0501e3,0x5d5519da,0x61f600ac,0x00000000}},	//   nehå, скат, _glyl,
  { {0x78a2017f,0x7a310137,0xbddb0003,0x00000000}},	// [2510] jtov, såtk, _bièr,
  { {0x0a6b018e,0x69c20983,0x2ac7005e,0x00000000}},	//   врди_, edoe, иљев,
  { {0xcf92014e,0x645b006d,0x69c200ac,0x00000000}},	//   _צטט_, zqui, fdoe,
  { {0x9183008b,0xb05b0072,0xc98719db,0x00000000}},	//   _yếu_, yväl, ружи,
  { {0xf0940047,0xa01b0137,0xf1bf00ea,0x00000000}},	//   ַנק_, bröt, llás_,
  { {0x645d02dd,0xe8f8000d,0xa01b0137,0x00000000}},	//   ísim, шлі_, mrös,
  { {0x7a3819dc,0xc6680138,0x657b002c,0x00000000}},	//   mítn, ашње_, tauh,
  { {0xff180063,0x69c019dd,0x0495000d,0x00000000}},	//   יקות_, _game, броў,
  { {0x248d19de,0x78bb004b,0xdb051013,0x00000000}},	//   urem_, _usuv, sehä,
  { {0x248d19df,0x245b017d,0x61e419d9,0x00000000}},	//   rrem_, _vêm_, _soil,
  { {0x645b13a8,0x69c00009,0x27220024,0x00000000}},	//   squi, _yame, rčné_,
  { {0x245b03d9,0xdb0800ea,0x82f4000d,0x00000000}},	//   _têm_, ülés, ючыц,
  { {0x61e40164,0x70560021,0xe6040044,0x00000000}},	//   _voil, إنسا, _بِنَ,
  { {0x51f6006a,0x10160085,0xb1430085,0x00000000}},	//   _گستر, сьмя, янял,
  { {0x22950021,0x27e50137,0x52850021,0x00000000}},	//   _العس, _moln_, _البك,
  { {0x51f6006a,0x6459002c,0x78a2016b,0x00000000}},	//   _دستر, _kuwi, ytov,
  { {0x228301f7,0x78a20512,0x5baa000d,0x00000000}},	// [2520] lık_, xtov, лкам_,
  { {0x69c019e0,0x62811058,0xaf9a1159,0x00000000}},	//   _same, oslo, _стих_,
  { {0x69c019e1,0xdcef001c,0xcf570063,0x00000000}},	//   _pame, _vecā, _לבית_,
  { {0x62810035,0x3ebe0026,0x88860021,0x00000000}},	//   islo, ættu_, مؤتم,
  { {0x69c219e2,0x17540065,0x78a219e3,0x00000000}},	//   rdoe, овля, utov,
  { {0x69c00035,0x78a204c8,0x69c20229,0x00000000}},	//   _wame, rtov, sdoe,
  { {0x78a219e4,0x75f5004c,0x7aea00a5,0x00000000}},	//   stov, _sáza, äftd,
  { {0x2283005b,0x645900a4,0xf1bf0025,0x00000000}},	//   dık_, _buwi, hlár_,
  { {0x7a38000f,0x7a150051,0xe4e601dd,0x00000000}},	//   líto, zątk, сійн,
  { {0x8cbb014e,0x6459002b,0xa41c008f,0x00000000}},	//   נציק, _duwi, _ādēļ_,
  { {0x02a30156,0xdb050137,0x628119e5,0x00000000}},	//   прям, pehå, gslo,
  { {0x22400089,0x20181346,0xdd28008f,0x00000000}},	//   _chik_, enri_, zēšo,
  { {0x25b7006a,0x628108ea,0x9f410066,0x00000000}},	//   _دهند_, aslo, _dlhý_,
  { {0xb4d4016a,0x7a3800ea,0xb05b0072,0x00000000}},	//   हमी_, kíto, lväk,
  { {0xa3d50161,0x628114d5,0x6459004d,0x00000000}},	//   हार_, cslo, _zuwi,
  { {0x64630026,0xbd890021,0x7a3819e6,0x00000000}},	//   _óvið, شنطن_, díto,
  { {0xf1d60053,0xc4b60053,0x765a19e7,0x00000000}},	// [2530] धारन, _अनोख, _luty,
  { {0x3a2d021f,0xf1bf0025,0xa01b0137,0x00000000}},	//   _skep_, clár_, rrös,
  { {0x1dc40053,0x765a0006,0xee3f0013,0x00000000}},	//   _लोकत, _nuty, _thý_,
  { {0x5ee80063,0x60cd19e8,0xb6460085,0x00000000}},	//   _הַשְ, _kram, _кнiж,
  { {0x7a380080,0x27e500c2,0x28a70121,0x00000000}},	//   mítl, _poln_, сшег,
  { {0x26cc007d,0x22830058,0x628119e9,0x00000000}},	//   _brdo_, yık_, yslo,
  { {0xcf94016e,0xe7390f9f,0xa3dc0042,0x00000000}},	//   לטס_, шек_, डान_,
  { {0x7d090ac6,0x26c700c3,0x7aea0502,0x00000000}},	//   _þess, rvno_, äfte,
  { {0xa3d50161,0x9475005d,0x7c22006c,0x00000000}},	//   हाल_, زگشا, éorg,
  { {0x228301f7,0x981703eb,0x628119ea,0x00000000}},	//   tık_, _ابرا, tslo,
  { {0x60cd04ab,0xe9ff008b,0x28c70042,0x00000000}},	//   _aram, _nhẫn_, लिवि,
  { {0x6459002c,0x75f5027d,0x6aa513d5,0x00000000}},	//   _tuwi, _zázn, ithf,
  { {0x2419007f,0x628119eb,0x7a38013d,0x00000000}},	//   _коды_, sslo, zíto,
  { {0xdd01004c,0x628105e7,0x3f9e004b,0x00000000}},	//   štěv, pslo, ütu_,
  { {0x60cd0019,0xd347007e,0xed5a0002,0x00000000}},	//   _eram, _دیده_, иов_,
  { {0x7bd500bd,0xed57000a,0x60cd19ec,0x00000000}},	//   _anzu, жот_, _fram,
  { {0xac0a0002,0xa01b0137,0x60db004d,0x00000000}},	// [2540] анаа_, rrör, äumt,
  { {0x6026019d,0x9f6000fe,0xa01b0137,0x00000000}},	//   _єдна, ärät_, srör,
  { {0xb05b00fe,0x75f50061,0xda650021,0x00000000}},	//   yväk, _názo, كاني,
  { {0x7bc50b54,0xa3d50053,0x286a0caa,0x00000000}},	//   adhu, हाँ_, арко_,
  { {0x79890185,0x7a38000f,0x2db7014e,0x00000000}},	//   _ddew, síto, _ולכן_,
  { {0xdb1c19ed,0x7a3819ee,0xa3c80042,0x00000000}},	//   _harí, píto, _लों_,
  { {0xf1ca0161,0x2d80003b,0xdb1c0014,0x00000000}},	//   ियान, oaie_, _karí,
  { {0x95ca0138,0x94aa0635,0x6366004c,0x00000000}},	//   рука_, атоа_, kční,
  { {0x75fc000f,0xdb1c0283,0xe9ff008b,0x00000000}},	//   _néze, _marí, _hiến_,
  { {0xe9ff001b,0x03f80001,0x26cc00c2,0x00000000}},	//   _kiến_, сној_, _trdo_,
  { {0xbcfb017d,0x05660121,0x60cd0734,0x00000000}},	//   _afél, _двен, _sram,
  { {0xe9ff008b,0x60cd19ef,0xf207012c,0x00000000}},	//   _miến_, _pram, іяно,
  { {0x845a000a,0x32f50013,0x4fc70816,0x00000000}},	//   _трет_, áy_, осва,
  { {0x7a3100d1,0xe9ff0013,0xb05b0244,0x00000000}},	//   lått, _phẫn_, hwäg,
  { {0x22630024,0x442c19f0,0xdb1c19f1,0x00000000}},	//   ľské_, mod_, _barí,
  { {0x02fb0063,0x60cd19f2,0x2d580376,0x00000000}},	//   _כלומ, _tram, жить_,
  { {0xa80201f7,0xdb1c05d5,0x75fc00ea,0x00000000}},	// [2550] şıyo, _darí, _kézb,
  { {0x442c19f3,0xe9ff001b,0xab940054,0x00000000}},	//   nod_, _biến_, дифі,
  { {0x201119f4,0x7bc500d1,0x6448005b,0x00000000}},	//   mizi_, rdhu, imdi,
  { {0x24860117,0x6aa5001f,0x7a3800ea,0x00000000}},	//   _ovom_, rthf, lítj,
  { {0x442c19f5,0x8dda0063,0x7e6200a8,0x00000000}},	//   kod_, _הקרק, _čopi,
  { {0x201104ab,0xe0df0268,0x7bd500bd,0x00000000}},	//   nizi_, ixò_, _unzu,
  { {0x9675000d,0xb05b004b,0x442c19f6,0x00000000}},	//   чылі, sväh, dod_,
  { {0x7a3100a5,0x391519f7,0xc1da0042,0x00000000}},	//   gått, _ембр, _बचेग,
  { {0x442c0185,0x5884000d,0x7a3800ea,0x00000000}},	//   fod_, _жыха, kítj,
  { {0x442c19f8,0x2011007d,0x73050062,0x00000000}},	//   god_, jizi_, зпоз,
  { {0x4439003d,0x20110ee6,0x7a38013d,0x00000000}},	//   ēs_, dizi_, dítj,
  { {0x2011008f,0xdb0e004c,0x5ef10082,0x00000000}},	//   eizi_, _nabý, ीनन्_,
  { {0xa01b00bd,0xe9ff008b,0x442c19f9,0x00000000}},	//   rsön, _chẩn_, bod_,
  { {0x764901f7,0x20110035,0x644f00cd,0x00000000}},	//   lmey, gizi_, ïcid,
  { {0xdee60a36,0xdb1c19fa,0x661b0066,0x00000000}},	//   чови, _parí, onuk,
  { {0x661b024a,0x764901f7,0xe1ff006d,0x00000000}},	//   nnuk, nmey, chó_,
  { {0xdb1c05d5,0xb05b00fe,0x661b19fb,0x00000000}},	// [2560] _varí, yväi, inuk,
  { {0x60090006,0x2d800003,0x7a3801a8,0x00000000}},	//   yžmi, saie_, rítm,
  { {0xab690032,0x7a3800ea,0x7649005b,0x00000000}},	//   تحقق_, sítm, kmey,
  { {0xdb1c0016,0x9f580331,0x7a380061,0x00000000}},	//   _parâ, piró_, mítk,
  { {0x442c002c,0xed52007e,0xdb1c017d,0x00000000}},	//   yod_, _سپس_, _barã,
  { {0xe9ff001b,0xdb0e0080,0x291a003b,0x00000000}},	//   _tiến_, _zabý, ăpa_,
  { {0x2486017f,0x8c4319fc,0x7a3104aa,0x00000000}},	//   _svom_, _чере, tått,
  { {0xceb3014e,0x442c001f,0xd5ba0121,0x00000000}},	//   גיה_, wod_, сск_,
  { {0x38c8006a,0xdb1c017d,0x7d0419fd,0x00000000}},	//   _بازی_, _farã, nzis,
  { {0x7d000014,0xa2f417f2,0x644319fe,0x00000000}},	//   _ýmsu, дпоч, _chni,
  { {0x442c19ff,0x6448008f,0x20111a00,0x00000000}},	//   rod_, rmdi, vizi_,
  { {0xd2570088,0x79820035,0x442c1a01,0x00000000}},	//   яць_, naow, sod_,
  { {0x442c0117,0x20110290,0x50671a02,0x00000000}},	//   pod_, tizi_, ятна,
  { {0xe2f8000d,0x7d041a03,0xe1ff0139,0x00000000}},	//   _мелі_, dzis, shó_,
  { {0x9f580290,0x53330141,0x7a38013d,0x00000000}},	//   tirò_, _пешт, rítj,
  { {0x63ba1a04,0x7a3800ea,0x67ef00b9,0x00000000}},	//   letn, sítj, _højt,
  { {0x7d040006,0xdd94000d,0x6e2d00a8,0x00000000}},	// [2570] gzis, эаты, roab,
  { {0x629a1a05,0x7a381084,0x76490058,0x00000000}},	//   outo, líth, zmey,
  { {0xdb1c0994,0x3f831a06,0x629a1a07,0x00000000}},	//   _carà, maju_, nuto,
  { {0x7aea00c7,0x63ba00ea,0x7a3800ea,0x00000000}},	//   äfta, hetn, níth,
  { {0xf1bf0013,0x48ab1a08,0x63ba1a09,0x00000000}},	//   goái_, стем_, ketn,
  { {0xfe70007e,0x63ba027c,0x2ca90137,0x00000000}},	//   _جدی_, jetn, mtad_,
  { {0x67d2000a,0x2ca91a0a,0x7649005b,0x00000000}},	//   тоју, ltad_, tmey,
  { {0x629a1a0b,0x9b440021,0xceb40063,0x00000000}},	//   duto, _سنقو, תיק_,
  { {0x764901f7,0x3f83017f,0x2ca91a0c,0x00000000}},	//   rmey, kaju_, ntad_,
  { {0x3f83017f,0x43740086,0xdb1c1919,0x00000000}},	//   jaju_, нуют, _hará,
  { {0x3f83017f,0x7bc71a0d,0x7d04104e,0x00000000}},	//   daju_, _maju, zzis,
  { {0x2ca91a0e,0xcf890ee1,0x7a381a0f,0x00000000}},	//   ktad_, _כט_, gíth,
  { {0x25ad0137,0x629a1a10,0xaca30013,0x00000000}},	//   mfel_, auto, _diịc,
  { {0x63ba007d,0x7bc70d76,0x3f83007d,0x00000000}},	//   cetn, _naju, gaju_,
  { {0x67ef0146,0xe9ff008b,0x2bd10042,0x00000000}},	//   _højs, _nhắn_, _सफ़ा,
  { {0xee3a0304,0x2ca90137,0x515604e3,0x00000000}},	//   іна_, ftad_, _отпу,
  { {0xbc6a006a,0x3f83017f,0x7a380080,0x00000000}},	// [2580] زمان_, baju_, sítk,
  { {0xdb1c0268,0x3f83017f,0x60c41a11,0x00000000}},	//   _parà, caju_, _isim,
  { {0xdb1c000f,0xe9ff008b,0x7a381513,0x00000000}},	//   _bará, _chắn_, líti,
  { {0xdb1c06b2,0x25ad06aa,0x61e600c2,0x00000000}},	//   _cará, jfel_, njkl,
  { {0x307a0047,0x395200fe,0x22520066,0x00000000}},	//   קאַנ, äys_, ízky_,
  { {0x60c40035,0x7bc71a12,0x38cb007e,0x00000000}},	//   _msim, _gaju, غانی_,
  { {0xa3c80053,0xc6a60002,0xb05b00a5,0x00000000}},	//   _लोग_, фрли, lvät,
  { {0xe5a3005e,0xa91d005f,0x6f030058,0x00000000}},	//   вићи, _bežd, _ünce,
  { {0x91fd008f,0x63ba1a13,0x7a38013d,0x00000000}},	//   kpār, tetn, víth,
  { {0xb05b1a14,0xdb1c1a15,0x629a1a16,0x00000000}},	//   hwäc, _zará, tuto,
  { {0x3f830117,0x60c41a17,0x629a00fe,0x00000000}},	//   vaju_, _asim, uuto,
  { {0x63ba1a18,0x629a1a19,0x7413007e,0x00000000}},	//   setn, ruto, _یونا,
  { {0xc5f3014e,0x3f83017f,0x63ba0384,0x00000000}},	//   _בדף_, taju_, petn,
  { {0xa01b01e3,0xbbc80161,0x67ef010a,0x00000000}},	//   msök, रयोक, _højr,
  { {0xa01b00c7,0x3f831a1a,0x60c4037e,0x00000000}},	//   lsök, raju_, _esim,
  { {0x7a380025,0x3f831a1b,0x2ca91a1c,0x00000000}},	//   bíti, saju_, ttad_,
  { {0x3f831a1d,0xa01b0137,0x64581a1e,0x00000000}},	// [2590] paju_, nsök, _kivi,
  { {0x2c6400c7,0x9f4500ea,0x2ca91a1f,0x00000000}},	//   _död_, óló_, rtad_,
  { {0x386d1a20,0xdb1c1a21,0x7bc70019,0x00000000}},	//   _ster_, _pará, _vaju,
  { {0x64581a22,0xa01b00c7,0xceb200b5,0x00000000}},	//   _livi, ksök, _גיט_,
  { {0x9f580027,0x7bc71a23,0xdb1c00ea,0x00000000}},	//   mhrá_, _taju, _vará,
  { {0x07a2026b,0xb05b0072,0xe9ff0013,0x00000000}},	//   гашн, lväs, _thắn_,
  { {0x25ad0529,0x49bb006a,0xa01b00c7,0x00000000}},	//   tfel_, _وارد_, esök,
  { {0xcf580132,0x6b85003e,0x62881a24,0x00000000}},	//   ובות_, lahg, dsdo,
  { {0xa01b0137,0x64581a25,0xad9b0014,0x00000000}},	//   gsök, _bivi, _klúb,
  { {0x25ad00c7,0x13090be6,0xe299005e,0x00000000}},	//   sfel_, зной_, пао_,
  { {0xa91d00c3,0x6d5d0d02,0x61ed003b,0x00000000}},	//   _deže, _ogsa, _boal,
  { {0x69cb05e1,0x64581a26,0xa01b0137,0x00000000}},	//   ndge, _eivi, bsök,
  { {0xe9ff001b,0xb05b0db3,0x38a90139,0x00000000}},	//   _nhận_, dväs, núr_,
  { {0x2c6400c7,0x64580924,0x6d5d00a4,0x00000000}},	//   _röd_, _givi, _agsa,
  { {0xa3dc0053,0x6e290061,0x7a38013d,0x00000000}},	//   डार_, čebn, mítv,
  { {0x91fd001c,0x7a38013d,0x64581a27,0x00000000}},	//   spār, lítv, _zivi,
  { {0x60c40035,0xf6520047,0xe9ff0013,0x00000000}},	// [25a0] _usim, רצן_, _chận_,
  { {0x61ed02b0,0x26c51a28,0x69cb10da,0x00000000}},	//   _zoal, _oslo_, edge,
  { {0xdb1c0016,0x8f9b00b5,0x69cb006f,0x00000000}},	//   _març, _ציטי, fdge,
  { {0xb05b0137,0xa9c50085,0x75f5013d,0x00000000}},	//   mvär, ксік, _fázi,
  { {0xb05b00c7,0x27fe0150,0x4c670062,0x00000000}},	//   lvär, _pltn_, _пиян_,
  { {0x3c340137,0x69db1a29,0xa01b0137,0x00000000}},	//   rävs_, _enue, vsök,
  { {0x8f9b0047,0x4df40053,0x64581a2a,0x00000000}},	//   ליסי, _इकाई_, _rivi,
  { {0xb5aa0021,0xc1ca0053,0x69e2004c,0x00000000}},	//   سابك_, ियोग, áteč,
  { {0x76590185,0xdb1c0803,0x2d82007d,0x00000000}},	//   _diwy, _barç, _meke_,
  { {0xa01b01e3,0x61ed0397,0xb05b0137,0x00000000}},	//   rsök, _soal, kvär,
  { {0xa01b00c7,0x64581a2b,0x61ed1a2c,0x00000000}},	//   ssök, _vivi, _poal,
  { {0x2d821181,0xb05b0137,0xa01b00a5,0x00000000}},	//   _neke_, dvär, psök,
  { {0x7bdc0983,0xad9b01a8,0xb05b0a26,0x00000000}},	//   _onru, _llúc, evär,
  { {0xdb1c1a2d,0x7ee7030b,0x00000000,0x00000000}},	//   _garç, нцбе,   ,
  { {0x61ed1a2e,0x53a30141,0x7a38013d,0x00000000}},	//   _toal, _сајб, lítu,
  { {0xbddb0164,0xbdd5005a,0xe9ff008b,0x00000000}},	//   _thèm, ъобщ, _phận_,
  { {0x7d550062,0x4c941a2f,0x5d55193d,0x00000000}},	// [25b0] твах, литс, ткат,
  { {0xb6030024,0x69c91a30,0x5c04045b,0x00000000}},	//   čšin, _saee, ляха,
  { {0xa01b00ea,0xb05b1a31,0xda78000d,0x00000000}},	//   kröz, sväs, еяч_,
  { {0x6149001c,0xe9ff008b,0x69cb1a32,0x00000000}},	//   _tūlī, _thận_, udge,
  { {0x28f80086,0xf09f00cd,0x69cb1a33,0x00000000}},	//   нець_, nuà_, rdge,
  { {0xd942005e,0x307c0041,0x907c0041,0x00000000}},	//   јеши, לאדנ, לטדי,
  { {0xa01b004d,0x38a91a34,0x98c10058,0x00000000}},	//   rsöh, súr_, ısız_,
  { {0xb606017f,0x7ae300fe,0xa91d007d,0x00000000}},	//   ješć, äntu, _vežb,
  { {0xdb1c005b,0xf1bf0024,0xc5680044,0x00000000}},	//   _parç, deá_, رحيل_,
  { {0x75f50a63,0xf09f00cd,0x3914000d,0x00000000}},	//   _názv, duà_, _смур,
  { {0xb05b0137,0x7a38013d,0xfbd20063,0x00000000}},	//   yvär, rítv, בתי_,
  { {0x7a3800ea,0x151500a0,0x3f850026,0x00000000}},	//   sítv, _идея, ðlun_,
  { {0x7a3800ea,0xe44e0062,0x2d8208ed,0x00000000}},	//   pítv, _вж_, _reke_,
  { {0x35a70053,0x25bf00dd,0xe29901f6,0x00000000}},	//   _गाड़, leul_, _жак_,
  { {0xb05b00c7,0x2d821a35,0x765c0003,0x00000000}},	//   tvär, _peke_, _éryt,
  { {0xf1bf0025,0x25bf003b,0xc69203c3,0x00000000}},	//   ceá_, neul_, יאל_,
  { {0xb05b00c7,0x2d821a36,0xd24f0021,0x00000000}},	// [25c0] rvär, _veke_, _بني_,
  { {0x395f018d,0x2d8200e8,0xb05b03c8,0x00000000}},	//   _agus_, _weke_, svär,
  { {0x2d821a37,0xbad5000d,0x9ad50086,0x00000000}},	//   _teke_, ліцы, люці,
  { {0xb05b004d,0x20181a38,0x38c8005d,0x00000000}},	//   nwän, liri_, فاتی_,
  { {0x20180139,0x25bf003b,0x18670f55,0x00000000}},	//   oiri_, deul_, вачи_,
  { {0xe9ff001b,0x6d461a39,0x249f1417,0x00000000}},	//   _phản_, _izka, duum_,
  { {0xcac70184,0x2ca01a3a,0x2018004b,0x00000000}},	//   _игре_, luid_, iiri_,
  { {0x20181a3b,0x66030002,0x7c3e1a3c,0x00000000}},	//   hiri_, ипја, llpr,
  { {0x7c3e00ac,0x20181a3d,0xe4e60086,0x00000000}},	//   olpr, kiri_, тійн,
  { {0x20180035,0xe9ff0013,0x22491a3e,0x00000000}},	//   jiri_, _thản_, _shak_,
  { {0xf2c30878,0xb05b004d,0x2ca00139,0x00000000}},	//   асян, fwän, huid_,
  { {0x2ca00019,0xf09f00cd,0x7a381a3f,0x00000000}},	//   kuid_, tuà_, pítu,
  { {0x7a3800ea,0x20181a40,0x249f00e5,0x00000000}},	//   líts, firi_, cuum_,
  { {0xdb170016,0x2ca00122,0x20181a41,0x00000000}},	//   nexã, duid_, giri_,
  { {0x0d67005a,0x660205e5,0xbe880076,0x00000000}},	//   възм, _klok, ксте_,
  { {0x443e1a42,0xd3570063,0xa91d1a43,0x00000000}},	//   llt_, _בשוק_, _leža,
  { {0x20181a44,0x60d61a45,0xe9ff008d,0x00000000}},	// [25d0] biri_, _grym, _nhạn_,
  { {0x91a0001b,0x25bf000c,0x629a1a46,0x00000000}},	//   _thị_, zeul_, orto,
  { {0x49750001,0x61fd0078,0x443e1a47,0x00000000}},	//   глес, oksl, ilt_,
  { {0x443e0199,0x0a940086,0x7a3800ea,0x00000000}},	//   hlt_, рацю, díts,
  { {0xa91d0024,0x61fd0006,0x69341a48,0x00000000}},	//   _beža, iksl, анцу,
  { {0x66021a49,0x443e00ea,0x16a90256,0x00000000}},	//   _alok, jlt_, евки_,
  { {0x7a38000f,0xb6590086,0x66021a4a,0x00000000}},	//   gíts, нших_, _blok,
  { {0x20180035,0x443e1a4b,0x3618000d,0x00000000}},	//   ziri_, elt_, кцыю_,
  { {0x644a0025,0x629a1a4c,0x998f004c,0x00000000}},	//   _bhfi, erto, logů_,
  { {0xdce4003d,0x66021a4d,0x249f0019,0x00000000}},	//   nciā, _elok, ruum_,
  { {0x6602007a,0x7a381a4e,0x600200be,0x00000000}},	//   _flok, mítr, _nôma,
  { {0x66020089,0x60d60022,0x443e1a4f,0x00000000}},	//   _glok, _prym, alt_,
  { {0x657b06a7,0x25e00161,0x2018192b,0x00000000}},	//   mbuh, कारी_, tiri_,
  { {0x04920021,0x66020051,0x23290bd8,0x00000000}},	//   _الوح, _zlok, _поли_,
  { {0x20180009,0x44271a50,0x7f19013c,0x00000000}},	//   riri_, _ijn_, віту_,
  { {0x20180035,0x2ca00019,0x7c3e006f,0x00000000}},	//   siri_, tuid_, wlpr,
  { {0x248d1a51,0x75f5013d,0x7a38013d,0x00000000}},	// [25e0] nsem_, _házs, zíts,
  { {0x207b0047,0xb05b004d,0x6d46004c,0x00000000}},	//   _ראיא, nwäl, _vzka,
  { {0xda650032,0x657b002c,0xa01b0137,0x00000000}},	//   لاني, kbuh, tsöv,
  { {0x53360047,0x3f8a179b,0x7a3800ea,0x00000000}},	//   אנען_, labu_, víts,
  { {0x2ca01a52,0x443e0303,0x4614007e,0x00000000}},	//   quid_, ylt_, یوتر,
  { {0xd7e70062,0x98470062,0xdce6005f,0x00000000}},	//   лмче_, ляща_, _sekė,
  { {0xdcfd001c,0x443e01e1,0x6602135a,0x00000000}},	//   _iesā, vlt_, _plok,
  { {0x3f8a0035,0x443e05e4,0x657b00a4,0x00000000}},	//   habu_, wlt_, gbuh,
  { {0xa91d05c9,0x7a3819ba,0x6e2400a4,0x00000000}},	//   _teža, bítr, inib,
  { {0x78a202f6,0x439400e1,0x657b00a4,0x00000000}},	//   muov, јанс, abuh,
  { {0x7bce03d5,0x8c370063,0x3f850014,0x00000000}},	//   _mabu, רטיס_, ðlum_,
  { {0xdb1c0139,0x6002008d,0x95c709b3,0x00000000}},	//   _barú, _rôma, _буша_,
  { {0x78a201f4,0x61fd1a53,0x00000000,0x00000000}},	//   nuov, rksl,   ,
  { {0x7bce1a54,0xdcfd008f,0x3f850014,0x00000000}},	//   _nabu, _nesā, úlu_,
  { {0xb7db0047,0xa91d1a55,0x68f90022,0x00000000}},	//   עקלי, _nežn, zywd,
  { {0x7bce002c,0x78a20cff,0x6fde0042,0x00000000}},	//   _aabu, kuov, माउं,
  { {0x3f8a0009,0x69c2191f,0x9c39000a,0x00000000}},	// [25f0] babu_, deoe, впат_,
  { {0xa91d0024,0x3f150086,0x6e240da5,0x00000000}},	//   _bežn, _вдос, anib,
  { {0xdb1502dd,0xdce4001c,0xd7f1008b,0x00000000}},	//   _razó, rciā, _rõ_,
  { {0xdb15006d,0xa91d00c2,0x0d640062,0x00000000}},	//   _sazó, _dežn, _гърм,
  { {0x225901c8,0xdd05008f,0xb05b0244,0x00000000}},	//   írky_, āpēj, hwäm,
  { {0xb8cd0161,0xe8f80088,0x248d1438,0x00000000}},	//   _कम_, ылі_, vsem_,
  { {0xdd2f004c,0x75fc013d,0xe1ff013d,0x00000000}},	//   věřo, _kézh, kkó_,
  { {0x8645005e,0x7bce1a56,0x78a20061,0x00000000}},	//   јниж, _zabu, buov,
  { {0xdb0500bd,0xccf20047,0xf4290239,0x00000000}},	//   gehö, ַכט_, коил_,
  { {0x68f600fe,0xa01b0072,0xddd5013d,0x00000000}},	//   äyde, isös, iszű,
  { {0x248d1a57,0x657b00a4,0xb05b004d,0x00000000}},	//   ssem_, pbuh, rwäl,
  { {0x3f8a0035,0xa06a1a58,0xdb050502,0x00000000}},	//   wabu_, кама_, behö,
  { {0x3f8a0009,0x3eb1004d,0xa8790047,0x00000000}},	//   tabu_, etzt_, כאָר,
  { {0x8fa60079,0x661b0b4f,0x7d0d0051,0x00000000}},	//   јаве, liuk, dzas,
  { {0xa225006a,0x3f8a10d2,0x7d0d1a59,0x00000000}},	//   _گروه, rabu_, ezas,
  { {0x3f8a0035,0x7bce1a5a,0x64411a5b,0x00000000}},	//   sabu_, _sabu, llli,
  { {0xed5a0079,0x7bce00a4,0xddd500ea,0x00000000}},	// [2600] тоа_, _pabu, gszű,
  { {0x4f961a5c,0x6441002b,0x60c90058,0x00000000}},	//   _триу, nlli, çeme,
  { {0xbf9b009f,0xc9661a5d,0x64411a5e,0x00000000}},	//   _בייש, авей, illi,
  { {0xe8fa00e2,0xbcfb013d,0xdca60336,0x00000000}},	//   кле_, _igén, _ками,
  { {0x18b80088,0x7d0d0051,0x8d630086,0x00000000}},	//   углы_, czas, _євре,
  { {0x48130086,0x66090bda,0xa91d08ed,0x00000000}},	//   оміс, ehek, _težn,
  { {0xddc4001c,0x2cb21a5f,0x290016ff,0x00000000}},	//   rmiņ, ltyd_, šia_,
  { {0xa01b00c7,0x64410d9e,0x75fc013d,0x00000000}},	//   nsör, elli, _kézi,
  { {0x2cb200ac,0x186a0086,0x37e60da2,0x00000000}},	//   ntyd_, _рази_, _коаг,
  { {0xe9ff001b,0xf366041d,0x6908005b,0x00000000}},	//   _phần_, штин, ırdı,
  { {0x7bd900b5,0x3266018e,0x7d0d1a60,0x00000000}},	//   אַרק, јтов, zzas,
  { {0xd5b0007e,0x66090035,0x9f580025,0x00000000}},	//   _رفت_, chek, bhrú_,
  { {0x6002017d,0x629c0066,0x64740121,0x00000000}},	//   _cômo, árob, _углу,
  { {0xe9ff008b,0x3317007e,0xfe73002a,0x00000000}},	//   _thần_, ازید_, قدر_,
  { {0x3a260122,0x54390047,0xbd6b0002,0x00000000}},	//   knop_, _געװא, врзе_,
  { {0x2cb200ac,0x75fc0003,0xdcfd00dd,0x00000000}},	//   ftyd_, _bézi, _nesă,
  { {0x7c8705ac,0xde580054,0x7d0d056c,0x00000000}},	// [2610] рубе, раті_, uzas,
  { {0x60cd1a61,0x7d0d0022,0x113c009a,0x00000000}},	//   _isam, rzas, _בתחל,
  { {0x9e350854,0x798b1a62,0xdce70058,0x00000000}},	//   _генч, tagw, ılıd,
  { {0xa2d70053,0x00000000,0x00000000,0x00000000}},	//   यित्,   ,   ,
  { {0xe9ff001b,0xdcfd003b,0x01fc0041,0x00000000}},	//   _nhấn_, _desă, כפאל,
  { {0x60cd0035,0xf09f174c,0xed56009a,0x00000000}},	//   _msam, irà_, _לברר_,
  { {0xfeca0047,0xaa94049f,0x66090b06,0x00000000}},	//   ָמפּ, _мирч, thek,
  { {0x9f580025,0xc4850713,0x60cd0a97,0x00000000}},	//   thrú_, блик, _osam,
  { {0xf7950088,0xe9ff0013,0x644100cd,0x00000000}},	//   _газэ, _chấn_, tlli,
  { {0xf09f19c9,0xf7700021,0x75f50e7c,0x00000000}},	//   drà_, _قام_, _vázq,
  { {0x7c220164,0x60cd1a63,0xf09f174c,0x00000000}},	//   éori, _asam, erà_,
  { {0x00000000,0x00000000,0x00000000,0x00000000}},	//     ,   ,   ,
  { {0x7bc51a64,0xf09f00cd,0x7989006f,0x00000000}},	//   kehu, grà_, _meew,
  { {0x249f0146,0x43850021,0x653a0047,0x00000000}},	//   mrum_, _الثق, _גענד,
  { {0xf09f19c9,0x60cd1a65,0xd1380051,0x00000000}},	//   arà_, _esam, łą_,
  { {0xf09f0268,0x629c001c,0x249f1a66,0x00000000}},	//   brà_, šroc, orum_,
  { {0x4d4a0001,0x249f00c7,0x61e41a67,0x00000000}},	// [2620] упан_, nrum_, _inil,
  { {0xf1bf0027,0x2cb200e8,0x249f0014,0x00000000}},	//   nnán_, rtyd_, irum_,
  { {0x7c2b0153,0x7ed50054,0x249f0058,0x00000000}},	//   égra, _діяч, hrum_,
  { {0xf1bf0025,0xb05b004d,0xdb0700ea,0x00000000}},	//   hnán_, ewäh, émár,
  { {0x2d801a68,0x98a30257,0x5e570041,0x00000000}},	//   mbie_, зиче, _ליטע_,
  { {0xdb1e000f,0x2bb70080,0x4c350085,0x00000000}},	//   lepí, _věcí_, _дэст,
  { {0xdb0e00fe,0x2d800051,0x3b0a0002,0x00000000}},	//   äjän, obie_, _сево_,
  { {0xe5c6093e,0x798900ac,0x443c0026,0x00000000}},	//   сско, _geew, _skv_,
  { {0x8cdb0053,0xdce40022,0xb9061415,0x00000000}},	//   नियो, bcią, _узак,
  { {0xf09f051e,0x600b005b,0x7989006f,0x00000000}},	//   vrà_, _küme, _zeew,
  { {0x61f61a69,0x60cd0072,0x7c3b0aeb,0x00000000}},	//   _boyl, _ssam, רגיז,
  { {0xf09f1a6a,0x201a0290,0x64a61a6b,0x00000000}},	//   trà_, _ampi_, _гада,
  { {0xf09f00cd,0x339402dc,0x763b0047,0x00000000}},	//   urà_, _далё, _געאג,
  { {0xf09f02f6,0x3e6e0080,0x61e4001f,0x00000000}},	//   rrà_, _být_, _enil,
  { {0x7bc504aa,0x2ca0004e,0xa3c50042,0x00000000}},	//   vehu, erid_, उजर_,
  { {0x60cd00f7,0x5eb40121,0xf09f099f,0x00000000}},	//   _tsam, яйст, prà_,
  { {0x7bc51a6c,0x60cd1a6d,0xdfd50085,0x00000000}},	// [2630] tehu, _usam, _допы,
  { {0xbddb0164,0x43780063,0xdcfd0078,0x00000000}},	//   _chèr, שְּׁ, _nesą,
  { {0x2ca00004,0xb99501fb,0xeb4b0fce,0x00000000}},	//   arid_, قلاب, учак_,
  { {0x2ca01a6e,0xf1bf004c,0x2bc70042,0x00000000}},	//   brid_, znán_, रजहा,
  { {0xb05b0024,0x75fc013d,0x37891849,0x00000000}},	//   dväz, _jézu, абло_,
  { {0xbddb0003,0x4cba0047,0x249f0137,0x00000000}},	//   _thès, _דזשו, vrum_,
  { {0xb05b004d,0x32090792,0x32020050,0x00000000}},	//   rwäh, _olay_, ykky_,
  { {0xb05b00bd,0x46490002,0xa5f6005e,0x00000000}},	//   swäh, јзин_, жећу_,
  { {0xdb1e000c,0xc7ab007e,0xc9840074,0x00000000}},	//   cepâ, _مدال_, _хуси,
  { {0x320904d2,0x61e40829,0x387d002b,0x00000000}},	//   _alay_, _snil, mpwr_,
  { {0x249f102d,0x2d800051,0xf1bf1a6f,0x00000000}},	//   srum_, ybie_, rnán_,
  { {0x2d8b007d,0xcad60063,0x32091a70,0x00000000}},	//   _nece_, קורת_, _clay_,
  { {0xa06a1a58,0x628e00ea,0x0574014d,0x00000000}},	//   рага_, ábor, _راند,
  { {0xee3f0024,0xa3d40085,0x2ca0004b,0x00000000}},	//   _aký_, _ночч, vrid_,
  { {0x645d005f,0x50431a71,0x9e050082,0x00000000}},	//   įsid, ферб, रसंघ_,
  { {0x61e41a72,0x2ca01a73,0xf1bf013d,0x00000000}},	//   _unil, trid_, nnál_,
  { {0xbddb0003,0x2d8b007d,0x2d800ea6,0x00000000}},	// [2640] _chèq, _dece_, rbie_,
  { {0x8b26000d,0xa91d00c2,0xeaba0062,0x00000000}},	//   одзе, _težj, ийз_,
  { {0x2d8b051e,0xf1bf00ea,0x38b2001f,0x00000000}},	//   _fece_, knál_, wâr_,
  { {0xa3d50053,0x752f0051,0x2d8b005b,0x00000000}},	//   ाएँ_, żczy, _gece_,
  { {0xf1bf013d,0x00000000,0x00000000,0x00000000}},	//   dnál_,   ,   ,
  { {0x2d8b000c,0x7aea004d,0xec34007e,0x00000000}},	//   _zece_, äfts, _روزگ,
  { {0x46670766,0x8a06046e,0xab270320,0x00000000}},	//   орым_, _дзве, _дора_,
  { {0x1637043b,0x7ae1000f,0xd5b709d2,0x00000000}},	//   يسية_, _álta, ось_,
  { {0x442a0001,0xa3d50053,0x0595007e,0x00000000}},	//   ицом_, ाएं_, سايگ,
  { {0x2240000f,0x344a0699,0x320900e5,0x00000000}},	//   _akik_, јчин_, _slay_,
  { {0x32091a74,0xe73a0086,0xb05b00a5,0x00000000}},	//   _play_, _теж_, mväx,
  { {0x601000c7,0xb05b0137,0xb6a400dd,0x00000000}},	//   _jämf, lväx, _crâş,
  { {0xd2580088,0x2d8b003b,0xddcd0051,0x00000000}},	//   юць_, _rece_, ymał,
  { {0x600b0019,0x2a640af9,0xb05b0137,0x00000000}},	//   _sümb, _limb_, nväx,
  { {0xed8b0138,0x28d10161,0x65790003,0x00000000}},	//   исак_, _दैनि, _éché,
  { {0xdb1c00bd,0x7c2e00a8,0x2136006c,0x00000000}},	//   _darü, _ajbr, éché_,
  { {0x69c60026,0x3169013d,0xb05b00a5,0x00000000}},	// [2650] _ókey, _igaz_, kväx,
  { {0x9f580026,0x3a3f14ba,0x26de0387,0x00000000}},	//   skrá_, _skup_, _orto_,
  { {0xa91d1253,0x2a640089,0x78a21a75,0x00000000}},	//   _težk, _bimb_, erov,
  { {0x3f91007d,0x78a201f5,0x25da0042,0x00000000}},	//   lazu_, frov, _खोली_,
  { {0xdb150016,0xe9d8000d,0xdb1c1a76,0x00000000}},	//   _razõ, ўкі_, _baró,
  { {0xf7710fe0,0x46f5005a,0xa91d1a77,0x00000000}},	//   رات_, зчит, _ježi,
  { {0xf1bf013d,0x46a51a78,0x78a21a79,0x00000000}},	//   tnál_, чайв, arov,
  { {0x2a6400c2,0x78a2081a,0xdce40022,0x00000000}},	//   _gimb_, brov, ecię,
  { {0xdb1c0025,0xad9b0139,0x629c0331,0x00000000}},	//   _faró, _clúi, áron,
  { {0x43740086,0xa91d1a7a,0x224001e1,0x00000000}},	//   муют, _neži, _skik_,
  { {0x7bd51a7b,0x3f9e0014,0xe299005e,0x00000000}},	//   _mazu, ótum_, љам_,
  { {0xdb1c0051,0xad9b0139,0x98bf0022,0x00000000}},	//   _zaró, _flúi, _czuć_,
  { {0xa91d04c9,0x2bac0053,0xad9b0139,0x00000000}},	//   _beži, _चाला, _glúi,
  { {0xdb0500ea,0x3f8c0066,0xd7f10013,0x00000000}},	//   eghí, údu_, _tĩu_,
  { {0x25ad1a7c,0x78a20066,0x79820022,0x00000000}},	//   ogel_, zrov, ybow,
  { {0x386d00e8,0x9f63004c,0xe9ff0013,0x00000000}},	//   _ouer_, ívám_, _thẹn_,
  { {0xed57000a,0x7bd51a7d,0x75fc013d,0x00000000}},	// [2660] зот_, _bazu, _kézr,
  { {0x7bd50529,0x394400a5,0x78a21a7e,0x00000000}},	//   _cazu, _ryms_, vrov,
  { {0x7bd5004d,0xf1bf004c,0x6ffb009a,0x00000000}},	//   _dazu, znám_, _הפיג,
  { {0xdb1e00cd,0x38c8007e,0x78a21a7f,0x00000000}},	//   repà, قاتی_, trov,
  { {0x2d920035,0x7bd50089,0xdce40051,0x00000000}},	//   maye_, _fazu, ycię,
  { {0x78a21a80,0x7bd5003b,0x386d1a81,0x00000000}},	//   rrov, _gazu, _duer_,
  { {0xdb1c006d,0xb05b0137,0x6002017d,0x00000000}},	//   _varó, rväx, _cômi,
  { {0x25ad00ea,0xddcf000c,0x78a209b7,0x00000000}},	//   ggel_, _micş, prov,
  { {0xb05b0137,0x0ee90042,0xa53404d6,0x00000000}},	//   pväx, _ऑप्स_, ьнич,
  { {0xdb1c0003,0x7c3e1a82,0xb8650021,0x00000000}},	//   _abré, nopr, _قالو,
  { {0x60c40006,0x26de0290,0x2d9d0051,0x00000000}},	//   _apim, _urto_, ówek_,
  { {0x60990044,0x00000000,0x00000000,0x00000000}},	//   ينجس_,   ,   ,
  { {0x2d920009,0x463b0047,0x3f910114,0x00000000}},	//   daye_, _פעדע, tazu_,
  { {0xa3e30235,0x54530086,0x644f0003,0x00000000}},	//   _पोप_, _звіт, ïcit,
  { {0x69c0034d,0x442c02eb,0x7bd502e2,0x00000000}},	//   _obme, mnd_, _razu,
  { {0x443e1a83,0x442c02d2,0xfbd3007e,0x00000000}},	//   lot_, lnd_, کتر_,
  { {0x442c1a84,0x1df80076,0x423801f9,0x00000000}},	// [2670] ond_, четы_, _מנהל_,
  { {0x443e003d,0xf09201f9,0x69c0004d,0x00000000}},	//   not_, _שני_, _abme,
  { {0x2d921a85,0x442c1a86,0x645a0dff,0x00000000}},	//   baye_, ind_, imti,
  { {0x7bd50035,0xdb1c01a8,0xa2a40053,0x00000000}},	//   _wazu, _parò, _किन्,
  { {0xa3ac024c,0xddc401f7,0x386d1a87,0x00000000}},	//   गला_, lmiş, _quer_,
  { {0x443e003d,0xd3660032,0x7c3e051e,0x00000000}},	//   jot_, _له_, copr,
  { {0xddc4005b,0x629c00ea,0x443e1a88,0x00000000}},	//   nmiş, árol, dot_,
  { {0x386d0003,0x64481a89,0x25ad06aa,0x00000000}},	//   _tuer_, eldi, ugel_,
  { {0xda340076,0x6298051e,0x443e1a8a,0x00000000}},	//   _четы, _avvo, fot_,
  { {0x2d920035,0x443e1a8b,0x93c2003b,0x00000000}},	//   zaye_, got_, _ţăra,
  { {0x69cb0179,0x69d9001f,0xd1ca0cb5,0x00000000}},	//   oege, odwe, олне_,
  { {0x7ae300fe,0x442c1a8c,0xddcd008f,0x00000000}},	//   änty, and_, lmaņ,
  { {0x20040016,0x6e2d001f,0x69cb004d,0x00000000}},	//   êmio_, dnab, iege,
  { {0x94740021,0x76491a8d,0x443e1a8e,0x00000000}},	//   _أدنا, lley, cot_,
  { {0x7f430055,0x7c3e1a8f,0x42d50054,0x00000000}},	//   верж, vopr, _цілу,
  { {0x6e2d007a,0x76491a90,0x765b0058,0x00000000}},	//   gnab, nley, nmuy,
  { {0x3eaa000c,0x60c40035,0x4095000d,0x00000000}},	// [2680] subt_, _upim, _прэт,
  { {0x2d920003,0x6faa0021,0x600b004b,0x00000000}},	//   saye_, _بهدف_, _hümn,
  { {0x764901f7,0x600b0019,0x69cb034e,0x00000000}},	//   kley, _kümn, fege,
  { {0x69cb1a91,0x6b8e1a92,0x443e1a93,0x00000000}},	//   gege, _webg, zot_,
  { {0x64481a94,0x442c1a95,0x64431a96,0x00000000}},	//   yldi, ynd_, _okni,
  { {0xdb1c007a,0xd6b40062,0x93bc003b,0x00000000}},	//   _farð, ейкъ, lnăv,
  { {0x6b63000d,0x7649005b,0xbb460002,0x00000000}},	//   _акра, fley, _цевк,
  { {0xceb3014e,0xb05b00bd,0xf1bf00ea,0x00000000}},	//   דיה_, nwär, rnák_,
  { {0x64a3000a,0x26c50019,0x443e1a97,0x00000000}},	//   вања, _eplo_, tot_,
  { {0x442c0780,0xb05b004d,0xa2f40121,0x00000000}},	//   und_, hwär, епоч,
  { {0xe57a0088,0x442c0649,0x443e1a98,0x00000000}},	//   _дзе_, rnd_, rot_,
  { {0x7d04024a,0x20ca0053,0x644306f1,0x00000000}},	//   kyis, िबंध, _ekni,
  { {0xc1050021,0x76401a99,0xdb1e004b,0x00000000}},	//   روسي, momy, lepä,
  { {0xdb1e017d,0xddc4005b,0x60dd00b9,0x00000000}},	//   cepç, tmiş, rvsm,
  { {0x629500ea,0xb05b004d,0x69d9002b,0x00000000}},	//   ázot, fwär, ydwe,
  { {0x7c870001,0x600b0019,0xddc4005b,0x00000000}},	//   дуже, _gümn, rmiş,
  { {0xde64005a,0xdc55018e,0x6e2d1a9a,0x00000000}},	// [2690] търп, евањ, rnab,
  { {0x7649005b,0x6e2d0c29,0x9f890014,0x00000000}},	//   zley, snab, _góðu_,
  { {0x7649005b,0x76401a9b,0xe0df01f4,0x00000000}},	//   yley, komy, lvò_,
  { {0xdb1c0026,0x76400051,0xf1bf0025,0x00000000}},	//   _varð, jomy, nfá_,
  { {0x7d160051,0xad9b0025,0x4e160063,0x00000000}},	//   czys, _dlút, _נחשב_,
  { {0x78ab1a20,0x69cb1a9c,0xf8070054,0x00000000}},	//   rugv, sege, ьчен,
  { {0x7649005b,0x69cb1a9d,0xcb440caa,0x00000000}},	//   tley, pege, _ахти,
  { {0xad9b00be,0x24f5012c,0x6ec20082,0x00000000}},	//   _glút, ечор, _लहसु,
  { {0xe7e00235,0x3e7500c7,0x76491a90,0x00000000}},	//   _गोवा_, _låt_, rley,
  { {0x62810250,0xdb1e004b,0x52850074,0x00000000}},	//   tplo, bepä, нгоб,
  { {0x764900a4,0x3e7500a5,0x0ece0042,0x00000000}},	//   pley, _nåt_, _हैंड,
  { {0x62811a9e,0x96350054,0x7d160022,0x00000000}},	//   rplo, _янец, yzys,
  { {0xa3b70053,0x62811a9f,0xe5070044,0x00000000}},	//   _छाप_, splo, _تباي,
  { {0x9f9b004b,0x66091aa0,0x3e7500cf,0x00000000}},	//   jääk_, lkek, _båt_,
  { {0x8464005a,0x44251aa1,0xb05b004d,0x00000000}},	//   _ръце, mil_, twär,
  { {0xee3a019d,0x7d04024a,0x25bf00e5,0x00000000}},	//   їна_, tyis, nful_,
  { {0x44250025,0x25bf0150,0x64411aa2,0x00000000}},	// [26a0] oil_, iful_, ooli,
  { {0x7d160045,0xb05b004d,0x6e24004b,0x00000000}},	//   rzys, swär, siib,
  { {0x7d160051,0x93bc003b,0x387f1aa3,0x00000000}},	//   szys, mnăt, _atur_,
  { {0x6aa30027,0x44251aa4,0xfaa30002,0x00000000}},	//   ánfa, hil_, ѓачо,
  { {0x2fda00a4,0x64411aa5,0x44251aa6,0x00000000}},	//   _kapg_, koli, kil_,
  { {0xf093009a,0x44251aa7,0xd7e7005e,0x00000000}},	//   ננו_, jil_, емље_,
  { {0x64411aa8,0x44251aa9,0x76401aaa,0x00000000}},	//   doli, dil_, tomy,
  { {0xdb1e0019,0xcb67000d,0x629c001c,0x00000000}},	//   repä, _часе_, šrok,
  { {0x442502e0,0xddde008f,0xdbd7004b,0x00000000}},	//   fil_, _atpū, _fääs,
  { {0x64410185,0x44251aab,0xdcef001c,0x00000000}},	//   goli, gil_, _secī,
  { {0xa3b60053,0xb05b004d,0x60d61aac,0x00000000}},	//   ङ्ग_, ltäg, _asym,
  { {0x44250027,0xdb21013d,0x6441004b,0x00000000}},	//   ail_, ütés, aoli,
  { {0xc05b0086,0x44251aad,0x489b0041,0x00000000}},	//   зів_, bil_, ּילװ,
  { {0x44251aae,0xe0df0290,0xdb1c006d,0x00000000}},	//   cil_, rvò_, _abrí,
  { {0xdd95000d,0x9f340054,0x7c250050,0x00000000}},	//   кавы, гері, vihr,
  { {0x629a1aaf,0x93bc00dd,0xe7e70082,0x00000000}},	//   msto, rnău, _टोना_,
  { {0x629a1ab0,0x61ed1ab1,0x3015000d,0x00000000}},	// [26b0] lsto, _inal, _адпр,
  { {0x600b1ab2,0x629a1ab3,0xad9b0046,0x00000000}},	//   _kümm, osto, _plús,
  { {0xd011007e,0x25bf00e5,0x7c250a80,0x00000000}},	//   _ملک_, yful_, rihr,
  { {0x64411147,0xdbd7065c,0x629a1ab4,0x00000000}},	//   zoli, _sääs, isto,
  { {0xfd96014e,0x64410035,0xdbd70d68,0x00000000}},	//   _בדרך_, yoli, _pääs,
  { {0x25bf0034,0x64580093,0x44251ab5,0x00000000}},	//   wful_, _nhvi, xil_,
  { {0x25bf0034,0x44251ab6,0x629a13d7,0x00000000}},	//   tful_, vil_, jsto,
  { {0x78a40117,0x44250cc4,0x2ca91ab7,0x00000000}},	//   šiva, wil_, orad_,
  { {0x25bf1729,0x44251ab8,0x629a1ab9,0x00000000}},	//   rful_, til_, esto,
  { {0x1309026c,0x2b9c0080,0x44250992,0x00000000}},	//   дной_, mácí_, uil_,
  { {0x38bb00ac,0x44251aba,0x64411abb,0x00000000}},	//   lêr_, ril_, roli,
  { {0x44251abc,0x412a0156,0x2ca90137,0x00000000}},	//   sil_, домо_, krad_,
  { {0x69db00bd,0x660600ea,0x629a1abd,0x00000000}},	//   _maue, ökke, asto,
  { {0x2ca91abe,0x629a1abf,0x69db1ac0,0x00000000}},	//   drad_, bsto, _laue,
  { {0x539a014e,0xa0671ac1,0x2ca91ac2,0x00000000}},	//   _חיצו, тара_, erad_,
  { {0xe8df008b,0xf1bf09b1,0x3ea508f5,0x00000000}},	//   _cuịa_, lián_, álta_,
  { {0x8e550086,0x3b960095,0x93bc003b,0x00000000}},	// [26c0] утрі, вјет, mnăr,
  { {0x61ed03a4,0xaf0601fe,0x3157009a,0x00000000}},	//   _znal, _апол, _ביפן_,
  { {0x69db103b,0x93bc003b,0x2ca91ac3,0x00000000}},	//   _baue, onăr, arad_,
  { {0xfaa30088,0x2ca91ac4,0x3c94007e,0x00000000}},	//   рацо, brad_, _میرز,
  { {0x69db00bd,0xa9670d4c,0xd7fa02fa,0x00000000}},	//   _daue, вица_, дуй_,
  { {0xbcfb000f,0xdb210024,0x3f981ac5,0x00000000}},	//   _egés, štát, naru_,
  { {0x48ee0053,0xfaa60002,0x629a1233,0x00000000}},	//   _आपको_, _јабо, xsto,
  { {0x7bdc014f,0x76591ac6,0x7f3b0063,0x00000000}},	//   _haru, _chwy, ועצו,
  { {0x2603048e,0x7866000d,0x7bdc1ac7,0x00000000}},	//   _años_, _аказ, _karu,
  { {0x7bde0d5e,0x629a1ac8,0x7bdc1ac9,0x00000000}},	//   ndpu, tsto, _jaru,
  { {0x629a1aca,0x7bdc1acb,0x04430002,0x00000000}},	//   usto, _maru, реќн,
  { {0x7bdc1acc,0x9293000d,0xe8df0013,0x00000000}},	//   _laru, шаюц, _uyển_,
  { {0x3f98002b,0xf1bf0331,0x63f60044,0x00000000}},	//   faru_, bián_, _لأغر,
  { {0x629a1acd,0xc9530063,0x7bde0137,0x00000000}},	//   psto, שמש_, jdpu,
  { {0xcddb005e,0x7f94007f,0x6e940121,0x00000000}},	//   мња_, расх, ииру,
  { {0x61ed075a,0x2ca91ace,0xddc40022,0x00000000}},	//   _unal, trad_, elił,
  { {0x7bdc0009,0xe390001b,0x7d550062,0x00000000}},	// [26d0] _baru, _điề, увах,
  { {0x600b005b,0x69db1acf,0xdfd1007e,0x00000000}},	//   _mümk, _saue, _ايد_,
  { {0x2ca90137,0x7bdc1ad0,0x69db007d,0x00000000}},	//   srad_, _daru, _paue,
  { {0xc33301f9,0x601000c7,0xc987005e,0x00000000}},	//   בוע_, _jämn, тужи,
  { {0x76590185,0x621c0047,0xa928004c,0x00000000}},	//   _rhwy, וואק, vyžá,
  { {0x601000c7,0x7bdc1ad1,0x38bb00e8,0x00000000}},	//   _lämn, _garu, rêr_,
  { {0x8cdb0053,0x68e2082a,0x7659001f,0x00000000}},	//   निको, avod, _phwy,
  { {0x601000c7,0x24590003,0xe8e00013,0x00000000}},	//   _nämn, ième_, huột_,
  { {0x24591090,0x63a70022,0x9525005d,0x00000000}},	//   hème_, ójno, دکام,
  { {0x6b95007d,0x23d50ae8,0x87d7002a,0x00000000}},	//   _jezg, уцир, _جغرا,
  { {0xa22a0ae8,0x7659002b,0x3f981ad2,0x00000000}},	//   ежна_, _thwy, varu_,
  { {0x6248006d,0x24590003,0x3f981ad3,0x00000000}},	//   eñor, dème_, waru_,
  { {0x93bc003b,0x3f981ad4,0x95670062,0x00000000}},	//   rnăr, taru_, _ръжд,
  { {0xdd2f0080,0x2a6d004d,0x79990150,0x00000000}},	//   měňo, _lieb_, haww,
  { {0xdb1c0512,0xada60b3f,0x68e21871,0x00000000}},	//   _obrá, лавл, zvod,
  { {0x7bdc1ad5,0x394d0331,0x3f981ad6,0x00000000}},	//   _saru, _oyes_, saru_,
  { {0x22980080,0xf1bf00ea,0xee3706c3,0x00000000}},	// [26e0] _týká_, rnát_, унт_,
  { {0xb05b00fe,0x4d631ad7,0x2b160766,0x00000000}},	//   ttäe, скув, льер,
  { {0x6b95003b,0x6010004d,0x7bdc1ad8,0x00000000}},	//   _dezg, _hämo, _varu,
  { {0x02b60047,0x6abe004d,0x7bdc1ad9,0x00000000}},	//   טלעך_, rtpf, _waru,
  { {0xa3b3016a,0x7bdc0f2b,0xb05b0072,0x00000000}},	//   टला_, _taru, stäe,
  { {0xa09b0149,0x394d00e5,0x6b950058,0x00000000}},	//   גיסט, _dyes_, _gezg,
  { {0x394d0034,0xb05b0137,0xfd500013,0x00000000}},	//   _eyes_, ltäc, _nghẹ,
  { {0xa5bd0078,0xfa670094,0xa6c7009b,0x00000000}},	//   liųj, _баск_, اويل_,
  { {0x27ef0080,0x75fc00ea,0x99160085,0x00000000}},	//   ální_, _kézz, _сьві,
  { {0x224900b9,0x1cbb0047,0x986a0044,0x00000000}},	//   _skak_, עמיע, _أحرف_,
  { {0xe9ff008b,0x2bc60053,0xdddc00c2,0x00000000}},	//   _chặn_, र्या, zprš,
  { {0x54e60242,0xdddc0195,0xdb05004d,0x00000000}},	//   _مستق, yprš, pfhö,
  { {0x3d000053,0x75d3009e,0x62831ada,0x00000000}},	//   ोनों_, _دينا, _etno,
  { {0x75fc000f,0x2bc60161,0x24590003,0x00000000}},	//   _nézz, र्मा, tème_,
  { {0x66021adb,0xce950062,0xaed50054,0x00000000}},	//   _kook, рабъ, шовш,
  { {0x66020004,0x24590003,0x62881adc,0x00000000}},	//   _jook, rème_, mpdo,
  { {0x20010019,0x8234007e,0xd0d50062,0x00000000}},	// [26f0] _tohi_, _دروا, _топъ,
  { {0x66020034,0x60cd002c,0x7d0200fe,0x00000000}},	//   _look, _ipam, äosa,
  { {0xf09f01a8,0xdddc007d,0xbcfb013d,0x00000000}},	//   lsà_, sprš, _egép,
  { {0xfde90042,0x5efa089e,0xeb480094,0x00000000}},	//   _ऑफिस_, _ספרד, учук_,
  { {0xa9350076,0xf09f00cd,0x200c0137,0x00000000}},	//   шедш, nsà_, ödig_,
  { {0x60100832,0x807c0041,0x2c6d005f,0x00000000}},	//   _näml, ענוצ, _iždo_,
  { {0xe5710021,0x66021add,0xc9871367,0x00000000}},	//   يطة_, _book, _бузи,
  { {0x7aea010a,0x46e60062,0x66021ade,0x00000000}},	//   æfte, рдън_, _cook,
  { {0xc7d90062,0xf1bf0240,0x84590002,0x00000000}},	//   _имах_, riál_, крот_,
  { {0xe4c80021,0x03a50092,0x44d60022,0x00000000}},	//   ابين_, јино, _dł_,
  { {0x244b05b9,0x6602004b,0xa5d50002,0x00000000}},	//   dømt_, _fook, _вжеш,
  { {0x0166042c,0xb34500cd,0x20050014,0x00000000}},	//   икно, _alçà, ölin_,
  { {0xe0d7011c,0x998f0006,0x291d05b3,0x00000000}},	//   авя_, logų_, nzwa_,
  { {0x8e860121,0x0fd90145,0xa06a01ce,0x00000000}},	//   игге, льсы_, ђава_,
  { {0x44d60051,0x249f1adf,0x69c901a8,0x00000000}},	//   _zł_, lsum_, _obee,
  { {0xdcfd008f,0x68e91ae0,0x40960cd6,0x00000000}},	//   _nesē, _ored, _крот,
  { {0x249f1ae1,0x6d4f1ae2,0x4c850021,0x00000000}},	// [2700] nsum_, _cyca, مؤلف,
  { {0x515b014e,0x4f260121,0x309b0063,0x00000000}},	//   _בכפו, _вдоб, _ששימ,
  { {0xdef90088,0xf1eb0053,0xb05b0137,0x00000000}},	//   _быў_, _जोड़_, stäc,
  { {0xb05b00c7,0xda650032,0xa5bd0078,0x00000000}},	//   ptäc, ماني, siųj,
  { {0x68e91ae3,0x3e7c0013,0x5cf60121,0x00000000}},	//   _cred, _hít_, _тяну,
  { {0xb8ce0394,0xc6a602b3,0x2d801ae4,0x00000000}},	//   _कि_, арии, lcie_,
  { {0x3e7c0080,0x68e91ae5,0x56940612,0x00000000}},	//   _jít_, _ered, щайт,
  { {0x3e7c0080,0x95ca0ace,0x44271ae6,0x00000000}},	//   _mít_, тука_, _amn_,
  { {0x442707b7,0x3e7c0013,0xe9ff0013,0x00000000}},	//   _bmn_, _lít_, _chẵn_,
  { {0xe3b8005b,0x2ca0004b,0x2a78004b,0x00000000}},	//   lnız_, isid_, _kurb_,
  { {0x2d8006ce,0xf7460002,0xe7370062,0x00000000}},	//   kcie_, _тежо, _кеф_,
  { {0x2ca00004,0x2bc60161,0xe4e60086,0x00000000}},	//   ksid_, र्ता, _вікн,
  { {0x60100137,0x25a61ae7,0xdce40023,0x00000000}},	//   _täml, _idol_, gaiļ,
  { {0x2d800051,0x2ca00019,0x629c00ea,0x00000000}},	//   ecie_, dsid_, áros,
  { {0xf09f1ae8,0x6448168b,0x244b06a5,0x00000000}},	//   ssà_, modi, rømt_,
  { {0xef190051,0x13170063,0x442c1ae9,0x00000000}},	//   ąż_, _כחול_, lid_,
  { {0x442c0122,0x64480213,0x60cd1aea,0x00000000}},	// [2710] oid_, oodi, _upam,
  { {0x64481aeb,0x442c1aec,0x7e64004b,0x00000000}},	//   nodi, nid_, amip,
  { {0x2bc60161,0x68e9065f,0x2a7800e5,0x00000000}},	//   र्धा, _sred, _curb_,
  { {0x68e91aed,0x442c1aee,0x2d801aef,0x00000000}},	//   _pred, hid_, ccie_,
  { {0x89a80086,0xb9c40021,0x64481af0,0x00000000}},	//   рків_, تقني, kodi,
  { {0x6e2d0034,0x68e91af1,0x442c1496,0x00000000}},	//   liab, _vred, jid_,
  { {0x442c1af2,0x2a780025,0x5692005e,0x00000000}},	//   did_, _gurb_, пајт,
  { {0x68e91781,0xdb160139,0x0f380063,0x00000000}},	//   _tred, _ócái, ירוט_,
  { {0x2d99051e,0x68e9065f,0x44270089,0x00000000}},	//   _mese_, _ured, _pmn_,
  { {0x2d99076c,0x33f50940,0x442c1af3,0x00000000}},	//   _lese_, счис, gid_,
  { {0x249f007a,0x8c1a0063,0x2d800051,0x00000000}},	//   ssum_, רותי, ycie_,
  { {0xc879005b,0x442c1af4,0x63c3008f,0x00000000}},	//   _kuş_, aid_, _žunā,
  { {0x442c1af5,0xddc6007d,0x6e2d1af6,0x00000000}},	//   bid_, _nikš, diab,
  { {0x64480641,0x7d0d1af7,0x442c1af8,0x00000000}},	//   codi, dyas, cid_,
  { {0x6e2d04bc,0x2d9900a4,0xddc60078,0x00000000}},	//   fiab, _bese_, _aikš,
  { {0xdb17017d,0x2d99006d,0x2ca00019,0x00000000}},	//   nexõ, _cese_, tsid_,
  { {0x6e360006,0x61eb0025,0x7fd60454,0x00000000}},	// [2720] rnyb, _ógla, _ліні,
  { {0x2ca00019,0xb05b10f0,0xe0fb0063,0x00000000}},	//   rsid_, ltän, _עליל,
  { {0x2ca00019,0xd24f007e,0x329a0041,0x00000000}},	//   ssid_, _زنی_, ָבנד,
  { {0x753d0051,0x2d9900ac,0x6e2d1af9,0x00000000}},	//   ższy, _gese_, ciab,
  { {0x91bb0063,0xdb1e00ea,0x6448005b,0x00000000}},	//   רמני, lepü, yodi,
  { {0xf0930063,0x442c1afa,0x98a70058,0x00000000}},	//   לנד_, xid_, şiği_,
  { {0x644806b9,0x07a30d34,0x09e60263,0x00000000}},	//   vodi, чајн, _ловн,
  { {0x442c1afb,0xf1bf00ea,0xd5ba1afc,0x00000000}},	//   wid_, riák_, уск_,
  { {0x38cb006a,0x442c1afd,0x64481afe,0x00000000}},	//   _مالی_, tid_, todi,
  { {0x3e4100eb,0x661b1aff,0x442c1b00,0x00000000}},	//   mėte_, ahuk, uid_,
  { {0x95ca019d,0x442c1b01,0x64481b02,0x00000000}},	//   _була_, rid_, rodi,
  { {0x442c0004,0x661b0009,0x64481b03,0x00000000}},	//   sid_, chuk, sodi,
  { {0x2d990290,0x248600c7,0x6b9e00a4,0x00000000}},	//   _rese_, _utom_, kapg,
  { {0x20050026,0x46dc0042,0x7d0d0072,0x00000000}},	//   ðli_, _मनाह, vyas,
  { {0x2d9902dd,0x53331b04,0xb425002a,0x00000000}},	//   _pese_, _нешт, _بعنو,
  { {0x3e410006,0x7e550086,0xddc6008f,0x00000000}},	//   kėte_, іває, _pikš,
  { {0x7c970021,0x5c740002,0x6e2d0897,0x00000000}},	// [2730] إشرا, злут, riab,
  { {0x3e410006,0x78a21244,0x2d9900ac,0x00000000}},	//   dėte_, dsov, _wese_,
  { {0x7d0d01f7,0xe37b0047,0x2d991b05,0x00000000}},	//   syas, ארבר, _tese_,
  { {0xb9550612,0x7d0d005b,0x9cf50085,0x00000000}},	//   овещ, pyas, _дзмі,
  { {0x6e3d006f,0x3e410078,0xb23c0047,0x00000000}},	//   _ijsb, gėte_, נעדז,
  { {0x6d5d001c,0x18691b06,0xba77009e,0x00000000}},	//   _izsa, шали_, _هارت,
  { {0xb05b024a,0x36190121,0x6fac0042,0x00000000}},	//   ytän, ицию_, _जयसू,
  { {0xc48512ad,0x34a90001,0x7bd7003b,0x00000000}},	//   олик, авио_, lexu,
  { {0x26de1b07,0x2bc60161,0xe6160086,0x00000000}},	//   _esto_, र्वा, ідь_,
  { {0x661b0035,0x799b00ac,0x78a600b9,0x00000000}},	//   shuk, _heuw, _ækva,
  { {0xb05b024a,0xd7f8008b,0xe2990d34,0x00000000}},	//   ttän, _khăn_, јам_,
  { {0xcf890ee1,0x04c90021,0x90c61b08,0x00000000}},	//   _יט_, _نوصي_, обме,
  { {0x290f0078,0x89da0063,0xb05b1b09,0x00000000}},	//   nyga_, בחרי, rtän,
  { {0xb05b1b0a,0x799b0150,0x0467005e,0x00000000}},	//   stän, _leuw, _утем,
  { {0x7bd71b0b,0x79820022,0xdee3012d,0x00000000}},	//   dexu, ycow, мори,
  { {0xe1ff006d,0xd5f90047,0x224b1b0c,0x00000000}},	//   lmón_, ספּר, cock_,
  { {0xad66006a,0xce470085,0x8f760083,0x00000000}},	// [2740] زاره, ізуе_, _муні,
  { {0x61e61b0d,0xb05b0d90,0x3e410078,0x00000000}},	//   ldkl, ntäl, vėte_,
  { {0x61e400bb,0xfe460854,0x20c40072,0x00000000}},	//   _kail, _мноо, löi_,
  { {0x61e60162,0x3e410006,0xdcfd0006,0x00000000}},	//   ndkl, tėte_, _nesė,
  { {0xc7ba0088,0x8d660086,0x63ba00b9,0x00000000}},	//   аёй_, _євге, ygtn,
  { {0xacd900b5,0x799b0122,0x2cb20185,0x00000000}},	//   _פֿרי, _eeuw, mryd_,
  { {0xa01b00fe,0xa7140054,0x78a21b0e,0x00000000}},	//   mpöt, ямкі, ssov,
  { {0x78ad0117,0x6b9c1b0f,0x61e41b10,0x00000000}},	//   šava, _herg, _nail,
  { {0x6b9c0019,0x7aee00c2,0x80da0042,0x00000000}},	//   _kerg, _hrbt, _पैले,
  { {0x61f6001f,0xdb1c017d,0x2fd801e1,0x00000000}},	//   _anyl, _acré, jerg_,
  { {0xb4e30161,0x61e41b11,0x6b9c09ee,0x00000000}},	//   कटॉप_, _bail, _merg,
  { {0x201a07de,0x61e414bd,0xe1ff0331,0x00000000}},	//   _alpi_, _cail, amón_,
  { {0x660f0d88,0x61e41b12,0x2d921b13,0x00000000}},	//   öcke, _dail, dbye_,
  { {0x3eb81b14,0x6b9c1b15,0x2cb2002b,0x00000000}},	//   furt_, _nerg, dryd_,
  { {0x9e070086,0x61e41b16,0xdd9b0f55,0x00000000}},	//   очал, _fail, иша_,
  { {0x2cb2001f,0x3ead0114,0x61e41b17,0x00000000}},	//   fryd_, čet_, _gail,
  { {0xc05b019d,0x6b9c1b18,0xb05b00fe,0x00000000}},	// [2750] _він_, _berg, ltäm,
  { {0x3eb800bd,0x6b9c1b19,0x61e40089,0x00000000}},	//   burt_, _cerg, _zail,
  { {0xb05b00fe,0x23c20053,0x3ce9004b,0x00000000}},	//   ntäm, _शानद, svav_,
  { {0x6b9c006f,0x2cb21b1a,0x290f0137,0x00000000}},	//   _eerg, bryd_, tyga_,
  { {0xd9450002,0x7aee004d,0x6d5d0023,0x00000000}},	//   џели, _erbt, _uzsa,
  { {0x3abb006a,0x6b9c1b1b,0xa69500e1,0x00000000}},	//   _پاسخ_, _gerg, приј,
  { {0x19951a02,0x4e0f0042,0x99d7009b,0x00000000}},	//   _навя, _सवाई_, _وترا,
  { {0xd6ce0032,0xc6680001,0x6b85001f,0x00000000}},	//   اقي_, ошње_, lchg,
  { {0x6d4300bd,0x27f60080,0x61e41b1c,0x00000000}},	//   ßnah, ádní_, _rail,
  { {0x94220076,0x69d91b1d,0x61e40399,0x00000000}},	//   емье, lewe, _sail,
  { {0xef200051,0x6b8500bd,0x69d9006f,0x00000000}},	//   ążki_, ichg, oewe,
  { {0xb05b01e3,0x60100137,0x614606b4,0x00000000}},	//   stäl, _jämv, зема,
  { {0xf9920063,0x61e41b1e,0x61e600b8,0x00000000}},	//   ערך_, _vail, rdkl,
  { {0xdff5000d,0xb05b00fe,0x20c40072,0x00000000}},	//   мясь, ltäj, röi_,
  { {0x26c702e2,0x63a11b1f,0x69d91b20,0x00000000}},	//   ntno_, maln, kewe,
  { {0x2cb21b21,0x63a11b22,0x625d0003,0x00000000}},	//   tryd_, laln, léon,
  { {0x69d91a33,0xee370086,0x6b9c1b23,0x00000000}},	// [2760] dewe, їну_, _perg,
  { {0xdce6003d,0x26c701b3,0x63a11b24,0x00000000}},	//   _iekļ, ktno_, naln,
  { {0x69cb004d,0x78b9006f,0x6b9c1b25,0x00000000}},	//   ffge, euwv, _verg,
  { {0xe8fa093e,0x69d91b26,0x3209008b,0x00000000}},	//   йле_, gewe, _xoay_,
  { {0x3a3f02eb,0x6b9c003e,0x63a11b27,0x00000000}},	//   _djup_, _terg, kaln,
  { {0xb05b00fe,0xddc40051,0x63a1107f,0x00000000}},	//   ytäm, yliś, jaln,
  { {0x8c1b014e,0x69d91b28,0x7c2e0b83,0x00000000}},	//   _פולי, bewe, _imbr,
  { {0xbb3b01f9,0xd5e2008b,0x44f41b29,0x00000000}},	//   _העלי, _khỏ, дпис,
  { {0x3e410078,0x27170013,0xdce6008f,0x00000000}},	//   nėta_, ãn_, _nekļ,
  { {0xb05b024a,0x22810014,0x63a11b2a,0x00000000}},	//   ttäm, _bók_, galn,
  { {0x31601b2b,0xe1d9019d,0x61d90062,0x00000000}},	//   _aziz_, одні_, омня_,
  { {0x63a10019,0xb05b00fe,0xe71711b4,0x00000000}},	//   aaln, rtäm, _מחבר_,
  { {0xb05b052c,0xd62501a7,0xdb2300ea,0x00000000}},	//   stäm, _تعلي, _örök,
  { {0x3e410006,0x225200ac,0x250b005d,0x00000000}},	//   dėta_, _ekyk_, _درمی_,
  { {0x628a02f0,0xdef8000d,0x7e7e1b2c,0x00000000}},	//   _utfo, пыт_, _cupp,
  { {0x7c2e1b2d,0xc3330063,0x6b85002b,0x00000000}},	//   _ambr, _רוק_, wchg,
  { {0x93bd0047,0xb05b0b6e,0x5d550094,0x00000000}},	// [2770] _אַלף_, ntäk, фкат,
  { {0x9ce4000d,0xf1bf00be,0xdb6b0121,0x00000000}},	//   эцсл, lgá_, брел_,
  { {0x6b8500bd,0xd7f8008b,0x69d905e9,0x00000000}},	//   rchg, _chăm_, tewe,
  { {0x69cb00bd,0xf1bf017d,0x6b85004d,0x00000000}},	//   ufge, ngá_, schg,
  { {0x37e503ec,0x7e7e01f4,0x69d9120e,0x00000000}},	//   долг, _zupp, rewe,
  { {0x69d91b2e,0x9be4071f,0xf8070505,0x00000000}},	//   sewe, _піск, ячен,
  { {0x63a10198,0xb05b024a,0xdb2300fe,0x00000000}},	//   valn, ttäj, ärän,
  { {0x601001e3,0x672300c2,0x26c702f7,0x00000000}},	//   _hämt, rznj, rtno_,
  { {0x63a11b2f,0x26c700c3,0x93fd000d,0x00000000}},	//   taln, stno_, аўнi,
  { {0x60100137,0xb05b00fe,0x7d020072,0x00000000}},	//   _jämt, stäj, äosi,
  { {0x56940138,0x2bcf0053,0x387f0104,0x00000000}},	//   _захт, स्या, _huur_,
  { {0x63a1014f,0x7e7e02e0,0x600b07be,0x00000000}},	//   saln, _rupp, _sümp,
  { {0xa5bd00eb,0x7e7e1b30,0xe44e0454,0x00000000}},	//   siųs, _supp, _аж_,
  { {0x22810026,0x387f0983,0xe46b0121,0x00000000}},	//   _tók_, _muur_, _ушел_,
  { {0x41c60053,0x93450eaf,0x00000000,0x00000000}},	//   _वापस, _юнке,   ,
  { {0x25bf1b31,0xd5e20013,0xdb08004c,0x00000000}},	//   ngul_, _phỏ, ílít,
  { {0xed570079,0xb5fd00c2,0xdca3150f,0x00000000}},	// [2780] дот_, emšk, кати,
  { {0x660b0146,0x8d630076,0x4d630086,0x00000000}},	//   _logk, твуе, ткув,
  { {0x78a902f6,0xb9e60086,0x0e661702,0x00000000}},	//   _avev, діли, _окон,
  { {0xd5e2008b,0xd378007d,0xdb1e0072,0x00000000}},	//   _thỏ, meće_, kepö,
  { {0xd378007d,0xb86a005e,0x02da0042,0x00000000}},	//   leće_, ојке_, _बन्न,
  { {0xd7f8001b,0x387f0173,0x368a0086,0x00000000}},	//   _thăm_, _duur_, осин_,
  { {0x660b01e1,0x7c3e0137,0xd5ba0054,0x00000000}},	//   _bogk, mnpr, осп_,
  { {0x973c017f,0xb05b00fe,0x94aa0002,0x00000000}},	//   _neće, ttäk, отоа_,
  { {0x47c60138,0xe3ce001b,0x387f00ac,0x00000000}},	//   _обав, _dựng_, _guur_,
  { {0x7e660150,0x25bf003b,0x7c3e1b32,0x00000000}},	//   _lhkp, agul_, nnpr,
  { {0x0bb7014e,0xd378017f,0xe2f80086,0x00000000}},	//   ולים_, jeće_, чені_,
  { {0xd3780117,0x00000000,0x00000000,0x00000000}},	//   deće_,   ,   ,
  { {0x442e09fe,0xbcfb00be,0xb05b078c,0x00000000}},	//   _tmf_, _ozéa, ltäi,
  { {0x8ca20053,0x00000000,0x00000000,0x00000000}},	//   गठनो,   ,   ,
  { {0xadd50001,0x443e1233,0x7687005b,0x00000000}},	//   новљ, mnt_, _kıya,
  { {0x645a1b33,0x601000bd,0xf1d0008b,0x00000000}},	//   llti, _sämt, _hạng_,
  { {0x5cb90088,0x645a17c2,0x2d580376,0x00000000}},	// [2790] ялаў_, olti, дить_,
  { {0x443e1b34,0x2bbb0021,0xdb1e004b,0x00000000}},	//   nnt_, تارة_, hepõ,
  { {0xf1d0001b,0x916d008b,0x387f1b35,0x00000000}},	//   _mạng_, _hồi_, _suur_,
  { {0x443e00bd,0x32190186,0xdb1c0025,0x00000000}},	//   hnt_, nksy_, _gcrí,
  { {0x99d40021,0x7e6d1b36,0x1bbb00f2,0x00000000}},	//   ئتما, mmap, _واسع_,
  { {0x443e0122,0xd366006a,0x387f006f,0x00000000}},	//   jnt_, _مه_, _vuur_,
  { {0x7ac41240,0xc8780075,0xb05b004e,0x00000000}},	//   _исте, _diğ_, rtäh,
  { {0x387f00e8,0x645a0026,0xb05b0019,0x00000000}},	//   _tuur_, elti, stäh,
  { {0x2bcf0161,0xa9540086,0x443e0026,0x00000000}},	//   स्था, _акті, fnt_,
  { {0xd378017f,0x73050d34,0x3e410078,0x00000000}},	//   zeće_, епоз, kėto_,
  { {0xf1d0001b,0x25a4002b,0xdb07004c,0x00000000}},	//   _dạng_, baml_, _odjí,
  { {0x2bcf0161,0x7afa00ea,0x2ca9004b,0x00000000}},	//   स्ता, _átte, ksad_,
  { {0xa155011c,0x973c007d,0xddc4005b,0x00000000}},	//   върш, _veće, eliş,
  { {0xdb1c0027,0x66060026,0x201e0026,0x00000000}},	//   _scrí, ökkv, óti_,
  { {0x7d0b0137,0x60100137,0xd378007d,0x00000000}},	//   ägsn, _säms, teće_,
  { {0x64b5005b,0x20180f49,0x42d40054,0x00000000}},	//   _eğiş, skri_, _рішу,
  { {0x1016000d,0xd378007d,0xfe431b37,0x00000000}},	// [27a0] _зьня, reće_, унто,
  { {0xaf9a0055,0x24820024,0xf5360047,0x00000000}},	//   _этих_, íkmi_, ײטער_,
  { {0x3f981b38,0x7e6d153a,0xb4160047,0x00000000}},	//   mbru_, bmap, עקעס_,
  { {0xda650021,0xe9e50086,0x0f370047,0x00000000}},	//   ناني, кціо, _טריט_,
  { {0x443e1b33,0x629c013d,0xc237009a,0x00000000}},	//   ynt_, ároz, ערנו_,
  { {0xb05b024a,0xf6e60699,0x6e24013d,0x00000000}},	//   ttäi, ецин, lhib,
  { {0x8c430928,0x443e02ab,0x7bde0035,0x00000000}},	//   _сере, vnt_, mepu,
  { {0x443e1b39,0xa7370021,0xa3d20053,0x00000000}},	//   wnt_, عثور_, ह्न_,
  { {0x6846000a,0xdb1c017d,0xb05b078c,0x00000000}},	//   _знаа, _ucrâ, stäi,
  { {0xb05b024a,0xe8d70063,0x7bde1b3a,0x00000000}},	//   ltäv, _אומר_, nepu,
  { {0x68e2002b,0x443e1b3b,0xa1950895,0x00000000}},	//   lwod, rnt_, канч,
  { {0x765b048e,0xb05b00fe,0x7bde004d,0x00000000}},	//   cluy, ntäv, hepu,
  { {0xf1d0008b,0x6e240035,0x66060014,0x00000000}},	//   _tạng_, dhib, ökku,
  { {0xb05b024a,0x60100137,0x251b0047,0x00000000}},	//   htäv, _sämr, _צוגא,
  { {0x7bde1b3c,0x916d0013,0x6e670062,0x00000000}},	//   depu, _dối_, етаж,
  { {0x7e6d00a4,0x916d0013,0x2ca9065e,0x00000000}},	//   umap, _tồi_, tsad_,
  { {0xd90404de,0x7e6d1b3d,0xdb1c0051,0x00000000}},	// [27b0] _ای_, rmap, _obró,
  { {0x6e24005b,0x7e6d0d14,0x7bde1b3e,0x00000000}},	//   ahib, smap, gepu,
  { {0x2ca900c7,0x76400014,0x69c2006f,0x00000000}},	//   ssad_, knmy, fgoe,
  { {0xddc4003b,0x5a350062,0x6e241b3f,0x00000000}},	//   rmiţ, ънет, chib,
  { {0x60100832,0xadf40085,0x26040042,0x00000000}},	//   _kämp, _спяш, वानी_,
  { {0x7bde0529,0xec350047,0x764000fe,0x00000000}},	//   cepu, _יאָר_, enmy,
  { {0x765b0058,0x68e20022,0x78bc0023,0x00000000}},	//   tluy, awod, _ārve,
  { {0x601004e1,0x6447074f,0xc8f50062,0x00000000}},	//   _lämp, čjim, _избъ,
  { {0x200c00ea,0xe1ff0051,0x765b1b40,0x00000000}},	//   ödik_, lmów_, rluy,
  { {0xa934000a,0x765b0014,0x2496005d,0x00000000}},	//   _сеуш, sluy, کنید_,
  { {0x916d0013,0x765b0058,0x23291b41,0x00000000}},	//   _rối_, pluy, фони_,
  { {0x7aea00b9,0x7bde0022,0x65951b42,0x00000000}},	//   æfti, zepu, _раду,
  { {0xc2431b43,0xbcfb013d,0x00000000,0x00000000}},	//   рняк, _szén,   ,
  { {0xc0e30856,0x7d160072,0x66091b44,0x00000000}},	//   јорк, vyys, ljek,
  { {0xb05b00fe,0xada60086,0x6e240441,0x00000000}},	//   ytäv, кавл, thib,
  { {0x68e20185,0x7bd500bd,0x66091b45,0x00000000}},	//   ywod, _abzu, njek,
  { {0x60260088,0x64410102,0x916d001b,0x00000000}},	// [27c0] _адпа, onli, _tối_,
  { {0x64411b46,0x6e241b47,0x63a31a28,0x00000000}},	//   nnli, shib, _jenn,
  { {0xb05b024a,0x63a304b1,0x7d1600fe,0x00000000}},	//   ttäv, _menn, syys,
  { {0x644100bd,0x3a200025,0x63a31b48,0x00000000}},	//   hnli, óip_, _lenn,
  { {0x7d0b1b49,0xe3a7007e,0x62831b4a,0x00000000}},	//   øgst, _پر_, _luno,
  { {0x64410122,0x63a300bd,0xb05b0bb7,0x00000000}},	//   jnli, _nenn, stäv,
  { {0x29000529,0x45d4000d,0x6f08004d,0x00000000}},	//   ţia_, гойс, ädch,
  { {0x661b002c,0xd378017f,0x64411b4b,0x00000000}},	//   gkuk, jeća_, enli,
  { {0x916d001b,0xd378017f,0x6aa104aa,0x00000000}},	//   _mỗi_, deća_, _ælfr,
  { {0x916d001b,0x661b1b4c,0x29550062,0x00000000}},	//   _lỗi_, akuk, _съср,
  { {0x62830529,0x60100019,0xddc4027c,0x00000000}},	//   _cuno, _rämp, zmiš,
  { {0x4425004d,0x27ec00e5,0x62831b4d,0x00000000}},	//   ahl_, _hadn_, _duno,
  { {0xc05b019d,0xb6350047,0x63a31b4e,0x00000000}},	//   дів_, _גרײס_, _fenn,
  { {0x63a31b4f,0xdfd80062,0x44251b50,0x00000000}},	//   _genn, къс_, chl_,
  { {0x6458001c,0x6283003b,0x9f411b51,0x00000000}},	//   _ikvi, _guno, _bahá_,
  { {0x3377014e,0xf3650086,0x78ad0ef0,0x00000000}},	//   _בתוך_, _стін, šavi,
  { {0xde580086,0x39490051,0x61ed00a4,0x00000000}},	// [27d0] таті_, żasz_, _iaal,
  { {0x61ed1b52,0xddc4007d,0xb05b004d,0x00000000}},	//   _haal, rmiš, ttäu,
  { {0x63a80024,0x61ed1b53,0xfe6e007e,0x00000000}},	//   iadn, _kaal, تگی_,
  { {0xc3330063,0xb05b004d,0x7d0b01e1,0x00000000}},	//   סוף_, rtäu, øgss,
  { {0x39490016,0x6609017f,0xa9540086,0x00000000}},	//   ças_, vjek, акці,
  { {0xab94019d,0x973c017f,0xd378017f,0x00000000}},	//   _вирі, _seća, zeća_,
  { {0x644102ab,0xb05b00fe,0x63a31b54,0x00000000}},	//   vnli, ltäs, _renn,
  { {0x3a260122,0x7ada0047,0xff7c0063,0x00000000}},	//   chop_, _אַמה, וטומ,
  { {0x661b1b55,0xb05b00fe,0x66090019,0x00000000}},	//   rkuk, ntäs, rjek,
  { {0xe3b10032,0x66091b56,0x661b024a,0x00000000}},	//   حرة_, sjek, skuk,
  { {0xc5d5019d,0x63a30398,0xbcfb00ea,0x00000000}},	//   _біль, _venn, _szél,
  { {0x26040053,0x7e7d0745,0x63a31b57,0x00000000}},	//   वाणी_, _nisp, _wenn,
  { {0xf484000a,0x61ed04a1,0xb05b0072,0x00000000}},	//   _кујн, _daal, ytät,
  { {0x628300a4,0x7e7d0025,0xb05b00a5,0x00000000}},	//   _tuno, _aisp, xtät,
  { {0xb05b1b58,0x61ed005b,0xa0671321,0x00000000}},	//   kräf, _faal, уара_,
  { {0xa3ab0235,0xd5e2001b,0xc69211b4,0x00000000}},	//   गणक_, _khó, מאל_,
  { {0x4d660785,0x8b960121,0xb05b0ede,0x00000000}},	// [27e0] укав, греч, ttät,
  { {0x69c9000c,0xab2a06b4,0x309b0a7a,0x00000000}},	//   _acee, ноза_, _רשימ,
  { {0x68e91b59,0xdd12008f,0x0af6000d,0x00000000}},	//   _ased, _kļūt, ычаў,
  { {0x63a800c3,0xb05b0ae2,0x1d0a06be,0x00000000}},	//   zadn, stät, _земи_,
  { {0xd5e2001b,0x522d0041,0xa9670131,0x00000000}},	//   _nhó, וואַ, гица_,
  { {0xdd3b00b5,0x3a261b5a,0xcaa60021,0x00000000}},	//   _װעלכ, shop_, _مصري,
  { {0x63a8018a,0xd5e2008b,0x3a261b5b,0x00000000}},	//   vadn, _phò, phop_,
  { {0xe4e6019d,0xa2810051,0xd49a0b69,0x00000000}},	//   гіон, łość_, нро_,
  { {0x39460001,0xd5e2008b,0xe1ff0139,0x00000000}},	//   _снаг, _chó, llóg_,
  { {0xc94b0063,0x656f004c,0x61ed1b5c,0x00000000}},	//   _אֲבֹ, ýcha, _saal,
  { {0x61ed002c,0xb05b00c7,0x26040053,0x00000000}},	//   _paal, ktär, वादी_,
  { {0x63a81959,0xa227014d,0xa1750054,0x00000000}},	//   sadn, ارده, игні,
  { {0x7e7d02f6,0x61ed0736,0x63a8081a,0x00000000}},	//   _risp, _vaal, padn,
  { {0x3e4100eb,0xf1bf0025,0x25a6001f,0x00000000}},	//   mėti_, chán_, _heol_,
  { {0x61ed04c6,0xb05b00bd,0x3e410006,0x00000000}},	//   _taal, hräg, lėti_,
  { {0xb05b0072,0x387e1b5d,0x3d950456,0x00000000}},	//   ttäs, _litr_, риар,
  { {0x7e7d003d,0x3e410006,0x527c0047,0x00000000}},	// [27f0] _visp, nėti_, _אנהא,
  { {0xb05b00c7,0x25a6001f,0x6d5d01c8,0x00000000}},	//   dräg, _leol_, _vysa,
  { {0xb05b04e1,0x7e7d04aa,0x78bc008f,0x00000000}},	//   träf, _tisp, _ārva,
  { {0x3e4100eb,0x636f00ea,0x973c007d,0x00000000}},	//   kėti_, lóné, _pećn,
  { {0x9df80121,0x28f80083,0x6d5d0075,0x00000000}},	//   _снят_, лець_, _uysa,
  { {0x3e4100eb,0x25a900c3,0x76b50001,0x00000000}},	//   dėti_, _žal_, аљиц,
  { {0xb05b004d,0x7ceb0137,0xe6110044,0x00000000}},	//   präf, _förå, قشة_,
  { {0x25a60025,0xd5e20013,0x2486002b,0x00000000}},	//   _ceol_, _phó, _buom_,
  { {0xf1bf0027,0xa5f6005e,0x25a600f1,0x00000000}},	//   thán_, рењу_, _deol_,
  { {0x2249017e,0x44230022,0xb05b0244,0x00000000}},	//   _ajak_, ój_, nräd,
  { {0x63bc007a,0xe784007e,0x316900ea,0x00000000}},	//   órna, _المپ, _azaz_,
  { {0x3e4100eb,0xa4d50086,0xd5751b5e,0x00000000}},	//   bėti_, _воді, _куль,
  { {0xb05b00a5,0xc1e7005d,0x64a51b5f,0x00000000}},	//   kräd, شکيل_, _тала,
  { {0xa06a0088,0xfaf8001c,0xe3b90054,0x00000000}},	//   тага_, _šīm_, _рбк_,
  { {0x43750047,0xb05b0072,0x6e360062,0x00000000}},	//   _דײַן_, ttär, ахах,
  { {0x644f0164,0x6e030044,0x425300de,0x00000000}},	//   écif, يِّن, _ونور,

  { {0x6fd60086,0xc0e60189,0x62730021,0x00000000}},	// [2800] _кінц, _топк, _بهيئ,
  { {0xd00f0021,0xb05b1b60,0xef1a01ce,0x00000000}},	//   _يلي_, stär, _амо_,
  { {0x394d1b61,0x79a6013f,0x5fbb009a,0x00000000}},	//   _axes_, арле, _בצינ,
  { {0xb05b00bd,0x2a6d004c,0x79850044,0x00000000}},	//   träg, _cheb_, مؤهل,
  { {0xda650021,0xd7940062,0x26040042,0x00000000}},	//   حالي, билъ, वासी_,
  { {0x25a60027,0xb05b0072,0x68431702,0x00000000}},	//   _seol_, ntäp, онча,
  { {0x973c007d,0x6f1c001f,0x24860072,0x00000000}},	//   _većo, nyrc, _suom_,
  { {0xb05b0c38,0x6b630086,0x998b00dd,0x00000000}},	//   präg, _єкта, ălţa_,
  { {0x87da007e,0x6f1c001f,0x7bc30014,0x00000000}},	//   _لباس_, hyrc, ónug,
  { {0x3e4100eb,0x7d0b0137,0xbcfb1b62,0x00000000}},	//   rėti_, ägsi, _szék,
  { {0x3e410078,0x23380895,0x6352004c,0x00000000}},	//   sėti_, упны_, děné,
  { {0xd2580086,0xd377000d,0x3e410006,0x00000000}},	//   иця_, шчы_, pėti_,
  { {0x04940032,0x6abe004d,0x66021b63,0x00000000}},	//   _التح, hrpf, _inok,
  { {0xd3a30062,0x443a0137,0x34fb0063,0x00000000}},	//   _дръп, _öp_, _שהגד,
  { {0x6f1c0185,0xfda70001,0x6367005a,0x00000000}},	//   gyrc, ијам, _кръг_,
  { {0x629a1b64,0x30a70133,0xdd981b65,0x00000000}},	//   mpto, _кров, ишу_,
  { {0xb05b00c7,0xcec40080,0x786d017d,0x00000000}},	// [2810] träd, teří_, lúve,
  { {0x2bb80021,0x515c009a,0xbca40044,0x00000000}},	//   لامة_, _בכחו, تمكي,
  { {0x660200ac,0xb05b0ae2,0x5fdc089e,0x00000000}},	//   _onok, rräd, _יחזק,
  { {0xdb1e0014,0x629a1b66,0x497501e4,0x00000000}},	//   efpó, ipto, блес,
  { {0x8cf4000d,0x26de0e7c,0xd8e70416,0x00000000}},	//   _дзяц, _apto_, рцеп,
  { {0x1d160063,0x3eb10051,0xb05b0244,0x00000000}},	//   _הקשר_, oszt_, bräe,
  { {0x2a7f0089,0x6dbb0022,0x68420085,0x00000000}},	//   _tiub_, ałał, янша,
  { {0x656f0114,0x3dc908f2,0xee320063,0x00000000}},	//   ýcho, ngaw_, ּֽה_,
  { {0xe4590189,0x00000000,0x00000000,0x00000000}},	//   лжи_,   ,   ,
  { {0x9f4c108f,0x981401fb,0x844400de,0x00000000}},	//   ždé_, _وبلا, ْخَل,
  { {0xe719007e,0x68fb0061,0x3e41005f,0x00000000}},	//   _حيات_, _hrud, lėtu_,
  { {0x3f910022,0xcf89016e,0xd1ba0044,0x00000000}},	//   eczu_, _טט_, دادا_,
  { {0x8505006a,0x291d02ae,0x6f1c001f,0x00000000}},	//   _دوشن, nywa_, wyrc,
  { {0xe3b8005b,0x33950021,0x644f006c,0x00000000}},	//   lkın_, _الغز, écid,
  { {0xd7f1001b,0xe3b0005d,0x66f70042,0x00000000}},	//   _mã_, _آره_, ंटिक_,
  { {0xb05b004d,0x68fb1b67,0x3e41005f,0x00000000}},	//   gräb, _orud, kėtu_,
  { {0x61e61b68,0xac831b43,0x00000000,0x00000000}},	// [2820] mekl, згул,   ,
  { {0x442700f3,0x69db006d,0x3b0a0ada,0x00000000}},	//   _jln_, _abue, лезо_,
  { {0xfc3f0994,0x998d00c2,0x61e600ca,0x00000000}},	//   _avís_, _smeš_, oekl,
  { {0x61e601f7,0xb346017d,0x38c8007e,0x00000000}},	//   nekl, leçõ, لاتی_,
  { {0x25ad0185,0x656f0024,0x68fb1b69,0x00000000}},	//   dael_, ýchl, _crud,
  { {0x7e641b6a,0x5fdb0042,0x68fb0d70,0x00000000}},	//   llip, म्पल, _drud,
  { {0xddcd005b,0x7bdc1b6b,0xf99f0002,0x00000000}},	//   nlaş, _ibru, _нè_,
  { {0x61e6017f,0x7afc004d,0x291d0051,0x00000000}},	//   jekl, _irrt, bywa_,
  { {0xa9260055,0x998f0006,0x7e641b6c,0x00000000}},	//   _удал, angų_, ilip,
  { {0xddcd01f7,0xb346017d,0x7c3e1b6d,0x00000000}},	//   klaş, jeçõ, nipr,
  { {0x5c5b00b5,0x2bf70063,0x7bdc0139,0x00000000}},	//   רדיק, זמין_, _mbru,
  { {0xad9b13a8,0xc0cb0138,0xcb130063,0x00000000}},	//   _anún, луге_, ללת_,
  { {0x661d00fe,0x7bdc1b6e,0x7c3e1b6f,0x00000000}},	//   öske, _obru, kipr,
  { {0x7e641b70,0xd7f10013,0xddcd0058,0x00000000}},	//   elip, _xã_, flaş,
  { {0x643b0047,0x644f0ec6,0x443e1b71,0x00000000}},	//   _געגנ, écie, mit_,
  { {0x7e64002c,0x61e601f7,0x6298006f,0x00000000}},	//   glip, cekl, _itvo,
  { {0x442c00e3,0x9c39000a,0x42380063,0x00000000}},	// [2830] ohd_, апат_, _לנהל_,
  { {0xb346017d,0xf3f1008b,0x443e1b72,0x00000000}},	//   ceçõ, họn_, nit_,
  { {0x207c0047,0x443e004b,0x9b6b0002,0x00000000}},	//   _גאזא, iit_, ушаа_,
  { {0x443e18ab,0x7bdc0162,0x1df90076,0x00000000}},	//   hit_, _ebru, _темы_,
  { {0x443e03f9,0x89a80054,0x645a1b73,0x00000000}},	//   kit_, сків_, koti,
  { {0xa69502a9,0x629804c9,0x63aa0026,0x00000000}},	//   ориј, _otvo, _nefn,
  { {0xa3be0053,0x645a1b74,0x443e1b75,0x00000000}},	//   ेलन_, doti, dit_,
  { {0x68fb1588,0xe6191b76,0xfc3f0025,0x00000000}},	//   _trud, рди_, _tvís_,
  { {0x442700f3,0x68fb0035,0x64480ea7,0x00000000}},	//   _pln_, _urud, fndi,
  { {0x63aa0185,0xddcd01f7,0x443e1b77,0x00000000}},	//   _cefn, ylaş, git_,
  { {0x63aa0185,0xdb1c0025,0x33650021,0x00000000}},	//   _defn, _scrú, تهدف,
  { {0x64480d74,0x443e1096,0x69cb1b78,0x00000000}},	//   andi, ait_, ngge,
  { {0xe3ae1b79,0x625d0003,0x61e61b7a,0x00000000}},	//   _об_, téor, rekl,
  { {0x63aa1b33,0xddcd0058,0x443e1b7b,0x00000000}},	//   _gefn, tlaş, cit_,
  { {0xb346017d,0x26c71b7c,0xdb07013d,0x00000000}},	//   reçõ, nuno_, _fejé,
  { {0x22b5003d,0x6e2d0a9f,0xb05b0832,0x00000000}},	//   māk_, ghab, träc,
  { {0xd7c9016a,0x22b5003d,0x22a700ea,0x00000000}},	// [2840] _रांच, lāk_, lők_,
  { {0x27e70031,0x6e2d00a4,0x7e641b7d,0x00000000}},	//   jenn_, ahab, slip,
  { {0xd24f007e,0x69d9004d,0x7c3e1b7e,0x00000000}},	//   _سنی_, ffwe, ripr,
  { {0xddcd0529,0x7c3e00eb,0x443e1b7f,0x00000000}},	//   rmaţ, sipr, zit_,
  { {0x3ead0117,0x64481b80,0x7d0b0832,0x00000000}},	//   ćete_, yndi, ägst,
  { {0x26c70011,0x7649005b,0x443e1b81,0x00000000}},	//   funo_, eney, xit_,
  { {0x26c702dd,0xdcf6005b,0x443e1b82,0x00000000}},	//   guno_, mayı, vit_,
  { {0xdcf601f7,0x443e0e5b,0xba9b0047,0x00000000}},	//   layı, wit_, _כסלי,
  { {0xa5070001,0xb80a007e,0x62981b83,0x00000000}},	//   жења_, _پيام_, _stvo,
  { {0x186a011c,0x68ed1b84,0x64481b85,0x00000000}},	//   _тази_, çade, undi,
  { {0x63aa0026,0x26c71059,0x1bfb0047,0x00000000}},	//   _vefn, cuno_, בליב,
  { {0xd378007d,0x443e00d8,0x645a1b86,0x00000000}},	//   neći_, sit_, soti,
  { {0xda7b014e,0x443e1b87,0x645a1b88,0x00000000}},	//   ינטר, pit_, poti,
  { {0x764000eb,0x22b5001c,0xc05b0086,0x00000000}},	//   limy, bāk_, рім_,
  { {0x539b0063,0x69cb060b,0x2a6600a4,0x00000000}},	//   _דיוו, ygge, klob_,
  { {0xd378017f,0x8d6b0002,0x76400ddd,0x00000000}},	//   jeći_, ајза_, nimy,
  { {0xd3780117,0x6e2d1b89,0x8d77014d,0x00000000}},	// [2850] deći_, rhab, زارا,
  { {0xad9b017d,0x1c050053,0x26c7006d,0x00000000}},	//   _inúm, राइल_, yuno_,
  { {0x27e700d1,0x6e2d0238,0x76401b8a,0x00000000}},	//   venn_, phab, kimy,
  { {0x26c705b3,0x7d0b0137,0x69d9004d,0x00000000}},	//   vuno_, ägss, ufwe,
  { {0x22b5001c,0x22a700ea,0x69d9001f,0x00000000}},	//   zāk_, zők_, rfwe,
  { {0x26c7001f,0xf80705f7,0xa7fc0075,0x00000000}},	//   tuno_, ючен, _akıb,
  { {0xdce6001c,0xd378007d,0x27e70e46,0x00000000}},	//   _izkā, beći_, renn_,
  { {0x68f00072,0x06091b8b,0x22b5008f,0x00000000}},	//   ähdä, сник_, vāk_,
  { {0x26c70290,0xe4d60021,0x764908d2,0x00000000}},	//   suno_, كويت_, rney,
  { {0x22a7000f,0x22b5001c,0x87070021,0x00000000}},	//   tők_, tāk_, _وبال,
  { {0x2bdd0053,0x786d0066,0xa2c00042,0x00000000}},	//   न्या, cúva, _विण्,
  { {0x22b5003d,0x26f90161,0x2c6d027d,0x00000000}},	//   rāk_, ्मीर_, _vždy_,
  { {0x22b5008f,0x22a7013d,0xdcf60058,0x00000000}},	//   sāk_, sők_, yayı,
  { {0xd848008b,0xd378007d,0xb4fa0063,0x00000000}},	//   họn_, zeći_, _לפני,
  { {0x644114f1,0x0e6a0021,0x973c007d,0x00000000}},	//   mili, مصري_, _peći,
  { {0xe1ff1b8c,0xb2ba0063,0xa2c00053,0x00000000}},	//   llón_, _המקר, _वित्,
  { {0x973c0117,0xd378007d,0x224200d1,0x00000000}},	// [2860] _veći, veći_, mikk_,
  { {0x22420031,0x6e241b8d,0x3c630002,0x00000000}},	//   likk_, skib, екуг,
  { {0xdcf601f7,0xd378017f,0x6297006d,0x00000000}},	//   rayı, teći_, _éxod,
  { {0x64411b8e,0x224200d1,0xf2960047,0x00000000}},	//   hili, nikk_, לכער_,
  { {0xd378017f,0x64411b8f,0x201a1b90,0x00000000}},	//   reći_, kili, _kopi_,
  { {0xb05b00bd,0xd378017f,0x644105b3,0x00000000}},	//   hrän, seći_, jili,
  { {0x64411b91,0xe9a60086,0xb05b0354,0x00000000}},	//   dili, _навп, krän,
  { {0xa3d90053,0x4425004c,0x64411b92,0x00000000}},	//   ड्स_, ekl_, eili,
  { {0xdced0024,0x786d0024,0xb05b004d,0x00000000}},	//   zbaľ, súva, drän,
  { {0xa2c00053,0x674700ea,0x988b0063,0x00000000}},	//   _विद्, árjá, _הָאֵ,
  { {0x644f03b2,0x22420031,0x78a9006f,0x00000000}},	//   écia, fikk_, _zwev,
  { {0xb05b01e3,0x7ae100bd,0x224200d1,0x00000000}},	//   grän, _älte, gikk_,
  { {0x682f1b49,0xe1ff1b93,0x64411b94,0x00000000}},	//   _fødd, blón_, bili,
  { {0x201a001f,0xe1ff006d,0x104b0121,0x00000000}},	//   _copi_, clón_, сями_,
  { {0x33db0063,0x629c0114,0x64b50058,0x00000000}},	//   _החוד, írod, _eşiğ,
  { {0x61f600e5,0x2242013d,0x00000000,0x00000000}},	//   _gayl, cikk_,   ,
  { {0x91bc014e,0xbcfb00ea,0xc1bc0063,0x00000000}},	// [2870] _המחי, _azér, _המחש,
  { {0x201a001f,0x9f43004c,0xa3be0042,0x00000000}},	//   _gopi_, lejí_, ेलि_,
  { {0x682f02ab,0x99890080,0x61f60058,0x00000000}},	//   _jøde, íkům_, _yayl,
  { {0x3a26002c,0x682f0146,0xb17b00a5,0x00000000}},	//   gkop_, _møde, gfåg,
  { {0xbcfb000f,0xca240121,0xd378007d,0x00000000}},	//   _ezér, эффи, meću_,
  { {0x64410764,0xd3780130,0xccf2009a,0x00000000}},	//   xili, leću_, _שכם_,
  { {0x3209005b,0x682f05b9,0x3a2600ca,0x00000000}},	//   _onay_, _rødd, bkop_,
  { {0x64410c70,0xdb070080,0x19590121,0x00000000}},	//   wili, _její, _дабы_,
  { {0x28080080,0xdb07006d,0x7bca0331,0x00000000}},	//   átní_, _mejí, ófug,
  { {0xe7b5006a,0xd8740044,0xc3250094,0x00000000}},	//   _آماد, _كالب, дмок,
  { {0x22420031,0x61f601f7,0x28080080,0x00000000}},	//   tikk_, _payl, štní_,
  { {0xd378017f,0x923a0086,0xdb0e017d,0x00000000}},	//   jeću_, ічну_, _bebê,
  { {0x22420031,0xd378017f,0x644118b1,0x00000000}},	//   rikk_, deću_, pili,
  { {0x22420031,0x682f05dd,0x3e48003b,0x00000000}},	//   sikk_, _føde, işte_,
  { {0xa0671b95,0xb05b0072,0x61f61b96,0x00000000}},	//   фара_, ntäy, _tayl,
  { {0x9f43004c,0x02060121,0x7bc30046,0x00000000}},	//   cejí_, _цзин, ónun,
  { {0xdb0e00e8,0xdb070066,0x201a1b97,0x00000000}},	// [2880] _gebê, _dejí, _topi_,
  { {0x682d0022,0xdb05004b,0x3a2d1b98,0x00000000}},	//   aźdz, kahä, _alep_,
  { {0x3e48000c,0x5f46007e,0x3a26006f,0x00000000}},	//   eşte_, _آنجل, tkop_,
  { {0xa2c00161,0xfaf8003d,0xc3320063,0x00000000}},	//   _विस्, _šīs_, כוב_,
  { {0x08970032,0xd83a000d,0x127b0041,0x00000000}},	//   وضوع_, жэй_, קאנע,
  { {0x68ed017d,0x9f430080,0x36d4005e,0x00000000}},	//   çada, zejí_, еокр,
  { {0xd6cf005a,0x66e3018e,0x3a261207,0x00000000}},	//   ът_, воја, pkop_,
  { {0x24870027,0x26c01b99,0x44f40781,0x00000000}},	//   _ainm_, čio_, епис,
  { {0x25af0290,0x83fc007d,0x05bf0042,0x00000000}},	//   _degl_, hođe, _एयरब,
  { {0x83fc0117,0xd378007d,0x224000ea,0x00000000}},	//   kođe, zeću_, _amik_,
  { {0x972601fb,0xd6cf002a,0x60c6030c,0x00000000}},	//   _تفاو, _نقل_, erkm,
  { {0xc7b8017f,0x64a60088,0xd626013a,0x00000000}},	//   _dođe_, _жада, _تعطي,
  { {0x7c2e1b9a,0xd378007d,0xdce7008f,0x00000000}},	//   _olbr, veću_, ālīb,
  { {0x9f430080,0x656f00bd,0xf1bf013d,0x00000000}},	//   sejí_, üche, ehát_,
  { {0x83fc017f,0xddc40022,0x60c60c01,0x00000000}},	//   gođe, dnił, arkm,
  { {0x41e70304,0xddc40022,0x7c2e1b9b,0x00000000}},	//   _ціка, enił, _albr,
  { {0xee84000d,0x5c751b9c,0xd378007d,0x00000000}},	// [2890] тыро, елат, reću_,
  { {0x78a20512,0x83fc017f,0x9f4c0240,0x00000000}},	//   dpov, bođe, ždá_,
  { {0xb5fd1b9d,0xdb0500a5,0x78a21b9e,0x00000000}},	//   loše, kahå, epov,
  { {0xdb1c0e7c,0xd37b0047,0x2cc40058,0x00000000}},	//   _acró, קראט, ürdü_,
  { {0xb5fd017f,0x682f0093,0x25af01e1,0x00000000}},	//   noše, _rødb, _regl_,
  { {0x46f50156,0xb05b0072,0x25af05a5,0x00000000}},	//   ечит, ttäy, _segl_,
  { {0x7b640121,0x78a200b2,0xa2c00042,0x00000000}},	//   _атте, apov, _विष्,
  { {0x2c740137,0xb5fd007d,0x7af5013d,0x00000000}},	//   räde_, koše, _iszt,
  { {0xa4d60001,0xa8a701dd,0xb05b0072,0x00000000}},	//   едњу_, _ірак, stäy,
  { {0xa2c00053,0x7af50051,0x25a2005b,0x00000000}},	//   _विश्, _kszt, ıkla_,
  { {0xe5e1000d,0x43740054,0xcad5009a,0x00000000}},	//   _былi_, куют, עוֹת_,
  { {0x83fc017f,0x34951b76,0xc7b8007d,0x00000000}},	//   vođe, _задр, _vođe_,
  { {0x65940138,0x660b1b9f,0x60c601e1,0x00000000}},	//   _рачу, _ingk, urkm,
  { {0x7bc30026,0x7af500ea,0x26c71ba0,0x00000000}},	//   ónul, _oszt, orno_,
  { {0xe4560047,0xbcfb00ea,0x9e76005e,0x00000000}},	//   _איסט_, _szép, ећај,
  { {0x26120053,0x83fc007d,0x224000c2,0x00000000}},	//   थायी_, rođe, _umik_,
  { {0x61e400a4,0x7af500ea,0x20130046,0x00000000}},	// [28a0] _ibil, _aszt, ýnið_,
  { {0x3ec5005b,0xa7fc0058,0x4d631ba1,0x00000000}},	//   üstü_, _akın, укув,
  { {0x4fd700b5,0x660b00f3,0x7fd700b5,0x00000000}},	//   _אויב_, _ongk, _אויס_,
  { {0xf2d2016e,0x5e460044,0xdca604ef,0x00000000}},	//   רעא_, _أَحْ, _пами,
  { {0x61e40009,0x186a064b,0x26c71ba2,0x00000000}},	//   _mbil, пади_, erno_,
  { {0x660b1acc,0xd6d00021,0x25dd0053,0x00000000}},	//   _angk, لقت_, क्सी_,
  { {0x61e41ba3,0xad9b0026,0x78a21ba4,0x00000000}},	//   _obil, _snúi, spov,
  { {0xdb1c0025,0x95d70062,0x61e40075,0x00000000}},	//   _ndré, едът_, _nbil,
  { {0xb17b00c7,0x5454026b,0x69c00078,0x00000000}},	//   neåt, квит, _idme,
  { {0xccf3014e,0x660b0397,0x29041ba5,0x00000000}},	//   רכז_, _engk, _irma_,
  { {0xf2e5000c,0xdb0e006d,0x2259007f,0x00000000}},	//   ţând_, _bebé, дины_,
  { {0x5ab700b7,0xb05b0072,0xf2c30085,0x00000000}},	//   עלכע_, rräm, ысьн,
  { {0x656f0024,0xd83f00a8,0x64a30500,0x00000000}},	//   ýcht, _ščit_, _бача,
  { {0xdb0700ea,0x442e1ba6,0xb5fd17cf,0x00000000}},	//   _lejá, _ulf_, roše,
  { {0xc0ab006a,0x63bc0026,0x6e950002,0x00000000}},	//   _کابل_, órnu, тибу,
  { {0x27ee002b,0x29041ba7,0xfe7314d7,0x00000000}},	//   hefn_, _orma_, ادس_,
  { {0xebc70001,0xf1bf0080,0xcbc7007e,0x00000000}},	// [28b0] ељен, nkám_, فزاي,
  { {0x69c00bbd,0x61fd1ba8,0x61e41ba9,0x00000000}},	//   _adme, ldsl, _zbil,
  { {0x29041095,0xdb07013d,0x61e8013d,0x00000000}},	//   _arma_, _bejá, ődle,
  { {0x68ed1997,0xb05b0137,0x61fd1baa,0x00000000}},	//   çado, kräk, ndsl,
  { {0xd366006a,0x7e6d003d,0xdb07006d,0x00000000}},	//   _چه_, mlap, _dejá,
  { {0xd366006a,0xab950001,0x97c20076,0x00000000}},	//   _نه_, _јављ, айше,
  { {0x316c0045,0xcc54005a,0x8f9c0047,0x00000000}},	//   ędzi_, _свръ, ליגי,
  { {0x7e6d00ea,0x61fd153a,0x60dd00df,0x00000000}},	//   nlap, jdsl, ktsm,
  { {0xe8950088,0x9f4a0268,0x61ef1bab,0x00000000}},	//   _разь, rebé_, decl,
  { {0xdb050014,0xe29902d8,0x7e6d1bac,0x00000000}},	//   dahú, мао_, hlap,
  { {0x26dc027d,0xe1bf0053,0x60dd00f5,0x00000000}},	//   ctvo_, ्लंघ, etsm,
  { {0x660b1bad,0xa696009f,0x7e6d008f,0x00000000}},	//   _ungk, _סכנה_, jlap,
  { {0x463a00b5,0x7e6d001c,0x60dd00b9,0x00000000}},	//   _קענע, dlap, gtsm,
  { {0x25dd0053,0x6a781bae,0x7e6d017e,0x00000000}},	//   क्री_, mífe, elap,
  { {0x998f0006,0x60dd0d13,0x6a7812c7,0x00000000}},	//   nigų_, atsm, lífe,
  { {0xa7fc005b,0x61e408ed,0x61ef00ca,0x00000000}},	//   _akıl, _ubil, cecl,
  { {0x6a780e1f,0x0d860f50,0x3e5a011b,0x00000000}},	// [28c0] nífe, тлан, jďte_,
  { {0x7e6d1baf,0xe0b7009f,0x6faa0021,0x00000000}},	//   alap, _שליט_, _تهدف_,
  { {0xe9da0076,0xb5fd0024,0x3daa0076,0x00000000}},	//   дке_, alši, _окно_,
  { {0x831a0047,0xceb80078,0x98a60962,0x00000000}},	//   וועז, šęs_, виде,
  { {0xb7b5008b,0x6c860021,0x314d009a,0x00000000}},	//   _vọn, _للحم, ּתוּ,
  { {0x7d061bb0,0x69dd0137,0xf1bf0195,0x00000000}},	//   _irks, _ösen, vkám_,
  { {0xddcd000c,0x27ee001f,0x8c430571,0x00000000}},	//   noaş, refn_, _тере,
  { {0xceb30063,0x64430ebd,0xd49a0141,0x00000000}},	//   ביה_, _amni, мро_,
  { {0x2904000c,0x26dc01a6,0x5e570047,0x00000000}},	//   _urma_, stvo_, כיקע_,
  { {0x98760092,0x7e6d0023,0xa84a043e,0x00000000}},	//   _рубљ, zlap, _غلام_,
  { {0x83fc007d,0x0bb70063,0xd7760021,0x00000000}},	//   gođa, כלים_, _شائع,
  { {0xbddb0003,0x27e9007d,0xd7d20053,0x00000000}},	//   _amèn, đane_, _साँच,
  { {0x61fd0f2d,0x68e9003b,0x61ef1bb1,0x00000000}},	//   rdsl, _xped, recl,
  { {0xdb050014,0xb5fd008f,0x4fc40a91,0x00000000}},	//   rahú, moša, исса,
  { {0xb5fd008f,0x53330062,0xd5e20013,0x00000000}},	//   loša, _вещт, _giọ,
  { {0x2d8f0146,0xfda40001,0x64430051,0x00000000}},	//   øge_, ијум, _zmni,
  { {0xb5fd003d,0x3d0d0161,0xbfab0062,0x00000000}},	// [28d0] noša, समें_, _отне_,
  { {0x7e6d0812,0xe1ff0331,0xd0f800ff,0x00000000}},	//   slap, ldó_, _יצחק_,
  { {0x68e91bb2,0xe0df0290,0xe945005d,0x00000000}},	//   _sped, ltò_, گرای,
  { {0xb5fd001c,0xe1ff0882,0x6e360114,0x00000000}},	//   koša, ndó_, chyb,
  { {0xe0df051e,0x89a80086,0xb5fd001c,0x00000000}},	//   ntò_, тків_, joša,
  { {0xb5fd003d,0x3e5a0240,0x29c3008b,0x00000000}},	//   doša, rďte_, ựa_,
  { {0x36690055,0x64481bb3,0x7d0b01e1,0x00000000}},	//   нако_, didi, ægsf,
  { {0x83fc017f,0xc7b8017f,0x6e2d1bb4,0x00000000}},	//   vođa, _vođa_, nkab,
  { {0x9f4300fe,0xb5fd001c,0x229a001c,0x00000000}},	//   lejä_, goša, _rīka_,
  { {0xb05b004d,0x64481bb5,0x229a0023,0x00000000}},	//   bräi, gidi, _sīka_,
  { {0x8458005a,0x6e2d005b,0x96fb0021,0x00000000}},	//   ърът_, kkab, _تعذر_,
  { {0xb5fd001c,0x8236007e,0x64481bb6,0x00000000}},	//   boša, اردا, aidi,
  { {0x3c360146,0x7d09007d,0x78f90047,0x00000000}},	//   _hæve_, _šesn, עפֿו,
  { {0x9f43024a,0x64481bb7,0xddc401da,0x00000000}},	//   kejä_, cidi, dliš,
  { {0x752900ea,0x3ebe0026,0xd5b70042,0x00000000}},	//   lyez, étt_, _इजाज,
  { {0x661b08f0,0x6e2d002c,0xb17b02ab,0x00000000}},	//   njuk, gkab, reår,
  { {0x75290009,0x753b00bd,0xddc40a1c,0x00000000}},	// [28e0] nyez, nzuz, gliš,
  { {0x6e2d1bb8,0x661b0ff2,0x1c0e0053,0x00000000}},	//   akab, hjuk, साइल_,
  { {0x49ca1527,0x27e0013d,0x9f8b004b,0x00000000}},	//   елен_, őink_, _söök_,
  { {0xddc400c2,0xb05b0137,0x64481bb9,0x00000000}},	//   bliš, tsäg, zidi,
  { {0x28f80b0f,0xad9b0024,0x64480306,0x00000000}},	//   тель_, _vnút, yidi,
  { {0x7d04011d,0xb5fd1bba,0xe1ff013d,0x00000000}},	//   mvis, voša, rlói_,
  { {0xfaa3018e,0x7d041bbb,0x627c0022,0x00000000}},	//   _гасо, lvis, _złoś,
  { {0xb5fd003d,0x64480185,0xceb30063,0x00000000}},	//   toša, widi, זיה_,
  { {0x25b90026,0x7d041bbc,0x752900ea,0x00000000}},	//   ðsla_, nvis, gyez,
  { {0x2a66002c,0x64480250,0xb5fd1bbd,0x00000000}},	//   loob_, uidi, roša,
  { {0x7d04024a,0xd7930032,0x3ce00019,0x00000000}},	//   hvis, _المخ, htiv_,
  { {0xe0df051e,0xb5fd1bbe,0x3ce00f4b,0x00000000}},	//   ttò_, lošn, ktiv_,
  { {0xc5f3014e,0xe1ff1bbf,0xa2c00053,0x00000000}},	//   _לדף_, rdó_, _विक्,
  { {0xe0df051e,0x7d041bc0,0xe1ff0022,0x00000000}},	//   rtò_, dvis, ylów_,
  { {0xf8d10161,0xe0df051e,0x9f340086,0x00000000}},	//   _सम्प, stò_, бері,
  { {0x7d0400b9,0x7bca0026,0x21360003,0x00000000}},	//   fvis, ófun, êché_,
  { {0xdb0e02dd,0x5bcb0001,0x786d0024,0x00000000}},	// [28f0] _debí, ећег_, súvi,
  { {0xad9b10d9,0x6e2d0b4b,0x9f4300fe,0x00000000}},	//   _saúd, skab, tejä_,
  { {0xddc4085a,0x63ba0089,0x212b1bc1,0x00000000}},	//   sliš, iatn, lych_,
  { {0x9f430072,0xb05b0137,0x98a9007d,0x00000000}},	//   rejä_, gräv, šač_,
  { {0x212b1bc2,0x3ce0000c,0xab950086,0x00000000}},	//   nych_, ctiv_, _вигі,
  { {0x63ba017f,0x9f4300fe,0xdb050025,0x00000000}},	//   jatn, pejä_, lbhí,
  { {0xdb580086,0xc7c40076,0x63ba1bc3,0x00000000}},	//   _бют_, ссчи, datn,
  { {0x212b0024,0x9f4a017d,0x645800c2,0x00000000}},	//   kych_, lebã_, _ajvi,
  { {0x680b003d,0xe3b1007e,0x63ba1bc4,0x00000000}},	//   _pēdē, يرد_, fatn,
  { {0x13090076,0x212b0106,0x661b1310,0x00000000}},	//   вной_, dych_, sjuk,
  { {0x9f4c0024,0xb05b004d,0x35f51bc5,0x00000000}},	//   ždú_, nräu, _впер,
  { {0x224b1101,0x2ca9006f,0x7d0400fe,0x00000000}},	//   gick_, kpad_, yvis,
  { {0x63ba003e,0x6d4b0014,0x23dd0042,0x00000000}},	//   batn, úgal, _मापद,
  { {0x645d03b2,0x7d041bc6,0x98a0017f,0x00000000}},	//   ésid, vvis, šić_,
  { {0x683f0006,0x25ad1bc7,0x682f0093,0x00000000}},	//   _išdė, obel_, _rødl,
  { {0x3126005a,0xb21b00b9,0x7d0406f1,0x00000000}},	//   _вдиг, lmæn, tvis,
  { {0x212b0045,0xb21b0146,0x3b9602d8,0x00000000}},	// [2900] cych_, omæn, ајет,
  { {0x69db048e,0x629e06b2,0x6abe004d,0x00000000}},	//   _acue, _époc, tspf,
  { {0xb5fd001c,0x0b460002,0x23dd0053,0x00000000}},	//   jošo, јнен, _मानद,
  { {0x25ad006f,0x3ebe0026,0xd3560063,0x00000000}},	//   jbel_, áttu_, ביעי_,
  { {0x9f580268,0xb21b00b9,0x63ba0360,0x00000000}},	//   ldrà_, kmæn, yatn,
  { {0xb05b00bd,0x69db0331,0xd90d007e,0x00000000}},	//   bräu, _ecue, عیل_,
  { {0x63ba1bc8,0x27fe14d4,0x9f580268,0x00000000}},	//   vatn, _vatn_, ndrà_,
  { {0x27e9017f,0x7bc30026,0xb05b01bb,0x00000000}},	//   đana_, ónuv, lrät,
  { {0x8e370047,0xddcd0195,0x98a31bc9,0x00000000}},	//   ינקא_, ymaž, _мите,
  { {0x3cf90053,0xb05b01bb,0x25ad1bca,0x00000000}},	//   _उनसे_, nrät, abel_,
  { {0x212b1112,0x8bd70047,0x29060072,0x00000000}},	//   wych_, סוטו_, lvoa_,
  { {0x63ba14b5,0x212b1a03,0x20df00dd,0x00000000}},	//   satn, tych_, tîi_,
  { {0x9258005a,0x63ba1bcb,0x224b03a3,0x00000000}},	//   раят_, patn, rick_,
  { {0x50670138,0x212b1bcc,0xddcd0078,0x00000000}},	//   ртма, rych_, umaž,
  { {0xe2970079,0xc058019d,0x645d0803,0x00000000}},	//   _кај_, рія_, ésie,
  { {0x2ca91bcd,0x63b800d1,0x71470121,0x00000000}},	//   tpad_, _hevn, _вхож,
  { {0xdb050027,0xb5fd1bce,0xb05b01bb,0x00000000}},	// [2910] rbhí, došl, frät,
  { {0x63b80031,0x0ba7000d,0xb05b092e,0x00000000}},	//   _jevn, ршам, grät,
  { {0xdb1500ea,0xddc40022,0x2ca91bcf,0x00000000}},	//   _kezé, nniś, spad_,
  { {0xdb05004b,0x2ca91bd0,0x3a240ca8,0x00000000}},	//   mahü, ppad_, _comp_,
  { {0xe1ff00cd,0xb05b004d,0xfe000053,0x00000000}},	//   llós_, sräu, _लोटस_,
  { {0x63b81bd1,0x9f58006d,0xb5fd001c,0x00000000}},	//   _nevn, ldrá_, tošo,
  { {0x26c11bd2,0x7bc30026,0x6298197c,0x00000000}},	//   ého_, ónuu, _nuvo,
  { {0xa2c00394,0x9f5802dd,0x200100a4,0x00000000}},	//   _विज्, ndrá_, _lahi_,
  { {0xdb0701c2,0x68fb1235,0x25ad1bd3,0x00000000}},	//   _nejú, _usud, rbel_,
  { {0xc6e7019d,0x20010150,0x62981bd4,0x00000000}},	//   _відп, _nahi_, _buvo,
  { {0xd6db0138,0xb21b00b9,0x9f5a01f4,0x00000000}},	//   _шта_, rmæn, _capì_,
  { {0xf5950021,0xb21b00b9,0x69d90b94,0x00000000}},	//   _الإج, smæn, ngwe,
  { {0x661d0014,0x5fdc0042,0xb05b0050,0x00000000}},	//   ösku, _बादल, yrät,
  { {0xf66a007a,0x22490089,0x0574007e,0x00000000}},	//   phæð_, _emak_, _بامد,
  { {0xdb1c0240,0xb05b0b6e,0x20010792,0x00000000}},	//   _odrá, vrät, _dahi_,
  { {0xb05b004d,0x9f5800cd,0x7bc70725,0x00000000}},	//   tsäc, rdrà_, _adju,
  { {0x629800bd,0x3a2409fe,0xb05b01bb,0x00000000}},	// [2920] _zuvo, _romp_, trät,
  { {0xd37e007d,0xddcd0051,0xb05b051c,0x00000000}},	//   šćem_, gnał, rsäc,
  { {0x628605b9,0x5f0609b4,0xb05b1bd5,0x00000000}},	//   omko, _узна, rrät,
  { {0x68e21bd6,0xb05b0cbf,0xddcd0022,0x00000000}},	//   ttod, srät, anał,
  { {0xa3d70235,0xb05b00c7,0xb5fd10f5,0x00000000}},	//   िला_, prät, rošl,
  { {0xd6da0086,0x6c36007e,0x29060072,0x00000000}},	//   гти_, _افسا, rvoa_,
  { {0xb21b0014,0x63b8080e,0x8706000d,0x00000000}},	//   fmæl, _revn, сяле,
  { {0xb05b0072,0x60c40734,0xf1bf013d,0x00000000}},	//   isäa, _ovim, nkát_,
  { {0x2733001b,0x63b8027d,0x62981bd7,0x00000000}},	//   ạn_, _pevn, _suvo,
  { {0x22491bd8,0x682f04aa,0x96ba143c,0x00000000}},	//   _smak_, _nødh, _буду_,
  { {0xe6960021,0xd5af1bd9,0x3618005d,0x00000000}},	//   _الصد, _нс_, _پراگ_,
  { {0xddcd0022,0xdb05004b,0xe717009a,0x00000000}},	//   znał, vahü, _לחבר_,
  { {0xdb1500ea,0x645d00ed,0x067b0047,0x00000000}},	//   _vezé, ésic, _ענדל,
  { {0x6e95000a,0xdb1c00b9,0xa0550086,0x00000000}},	//   живу, _idræ, івві,
  { {0xadbd0088,0x9f340086,0x2001004b,0x00000000}},	//   кавi, пері, _vahi_,
  { {0x66020004,0x44e20014,0xb05b00a5,0x00000000}},	//   _jaok, oð_, träs,
  { {0x61ed002c,0x20011bda,0x6144005e,0x00000000}},	// [2930] _ibal, _tahi_, _нећа,
  { {0x44e2007a,0xb606007d,0x2bb80044,0x00000000}},	//   ið_, lašć, مامة_,
  { {0xaab50054,0xf1bf013d,0x99990768,0x00000000}},	//   ійді, bkát_, акет_,
  { {0xb05b0c38,0x3c2f0058,0x49751579,0x00000000}},	//   präs, _sıvı_, олес,
  { {0x7bc3007a,0x61ed0009,0xa9690001,0x00000000}},	//   ónus, _mbal, јила_,
  { {0xbcfb0164,0x3c3601e1,0xdb050139,0x00000000}},	//   _exéc, _hævn_, abhá,
  { {0x44e2007a,0x682f05dd,0x61ed1bdb,0x00000000}},	//   eð_, _jødi, _obal,
  { {0xf6250086,0xe7f50053,0x644a1bdc,0x00000000}},	//   ідпо, _इसका_, _amfi,
  { {0x84591bdd,0xb5fd01b3,0x69c91bde,0x00000000}},	//   ирот_, lošk, _idee,
  { {0x61ed1bdf,0x94790002,0x78a900ca,0x00000000}},	//   _abal, јсиу_, _itev,
  { {0x44e2007a,0x60c4017f,0xfbd20063,0x00000000}},	//   að_, _svim, ותי_,
  { {0x3c3600b9,0x644a00be,0xe5ef0072,0x00000000}},	//   _nævn_, _emfi, äkää,
  { {0x644f0164,0x629e0003,0x62861be0,0x00000000}},	//   écis, _épon, rmko,
  { {0x22591be1,0xfc3f004c,0x66021be2,0x00000000}},	//   ansk_, _stín_, _zaok,
  { {0xb5fd007d,0x44271be3,0xbea30085,0x00000000}},	//   jošk, _ion_, даск,
  { {0x78a90080,0x44271be4,0x6d050042,0x00000000}},	//   _otev, _hon_, रिंग_,
  { {0xec4a0055,0xdb9a0001,0x44271be5,0x00000000}},	// [2940] азал_, атељ_, _kon_,
  { {0x44271be6,0x61ed0066,0x2004008f,0x00000000}},	//   _jon_, _zbal, ēmis_,
  { {0x44271be7,0x290d1be8,0xb5fd00b2,0x00000000}},	//   _mon_, _area_, gošk,
  { {0x38c8007e,0xb05b051c,0xddcd056c,0x00000000}},	//   ماتی_, nsän, gnań,
  { {0x290d1be9,0xb05b0072,0x61eb0058,0x00000000}},	//   _crea_, isän, _ögle,
  { {0x44271bea,0x764b001f,0xb8f20053,0x00000000}},	//   _non_, _amgy, _वि_,
  { {0xab2a0017,0x3e48003b,0xd6d00021,0x00000000}},	//   _това_, eşti_, رقة_,
  { {0x44270027,0xd4b807b0,0xcf930063,0x00000000}},	//   _aon_, блиц_, וטו_,
  { {0xe4e6019d,0x44271beb,0xb05b1bec,0x00000000}},	//   ційн, _bon_, kräp,
  { {0x44e2007a,0x44271bed,0x44381bee,0x00000000}},	//   rð_, _con_, ór_,
  { {0x78830080,0x69c900b9,0xe2f80086,0x00000000}},	//   _důvě, _ydee, щені_,
  { {0x92580076,0x44271bef,0x9f45004c,0x00000000}},	//   жают_, _eon_, ýlí_,
  { {0xc218019d,0x8556007e,0xa6330054,0x00000000}},	//   ією_, _بخاط, _інші,
  { {0xdb1e017d,0x9f4c0114,0x44271bf0,0x00000000}},	//   rapê, ždý_, _gon_,
  { {0x764b0185,0xa5c30051,0x645a0139,0x00000000}},	//   _ymgy, spół, mnti,
  { {0x44271bf1,0x61ed1bf2,0x5d990085,0x00000000}},	//   _zon_, _ubal, скаў_,
  { {0xe04b006a,0x645a0aca,0x443e004b,0x00000000}},	// [2950] _نشده_, onti, oht_,
  { {0xddcd003b,0x645a1bf3,0x656f004d,0x00000000}},	//   flaţ, nnti, üchi,
  { {0x645a1bf4,0xdefb000d,0x2bb80021,0x00000000}},	//   inti, _тып_, زالة_,
  { {0x7b64011c,0xb5fd1312,0xf9c7019d,0x00000000}},	//   фтуе, rošk, іщен,
  { {0xf99003eb,0x07a50854,0x8d871bf5,0x00000000}},	//   نبه_, палн, _фунд,
  { {0x290d000c,0x7c3e1bf6,0x09340021,0x00000000}},	//   _vrea_, chpr, برمج,
  { {0x443e0139,0xb5fd0a80,0x8c3b004d,0x00000000}},	//   dht_, loši, _außg,
  { {0x682f191f,0x290d0147,0x443e0b64,0x00000000}},	//   _nødv, _trea_, eht_,
  { {0xb05b0137,0x290d1bf7,0x25bf002b,0x00000000}},	//   vsän, _urea_, raul_,
  { {0x443e1bf8,0xfb96009a,0xf7730044,0x00000000}},	//   ght_, ּ֣ית_, _قاض_,
  { {0x44270cd4,0xdb0e00bd,0xddc4003b,0x00000000}},	//   _von_, _gebä, noiţ,
  { {0x44271bf9,0x98cf0053,0xfc3f0d5d,0x00000000}},	//   _won_, _हटाए, _stíl_,
  { {0x44271bfa,0xb5fd001c,0xb05b01bb,0x00000000}},	//   _ton_, joši, rsän,
  { {0x9f5a0290,0x443e1bfb,0xb5fd008f,0x00000000}},	//   _papà_, cht_, doši,
  { {0x7d0b01e1,0xa8560063,0x765b0058,0x00000000}},	//   ægsn, לישה_, onuy,
  { {0x9f4b000f,0x6446008f,0xc7b80130,0x00000000}},	//   áját_, īkie, _vođi_,
  { {0x229a001c,0xdb1c017d,0x6446008f,0x00000000}},	// [2960] _rīki_, _gerê, ūkie,
  { {0xdb1e00ea,0xddc4003b,0x4176005d,0x00000000}},	//   lapé, foiţ, _واکس,
  { {0xb05b024a,0x60c600d1,0x1c390086,0x00000000}},	//   isäl, lskm, цять_,
  { {0x6287004c,0x7d290046,0x0136009d,0x00000000}},	//   ňkov, ðssó, ּרַת_,
  { {0x645a1bfc,0x62840025,0xddcd003b,0x00000000}},	//   ynti, _mhio, slaţ,
  { {0x62960035,0x7b0100fe,0x18670896,0x00000000}},	//   _liyo, äytä, пачи_,
  { {0xb17b0d02,0x6e360078,0x765b0014,0x00000000}},	//   mgåe, okyb, fnuy,
  { {0x62960a9f,0x6e360006,0x6d44004d,0x00000000}},	//   _niyo, nkyb, ozia,
  { {0x6d441bfd,0xa4f8007e,0x38cb005d,0x00000000}},	//   nzia, تکار_, _هالی_,
  { {0x644f0164,0x6e240035,0x629600a4,0x00000000}},	//   écip, hjib, _aiyo,
  { {0xddcd02f4,0xe41a0024,0x62961bfe,0x00000000}},	//   hlaš, _kľúč, _biyo,
  { {0x6d440089,0xdb1e00cd,0xa77b0047,0x00000000}},	//   kzia, rapè, _פראפ,
  { {0x6296132d,0x61f8000d,0x518401ce,0x00000000}},	//   _diyo, чняў_, еура,
  { {0x6d440045,0xc953014e,0xc05b0500,0x00000000}},	//   dzia, תמש_, сім_,
  { {0xb17b0146,0x62840025,0x9f5a1bff,0x00000000}},	//   dgåe, _fhio, _papá_,
  { {0x3377014e,0xb5fd001c,0xddc4003b,0x00000000}},	//   _מתוך_, toši, voiţ,
  { {0x7e6d000c,0xddcd01a6,0xdb1c00cd,0x00000000}},	// [2970] roap, glaš, _herè,
  { {0x6e240035,0xb5fd1c00,0x7a330058,0x00000000}},	//   ajib, roši, _içti,
  { {0x3cf90053,0x682f00b9,0x69c2001f,0x00000000}},	//   _उनके_, _mødt, faoe,
  { {0xddcd00c3,0x7bde00a4,0xb05b0072,0x00000000}},	//   blaš, agpu, isäm,
  { {0x8c3b0199,0x99840080,0x88c80054,0x00000000}},	//   _auße, _domů_, злів_,
  { {0xe8f8000d,0x682f05a5,0x27e10244,0x00000000}},	//   ялі_, _nødt, ühn_,
  { {0x7d0d1c01,0xca7700f2,0x3e770058,0x00000000}},	//   lvas, _فارغ, eçti_,
  { {0xff180063,0x443c1c02,0x765b0058,0x00000000}},	//   לקות_, _alv_, unuy,
  { {0x3a84000d,0x58d4050f,0x645d0003,0x00000000}},	//   _чырв, _потт, ésio,
  { {0x23c6004c,0x3ce9007d,0x8c3b0244,0x00000000}},	//   víjí_, itav_, _fuße,
  { {0xb05b00c7,0x6d441c03,0x3ce90019,0x00000000}},	//   rsäl, zzia, htav_,
  { {0xdb1c00b9,0xc7b8007d,0x7640002b,0x00000000}},	//   _udrå, _dođu_, chmy,
  { {0xdb1e0e1a,0x6609005b,0x7d0b0583,0x00000000}},	//   rapé, mdek, ægsl,
  { {0x6d440024,0xddcd007d,0x660918d2,0x00000000}},	//   vzia, vlaš, ldek,
  { {0x62840027,0xdee31c04,0x64411c05,0x00000000}},	//   _thio, кори, mhli,
  { {0x2ca600ed,0x9e75005e,0x1e750002,0x00000000}},	//   íodo_, ећуј, еѓус,
  { {0x15e20053,0x6e240150,0xb17b00cf,0x00000000}},	// [2980] क्टर_, rjib, tgåe,
  { {0x660900fe,0x6d441c06,0x26c700b2,0x00000000}},	//   hdek, rzia, ksno_,
  { {0xb17b0203,0xdb050003,0x442500ca,0x00000000}},	//   rgåe, nchè, ijl_,
  { {0xddcd001c,0x2a600019,0xa2d50053,0x00000000}},	//   plaš, õib_, _भिन्,
  { {0x64411c07,0x682f06a5,0x66091c08,0x00000000}},	//   khli, _nøds, ddek,
  { {0x645d0003,0x76aa1c09,0x66091c0a,0x00000000}},	//   ésil, отив_, edek,
  { {0x8c3b00bd,0xda6600de,0x986900de,0x00000000}},	//   _fußb, _قاري, أحنف_,
  { {0x44250146,0xd5b00021,0x64411a59,0x00000000}},	//   ejl_, دفة_, ehli,
  { {0x7d1b0268,0x69c0003d,0x34940062,0x00000000}},	//   _àust, _ieme, наир,
  { {0x682f02ab,0xd4670001,0x64411c0b,0x00000000}},	//   _døds, миње_, ghli,
  { {0x69c00e53,0x39460331,0x734a0e82,0x00000000}},	//   _keme, lzos_, ючив_,
  { {0x9f580024,0x682f02ab,0xb05b0137,0x00000000}},	//   ceré_, _føds, rsäm,
  { {0x69c00e53,0x229a003d,0x656f00bd,0x00000000}},	//   _meme, _rīku_, ücht,
  { {0x64410199,0xd0840076,0x69c019ad,0x00000000}},	//   chli, выси, _leme,
  { {0x3267005a,0xfe73043e,0x33db009a,0x00000000}},	//   _отив, ندر_, _וחוד,
  { {0xbddb1b84,0xe508001b,0x27e9017f,0x00000000}},	//   _amèr, _kỷ_, đani_,
  { {0x61fd1c0c,0xa2da0053,0xdd03001c,0x00000000}},	// [2990] mesl, पूर्, _ārēj,
  { {0x6609005b,0xb05b00fe,0xb5fd1c0d,0x00000000}},	//   zdek, isäk, lošt,
  { {0xdb1500ea,0x7d0d1c0e,0x69c01c0f,0x00000000}},	//   _bezá, svas, _beme,
  { {0xfe3500b5,0x61fd1c10,0xdb050003,0x00000000}},	//   _נאָך_, nesl, nché,
  { {0xe8ee0076,0x61fd1c11,0x69c01c12,0x00000000}},	//   ыл_, iesl, _deme,
  { {0xb5fd004c,0x0138009a,0x66e502fa,0x00000000}},	//   hošt, ורדת_, еока,
  { {0x9f580080,0x66090179,0x3ea10019,0x00000000}},	//   teré_, tdek, _juht_,
  { {0x69c0094e,0x0654000d,0x8557007e,0x00000000}},	//   _geme, ктыў, ویار_,
  { {0x66091760,0x64411c13,0x61fd1c14,0x00000000}},	//   rdek, thli, desl,
  { {0x03250079,0x26dc0006,0x60dd0019,0x00000000}},	//   едон, buvo_, dusm,
  { {0x35b51c15,0x69cc0080,0xdb1c1c16,0x00000000}},	//   _збер, ůlež, _peré,
  { {0x61fd03a8,0x68340268,0xcb1200b5,0x00000000}},	//   gesl, _ràdi, אלט_,
  { {0x25b9007a,0x7bc5002c,0xddc40080,0x00000000}},	//   ðslu_, kahu, tliž,
  { {0x7bc51c17,0xf8b20063,0x6a781bae,0x00000000}},	//   jahu, רשם_, rífi,
  { {0x5e960032,0x3a3f005b,0x7bc50397,0x00000000}},	//   فلسط, _olup_, dahu,
  { {0x61fd1c18,0xf1bf013d,0xddcd056c,0x00000000}},	//   cesl, lján_, mnaś,
  { {0xc69211b4,0xac861137,0x5096005e,0x00000000}},	// [29a0] ראן_, егал, _прођ,
  { {0x69c01c19,0xf1bf013d,0x271c008d,0x00000000}},	//   _seme, nján_, _ủng_,
  { {0x69c006a7,0x22401c1a,0x4fbb0063,0x00000000}},	//   _peme, _klik_, _מציא,
  { {0xf38c0047,0x0f57069a,0xc9861c1b,0x00000000}},	//   קראָ, _טיים_, нули,
  { {0xd83a000d,0xa3cf0053,0x7bc500a4,0x00000000}},	//   зэй_, षणा_, bahu,
  { {0x26dc1c1c,0x394602dd,0x7bce00b9,0x00000000}},	//   tuvo_, rzos_, _udbu,
  { {0x316c0045,0x8c1b00b5,0xdb05006c,0x00000000}},	//   ędzy_, _צולי, yché,
  { {0xb21b00b9,0xddd10078,0xe5c60121,0x00000000}},	//   mlæg, _įgūd, хско,
  { {0xb21b00b9,0xb5fd007d,0x61fd0075,0x00000000}},	//   llæg, vošt, vesl,
  { {0xb05b00c7,0x7c2e1c1d,0x22401c1e,0x00000000}},	//   rsäk, _jobr, _alik_,
  { {0xb21b0146,0x229a001c,0xe1ff0025,0x00000000}},	//   nlæg, _rīks_, nnóg_,
  { {0x916d001b,0xe508001b,0xe5a3005e,0x00000000}},	//   _nội_, _tỷ_, _бици,
  { {0x7bc50035,0xdb0518b2,0x61fd1781,0x00000000}},	//   yahu, rché, resl,
  { {0x7c2e1c1f,0x61fd1c20,0x60dd1c21,0x00000000}},	//   _nobr, sesl, rusm,
  { {0xddc40051,0x22401c22,0x60dd004b,0x00000000}},	//   bliż, _flik_, susm,
  { {0xb21b1c23,0x442e0da0,0xb05b0072,0x00000000}},	//   dlæg, _hof_, isäi,
  { {0x3a2d0186,0x7bc51c24,0x3d1b0053,0x00000000}},	// [29b0] _roep_, tahu, नमें_,
  { {0xddeb04de,0x6f03017d,0xe1ff0857,0x00000000}},	//   _کرده_, _ânco, leó_,
  { {0x7c2e1c25,0x7bc51c26,0xdb140046,0x00000000}},	//   _dobr, rahu, óaði,
  { {0x7bc50512,0x442e1c27,0xe1ff006d,0x00000000}},	//   sahu, _lof_, neó_,
  { {0x7c950032,0xb21b0146,0x7bc5002c,0x00000000}},	//   _للحص, lmæs, pahu,
  { {0xbddb0164,0x46f50086,0x25a90022,0x00000000}},	//   _flèc, вчит, _żal_,
  { {0xddcd0051,0xb21b01e1,0x1c0a0053,0x00000000}},	//   miał, nmæs, _होटल_,
  { {0x60cd017f,0x7c2e027d,0xb05b00fe,0x00000000}},	//   _ovam, _zobr, ssäh,
  { {0xe1ff00ea,0x93fd000d,0x98f4013a,0x00000000}},	//   deó_, оўнi, _مثلا,
  { {0x22401c28,0x628f006f,0x9f580290,0x00000000}},	//   _slik_, emco, ferì_,
  { {0x22400045,0xf1c3001b,0xb21b00b9,0x00000000}},	//   _plik_, _trở_, klæd,
  { {0x6b9a0026,0xe6040044,0xddcd056c,0x00000000}},	//   _útge, _مِمَ, rnaś,
  { {0xf1bf000f,0xdd010080,0x41030062,0x00000000}},	//   pján_, čtět, азяв,
  { {0x65940138,0x442e002b,0xd4790047,0x00000000}},	//   _сачу, _gof_, _קאַל,
  { {0x7c2e1c29,0x83f6005e,0xd46602b6,0x00000000}},	//   _robr, _рејс_, _шише_,
  { {0xb17b00c7,0x7c2e1028,0x224000d1,0x00000000}},	//   mgån, _sobr, _ulik_,
  { {0x660b00bb,0xb17b00c7,0xdca303d6,0x00000000}},	// [29c0] _magk, lgån, иати,
  { {0x660b00a5,0x2137016e,0x30760145,0x00000000}},	//   _lagk, _סטיל_, _шуйс,
  { {0x9f4800fe,0xb17b0137,0xfaa30085,0x00000000}},	//   ähän_, ngån, аахо,
  { {0xb21b007a,0x660b002c,0x7c2e002b,0x00000000}},	//   rlæg, _nagk, _wobr,
  { {0xb21b0146,0xd94603d6,0xe3b80058,0x00000000}},	//   slæg, ъеди, ybı_,
  { {0xddcd0051,0x98730304,0x2b4d004c,0x00000000}},	//   ciał, аліц, _řece_,
  { {0x4420001b,0x7d04004d,0xd8380130,0x00000000}},	//   _đi_, lwis, _niče_,
  { {0xb17b0137,0x6b830378,0xddcd0195,0x00000000}},	//   dgån, ünge, plať,
  { {0x2ca6018d,0x57ea000a,0x7d041c2a,0x00000000}},	//   íodh_, _одам_, nwis,
  { {0x6a78039f,0x683401a8,0xd838007c,0x00000000}},	//   rífu, _pàdu, _biče_,
  { {0xdb15004d,0x7d040206,0x66270058,0x00000000}},	//   _gezä, hwis, ürkç,
  { {0xb21b1c2b,0x7d040035,0xddcd0051,0x00000000}},	//   emær, kwis, ział,
  { {0x76420035,0xe1ff006d,0xa4d40086,0x00000000}},	//   _iloy, reó_, _солі,
  { {0xb21b1c2b,0xe1ff0331,0x66970041,0x00000000}},	//   gmær, seó_, _נאַרײ,
  { {0xf8c8008b,0x7d040333,0xadd5005e,0x00000000}},	//   hứ_, ewis, ловљ,
  { {0x63970063,0x1287007e,0xddcd0051,0x00000000}},	//   _בדוא_, _جمعی_, wiał,
  { {0xd90404de,0xebc70138,0x2d580b0f,0x00000000}},	// [29d0] _بی_, вљен, вить_,
  { {0x225902e0,0x61f6004c,0x76421c2c,0x00000000}},	//   lisk_, _zbyl, _lloy,
  { {0xddcd0051,0x8c3b004d,0x0ba401e2,0x00000000}},	//   riał, _fußn, ршум,
  { {0x629e0164,0x22591c2d,0xddcd0051,0x00000000}},	//   _épou, nisk_, siał,
  { {0x4dda014e,0xbd6b0001,0xdb1c1c2e,0x00000000}},	//   _אחרו, _црне_, _cerâ,
  { {0x07090044,0xd3660043,0xd7c902da,0x00000000}},	//   فيتي_, _هه_, روبه_,
  { {0x660b0273,0x225906f1,0xf094069a,0x00000000}},	//   _pagk, kisk_, בנס_,
  { {0xf5090cbb,0xdb0700ea,0x2259000e,0x00000000}},	//   енил_, _bejö, jisk_,
  { {0x614a0003,0x22590d7d,0xb05b004d,0x00000000}},	//   _mêlé, disk_, lsäu,
  { {0xb17b0137,0x2c1c0042,0x14250054,0x00000000}},	//   tgån, नाएं_, удом,
  { {0x22590d7d,0xb05b004d,0x7d041c2f,0x00000000}},	//   fisk_, nsäu, zwis,
  { {0xb17b00c7,0x7d040051,0x22590f4b,0x00000000}},	//   rgån, ywis, gisk_,
  { {0xb21b01e1,0xdb05006c,0xb05b0244,0x00000000}},	//   tmær, nchâ, hsäu,
  { {0xdb1c02dd,0xd838074f,0xb17b00a5,0x00000000}},	//   _serí, _tiče_, pgån,
  { {0xdb1c1c30,0x225902c0,0x9e66005d,0x00000000}},	//   _perí, bisk_, هارن,
  { {0x22590045,0x25ad1c31,0xb21b00b9,0x00000000}},	//   cisk_, ncel_, smær,
  { {0xb21b00b9,0xdb1c1c32,0xddcd0022,0x00000000}},	// [29e0] pmær, _verí, diań,
  { {0x629e0268,0x5f76007e,0xdb1e0139,0x00000000}},	//   _èpoc, _ماجر, eapá,
  { {0xe9da1c33,0x7d04004d,0xb05b004d,0x00000000}},	//   еке_, swis, gsäu,
  { {0x61e61c34,0x9f58099f,0x27150013,0x00000000}},	//   ngkl, merà_, _ính_,
  { {0x9f58197c,0x27150013,0x3202017c,0x00000000}},	//   lerà_, _h́nh_, ieky_,
  { {0xdcfd003d,0xf539004c,0xe8940e74,0x00000000}},	//   _uzsā, dyť_, шаль,
  { {0xf1ba001b,0xeab401f9,0x9f581c35,0x00000000}},	//   _đơn_, _כִּי_, nerà_,
  { {0x7e640b34,0x6443085f,0xb05b01bb,0x00000000}},	//   nnip, _alni, lsät,
  { {0xc966000d,0x9f580290,0xdb1c00cd,0x00000000}},	//   _свай, herà_, _herà,
  { {0x545406be,0x68e20b4e,0x22590051,0x00000000}},	//   рвот, muod, wisk_,
  { {0xd5e2001b,0xb05b00fe,0x22591c36,0x00000000}},	//   _chọ, isät, tisk_,
  { {0x9f58197c,0x3eb800c2,0xbb3b0047,0x00000000}},	//   derà_, dprt_, געטי,
  { {0xf1bf00ea,0x7c3e00d1,0x2715008b,0x00000000}},	//   lják_, kkpr, _ánh_,
  { {0x61e600a4,0x225917d5,0x3394000d,0x00000000}},	//   agkl, sisk_, _калё,
  { {0x645a1c37,0x22591c38,0x33170021,0x00000000}},	//   miti, pisk_, _مزيد_,
  { {0x442c00c7,0x645a1852,0x7c3e00ca,0x00000000}},	//   ljd_, liti, ekpr,
  { {0x26c1000f,0xdc5502a9,0x644800fe,0x00000000}},	// [29f0] ához_, авањ, ohdi,
  { {0x68e20006,0xb05b0137,0xddcd0051,0x00000000}},	//   duod, gsät, wiań,
  { {0xcb550138,0x442c0122,0x443e1c39,0x00000000}},	//   јвећ, ijd_, ikt_,
  { {0xdb1c03d9,0xf1bf00ea,0xb05b004d,0x00000000}},	//   _serã, dják_, rsäu,
  { {0x443e0026,0xfc3f0025,0x89a80086,0x00000000}},	//   kkt_, _dtír_, уків_,
  { {0x443e0122,0xccf20063,0x7c3e1c3a,0x00000000}},	//   jkt_, _וכך_, ckpr,
  { {0xfc3f02dd,0xdb1c0016,0xaa950086,0x00000000}},	//   _guía_, _verã, _вивч,
  { {0x443e1c3b,0xe6c40021,0x6e2d1c3c,0x00000000}},	//   ekt_, حتوي, njab,
  { {0x7bc70397,0xdb1c0016,0x6d4d006f,0x00000000}},	//   _keju, _terã, nzaa,
  { {0xf5390024,0x64480025,0x4d7c0047,0x00000000}},	//   ryť_, ghdi, ערזע,
  { {0x9f581c3d,0x628d0139,0x63850699,0x00000000}},	//   xerà_, _bhao, ргна,
  { {0x443e0122,0x9f58051e,0x38ab0146,0x00000000}},	//   akt_, verà_, _kør_,
  { {0x9f581c3e,0x628d0027,0x38ab00d1,0x00000000}},	//   derá_, _dhao, _jør_,
  { {0x443e1c3f,0x6d4d006f,0x9f58197c,0x00000000}},	//   ckt_, dzaa, terà_,
  { {0x94740021,0x6d4d1c40,0x68e20006,0x00000000}},	//   _ادنا, ezaa, zuod,
  { {0x9f580290,0x628d0025,0x69cb1c41,0x00000000}},	//   rerà_, _ghao, jage,
  { {0xb05b03c8,0xdb1c00cd,0x527b0063,0x00000000}},	// [2a00] tsät, _serà, _בנקא,
  { {0xdb1c0025,0xb05b004d,0x69cb1c42,0x00000000}},	//   _aerá, usät, eage,
  { {0x49ca0076,0xb05b0d88,0x9f581c43,0x00000000}},	//   влен_, rsät, berá_,
  { {0x38ab191f,0x9f5806b2,0xdb1c006d,0x00000000}},	//   _bør_, cerá_, _cerá,
  { {0xb05b00c7,0x443e02ea,0x39400b9b,0x00000000}},	//   psät, ykt_, áis_,
  { {0xf1bf000f,0xdb1c00cd,0x68e20006,0x00000000}},	//   tják_, _terà, ruod,
  { {0x69cb1c44,0x68e200fe,0x39400006,0x00000000}},	//   bage, suod, šis_,
  { {0x38ab02ab,0xd6260021,0xf1bf00ea,0x00000000}},	//   _før_, شعبي, rják_,
  { {0x38ab010a,0x37e60076,0x645a1c45,0x00000000}},	//   _gør_, _возг, titi,
  { {0x628d0027,0x9f580024,0x443e008f,0x00000000}},	//   _shao, zerá_, ukt_,
  { {0x443e1c46,0xcc3b0047,0x7980002b,0x00000000}},	//   rkt_, דעיט, _hymw,
  { {0x443e1c47,0x7ae300cd,0x76491a62,0x00000000}},	//   skt_, ànti, chey,
  { {0x9f580016,0xc05b019d,0x645a1c48,0x00000000}},	//   verá_, вів_, piti,
  { {0xdb1e0268,0xc05b0086,0x44f000cd,0x00000000}},	//   capç, тім_, mà_,
  { {0xa2e3000a,0x628d0025,0xdb1e0019,0x00000000}},	//   _дојд, _thao, napä,
  { {0x7bc706a7,0x20030035,0x6d4d006f,0x00000000}},	//   _seju, seji_, tzaa,
  { {0x629f0164,0x7bc70397,0x2ba70001,0x00000000}},	// [2a10] _époq, _peju, ајев,
  { {0x44f002f6,0xdb1c02dd,0x6d4d0122,0x00000000}},	//   ià_, _será, rzaa,
  { {0x38ab1609,0x69cb1c49,0x44f0008b,0x00000000}},	//   _sør_, tage, hà_,
  { {0xceb200b7,0x7d0b00b9,0xe0df01f4,0x00000000}},	//   _מיט_, ægss, orò_,
  { {0xdb1c1143,0xe9d8000d,0x44f000cd,0x00000000}},	//   _verá, ркі_, jà_,
  { {0x44f000cd,0x69cb1c4a,0xdb051c4b,0x00000000}},	//   dà_, sage, achá,
  { {0xb9e70086,0xdb051c4c,0x69cb1c4d,0x00000000}},	//   _візи, rbhó, page,
  { {0x683d0268,0x62560006,0x38ab000e,0x00000000}},	//   _mèdi, ršok, _tør_,
  { {0x6486007a,0xf8070086,0x44f000cd,0x00000000}},	//   rðin, _вчен, gà_,
  { {0xddcd00c2,0x0445005e,0x61ed1c4e,0x00000000}},	//   jlaž, сеон, _acal,
  { {0x9f580268,0xe0df19c9,0x78a9006d,0x00000000}},	//   merç_, erò_, _huev,
  { {0x44f000cd,0x78a11c4f,0x7d160072,0x00000000}},	//   bà_, _hilv, yvys,
  { {0x78a91c50,0x44f00268,0x25bf165d,0x00000000}},	//   _juev, cà_, mbul_,
  { {0x78a9006d,0xf1bf00be,0xdb050566,0x00000000}},	//   _muev, abá_, zchá,
  { {0x7ae50019,0xe0df0290,0x61ed00fe,0x00000000}},	//   juht, arò_, ällö,
  { {0xf8a504de,0xb21b00b9,0x60db0006,0x00000000}},	//   _يک_, llæn, šuma,
  { {0x78a9048e,0x6441001c,0x925a005d,0x00000000}},	// [2a20] _nuev, okli, _لشکر_,
  { {0x64411c51,0x7e7d1c52,0x6aa01c53,0x00000000}},	//   nkli, _eksp, _simf,
  { {0x25bf0089,0x64411c54,0xb09b0063,0x00000000}},	//   kbul_, ikli, _תייר,
  { {0xdb1e0019,0xd910007e,0x0dba0021,0x00000000}},	//   vapä, ویز_, _حادث_,
  { {0x78a90118,0x44f000cd,0x64411c55,0x00000000}},	//   _cuev, xà_, kkli,
  { {0x78a1003d,0x44f01c56,0x7659002b,0x00000000}},	//   _cilv, và_, _amwy,
  { {0x64410246,0xb05b0050,0x1ae31c57,0x00000000}},	//   dkli, isäp, _норм,
  { {0x44f002f6,0x44b4019d,0xbb3b0047,0x00000000}},	//   tà_, обис, _געלי,
  { {0x78a9106e,0xdb1c0c77,0x3ebf0130,0x00000000}},	//   _guev, _berç, ćuti_,
  { {0x44f01c58,0x6441002c,0x9f5a0268,0x00000000}},	//   rà_, gkli, _japó_,
  { {0xcc7b00b5,0x44f000cd,0xe2f80086,0x00000000}},	//   רװיר, sà_, шені_,
  { {0x644100e8,0x78a10122,0xe0df051e,0x00000000}},	//   akli, _zilv, trò_,
  { {0xdb1c00fe,0x64411c59,0xe0df01f4,0x00000000}},	//   _herä, bkli, urò_,
  { {0xdb1c1c5a,0xe0df0290,0x64411c5b,0x00000000}},	//   _gerç, rrò_, ckli,
  { {0x7659001f,0xc0580454,0x3ce0004b,0x00000000}},	//   _ymwy, сія_, eriv_,
  { {0x2fdf00dd,0x74bf0042,0x8de500de,0x00000000}},	//   şug_, लीकृ, تكره,
  { {0x7c350024,0x3ea20829,0xdb1c0058,0x00000000}},	// [2a30] _pozr, _dikt_, _yerç,
  { {0x25bf0089,0x4d980475,0x3ea2008f,0x00000000}},	//   zbul_, скую_, _eikt_,
  { {0xfbd00021,0xdc300078,0x29d50021,0x00000000}},	//   عتك_, ažįs, قياس,
  { {0x6441001c,0x78a11c5c,0x7ae50b75,0x00000000}},	//   zkli, _silv, ruht,
  { {0xbcfb0016,0x7ae5003a,0x78a91c5d,0x00000000}},	//   _exér, suht, _quev,
  { {0xdb1c01e3,0xdd310051,0x8aa71c5e,0x00000000}},	//   _berä, zęśc, _град,
  { {0x20131c5f,0x6e3800a8,0xf6d50054,0x00000000}},	//   _maxi_, žabš, ціля,
  { {0xe8920066,0x56920092,0x44f90085,0x00000000}},	//   ĺňať_, мајт, ахоў_,
  { {0x78a107e2,0x8937007e,0xdb1c0003,0x00000000}},	//   _tilv, _اعزا, _perç,
  { {0x99480021,0xf9900021,0xa9880063,0x00000000}},	//   _الكل_, _سبق_, _הָעִ,
  { {0xdb1c00bd,0xb21b0146,0xc5d50086,0x00000000}},	//   _gerä, rlæn, _діль,
  { {0x625a0121,0x99f90047,0xb21b01e1,0x00000000}},	//   ррор_, ױפֿפ, slæn,
  { {0xdb1c1908,0x64411c60,0x3ea200df,0x00000000}},	//   _terç, pkli, _rikt_,
  { {0x224900e3,0x2d8200ac,0x3ea20829,0x00000000}},	//   _elak_, _ryke_, _sikt_,
  { {0x03250086,0x2d8200d1,0x4fa30062,0x00000000}},	//   _єдин, _syke_, дирв,
  { {0x3f840418,0xdcf70053,0xedf4005d,0x00000000}},	//   āmu_, ुबंध_, ثيرگ,
  { {0x3ea200c7,0x62730021,0x7d0b01e1,0x00000000}},	// [2a40] _vikt_, _تهيئ, ægsp,
  { {0x62861c61,0x39420019,0x3a241c62,0x00000000}},	//   llko, _üksi_, _snmp_,
  { {0x3ea2001c,0x6da6010d,0x0b46000d,0x00000000}},	//   _tikt_, _мина, ўнен,
  { {0x66fc008f,0xdb1c00a5,0x3ce01c63,0x00000000}},	//   nākš, _nerå, priv_,
  { {0x62861c64,0xf1bf013d,0xa3e90042,0x00000000}},	//   ilko, mját_, यला_,
  { {0xdb1c00fe,0xf1bf00ea,0x9f580072,0x00000000}},	//   _perä, lját_, perä_,
  { {0x27e001f7,0xdca30f55,0xf793000d,0x00000000}},	//   ğin_, _цари, машэ,
  { {0xdb1c00bd,0x628600b9,0x67f40026,0x00000000}},	//   _verä, jlko, fþjó,
  { {0xd40603d6,0xe46a0002,0x69c203bf,0x00000000}},	//   ояни, ишол_, mboe,
  { {0x6abe00d1,0xdb1c00fe,0x68e2001f,0x00000000}},	//   oppf, _terä, mrod,
  { {0x22490162,0x68e40025,0xf1bf00ea,0x00000000}},	//   _plak_, áidf, kját_,
  { {0x68e21c65,0x69c21c66,0x64a61c67,0x00000000}},	//   orod, nboe, _дада,
  { {0x2beb0235,0x1a9b00b5,0x22491c68,0x00000000}},	//   _चालू_, ייטע, _vlak_,
  { {0xadee0053,0x68e2013d,0x7414005d,0x00000000}},	//   ङ्घन_, irod, _روبا,
  { {0xd83800c3,0x69c21986,0xce950062,0x00000000}},	//   _moč_, kboe, завъ,
  { {0x68e20218,0xf1bf00ea,0x628601a8,0x00000000}},	//   krod, gját_, clko,
  { {0x5d550581,0xfbab0376,0x69c2006f,0x00000000}},	// [2a50] чкат, атей_, dboe,
  { {0xf1bf00ea,0xd83800c2,0x68e21c69,0x00000000}},	//   aját_, _noč_, drod,
  { {0xb5fd10f5,0x68e21c6a,0x625601d1,0x00000000}},	//   liše, erod, ršov,
  { {0x69c20122,0xc33300b5,0x5a35005a,0x00000000}},	//   gboe, ווע_, янет,
  { {0x2ca302b0,0x68e20051,0x62560114,0x00000000}},	//   _tijd_, grod, pšov,
  { {0xdb15013d,0xd7fb1580,0xe1ff013d,0x00000000}},	//   _kezü, руд_, liód_,
  { {0x4429001b,0x3ffc00b5,0xb6590076,0x00000000}},	//   _đa_, יפגע, йших_,
  { {0x67f40026,0x68e21c6b,0x644a1c6c,0x00000000}},	//   tþjó, brod, _alfi,
  { {0xdb050199,0x2919006d,0x7d0d1c6d,0x00000000}},	//   schä, _ésa_, nwas,
  { {0x67f40026,0x7d0d00a4,0x28e00082,0x00000000}},	//   rþjó, iwas, _निति,
  { {0x67f40026,0x5884000d,0x59cf0042,0x00000000}},	//   sþjó, _цыта, _हजार,
  { {0xdb12000f,0x7d0d1c6e,0x83fc007d,0x00000000}},	//   égév, kwas, viđe,
  { {0x271c001b,0xa567007e,0xb1430456,0x00000000}},	//   _ảnh_, _بدان, енял,
  { {0xdb1500bd,0x66fc001c,0xa8790041,0x00000000}},	//   _bezü, sākš, מאָר,
  { {0x7d0d1c6f,0x44271c70,0xf1bf013d,0x00000000}},	//   ewas, _inn_, tját_,
  { {0xdd920021,0x660908f3,0x68e20022,0x00000000}},	//   فوز_, neek, yrod,
  { {0xf1bf013d,0x59cf0042,0x16c80082,0x00000000}},	// [2a60] rját_, _हज़र, _रब्ब,
  { {0x66091c71,0x4c83036a,0xb17b0137,0x00000000}},	//   heek, елув, tgåv,
  { {0x291f0035,0x69c2006f,0x103b0063,0x00000000}},	//   _arua_, tboe, _הגיע,
  { {0xdca61c72,0x7d0d0035,0x200a005b,0x00000000}},	//   _нами, bwas, lebi_,
  { {0x69c2016d,0x68e20006,0xb05b0019,0x00000000}},	//   rboe, urod, späe,
  { {0xb17b0031,0x69c21c73,0xd823005e,0x00000000}},	//   mgåt, sboe, едљи,
  { {0xa91d0a63,0xe737018e,0x2018001c,0x00000000}},	//   _vyža, зеј_, idri_,
  { {0x44270027,0x54b803d6,0x660900b9,0x00000000}},	//   _ann_, огия_, geek,
  { {0x7bce06a7,0xb17b00d1,0x48e302a2,0x00000000}},	//   _kebu, ngåt, _потв,
  { {0x200a007d,0xb5fd0734,0x44271c74,0x00000000}},	//   jebi_, više, _cnn_,
  { {0x67bb0063,0x20180014,0xf3660505,0x00000000}},	//   _המבק, ddri_, ятин,
  { {0x44271c75,0x7d0d0051,0x7bce1472,0x00000000}},	//   _enn_, ywas, _lebu,
  { {0xba570041,0x7bdc1c76,0x867b009a,0x00000000}},	//   לסטו_, _odru, _פרדו,
  { {0xc058000d,0xb5fd082a,0x7bce1c77,0x00000000}},	//   піс_, riše, _nebu,
  { {0x8c3b00bd,0xff0408b9,0x33fb0165,0x00000000}},	//   _mußt, нятн, _להגנ,
  { {0x7d0d002c,0xb5fd082a,0xf3130044,0x00000000}},	//   twas, piše, _أبوظ,
  { {0x62560006,0x2d8f102d,0x200a005b,0x00000000}},	// [2a70] ršot, åge_, bebi_,
  { {0x200a017d,0x7c140086,0xdb07013d,0x00000000}},	//   cebi_, ндує, _ifjú,
  { {0x2bb80021,0x7afa0137,0x7d0d1c78,0x00000000}},	//   سالة_, _ättl, swas,
  { {0xa3dc0053,0xfd1f008b,0x291f0290,0x00000000}},	//   तृत_, _trì_, _prua_,
  { {0x9f5102dd,0x7bdc006f,0x6609004b,0x00000000}},	//   pezó_, _fdru, veek,
  { {0x7bce05e4,0x66091c79,0x7e6d013d,0x00000000}},	//   _gebu, week, lnap,
  { {0xe736005a,0x6d400019,0xac941c7a,0x00000000}},	//   дещ_, _ümar, _чарш,
  { {0x7bdc1c7b,0x61fd006f,0x7e6d032e,0x00000000}},	//   _zdru, jfsl, nnap,
  { {0x66090173,0x7cde000c,0x7e6d1c7c,0x00000000}},	//   reek, părţ, inap,
  { {0x68e40027,0x61fd0026,0x7e6d1c7d,0x00000000}},	//   áide, efsl, hnap,
  { {0x420a02e4,0x03a50002,0x7e6d0f4b,0x00000000}},	//   онно_, ќино, knap,
  { {0x1fc60394,0xd9ff0053,0xc049009a,0x00000000}},	//   वर्ड, ोजित_, _דז_,
  { {0xd4350021,0x7e6d1c7e,0x200a1c7f,0x00000000}},	//   _يعتب, dnap, tebi_,
  { {0x7e6d1c80,0xe8000042,0x24180085,0x00000000}},	//   enap, ल्पा_, _ночы_,
  { {0x7bce1c81,0xb5fd0195,0xa0a303e5,0x00000000}},	//   _rebu, enši, тард,
  { {0x7bce014f,0x7bdc01da,0x7e6d1c82,0x00000000}},	//   _sebu, _sdru, gnap,
  { {0xd59a0041,0x6abc1c83,0x6aae1c84,0x00000000}},	// [2a80] ַבעל, _strf, _subf,
  { {0x7e6d002c,0xb17b00a5,0xfce30d0a,0x00000000}},	//   anap, rgåt, тофо,
  { {0xddc60121,0x5f76005d,0x28e00042,0x00000000}},	//   _обни, _زادر, _निहि,
  { {0x533600b5,0x7bce1c85,0x1bf00042,0x00000000}},	//   ונען_, _webu, _चावल_,
  { {0x644f001c,0x7bce1c86,0x7c49013d,0x00000000}},	//   īcij, _tebu, ásró,
  { {0x7bdc017f,0xdb24003b,0x7e640072,0x00000000}},	//   _udru, ăsân, liip,
  { {0x2bc4016a,0x61fd00ac,0x62840078,0x00000000}},	//   _ल्या, yfsl, _okio,
  { {0x44200469,0x8c3b004d,0x15140330,0x00000000}},	//   _şi_, _wußt, едия,
  { {0x6d440397,0x7c3c1c87,0xf3f10013,0x00000000}},	//   nyia, _korr, hịu_,
  { {0x03f80001,0xdb1c0205,0x628405b3,0x00000000}},	//   чној_, _berø, _akio,
  { {0x7c3c1c88,0x7e6d1c89,0x17790085,0x00000000}},	//   _morr, ynap, _есць_,
  { {0x68ed0812,0x7546005a,0x63ad1c8a,0x00000000}},	//   žodž, _онез, _şant,
  { {0x61f40024,0x7c3c0104,0x61fd1c8b,0x00000000}},	//   _želá, _oorr, rfsl,
  { {0x7c3c1c8c,0x20840044,0x30840044,0x00000000}},	//   _norr, َلَّ, َلَف,
  { {0x9f5f005b,0xe3b8005b,0x7522004a,0x00000000}},	//   _ürün_, mcı_, _hroz,
  { {0x7e6d0035,0x91690013,0x443c1c8d,0x00000000}},	//   unap, _lửa_, _hov_,
  { {0x7c3c0d0f,0x7e6d1c8e,0xb5fd1840,0x00000000}},	// [2a90] _borr, rnap, niša,
  { {0xe3b8005b,0x2ca71c8f,0x7c3c1292,0x00000000}},	//   ncı_, önd_, _corr,
  { {0x7c3c035a,0x660200c2,0x443c1c90,0x00000000}},	//   _dorr, _obok, _mov_,
  { {0x60cd1c91,0xddeb007e,0xddc4000c,0x00000000}},	//   _kwam, _برده_, rniţ,
  { {0xa803005b,0x644804aa,0xb90b009e,0x00000000}},	//   _çıkt, kkdi, تزام_,
  { {0x68eb016d,0x9169008b,0x60cd0035,0x00000000}},	//   rugd, _cửa_, _mwam,
  { {0xddc400c3,0x98bf005b,0x39491867,0x00000000}},	//   lniš, ırım_, šas_,
  { {0x7c3c1c92,0xddc4007d,0x83fc007d,0x00000000}},	//   _zorr, oniš, viđa,
  { {0xc8f4005a,0x75221806,0x6e3d12a9,0x00000000}},	//   _изтъ, _croz, _mosb,
  { {0xe1ff0022,0x20cd1581,0xe5760085,0x00000000}},	//   onów_, dži_, эзы_,
  { {0x443c0a02,0x63ad1c93,0xddc400c2,0x00000000}},	//   _dov_, _şans, hniš,
  { {0xf0890063,0x75221c94,0x64480058,0x00000000}},	//   _הנ_, _froz, akdi,
  { {0x321e0080,0xddc402f7,0x75221c95,0x00000000}},	//   ěty_, jniš, _groz,
  { {0x443c1c96,0xddc402e2,0x661b1c97,0x00000000}},	//   _gov_, dniš, lduk,
  { {0x6e3d006f,0x75220a14,0x20cd1844,0x00000000}},	//   _bosb, _zroz, aži_,
  { {0x8236006a,0x7d060089,0x661b1c98,0x00000000}},	//   _سربا, _ppks, nduk,
  { {0x6e3d001f,0x1d071259,0xb05b0072,0x00000000}},	// [2aa0] _dosb, нети_, mpän,
  { {0x31570047,0xe0fb0063,0x661b0072,0x00000000}},	//   _ניין_, _צליל, hduk,
  { {0x7c3c1c99,0x4ff70047,0x9169008d,0x00000000}},	//   _vorr, _אזיע_, _rửa_,
  { {0xddc40198,0x78a800c7,0x7ae30027,0x00000000}},	//   bniš, _sidv, ánta,
  { {0xdb1e1c9a,0xe3b80058,0xc9831c9b,0x00000000}},	//   lapü, ycı_, луши,
  { {0x260a0013,0xb5fd1c9c,0x98a31c9d,0x00000000}},	//   _ẹo_, viša, гиче,
  { {0x09e6019d,0x7522004c,0x6aa91276,0x00000000}},	//   _повн, _sroz, _fief,
  { {0x75221c9e,0xe8fa0002,0x201a08f2,0x00000000}},	//   _proz, _нлб_, _lapi_,
  { {0x7d1b017d,0x78a808a9,0xc8ca014d,0x00000000}},	//   _áust, _tidv, _روان_,
  { {0x201a000f,0x07a615d4,0x78250021,0x00000000}},	//   _napi_, _зазн, _لعمل,
  { {0xddc408ea,0x60cd1c9f,0x2caa006d,0x00000000}},	//   zniš, _swam, _mibd_,
  { {0x75221ca0,0xb5fd114b,0xd377000d,0x00000000}},	//   _troz, lišn, эчы_,
  { {0x44f900cd,0x6e3d1ca1,0x865b009a,0x00000000}},	//   cè_, _rosb, _צדדי,
  { {0x201a1ca2,0xddc4027c,0x20cd074f,0x00000000}},	//   _capi_, vniš, rži_,
  { {0x6e3d00e8,0x141b0063,0x2ef50062,0x00000000}},	//   _posb, _מוגב, ъзвр,
  { {0xddc408ea,0x6d1c0042,0x9f60009c,0x00000000}},	//   tniš, निंग_, árát_,
  { {0x22ac0080,0x31350571,0x6aa91ca3,0x00000000}},	// [2ab0] _věku_, _репр, _rief,
  { {0xddc408ea,0xb5fd007d,0xb05b0072,0x00000000}},	//   rniš, jišn, ysäy,
  { {0xb5fd1ca4,0x99f5000d,0xcfb60063,0x00000000}},	//   dišn, вялі, _בלתי_,
  { {0xddc400b2,0xee210054,0xe1ff0022,0x00000000}},	//   pniš, _темi_, rnów_,
  { {0x9dd60047,0xb5fd0195,0xdfa7005d,0x00000000}},	//   _בורק_, inšt, _تحکي,
  { {0x7ae2008f,0x201a1ca5,0x64860014,0x00000000}},	//   ņota, _xapi_, iðis,
  { {0x6aa900bd,0x3946002c,0xe3b1007e,0x00000000}},	//   _tief, ayos_, یرد_,
  { {0x44f901a8,0xdb1e01a8,0x6b830244,0x00000000}},	//   tè_, aapó, üngu,
  { {0x44f90268,0xf4950121,0x661b0b38,0x00000000}},	//   uè_, крою, rduk,
  { {0x76491258,0x661b1ca6,0xe5040044,0x00000000}},	//   skey, sduk, ابيي,
  { {0x201a0397,0x35f5000d,0x95d90121,0x00000000}},	//   _rapi_, _апер, _ждет_,
  { {0x201a00f3,0x216a07da,0x3ce906f1,0x00000000}},	//   _sapi_, дими_, krav_,
  { {0x21240025,0x201a1ca7,0xe5350062,0x00000000}},	//   ímh_, _papi_, _шедь,
  { {0x3a3f1ca8,0xb05b0354,0xdcee008f,0x00000000}},	//   _loup_, spän, ūdīg,
  { {0xfc3f1088,0xe1ff006d,0xb05b0050,0x00000000}},	//   _luís_, mión_, ppän,
  { {0x201a0035,0xe1ff1ca9,0x2ee50014,0x00000000}},	//   _wapi_, lión_, álfa_,
  { {0x201a014f,0x3eab1caa,0xbea31cab,0x00000000}},	// [2ac0] _tapi_, _dict_, ратк,
  { {0xe1ff02dd,0x8b26000d,0xe572009a,0x00000000}},	//   nión_, кдзе, בַע_,
  { {0x8fa60635,0xb5fd007d,0x3ce900a5,0x00000000}},	//   _јане, višn, arav_,
  { {0xc332014e,0x3a3f1cac,0x2fd800cd,0x00000000}},	//   יוב_, _coup_, larg_,
  { {0xdb1e0026,0x3946006d,0x3ea01cad,0x00000000}},	//   tapó, uyos_, mmit_,
  { {0xdb1c000f,0xb7d80021,0xfbc30002,0x00000000}},	//   _kerü, روبا_, _вбро,
  { {0xc7b8007d,0x7c2e1cae,0x8c1b0063,0x00000000}},	//   _nađe_, _inbr, _קולי,
  { {0xdb1c00ea,0x96b7005e,0xeb971caf,0x00000000}},	//   _merü, њују_, _рис_,
  { {0xb5fd01b3,0x22920014,0xca750085,0x00000000}},	//   mišl, tákn_, _суры,
  { {0xe1ff1cb0,0x9f58006d,0x6264013d,0x00000000}},	//   gión_, neró_, sőol,
  { {0x225200e8,0x9f580080,0x25bd002b,0x00000000}},	//   _blyk_, terý_, _ffwl_,
  { {0xacbb0164,0xdb1c1cb1,0x26da004c,0x00000000}},	//   _brûl, _heró, ápou_,
  { {0x7c2e006f,0xb5fd004c,0x92580062,0x00000000}},	//   _onbr, rnšt, таят_,
  { {0xe1ff0814,0xdb1c1cb2,0x64860026,0x00000000}},	//   ción_, _berü, rðis,
  { {0x9f58006d,0xeeab0086,0x9f660014,0x00000000}},	//   deró_, дтак_, óuðu_,
  { {0x7c2e1cb3,0x645d001c,0x6dc40121,0x00000000}},	//   _anbr, īsie, исуж,
  { {0xb5fd0066,0x3a3f1cb4,0x645d008f,0x00000000}},	// [2ad0] dišl, _roup_, ūsie,
  { {0x7ae31919,0x3ea01cb5,0x3a3f00e5,0x00000000}},	//   ánto, amit_, _soup_,
  { {0x3ea01269,0xfc3f00cd,0xdb1c004d,0x00000000}},	//   bmit_, _suís_, _gerü,
  { {0x3ce900c3,0xd7f8000c,0xb21b00b9,0x00000000}},	//   prav_, _acă_, mlæs,
  { {0x26de00c2,0xdce7008f,0x9f580331,0x00000000}},	//   _avto_, īmēt, beró_,
  { {0xe1ff02dd,0x20111052,0x9f5801a8,0x00000000}},	//   xión_, nezi_, ceró_,
  { {0x20110035,0x27e9005b,0xef120063,0x00000000}},	//   iezi_, ğan_, ֶּה_,
  { {0x27e901f7,0x2011003b,0xa91d017c,0x00000000}},	//   şan_, hezi_, _lyži,
  { {0x2a64011c,0x9f580290,0x20110b88,0x00000000}},	//   _търг, nerò_, kezi_,
  { {0x69d91cb6,0x98a4005e,0x2011013d,0x00000000}},	//   lawe, _виђе, jezi_,
  { {0xe1ff006d,0x3ea000fe,0xf2a602b3,0x00000000}},	//   rión_, ymit_, лиоп,
  { {0xe1ff048e,0xb21b0146,0x69d91cb7,0x00000000}},	//   sión_, dlæs, nawe,
  { {0x64860026,0xe1ff0331,0xd5ae01fb,0x00000000}},	//   rðir, pión_, _عفو_,
  { {0xdb050025,0x9f580290,0x69d9083f,0x00000000}},	//   nchó, derò_, hawe,
  { {0x2d8f00bd,0x53320002,0x2eb50b3f,0x00000000}},	//   ügen_, _гејт, истс,
  { {0x229900ea,0x69d91cb8,0xdb1c004d,0x00000000}},	//   téke_, jawe, _verü,
  { {0xed571cb9,0x9f58006d,0x7bd51cba,0x00000000}},	// [2ae0] гот_, teró_, _bezu,
  { {0xdb1c000f,0x09cc0053,0x3ea0001c,0x00000000}},	//   _terü, ार्य, smit_,
  { {0x272301f7,0x5f460021,0x60db008f,0x00000000}},	//   _nın_, _إنجل, šumt,
  { {0x24851cbb,0x9f41006d,0x62861cbc,0x00000000}},	//   holm_, _echó_, noko,
  { {0x9f580118,0xb5fd0a80,0xdb1c1cbd,0x00000000}},	//   peró_, rišl, _peró,
  { {0xd9430138,0xddcd0051,0x7d16002b,0x00000000}},	//   сељи, chał, mwys,
  { {0x60c40290,0xdb1c1cbe,0x7d16001f,0x00000000}},	//   _ltim, _veró, lwys,
  { {0x60c40016,0x2011003b,0x60dd04aa,0x00000000}},	//   _otim, zezi_, yssm,
  { {0x2956005a,0x7d161cbf,0xb21b0205,0x00000000}},	//   _съвр, nwys, klær,
  { {0xb7b5008b,0x3cfb0047,0x61e41cc0,0x00000000}},	//   _hạn, עלינ, _adil,
  { {0x60c40078,0x22590121,0x7d16002b,0x00000000}},	//   _atim, вины_, hwys,
  { {0x20110009,0xe452006a,0x88c7004c,0x00000000}},	//   wezi_, _گفتگ, směš,
  { {0x61e40185,0xb7b5001b,0x20111cc1,0x00000000}},	//   _ddil, _mạn, tezi_,
  { {0x61e401f7,0xf5930032,0x7d1600ac,0x00000000}},	//   _edil, _الهج, dwys,
  { {0xa91d0024,0x69d90035,0x7d1600ac,0x00000000}},	//   _vyži, yawe, ewys,
  { {0x7d161cc2,0x24490014,0x20111cc3,0x00000000}},	//   fwys, _rúmi_, sezi_,
  { {0xdb0500bd,0x320900a4,0x629f00cd,0x00000000}},	// [2af0] schü, _ibay_, _èpoq,
  { {0x69d916ae,0x69c01cc4,0x6bd40021,0x00000000}},	//   wawe, _afme, متمر,
  { {0x7bd5007d,0x69d91cc5,0x9f350054,0x00000000}},	//   _vezu, tawe, _тені,
  { {0x7f3a0047,0xb7b5008b,0x9f58197c,0x00000000}},	//   _סערו, _cạn, però_,
  { {0xb7b5001b,0xe0df0290,0x80a4007e,0x00000000}},	//   _dạn, nsò_, _خمین,
  { {0xb346005b,0xe8000053,0x62861cc6,0x00000000}},	//   _kaçı, ल्ला_, zoko,
  { {0xe7390928,0x9169008b,0x62861cc7,0x00000000}},	//   тей_, _lừa_, yoko,
  { {0xb5fd17b8,0x24520003,0x8aa41cc8,0x00000000}},	//   mišk, _râma_, _груд,
  { {0xf1c80080,0xb5fd17d2,0x62861cc9,0x00000000}},	//   ndář_, lišk, voko,
  { {0x6286056c,0xb4650a30,0x4465129d,0x00000000}},	//   woko, ркол, рвов,
  { {0xe29a0001,0x2129053b,0xb5fd17d2,0x00000000}},	//   као_, _arah_, nišk,
  { {0xe1260121,0x8c44003b,0x7d16002b,0x00000000}},	//   амми, ăşit, ywys,
  { {0x2d8f00bd,0xb5fd00c2,0x62861cca,0x00000000}},	//   ügel_, hišk, roko,
  { {0x32091ccb,0x9f58007a,0xb5fd0006,0x00000000}},	//   _ebay_, ferð_, kišk,
  { {0x9f58007a,0xb5fd1ccc,0x25bf003b,0x00000000}},	//   gerð_, višj, ocul_,
  { {0x25bf06a7,0x201e0006,0xb5fd00fc,0x00000000}},	//   ncul_, žti_, dišk,
  { {0xb21b0031,0xbc66000d,0xb5fd0078,0x00000000}},	// [2b00] plær, авак, eišk,
  { {0x7d16021f,0xb5fd17d2,0x64431ccd,0x00000000}},	//   rwys, fišk, _joni,
  { {0xe9da14cf,0x7d1600ac,0xb5fd0006,0x00000000}},	//   вке_, swys, gišk,
  { {0x6287007d,0x536c0041,0xa9261cce,0x00000000}},	//   čkog, עכאַ, идел,
  { {0xb5fd0006,0xd378007d,0x6aa21ccf,0x00000000}},	//   aišk, maće_, rmof,
  { {0xdb1c0026,0xb5fd17b8,0x1c020042,0x00000000}},	//   _ferð, bišk, र्शल_,
  { {0xdb1c007a,0xd6d703e6,0x475a0062,0x00000000}},	//   _gerð, аты_, ърдя_,
  { {0xddcd1cd0,0x96341cd1,0x7ae3003b,0x00000000}},	//   mnaţ, сниц, ânte,
  { {0x64430dd1,0xd90e007e,0xe944007e,0x00000000}},	//   _boni, _آیت_, _ارزی,
  { {0xddcd000c,0x656f0025,0xc34a0062,0x00000000}},	//   onaţ, úcha, вяме_,
  { {0x0bb7014e,0x6f090045,0x84330086,0x00000000}},	//   ילים_, łecz, інює,
  { {0x9f580014,0x21291cd2,0xf5060200,0x00000000}},	//   verð_, _prah_, _вздо,
  { {0xdfdb011c,0xc6930063,0xd378007d,0x00000000}},	//   къв_, _ואף_, daće_,
  { {0xd48f0086,0xe0df0290,0x9169008b,0x00000000}},	//   _єр_, rsò_, _vừa_,
  { {0xe0df0682,0xb05b00fe,0xaf34007e,0x00000000}},	//   ssò_, npäi, يرفت,
  { {0x443e0137,0xb5fd17b8,0x3eaf0137,0x00000000}},	//   ljt_, višk, ögt_,
  { {0x656d0024,0xdbd10026,0x212900c3,0x00000000}},	// [2b10] _ľahk, _býðu, _urah_,
  { {0xb5fd00eb,0xa8020058,0x606400de,0x00000000}},	//   tišk, çıla, _وهيل,
  { {0xf2d300b5,0x6aa3006f,0x2d870051,0x00000000}},	//   ַעס_, ïnfo, łne_,
  { {0xdb1c0ac6,0xb5fd1cd3,0xc7b8007d,0x00000000}},	//   _verð, rišk, _rađa_,
  { {0xb5fd0006,0x645a0e83,0xdb1c00a3,0x00000000}},	//   sišk, khti, _ffrï,
  { {0x89340754,0x7e6d1cd4,0x26110013,0x00000000}},	//   تعما, liap, _ạo_,
  { {0xe1ff013d,0x9b45005d,0xd7f8076f,0x00000000}},	//   giók_, _انزو, руч_,
  { {0x64431cd5,0x645a0ff2,0x7e6d1cd6,0x00000000}},	//   _soni, ehti, niap,
  { {0x6d4d014f,0xd5490076,0x64431cd7,0x00000000}},	//   nyaa, уппе_, _poni,
  { {0x645a1cd8,0x628d0035,0x25bf1cd9,0x00000000}},	//   ghti, _akao, scul_,
  { {0xd7950032,0xe1ff00ea,0x6443147f,0x00000000}},	//   _الاخ, ciók_, _voni,
  { {0xc0491cda,0x64431cdb,0x443e007d,0x00000000}},	//   _אז_, _woni, ajt_,
  { {0xd378007d,0xa9790041,0x7e6d1cdc,0x00000000}},	//   vaće_, ראָכ, diap,
  { {0x645a1cdd,0x4613007e,0x305501ce,0x00000000}},	//   chti, _دوچر, ођст,
  { {0x8c3b004d,0xd378007d,0x7d0f013d,0x00000000}},	//   _fußz, taće_, _apcs,
  { {0x7e6d1cde,0x3392005d,0x92650044,0x00000000}},	//   giap, _عليز, _وديم,
  { {0xd378007d,0xe1ff013d,0x80b20042,0x00000000}},	// [2b20] raće_, ziók_, _इंटे,
  { {0x3ce00f8c,0x8f761cdf,0x00000000,0x00000000}},	//   rsiv_, _гумі,   ,
  { {0x6d4d014f,0xeafa007e,0xddc4003b,0x00000000}},	//   ayaa, طرات_, chiş,
  { {0xeb970b0f,0xddcd000c,0x99dd0066,0x00000000}},	//   щих_, rnaţ, _poňa,
  { {0x2d840164,0x645a00fe,0xdd920049,0x00000000}},	//   _âme_, yhti, _روس_,
  { {0x98730085,0xa91d0078,0x99dd017c,0x00000000}},	//   пліц, _ryžt, _voňa,
  { {0xf743000a,0x39520006,0x6b6313c6,0x00000000}},	//   зејо, šys_, _екра,
  { {0xdb1c00c7,0xceb30063,0x6e241ce0,0x00000000}},	//   _berö, היה_, ndib,
  { {0xb05b00fe,0x645d001c,0x7d041ce1,0x00000000}},	//   späi, īsin, ntis,
  { {0x14b70032,0xb05b00fe,0x7bde1acc,0x00000000}},	//   حديث_, ppäi, napu,
  { {0x53980086,0x7e6d0150,0x9f45005b,0x00000000}},	//   рвня_, yiap, ülü_,
  { {0x7ae3006d,0x68e21ce2,0x9169008b,0x00000000}},	//   ánti, osod, _nữa_,
  { {0xc05b0086,0x60d6001f,0x68e21ce3,0x00000000}},	//   гів_, _cwym, nsod,
  { {0xd3ba0086,0xdb1c0014,0x7d0400e0,0x00000000}},	//   _суді_, _afrí, dtis,
  { {0x7e6d0089,0x91690013,0xe3b80058,0x00000000}},	//   tiap, _bữa_, ndım_,
  { {0x33770063,0x7d1d1ce4,0xdceb14cb,0x00000000}},	//   _לתוך_, _psss, žičk,
  { {0x60d6002b,0x7d04013d,0x68e200a8,0x00000000}},	// [2b30] _gwym, gtis, jsod,
  { {0x7e6d0397,0x7bde1ce5,0xb5fd1ce6,0x00000000}},	//   siap, gapu, riši,
  { {0x6d4d0089,0x68e2002b,0xd011005d,0x00000000}},	//   syaa, esod, _فلک_,
  { {0xb5fd02e2,0x7bde0072,0x02fb0047,0x00000000}},	//   piši, aapu, רלאמ,
  { {0xe9d80088,0x645802dd,0xab62005b,0x00000000}},	//   скі_, _olvi, _çünk,
  { {0x6829013d,0xe9d90022,0xa6c91ce7,0x00000000}},	//   ködő, _weź_, алка_,
  { {0xf7420062,0x07a2150f,0x70b50053,0x00000000}},	//   дещо, машн, ंदुल,
  { {0x245b03b2,0x79960051,0xdb1c001f,0x00000000}},	//   _même_, żywa, _ffrâ,
  { {0x69db001f,0xe1ff0758,0xe4590794,0x00000000}},	//   _ieue, ciói_, ижи_,
  { {0xdb1c00bd,0x130905ac,0x60d600a3,0x00000000}},	//   _verö, аной_, _rwym,
  { {0xe1ff0022,0x60d60022,0xd6390085,0x00000000}},	//   niów_, _swym, _вялі_,
  { {0x7de6000f,0xdb1c005b,0x7d041ce8,0x00000000}},	//   _késő, _terö, ytis,
  { {0x7bde1ce9,0x69db00cd,0x3eba00dd,0x00000000}},	//   yapu, _meue, _supt_,
  { {0x9f580164,0x68e40025,0x66090089,0x00000000}},	//   lgré_, áidi, lfek,
  { {0xe29a1cea,0xdb1c017d,0x75291ceb,0x00000000}},	//   _как_, _jerô, lvez,
  { {0x69db0199,0x7d040bcf,0x7529082a,0x00000000}},	//   _neue, ttis, ovez,
  { {0xe0d20032,0x7bde1cec,0x7659001f,0x00000000}},	// [2b40] _غزة_, tapu, _mlwy,
  { {0x76590185,0x7c96000d,0xe3b80058,0x00000000}},	//   _llwy, ірац, ydım_,
  { {0x3bd50076,0xda660086,0x20181ced,0x00000000}},	//   яютс, овжи, meri_,
  { {0x20181cee,0x7ff6007e,0x7ae3003b,0x00000000}},	//   leri_, _اسکا, ânta,
  { {0x7bde1acc,0x69db00cd,0xcaa50021,0x00000000}},	//   papu, _deue, أصلي,
  { {0xab2a1b76,0x752900ea,0x7659002b,0x00000000}},	//   _кога_, dvez, _alwy,
  { {0xf8bf02b0,0x7659001f,0x69db1cef,0x00000000}},	//   _één_, _blwy, _feue,
  { {0xe3b801f7,0x7659001f,0x7bdc1cf0,0x00000000}},	//   rdım_, _clwy, _heru,
  { {0x7bdc0397,0x2018005b,0xdb210072,0x00000000}},	//   _keru, keri_, ätös,
  { {0xb05b00fe,0xddc41cf1,0x20181cf2,0x00000000}},	//   npät, jniž, jeri_,
  { {0x76590185,0x7bdc014f,0xdb0500bd,0x00000000}},	//   _flwy, _meru, schö,
  { {0x644100e3,0x752908ea,0xbddb0164,0x00000000}},	//   ajli, bvez, _poèm,
  { {0x290600fe,0xe3b8005b,0xddcd004c,0x00000000}},	//   ntoa_, ndık_, chař,
  { {0x20180397,0x3a241cf3,0x6fd90022,0x00000000}},	//   geri_, _lamp_, dźcó,
  { {0xcddb018e,0x6abc0089,0xff04026c,0x00000000}},	//   иња_, _nurf, мятн,
  { {0x7bdc1423,0xb5fd0078,0x00000000,0x00000000}},	//   _aeru, sišv,   ,
  { {0x7bdc1b18,0x20181cf4,0x8cf5000d,0x00000000}},	// [2b50] _beru, beri_, язац,
  { {0x7bdc000c,0x2018000c,0x69db0295,0x00000000}},	//   _ceru, ceri_, _seue,
  { {0x2001162d,0x7bdc1cf5,0x29060072,0x00000000}},	//   _ichi_, _deru, etoa_,
  { {0x61fd1c2d,0x6abc05e4,0xd959000d,0x00000000}},	//   ngsl, _durf, йшлі_,
  { {0x61fd1cf6,0x3ea901a5,0x69db00cd,0x00000000}},	//   igsl, mmat_, _veue,
  { {0xd8220076,0x7bdc1466,0xb5fd00c2,0x00000000}},	//   едши, _geru, hišt,
  { {0x7bc50025,0xf6510021,0x7659002b,0x00000000}},	//   mchu, فئة_, _plwy,
  { {0xe9df0ac6,0x3a24001f,0xb5fd1cf7,0x00000000}},	//   _þú_, _gamp_, jišt,
  { {0xb5fd0743,0x2001000c,0x5a34000d,0x00000000}},	//   dišt, _ochi_, _ўнут,
  { {0x20010009,0x7529000f,0x3ea9003e,0x00000000}},	//   _nchi_, rvez, hmat_,
  { {0x7bc500bd,0x3ea90360,0x20181cf8,0x00000000}},	//   ichu, kmat_, veri_,
  { {0xb05b0024,0x7bc50025,0x61fd00d1,0x00000000}},	//   zpät, hchu, ggsl,
  { {0x3ea900e3,0x55ba0063,0x20181cf9,0x00000000}},	//   dmat_, _המנו, teri_,
  { {0x394000fe,0xd00a005e,0x9fc7005e,0x00000000}},	//   äisi_, љеве_, згра_,
  { {0x602f0006,0x200500cd,0x20181cfa,0x00000000}},	//   dėmė, òlia_, reri_,
  { {0x7bdc070e,0x20181cfb,0x75f60058,0x00000000}},	//   _seru, seri_, müzü,
  { {0x20181cfc,0x6abc13b7,0x0d9a000d,0x00000000}},	// [2b60] peri_, _surf, ствы_,
  { {0x7bc50025,0xee3f0066,0x3ea901a9,0x00000000}},	//   gchu, _chýb_, amat_,
  { {0x68f9006f,0xddc40051,0x6f0c003b,0x00000000}},	//   euwd, oniż, încă,
  { {0x290600fe,0x82d60047,0x7bc50022,0x00000000}},	//   ttoa_, פונג_, achu,
  { {0x7bdc1cfd,0xb05b0072,0x7ae504aa,0x00000000}},	//   _teru, mpär, asht,
  { {0x6e2600bb,0x290600fe,0x7c5a0021,0x00000000}},	//   _hakb, rtoa_, _السر_,
  { {0x2906024a,0xc66a0076,0xdb830699,0x00000000}},	//   stoa_, йшие_, _згри,
  { {0x6e260051,0xb866007e,0xe6630086,0x00000000}},	//   _jakb, _کارو, етьо,
  { {0xb5fd1cfe,0xa7b60092,0xc7b8008d,0x00000000}},	//   eišs, _есеј, _tgđ_,
  { {0x6e261cff,0x22490168,0x29130043,0x00000000}},	//   _lakb, _soak_, _سومآ,
  { {0xb5fd1aa5,0xe9ff0013,0x68ec005f,0x00000000}},	//   tišt, _hoạn_, žodį,
  { {0x6e260089,0x76bb0063,0x22440044,0x00000000}},	//   _nakb, _המאפ, ّنَّ,
  { {0xb5fd0117,0x61fd1d00,0x32191d01,0x00000000}},	//   rišt, rgsl, resy_,
  { {0xb97b009a,0xa2ca04ef,0xf044014b,0x00000000}},	//   מרכז, _луиз_, нэсо,
  { {0xb5fd0080,0x9f340086,0xe9ff008b,0x00000000}},	//   pišt, нері, _loạn_,
  { {0x644a0917,0x5f940690,0x7bc5002b,0x00000000}},	//   _hofi, хист, wchu,
  { {0x628f0024,0x3ea91d02,0x200e005f,0x00000000}},	// [2b70] moco, rmat_, _ūkių_,
  { {0x7bc51d03,0xe1ff006d,0x628f1d04,0x00000000}},	//   uchu, lgó_, loco,
  { {0xe7a5001c,0x7bc51d05,0x7b6710f6,0x00000000}},	//   ādīš, rchu, чтае,
  { {0xe1ff1d06,0x7bc51d07,0x68ed00ea,0x00000000}},	//   ciót_, schu, áado,
  { {0xa954019d,0xddd6017c,0x08c40054,0x00000000}},	//   нкці, dkyň, ебін,
  { {0xf770006a,0x60cd0035,0x644a001f,0x00000000}},	//   گاه_, _mtam, _nofi,
  { {0xab950086,0xe1ff056d,0x572400f2,0x00000000}},	//   _циві, niós_, فريق,
  { {0x60cd00fe,0x2a7f07b7,0xb882013d,0x00000000}},	//   _otam, _ujub_, áírj,
  { {0x68e40027,0xad9b0066,0x644a1d08,0x00000000}},	//   áidt, _zbúr, _bofi,
  { {0x61ed1d09,0x644a0185,0x43750002,0x00000000}},	//   _adal, _cofi, думт,
  { {0x58840088,0x60cd005b,0x628700c2,0x00000000}},	//   _чыта, _atam, čkon,
  { {0xd7f8003b,0x442b0022,0xb5fd017c,0x00000000}},	//   _umăr_, śc_, rišs,
  { {0x98a4000c,0x61ed001f,0x2bfe0053,0x00000000}},	//   _urmă_, _ddal, _लालू_,
  { {0x644a001f,0x7c270f6a,0x661b1d0a,0x00000000}},	//   _gofi, _najr, leuk,
  { {0x92e80032,0xe1ff00cd,0xcec40080,0x00000000}},	//   _فريق_, giós_, daří_,
  { {0x44271d0b,0x644a1d0c,0xf1bf0260,0x00000000}},	//   _han_, _zofi, ndál_,
  { {0xfce30055,0x44271d0d,0x6e26006f,0x00000000}},	// [2b80] кото, _kan_, _vakb,
  { {0xb05b0019,0x61ed1959,0x2ca70782,0x00000000}},	//   spär, _zdal, дкуп_,
  { {0x661b00fe,0x6e261d0e,0xe9ff008b,0x00000000}},	//   keuk, _takb, _soạn_,
  { {0xe1ff0051,0x9208001c,0x44271d0f,0x00000000}},	//   chód_, _frāž, _lan_,
  { {0x44271d10,0xddc40078,0x09e31d11,0x00000000}},	//   _oan_, snių, точн,
  { {0x7afa0137,0xd943005e,0x44271d12,0x00000000}},	//   _åtto, тељи, _nan_,
  { {0x644a1d13,0xe73702f8,0xc7b00044,0x00000000}},	//   _rofi, деј_, دّث_,
  { {0x4427182f,0x68e40139,0x764b002b,0x00000000}},	//   _aan_, áids, _cogy,
  { {0xd7cf0053,0x628f00ed,0xc6a30062,0x00000000}},	//   _स्वच, voco, ърши,
  { {0x442703ae,0xddd60066,0x628f0022,0x00000000}},	//   _can_, skyň, woco,
  { {0x4427014f,0x68e91d14,0x60cd1d15,0x00000000}},	//   _dan_, _zved, _stam,
  { {0x92580076,0x44270025,0xc7b8007d,0x00000000}},	//   дают_, _ean_, _nađi_,
  { {0xe1ff1919,0x628f1d16,0x84460021,0x00000000}},	//   rgó_, roco, _يختل,
  { {0xa3df0161,0x628f1d17,0x44271d18,0x00000000}},	//   तरण_, soco, _gan_,
  { {0x764b00f3,0x626b0080,0xe580008f,0x00000000}},	//   _yogy, dřov, šķā_,
  { {0xe1ff00cd,0x2cb80025,0x61ed1d19,0x00000000}},	//   riós_, _aird_, _udal,
  { {0xce94005a,0x60cd1d1a,0x2cb81d1b,0x00000000}},	// [2b90] татъ, _utam, _bird_,
  { {0x69c9006f,0x8235007e,0x2299013d,0x00000000}},	//   _sfee, _آرژا, déki_,
  { {0x649400cd,0x68e91d1c,0xe945005d,0x00000000}},	//   làis, _sved, کرای,
  { {0xdb0e00ea,0xdd91007e,0xddcd0022,0x00000000}},	//   áján, _موج_, skał,
  { {0xcce70032,0xe6ed0024,0x661b0130,0x00000000}},	//   _تسجي, _väčš, veuk,
  { {0xa1580063,0x07a505f9,0xc7a50e82,0x00000000}},	//   ובדה_, налн, нилк,
  { {0x44271d1d,0x3eb900ca,0xf773014d,0x00000000}},	//   _ran_, _kist_, خاش_,
  { {0x1995000d,0x44271d1e,0x2d990072,0x00000000}},	//   _забя, _san_, _kyse_,
  { {0xe5790076,0x68e90114,0x44271d1f,0x00000000}},	//   язи_, _uved, _pan_,
  { {0x3eb91d20,0xe3b1005d,0x9cd6009a,0x00000000}},	//   _list_, ُرد_, עותה_,
  { {0x44271d21,0x8707007e,0xe29a1d22,0x00000000}},	//   _van_, _زبال, зан_,
  { {0x44271d23,0x3eb91d24,0x2378013d,0x00000000}},	//   _wan_, _nist_, úrja_,
  { {0xdb1c00c7,0xc19a0054,0x44271d25,0x00000000}},	//   _ifrå, ятої_, _tan_,
  { {0x442701a8,0x32040022,0x76460050,0x00000000}},	//   _uan_, żmy_, ökyv,
  { {0x3eb900bd,0x322900fe,0x68ed00ea,0x00000000}},	//   _bist_, ötyä_, áadj,
  { {0xf7720041,0x3eb91d26,0x6cd60044,0x00000000}},	//   אקל_, _cist_, فقرا,
  { {0x626b0080,0x3eb91276,0x63a60022,0x00000000}},	// [2ba0] třov, _dist_, ękne,
  { {0x3eb9006f,0x4f261d27,0xf2e6005d,0x00000000}},	//   _eist_, _здоб, _تکیه_,
  { {0xb346017d,0x20c60013,0x5fdb0063,0x00000000}},	//   maçõ, _hôi_, _מחיק,
  { {0x2cb80cd4,0xb3460016,0x88e60ac5,0x00000000}},	//   _wird_, laçõ, ежде,
  { {0xa3df0053,0x92690041,0x626b011b,0x00000000}},	//   तरा_, ובאַ_, přov,
  { {0xeee7006a,0xb3460016,0x20c6008b,0x00000000}},	//   _تغیی, naçõ, _môi_,
  { {0x20c6008b,0x8ba30121,0x44dd0066,0x00000000}},	//   _lôi_, _бирж, eň_,
  { {0x963400fb,0x3546080a,0x95ca1d28,0x00000000}},	//   тниц, ехов, чука_,
  { {0xd4060086,0xddcd003b,0x61e61d29,0x00000000}},	//   няни, liaţ, dakl,
  { {0x545406cb,0x6287007d,0xdbdf0014,0x00000000}},	//   твот, čkom, níði,
  { {0xb346017d,0xddcd003b,0xd7060054,0x00000000}},	//   daçõ, niaţ, _їзди,
  { {0x20c60013,0xa75b0063,0x78ba013d,0x00000000}},	//   _bôi_, _מדבר, _hitv,
  { {0xf1bf00ea,0x20c60013,0x3eb91d2a,0x00000000}},	//   ldák_, _côi_, _rist_,
  { {0xb3460016,0x3eb902f0,0x20051d2b,0x00000000}},	//   gaçõ, _sist_, üli_,
  { {0x61e61d2c,0x61f40137,0x78ba1d2d,0x00000000}},	//   bakl, ådlö, _mitv,
  { {0x61e6005b,0xddcd000c,0x645a00ca,0x00000000}},	//   cakl, diaţ, lkti,
  { {0x442c0185,0x3eb902ab,0x200c00cd,0x00000000}},	// [2bb0] odd_, _vist_, òdic_,
  { {0xb3460016,0x3eb90122,0x2bbb0021,0x00000000}},	//   caçõ, _wist_, ساطة_,
  { {0x2d9900e8,0x442c1b33,0x645a1d2e,0x00000000}},	//   _wyse_, idd_, ikti,
  { {0x7d09003b,0x7e641d2f,0x78ba005f,0x00000000}},	//   _ţesu, chip, _aitv,
  { {0x6e3d00bd,0x88c80086,0x7afe1d30,0x00000000}},	//   _insb, елів_, aupt,
  { {0xa3bc0053,0x645a006f,0x61e61d31,0x00000000}},	//   _अलग_, jkti, zakl,
  { {0xddcd000c,0x7d0d1d32,0x442c1d33,0x00000000}},	//   ciaţ, ltas, ddd_,
  { {0x442c0185,0xb3460016,0x7f3c0047,0x00000000}},	//   edd_, zaçõ, לעוו,
  { {0x0568000a,0x2c6400c7,0xc4850156,0x00000000}},	//   ејќи_, _född_, клик,
  { {0xcdaa0047,0x69d9004d,0xb34600be,0x00000000}},	//   ויפֿ, lbwe, xaçõ,
  { {0xd5d2016a,0xb3460016,0xb9040053,0x00000000}},	//   _ध्वज, vaçõ, भी_,
  { {0x27e70027,0x45d50612,0x442c1d34,0x00000000}},	//   lann_, _родс, add_,
  { {0xb3460016,0x69d900bd,0x320c0051,0x00000000}},	//   taçõ, ibwe, ędy_,
  { {0x7d0d010a,0x27e70027,0xdfd20021,0x00000000}},	//   dtas, nann_, شير_,
  { {0xb34603d9,0x24960021,0x5f060062,0x00000000}},	//   raçõ, _جنود_, ъзва,
  { {0x20c600aa,0xb3460016,0xdbc90019,0x00000000}},	//   _tôi_, saçõ, _mõõd,
  { {0xb346017d,0x27e70026,0x7d0d1d35,0x00000000}},	// [2bc0] paçõ, kann_, gtas,
  { {0x61e41d36,0x7e641d37,0xbc63000d,0x00000000}},	//   _heil, ship, авук,
  { {0xe3b8005b,0xbddb02a7,0x09e617e1,0x00000000}},	//   ldır_, _poèt, воен,
  { {0xddcd000c,0x60c40035,0x27e70025,0x00000000}},	//   riaţ, _kuim, eann_,
  { {0x442c0c70,0xe3b8005b,0x27e70137,0x00000000}},	//   ydd_, ndır_, fann_,
  { {0x27e71d38,0xddcd000c,0xcee9007e,0x00000000}},	//   gann_, piaţ, _ترین_,
  { {0x60c40025,0xa7fc005b,0x9183008b,0x00000000}},	//   _luim, _alıc, iếp_,
  { {0xdb1c0027,0x442c0185,0x61e41d39,0x00000000}},	//   _ngré, wdd_, _neil,
  { {0x60c40006,0x629d00b9,0x09060d34,0x00000000}},	//   _nuim, vlso, _шпан,
  { {0x78ba0102,0x27e70025,0xdb1c0164,0x00000000}},	//   _uitv, cann_, _agré,
  { {0x442c0185,0xa2b5005a,0x7d0d00ea,0x00000000}},	//   rdd_, лбоч, ztas,
  { {0xd378017f,0x442a00c2,0x645a00a4,0x00000000}},	//   naći_, žb_, skti,
  { {0x60c40025,0x83f80002,0x25a00139,0x00000000}},	//   _cuim, _зелс_, _áil_,
  { {0x2bfe0161,0x60c40104,0x3946021a,0x00000000}},	//   _लागू_, _duim, ixos_,
  { {0x61e41d3a,0x200c01a8,0x260f0042,0x00000000}},	//   _feil, òdia_, थ्वी_,
  { {0x7d0d1d3b,0x60c4006d,0x68ed007d,0x00000000}},	//   ttas, _fuim, šadi,
  { {0x6e2d1d3c,0x60c41510,0xf1c40061,0x00000000}},	// [2bd0] rdab, _guim, ášť_,
  { {0x7d0d1d3d,0x61e405e4,0x3f840058,0x00000000}},	//   rtas, _zeil, ğmur_,
  { {0xddc60051,0xda35000d,0x27e7129e,0x00000000}},	//   _dokł, лежы, vann_,
  { {0x27e700bd,0xc7ce0013,0x7d0d1d3e,0x00000000}},	//   wann_, uống_, ptas,
  { {0xe9d80088,0xee3f0024,0xf1bf0139,0x00000000}},	//   ткі_, _iný_, meád_,
  { {0x27e70025,0xd70905f4,0x66e5030b,0x00000000}},	//   uann_, енке_, гока,
  { {0xe3b8005b,0x27e71d3f,0x6aa91d40,0x00000000}},	//   zdır_, rann_, _thef,
  { {0xddcd003d,0xe3b8005b,0x68f60078,0x00000000}},	//   skaņ, ydır_, šyda,
  { {0x27e70026,0x61e41d41,0x765b0058,0x00000000}},	//   pann_, _reil, rkuy,
  { {0x60c40173,0x61e41d42,0x656900bd,0x00000000}},	//   _ruim, _seil, rzeh,
  { {0x656900ea,0x60c41d43,0x87040154,0x00000000}},	//   szeh, _suim, _вяче,
  { {0xa75a0041,0x216a030b,0x52860044,0x00000000}},	//   _אדער, еими_, الحك,
  { {0x4a5a0063,0x61e41d44,0x60c40955,0x00000000}},	//   גדרו, _veil, _quim,
  { {0xe3b801f7,0x26c500ac,0x61e41d45,0x00000000}},	//   rdır_, _kulo_, _weil,
  { {0x61e41d46,0x99750051,0xc29a0121,0x00000000}},	//   _teil, nęło_, _птиц_,
  { {0xa2060f9f,0x7afa08a9,0x60c41d47,0x00000000}},	//   _спид, _åtti, _tuim,
  { {0x0eb90475,0x66c7005b,0x4c861939,0x00000000}},	// [2be0] туры_, _sıkl, глав,
  { {0xdde3008f,0x91bb009a,0x5d1300de,0x00000000}},	//   ārša, _אמפי, إِلا,
  { {0x26c500f8,0xfaa61d48,0x99750022,0x00000000}},	//   _nulo_, гажо, jęło_,
  { {0x3ce80235,0x2cb00006,0x394600cd,0x00000000}},	//   _चौथे_, _žodį_, txos_,
  { {0xf9920021,0x127b0047,0xed570591,0x00000000}},	//   حبا_, עאנע, _боя_,
  { {0x66c704ab,0x3ea01d49,0xa9280124,0x00000000}},	//   _tıkl, llit_, južš,
  { {0xcb6a0699,0x3c630505,0x3ea01d4a,0x00000000}},	//   _џабе_, _укрг, olit_,
  { {0x7c2e1d4b,0x26c500a4,0x44f4137a,0x00000000}},	//   _habr, _dulo_, апис,
  { {0x3e7f00fe,0x5e570047,0xca75000d,0x00000000}},	//   lätä_, טיקע_, _туры,
  { {0x2452000c,0xd91b0047,0x38a90066,0x00000000}},	//   _câmp_, _אומל, túre_,
  { {0x68ed00ea,0x7c2e1d4c,0x26c51d4d,0x00000000}},	//   áadv, _mabr, _gulo_,
  { {0x21b5019d,0x0bb70063,0x7c2e1d4e,0x00000000}},	//   ийня, טלים_, _labr,
  { {0x667b0047,0x463b0047,0xe6930044,0x00000000}},	//   _אטאק, _רעדע, _الند,
  { {0x3e670019,0x3e7f0072,0xe1ff0331,0x00000000}},	//   _mõte_, kätä_, chón_,
  { {0xdb1c001f,0x316b0051,0x2327005e,0x00000000}},	//   _sgrî, szcz_, _боји_,
  { {0x442e001f,0x3ea019fb,0xddcd0562,0x00000000}},	//   _haf_, glit_, snaž,
  { {0x3cee0161,0x9f430080,0x2129053b,0x00000000}},	// [2bf0] ेंगे_, mají_, _usah_,
  { {0x9f430080,0x8c440001,0x93bc003b,0x00000000}},	//   lají_, беђе, bdăt,
  { {0xbb840021,0x3ea01d4f,0x2cb4004c,0x00000000}},	//   ملكي, blit_, _řadí_,
  { {0x9f430080,0xe37b0041,0x3ea01d50,0x00000000}},	//   nají_, עראר, clit_,
  { {0x7c2e1d51,0xd7c9005d,0xd3780130,0x00000000}},	//   _fabr, نوشه_, maću_,
  { {0x9f430080,0x26c51d52,0x5c790041,0x00000000}},	//   hají_, _pulo_, _יאָה,
  { {0x36690dd5,0x9f430080,0x1866005a,0x00000000}},	//   како_, kají_, ращи_,
  { {0xbb840032,0x7ae3000c,0x7c2e073e,0x00000000}},	//   _الفي, ântu, _zabr,
  { {0x9f430080,0xa4d6005e,0x49750062,0x00000000}},	//   dají_, адњу_, _тлас,
  { {0x99540001,0x26c50072,0x442e1d53,0x00000000}},	//   _укуц, _tulo_, _caf_,
  { {0x53a5000a,0x52aa005e,0x3ea00072,0x00000000}},	//   ранб, квом_, ylit_,
  { {0xcb120063,0x67b80593,0x2c6400a5,0x00000000}},	//   חלט_, _صالح_, _möda_,
  { {0x41030062,0xd378007d,0xb5fd0023,0x00000000}},	//   озяв, daću_, ekšg,
  { {0x05a80086,0x442e1d54,0xad9b0025,0x00000000}},	//   _свій_, _gaf_, _gcúi,
  { {0x9e76005e,0x3f9e0014,0xdee60b4c,0x00000000}},	//   аћај, ætu_, роби,
  { {0xdbdf007a,0x6e2f0013,0x7c2e1d55,0x00000000}},	//   _síðu, _cacb, _sabr,

  { {0x3ea0007a,0x7c2e1d56,0xac0a0002,0x00000000}},	// [2c00] rlit_, _pabr, кнаа_,
  { {0xa7fc01f7,0x62860066,0x6446008d,0x00000000}},	//   _alın, lnko, êkix,
  { {0x3ea01d57,0x62870ea3,0xf1a9005d,0x00000000}},	//   plit_, čkov, _لایه_,
  { {0x2c6400c7,0x3e7f00fe,0x2d870058,0x00000000}},	//   _döda_, rätä_, ğner_,
  { {0x3e7f024a,0x93bc000c,0x67d40002,0x00000000}},	//   sätä_, ndăr, болу,
  { {0x2c640137,0x7d041d58,0x6e241d59,0x00000000}},	//   _föda_, muis, leib,
  { {0x7d04119d,0x8c1b0063,0xe0b70063,0x00000000}},	//   luis, _שולי, בלסט_,
  { {0x95d7005a,0x442e1d5a,0x9856056c,0x00000000}},	//   адът_, _saf_, dłą_,
  { {0x9f430080,0x78b10026,0x7d041d5b,0x00000000}},	//   vají_, ákvæ, nuis,
  { {0xb806006a,0xb7960001,0x6e2400bd,0x00000000}},	//   _خبره, _крећ, heib,
  { {0x9f430080,0x7d041d5c,0x43941d5d,0x00000000}},	//   tají_, huis, санс,
  { {0x628605dd,0x7d041d5e,0x38a90046,0x00000000}},	//   gnko, kuis, múra_,
  { {0x7d041c71,0x61f6001f,0x4fc700a0,0x00000000}},	//   juis, _ddyl, исва,
  { {0x7d041d5f,0xdb1c00c5,0x0377005d,0x00000000}},	//   duis, _agrí, احیت_,
  { {0xf0b40086,0x6aa20014,0x1df9066e,0x00000000}},	//   ійсь, klof, левы_,
  { {0x2c6400c7,0xdce6005b,0xcdd8005e,0x00000000}},	//   _röda_, _aykı, ињу_,
  { {0xebc70001,0xd904007e,0xa2ca0053,0x00000000}},	// [2c10] аљен, _تی_, _सूत्,
  { {0x38a90066,0x8bd80cb7,0x2292011b,0x00000000}},	//   kúra_, имус_, dáky_,
  { {0xeb090021,0x7d040072,0xca150062,0x00000000}},	//   اقصى_, auis, йджъ,
  { {0xe8f50032,0x7d041d60,0x6f0100cd,0x00000000}},	//   مستخ, buis, àlcu,
  { {0x3cfe0053,0xb9270edb,0x7afe1d61,0x00000000}},	//   _लिये_, рфей, arpt,
  { {0xf1bf013d,0x5c040085,0x26d9011b,0x00000000}},	//   ldás_, _мяса, _čsob_,
  { {0xe7080021,0x62860022,0xe73914db,0x00000000}},	//   لتين_, ynko, уей_,
  { {0x7c251d62,0xcb120063,0xf1bf013d,0x00000000}},	//   lehr, _מלל_, ndás_,
  { {0xd842004c,0x95550044,0xaa5801ce,0x00000000}},	//   áčí_, إخبا, _титу_,
  { {0xb4650055,0x6e24004d,0x04491224,0x00000000}},	//   скол, zeib, упок_,
  { {0x36d40054,0x8c1a0063,0x60d61d63,0x00000000}},	//   _дохр, אותי, _stym,
  { {0x99800024,0x62861d64,0xca7a0041,0x00000000}},	//   žiť_, unko, ָנשט,
  { {0x7c2500bd,0xf6520063,0x62861d65,0x00000000}},	//   kehr, _מצא_, rnko,
  { {0x7d0400fe,0x75360047,0x200c0019,0x00000000}},	//   vuis, _לאנד_, üdi_,
  { {0x64430c35,0x78a3001c,0x44250d03,0x00000000}},	//   _inni, ilnv, mel_,
  { {0x66090d36,0x7d041d66,0x22f60aeb,0x00000000}},	//   ngek, tuis, _הזקן_,
  { {0x75290122,0x6e241a6c,0x628700c2,0x00000000}},	// [2c20] nwez, reib, čkot,
  { {0x7c25004d,0x7d041d67,0x8b26000d,0x00000000}},	//   gehr, ruis, йдзе,
  { {0x291f00fe,0x2018061f,0x44250296,0x00000000}},	//   _apua_, mfri_, iel_,
  { {0xa2ca0161,0x201800c7,0x44251d68,0x00000000}},	//   _संस्, lfri_, hel_,
  { {0x6443024a,0x66090173,0x44251d69,0x00000000}},	//   _onni, dgek, kel_,
  { {0xd90d007e,0x38a918a8,0x44251d6a,0x00000000}},	//   ئیل_, túra_, jel_,
  { {0xfaa6000d,0xf1bf1d6b,0xbad5000d,0x00000000}},	//   _гаво, ndár_, _міты,
  { {0x44250276,0x64431926,0x66091d6c,0x00000000}},	//   eel_, _anni, ggek,
  { {0xc966000d,0x89661d6d,0x96b7005e,0x00000000}},	//   _увай, _укаж, љују_,
  { {0xe8d70063,0x442502ce,0x68f3004c,0x00000000}},	//   _לומר_, gel_, ředí,
  { {0xd3d70021,0xd7960044,0xf7430f0a,0x00000000}},	//   حبًا_, _الضخ, _нефо,
  { {0x44250185,0x46690086,0x64430c78,0x00000000}},	//   ael_, _крім_, _enni,
  { {0x44251d6e,0xf4d70044,0x00000000,0x00000000}},	//   bel_, _هونغ_,   ,
  { {0x27ee0026,0x2018000e,0x2fc506a5,0x00000000}},	//   nafn_, gfri_, ølg_,
  { {0x447b0063,0xd6f80063,0x7e85005f,0x00000000}},	//   _תנוע, יִּש, lėpi,
  { {0x7c2500bd,0x63be004c,0x62871a77,0x00000000}},	//   wehr, ězně, čkos,
  { {0xdc550138,0x463b0047,0xdb1c00cd,0x00000000}},	// [2c30] овањ, נעמע, _agrà,
  { {0x61ef1d6f,0xba3d004c,0xddc6011b,0x00000000}},	//   lacl, _lhůt, _mokř,
  { {0x212b0185,0xf09f00cd,0x50d4007e,0x00000000}},	//   lwch_, stàs_, _وزیر,
  { {0x44251d70,0x7c251d71,0x61ef1d72,0x00000000}},	//   zel_, sehr, nacl,
  { {0x212b0185,0xa2bc0047,0x44250779,0x00000000}},	//   nwch_, אמאט, yel_,
  { {0x27ee002b,0x44251d73,0x212b002b,0x00000000}},	//   gafn_, xel_, iwch_,
  { {0x212b001f,0x66090229,0xb8d00053,0x00000000}},	//   hwch_, tgek, _टी_,
  { {0x44251d74,0xe9df0066,0x7e6d1d75,0x00000000}},	//   wel_, _ýú_, nhap,
  { {0x200a001f,0x66091d76,0x2018002b,0x00000000}},	//   ygbi_, rgek, yfri_,
  { {0x212b0185,0x75290122,0x44251d77,0x00000000}},	//   dwch_, rwez, uel_,
  { {0x224a000a,0x212b001f,0x44251d78,0x00000000}},	//   апни_, ewch_, rel_,
  { {0x44251d79,0x212b002b,0xd6ab0067,0x00000000}},	//   sel_, fwch_, _صدام_,
  { {0x212b0185,0xa4f7007e,0x44251d7a,0x00000000}},	//   gwch_, _اکبر_, pel_,
  { {0x64430026,0xd00a005e,0x316c0022,0x00000000}},	//   _unni, јеве_, ądz_,
  { {0x1fb511ec,0x7e56148f,0xe81b0042,0x00000000}},	//   зстр, отац, प्या_,
  { {0x212b001f,0x7e6d1d7b,0x201800df,0x00000000}},	//   bwch_, ghap, sfri_,
  { {0x63a30185,0xf1bf0025,0x212b002b,0x00000000}},	// [2c40] _hynn, leán_, cwch_,
  { {0x63a3007a,0xe80e016a,0x0c230076,0x00000000}},	//   _kynn, _साधा_, ммун,
  { {0x49ca1d7c,0xd1380051,0xddc4003b,0x00000000}},	//   ален_, łąd_, ghiţ,
  { {0x09e3000a,0x7e6d1d7d,0x63a30cc7,0x00000000}},	//   доцн, chap, _mynn,
  { {0xb5fd0066,0x63a3119a,0xe80e0042,0x00000000}},	//   chši, _lynn, _सादा_,
  { {0x6e360006,0x786f00b9,0x7e641d7e,0x00000000}},	//   ldyb, _løvf, lkip,
  { {0x7e640050,0x466a0816,0xc053009a,0x00000000}},	//   okip, ирим_, וזג_,
  { {0xf1bf0025,0x27ee0026,0xddc4003b,0x00000000}},	//   deán_, safn_, chiţ,
  { {0xceb30132,0x7e641d7f,0x7d161d80,0x00000000}},	//   ויה_, ikip, ntys,
  { {0x63a3001f,0xc8660021,0x7d161d81,0x00000000}},	//   _bynn, _بطري, itys,
  { {0x63a30185,0xe3b8005b,0x7e640072,0x00000000}},	//   _cynn, ldız_, kkip,
  { {0x212b001f,0x63a3001f,0x63b5004a,0x00000000}},	//   twch_, _dynn, ýzna,
  { {0x61ef0120,0x26cc1d82,0x212b002b,0x00000000}},	//   racl, _hudo_, uwch_,
  { {0x212b0185,0x63a3002b,0x74130049,0x00000000}},	//   rwch_, _fynn, _يونا,
  { {0x63a30185,0x212b0185,0x9f340086,0x00000000}},	//   _gynn, swch_, мері,
  { {0x97570063,0x60dd0137,0xa19501dd,0x00000000}},	//   חילו_, ppsm, _найч,
  { {0x7e6d1d83,0x26cc1d84,0x64581d85,0x00000000}},	// [2c50] rhap, _ludo_, _kovi,
  { {0x61ed1d86,0x2ba70001,0x7e641040,0x00000000}},	//   _heal, ојев, akip,
  { {0xf42900fe,0x26cc1059,0x60cd0331,0x00000000}},	//   lmää_, _nudo_, _huam,
  { {0x61ed0034,0x60cd0035,0x3ae7001f,0x00000000}},	//   _jeal, _kuam, rŵp_,
  { {0x6d4b0137,0x61ed1a74,0xd92b0062,0x00000000}},	//   ågad, _meal, рцел_,
  { {0x64581d87,0x61ed1d88,0x629d1d89,0x00000000}},	//   _novi, _leal, hoso,
  { {0xb5fd001c,0x915e008b,0xf42900fe,0x00000000}},	//   ekša, oặc_, hmää_,
  { {0xdb1c00ea,0x26cc0331,0x61ed1d8a,0x00000000}},	//   _ugrá, _dudo_, _neal,
  { {0x6560001f,0x629d1d8b,0x45850121,0x00000000}},	//   gymh, doso, ягив,
  { {0xf1bf0025,0x13090121,0x73050121,0x00000000}},	//   teán_, бной_, ппоз,
  { {0x61ed0025,0x07080021,0xdb1c01e1,0x00000000}},	//   _beal, _ويكي_, _egræ,
  { {0x61ed0027,0xf1bf0027,0x7d161d8c,0x00000000}},	//   _ceal, reán_, ytys,
  { {0xf1bf0025,0x61ed1d8d,0xf8cb0053,0x00000000}},	//   seán_, _deal, ादिय,
  { {0x653a00b5,0x7c350222,0x63a31d8e,0x00000000}},	//   _לענד, _nazr, _tynn,
  { {0x61ed0d12,0xdfcf014d,0x2aae0066,0x00000000}},	//   _feal, ايف_, hýba_,
  { {0xee3a0001,0x69c900ac,0x6446001c,0x00000000}},	//   љна_, _ngee, ēkie,
  { {0xf1bf0027,0x7e641d8f,0x60cd028b,0x00000000}},	// [2c60] neál_, rkip, _guam,
  { {0x7e641d90,0x61ed1d91,0x6e3604aa,0x00000000}},	//   skip, _zeal, sdyb,
  { {0xe8050235,0x8b260086,0x6d4b00c7,0x00000000}},	//   _राजा_, ядже, ägar,
  { {0x76590045,0x0ae90021,0x2bbd0042,0x00000000}},	//   _nowy, تركي_, ्ख़ा,
  { {0x63a60022,0x28f80085,0x9056009a,0x00000000}},	//   ękni, цель_, ּסֶף_,
  { {0x26cc02dd,0x68e9002b,0x28f70121,0x00000000}},	//   _pudo_, _dwed, чешь_,
  { {0xe1ff0051,0x629d0c55,0x75221cca,0x00000000}},	//   chów_, yoso, _spoz,
  { {0xfaa3019d,0x7d041d92,0x60db003b,0x00000000}},	//   _засо, oris, ţumi,
  { {0x68e9001f,0x61ed1d93,0xb5fd008f,0x00000000}},	//   _gwed, _real, ukša,
  { {0x26cc03d9,0xb21b00b9,0x7d041d94,0x00000000}},	//   _tudo_, nnæv, iris,
  { {0x61ed0004,0x60cd053b,0xe61a0675,0x00000000}},	//   _peal, _suam, _где_,
  { {0xd377000d,0x7d041d95,0xe707005d,0x00000000}},	//   ячы_, kris, _رسمی,
  { {0xe5340076,0xf1bf0025,0x104b0062,0x00000000}},	//   _цель, ceál_, бяви_,
  { {0x61ed0034,0x61e001f7,0x629d00fe,0x00000000}},	//   _weal, ımla, soso,
  { {0x7c3502e2,0xf42900fe,0x60c5004b,0x00000000}},	//   _razr, smää_, _vihm,
  { {0xe0df0290,0x7d041d96,0x7c35007d,0x00000000}},	//   ppò_, fris, _sazr,
  { {0x22490024,0xaffd0086,0x81fc0063,0x00000000}},	// [2c70] _inak_, _копi, _ההחז,
  { {0xdfd10021,0xfbd00044,0x00000000,0x00000000}},	//   _جيد_, هتم_,   ,
  { {0xde590086,0xaac703eb,0x7d041d97,0x00000000}},	//   _дані_, ستان, aris,
  { {0x7d180027,0x68e9002c,0x7d041d98,0x00000000}},	//   éasá, _pwed, bris,
  { {0x3ea90137,0x7d040a54,0x786f01f2,0x00000000}},	//   mlat_, cris, _løve,
  { {0xc7a50086,0x01380063,0x3ea91d99,0x00000000}},	//   милк, פרות_, llat_,
  { {0x3ea91d9a,0x76591d9b,0xdce40022,0x00000000}},	//   olat_, _powy, dzię,
  { {0xd877006a,0x645c01e3,0xb5fd00c3,0x00000000}},	//   _کارب, örin, akšn,
  { {0xdb1c0137,0x68e900a4,0x3ea90089,0x00000000}},	//   _egrä, _uwed, ilat_,
  { {0x22490397,0x3ea90072,0x9f410072,0x00000000}},	//   _anak_, hlat_, _kehä_,
  { {0x3ea91d9c,0xa22a1d9d,0xe76b01ce,0x00000000}},	//   klat_, ожна_, _ујак_,
  { {0x38b2003b,0x0394000d,0x1dbf0053,0x00000000}},	//   râre_, эрыя, ्शात,
  { {0x66c70058,0xb148005d,0x3ea91d9e,0x00000000}},	//   _fıkr, سیدم_, dlat_,
  { {0x63850138,0x22491d9f,0x3ea90137,0x00000000}},	//   _огла, _enak_, elat_,
  { {0xe29f007a,0x75450051,0xd335000d,0x00000000}},	//   boð_, łrzę, _цэлы,
  { {0x3ea91da0,0x0eaa000d,0xecea1406,0x00000000}},	//   glat_, ікай_, ждал_,
  { {0x32d3001b,0xb21b00b9,0xd12f007e,0x00000000}},	// [2c80] _hãy_, tnæv, _نمي_,
  { {0x7d041da1,0x25a2004b,0x22490938,0x00000000}},	//   rris, ükli_, _znak_,
  { {0x3ea91da2,0x7d041da3,0xbad6014b,0x00000000}},	//   blat_, sris, фізы,
  { {0x3ea90268,0x7d040399,0xb21b00b9,0x00000000}},	//   clat_, pris, snæv,
  { {0x20d4065c,0xaac5007e,0xbdfb007e,0x00000000}},	//   _jäi_, رتمن, _برپا_,
  { {0x3ea01da4,0xd6da1da5,0xe8940085,0x00000000}},	//   loit_, оти_, эаль,
  { {0xf7930088,0x3ea00983,0x45d4030b,0x00000000}},	//   кашэ, ooit_, нойс,
  { {0xa3c30053,0xdb1c0137,0x786f01f2,0x00000000}},	//   ्शन_, _vgrä, _røve,
  { {0x20d4004e,0x64c80042,0xd406030b,0x00000000}},	//   _näi_, रदेश, мяни,
  { {0x224900b9,0xc3540002,0x61e6069f,0x00000000}},	//   _snak_, екој, ebkl,
  { {0xd37a0685,0xe29f0014,0x3ea91da6,0x00000000}},	//   ючи_, toð_, ylat_,
  { {0x32d3008b,0x5725007e,0x68e21da7,0x00000000}},	//   _dãy_, _سرمق, opod,
  { {0xf1ab007e,0xa2ca0053,0xddcd0066,0x00000000}},	//   تاده_, _संक्, tiaž,
  { {0x9f430024,0x104b0086,0x786f00b9,0x00000000}},	//   majú_, цями_, _tøve,
  { {0x9f430024,0x644a1b2d,0xd838007d,0x00000000}},	//   lajú_, _infi, _mač_,
  { {0x3ea91d0e,0x442c1da8,0x92580021,0x00000000}},	//   ulat_, led_, _يشير_,
  { {0xdfd5122b,0x9f430024,0x865b0063,0x00000000}},	// [2c90] _попы, najú_, קדמי,
  { {0xb5fd003d,0x442c1da9,0x26de1daa,0x00000000}},	//   ekšl, ned_, _otto_,
  { {0x9f430066,0x628f17eb,0x68e21dab,0x00000000}},	//   hajú_, onco, epod,
  { {0x2bdf0394,0xfbdf0161,0x9f430024,0x00000000}},	//   _प्रा, _प्रम, kajú_,
  { {0x26de051e,0x442c1dac,0xd825050f,0x00000000}},	//   _atto_, ked_, едли,
  { {0x9f430024,0x442c1dad,0x7d0d017e,0x00000000}},	//   dajú_, jed_, muas,
  { {0xa2ca0053,0x442c1dae,0x46a5026b,0x00000000}},	//   _संग्, ded_, накв,
  { {0xbb48007e,0x628f006f,0xee320063,0x00000000}},	//   _تلفن_, jnco, ָֽה_,
  { {0x79a70fe2,0x660600ea,0x99890051,0x00000000}},	//   _црве, ókka, żał_,
  { {0xa2ca0161,0xe4510032,0x442c1daf,0x00000000}},	//   _संख्, اضة_, ged_,
  { {0xe2860da9,0xae0f0053,0x7d0d1db0,0x00000000}},	//   елни, िलान_, huas,
  { {0x644a1db1,0x7d0d07fa,0x442c004b,0x00000000}},	//   _enfi, kuas, aed_,
  { {0x442c1db2,0x3e6e0026,0x6e2d1db3,0x00000000}},	//   bed_, _nýta_, deab,
  { {0x442c1db4,0xa2ca0235,0xa06a000d,0x00000000}},	//   ced_, _सूक्, чага_,
  { {0x53320002,0x6e2d0025,0x3ea01db5,0x00000000}},	//   _бејт, feab, toit_,
  { {0x7d0d0035,0xd7f10013,0x6e2d1db6,0x00000000}},	//   fuas, _lẽ_, geab,
  { {0x3ea01db7,0x62861db8,0x7d0d1db9,0x00000000}},	// [2ca0] roit_, miko, guas,
  { {0x69db006d,0xc19b0063,0x3ea01dba,0x00000000}},	//   _afue, _משפי, soit_,
  { {0x9f430024,0xe1ff0025,0x961d001c,0x00000000}},	//   zajú_, mhór_, ziņa,
  { {0x442c0886,0xb21b0093,0x649c005b,0x00000000}},	//   zed_, lnær, _içiş,
  { {0x442c0034,0xd83800c2,0x3cd5000d,0x00000000}},	//   yed_, _pač_, _аўст,
  { {0x9f430024,0x442c0034,0x62860ff2,0x00000000}},	//   vajú_, xed_, hiko,
  { {0x442c0034,0xe66600e1,0x62861dbb,0x00000000}},	//   ved_, етпо, kiko,
  { {0x442c04bf,0x9f430024,0x961d008f,0x00000000}},	//   wed_, tajú_, tiņa,
  { {0xdb1c0025,0x442c1dbc,0x35b40062,0x00000000}},	//   _ngrú, ted_, ъбир,
  { {0x998000eb,0x6aa20179,0x9f430024,0x00000000}},	//   žių_, loof, rajú_,
  { {0x442c1dbd,0x99890066,0x62861dbe,0x00000000}},	//   red_, ľať_, fiko,
  { {0x62860004,0x99890024,0x442c1dbf,0x00000000}},	//   giko, žať_, sed_,
  { {0x442c1dc0,0x60f8007f,0x2c6f0022,0x00000000}},	//   ped_, нняя_, ażdy_,
  { {0x6aa2006f,0x62861dc1,0x644a00e5,0x00000000}},	//   hoof, aiko, _unfi,
  { {0xcf9800d7,0x2f280062,0x6e2d1dc2,0x00000000}},	//   ејт_, нюто_, teab,
  { {0xb21b0583,0x7bdc1dc3,0x7d0d1dc4,0x00000000}},	//   rnæs, _afru, tuas,
  { {0x6e2d1dc5,0x1bd51dc6,0x8d740044,0x00000000}},	// [2cb0] reab, возя, هاكا,
  { {0x6e2d1dc7,0xf8b8008b,0x9c38005e,0x00000000}},	//   seab, _nhĩ_, нпут_,
  { {0x39441dc8,0x68fb007d,0x7afa0014,0x00000000}},	//   _arms_, _svud, _ættl,
  { {0xd7f100aa,0x7d0d0397,0x636b00ea,0x00000000}},	//   _sẽ_, puas, lönö,
  { {0x7d0d01f4,0xb5fd0078,0x26da01c8,0x00000000}},	//   quas, ukšm, ípon_,
  { {0x62861dc9,0x717c009a,0xf1b4009a,0x00000000}},	//   ziko, הנדס, נסס_,
  { {0xa6950095,0x63aa002b,0x39441dca,0x00000000}},	//   криј, _nyfn, _erms_,
  { {0x6edc00c2,0x628611d9,0x99d40044,0x00000000}},	//   _učbe, xiko, _متكا,
  { {0x58d50086,0xf993014d,0x69c41dcb,0x00000000}},	//   _розт, _صبر_, žier,
  { {0x44651dcc,0x58d40afc,0x290f004b,0x00000000}},	//   твов, _софт, muga_,
  { {0x63aa0185,0xe3b90088,0xfbd20063,0x00000000}},	//   _cyfn, ьбо_, יתי_,
  { {0x20010150,0x63aa002b,0x63ae0058,0x00000000}},	//   _adhi_, _dyfn, übna,
  { {0x290f0019,0x0fda0121,0xa56400f2,0x00000000}},	//   nuga_, дьбы_, _مدون,
  { {0x291d1147,0x62861dcd,0x5576009a,0x00000000}},	//   itwa_, siko, _בענן_,
  { {0x63aa001f,0x8fa6026b,0x290f1c8f,0x00000000}},	//   _gyfn, таве, huga_,
  { {0x7bdc051e,0x290f0019,0xf2d20063,0x00000000}},	//   _sfru, kuga_, _דעה_,
  { {0x290f004b,0x7e23005e,0xc5f2009f,0x00000000}},	// [2cc0] juga_, јдуж, ידן_,
  { {0x20040006,0x78a300d1,0x290f1dce,0x00000000}},	//   ėmis_, jonv, duga_,
  { {0x753c008f,0x78a30050,0x9a25014b,0x00000000}},	//   ārzi, donv, сiяй_,
  { {0x290f1dcf,0xc9861dd0,0xf98a0044,0x00000000}},	//   fuga_, кули, وناي_,
  { {0x78a300df,0x290f004b,0x645c01cf,0x00000000}},	//   fonv, guga_, örik,
  { {0x7afc017f,0xa7fc005b,0x6aa20019,0x00000000}},	//   _tvrt, _alır, soof,
  { {0x7c3c0027,0x291d0150,0x7c3e0137,0x00000000}},	//   _iarr, atwa_, mdpr,
  { {0xc6a60062,0x96341dd1,0x7c3c1dd2,0x00000000}},	//   ърли, униц, _harr,
  { {0x291d0051,0x08c6000d,0xdd110058,0x00000000}},	//   ctwa_, _абан, _müşe,
  { {0xdb0e003b,0x3e67004b,0x7c3e1dd3,0x00000000}},	//   _izbâ, _võti_, ndpr,
  { {0x64a30079,0xd251006a,0x7c3c09e2,0x00000000}},	//   раќа, مند_, _marr,
  { {0x6d461dd4,0x7c3c1dd5,0x21790121,0x00000000}},	//   _orka, _larr, еймы_,
  { {0x9553006a,0xaf34007e,0x316d0331,0x00000000}},	//   _نخوا, یرفت, áez_,
  { {0x3e75076c,0xa3d31dd6,0x8cd60042,0x00000000}},	//   _måte_, _кошч, _बढ़ो,
  { {0x6d461a8d,0x5433002a,0x66020260,0x00000000}},	//   _arka, _ضرور, _kdok,
  { {0x443e1dd7,0x443c018c,0x290f0f20,0x00000000}},	//   ldt_, _hav_, yuga_,
  { {0x961d003d,0x5cb9000d,0x201e00cd,0x00000000}},	// [2cd0] ziņo, елаў_, òtic_,
  { {0x443e1dd8,0x1a65007e,0x443c1dd9,0x00000000}},	//   ndt_, گیری_, _jav_,
  { {0x7c3c1dda,0x6d4600bd,0x44e2001b,0x00000000}},	//   _darr, _erka, hư_,
  { {0x7c3c0027,0x99840006,0x443c1ddb,0x00000000}},	//   _earr, _namų_, _lav_,
  { {0xe8df0013,0x443c1ddc,0x7c3c1ddd,0x00000000}},	//   _trọn_, _oav_, _farr,
  { {0x443c0418,0xfc64005a,0x443e0122,0x00000000}},	//   _nav_, _късн, jdt_,
  { {0x290f0019,0x291d0051,0x46f4000d,0x00000000}},	//   suga_, stwa_, ачыт,
  { {0xc1e30235,0x443e0122,0x6d460137,0x00000000}},	//   _क्लब_, edt_, _yrka,
  { {0x6e3d00a4,0xfeca0047,0x7e6d193c,0x00000000}},	//   _masb, עמפּ, ikap,
  { {0x649d0268,0x38a90066,0x7e6d0072,0x00000000}},	//   nèix, túru_, hkap,
  { {0xf770007e,0x461501fb,0x7e6d1dde,0x00000000}},	//   _وام_, _موار, kkap,
  { {0xe0c900b5,0x443e006f,0x32ba0021,0x00000000}},	//   _זײ_, adt_, عددة_,
  { {0x321e0051,0x7e6d1ddf,0x51f70043,0x00000000}},	//   ęty_, dkap, دسپر,
  { {0x443c1de0,0x2c7600b9,0x66020240,0x00000000}},	//   _gav_, _kæde_, _zdok,
  { {0x44271de1,0x65690072,0x1e961de2,0x00000000}},	//   _ibn_, lyeh, грар,
  { {0xd7f1001b,0x93bc003b,0x9e75005e,0x00000000}},	//   _dõi_, sfăc, аћуј,
  { {0x61461968,0x261b0053,0x65690150,0x00000000}},	// [2ce0] _сепа, _यानी_, nyeh,
  { {0x7e6d0012,0x31570063,0x7e761de3,0x00000000}},	//   akap, _עיין_, shyp,
  { {0x8e8606f0,0x629d0003,0xaa460002,0x00000000}},	//   _бгне, érog, лежл,
  { {0x7c3c1926,0x26da0066,0x7e6d047b,0x00000000}},	//   _warr, ípom_, ckap,
  { {0x443e0c3d,0x7c3c1de4,0x99550058,0x00000000}},	//   ydt_, _tarr, rüşe_,
  { {0x8d4b0063,0x219b0041,0x20f20023,0x00000000}},	//   _אֲלֵ, עבסא, iņi_,
  { {0x6d441de5,0xc7af02dc,0x7fd7009f,0x00000000}},	//   lvia, сё_, נוקס_,
  { {0x9b930021,0x443c1de6,0x657b004d,0x00000000}},	//   _الفت, _sav_, fzuh,
  { {0x6d441de7,0x443c0006,0x44271de8,0x00000000}},	//   nvia, _pav_, _bbn_,
  { {0x443e006f,0xd5c00053,0xe8d70063,0x00000000}},	//   udt_, शेषज, _עובר_,
  { {0x443e0b7d,0x7e6d1de9,0x61f61dea,0x00000000}},	//   rdt_, ykap, _beyl,
  { {0x673a007d,0x443c1deb,0x61f61dec,0x00000000}},	//   _istj, _wav_, _ceyl,
  { {0x6d440024,0x61f8000d,0x9f51004a,0x00000000}},	//   jvia, ыняў_, razí_,
  { {0x60d6005b,0x6d440066,0x443c1ded,0x00000000}},	//   _duym, dvia, _uav_,
  { {0xcebb0001,0xb4c20053,0x7e6d0659,0x00000000}},	//   еља_, ्दी_, tkap,
  { {0x38bb00e8,0xe80e0053,0xe1ff009c,0x00000000}},	//   mêre_, _साझा_, kkói_,
  { {0x38bb00e8,0x5d55026b,0x6abb001f,0x00000000}},	// [2cf0] lêre_, шкат, _rhuf,
  { {0x673a0019,0x9ed90189,0x7e6d1dee,0x00000000}},	//   _ostj, _имот_, skap,
  { {0x649d0268,0x38bb00e8,0xca150062,0x00000000}},	//   rèix, nêre_, иджъ,
  { {0xbddb00cd,0x8bc4007f,0xb5fd0078,0x00000000}},	//   _enèr, ссуд, lkšv,
  { {0xc27c00b5,0x2c7605b9,0xe9d8000d,0x00000000}},	//   ערדי, _sæde_, укі_,
  { {0x1bd4137a,0xa9661def,0x8d48009a,0x00000000}},	//   _горя, риша_, _עֲרֵ,
  { {0x4af6007e,0xdc9a009a,0x4c9a009a,0x00000000}},	//   _نکند_, _יישל, _יבשו,
  { {0x44270150,0x0f580063,0xe1ff0022,0x00000000}},	//   _sbn_, ריהם_, mków_,
  { {0xd4550086,0x7d0d09ad,0xb4c20042,0x00000000}},	//   атнь, nras, ्दू_,
  { {0x032500d7,0x7c250025,0xddc40006,0x00000000}},	//   адон, nfhr, nkiš,
  { {0xe1ff0045,0x9655005a,0xee3f0066,0x00000000}},	//   nków_, _вълч, _akým_,
  { {0x216a0086,0x7d0d1df0,0x6d440006,0x00000000}},	//   вими_, kras, yvia,
  { {0xe2971df1,0x7d0d1df2,0x34951bf5,0x00000000}},	//   рая_, jras, _кадр,
  { {0xd4660138,0x38bb00e8,0x6d44051e,0x00000000}},	//   _више_, bêre_, vvia,
  { {0x6f630002,0x7d0d07ff,0xe1ff0022,0x00000000}},	//   оврз, eras, jków_,
  { {0x539a0f6d,0x7afa0026,0xe1ff0051,0x00000000}},	//   _ביצו, _ætti, dków_,
  { {0x4c86000d,0x7d0d1df3,0x629d006d,0x00000000}},	// [2d00] алав, gras, éroe,
  { {0xe0fb014e,0xd12f007e,0x6d441df4,0x00000000}},	//   _שליל, _کمی_, rvia,
  { {0xdddd000f,0x2abc006d,0x64411df5,0x00000000}},	//   _első, híbe_, idli,
  { {0x6da60086,0x8b650021,0x7d0d1df6,0x00000000}},	//   _вима, حاكم, bras,
  { {0x29000016,0x9f43006d,0x44e91df7,0x00000000}},	//   éia_, bajó_, _nº_,
  { {0x20181df8,0x64411df9,0xf1b9027d,0x00000000}},	//   ngri_, jdli, ýši_,
  { {0x26cf00a4,0x64411dfa,0x3e67004b,0x00000000}},	//   _bigo_, ddli, _tõtt_,
  { {0x644100bd,0xeb97019d,0x2240014f,0x00000000}},	//   edli, _тис_, _naik_,
  { {0xd5b70b62,0x26cf0460,0xd946005e,0x00000000}},	//   ись_, _digo_, _њези,
  { {0x38bb00e8,0xb4c00053,0x9169008b,0x00000000}},	//   têre_, ंगे_, _lựa_,
  { {0x2240014f,0x3e7500c7,0x26cf1dfb,0x00000000}},	//   _baik_, _låta_, _figo_,
  { {0x38bb00ac,0x39461dfc,0x9f580e7c,0x00000000}},	//   rêre_, ovos_, caré_,
  { {0xe1ff0022,0x50671dfd,0x867b0063,0x00000000}},	//   zków_, атва, _בראו,
  { {0x27fc0dfb,0x7d0d0387,0x3946017d,0x00000000}},	//   navn_, vras, ivos_,
  { {0x06fd0080,0x3eb204aa,0x7d0d00a3,0x00000000}},	//   žívá_, flyt_, wras,
  { {0x27fc06a5,0x7d0d1dfe,0x200d003b,0x00000000}},	//   havn_, tras, şei_,
  { {0x7d0d1dff,0x9169008b,0x61fd0443,0x00000000}},	// [2d10] uras, _dựa_, masl,
  { {0xe1ff0051,0x61fd1e00,0x9f581358,0x00000000}},	//   tków_, lasl, zaré_,
  { {0x22400089,0x2a641e01,0x9e350002,0x00000000}},	//   _yaik_, _bomb_, _ленч,
  { {0x7d0d1e02,0x7e55007e,0xe1ff0022,0x00000000}},	//   pras, _انحص, rków_,
  { {0x3949048e,0x0dcb000a,0xe1ff0051,0x00000000}},	//   ías_, _јуни_, sków_,
  { {0x229200c2,0xf8a8000d,0x26cf0e7c,0x00000000}},	//   mške_, авік_, _sigo_,
  { {0x9f581e03,0xb21b0014,0x6d400014,0x00000000}},	//   taré_, mhæf, _ámar,
  { {0x2a6400ea,0x2f980063,0x7d1b004d,0x00000000}},	//   _gomb_, יכון_, _äuss,
  { {0x88070242,0x26cf1e04,0x22920734,0x00000000}},	//   _نظام, _vigo_, nške_,
  { {0x2abc0025,0x9f581795,0x66d50a1e,0x00000000}},	//   ríbe_, saré_, _aške,
  { {0x64411e05,0xa25b017d,0x9f580003,0x00000000}},	//   rdli, rmôn, paré_,
  { {0x6f15048e,0x27211e06,0xdb0e006c,0x00000000}},	//   duzc, món_, édée,
  { {0x27211e07,0x200c00be,0x29350041,0x00000000}},	//   lón_, ódio_, זאָן_,
  { {0x672300c2,0x6f080124,0x61fd00a8,0x00000000}},	//   otnj, ádco, aasl,
  { {0xb21b0146,0x27211e08,0x20180046,0x00000000}},	//   dhæf, nón_, rgri_,
  { {0x39460078,0xbda60044,0x92930092,0x00000000}},	//   yvos_, محذو, _најц,
  { {0xee370001,0x27211919,0xed571e09,0x00000000}},	// [2d20] љну_, hón_, бот_,
  { {0x4f960002,0xb17b00a5,0xa3ab0042,0x00000000}},	//   _грму, rbåt, कअप_,
  { {0x4b260002,0x27211e0a,0x3ea91098,0x00000000}},	//   смев, jón_, boat_,
  { {0xef220051,0x82d60047,0x27211e0b,0x00000000}},	//   ążę_, צונג_, dón_,
  { {0x186a0ef3,0x27211e0c,0x39460072,0x00000000}},	//   лади_, eón_, uvos_,
  { {0xa967005e,0x394618f5,0x27211e0d,0x00000000}},	//   сиља_, rvos_, fón_,
  { {0x27211e0e,0x290f1e0f,0x39460078,0x00000000}},	//   gón_, arga_, svos_,
  { {0x3e6e004c,0x1efb0041,0xddcd0022,0x00000000}},	//   _býti_, אלקע, jjaś,
  { {0x61fd000f,0xb5fd001c,0x99920051,0x00000000}},	//   vasl, ekšs, żył_,
  { {0xd6d208aa,0x2721006d,0xb8650021,0x00000000}},	//   _فقط_, bón_, _والو,
  { {0x22590121,0x27211e10,0x61fd1e11,0x00000000}},	//   аины_, cón_, tasl,
  { {0xb5fd0006,0x41e4000d,0x7afa0014,0x00000000}},	//   ukšt, зіра, _ættu,
  { {0x61fd02e2,0xb5fd0078,0x645c1e12,0x00000000}},	//   rasl, rkšt, öris,
  { {0x2d801e13,0x8cd30053,0x7d160058,0x00000000}},	//   dzie_, _भूगो, duys,
  { {0x61e40185,0x7e6600c7,0x61fd1e14,0x00000000}},	//   _ffil, _bokp, pasl,
  { {0xa1950062,0x63970063,0x5f941e15,0x00000000}},	//   _майч, _לדוא_, чист,
  { {0x272102dd,0x3ea900e5,0x2d580065,0x00000000}},	// [2d30] zón_, roat_, бить_,
  { {0xebc70001,0xaae70021,0x628f1e16,0x00000000}},	//   бљен, مسؤو, lico,
  { {0xb5fd082a,0xb21b0026,0xddcf003b,0x00000000}},	//   ljše, rhæf, _focş,
  { {0xdb1f0026,0x6f010e7c,0x628f1e17,0x00000000}},	//   _ávís, álcu, nico,
  { {0xae1a00b5,0xb5fd1253,0x290f1e18,0x00000000}},	//   _דורכ, njše, urga_,
  { {0x27211e19,0x0c75007e,0x2bcb0002,0x00000000}},	//   tón_, _بگرد, _бубо_,
  { {0x2d9c0058,0xddcd0022,0xe708009b,0x00000000}},	//   şvet_, yjaś, متين_,
  { {0x27210885,0xb5fd001c,0x628f0130,0x00000000}},	//   rón_, ekšr, jico,
  { {0x628f1e1a,0x2721006d,0x64991e1b,0x00000000}},	//   dico, són_, итор_,
  { {0x7305019d,0x6aab1e1c,0x27211e1d,0x00000000}},	//   опоз, logf, pón_,
  { {0x628f0b23,0x8c1a0063,0xe3b10021,0x00000000}},	//   fico, בותי, برة_,
  { {0x628f06b2,0xd1ca005e,0xd5751b37,0x00000000}},	//   gico, илне_, _муль,
  { {0x26da0066,0xd5480593,0xf494005d,0x00000000}},	//   ípov_, _هجوم_, _کشند,
  { {0x201e004b,0xd01200f2,0x661b004e,0x00000000}},	//   üti_, بلس_, lguk,
  { {0x64430290,0x628f0877,0x661b004b,0x00000000}},	//   _iani, bico, oguk,
  { {0xee3a00e1,0x64431832,0x38b2003b,0x00000000}},	//   јна_, _hani, râri_,
  { {0x644303d5,0x7fd60097,0x6aab002b,0x00000000}},	// [2d40] _kani, _міні, dogf,
  { {0x2d800024,0x64431e1e,0xab2a066f,0x00000000}},	//   rzie_, _jani, иоза_,
  { {0x6a860edd,0x394d0dd2,0xe9da1e1f,0x00000000}},	//   олжа, _ares_, аке_,
  { {0x9c870080,0xddc60078,0x64431e20,0x00000000}},	//   _počá, _jokū, _lani,
  { {0xdb070080,0xef190022,0x09360044,0x00000000}},	//   _vyjá, ąże_, تراج,
  { {0x64431e21,0xd90d007e,0xc1730063,0x00000000}},	//   _nani, ایل_, וחד_,
  { {0xe3a7006a,0x8b23041d,0x394d02dd,0x00000000}},	//   _آر_, _одре, _eres_,
  { {0x7d041e22,0x628f1e23,0x7ae1013d,0x00000000}},	//   osis, xico, _élta,
  { {0x9f580024,0x64431e24,0xe4c60121,0x00000000}},	//   darí_, _bani, жённ,
  { {0x64431e25,0x29000078,0x7d041e26,0x00000000}},	//   _cani, šias_, isis,
  { {0x628f1e27,0x7d04049c,0x64431e28,0x00000000}},	//   tico, hsis, _dani,
  { {0xd3770088,0x7d041e29,0xdb2100ea,0x00000000}},	//   ючы_, ksis, étét,
  { {0x66d50006,0x628f1e2a,0x7d04001c,0x00000000}},	//   _iška, rico, jsis,
  { {0x64430a73,0xdfd8005a,0x628f1e2b,0x00000000}},	//   _gani, жът_, sico,
  { {0x628f0b23,0x4e8b0062,0x7d041e2c,0x00000000}},	//   pico, ащам_, esis,
  { {0x7d040009,0x64431e2d,0x66001e2e,0x00000000}},	//   fsis, _zani, namk,
  { {0x7d0400bb,0xd904006a,0xdddd0051,0x00000000}},	// [2d50] gsis, _جی_, _posł,
  { {0x660000e3,0xa0680001,0xfc330021,0x00000000}},	//   hamk, _мања_, بحر_,
  { {0x66000397,0x68e905e5,0x5a350002,0x00000000}},	//   kamk, _sted, знет,
  { {0x394d1e2f,0xc1750063,0x7d041e30,0x00000000}},	//   _pres_, ּחַ_, bsis,
  { {0x6aab00b9,0x9e5a0063,0x7d040072,0x00000000}},	//   rogf, _הכרט, csis,
  { {0x68e90024,0x3e7c0080,0x48ab005e,0x00000000}},	//   _vted, _víte_, штем_,
  { {0xf77104f6,0x68e90051,0x64431e31,0x00000000}},	//   عات_, _wted, _rani,
  { {0x394d1e32,0x44e0008b,0x05650156,0x00000000}},	//   _tres_, _bò_, звин,
  { {0x79820045,0x64431e33,0x661b004b,0x00000000}},	//   czow, _pani, rguk,
  { {0x44e0008b,0x629d0b6c,0x442e00be,0x00000000}},	//   _dò_, éron, _cbf_,
  { {0xf1a900b7,0x229200eb,0x0322000d,0x00000000}},	//   _עס_, eška_, ндэн,
  { {0x6443166a,0x67ba0063,0xe29a1e34,0x00000000}},	//   _wani, _המעק, сам_,
  { {0xa7fc005b,0x2bb80053,0x44e00013,0x00000000}},	//   _alıy, _अर्थ, _gò_,
  { {0xf09f00cd,0x7ae91aa5,0x22590078,0x00000000}},	//   dràs_, _četn, _čekų_,
  { {0x6e2f0016,0x7d040050,0x6d4f1e35,0x00000000}},	//   _bbcb, wsis, _arca,
  { {0x3e6e007a,0xc7b20063,0x7d041e36,0x00000000}},	//   _nýtt_, גבל_, tsis,
  { {0xed57036a,0x0d86005e,0x7d041e37,0x00000000}},	// [2d60] пот_, члан, usis,
  { {0x7d041e38,0xe058007e,0x32020445,0x00000000}},	//   rsis, _بیست_, laky_,
  { {0x6d4f1e39,0x7d041250,0x8ad601f3,0x00000000}},	//   _erca, ssis, ستائ,
  { {0xf09f00cd,0x9f5801a8,0xd491008d,0x00000000}},	//   bràs_, marà_, hì_,
  { {0x9f5800cd,0xda650044,0xadd7009a,0x00000000}},	//   larà_, بالي, _מוכח_,
  { {0x91bb0063,0x79820051,0x44e0008d,0x00000000}},	//   זמני, rzow, _rò_,
  { {0x9f580268,0xa3ab0053,0x79820051,0x00000000}},	//   narà_, _कुल_, szow,
  { {0x44e001f4,0x09e6005e,0x8b9b0063,0x00000000}},	//   _pò_, _хоан, _הבלת,
  { {0x66001e3a,0xa3c90042,0xfaa31e3b,0x00000000}},	//   ramk, लेस_, _чато,
  { {0x660000bd,0x628d0025,0x69c01e3c,0x00000000}},	//   samk, _smao, _izme,
  { {0xd251006a,0xe2150121,0x4adc0042,0x00000000}},	//   نند_, ммны, यदिव,
  { {0x9f580268,0x11d90021,0x44e00013,0x00000000}},	//   darà_, توحة_, _tò_,
  { {0xc05b0086,0x3254000d,0x2906007d,0x00000000}},	//   бів_, хвяр, nsoa_,
  { {0x229202f7,0x82f7005d,0x4ee70054,0x00000000}},	//   rška_, _کروز_, зіаз,
  { {0x9f580268,0xb5fd06bb,0x6448001f,0x00000000}},	//   garà_, ljša, mddi,
  { {0x02a40088,0xbddb00cd,0x877b0047,0x00000000}},	//   _прым, _gaèl, זאלי,
  { {0xb5fd00c3,0x442c006f,0x2d580071,0x00000000}},	// [2d70] njša, ofd_, пить_,
  { {0x26de00e8,0x9f5800cd,0xebc70001,0x00000000}},	//   _outo_, barà_, пљен,
  { {0x9f580268,0x20030035,0x6448001f,0x00000000}},	//   carà_, maji_, iddi,
  { {0x629d00d1,0x3935000d,0x20031e3d,0x00000000}},	//   nnso, дэкс, laji_,
  { {0x9f580460,0x6d4f003b,0x26de0719,0x00000000}},	//   mará_, _urca, _auto_,
  { {0x20030035,0x9f580e7c,0x629d1e3e,0x00000000}},	//   naji_, lará_, hnso,
  { {0x61e600c7,0x60df0089,0x6d4d0d47,0x00000000}},	//   yckl, _luqm, lvaa,
  { {0x9f580297,0x442c006f,0x64480767,0x00000000}},	//   nará_, efd_, eddi,
  { {0x6d4d1e3f,0x20030e29,0x64481e40,0x00000000}},	//   nvaa, kaji_, fddi,
  { {0x6d4d172b,0x13090121,0x9f5800be,0x00000000}},	//   ivaa, оной_, hará_,
  { {0x9f580268,0x3e7c0026,0x26de155f,0x00000000}},	//   xarà_, _líta_, _guto_,
  { {0x9f581e41,0x6d4d004b,0x64580764,0x00000000}},	//   varà_, kvaa, _envi,
  { {0x9f5806b2,0x6f150051,0x5155180c,0x00000000}},	//   dará_, erzc, нтру,
  { {0x9f580268,0x629d1e42,0x20030150,0x00000000}},	//   tarà_, anso, gaji_,
  { {0x7e640150,0x6d4d1986,0x6e2d1e43,0x00000000}},	//   tjip, evaa, ffab,
  { {0x9f581e44,0x229200c2,0x7649005b,0x00000000}},	//   rarà_, mško_, ndey,
  { {0x8236006a,0xa3c9016a,0x9f580268,0x00000000}},	// [2d80] _فرکا, लेर_, sarà_,
  { {0x28e10053,0x9f5800cd,0x66d500c2,0x00000000}},	//   _पढ़ि, parà_, _oško,
  { {0xab27100b,0x9f580e7c,0x786f000e,0x00000000}},	//   доха_, bará_, _løvs,
  { {0x9f5806b2,0x99dd0a63,0x29060072,0x00000000}},	//   cará_, _daňo, tsoa_,
  { {0x64480c70,0xa967006e,0x79a30002,0x00000000}},	//   yddi, мица_, крше,
  { {0x7659001f,0x3ead1e45,0x764900a4,0x00000000}},	//   _anwy, čete_, edey,
  { {0x29060016,0x8a060001,0x7bdc00a4,0x00000000}},	//   ssoa_, _озве, _igru,
  { {0x20030009,0xc9560076,0xf4290072,0x00000000}},	//   zaji_, _отзы, ylää_,
  { {0x6f1c1e46,0x66d50078,0x69c01bbd,0x00000000}},	//   hurc, _eško, _uzme,
  { {0x9f580297,0x26de01c2,0x68ed032a,0x00000000}},	//   zará_, _tuto_, íade,
  { {0x64481e47,0x20031e48,0x629d1e49,0x00000000}},	//   rddi, vaji_, tnso,
  { {0x6f1c0199,0x9f5800ed,0x7d161e4a,0x00000000}},	//   durc, xará_, krys,
  { {0x200310ca,0x9f5804a6,0x75291e4b,0x00000000}},	//   taji_, vará_, ctez,
  { {0x656f00bd,0x7bdc0150,0x27170013,0x00000000}},	//   äche, _ngru, ũng_,
  { {0x9f5806b2,0xd0d4005a,0xa295000d,0x00000000}},	//   tará_, торъ, _пакі,
  { {0x6d4d0122,0x4ea40189,0x7bdc1e4c,0x00000000}},	//   tvaa, вруа, _agru,
  { {0x9f5806b2,0x200300c2,0xf1a4000d,0x00000000}},	// [2d90] rará_, paji_, _арэн,
  { {0x3156014e,0x9f580b23,0x6d4d1e4d,0x00000000}},	//   _ניתן_, sará_, rvaa,
  { {0xda15000a,0x752900c2,0x9f580460,0x00000000}},	//   едењ, ztez, pará_,
  { {0x2249004b,0x6d4d0983,0x28c40042,0x00000000}},	//   _jaak_, pvaa, _लीबि,
  { {0x22491a20,0xeab00021,0xf5480013,0x00000000}},	//   _maak_, جعل_, _nụ_,
  { {0x212b0168,0x9178009a,0xacfa009d,0x00000000}},	//   itch_, ועדף_, _מהשכ,
  { {0x7afc0185,0x20010019,0xcb690044,0x00000000}},	//   _gwrt, _mehi_, _عمره_,
  { {0x7529051e,0x06091e4e,0x26c6179b,0x00000000}},	//   ttez, чник_, _choo_,
  { {0xf548001b,0x76490058,0x78f80044,0x00000000}},	//   _cụ_, rdey, _يعكس_,
  { {0xf548001b,0x75291e4f,0x2db80063,0x00000000}},	//   _dụ_, rtez, ולחן_,
  { {0xa3c90053,0xe66700a0,0x291d00a4,0x00000000}},	//   लें_, _отдо, luwa_,
  { {0xbbdc0053,0x2292085a,0x7529003b,0x00000000}},	//   _बल्क, rško_, ptez,
  { {0x00000000,0x00000000,0x00000000,0x00000000}},	//     ,   ,   ,
  { {0x7d1600ac,0x38a90066,0x2a6d1e50,0x00000000}},	//   vrys, túry_, _loeb_,
  { {0xc7b200b5,0x2baf0053,0x7e561e51,0x00000000}},	//   ָבן_, _जुला, нтац,
  { {0x9f5c0ac6,0x291d10ca,0x683301f7,0x00000000}},	//   _því_, kuwa_, lıdı,
  { {0xafe6064b,0xe3b80058,0xec7a01d5,0x00000000}},	// [2da0] _попл, ngın_, ппа_,
  { {0xb21b0146,0x22490122,0xcf46000d,0x00000000}},	//   nhæn, _zaak_, _зной,
  { {0xddcd08ed,0x66c5013d,0x6bd70044,0x00000000}},	//   rkaš, iókb, فوكس_,
  { {0xdceb005b,0x7d160b9d,0xb906066e,0x00000000}},	//   _çiğn, prys, ездк,
  { {0xe2970047,0x3ea01e52,0x38c8005d,0x00000000}},	//   עכנט_, mnit_, واتی_,
  { {0x6d461e53,0x4973000d,0x3ea01e54,0x00000000}},	//   _iska, ыліс, lnit_,
  { {0x7c3e0fea,0x501b0063,0x6386006c,0x00000000}},	//   mepr, לוסו, _méné,
  { {0x3ea01e55,0x3944004b,0x7c3e1e56,0x00000000}},	//   nnit_, _tsms_, lepr,
  { {0x224900e8,0xb21b0146,0x3ea0058e,0x00000000}},	//   _raak_, fhæn, init_,
  { {0xf548001b,0x224914c2,0xa9230078,0x00000000}},	//   _vụ_, _saak_, ėžta,
  { {0x7c3e1e57,0xd764007e,0x2c1e0082,0x00000000}},	//   iepr, _جنای, _पाईं_,
  { {0xd62a0076,0xf548008b,0x270c004c,0x00000000}},	//   _ходе_, _tụ_, měn_,
  { {0x224902b0,0x63860164,0xc05b0086,0x00000000}},	//   _vaak_, _béné, пів_,
  { {0x3ea01e58,0x68330058,0x7c3e1e59,0x00000000}},	//   enit_, cıdı, jepr,
  { {0x270c0080,0x22490179,0x9f340086,0x00000000}},	//   něn_, _taak_, лері,
  { {0x644a1e5a,0xada30066,0xceb8005e,0x00000000}},	//   _hafi, ylúč, ељу_,
  { {0x443e0173,0x5ff5005a,0x61ed0137,0x00000000}},	// [2db0] oet_, _изпу, _ifal,
  { {0x638603b2,0x443e1af0,0x3ea00072,0x00000000}},	//   _géné, net_, anit_,
  { {0x443e02b0,0x644a1e5b,0xa3c20053,0x00000000}},	//   iet_, _mafi, ्धि_,
  { {0x443e1e5c,0x291d00a4,0xd9990021,0x00000000}},	//   het_, tuwa_, ونات_,
  { {0x61ed0035,0x7c3e0006,0x443e1e5d,0x00000000}},	//   _mfal, bepr, ket_,
  { {0x443e1e5e,0x644a1e5f,0x1d160063,0x00000000}},	//   jet_, _nafi, _בקשר_,
  { {0x443e1e60,0x61ed001f,0x1ab5000d,0x00000000}},	//   det_, _ofal, _абвя,
  { {0x2f5c0047,0x443e1e61,0xead40085,0x00000000}},	//   לדונ, eet_, _бось,
  { {0x443e1e62,0xe5710021,0x16620121,0x00000000}},	//   fet_, شطة_, рвым,
  { {0xf990007e,0x443e1e63,0x3ea0004c,0x00000000}},	//   _طبق_, get_, znit_,
  { {0x6833005b,0x53a506b4,0x644a1e64,0x00000000}},	//   rıdı, танб, _dafi,
  { {0x7c3e1e65,0x6833005b,0xb21b00b9,0x00000000}},	//   zepr, sıdı, shæn,
  { {0x443e1e66,0x63860164,0x3ea00080,0x00000000}},	//   bet_, _péné, vnit_,
  { {0x61ed0185,0x6143005e,0x6d4600a8,0x00000000}},	//   _efal, јера, _rska,
  { {0x63860003,0xc0030095,0x3ea0004c,0x00000000}},	//   _véné, рпск, tnit_,
  { {0x6d460df9,0x644a1e67,0xb5fd0023,0x00000000}},	//   _pska, _zafi, ekšz,
  { {0x7c3e1e68,0x63860003,0xf1bf002b,0x00000000}},	// [2dc0] tepr, _téné, ffáu_,
  { {0x3ea01e69,0x764b002c,0x711b0047,0x00000000}},	//   snit_, _lagy, _קויפ,
  { {0x6d460045,0x290d1e6a,0x7c3e1e6b,0x00000000}},	//   _wska, _avea_, repr,
  { {0x7c3e1e6c,0x764b1e6d,0x443e1e6e,0x00000000}},	//   sepr, _nagy, zet_,
  { {0x443e1e6f,0x98a600a8,0x6d461e70,0x00000000}},	//   yet_, stoč_, _uska,
  { {0x443e1374,0x68ed00ed,0xfd5f0013,0x00000000}},	//   xet_, íada, huyệ,
  { {0x644a1e71,0x443e1c38,0xe7370699,0x00000000}},	//   _rafi, vet_, веј_,
  { {0x6e241e72,0x6d440051,0x443e1e73,0x00000000}},	//   ngib, owia, wet_,
  { {0x48e6019d,0x7ae9017f,0x644a001f,0x00000000}},	//   _розв, _četi, _pafi,
  { {0x54530076,0x443e1e74,0x44270290,0x00000000}},	//   авьт, uet_, _ccn_,
  { {0x6602024a,0x443e1e75,0xbc1b0047,0x00000000}},	//   _teok, ret_, וויש,
  { {0x92580076,0x443e1e76,0x644a05b3,0x00000000}},	//   вают_, set_, _wafi,
  { {0x443e1e77,0x3e750137,0x644a1e78,0x00000000}},	//   pet_, _mått_, _tafi,
  { {0x84380032,0x649a0054,0x66c5013d,0x00000000}},	//   _أكثر_, _ютер_, móka,
  { {0x66c500ea,0xe2080022,0xa381004e,0x00000000}},	//   lóka, _stół_, õõte,
  { {0x645d003d,0x3e7500c7,0x6e240290,0x00000000}},	//   ēsie, _nått_, ggib,
  { {0x51870304,0x3f8a004c,0x6aa2017c,0x00000000}},	// [2dd0] _шука, azbu_, dnof,
  { {0x673a09b0,0x1acb0053,0x20c40072,0x00000000}},	//   _optj, िष्ठ, löin_,
  { {0x764000fe,0xdfd1007e,0x290d0137,0x00000000}},	//   kemy, _ديد_, _svea_,
  { {0xb21b00b9,0x6aa200ac,0xc3330063,0x00000000}},	//   skæf, gnof, יוע_,
  { {0x0d640062,0x66ea0051,0x202a0014,0x00000000}},	//   _кърм, _ręka, _ýtið_,
  { {0x66d50006,0xfaf3005d,0x66c5013d,0x00000000}},	//   _iški, _نثر_, dóka,
  { {0x3e751e79,0x9f5100ea,0x764b0078,0x00000000}},	//   _fått_, mazó_, _pagy,
  { {0x3e750a2e,0x9f51006d,0xb21b01e1,0x00000000}},	//   _gått_, lazó_, nkæd,
  { {0xdd1201f7,0xb5fd00c2,0x7d0d1e7a,0x00000000}},	//   _müşt, ljšk, nsas,
  { {0x229200c3,0x7c25001f,0x9f510331,0x00000000}},	//   mški_, nghr, nazó_,
  { {0x2292007d,0xc759008f,0x6d440022,0x00000000}},	//   lški_, šībā, zwia,
  { {0xad9b0b23,0x09b50047,0x229200c2,0x00000000}},	//   _reún, ָפֿט_, oški_,
  { {0xd5bb0088,0x44270013,0x9f580003,0x00000000}},	//   _ўсе_, _tcn_, mbré_,
  { {0xd3780051,0x351a0047,0xc4840500,0x00000000}},	//   być_, _נוצנ, _клік,
  { {0xa3c90053,0xe29a086c,0x64411e7b,0x00000000}},	//   लेख_, _пак_, meli,
  { {0x26dd0150,0x6d440022,0xb22602b3,0x00000000}},	//   _jiwo_, twia, _смил,
  { {0x7d0d00bb,0x62840009,0xdd12005b,0x00000000}},	// [2de0] gsas, _ilio, _düşt,
  { {0x64411e7c,0x76400051,0x5046005e,0x00000000}},	//   neli, zemy, _сеоб,
  { {0x61e900c3,0x44e90025,0xe47a0047,0x00000000}},	//   žele, _lú_, ערעכ,
  { {0xa3ab0053,0x64410aba,0xaaba007e,0x00000000}},	//   _कुछ_, heli, ردار_,
  { {0x44e9007a,0xd3780051,0x64411e7d,0x00000000}},	//   _nú_, zyć_, keli,
  { {0x7ae9017f,0x64411e7e,0x200a002c,0x00000000}},	//   _četv, jeli, nabi_,
  { {0x64410fdf,0xeef60063,0xd6da1e7f,0x00000000}},	//   deli, אמֶר_, нти_,
  { {0x224200d1,0x200a0222,0x66c500ea,0x00000000}},	//   jekk_, habi_, tóka,
  { {0x49ca0138,0x64411e80,0x44e91e81,0x00000000}},	//   _члан_, feli, _cú_,
  { {0x200a172b,0x27f701c2,0x62841e82,0x00000000}},	//   jabi_, čení_, _alio,
  { {0x44e90024,0xa8570063,0x7d0d013d,0x00000000}},	//   _eú_, _תיבה_, zsas,
  { {0x26dd0150,0x66c500ea,0x75200035,0x00000000}},	//   _giwo_, lókn, pumz,
  { {0x44e91e83,0xd3780022,0x64411e84,0x00000000}},	//   _gú_, syć_, beli,
  { {0x657d000e,0x64411e85,0x224d189f,0x00000000}},	//   øshe, celi, žek_,
  { {0x447b00b5,0xdfd5014c,0x1ee7007e,0x00000000}},	//   _אנגע, ровы, اوری_,
  { {0x7d0d021e,0x20050022,0xdd2d0078,0x00000000}},	//   tsas, źli_, _vėžy,
  { {0x320b0034,0x629d0003,0x7d0d01cf,0x00000000}},	// [2df0] macy_, érou, usas,
  { {0x7d0d1e86,0xb21b01e1,0x320b0ac3,0x00000000}},	//   rsas, skæd, lacy_,
  { {0x628400fe,0x66d50006,0x7d0d1e87,0x00000000}},	//   _ylio, _iškv, ssas,
  { {0x64411e88,0x639b0047,0xd3570063,0x00000000}},	//   zeli, עסאנ, טיבי_,
  { {0x4425001f,0x64411e89,0x1958000d,0x00000000}},	//   ygl_, yeli, лацы_,
  { {0xfc67005a,0x7e6d0019,0x229202f7,0x00000000}},	//   _съмн, ljap, rški_,
  { {0x44e91e8a,0xb5fd00c3,0x64411e8b,0x00000000}},	//   _sú_, ljši, veli,
  { {0x7f3c0047,0x7be3005b,0x64411e8c,0x00000000}},	//   געהו, ştuğ, weli,
  { {0xb5fd00c3,0x26c3001c,0xc9870001,0x00000000}},	//   njši, ējo_, _суви,
  { {0x99840032,0x62841e8d,0x44e90013,0x00000000}},	//   _الكو, _slio, _vú_,
  { {0x4615006a,0x200a00c3,0x62841e8e,0x00000000}},	//   _نوار, vabi_, _plio,
  { {0x44e9018d,0xc5d5019d,0xa5f90001,0x00000000}},	//   _tú_, _кіль, _реду_,
  { {0x273100aa,0x22421609,0x200a002c,0x00000000}},	//   _hơn_, rekk_, tabi_,
  { {0xe3b0006a,0x0574005d,0x251a009d,0x00000000}},	//   _کره_, _دامد, _יונא,
  { {0x200a05c9,0x672308f0,0xd0071e8f,0x00000000}},	//   rabi_, nunj, ресе_,
  { {0x62840009,0x200a1e90,0x66c510fd,0x00000000}},	//   _ulio, sabi_, ióko,
  { {0x6146000a,0xb2bb0165,0xee370001,0x00000000}},	// [2e00] _тепа, _במקר, јну_,
  { {0xcc87000d,0x6723017e,0x3e7c004c,0x00000000}},	//   абуе_, kunj, _míti_,
  { {0x69c90089,0x6723017e,0x0b460cdf,0x00000000}},	//   _azee, junj, рнен,
  { {0x533600b5,0xb4c10053,0xba170044,0x00000000}},	//   ינען_, ंतु_, ليما_,
  { {0x656f00bd,0x66c500ea,0xe6da0014,0x00000000}},	//   ächl, tókn, ðsíð,
  { {0x57f30dd5,0x6abb00ac,0xfb26007e,0x00000000}},	//   општ, _ekuf, _پرسپ,
  { {0x61e401e3,0xa7b81485,0x2731008b,0x00000000}},	//   _ogil, ылку_, _cơn_,
  { {0x66c50026,0x2baf0042,0x22820046,0x00000000}},	//   sókn, _जुटा, _sókn_,
  { {0x54b80062,0x320b1e91,0xe5c60121,0x00000000}},	//   лгия_, vacy_, шско,
  { {0x6723017f,0x14180021,0x44380014,0x00000000}},	//   bunj, ديدة_, ýr_,
  { {0x69c01e92,0x94730044,0x88bb009a,0x00000000}},	//   _hyme, تديا, _יזמי,
  { {0x9f610003,0x442a0022,0x69c00050,0x00000000}},	//   _épée_, żb_, _kyme,
  { {0xe2980088,0x320b1e93,0x3254000d,0x00000000}},	//   раў_, racy_, цвяр,
  { {0x4035005e,0x61e41e94,0xdfa702d8,0x00000000}},	//   љевс, _egil, ајбо,
  { {0xcebb0001,0xddc4003d,0xddc60051,0x00000000}},	//   вља_, ndiņ, _nakł,
  { {0x33db0063,0x6e640054,0x6d58008f,0x00000000}},	//   _בחוד, отуж, āvan,
  { {0xe1ff1795,0x629d1e95,0x7e6d01a9,0x00000000}},	// [2e10] mbó_, miso, rjap,
  { {0xfd4d00aa,0x6aa900d1,0xc1bc0063,0x00000000}},	//   _khoả, _sjef, _במחש,
  { {0x69c01e96,0x629d1098,0xf092009d,0x00000000}},	//   _ayme, oiso, _זני_,
  { {0x69c000e8,0x67230035,0x6d4b0014,0x00000000}},	//   _byme, vunj, ægas,
  { {0x69c00185,0x2731008b,0xe9471e97,0x00000000}},	//   _cyme, _sơn_, рхео,
  { {0x6c850021,0x67231e98,0x629d1e99,0x00000000}},	//   _السم, tunj, hiso,
  { {0x3e7c0080,0x80380041,0x629d1e9a,0x00000000}},	//   _síti_, ינגע_, kiso,
  { {0x9aa5006a,0x629d0035,0x7ae00006,0x00000000}},	//   _امرو, jiso, _gimt,
  { {0xddc60045,0x69c00185,0xddc4004c,0x00000000}},	//   _zakł, _gyme, ojiš,
  { {0xd8740032,0x61e4001f,0x67231e9b,0x00000000}},	//   _والب, _sgil, punj,
  { {0xdb1c1e9c,0xe3b10021,0x58ba0041,0x00000000}},	//   _pyré, ثرة_, _עמעצ,
  { {0x22920066,0x216a0e82,0xeb3a0041,0x00000000}},	//   yšku_, гими_, נערש,
  { {0x68e102ab,0xe297007f,0x68e9004d,0x00000000}},	//   _kild, сая_, _jued,
  { {0x629d1e9d,0xd4660062,0xa4d40054,0x00000000}},	//   aiso, _гише_, _дочі,
  { {0xf1bf00ea,0x629d1e9e,0x61e91e9f,0x00000000}},	//   lgál_, biso, žela,
  { {0x681b003d,0x673c00fe,0x629d1ea0,0x00000000}},	//   lādē, _ärje, ciso,
  { {0x7ae00006,0x7afb003b,0x2292004c,0x00000000}},	// [2e20] _rimt, _ăuta, ušku_,
  { {0xcb6a0001,0x7ae91ea1,0x2292007d,0x00000000}},	//   лазе_, _četr, ršku_,
  { {0xb5fd00c3,0x60db0063,0x394d1ea2,0x00000000}},	//   ljšu, _תקינ, _ases_,
  { {0x68e1001f,0x7f3b0047,0x68e901e1,0x00000000}},	//   _aild, _געטו, _bued,
  { {0x39130086,0x68e11ea3,0xb5fd00c2,0x00000000}},	//   змір, _bild, njšu,
  { {0xbcfb0026,0x96f8000d,0x69c0027d,0x00000000}},	//   _bréf, аект_, _vyme,
  { {0xb21b0146,0xd6d00032,0xbb860021,0x00000000}},	//   mhæv, وقت_, _الأي,
  { {0xdd080024,0x994c0024,0x567800a0,0x00000000}},	//   _môže, môže_, рбия_,
  { {0xc9aa0088,0xd5ba0be6,0x68e1011d,0x00000000}},	//   _свае_, ыск_, _fild,
  { {0x68e1007a,0x629d001f,0x44fb00be,0x00000000}},	//   _gild, wiso, _dª_,
  { {0x66c500ea,0x629d0ece,0xa5bd0078,0x00000000}},	//   iókj, tiso, ngųj,
  { {0xc879003b,0x25a90130,0xe1d90054,0x00000000}},	//   _ruşi_, _žale_, идні_,
  { {0xe1ff1ea4,0x75d6007e,0x25ab0066,0x00000000}},	//   rbó_, _ايشا, čilú_,
  { {0xfd4d008b,0xc879003b,0xcff40062,0x00000000}},	//   _thoả, _puşi_, зпръ,
  { {0x66d50006,0xe7f00053,0xb21b01e1,0x00000000}},	//   _iškr, _चलना_, dhæv,
  { {0xc3330041,0x6e9408ac,0x82a4007b,0x00000000}},	//   _זוק_, пису, _најж,
  { {0xcc990138,0xe29f007a,0xcc75005e,0x00000000}},	// [2e30] авац_, mið_, огаћ,
  { {0xe29f007a,0x68e9006d,0x5c740054,0x00000000}},	//   lið_, _rued, плут,
  { {0xa0360063,0x68e91ea5,0x41b5007e,0x00000000}},	//   _ואתה_, _sued, _دمکر,
  { {0x68e90814,0x66f1003d,0xe29f0026,0x00000000}},	//   _pued, _nāka, nið_,
  { {0x68e91ea6,0x68e11ea7,0xa96908ef,0x00000000}},	//   _qued, _pild, рила_,
  { {0xbcfb0164,0xaf34006a,0x26c40a02,0x00000000}},	//   _préf, _بریت, elmo_,
  { {0xe29f007a,0x3ea91ea8,0x907c0047,0x00000000}},	//   kið_, onat_, רטוי,
  { {0x68e9001f,0x3ea91ea9,0x66e20062,0x00000000}},	//   _tued, nnat_, моща,
  { {0x394d0034,0x68e105dd,0x30e30047,0x00000000}},	//   _uses_, _tild, _שריפֿ,
  { {0x9f880026,0xa4d6005e,0xe29f0014,0x00000000}},	//   kóða_, одњу_, eið_,
  { {0xb8df016a,0xe29f007a,0x9f880026,0x00000000}},	//   ीत_, fið_, jóða_,
  { {0xe29f007a,0x6d5d1eaa,0x6d4f1eab,0x00000000}},	//   gið_, _orsa, _osca,
  { {0xa5091857,0xd176000d,0x3ea91eac,0x00000000}},	//   _тела_, цыны, dnat_,
  { {0xcfaa0021,0x39400058,0x3e7c0014,0x00000000}},	//   لازم_, çisi_, _lítt_,
  { {0x6d4f1ead,0x78a40139,0x6d5d1eae,0x00000000}},	//   _asca, éivi, _arsa,
  { {0x3ea90268,0xd5f90047,0xe8df008d,0x00000000}},	//   gnat_, שפּר, _baịo_,
  { {0x660b000f,0x3ce30122,0x61f600c7,0x00000000}},	// [2e40] _megk, _bijv_, _ifyl,
  { {0x660b00ea,0xa7fc005b,0x6d5d00c2,0x00000000}},	//   _legk, _anın, _drsa,
  { {0x6d5d089f,0x6d4f03e1,0x9b1a005d,0x00000000}},	//   _ersa, _esca, شتاز_,
  { {0xfaa31eaf,0x00000000,0x00000000,0x00000000}},	//   махо,   ,   ,
  { {0x82d70047,0xbcfb1eb0,0xb21b01e1,0x00000000}},	//   קונג_, _créd, phæv,
  { {0x3ea01eb1,0x66f1001c,0x66c5013d,0x00000000}},	//   liit_, _sāka, lókh,
  { {0x8cb90042,0xa3de0042,0x00000000,0x00000000}},	//   ्तरो, _दृढ_,   ,
  { {0xbcfb04d4,0x9f58006d,0x7bce003b,0x00000000}},	//   _fréd, laró_, _izbu,
  { {0x94aa000a,0x95d7005a,0x442e1eb2,0x00000000}},	//   итоа_, одът_, _pcf_,
  { {0x3ea91eb3,0x3ead01b3,0x7afe00d1,0x00000000}},	//   znat_, četi_, oppt,
  { {0xe29f007a,0xbcfb0c77,0x69c600d1,0x00000000}},	//   tið_, _trég, _økeb,
  { {0x556600de,0x00000000,0x00000000,0x00000000}},	//   _وهاك,   ,   ,
  { {0xe29f0ac6,0x3ea91260,0x3ea0004b,0x00000000}},	//   rið_, vnat_, diit_,
  { {0xe29f0026,0x648d0025,0xf8ca0053,0x00000000}},	//   sið_, _cúid, ितिय,
  { {0xc058019d,0x64481eb4,0x3f85004a,0x00000000}},	//   ція_, medi, álu_,
  { {0x442c0122,0x82f7007e,0xe29800e1,0x00000000}},	//   lgd_, _بروز_, _мај_,
  { {0x442c006f,0x3ea91eb5,0x2d580121,0x00000000}},	// [2e50] ogd_, rnat_, оить_,
  { {0xebc70001,0x64481eb6,0x442c1eb7,0x00000000}},	//   ољен, nedi, ngd_,
  { {0x442c006f,0x6448006f,0x3ea90137,0x00000000}},	//   igd_, iedi, pnat_,
  { {0x20110117,0xbcfb1eb8,0xe8df008d,0x00000000}},	//   lazi_, _préd, _taịo_,
  { {0x6d5d00bd,0x2900003b,0x660b1eb9,0x00000000}},	//   _ursa, ţian_, _regk,
  { {0x64480117,0xbcfb03b2,0x6f150022,0x00000000}},	//   jedi, _crée, oszc,
  { {0x6d4d0122,0x6e2d0290,0x64481eba,0x00000000}},	//   lwaa, ogab, dedi,
  { {0x442c006f,0x915e0013,0x657d05e7,0x00000000}},	//   egd_, hắc_, øsho,
  { {0x6e2d1ebb,0x6d4d0717,0x20111ebc,0x00000000}},	//   igab, nwaa, kazi_,
  { {0x442c0137,0x660b0760,0xbcfb006c,0x00000000}},	//   ggd_, _wegk, _grée,
  { {0xe7f00053,0xe3b9005e,0x6f150022,0x00000000}},	//   _चलता_, сбн_, jszc,
  { {0x442c016d,0x6d4d1ebd,0x395f08f2,0x00000000}},	//   agd_, kwaa, _krus_,
  { {0x6f150045,0x6464000c,0x6d4d00ca,0x00000000}},	//   eszc, _ştiţ, jwaa,
  { {0x6448156f,0x6d4d1031,0x6723007d,0x00000000}},	//   cedi, dwaa, ornj,
  { {0x6e2d00bd,0x6d4d0229,0x7529003b,0x00000000}},	//   fgab, ewaa, luez,
  { {0xa7fc005b,0xa2060121,0x6d4d0229,0x00000000}},	//   _anıl, _эпид, fwaa,
  { {0x6d4d0438,0x9f58032a,0xa0a60002,0x00000000}},	// [2e60] gwaa, taró_, _наид,
  { {0x3137014e,0x66f1001c,0xddcb005b,0x00000000}},	//   _צריך_, _nāko, şişl,
  { {0x307b014e,0x395f053b,0x6e2d004d,0x00000000}},	//   _האינ, _arus_, bgab,
  { {0x62861ebe,0x66c50014,0xe9da0121,0x00000000}},	//   nkko, bóki, бке_,
  { {0xb9e30086,0x9f58006d,0x628600fe,0x00000000}},	//   ніши, paró_, ikko,
  { {0x7d161ebf,0xcee9005d,0x6aab0740,0x00000000}},	//   msys, _درین_, angf,
  { {0xa7370021,0x7bce007d,0x64481ec0,0x00000000}},	//   كثير_, _uzbu, vedi,
  { {0xd90d007e,0x6448001f,0x98ac0058,0x00000000}},	//   _چین_, wedi, ılıp_,
  { {0x644801f7,0x7d161ec1,0x201102cc,0x00000000}},	//   tedi, nsys, yazi_,
  { {0x7ce90006,0x442c006f,0x6f150051,0x00000000}},	//   _užre, ugd_, yszc,
  { {0x442c006f,0x6d4d006f,0x64481ec2,0x00000000}},	//   rgd_, zwaa, redi,
  { {0x64481ec3,0xa25b0164,0x201102ae,0x00000000}},	//   sedi, plôm, wazi_,
  { {0xd6270086,0x64481b69,0x20111ec4,0x00000000}},	//   _хоче_, pedi, tazi_,
  { {0x7d161ec5,0x44f2002b,0x62861ec6,0x00000000}},	//   dsys, _iâ_, akko,
  { {0x543b00b5,0x2fc50146,0x201102e2,0x00000000}},	//   _לעגא, ælg_, razi_,
  { {0x6d4d006f,0x6f150022,0x62861ec7,0x00000000}},	//   twaa, rszc, ckko,
  { {0x20110290,0x6aa21c6c,0xa7fc0058,0x00000000}},	// [2e70] pazi_, diof, _anım,
  { {0x6d4d0ac8,0x6e2d00bd,0x787d0164,0x00000000}},	//   rwaa, sgab, _lèvr,
  { {0x2900000c,0x6d4d0f5e,0x6e2d008f,0x00000000}},	//   ţial_, swaa, pgab,
  { {0x67230198,0x7aee0268,0x66f1003d,0x00000000}},	//   vrnj, _dubt, _sāko,
  { {0x6d4d0089,0x224b030c,0x2d4d007d,0x00000000}},	//   qwaa, ieck_, _uže_,
  { {0xccf20063,0xba77007e,0xbcfb0b6c,0x00000000}},	//   _בכך_, _کاست, _tréb,
  { {0xe7391ec8,0xe7fe0042,0x00000000,0x00000000}},	//   цей_, _उभरा_,   ,
  { {0x61e9027c,0x05650076,0xbcfb1ec9,0x00000000}},	//   želj, двин, _gréc,
  { {0xb3450016,0x395f0228,0x648d0025,0x00000000}},	//   _opçã, _urus_, _núic,
  { {0xb21b0583,0x628d01cf,0x69c604aa,0x00000000}},	//   skæl, _alao, _økea,
  { {0xdc380047,0xa2670078,0x8c1a009a,0x00000000}},	//   לאזט_, _dėžę_, חותי,
  { {0x78a300fe,0xd29a0086,0x11d60086,0x00000000}},	//   linv, ітні_, дігр,
  { {0x6286024a,0x752904a6,0x78a301f4,0x00000000}},	//   rkko, quez, oinv,
  { {0x62860004,0x7d1617d5,0xc4db005e,0x00000000}},	//   skko, vsys, _уђе_,
  { {0xae7a0121,0x224b1eca,0xf486005d,0x00000000}},	//   осах_, beck_, _زاوی,
  { {0xee3a0088,0x92b60032,0x628d0025,0x00000000}},	//   ўна_, _تحتا, _glao,
  { {0x78a31ecb,0x7aee1ecc,0x7afc005f,0x00000000}},	// [2e80] kinv, _subt, _strt,
  { {0x79820035,0x7d161ecd,0x70770044,0x00000000}},	//   vyow, rsys, _يميز_,
  { {0xbcfb03b2,0x7d1602e0,0xbb4a01f3,0x00000000}},	//   _préc, ssys, تلان_,
  { {0x8b650032,0x49ca05bd,0x1e831ece,0x00000000}},	//   عالم, олен_, _алюм,
  { {0xd910007e,0x7d030062,0x7bc70046,0x00000000}},	//   ایط_, _изяж, _eyju,
  { {0x787d1ecf,0xa9670121,0x91bb009d,0x00000000}},	//   _sèvr, ьича_, חמני,
  { {0x93bc003b,0x212b0022,0x00000000,0x00000000}},	//   ngăt, zuch_,   ,
  { {0xdb0e0051,0x96341ed0,0x78a30050,0x00000000}},	//   _wybó, хниц, ainv,
  { {0xfaa30001,0x61e91ed1,0xd44a012c,0x00000000}},	//   _рато, želk, оянд_,
  { {0xb21b00b9,0x5454000d,0x224b004d,0x00000000}},	//   rkæm, хвот, weck_,
  { {0x224b004d,0xd251002a,0x7d0b013d,0x00000000}},	//   teck_, هند_, ágsz,
  { {0x6d460146,0x68e81ed2,0xddcd003b,0x00000000}},	//   _opka, _hidd, njaţ,
  { {0x656f00bd,0x93bc000c,0x224b1ed3,0x00000000}},	//   ächt, egăt, reck_,
  { {0x68e81ed4,0x557700b5,0x212b0221,0x00000000}},	//   _jidd, _קעגן_, ruch_,
  { {0x212b00bd,0x6d460df9,0x68e807f3,0x00000000}},	//   such_, _apka, _midd,
  { {0x65621ed5,0x68e81ed6,0x443e1ed7,0x00000000}},	//   _kroh, _lidd, lft_,
  { {0x7bca00bd,0x61ed0019,0x64581ed8,0x00000000}},	// [2e90] üfun, _igal, _kavi,
  { {0xbcfb03b2,0x443e00bd,0x61fa0080,0x00000000}},	//   _créa, nft_, ětle,
  { {0xbcfb0027,0x661d00eb,0x9be4000d,0x00000000}},	//   _dréa, ųski, віцк,
  { {0x69dd01d1,0x80ad0042,0x64581ed9,0x00000000}},	//   _úsek, ँचवे, _lavi,
  { {0xbcfb0025,0xdb1c0114,0x78a31eda,0x00000000}},	//   _fréa, _vyrá, tinv,
  { {0xbcfb0027,0x443e0122,0x68e8005b,0x00000000}},	//   _gréa, jft_, _cidd,
  { {0x68e80185,0x69c600d1,0x78a31edb,0x00000000}},	//   _didd, _øken, rinv,
  { {0x443e1edc,0x68e8001f,0xca240121,0x00000000}},	//   eft_, _eidd, _аффи,
  { {0x443e1edd,0x68e81ede,0x64581edf,0x00000000}},	//   fft_, _fidd, _bavi,
  { {0xe1fa0161,0x656200bd,0x61ed1ee0,0x00000000}},	//   ूर्ण_, _droh, _agal,
  { {0x53c90086,0x7ae90006,0x64581ee1,0x00000000}},	//   ягом_, _kiet, _davi,
  { {0x7e7d001c,0x656f00bd,0xb607000d,0x00000000}},	//   _nosp, ächs, _цяжк,
  { {0xe5690062,0x65621ee2,0xdce7004c,0x00000000}},	//   _хилд_, _groh, áměs,
  { {0x61ed1ee3,0x7ae91ee4,0x645812d0,0x00000000}},	//   _egal, _liet, _gavi,
  { {0xb4cb0053,0xf8b20063,0x7e7d1ee5,0x00000000}},	//   लती_, אשם_, _bosp,
  { {0x7e7d1ee6,0x7ae91ee7,0x645804d9,0x00000000}},	//   _cosp, _niet, _zavi,
  { {0xbcfb1ee8,0x7e7d1ee9,0x753b1eea,0x00000000}},	// [2ea0] _préa, _dosp, ntuz,
  { {0xe0d204f6,0x765900f6,0x6ab80053,0x00000000}},	//   _حزب_, _lawy, इक्र,
  { {0xa09b0047,0x7ae90321,0xcb090086,0x00000000}},	//   _זייט, _biet, дхід_,
  { {0x68e81eeb,0xc3320063,0x69c900ac,0x00000000}},	//   _sidd, רוא_, _byee,
  { {0x64430051,0x7ae91eec,0x443e0026,0x00000000}},	//   _obni, _diet, yft_,
  { {0x7d041eed,0x00000000,0x00000000,0x00000000}},	//   mpis,   ,   ,
  { {0x7ce90006,0x7d041eee,0x64581eef,0x00000000}},	//   _užra, lpis, _ravi,
  { {0xddcd017f,0x656204a3,0xd6d708a6,0x00000000}},	//   ljaš, _proh, нты_,
  { {0x7ae30173,0xddcd085a,0x65940ada,0x00000000}},	//   ïnte, ojaš, тапу,
  { {0xd91b014e,0x64a30001,0x443e00bd,0x00000000}},	//   _מומל, лања, uft_,
  { {0xa2950086,0x443e1ef0,0x22950ac5,0x00000000}},	//   вані, rft_, виня,
  { {0xda100161,0x6458075a,0x65621ef1,0x00000000}},	//   ारित_, _wavi, _troh,
  { {0xd251006a,0x51870088,0x443e00bd,0x00000000}},	//   هنگ_, хуна, pft_,
  { {0x7e7d1ef2,0x7d041ef3,0x648d0139,0x00000000}},	//   _sosp, dpis, _húin,
  { {0x6e671ef4,0xbcfb0003,0x4fe80121,0x00000000}},	//   нтаж, _crén, емён_,
  { {0x61ed1ef5,0x66c5013d,0xd13b066f,0x00000000}},	//   _ugal, lókr, _ехо_,
  { {0xd904007e,0xac271ef6,0x648d0139,0x00000000}},	// [2eb0] _دی_, ефек, _múin,
  { {0xd1400051,0x7ae91ef7,0x22b6001c,0x00000000}},	//   żący_, _siet, māka_,
  { {0x22b6001c,0x7ae91ef8,0x7d041ef9,0x00000000}},	//   lāka_, _piet, apis,
  { {0xe9f80054,0xc333009d,0x00000000,0x00000000}},	//   енці_, טוע_,   ,
  { {0x273a0122,0x69c600d1,0xddcd007d,0x00000000}},	//   eën_, _økel, bjaš,
  { {0x2ca50014,0x07a51efa,0xd8220363,0x00000000}},	//   _öld_, калн, адши,
  { {0x6b8300c7,0x648d0026,0x7ae91efb,0x00000000}},	//   ängd, _búin, _tiet,
  { {0xdddd003d,0x22b6001c,0x648d0139,0x00000000}},	//   _nosū, kāka_, _cúin,
  { {0x648d0027,0x765b0e6f,0xf5050094,0x00000000}},	//   _dúin, rduy, ъзпо,
  { {0xb4cb0053,0x753b1efc,0x66c50014,0x00000000}},	//   लते_, rtuz, tóks,
  { {0x7d040c22,0x648d0139,0xb7670054,0x00000000}},	//   zpis, _fúin, _ятай,
  { {0xddcd0b59,0x3dc60022,0x7d041efd,0x00000000}},	//   zjaš, żowi_, ypis,
  { {0x660908a4,0xe2971efe,0x22b6008f,0x00000000}},	//   mbek, тая_, gāka_,
  { {0xbcfb0003,0x66090170,0x93bc003b,0x00000000}},	//   _prén, lbek, rgăr,
  { {0xc059000d,0x3f8c0114,0x12aa0021,0x00000000}},	//   хіў_, ádu_, _يدعى_,
  { {0x7d04017f,0xe3e80047,0xbcfb1eff,0x00000000}},	//   tpis, _אַפֿ, _créo,
  { {0x7bd5051e,0xee370062,0x1ea90021,0x00000000}},	// [2ec0] _azzu, ънт_, رافي_,
  { {0x0cbe0161,0x7d04003e,0x64411f00,0x00000000}},	//   ्तेम, rpis, nfli,
  { {0x2018173f,0x26df0078,0x6441004d,0x00000000}},	//   mari_, kmuo_, ifli,
  { {0xca75000d,0x20181f01,0xfa89013c,0x00000000}},	//   лучы, lari_, нсій_,
  { {0xdb0e00c7,0x66091f02,0xc02f0013,0x00000000}},	//   _nybö, dbek, _điếu_,
  { {0x66d50006,0xd90d007e,0x75291f03,0x00000000}},	//   _išky, سیم_, drez,
  { {0x20180268,0xdb1c16af,0x22b6001c,0x00000000}},	//   iari_, _byrå, zāka_,
  { {0x201813dc,0x3eb21f04,0x6b83089f,0x00000000}},	//   hari_, nnyt_, änge,
  { {0xd9460138,0x20181f05,0xa3e40053,0x00000000}},	//   _јези, kari_, पेन_,
  { {0xb8f60235,0x3eb200fe,0x20181894,0x00000000}},	//   सत_, hnyt_, jari_,
  { {0x5334000d,0x20181f06,0x75291f07,0x00000000}},	//   ыент, dari_, arez,
  { {0x26cd1095,0x20131f08,0x558a06be,0x00000000}},	//   cleo_, _sexi_, _обем_,
  { {0x2018077d,0x75291f09,0x2499008f,0x00000000}},	//   fari_, crez, ūsma_,
  { {0x20181f0a,0xf3660f55,0x9f350454,0x00000000}},	//   gari_, _атин, легі,
  { {0xbcfb0003,0x22b6001c,0x78ad0003,0x00000000}},	//   _préo, sāka_, éavi,
  { {0x20181a61,0x26c41f0b,0xceb8005e,0x00000000}},	//   aari_, nomo_, вљу_,
  { {0x20180009,0x3f9e0014,0xf1bf009c,0x00000000}},	// [2ed0] bari_, útur_, rgás_,
  { {0x66090035,0x653b0063,0x20181f0c,0x00000000}},	//   zbek, ועמד, cari_,
  { {0x752900b2,0x6ce40054,0x26c41f0d,0x00000000}},	//   zrez, ріте, komo_,
  { {0x3e04005a,0xddcd0080,0x7d280058,0x00000000}},	//   _вярв, zdař, ürsü,
  { {0x6b830137,0x3ea91f0e,0x26c41f0f,0x00000000}},	//   ängb, miat_, domo_,
  { {0x7c870818,0x4759042c,0x08c401dd,0x00000000}},	//   _руме, ерия_, абін,
  { {0x46a5005a,0x648d0025,0xf6510021,0x00000000}},	//   лакв, _dúil, مئة_,
  { {0x75291f10,0x8579000a,0x3ea9145f,0x00000000}},	//   trez, есот_, niat_,
  { {0xd41517ab,0x2018053a,0x66091f11,0x00000000}},	//   льны, yari_, rbek,
  { {0x13090055,0x75291f12,0x478b005a,0x00000000}},	//   нной_, rrez, _осем_,
  { {0x3eb2024a,0x26cd006d,0x20181f13,0x00000000}},	//   ynyt_, pleo_, vari_,
  { {0xbcfb0164,0x26c41f14,0x20181f15,0x00000000}},	//   _prél, como_, wari_,
  { {0xe56e0138,0x3ea91f16,0x20181f17,0x00000000}},	//   _уз_, diat_, tari_,
  { {0x291d0150,0x291f05b3,0xbcfb0003,0x00000000}},	//   iswa_, _mvua_, _crém,
  { {0x20181f18,0x3ea91f19,0x212b1f1a,0x00000000}},	//   rari_, fiat_, arch_,
  { {0x20181f1b,0x22b6008f,0x22920066,0x00000000}},	//   sari_, māko_, yšky_,
  { {0x8d661485,0xbcfb0003,0x22b6001c,0x00000000}},	// [2ee0] ывае, _frém, lāko_,
  { {0x26c40035,0x219b009f,0xeb9a0fc3,0x00000000}},	//   zomo_, _נביא, низ_,
  { {0x26c40009,0x3ea90089,0x0c370021,0x00000000}},	//   yomo_, biat_, اكمة_,
  { {0x3ea91f1c,0x648d0139,0x7e5601ce,0x00000000}},	//   ciat_, _súil, _стоц,
  { {0x2292004c,0x38140085,0xa9671f1d,0x00000000}},	//   ušky_, амлё, лица_,
  { {0x61d70063,0x6e360078,0xdca601ce,0x00000000}},	//   נוסף_, lgyb, _саги,
  { {0x26c41f1e,0x37a70062,0x38cb007e,0x00000000}},	//   tomo_, лтън_, راهی_,
  { {0x212b001f,0x2120027c,0x7f3b0047,0x00000000}},	//   yrch_, _ovih_, געקו,
  { {0x7afb00c2,0x3f8a01c2,0x44f40141,0x00000000}},	//   _čuti, hybu_, јпос,
  { {0x44380199,0x26c40035,0xb9930021,0x00000000}},	//   ür_, somo_, _الكب,
  { {0x22b6008f,0x212b002b,0xa2b50e82,0x00000000}},	//   gāko_, wrch_, ибоч,
  { {0x92580076,0x6b8101a8,0x7ae2136f,0x00000000}},	//   гают_, _àlge, nmot,
  { {0x3ea90994,0x212b00bd,0xa507005e,0x00000000}},	//   viat_, urch_, _беча_,
  { {0xe3a4007e,0x3ea90051,0x22b6001c,0x00000000}},	//   _پشتی, wiat_, bāko_,
  { {0x7ae200c7,0x9295000d,0x22b6008f,0x00000000}},	//   kmot, _вайц, cāko_,
  { {0x5e58019d,0x25a9007d,0x201e0014,0x00000000}},	//   лися_, _žali_, ótir_,
  { {0x3ea91f1f,0xfc670062,0xbcfb1f20,0x00000000}},	// [2ef0] riat_, лъжн, _trém,
  { {0x3ea91f21,0xe1ff1f22,0x7ae21f23,0x00000000}},	//   siat_, lcó_, emot,
  { {0x75eb000f,0xef670062,0x3ea91f24,0x00000000}},	//   _közü, _съпо, piat_,
  { {0x628f006f,0xe1ff006d,0xeaae0086,0x00000000}},	//   nkco, ncó_, ій_,
  { {0x224900f3,0x3eb9006f,0xfe360047,0x00000000}},	//   _mbak_, _ijst_, _דארך_,
  { {0xd7050062,0xf77100f2,0x7ae21f25,0x00000000}},	//   азки, قاب_, amot,
  { {0xdd0e0058,0x10380041,0x66f1008f,0x00000000}},	//   _kışl, אטום_, _nākt,
  { {0x31690045,0xa3de0080,0x22b6001c,0x00000000}},	//   _oraz_, _běží_, vāko_,
  { {0x98750086,0xef190022,0x60c71f26,0x00000000}},	//   _клац, ąży_, kojm,
  { {0x66f1003d,0xbcfb0003,0x2613008b,0x00000000}},	//   _sāku, _préj, ảo_,
  { {0x21200117,0xe3b10021,0x798b001f,0x00000000}},	//   _svih_, ترة_, lygw,
  { {0x91e61527,0x61fa004c,0x22b6008f,0x00000000}},	//   ионе, ětlo, rāko_,
  { {0x6f050025,0x661b00fe,0x51ba082d,0x00000000}},	//   _athc, mauk, тыня_,
  { {0x7ae214ba,0x859a0063,0x661b1f27,0x00000000}},	//   zmot, _בשנו, lauk,
  { {0x44fb021f,0x2376007e,0xa067005e,0x00000000}},	//   _hê_, _نمود_, јаса_,
  { {0x44fb001b,0x75eb005b,0x7bce002b,0x00000000}},	//   _kê_, _gözü, _rybu,
  { {0xdd0e005b,0x6e361f28,0x7eba0078,0x00000000}},	// [2f00] _dışl, rgyb, gįpa,
  { {0x6e36001f,0x44fb1f29,0x6d56002b,0x00000000}},	//   sgyb, _mê_, rwya,
  { {0x907b0063,0x66f1001c,0x44fb1f2a,0x00000000}},	//   _סטטי, _māks, _lê_,
  { {0x6b8300c7,0x7bce0240,0x661b1f2b,0x00000000}},	//   änga, _vybu, jauk,
  { {0x7bce0051,0x88e6047e,0x09b00053,0x00000000}},	//   _wybu, ажде, जपेय,
  { {0x99150088,0x66f1008f,0x7ae21f2c,0x00000000}},	//   сьці, _nāks, smot,
  { {0x7c47013d,0x78aa1f2d,0x7ae2059f,0x00000000}},	//   ésrő, rifv, pmot,
  { {0x62840290,0x44fb1f2e,0x661b05b5,0x00000000}},	//   _noio, _bê_, gauk,
  { {0x66f1001c,0x245b0006,0xa5070002,0x00000000}},	//   _sākt, kšmė_, аења_,
  { {0x44fb1f2f,0x07a61f30,0x75eb0058,0x00000000}},	//   _dê_, _казн, _sözü,
  { {0x2bf70063,0x57fb0149,0x8c1b0063,0x00000000}},	//   ימין_, _סלאו, כויי,
  { {0x661b0150,0x44fb017d,0x15460054,0x00000000}},	//   cauk, _fê_, _ведм,
  { {0x628f006f,0xe1ff0118,0xddd60022,0x00000000}},	//   rkco, rcó_, ndyń,
  { {0xe1ff1f31,0x160e0042,0xd59b009a,0x00000000}},	//   scó_, सरकर_, _שֹׁכ,
  { {0x60c70024,0x31690051,0x4ea71cb9,0x00000000}},	//   rojm, _wraz_, араа,
  { {0x3169017d,0xf1a70f8d,0xf2390094,0x00000000}},	//   _traz_, _врон, _спиш_,
  { {0x44fb0013,0x7c070044,0xd657009a,0x00000000}},	// [2f10] _xê_, لباك, סימת_,
  { {0xcc740138,0x7055006a,0xb035005e,0x00000000}},	//   огућ, _اندا, _унош,
  { {0x07f20047,0x9f58004c,0x7a41013d,0x00000000}},	//   _װאָס_, obrý_, játó,
  { {0x99d90021,0x66020023,0xdfd10043,0x00000000}},	//   هواء_, _nfok, _ويک_,
  { {0x661b0ab6,0x644a0022,0xe9460043,0x00000000}},	//   vauk, _obfi, مروی,
  { {0x88c8019d,0xfc67005a,0x31580047,0x00000000}},	//   алів_, _тъмн, יידן_,
  { {0x44fb00e8,0x661b00fe,0xbb850021,0x00000000}},	//   _sê_, tauk, _الزي,
  { {0x66f1001c,0xbcfb0003,0xd7f10013,0x00000000}},	//   _sāks, _préh, _mãi_,
  { {0x05680079,0xa3e4024c,0x6aa90035,0x00000000}},	//   ајќи_, पेस_, _imef,
  { {0x661b003d,0x44fb1f32,0xbcfb00cd,0x00000000}},	//   sauk, _vê_, _créi,
  { {0x661b00fe,0x97a7000d,0x44fb001f,0x00000000}},	//   pauk, _трал, _wê_,
  { {0xc7b20063,0x44fb1f33,0x6d5d1f34,0x00000000}},	//   _צבא_, _tê_, _ossa,
  { {0xd6c6006a,0xe3b1007e,0x7522007d,0x00000000}},	//   _امنی, ترک_, _gvoz,
  { {0xbcfb0025,0xa06a0001,0xb97a0063,0x00000000}},	//   _gréi, ћава_, אנשי,
  { {0xf8520066,0xb21b01e1,0xdfd2013a,0x00000000}},	//   ážiť_, rkær, سير_,
  { {0xb21b0146,0xee370782,0xed5a137c,0x00000000}},	//   skær, йнс_, лоб_,
  { {0x6cd60021,0x44270089,0xf1a9007e,0x00000000}},	// [2f20] مقرا, _kdn_, _پايه_,
  { {0x8db50086,0x4c83019c,0xcc290021,0x00000000}},	//   істі, плув, لأمم_,
  { {0x6d5d1f35,0x0b461518,0xeb2a0131,0x00000000}},	//   _essa, снен, ужел_,
  { {0x8aa50054,0x98b9008f,0xfe94005d,0x00000000}},	//   орід, _īsā_, _بیرج,
  { {0x823b0047,0xda650067,0x44270130,0x00000000}},	//   רענצ, تالي, _odn_,
  { {0x3cf10024,0x6c860021,0x7e64004e,0x00000000}},	//   ľovú_, _الآم, ldip,
  { {0x9f58006d,0x6d441f36,0xeb9a0854,0x00000000}},	//   mbró_, ltia, _сив_,
  { {0xddcd005b,0x7e641f37,0x4427146d,0x00000000}},	//   ndaş, ndip, _adn_,
  { {0x6d441d23,0x7a4100ea,0x661d0014,0x00000000}},	//   ntia, sátó, ðska,
  { {0x6d440025,0x00000000,0x00000000,0x00000000}},	//   itia,   ,   ,
  { {0x6d441169,0x6c7b0041,0x0ec80042,0x00000000}},	//   htia, אריד, लवाड,
  { {0x6d441f38,0x51870002,0xa6e6030b,0x00000000}},	//   ktia, буга, _ужел,
  { {0xe2980088,0xbcfb0025,0xd7f10013,0x00000000}},	//   саў_, _tréi, _rãi_,
  { {0x201a0150,0x1394030b,0x7ff40044,0x00000000}},	//   _cepi_, _милю, كسفا,
  { {0x6d440397,0x7ce9005f,0x5f940299,0x00000000}},	//   etia, _užri, пирт,
  { {0xb3b7009a,0xbd450044,0xda0a0082,0x00000000}},	//   _לפוג_, ينزي, हुमत_,
  { {0x98ba0042,0x5ed400de,0x00000000,0x00000000}},	// [2f30] ेवाए, ستفز,   ,
  { {0x9f550699,0xd0110044,0x5478009d,0x00000000}},	//   _двоч, _تلد_, סְּנ,
  { {0xd9f90fec,0x6d441f39,0x9b590854,0x00000000}},	//   анец_, atia, риет_,
  { {0x4ee4000d,0x6d4400a4,0x7055007e,0x00000000}},	//   _ніяз, btia, _انگا,
  { {0xa9240086,0x27330013,0x20040022,0x00000000}},	//   зділ, ọng_, śmie_,
  { {0x1869000a,0x20030045,0x9f580290,0x00000000}},	//   раки_, ncji_, mbrò_,
  { {0x7d0d04b1,0x9b090063,0xcb340062,0x00000000}},	//   lpas, _כִּ֥, _неръ,
  { {0x44271f3a,0x6aa90035,0xdd090066,0x00000000}},	//   _sdn_, _umef, _môžt,
  { {0x20030045,0x7d0d1f3b,0x94790690,0x00000000}},	//   kcji_, npas, асну_,
  { {0x8d5c0063,0x395f1f3c,0x22b6008f,0x00000000}},	//   רכזי, _isus_, māki_,
  { {0x22b6008f,0xdb1f0137,0xbcfb006c,0x00000000}},	//   lāki_, _övär, _grév,
  { {0x7d0d0150,0x68fb0213,0x201a1f3d,0x00000000}},	//   kpas, _kuud, _sepi_,
  { {0xa193000d,0x7649002b,0x68fb0bda,0x00000000}},	//   даўч, mfey, _juud,
  { {0x68fb0004,0xa06a0088,0x7649002b,0x00000000}},	//   _muud, шага_, lfey,
  { {0x6b830502,0x7d0d1f3e,0x6d44002b,0x00000000}},	//   ängl, epas, wtia,
  { {0x61f60307,0x2733008b,0x6d441f3f,0x00000000}},	//   _ugyl, ạng_, ttia,
  { {0x7d0d00bb,0x201a0397,0x6496000c,0x00000000}},	// [2f40] gpas, _tepi_, _mâin,
  { {0xd00a0001,0x6d441f40,0x7649002b,0x00000000}},	//   _њене_, rtia, hfey,
  { {0x7d0d1f41,0x395f004b,0x6d441f42,0x00000000}},	//   apas, _asus_, stia,
  { {0x7d0d00be,0x298a137a,0x5aca05ac,0x00000000}},	//   bpas, исло_, шлем_,
  { {0xc9830076,0x18740726,0x7649001f,0x00000000}},	//   дущи, згля, dfey,
  { {0xf72a0076,0xbcfb1db1,0x96f80062,0x00000000}},	//   аций_, _prév, бект_,
  { {0x7bdc001c,0xab271f43,0xdce40078,0x00000000}},	//   _uzru, _мора_, nvič,
  { {0x6496003b,0x7649001f,0x22b6008f,0x00000000}},	//   _câin, gfey, bāki_,
  { {0x20030051,0x26d8008f,0x7e9b0149,0x00000000}},	//   ycji_, ēro_, יסקו,
  { {0x60c20027,0xbcfb1f44,0x3946143b,0x00000000}},	//   _íomh, _trév, mtos_,
  { {0xc6060088,0xa3e40161,0x39461f45,0x00000000}},	//   _дзей, पें_, ltos_,
  { {0x92940088,0x69c600d1,0xdce400a8,0x00000000}},	//   даюц, _økes, dvič,
  { {0x39461f46,0x506706be,0x7d020025,0x00000000}},	//   ntos_, отва, íosl,
  { {0x39461f47,0x2733008b,0x2a641f48,0x00000000}},	//   itos_, ụng_, _lamb_,
  { {0xa295000d,0xeeab0d62,0x20030022,0x00000000}},	//   _накі, атак_, rcji_,
  { {0xc3330063,0x539b0063,0x9df9065b,0x00000000}},	//   _חוק_, _כיוו, снат_,
  { {0x3ebe0026,0x20030051,0x7d0d1f49,0x00000000}},	// [2f50] étta_, pcji_, upas,
  { {0xc0580086,0x68fb0659,0x22590b1b,0x00000000}},	//   _дію_, _ruud, lesk_,
  { {0x68fb1f4a,0x7afc02ed,0x7d0d1f4b,0x00000000}},	//   _suud, _curt, spas,
  { {0x68fb0004,0x6738007d,0x7d0d1f4c,0x00000000}},	//   _puud, duvj, ppas,
  { {0xa9691f4d,0xbcfb0153,0x39460a10,0x00000000}},	//   сила_, _crét, gtos_,
  { {0xe9d80088,0x7afc1729,0x22b6001c,0x00000000}},	//   цкі_, _furt, rāki_,
  { {0x661d0026,0x6496003b,0x7afc0e16,0x00000000}},	//   ðsko, _pâin, _gurt,
  { {0xbcfb007a,0xba770067,0x629d0078,0x00000000}},	//   _frét, _باست, ūroj,
  { {0x39461f4e,0x395f08a4,0x7649002b,0x00000000}},	//   ctos_, _usus_, rfey,
  { {0x7afc0058,0x7649002b,0x656908f3,0x00000000}},	//   _yurt, sfey, rveh,
  { {0x69c600d1,0x35f501ce,0x69b10082,0x00000000}},	//   _øker, _епер, _आइडी,
  { {0x00000000,0x00000000,0x00000000,0x00000000}},	//     ,   ,   ,
  { {0x6b830137,0x21391f4f,0x1016046e,0x00000000}},	//   ängj, gush_, зьбя,
  { {0xd0070076,0x648d0139,0x38670137,0x00000000}},	//   зере_, _cúit, ndnr_,
  { {0x394600ea,0xc059000d,0xdee61f50,0x00000000}},	//   ztos_, ціў_, зови,
  { {0x39460006,0x21391f51,0x531a0041,0x00000000}},	//   ytos_, bush_, _פופצ,
  { {0xf5390024,0x3946141f,0x7afc00e9,0x00000000}},	// [2f60] nuť_, xtos_, _surt,
  { {0xe1ff006d,0x7afc1f52,0xc173069a,0x00000000}},	//   ndón_, _purt, _נחת_,
  { {0xbcfb0164,0x6ffb009a,0xef94005d,0x00000000}},	//   _brés, _להיפ, _غیرد,
  { {0xbcfb0164,0xdb23004c,0x8a030062,0x00000000}},	//   _prét, írán, езце,
  { {0x64960003,0x7afc1dba,0x39461f53,0x00000000}},	//   _bâil, _wurt, utos_,
  { {0x7afc0498,0x39461f54,0x7e660137,0x00000000}},	//   _turt, rtos_, _hakp,
  { {0x22b6001c,0x39461f55,0x76aa0062,0x00000000}},	//   lāku_, stos_, йтив_,
  { {0xbddb0813,0xdb1c0051,0x39461f56,0x00000000}},	//   _ibèr, _wyró, ptos_,
  { {0x22b6008f,0xc9860021,0xf7f614d7,0x00000000}},	//   nāku_, _عشري, _فساد,
  { {0x7c3e1f57,0x00000000,0x00000000,0x00000000}},	//   ngpr,   ,   ,
  { {0x2ee9002b,0x62350f55,0x00000000,0x00000000}},	//   ymaf_, мену,   ,
  { {0x22b6001c,0x7e6600a4,0x648d0014,0x00000000}},	//   kāku_, _nakp, _búis,
  { {0x648d0025,0x5bb90053,0xa6e20046,0x00000000}},	//   _cúis, _आश्व, æðuh,
  { {0x212d02f4,0xa3b40086,0x22b6008f,0x00000000}},	//   šeho_, _облі, dāku_,
  { {0xa9230078,0x645a1f58,0x4fc4013f,0x00000000}},	//   ėžia, meti, еста,
  { {0x443e10eb,0x645a1f59,0x7c3e00ea,0x00000000}},	//   lgt_, leti, egpr,
  { {0x443e006f,0x648d0025,0x22b6008f,0x00000000}},	// [2f70] ogt_, _gúis, gāku_,
  { {0x67280117,0x3ea0002c,0x443e1f5a,0x00000000}},	//   _ovdj, ahit_, ngt_,
  { {0xbcfb03b2,0x9e150086,0x645a1f5b,0x00000000}},	//   _prés, _одні, ieti,
  { {0x7c3e00a4,0x22b6001c,0xd366007e,0x00000000}},	//   agpr, bāku_, _یه_,
  { {0xd914000d,0xbd6b0002,0x645a1f5c,0x00000000}},	//   едчы, _урне_, keti,
  { {0x443e0122,0x645a1f5d,0xddcd0022,0x00000000}},	//   jgt_, jeti, reań,
  { {0xbcfb0164,0xe8480044,0x67d20896,0x00000000}},	//   _trés, سجون_, кољу,
  { {0x22b6001c,0x443e1f5e,0xf5090456,0x00000000}},	//   nākt_, egt_, онил_,
  { {0xdddd0045,0x69c600d1,0xc8ab0062,0x00000000}},	//   _hasł, _økep, _лъже_,
  { {0x648d0025,0x443e0626,0x645a1f5f,0x00000000}},	//   _rúis, ggt_, geti,
  { {0x9c870080,0xe1ff006d,0x22b6001c,0x00000000}},	//   _začá, rdón_, zāku_,
  { {0x443e19c3,0xd5ae007e,0x648d0139,0x00000000}},	//   agt_, افی_, _cúir,
  { {0x9293000d,0x648d0025,0xf42901d5,0x00000000}},	//   таўц, _dúir, _долл_,
  { {0x645a1f60,0x7e6604aa,0x22b6008f,0x00000000}},	//   ceti, _sakp, vāku_,
  { {0x7e66002c,0xdddd0022,0x9e76005d,0x00000000}},	//   _pakp, _nasł, وهست,
  { {0x648d0025,0x22b6001c,0xdee30091,0x00000000}},	//   _túis, tāku_, воси,
  { {0x7e6600ac,0x3ea00104,0x6fe70003,0x00000000}},	// [2f80] _vakp, rhit_, técé,
  { {0xb21b00b9,0x61fa0080,0x22b6001c,0x00000000}},	//   hjæl, ětlu, rāku_,
  { {0x307b0063,0x7e6600a4,0x6fe70003,0x00000000}},	//   _ואינ, _takp, récé,
  { {0x22b6001c,0xeb970121,0x62861f61,0x00000000}},	//   māks_, ьих_, njko,
  { {0xbcfb0164,0x645a005b,0x22b6001c,0x00000000}},	//   _fréq, yeti, lāks_,
  { {0xb7bc008f,0x96f80f0a,0xddc6005f,0x00000000}},	//   _leģe, пект_, _lakū,
  { {0x22b6001c,0x645a1f62,0x36d40f34,0x00000000}},	//   nāks_, veti, нокр,
  { {0x7bc10078,0x98a60022,0xebe31f63,0x00000000}},	//   _žlug, kroć_, _росп,
  { {0xdddd0051,0xe4c60121,0x645a1f64,0x00000000}},	//   _zasł, дённ, teti,
  { {0x98af003b,0x443e030c,0x7d7b0aeb,0x00000000}},	//   rugă_, ugt_, קריג,
  { {0xb21b0146,0x6e24002c,0x443e1f65,0x00000000}},	//   bjæl, kaib, rgt_,
  { {0x6b830b64,0xdddd0066,0x645a0869,0x00000000}},	//   ängi, _hosť, seti,
  { {0x7c2e017f,0x65960242,0x22b6001c,0x00000000}},	//   _odbr, _تجار, vākt_,
  { {0xe3af04de,0x61f80088,0x69c5004d,0x00000000}},	//   اری_, ьняў_, ßhei,
  { {0xdfd8005a,0xdfd4000d,0x6e240003,0x00000000}},	//   дът_, воры, faib,
  { {0x656d0734,0xd5e20042,0x98a6056c,0x00000000}},	//   _šahi, _पराज, broć_,
  { {0xbcfb0003,0x6aa2004d,0x7c870121,0x00000000}},	// [2f90] _crép, dhof, муже,
  { {0x22b6183d,0x61e0005b,0xfc300044,0x00000000}},	//   sākt_, ümle, لحم_,
  { {0x290d003b,0x9f450072,0x5a350794,0x00000000}},	//   _stea_, älä_, енет,
  { {0x6aa2001f,0x6e241f66,0x9dab0062,0x00000000}},	//   ghof, caib, _дъга_,
  { {0x49b8006a,0xd5a60044,0x5a44014b,0x00000000}},	//   واهد_, _إف_, тэха,
  { {0xf09f01a8,0xd62202fe,0x2bbe0042,0x00000000}},	//   mpàs_, _цiка, ्थशा,
  { {0xe7390376,0x46f50071,0xcb440094,0x00000000}},	//   чей_, нчит, _ихти,
  { {0x05650138,0x6aa20035,0x7c251f67,0x00000000}},	//   евин, chof, lahr,
  { {0x5a44000d,0x22b6001c,0x04b502e4,0x00000000}},	//   _шэра, zāks_, есня,
  { {0xb21b00b9,0x7c251f68,0x6e24013d,0x00000000}},	//   sjæl, nahr, zaib,
  { {0x889a0063,0x5435005d,0x9f600075,0x00000000}},	//   _צבעי, ورگر, örür_,
  { {0x753b0035,0x22b6008f,0xc0490063,0x00000000}},	//   puuz, vāks_, _לז_,
  { {0x34950088,0xbddb0164,0xb7bc008f,0x00000000}},	//   _падр, _scèn, _veģe,
  { {0x7c25004d,0x22b6001c,0x09b6009a,0x00000000}},	//   jahr, tāks_, תפשט_,
  { {0xdfd20049,0x6609008f,0x6e24013d,0x00000000}},	//   ايز_, ocek, taib,
  { {0xbcfb0164,0x66091f69,0x64411f6a,0x00000000}},	//   _prép, ncek, lgli,
  { {0xed570079,0x7c250199,0xee370088,0x00000000}},	// [2fa0] нот_, fahr, энт_,
  { {0x64411f6b,0x6e24013d,0x44251f6c,0x00000000}},	//   ngli, saib, nal_,
  { {0x64411d60,0x20181f6d,0x44251f6e,0x00000000}},	//   igli, mbri_, ial_,
  { {0xca75000d,0xbcfb0003,0x44251f6f,0x00000000}},	//   кучы, _trép, hal_,
  { {0x44251f70,0x6aa21f71,0xe9800085,0x00000000}},	//   kal_, rhof, ралi_,
  { {0x7c2e0146,0x44251f72,0x6cd60021,0x00000000}},	//   _udbr, jal_, _أقسا,
  { {0x20180290,0x59dc0053,0xf0930063,0x00000000}},	//   ibri_, _बरकर, רנו_,
  { {0x7b06001c,0x76400014,0x61e41f73,0x00000000}},	//   ēstā, ugmy, _ozil,
  { {0x44251f74,0x442e1f75,0xfaa31849,0x00000000}},	//   fal_, _pdf_, _сато,
  { {0x1828006a,0x64411f76,0x44251c45,0x00000000}},	//   _آقای_, ggli, gal_,
  { {0x61e41f77,0x5c370047,0x3d170042,0x00000000}},	//   _azil, ערטן_, _पढ़ने_,
  { {0x64411f78,0x44251f79,0x752900a8,0x00000000}},	//   agli, aal_, bsez,
  { {0x44251121,0x7ebb0050,0x644e004e,0x00000000}},	//   bal_, häpä, õbis,
  { {0x32c4005b,0x44251f7a,0x656601e1,0x00000000}},	//   rıya_, cal_, ækhu,
  { {0x7ea30004,0xd4670001,0xdfd5026c,0x00000000}},	//   _lõpe, _чије_, товы,
  { {0x2ebd0161,0x7c2500bd,0x32c40058,0x00000000}},	//   ्केत, wahr, pıya_,
  { {0x661d0ac6,0x2d580055,0x20180290,0x00000000}},	// [2fb0] ðski, нить_, bbri_,
  { {0x6ac90053,0x2d87007d,0x212b00ca,0x00000000}},	//   िक्र, ćne_, msch_,
  { {0xf09f00cd,0x212b050c,0xc0520041,0x00000000}},	//   spàs_, lsch_, _דזי_,
  { {0x44251f7b,0xc5fe001c,0xc3330063,0x00000000}},	//   zal_, šējo_, רוף_,
  { {0x212b1f7c,0x44251f7d,0x7e7d1f7e,0x00000000}},	//   nsch_, yal_, _insp,
  { {0x6d4d002c,0x212b0221,0xf8ae007e,0x00000000}},	//   mtaa, isch_, يکل_,
  { {0xf892000a,0x6d4d1f7f,0x68fa01b0,0x00000000}},	//   рајќ, ltaa, _ditd,
  { {0x7e6d0e53,0x442511c4,0x6b831255,0x00000000}},	//   ndap, wal_, ängu,
  { {0x64410199,0x6d4d1f80,0x66091f81,0x00000000}},	//   tgli, ntaa, rcek,
  { {0xd90d006a,0x13090be6,0x64411f82,0x00000000}},	//   _هیچ_, мной_, ugli,
  { {0x6d4d00fe,0x75291f83,0x212b06aa,0x00000000}},	//   htaa, ssez, esch_,
  { {0xddc40529,0x6441001f,0x6d4d166f,0x00000000}},	//   ndiţ, sgli, ktaa,
  { {0x7afb000f,0x44250e57,0x06380044,0x00000000}},	//   _miut, pal_, _أسمع_,
  { {0x016300d7,0x7e7d1bf6,0x442500ac,0x00000000}},	//   јкро, _ansp, qal_,
  { {0x03a20086,0x6d4d1986,0x212b0244,0x00000000}},	//   _вищо, etaa, asch_,
  { {0x41b60021,0x6d4d00ac,0x7ae900d1,0x00000000}},	//   _لمعر, ftaa, _nhet,
  { {0x6d4d002c,0x6cd60032,0xf1aa0042,0x00000000}},	// [2fc0] gtaa, نقرا, _चेचन,
  { {0x7afb02f6,0xdd8f01fb,0x7e6d1f84,0x00000000}},	//   _aiut, غول_, adap,
  { {0x0a4a0088,0x6d4d1f85,0xcb090054,0x00000000}},	//   дзей_, ataa, ехід_,
  { {0x7afb0994,0x78a11f86,0x7ae91f87,0x00000000}},	//   _ciut, _allv, _chet,
  { {0xd9540032,0x7afb0397,0x7ceb00bd,0x00000000}},	//   انتخ, _diut, dürf,
  { {0x7ae3006f,0xf772002a,0xe8f70054,0x00000000}},	//   ïntr, لاع_, вніч_,
  { {0x6b830502,0x8a061f88,0xd7ef1f89,0x00000000}},	//   ängt, _азбе, ру_,
  { {0xe6cc0053,0x3ce60042,0x7ae90a04,0x00000000}},	//   ावेज, _जीते_, _ghet,
  { {0xceb3014e,0x27e51f8a,0x7bdc1f8b,0x00000000}},	//   ייה_, _ezln_, _hyru,
  { {0xb865006a,0x68fa0162,0xb4cc0053,0x00000000}},	//   _مامو, _uitd, लवे_,
  { {0xa2950097,0x83fc017f,0x387e000c,0x00000000}},	//   гані, jeđe, _intr_,
  { {0x26c00006,0x212b1f8c,0x98a600a8,0x00000000}},	//   čios_, tsch_, isoč_,
  { {0xe2980088,0x29040035,0x212b004d,0x00000000}},	//   таў_, _juma_, usch_,
  { {0x2ebd0053,0x212b1f8d,0x64a302d8,0x00000000}},	//   ्क्त, rsch_, _ваља,
  { {0x2904002c,0xff0403d6,0x9f050021,0x00000000}},	//   _luma_, иятн, اورو,
  { {0x6d4d024a,0x7e6d1f8e,0xde580054,0x00000000}},	//   ttaa, udap, касі_,
  { {0x29040016,0x7e6d0397,0x7afb07a0,0x00000000}},	// [2fd0] _numa_, rdap, _riut,
  { {0x6d4d1f8f,0x629d10da,0x63a50244,0x00000000}},	//   rtaa, lkso, _ühnc,
  { {0x7afb1f90,0x3f790047,0x6d4d1f91,0x00000000}},	//   _piut, _װאָס, staa,
  { {0x629d1f92,0x4ae4000d,0x6d4d1f93,0x00000000}},	//   nkso, аўча, ptaa,
  { {0x3a241f94,0x29041f95,0xb5fd0c6d,0x00000000}},	//   _demp_, _cuma_, neše,
  { {0x7ae90034,0xe8f80086,0x98e50021,0x00000000}},	//   _whet, влі_, دكتو,
  { {0x2249005b,0x00580063,0x7bdc1f96,0x00000000}},	//   _ocak_, דשות_, _gyru,
  { {0xdb24018d,0xd756006a,0x629d006f,0x00000000}},	//   _úsái, اليت_, jkso,
  { {0xb5fd007d,0xddc402f7,0x3ebe0014,0x00000000}},	//   ješe, odiš, étti_,
  { {0x2001008b,0xb5fd0253,0x8236007e,0x00000000}},	//   _nghi_, deše, گردا,
  { {0x9475006a,0x98af003b,0x29041f97,0x00000000}},	//   ندگا, argă_, _zuma_,
  { {0x7ceb004d,0xcad50063,0xaad30042,0x00000000}},	//   bürg, רוֹת_, तविक,
  { {0x661b076b,0xc5fe008f,0xe1ff013d,0x00000000}},	//   mbuk, ģēto_, deód_,
  { {0x55ba0063,0xddc400c2,0x3f98002b,0x00000000}},	//   _אמנו, jdiš, tyru_,
  { {0xf8b20063,0x2d8f0502,0x3f9e108f,0x00000000}},	//   משך_, ägen_, átu_,
  { {0x629d1f98,0x7ee30044,0xc7b2009d,0x00000000}},	//   ckso, مكّن, צבן_,
  { {0x83fc0117,0x3f9e1f99,0xc692069a,0x00000000}},	// [2fe0] ređe, štu_, זאן_,
  { {0xf06609e1,0x7bdc04ec,0x0c230330,0x00000000}},	//   _скоп, _pyru, ймун,
  { {0xa25b017d,0xddd40051,0x7ceb0058,0x00000000}},	//   inôn, _łańc, dürd,
  { {0x7524005b,0x094a0448,0xba450054,0x00000000}},	//   _çizg, ечки_, ихій,
  { {0x38a2007a,0x82d700b5,0x6b830137,0x00000000}},	//   _aðra_, נונג_, ängr,
  { {0x753b12bf,0x4b26002a,0x2ee00196,0x00000000}},	//   druz, _معرف, llif_,
  { {0x3a24055b,0xd6d0007e,0x69c5004d,0x00000000}},	//   _temp_, يقت_, ßher,
  { {0x29040009,0x6b8300c7,0x661b1f9a,0x00000000}},	//   _tuma_, ånge, gbuk,
  { {0xc0b3001b,0x7d061f9b,0x753b1f9c,0x00000000}},	//   gười_, _juks, gruz,
  { {0xd563011c,0x661b00a4,0x635419b6,0x00000000}},	//   стъп, abuk, авоу,
  { {0x2ee0005b,0x7d061be2,0x37e6030b,0x00000000}},	//   klif_, _luks, _сожг,
  { {0x52a70021,0x7ceb08af,0x66e31f9d,0x00000000}},	//   اصدق, pürg, _лоха,
  { {0xc05b019d,0x629d0307,0xe1ff0022,0x00000000}},	//   нів_, rkso, zdów_,
  { {0xef670062,0xdced0130,0x2ee00058,0x00000000}},	//   лъбо, tvač, elif_,
  { {0x9423005e,0x28970047,0xb5fd1f9e,0x00000000}},	//   _умје, נדלן_, reše,
  { {0x7d061f9f,0x6e20004b,0x8d8715ce,0x00000000}},	//   _buks, _õmbl, лузд,
  { {0xb5fd00c2,0x40351fa0,0x9df9019c,0x00000000}},	// [2ff0] peše, _кепс, тнат_,
  { {0x2a6d1fa1,0xadf41fa2,0x7ceb0075,0x00000000}},	//   _saeb_, спуш, küre,
  { {0x60fa0063,0x7ae3003b,0x70fa0063,0x00000000}},	//   _שהתק, înto, _שהתח,
  { {0x660200e8,0x19b90088,0x7ceb1fa3,0x00000000}},	//   _ngok, куль_, würd,
  { {0x3ea90d17,0xe1ff0051,0x64580513,0x00000000}},	//   mhat_, rdów_, _obvi,
  { {0x3ea900ea,0x7c871fa4,0xd9160044,0x00000000}},	//   lhat_, _суме, جيوش_,
  { {0x07a51fa5,0xc7a50062,0x2bc8007b,0x00000000}},	//   райн, рийк, _буто_,
  { {0x753b1fa6,0x661b002c,0x3ea91fa7,0x00000000}},	//   truz, ubuk, nhat_,
  { {0x661b08f0,0x3ea90150,0xca48007e,0x00000000}},	//   rbuk, ihat_, _حلقه_,
  { {0x753b097c,0xb4c10053,0xb9940021,0x00000000}},	//   rruz, ्के_, _الْب,
  { {0xa3ea016a,0xe2860793,0x7c27007d,0x00000000}},	//   _मरण_, ални, _mejr,
  { {0x25b6007e,0x7c2700b9,0x6d5d1fa8,0x00000000}},	//   اهید_, _lejr, _opsa,
  { {0x3ea900ea,0xcad60063,0x2d8f0989,0x00000000}},	//   dhat_, שורת_, ägel_,
  { {0x3ea900f3,0x7c270080,0xa06a0001,0x00000000}},	//   ehat_, _nejr, њава_,
  { {0x7d061fa9,0x6d5d13d0,0x44271faa,0x00000000}},	//   _suks, _apsa, _ien_,
  { {0xed5a0856,0x44271fab,0x7d06004b,0x00000000}},	//   коб_, _hen_, _puks,

  { {0x1d07005a,0x44271fac,0x25ad1fad,0x00000000}},	// [3000] иети_, _ken_, nzel_,
  { {0x44270080,0x3ea9002c,0x4c83000a,0x00000000}},	//   _jen_, ahat_, олув,
  { {0x3ea91fae,0x9f4c0072,0x44271aaf,0x00000000}},	//   bhat_, ädä_, _men_,
  { {0x44270024,0x3ea91faf,0x7d061fb0,0x00000000}},	//   _len_, chat_, _tuks,
  { {0x2d8f00b9,0x7c2700b9,0x3ebe0014,0x00000000}},	//   øget_, _fejr, éttu_,
  { {0xd7f1001b,0xddcd000c,0x44271fb1,0x00000000}},	//   _hãy_, leaş, _nen_,
  { {0x6d44003b,0xf727000d,0x07a302d8,0x00000000}},	//   luia, ацый_, жајн,
  { {0x3ea001b2,0x2733008b,0x442700ca,0x00000000}},	//   nkit_, ịnh_, _aen_,
  { {0x74c6005a,0x35f30062,0x6d441fb2,0x00000000}},	//   ищож, опър, nuia,
  { {0x3ea900ea,0x7ae21fb3,0x661d0014,0x00000000}},	//   zhat_, llot, ðskr,
  { {0x44271ea3,0x5c790047,0x7ae21fb4,0x00000000}},	//   _den_, אָרױ, olot,
  { {0x44271fb5,0x96070076,0x7ae2013d,0x00000000}},	//   _een_, _кэша_, nlot,
  { {0x3ea9013d,0x44271fb6,0x7cf00244,0x00000000}},	//   vhat_, _fen_, märf,
  { {0x3ea90034,0x3be60053,0x7cf00137,0x00000000}},	//   what_, _करूँ_, lärf,
  { {0x442c0029,0x3ea900ea,0x4343018e,0x00000000}},	//   mad_, that_, _дејв,
  { {0x7c2700b9,0x27e300b9,0x93fb0047,0x00000000}},	//   _sejr, _øjne_, _בלוי,
  { {0x27330013,0x6d441fb7,0x44271fb8,0x00000000}},	// [3010] ạnh_, guia, _yen_,
  { {0x442c1fb9,0x7ae21fba,0xb5fd00cc,0x00000000}},	//   nad_, elot, neša,
  { {0x7c270146,0xcb550001,0x644800a4,0x00000000}},	//   _vejr, свећ, igdi,
  { {0x2d8f00b9,0x7ceb00bd,0xbad80086,0x00000000}},	//   øges_, fürc, афії_,
  { {0x6d44003b,0x98dd000d,0x442c1fbb,0x00000000}},	//   cuia, нскi, kad_,
  { {0x442c0004,0x25ad00c3,0xb5fd017f,0x00000000}},	//   jad_, vzel_, ješa,
  { {0x442c1fbc,0xb5fd017f,0xccf20063,0x00000000}},	//   dad_, deša, _מכך_,
  { {0x4427024a,0x6e2d1fbd,0x442c1fbe,0x00000000}},	//   _sen_, naab, ead_,
  { {0xddc60198,0x442c1fbf,0x44271fc0,0x00000000}},	//   _kakš, fad_, _pen_,
  { {0x395f00cd,0xd469005e,0x442c1fc1,0x00000000}},	//   _ipus_, ћине_, gad_,
  { {0xa22a0076,0x6e2d1a61,0x44271fc2,0x00000000}},	//   лжна_, kaab, _ven_,
  { {0xddc61fc3,0x6448006f,0x442c1fc4,0x00000000}},	//   _lakš, agdi, aad_,
  { {0x44271fc5,0x83fc007d,0x6e2d004b,0x00000000}},	//   _ten_, ređa, daab,
  { {0x7cf00019,0x7649005b,0x7e200042,0x00000000}},	//   märg, lgey, बर्ग_,
  { {0x13a7005d,0x34920699,0x8fa31fc6,0x00000000}},	//   _خنثی_, _хајр, паре,
  { {0x6e2d00a4,0x539a0063,0x4226047e,0x00000000}},	//   gaab, _תיקו, _удив,
  { {0x3ea000fe,0x7e640006,0x51850002,0x00000000}},	// [3020] rkit_, reip, _дуќа,
  { {0x6e2d00a4,0x6d44003b,0x62960331,0x00000000}},	//   aaab, ruia, _hoyo,
  { {0x2d8f0146,0xe1ff0268,0xd24f007e,0x00000000}},	//   øger_, bdós_, _غنی_,
  { {0x6b8300c7,0x442c1fc7,0x1a2a0062,0x00000000}},	//   ånga, zad_, ужди_,
  { {0x442c00bb,0xb9560138,0x7cf00019,0x00000000}},	//   yad_, стећ, järg,
  { {0x7ae21fc8,0x307a00b5,0x7ea30019,0x00000000}},	//   slot, ראַנ, _lõpl,
  { {0x442c1fc9,0x628400e5,0x7ae21fca,0x00000000}},	//   vad_, _onio, plot,
  { {0x7cf00137,0x6296006c,0x442c1fcb,0x00000000}},	//   färg, _noyo, wad_,
  { {0xb21b069f,0x442c1fcc,0x142a0054,0x00000000}},	//   kjær, tad_, ліно_,
  { {0x442c0d4b,0x628419e7,0x3946005f,0x00000000}},	//   uad_, _anio, muos_,
  { {0x38ab0205,0x442c1fcd,0x62960150,0x00000000}},	//   _sørg_, rad_, _boyo,
  { {0xd62705fb,0x62840025,0x6569004d,0x00000000}},	//   _гоце_, _cnio, bweh,
  { {0x442c1fce,0x914b000d,0xb5fd0be1,0x00000000}},	//   pad_, ычна_, lešn,
  { {0x224d0051,0x39460006,0xb21b04aa,0x00000000}},	//   żek_, iuos_, gjær,
  { {0xdbf10080,0xe4570047,0x66110072,0x00000000}},	//   _přím, _ליגט_, _ähkö,
  { {0x39460078,0x7cf000a5,0xf8140022,0x00000000}},	//   kuos_, härd, ężyć_,
  { {0x6e940817,0x38ab01f2,0x5cb9000d,0x00000000}},	// [3030] читу, _høre_, алаў_,
  { {0x38ab0146,0x394604a6,0xa3cc0053,0x00000000}},	//   _køre_, duos_, _रखा_,
  { {0x62960009,0xce95011c,0x395f000c,0x00000000}},	//   _yoyo, _данъ, _spus_,
  { {0xdb0800ea,0x38ab05e7,0xc17f0078,0x00000000}},	//   álás, _møre_, _įėjo_,
  { {0xc7b8017f,0x394602dd,0xddc600c3,0x00000000}},	//   _među_, guos_, _takš,
  { {0x7cf01fcf,0x644e00cd,0x58d40363,0x00000000}},	//   gärd, òbil, почт,
  { {0x7ea3004b,0x76490046,0xa09c009a,0x00000000}},	//   _lõpm, tgey, ריוט,
  { {0x66f2018e,0x060905a1,0x78a80014,0x00000000}},	//   мпју, шник_, _eldv,
  { {0xf9930032,0x62960089,0x5fdb0053,0x00000000}},	//   _عبر_, _royo, _मुसल,
  { {0x6296066d,0x6569004d,0x7cf0004d,0x00000000}},	//   _soyo, rweh, rärg,
  { {0x61ed0792,0x62661527,0x65691fd0,0x00000000}},	//   _azal, овна, sweh,
  { {0x7cf0004d,0xe7300021,0xc7d60041,0x00000000}},	//   märe, _أصل_, _וועי_,
  { {0x62960164,0x7cf01fd1,0xe4c80043,0x00000000}},	//   _voyo, läre, شبین_,
  { {0x38ab0831,0x6aa9001f,0x62840051,0x00000000}},	//   _føre_, _llef, _wnio,
  { {0x62961fd2,0x38ab010a,0x9e960001,0x00000000}},	//   _toyo, _gøre_, ошаљ,
  { {0x62840305,0xf77207e9,0xb5fd1fd3,0x00000000}},	//   _unio, וקל_, nešo,
  { {0xe1ff006d,0xe5f60047,0xf8c80013,0x00000000}},	// [3040] león_, ַזער_, hứa_,
  { {0x61e4005b,0x39460078,0x9046005d,0x00000000}},	//   _iyil, vuos_, _بنده,
  { {0xbcfb03b2,0x7cf010b5,0x643a0047,0x00000000}},	//   _spéc, värd, שעענ,
  { {0x60dc185a,0xae5a0054,0x39461fd4,0x00000000}},	//   lorm, _троє_, tuos_,
  { {0x6aa21fd5,0x7cf00e77,0xbcfb013d,0x00000000}},	//   rkof, tärd, _csés,
  { {0x7cf00cbf,0x2d540019,0x98a303d6,0x00000000}},	//   färe, mäe_, миче,
  { {0xf09300b7,0xfaa6000d,0x291d00a4,0x00000000}},	//   ונג_, _даво, apwa_,
  { {0x60dc08f8,0xc6f8005e,0x38ab01e1,0x00000000}},	//   horm, љних_, _røre_,
  { {0xb7bc008f,0xe60f0044,0x0ae90044,0x00000000}},	//   _meģi, خشى_, _طرفي_,
  { {0x7cf00d88,0xd49a0076,0xddcd000c,0x00000000}},	//   lärb, рри_, ldaţ,
  { {0x64a30002,0x60dc1fd6,0x61ed1504,0x00000000}},	//   фаќа, dorm, _szal,
  { {0xddcd000c,0x5187005e,0x2bbd0053,0x00000000}},	//   ndaţ, оуга, ्पता,
  { {0x8afb0041,0x60dc1fd7,0xad9b013d,0x00000000}},	//   יפטק, form, _egúj,
  { {0x6ab70235,0x61ed01c8,0xf8bc0042,0x00000000}},	//   _आग्र, _vzal, ्चिय,
  { {0xcebb0001,0x09b70053,0x78800066,0x00000000}},	//   аља_, _अध्य, _závä,
  { {0x9d151fd8,0x645a1fd9,0x02940044,0x00000000}},	//   здач, lfti, _يؤيد,
  { {0x5fdb0042,0x60dc017c,0xf8bc0042,0x00000000}},	// [3050] _मुरल, borm, ्चाय,
  { {0x645a00bd,0xb5fd004c,0xe5710063,0x00000000}},	//   nfti, dešl, עַן_,
  { {0x7cf0004d,0xc052009a,0xf1c8011b,0x00000000}},	//   färb, _אזי_, rbář_,
  { {0x7cf001e9,0x8f880063,0x59750085,0x00000000}},	//   väre, _וְשֵ, зыку,
  { {0x0dc8000a,0xa924019d,0xddeb005d,0x00000000}},	//   _дури_, дділ, _خرده_,
  { {0x645a0122,0x61e0004d,0x27950cdf,0x00000000}},	//   jfti, ümli, зшир,
  { {0x24890013,0x4ac500de,0x00000000,0x00000000}},	//   _đam_, _فيسق,   ,
  { {0x3209001b,0x7cf0004d,0x645a1fda,0x00000000}},	//   _ngay_, räre, efti,
  { {0x645a0333,0x7cf01fdb,0x47d5005d,0x00000000}},	//   ffti, säre, _کيار,
  { {0xe719007e,0x7ceb0244,0x870702fa,0x00000000}},	//   _هيئت_, zürn, _дяде,
  { {0x3a2d04ff,0x6498005a,0x61e41fdc,0x00000000}},	//   _keep_, ютър_, _syil,
  { {0x216a0062,0x60dc0c5f,0x6d41008f,0x00000000}},	//   бими_, worm, _ālan,
  { {0x29050009,0xb7bc003d,0x6aaa0229,0x00000000}},	//   _kila_, _reģi, ëffi,
  { {0x2d540019,0x60dc0072,0xf9920063,0x00000000}},	//   väe_, uorm, תרך_,
  { {0x29051fdd,0x657b0014,0xa3de004c,0x00000000}},	//   _mila_, lvuh, _těší_,
  { {0x539a014e,0x60dc0164,0xf7720047,0x00000000}},	//   _ליצו, sorm, עקן_,
  { {0x60dc0273,0xdb0d0066,0xa1130044,0x00000000}},	// [3060] porm, ľkým, _كويت,
  { {0x2905002c,0x6d5600e5,0xf8a5007e,0x00000000}},	//   _nila_, rtya, _شک_,
  { {0x309b0063,0xda0a0021,0xa09b07e9,0x00000000}},	//   _השימ, مياه_, _הייט,
  { {0x7ceb1fde,0xed5a0782,0xaae60044,0x00000000}},	//   büro, _лом_, أسطو,
  { {0x3a2d0034,0xddcd003b,0x29051fdf,0x00000000}},	//   _deep_, rdaţ, _bila_,
  { {0x7ceb005b,0x63a10137,0x6e241fe0,0x00000000}},	//   nürl, kyln, lbib,
  { {0x29050da5,0x38cb007e,0x7c2e008f,0x00000000}},	//   _dila_, حانی_, _iebr,
  { {0x6e240396,0x7c2e1fe1,0x6d441fe2,0x00000000}},	//   nbib, _hebr, oria,
  { {0x29051fe3,0x9c8300c3,0x7ceb004d,0x00000000}},	//   _fila_, ščet, kürl,
  { {0x6d441142,0x29051496,0xa9230240,0x00000000}},	//   iria, _gila_, ážen,
  { {0x9956001c,0xe2f90086,0x7ceb0058,0x00000000}},	//   kļūt_, жені_, dürl,
  { {0x6d440006,0xa3bd0042,0x2905008f,0x00000000}},	//   kria, _इधर_, _zila_,
  { {0xc50a0032,0x51870138,0x867b014e,0x00000000}},	//   _اتصل_, чуна, _לראו,
  { {0x6d441fe4,0x7ceb005b,0x6e24006f,0x00000000}},	//   dria, gürl, ebib,
  { {0x6d441fe5,0x7127007e,0x4477009a,0x00000000}},	//   eria, _کربل, _מעגל_,
  { {0x6e2400bb,0xdce4017f,0x442e1fe6,0x00000000}},	//   gbib, dviđ, _hef_,
  { {0xcc990001,0x6d441fe7,0x1df80895,0x00000000}},	// [3070] овац_, gria, зеты_,
  { {0x6e2400a4,0x442e00ca,0x7c2e18fb,0x00000000}},	//   abib, _jef_, _cebr,
  { {0xdced017f,0x7c2e1fe8,0xf0920063,0x00000000}},	//   hvać, _debr, _סנט_,
  { {0x29051fe9,0xddcd007d,0x6d441fea,0x00000000}},	//   _sila_, adaš, bria,
  { {0x6d4412aa,0x2905185d,0x2ee9002b,0x00000000}},	//   cria, _pila_, mlaf_,
  { {0x7c2e1feb,0xe9d8000d,0x21780063,0x00000000}},	//   _gebr, чкі_, פתור_,
  { {0x6b830146,0x3f570003,0x29051fec,0x00000000}},	//   ængd, nçu_, _vila_,
  { {0xaa580138,0x7c250139,0x7c2e1fed,0x00000000}},	//   _нису_, lbhr, _zebr,
  { {0x29051fee,0x7cf0086f,0xa8550a74,0x00000000}},	//   _tila_, lära, _окач,
  { {0xb5fd027c,0x2ee9004d,0x03a50363,0x00000000}},	//   lešk, hlaf_, диоо,
  { {0xa91d0be1,0x657b078c,0x442e1fef,0x00000000}},	//   _drže, svuh, _def_,
  { {0x7d0702b0,0x442e006f,0x7c250025,0x00000000}},	//   _lijs, _eef_, hbhr,
  { {0x27e001f7,0x7ceb1fa3,0x3f570003,0x00000000}},	//   ğine_, türl, eçu_,
  { {0x1dd80161,0x6d4415b7,0x442e0014,0x00000000}},	//   _भुगत, vria, _gef_,
  { {0x7c2e0994,0x91030c09,0x6d44001f,0x00000000}},	//   _rebr, тпре, wria,
  { {0xb5fd007d,0x26cd1ff0,0x6d441ff1,0x00000000}},	//   ješk, nneo_, tria,
  { {0xed570079,0x7d070122,0x4425001f,0x00000000}},	// [3080] мот_, _bijs, obl_,
  { {0x1c39000d,0x6d441ff2,0x6f061ff3,0x00000000}},	//   зяць_, rria, _wikc,
  { {0x7cf001e3,0x660b00d1,0xbb8600de,0x00000000}},	//   gära, _oggk, بلاي,
  { {0x7c250139,0x7c2e1ff4,0x6d441ff5,0x00000000}},	//   abhr, _webr, pria,
  { {0x2d8f0137,0x7c2e005b,0xe7c30053,0x00000000}},	//   äget_, _tebr, _वेबप,
  { {0xab2a005a,0x61eb05b9,0x7cf00137,0x00000000}},	//   _мога_, _øgle, bära,
  { {0xb5fd00c2,0x8c4302d8,0xd83800a8,0x00000000}},	//   bešk, _јесе, _noče_,
  { {0x6b83010a,0x20070024,0x26cd0290,0x00000000}},	//   ænge, _únie_, gneo_,
  { {0xa91d0130,0xfcaa009a,0xb4460085,0x00000000}},	//   _prže, ַיֹּ, мэнк,
  { {0x83fc007d,0x75240058,0xa99b009a,0x00000000}},	//   leđi, _çizm, _ובמר,
  { {0x7eb10031,0xf7720021,0x442e0026,0x00000000}},	//   _håpe, _جاء_, _vef_,
  { {0xe5c61dd1,0x39461ff6,0x87b70041,0x00000000}},	//   _осло, oros_, _קלאס_,
  { {0xa91d0ae1,0x26c41488,0x7ceb004d,0x00000000}},	//   _trže, mimo_, würm,
  { {0x394603d9,0x26c40add,0x7ceb1b89,0x00000000}},	//   iros_, limo_, türm,
  { {0x7d07006f,0x7d0f01e1,0xe8ee0085,0x00000000}},	//   _rijs, _sucs, ылi_,
  { {0x3f570164,0x3f8102e2,0x26c41ff7,0x00000000}},	//   rçu_, _vrhu_, nimo_,
  { {0x2fdf0051,0xb5fd1253,0xf1a70086,0x00000000}},	// [3090] ług_, vešk, _ірин,
  { {0x26c41882,0x3f810240,0x2ee90474,0x00000000}},	//   himo_, _trhu_, slaf_,
  { {0x26c400eb,0x38ab0146,0x7c250025,0x00000000}},	//   kimo_, _børn_, rbhr,
  { {0x26c400eb,0x7d070122,0xdd9505ac,0x00000000}},	//   jimo_, _wijs, _замы,
  { {0xb5fd1ff8,0xe9ce1ff9,0x39461ffa,0x00000000}},	//   rešk, ук_, gros_,
  { {0x7b67005a,0x7cf01ffb,0x99d4007e,0x00000000}},	//   _отбе, pära, ختما,
  { {0xb5fd00c2,0xddcf003b,0xc8780058,0x00000000}},	//   pešk, _facţ, _dağ_,
  { {0x39461ffc,0x26c40006,0x4425001f,0x00000000}},	//   bros_, gimo_, wbl_,
  { {0x2f1502eb,0x26cd1ffd,0x39461ffe,0x00000000}},	//   _låg_, rneo_, cros_,
  { {0xb5fd00eb,0x7e6d0025,0xd838007d,0x00000000}},	//   neši, heap, _poče_,
  { {0xc2c60021,0x13e90076,0x3ea9005b,0x00000000}},	//   فيدي, ямой_, kkat_,
  { {0x7cf000c7,0xc5d501dd,0xeb920041,0x00000000}},	//   järn, _піль, אָש_,
  { {0x7e6d000c,0x9136000d,0xc8780058,0x00000000}},	//   deap, эхні, _yağ_,
  { {0xb5fd017f,0x6d4d0019,0x0ef80053,0x00000000}},	//   ješi, duaa, ंग्स_,
  { {0x7ea30004,0x645c0268,0xb5fd16fe,0x00000000}},	//   _lõpu, òrie, deši,
  { {0x3ea91fff,0x7eaa004a,0x7cf00137,0x00000000}},	//   gkat_, _výpo, gärn,
  { {0xac861a02,0xfd4a0085,0x4d4a0085,0x00000000}},	// [30a0] нгал, язак_, япан_,
  { {0x39460016,0x26c408ed,0x3ea92000,0x00000000}},	//   vros_, zimo_, akat_,
  { {0x291f017d,0x9057009a,0x2d8f0832,0x00000000}},	//   _atua_, _אביו_, äger_,
  { {0x39460747,0x3ea900c7,0x26c40fac,0x00000000}},	//   tros_, ckat_, ximo_,
  { {0xf5390024,0x83fc017f,0x9c8300c2,0x00000000}},	//   jsť_, ređi, ščat,
  { {0x20070268,0x7eb10031,0x39462001,0x00000000}},	//   _únic_, _våpe, rros_,
  { {0xf5390024,0x26c40aca,0x2d802002,0x00000000}},	//   esť_, timo_, lvie_,
  { {0x2b470080,0x39462003,0x2d802004,0x00000000}},	//   ánce_, pros_, ovie_,
  { {0x2d800016,0xceb30063,0x26c40aa6,0x00000000}},	//   nvie_, טיה_, rimo_,
  { {0x26c42005,0x2240053b,0xed570063,0x00000000}},	//   simo_, _adik_, עביר_,
  { {0x26c42006,0xf5390066,0xd6cf2007,0x00000000}},	//   pimo_, asť_, _бт_,
  { {0x7ae212f9,0x7ceb2008,0x5fdb0042,0x00000000}},	//   noot, türk, _मुगल,
  { {0x2f1502eb,0x7cf00137,0x64a62009,0x00000000}},	//   _såg_, värn, _пада,
  { {0x251b009f,0x7ae21b13,0x7ceb0075,0x00000000}},	//   _צווא, hoot, rürk,
  { {0x30a4005a,0x7e6d000c,0xdfd4000d,0x00000000}},	//   уряв, teap, горы,
  { {0x3ea9200a,0x2f150137,0x9f47004c,0x00000000}},	//   ukat_, _våg_, _ání_,
  { {0x628d0035,0x6c550076,0xdce40051,0x00000000}},	// [30b0] _inao, ккау, zwią,
  { {0x2f150137,0x8c44005e,0x3ea9200b,0x00000000}},	//   _tåg_, леђе, skat_,
  { {0x6e3600bb,0x6d4d021e,0xb5fd02f7,0x00000000}},	//   bayb, suaa, reši,
  { {0x9f960063,0x7ae20050,0xf8a90042,0x00000000}},	//   _סדרה_, goot, कस्प,
  { {0xa3de0080,0xf2d40047,0xe895030b,0x00000000}},	//   _věří_, װעס_, кадь,
  { {0xf745060e,0xf7710049,0x1866030b,0x00000000}},	//   веко, لاب_, ваши_,
  { {0xa91d06bb,0x6a15200c,0x7ae205be,0x00000000}},	//   _drža, _амбу, boot,
  { {0x67230130,0x05650121,0xddc4005f,0x00000000}},	//   rpnj, ввин, leiš,
  { {0x6827000d,0x7cf000a5,0xa92b014b,0x00000000}},	//   _зьез, kärl, _хібе_,
  { {0x27e0003b,0x9476007e,0xb4bd0053,0x00000000}},	//   şina_, ندپا, ीचे_,
  { {0x68e3200d,0x2d800066,0x21200130,0x00000000}},	//   mond, zvie_, _stih_,
  { {0x83fc007d,0x9f5e0066,0x68e3200e,0x00000000}},	//   jeđu, ätí_, lond,
  { {0x645c0268,0x6a3a0063,0x7cf00137,0x00000000}},	//   òric, וגרפ, färl,
  { {0x68e3200f,0x64a22010,0x753b0058,0x00000000}},	//   nond, _ваша, msuz,
  { {0xafe60065,0x753b0058,0x661b0058,0x00000000}},	//   товл, lsuz, ocuk,
  { {0x661b0397,0xee3a0002,0xd007005e,0x00000000}},	//   ncuk, ќна_, ђете_,
  { {0xe0da0259,0x68e32011,0x753b0058,0x00000000}},	// [30c0] _ови_, kond, nsuz,
  { {0x3137014e,0x2d802012,0x6e3608f2,0x00000000}},	//   _שנים_, rvie_, sayb,
  { {0xda7a0062,0x83fc007d,0x68e32013,0x00000000}},	//   дял_, beđu, dond,
  { {0xbb430076,0x0a6700e1,0x20070066,0x00000000}},	//   рецк, врши_, _únia_,
  { {0x7ae212bc,0xfaa30002,0x68e32014,0x00000000}},	//   root, јачо, fond,
  { {0x91bb0063,0x75240058,0xb5fd008f,0x00000000}},	//   ומני, _çizi, nešu,
  { {0x98a30001,0xb8ea0053,0x394f0023,0x00000000}},	//   рије, _लग_, augs_,
  { {0x7ceb004d,0x4420004c,0xfaa32015,0x00000000}},	//   fürw, _ři_, _касо,
  { {0xa91d00c2,0x68e32016,0x09062017,0x00000000}},	//   _trža, bond, _апан,
  { {0x7cf00137,0x68e304ca,0xb5fd0130,0x00000000}},	//   kärm, cond, ješu,
  { {0xb8f6016a,0x7cf00137,0xc4c6005d,0x00000000}},	//   ाच_, värl, فتگو,
  { {0xa91d007d,0xc6a30259,0x6aa006a5,0x00000000}},	//   _mržn, _врши, _jomf,
  { {0x61f60051,0xc05b0086,0x7ceb004b,0x00000000}},	//   _czyl, мів_, süri,
  { {0x38d4009a,0x00000000,0x00000000,0x00000000}},	//   אֵֽל_,   ,   ,
  { {0x290c2018,0x4034093e,0xcfa4018e,0x00000000}},	//   _mida_, ресс, ашти,
  { {0x68e30122,0x628d0009,0x290c2019,0x00000000}},	//   zond, _unao, _lida_,
  { {0x83fc017f,0xbdf5005e,0x68e3107b,0x00000000}},	// [30d0] ređu, упај, yond,
  { {0x6adb0161,0xb5fd017f,0x2075000d,0x00000000}},	//   यक्र, mešt, _слоў,
  { {0x68e302b0,0xddc40006,0xfbd00021,0x00000000}},	//   vond, reiš, يتم_,
  { {0x6aa0201a,0x68e30983,0x19f9000d,0x00000000}},	//   _comf, wond, нэль_,
  { {0xb5fd0006,0x4a440086,0x68e3201b,0x00000000}},	//   nešt, рнів, tond,
  { {0x63a800b9,0x68e30035,0x61ed0474,0x00000000}},	//   kydn, uond, _myal,
  { {0x57a40001,0xdce40051,0x68e3201c,0x00000000}},	//   ишћа, jwię, rond,
  { {0x7cf00d9e,0x68e3201d,0xf77001fb,0x00000000}},	//   järj, sond, تاه_,
  { {0xb5fd017f,0x68e309ed,0x61ed0150,0x00000000}},	//   ješt, pond, _nyal,
  { {0x38ab0093,0x7e7d0104,0x68e300ac,0x00000000}},	//   _mørk_, _lasp, qond,
  { {0x645c00cd,0x7e7d003b,0x61ed201e,0x00000000}},	//   òria, _oasp, _ayal,
  { {0x7e7d03f5,0x290c007d,0x85b9005e,0x00000000}},	//   _nasp, _zida_, _плес_,
  { {0x7cf0004d,0x15450699,0x45450021,0x00000000}},	//   wärm, _селм, _إنتق,
  { {0xdddd0045,0xf0d5000d,0x7c35201f,0x00000000}},	//   _obsł, аўсю, _nezr,
  { {0x644600eb,0x7afb0019,0x61ed005b,0x00000000}},	//   ėkit, _ohut, _eyal,
  { {0x7ea30019,0x7e7d2020,0x2eb50085,0x00000000}},	//   _sõpr, _casp, асус,
  { {0xde35000d,0x6aa02021,0x7c352022,0x00000000}},	// [30e0] рэсь, _romf, _bezr,
  { {0x7cf02023,0x7e7d0025,0xddc60114,0x00000000}},	//   märk, _easp, _takž,
  { {0x290c1a8a,0x0b460086,0x5f760049,0x00000000}},	//   _rida_, унен, _صادر,
  { {0x290c02eb,0xbae5019d,0xbddb00cd,0x00000000}},	//   _sida_, ацій, _idèn,
  { {0x9e63000d,0x5a330086,0x79c6000d,0x00000000}},	//   _увяд, сніт, ыйдз,
  { {0xa91d2024,0xf7720593,0x7e7d1c76,0x00000000}},	//   _tržn, ماع_, _zasp,
  { {0x69dc0045,0x290c2025,0xf6e6026b,0x00000000}},	//   _śred, _vida_, лцин,
  { {0x7afb0027,0x644300ea,0x1ab80042,0x00000000}},	//   _ghut, _adni, _आतिथ,
  { {0x45d40fe2,0x290c2026,0xbcfb0025,0x00000000}},	//   ропс, _tida_, _spéi,
  { {0xb5fd0117,0x7ea30004,0x63a80205,0x00000000}},	//   vešt, _lõpp, tydn,
  { {0x87260121,0x44f714d7,0x00000000,0x00000000}},	//   _смеж, دريج_,   ,
  { {0x64430384,0x63a8061f,0x171b009a,0x00000000}},	//   _edni, rydn, _נודע,
  { {0x7e7d2027,0xf4861915,0x63ba013d,0x00000000}},	//   _rasp, _буйн, sztn,
  { {0xe1ff013d,0xb5fd2028,0x7e7d008f,0x00000000}},	//   deót_, rešt, _sasp,
  { {0x7e7d0812,0x9f350054,0x7c352029,0x00000000}},	//   _pasp, ребі, _rezr,
  { {0x4ea40138,0x61ed00ac,0x9f5e0066,0x00000000}},	//   бруа, _tyal, ätá_,
  { {0xdd940076,0x7afb001f,0x7e7d202a,0x00000000}},	// [30f0] баты, _rhut, _vasp,
  { {0x7afb1568,0x7e7d202b,0x27e0004c,0x00000000}},	//   _shut, _wasp, řiny_,
  { {0xda15000a,0x7afb008d,0x7f95005e,0x00000000}},	//   адењ, _phut, _танх,
  { {0xa3c30080,0x78a1202c,0x8f9a0149,0x00000000}},	//   náší_, _solv, _סירי,
  { {0x6e2d202d,0x78a1202e,0xd90f005d,0x00000000}},	//   mbab, _polv, سیا_,
  { {0x07a5011c,0x6b8300c7,0x6e2d0370,0x00000000}},	//   иалн, ångs, lbab,
  { {0x78a1048e,0xdcef003b,0x6447006d,0x00000000}},	//   _volv, _escă, ójim,
  { {0x46a50612,0x78a119dd,0x7545202f,0x00000000}},	//   раив, _wolv, аниз,
  { {0x6d4d119d,0x6f0f2030,0x78a12031,0x00000000}},	//   nraa, _micc, _tolv,
  { {0x98f70021,0x629d0080,0xa5f60001,0x00000000}},	//   _إثرا, ejso, шењу_,
  { {0xf799005d,0xd3b90054,0x7ceb0058,0x00000000}},	//   _جناب_, тупі_, lürs,
  { {0x6f0f2032,0x8b080080,0x7cf00832,0x00000000}},	//   _nicc, mořá, tärk,
  { {0x7ceb0058,0x6d4d2033,0xa4d50054,0x00000000}},	//   nürs, jraa, _коді,
  { {0x6e2d0089,0x6d4d2034,0x75292035,0x00000000}},	//   ebab, draa, mpez,
  { {0x6f0f0290,0x2d8f0137,0x6d4d1986,0x00000000}},	//   _bicc, ågen_, eraa,
  { {0x6e2d00bb,0xddc60045,0x6f0f0a02,0x00000000}},	//   gbab, _takż, _cicc,
  { {0x3da7005a,0x6f0f2036,0x6281008f,0x00000000}},	// [3100] акто_, _dicc, ēlot,
  { {0x6e2d002c,0x8c4617f2,0x913b009a,0x00000000}},	//   abab, реже, _שעיק,
  { {0x6f0f2037,0x6ecc0058,0x7cf02038,0x00000000}},	//   _ficc, aşba, näri,
  { {0x8b230086,0x79892039,0x6d4d056f,0x00000000}},	//   ідче, _brew, braa,
  { {0x7cf0004d,0x3940203a,0x6d4d00ca,0x00000000}},	//   häri, éis_, craa,
  { {0x798912cc,0x7cf00072,0x4b260044,0x00000000}},	//   _drew, käri, _نعرف,
  { {0xd90d006a,0x6a960054,0xd6da1e7f,0x00000000}},	//   ریم_, _крає, кти_,
  { {0x2f1c00ea,0xa5340086,0xa9260156,0x00000000}},	//   _míg_, бнич, _вдал,
  { {0x6f04203b,0x9f600003,0x7989203c,0x00000000}},	//   imic, érêt_, _grew,
  { {0xd4060ac5,0xf8aa0042,0xc977009a,0x00000000}},	//   ияни, _कविय, _דגמי_,
  { {0x6f04074f,0xdddd001c,0xbddb12f7,0x00000000}},	//   kmic, _pasū, _adèl,
  { {0x20cd00eb,0x26c600a4,0xd62a05f4,0x00000000}},	//   džia_, _umoo_, _роде_,
  { {0x6f0f12c9,0x6f040ecf,0xd1380002,0x00000000}},	//   _ricc, dmic, ихр_,
  { {0x6d4d04c6,0x6f0f203d,0x14f3000d,0x00000000}},	//   vraa, _sicc, _дзіў,
  { {0x6f0f203e,0x3ec7000d,0x13a9007e,0x00000000}},	//   _picc, асаб, _منوی_,
  { {0x5eb40245,0xceb8005e,0x6d4d0d47,0x00000000}},	//   ойст, аљу_, traa,
  { {0x6e2d203f,0xe7ed0053,0xf1a4000d,0x00000000}},	// [3110] rbab, _चुना_, _дрэн,
  { {0x9f410072,0x6f0f2040,0x6d4d12f9,0x00000000}},	//   _pyhä_, _wicc, rraa,
  { {0x6d4d2041,0xdfd10044,0xbb1800de,0x00000000}},	//   sraa, _ريح_, لزنا_,
  { {0x38b90164,0x6e950754,0x6d4d0162,0x00000000}},	//   _mère_, _الحا, praa,
  { {0xa9c7000a,0xd838007d,0x200c004c,0x00000000}},	//   јсек, _beč_, ždit_,
  { {0x7ceb005b,0x1d160063,0xa3b60042,0x00000000}},	//   rürs, _לקשר_, छना_,
  { {0x4738000d,0x6e46013d,0xe0b8009a,0x00000000}},	//   ачыў_, _átbö, שלוט_,
  { {0x24890058,0x7cf02042,0x06820062,0x00000000}},	//   _şam_, väri, згън,
  { {0xe5710021,0xdb12013d,0xe6c400de,0x00000000}},	//   سطة_, ögöt, تتوي,
  { {0x8b080080,0x7cf01555,0x6f0408b7,0x00000000}},	//   pořá, täri, zmic,
  { {0x130a0076,0x7529051f,0xc209009a,0x00000000}},	//   лной_, spez, _נה_,
  { {0xfbd20063,0x7cf0004e,0x8704012c,0x00000000}},	//   לתי_, räri, _дяче,
  { {0xd4690fe2,0x2d8f0137,0x86c40049,0x00000000}},	//   _биле_, ågel_, _بينن,
  { {0xd7f1008b,0x7cf02043,0x60230867,0x00000000}},	//   _kỹ_, lärv, здра,
  { {0xf4120063,0x38b90003,0x2d8b0331,0x00000000}},	//   _צפה_, _gère_, _arce_,
  { {0xd7f1008b,0x16040053,0x20cd0066,0x00000000}},	//   _mỹ_, शेवर_, ržia_,
  { {0xddea006a,0xd2570063,0x6f040aca,0x00000000}},	// [3120] ارزه_, _השפה_, rmic,
  { {0xc5f20149,0xeb9a2044,0xed570f50,0x00000000}},	//   לדן_, лиз_, соф_,
  { {0x7f860032,0x9f5e00fe,0xd8380ecf,0x00000000}},	//   _الجن, ätä_, _reč_,
  { {0xd8380080,0x93bc000c,0x7cf02045,0x00000000}},	//   _seč_, mbăt, järv,
  { {0xe8380054,0x2fd7005d,0x00000000,0x00000000}},	//   аплі_, _نوید_,   ,
  { {0x3ea70529,0x48e3005a,0x4973000d,0x00000000}},	//   _într_, почв, яліс,
  { {0xd8380fbf,0xf1bf000f,0x6d561362,0x00000000}},	//   _več_, zzá_, luya,
  { {0xc6f80001,0xa6aa009e,0x7c3e1561,0x00000000}},	//   јних_, طابق_, lapr,
  { {0x54b80330,0xe9da2046,0xe8fa2047,0x00000000}},	//   игия_, _ска_, _бла_,
  { {0x38b903b2,0x443810c3,0xb5fd0066,0x00000000}},	//   _père_, úr_, rešp,
  { {0xd251006a,0x7e760026,0x25bf003b,0x00000000}},	//   وند_, keyp, azul_,
  { {0x6d5600bb,0xddcd003b,0x3f850026,0x00000000}},	//   kuya, neaţ, ælum_,
  { {0x9c830198,0x68ea0122,0x7cf000bd,0x00000000}},	//   ščit, oofd, läru,
  { {0x9a290013,0x661d0066,0xdb0d0066,0x00000000}},	//   _mươi_, ľske, ľkém,
  { {0xbcfb03b2,0x443e1f1f,0xaab80053,0x00000000}},	//   _opér, mat_, _आतंक,
  { {0x38ab06a5,0x443e2048,0xff072049,0x00000000}},	//   _hørt_, lat_, сягн,
  { {0x38ab00b9,0xf2d40047,0x9c39005e,0x00000000}},	// [3130] _kørt_, _מעק_, ипат_,
  { {0x6ef3005b,0x443e204a,0x645a204b,0x00000000}},	//   içbi, nat_, ngti,
  { {0x443e000c,0x645a00b9,0xea19204c,0x00000000}},	//   iat_, igti, ажеш_,
  { {0x443e204d,0xda650054,0x6008009a,0x00000000}},	//   hat_, івли, _לִרְ,
  { {0xd9450076,0x443e204e,0x7cf0204f,0x00000000}},	//   цели, kat_, värv,
  { {0xdcb10013,0xa7a92050,0x443e2051,0x00000000}},	//   _ổ_, икла_, jat_,
  { {0x3eb90026,0x443e2052,0x22492053,0x00000000}},	//   _klst_, dat_, _odak_,
  { {0x22490150,0x443e0770,0x85490a8f,0x00000000}},	//   _ndak_, eat_, азив_,
  { {0x443e1df0,0x93bc003b,0x39400014,0x00000000}},	//   fat_, zbăt, áist_,
  { {0xe4c5019d,0x20cd00eb,0x645a00d1,0x00000000}},	//   ійни, džio_, ggti,
  { {0x7cf000fe,0x7aeb006f,0x25bf013d,0x00000000}},	//   märt, oogt, szul_,
  { {0x645a2054,0xae090053,0x443e2055,0x00000000}},	//   agti, वधान_, aat_,
  { {0x443e2056,0x38ab06a5,0x672d007d,0x00000000}},	//   bat_, _ført_, ćaju,
  { {0x443e2057,0xbf020053,0x6b6c001c,0x00000000}},	//   cat_, लग्न_, lēgš,
  { {0x6d4b0025,0xa91d0648,0x3f8c0195,0x00000000}},	//   ágan, _drži, ídu_,
  { {0x93bc000c,0x7c3e0150,0xa91d0078,0x00000000}},	//   rbăt, wapr, _erži,
  { {0x62960273,0x27e001f7,0x7c3e2058,0x00000000}},	// [3140] _inyo, ğini_, tapr,
  { {0x93bc0529,0x62860004,0x62840035,0x00000000}},	//   mbăr, ldko, _haio,
  { {0x7c3e1605,0x6d56006c,0x7aeb013d,0x00000000}},	//   rapr, suya, fogt,
  { {0xd83800c2,0x6d560003,0x7c3e2059,0x00000000}},	//   _točk_, puya, sapr,
  { {0x628403d9,0x62960009,0x443e03f9,0x00000000}},	//   _maio, _mnyo, yat_,
  { {0x443e1f1c,0xc8660086,0xed4301dd,0x00000000}},	//   xat_, ітли, _інсп,
  { {0x6d44205a,0x501b014e,0x99490051,0x00000000}},	//   lsia, בוצו, góły_,
  { {0x356a0088,0x7c3c205b,0xd83800c3,0x00000000}},	//   арон_, _herr, _moči_,
  { {0x443e205c,0xd83800c2,0x7c3c205d,0x00000000}},	//   tat_, _loči_, _kerr,
  { {0x62960465,0xc9d5007e,0x6d44205e,0x00000000}},	//   _anyo, _عملک, isia,
  { {0x6d4400e3,0x69c2006f,0xd83800c2,0x00000000}},	//   hsia, lzoe, _noči_,
  { {0x6b830146,0x672d017f,0x443e2056,0x00000000}},	//   ængi, ćajt, sat_,
  { {0xf1c5016a,0x56d90047,0x443e035d,0x00000000}},	//   _लेखन, _פֿעד, pat_,
  { {0x6e24205f,0x84380021,0x443e0222,0x00000000}},	//   ecib, _اكثر_, qat_,
  { {0x6d460c4a,0x22560080,0x78a801e1,0x00000000}},	//   _avka, ácké_, _modv,
  { {0x443c2060,0x3f45001c,0x628400be,0x00000000}},	//   _hev_, rķu_, _gaio,
  { {0xa91d2061,0x7d550062,0x54fe0053,0x00000000}},	// [3150] _trži, явах, _उठाए_,
  { {0x7c3c2062,0xf1a4000d,0x69c2006f,0x00000000}},	//   _cerr, _ірын, dzoe,
  { {0x69c20122,0x7aeb00e8,0x7c3c100f,0x00000000}},	//   ezoe, togt, _derr,
  { {0x0f7a00b5,0x7cf02063,0x7055007e,0x00000000}},	//   _פארב, färs, _بنگا,
  { {0x7c3c2064,0x99d4007e,0x7aeb01e1,0x00000000}},	//   _ferr, وتها, rogt,
  { {0x88c80086,0x017c0063,0x3afc0014,0x00000000}},	//   олів_, שָׁל, rípa_,
  { {0xe7390055,0xdb23007e,0x7d1d2065,0x00000000}},	//   щей_, _آوری, _huss,
  { {0x7c3c0378,0x66de008f,0x69c200ca,0x00000000}},	//   _zerr, tīka, bzoe,
  { {0x7cf000fe,0x62842066,0x765b0058,0x00000000}},	//   märr, _raio, rguy,
  { {0x6aa90122,0x7d1d2067,0x7c3c01a8,0x00000000}},	//   _hoef, _muss, _xerr,
  { {0x6e3d00f5,0x7d1d2068,0x62842069,0x00000000}},	//   _oesb, _luss, _paio,
  { {0x6d44206a,0xe0c90047,0x7c250139,0x00000000}},	//   ysia, _גײ_, hchr,
  { {0x443c1560,0xa5f8005e,0x6286206b,0x00000000}},	//   _fev_, _децу_, rdko,
  { {0xa06a0001,0x5468000d,0x93bc003b,0x00000000}},	//   љава_, _маім_, rbăr,
  { {0xdfd20032,0x7d1d206c,0x6abb00ac,0x00000000}},	//   رير_, _auss, _oluf,
  { {0x6d440004,0x7d15003d,0x7b030019,0x00000000}},	//   tsia, _aizs, nõud,
  { {0x6d44206d,0x6e24206e,0xee37000d,0x00000000}},	// [3160] usia, rcib, янт_,
  { {0x6e24206f,0x64412070,0x22422071,0x00000000}},	//   scib, nali, lakk_,
  { {0x7d1d0164,0x64410035,0x7c3c13aa,0x00000000}},	//   _euss, iali, _verr,
  { {0x7b030019,0x69c2006f,0x64412072,0x00000000}},	//   jõud, tzoe, hali,
  { {0x64412073,0x4427001f,0x7d1d0206,0x00000000}},	//   kali, _ofn_, _guss,
  { {0x69c202b0,0x6f1e1c6b,0x64412074,0x00000000}},	//   rzoe, _kupc, jali,
  { {0x69c20122,0xf093014e,0x6aa900ac,0x00000000}},	//   szoe, תנו_, _foef,
  { {0x7d1d2075,0x44270014,0x443c008f,0x00000000}},	//   _yuss, _afn_, _sev_,
  { {0x64410739,0x7ae319ad,0x7eb8004c,0x00000000}},	//   fali, énte, _lípo,
  { {0x39462076,0x64412077,0xd49a0239,0x00000000}},	//   msos_, gali, сри_,
  { {0x99840006,0x38ab00d1,0xa279167b,0x00000000}},	//   _temų_, _tørr_, обну_,
  { {0x32670076,0x64412078,0xdbc7004b,0x00000000}},	//   чтов, aali, pöör,
  { {0x6441170b,0x6e3d18a7,0x443c001c,0x00000000}},	//   bali, _resb, _tev_,
  { {0x64a30088,0x644118f5,0x20cd004c,0x00000000}},	//   _пача, cali, mžik_,
  { {0x224200d1,0x7d1d1eec,0x2d8206a5,0x00000000}},	//   bakk_, _suss, _aske_,
  { {0x7c25002b,0x6727013d,0x7d150058,0x00000000}},	//   wchr, _éjje, _sizs,
  { {0x7b030019,0x6e3d00a8,0x7cf000a5,0x00000000}},	// [3170] nõue, _vesb, värr,
  { {0xad9b006d,0x91bc0063,0xc1bc0063,0x00000000}},	//   _azúc, _למחי, _למחש,
  { {0x7d1500ea,0x7d1d004d,0x7c252079,0x00000000}},	//   _vizs, _wuss, rchr,
  { {0x7c251a91,0x7d1d0102,0xc3330063,0x00000000}},	//   schr, _tuss, תוף_,
  { {0x6441207a,0x7b03004b,0x9c830445,0x00000000}},	//   yali, jõue, áčst,
  { {0xec290021,0x7c8401ce,0xb79501ce,0x00000000}},	//   _ذكرى_, _пусе, дрић,
  { {0x238c0080,0x6441207b,0x7cf00137,0x00000000}},	//   _něj_, vali, pärr,
  { {0xa562007e,0x20070066,0x6441207c,0x00000000}},	//   چگون, _úniu_, wali,
  { {0x26c30006,0xc6480021,0xa562007e,0x00000000}},	//   ėjo_, سجيل_, نگون,
  { {0x6441207d,0x3a3f00ca,0xf3490cb2,0x00000000}},	//   uali, _heup_, опол_,
  { {0x61f60072,0x96eb0121,0x6441207e,0x00000000}},	//   _syyl, _льда_, rali,
  { {0x216a0076,0xc0490ee1,0x6441207f,0x00000000}},	//   оими_, _כז_, sali,
  { {0x21a30076,0xf6520063,0x64412080,0x00000000}},	//   виям, _יצא_, pali,
  { {0x3cf90053,0x6ada0082,0x00000000,0x00000000}},	//   ्गों_, _भद्र,   ,
  { {0x291f0019,0x93bc003b,0x65691561,0x00000000}},	//   _luua_, ncăl, lteh,
  { {0x61f600fe,0x00000000,0x00000000,0x00000000}},	//   _tyyl,   ,   ,
  { {0xf1bf02fc,0x65692081,0x8d66000d,0x00000000}},	// [3180] lcán_, nteh, ьвае,
  { {0x315700b5,0xec770894,0x718b009d,0x00000000}},	//   _קיין_, мпу_, _וְטַ,
  { {0x309b0063,0xa09b0063,0x9a860091,0x00000000}},	//   _ושימ, _וייט, дулл,
  { {0x21200089,0x2b4700dd,0xa3d40082,0x00000000}},	//   _kuih_, ânca_, _सेफ_,
  { {0x39460006,0x397a04f6,0x5937000d,0x00000000}},	//   usos_, تصاد_, дзіў_,
  { {0x394605ca,0x7f5c0003,0x21200089,0x00000000}},	//   rsos_, ourq, _muih_,
  { {0x39460f76,0xdce4027c,0xd7ef0b3f,0x00000000}},	//   ssos_, ntič, ту_,
  { {0x38c8007e,0x6d5600a4,0x2d802082,0x00000000}},	//   _کاری_, orya, owie_,
  { {0xe5c60076,0xe4e60086,0x78660ac5,0x00000000}},	//   ьско, дінн, _оказ,
  { {0xdce42061,0x80d00042,0x00000000,0x00000000}},	//   ktič, डोमे,   ,
  { {0x2ca7004b,0xe2f90603,0x65692083,0x00000000}},	//   öndi_, зені_, ateh,
  { {0x92940088,0xe6930021,0x7b03004b,0x00000000}},	//   ваюц, _للمد, põue,
  { {0xf5b6006a,0xf1b90240,0xf1bf2084,0x00000000}},	//   _تصاد, áš_, acán_,
  { {0xfd4f008b,0x2d800051,0xb75a0013,0x00000000}},	//   _triế, dwie_, _ngừơ,
  { {0xc588001b,0x46b20042,0xf2030042,0x00000000}},	//   _hồ_, _जवाह, रेज़_,
  { {0x3869007d,0xe5020042,0xe731009a,0x00000000}},	//   đari_, _रीति_, רֵם_,
  { {0x7cf00e77,0x2d802085,0x00000000,0x00000000}},	// [3190] tärp, gwie_,   ,
  { {0xc5880013,0x387c0130,0x00000000,0x00000000}},	//   _mồ_, jevr_,   ,
  { {0xf42900fe,0x66de001c,0xc588008b,0x00000000}},	//   lkää_, tīkl, _lồ_,
  { {0x527c0047,0x60d52086,0x0dcb0f63,0x00000000}},	//   ַנוא, lizm, _дуги_,
  { {0x39490d2f,0x5e560149,0x6f0d2087,0x00000000}},	//   éas_, _אירע_, mmac,
  { {0x6b8300b9,0xb0660072,0x80a20053,0x00000000}},	//   ængs, _ikää, खाये,
  { {0x6602000f,0x7ceb00bd,0x20cd0130,0x00000000}},	//   _azok, kürz, ržih_,
  { {0x291f0019,0xc588008b,0x661d0066,0x00000000}},	//   _tuua_, _bồ_, ľsko,
  { {0x93bc003b,0xe5760121,0x98752088,0x00000000}},	//   scăl, езы_, _плац,
  { {0x6f0d00bd,0xdce70078,0x79580e82,0x00000000}},	//   hmac, ėmėt, _цифр_,
  { {0x6f0d2089,0x6569208a,0x2d800051,0x00000000}},	//   kmac, steh, zwie_,
  { {0x87b60047,0x60d50249,0xe7b60041,0x00000000}},	//   _אלעס_, eizm, _אהער_,
  { {0x463a00b5,0x30760086,0xf1bf0139,0x00000000}},	//   _זענע, нувс, scán_,
  { {0x73e5011c,0x30750076,0x672100fe,0x00000000}},	//   _полз, кусс, _kulj,
  { {0xf8520024,0xf8ad008b,0x91031410,0x00000000}},	//   ížiť_, _đợi_, упре,
  { {0x2d800051,0x38650150,0x67210ba5,0x00000000}},	//   twie_, _lclr_, _mulj,
  { {0x82770047,0xdce4208b,0xf3890013,0x00000000}},	// [31a0] _טעקע_, stič, _hả_,
  { {0x6c860021,0x9f860304,0xef860330,0x00000000}},	//   علام, _згод, _злоп,
  { {0x395d006f,0x6e461137,0x26df007d,0x00000000}},	//   euws_, _пенз, knuo_,
  { {0x7eb104aa,0xf3890013,0x6da60bd8,0x00000000}},	//   _dåps, _mả_, _зима,
  { {0x7ae3006d,0xd6d0007e,0x2d8f0b2a,0x00000000}},	//   énta, یقت_, åget_,
  { {0x98a30f34,0xc5880013,0x67210130,0x00000000}},	//   личе, _rồ_, _bulj,
  { {0x660200ea,0xfce3208c,0x7c3f013d,0x00000000}},	//   _szok, _соро, özrő,
  { {0x6721017f,0x26df007d,0x60d5208d,0x00000000}},	//   _dulj, gnuo_, zizm,
  { {0xfcaa009d,0x00000000,0x00000000,0x00000000}},	//   ִיֹּ,   ,   ,
  { {0x07a60088,0x6d4b00ea,0x7ceb004d,0x00000000}},	//   _пазн, ágai, würz,
  { {0xf389001b,0x6f0d0731,0x7ceb004d,0x00000000}},	//   _cả_, ymac, türz,
  { {0xf7730063,0x9f5e0066,0xf4290072,0x00000000}},	//   _תקף_, ätý_, tkää_,
  { {0xc1b81224,0x60d5208e,0x7b03004e,0x00000000}},	//   елях_, tizm, nõua,
  { {0x13f4005a,0x645c017d,0xddc6056c,0x00000000}},	//   _изля, órid, _odkł,
  { {0xcebb005e,0xf389008d,0x60d50de1,0x00000000}},	//   пља_, _gả_, rizm,
  { {0x79820022,0x60d5208f,0x9f48011b,0x00000000}},	//   kwow, sizm, íhán_,
  { {0x98830024,0x75220006,0x6f0d2090,0x00000000}},	// [31b0] víľu_, _juoz, rmac,
  { {0x9c8200c2,0x658f013d,0x7e66004d,0x00000000}},	//   ščne, lőhö, _eckp,
  { {0xc4d300b5,0xf3890013,0x1cb80044,0x00000000}},	//   נגע_, _xả_, راكب_,
  { {0x2d8f00b9,0x76420331,0x59d20042,0x00000000}},	//   åges_, _neoy, _देहर,
  { {0x672100fe,0x3ea9008f,0xd91b0121,0x00000000}},	//   _sulj, mjat_, чье_,
  { {0xdb23007e,0x9dd60063,0x67212091,0x00000000}},	//   _موسی, _יורק_, _pulj,
  { {0x26df007d,0x2ca70014,0xc7a50062,0x00000000}},	//   tnuo_, öndu_, тийк,
  { {0x3ea92092,0xf3890013,0x59d20082,0x00000000}},	//   njat_, _rả_, _देवर,
  { {0xceb40e2a,0x3ea90072,0xf5090363,0x00000000}},	//   טיק_, ijat_, мнил_,
  { {0x26df007d,0x3ea901cf,0x66e8004c,0x00000000}},	//   snuo_, hjat_, věke,
  { {0xa3cb0053,0xed60004c,0x00000000,0x00000000}},	//   _रेख_, ěžit_,   ,
  { {0x6d5f00ac,0xf3890013,0xe2970446,0x00000000}},	//   kuqa, _vả_, ваю_,
  { {0x20d6019d,0xcb1200b5,0x3ea914c8,0x00000000}},	//   вівс, ילט_, djat_,
  { {0xf389001b,0x3e7c0013,0x09b6009a,0x00000000}},	//   _tả_, _ật_, דפשט_,
  { {0xddca0051,0x10a3150a,0x64432093,0x00000000}},	//   łoży, ширн, _ieni,
  { {0x20cd0006,0x79820051,0x64432094,0x00000000}},	//   džiu_, ywow, _heni,
  { {0xe0d2007e,0x64432095,0xfc320021,0x00000000}},	// [31c0] _نزد_, _keni, لحا_,
  { {0x64432096,0x3ea900fe,0xccc30085,0x00000000}},	//   _jeni, ajat_, абуй,
  { {0x2d8f0146,0xd83e00c2,0x64432097,0x00000000}},	//   åger_, ščka_, _meni,
  { {0x64432098,0x79820051,0xdb21013d,0x00000000}},	//   _leni, twow, átás,
  { {0x3eab0240,0x644307fc,0x6b95004d,0x00000000}},	//   žitá_, _oeni, _erzg,
  { {0x79820051,0x658f013d,0xfce61cce,0x00000000}},	//   rwow, zőhö, _рого,
  { {0xf6e61567,0x36d42099,0xc8b50085,0x00000000}},	//   кцин, локр, ысцы,
  { {0xd6d70475,0x7b03004b,0x96330062,0x00000000}},	//   кты_, lõun, анъц,
  { {0xb5a3000d,0x752201f4,0x7ae2209a,0x00000000}},	//   арэй, _quoz, mnot,
  { {0x7ae20051,0xe7ed0053,0x6443209b,0x00000000}},	//   lnot, _चुका_, _ceni,
  { {0x645c00cd,0x9f4f005b,0x644316d6,0x00000000}},	//   òriq, ünüz_, _deni,
  { {0x64430179,0xa159000d,0x41e7013c,0x00000000}},	//   _eeni, наму_, віга,
  { {0xb356006a,0x6443209c,0x7ae2209d,0x00000000}},	//   ریکا_, _feni, inot,
  { {0x6443209e,0x7ae20139,0x658f013d,0x00000000}},	//   _geni, hnot, sőhö,
  { {0x3ea90bba,0x644807f4,0xdfd80062,0x00000000}},	//   tjat_, madi, вът_,
  { {0xaf34007e,0xff070086,0x6e220066,0x00000000}},	//   شرفت, тягн, žobn,
  { {0x644301f7,0x7d1c0026,0x7ae20114,0x00000000}},	// [31d0] _yeni, _birs, dnot,
  { {0x3e53001b,0xdcf90021,0x64481e3e,0x00000000}},	//   ệt_, رفات_, nadi,
  { {0xaa950086,0x64480066,0x7d1c209f,0x00000000}},	//   лижч, iadi, _dirs,
  { {0x628f20a0,0x644820a1,0x7ae220a2,0x00000000}},	//   ndco, hadi, gnot,
  { {0x7d1c0034,0x69cd016a,0x79a7005a,0x00000000}},	//   _firs, _देखी, ърже,
  { {0x7ae2024a,0x961d001c,0x644820a3,0x00000000}},	//   anot, ieņe, jadi,
  { {0xccf20063,0x644820a4,0x98480054,0x00000000}},	//   _לכך_, dadi, тяча_,
  { {0x6e2d18ff,0xb5fd001c,0x645d0006,0x00000000}},	//   ncab, egša, ėsim,
  { {0x6d4d015d,0x644320a5,0x6f1d20a6,0x00000000}},	//   nsaa, _peni, _misc,
  { {0x6f1d20a7,0xf770007e,0x628f20a8,0x00000000}},	//   _lisc, _ژان_, edco,
  { {0x628f006f,0x644320a9,0x69cb004d,0x00000000}},	//   fdco, _veni, lzge,
  { {0x64430199,0x68ed0025,0x6d4d20aa,0x00000000}},	//   _weni, éadf, ksaa,
  { {0x64480009,0x64431961,0x645c04a6,0x00000000}},	//   badi, _teni, óric,
  { {0x6f1d0027,0x6d4d00e8,0xd6d90051,0x00000000}},	//   _aisc, dsaa, lił_,
  { {0xd36e0021,0x6f1d20ab,0x68e30f49,0x00000000}},	//   _فهو_, _bisc, innd,
  { {0x6d4d00e8,0xdfcf0021,0xd6d90051,0x00000000}},	//   fsaa, سيق_, nił_,
  { {0xed570079,0x6d4d20ac,0xd83e0078,0x00000000}},	// [31e0] лот_, gsaa, ščia_,
  { {0x20cd0080,0x6f1d20ad,0x621b009a,0x00000000}},	//   užit_, _eisc, _אופק,
  { {0xad9b006d,0x7d1c20ae,0x6d4d20af,0x00000000}},	//   _ayúd, _virs, asaa,
  { {0x7d1c004d,0x7ae220b0,0xeafa01fb,0x00000000}},	//   _wirs, unot, ررات_,
  { {0x99dd0024,0x2d840003,0x7ae220b1,0x00000000}},	//   _peňa, _ème_, rnot,
  { {0x2cb100c2,0x7ae220b2,0x2b5a20b3,0x00000000}},	//   _gozd_, snot, prpc_,
  { {0x644820b4,0xb21b0831,0xf1c200c2,0x00000000}},	//   vadi, ndær, lišč_,
  { {0x65aa0001,0xb60500c2,0x64480011,0x00000000}},	//   етог_, _oišč, wadi,
  { {0x644820b5,0x7b06008f,0x35b30062,0x00000000}},	//   tadi, ārtē, йбър,
  { {0x297b0041,0x3a09005d,0x2418007f,0x00000000}},	//   _אטמא, _شکنی_, копы_,
  { {0xd6d90051,0x442e004d,0x644820b6,0x00000000}},	//   bił_, _vff_, radi,
  { {0xd6d90051,0xe2150121,0xb60500c2,0x00000000}},	//   cił_, имны, _bišč,
  { {0x291e014f,0x6f1d20b7,0x59c40053,0x00000000}},	//   _kita_, _risc, वनिर,
  { {0xf1c200c2,0x43940601,0x442e20b8,0x00000000}},	//   dišč_, _вакс, _uff_,
  { {0x14d720b9,0x291e20ba,0x226a0072,0x00000000}},	//   _גוגל_, _mita_, ätkö_,
  { {0x1e350088,0x63b50066,0x291e20bb,0x00000000}},	//   рнаў, äzne, _lita_,
  { {0xe905001b,0x63ba00b9,0x2d580b3f,0x00000000}},	// [31f0] _lượ, lytn, лить_,
  { {0x0f35007e,0x6d4d20bc,0x6e2d20bd,0x00000000}},	//   _نکرد, rsaa, scab,
  { {0x63ba0831,0x6f1d0221,0xbc0703d6,0x00000000}},	//   nytn, _tisc, учай,
  { {0x6f1d0025,0x69cb20be,0xdb120026,0x00000000}},	//   _uisc, tzge, ægðu,
  { {0x291e20bf,0x186920c0,0x00000000,0x00000000}},	//   _bita_, вали_,   ,
  { {0xd6d90051,0x2d99006d,0x63ba0240,0x00000000}},	//   wił_, _irse_, kytn,
  { {0x291e20c1,0x7cf00072,0xa3d40042,0x00000000}},	//   _dita_, järy, _सेल_,
  { {0xe9050013,0x2b5c004c,0x291e2071,0x00000000}},	//   _dượ, ávce_, _eita_,
  { {0x7afb0397,0x291e20c2,0x7649002b,0x00000000}},	//   _ikut, _fita_, raey,
  { {0xa5090001,0xd6d90051,0x67d50782,0x00000000}},	//   ђена_, sił_, _козу,
  { {0x645c20c3,0xd6d90051,0x7ae900d1,0x00000000}},	//   ória, pił_, _kjet,
  { {0x95d90076,0x291e20c4,0x2d8b20c5,0x00000000}},	//   _идет_, _zita_, _osce_,
  { {0x26110053,0x7afb05b3,0x64a520c6,0x00000000}},	//   देशी_, _mkut, _вала,
  { {0x7ae9017f,0x65750024,0x7eb800cd,0x00000000}},	//   _ljet, ľahč, _lípt,
  { {0x61ed15ae,0x2d9900dd,0x224b20c7,0x00000000}},	//   _exal, _arse_, back_,
  { {0xf1c200c3,0x5de6026b,0xb21b01e1,0x00000000}},	//   tišč_, ажба, rdær,
  { {0xf8c50053,0xcd270062,0xfe430054,0x00000000}},	// [3200] वसाय, ижте_, інфо,
  { {0x3b960001,0xc19b0063,0xf1c200a8,0x00000000}},	//   ијет, _ישפי, rišč_,
  { {0x60dc002c,0x2d8b0290,0x7ae90331,0x00000000}},	//   mirm, _esce_, _bjet,
  { {0x291e20c8,0x60dc0058,0x7eb80046,0x00000000}},	//   _sita_, lirm, _pípu,
  { {0xed57005a,0x7ae9007d,0x60dc0139,0x00000000}},	//   _коя_, _djet, oirm,
  { {0xd8f7019d,0x60dc20c9,0xf7540021,0x00000000}},	//   анії_, nirm, منتج,
  { {0x291e20ca,0x60dc004b,0x69d60082,0x00000000}},	//   _vita_, iirm, _मेरी,
  { {0x7eb8000f,0x60dc00bd,0x7ae900d1,0x00000000}},	//   _típu, hirm, _gjet,
  { {0x96b70001,0x7c29005b,0xe4a620cb,0x00000000}},	//   рују_, _şeri, арно,
  { {0x291e003b,0xe905008b,0xd49a0806,0x00000000}},	//   _uita_, _tượ, три_,
  { {0x224b0034,0x929520cc,0xc6a6005e,0x00000000}},	//   tack_, банц, _врли,
  { {0x81c3001c,0x56930086,0x2b47003b,0x00000000}},	//   ņēmi, _маєт, ânci_,
  { {0xd534007e,0xddcd003b,0x60dc20cd,0x00000000}},	//   _افتخ, ifaţ, firm,
  { {0x672801a8,0x224b20ce,0x66e1008f,0x00000000}},	//   _kudj, sack_, vēki,
  { {0x232720cf,0xd43700b5,0x61140086,0x00000000}},	//   _који_, _דרוק_, ідсу,
  { {0x443e004d,0x877b009d,0x33fb009d,0x00000000}},	//   lbt_, כאלי, _שההנ,
  { {0x5d99000d,0x32090058,0xfd470085,0x00000000}},	// [3210] ыкаў_, _uzay_, рэбн,
  { {0x60dc0331,0x7ae920d0,0x7afb20d1,0x00000000}},	//   cirm, _sjet, _skut,
  { {0x443e0199,0x68f80130,0x3b670094,0x00000000}},	//   ibt_, dovd, ръзв,
  { {0x21290089,0x7c3e008f,0x66e8004c,0x00000000}},	//   _kuah_, abpr, děko,
  { {0xe9f80086,0x7ae920d2,0x9f5e0072,0x00000000}},	//   анці_, _vjet, ätö_,
  { {0x6728024a,0xe8f80304,0x224900e5,0x00000000}},	//   _budj, алі_, _leak_,
  { {0x7b030019,0x21290089,0xe7680021,0x00000000}},	//   nõuk, _luah_, لحين_,
  { {0x443e20d3,0x7ae900c2,0x7afb02ae,0x00000000}},	//   ebt_, _ujet, _ukut,
  { {0xb9340635,0x2eaa0047,0x25a90044,0x00000000}},	//   _метј, רשפּ, ادعي_,
  { {0x442300b9,0x7b2c0058,0xc8b40044,0x00000000}},	//   øj_, _oğul, _وإلغ,
  { {0x60dc005b,0x83a80021,0x224900e5,0x00000000}},	//   virm, لاَّ_, _beak_,
  { {0x2129053b,0x63bc00d1,0x1b7a0047,0x00000000}},	//   _buah_, ørna, נטרע,
  { {0x443e00c7,0xd36e007e,0x60dc20d4,0x00000000}},	//   bbt_, وهی_, tirm,
  { {0x25c90058,0x2d9e004c,0xf5560044,0x00000000}},	//   ıtlı_, _čte_, _الوب_,
  { {0xbea606b4,0x60dc0014,0x93bc003b,0x00000000}},	//   бавк, rirm, ucăt,
  { {0x93bc003b,0xc24607b3,0x42560044,0x00000000}},	//   rcăt, _уник, _انظر,
  { {0x60dc20d5,0x628620d6,0x93bc003b,0x00000000}},	// [3220] pirm, meko, scăt,
  { {0x30860032,0x628620d7,0xf06601ce,0x00000000}},	//   _الدف, leko, _укоп,
  { {0x20290024,0x62860173,0x93bc003b,0x00000000}},	//   átiť_, oeko, lcăr,
  { {0x628620d8,0x24851eca,0x66e8011b,0x00000000}},	//   neko, helm_, věko,
  { {0x38cb006a,0x6f0400bd,0x6728017f,0x00000000}},	//   گانی_, mlic, _sudj,
  { {0x6f0420d9,0x62860ff2,0x7c2900dd,0x00000000}},	//   llic, heko, _şerv,
  { {0x6286057e,0x38cb007e,0x35d00053,0x00000000}},	//   keko, دانی_, _तेज़,
  { {0x6f040199,0x628620da,0x257000cd,0x00000000}},	//   nlic, jeko, tàl_,
  { {0x799b006f,0x645c20db,0xd9430782,0x00000000}},	//   _gruw, ório, _нети,
  { {0x6728000f,0x6f0420dc,0x443e00bd,0x00000000}},	//   _tudj, hlic, ubt_,
  { {0x22490034,0x443e00bd,0x6f0420dd,0x00000000}},	//   _peak_, rbt_, klic,
  { {0xd5a4007e,0xe2f90086,0x66de001c,0x00000000}},	//   _ولای, ремі_, rīks,
  { {0xc05b019d,0x6f0420de,0x7ae3006d,0x00000000}},	//   лів_, dlic, énti,
  { {0x22490034,0xf6170063,0x65c10014,0x00000000}},	//   _weak_, _החדש_, sáhö,
  { {0x6f0420df,0xcfa40d34,0xc1040021,0x00000000}},	//   flic, пшти, سوفي,
  { {0x212900e3,0x6f0420e0,0x644a20e1,0x00000000}},	//   _tuah_, glic, _hefi,
  { {0x644a20e2,0x6b9c20e3,0x5274005d,0x00000000}},	// [3230] _kefi, _arrg, _رايز,
  { {0xddd0003b,0x6f1616bb,0x0ba70121,0x00000000}},	//   ţeşt, amyc, йшем,
  { {0xebd90002,0xbab50121,0x9be4000d,0x00000000}},	//   јдеш_, жёлы, піцк,
  { {0x6f0420e4,0x999920e5,0x2b5c0066,0x00000000}},	//   clic, икет_, ávca_,
  { {0x6458082a,0x7e6f0150,0xd82520e6,0x00000000}},	//   _odvi, _iccp, одли,
  { {0x4759011c,0x98a2026b,0x62860051,0x00000000}},	//   ария_, дише, zeko,
  { {0xe7390055,0x7af90051,0x16a91580,0x00000000}},	//   шей_, powt, ивки_,
  { {0x8579000a,0x2ee9001f,0xb9e70086,0x00000000}},	//   асот_, nnaf_, _лізи,
  { {0xb8830024,0x644a20e7,0x628620e8,0x00000000}},	//   _príč, _befi, veko,
  { {0x644a002b,0xd877009e,0x6f0420e9,0x00000000}},	//   _cefi, _دارب, zlic,
  { {0xdce4017f,0xc2090063,0xc7c70699,0x00000000}},	//   stić, _סה_, _усаи,
  { {0x7e7d20ea,0x248520eb,0xd491008d,0x00000000}},	//   _nbsp, selm_, còn_,
  { {0x412a20ec,0x3495032d,0x961d008f,0x00000000}},	//   рого_, _мадр, meņo,
  { {0x6ab6016a,0x93bc000c,0xa06a00e1,0x00000000}},	//   _अक्र, rcăr, јава_,
  { {0x68e40027,0x6f0420ed,0x93bc000c,0x00000000}},	//   éidi, tlic, scăr,
  { {0x75230199,0x64411ab2,0x32d20078,0x00000000}},	//   _hinz, lbli, ršys_,
  { {0x6f04051d,0x644120ee,0x5d6a0065,0x00000000}},	// [3240] rlic, obli, ризм_,
  { {0x2ee90162,0xdb9a0001,0x44270150,0x00000000}},	//   anaf_, итељ_, _jgn_,
  { {0xda6f0895,0x6f040641,0xeb970201,0x00000000}},	//   мя_, plic, жих_,
  { {0x63ae004d,0xbae50054,0x764b20ef,0x00000000}},	//   äbni, пцій, _negy,
  { {0x2d8f00b9,0x672220f0,0x442701f4,0x00000000}},	//   æget_, _rioj, _ogn_,
  { {0x7659002b,0xd7940062,0x58d70054,0x00000000}},	//   _adwy, зикъ, одія_,
  { {0x764b02ab,0x68ed0025,0x644105b9,0x00000000}},	//   _begy, éada, dbli,
  { {0x35b417f4,0x3860005b,0x6441004d,0x00000000}},	//   збир, şir_, ebli,
  { {0x2cb80004,0x7659001f,0x2db70047,0x00000000}},	//   _kord_, _ddwy, ַלטן_,
  { {0x752313ba,0x2cb80e6c,0x442720f1,0x00000000}},	//   _cinz, _jord_, _cgn_,
  { {0x4427028d,0x644a0026,0xa2950454,0x00000000}},	//   _dgn_, _vefi, пані,
  { {0x75230199,0x2cb81e3e,0x442705a5,0x00000000}},	//   _einz, _lord_, _egn_,
  { {0x644102f6,0x66de001c,0x752301f4,0x00000000}},	//   bbli, lūko, _finz,
  { {0x6458010a,0x2cb820f2,0x75230168,0x00000000}},	//   _udvi, _nord_, _ginz,
  { {0x645d0006,0x7659002b,0x0f1b0044,0x00000000}},	//   ėsit, _ydwy, لغرب_,
  { {0x4427006f,0xd3570063,0x1d351dfd,0x00000000}},	//   _zgn_, _ויהי_, зная,
  { {0x2cb820f3,0x61550021,0x00000000,0x00000000}},	// [3250] _bord_, _عندئ,   ,
  { {0x2cb800e5,0xd53b009a,0x00000000,0x00000000}},	//   _cord_, יתמט,   ,
  { {0xd0f80042,0xfbab0085,0x23ca0042,0x00000000}},	//   ंकरण_, штай_, ानिद,
  { {0x6ffa0063,0xbad80054,0x99d704a0,0x00000000}},	//   _להתפ, офії_, يتشا,
  { {0x6441001f,0xe8ee184b,0xd9451741,0x00000000}},	//   ybli, ел_, чели,
  { {0x3eb912d4,0x7e6d004b,0x798b002b,0x00000000}},	//   _host_, lgap, rwgw,
  { {0x8ae70086,0x18660062,0xad9b013d,0x00000000}},	//   _діал, чащи_, _ezút,
  { {0x7e6d20f4,0xc98705ef,0xa7fc0075,0x00000000}},	//   ngap, _музи, _acıs,
  { {0x3eb920f5,0x95550032,0x26df00eb,0x00000000}},	//   _most_, أخبا, riuo_,
  { {0x3eb90034,0xd469005e,0x644120f6,0x00000000}},	//   _lost_, љине_, ubli,
  { {0x3eb90122,0xf7700021,0x7aeb20f7,0x00000000}},	//   _oost_, _لان_, ongt,
  { {0x64411f5f,0x29070b68,0xddc4003b,0x00000000}},	//   sbli, llna_, ngiţ,
  { {0x2731008b,0x59bd0053,0x6456013d,0x00000000}},	//   _hán_, ्निर, égió,
  { {0x859a014e,0x9742017f,0x659a0e2a,0x00000000}},	//   _לשנו, šćen, _לינק,
  { {0x3eb9001f,0x656900fe,0x27311994,0x00000000}},	//   _bost_, lueh, _ján_,
  { {0xa3d40053,0x7e6d20f8,0x3eb920f9,0x00000000}},	//   _सेट_, ggap, _cost_,
  { {0x27310025,0x6296002c,0x4d660603,0x00000000}},	// [3260] _lán_, _iayo, якав,
  { {0x7e6d002c,0x62961362,0xdd8f0021,0x00000000}},	//   agap, _hayo, طوم_,
  { {0x3eb90469,0x629600bb,0x2d8f00b9,0x00000000}},	//   _fost_, _kayo, æger_,
  { {0x2fc50205,0x2cb8015e,0x656900fe,0x00000000}},	//   ølge_, _word_, kueh,
  { {0x7e9b0063,0x629620fa,0xe89420fb,0x00000000}},	//   _הסכו, _mayo, даль,
  { {0x273120fc,0x7aeb00a4,0x29070026,0x00000000}},	//   _bán_, angt, glna_,
  { {0xd6da0619,0x2731008b,0xaa4620fd,0x00000000}},	//   йти_, _cán_, _невл,
  { {0x987800c3,0x2d840003,0x6d56005b,0x00000000}},	//   _išči_, _âmes_, osya,
  { {0x6d5620fe,0x7ae220ff,0xa4d4071f,0x00000000}},	//   nsya, miot, допі,
  { {0x6296002c,0x27310025,0xa4d80086,0x00000000}},	//   _aayo, _fán_, ідну_,
  { {0x78a81c23,0x6d56017e,0xd91b0149,0x00000000}},	//   _indv, hsya, _פובל,
  { {0xddc4003d,0xf6d6005d,0x7ae22100,0x00000000}},	//   maiņ, _عزاد, niot,
  { {0x64a62101,0x3eb92102,0x63bc00a5,0x00000000}},	//   _нада, _rost_, ärnb,
  { {0x760b00b5,0x65930002,0xe1ff013d,0x00000000}},	//   _פּאַ, _чашу, ngói_,
  { {0x78ba00cf,0x3eb913bb,0x20050014,0x00000000}},	//   _motv, _post_, æli_,
  { {0x62962103,0x660f00bd,0x7b03004b,0x00000000}},	//   _gayo, ückg, nõut,
  { {0xa2aa0053,0x5cb90085,0x7ae22104,0x00000000}},	// [3270] टार्, олаў_, diot,
  { {0xb03501a4,0xddc40023,0x78ba2105,0x00000000}},	//   _юнош, kaiņ, _notv,
  { {0x62960035,0x6d561324,0x316c0051,0x00000000}},	//   _yayo, asya, ądze_,
  { {0x5a34000d,0x7aeb2106,0x27312107,0x00000000}},	//   енцт, ungt, _rán_,
  { {0x78ba01e1,0x27310013,0x98f50085,0x00000000}},	//   _botv, _sán_, мякч,
  { {0x48790086,0x2731027d,0xf77104a0,0x00000000}},	//   ісля_, _pán_, ناب_,
  { {0x7ae22108,0x261a0053,0x97a70085,0x00000000}},	//   biot, मेसी_, ярдл,
  { {0xe5590001,0x7ae20387,0x78a82109,0x00000000}},	//   ојој_, ciot, _endv,
  { {0x78270242,0x6296210a,0xfaff008f,0x00000000}},	//   _فعال, _rayo, ļūda_,
  { {0x61e20026,0x2731008b,0x6abb011b,0x00000000}},	//   _þoli, _tán_, _houf,
  { {0x6296210b,0xc747007e,0x68e3210c,0x00000000}},	//   _payo, _رضاي, mind,
  { {0x91e606b4,0x6abb006c,0x36d4210d,0x00000000}},	//   доме, _jouf, _похр,
  { {0x68e3210e,0xdc0a0042,0x9557005d,0x00000000}},	//   oind, _वर्ड_, _رخشا,
  { {0x7ae2210f,0xf9920063,0x68e32110,0x00000000}},	//   ziot, דרך_, nind,
  { {0x629600a4,0x7b030019,0xdff50121,0x00000000}},	//   _tayo, nõus, еять,
  { {0x68e32111,0x7c29095a,0x8236043e,0x00000000}},	//   hind, _şerp, _غربا,
  { {0x68e31a4f,0x7ae22112,0xad9b013d,0x00000000}},	// [3280] kind, viot, _szúr,
  { {0x3cfa0161,0x69c20035,0xdd8f0021,0x00000000}},	//   ्त