# Copyright (c) 2011 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser',
      'type': 'static_library',
      'msvs_guid': '5BF908A7-68FB-4A4B-99E3-8C749F1FE4EA',
      'dependencies': [
        'app/policy/cloud_policy_codegen.gyp:policy',
        'browser/sync/protocol/sync_proto.gyp:sync_proto_cpp',
        'chrome_extra_resources',
        'chrome_resources',
        'chrome_strings',
        'common',
        'common_net',
        'debugger',
        'in_memory_url_index_cache_proto_cpp',
        'installer_util',
        'platform_locale_settings',
        'profile_import',
        'safe_browsing_csd_proto',
        'safe_browsing_report_proto',
        'syncapi',
        'theme_resources',
        'theme_resources_large',
        'theme_resources_standard',
        'userfeedback_proto',
        '../app/app.gyp:app_resources',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../content/content.gyp:content_browser',
        '../crypto/crypto.gyp:crypto',
        '../media/media.gyp:media',
        '../ppapi/ppapi_internal.gyp:ppapi_proxy',  # For PpapiMsg_LoadPlugin
        '../printing/printing.gyp:printing',
        '../skia/skia.gyp:skia',
        '../third_party/bzip2/bzip2.gyp:bzip2',
        '../third_party/expat/expat.gyp:expat',
        '../third_party/hunspell/hunspell.gyp:hunspell',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
        '../third_party/libphonenumber/libphonenumber.gyp:phonenumber_proto',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/npapi/npapi.gyp:npapi',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/gfx/surface/surface.gyp:surface',
        '../webkit/support/webkit_support.gyp:appcache',
        '../webkit/support/webkit_support.gyp:blob',
        '../webkit/support/webkit_support.gyp:database',
        '../webkit/support/webkit_support.gyp:fileapi',
        '../webkit/support/webkit_support.gyp:glue',
        '../webkit/support/webkit_support.gyp:quota',
        '../webkit/support/webkit_support.gyp:webkit_resources',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
      ],
      'defines': [
        '<@(nacl_defines)',
      ],
      'direct_dependent_settings': {
        'defines': [
          '<@(nacl_defines)',
        ],
      },
      'sources': [
        # All .cc, .h, .m, and .mm files under browser except for tests and
        # mocks.
        'browser/about_flags.cc',
        'browser/about_flags.h',
        'browser/accessibility/browser_accessibility.cc',
        'browser/accessibility/browser_accessibility.h',
        'browser/accessibility/browser_accessibility_cocoa.h',
        'browser/accessibility/browser_accessibility_cocoa.mm',
        'browser/accessibility/browser_accessibility_delegate_mac.h',
        'browser/accessibility/browser_accessibility_mac.h',
        'browser/accessibility/browser_accessibility_mac.mm',
        'browser/accessibility/browser_accessibility_manager.cc',
        'browser/accessibility/browser_accessibility_manager.h',
        'browser/accessibility/browser_accessibility_manager_mac.h',
        'browser/accessibility/browser_accessibility_manager_mac.mm',
        'browser/accessibility/browser_accessibility_manager_win.cc',
        'browser/accessibility/browser_accessibility_manager_win.h',
        'browser/accessibility/browser_accessibility_state.cc',
        'browser/accessibility/browser_accessibility_state.h',
        'browser/accessibility/browser_accessibility_win.cc',
        'browser/accessibility/browser_accessibility_win.h',
        'browser/accessibility_events.cc',
        'browser/accessibility_events.h',
        'browser/aeropeek_manager.cc',
        'browser/aeropeek_manager.h',
        'browser/alternate_nav_url_fetcher.cc',
        'browser/alternate_nav_url_fetcher.h',
        'browser/app_controller_cppsafe_mac.h',
        'browser/app_controller_mac.h',
        'browser/app_controller_mac.mm',
        'browser/app_icon_win.cc',
        'browser/app_icon_win.h',
        'browser/autocomplete/autocomplete.cc',
        'browser/autocomplete/autocomplete.h',
        'browser/autocomplete/autocomplete_accessibility.cc',
        'browser/autocomplete/autocomplete_accessibility.h',
        'browser/autocomplete/autocomplete_classifier.cc',
        'browser/autocomplete/autocomplete_classifier.h',
        'browser/autocomplete/autocomplete_controller_delegate.h',
        'browser/autocomplete/autocomplete_edit.cc',
        'browser/autocomplete/autocomplete_edit.h',
        'browser/autocomplete/autocomplete_match.cc',
        'browser/autocomplete/autocomplete_match.h',
        'browser/autocomplete/autocomplete_popup_model.cc',
        'browser/autocomplete/autocomplete_popup_model.h',
        'browser/autocomplete/autocomplete_popup_view.h',
        'browser/autocomplete/autocomplete_popup_view_gtk.cc',
        'browser/autocomplete/autocomplete_popup_view_gtk.h',
        'browser/autocomplete/autocomplete_popup_view_mac.h',
        'browser/autocomplete/autocomplete_popup_view_mac.mm',
        'browser/autocomplete/builtin_provider.cc',
        'browser/autocomplete/builtin_provider.h',
        'browser/autocomplete/extension_app_provider.cc',
        'browser/autocomplete/extension_app_provider.h',
        'browser/autocomplete/history_contents_provider.cc',
        'browser/autocomplete/history_contents_provider.h',
        'browser/autocomplete/history_provider.cc',
        'browser/autocomplete/history_provider.h',
        'browser/autocomplete/history_provider_util.cc',
        'browser/autocomplete/history_provider_util.h',
        'browser/autocomplete/history_quick_provider.cc',
        'browser/autocomplete/history_quick_provider.h',
        'browser/autocomplete/history_url_provider.cc',
        'browser/autocomplete/history_url_provider.h',
        'browser/autocomplete/keyword_provider.cc',
        'browser/autocomplete/keyword_provider.h',
        'browser/autocomplete/search_provider.cc',
        'browser/autocomplete/search_provider.h',
        'browser/autocomplete_history_manager.cc',
        'browser/autocomplete_history_manager.h',
        'browser/autofill/address.cc',
        'browser/autofill/address.h',
        'browser/autofill/address_field.cc',
        'browser/autofill/address_field.h',
        'browser/autofill/autofill-inl.h',
        'browser/autofill/autofill_cc_infobar_delegate.cc',
        'browser/autofill/autofill_cc_infobar_delegate.h',
        'browser/autofill/autofill_country.cc',
        'browser/autofill/autofill_country.h',
        'browser/autofill/autofill_download.cc',
        'browser/autofill/autofill_download.h',
        'browser/autofill/autofill_ecml.cc',
        'browser/autofill/autofill_ecml.h',
        'browser/autofill/autofill_field.cc',
        'browser/autofill/autofill_field.h',
        'browser/autofill/autofill_ie_toolbar_import_win.cc',
        'browser/autofill/autofill_ie_toolbar_import_win.h',
        'browser/autofill/autofill_manager.cc',
        'browser/autofill/autofill_manager.h',
        'browser/autofill/autofill_metrics.cc',
        'browser/autofill/autofill_metrics.h',
        'browser/autofill/autofill_profile.cc',
        'browser/autofill/autofill_profile.h',
        'browser/autofill/autofill_scanner.cc',
        'browser/autofill/autofill_scanner.h',
        'browser/autofill/autofill_type.cc',
        'browser/autofill/autofill_type.h',
        'browser/autofill/autofill_xml_parser.cc',
        'browser/autofill/autofill_xml_parser.h',
        'browser/autofill/contact_info.cc',
        'browser/autofill/contact_info.h',
        'browser/autofill/credit_card.cc',
        'browser/autofill/credit_card.h',
        'browser/autofill/credit_card_field.cc',
        'browser/autofill/credit_card_field.h',
        'browser/autofill/email_field.cc',
        'browser/autofill/email_field.h',
        'browser/autofill/fax_number.cc',
        'browser/autofill/fax_number.h',
        'browser/autofill/field_types.h',
        'browser/autofill/form_field.cc',
        'browser/autofill/form_field.h',
        'browser/autofill/form_group.cc',
        'browser/autofill/form_group.h',
        'browser/autofill/form_structure.cc',
        'browser/autofill/form_structure.h',
        'browser/autofill/home_phone_number.cc',
        'browser/autofill/home_phone_number.h',
        'browser/autofill/name_field.cc',
        'browser/autofill/name_field.h',
        'browser/autofill/personal_data_manager.cc',
        'browser/autofill/personal_data_manager.h',
        'browser/autofill/personal_data_manager_mac.mm',
        'browser/autofill/phone_field.cc',
        'browser/autofill/phone_field.h',
        'browser/autofill/phone_number.cc',
        'browser/autofill/phone_number.h',
        'browser/autofill/phone_number_i18n.cc',
        'browser/autofill/phone_number_i18n.h',
        'browser/autofill/select_control_handler.cc',
        'browser/autofill/select_control_handler.h',
        'browser/automation/automation_browser_tracker.cc',
        'browser/automation/automation_browser_tracker.h',
        'browser/automation/automation_extension_tracker.cc',
        'browser/automation/automation_extension_tracker.h',
        'browser/automation/automation_omnibox_tracker.cc',
        'browser/automation/automation_omnibox_tracker.h',
        'browser/automation/automation_provider.cc',
        'browser/automation/automation_provider.h',
        'browser/automation/automation_provider_gtk.cc',
        'browser/automation/automation_provider_json.cc',
        'browser/automation/automation_provider_json.h',
        'browser/automation/automation_provider_list.cc',
        'browser/automation/automation_provider_list.h',
        'browser/automation/automation_provider_list_generic.cc',
        'browser/automation/automation_provider_list_mac.mm',
        'browser/automation/automation_provider_mac.mm',
        'browser/automation/automation_provider_observers.cc',
        'browser/automation/automation_provider_observers.h',
        'browser/automation/automation_provider_observers_chromeos.cc',
        'browser/automation/automation_provider_win.cc',
        'browser/automation/automation_resource_message_filter.cc',
        'browser/automation/automation_resource_message_filter.h',
        'browser/automation/automation_resource_tracker.cc',
        'browser/automation/automation_resource_tracker.h',
        'browser/automation/automation_tab_helper.cc',
        'browser/automation/automation_tab_helper.h',
        'browser/automation/automation_tab_tracker.cc',
        'browser/automation/automation_tab_tracker.h',
        'browser/automation/automation_util.cc',
        'browser/automation/automation_util.h',
        'browser/automation/automation_window_tracker.cc',
        'browser/automation/automation_window_tracker.h',
        'browser/automation/chrome_frame_automation_provider.cc',
        'browser/automation/chrome_frame_automation_provider.h',
        'browser/automation/testing_automation_provider.cc',
        'browser/automation/testing_automation_provider.h',
        'browser/automation/testing_automation_provider_chromeos.cc',
        'browser/automation/testing_automation_provider_gtk.cc',
        'browser/automation/testing_automation_provider_mac.mm',
        'browser/automation/testing_automation_provider_views.cc',
        'browser/automation/testing_automation_provider_win.cc',
        'browser/automation/ui_controls.h',
        'browser/automation/ui_controls_internal.cc',
        'browser/automation/ui_controls_internal.h',
        'browser/automation/ui_controls_linux.cc',
        'browser/automation/ui_controls_mac.mm',
        'browser/automation/ui_controls_win.cc',
        'browser/automation/url_request_automation_job.cc',
        'browser/automation/url_request_automation_job.h',
        'browser/background_application_list_model.cc',
        'browser/background_application_list_model.h',
        'browser/background_contents_service.cc',
        'browser/background_contents_service.h',
        'browser/background_contents_service_factory.cc',
        'browser/background_contents_service_factory.h',
        'browser/background_mode_manager.cc',
        'browser/background_mode_manager.h',
        'browser/background_mode_manager_chromeos.cc',
        'browser/background_mode_manager_linux.cc',
        'browser/background_mode_manager_mac.mm',
        'browser/background_mode_manager_win.cc',
        'browser/bookmarks/base_bookmark_model_observer.cc',
        'browser/bookmarks/base_bookmark_model_observer.h',
        'browser/bookmarks/bookmark_codec.cc',
        'browser/bookmarks/bookmark_codec.h',
        'browser/bookmarks/bookmark_context_menu_controller.cc',
        'browser/bookmarks/bookmark_context_menu_controller.h',
        'browser/bookmarks/bookmark_drop_info.cc',
        'browser/bookmarks/bookmark_drop_info.h',
        'browser/bookmarks/bookmark_editor.cc',
        'browser/bookmarks/bookmark_editor.h',
        'browser/bookmarks/bookmark_folder_editor_controller.cc',
        'browser/bookmarks/bookmark_folder_editor_controller.h',
        'browser/bookmarks/bookmark_html_writer.cc',
        'browser/bookmarks/bookmark_html_writer.h',
        'browser/bookmarks/bookmark_index.cc',
        'browser/bookmarks/bookmark_index.h',
        'browser/bookmarks/bookmark_model.cc',
        'browser/bookmarks/bookmark_model.h',
        'browser/bookmarks/bookmark_model_observer.h',
        'browser/bookmarks/bookmark_node_data.cc',
        'browser/bookmarks/bookmark_node_data.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.h',
        'browser/bookmarks/bookmark_pasteboard_helper_mac.mm',
        'browser/bookmarks/bookmark_service.h',
        'browser/bookmarks/bookmark_storage.cc',
        'browser/bookmarks/bookmark_storage.h',
        'browser/bookmarks/bookmark_utils.cc',
        'browser/bookmarks/bookmark_utils.h',
        'browser/bookmarks/recently_used_folders_combo_model.cc',
        'browser/bookmarks/recently_used_folders_combo_model.h',
        'browser/browser_about_handler.cc',
        'browser/browser_about_handler.h',
        'browser/browser_main.cc',
        'browser/browser_main_gtk.cc',
        'browser/browser_main_gtk.h',
        'browser/browser_main_mac.mm',
        'browser/browser_main_posix.cc',
        'browser/browser_main_posix.h',
        'browser/browser_main_win.cc',
        'browser/browser_main_win.h',
        'browser/browser_process.cc',
        'browser/browser_process.h',
        'browser/browser_process_impl.cc',
        'browser/browser_process_impl.h',
        'browser/browser_process_sub_thread.cc',
        'browser/browser_process_sub_thread.h',
        'browser/browser_shutdown.cc',
        'browser/browser_shutdown.h',
        'browser/browser_signin.cc',
        'browser/browser_signin.h',
        'browser/browser_trial.cc',
        'browser/browser_trial.h',
        'browser/browser_url_handler.cc',
        'browser/browser_url_handler.h',
        'browser/browser_util_win.cc',
        'browser/browser_util_win.h',
        'browser/browsing_data_appcache_helper.cc',
        'browser/browsing_data_appcache_helper.h',
        'browser/browsing_data_database_helper.cc',
        'browser/browsing_data_database_helper.h',
        'browser/browsing_data_file_system_helper.cc',
        'browser/browsing_data_file_system_helper.h',
        'browser/browsing_data_indexed_db_helper.cc',
        'browser/browsing_data_indexed_db_helper.h',
        'browser/browsing_data_local_storage_helper.cc',
        'browser/browsing_data_local_storage_helper.h',
        'browser/browsing_data_remover.cc',
        'browser/browsing_data_remover.h',
        'browser/bug_report_data.cc',
        'browser/bug_report_data.h',
        'browser/bug_report_util.cc',
        'browser/bug_report_util.h',
        'browser/certificate_manager_model.cc',
        'browser/certificate_manager_model.h',
        'browser/certificate_viewer.cc',
        'browser/certificate_viewer.h',
        # TODO(rkc): Find a better way to include these files
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/annotations.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/chrome.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/common.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/dom.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/extension.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/math.pb.cc',
        '<(protoc_out_dir)/chrome/browser/userfeedback/proto/web.pb.cc',
        'browser/character_encoding.cc',
        'browser/character_encoding.h',
        'browser/chrome_browser_application_mac.h',
        'browser/chrome_browser_application_mac.mm',
        'browser/chrome_content_browser_client.cc',
        'browser/chrome_content_browser_client.h',
        'browser/chrome_plugin_message_filter.cc',
        'browser/chrome_plugin_message_filter.h',
        'browser/chrome_quota_permission_context.cc',
        'browser/chrome_quota_permission_context.h',
        'browser/chrome_worker_message_filter.cc',
        'browser/chrome_worker_message_filter.h',
        'browser/chromeos/audio_handler.cc',
        'browser/chromeos/audio_handler.h',
        'browser/chromeos/audio_mixer.h',
        'browser/chromeos/audio_mixer_alsa.cc',
        'browser/chromeos/audio_mixer_alsa.h',
        'browser/chromeos/boot_times_loader.cc',
        'browser/chromeos/boot_times_loader.h',
        'browser/chromeos/brightness_bubble.cc',
        'browser/chromeos/brightness_bubble.h',
        'browser/chromeos/brightness_observer.cc',
        'browser/chromeos/brightness_observer.h',
        'browser/chromeos/browser_main_chromeos.cc',
        'browser/chromeos/browser_main_chromeos.h',
        'browser/chromeos/choose_mobile_network_dialog.cc',
        'browser/chromeos/choose_mobile_network_dialog.h',
        'browser/chromeos/cros/brightness_library.cc',
        'browser/chromeos/cros/brightness_library.h',
        'browser/chromeos/cros/burn_library.cc',
        'browser/chromeos/cros/burn_library.h',
        'browser/chromeos/cros/cros_library.cc',
        'browser/chromeos/cros/cros_library.h',
        'browser/chromeos/cros/cros_library_loader.cc',
        'browser/chromeos/cros/cros_library_loader.h',
        'browser/chromeos/cros/cryptohome_library.cc',
        'browser/chromeos/cros/cryptohome_library.h',
        'browser/chromeos/cros/input_method_library.cc',
        'browser/chromeos/cros/input_method_library.h',
        'browser/chromeos/cros/libcros_service_library.cc',
        'browser/chromeos/cros/libcros_service_library.h',
        'browser/chromeos/cros/login_library.cc',
        'browser/chromeos/cros/login_library.h',
        'browser/chromeos/cros/mount_library.cc',
        'browser/chromeos/cros/mount_library.h',
        'browser/chromeos/cros/network_library.cc',
        'browser/chromeos/cros/network_library.h',
        'browser/chromeos/cros/power_library.cc',
        'browser/chromeos/cros/power_library.h',
        'browser/chromeos/cros/screen_lock_library.cc',
        'browser/chromeos/cros/screen_lock_library.h',
        'browser/chromeos/cros/speech_synthesis_library.cc',
        'browser/chromeos/cros/speech_synthesis_library.h',
        'browser/chromeos/cros/syslogs_library.cc',
        'browser/chromeos/cros/syslogs_library.h',
        'browser/chromeos/cros/touchpad_library.cc',
        'browser/chromeos/cros/touchpad_library.h',
        'browser/chromeos/cros/update_library.cc',
        'browser/chromeos/cros/update_library.h',
        'browser/chromeos/cros_settings.cc',
        'browser/chromeos/cros_settings.h',
        'browser/chromeos/cros_settings_names.cc',
        'browser/chromeos/cros_settings_names.h',
        'browser/chromeos/cros_settings_provider.cc',
        'browser/chromeos/cros_settings_provider.h',
        'browser/chromeos/customization_document.cc',
        'browser/chromeos/customization_document.h',
        'browser/chromeos/drop_shadow_label.cc',
        'browser/chromeos/enterprise_extension_observer.cc',
        'browser/chromeos/enterprise_extension_observer.h',
        'browser/chromeos/extensions/file_browser_event_router.cc',
        'browser/chromeos/extensions/file_browser_event_router.h',
        'browser/chromeos/extensions/media_player_event_router.cc',
        'browser/chromeos/extensions/media_player_event_router.h',
        'browser/chromeos/external_metrics.cc',
        'browser/chromeos/external_metrics.h',
        'browser/chromeos/external_protocol_dialog.cc',
        'browser/chromeos/external_protocol_dialog.h',
        'browser/chromeos/frame/browser_frame_view_chromeos.cc',
        'browser/chromeos/frame/browser_frame_view_chromeos.h',
        'browser/chromeos/frame/browser_non_client_frame_view_factory_chromeos.cc',
        'browser/chromeos/frame/browser_view.cc',
        'browser/chromeos/frame/browser_view.h',
        'browser/chromeos/frame/bubble_frame_view.cc',
        'browser/chromeos/frame/bubble_frame_view.h',
        'browser/chromeos/frame/bubble_window.cc',
        'browser/chromeos/frame/bubble_window.h',
        'browser/chromeos/frame/panel_browser_view.cc',
        'browser/chromeos/frame/panel_browser_view.h',
        'browser/chromeos/frame/panel_controller.cc',
        'browser/chromeos/frame/panel_controller.h',
        'browser/chromeos/google_update_chromeos.cc',
        'browser/chromeos/gview_request_interceptor.cc',
        'browser/chromeos/gview_request_interceptor.h',
        'browser/chromeos/input_method/candidate_window.cc',
        'browser/chromeos/input_method/candidate_window.h',
        'browser/chromeos/input_method/input_method_util.cc',
        'browser/chromeos/input_method/input_method_util.h',
        'browser/chromeos/input_method/xkeyboard.cc',
        'browser/chromeos/input_method/xkeyboard.h',
        'browser/chromeos/language_preferences.cc',
        'browser/chromeos/language_preferences.h',
        'browser/chromeos/locale_change_guard.cc',
        'browser/chromeos/locale_change_guard.h',
        'browser/chromeos/login/auth_attempt_state.cc',
        'browser/chromeos/login/auth_attempt_state.h',
        'browser/chromeos/login/auth_attempt_state_resolver.cc',
        'browser/chromeos/login/auth_attempt_state_resolver.h',
        'browser/chromeos/login/auth_response_handler.cc',
        'browser/chromeos/login/auth_response_handler.h',
        'browser/chromeos/login/authentication_notification_details.h',
        'browser/chromeos/login/authenticator.cc',
        'browser/chromeos/login/authenticator.h',
        'browser/chromeos/login/background_view.cc',
        'browser/chromeos/login/background_view.h',
        'browser/chromeos/login/base_login_display_host.cc',
        'browser/chromeos/login/base_login_display_host.h',
        'browser/chromeos/login/base_login_display_host.h',
        'browser/chromeos/login/camera.cc',
        'browser/chromeos/login/camera.h',
        'browser/chromeos/login/camera_controller.cc',
        'browser/chromeos/login/camera_controller.h',
        'browser/chromeos/login/captcha_view.cc',
        'browser/chromeos/login/captcha_view.h',
        'browser/chromeos/login/client_login_response_handler.cc',
        'browser/chromeos/login/client_login_response_handler.h',
        'browser/chromeos/login/cookie_fetcher.cc',
        'browser/chromeos/login/cookie_fetcher.h',
        'browser/chromeos/login/cryptohome_op.cc',
        'browser/chromeos/login/cryptohome_op.h',
        'browser/chromeos/login/default_images_view.cc',
        'browser/chromeos/login/default_images_view.h',
        'browser/chromeos/login/default_user_images.cc',
        'browser/chromeos/login/default_user_images.h',
        'browser/chromeos/login/dom_login_display.cc',
        'browser/chromeos/login/dom_login_display.h',
        'browser/chromeos/login/dom_login_display_host.cc',
        'browser/chromeos/login/dom_login_display_host.h',
        'browser/chromeos/login/enterprise_enrollment_screen.cc',
        'browser/chromeos/login/enterprise_enrollment_screen.h',
        'browser/chromeos/login/enterprise_enrollment_view.cc',
        'browser/chromeos/login/enterprise_enrollment_view.h',
        'browser/chromeos/login/eula_screen.cc',
        'browser/chromeos/login/eula_screen.h',
        'browser/chromeos/login/eula_screen_actor.h',
        'browser/chromeos/login/eula_view.cc',
        'browser/chromeos/login/eula_view.h',
        'browser/chromeos/login/existing_user_controller.cc',
        'browser/chromeos/login/existing_user_controller.h',
        'browser/chromeos/login/existing_user_view.cc',
        'browser/chromeos/login/existing_user_view.h',
        'browser/chromeos/login/google_authenticator.cc',
        'browser/chromeos/login/google_authenticator.h',
        'browser/chromeos/login/guest_user_view.cc',
        'browser/chromeos/login/guest_user_view.h',
        'browser/chromeos/login/help_app_launcher.cc',
        'browser/chromeos/login/help_app_launcher.h',
        'browser/chromeos/login/helper.cc',
        'browser/chromeos/login/helper.h',
        'browser/chromeos/login/html_page_screen.cc',
        'browser/chromeos/login/html_page_screen.h',
        'browser/chromeos/login/image_decoder.cc',
        'browser/chromeos/login/image_decoder.h',
        'browser/chromeos/login/image_downloader.cc',
        'browser/chromeos/login/image_downloader.h',
        'browser/chromeos/login/issue_response_handler.cc',
        'browser/chromeos/login/issue_response_handler.h',
        'browser/chromeos/login/keyboard_switch_menu.cc',
        'browser/chromeos/login/keyboard_switch_menu.h',
        'browser/chromeos/login/language_switch_menu.cc',
        'browser/chromeos/login/language_switch_menu.h',
        'browser/chromeos/login/login_display.cc',
        'browser/chromeos/login/login_display.h',
        'browser/chromeos/login/login_display_host.h',
        'browser/chromeos/login/login_html_dialog.cc',
        'browser/chromeos/login/login_html_dialog.h',
        'browser/chromeos/login/login_performer.cc',
        'browser/chromeos/login/login_performer.h',
        'browser/chromeos/login/login_status_consumer.cc',
        'browser/chromeos/login/login_status_consumer.h',
        'browser/chromeos/login/login_utils.cc',
        'browser/chromeos/login/login_utils.h',
        'browser/chromeos/login/message_bubble.cc',
        'browser/chromeos/login/message_bubble.h',
        'browser/chromeos/login/network_screen.cc',
        'browser/chromeos/login/network_screen.h',
        'browser/chromeos/login/network_screen_actor.h',
        'browser/chromeos/login/network_selection_view.cc',
        'browser/chromeos/login/network_selection_view.h',
        'browser/chromeos/login/new_user_view.cc',
        'browser/chromeos/login/new_user_view.h',
        'browser/chromeos/login/online_attempt.cc',
        'browser/chromeos/login/online_attempt.h',
        'browser/chromeos/login/oobe_display.h',
        'browser/chromeos/login/oobe_progress_bar.cc',
        'browser/chromeos/login/oobe_progress_bar.h',
        'browser/chromeos/login/owner_key_utils.cc',
        'browser/chromeos/login/owner_key_utils.h',
        'browser/chromeos/login/owner_manager.cc',
        'browser/chromeos/login/owner_manager.h',
        'browser/chromeos/login/ownership_service.cc',
        'browser/chromeos/login/ownership_service.h',
        'browser/chromeos/login/ownership_status_checker.cc',
        'browser/chromeos/login/ownership_status_checker.h',
        'browser/chromeos/login/parallel_authenticator.cc',
        'browser/chromeos/login/parallel_authenticator.h',
        'browser/chromeos/login/password_changed_view.cc',
        'browser/chromeos/login/password_changed_view.h',
        'browser/chromeos/login/proxy_settings_dialog.cc',
        'browser/chromeos/login/proxy_settings_dialog.h',
        'browser/chromeos/login/registration_screen.cc',
        'browser/chromeos/login/registration_screen.h',
        'browser/chromeos/login/rounded_rect_painter.cc',
        'browser/chromeos/login/rounded_rect_painter.h',
        'browser/chromeos/login/screen_lock_view.cc',
        'browser/chromeos/login/screen_lock_view.h',
        'browser/chromeos/login/screen_locker.cc',
        'browser/chromeos/login/screen_locker.h',
        'browser/chromeos/login/screen_observer.h',
        'browser/chromeos/login/shutdown_button.cc',
        'browser/chromeos/login/shutdown_button.h',
        'browser/chromeos/login/signed_settings.cc',
        'browser/chromeos/login/signed_settings.h',
        'browser/chromeos/login/signed_settings_helper.cc',
        'browser/chromeos/login/signed_settings_helper.h',
        'browser/chromeos/login/signed_settings_temp_storage.cc',
        'browser/chromeos/login/signed_settings_temp_storage.h',
        'browser/chromeos/login/take_photo_view.cc',
        'browser/chromeos/login/take_photo_view.h',
        'browser/chromeos/login/test_attempt_state.cc',
        'browser/chromeos/login/test_attempt_state.h',
        'browser/chromeos/login/textfield_with_margin.cc',
        'browser/chromeos/login/textfield_with_margin.h',
        'browser/chromeos/login/update_screen.cc',
        'browser/chromeos/login/update_screen.h',
        'browser/chromeos/login/update_screen_actor.h',
        'browser/chromeos/login/update_view.cc',
        'browser/chromeos/login/update_view.h',
        'browser/chromeos/login/user_controller.cc',
        'browser/chromeos/login/user_controller.h',
        'browser/chromeos/login/user_controller_gtk.cc',
        'browser/chromeos/login/user_image_loader.cc',
        'browser/chromeos/login/user_image_loader.h',
        'browser/chromeos/login/user_image_screen.cc',
        'browser/chromeos/login/user_image_screen.h',
        'browser/chromeos/login/user_image_view.cc',
        'browser/chromeos/login/user_image_view.h',
        'browser/chromeos/login/user_manager.cc',
        'browser/chromeos/login/user_manager.h',
        'browser/chromeos/login/user_view.cc',
        'browser/chromeos/login/user_view.h',
        'browser/chromeos/login/username_view.cc',
        'browser/chromeos/login/username_view.h',
        'browser/chromeos/login/view_screen.h',
        'browser/chromeos/login/views_eula_screen_actor.cc',
        'browser/chromeos/login/views_eula_screen_actor.h',
        'browser/chromeos/login/views_login_display.cc',
        'browser/chromeos/login/views_login_display.h',
        'browser/chromeos/login/views_login_display_host.cc',
        'browser/chromeos/login/views_login_display_host.h',
        'browser/chromeos/login/views_network_screen_actor.cc',
        'browser/chromeos/login/views_network_screen_actor.h',
        'browser/chromeos/login/views_oobe_display.cc',
        'browser/chromeos/login/views_oobe_display.h',
        'browser/chromeos/login/views_update_screen_actor.cc',
        'browser/chromeos/login/views_update_screen_actor.h',
        'browser/chromeos/login/web_page_screen.cc',
        'browser/chromeos/login/web_page_screen.h',
        'browser/chromeos/login/web_page_view.cc',
        'browser/chromeos/login/web_page_view.h',
        'browser/chromeos/login/webui_login_view.h',
        'browser/chromeos/login/webui_login_view.cc',
        'browser/chromeos/login/wizard_accessibility_handler.cc',
        'browser/chromeos/login/wizard_accessibility_handler.h',
        'browser/chromeos/login/wizard_accessibility_helper.cc',
        'browser/chromeos/login/wizard_accessibility_helper.h',
        'browser/chromeos/login/wizard_controller.cc',
        'browser/chromeos/login/wizard_controller.h',
        'browser/chromeos/login/wizard_screen.cc',
        'browser/chromeos/login/wizard_screen.h',
        'browser/chromeos/low_battery_observer.cc',
        'browser/chromeos/low_battery_observer.h',
        'browser/chromeos/media/media_player.cc',
        'browser/chromeos/media/media_player.h',
        'browser/chromeos/metrics_cros_settings_provider.cc',
        'browser/chromeos/metrics_cros_settings_provider.h',
        'browser/chromeos/name_value_pairs_parser.cc',
        'browser/chromeos/name_value_pairs_parser.h',
        'browser/chromeos/native_dialog_window.cc',
        'browser/chromeos/native_dialog_window.h',
        'browser/chromeos/net/network_change_notifier_chromeos.cc',
        'browser/chromeos/net/network_change_notifier_chromeos.h',
        'browser/chromeos/network_login_observer.cc',
        'browser/chromeos/network_login_observer.h',
        'browser/chromeos/network_message_observer.cc',
        'browser/chromeos/network_message_observer.h',
        'browser/chromeos/network_state_notifier.cc',
        'browser/chromeos/network_state_notifier.h',
        'browser/chromeos/notifications/balloon_collection_impl.cc',
        'browser/chromeos/notifications/balloon_collection_impl.h',
        'browser/chromeos/notifications/balloon_view.cc',
        'browser/chromeos/notifications/balloon_view.h',
        'browser/chromeos/notifications/balloon_view_host.cc',
        'browser/chromeos/notifications/balloon_view_host.h',
        'browser/chromeos/notifications/notification_panel.cc',
        'browser/chromeos/notifications/notification_panel.h',
        'browser/chromeos/notifications/system_notification.cc',
        'browser/chromeos/notifications/system_notification.h',
        'browser/chromeos/notifications/system_notification_factory.cc',
        'browser/chromeos/notifications/system_notification_factory.h',
        'browser/chromeos/offline/offline_load_page.cc',
        'browser/chromeos/offline/offline_load_page.h',
        'browser/chromeos/options/network_config_view.cc',
        'browser/chromeos/options/network_config_view.h',
        'browser/chromeos/options/take_photo_dialog.cc',
        'browser/chromeos/options/take_photo_dialog.h',
        'browser/chromeos/options/wifi_config_model.cc',
        'browser/chromeos/options/wifi_config_model.h',
        'browser/chromeos/options/wifi_config_view.cc',
        'browser/chromeos/options/wifi_config_view.h',
        'browser/chromeos/options/vpn_config_view.cc',
        'browser/chromeos/options/vpn_config_view.h',
        'browser/chromeos/panels/panel_scroller.cc',
        'browser/chromeos/panels/panel_scroller.h',
        'browser/chromeos/panels/panel_scroller_container.cc',
        'browser/chromeos/panels/panel_scroller_container.h',
        'browser/chromeos/panels/panel_scroller_header.cc',
        'browser/chromeos/panels/panel_scroller_header.h',
        'browser/chromeos/preferences.cc',
        'browser/chromeos/preferences.h',
        'browser/chromeos/proxy_config_service.cc',
        'browser/chromeos/proxy_config_service.h',
        'browser/chromeos/proxy_config_service_impl.cc',
        'browser/chromeos/proxy_config_service_impl.h',
        'browser/chromeos/proxy_cros_settings_provider.cc',
        'browser/chromeos/proxy_cros_settings_provider.h',
        'browser/chromeos/setting_level_bubble.cc',
        'browser/chromeos/setting_level_bubble.h',
        'browser/chromeos/setting_level_bubble_view.cc',
        'browser/chromeos/setting_level_bubble_view.h',
        'browser/chromeos/sim_dialog_delegate.cc',
        'browser/chromeos/sim_dialog_delegate.h',
        'browser/chromeos/sms_observer.cc',
        'browser/chromeos/sms_observer.h',
        'browser/chromeos/status/clock_menu_button.cc',
        'browser/chromeos/status/clock_menu_button.h',
        'browser/chromeos/status/input_method_menu.cc',
        'browser/chromeos/status/input_method_menu.h',
        'browser/chromeos/status/input_method_menu_button.cc',
        'browser/chromeos/status/input_method_menu_button.h',
        'browser/chromeos/status/network_dropdown_button.cc',
        'browser/chromeos/status/network_dropdown_button.h',
        'browser/chromeos/status/network_menu.cc',
        'browser/chromeos/status/network_menu.h',
        'browser/chromeos/status/network_menu_button.cc',
        'browser/chromeos/status/network_menu_button.h',
        'browser/chromeos/status/power_menu_button.cc',
        'browser/chromeos/status/power_menu_button.h',
        'browser/chromeos/status/status_area_button.cc',
        'browser/chromeos/status/status_area_button.h',
        'browser/chromeos/status/status_area_host.h',
        'browser/chromeos/status/status_area_view.cc',
        'browser/chromeos/status/status_area_view.h',
        'browser/chromeos/status/window_switcher_button.cc',
        'browser/chromeos/status/window_switcher_button.h',
        'browser/chromeos/system_access.cc',
        'browser/chromeos/system_access.h',
        'browser/chromeos/system_key_event_listener.cc',
        'browser/chromeos/system_key_event_listener.h',
        'browser/chromeos/tab_closeable_state_watcher.cc',
        'browser/chromeos/tab_closeable_state_watcher.h',
        'browser/chromeos/update_observer.cc',
        'browser/chromeos/update_observer.h',
        'browser/chromeos/upgrade_detector_chromeos.cc',
        'browser/chromeos/upgrade_detector_chromeos.h',
        'browser/chromeos/user_cros_settings_provider.cc',
        'browser/chromeos/user_cros_settings_provider.h',
        'browser/chromeos/version_loader.cc',
        'browser/chromeos/version_loader.h',
        'browser/chromeos/view_ids.h',
        'browser/chromeos/views/copy_background.cc',
        'browser/chromeos/views/copy_background.h',
        'browser/chromeos/views/dropdown_button.cc',
        'browser/chromeos/views/dropdown_button.h',
        'browser/chromeos/volume_bubble.cc',
        'browser/chromeos/volume_bubble.h',
        'browser/chromeos/web_socket_proxy_controller.cc',
        'browser/chromeos/web_socket_proxy_controller.h',
        'browser/chromeos/web_socket_proxy.cc',
        'browser/chromeos/web_socket_proxy.h',
        'browser/chromeos/wm_ipc.cc',
        'browser/chromeos/wm_ipc.h',
        'browser/chromeos/wm_message_listener.cc',
        'browser/chromeos/wm_message_listener.h',
        'browser/chromeos/xinput_hierarchy_changed_event_listener.cc',
        'browser/chromeos/xinput_hierarchy_changed_event_listener.h',
        'browser/cocoa/authorization_util.h',
        'browser/cocoa/authorization_util.mm',
        'browser/cocoa/file_metadata.h',
        'browser/cocoa/file_metadata.mm',
        'browser/cocoa/install_from_dmg.h',
        'browser/cocoa/install_from_dmg.mm',
        'browser/cocoa/keystone_glue.h',
        'browser/cocoa/keystone_glue.mm',
        'browser/cocoa/scoped_authorizationref.h',
        'browser/command_updater.cc',
        'browser/command_updater.h',
        'browser/content_settings/content_settings_base_provider.cc',
        'browser/content_settings/content_settings_base_provider.h',
        'browser/content_settings/content_settings_details.h',
        'browser/content_settings/content_settings_extension_provider.cc',
        'browser/content_settings/content_settings_extension_provider.h',
        'browser/content_settings/content_settings_notification_provider.cc',
        'browser/content_settings/content_settings_notification_provider.h',
        'browser/content_settings/content_settings_pattern.cc',
        'browser/content_settings/content_settings_pattern.h',
        'browser/content_settings/content_settings_pattern_parser.cc',
        'browser/content_settings/content_settings_pattern_parser.h',
        'browser/content_settings/content_settings_policy_provider.cc',
        'browser/content_settings/content_settings_policy_provider.h',
        'browser/content_settings/content_settings_pref_provider.cc',
        'browser/content_settings/content_settings_pref_provider.h',
        'browser/content_settings/content_settings_provider.cc',
        'browser/content_settings/content_settings_provider.h',
        'browser/content_settings/content_settings_utils.h',
        'browser/content_settings/content_settings_utils.cc',
        'browser/content_settings/host_content_settings_map.cc',
        'browser/content_settings/host_content_settings_map.h',
        'browser/content_settings/tab_specific_content_settings.cc',
        'browser/content_settings/tab_specific_content_settings.h',
        'browser/cookies_tree_model.cc',
        'browser/cookies_tree_model.h',
        'browser/crash_upload_list.cc',
        'browser/crash_upload_list.h',
        'browser/crash_upload_list_win.cc',
        'browser/crash_upload_list_win.h',
        'browser/custom_home_pages_table_model.cc',
        'browser/custom_home_pages_table_model.h',
        'browser/custom_handlers/protocol_handler.cc',
        'browser/custom_handlers/protocol_handler.h',
        'browser/custom_handlers/protocol_handler_registry.cc',
        'browser/custom_handlers/protocol_handler_registry.h',
        'browser/custom_handlers/register_protocol_handler_infobar_delegate.cc',
        'browser/custom_handlers/register_protocol_handler_infobar_delegate.h',
        'browser/default_encoding_combo_model.cc',
        'browser/default_encoding_combo_model.h',
        'browser/defaults.cc',
        'browser/defaults.h',
        'browser/desktop_notification_handler.cc',
        'browser/desktop_notification_handler.h',
        'browser/diagnostics/diagnostics_main.cc',
        'browser/diagnostics/diagnostics_main.h',
        'browser/diagnostics/diagnostics_model.cc',
        'browser/diagnostics/diagnostics_model.h',
        'browser/diagnostics/diagnostics_test.cc',
        'browser/diagnostics/diagnostics_test.h',
        'browser/diagnostics/recon_diagnostics.cc',
        'browser/diagnostics/recon_diagnostics.h',
        'browser/diagnostics/sqlite_diagnostics.cc',
        'browser/diagnostics/sqlite_diagnostics.h',
        'browser/dom_operation_notification_details.h',
        'browser/download/base_file.cc',
        'browser/download/base_file.h',
        'browser/download/download_create_info.cc',
        'browser/download/download_create_info.h',
        'browser/download/download_extensions.cc',
        'browser/download/download_extensions.h',
        'browser/download/download_file.cc',
        'browser/download/download_file.h',
        'browser/download/download_file_manager.cc',
        'browser/download/download_file_manager.h',
        'browser/download/download_history.cc',
        'browser/download/download_history.h',
        'browser/download/download_item.cc',
        'browser/download/download_item.h',
        'browser/download/download_item_model.cc',
        'browser/download/download_item_model.h',
        'browser/download/download_manager.cc',
        'browser/download/download_manager.h',
        'browser/download/download_prefs.cc',
        'browser/download/download_prefs.h',
        'browser/download/download_process_handle.cc',
        'browser/download/download_process_handle.h',
        'browser/download/download_request_infobar_delegate.cc',
        'browser/download/download_request_infobar_delegate.h',
        'browser/download/download_request_limiter.cc',
        'browser/download/download_request_limiter.h',
        'browser/download/download_safe_browsing_client.cc',
        'browser/download/download_safe_browsing_client.h',
        'browser/download/download_shelf.h',
        'browser/download/download_shelf_context_menu.cc',
        'browser/download/download_shelf_context_menu.h',
        'browser/download/download_started_animation.h',
        'browser/download/download_state_info.cc',
        'browser/download/download_state_info.h',
        'browser/download/download_status_updater.cc',
        'browser/download/download_status_updater.h',
        'browser/download/download_status_updater_delegate.h',
        'browser/download/download_types.cc',
        'browser/download/download_types.h',
        'browser/download/download_util.cc',
        'browser/download/download_util.h',
        'browser/download/drag_download_file.cc',
        'browser/download/drag_download_file.h',
        'browser/download/drag_download_util.cc',
        'browser/download/drag_download_util.h',
        'browser/download/save_file.cc',
        'browser/download/save_file.h',
        'browser/download/save_file_manager.cc',
        'browser/download/save_file_manager.h',
        'browser/download/save_item.cc',
        'browser/download/save_item.h',
        'browser/download/save_package.cc',
        'browser/download/save_package.h',
        'browser/download/save_types.cc',
        'browser/download/save_types.h',
        'browser/enumerate_modules_model_win.cc',
        'browser/enumerate_modules_model_win.h',
        'browser/extensions/apps_promo.cc',
        'browser/extensions/apps_promo.h',
        'browser/extensions/convert_user_script.cc',
        'browser/extensions/convert_user_script.h',
        'browser/extensions/convert_web_app.cc',
        'browser/extensions/convert_web_app.h',
        'browser/extensions/crx_installer.cc',
        'browser/extensions/crx_installer.h',
        'browser/extensions/execute_code_in_tab_function.cc',
        'browser/extensions/execute_code_in_tab_function.h',
        'browser/extensions/extension_accessibility_api.cc',
        'browser/extensions/extension_accessibility_api.h',
        'browser/extensions/extension_accessibility_api_constants.cc',
        'browser/extensions/extension_accessibility_api_constants.h',
        'browser/extensions/extension_bookmark_helpers.cc',
        'browser/extensions/extension_bookmark_helpers.h',
        'browser/extensions/extension_bookmark_manager_api.cc',
        'browser/extensions/extension_bookmark_manager_api.h',
        'browser/extensions/extension_bookmarks_module.cc',
        'browser/extensions/extension_bookmarks_module.h',
        'browser/extensions/extension_bookmarks_module_constants.cc',
        'browser/extensions/extension_bookmarks_module_constants.h',
        'browser/extensions/extension_browser_actions_api.cc',
        'browser/extensions/extension_browser_actions_api.h',
        'browser/extensions/extension_browser_event_router.cc',
        'browser/extensions/extension_browser_event_router.h',
        'browser/extensions/extension_content_settings_api_constants.cc',
        'browser/extensions/extension_content_settings_api_constants.h',
        'browser/extensions/extension_content_settings_helpers.cc',
        'browser/extensions/extension_content_settings_helpers.h',
        'browser/extensions/extension_content_settings_store.cc',
        'browser/extensions/extension_content_settings_store.h',
        'browser/extensions/extension_context_menu_api.cc',
        'browser/extensions/extension_context_menu_api.h',
        'browser/extensions/extension_context_menu_model.cc',
        'browser/extensions/extension_context_menu_model.h',
        'browser/extensions/extension_cookies_api.cc',
        'browser/extensions/extension_cookies_api.h',
        'browser/extensions/extension_cookies_api_constants.cc',
        'browser/extensions/extension_cookies_api_constants.h',
        'browser/extensions/extension_cookies_helpers.cc',
        'browser/extensions/extension_cookies_helpers.h',
        'browser/extensions/extension_creator.cc',
        'browser/extensions/extension_creator.h',
        'browser/extensions/extension_data_deleter.cc',
        'browser/extensions/extension_data_deleter.h',
        'browser/extensions/extension_debugger_api.cc',
        'browser/extensions/extension_debugger_api.h',
        'browser/extensions/extension_debugger_api_constants.cc',
        'browser/extensions/extension_debugger_api_constants.h',
        'browser/extensions/extension_devtools_bridge.cc',
        'browser/extensions/extension_devtools_bridge.h',
        'browser/extensions/extension_devtools_events.cc',
        'browser/extensions/extension_devtools_events.h',
        'browser/extensions/extension_devtools_manager.cc',
        'browser/extensions/extension_devtools_manager.h',
        'browser/extensions/extension_disabled_infobar_delegate.cc',
        'browser/extensions/extension_disabled_infobar_delegate.h',
        'browser/extensions/extension_error_reporter.cc',
        'browser/extensions/extension_error_reporter.h',
        'browser/extensions/extension_event_names.cc',
        'browser/extensions/extension_event_names.h',
        'browser/extensions/extension_event_router.cc',
        'browser/extensions/extension_event_router.h',
        'browser/extensions/extension_event_router_forwarder.cc',
        'browser/extensions/extension_event_router_forwarder.h',
        'browser/extensions/extension_file_browser_private_api.cc',
        'browser/extensions/extension_file_browser_private_api.h',
        'browser/extensions/extension_function.cc',
        'browser/extensions/extension_function.h',
        'browser/extensions/extension_function_dispatcher.cc',
        'browser/extensions/extension_function_dispatcher.h',
        'browser/extensions/extension_history_api.cc',
        'browser/extensions/extension_history_api.h',
        'browser/extensions/extension_history_api_constants.cc',
        'browser/extensions/extension_history_api_constants.h',
        'browser/extensions/extension_host.cc',
        'browser/extensions/extension_host.h',
        'browser/extensions/extension_host_mac.h',
        'browser/extensions/extension_host_mac.mm',
        'browser/extensions/extension_i18n_api.cc',
        'browser/extensions/extension_i18n_api.h',
        'browser/extensions/extension_icon_manager.cc',
        'browser/extensions/extension_icon_manager.h',
        'browser/extensions/extension_idle_api.cc',
        'browser/extensions/extension_idle_api.h',
        'browser/extensions/extension_idle_api_constants.cc',
        'browser/extensions/extension_idle_api_constants.h',
        'browser/extensions/extension_info_map.cc',
        'browser/extensions/extension_info_map.h',
        'browser/extensions/extension_info_private_api_chromeos.cc',
        'browser/extensions/extension_info_private_api_chromeos.h',
        'browser/extensions/extension_infobar_delegate.cc',
        'browser/extensions/extension_infobar_delegate.h',
        'browser/extensions/extension_infobar_module.cc',
        'browser/extensions/extension_infobar_module.h',
        'browser/extensions/extension_infobar_module_constants.cc',
        'browser/extensions/extension_infobar_module_constants.h',
        'browser/extensions/extension_input_api.cc',
        'browser/extensions/extension_input_api.h',
        'browser/extensions/extension_input_ui_api.cc',
        'browser/extensions/extension_input_ui_api.h',
        'browser/extensions/extension_install_dialog.h',
        'browser/extensions/extension_install_ui.cc',
        'browser/extensions/extension_install_ui.h',
        'browser/extensions/extension_management_api.cc',
        'browser/extensions/extension_management_api.h',
        'browser/extensions/extension_menu_manager.cc',
        'browser/extensions/extension_menu_manager.h',
        'browser/extensions/extension_mediaplayer_private_api.h',
        'browser/extensions/extension_mediaplayer_private_api.cc',
        'browser/extensions/extension_message_handler.cc',
        'browser/extensions/extension_message_handler.h',
        'browser/extensions/extension_message_service.cc',
        'browser/extensions/extension_message_service.h',
        'browser/extensions/extension_metrics_module.cc',
        'browser/extensions/extension_metrics_module.h',
        'browser/extensions/extension_module.cc',
        'browser/extensions/extension_module.h',
        'browser/extensions/extension_omnibox_api.cc',
        'browser/extensions/extension_omnibox_api.h',
        'browser/extensions/extension_page_actions_module.cc',
        'browser/extensions/extension_page_actions_module.h',
        'browser/extensions/extension_page_actions_module_constants.cc',
        'browser/extensions/extension_page_actions_module_constants.h',
        'browser/extensions/extension_preference_api.cc',
        'browser/extensions/extension_preference_api.h',
        'browser/extensions/extension_pref_store.cc',
        'browser/extensions/extension_pref_store.h',
        'browser/extensions/extension_pref_value_map.cc',
        'browser/extensions/extension_pref_value_map.h',
        'browser/extensions/extension_prefs.cc',
        'browser/extensions/extension_prefs.h',
        'browser/extensions/extension_prefs_scope.h',
        'browser/extensions/extension_process_manager.cc',
        'browser/extensions/extension_process_manager.h',
        'browser/extensions/extension_processes_api.cc',
        'browser/extensions/extension_processes_api.h',
        'browser/extensions/extension_processes_api_constants.cc',
        'browser/extensions/extension_processes_api_constants.h',
        'browser/extensions/extension_protocols.cc',
        'browser/extensions/extension_protocols.h',
        'browser/extensions/extension_proxy_api.cc',
        'browser/extensions/extension_proxy_api.h',
        'browser/extensions/extension_proxy_api_constants.cc',
        'browser/extensions/extension_proxy_api_constants.h',
        'browser/extensions/extension_proxy_api_helpers.cc',
        'browser/extensions/extension_proxy_api_helpers.h',
        'browser/extensions/extension_rlz_module.cc',
        'browser/extensions/extension_rlz_module.h',
        'browser/extensions/extension_service.cc',
        'browser/extensions/extension_service.h',
        'browser/extensions/extension_sidebar_api.cc',
        'browser/extensions/extension_sidebar_api.h',
        'browser/extensions/extension_special_storage_policy.cc',
        'browser/extensions/extension_special_storage_policy.h',
        'browser/extensions/extension_sync_data.cc',
        'browser/extensions/extension_sync_data.h',
        'browser/extensions/extension_tab_id_map.cc',
        'browser/extensions/extension_tab_id_map.h',
        'browser/extensions/extension_tab_helper.cc',
        'browser/extensions/extension_tab_helper.h',
        'browser/extensions/extension_tabs_module.cc',
        'browser/extensions/extension_tabs_module.h',
        'browser/extensions/extension_tabs_module_constants.cc',
        'browser/extensions/extension_tabs_module_constants.h',
        'browser/extensions/extension_test_api.cc',
        'browser/extensions/extension_test_api.h',
        'browser/extensions/extension_toolbar_model.cc',
        'browser/extensions/extension_toolbar_model.h',
        'browser/extensions/extension_tts_api.cc',
        'browser/extensions/extension_tts_api.h',
        'browser/extensions/extension_tts_api_chromeos.cc',
        'browser/extensions/extension_tts_api_linux.cc',
        'browser/extensions/extension_tts_api_mac.mm',
        'browser/extensions/extension_tts_api_util.cc',
        'browser/extensions/extension_tts_api_util.h',
        'browser/extensions/extension_tts_api_win.cc',
        'browser/extensions/extension_uninstall_dialog.cc',
        'browser/extensions/extension_uninstall_dialog.h',
        'browser/extensions/extension_updater.cc',
        'browser/extensions/extension_updater.h',
        'browser/extensions/extension_web_socket_proxy_private_api.cc',
        'browser/extensions/extension_web_socket_proxy_private_api.h',
        'browser/extensions/extension_web_ui.cc',
        'browser/extensions/extension_web_ui.h',
        'browser/extensions/extension_webrequest_api.cc',
        'browser/extensions/extension_webrequest_api.h',
        'browser/extensions/extension_webnavigation_api.cc',
        'browser/extensions/extension_webnavigation_api.h',
        'browser/extensions/extension_webnavigation_api_constants.cc',
        'browser/extensions/extension_webnavigation_api_constants.h',
        'browser/extensions/extension_webrequest_api_constants.cc',
        'browser/extensions/extension_webrequest_api_constants.h',
        'browser/extensions/extension_webstore_private_api.cc',
        'browser/extensions/extension_webstore_private_api.h',
        'browser/extensions/extensions_quota_service.cc',
        'browser/extensions/extensions_quota_service.h',
        'browser/extensions/extensions_startup.cc',
        'browser/extensions/extensions_startup.h',
        'browser/extensions/extensions_ui.cc',
        'browser/extensions/extensions_ui.h',
        'browser/extensions/external_extension_loader.cc',
        'browser/extensions/external_extension_loader.h',
        'browser/extensions/external_extension_provider_impl.cc',
        'browser/extensions/external_extension_provider_impl.h',
        'browser/extensions/external_extension_provider_interface.h',
        'browser/extensions/external_policy_extension_loader.cc',
        'browser/extensions/external_policy_extension_loader.h',
        'browser/extensions/external_pref_extension_loader.cc',
        'browser/extensions/external_pref_extension_loader.h',
        'browser/extensions/external_registry_extension_loader_win.cc',
        'browser/extensions/external_registry_extension_loader_win.h',
        'browser/extensions/file_manager_util.h',
        'browser/extensions/file_manager_util.cc',
        'browser/extensions/file_reader.cc',
        'browser/extensions/file_reader.h',
        'browser/extensions/image_loading_tracker.cc',
        'browser/extensions/image_loading_tracker.h',
        'browser/extensions/key_identifier_conversion_views.cc',
        'browser/extensions/key_identifier_conversion_views.h',
        'browser/extensions/pack_extension_job.cc',
        'browser/extensions/pack_extension_job.h',
        'browser/extensions/pending_extension_info.h',
        'browser/extensions/pending_extension_info.cc',
        'browser/extensions/pending_extension_manager.h',
        'browser/extensions/pending_extension_manager.cc',
        'browser/extensions/sandboxed_extension_unpacker.cc',
        'browser/extensions/sandboxed_extension_unpacker.h',
        'browser/extensions/theme_installed_infobar_delegate.cc',
        'browser/extensions/theme_installed_infobar_delegate.h',
        'browser/extensions/user_script_listener.cc',
        'browser/extensions/user_script_listener.h',
        'browser/extensions/user_script_master.cc',
        'browser/extensions/user_script_master.h',
        'browser/external_protocol/external_protocol_handler.cc',
        'browser/external_protocol/external_protocol_handler.h',
        'browser/external_protocol/external_protocol_observer.cc',
        'browser/external_protocol/external_protocol_observer.h',
        'browser/external_tab_container_win.cc',
        'browser/external_tab_container_win.h',
        'browser/favicon/favicon_handler.cc',
        'browser/favicon/favicon_handler.h',
        'browser/favicon/favicon_service.cc',
        'browser/favicon/favicon_service.h',
        'browser/favicon/favicon_tab_helper.cc',
        'browser/favicon/favicon_tab_helper.h',
        'browser/file_select_helper.cc',
        'browser/file_select_helper.h',
        'browser/first_run/first_run.cc',
        'browser/first_run/first_run.h',
        'browser/first_run/first_run_browser_process.cc',
        'browser/first_run/first_run_browser_process.h',
        'browser/first_run/first_run_dialog.h',
        'browser/first_run/first_run_gtk.cc',
        'browser/first_run/first_run_import_observer.cc',
        'browser/first_run/first_run_import_observer.h',
        'browser/first_run/first_run_mac.mm',
        'browser/first_run/first_run_win.cc',
        'browser/first_run/upgrade_util.cc',
        'browser/first_run/upgrade_util.h',
        'browser/first_run/upgrade_util_linux.cc',
        'browser/first_run/upgrade_util_linux.h',
        'browser/first_run/upgrade_util_win.cc',
        'browser/first_run/upgrade_util_win.h',
        'browser/first_run/try_chrome_dialog_view.cc',
        'browser/first_run/try_chrome_dialog_view.h',
        'browser/fullscreen.h',
        'browser/fullscreen_linux.cc',
        'browser/fullscreen_mac.mm',
        'browser/fullscreen_win.cc',
        'browser/geolocation/access_token_store.cc',
        'browser/geolocation/geolocation_content_settings_map.cc',
        'browser/geolocation/geolocation_content_settings_map.h',
        'browser/geolocation/geolocation_exceptions_table_model.cc',
        'browser/geolocation/geolocation_exceptions_table_model.h',
        'browser/geolocation/geolocation_permission_context.cc',
        'browser/geolocation/geolocation_prefs.cc',
        'browser/geolocation/geolocation_prefs.h',
        'browser/geolocation/geolocation_settings_state.cc',
        'browser/geolocation/geolocation_settings_state.h',
        'browser/geolocation/wifi_data_provider_chromeos.cc',
        'browser/geolocation/wifi_data_provider_chromeos.h',
        'browser/global_keyboard_shortcuts_mac.h',
        'browser/global_keyboard_shortcuts_mac.mm',
        'browser/google/google_update.cc',
        'browser/google/google_update.h',
        'browser/google/google_update_settings_posix.cc',
        'browser/google/google_url_tracker.cc',
        'browser/google/google_url_tracker.h',
        'browser/google/google_util.cc',
        'browser/google/google_util.h',
        'browser/hang_monitor/hung_plugin_action.cc',
        'browser/hang_monitor/hung_plugin_action.h',
        'browser/hang_monitor/hung_window_detector.cc',
        'browser/hang_monitor/hung_window_detector.h',
        'browser/history/archived_database.cc',
        'browser/history/archived_database.h',
        'browser/history/download_database.cc',
        'browser/history/download_database.h',
        'browser/history/download_history_info.cc',
        'browser/history/download_history_info.h',
        'browser/history/expire_history_backend.cc',
        'browser/history/expire_history_backend.h',
        'browser/history/history.cc',
        'browser/history/history.h',
        'browser/history/history_backend.cc',
        'browser/history/history_backend.h',
        'browser/history/history_database.cc',
        'browser/history/history_database.h',
        'browser/history/history_marshaling.h',
        'browser/history/history_notifications.cc',
        'browser/history/history_notifications.h',
        'browser/history/history_publisher.cc',
        'browser/history/history_publisher.h',
        'browser/history/history_publisher_none.cc',
        'browser/history/history_publisher_win.cc',
        'browser/history/history_tab_helper.cc',
        'browser/history/history_tab_helper.h',
        'browser/history/history_types.cc',
        'browser/history/history_types.h',
        'browser/history/in_memory_database.cc',
        'browser/history/in_memory_database.h',
        'browser/history/in_memory_history_backend.cc',
        'browser/history/in_memory_history_backend.h',
        'browser/history/in_memory_url_index.cc',
        'browser/history/in_memory_url_index.h',
        'browser/history/page_usage_data.cc',
        'browser/history/page_usage_data.h',
        'browser/history/query_parser.cc',
        'browser/history/query_parser.h',
        'browser/history/snippet.cc',
        'browser/history/snippet.h',
        'browser/history/starred_url_database.cc',
        'browser/history/starred_url_database.h',
        'browser/history/text_database.cc',
        'browser/history/text_database.h',
        'browser/history/text_database_manager.cc',
        'browser/history/text_database_manager.h',
        'browser/history/thumbnail_database.cc',
        'browser/history/thumbnail_database.h',
        'browser/history/top_sites.cc',
        'browser/history/top_sites.h',
        'browser/history/top_sites_backend.cc',
        'browser/history/top_sites_backend.h',
        'browser/history/top_sites_cache.cc',
        'browser/history/top_sites_cache.h',
        'browser/history/top_sites_database.cc',
        'browser/history/top_sites_database.h',
        'browser/history/url_database.cc',
        'browser/history/url_database.h',
        'browser/history/visit_database.cc',
        'browser/history/visit_database.h',
        'browser/history/visit_tracker.cc',
        'browser/history/visit_tracker.h',
        'browser/history/visitsegment_database.cc',
        'browser/history/visitsegment_database.h',
        'browser/icon_loader.cc',
        'browser/icon_loader.h',
        'browser/icon_loader_linux.cc',
        'browser/icon_loader_mac.mm',
        'browser/icon_loader_win.cc',
        'browser/icon_manager.cc',
        'browser/icon_manager.h',
        'browser/icon_manager_linux.cc',
        'browser/icon_manager_mac.mm',
        'browser/icon_manager_win.cc',
        'browser/idle_linux.cc',
        'browser/idle_mac.mm',
        'browser/idle_query_linux.cc',
        'browser/idle_query_linux.h',
        'browser/idle_win.cc',
        'browser/importer/external_process_importer_bridge.cc',
        'browser/importer/external_process_importer_bridge.h',
        'browser/importer/external_process_importer_client.cc',
        'browser/importer/external_process_importer_client.h',
        'browser/importer/external_process_importer_host.cc',
        'browser/importer/external_process_importer_host.h',
        'browser/importer/firefox2_importer.cc',
        'browser/importer/firefox2_importer.h',
        'browser/importer/firefox3_importer.cc',
        'browser/importer/firefox3_importer.h',
        'browser/importer/firefox_importer_utils.cc',
        'browser/importer/firefox_importer_utils.h',
        'browser/importer/firefox_importer_utils_linux.cc',
        'browser/importer/firefox_importer_utils_mac.mm',
        'browser/importer/firefox_importer_utils_win.cc',
        'browser/importer/firefox_profile_lock.cc',
        'browser/importer/firefox_profile_lock.h',
        'browser/importer/firefox_profile_lock_posix.cc',
        'browser/importer/firefox_profile_lock_win.cc',
        'browser/importer/firefox_proxy_settings.cc',
        'browser/importer/firefox_proxy_settings.h',
        'browser/importer/ie_importer.cc',
        'browser/importer/ie_importer.h',
        'browser/importer/importer.cc',
        'browser/importer/importer.h',
        'browser/importer/importer_bridge.cc',
        'browser/importer/importer_bridge.h',
        'browser/importer/importer_data_types.cc',
        'browser/importer/importer_data_types.h',
        'browser/importer/importer_host.cc',
        'browser/importer/importer_host.h',
        'browser/importer/importer_list.cc',
        'browser/importer/importer_list.h',
        'browser/importer/importer_lock_dialog.h',
        'browser/importer/importer_observer.h',
        'browser/importer/importer_progress_dialog.h',
        'browser/importer/importer_progress_observer.h',
        'browser/importer/importer_type.cc',
        'browser/importer/importer_type.h',
        'browser/importer/in_process_importer_bridge.cc',
        'browser/importer/in_process_importer_bridge.h',
        'browser/importer/mork_reader.cc',
        'browser/importer/mork_reader.h',
        'browser/importer/nss_decryptor.cc',
        'browser/importer/nss_decryptor.h',
        'browser/importer/nss_decryptor_mac.h',
        'browser/importer/nss_decryptor_mac.mm',
        'browser/importer/nss_decryptor_system_nss.cc',
        'browser/importer/nss_decryptor_system_nss.h',
        'browser/importer/nss_decryptor_win.cc',
        'browser/importer/nss_decryptor_win.h',
        'browser/importer/profile_import_process_client.cc',
        'browser/importer/profile_import_process_client.h',
        'browser/importer/profile_import_process_host.cc',
        'browser/importer/profile_import_process_host.h',
        'browser/importer/profile_import_process_messages.cc',
        'browser/importer/profile_import_process_messages.h',
        'browser/importer/profile_writer.cc',
        'browser/importer/profile_writer.h',
        'browser/importer/safari_importer.h',
        'browser/importer/safari_importer.mm',
        'browser/importer/toolbar_importer.cc',
        'browser/importer/toolbar_importer.h',
        'browser/importer/toolbar_importer_utils.cc',
        'browser/importer/toolbar_importer_utils.h',
        'browser/instant/instant_commit_type.h',
        'browser/instant/instant_confirm_dialog.cc',
        'browser/instant/instant_confirm_dialog.h',
        'browser/instant/instant_controller.cc',
        'browser/instant/instant_controller.h',
        'browser/instant/instant_delegate.h',
        'browser/instant/instant_loader.cc',
        'browser/instant/instant_loader.h',
        'browser/instant/instant_loader_delegate.h',
        'browser/instant/instant_loader_manager.cc',
        'browser/instant/instant_loader_manager.h',
        'browser/instant/instant_unload_handler.cc',
        'browser/instant/instant_unload_handler.h',
        'browser/instant/promo_counter.cc',
        'browser/instant/promo_counter.h',
        'browser/internal_auth.cc',
        'browser/internal_auth.h',
        'browser/intranet_redirect_detector.cc',
        'browser/intranet_redirect_detector.h',
        'browser/io_thread.cc',
        'browser/io_thread.h',
        'browser/jankometer.cc',
        'browser/jankometer.h',
        'browser/jankometer_mac.cc',
        'browser/jumplist_win.cc',
        'browser/jumplist_win.h',
        'browser/keychain_mac.cc',
        'browser/keychain_mac.h',
        'browser/language_combobox_model.cc',
        'browser/language_combobox_model.h',
        'browser/language_order_table_model.cc',
        'browser/language_order_table_model.h',
        'browser/load_from_memory_cache_details.cc',
        'browser/load_from_memory_cache_details.h',
        'browser/mach_broker_mac.cc',
        'browser/mach_broker_mac.h',
        'browser/memory_details.cc',
        'browser/memory_details.h',
        'browser/memory_details_linux.cc',
        'browser/memory_details_mac.cc',
        'browser/memory_details_win.cc',
        'browser/memory_purger.cc',
        'browser/memory_purger.h',
        'browser/metrics/field_trial_synchronizer.cc',
        'browser/metrics/field_trial_synchronizer.h',
        'browser/metrics/histogram_synchronizer.cc',
        'browser/metrics/histogram_synchronizer.h',
        'browser/metrics/metric_event_duration_details.h',
        'browser/metrics/metrics_log.cc',
        'browser/metrics/metrics_log.h',
        'browser/metrics/metrics_reporting_scheduler.cc',
        'browser/metrics/metrics_reporting_scheduler.h',
        'browser/metrics/metrics_response.cc',
        'browser/metrics/metrics_response.h',
        'browser/metrics/metrics_service.cc',
        'browser/metrics/metrics_service.h',
        'browser/metrics/thread_watcher.cc',
        'browser/metrics/thread_watcher.h',
        'browser/nacl_host/nacl_broker_host_win.cc',
        'browser/nacl_host/nacl_broker_host_win.h',
        'browser/nacl_host/nacl_broker_service_win.cc',
        'browser/nacl_host/nacl_broker_service_win.h',
        'browser/nacl_host/nacl_process_host.cc',
        'browser/nacl_host/nacl_process_host.h',
        'browser/net/browser_url_util.cc',
        'browser/net/browser_url_util.h',
        'browser/net/chrome_cookie_notification_details.h',
        'browser/net/chrome_dns_cert_provenance_checker.cc',
        'browser/net/chrome_dns_cert_provenance_checker.h',
        'browser/net/chrome_dns_cert_provenance_checker_factory.cc',
        'browser/net/chrome_dns_cert_provenance_checker_factory.h',
        'browser/net/chrome_net_log.cc',
        'browser/net/chrome_net_log.h',
        'browser/net/chrome_network_delegate.cc',
        'browser/net/chrome_network_delegate.h',
        'browser/net/chrome_url_request_context.cc',
        'browser/net/chrome_url_request_context.h',
        'browser/net/connect_interceptor.cc',
        'browser/net/connect_interceptor.h',
        'browser/net/connection_tester.cc',
        'browser/net/connection_tester.h',
        'browser/net/gaia/token_service.cc',
        'browser/net/gaia/token_service.h',
        'browser/net/load_timing_observer.cc',
        'browser/net/load_timing_observer.h',
        'browser/net/metadata_url_request.cc',
        'browser/net/metadata_url_request.h',
        'browser/net/net_log_logger.cc',
        'browser/net/net_log_logger.h',
        'browser/net/net_pref_observer.cc',
        'browser/net/net_pref_observer.h',
        'browser/net/passive_log_collector.cc',
        'browser/net/passive_log_collector.h',
        'browser/net/preconnect.cc',
        'browser/net/preconnect.h',
        'browser/net/predictor.cc',
        'browser/net/predictor.h',
        'browser/net/predictor_api.cc',
        'browser/net/predictor_api.h',
        'browser/net/pref_proxy_config_service.cc',
        'browser/net/pref_proxy_config_service.h',
        'browser/net/proxy_service_factory.cc',
        'browser/net/proxy_service_factory.h',
        'browser/net/quoted_printable.cc',
        'browser/net/quoted_printable.h',
        'browser/net/referrer.cc',
        'browser/net/referrer.h',
        'browser/net/sdch_dictionary_fetcher.cc',
        'browser/net/sdch_dictionary_fetcher.h',
        'browser/net/service_providers_win.cc',
        'browser/net/service_providers_win.h',
        'browser/net/sqlite_persistent_cookie_store.cc',
        'browser/net/sqlite_persistent_cookie_store.h',
        'browser/net/ssl_config_service_manager.h',
        'browser/net/ssl_config_service_manager_pref.cc',
        'browser/net/url_fixer_upper.cc',
        'browser/net/url_fixer_upper.h',
        'browser/net/url_info.cc',
        'browser/net/url_info.h',
        'browser/net/url_request_failed_dns_job.cc',
        'browser/net/url_request_failed_dns_job.h',
        # TODO:  These should be moved to test_support (see below), but
        # are currently used by production code in automation_provider.cc.
        'browser/net/url_request_mock_http_job.cc',
        'browser/net/url_request_mock_http_job.h',
        'browser/net/url_request_mock_link_doctor_job.cc',
        'browser/net/url_request_mock_link_doctor_job.h',
        'browser/net/url_request_mock_util.cc',
        'browser/net/url_request_mock_util.h',
        'browser/net/url_request_slow_download_job.cc',
        'browser/net/url_request_slow_download_job.h',
        'browser/net/url_request_slow_http_job.cc',
        'browser/net/url_request_slow_http_job.h',
        'browser/net/view_blob_internals_job_factory.cc',
        'browser/net/view_blob_internals_job_factory.h',
        'browser/net/view_http_cache_job_factory.cc',
        'browser/net/view_http_cache_job_factory.h',
        'browser/net/websocket_experiment/websocket_experiment_runner.cc',
        'browser/net/websocket_experiment/websocket_experiment_runner.h',
        'browser/net/websocket_experiment/websocket_experiment_task.cc',
        'browser/net/websocket_experiment/websocket_experiment_task.h',
        'browser/notifications/balloon.cc',
        'browser/notifications/balloon.h',
        'browser/notifications/balloon_collection.cc',
        'browser/notifications/balloon_collection.h',
        'browser/notifications/balloon_collection_base.cc',
        'browser/notifications/balloon_collection_base.h',
        'browser/notifications/balloon_collection_impl.cc',
        'browser/notifications/balloon_collection_impl.h',
        'browser/notifications/balloon_collection_linux.cc',
        'browser/notifications/balloon_collection_mac.mm',
        'browser/notifications/balloon_collection_win.cc',
        'browser/notifications/balloon_host.cc',
        'browser/notifications/balloon_host.h',
        'browser/notifications/desktop_notification_service.cc',
        'browser/notifications/desktop_notification_service.h',
        'browser/notifications/desktop_notification_service_factory.cc',
        'browser/notifications/desktop_notification_service_factory.h',
        'browser/notifications/notification.cc',
        'browser/notifications/notification.h',
        'browser/notifications/notification_delegate.h',
        'browser/notifications/notification_exceptions_table_model.cc',
        'browser/notifications/notification_exceptions_table_model.h',
        'browser/notifications/notification_object_proxy.cc',
        'browser/notifications/notification_object_proxy.h',
        'browser/notifications/notification_options_menu_model.cc',
        'browser/notifications/notification_options_menu_model.h',
        'browser/notifications/notification_ui_manager.cc',
        'browser/notifications/notification_ui_manager.h',
        'browser/notifications/notifications_prefs_cache.cc',
        'browser/notifications/notifications_prefs_cache.h',
        'browser/ntp_background_util.cc',
        'browser/ntp_background_util.h',
        'browser/omnibox_search_hint.cc',
        'browser/omnibox_search_hint.h',
        'browser/oom_priority_manager.cc',
        'browser/oom_priority_manager.h',
        'browser/page_info_model.cc',
        'browser/page_info_model.h',
        'browser/parsers/metadata_parser.cc',
        'browser/parsers/metadata_parser.h',
        'browser/parsers/metadata_parser_factory.h',
        'browser/parsers/metadata_parser_filebase.cc',
        'browser/parsers/metadata_parser_filebase.h',
        'browser/parsers/metadata_parser_jpeg.cc',
        'browser/parsers/metadata_parser_jpeg.h',
        'browser/parsers/metadata_parser_jpeg_factory.cc',
        'browser/parsers/metadata_parser_jpeg_factory.h',
        'browser/parsers/metadata_parser_manager.cc',
        'browser/parsers/metadata_parser_manager.h',
        'browser/password_manager/encryptor.h',
        'browser/password_manager/encryptor_linux.cc',
        'browser/password_manager/encryptor_mac.mm',
        'browser/password_manager/encryptor_password_mac.h',
        'browser/password_manager/encryptor_password_mac.mm',
        'browser/password_manager/encryptor_win.cc',
        'browser/password_manager/ie7_password.cc',
        'browser/password_manager/ie7_password.h',
        'browser/password_manager/login_database.cc',
        'browser/password_manager/login_database.h',
        'browser/password_manager/login_database_mac.cc',
        'browser/password_manager/login_database_posix.cc',
        'browser/password_manager/login_database_win.cc',
        'browser/password_manager/native_backend_gnome_x.cc',
        'browser/password_manager/native_backend_gnome_x.h',
        'browser/password_manager/native_backend_kwallet_x.cc',
        'browser/password_manager/native_backend_kwallet_x.h',
        'browser/password_manager/password_form_manager.cc',
        'browser/password_manager/password_form_manager.h',
        'browser/password_manager/password_manager.cc',
        'browser/password_manager/password_manager.h',
        'browser/password_manager/password_store.cc',
        'browser/password_manager/password_store.h',
        'browser/password_manager/password_store_consumer.cc',
        'browser/password_manager/password_store_consumer.h',
        'browser/password_manager/password_store_default.cc',
        'browser/password_manager/password_store_default.h',
        'browser/password_manager/password_store_mac.cc',
        'browser/password_manager/password_store_mac.h',
        'browser/password_manager/password_store_mac_internal.h',
        'browser/password_manager/password_store_win.cc',
        'browser/password_manager/password_store_win.h',
        'browser/password_manager/password_store_x.cc',
        'browser/password_manager/password_store_x.h',
        'browser/password_manager_delegate_impl.cc',
        'browser/password_manager_delegate_impl.h',
        'browser/pdf_unsupported_feature.cc',
        'browser/pdf_unsupported_feature.h',
        'browser/platform_util.h',
        'browser/platform_util_chromeos.cc',
        'browser/platform_util_common_linux.cc',
        'browser/platform_util_linux.cc',
        'browser/platform_util_mac.mm',
        'browser/platform_util_win.cc',
        'browser/plugin_data_remover.cc',
        'browser/plugin_data_remover.h',
        'browser/plugin_data_remover_helper.cc',
        'browser/plugin_data_remover_helper.h',
        'browser/plugin_download_helper.cc',
        'browser/plugin_download_helper.h',
        'browser/plugin_exceptions_table_model.cc',
        'browser/plugin_exceptions_table_model.h',
        'browser/plugin_installer_infobar_delegate.cc',
        'browser/plugin_installer_infobar_delegate.h',
        'browser/plugin_observer.cc',
        'browser/plugin_observer.h',
        'browser/plugin_updater.cc',
        'browser/plugin_updater.h',
        'browser/policy/asynchronous_policy_loader.cc',
        'browser/policy/asynchronous_policy_loader.h',
        'browser/policy/asynchronous_policy_provider.cc',
        'browser/policy/asynchronous_policy_provider.h',
        'browser/policy/browser_policy_connector.cc',
        'browser/policy/browser_policy_connector.h',
        'browser/policy/cloud_policy_cache_base.cc',
        'browser/policy/cloud_policy_cache_base.h',
        'browser/policy/cloud_policy_controller.cc',
        'browser/policy/cloud_policy_controller.h',
        'browser/policy/cloud_policy_identity_strategy.cc',
        'browser/policy/cloud_policy_identity_strategy.h',
        'browser/policy/cloud_policy_subsystem.cc',
        'browser/policy/cloud_policy_subsystem.h',
        'browser/policy/config_dir_policy_provider.cc',
        'browser/policy/config_dir_policy_provider.h',
        'browser/policy/configuration_policy_loader_win.cc',
        'browser/policy/configuration_policy_loader_win.h',
        'browser/policy/configuration_policy_pref_store.cc',
        'browser/policy/configuration_policy_pref_store.h',
        'browser/policy/configuration_policy_provider.cc',
        'browser/policy/configuration_policy_provider.h',
        'browser/policy/configuration_policy_provider_delegate_win.cc',
        'browser/policy/configuration_policy_provider_delegate_win.h',
        'browser/policy/configuration_policy_provider_mac.cc',
        'browser/policy/configuration_policy_provider_mac.h',
        'browser/policy/configuration_policy_provider_win.cc',
        'browser/policy/configuration_policy_provider_win.h',
        'browser/policy/configuration_policy_store_interface.cc',
        'browser/policy/configuration_policy_store_interface.h',
        'browser/policy/device_management_backend.h',
        'browser/policy/device_management_backend_impl.cc',
        'browser/policy/device_management_backend_impl.h',
        'browser/policy/device_management_service.cc',
        'browser/policy/device_management_service.h',
        'browser/policy/device_policy_cache.cc',
        'browser/policy/device_policy_cache.h',
        'browser/policy/device_policy_identity_strategy.cc',
        'browser/policy/device_policy_identity_strategy.h',
        'browser/policy/device_token_fetcher.cc',
        'browser/policy/device_token_fetcher.h',
        'browser/policy/dummy_configuration_policy_provider.cc',
        'browser/policy/dummy_configuration_policy_provider.h',
        'browser/policy/enterprise_install_attributes.cc',
        'browser/policy/enterprise_install_attributes.h',
        'browser/policy/file_based_policy_loader.cc',
        'browser/policy/file_based_policy_loader.h',
        'browser/policy/file_based_policy_provider.cc',
        'browser/policy/file_based_policy_provider.h',
        'browser/policy/managed_prefs_banner_base.cc',
        'browser/policy/managed_prefs_banner_base.h',
        'browser/policy/policy_notifier.cc',
        'browser/policy/policy_notifier.h',
        'browser/policy/policy_path_parser.h',
        'browser/policy/policy_path_parser_mac.mm',
        'browser/policy/policy_path_parser_posix.cc',
        'browser/policy/policy_path_parser_win.cc',
        'browser/policy/profile_policy_connector.cc',
        'browser/policy/profile_policy_connector.h',
        'browser/policy/profile_policy_connector_factory.cc',
        'browser/policy/profile_policy_connector_factory.h',
        'browser/policy/user_policy_cache.cc',
        'browser/policy/user_policy_cache.h',
        'browser/policy/user_policy_identity_strategy.cc',
        'browser/policy/user_policy_identity_strategy.h',
        # TODO(danno): Find a better way to include these files
        '<(protoc_out_dir)/chrome/browser/policy/proto/chrome_device_policy.pb.cc',
        '<(protoc_out_dir)/chrome/browser/policy/proto/chrome_device_policy.pb.h',
        '<(protoc_out_dir)/chrome/browser/policy/proto/device_management_backend.pb.cc',
        '<(protoc_out_dir)/chrome/browser/policy/proto/device_management_backend.pb.h',
        'browser/policy/proto/device_management_constants.cc',
        'browser/policy/proto/device_management_constants.h',
        '<(protoc_out_dir)/chrome/browser/policy/proto/device_management_local.pb.cc',
        '<(protoc_out_dir)/chrome/browser/policy/proto/device_management_local.pb.h',
        'browser/possible_url_model.cc',
        'browser/possible_url_model.h',
        'browser/power_save_blocker.h',
        'browser/power_save_blocker_common.cc',
        'browser/power_save_blocker_mac.cc',
        'browser/power_save_blocker_stub.cc',
        'browser/power_save_blocker_win.cc',
        'browser/preferences_mac.cc',
        'browser/preferences_mac.h',
        'browser/prefs/browser_prefs.cc',
        'browser/prefs/browser_prefs.h',
        'browser/prefs/command_line_pref_store.cc',
        'browser/prefs/command_line_pref_store.h',
        'browser/prefs/default_pref_store.cc',
        'browser/prefs/default_pref_store.h',
        'browser/prefs/overlay_persistent_pref_store.cc',
        'browser/prefs/overlay_persistent_pref_store.h',
        'browser/prefs/pref_change_registrar.cc',
        'browser/prefs/pref_change_registrar.h',
        'browser/prefs/pref_member.cc',
        'browser/prefs/pref_member.h',
        'browser/prefs/pref_model_associator.cc',
        'browser/prefs/pref_model_associator.h',
        'browser/prefs/pref_notifier.h',
        'browser/prefs/pref_notifier_impl.cc',
        'browser/prefs/pref_notifier_impl.h',
        'browser/prefs/pref_service.cc',
        'browser/prefs/pref_service.h',
        'browser/prefs/pref_set_observer.cc',
        'browser/prefs/pref_set_observer.h',
        'browser/prefs/pref_value_map.cc',
        'browser/prefs/pref_value_map.h',
        'browser/prefs/pref_value_store.cc',
        'browser/prefs/pref_value_store.h',
        'browser/prefs/proxy_config_dictionary.cc',
        'browser/prefs/proxy_config_dictionary.h',
        'browser/prefs/proxy_prefs.cc',
        'browser/prefs/proxy_prefs.h',
        'browser/prefs/scoped_user_pref_update.cc',
        'browser/prefs/scoped_user_pref_update.h',
        'browser/prefs/session_startup_pref.cc',
        'browser/prefs/session_startup_pref.h',
        'browser/prefs/value_map_pref_store.cc',
        'browser/prefs/value_map_pref_store.h',
        'browser/prerender/prerender_contents.cc',
        'browser/prerender/prerender_contents.h',
        'browser/prerender/prerender_field_trial.cc',
        'browser/prerender/prerender_field_trial.h',
        'browser/prerender/prerender_final_status.cc',
        'browser/prerender/prerender_final_status.h',
        'browser/prerender/prerender_manager.cc',
        'browser/prerender/prerender_manager.h',
        'browser/prerender/prerender_observer.cc',
        'browser/prerender/prerender_observer.h',
        'browser/prerender/prerender_render_view_host_observer.cc',
        'browser/prerender/prerender_render_view_host_observer.h',
        'browser/prerender/prerender_tracker.cc',
        'browser/prerender/prerender_tracker.h',
        'browser/printing/background_printing_manager.cc',
        'browser/printing/background_printing_manager.h',
        'browser/printing/cloud_print/cloud_print_proxy_service.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service.h',
        'browser/printing/cloud_print/cloud_print_setup_flow.cc',
        'browser/printing/cloud_print/cloud_print_setup_flow.h',
        'browser/printing/cloud_print/cloud_print_setup_handler.cc',
        'browser/printing/cloud_print/cloud_print_setup_handler.h',
        'browser/printing/cloud_print/cloud_print_setup_message_handler.cc',
        'browser/printing/cloud_print/cloud_print_setup_message_handler.h',
        'browser/printing/cloud_print/cloud_print_setup_source.cc',
        'browser/printing/cloud_print/cloud_print_setup_source.h',
        'browser/printing/cloud_print/cloud_print_url.cc',
        'browser/printing/cloud_print/cloud_print_url.h',
        'browser/printing/print_dialog_cloud.cc',
        'browser/printing/print_dialog_cloud.h',
        'browser/printing/print_dialog_gtk.cc',
        'browser/printing/print_dialog_gtk.h',
        'browser/printing/print_job.cc',
        'browser/printing/print_job.h',
        'browser/printing/print_job_manager.cc',
        'browser/printing/print_job_manager.h',
        'browser/printing/print_job_worker.cc',
        'browser/printing/print_job_worker.h',
        'browser/printing/print_job_worker_owner.h',
        'browser/printing/print_preview_data_service.cc',
        'browser/printing/print_preview_data_service.h',
        'browser/printing/print_preview_message_handler.cc',
        'browser/printing/print_preview_message_handler.h',
        'browser/printing/print_preview_tab_controller.cc',
        'browser/printing/print_preview_tab_controller.h',
        'browser/printing/print_view_manager.cc',
        'browser/printing/print_view_manager.h',
        'browser/printing/printer_manager_dialog.h',
        'browser/printing/printer_manager_dialog_linux.cc',
        'browser/printing/printer_manager_dialog_mac.mm',
        'browser/printing/printer_manager_dialog_win.cc',
        'browser/printing/printer_query.cc',
        'browser/printing/printer_query.h',
        'browser/printing/printing_message_filter.cc',
        'browser/printing/printing_message_filter.h',
        'browser/process_info_snapshot.h',
        'browser/process_info_snapshot_mac.cc',
        'browser/process_singleton.h',
        'browser/process_singleton_linux.cc',
        'browser/process_singleton_mac.cc',
        'browser/process_singleton_win.cc',
        'browser/profiles/off_the_record_profile_io_data.cc',
        'browser/profiles/off_the_record_profile_io_data.h',
        'browser/profiles/profile.cc',
        'browser/profiles/profile.h',
        'browser/profiles/profile_dependency_manager.cc',
        'browser/profiles/profile_dependency_manager.h',
        'browser/profiles/profile_impl.cc',
        'browser/profiles/profile_impl.h',
        'browser/profiles/profile_impl_io_data.cc',
        'browser/profiles/profile_impl_io_data.h',
        'browser/profiles/profile_io_data.cc',
        'browser/profiles/profile_io_data.h',
        'browser/profiles/profile_keyed_service_factory.cc',
        'browser/profiles/profile_keyed_service_factory.h',
        'browser/profiles/profile_manager.cc',
        'browser/profiles/profile_manager.h',
        'browser/remove_rows_table_model.h',
        'browser/renderer_host/accelerated_plugin_view_mac.h',
        'browser/renderer_host/accelerated_plugin_view_mac.mm',
        'browser/renderer_host/chrome_render_message_filter.cc',
        'browser/renderer_host/chrome_render_message_filter.h',
        'browser/renderer_host/chrome_render_view_host_observer.cc',
        'browser/renderer_host/chrome_render_view_host_observer.h',
        'browser/renderer_host/chrome_resource_dispatcher_host_observer.cc',
        'browser/renderer_host/chrome_resource_dispatcher_host_observer.h',
        'browser/renderer_host/download_resource_handler.cc',
        'browser/renderer_host/download_resource_handler.h',
        'browser/renderer_host/download_throttling_resource_handler.cc',
        'browser/renderer_host/download_throttling_resource_handler.h',
        'browser/renderer_host/gtk_im_context_wrapper.cc',
        'browser/renderer_host/gtk_im_context_wrapper.h',
        'browser/renderer_host/gtk_key_bindings_handler.cc',
        'browser/renderer_host/gtk_key_bindings_handler.h',
        'browser/renderer_host/offline_resource_handler.cc',
        'browser/renderer_host/offline_resource_handler.h',
        'browser/renderer_host/render_widget_host_view_gtk.cc',
        'browser/renderer_host/render_widget_host_view_gtk.h',
        'browser/renderer_host/render_widget_host_view_mac.h',
        'browser/renderer_host/render_widget_host_view_mac.mm',
        'browser/renderer_host/render_widget_host_view_views.cc',
        'browser/renderer_host/render_widget_host_view_views.h',
        'browser/renderer_host/render_widget_host_view_win.cc',
        'browser/renderer_host/render_widget_host_view_win.h',
        'browser/renderer_host/safe_browsing_resource_handler.cc',
        'browser/renderer_host/safe_browsing_resource_handler.h',
        'browser/renderer_host/save_file_resource_handler.cc',
        'browser/renderer_host/save_file_resource_handler.h',
        'browser/renderer_host/text_input_client_mac.h',
        'browser/renderer_host/text_input_client_mac.mm',
        'browser/renderer_host/text_input_client_message_filter.h',
        'browser/renderer_host/text_input_client_message_filter.mm',
        'browser/renderer_host/web_cache_manager.cc',
        'browser/renderer_host/web_cache_manager.h',
        'browser/renderer_preferences_util.cc',
        'browser/renderer_preferences_util.h',
        'browser/repost_form_warning_controller.cc',
        'browser/repost_form_warning_controller.h',
        'browser/resources_util.cc',
        'browser/resources_util.h',
        'browser/rlz/rlz.cc',
        'browser/rlz/rlz.h',
        'browser/safe_browsing/bloom_filter.cc',
        'browser/safe_browsing/bloom_filter.h',
        'browser/safe_browsing/chunk_range.cc',
        'browser/safe_browsing/chunk_range.h',
        'browser/safe_browsing/client_side_detection_host.cc',
        'browser/safe_browsing/client_side_detection_host.h',
        'browser/safe_browsing/client_side_detection_service.cc',
        'browser/safe_browsing/client_side_detection_service.h',
        'browser/safe_browsing/malware_details.cc',
        'browser/safe_browsing/malware_details.h',
        'browser/safe_browsing/malware_details_cache.cc',
        'browser/safe_browsing/malware_details_cache.h',
        'browser/safe_browsing/malware_details_history.cc',
        'browser/safe_browsing/malware_details_history.h',
        'browser/safe_browsing/prefix_set.cc',
        'browser/safe_browsing/prefix_set.h',
        'browser/safe_browsing/protocol_manager.cc',
        'browser/safe_browsing/protocol_manager.h',
        'browser/safe_browsing/protocol_parser.cc',
        'browser/safe_browsing/protocol_parser.h',
        '<(protoc_out_dir)/chrome/browser/safe_browsing/report.pb.cc',
        '<(protoc_out_dir)/chrome/browser/safe_browsing/report.pb.h',
        'browser/safe_browsing/safe_browsing_blocking_page.cc',
        'browser/safe_browsing/safe_browsing_blocking_page.h',
        'browser/safe_browsing/safe_browsing_database.cc',
        'browser/safe_browsing/safe_browsing_database.h',
        'browser/safe_browsing/safe_browsing_service.cc',
        'browser/safe_browsing/safe_browsing_service.h',
        'browser/safe_browsing/safe_browsing_store.cc',
        'browser/safe_browsing/safe_browsing_store.h',
        'browser/safe_browsing/safe_browsing_store_file.cc',
        'browser/safe_browsing/safe_browsing_store_file.h',
        'browser/safe_browsing/safe_browsing_util.cc',
        'browser/safe_browsing/safe_browsing_util.h',
        'browser/search_engines/search_engine_type.h',
        'browser/search_engines/search_host_to_urls_map.cc',
        'browser/search_engines/search_host_to_urls_map.h',
        'browser/search_engines/search_provider_install_data.cc',
        'browser/search_engines/search_provider_install_data.h',
        'browser/search_engines/search_provider_install_state_message_filter.cc',
        'browser/search_engines/search_provider_install_state_message_filter.h',
        'browser/search_engines/search_terms_data.cc',
        'browser/search_engines/search_terms_data.h',
        'browser/search_engines/template_url.cc',
        'browser/search_engines/template_url.h',
        'browser/search_engines/template_url_fetcher.cc',
        'browser/search_engines/template_url_fetcher.h',
        'browser/search_engines/template_url_fetcher_callbacks.h',
        'browser/search_engines/template_url_id.h',
        'browser/search_engines/template_url_model.cc',
        'browser/search_engines/template_url_model.h',
        'browser/search_engines/template_url_model_observer.h',
        'browser/search_engines/template_url_parser.cc',
        'browser/search_engines/template_url_parser.h',
        'browser/search_engines/template_url_prepopulate_data.cc',
        'browser/search_engines/template_url_prepopulate_data.h',
        'browser/search_engines/util.cc',
        'browser/search_engines/util.h',
        'browser/service/service_process_control.cc',
        'browser/service/service_process_control_mac.mm',
        'browser/service/service_process_control.h',
        'browser/service/service_process_control_manager.cc',
        'browser/service/service_process_control_manager.h',
        'browser/sessions/base_session_service.cc',
        'browser/sessions/base_session_service.h',
        'browser/sessions/session_backend.cc',
        'browser/sessions/session_backend.h',
        'browser/sessions/session_command.cc',
        'browser/sessions/session_command.h',
        'browser/sessions/session_id.cc',
        'browser/sessions/session_id.h',
        'browser/sessions/session_restore.cc',
        'browser/sessions/session_restore.h',
        'browser/sessions/session_service.cc',
        'browser/sessions/session_service.h',
        'browser/sessions/session_service_factory.cc',
        'browser/sessions/session_service_factory.h',
        'browser/sessions/session_types.cc',
        'browser/sessions/session_types.h',
        'browser/sessions/tab_restore_service.cc',
        'browser/sessions/tab_restore_service.h',
        'browser/sessions/tab_restore_service_factory.cc',
        'browser/sessions/tab_restore_service_factory.h',
        'browser/shell_integration.cc',
        'browser/shell_integration.h',
        'browser/shell_integration_linux.cc',
        'browser/shell_integration_mac.mm',
        'browser/shell_integration_win.cc',
        'browser/sidebar/sidebar_container.cc',
        'browser/sidebar/sidebar_container.h',
        'browser/sidebar/sidebar_manager.cc',
        'browser/sidebar/sidebar_manager.h',
        'browser/speech/speech_input_bubble.cc',
        'browser/speech/speech_input_bubble.h',
        'browser/speech/speech_input_bubble_controller.cc',
        'browser/speech/speech_input_bubble_controller.h',
        'browser/speech/speech_input_bubble_gtk.cc',
        'browser/speech/speech_input_bubble_mac.mm',
        'browser/speech/speech_input_bubble_views.cc',
        'browser/speech/speech_input_manager.cc',
        'browser/spellcheck_host.cc',
        'browser/spellcheck_host.h',
        'browser/spellcheck_host_impl.cc',
        'browser/spellcheck_host_impl.h',
        'browser/spellcheck_message_filter.cc',
        'browser/spellcheck_message_filter.h',
        'browser/spellchecker_linux.cc',
        'browser/spellchecker_mac.mm',
        'browser/spellchecker_platform_engine.h',
        'browser/spellchecker_win.cc',
        'browser/ssl/ssl_add_cert_handler.cc',
        'browser/ssl/ssl_add_cert_handler.h',
        'browser/ssl/ssl_add_cert_handler_mac.mm',
        'browser/ssl/ssl_blocking_page.cc',
        'browser/ssl/ssl_blocking_page.h',
        'browser/ssl/ssl_cert_error_handler.cc',
        'browser/ssl/ssl_cert_error_handler.h',
        'browser/ssl/ssl_client_auth_handler.cc',
        'browser/ssl/ssl_client_auth_handler.h',
        'browser/ssl/ssl_client_auth_notification_details.cc',
        'browser/ssl/ssl_client_auth_notification_details.h',
        'browser/ssl/ssl_error_handler.cc',
        'browser/ssl/ssl_error_handler.h',
        'browser/ssl/ssl_error_info.cc',
        'browser/ssl/ssl_error_info.h',
        'browser/ssl/ssl_host_state.cc',
        'browser/ssl/ssl_host_state.h',
        'browser/ssl/ssl_manager.cc',
        'browser/ssl/ssl_manager.h',
        'browser/ssl/ssl_policy.cc',
        'browser/ssl/ssl_policy.h',
        'browser/ssl/ssl_policy_backend.cc',
        'browser/ssl/ssl_policy_backend.h',
        'browser/ssl/ssl_request_info.cc',
        'browser/ssl/ssl_request_info.h',
        'browser/ssl_client_certificate_selector.h',
        'browser/status_icons/status_icon.cc',
        'browser/status_icons/status_icon.h',
        'browser/status_icons/status_tray.cc',
        'browser/status_icons/status_tray.h',
        'browser/sync/glue/app_change_processor.cc',
        'browser/sync/glue/app_change_processor.h',
        'browser/sync/glue/app_data_type_controller.cc',
        'browser/sync/glue/app_data_type_controller.h',
        'browser/sync/glue/app_model_associator.cc',
        'browser/sync/glue/app_model_associator.h',
        'browser/sync/glue/autofill_change_processor.cc',
        'browser/sync/glue/autofill_change_processor.h',
        'browser/sync/glue/autofill_data_type_controller.cc',
        'browser/sync/glue/autofill_data_type_controller.h',
        'browser/sync/glue/autofill_model_associator.cc',
        'browser/sync/glue/autofill_model_associator.h',
        'browser/sync/glue/autofill_profile_change_processor.cc',
        'browser/sync/glue/autofill_profile_change_processor.h',
        'browser/sync/glue/autofill_profile_data_type_controller.cc',
        'browser/sync/glue/autofill_profile_data_type_controller.h',
        'browser/sync/glue/autofill_profile_model_associator.cc',
        'browser/sync/glue/autofill_profile_model_associator.h',
        'browser/sync/glue/bookmark_change_processor.cc',
        'browser/sync/glue/bookmark_change_processor.h',
        'browser/sync/glue/bookmark_data_type_controller.cc',
        'browser/sync/glue/bookmark_data_type_controller.h',
        'browser/sync/glue/bookmark_model_associator.cc',
        'browser/sync/glue/bookmark_model_associator.h',
        'browser/sync/glue/change_processor.cc',
        'browser/sync/glue/change_processor.h',
        'browser/sync/glue/data_type_controller.h',
        'browser/sync/glue/data_type_manager.cc',
        'browser/sync/glue/data_type_manager.h',
        'browser/sync/glue/data_type_manager_impl.cc',
        'browser/sync/glue/data_type_manager_impl.h',
        'browser/sync/glue/database_model_worker.cc',
        'browser/sync/glue/database_model_worker.h',
        'browser/sync/glue/do_optimistic_refresh_task.cc',
        'browser/sync/glue/do_optimistic_refresh_task.h',
        'browser/sync/glue/extension_change_processor.cc',
        'browser/sync/glue/extension_change_processor.h',
        'browser/sync/glue/extension_data_type_controller.cc',
        'browser/sync/glue/extension_data_type_controller.h',
        'browser/sync/glue/extension_model_associator.cc',
        'browser/sync/glue/extension_model_associator.h',
        'browser/sync/glue/extension_sync.cc',
        'browser/sync/glue/extension_sync.h',
        'browser/sync/glue/extension_sync_traits.cc',
        'browser/sync/glue/extension_sync_traits.h',
        'browser/sync/glue/extension_util.cc',
        'browser/sync/glue/extension_util.h',
        'browser/sync/glue/foreign_session_tracker.cc',
        'browser/sync/glue/foreign_session_tracker.h',
        'browser/sync/glue/frontend_data_type_controller.cc',
        'browser/sync/glue/frontend_data_type_controller.h',
        'browser/sync/glue/generic_change_processor.cc',
        'browser/sync/glue/generic_change_processor.h',
        'browser/sync/glue/history_model_worker.cc',
        'browser/sync/glue/history_model_worker.h',
        'browser/sync/glue/http_bridge.cc',
        'browser/sync/glue/http_bridge.h',
        'browser/sync/glue/model_associator.h',
        'browser/sync/glue/non_frontend_data_type_controller.cc',
        'browser/sync/glue/non_frontend_data_type_controller.h',
        'browser/sync/glue/password_change_processor.cc',
        'browser/sync/glue/password_change_processor.h',
        'browser/sync/glue/password_data_type_controller.cc',
        'browser/sync/glue/password_data_type_controller.h',
        'browser/sync/glue/password_model_associator.cc',
        'browser/sync/glue/password_model_associator.h',
        'browser/sync/glue/password_model_worker.cc',
        'browser/sync/glue/password_model_worker.h',
        'browser/sync/glue/preference_data_type_controller.cc',
        'browser/sync/glue/preference_data_type_controller.h',
        'browser/sync/glue/session_change_processor.cc',
        'browser/sync/glue/session_change_processor.h',
        'browser/sync/glue/session_data_type_controller.cc',
        'browser/sync/glue/session_data_type_controller.h',
        'browser/sync/glue/session_model_associator.cc',
        'browser/sync/glue/session_model_associator.h',
        'browser/sync/glue/syncable_service_adapter.cc',
        'browser/sync/glue/syncable_service_adapter.h',        
        'browser/sync/glue/sync_backend_host.cc',
        'browser/sync/glue/sync_backend_host.h',
        'browser/sync/glue/theme_change_processor.cc',
        'browser/sync/glue/theme_change_processor.h',
        'browser/sync/glue/theme_data_type_controller.cc',
        'browser/sync/glue/theme_data_type_controller.h',
        'browser/sync/glue/theme_model_associator.cc',
        'browser/sync/glue/theme_model_associator.h',
        'browser/sync/glue/theme_util.cc',
        'browser/sync/glue/theme_util.h',
        'browser/sync/glue/typed_url_change_processor.cc',
        'browser/sync/glue/typed_url_change_processor.h',
        'browser/sync/glue/typed_url_data_type_controller.cc',
        'browser/sync/glue/typed_url_data_type_controller.h',
        'browser/sync/glue/typed_url_model_associator.cc',
        'browser/sync/glue/typed_url_model_associator.h',
        'browser/sync/glue/ui_model_worker.cc',
        'browser/sync/glue/ui_model_worker.h',
        'browser/sync/backend_migrator.cc',
        'browser/sync/backend_migrator.h',
        'browser/sync/profile_sync_factory.h',
        'browser/sync/profile_sync_factory_impl.cc',
        'browser/sync/profile_sync_factory_impl.h',
        'browser/sync/profile_sync_service.cc',
        'browser/sync/profile_sync_service.h',
        'browser/sync/profile_sync_service_harness.cc',
        'browser/sync/profile_sync_service_harness.h',
        'browser/sync/profile_sync_service_observer.h',
        'browser/sync/api/syncable_service.cc',  # TODO(zea): make own target.
        'browser/sync/api/syncable_service.h',
        'browser/sync/api/sync_data.h',
        'browser/sync/api/sync_data.cc',
        'browser/sync/api/sync_change.h',
        'browser/sync/api/sync_change.cc',
        'browser/sync/api/sync_change_processor.h',
        'browser/sync/api/sync_change_processor.cc',        
        'browser/sync/signin_manager.cc',
        'browser/sync/signin_manager.h',
        'browser/sync/sync_setup_flow.cc',
        'browser/sync/sync_setup_flow.h',
        'browser/sync/sync_setup_flow_handler.h',
        'browser/sync/sync_setup_wizard.cc',
        'browser/sync/sync_setup_wizard.h',
        'browser/sync/sync_ui_util.cc',
        'browser/sync/sync_ui_util.h',
        'browser/sync/sync_ui_util_mac.h',
        'browser/sync/sync_ui_util_mac.mm',
        'browser/tab_closeable_state_watcher.cc',
        'browser/tab_closeable_state_watcher.h',
        'browser/tab_contents/background_contents.cc',
        'browser/tab_contents/background_contents.h',
        'browser/tab_contents/chrome_interstitial_page.cc',
        'browser/tab_contents/chrome_interstitial_page.h',
        'browser/tab_contents/confirm_infobar_delegate.cc',
        'browser/tab_contents/confirm_infobar_delegate.h',
        'browser/tab_contents/infobar.cc',
        'browser/tab_contents/infobar.h',
        'browser/tab_contents/infobar_container.cc',
        'browser/tab_contents/infobar_container.h',
        'browser/tab_contents/infobar_delegate.cc',
        'browser/tab_contents/infobar_delegate.h',
        'browser/tab_contents/language_state.cc',
        'browser/tab_contents/language_state.h',
        'browser/tab_contents/link_infobar_delegate.cc',
        'browser/tab_contents/link_infobar_delegate.h',
        'browser/tab_contents/simple_alert_infobar_delegate.cc',
        'browser/tab_contents/simple_alert_infobar_delegate.h',
        'browser/tab_contents/popup_menu_helper_mac.h',
        'browser/tab_contents/popup_menu_helper_mac.mm',
        'browser/tab_contents/render_view_context_menu.cc',
        'browser/tab_contents/render_view_context_menu.h',
        'browser/tab_contents/render_view_context_menu_gtk.cc',
        'browser/tab_contents/render_view_context_menu_gtk.h',
        'browser/tab_contents/render_view_context_menu_mac.h',
        'browser/tab_contents/render_view_context_menu_mac.mm',
        'browser/tab_contents/render_view_host_delegate_helper.cc',
        'browser/tab_contents/render_view_host_delegate_helper.h',
        'browser/tab_contents/tab_contents_ssl_helper.cc',
        'browser/tab_contents/tab_contents_ssl_helper.h',
        'browser/tab_contents/tab_contents_view_gtk.cc',
        'browser/tab_contents/tab_contents_view_gtk.h',
        'browser/tab_contents/tab_contents_view_mac.h',
        'browser/tab_contents/tab_contents_view_mac.mm',
        'browser/tab_contents/tab_util.cc',
        'browser/tab_contents/tab_util.h',
        'browser/tab_contents/thumbnail_generator.cc',
        'browser/tab_contents/thumbnail_generator.h',
        'browser/tab_contents/web_drag_dest_gtk.cc',
        'browser/tab_contents/web_drag_dest_gtk.h',
        'browser/tab_contents/web_drag_source_win.cc',
        'browser/tab_contents/web_drag_source_win.h',
        'browser/tab_contents/web_drag_utils_win.cc',
        'browser/tab_contents/web_drag_utils_win.h',
        'browser/tab_contents/web_drop_target_win.cc',
        'browser/tab_contents/web_drop_target_win.h',
        'browser/tabs/default_tab_handler.cc',
        'browser/tabs/default_tab_handler.h',
        'browser/tabs/pinned_tab_codec.cc',
        'browser/tabs/pinned_tab_codec.h',
        'browser/tabs/pinned_tab_service.cc',
        'browser/tabs/pinned_tab_service.h',
        'browser/tabs/pinned_tab_service_factory.cc',
        'browser/tabs/pinned_tab_service_factory.h',
        'browser/tabs/tab_handler.h',
        'browser/tabs/tab_finder.cc',
        'browser/tabs/tab_finder.h',
        'browser/tabs/tab_strip_model.cc',
        'browser/tabs/tab_strip_model.h',
        'browser/tabs/tab_strip_model_delegate.h',
        'browser/tabs/tab_strip_model_observer.cc',
        'browser/tabs/tab_strip_model_observer.h',
        'browser/tabs/tab_strip_model_order_controller.cc',
        'browser/tabs/tab_strip_model_order_controller.h',
        'browser/tabs/tab_strip_selection_model.cc',
        'browser/tabs/tab_strip_selection_model.h',
        'browser/task_manager/task_manager.cc',
        'browser/task_manager/task_manager.h',
        'browser/task_manager/task_manager_resource_providers.cc',
        'browser/task_manager/task_manager_resource_providers.h',
        'browser/themes/browser_theme_pack.cc',
        'browser/themes/browser_theme_pack.h',
        'browser/themes/theme_service.cc',
        'browser/themes/theme_service.h',
        'browser/themes/theme_service_factory.cc',
        'browser/themes/theme_service_factory.h',
        'browser/themes/theme_service_gtk.cc',
        'browser/themes/theme_service_mac.mm',
        'browser/translate/languages_menu_model.cc',
        'browser/translate/languages_menu_model.h',
        'browser/translate/options_menu_model.cc',
        'browser/translate/options_menu_model.h',
        'browser/translate/translate_infobar_delegate.cc',
        'browser/translate/translate_infobar_delegate.h',
        'browser/translate/translate_infobar_view.h',
        'browser/translate/translate_manager.cc',
        'browser/translate/translate_manager.h',
        'browser/translate/translate_prefs.cc',
        'browser/translate/translate_prefs.h',
        'browser/translate/translate_tab_helper.cc',
        'browser/translate/translate_tab_helper.h',
        'browser/transport_security_persister.cc',
        'browser/transport_security_persister.h',
        'browser/ui/app_modal_dialogs/app_modal_dialog.cc',
        'browser/ui/app_modal_dialogs/app_modal_dialog.h',
        'browser/ui/app_modal_dialogs/app_modal_dialog_queue.cc',
        'browser/ui/app_modal_dialogs/app_modal_dialog_queue.h',
        'browser/ui/app_modal_dialogs/js_modal_dialog.cc',
        'browser/ui/app_modal_dialogs/js_modal_dialog.h',
        'browser/ui/app_modal_dialogs/message_box_handler.cc',
        'browser/ui/app_modal_dialogs/message_box_handler.h',
        'browser/ui/app_modal_dialogs/native_app_modal_dialog.h',
        'browser/ui/blocked_content/blocked_content_container.cc',
        'browser/ui/blocked_content/blocked_content_container.h',
        'browser/ui/blocked_content/blocked_content_tab_helper.cc',
        'browser/ui/blocked_content/blocked_content_tab_helper.h',
        'browser/ui/blocked_content/blocked_content_tab_helper_delegate.cc',
        'browser/ui/blocked_content/blocked_content_tab_helper_delegate.h',
        'browser/ui/bookmarks/bookmark_tab_helper.cc',
        'browser/ui/bookmarks/bookmark_tab_helper.h',
        'browser/ui/bookmarks/bookmark_tab_helper_delegate.cc',
        'browser/ui/bookmarks/bookmark_tab_helper_delegate.h',
        'browser/ui/browser.cc',
        'browser/ui/browser.h',
        'browser/ui/browser_dialogs.h',
        'browser/ui/browser_init.cc',
        'browser/ui/browser_init.h',
        'browser/ui/browser_list.cc',
        'browser/ui/browser_list.h',
        'browser/ui/browser_list_gtk.cc',
        'browser/ui/browser_list_mac.mm',
        'browser/ui/browser_list_stub.cc',
        'browser/ui/browser_list_win.cc',
        'browser/ui/browser_navigator.cc',
        'browser/ui/browser_navigator.h',
        'browser/ui/browser_tab_restore_service_delegate.cc',
        'browser/ui/browser_tab_restore_service_delegate.h',
        'browser/ui/browser_window.h',
        'browser/ui/cocoa/about_ipc_controller.h',
        'browser/ui/cocoa/about_ipc_controller.mm',
        'browser/ui/cocoa/about_ipc_dialog.h',
        'browser/ui/cocoa/about_ipc_dialog.mm',
        'browser/ui/cocoa/about_window_controller.h',
        'browser/ui/cocoa/about_window_controller.mm',
        'browser/ui/cocoa/accelerators_cocoa.h',
        'browser/ui/cocoa/accelerators_cocoa.mm',
        'browser/ui/cocoa/animatable_image.h',
        'browser/ui/cocoa/animatable_image.mm',
        'browser/ui/cocoa/animatable_view.h',
        'browser/ui/cocoa/animatable_view.mm',
        'browser/ui/cocoa/applescript/bookmark_folder_applescript.h',
        'browser/ui/cocoa/applescript/bookmark_folder_applescript.mm',
        'browser/ui/cocoa/applescript/bookmark_item_applescript.h',
        'browser/ui/cocoa/applescript/bookmark_item_applescript.mm',
        'browser/ui/cocoa/applescript/bookmark_node_applescript.h',
        'browser/ui/cocoa/applescript/bookmark_node_applescript.mm',
        'browser/ui/cocoa/applescript/browsercrapplication+applescript.h',
        'browser/ui/cocoa/applescript/browsercrapplication+applescript.mm',
        'browser/ui/cocoa/applescript/constants_applescript.h',
        'browser/ui/cocoa/applescript/constants_applescript.mm',
        'browser/ui/cocoa/applescript/element_applescript.h',
        'browser/ui/cocoa/applescript/element_applescript.mm',
        'browser/ui/cocoa/applescript/error_applescript.h',
        'browser/ui/cocoa/applescript/error_applescript.mm',
        'browser/ui/cocoa/applescript/tab_applescript.h',
        'browser/ui/cocoa/applescript/tab_applescript.mm',
        'browser/ui/cocoa/applescript/window_applescript.h',
        'browser/ui/cocoa/applescript/window_applescript.mm',
        'browser/ui/cocoa/background_gradient_view.h',
        'browser/ui/cocoa/background_gradient_view.mm',
        'browser/ui/cocoa/background_tile_view.h',
        'browser/ui/cocoa/background_tile_view.mm',
        'browser/ui/cocoa/base_bubble_controller.h',
        'browser/ui/cocoa/base_bubble_controller.mm',
        'browser/ui/cocoa/base_view.h',
        'browser/ui/cocoa/base_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_bridge.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_bridge.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_constants.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_state.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_view.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_view.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bubble_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_bubble_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button.h',
        'browser/ui/cocoa/bookmarks/bookmark_button.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button_cell.h',
        'browser/ui/cocoa/bookmarks/bookmark_button_cell.mm',
        'browser/ui/cocoa/bookmarks/bookmark_drag_source.h',
        'browser/ui/cocoa/bookmarks/bookmark_drag_source.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_editor_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_folder_target.h',
        'browser/ui/cocoa/bookmarks/bookmark_folder_target.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu.h',
        'browser/ui/cocoa/bookmarks/bookmark_menu.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_bridge.h',
        'browser/ui/cocoa/bookmarks/bookmark_menu_bridge.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa.mm',
        'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa.h',
        'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller.h',
        'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller.mm',
        'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell.h',
        'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell.mm',
        'browser/ui/cocoa/browser_command_executor.h',
        'browser/ui/cocoa/browser_frame_view.h',
        'browser/ui/cocoa/browser_frame_view.mm',
        'browser/ui/cocoa/browser_window_cocoa.h',
        'browser/ui/cocoa/browser_window_cocoa.mm',
        'browser/ui/cocoa/browser_window_controller.h',
        'browser/ui/cocoa/browser_window_controller.mm',
        'browser/ui/cocoa/browser_window_controller_private.h',
        'browser/ui/cocoa/browser_window_controller_private.mm',
        'browser/ui/cocoa/browser_window_factory.mm',
        'browser/ui/cocoa/bubble_view.h',
        'browser/ui/cocoa/bubble_view.mm',
        'browser/ui/cocoa/bug_report_window_controller.h',
        'browser/ui/cocoa/bug_report_window_controller.mm',
        'browser/ui/cocoa/certificate_viewer.mm',
        'browser/ui/cocoa/chrome_browser_window.h',
        'browser/ui/cocoa/chrome_browser_window.mm',
        'browser/ui/cocoa/chrome_event_processing_window.h',
        'browser/ui/cocoa/chrome_event_processing_window.mm',
        'browser/ui/cocoa/clickhold_button_cell.h',
        'browser/ui/cocoa/clickhold_button_cell.mm',
        'browser/ui/cocoa/command_observer_bridge.h',
        'browser/ui/cocoa/command_observer_bridge.mm',
        'browser/ui/cocoa/confirm_quit_panel_controller.h',
        'browser/ui/cocoa/confirm_quit_panel_controller.mm',
        'browser/ui/cocoa/constrained_html_delegate_mac.mm',
        'browser/ui/cocoa/constrained_window_mac.h',
        'browser/ui/cocoa/constrained_window_mac.mm',
        'browser/ui/cocoa/content_settings/collected_cookies_mac.h',
        'browser/ui/cocoa/content_settings/collected_cookies_mac.mm',
        'browser/ui/cocoa/content_settings/content_setting_bubble_cocoa.h',
        'browser/ui/cocoa/content_settings/content_setting_bubble_cocoa.mm',
        'browser/ui/cocoa/content_settings/cookie_details.h',
        'browser/ui/cocoa/content_settings/cookie_details.mm',
        'browser/ui/cocoa/content_settings/cookie_details_view_controller.h',
        'browser/ui/cocoa/content_settings/cookie_details_view_controller.mm',
        'browser/ui/cocoa/content_settings/cookie_tree_node.h',
        'browser/ui/cocoa/content_settings/cookie_tree_node.mm',
        'browser/ui/cocoa/dev_tools_controller.h',
        'browser/ui/cocoa/dev_tools_controller.mm',
        'browser/ui/cocoa/dock_icon.h',
        'browser/ui/cocoa/dock_icon.mm',
        'browser/ui/cocoa/download/background_theme.h',
        'browser/ui/cocoa/download/background_theme.mm',
        'browser/ui/cocoa/download/download_item_button.h',
        'browser/ui/cocoa/download/download_item_button.mm',
        'browser/ui/cocoa/download/download_item_cell.h',
        'browser/ui/cocoa/download/download_item_cell.mm',
        'browser/ui/cocoa/download/download_item_controller.h',
        'browser/ui/cocoa/download/download_item_controller.mm',
        'browser/ui/cocoa/download/download_item_mac.h',
        'browser/ui/cocoa/download/download_item_mac.mm',
        'browser/ui/cocoa/download/download_shelf_controller.h',
        'browser/ui/cocoa/download/download_shelf_controller.mm',
        'browser/ui/cocoa/download/download_shelf_mac.h',
        'browser/ui/cocoa/download/download_shelf_mac.mm',
        'browser/ui/cocoa/download/download_shelf_view.h',
        'browser/ui/cocoa/download/download_shelf_view.mm',
        'browser/ui/cocoa/download/download_show_all_button.h',
        'browser/ui/cocoa/download/download_show_all_button.mm',
        'browser/ui/cocoa/download/download_show_all_cell.h',
        'browser/ui/cocoa/download/download_show_all_cell.mm',
        'browser/ui/cocoa/download/download_started_animation_mac.mm',
        'browser/ui/cocoa/download/download_util_mac.h',
        'browser/ui/cocoa/download/download_util_mac.mm',
        'browser/ui/cocoa/draggable_button.h',
        'browser/ui/cocoa/draggable_button.mm',
        'browser/ui/cocoa/drag_util.h',
        'browser/ui/cocoa/drag_util.mm',
        'browser/ui/cocoa/encoding_menu_controller_delegate_mac.h',
        'browser/ui/cocoa/encoding_menu_controller_delegate_mac.mm',
        'browser/ui/cocoa/event_utils.h',
        'browser/ui/cocoa/event_utils.mm',
        'browser/ui/cocoa/extensions/browser_action_button.h',
        'browser/ui/cocoa/extensions/browser_action_button.mm',
        'browser/ui/cocoa/extensions/browser_actions_container_view.h',
        'browser/ui/cocoa/extensions/browser_actions_container_view.mm',
        'browser/ui/cocoa/extensions/browser_actions_controller.h',
        'browser/ui/cocoa/extensions/browser_actions_controller.mm',
        'browser/ui/cocoa/extensions/chevron_menu_button.h',
        'browser/ui/cocoa/extensions/chevron_menu_button.mm',
        'browser/ui/cocoa/extensions/chevron_menu_button_cell.h',
        'browser/ui/cocoa/extensions/chevron_menu_button_cell.mm',
        'browser/ui/cocoa/extensions/extension_action_context_menu.h',
        'browser/ui/cocoa/extensions/extension_action_context_menu.mm',
        'browser/ui/cocoa/extensions/extension_infobar_controller.h',
        'browser/ui/cocoa/extensions/extension_infobar_controller.mm',
        'browser/ui/cocoa/extensions/extension_install_dialog_controller.h',
        'browser/ui/cocoa/extensions/extension_install_dialog_controller.mm',
        'browser/ui/cocoa/extensions/extension_installed_bubble_bridge.mm',
        'browser/ui/cocoa/extensions/extension_installed_bubble_controller.h',
        'browser/ui/cocoa/extensions/extension_installed_bubble_controller.mm',
        'browser/ui/cocoa/extensions/extension_popup_controller.h',
        'browser/ui/cocoa/extensions/extension_popup_controller.mm',
        'browser/ui/cocoa/extensions/extension_uninstall_dialog_cocoa.mm',
        'browser/ui/cocoa/extensions/extension_view_mac.h',
        'browser/ui/cocoa/extensions/extension_view_mac.mm',
        'browser/ui/cocoa/external_protocol_dialog.h',
        'browser/ui/cocoa/external_protocol_dialog.mm',
        'browser/ui/cocoa/fast_resize_view.h',
        'browser/ui/cocoa/fast_resize_view.mm',
        'browser/ui/cocoa/find_bar/find_bar_bridge.h',
        'browser/ui/cocoa/find_bar/find_bar_bridge.mm',
        'browser/ui/cocoa/find_bar/find_bar_cocoa_controller.h',
        'browser/ui/cocoa/find_bar/find_bar_cocoa_controller.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field.h',
        'browser/ui/cocoa/find_bar/find_bar_text_field.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field_cell.h',
        'browser/ui/cocoa/find_bar/find_bar_text_field_cell.mm',
        'browser/ui/cocoa/find_bar/find_bar_view.h',
        'browser/ui/cocoa/find_bar/find_bar_view.mm',
        'browser/ui/cocoa/find_pasteboard.h',
        'browser/ui/cocoa/find_pasteboard.mm',
        'browser/ui/cocoa/first_run_bubble_controller.h',
        'browser/ui/cocoa/first_run_bubble_controller.mm',
        'browser/ui/cocoa/first_run_dialog.h',
        'browser/ui/cocoa/first_run_dialog.mm',
        'browser/ui/cocoa/floating_bar_backing_view.h',
        'browser/ui/cocoa/floating_bar_backing_view.mm',
        'browser/ui/cocoa/focus_tracker.h',
        'browser/ui/cocoa/focus_tracker.mm',
        'browser/ui/cocoa/framed_browser_window.h',
        'browser/ui/cocoa/framed_browser_window.mm',
        'browser/ui/cocoa/fullscreen_controller.h',
        'browser/ui/cocoa/fullscreen_controller.mm',
        'browser/ui/cocoa/fullscreen_window.h',
        'browser/ui/cocoa/fullscreen_window.mm',
        'browser/ui/cocoa/gradient_button_cell.h',
        'browser/ui/cocoa/gradient_button_cell.mm',
        'browser/ui/cocoa/history_menu_bridge.h',
        'browser/ui/cocoa/history_menu_bridge.mm',
        'browser/ui/cocoa/history_menu_cocoa_controller.h',
        'browser/ui/cocoa/history_menu_cocoa_controller.mm',
        'browser/ui/cocoa/hover_button.h',
        'browser/ui/cocoa/hover_button.mm',
        'browser/ui/cocoa/hover_close_button.h',
        'browser/ui/cocoa/hover_close_button.mm',
        'browser/ui/cocoa/hover_image_button.h',
        'browser/ui/cocoa/hover_image_button.mm',
        'browser/ui/cocoa/html_dialog_window_controller.h',
        'browser/ui/cocoa/html_dialog_window_controller.mm',
        'browser/ui/cocoa/hung_renderer_controller.h',
        'browser/ui/cocoa/hung_renderer_controller.mm',
        'browser/ui/cocoa/hyperlink_button_cell.h',
        'browser/ui/cocoa/hyperlink_button_cell.mm',
        'browser/ui/cocoa/image_button_cell.h',
        'browser/ui/cocoa/image_button_cell.mm',
        'browser/ui/cocoa/image_utils.h',
        'browser/ui/cocoa/image_utils.mm',
        'browser/ui/cocoa/importer/import_lock_dialog_cocoa.mm',
        'browser/ui/cocoa/importer/import_progress_dialog_cocoa.h',
        'browser/ui/cocoa/importer/import_progress_dialog_cocoa.mm',
        'browser/ui/cocoa/info_bubble_view.h',
        'browser/ui/cocoa/info_bubble_view.mm',
        'browser/ui/cocoa/info_bubble_window.h',
        'browser/ui/cocoa/info_bubble_window.mm',
        'browser/ui/cocoa/infobars/infobar.h',
        'browser/ui/cocoa/infobars/infobar_container_controller.h',
        'browser/ui/cocoa/infobars/infobar_container_controller.mm',
        'browser/ui/cocoa/infobars/infobar_controller.h',
        'browser/ui/cocoa/infobars/infobar_controller.mm',
        'browser/ui/cocoa/infobars/infobar_gradient_view.h',
        'browser/ui/cocoa/infobars/infobar_gradient_view.mm',
        'browser/ui/cocoa/infobars/mock_confirm_infobar_delegate.cc',
        'browser/ui/cocoa/infobars/mock_confirm_infobar_delegate.h',
        'browser/ui/cocoa/infobars/mock_link_infobar_delegate.cc',
        'browser/ui/cocoa/infobars/mock_link_infobar_delegate.h',
        'browser/ui/cocoa/js_modal_dialog_cocoa.h',
        'browser/ui/cocoa/js_modal_dialog_cocoa.mm',
        'browser/ui/cocoa/keystone_infobar.h',
        'browser/ui/cocoa/keystone_infobar.mm',
        'browser/ui/cocoa/l10n_util.h',
        'browser/ui/cocoa/l10n_util.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_cell.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_cell.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_editor.h',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_editor.mm',
        'browser/ui/cocoa/location_bar/bubble_decoration.h',
        'browser/ui/cocoa/location_bar/bubble_decoration.mm',
        'browser/ui/cocoa/location_bar/content_setting_decoration.h',
        'browser/ui/cocoa/location_bar/content_setting_decoration.mm',
        'browser/ui/cocoa/location_bar/ev_bubble_decoration.h',
        'browser/ui/cocoa/location_bar/ev_bubble_decoration.mm',
        'browser/ui/cocoa/location_bar/image_decoration.h',
        'browser/ui/cocoa/location_bar/image_decoration.mm',
        'browser/ui/cocoa/location_bar/instant_opt_in_controller.h',
        'browser/ui/cocoa/location_bar/instant_opt_in_controller.mm',
        'browser/ui/cocoa/location_bar/instant_opt_in_view.h',
        'browser/ui/cocoa/location_bar/instant_opt_in_view.mm',
        'browser/ui/cocoa/location_bar/keyword_hint_decoration.h',
        'browser/ui/cocoa/location_bar/keyword_hint_decoration.mm',
        'browser/ui/cocoa/location_bar/location_bar_decoration.h',
        'browser/ui/cocoa/location_bar/location_bar_decoration.mm',
        'browser/ui/cocoa/location_bar/location_bar_view_mac.h',
        'browser/ui/cocoa/location_bar/location_bar_view_mac.mm',
        'browser/ui/cocoa/location_bar/location_icon_decoration.h',
        'browser/ui/cocoa/location_bar/location_icon_decoration.mm',
        'browser/ui/cocoa/location_bar/omnibox_popup_view.h',
        'browser/ui/cocoa/location_bar/omnibox_popup_view.mm',
        'browser/ui/cocoa/location_bar/page_action_decoration.h',
        'browser/ui/cocoa/location_bar/page_action_decoration.mm',
        'browser/ui/cocoa/location_bar/selected_keyword_decoration.h',
        'browser/ui/cocoa/location_bar/selected_keyword_decoration.mm',
        'browser/ui/cocoa/location_bar/star_decoration.h',
        'browser/ui/cocoa/location_bar/star_decoration.mm',
        'browser/ui/cocoa/menu_button.h',
        'browser/ui/cocoa/menu_button.mm',
        'browser/ui/cocoa/menu_controller.h',
        'browser/ui/cocoa/menu_controller.mm',
        'browser/ui/cocoa/multi_key_equivalent_button.h',
        'browser/ui/cocoa/multi_key_equivalent_button.mm',
        'browser/ui/cocoa/new_tab_button.h',
        'browser/ui/cocoa/new_tab_button.mm',
        'browser/ui/cocoa/notifications/balloon_controller.h',
        'browser/ui/cocoa/notifications/balloon_controller.mm',
        'browser/ui/cocoa/notifications/balloon_view.h',
        'browser/ui/cocoa/notifications/balloon_view.mm',
        'browser/ui/cocoa/notifications/balloon_view_bridge.h',
        'browser/ui/cocoa/notifications/balloon_view_bridge.mm',
        'browser/ui/cocoa/notifications/balloon_view_host_mac.h',
        'browser/ui/cocoa/notifications/balloon_view_host_mac.mm',
        'browser/ui/cocoa/nsmenuitem_additions.h',
        'browser/ui/cocoa/nsmenuitem_additions.mm',
        'browser/ui/cocoa/nsview_additions.h',
        'browser/ui/cocoa/nsview_additions.mm',
        'browser/ui/cocoa/objc_method_swizzle.h',
        'browser/ui/cocoa/objc_method_swizzle.mm',
        'browser/ui/cocoa/objc_zombie.h',
        'browser/ui/cocoa/objc_zombie.mm',
        'browser/ui/cocoa/omnibox/omnibox_view_mac.h',
        'browser/ui/cocoa/omnibox/omnibox_view_mac.mm',
        'browser/ui/cocoa/page_info_bubble_controller.h',
        'browser/ui/cocoa/page_info_bubble_controller.mm',
        'browser/ui/cocoa/profile_menu_button.h',
        'browser/ui/cocoa/profile_menu_button.mm',
        'browser/ui/cocoa/repost_form_warning_mac.h',
        'browser/ui/cocoa/repost_form_warning_mac.mm',
        'browser/ui/cocoa/restart_browser.h',
        'browser/ui/cocoa/restart_browser.mm',
        'browser/ui/cocoa/rwhvm_editcommand_helper.h',
        'browser/ui/cocoa/rwhvm_editcommand_helper.mm',
        'browser/ui/cocoa/search_engine_dialog_controller.h',
        'browser/ui/cocoa/search_engine_dialog_controller.mm',
        'browser/ui/cocoa/shell_dialogs_mac.mm',
        'browser/ui/cocoa/sidebar_controller.h',
        'browser/ui/cocoa/sidebar_controller.mm',
        'browser/ui/cocoa/speech_input_window_controller.h',
        'browser/ui/cocoa/speech_input_window_controller.mm',
        'browser/ui/cocoa/ssl_client_certificate_selector.mm',
        'browser/ui/cocoa/status_bubble_mac.h',
        'browser/ui/cocoa/status_bubble_mac.mm',
        'browser/ui/cocoa/status_icons/status_icon_mac.h',
        'browser/ui/cocoa/status_icons/status_icon_mac.mm',
        'browser/ui/cocoa/status_icons/status_tray_mac.h',
        'browser/ui/cocoa/status_icons/status_tray_mac.mm',
        'browser/ui/cocoa/styled_text_field.h',
        'browser/ui/cocoa/styled_text_field.mm',
        'browser/ui/cocoa/styled_text_field_cell.h',
        'browser/ui/cocoa/styled_text_field_cell.mm',
        'browser/ui/cocoa/tab_contents/favicon_util.h',
        'browser/ui/cocoa/tab_contents/favicon_util.mm',
        'browser/ui/cocoa/tab_contents/previewable_contents_controller.h',
        'browser/ui/cocoa/tab_contents/previewable_contents_controller.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_controller.h',
        'browser/ui/cocoa/tab_contents/sad_tab_controller.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_view.h',
        'browser/ui/cocoa/tab_contents/sad_tab_view.mm',
        'browser/ui/cocoa/tab_contents/tab_contents_controller.h',
        'browser/ui/cocoa/tab_contents/tab_contents_controller.mm',
        'browser/ui/cocoa/tab_contents/web_contents_drag_source.h',
        'browser/ui/cocoa/tab_contents/web_contents_drag_source.mm',
        'browser/ui/cocoa/tab_contents/web_drag_source.h',
        'browser/ui/cocoa/tab_contents/web_drag_source.mm',
        'browser/ui/cocoa/tab_contents/web_drop_target.h',
        'browser/ui/cocoa/tab_contents/web_drop_target.mm',
        'browser/ui/cocoa/tab_view_picker_table.h',
        'browser/ui/cocoa/tab_view_picker_table.mm',
        'browser/ui/cocoa/table_model_array_controller.h',
        'browser/ui/cocoa/table_model_array_controller.mm',
        'browser/ui/cocoa/table_row_nsimage_cache.h',
        'browser/ui/cocoa/table_row_nsimage_cache.mm',
        'browser/ui/cocoa/tabpose_window.h',
        'browser/ui/cocoa/tabpose_window.mm',
        'browser/ui/cocoa/tabs/side_tab_strip_controller.h',
        'browser/ui/cocoa/tabs/side_tab_strip_controller.mm',
        'browser/ui/cocoa/tabs/side_tab_strip_view.h',
        'browser/ui/cocoa/tabs/side_tab_strip_view.mm',
        'browser/ui/cocoa/tabs/tab_controller.h',
        'browser/ui/cocoa/tabs/tab_controller.mm',
        'browser/ui/cocoa/tabs/tab_strip_controller.h',
        'browser/ui/cocoa/tabs/tab_strip_controller.mm',
        'browser/ui/cocoa/tabs/tab_strip_model_observer_bridge.h',
        'browser/ui/cocoa/tabs/tab_strip_model_observer_bridge.mm',
        'browser/ui/cocoa/tabs/tab_strip_view.h',
        'browser/ui/cocoa/tabs/tab_strip_view.mm',
        'browser/ui/cocoa/tabs/tab_view.h',
        'browser/ui/cocoa/tabs/tab_view.mm',
        'browser/ui/cocoa/tabs/tab_window_controller.h',
        'browser/ui/cocoa/tabs/tab_window_controller.mm',
        'browser/ui/cocoa/tabs/throbber_view.h',
        'browser/ui/cocoa/tabs/throbber_view.mm',
        'browser/ui/cocoa/task_manager_mac.h',
        'browser/ui/cocoa/task_manager_mac.mm',
        'browser/ui/cocoa/theme_install_bubble_view.h',
        'browser/ui/cocoa/theme_install_bubble_view.mm',
        'browser/ui/cocoa/themed_window.h',
        'browser/ui/cocoa/themed_window.mm',
        'browser/ui/cocoa/toolbar/back_forward_menu_controller.h',
        'browser/ui/cocoa/toolbar/back_forward_menu_controller.mm',
        'browser/ui/cocoa/toolbar/reload_button.h',
        'browser/ui/cocoa/toolbar/reload_button.mm',
        'browser/ui/cocoa/toolbar/toolbar_button.h',
        'browser/ui/cocoa/toolbar/toolbar_button.mm',
        'browser/ui/cocoa/toolbar/toolbar_controller.h',
        'browser/ui/cocoa/toolbar/toolbar_controller.mm',
        'browser/ui/cocoa/toolbar/toolbar_view.h',
        'browser/ui/cocoa/toolbar/toolbar_view.mm',
        'browser/ui/cocoa/tracking_area.h',
        'browser/ui/cocoa/tracking_area.mm',
        'browser/ui/cocoa/translate/after_translate_infobar_controller.h',
        'browser/ui/cocoa/translate/after_translate_infobar_controller.mm',
        'browser/ui/cocoa/translate/before_translate_infobar_controller.h',
        'browser/ui/cocoa/translate/before_translate_infobar_controller.mm',
        'browser/ui/cocoa/translate/translate_infobar_base.h',
        'browser/ui/cocoa/translate/translate_infobar_base.mm',
        'browser/ui/cocoa/translate/translate_message_infobar_controller.h',
        'browser/ui/cocoa/translate/translate_message_infobar_controller.mm',
        'browser/ui/cocoa/ui_localizer.h',
        'browser/ui/cocoa/ui_localizer.mm',
        'browser/ui/cocoa/url_drop_target.h',
        'browser/ui/cocoa/url_drop_target.mm',
        'browser/ui/cocoa/vertical_gradient_view.h',
        'browser/ui/cocoa/vertical_gradient_view.mm',
        'browser/ui/cocoa/view_id_util.h',
        'browser/ui/cocoa/view_id_util.mm',
        'browser/ui/cocoa/view_resizer.h',
        'browser/ui/cocoa/window_size_autosaver.h',
        'browser/ui/cocoa/window_size_autosaver.mm',
        'browser/ui/cocoa/wrench_menu/menu_tracked_button.h',
        'browser/ui/cocoa/wrench_menu/menu_tracked_button.mm',
        'browser/ui/cocoa/wrench_menu/menu_tracked_root_view.h',
        'browser/ui/cocoa/wrench_menu/menu_tracked_root_view.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell.h',
        'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_controller.h',
        'browser/ui/cocoa/wrench_menu/wrench_menu_controller.mm',
        'browser/ui/collected_cookies_infobar_delegate.h',
        'browser/ui/collected_cookies_infobar_delegate.cc',
        'browser/ui/content_settings/content_setting_bubble_model.cc',
        'browser/ui/content_settings/content_setting_bubble_model.h',
        'browser/ui/content_settings/content_setting_combo_model.cc',
        'browser/ui/content_settings/content_setting_combo_model.h',
        'browser/ui/content_settings/content_setting_image_model.cc',
        'browser/ui/content_settings/content_setting_image_model.h',
        'browser/ui/crypto_module_password_dialog.h',
        'browser/ui/crypto_module_password_dialog_nss.cc',
        'browser/ui/crypto_module_password_dialog_openssl.cc',
        'browser/ui/download/download_tab_helper.cc',
        'browser/ui/download/download_tab_helper.h',
        'browser/ui/download/download_tab_helper_delegate.cc',
        'browser/ui/download/download_tab_helper_delegate.h',
        'browser/ui/find_bar/find_bar.h',
        'browser/ui/find_bar/find_bar_controller.cc',
        'browser/ui/find_bar/find_bar_controller.h',
        'browser/ui/find_bar/find_bar_state.cc',
        'browser/ui/find_bar/find_bar_state.h',
        'browser/ui/find_bar/find_notification_details.h',
        'browser/ui/find_bar/find_tab_helper.h',
        'browser/ui/find_bar/find_tab_helper.cc',
        'browser/ui/gtk/about_chrome_dialog.cc',
        'browser/ui/gtk/about_chrome_dialog.h',
        'browser/ui/gtk/accelerators_gtk.cc',
        'browser/ui/gtk/accelerators_gtk.h',
        'browser/ui/gtk/back_forward_button_gtk.cc',
        'browser/ui/gtk/back_forward_button_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_bar_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_bar_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_bar_instructions_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_bar_instructions_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_bubble_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_bubble_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_editor_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_editor_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_menu_controller_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_menu_controller_gtk.h',
        'browser/ui/gtk/bookmarks/bookmark_tree_model.cc',
        'browser/ui/gtk/bookmarks/bookmark_tree_model.h',
        'browser/ui/gtk/bookmarks/bookmark_utils_gtk.cc',
        'browser/ui/gtk/bookmarks/bookmark_utils_gtk.h',
        'browser/ui/gtk/browser_actions_toolbar_gtk.cc',
        'browser/ui/gtk/browser_actions_toolbar_gtk.h',
        'browser/ui/gtk/browser_titlebar.cc',
        'browser/ui/gtk/browser_titlebar.h',
        'browser/ui/gtk/browser_toolbar_gtk.cc',
        'browser/ui/gtk/browser_toolbar_gtk.h',
        'browser/ui/gtk/browser_window_factory_gtk.cc',
        'browser/ui/gtk/browser_window_gtk.cc',
        'browser/ui/gtk/browser_window_gtk.h',
        'browser/ui/gtk/bubble/bubble_accelerators_gtk.cc',
        'browser/ui/gtk/bubble/bubble_accelerators_gtk.h',
        'browser/ui/gtk/bubble/bubble_gtk.cc',
        'browser/ui/gtk/bubble/bubble_gtk.h',
        'browser/ui/gtk/cairo_cached_surface.cc',
        'browser/ui/gtk/cairo_cached_surface.h',
        'browser/ui/gtk/certificate_dialogs.cc',
        'browser/ui/gtk/certificate_dialogs.h',
        'browser/ui/gtk/certificate_viewer.cc',
        'browser/ui/gtk/certificate_viewer.h',
        'browser/ui/gtk/chrome_gtk_frame.cc',
        'browser/ui/gtk/chrome_gtk_frame.h',
        'browser/ui/gtk/collected_cookies_gtk.cc',
        'browser/ui/gtk/collected_cookies_gtk.h',
        'browser/ui/gtk/constrained_html_delegate_gtk.cc',
        'browser/ui/gtk/constrained_window_gtk.cc',
        'browser/ui/gtk/constrained_window_gtk.h',
        'browser/ui/gtk/content_setting_bubble_gtk.cc',
        'browser/ui/gtk/content_setting_bubble_gtk.h',
        'browser/ui/gtk/create_application_shortcuts_dialog_gtk.cc',
        'browser/ui/gtk/create_application_shortcuts_dialog_gtk.h',
        'browser/ui/gtk/crypto_module_password_dialog.cc',
        'browser/ui/gtk/custom_button.cc',
        'browser/ui/gtk/custom_button.h',
        'browser/ui/gtk/custom_drag.cc',
        'browser/ui/gtk/custom_drag.h',
        'browser/ui/gtk/dialogs_gtk.cc',
        'browser/ui/gtk/download/download_in_progress_dialog_gtk.cc',
        'browser/ui/gtk/download/download_in_progress_dialog_gtk.h',
        'browser/ui/gtk/download/download_item_gtk.cc',
        'browser/ui/gtk/download/download_item_gtk.h',
        'browser/ui/gtk/download/download_shelf_context_menu_gtk.cc',
        'browser/ui/gtk/download/download_shelf_context_menu_gtk.h',
        'browser/ui/gtk/download/download_shelf_gtk.cc',
        'browser/ui/gtk/download/download_shelf_gtk.h',
        'browser/ui/gtk/download/download_started_animation_gtk.cc',
        'browser/ui/gtk/edit_search_engine_dialog.cc',
        'browser/ui/gtk/edit_search_engine_dialog.h',
        'browser/ui/gtk/extensions/extension_install_dialog_gtk.cc',
        'browser/ui/gtk/extensions/extension_installed_bubble_gtk.cc',
        'browser/ui/gtk/extensions/extension_installed_bubble_gtk.h',
        'browser/ui/gtk/extensions/extension_popup_gtk.cc',
        'browser/ui/gtk/extensions/extension_popup_gtk.h',
        'browser/ui/gtk/extensions/extension_uninstall_dialog_gtk.cc',
        'browser/ui/gtk/extensions/extension_view_gtk.cc',
        'browser/ui/gtk/extensions/extension_view_gtk.h',
        'browser/ui/gtk/external_protocol_dialog_gtk.cc',
        'browser/ui/gtk/external_protocol_dialog_gtk.h',
        'browser/ui/gtk/find_bar_gtk.cc',
        'browser/ui/gtk/find_bar_gtk.h',
        'browser/ui/gtk/first_run_bubble.cc',
        'browser/ui/gtk/first_run_bubble.h',
        'browser/ui/gtk/first_run_dialog.cc',
        'browser/ui/gtk/first_run_dialog.h',
        'browser/ui/gtk/focus_store_gtk.cc',
        'browser/ui/gtk/focus_store_gtk.h',
        'browser/ui/gtk/fullscreen_exit_bubble_gtk.cc',
        'browser/ui/gtk/fullscreen_exit_bubble_gtk.h',
        'browser/ui/gtk/gconf_titlebar_listener.cc',
        'browser/ui/gtk/gconf_titlebar_listener.h',
        'browser/ui/gtk/global_bookmark_menu.cc',
        'browser/ui/gtk/global_bookmark_menu.h',
        'browser/ui/gtk/global_history_menu.cc',
        'browser/ui/gtk/global_history_menu.h',
        'browser/ui/gtk/global_menu_bar.cc',
        'browser/ui/gtk/global_menu_bar.h',
        'browser/ui/gtk/gtk_chrome_button.cc',
        'browser/ui/gtk/gtk_chrome_button.h',
        'browser/ui/gtk/gtk_chrome_cookie_view.cc',
        'browser/ui/gtk/gtk_chrome_cookie_view.h',
        'browser/ui/gtk/gtk_chrome_link_button.cc',
        'browser/ui/gtk/gtk_chrome_link_button.h',
        'browser/ui/gtk/gtk_chrome_shrinkable_hbox.cc',
        'browser/ui/gtk/gtk_chrome_shrinkable_hbox.h',
        'browser/ui/gtk/gtk_custom_menu.cc',
        'browser/ui/gtk/gtk_custom_menu.h',
        'browser/ui/gtk/gtk_custom_menu_item.cc',
        'browser/ui/gtk/gtk_custom_menu_item.h',
        'browser/ui/gtk/gtk_expanded_container.cc',
        'browser/ui/gtk/gtk_expanded_container.h',
        'browser/ui/gtk/gtk_floating_container.cc',
        'browser/ui/gtk/gtk_floating_container.h',
        'browser/ui/gtk/gtk_theme_service.cc',
        'browser/ui/gtk/gtk_theme_service.h',
        'browser/ui/gtk/gtk_tree.cc',
        'browser/ui/gtk/gtk_tree.h',
        'browser/ui/gtk/gtk_util.cc',
        'browser/ui/gtk/gtk_util.h',
        'browser/ui/gtk/hover_controller_gtk.cc',
        'browser/ui/gtk/hover_controller_gtk.h',
        'browser/ui/gtk/html_dialog_gtk.cc',
        'browser/ui/gtk/html_dialog_gtk.h',
        'browser/ui/gtk/hung_renderer_dialog_gtk.cc',
        'browser/ui/gtk/importer/import_lock_dialog_gtk.cc',
        'browser/ui/gtk/importer/import_lock_dialog_gtk.h',
        'browser/ui/gtk/importer/import_progress_dialog_gtk.cc',
        'browser/ui/gtk/importer/import_progress_dialog_gtk.h',
        'browser/ui/gtk/infobars/after_translate_infobar_gtk.cc',
        'browser/ui/gtk/infobars/after_translate_infobar_gtk.h',
        'browser/ui/gtk/infobars/before_translate_infobar_gtk.cc',
        'browser/ui/gtk/infobars/before_translate_infobar_gtk.h',
        'browser/ui/gtk/infobars/confirm_infobar_gtk.cc',
        'browser/ui/gtk/infobars/confirm_infobar_gtk.h',
        'browser/ui/gtk/infobars/extension_infobar_gtk.cc',
        'browser/ui/gtk/infobars/extension_infobar_gtk.h',
        'browser/ui/gtk/infobars/infobar_arrow_model.cc',
        'browser/ui/gtk/infobars/infobar_arrow_model.h',
        'browser/ui/gtk/infobars/infobar_container_gtk.cc',
        'browser/ui/gtk/infobars/infobar_container_gtk.h',
        'browser/ui/gtk/infobars/infobar_gtk.cc',
        'browser/ui/gtk/infobars/infobar_gtk.h',
        'browser/ui/gtk/infobars/link_infobar_gtk.cc',
        'browser/ui/gtk/infobars/link_infobar_gtk.h',
        'browser/ui/gtk/infobars/translate_infobar_base_gtk.cc',
        'browser/ui/gtk/infobars/translate_infobar_base_gtk.h',
        'browser/ui/gtk/infobars/translate_message_infobar_gtk.cc',
        'browser/ui/gtk/infobars/translate_message_infobar_gtk.h',
        'browser/ui/gtk/instant_confirm_dialog_gtk.cc',
        'browser/ui/gtk/instant_confirm_dialog_gtk.h',
        'browser/ui/gtk/js_modal_dialog_gtk.cc',
        'browser/ui/gtk/js_modal_dialog_gtk.h',
        'browser/ui/gtk/location_bar_view_gtk.cc',
        'browser/ui/gtk/location_bar_view_gtk.h',
        'browser/ui/gtk/menu_bar_helper.cc',
        'browser/ui/gtk/menu_bar_helper.h',
        'browser/ui/gtk/menu_gtk.cc',
        'browser/ui/gtk/menu_gtk.h',
        'browser/ui/gtk/nine_box.cc',
        'browser/ui/gtk/nine_box.h',
        'browser/ui/gtk/notifications/balloon_view_gtk.cc',
        'browser/ui/gtk/notifications/balloon_view_gtk.h',
        'browser/ui/gtk/notifications/balloon_view_host_gtk.cc',
        'browser/ui/gtk/notifications/balloon_view_host_gtk.h',
        'browser/ui/gtk/omnibox/omnibox_view_gtk.cc',
        'browser/ui/gtk/omnibox/omnibox_view_gtk.h',
        'browser/ui/gtk/overflow_button.cc',
        'browser/ui/gtk/overflow_button.h',
        'browser/ui/gtk/owned_widget_gtk.cc',
        'browser/ui/gtk/owned_widget_gtk.h',
        'browser/ui/gtk/page_info_bubble_gtk.cc',
        'browser/ui/gtk/process_singleton_dialog.cc',
        'browser/ui/gtk/process_singleton_dialog.h',
        'browser/ui/gtk/reload_button_gtk.cc',
        'browser/ui/gtk/reload_button_gtk.h',
        'browser/ui/gtk/repost_form_warning_gtk.cc',
        'browser/ui/gtk/repost_form_warning_gtk.h',
        'browser/ui/gtk/rounded_window.cc',
        'browser/ui/gtk/rounded_window.h',
        'browser/ui/gtk/sad_tab_gtk.cc',
        'browser/ui/gtk/sad_tab_gtk.h',
        'browser/ui/gtk/slide_animator_gtk.cc',
        'browser/ui/gtk/slide_animator_gtk.h',
        'browser/ui/gtk/ssl_client_certificate_selector.cc',
        'browser/ui/gtk/status_bubble_gtk.cc',
        'browser/ui/gtk/status_bubble_gtk.h',
        'browser/ui/gtk/status_icons/status_icon_gtk.cc',
        'browser/ui/gtk/status_icons/status_icon_gtk.h',
        'browser/ui/gtk/status_icons/status_tray_gtk.cc',
        'browser/ui/gtk/status_icons/status_tray_gtk.h',
        'browser/ui/gtk/tab_contents_container_gtk.cc',
        'browser/ui/gtk/tab_contents_container_gtk.h',
        'browser/ui/gtk/tab_contents_drag_source.cc',
        'browser/ui/gtk/tab_contents_drag_source.h',
        'browser/ui/gtk/tabs/dragged_tab_controller_gtk.cc',
        'browser/ui/gtk/tabs/dragged_tab_controller_gtk.h',
        'browser/ui/gtk/tabs/dragged_tab_gtk.cc',
        'browser/ui/gtk/tabs/dragged_tab_gtk.h',
        'browser/ui/gtk/tabs/tab_gtk.cc',
        'browser/ui/gtk/tabs/tab_gtk.h',
        'browser/ui/gtk/tabs/tab_renderer_gtk.cc',
        'browser/ui/gtk/tabs/tab_renderer_gtk.h',
        'browser/ui/gtk/tabs/tab_strip_gtk.cc',
        'browser/ui/gtk/tabs/tab_strip_gtk.h',
        'browser/ui/gtk/task_manager_gtk.cc',
        'browser/ui/gtk/task_manager_gtk.h',
        'browser/ui/gtk/theme_install_bubble_view_gtk.cc',
        'browser/ui/gtk/theme_install_bubble_view_gtk.h',
        'browser/ui/gtk/unity_service.cc',
        'browser/ui/gtk/unity_service.h',
        'browser/ui/gtk/update_recommended_dialog.cc',
        'browser/ui/gtk/update_recommended_dialog.h',
        'browser/ui/gtk/view_id_util.cc',
        'browser/ui/gtk/view_id_util.h',
        'browser/ui/input_window_dialog.h',
        'browser/ui/input_window_dialog_gtk.cc',
        'browser/ui/input_window_dialog_win.cc',
        'browser/ui/login/login_model.h',
        'browser/ui/login/login_prompt.cc',
        'browser/ui/login/login_prompt.h',
        'browser/ui/login/login_prompt_gtk.cc',
        'browser/ui/login/login_prompt_mac.h',
        'browser/ui/login/login_prompt_mac.mm',
        'browser/ui/login/login_prompt_ui.cc',
        'browser/ui/login/login_prompt_win.cc',
        'browser/ui/omnibox/location_bar.h',
        'browser/ui/omnibox/location_bar_util.cc',
        'browser/ui/omnibox/location_bar_util.h',
        'browser/ui/omnibox/omnibox_view.cc',
        'browser/ui/omnibox/omnibox_view.h',
        'browser/ui/options/options_util.cc',
        'browser/ui/options/options_util.h',
        'browser/ui/panels/about_panel_bubble.cc',
        'browser/ui/panels/about_panel_bubble.h',
        'browser/ui/panels/panel.cc',
        'browser/ui/panels/panel.h',
        'browser/ui/panels/panel_browser_frame_view.cc',
        'browser/ui/panels/panel_browser_frame_view.h',
        'browser/ui/panels/panel_browser_window_cocoa.h',
        'browser/ui/panels/panel_browser_window_cocoa.mm',
        'browser/ui/panels/panel_browser_window_gtk.cc',
        'browser/ui/panels/panel_browser_window_gtk.h',
        'browser/ui/panels/panel_browser_view.cc',
        'browser/ui/panels/panel_browser_view.h',
        'browser/ui/panels/panel_manager.cc',
        'browser/ui/panels/panel_manager.h',
        'browser/ui/panels/panel_window_controller_cocoa.h',
        'browser/ui/panels/panel_window_controller_cocoa.mm',
        'browser/ui/profile_error_dialog.cc',
        'browser/ui/profile_error_dialog.h',
        'browser/ui/profile_menu_model.cc',
        'browser/ui/profile_menu_model.h',
        'browser/ui/search_engines/edit_search_engine_controller.cc',
        'browser/ui/search_engines/edit_search_engine_controller.h',
        'browser/ui/search_engines/keyword_editor_controller.cc',
        'browser/ui/search_engines/keyword_editor_controller.h',
        'browser/ui/search_engines/search_engine_tab_helper.cc',
        'browser/ui/search_engines/search_engine_tab_helper.h',
        'browser/ui/search_engines/search_engine_tab_helper_delegate.cc',
        'browser/ui/search_engines/search_engine_tab_helper_delegate.h',
        'browser/ui/search_engines/template_url_fetcher_ui_callbacks.cc',
        'browser/ui/search_engines/template_url_fetcher_ui_callbacks.h',
        'browser/ui/search_engines/template_url_table_model.cc',
        'browser/ui/search_engines/template_url_table_model.h',
        'browser/ui/shell_dialogs.cc',
        'browser/ui/shell_dialogs.h',
        'browser/ui/status_bubble.h',
        'browser/ui/tab_contents/tab_contents_wrapper.cc',
        'browser/ui/tab_contents/tab_contents_wrapper.h',
        'browser/ui/tab_contents/tab_contents_wrapper_delegate.cc',
        'browser/ui/tab_contents/tab_contents_wrapper_delegate.h',
        'browser/ui/tabs/dock_info.cc',
        'browser/ui/tabs/dock_info.h',
        'browser/ui/tabs/dock_info_gtk.cc',
        'browser/ui/tabs/dock_info_mac.cc',
        'browser/ui/tabs/dock_info_win.cc',
        'browser/ui/tabs/hover_tab_selector.cc',
        'browser/ui/tabs/hover_tab_selector.h',
        'browser/ui/tabs/tab_menu_model.cc',
        'browser/ui/tabs/tab_menu_model.h',
        'browser/ui/toolbar/back_forward_menu_model.cc',
        'browser/ui/toolbar/back_forward_menu_model.h',
        'browser/ui/toolbar/encoding_menu_controller.cc',
        'browser/ui/toolbar/encoding_menu_controller.h',
        'browser/ui/toolbar/toolbar_model.cc',
        'browser/ui/toolbar/toolbar_model.h',
        'browser/ui/toolbar/wrench_menu_model.cc',
        'browser/ui/toolbar/wrench_menu_model.h',
        'browser/ui/touch/frame/browser_non_client_frame_view_factory_touch.cc',
        'browser/ui/touch/frame/keyboard_container_view.cc',
        'browser/ui/touch/frame/keyboard_container_view.h',
        'browser/ui/touch/frame/touch_browser_frame_view.cc',
        'browser/ui/touch/frame/touch_browser_frame_view.h',
        'browser/ui/touch/tabs/tab_strip_factory.cc',
        'browser/ui/touch/tabs/touch_tab.cc',
        'browser/ui/touch/tabs/touch_tab.h',
        'browser/ui/touch/tabs/touch_tab_strip.cc',
        'browser/ui/touch/tabs/touch_tab_strip.h',
        'browser/ui/view_ids.h',
        'browser/ui/views/about_chrome_view.cc',
        'browser/ui/views/about_chrome_view.h',
        'browser/ui/views/about_ipc_dialog.cc',
        'browser/ui/views/about_ipc_dialog.h',
        'browser/ui/views/accelerator_table_gtk.cc',
        'browser/ui/views/accelerator_table_gtk.h',
        'browser/ui/views/accessibility_event_router_views.cc',
        'browser/ui/views/accessibility_event_router_views.h',
        'browser/ui/views/accessible_pane_view.cc',
        'browser/ui/views/accessible_pane_view.h',
        'browser/ui/views/appcache_info_view.cc',
        'browser/ui/views/appcache_info_view.h',
        'browser/ui/views/autocomplete/autocomplete_popup_contents_view.cc',
        'browser/ui/views/autocomplete/autocomplete_popup_contents_view.h',
        'browser/ui/views/autocomplete/autocomplete_result_view.cc',
        'browser/ui/views/autocomplete/autocomplete_result_view.h',
        'browser/ui/views/autocomplete/autocomplete_result_view_model.h',
        'browser/ui/views/autocomplete/touch_autocomplete_popup_contents_view.cc',
        'browser/ui/views/autocomplete/touch_autocomplete_popup_contents_view.h',
        'browser/ui/views/bookmarks/bookmark_bar_instructions_view.cc',
        'browser/ui/views/bookmarks/bookmark_bar_instructions_view.h',
        'browser/ui/views/bookmarks/bookmark_bar_view.cc',
        'browser/ui/views/bookmarks/bookmark_bar_view.h',
        'browser/ui/views/bookmarks/bookmark_bubble_view.cc',
        'browser/ui/views/bookmarks/bookmark_bubble_view.h',
        'browser/ui/views/bookmarks/bookmark_context_menu.cc',
        'browser/ui/views/bookmarks/bookmark_context_menu.h',
        'browser/ui/views/bookmarks/bookmark_context_menu_controller_views.cc',
        'browser/ui/views/bookmarks/bookmark_context_menu_controller_views.h',
        'browser/ui/views/bookmarks/bookmark_editor_view.cc',
        'browser/ui/views/bookmarks/bookmark_editor_view.h',
        'browser/ui/views/bookmarks/bookmark_menu_controller_views.cc',
        'browser/ui/views/bookmarks/bookmark_menu_controller_views.h',
        'browser/ui/views/bookmarks/bookmark_menu_delegate.cc',
        'browser/ui/views/bookmarks/bookmark_menu_delegate.h',
        'browser/ui/views/browser_actions_container.cc',
        'browser/ui/views/browser_actions_container.h',
        'browser/ui/views/browser_bubble.cc',
        'browser/ui/views/browser_bubble.h',
        'browser/ui/views/browser_bubble_gtk.cc',
        'browser/ui/views/browser_bubble_win.cc',
        'browser/ui/views/browser_dialogs.h',
        'browser/ui/views/bubble/border_contents.cc',
        'browser/ui/views/bubble/border_contents.h',
        'browser/ui/views/bubble/border_widget_win.cc',
        'browser/ui/views/bubble/border_widget_win.h',
        'browser/ui/views/bubble/bubble.cc',
        'browser/ui/views/bubble/bubble.h',
        'browser/ui/views/bubble/bubble_border.cc',
        'browser/ui/views/bubble/bubble_border.h',
        'browser/ui/views/certificate_viewer_win.cc',
        'browser/ui/views/chrome_views_delegate.cc',
        'browser/ui/views/chrome_views_delegate.h',
        'browser/ui/views/collected_cookies_win.cc',
        'browser/ui/views/collected_cookies_win.h',
        'browser/ui/views/compact_nav/compact_location_bar_view.cc',
        'browser/ui/views/compact_nav/compact_location_bar_view.h',
        'browser/ui/views/compact_nav/compact_location_bar_view_host.cc',
        'browser/ui/views/compact_nav/compact_location_bar_view_host.h',
        'browser/ui/views/compact_nav/compact_navigation_bar.cc',
        'browser/ui/views/compact_nav/compact_navigation_bar.h',
        'browser/ui/views/compact_nav/compact_options_bar.cc',
        'browser/ui/views/compact_nav/compact_options_bar.h',
        'browser/ui/views/constrained_html_delegate_gtk.cc',
        'browser/ui/views/constrained_html_delegate_win.cc',
        'browser/ui/views/constrained_window_views.cc',
        'browser/ui/views/constrained_window_views.h',
        'browser/ui/views/content_setting_bubble_contents.cc',
        'browser/ui/views/content_setting_bubble_contents.h',
        'browser/ui/views/cookie_info_view.cc',
        'browser/ui/views/cookie_info_view.h',
        'browser/ui/views/create_application_shortcut_view.cc',
        'browser/ui/views/create_application_shortcut_view.h',
        'browser/ui/views/database_info_view.cc',
        'browser/ui/views/database_info_view.h',
        'browser/ui/views/database_open_info_view.cc',
        'browser/ui/views/database_open_info_view.h',
        'browser/ui/views/default_search_view.cc',
        'browser/ui/views/default_search_view.h',
        'browser/ui/views/detachable_toolbar_view.cc',
        'browser/ui/views/detachable_toolbar_view.h',
        'browser/ui/views/dialog_stubs_gtk.cc',
        'browser/ui/views/dom_view.cc',
        'browser/ui/views/dom_view.h',
        'browser/ui/views/download/download_in_progress_dialog_view.cc',
        'browser/ui/views/download/download_in_progress_dialog_view.h',
        'browser/ui/views/download/download_item_view.cc',
        'browser/ui/views/download/download_item_view.h',
        'browser/ui/views/download/download_shelf_context_menu_view.cc',
        'browser/ui/views/download/download_shelf_context_menu_view.h',
        'browser/ui/views/download/download_shelf_view.cc',
        'browser/ui/views/download/download_shelf_view.h',
        'browser/ui/views/download/download_started_animation_win.cc',
        'browser/ui/views/dropdown_bar_host.cc',
        'browser/ui/views/dropdown_bar_host.h',
        'browser/ui/views/dropdown_bar_host_delegate.h',
        'browser/ui/views/dropdown_bar_host_gtk.cc',
        'browser/ui/views/dropdown_bar_host_win.cc',
        'browser/ui/views/dropdown_bar_view.cc',
        'browser/ui/views/dropdown_bar_view.h',
        'browser/ui/views/edit_search_engine_dialog.cc',
        'browser/ui/views/edit_search_engine_dialog.h',
        'browser/ui/views/event_utils.cc',
        'browser/ui/views/event_utils.h',
        'browser/ui/views/extensions/browser_action_drag_data.cc',
        'browser/ui/views/extensions/browser_action_drag_data.h',
        'browser/ui/views/extensions/browser_action_overflow_menu_controller.cc',
        'browser/ui/views/extensions/browser_action_overflow_menu_controller.h',
        'browser/ui/views/extensions/extension_dialog.cc',
        'browser/ui/views/extensions/extension_dialog.h',
        'browser/ui/views/extensions/extension_install_dialog_view.cc',
        'browser/ui/views/extensions/extension_installed_bubble.cc',
        'browser/ui/views/extensions/extension_installed_bubble.h',
        'browser/ui/views/extensions/extension_popup.cc',
        'browser/ui/views/extensions/extension_popup.h',
        'browser/ui/views/extensions/extension_uninstall_dialog_view.cc',
        'browser/ui/views/extensions/extension_view.cc',
        'browser/ui/views/extensions/extension_view.h',
        'browser/ui/views/external_protocol_dialog.cc',
        'browser/ui/views/external_protocol_dialog.h',
        'browser/ui/views/file_manager_dialogs.cc',
        'browser/ui/views/find_bar_host.cc',
        'browser/ui/views/find_bar_host.h',
        'browser/ui/views/find_bar_host_gtk.cc',
        'browser/ui/views/find_bar_host_win.cc',
        'browser/ui/views/find_bar_view.cc',
        'browser/ui/views/find_bar_view.h',
        'browser/ui/views/first_run_bubble.cc',
        'browser/ui/views/first_run_bubble.h',
        'browser/ui/views/first_run_search_engine_view.cc',
        'browser/ui/views/first_run_search_engine_view.h',
        'browser/ui/views/frame/app_panel_browser_frame_view.cc',
        'browser/ui/views/frame/app_panel_browser_frame_view.h',
        'browser/ui/views/frame/browser_bubble_host.cc',
        'browser/ui/views/frame/browser_bubble_host.h',
        'browser/ui/views/frame/browser_frame.cc',
        'browser/ui/views/frame/browser_frame.h',
        'browser/ui/views/frame/browser_frame_gtk.cc',
        'browser/ui/views/frame/browser_frame_gtk.h',
        'browser/ui/views/frame/browser_frame_win.cc',
        'browser/ui/views/frame/browser_frame_win.h',
        'browser/ui/views/frame/browser_non_client_frame_view.h',
        'browser/ui/views/frame/browser_non_client_frame_view_factory_gtk.cc',
        'browser/ui/views/frame/browser_non_client_frame_view_factory_win.cc',
        'browser/ui/views/frame/browser_root_view.cc',
        'browser/ui/views/frame/browser_root_view.h',
        'browser/ui/views/frame/browser_view.cc',
        'browser/ui/views/frame/browser_view.h',
        'browser/ui/views/frame/browser_view_layout.cc',
        'browser/ui/views/frame/browser_view_layout.h',
        'browser/ui/views/frame/contents_container.cc',
        'browser/ui/views/frame/contents_container.h',
        'browser/ui/views/frame/glass_browser_frame_view.cc',
        'browser/ui/views/frame/glass_browser_frame_view.h',
        'browser/ui/views/frame/native_browser_frame.h',
        'browser/ui/views/frame/native_browser_frame_delegate.h',
        'browser/ui/views/frame/opaque_browser_frame_view.cc',
        'browser/ui/views/frame/opaque_browser_frame_view.h',
        'browser/ui/views/frame/popup_non_client_frame_view.cc',
        'browser/ui/views/frame/popup_non_client_frame_view.h',
        'browser/ui/views/fullscreen_exit_bubble.cc',
        'browser/ui/views/fullscreen_exit_bubble.h',
        'browser/ui/views/generic_info_view.cc',
        'browser/ui/views/generic_info_view.h',
        'browser/ui/views/handle_web_keyboard_event_gtk.h',
        'browser/ui/views/handle_web_keyboard_event_gtk.cc',
        'browser/ui/views/html_dialog_view.cc',
        'browser/ui/views/html_dialog_view.h',
        'browser/ui/views/hung_renderer_view.cc',
        'browser/ui/views/importer/import_lock_dialog_view.cc',
        'browser/ui/views/importer/import_lock_dialog_view.h',
        'browser/ui/views/importer/import_progress_dialog_view.cc',
        'browser/ui/views/importer/import_progress_dialog_view.h',
        'browser/ui/views/indexed_db_info_view.cc',
        'browser/ui/views/indexed_db_info_view.h',
        'browser/ui/views/infobars/after_translate_infobar.cc',
        'browser/ui/views/infobars/after_translate_infobar.h',
        'browser/ui/views/infobars/before_translate_infobar.cc',
        'browser/ui/views/infobars/before_translate_infobar.h',
        'browser/ui/views/infobars/confirm_infobar.cc',
        'browser/ui/views/infobars/confirm_infobar.h',
        'browser/ui/views/infobars/extension_infobar.cc',
        'browser/ui/views/infobars/extension_infobar.h',
        'browser/ui/views/infobars/infobar_background.cc',
        'browser/ui/views/infobars/infobar_background.h',
        'browser/ui/views/infobars/infobar_button_border.cc',
        'browser/ui/views/infobars/infobar_button_border.h',
        'browser/ui/views/infobars/infobar_container_view.cc',
        'browser/ui/views/infobars/infobar_container_view.h',
        'browser/ui/views/infobars/infobar_view.cc',
        'browser/ui/views/infobars/infobar_view.h',
        'browser/ui/views/infobars/link_infobar.cc',
        'browser/ui/views/infobars/link_infobar.h',
        'browser/ui/views/infobars/translate_infobar_base.cc',
        'browser/ui/views/infobars/translate_infobar_base.h',
        'browser/ui/views/infobars/translate_message_infobar.cc',
        'browser/ui/views/infobars/translate_message_infobar.h',
        'browser/ui/views/instant_confirm_view.cc',
        'browser/ui/views/instant_confirm_view.h',
        'browser/ui/views/js_modal_dialog_views.cc',
        'browser/ui/views/js_modal_dialog_views.h',
        'browser/ui/views/keyboard_overlay_delegate.cc',
        'browser/ui/views/keyboard_overlay_delegate.h',
        'browser/ui/views/keyboard_overlay_dialog_view.cc',
        'browser/ui/views/keyboard_overlay_dialog_view.h',
        'browser/ui/views/local_storage_info_view.cc',
        'browser/ui/views/local_storage_info_view.h',
        'browser/ui/views/local_storage_set_item_info_view.cc',
        'browser/ui/views/local_storage_set_item_info_view.h',
        'browser/ui/views/location_bar/click_handler.cc',
        'browser/ui/views/location_bar/click_handler.h',
        'browser/ui/views/location_bar/content_setting_image_view.cc',
        'browser/ui/views/location_bar/content_setting_image_view.h',
        'browser/ui/views/location_bar/ev_bubble_view.cc',
        'browser/ui/views/location_bar/ev_bubble_view.h',
        'browser/ui/views/location_bar/icon_label_bubble_view.cc',
        'browser/ui/views/location_bar/icon_label_bubble_view.h',
        'browser/ui/views/location_bar/keyword_hint_view.cc',
        'browser/ui/views/location_bar/keyword_hint_view.h',
        'browser/ui/views/location_bar/location_bar_view.cc',
        'browser/ui/views/location_bar/location_bar_view.h',
        'browser/ui/views/location_bar/location_icon_view.cc',
        'browser/ui/views/location_bar/location_icon_view.h',
        'browser/ui/views/location_bar/page_action_image_view.cc',
        'browser/ui/views/location_bar/page_action_image_view.h',
        'browser/ui/views/location_bar/page_action_with_badge_view.cc',
        'browser/ui/views/location_bar/page_action_with_badge_view.h',
        'browser/ui/views/location_bar/selected_keyword_view.cc',
        'browser/ui/views/location_bar/selected_keyword_view.h',
        'browser/ui/views/location_bar/star_view.cc',
        'browser/ui/views/location_bar/star_view.h',
        'browser/ui/views/location_bar/suggested_text_view.cc',
        'browser/ui/views/location_bar/suggested_text_view.h',
        'browser/ui/views/login_view.cc',
        'browser/ui/views/login_view.h',
        'browser/ui/views/native_constrained_window_win.cc',
        'browser/ui/views/notifications/balloon_view.cc',
        'browser/ui/views/notifications/balloon_view.h',
        'browser/ui/views/notifications/balloon_view_host.cc',
        'browser/ui/views/notifications/balloon_view_host.h',
        'browser/ui/views/omnibox/omnibox_view_views.cc',
        'browser/ui/views/omnibox/omnibox_view_views.h',
        'browser/ui/views/omnibox/omnibox_view_win.cc',
        'browser/ui/views/omnibox/omnibox_view_win.h',
        'browser/ui/views/page_info_bubble_view.cc',
        'browser/ui/views/page_info_bubble_view.h',
        'browser/ui/views/pinned_contents_info_bubble.cc',
        'browser/ui/views/pinned_contents_info_bubble.h',
        'browser/ui/views/profile_menu_button.cc',
        'browser/ui/views/profile_menu_button.h',
        'browser/ui/views/profile_tag_view.cc',
        'browser/ui/views/profile_tag_view.h',
        'browser/ui/views/reload_button.cc',
        'browser/ui/views/reload_button.h',
        'browser/ui/views/repost_form_warning_view.cc',
        'browser/ui/views/repost_form_warning_view.h',
        'browser/ui/views/restart_message_box.cc',
        'browser/ui/views/restart_message_box.h',
        'browser/ui/views/sad_tab_view.cc',
        'browser/ui/views/sad_tab_view.h',
        'browser/ui/views/select_file_dialog.cc',
        'browser/ui/views/shell_dialogs_win.cc',
        'browser/ui/views/ssl_client_certificate_selector_win.cc',
        'browser/ui/views/status_bubble_views.cc',
        'browser/ui/views/status_bubble_views.h',
        'browser/ui/views/status_icons/status_icon_win.cc',
        'browser/ui/views/status_icons/status_icon_win.h',
        'browser/ui/views/status_icons/status_tray_gtk.cc',
        'browser/ui/views/status_icons/status_tray_win.cc',
        'browser/ui/views/status_icons/status_tray_win.h',
        'browser/ui/views/tab_contents/native_tab_contents_container.h',
        'browser/ui/views/tab_contents/native_tab_contents_container_gtk.cc',
        'browser/ui/views/tab_contents/native_tab_contents_container_gtk.h',
        'browser/ui/views/tab_contents/native_tab_contents_container_win.cc',
        'browser/ui/views/tab_contents/native_tab_contents_container_win.h',
        'browser/ui/views/tab_contents/native_tab_contents_view.h',
        'browser/ui/views/tab_contents/native_tab_contents_view_delegate.h',
        'browser/ui/views/tab_contents/native_tab_contents_view_gtk.cc',
        'browser/ui/views/tab_contents/native_tab_contents_view_gtk.h',
        'browser/ui/views/tab_contents/native_tab_contents_view_win.cc',
        'browser/ui/views/tab_contents/native_tab_contents_view_win.h',
        'browser/ui/views/tab_contents/render_view_context_menu_views.cc',
        'browser/ui/views/tab_contents/render_view_context_menu_views.h',
        'browser/ui/views/tab_contents/tab_contents_container.cc',
        'browser/ui/views/tab_contents/tab_contents_container.h',
        'browser/ui/views/tab_contents/tab_contents_container_native.cc',
        'browser/ui/views/tab_contents/tab_contents_container_native.h',
        'browser/ui/views/tab_contents/tab_contents_container_views.cc',
        'browser/ui/views/tab_contents/tab_contents_container_views.h',
        'browser/ui/views/tab_contents/tab_contents_drag_win.cc',
        'browser/ui/views/tab_contents/tab_contents_drag_win.h',
        'browser/ui/views/tab_contents/tab_contents_view_touch.cc',
        'browser/ui/views/tab_contents/tab_contents_view_touch.h',
        'browser/ui/views/tab_contents/tab_contents_view_views.cc',
        'browser/ui/views/tab_contents/tab_contents_view_views.h',
        'browser/ui/views/tab_icon_view.cc',
        'browser/ui/views/tab_icon_view.h',
        'browser/ui/views/tabs/abstract_tab_strip_view.h',
        'browser/ui/views/tabs/base_tab.cc',
        'browser/ui/views/tabs/base_tab.h',
        'browser/ui/views/tabs/base_tab_strip.cc',
        'browser/ui/views/tabs/base_tab_strip.h',
        'browser/ui/views/tabs/browser_tab_strip_controller.cc',
        'browser/ui/views/tabs/browser_tab_strip_controller.h',
        'browser/ui/views/tabs/dragged_tab_controller.cc',
        'browser/ui/views/tabs/dragged_tab_controller.h',
        'browser/ui/views/tabs/dragged_tab_view.cc',
        'browser/ui/views/tabs/dragged_tab_view.h',
        'browser/ui/views/tabs/native_view_photobooth.h',
        'browser/ui/views/tabs/native_view_photobooth_gtk.cc',
        'browser/ui/views/tabs/native_view_photobooth_gtk.h',
        'browser/ui/views/tabs/native_view_photobooth_win.cc',
        'browser/ui/views/tabs/native_view_photobooth_win.h',
        'browser/ui/views/tabs/side_tab.cc',
        'browser/ui/views/tabs/side_tab.h',
        'browser/ui/views/tabs/side_tab_strip.cc',
        'browser/ui/views/tabs/side_tab_strip.h',
        'browser/ui/views/tabs/tab.cc',
        'browser/ui/views/tabs/tab.h',
        'browser/ui/views/tabs/tab_controller.h',
        'browser/ui/views/tabs/tab_renderer_data.cc',
        'browser/ui/views/tabs/tab_renderer_data.h',
        'browser/ui/views/tabs/tab_strip.cc',
        'browser/ui/views/tabs/tab_strip.h',
        'browser/ui/views/tabs/tab_strip_controller.h',
        'browser/ui/views/tabs/tab_strip_factory.cc',
        'browser/ui/views/tabs/tab_strip_factory.h',
        'browser/ui/views/task_manager_view.cc',
        'browser/ui/views/textfield_views.cc',
        'browser/ui/views/textfield_views.h',
        'browser/ui/views/theme_background.cc',
        'browser/ui/views/theme_background.h',
        'browser/ui/views/theme_helpers.cc',
        'browser/ui/views/theme_helpers.h',
        'browser/ui/views/theme_install_bubble_view.cc',
        'browser/ui/views/theme_install_bubble_view.h',
        'browser/ui/views/toolbar_view.cc',
        'browser/ui/views/toolbar_view.h',
        'browser/ui/views/unhandled_keyboard_event_handler.cc',
        'browser/ui/views/unhandled_keyboard_event_handler.h',
        'browser/ui/views/uninstall_view.cc',
        'browser/ui/views/uninstall_view.h',
        'browser/ui/views/update_recommended_message_box.cc',
        'browser/ui/views/update_recommended_message_box.h',
        'browser/ui/views/user_data_dir_dialog.cc',
        'browser/ui/views/user_data_dir_dialog.h',
        'browser/ui/views/window.cc',
        'browser/ui/views/window.h',
        'browser/ui/views/wrench_menu.cc',
        'browser/ui/views/wrench_menu.h',
        'browser/ui/web_applications/web_app_ui.cc',
        'browser/ui/web_applications/web_app_ui.h',
        'browser/ui/webui/bookmarks_ui.cc',
        'browser/ui/webui/bookmarks_ui.h',
        'browser/ui/webui/bug_report_ui.cc',
        'browser/ui/webui/bug_report_ui.h',
        'browser/ui/webui/chrome_url_data_manager_backend.cc',
        'browser/ui/webui/chrome_url_data_manager_backend.h',
        'browser/ui/webui/chrome_url_data_manager.cc',
        'browser/ui/webui/chrome_url_data_manager.h',
        'browser/ui/webui/chrome_web_ui_data_source.cc',
        'browser/ui/webui/chrome_web_ui_data_source.h',
        'browser/ui/webui/chrome_web_ui_factory.cc',
        'browser/ui/webui/chrome_web_ui_factory.h',
        'browser/ui/webui/chromeos/choose_mobile_network_ui.cc',
        'browser/ui/webui/chromeos/choose_mobile_network_ui.h',
        'browser/ui/webui/chromeos/enterprise_enrollment_ui.cc',
        'browser/ui/webui/chromeos/enterprise_enrollment_ui.h',
        'browser/ui/webui/chromeos/imageburner_ui.cc',
        'browser/ui/webui/chromeos/imageburner_ui.h',
        'browser/ui/webui/chromeos/keyboard_overlay_ui.cc',
        'browser/ui/webui/chromeos/keyboard_overlay_ui.h',
        'browser/ui/webui/chromeos/login/oobe_ui.cc',
        'browser/ui/webui/chromeos/login/oobe_ui.h',
        'browser/ui/webui/chromeos/login/login_ui.cc',
        'browser/ui/webui/chromeos/login/login_ui.h',
        'browser/ui/webui/chromeos/login/login_ui_helpers.cc',
        'browser/ui/webui/chromeos/login/login_ui_helpers.h',
        'browser/ui/webui/chromeos/mobile_setup_ui.cc',
        'browser/ui/webui/chromeos/mobile_setup_ui.h',
        'browser/ui/webui/chromeos/proxy_settings_ui.cc',
        'browser/ui/webui/chromeos/proxy_settings_ui.h',
        'browser/ui/webui/chromeos/register_page_ui.cc',
        'browser/ui/webui/chromeos/register_page_ui.h',
        'browser/ui/webui/chromeos/sim_unlock_ui.cc',
        'browser/ui/webui/chromeos/sim_unlock_ui.h',
        'browser/ui/webui/chromeos/system_info_ui.cc',
        'browser/ui/webui/chromeos/system_info_ui.h',
        'browser/ui/webui/collected_cookies_ui_delegate.cc',
        'browser/ui/webui/collected_cookies_ui_delegate.h',
        'browser/ui/webui/constrained_html_ui.cc',
        'browser/ui/webui/constrained_html_ui.h',
        'browser/ui/webui/cookies_tree_model_adapter.cc',
        'browser/ui/webui/cookies_tree_model_adapter.h',
        'browser/ui/webui/cookies_tree_model_util.cc',
        'browser/ui/webui/cookies_tree_model_util.h',
        'browser/ui/webui/crashes_ui.cc',
        'browser/ui/webui/crashes_ui.h',
        'browser/ui/webui/devtools_ui.cc',
        'browser/ui/webui/devtools_ui.h',
        'browser/ui/webui/downloads_dom_handler.cc',
        'browser/ui/webui/downloads_dom_handler.h',
        'browser/ui/webui/downloads_ui.cc',
        'browser/ui/webui/downloads_ui.h',
        'browser/ui/webui/active_downloads_ui.cc',
        'browser/ui/webui/active_downloads_ui.h',
        'browser/ui/webui/extension_icon_source.cc',
        'browser/ui/webui/extension_icon_source.h',
        'browser/ui/webui/favicon_source.cc',
        'browser/ui/webui/favicon_source.h',
        'browser/ui/webui/fileicon_source.cc',
        'browser/ui/webui/fileicon_source.h',
        'browser/ui/webui/fileicon_source_cros.h',
        'browser/ui/webui/fileicon_source_cros.cc',
        'browser/ui/webui/flags_ui.cc',
        'browser/ui/webui/flags_ui.h',
        'browser/ui/webui/flash_ui.cc',
        'browser/ui/webui/flash_ui.h',
        'browser/ui/webui/gpu_internals_ui.cc',
        'browser/ui/webui/gpu_internals_ui.h',
        'browser/ui/webui/history2_ui.cc',
        'browser/ui/webui/history2_ui.h',
        'browser/ui/webui/history_ui.cc',
        'browser/ui/webui/history_ui.h',
        'browser/ui/webui/html_dialog_tab_contents_delegate.cc',
        'browser/ui/webui/html_dialog_tab_contents_delegate.h',
        'browser/ui/webui/html_dialog_ui.cc',
        'browser/ui/webui/html_dialog_ui.h',
        'browser/ui/webui/keyboard_ui.cc',
        'browser/ui/webui/keyboard_ui.h',
        'browser/ui/webui/net_internals_ui.cc',
        'browser/ui/webui/net_internals_ui.h',
        'browser/ui/webui/ntp/app_launcher_handler.cc',
        'browser/ui/webui/ntp/app_launcher_handler.h',
        'browser/ui/webui/ntp/foreign_session_handler.cc',
        'browser/ui/webui/ntp/foreign_session_handler.h',
        'browser/ui/webui/ntp/most_visited_handler.cc',
        'browser/ui/webui/ntp/most_visited_handler.h',
        'browser/ui/webui/ntp/new_tab_page_sync_handler.cc',
        'browser/ui/webui/ntp/new_tab_page_sync_handler.h',
        'browser/ui/webui/ntp/new_tab_ui.cc',
        'browser/ui/webui/ntp/new_tab_ui.h',
        'browser/ui/webui/ntp/ntp_login_handler.cc',
        'browser/ui/webui/ntp/ntp_login_handler.h',
        'browser/ui/webui/ntp/ntp_resource_cache.cc',
        'browser/ui/webui/ntp/ntp_resource_cache.h',
        'browser/ui/webui/ntp/shown_sections_handler.cc',
        'browser/ui/webui/ntp/shown_sections_handler.h',
        'browser/ui/webui/ntp/thumbnail_source.cc',
        'browser/ui/webui/ntp/thumbnail_source.h',
        'browser/ui/webui/ntp/value_helper.cc',
        'browser/ui/webui/ntp/value_helper.h',
        'browser/ui/webui/options/about_page_handler.cc',
        'browser/ui/webui/options/about_page_handler.h',
        'browser/ui/webui/options/advanced_options_handler.cc',
        'browser/ui/webui/options/advanced_options_handler.h',
        'browser/ui/webui/options/advanced_options_utils.h',
        'browser/ui/webui/options/advanced_options_utils_gtk.cc',
        'browser/ui/webui/options/advanced_options_utils_mac.mm',
        'browser/ui/webui/options/advanced_options_utils_win.cc',
        'browser/ui/webui/options/autofill_options_handler.cc',
        'browser/ui/webui/options/autofill_options_handler.h',
        'browser/ui/webui/options/browser_options_handler.cc',
        'browser/ui/webui/options/browser_options_handler.h',
        'browser/ui/webui/options/certificate_manager_handler.cc',
        'browser/ui/webui/options/certificate_manager_handler.h',
        'browser/ui/webui/options/chromeos/accounts_options_handler.cc',
        'browser/ui/webui/options/chromeos/accounts_options_handler.h',
        'browser/ui/webui/options/chromeos/change_picture_options_handler.cc',
        'browser/ui/webui/options/chromeos/change_picture_options_handler.h',
        'browser/ui/webui/options/chromeos/core_chromeos_options_handler.cc',
        'browser/ui/webui/options/chromeos/core_chromeos_options_handler.h',
        'browser/ui/webui/options/chromeos/cros_language_options_handler.cc',
        'browser/ui/webui/options/chromeos/cros_language_options_handler.h',
        'browser/ui/webui/options/chromeos/cros_options_page_ui_handler.cc',
        'browser/ui/webui/options/chromeos/cros_options_page_ui_handler.h',
        'browser/ui/webui/options/chromeos/internet_options_handler.cc',
        'browser/ui/webui/options/chromeos/internet_options_handler.h',
        'browser/ui/webui/options/chromeos/language_chewing_handler.cc',
        'browser/ui/webui/options/chromeos/language_chewing_handler.h',
        'browser/ui/webui/options/chromeos/language_customize_modifier_keys_handler.cc',
        'browser/ui/webui/options/chromeos/language_customize_modifier_keys_handler.h',
        'browser/ui/webui/options/chromeos/language_hangul_handler.cc',
        'browser/ui/webui/options/chromeos/language_hangul_handler.h',
        'browser/ui/webui/options/chromeos/language_mozc_handler.cc',
        'browser/ui/webui/options/chromeos/language_mozc_handler.h',
        'browser/ui/webui/options/chromeos/language_options_util.cc',
        'browser/ui/webui/options/chromeos/language_options_util.h',
        'browser/ui/webui/options/chromeos/language_pinyin_handler.cc',
        'browser/ui/webui/options/chromeos/language_pinyin_handler.h',
        'browser/ui/webui/options/chromeos/proxy_handler.cc',
        'browser/ui/webui/options/chromeos/proxy_handler.h',
        'browser/ui/webui/options/chromeos/stats_options_handler.cc',
        'browser/ui/webui/options/chromeos/stats_options_handler.h',
        'browser/ui/webui/options/chromeos/system_options_handler.cc',
        'browser/ui/webui/options/chromeos/system_options_handler.h',
        'browser/ui/webui/options/chromeos/system_settings_provider.cc',
        'browser/ui/webui/options/chromeos/system_settings_provider.h',
        'browser/ui/webui/options/chromeos/user_image_source.cc',
        'browser/ui/webui/options/chromeos/user_image_source.h',
        'browser/ui/webui/options/clear_browser_data_handler.cc',
        'browser/ui/webui/options/clear_browser_data_handler.h',
        'browser/ui/webui/options/content_settings_handler.cc',
        'browser/ui/webui/options/content_settings_handler.h',
        'browser/ui/webui/options/cookies_view_handler.cc',
        'browser/ui/webui/options/cookies_view_handler.h',
        'browser/ui/webui/options/core_options_handler.cc',
        'browser/ui/webui/options/core_options_handler.h',
        'browser/ui/webui/options/font_settings_handler.cc',
        'browser/ui/webui/options/font_settings_handler.h',
        'browser/ui/webui/options/font_settings_utils.h',
        'browser/ui/webui/options/font_settings_utils_gtk.cc',
        'browser/ui/webui/options/font_settings_utils_mac.mm',
        'browser/ui/webui/options/font_settings_utils_win.cc',
        'browser/ui/webui/options/import_data_handler.cc',
        'browser/ui/webui/options/import_data_handler.h',
        'browser/ui/webui/options/language_options_handler.cc',
        'browser/ui/webui/options/language_options_handler.h',
        'browser/ui/webui/options/language_options_handler_common.cc',
        'browser/ui/webui/options/language_options_handler_common.h',
        'browser/ui/webui/options/options_managed_banner_handler.cc',
        'browser/ui/webui/options/options_managed_banner_handler.h',
        'browser/ui/webui/options/options_ui.cc',
        'browser/ui/webui/options/options_ui.h',
        'browser/ui/webui/options/password_manager_handler.cc',
        'browser/ui/webui/options/password_manager_handler.h',
        'browser/ui/webui/options/handler_options_handler.cc',
        'browser/ui/webui/options/handler_options_handler.h',
        'browser/ui/webui/options/personal_options_handler.cc',
        'browser/ui/webui/options/personal_options_handler.h',
        'browser/ui/webui/options/search_engine_manager_handler.cc',
        'browser/ui/webui/options/search_engine_manager_handler.h',
        'browser/ui/webui/options/stop_syncing_handler.cc',
        'browser/ui/webui/options/stop_syncing_handler.h',
        'browser/ui/webui/options/sync_setup_handler.cc',
        'browser/ui/webui/options/sync_setup_handler.h',
        'browser/ui/webui/plugins_ui.cc',
        'browser/ui/webui/plugins_ui.h',
        'browser/ui/webui/print_preview_data_source.cc',
        'browser/ui/webui/print_preview_data_source.h',
        'browser/ui/webui/print_preview_handler.cc',
        'browser/ui/webui/print_preview_handler.h',
        'browser/ui/webui/print_preview_ui.cc',
        'browser/ui/webui/print_preview_ui.h',
        'browser/ui/webui/screenshot_source.cc',
        'browser/ui/webui/screenshot_source.h',
        'browser/ui/webui/shared_resources_data_source.cc',
        'browser/ui/webui/shared_resources_data_source.h',
        'browser/ui/webui/sync_internals_html_source.cc',
        'browser/ui/webui/sync_internals_html_source.h',
        'browser/ui/webui/sync_internals_ui.cc',
        'browser/ui/webui/sync_internals_ui.h',
        'browser/ui/webui/test_chrome_web_ui_factory.cc',
        'browser/ui/webui/test_chrome_web_ui_factory.h',
        'browser/ui/webui/textfields_ui.cc',
        'browser/ui/webui/textfields_ui.h',
        'browser/ui/webui/theme_source.cc',
        'browser/ui/webui/theme_source.h',
        'browser/ui/webui/web_ui_util.cc',
        'browser/ui/webui/web_ui_util.h',
        'browser/ui/window_sizer.cc',
        'browser/ui/window_sizer.h',
        'browser/ui/window_sizer_linux.cc',
        'browser/ui/window_sizer_mac.mm',
        'browser/ui/window_sizer_win.cc',
        'browser/ui/window_snapshot/window_snapshot.h',
        'browser/ui/window_snapshot/window_snapshot_mac.mm',
        'browser/ui/window_snapshot/window_snapshot_win.cc',
        'browser/ui/window_snapshot/window_snapshot_x.cc',
        'browser/upgrade_detector.cc',
        'browser/upgrade_detector.h',
        'browser/upgrade_detector_impl.cc',
        'browser/upgrade_detector_impl.h',
        'browser/user_style_sheet_watcher.cc',
        'browser/user_style_sheet_watcher.h',
        'browser/utility_process_host.cc',
        'browser/utility_process_host.h',
        'browser/visitedlink/visitedlink_event_listener.cc',
        'browser/visitedlink/visitedlink_event_listener.h',
        'browser/visitedlink/visitedlink_master.cc',
        'browser/visitedlink/visitedlink_master.h',
        'browser/web_applications/web_app.cc',
        'browser/web_applications/web_app.h',
        'browser/web_resource/gpu_blacklist_updater.cc',
        'browser/web_resource/gpu_blacklist_updater.h',
        'browser/web_resource/promo_resource_service.cc',
        'browser/web_resource/promo_resource_service.h',
        'browser/web_resource/web_resource_service.cc',
        'browser/web_resource/web_resource_service.h',
        'browser/webdata/autofill_change.cc',
        'browser/webdata/autofill_change.h',
        'browser/webdata/autofill_entry.cc',
        'browser/webdata/autofill_entry.h',
        'browser/webdata/autofill_table.cc',
        'browser/webdata/autofill_table.h',
        'browser/webdata/keyword_table.cc',
        'browser/webdata/keyword_table.h',
        'browser/webdata/logins_table.cc',
        'browser/webdata/logins_table.h',
        'browser/webdata/logins_table_win.cc',
        'browser/webdata/token_service_table.cc',
        'browser/webdata/token_service_table.h',
        'browser/webdata/web_apps_table.cc',
        'browser/webdata/web_apps_table.h',
        'browser/webdata/web_data_service.cc',
        'browser/webdata/web_data_service.h',
        'browser/webdata/web_data_service_win.cc',
        'browser/webdata/web_database.cc',
        'browser/webdata/web_database.h',
        'browser/webdata/web_database_table.cc',
        'browser/webdata/web_database_table.h',

        # These files are generated by GRIT.
        '<(grit_out_dir)/grit/component_extension_resources_map.cc',
        '<(grit_out_dir)/grit/devtools_frontend_resources_map.cc',
        '<(grit_out_dir)/grit/devtools_resources_map.cc',
        '<(grit_out_dir)/grit/shared_resources_map.cc',
        '<(grit_out_dir)/grit/theme_resources_map.cc',
        '<(grit_out_dir)/grit/theme_resources_large_map.cc',
        '<(grit_out_dir)/grit/theme_resources_standard_map.cc',
      ],
      'conditions': [
        ['javascript_engine=="v8"', {
          'defines': [
            'CHROME_V8',
          ],
        }],
        ['debug_devtools==1', {
          'defines': [
            'DEBUG_DEVTOOLS=1',
          ],
        }],
        ['chromeos==0', {
          'sources/': [
            ['exclude', '^browser/chromeos'],
            ['exclude', '^browser/extensions/extension_input_ui_api.cc'],
            ['exclude', '^browser/extensions/extension_input_ui_api.h'],
            ['exclude', '^browser/ui/webui/chromeos'],
            ['exclude', '^browser/ui/webui/options/chromeos'],
            ['exclude', 'browser/extensions/extension_file_browser_private_api.cc'],
            ['exclude', 'browser/extensions/extension_file_browser_private_api.h'],
            ['exclude', 'browser/extensions/extension_mediaplayer_private_api.cc'],
            ['exclude', 'browser/extensions/extension_mediaplayer_private_api.h'],
            ['exclude', 'browser/extensions/extension_tts_api_chromeos.cc'],
            ['exclude', 'browser/extensions/file_manager_util.h'],
            ['exclude', 'browser/extensions/file_manager_util.cc'],
            ['exclude', 'browser/oom_priority_manager.cc'],
            ['exclude', 'browser/oom_priority_manager.h'],
            ['exclude', 'browser/policy/device_policy_cache.cc'],
            ['exclude', 'browser/policy/device_policy_cache.h'],
            ['exclude', 'browser/policy/enterprise_install_attributes.cc'],
            ['exclude', 'browser/policy/enterprise_install_attributes.h'],
            ['exclude', 'browser/policy/device_policy_identity_strategy.cc'],
            ['exclude', 'browser/policy/device_policy_identity_strategy.h'],
            ['exclude', 'browser/policy/proto/chrome_device_policy.pb.cc'],
            ['exclude', 'browser/policy/proto/chrome_device_policy.pb.h'],
            ['exclude', 'browser/renderer_host/offline_resource_handler.cc'],
            ['exclude', 'browser/renderer_host/offline_resource_handler.h'],
            ['exclude', 'browser/ui/login/login_prompt_ui.cc'],
            ['exclude', 'browser/ui/webui/active_downloads_ui.cc'],
            ['exclude', 'browser/ui/webui/collected_cookies_ui_delegate.cc'],
            ['exclude', 'browser/ui/webui/collected_cookies_ui_delegate.h'],
            ['exclude', 'browser/ui/webui/cookies_tree_model_adapter.cc'],
            ['exclude', 'browser/ui/webui/cookies_tree_model_adapter.h'],
            ['exclude', 'browser/ui/webui/fileicon_source_cros.cc'],
            ['exclude', 'browser/ui/webui/fileicon_source_cros.h'],
          ],
        }],
        ['chromeos==1', {
          'sources!': [
            'browser/background_mode_manager_linux.cc',
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
            'browser/first_run/upgrade_util_linux.cc',
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
            'browser/password_manager/native_backend_kwallet_x.cc',
            'browser/password_manager/native_backend_kwallet_x.h',
            'browser/platform_util_linux.cc',
            'browser/upgrade_detector_impl.cc',
            'browser/upgrade_detector_impl.h',
          ],
        }],
        ['use_cups==1', {
          'dependencies': [
            '../printing/printing.gyp:cups',
          ],
        }],
        ['use_gconf==0', {
          'sources!': [
            'browser/ui/gtk/gconf_titlebar_listener.cc',
            'browser/ui/gtk/gconf_titlebar_listener.h',
          ],
        }],
        ['use_gnome_keyring==0', {
          'sources!': [
            'browser/password_manager/native_backend_gnome_x.cc',
            'browser/password_manager/native_backend_gnome_x.h',
          ],
        }],
        ['touchui==0', {
          'sources/': [
            ['exclude', '^browser/chromeos/frame/dom_*'],
            ['exclude', '^browser/chromeos/login/dom_*'],
            ['exclude', '^browser/chromeos/login/webui_*'],
            ['exclude', '^browser/extensions/extension_input_ui_api.cc'],
            ['exclude', '^browser/extensions/extension_input_ui_api.h'],
            ['exclude', '^browser/renderer_host/render_widget_host_view_views.*'],
            ['exclude', '^browser/ui/touch/*'],
            ['exclude', '^browser/ui/views/tab_contents/tab_contents_container_views.cc'],
            ['exclude', '^browser/ui/views/tab_contents/tab_contents_container_views.h'],
            ['exclude', '^browser/ui/views/tab_contents/tab_contents_view_touch.*'],
            ['exclude', '^browser/ui/webui/chromeos/login/login*'],
            ['exclude', '^browser/ui/webui/keyboard_ui.*'],
          ],
        }],
        ['touchui==1', {
          'sources/': [
            ['include', '^browser/ui/touch/*'],
            ['exclude', '^browser/chromeos/frame/browser_non_client_frame_view_factory_chromeos.cc'],
            ['exclude', '^browser/renderer_host/gtk_im_context_wrapper.cc'],
            ['exclude', '^browser/renderer_host/gtk_im_context_wrapper.h'],
            ['exclude', '^browser/renderer_host/render_widget_host_view_gtk.cc'],
            ['exclude', '^browser/renderer_host/render_widget_host_view_gtk.h'],
            ['exclude', '^browser/ui/views/frame/browser_non_client_frame_view_factory_gtk.cc'],
            ['exclude', '^browser/ui/views/handle_web_keyboard_event_gtk.cc'],
            ['exclude', '^browser/ui/views/tab_contents/tab_contents_view_views.*'],
            ['exclude', '^browser/ui/views/tab_contents/native_tab_contents_view_gtk.*'],
            ['exclude', '^browser/chromeos/input_method/candidate_window.cc'],
            ['exclude', '^browser/chromeos/input_method/candidate_window.h'],
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus-glib',
            '../build/linux/system.gyp:gconf',
            '../build/linux/system.gyp:gtk',
            '../build/linux/system.gyp:gtkprint',
            '../build/linux/system.gyp:ssl',
            '../build/linux/system.gyp:x11',
            '../third_party/undoview/undoview.gyp:undoview',
          ],
          'link_settings': {
            'libraries': [
              # For dlsym() in 'browser/zygote_main_linux.cc'
              '-ldl',
            ],
          },
          'sources!': [
            'browser/ui/views/extensions/extension_view.cc',
            'browser/ui/views/extensions/extension_view.h',
          ],
          'sources': [
            'browser/crash_handler_host_linux.h',
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
          ],
          'conditions': [
            ['use_gnome_keyring==1', {
              'dependencies': [
                '../build/linux/system.gyp:gnome-keyring',
              ],
            }],
            ['linux_breakpad==1', {
              'sources': [
                'app/breakpad_linux.cc',
                'app/breakpad_linux.h',
                'browser/crash_handler_host_linux.cc',
              ],
              'dependencies': [
                '../breakpad/breakpad.gyp:breakpad_client',
                # make sure file_version_info_linux.h is generated first.
                'common',
              ],
              'include_dirs': [
                # breakpad_linux.cc uses generated file_version_info_linux.h.
                '<(SHARED_INTERMEDIATE_DIR)',
                '../breakpad/src',
              ],
            }, {  # linux_breakpad==0
              'sources': [
                'browser/crash_handler_host_linux_stub.cc',
              ],
            }],
            ['use_openssl==0', {
              'sources': [
                'third_party/mozilla_security_manager/nsNSSCertHelper.cpp',
                'third_party/mozilla_security_manager/nsNSSCertHelper.h',
                'third_party/mozilla_security_manager/nsNSSCertificate.cpp',
                'third_party/mozilla_security_manager/nsNSSCertificate.h',
                'third_party/mozilla_security_manager/nsUsageArrayHelper.cpp',
                'third_party/mozilla_security_manager/nsUsageArrayHelper.h',
              ],
            }],
            ['linux_sandbox_path != ""', {
              'defines': [
                'LINUX_SANDBOX_PATH="<(linux_sandbox_path)"',
              ],
            }],
          ],
        }, {  # toolkit_uses_gtk != 1
          'sources!': [
            # TODO(mattm): Cert manager stuff is really !USE_NSS.
            'browser/certificate_manager_model.cc',
            'browser/certificate_manager_model.h',
            'browser/ui/webui/options/certificate_manager_handler.cc',
            'browser/ui/webui/options/certificate_manager_handler.h',
          ],
        }],
        ['OS=="mac"', {
          'sources!': [
            'browser/automation/automation_provider_list_generic.cc',
            'browser/bookmarks/bookmark_context_menu.cc',
            'browser/bookmarks/bookmark_drop_info.cc',
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/jankometer.cc',
            'browser/password_manager/login_database_posix.cc',
            'browser/power_save_blocker_stub.cc',
            'browser/ui/browser_list_stub.cc',
            'browser/ui/crypto_module_password_dialog_nss.cc',
            'browser/ui/panels/about_panel_bubble.cc',
            'browser/ui/panels/about_panel_bubble.h',
            'browser/ui/panels/panel_browser_frame_view.cc',
            'browser/ui/panels/panel_browser_frame_view.h',
            'browser/ui/panels/panel_browser_view.cc',
            'browser/ui/panels/panel_browser_view.h',
            'browser/ui/tabs/dock_info.cc',
            'browser/ui/views/extensions/extension_view.cc',
            'browser/ui/views/extensions/extension_view.h',
          ],
          'sources': [
            # Build Apple sample code
            '../third_party/apple/ImageAndTextCell.h',
            '../third_party/apple/ImageAndTextCell.m',
            # Build the necessary GTM sources
            '../third_party/GTM/AppKit/GTMFadeTruncatingTextFieldCell.h',
            '../third_party/GTM/AppKit/GTMFadeTruncatingTextFieldCell.m',
            '../third_party/GTM/AppKit/GTMIBArray.h',
            '../third_party/GTM/AppKit/GTMIBArray.m',
            '../third_party/GTM/AppKit/GTMNSAnimation+Duration.h',
            '../third_party/GTM/AppKit/GTMNSAnimation+Duration.m',
            '../third_party/GTM/AppKit/GTMNSBezierPath+CGPath.h',
            '../third_party/GTM/AppKit/GTMNSBezierPath+CGPath.m',
            '../third_party/GTM/AppKit/GTMNSBezierPath+RoundRect.m',
            '../third_party/GTM/AppKit/GTMNSColor+Luminance.m',
            '../third_party/GTM/AppKit/GTMUILocalizer.h',
            '../third_party/GTM/AppKit/GTMUILocalizer.m',
            '../third_party/GTM/AppKit/GTMUILocalizerAndLayoutTweaker.h',
            '../third_party/GTM/AppKit/GTMUILocalizerAndLayoutTweaker.m',
            '../third_party/GTM/AppKit/GTMWindowSheetController.m',
            '../third_party/GTM/Foundation/GTMNSNumber+64Bit.h',
            '../third_party/GTM/Foundation/GTMNSNumber+64Bit.m',
            '../third_party/GTM/Foundation/GTMNSObject+KeyValueObserving.h',
            '../third_party/GTM/Foundation/GTMNSObject+KeyValueObserving.m',
            '../third_party/GTM/Foundation/GTMServiceManagement.h',
            '../third_party/GTM/Foundation/GTMServiceManagement.c',
            # MolokoCacao additions
            '../third_party/molokocacao/NSBezierPath+MCAdditions.h',
            '../third_party/molokocacao/NSBezierPath+MCAdditions.m',
            # Build necessary Mozilla sources
            '../third_party/mozilla/ComplexTextInputPanel.h',
            '../third_party/mozilla/ComplexTextInputPanel.mm',
            '../third_party/mozilla/NSPasteboard+Utils.h',
            '../third_party/mozilla/NSPasteboard+Utils.mm',
            '../third_party/mozilla/NSScreen+Utils.h',
            '../third_party/mozilla/NSScreen+Utils.m',
            '../third_party/mozilla/NSString+Utils.h',
            '../third_party/mozilla/NSString+Utils.mm',
            '../third_party/mozilla/NSURL+Utils.h',
            '../third_party/mozilla/NSURL+Utils.m',
            '../third_party/mozilla/NSWorkspace+Utils.h',
            '../third_party/mozilla/NSWorkspace+Utils.m',
            # Headers so that IB can find classes it needs to resolve classes
            # in XIB files.
            'common/chrome_application_mac.h',
          ],
          'include_dirs': [
            '../third_party/apple',
            '../third_party/GTM',
            '../third_party/GTM/AppKit',
            '../third_party/GTM/DebugUtils',
            '../third_party/GTM/Foundation',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/Accelerate.framework',
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/AudioUnit.framework',
              '$(SDKROOT)/System/Library/Frameworks/IOKit.framework',
              '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/SecurityInterface.framework',
            ],
            'mac_bundle_resources': [
              'browser/nacl_loader.sb',
              'browser/utility.sb',
            ],
          },
          'actions': [
            {
              # This action is used to extract the localization data from xib
              # files and generate table for the ui localizer from it.
              'variables': {
                'xib_localizer_tool_path':
                    'tools/build/mac/generate_localizer',
                'xib_files_to_scan': [
                  # The xibs that need localization
                  'app/nibs/About.xib',
                  'app/nibs/BookmarkAllTabs.xib',
                  'app/nibs/BookmarkBar.xib',
                  'app/nibs/BookmarkBubble.xib',
                  'app/nibs/BookmarkEditor.xib',
                  'app/nibs/BookmarkNameFolder.xib',
                  'app/nibs/CollectedCookies.xib',
                  'app/nibs/ContentBlockedCookies.xib',
                  'app/nibs/ContentBlockedImages.xib',
                  'app/nibs/ContentBlockedJavaScript.xib',
                  'app/nibs/ContentBlockedPlugins.xib',
                  'app/nibs/ContentBlockedPopups.xib',
                  'app/nibs/ContentBlockedGeolocation.xib',
                  'app/nibs/CookieDetailsView.xib',
                  'app/nibs/DownloadItem.xib',
                  'app/nibs/DownloadShelf.xib',
                  'app/nibs/ExtensionInstallPrompt.xib',
                  'app/nibs/ExtensionInstallPromptNoWarnings.xib',
                  'app/nibs/ExtensionInstalledBubble.xib',
                  'app/nibs/FirstRunBubble.xib',
                  'app/nibs/FirstRunDialog.xib',
                  'app/nibs/HttpAuthLoginSheet.xib',
                  'app/nibs/HungRendererDialog.xib',
                  'app/nibs/ImportProgressDialog.xib',
                  'app/nibs/InstantOptIn.xib',
                  'app/nibs/MainMenu.xib',
                  'app/nibs/ReportBug.xib',
                  'app/nibs/SadTab.xib',
                  'app/nibs/SaveAccessoryView.xib',
                  'app/nibs/SearchEngineDialog.xib',
                  'app/nibs/SpeechInputBubble.xib',
                  'app/nibs/TaskManager.xib',
                  'app/nibs/Toolbar.xib',
                ],
              },
              'action_name': 'Process xibs for localization',
              'inputs': [
                '<(xib_localizer_tool_path)',
                '<@(xib_files_to_scan)',
              ],
              'outputs': [
                '<(INTERMEDIATE_DIR)/ui_localizer_table.h',
              ],
              'action': ['<(xib_localizer_tool_path)',
                          '<@(_outputs)',
                          '<@(xib_files_to_scan)'],
            },
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
            '../views/views.gyp:*',
            '../rlz/rlz.gyp:rlz_lib',
          ],
          'export_dependent_settings': [
            '../views/views.gyp:*',
          ],
          'direct_dependent_settings': {
            'link_settings': {
              'libraries': [
                '-llocationapi.lib',
                '-lsensorsapi.lib',
              ],
            }
          },
          'sources': [
            'browser/first_run/upgrade_util.cc',
            'browser/first_run/upgrade_util.h',
            # Using built-in rule in vstudio for midl.
            'browser/history/history_indexer.idl',
            'browser/ui/webui/conflicts_ui.cc',
            'browser/ui/webui/conflicts_ui.h',
          ],
          'sources!': [
            'browser/history/history_publisher_none.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/power_save_blocker_stub.cc',
            'browser/ui/browser_list_stub.cc',
            'browser/ui/crypto_module_password_dialog_nss.cc',
            'browser/ui/views/keyboard_overlay_delegate.cc',
            'browser/ui/views/keyboard_overlay_dialog_view.cc',
            'browser/ui/views/select_file_dialog.cc',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }, {  # 'OS!="win"
          'sources/': [
            # Exclude all of hang_monitor.
            ['exclude', '^browser/hang_monitor/'],

            # Exclude parts of password_manager.
            ['exclude', '^browser/password_manager/ie7_password\\.cc$'],

            # Exclude all of rlz.
            ['exclude', '^browser/rlz/'],
            ['exclude', '^browser/extensions/extension_rlz_module'],

            # Exclude all of views.
            ['exclude', '^browser/ui/views/'],

            # Exclude try chrome dialog.
            ['exclude', '^browser/first_run/try_chrome_dialog_view.cc'],
            ['exclude', '^browser/first_run/try_chrome_dialog_view.h'],
          ],
          'conditions': [
            ['OS=="linux" and toolkit_views==1',{
              'dependencies': [
                '../views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
              'sources/': [
                ['include', '^browser/extensions/'],
                # This exclude duplicates the one just above because of the
                # order of evaluation of the 'sources/' rule above, the
                # conditions, and this 'sources/' rule.
                ['exclude', '^browser/extensions/extension_rlz_module'],
                ['include', 'browser/printing/print_dialog_cloud.cc'],
                ['include', 'browser/printing/print_dialog_cloud.h'],
                ['include', '^browser/speech/speech_input_bubble_views.cc'],

                # Exclude all of browser/ui/gtk, then include the things we want.
                ['exclude', '^browser/ui/gtk'],
                ['include', '^browser/ui/gtk/bookmarks/bookmark_editor_gtk.cc'],
                ['include', '^browser/ui/gtk/bookmarks/bookmark_editor_gtk.h'],
                ['include', '^browser/ui/gtk/bookmarks/bookmark_tree_model.cc'],
                ['include', '^browser/ui/gtk/bookmarks/bookmark_tree_model.h'],
                ['include', '^browser/ui/gtk/bookmarks/bookmark_utils_gtk.cc'],
                ['include', '^browser/ui/gtk/bookmarks/bookmark_utils_gtk.h'],
                ['include', '^browser/ui/gtk/cairo_cached_surface.cc'],
                ['include', '^browser/ui/gtk/cairo_cached_surface.h'],
                ['include', '^browser/ui/gtk/certificate_dialogs.cc'],
                ['include', '^browser/ui/gtk/certificate_dialogs.h'],
                ['include', '^browser/ui/gtk/certificate_viewer.cc'],
                ['include', '^browser/ui/gtk/certificate_viewer.h'],
                ['include', '^browser/ui/gtk/chrome_gtk_frame.cc'],
                ['include', '^browser/ui/gtk/chrome_gtk_frame.h'],
                ['include', '^browser/ui/gtk/collected_cookies_gtk.cc'],
                ['include', '^browser/ui/gtk/collected_cookies_gtk.h'],
                ['include', '^browser/ui/gtk/constrained_window_gtk.cc'],
                ['include', '^browser/ui/gtk/constrained_window_gtk.h'],
                ['include', '^browser/ui/gtk/crypto_module_password_dialog.cc'],
                ['include', '^browser/ui/gtk/download/download_started_animation_gtk.cc'],
                ['include', '^browser/ui/gtk/edit_search_engine_dialog.cc'],
                ['include', '^browser/ui/gtk/edit_search_engine_dialog.h'],
                ['include', '^browser/ui/gtk/first_run_dialog.cc'],
                ['include', '^browser/ui/gtk/first_run_dialog.h'],
                ['include', '^browser/ui/gtk/gtk_chrome_button.cc'],
                ['include', '^browser/ui/gtk/gtk_chrome_button.h'],
                ['include', '^browser/ui/gtk/gtk_chrome_cookie_view.cc'],
                ['include', '^browser/ui/gtk/gtk_chrome_cookie_view.h'],
                ['include', '^browser/ui/gtk/gtk_chrome_link_button.cc'],
                ['include', '^browser/ui/gtk/gtk_chrome_link_button.h'],
                ['include', '^browser/ui/gtk/gtk_custom_menu_item.cc'],
                ['include', '^browser/ui/gtk/gtk_floating_container.cc'],
                ['include', '^browser/ui/gtk/gtk_floating_container.h'],
                ['include', '^browser/ui/gtk/gtk_theme_service.cc'],
                ['include', '^browser/ui/gtk/gtk_theme_service.h'],
                ['include', '^browser/ui/gtk/gtk_tree.cc'],
                ['include', '^browser/ui/gtk/gtk_tree.h'],
                ['include', '^browser/ui/gtk/gtk_util.cc'],
                ['include', '^browser/ui/gtk/gtk_util.h'],
                ['include', '^browser/ui/gtk/hover_controller_gtk.cc'],
                ['include', '^browser/ui/gtk/hover_controller_gtk.h'],
                ['include', '^browser/ui/gtk/hung_renderer_dialog_gtk.cc'],
                ['include', '^browser/ui/gtk/importer/import_lock_dialog_gtk.cc'],
                ['include', '^browser/ui/gtk/importer/import_lock_dialog_gtk.h'],
                ['include', '^browser/ui/gtk/importer/import_progress_dialog_gtk.cc'],
                ['include', '^browser/ui/gtk/importer/import_progress_dialog_gtk.h'],
                ['include', '^browser/ui/gtk/nine_box.cc'],
                ['include', '^browser/ui/gtk/nine_box.h'],
                ['include', '^browser/ui/gtk/omnibox/omnibox_view_gtk.cc'],
                ['include', '^browser/ui/gtk/omnibox/omnibox_view_gtk.h'],
                ['include', '^browser/ui/gtk/owned_widget_gtk.cc'],
                ['include', '^browser/ui/gtk/owned_widget_gtk.h'],
                ['include', '^browser/ui/gtk/repost_form_warning_gtk.cc'],
                ['include', '^browser/ui/gtk/repost_form_warning_gtk.h'],
                ['include', '^browser/ui/gtk/ssl_client_certificate_selector.cc'],
                ['include', '^browser/ui/gtk/tab_contents_drag_source.cc'],
                ['include', '^browser/ui/gtk/tab_contents_drag_source.h'],
                ['include', '^browser/ui/gtk/task_manager_gtk.cc'],
                ['include', '^browser/ui/gtk/task_manager_gtk.h'],
                ['include', '^browser/ui/gtk/view_id_util.cc'],
                ['include', '^browser/ui/gtk/view_id_util.h'],
                ['include', '^browser/ui/profile_menu_model.cc'],
                ['include', '^browser/ui/profile_menu_model.h'],
                ['include', '^browser/ui/tabs/dock_info.cc'],
                ['include', '^browser/ui/tabs/dock_info.h'],
                ['include', '^browser/ui/views/about_chrome_view.cc'],
                ['include', '^browser/ui/views/about_chrome_view.h'],
                ['include', '^browser/ui/views/accelerator_table_gtk.cc'],
                ['include', '^browser/ui/views/accelerator_table_gtk.h'],
                ['include', '^browser/ui/views/accessibility_event_router_views.cc'],
                ['include', '^browser/ui/views/accessibility_event_router_views.h'],
                ['include', '^browser/ui/views/accessible_pane_view.cc'],
                ['include', '^browser/ui/views/accessible_pane_view.h'],
                ['include', '^browser/ui/views/autocomplete/autocomplete_popup_contents_view.cc'],
                ['include', '^browser/ui/views/autocomplete/autocomplete_popup_contents_view.h'],
                ['include', '^browser/ui/views/autocomplete/autocomplete_result_view.cc'],
                ['include', '^browser/ui/views/autocomplete/autocomplete_result_view.h'],
                ['include', '^browser/ui/views/autocomplete/autocomplete_result_view_model.h'],
                ['include', '^browser/ui/views/autocomplete/touch_autocomplete_popup_contents_view.cc'],
                ['include', '^browser/ui/views/autocomplete/touch_autocomplete_popup_contents_view.h'],
                ['include', '^browser/ui/views/bookmarks/bookmark_bar_instructions_view.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_bar_instructions_view.h'],
                ['include', '^browser/ui/views/bookmarks/bookmark_bar_view.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_bar_view.h'],
                ['include', '^browser/ui/views/bookmarks/bookmark_bubble_view.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_bubble_view.h'],
                ['include', '^browser/ui/views/bookmarks/bookmark_context_menu.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_context_menu.h'],
                ['include', '^browser/ui/views/bookmarks/bookmark_context_menu_controller_views.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_context_menu_controller_views.h'],
                ['include', '^browser/ui/views/bookmarks/bookmark_menu_controller_views.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_menu_delegate.cc'],
                ['include', '^browser/ui/views/bookmarks/bookmark_menu_delegate.h'],
                ['include', '^browser/ui/views/browser_actions_container.cc'],
                ['include', '^browser/ui/views/browser_actions_container.h'],
                ['include', '^browser/ui/views/browser_bubble.cc'],
                ['include', '^browser/ui/views/browser_bubble.h'],
                ['include', '^browser/ui/views/browser_bubble_gtk.cc'],
                ['include', '^browser/ui/views/bubble/border_contents.cc'],
                ['include', '^browser/ui/views/bubble/border_contents.h'],
                ['include', '^browser/ui/views/bubble/bubble.cc'],
                ['include', '^browser/ui/views/bubble/bubble.h'],
                ['include', '^browser/ui/views/bubble/bubble_border.cc'],
                ['include', '^browser/ui/views/bubble/bubble_border.h'],
                ['include', '^browser/ui/views/chrome_views_delegate.cc'],
                ['include', '^browser/ui/views/compact_nav/compact_location_bar_view.cc'],
                ['include', '^browser/ui/views/compact_nav/compact_location_bar_view.h'],
                ['include', '^browser/ui/views/compact_nav/compact_location_bar_view_host.cc'],
                ['include', '^browser/ui/views/compact_nav/compact_location_bar_view_host.h'],
                ['include', '^browser/ui/views/compact_nav/compact_navigation_bar.cc'],
                ['include', '^browser/ui/views/compact_nav/compact_navigation_bar.h'],
                ['include', '^browser/ui/views/compact_nav/compact_options_bar.cc'],
                ['include', '^browser/ui/views/compact_nav/compact_options_bar.h'],
                ['include', '^browser/ui/views/constrained_html_delegate_gtk.cc'],
                ['include', '^browser/ui/views/content_setting_bubble_contents.cc'],
                ['include', '^browser/ui/views/content_setting_bubble_contents.h'],
                ['include', '^browser/ui/views/create_application_shortcut_view.cc'],
                ['include', '^browser/ui/views/create_application_shortcut_view.h'],
                ['include', '^browser/ui/views/detachable_toolbar_view.cc'],
                ['include', '^browser/ui/views/detachable_toolbar_view.h'],
                ['include', '^browser/ui/views/dialog_stubs_gtk.cc'],
                ['include', '^browser/ui/views/dom_view.cc'],
                ['include', '^browser/ui/views/dom_view.h'],
                ['include', '^browser/ui/views/download/download_in_progress_dialog_view.cc'],
                ['include', '^browser/ui/views/download/download_in_progress_dialog_view.h'],
                ['include', '^browser/ui/views/download/download_item_view.cc'],
                ['include', '^browser/ui/views/download/download_item_view.h'],
                ['include', '^browser/ui/views/download/download_shelf_context_menu_view.cc'],
                ['include', '^browser/ui/views/download/download_shelf_context_menu_view.h'],
                ['include', '^browser/ui/views/download/download_shelf_view.cc'],
                ['include', '^browser/ui/views/download/download_shelf_view.h'],
                ['include', '^browser/ui/views/dropdown_bar_host.cc'],
                ['include', '^browser/ui/views/dropdown_bar_host.h'],
                ['include', '^browser/ui/views/dropdown_bar_host_gtk.cc'],
                ['include', '^browser/ui/views/dropdown_bar_view.cc'],
                ['include', '^browser/ui/views/dropdown_bar_view.h'],
                ['include', '^browser/ui/views/event_utils.cc'],
                ['include', '^browser/ui/views/event_utils.h'],
                ['include', '^browser/ui/views/extensions/browser_action_drag_data.cc'],
                ['include', '^browser/ui/views/extensions/browser_action_drag_data.h'],
                ['include', '^browser/ui/views/extensions/browser_action_overflow_menu_controller.cc'],
                ['include', '^browser/ui/views/extensions/browser_action_overflow_menu_controller.h'],
                ['include', '^browser/ui/views/extensions/extension_dialog.cc'],
                ['include', '^browser/ui/views/extensions/extension_dialog.h'],
                ['include', '^browser/ui/views/extensions/extension_install_dialog_view.cc'],
                ['include', '^browser/ui/views/extensions/extension_installed_bubble.cc'],
                ['include', '^browser/ui/views/extensions/extension_installed_bubble.h'],
                ['include', '^browser/ui/views/extensions/extension_popup.cc'],
                ['include', '^browser/ui/views/extensions/extension_popup.h'],
                ['include', '^browser/ui/views/extensions/extension_uninstall_dialog_view.cc'],
                ['include', '^browser/ui/views/extensions/extension_view.cc'],
                ['include', '^browser/ui/views/extensions/extension_view.h'],
                ['include', '^browser/ui/views/find_bar_host.cc'],
                ['include', '^browser/ui/views/find_bar_host.h'],
                ['include', '^browser/ui/views/find_bar_host_gtk.cc'],
                ['include', '^browser/ui/views/find_bar_view.cc'],
                ['include', '^browser/ui/views/find_bar_view.h'],
                ['include', '^browser/ui/views/frame/browser_bubble_host.cc'],
                ['include', '^browser/ui/views/frame/browser_bubble_host.h'],
                ['include', '^browser/ui/views/frame/browser_frame.cc'],
                ['include', '^browser/ui/views/frame/browser_frame.h'],
                ['include', '^browser/ui/views/frame/browser_frame_gtk.cc'],
                ['include', '^browser/ui/views/frame/browser_frame_gtk.h'],
                ['include', '^browser/ui/views/frame/browser_root_view.cc'],
                ['include', '^browser/ui/views/frame/browser_root_view.h'],
                ['include', '^browser/ui/views/frame/browser_view.cc'],
                ['include', '^browser/ui/views/frame/browser_view.h'],
                ['include', '^browser/ui/views/frame/browser_view_layout.cc'],
                ['include', '^browser/ui/views/frame/browser_view_layout.h'],
                ['include', '^browser/ui/views/frame/contents_container.cc'],
                ['include', '^browser/ui/views/frame/contents_container.h'],
                ['include', '^browser/ui/views/frame/native_browser_frame.h'],
                ['include', '^browser/ui/views/frame/native_browser_frame_delegate.h'],
                ['include', '^browser/ui/views/frame/opaque_browser_frame_view.cc'],
                ['include', '^browser/ui/views/frame/opaque_browser_frame_view.h'],
                ['include', '^browser/ui/views/frame/popup_non_client_frame_view.cc'],
                ['include', '^browser/ui/views/frame/popup_non_client_frame_view.h'],
                ['include', '^browser/ui/views/fullscreen_exit_bubble.cc'],
                ['include', '^browser/ui/views/fullscreen_exit_bubble.h'],
                ['include', '^browser/ui/views/handle_web_keyboard_event_gtk.cc'],
                ['include', '^browser/ui/views/handle_web_keyboard_event_gtk.h'],
                ['include', '^browser/ui/views/html_dialog_view.cc'],
                ['include', '^browser/ui/views/html_dialog_view.h'],
                ['include', '^browser/ui/views/infobars/*'],
                ['include', '^browser/ui/views/instant_confirm_view.cc'],
                ['include', '^browser/ui/views/instant_confirm_view.h'],
                ['include', '^browser/ui/views/js_modal_dialog_views.cc'],
                ['include', '^browser/ui/views/js_modal_dialog_views.h'],
                ['include', '^browser/ui/views/keyboard_overlay_delegate.cc'],
                ['include', '^browser/ui/views/keyboard_overlay_delegate.h'],
                ['include', '^browser/ui/views/keyboard_overlay_dialog_view.cc'],
                ['include', '^browser/ui/views/keyboard_overlay_dialog_view.h'],
                ['include', '^browser/ui/views/location_bar/click_handler.cc'],
                ['include', '^browser/ui/views/location_bar/click_handler.h'],
                ['include', '^browser/ui/views/location_bar/content_setting_image_view.cc'],
                ['include', '^browser/ui/views/location_bar/content_setting_image_view.h'],
                ['include', '^browser/ui/views/location_bar/ev_bubble_view.cc'],
                ['include', '^browser/ui/views/location_bar/ev_bubble_view.h'],
                ['include', '^browser/ui/views/location_bar/icon_label_bubble_view.cc'],
                ['include', '^browser/ui/views/location_bar/icon_label_bubble_view.h'],
                ['include', '^browser/ui/views/location_bar/keyword_hint_view.cc'],
                ['include', '^browser/ui/views/location_bar/keyword_hint_view.h'],
                ['include', '^browser/ui/views/location_bar/location_bar_view.cc'],
                ['include', '^browser/ui/views/location_bar/location_bar_view.h'],
                ['include', '^browser/ui/views/location_bar/location_icon_view.cc'],
                ['include', '^browser/ui/views/location_bar/location_icon_view.h'],
                ['include', '^browser/ui/views/location_bar/page_action_image_view.cc'],
                ['include', '^browser/ui/views/location_bar/page_action_image_view.h'],
                ['include', '^browser/ui/views/location_bar/page_action_with_badge_view.cc'],
                ['include', '^browser/ui/views/location_bar/page_action_with_badge_view.h'],
                ['include', '^browser/ui/views/location_bar/selected_keyword_view.cc'],
                ['include', '^browser/ui/views/location_bar/selected_keyword_view.h'],
                ['include', '^browser/ui/views/location_bar/star_view.cc'],
                ['include', '^browser/ui/views/location_bar/star_view.h'],
                ['include', '^browser/ui/views/notifications/balloon_view_host.cc'],
                ['include', '^browser/ui/views/notifications/balloon_view_host.h'],
                ['include', '^browser/ui/views/omnibox/omnibox_view_views.cc'],
                ['include', '^browser/ui/views/omnibox/omnibox_view_views.h'],
                ['include', '^browser/ui/views/page_info_bubble_view.cc'],
                ['include', '^browser/ui/views/pinned_contents_info_bubble.cc'],
                ['include', '^browser/ui/views/pinned_contents_info_bubble.h'],
                ['include', '^browser/ui/views/profile_menu_button.cc'],
                ['include', '^browser/ui/views/profile_menu_button.h'],
                ['include', '^browser/ui/views/profile_tag_view.cc'],
                ['include', '^browser/ui/views/profile_tag_view.h'],
                ['include', '^browser/ui/views/reload_button.cc'],
                ['include', '^browser/ui/views/reload_button.h'],
                ['include', '^browser/ui/views/restart_message_box.cc'],
                ['include', '^browser/ui/views/restart_message_box.h'],
                ['include', '^browser/ui/views/sad_tab_view.cc'],
                ['include', '^browser/ui/views/sad_tab_view.h'],
                ['include', '^browser/ui/views/select_file_dialog.cc'],
                ['include', '^browser/ui/views/status_bubble_views.cc'],
                ['include', '^browser/ui/views/status_bubble_views.h'],
                ['include', '^browser/ui/views/status_icons/status_tray_gtk.cc'],
                ['include', '^browser/ui/views/tab_contents/native_tab_contents_container_gtk.cc'],
                ['include', '^browser/ui/views/tab_contents/native_tab_contents_container_gtk.h'],
                ['include', '^browser/ui/views/tab_contents/native_tab_contents_view_gtk.cc'],
                ['include', '^browser/ui/views/tab_contents/native_tab_contents_view_gtk.h'],
                ['include', '^browser/ui/views/tab_contents/native_tab_contents_view.h'],
                ['include', '^browser/ui/views/tab_contents/native_tab_contents_view_delegate.h'],
                ['include', '^browser/ui/views/tab_contents/render_view_context_menu_views.cc'],
                ['include', '^browser/ui/views/tab_contents/render_view_context_menu_views.h'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_container.cc'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_container.h'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_container_native.cc'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_container_native.h'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_view_views.cc'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_view_views.h'],
                ['include', '^browser/ui/views/tab_icon_view.cc'],
                ['include', '^browser/ui/views/tab_icon_view.h'],
                ['include', '^browser/ui/views/tabs/abstract_tab_strip_view.h'],
                ['include', '^browser/ui/views/tabs/base_tab.cc'],
                ['include', '^browser/ui/views/tabs/base_tab.h'],
                ['include', '^browser/ui/views/tabs/base_tab_strip.cc'],
                ['include', '^browser/ui/views/tabs/base_tab_strip.h'],
                ['include', '^browser/ui/views/tabs/browser_tab_strip_controller.cc'],
                ['include', '^browser/ui/views/tabs/browser_tab_strip_controller.h'],
                ['include', '^browser/ui/views/tabs/dragged_tab_controller.cc'],
                ['include', '^browser/ui/views/tabs/dragged_tab_controller.h'],
                ['include', '^browser/ui/views/tabs/dragged_tab_view.cc'],
                ['include', '^browser/ui/views/tabs/dragged_tab_view.h'],
                ['include', '^browser/ui/views/tabs/native_view_photobooth.h'],
                ['include', '^browser/ui/views/tabs/native_view_photobooth_gtk.cc'],
                ['include', '^browser/ui/views/tabs/native_view_photobooth_gtk.h'],
                ['include', '^browser/ui/views/tabs/side_tab.cc'],
                ['include', '^browser/ui/views/tabs/side_tab.h'],
                ['include', '^browser/ui/views/tabs/side_tab_strip.cc'],
                ['include', '^browser/ui/views/tabs/side_tab_strip.h'],
                ['include', '^browser/ui/views/tabs/tab.cc'],
                ['include', '^browser/ui/views/tabs/tab.h'],
                ['include', '^browser/ui/views/tabs/tab_controller.h'],
                ['include', '^browser/ui/views/tabs/tab_renderer_data.cc'],
                ['include', '^browser/ui/views/tabs/tab_renderer_data.h'],
                ['include', '^browser/ui/views/tabs/tab_strip.cc'],
                ['include', '^browser/ui/views/tabs/tab_strip.h'],
                ['include', '^browser/ui/views/tabs/tab_strip_factory.cc'],
                ['include', '^browser/ui/views/tabs/tab_strip_factory.h'],
                ['include', '^browser/ui/views/textfield_views.cc'],
                ['include', '^browser/ui/views/textfield_views.h'],
                ['include', '^browser/ui/views/theme_background.cc'],
                ['include', '^browser/ui/views/theme_background.h'],
                ['include', '^browser/ui/views/theme_install_bubble_view.cc'],
                ['include', '^browser/ui/views/theme_install_bubble_view.h'],
                ['include', '^browser/ui/views/toolbar_view.cc'],
                ['include', '^browser/ui/views/toolbar_view.h'],
                ['include', '^browser/ui/views/unhandled_keyboard_event_handler.cc'],
                ['include', '^browser/ui/views/unhandled_keyboard_event_handler.h'],
                ['include', '^browser/ui/views/update_recommended_message_box.cc'],
                ['include', '^browser/ui/views/update_recommended_message_box.h'],
                ['include', '^browser/ui/views/window.cc'],
                ['include', '^browser/ui/views/window.h'],
                ['include', '^browser/ui/views/wrench_menu.cc'],
                ['include', '^browser/ui/views/wrench_menu.h'],
                ['include', '^browser/ui/window_sizer.cc'],
                ['include', '^browser/ui/window_sizer.h'],

                # Other excluded stuff.
                ['exclude', '^browser/autocomplete/autocomplete_popup_view_gtk.cc'],
                ['exclude', '^browser/autocomplete/autocomplete_popup_view_gtk.h'],
                ['exclude', '^browser/extensions/extension_host_mac.h'],
                ['exclude', '^browser/extensions/extension_host_mac.mm'],
                ['exclude', '^browser/extensions/external_registry_extension_loader_win.cc'],
                ['exclude', '^browser/extensions/external_registry_extension_loader_win.h'],
                ['exclude', '^browser/speech/speech_input_bubble_gtk.cc'],
                ['exclude', '^browser/tab_contents/render_view_context_menu_gtk.cc'],
                ['exclude', '^browser/tab_contents/render_view_context_menu_gtk.h'],
                ['exclude', '^browser/tab_contents/tab_contents_view_gtk.cc'],
                ['exclude', '^browser/tab_contents/tab_contents_view_gtk.h'],
                ['exclude', '^browser/ui/browser_list_gtk.cc'],
                ['exclude', '^browser/ui/panels/panel_browser_window_gtk.cc'],
                ['exclude', '^browser/ui/panels/panel_browser_window_gtk.h'],
              ],
            }],
            # Exclude these toolkit_views specific files again.
            # (Required because of the '^browser/extensions/' include above)
            ['toolkit_views==0', {
              'sources/': [
                ['exclude', '^browser/extensions/extension_input_api.cc'],
                ['exclude', '^browser/extensions/extension_input_api.h'],
                ['exclude', '^browser/extensions/key_identifier_conversion_views.cc'],
                ['exclude', '^browser/extensions/key_identifier_conversion_views.h'],
              ],
            }],
            # These GTK files haven't been ported to views, while ChromeOS has
            # its own separate implementation below.  So re-include them only on
            # non-ChromeOS views Linux builds.
            ['OS=="linux" and toolkit_views==1 and chromeos==0', {
              'sources/': [
                ['exclude', '^browser/extensions/extension_file_browser_private_api'],
                ['include', '^browser/ui/gtk/dialogs_gtk.cc'],
                ['include', '^browser/ui/gtk/external_protocol_dialog_gtk.cc'],
                ['include', '^browser/ui/gtk/external_protocol_dialog_gtk.h'],
                ['include', '^browser/ui/views/frame/browser_non_client_frame_view_factory_gtk.cc'],
                ['include', '^browser/ui/views/notifications/balloon_view.cc'],
                ['include', '^browser/ui/views/notifications/balloon_view.h'],
                ['exclude', '^browser/ui/views/keyboard_overlay_delegate.cc'],
                ['exclude', '^browser/ui/views/keyboard_overlay_delegate.h'],
                ['exclude', '^browser/ui/views/keyboard_overlay_dialog_view.cc'],
                ['exclude', '^browser/ui/views/keyboard_overlay_dialog_view.h'],
                ['exclude', '^browser/ui/views/select_file_dialog.cc'],
              ],
            }],
            # Exclude extension_input_ui_api again
            # (Required because of the '^browser/extensions/' include abrove)
            ['toolkit_uses_gtk == 1 and ( touchui == 0 or chromeos == 0 )', {
              'sources/': [
                ['exclude', '^browser/extensions/extension_input_ui_api.cc'],
                ['exclude', '^browser/extensions/extension_input_ui_api.h'],
              ],
            }],
            # GTK build only
            ['toolkit_uses_gtk == 1 and toolkit_views == 0', {
              'sources/': [
                ['include', '^browser/printing/print_dialog_gtk.cc'],
                ['include', '^browser/printing/print_dialog_gtk.h'],
                ['exclude', '^browser/bookmarks/bookmark_drop_info.cc'],
                ['exclude', '^browser/ui/browser_list_stub.cc'],
                ['exclude', '^browser/ui/panels/about_panel_bubble.cc'],
                ['exclude', '^browser/ui/panels/about_panel_bubble.h'],
                ['exclude', '^browser/ui/panels/panel_browser_frame_view.cc'],
                ['exclude', '^browser/ui/panels/panel_browser_frame_view.h'],
                ['exclude', '^browser/ui/panels/panel_browser_view.cc'],
                ['exclude', '^browser/ui/panels/panel_browser_view.h'],
              ],
            }],
            # Touch build only
            ['OS=="linux" and toolkit_views==1 and touchui==1', {
              'sources/': [
                ['include', '^browser/ui/views/tab_contents/tab_contents_view_touch.cc'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_view_touch.h'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_container_views.cc'],
                ['include', '^browser/ui/views/tab_contents/tab_contents_container_views.h'],
                # TODO(anicolao): exclude these once we have WebUI dialogs
                # ['exclude', '^browser/ui/gtk/constrained_window_gtk.cc'],
                # ['exclude', '^browser/ui/gtk/constrained_window_gtk.h'],
                ['exclude', '^browser/ui/views/frame/browser_non_client_frame_view_factory_gtk.cc'],
                ['exclude', '^browser/ui/views/tabs/tab_strip_factory.cc'],
                ['exclude', '^browser/ui/views/tab_contents/tab_contents_container_native.cc'],
                ['exclude', '^browser/ui/views/tab_contents/tab_contents_container_native.h'],
                ['exclude', '^browser/ui/views/tab_contents/tab_contents_view_views.*'],
                ['exclude', '^browser/ui/views/tab_contents/native_tab_contents_view_gtk.*'],
              ],
            }],
            ['OS=="linux" and chromeos==1',{
              'sources/': [
                ['include', '^browser/ui/gtk/omnibox/omnibox_view_gtk.cc'],
                ['include', '^browser/ui/gtk/omnibox/omnibox_view_gtk.h'],
                ['include', '^browser/ui/login/login_prompt_ui.cc'],
                ['include', '^browser/ui/views/omnibox/omnibox_view_views.cc'],
                ['include', '^browser/ui/views/omnibox/omnibox_view_views.h'],
                ['exclude', '^browser/extensions/extension_tts_api_linux.cc'],
                ['exclude', '^browser/notifications/balloon_collection_impl.cc'],
                ['exclude', '^browser/notifications/balloon_collection_impl.h'],
                ['exclude', '^browser/notifications/balloon_collection_linux.cc'],
                ['exclude', '^browser/ui/login/login_prompt_gtk.cc'],
              ],
              'dependencies': [
                '../third_party/protobuf/protobuf.gyp:protobuf_lite',
                '../third_party/protobuf/protobuf.gyp:protoc#host',
              ],
              'conditions': [
                ['system_libcros==0', {
                  'dependencies': [
                    '../third_party/cros/cros_api.gyp:cros_api',
                  ],
                  'include_dirs': [
                    '../third_party/'
                  ],
                }],
                ['system_libcros==1', {
                  'link_settings': {
                    'libraries': [
                      '-lcrosapi',
                    ],
                  },
                }],
              ],
              'actions': [
                {
                  'action_name': 'my_proto',
                  'inputs': [
                    '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
                    'browser/metrics/system_metrics.proto',
                  ],
                  'outputs': [
                    '<(INTERMEDIATE_DIR)/chrome/browser/metrics/system_metrics.pb.cc',
                    '<(INTERMEDIATE_DIR)/chrome/browser/metrics/system_metrics.pb.h',
                  ],
                  'dependencies': [
                    '../third_party/protobuf/protobuf.gyp:protoc',
                  ],
                  'action': [
                    '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
                    'browser/metrics/system_metrics.proto',
                    '--cpp_out=<(INTERMEDIATE_DIR)/chrome',
                  ],
                },
              ],
            }],
            ['os_posix == 1 and OS != "mac" and gcc_version == 45', {
              # Avoid gcc 4.5 miscompilation of template_url.cc
              # as per http://crbug.com/41887
              'cflags': [
                '-fno-ipa-cp',
              ],
            }],
          ],
          # Exclude files that should be excluded for all non-Windows platforms.
          'sources!': [
            'browser/accessibility/browser_accessibility_manager_win.cc',
            'browser/accessibility/browser_accessibility_manager_win.h',
            'browser/accessibility/browser_accessibility_win.cc',
            'browser/accessibility/browser_accessibility_win.h',
            'browser/aeropeek_manager.cc',
            'browser/autocomplete/autocomplete_accessibility.cc',
            'browser/extensions/extension_tts_api_win.cc',
            'browser/google/google_update.cc',
            'browser/importer/ie_importer.cc',
          ],
        }],
        [ 'use_openssl==1', {
          'sources!': [
            'browser/importer/nss_decryptor.cc',
            'browser/importer/nss_decryptor_system_nss.cc',
            'browser/importer/nss_decryptor_system_nss.h',
            'browser/ui/crypto_module_password_dialog_nss.cc',
          ]}, {
           'sources!': [
             'browser/ui/crypto_module_password_dialog_openssl.cc',
          ]},
        ],
        ['file_manager_extension==1', {
          'sources/': [
            ['exclude', '^browser/ui/gtk/dialogs_gtk.cc'],
            ['exclude', '^browser/ui/views/select_file_dialog.cc'],
            ['include', '^browser/ui/views/file_manager_dialogs.cc'],
          ]}, {
          'sources/': [
            ['exclude', '^browser/ui/views/file_manager_dialogs.cc'],
          ]}
        ],
      ],
    },
    {
      # Protobuf compiler / generate rule for feedback
      'target_name': 'userfeedback_proto',
      'type': 'none',
      'sources': [
        'browser/userfeedback/proto/annotations.proto',
        'browser/userfeedback/proto/chrome.proto',
        'browser/userfeedback/proto/common.proto',
        'browser/userfeedback/proto/dom.proto',
        'browser/userfeedback/proto/extension.proto',
        'browser/userfeedback/proto/math.proto',
        'browser/userfeedback/proto/web.proto',
      ],
      'rules': [
        {
          'rule_name': 'genproto',
          'extension': 'proto',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
          ],
          'variables': {
            # The protoc compiler requires a proto_path argument with the
            # directory containing the .proto file.
            # There's no generator variable that corresponds to this, so fake it.
            'rule_input_relpath': 'browser/userfeedback/proto',
          },
          'outputs': [
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.h',
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.cc',
          ],
          'action': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
            '--proto_path=./<(rule_input_relpath)',
            './<(rule_input_relpath)/<(RULE_INPUT_ROOT)<(RULE_INPUT_EXT)',
            '--cpp_out=<(protoc_out_dir)/chrome/<(rule_input_relpath)',
          ],
          'message': 'Generating C++ code from <(RULE_INPUT_PATH)',
        },
      ],
      'dependencies': [
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/protobuf/protobuf.gyp:protoc#host',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(protoc_out_dir)',
        ]
      },
      'export_dependent_settings': [
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
      ],
    },
    {
      # Protobuf compiler / generator for the safebrowsing reporting
      # protocol buffer.
      'target_name': 'safe_browsing_report_proto',
      'type': 'none',
      'sources': [ 'browser/safe_browsing/report.proto' ],
      'rules': [
        {
          'rule_name': 'genproto',
          'extension': 'proto',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
          ],
          'variables': {
            # The protoc compiler requires a proto_path argument with the
            # directory containing the .proto file.
            # There's no generator variable that corresponds to this, so fake
            # it.
            'rule_input_relpath': 'browser/safe_browsing',
          },
          'outputs': [
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.h',
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.cc',
          ],
          'action': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
            '--proto_path=./<(rule_input_relpath)',
            './<(rule_input_relpath)/<(RULE_INPUT_ROOT)<(RULE_INPUT_EXT)',
            '--cpp_out=<(protoc_out_dir)/chrome/<(rule_input_relpath)',
          ],
          'message': 'Generating C++ code from <(RULE_INPUT_PATH)',
        },
      ],
      'dependencies': [
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/protobuf/protobuf.gyp:protoc#host',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(protoc_out_dir)',
        ]
      },
      'export_dependent_settings': [
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
      ],
    },
    {
      # Protobuf compiler / generator for the InMemoryURLIndex caching
      # protocol buffer.
      'target_name': 'in_memory_url_index_cache_proto',
      'type': 'none',
      'sources': [ 'browser/history/in_memory_url_index_cache.proto' ],
      'rules': [
        {
          'rule_name': 'genproto',
          'extension': 'proto',
          'inputs': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
          ],
          'variables': {
            # The protoc compiler requires a proto_path argument with the
            # directory containing the .proto file.
            # There's no generator variable that corresponds to this, so fake
            # it.
            'rule_input_relpath': 'browser/history',
          },
          'outputs': [
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.h',
            '<(protoc_out_dir)/chrome/<(rule_input_relpath)/<(RULE_INPUT_ROOT).pb.cc',
          ],
          'action': [
            '<(PRODUCT_DIR)/<(EXECUTABLE_PREFIX)protoc<(EXECUTABLE_SUFFIX)',
            '--proto_path=./<(rule_input_relpath)',
            './<(rule_input_relpath)/<(RULE_INPUT_ROOT)<(RULE_INPUT_EXT)',
            '--cpp_out=<(protoc_out_dir)/chrome/<(rule_input_relpath)',
          ],
          'message': 'Generating C++ code from <(RULE_INPUT_PATH)',
        },
      ],
      'dependencies': [
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/protobuf/protobuf.gyp:protoc#host',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(protoc_out_dir)',
        ]
      },
      'export_dependent_settings': [
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
      ],
    },
    {
      'target_name': 'in_memory_url_index_cache_proto_cpp',
      'type': 'static_library',
      'sources': [
        '<(protoc_out_dir)/chrome/browser/history/in_memory_url_index_cache.pb.cc',
        '<(protoc_out_dir)/chrome/browser/history/in_memory_url_index_cache.pb.h',
      ],
      'dependencies': [
        'in_memory_url_index_cache_proto',
      ],
      'export_dependent_settings': [
        'in_memory_url_index_cache_proto',
      ],
      # This target exports a hard dependency because it includes generated
      # header files.
      'hard_dependency': 1,
    },
  ],
}

# Local Variables:
# tab-width:2
# indent-tabs-mode:nil
# End:
# vim: set expandtab tabstop=2 shiftwidth=2:
