#ifndef VIDEOAUDIOINPUT_HPP
#define VIDEOAUDIOINPUT_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qvector.h>

class CVideoDeviceLinux;

class CVideoAudioInput: public QObject
{
   Q_OBJECT
private:
   CVideoDeviceLinux *pVideo;
   int Channel;

   int Flags;
   QString Name;

public:
   enum {
     Mono,
     Stereo,
     Language1,
     Language2,   
   } Modes;

   CVideoAudioInput(CVideoDeviceLinux *video, int channel);

   int GetNumber() const;   
   QString GetName() const;

   bool IsMutable();
   bool IsMuted();
   int GetVolume() const;
   int GetBass() const;
   int GetTreble() const;
   
public slots:
   void Mute(bool mute_on);
   void SetVolume(int volume);
   void SetBass(int bass);
   void SetTreble(int treble);
};


#endif
