#ifndef QLEDBAR_HPP
#define QLEDBAR_HPP

#include <qcolor.h>
#include <qevent.h>
#include <qpixmap.h>
#ifdef QT_THREAD_SUPPORT
#include <qthread.h>
#endif
#include <qwidget.h>

class CLedBar: public QWidget
{
   Q_OBJECT
public:
   enum Orientation { // orientation, like a compass; the bars grow from the centre
     North,
     West,
     South,
     East
   };

   enum BarMode {
     SolidBar,   ///< One solid bar
     SegmentBar, ///< Blocked bar, looks most like a real LED bar

   };

private:
#ifdef QT_THREAD_SUPPORT
   QMutex Busy;
#endif
   int Minimum, Maximum, Range, Value;
   Orientation BarOrientation;
   int BarLength;  // in pixels
   int BarWidth;   // in pixels
   BarMode m_BarMode;

   int Segments;
   int Margin;

   int StartOfSegment[21];	// start of segment in pixels from beginning
   int ValueForSegment[20];	// start of segment in value
   QColor ColorOfSegment[20];

   QPixmap DrawingArea;

   void BusyLock();
   void BusyUnlock();

   void CalcBoundaries();

protected:
   void resizeEvent(QResizeEvent *);
   void paintEvent(QPaintEvent *);

public:
   CLedBar(Orientation orientation, int min_range, int max_range, BarMode bar_mode = SolidBar, QWidget *parent = 0, const char *name = 0);

   void SetBarMode(BarMode bar_mode);
   void SetSegments(int segments, const QColor *colors);
   void SetMargin(int width);

   // SetPeakHold(int value, int time_ms);

public slots:
   void setValue(int value);
};

#endif
