/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifndef AUDIOCOLLECTOR_H
#define AUDIOCOLLECTOR_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qmap.h>
#include <qlist.h>

#include "AudioDevice.h"

class CAudioCollector
{
private:
   static CAudioCollector *s_pAudioCollector;
   QList<CAudioDevice> m_Devices;

   CAudioCollector();
   void Scan();

public:
   static CAudioCollector *Instance();

   uint NumberOfAudioDevices() const;
   CAudioDevice *GetAudioDevice(uint n);

   CAudioDevice *Find(const QString &device_name, const QString &node_name);
};


#endif
