/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/


#include "AudioRingBuffer.h"
#include "MemoryAudioSample.h"


CAudioRingBufferReader::CAudioRingBufferReader(CRingBuffer *ring, const SoundAttributes *attr)
	: CRingBufferReader(ring)
{
qDebug(">> CAudioRingBufferReader::CAudioRingBufferReader(..)");
   m_pRing = ring;
   m_pSoundAttributes = attr;
qDebug("<< CAudioRingBufferReader::CAudioRingBufferReader(..)");
}

SoundAttributes CAudioRingBufferReader::GetSoundAttributes() const
{
   return *m_pSoundAttributes;
}


void CAudioRingBufferReader::SetLowWaterMark(SamplePos mark)
{
   CRingBufferReader::SetLowWaterMark(mark * m_pSoundAttributes->BytesPerSample());
}

SamplePos CAudioRingBufferReader::GetLowWaterMark() const
{
   return CRingBufferReader::GetLowWaterMark() / m_pSoundAttributes->BytesPerSample();
}

void CAudioRingBufferReader::SetHighWaterMark(SamplePos mark)
{
   CRingBufferReader::SetHighWaterMark(mark * m_pSoundAttributes->BytesPerSample());
}

SamplePos CAudioRingBufferReader::GetHighWaterMark() const
{
   return CRingBufferReader::GetHighWaterMark() / m_pSoundAttributes->BytesPerSample();
}


#if 0
CAudioSample CAudioRingBufferReader::ReadFromTail(SamplePos length)
{


}
#endif

CAudioSample CAudioRingBufferReader::ReadFromHead(SamplePos length, bool clear, unsigned long time)
{
   CMemoryAudioSample sam(*m_pSoundAttributes, length);
   void *p;
   int copied, need;

//qDebug(">> CAudioRingBufferReader::ReadFromHead");
   p = sam.GetRawPointer();
   if (p != 0)
   {
     need = length * m_pSoundAttributes->BytesPerSample();
     copied = ReadFromBufferHead(p, need, clear, time);
     if (copied < need)
       return CAudioSample(); // return empty sample
   }
//qDebug("<< CAudioRingBufferReader::ReadFromHead");
   return sam;
}

