let read_chan f ic =
  try
    while true do
      f (input_char ic)
    done
  with End_of_file -> ()

let include_file file =
  let buf = Buffer.create 1000 in
  let ic = open_in_bin file in
  read_chan (Buffer.add_char buf) ic;
  close_in ic;
  print (Buffer.contents buf)

let html_verbatim file =
  let buf = Buffer.create 1000 in
  let ic = open_in_bin file in
  Buffer.add_string buf "<pre>\n";
  read_chan 
    (function
       | '<' -> Buffer.add_string buf "&lt;"
       | '>' -> Buffer.add_string buf "&gt;"
       | '&' -> Buffer.add_string buf "&amp;"
       | c   -> Buffer.add_char buf c)
    ic;
  close_in ic;
  Buffer.add_string buf "</pre>\n";
  print (Buffer.contents buf)

let camlmix file = Sys.command ("./camlmix " ^ file)

let author = "Martin Jambon"
let some_text = "inserted using Ocaml"
