/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_EDITOR_H
#define INCLUDED_EDITOR_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QTextEdit;
class QPushButton;

/*------- class declaration:
-------------------------------------------------------------------*/
class Editor : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Editor( QWidget* const in_parent, const QString& in_fname );
private:
	Editor( const Editor& );
	Editor& operator=( const Editor& );
	
// ******* MEMBERS *******
private:
	static const QString CAPTION;
	static const QString MSG_READ_ERROR;
	static const QString MSG_SAVE_ERROR;
	static const QString MSG_FILE_MODIFIED;
		
	QTextEdit*    const d_editor;
	QPushButton*  const d_reload_btn;
	QPushButton*  const d_save_btn;
	QPushButton*  const d_return_btn;
	const QString       d_fname;	

// ******* METHODS *******
private:
	void set_viewer_text();
	void polish();
	void set_edit_config();
	bool read_file();
	bool save_file();
private slots:
	void reload();
	void save();
	void accept();
};

#endif // INCLUDED_EDITOR_H
