/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "CanOverwrite.h"
#include "Shared.h"
#include "Config.h"
#include <qapplication.h>
#include <qeventloop.h>
#include <qdesktopwidget.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>

/*------- local constants:
-------------------------------------------------------------------*/
const int     CanOverwrite::Margin         = 10;
const QColor  CanOverwrite::MsgColor       = qRgb( 255, 0, 0 );
const QString CanOverwrite::Caption        = QT_TR_NOOP( "Question about overwriting" );
const QString CanOverwrite::MsgText        = QT_TR_NOOP( "Destination file already exists:" );
const QString CanOverwrite::BtnSkipLabel   = QT_TR_NOOP( "&Skip" );
const QString CanOverwrite::BtnOverLabel   = QT_TR_NOOP( "&Overwrite" );
const QString CanOverwrite::BtnUpdateLabel = QT_TR_NOOP( "&Update" );
const QString CanOverwrite::BtnRenameLabel = QT_TR_NOOP( "&Rename" );
const QString CanOverwrite::CbDontAskLabel = QT_TR_NOOP( "Don't ask again" );


//*******************************************************************
// CanOverwrite
//*******************************************************************
CanOverwrite::CanOverwrite( QWidget* const in_parent, const QString& in_fname )
: QDialog        ( in_parent )
, d_info_field   ( 0 )
, d_ask_checkbox ( new QCheckBox  ( tr( CbDontAskLabel ), this ))
, d_rename_button( new QPushButton( tr( BtnRenameLabel ), this ))
, d_skip_button  ( new QPushButton( tr( BtnSkipLabel ), this ))
, d_over_button  ( new QPushButton( tr( BtnOverLabel ), this ))
, d_update_button( new QPushButton( tr( BtnUpdateLabel ), this ))
, d_cancel_button( new QPushButton( tr( Shared::CancelBtnLabel ), this ))
{
	setCaption( tr( Caption ) );
	setFont( Config::instance()->lfs_default_font() );
	d_skip_button->setDefault( TRUE );
		
	QVBoxLayout* const main_layout = new QVBoxLayout( this );
	main_layout->setMargin ( Margin );
	main_layout->setSpacing ( Shared::LayoutSpacing );

	QFrame* const frame = new QFrame( this );
	main_layout->addWidget( frame );
	frame->setFrameShape( QFrame::GroupBoxPanel );
	frame->setFrameShadow( QFrame::Sunken );
	frame->setLineWidth( 1 );
	frame->setMidLineWidth( 1 );
			
	QVBoxLayout* const frame_layout = new QVBoxLayout( frame );
	frame_layout->setMargin ( Margin );
	frame_layout->setSpacing ( Shared::LayoutSpacing );
	frame_layout->addWidget( new QLabel( tr( MsgText), frame ));

	d_info_field = new InfoField( in_fname, frame );
	frame_layout->addWidget( d_info_field );
	d_info_field->setPaletteForegroundColor( MsgColor );

	// Dolna czesc dialogu z przyciskami.
	QHBoxLayout* const bottom_layout = new QHBoxLayout;
	main_layout->addLayout( bottom_layout );
			
	// check box u gory, z lewej strony
	QVBoxLayout* const checkbox_layout = new QVBoxLayout;
	bottom_layout->addLayout( checkbox_layout );
	bottom_layout->setStretchFactor( checkbox_layout, Shared::OverStretch );
	checkbox_layout->addWidget( d_ask_checkbox );
	checkbox_layout->addStretch( Shared::OverStretch );
	
	// przyciski
	QGridLayout* const button_layout = new QGridLayout( bottom_layout, 2, 3, 2 );
	button_layout->addWidget( d_rename_button, 0, 0 );
	button_layout->addWidget( d_update_button, 0, 1 );
	button_layout->addWidget( d_over_button  , 1, 1 );
	button_layout->addWidget( d_skip_button  , 0, 2 );
	button_layout->addWidget( d_cancel_button, 1, 2 );

	connect( d_rename_button, SIGNAL( clicked() ), this, SLOT( rename() ));
	connect( d_skip_button  , SIGNAL( clicked() ), this, SLOT( skip()   ));
	connect( d_over_button  , SIGNAL( clicked() ), this, SLOT( over()   ));
	connect( d_update_button, SIGNAL( clicked() ), this, SLOT( update() ));
	connect( d_cancel_button, SIGNAL( clicked() ), this, SLOT( cancel() ));
}
// end of CanOverwrite


//###################################################################
//#                                                                 #
//#                        P R I V A T E                            #
//#                                                                 #
//###################################################################


//*******************************************************************
// polish                                                    PRIVATE
//*******************************************************************
void CanOverwrite::polish()
{
	Shared::polish_width( this, 40 );
}
// end of polish

//*******************************************************************
// rename                                               PRIVATE slot
//*******************************************************************
void CanOverwrite::rename()
{
	done( RENAME );
}
// end of rename

//*******************************************************************
// skip                                                 PRIVATE slot
//*******************************************************************
void CanOverwrite::skip()
{
	done( SKIP );
}
// end of skip

//*******************************************************************
// over                                                 PRIVATE slot
//*******************************************************************
void CanOverwrite::over()
{
	done( OVER );
}
// end of over

//*******************************************************************
// update                                               PRIVATE slot
//*******************************************************************
void CanOverwrite::update()
{
	done( UPDATE );
}
// end of update

//*******************************************************************
// cancel                                               PRIVATE slot
//*******************************************************************
void CanOverwrite::cancel()
{
	done( CANCEL );
}
// end of cancel
