#!/bin/bash
# Usage: svn-transform src dest

set -e

SRC=$1
DEST=$2
SRC=$(pwd)/"${SRC:-bnd}"
DEST=$(pwd)/"${DEST:-bnd-svn}"
VERSION=$(dpkg-parsechangelog | egrep '^Version:' | cut -f 2 -d ' '| cut -d: -f2- | cut -d'-' -f 1)

rm -rf $DEST

echo "Copy files..."
mkdir -p $DEST/libg/src/main/java
rsync --cvs-exclude -r --exclude '**/*.class' --exclude '**/*.jar' --exclude '**/filter' $SRC/aQute.libg/src/ $DEST/libg/src/main/java/   

mkdir -p $DEST/runtime/src/main/java
rsync --cvs-exclude -r --exclude '**/*.class' --exclude '**/*.jar' $SRC/aQute.runtime/src/ $DEST/runtime/src/main/java/   

mkdir -p $DEST/service/src/main/java
rsync --cvs-exclude -r --exclude '**/*.class' --exclude '**/*.jar' $SRC/aQute.service/src/ $DEST/service/src/main/java/   

mkdir -p $DEST/core/src/main/bnd
mkdir -p $DEST/core/src/main/java
mkdir -p $DEST/core/src/main/resources
mkdir -p $DEST/core/src/test/java
mkdir -p $DEST/core/src/test/resources

rsync --cvs-exclude -r $SRC/aQute.bnd/*.bnd $SRC/aQute.bnd/bnd.version $SRC/aQute.bnd/plugin.xml $DEST/core/src/main/bnd
rsync --cvs-exclude -r --exclude 'test' --exclude 'biz' --exclude 'swing2swt' --exclude '**/*.class' --exclude '**/*.jar' --exclude '**/*.properties' --exclude '**/*Test.java' --exclude 'aQute/bnd/plugin' --exclude 'aQute/bnd/launch' --exclude 'aQute/bnd/junit' --exclude 'aQute/bnd/jareditor' --exclude 'aQute/bnd/classpath' $SRC/aQute.bnd/src/ $DEST/core/src/main/java/   
rsync --cvs-exclude -r --exclude '**/*.jar' $SRC/aQute.bnd/src/aQute/bnd/test $DEST/core/src/main/java/aQute/bnd/
rsync --cvs-exclude -r $SRC/aQute.bnd/META-INF $SRC/aQute.bnd/icons $DEST/core/src/main/resources/   
rsync -avmr --filter='+ */' --filter='+ *.properties' --filter='- *' $SRC/aQute.bnd/src/ $DEST/core/src/main/resources/   

#rsync --cvs-exclude -r --exclude 'com.acme' --exclude 'iht' --exclude 'include.bnd' --exclude 'repo' --exclude 'resourcesonly' --exclude 'signing' --exclude 'split' --exclude '*.jar' --exclude '*.class' --exclude '*.jclass' --exclude '*.clazz' --exclude '*.bnd' --exclude '*.mf' --exclude '*.prop' --exclude '*.info' --exclude '*.spring' $SRC/aQute.bnd/src/test $DEST/core/src/test/java/
#cd $SRC/aQute.bnd/src/test
#rsync --cvs-exclude -r com.acme iht include.bnd repo resourcesonly signing split *.jar *.class *.jclass *.clazz *.bnd *.mf *.prop *.info *.spring $DEST/core/src/test/resources/test
#cd -
#rsync --cvs-exclude -r $SRC/aQute.bnd/test/ $DEST/core/src/test/resources/   
#rsync --cvs-exclude -r $SRC/aQute.bnd/bnd $DEST/core/src/test/resources/

mkdir -p $DEST/compilerversions/src/main/java
mkdir -p $DEST/compilerversions/src/main/bnd

echo 'mkdir -p target/classes' > .cp.sh
cat .cp.sh $SRC/aQute.bnd/compilerversions/compile.sh | sed 's|-cp src|-d target/classes -cp target/classes|' | sed 's|src/|src/main/java/|' > $DEST/compilerversions/compile.sh
chmod +x $DEST/compilerversions/compile.sh
rm .cp.sh
cp $SRC/aQute.bnd/compilerversions/*.gif $DEST/compilerversions/
cp $SRC/aQute.bnd/compilerversions/compilerversions.bnd $DEST/compilerversions/src/main/bnd
rsync --cvs-exclude -r --exclude '**/*.class' $SRC/aQute.bnd/compilerversions/src/ $DEST/compilerversions/src/main/java

mkdir -p $DEST/eclipse/src/main/java/aQute/bnd

rsync --cvs-exclude -r --exclude 'test' --exclude 'aQute' --exclude '**/*.class' --exclude '**/*.jar' $SRC/aQute.bnd/src/ $DEST/eclipse/src/main/java/   
rsync --cvs-exclude -r $SRC/aQute.bnd/src/aQute/bnd/plugin $SRC/aQute.bnd/src/aQute/bnd/launch $SRC/aQute.bnd/src/aQute/bnd/junit $SRC/aQute.bnd/src/aQute/bnd/jareditor $SRC/aQute.bnd/src/aQute/bnd/classpath $DEST/eclipse/src/main/java/aQute/bnd  

#rsync --cvs-exclude -r $SRC/aQute.bnd/jar $DEST/core/src/test/resources
mkdir -p $DEST/src/main/assembly
mkdir -p $DEST/src/main/resources
cp $SRC/aQute.bnd/plugin.xml $DEST/src/main/resources
cp $SRC/aQute.bnd/FEATURE* $DEST
cp $SRC/aQute.bnd/LICENSE $DEST
cp $SRC/aQute.bnd/TODO $DEST
cp $SRC/aQute.bnd/testreqs $DEST

#echo "Perl back magic..."
#perl -p -i -e 's|src/test|src/test/java/test|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|"bin"|"target/test-classes"|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|"aQute\.bnd"|"core"|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|TargetFolder=test|TargetFolder=src/test/resources|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|\"/=src/test|"/=src/test/java/test|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|extends TestCase|extends BaseTestCase|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|new File\("bin"\)|binDir|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|new File\("src"\)|srcDir|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|new File\("(.*)"\)|locateFile("\1")|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|locateFile\("src/|locateFile("|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|locateFile\("test"\)|testSrcDir|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|contains\("src/test|contains("test|g' $DEST/core/src/test/java/test/*.java
#perl -p -i -e 's|\"src\"|srcDir.getAbsolutePath()|g' $DEST/core/src/test/java/test/*.java

echo "Create Maven and Eclipse files..."
cat > $DEST/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>bnd-parent</artifactId>
  <version>${VERSION}</version>
  <packaging>pom</packaging>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool parent</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
  <modules>
    <module>libg</module>
    <module>core</module>
    <module>service</module>
    <module>runtime</module>
    <!--module>eclipse</module-->
  </modules> 
  <build>
    <plugins>
      <plugin>
        <artifactId>maven-assembly-plugin</artifactId>
        <configuration>
          <descriptors>
            <descriptor>src/main/assembly/dist.xml</descriptor>
          </descriptors>
        </configuration>
        <executions>
          <execution>
            <id>make-assembly</id> <!-- this is used for inheritance merges -->
            <phase>package</phase> <!-- append to the packaging phase. -->
            <goals>
              <goal>single</goal> <!-- goals == mojos -->
            </goals>
          </execution>
        </executions>
      </plugin>
    </plugins>
  </build> 
</project>
EOF

cat > $DEST/core/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>core</artifactId>
  <version>${VERSION}</version>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool - core</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
  <build>
  	<testResources>
  		<testResource>
  			<filtering>false</filtering>
  			<directory>src/test/resources</directory>
  			<includes>
  				<include>**/*</include>
  			</includes>
  		</testResource>
  	</testResources>
    <plugins>
      <plugin>
        <artifactId>maven-compiler-plugin</artifactId>
        <configuration>
          <source>1.5</source>
          <target>1.5</target>
        </configuration>
      </plugin>
    </plugins>
  </build>
  <repositories>
  	<repository>
  		<releases>
  			<enabled>true</enabled>
  		</releases>
  		<snapshots>
  			<enabled>false</enabled>
  		</snapshots>
  		<id>eclipse</id>
  		<name>Eclipse repository</name>
  		<url>http://repository.sonatype.org/content/repositories/eclipse</url>
  	</repository>
  </repositories>
  <dependencies>
    <dependency>
      <groupId>org.apache.ant</groupId>
      <artifactId>ant</artifactId>
      <version>1.7.0</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>biz.aQute</groupId>
      <artifactId>libg</artifactId>
      <version>\${project.version}</version>
    </dependency>
    <dependency>
      <groupId>biz.aQute</groupId>
      <artifactId>service</artifactId>
      <version>\${project.version}</version>
    </dependency>
    <dependency>
      <groupId>junit</groupId>
      <artifactId>junit</artifactId>
      <version>3.8.2</version>
      <scope>test</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.osgi.services</artifactId>
      <version>3.1.200.v20070605</version>
      <scope>test</scope>
    </dependency>
  </dependencies>
</project>
EOF

cat > $DEST/libg/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>libg</artifactId>
  <version>${VERSION}</version>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool - libg</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
  <build>
    <plugins>
      <plugin>
        <artifactId>maven-compiler-plugin</artifactId>
        <configuration>
          <source>1.5</source>
          <target>1.5</target>
        </configuration>
      </plugin>
    </plugins>
  </build>
</project>
EOF

cat > $DEST/service/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>service</artifactId>
  <version>${VERSION}</version>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool - service</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
  <build>
    <plugins>
      <plugin>
        <artifactId>maven-compiler-plugin</artifactId>
        <configuration>
          <source>1.5</source>
          <target>1.5</target>
        </configuration>
      </plugin>
    </plugins>
  </build>
</project>
EOF

cat > $DEST/runtime/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>runtime</artifactId>
  <version>${VERSION}</version>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool - runtime</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
  <build>
    <plugins>
      <plugin>
        <artifactId>maven-compiler-plugin</artifactId>
        <configuration>
          <source>1.5</source>
          <target>1.5</target>
        </configuration>
      </plugin>
    </plugins>
  </build>
  <repositories>
  	<repository>
  		<releases>
  			<enabled>true</enabled>
  		</releases>
  		<snapshots>
  			<enabled>false</enabled>
  		</snapshots>
  		<id>eclipse</id>
  		<name>Eclipse repository</name>
  		<url>http://repository.sonatype.org/content/repositories/eclipse</url>
  	</repository>
  </repositories>
  <dependencies>
    <dependency>
      <groupId>junit</groupId>
      <artifactId>junit</artifactId>
      <version>3.8.2</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.osgi</artifactId>
      <version>3.5.0.v20090520</version>
      <scope>compile</scope>
    </dependency>
  </dependencies>
</project>
EOF

cat > $DEST/eclipse/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>eclipse</artifactId>
  <version>${VERSION}</version>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool - eclipse support</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
  <build>
    <plugins>
      <plugin>
        <artifactId>maven-compiler-plugin</artifactId>
        <configuration>
          <source>1.5</source>
          <target>1.5</target>
        </configuration>
      </plugin>
    </plugins>
  </build>
  <repositories>
  	<repository>
  		<releases>
  			<enabled>true</enabled>
  		</releases>
  		<snapshots>
  			<enabled>false</enabled>
  		</snapshots>
  		<id>eclipse</id>
  		<name>Eclipse repository</name>
  		<url>http://repository.sonatype.org/content/repositories/eclipse</url>
  	</repository>
  </repositories>
  <!-- All org.eclipse.* dependencies require that you get the Eclipse 3.2 distribution (NOT 3.2.x)
       and manually deploy the various plugins to your repository, e.g. using mvn deploy:deploy-file.
       Which plugin files to deploy should be fairly straight forward to figure out given the
       artifactId and version below -->
  <dependencies>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.osgi</artifactId>
      <!--version>3.2.0-v20060601</version-->
      <version>3.2.1.R32x_v20060919</version> 
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.equinox.common</artifactId>
      <version>3.2.0.v20060603</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.core.resources</artifactId>
      <!--version>3.2.0.v20060603</version-->
      <version>3.2.1.R32x_v20060914</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.core.runtime</artifactId>
      <version>3.2.0.v20060603</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.core.jobs</artifactId>
      <version>3.2.0.v20060603</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.equinox.registry</artifactId>
      <!--version>3.2.0.v20060603</version-->
      <version>3.2.1.R32x_v20060814</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.jface</artifactId>
      <!-- version>3.2.0-I20060605-1400</version-->
      <version>3.2.1.M20060908-1000</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.ui.workbench</artifactId>
      <!--version>3.2.0-I20060605-1400</version-->
      <version>3.2.1.M20060906-0800</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.swt.win32.win32.x86</artifactId>
      <!--version>3.2.0.v3232</version-->
      <version>3.2.1.v3235</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.eclipse</groupId>
      <artifactId>org.eclipse.jdt.core</artifactId>
      <!--version>3.2.0.v_671</version-->
      <version>3.2.1.v_677_R32x</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>org.apache.ant</groupId>
      <artifactId>ant</artifactId>
      <version>1.7.0</version>
      <scope>compile</scope>
    </dependency>
    <dependency>
      <groupId>biz.aQute</groupId>
      <artifactId>core</artifactId>
      <version>\${project.version}</version>
    </dependency>
  </dependencies>
</project>
EOF

cat > $DEST/core/.classpath <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<classpath>
	<classpathentry including="**/*.java" kind="src" path="src/main/java"/>
	<classpathentry including="**/*.java" kind="src" output="target/test-classes" path="src/test/java"/>
	<classpathentry kind="con" path="org.eclipse.iam.jdt.core.mavenClasspathContainer"/>
	<classpathentry kind="con" path="org.eclipse.jdt.launching.JRE_CONTAINER"/>
	<classpathentry kind="output" path="target/classes"/>
</classpath>
EOF

cat > $DEST/core/.project <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<projectDescription>
	<name>core</name>
	<comment></comment>
	<projects>
	</projects>
	<buildSpec>
		<buildCommand>
			<name>org.eclipse.jdt.core.javabuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
		<buildCommand>
			<name>org.eclipse.iam.jdt.core.mavenIncrementalBuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
	</buildSpec>
	<natures>
		<nature>org.eclipse.iam.jdt.core.mavenNature</nature>
		<nature>org.eclipse.jdt.core.javanature</nature>
	</natures>
</projectDescription>
EOF

#cat > $DEST/core/src/test/java/test/BaseTestCase.java <<EOF
#package test;
#
#import java.io.File;
#
#import junit.framework.TestCase;
#
#public class BaseTestCase extends TestCase {
#
#	protected File binDir;
#	protected File srcDir;
#	protected File testSrcDir;
#	
#	protected void setUp() throws Exception {
#		super.setUp();
#		binDir = new File("target/test-classes");
#		if (!binDir.exists()) {
#			binDir = new File("bin");
#		}
#		srcDir = new File("src/test/java");
#		testSrcDir = new File(srcDir, "test");
#	}
#	
#	protected File locateFile(String relPath) {
#		File found = null;
#		if (getClass().getResource("/" + relPath) != null) {
#			String path = getClass().getResource("/" + relPath).getPath();
#			path = path.replace("file:", "");
#			System.out.println(path);
#			found = new File(path);
#			if (!found.exists()) {
#				found = null;
#			}
#		}
#		if (found == null) {
#			found = new File("src/test/resources/" + relPath);
#			if (!found.exists()) {
#				found = new File("src/test/java/" + relPath);
#			}
#		}
#		return found;
#	}
#}
#EOF

cat > $DEST/eclipse/.classpath <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<classpath>
	<classpathentry including="**/*.java" kind="src" path="src/main/java"/>
	<classpathentry kind="con" path="org.eclipse.iam.jdt.core.mavenClasspathContainer"/>
	<classpathentry kind="con" path="org.eclipse.jdt.launching.JRE_CONTAINER"/>
	<classpathentry kind="output" path="target/classes"/>
</classpath>
EOF

cat > $DEST/eclipse/.project <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<projectDescription>
	<name>eclipse</name>
	<comment></comment>
	<projects>
	</projects>
	<buildSpec>
		<buildCommand>
			<name>org.eclipse.jdt.core.javabuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
		<buildCommand>
			<name>org.eclipse.iam.jdt.core.mavenIncrementalBuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
	</buildSpec>
	<natures>
		<nature>org.eclipse.iam.jdt.core.mavenNature</nature>
		<nature>org.eclipse.jdt.core.javanature</nature>
	</natures>
</projectDescription>
EOF

cat > $DEST/libg/.classpath <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<classpath>
	<classpathentry including="**/*.java" kind="src" path="src/main/java"/>
	<classpathentry kind="con" path="org.eclipse.iam.jdt.core.mavenClasspathContainer"/>
	<classpathentry kind="con" path="org.eclipse.jdt.launching.JRE_CONTAINER"/>
	<classpathentry kind="output" path="target/classes"/>
</classpath>
EOF

cat > $DEST/libg/.project <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<projectDescription>
	<name>libg</name>
	<comment></comment>
	<projects>
	</projects>
	<buildSpec>
		<buildCommand>
			<name>org.eclipse.jdt.core.javabuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
		<buildCommand>
			<name>org.eclipse.iam.jdt.core.mavenIncrementalBuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
	</buildSpec>
	<natures>
		<nature>org.eclipse.iam.jdt.core.mavenNature</nature>
		<nature>org.eclipse.jdt.core.javanature</nature>
	</natures>
</projectDescription>
EOF

cat > $DEST/runtime/.classpath <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<classpath>
	<classpathentry including="**/*.java" kind="src" path="src/main/java"/>
	<classpathentry kind="con" path="org.eclipse.iam.jdt.core.mavenClasspathContainer"/>
	<classpathentry kind="con" path="org.eclipse.jdt.launching.JRE_CONTAINER"/>
	<classpathentry kind="output" path="target/classes"/>
</classpath>
EOF

cat > $DEST/runtime/.project <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<projectDescription>
	<name>runtime</name>
	<comment></comment>
	<projects>
	</projects>
	<buildSpec>
		<buildCommand>
			<name>org.eclipse.jdt.core.javabuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
		<buildCommand>
			<name>org.eclipse.iam.jdt.core.mavenIncrementalBuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
	</buildSpec>
	<natures>
		<nature>org.eclipse.iam.jdt.core.mavenNature</nature>
		<nature>org.eclipse.jdt.core.javanature</nature>
	</natures>
</projectDescription>
EOF

cat > $DEST/service/.classpath <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<classpath>
	<classpathentry including="**/*.java" kind="src" path="src/main/java"/>
	<classpathentry kind="con" path="org.eclipse.iam.jdt.core.mavenClasspathContainer"/>
	<classpathentry kind="con" path="org.eclipse.jdt.launching.JRE_CONTAINER"/>
	<classpathentry kind="output" path="target/classes"/>
</classpath>
EOF

cat > $DEST/service/.project <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<projectDescription>
	<name>service</name>
	<comment></comment>
	<projects>
	</projects>
	<buildSpec>
		<buildCommand>
			<name>org.eclipse.jdt.core.javabuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
		<buildCommand>
			<name>org.eclipse.iam.jdt.core.mavenIncrementalBuilder</name>
			<arguments>
			</arguments>
		</buildCommand>
	</buildSpec>
	<natures>
		<nature>org.eclipse.iam.jdt.core.mavenNature</nature>
		<nature>org.eclipse.jdt.core.javanature</nature>
	</natures>
</projectDescription>
EOF

cat > $DEST/src/main/assembly/dist.xml <<EOF
<assembly>
  <id>dist</id>
  <formats>
    <format>jar</format>
  </formats>
  <includeBaseDirectory>false</includeBaseDirectory>
  <moduleSets>
    <moduleSet>
      <excludes>
        <exclude>biz.aQute:runtime:*</exclude> 
      </excludes> 
      <sources>
        <includeModuleDirectory>false</includeModuleDirectory>
        <fileSets>
          <fileSet>
            <outputDirectory>OSGI-OPT/src</outputDirectory>
            <directory>src/main/java</directory>
            <excludes>
              <exclude>DefaultPackage.java</exclude>
              <exclude>aQute/lib/signing/**</exclude>
              <exclude>aQute/lib/spring/**</exclude>
              <exclude>aQute/libg/asn1/**</exclude>
              <exclude>aQute/libg/classdump/**</exclude>
              <exclude>aQute/libg/clauses/**</exclude>
              <exclude>aQute/libg/log/**</exclude>
            </excludes>
          </fileSet>
        </fileSets>
      </sources>
      <binaries>
        <includeDependencies>false</includeDependencies>
        <unpack>true</unpack>
        <unpackOptions>
          <includes> 
            <include>aQute/**</include>
            <include>icons/**</include>
          </includes> 
          <!-- Doesn't seem to work, TODO: report bug -->
          <excludes>
            <exclude>*.classes</exclude>
            <exclude>DefaultPackage.class</exclude>
            <exclude>aQute/lib/signing/**</exclude>
            <exclude>aQute/lib/spring/**</exclude>
            <exclude>aQute/libg/asn1/**</exclude>
            <exclude>aQute/libg/classdump/**</exclude>
            <exclude>aQute/libg/clauses/**</exclude>
            <exclude>aQute/libg/log/**</exclude>
          </excludes>
        </unpackOptions>
        <outputDirectory></outputDirectory>
      </binaries>
    </moduleSet>
  </moduleSets>
  <fileSets>
    <fileSet>
      <includes>
        <include>\${project.basedir}/LICENSE</include>
        <include>\${project.basedir}/src/main/resources/*.xml</include>
      </includes>
      <useDefaultExcludes>true</useDefaultExcludes>
    </fileSet>
  </fileSets>
</assembly>
EOF

cat > $DEST/src/main/resources/pom.xml <<EOF
<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>
  <modelVersion>4.0.0</modelVersion>
  <groupId>biz.aQute</groupId>
  <artifactId>bnd</artifactId>
  <version>${VERSION}</version>
  <packaging>jar</packaging>
  <description>
    A utility and plugin to wrap, build, or print bundles
  </description>
  <name>aQute Bundle Tool</name>
  <url>http://www.aQute.biz/Code/Bnd</url>
  <organization>
    <name>aQute SARL</name>
    <url>http://www.aQute.biz</url>
  </organization>
  <licenses>
    <license>
    <name>This material is licensed under the Apache Software License, Version 2.0</name>
    <url>http://www.apache.org/licenses/LICENSE-2.0</url>
    <distribution>repo</distribution>
    </license>
  </licenses>
</project>
EOF

cat > $DEST/build <<EOF
#!/bin/sh
mvn -Dmaven.test.skip=true install
EOF

echo "Done."
