/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0105


#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Multiline_Output.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Button.H>
#include <join_ring_dialog.h>
#include <iostream>


static const char* istruction_join_ring_dialog=
"-------------------------------------------------\n"
"This simple Plug-in try to \"melt\" two molecules\n"
"in a dummy but somehow useful way. To use\n"
"it just press the \"OK\" button below and\n"
"select four atoms with \"Select Element\"\n"
"button on the left toolbar.\n\n"
"Example:\n\n"
"----A       C----\n"
"     |        |   \n"
"     |        |   \n"
"     |        |   \n"
"----B       D----\n\n\n"
"If you have selected \"A, B, C, D\" (in that order)\n"
"you shold get something like:\n\n"
"----C----\n"
"      |   \n"
"      |   \n"
"      |   \n"
"----D----\n"
"\n"
"If you select the checkbox below Atoms A and B\n"
"will be deleted otherwise will be only highlighted\n\n"
"--------------------------------------------------";


void join_plugin_cb(Fl_Widget* w, void* d){
  Fl_Double_Window* win=dynamic_cast<Fl_Double_Window*>(w->parent());
  win->hide();
}

Fl_Double_Window* make_join_ring_dialog() {
  Fl_Double_Window* a = new Fl_Double_Window(400, 315, "Join Rings");
  
  Fl_Box*  b= new Fl_Box(10, 5, 375, 265);
  b->box(FL_EMBOSSED_BOX);
  a->add(b);

  Fl_Multiline_Output* c=new Fl_Multiline_Output(20, 15, 355, 215);
  c->value(istruction_join_ring_dialog);
  a->add(c);

  Fl_Check_Button* d = new Fl_Check_Button(20, 240, 160, 30, "Delete \"old\" atom(s)");
  d->down_box(FL_DOWN_BOX);
  a->add(d);

  Fl_Button* e=new Fl_Button(147, 275, 105, 35, "OK");
  e->callback(join_plugin_cb);
  a->add(e);
    
  a->end();
  
  a->set_modal();
  a->show();
   
  return a;
}

