/*
 * Copyright (c) 2005, 2006 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "watchermainact.h"
#include "searchfilter.h"
#include "verse.h"
#include "mainact.h"
#include <qstring.h>
#include "qt_types.h"
using namespace bmemcore;

namespace bmemui
{

WatcherMainAct::WatcherMainAct(MainAct& mainAct, Verse& verse,
        SearchFilter* searchFilter)
:mMainAct(mainAct), mVerse(verse), mSearchFilter(searchFilter)
{
    mMainAct.addWatcher(this);
    mListBoxText = 0;
    mVerse.addWatcher(this);
    newFilter(searchFilter);
}


WatcherMainAct::~WatcherMainAct()
{
    killListBoxText();
    mMainAct.removeWatcher(this);
}

//We are only watching one verse, so the parameter is superfluous.
void WatcherMainAct::verseChanged(const Verse&,
        VerseWatcher::ChangeType whatChanged)
{
    switch (whatChanged)
    {
    case CHANGE_BOOK:
    case CHANGE_UBOOK:
    case CHANGE_CHAPTER:
    case CHANGE_VERSES:
        textChanged = true;
        handleFilter();
        break;
    case CHANGE_DESTROYED:
        delete this;
        break;
    default:
        //do nothing
        break;
    }
}

void WatcherMainAct::newFilter(SearchFilter* theFilter)
{
    mSearchFilter = theFilter;
    handleFilter();
}

void WatcherMainAct::handleFilter()
{
    //int index = -1;
    if (mSearchFilter->allows(mVerse))
    {
        if (textChanged)
        {
            //if (mListBoxText != 0)
            //    index = mListBox.index(mListBoxText);
            killListBoxText();
            mListBoxText = new BQListBoxText(mVerse.getReference());
            //mListBox.insertItem(mListBoxText, index);
            mMainAct.associateListItem(mListBoxText, &mVerse);
        }
        else if (mListBoxText == 0)
        {
            mListBoxText = new BQListBoxText(mVerse.getReference());
            //mListBox.insertItem(mListBoxText, index);
            mMainAct.associateListItem(mListBoxText, &mVerse);
        }
    }
    else
    {
        killListBoxText();
    }
    textChanged = false;
}

void WatcherMainAct::killListBoxText()
{
    if (mListBoxText != 0)
    {
        mMainAct.dissociateListItem(mListBoxText);
        //delete mListBoxText;
        mListBoxText = 0;
    }
}

}

