/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_VERSIFICATION_H
#define INCLUDED_VERSIFICATION_H


#include "libraries.h"
#include <sqlite3.h>


ustring versification_get_name (ustring path);
vector<ustring> versification_get_raw_templates_available ();
void versification_get_ones_available (vector<ustring>& versifications);
void versification_create_book_template (const ustring& versification, const ustring& book, vector<ustring>& booktemplate);
void versification_create_chapter_template (const ustring& versification, const ustring& book, unsigned int chapter, vector<ustring>& chaptertemplate);
vector <unsigned int> versification_get_chapters (const ustring& versification, const ustring& book);
ustring versification_get_last_verse (const ustring& versification, const ustring& book, unsigned int chapter);
void versification_import_textfile (const ustring& name, const ustring& textfile);


#endif
