/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "dialogselectbooks.h"
#include "bible.h"
#include "books.h"
#include "session.h"
#include "help.h"


SelectBooksDialog::SelectBooksDialog (SelectBookDialogActions action,
                                      const vector <unsigned int>& selectablebooks,
                                      set <unsigned int>& selection,
                                      const ustring& language):
  genconfig (0)                                      
{
  // Save variables.
  mylanguage = language;
  
  // Build dialog.  
  selectbooksdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (selectbooksdialog), "Select books");
  gtk_window_set_position (GTK_WINDOW (selectbooksdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (selectbooksdialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (selectbooksdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (hbox2), hbox3, TRUE, TRUE, 0);

  // Produce six sets of the books to be displayed in the six columns.
  unsigned int amount = selectablebooks.size();
  unsigned int amount1 = (amount / 6);
  unsigned int amount2 = (amount / 6);
  unsigned int amount3 = (amount / 6);
  unsigned int amount4 = (amount / 6);
  unsigned int amount5 = (amount / 6);
  unsigned int amount6 = (amount / 6);
  unsigned int remainder = amount % 6;
  switch (remainder) {
    case 5: amount5++;
    case 4: amount4++; 
    case 3: amount3++;
    case 2: amount2++;
    case 1: amount1++;
  }
  unsigned int limit1 = amount1;
  unsigned int limit2 = limit1 + amount2;
  unsigned int limit3 = limit2 + amount3;
  unsigned int limit4 = limit3 + amount4;
  unsigned int limit5 = limit4 + amount5;
  unsigned int limit6 = limit5 + amount6;
  set <unsigned int> set1;
  set <unsigned int> set2;
  set <unsigned int> set3;
  set <unsigned int> set4;
  set <unsigned int> set5;
  set <unsigned int> set6;
  for (unsigned int i = 0; i < amount; i++) {
    if (i < limit1) {
      set1.insert (selectablebooks[i]);
    } else if (i < limit2) {
      set2.insert (selectablebooks[i]);
    } else if (i < limit3) {
      set3.insert (selectablebooks[i]);
    } else if (i < limit4) {
      set4.insert (selectablebooks[i]);
    } else if (i < limit5) {
      set5.insert (selectablebooks[i]);
    } else if (i < limit6) {
      set6.insert (selectablebooks[i]);
    }
  }

  // The iterator goes through all models.
  GtkTreeIter iter;

  // Six stores to hold all information.
  store1 = gtk_list_store_new (1, G_TYPE_STRING);
  store2 = gtk_list_store_new (1, G_TYPE_STRING);
  store3 = gtk_list_store_new (1, G_TYPE_STRING);
  store4 = gtk_list_store_new (1, G_TYPE_STRING);
  store5 = gtk_list_store_new (1, G_TYPE_STRING);
  store6 = gtk_list_store_new (1, G_TYPE_STRING);

  // Add the data to each of the 6 stores.
  for (unsigned int i = 0; i < selectablebooks.size (); i++) {
    if (set1.find (selectablebooks[i]) != set1.end ())
    {
      gtk_list_store_append (store1, &iter);
      gtk_list_store_set (store1, &iter, 0, books_id_to_name (language, selectablebooks[i]).c_str (), -1);
    }
    else if (set2.find (selectablebooks[i]) != set2.end ())
    {
      gtk_list_store_append (store2, &iter);
      gtk_list_store_set (store2, &iter, 0, books_id_to_name (language, selectablebooks[i]).c_str (), -1);
    }
    else if (set3.find (selectablebooks[i]) != set3.end ())
    {
      gtk_list_store_append (store3, &iter);
      gtk_list_store_set (store3, &iter, 0, books_id_to_name (language, selectablebooks[i]).c_str (), -1);
    }
    else if (set4.find (selectablebooks[i]) != set4.end ())
    {
      gtk_list_store_append (store4, &iter);
      gtk_list_store_set (store4, &iter, 0, books_id_to_name (language, selectablebooks[i]).c_str (), -1);
    }
    else if (set5.find (selectablebooks[i]) != set5.end ())
    {
      gtk_list_store_append (store5, &iter);
      gtk_list_store_set (store5, &iter, 0, books_id_to_name (language, selectablebooks[i]).c_str (), -1);
    }
    else if (set6.find (selectablebooks[i]) != set6.end ())
    {
      gtk_list_store_append (store6, &iter);
      gtk_list_store_set (store6, &iter, 0, books_id_to_name (language, selectablebooks[i]).c_str (), -1);
    }
  }

  // Point to the input selection.
  myselection = &selection;

  // Text cell renderer.
  GtkCellRenderer *renderer;
  renderer = gtk_cell_renderer_text_new ();

  // The six treeviews, deal with each of them.
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox2, TRUE, TRUE, 0);

  treeview1 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store1));
  gtk_widget_show (treeview1);
  gtk_box_pack_start (GTK_BOX (vbox2), treeview1, TRUE, TRUE, 0);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview1), FALSE);
  column1 = gtk_tree_view_column_new_with_attributes ("", renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview1), column1);

  label11 = gtk_label_new_with_mnemonic ("_1");
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (vbox2), label11, FALSE, FALSE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox3, TRUE, TRUE, 0);

  treeview2 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store2));
  gtk_widget_show (treeview2);
  gtk_box_pack_start (GTK_BOX (vbox3), treeview2, TRUE, TRUE, 0);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview2), FALSE);
  column2 = gtk_tree_view_column_new_with_attributes ("", renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview2), column2);

  label12 = gtk_label_new_with_mnemonic ("_2");
  gtk_widget_show (label12);
  gtk_box_pack_start (GTK_BOX (vbox3), label12, FALSE, FALSE, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox4, TRUE, TRUE, 0);

  treeview3 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store3));
  gtk_widget_show (treeview3);
  gtk_box_pack_start (GTK_BOX (vbox4), treeview3, TRUE, TRUE, 0);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview3), FALSE);
  column3 = gtk_tree_view_column_new_with_attributes ("", renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview3), column3);

  label13 = gtk_label_new_with_mnemonic ("_3");
  gtk_widget_show (label13);
  gtk_box_pack_start (GTK_BOX (vbox4), label13, FALSE, FALSE, 0);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox5, TRUE, TRUE, 0);

  treeview4 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store4));
  gtk_widget_show (treeview4);
  gtk_box_pack_start (GTK_BOX (vbox5), treeview4, TRUE, TRUE, 0);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview4), FALSE);
  column4 = gtk_tree_view_column_new_with_attributes ("", renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview4), column4);

  label14 = gtk_label_new_with_mnemonic ("_4");
  gtk_widget_show (label14);
  gtk_box_pack_start (GTK_BOX (vbox5), label14, FALSE, FALSE, 0);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox6, TRUE, TRUE, 0);

  treeview5 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store5));
  gtk_widget_show (treeview5);
  gtk_box_pack_start (GTK_BOX (vbox6), treeview5, TRUE, TRUE, 0);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview5), FALSE);
  column5 = gtk_tree_view_column_new_with_attributes ("", renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview5), column5);

  label15 = gtk_label_new_with_mnemonic ("_5");
  gtk_widget_show (label15);
  gtk_box_pack_start (GTK_BOX (vbox6), label15, FALSE, FALSE, 0);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox7);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox7, TRUE, TRUE, 0);

  treeview6 = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store6));
  gtk_widget_show (treeview6);
  gtk_box_pack_start (GTK_BOX (vbox7), treeview6, TRUE, TRUE, 0);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview6), FALSE);
  column6 = gtk_tree_view_column_new_with_attributes ("", renderer, "text", 0, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview6), column6);

  label16 = gtk_label_new_with_mnemonic ("_6");
  gtk_widget_show (label16);
  gtk_box_pack_start (GTK_BOX (vbox7), label16, FALSE, FALSE, 0);

  // Set up the selection for each of the 6 tree views.
  select1 = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview1));
  gtk_tree_selection_set_mode (select1, GTK_SELECTION_MULTIPLE);

  select2 = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview2));
  gtk_tree_selection_set_mode (select2, GTK_SELECTION_MULTIPLE);

  select3 = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview3));
  gtk_tree_selection_set_mode (select3, GTK_SELECTION_MULTIPLE);

  select4 = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview4));
  gtk_tree_selection_set_mode (select4, GTK_SELECTION_MULTIPLE);

  select5 = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview5));
  gtk_tree_selection_set_mode (select5, GTK_SELECTION_MULTIPLE);

  select6 = gtk_tree_view_get_selection (GTK_TREE_VIEW (treeview6));
  gtk_tree_selection_set_mode (select6, GTK_SELECTION_MULTIPLE);

  // Unreference the stores once, so they get destroyed with the treeview.
  g_object_unref (store1);
  g_object_unref (store2);
  g_object_unref (store3);
  g_object_unref (store4);
  g_object_unref (store5);
  g_object_unref (store6);
  
  // Info label.
  ustring info;
  switch (action)
  {
    case sbAdd:
    {
      info = "This is a list of books that can be added to the project";
      if (selectablebooks.size () == 0)
        info.append ("\n(none are shown because the project is full)");
      break;
    }
    case sbDelete:
    {
      info = "This is a list of books that can be deleted from the project";
      if (selectablebooks.size () == 0)
        info.append ("\n(none are shown because the project is empty)");
      break;
    }
    case sbSearch:
    {
      info = "Select or deselect books to search in";
      if (selectablebooks.size () == 0)
        info.append ("\n(none are shown because the project is empty)");
      initially_select_books ();
      break;
    }
    case sbCheck:
    {
      info = "Select or deselect books to check";
      if (selectablebooks.size () == 0)
        info.append ("\n(none are shown because the project is empty)");
      initially_select_books ();
      break;
    }
    case sbImport:
    {
      info = "Select or deselect books to import";
      if (selectablebooks.size () == 0)
        info.append ("\n(there were no files that could be imported into the project)");
      initially_select_books ();
      break;
    }
  }
  label5 = gtk_label_new (info.c_str ());
  gtk_widget_show (label5);
  gtk_box_pack_start (GTK_BOX (vbox1), label5, FALSE, FALSE, 10);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  nobutton = gtk_button_new ();
  gtk_widget_show (nobutton);
  gtk_box_pack_start (GTK_BOX (hbox1), nobutton, FALSE, FALSE, 0);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (nobutton), alignment1);

  hbox4 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox4);

  image1 = gtk_image_new_from_stock ("gtk-clear", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image1);
  gtk_box_pack_start (GTK_BOX (hbox4), image1, FALSE, FALSE, 0);

  label6 = gtk_label_new_with_mnemonic ("No _books");
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox4), label6, FALSE, FALSE, 0);

  otbutton = gtk_button_new ();
  gtk_widget_show (otbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), otbutton, FALSE, FALSE, 0);

  alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment2);
  gtk_container_add (GTK_CONTAINER (otbutton), alignment2);

  hbox5 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (alignment2), hbox5);

  image2 = gtk_image_new_from_stock ("gtk-goto-first", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_box_pack_start (GTK_BOX (hbox5), image2, FALSE, FALSE, 0);

  label7 = gtk_label_new_with_mnemonic ("Old _Testament");
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox5), label7, FALSE, FALSE, 0);

  ntbutton = gtk_button_new ();
  gtk_widget_show (ntbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), ntbutton, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment3);
  gtk_container_add (GTK_CONTAINER (ntbutton), alignment3);

  hbox6 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (alignment3), hbox6);

  image3 = gtk_image_new_from_stock ("gtk-goto-last", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_box_pack_start (GTK_BOX (hbox6), image3, FALSE, FALSE, 0);

  label8 = gtk_label_new_with_mnemonic ("_New Testament");
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox6), label8, FALSE, FALSE, 0);

  otherbutton = gtk_button_new ();
  gtk_widget_show (otherbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), otherbutton, FALSE, FALSE, 0);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (otherbutton), alignment6);

  hbox9 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox9);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox9);

  image6 = gtk_image_new_from_stock ("gtk-dialog-warning", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image6);
  gtk_box_pack_start (GTK_BOX (hbox9), image6, FALSE, FALSE, 0);

  label11a = gtk_label_new_with_mnemonic ("Oth_er books");
  gtk_widget_show (label11a);
  gtk_box_pack_start (GTK_BOX (hbox9), label11a, FALSE, FALSE, 0);
  
  allbutton = gtk_button_new ();
  gtk_widget_show (allbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), allbutton, FALSE, FALSE, 0);

  alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (allbutton), alignment4);

  hbox7 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox7);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox7);

  image4 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image4);
  gtk_box_pack_start (GTK_BOX (hbox7), image4, FALSE, FALSE, 0);

  label9 = gtk_label_new_with_mnemonic ("_All books");
  gtk_widget_show (label9);
  gtk_box_pack_start (GTK_BOX (hbox7), label9, FALSE, FALSE, 0);

  currentbutton = gtk_button_new ();
  gtk_widget_show (currentbutton);
  gtk_box_pack_start (GTK_BOX (hbox1), currentbutton, FALSE, FALSE, 0);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (currentbutton), alignment5);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox8);

  image5 = gtk_image_new_from_stock ("gtk-properties", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image5);
  gtk_box_pack_start (GTK_BOX (hbox8), image5, FALSE, FALSE, 0);

  label10 = gtk_label_new_with_mnemonic ("C_urrent book");
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (hbox8), label10, FALSE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (selectbooksdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  help_button (dialog_action_area1, NULL, "selectbooks");

  cancelbutton = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (selectbooksdialog), cancelbutton, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);

  okbutton = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton);
  gtk_dialog_add_action_widget (GTK_DIALOG (selectbooksdialog), okbutton, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) nobutton, "clicked",
                    G_CALLBACK (on_nobutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) otbutton, "clicked",
                    G_CALLBACK (on_otbutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) ntbutton, "clicked",
                    G_CALLBACK (on_ntbutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) otherbutton, "clicked",
                    G_CALLBACK (on_otherbutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) allbutton, "clicked",
                    G_CALLBACK (on_allbutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) currentbutton, "clicked",
                    G_CALLBACK (on_currentbutton_clicked), gpointer (this));
  g_signal_connect ((gpointer) okbutton, "clicked",
                    G_CALLBACK (on_okbutton_clicked), gpointer (this));

  gtk_label_set_mnemonic_widget (GTK_LABEL (label11), treeview1);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label12), treeview2);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label13), treeview3);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label14), treeview4);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label15), treeview5);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label16), treeview6);

  gtk_widget_grab_focus (okbutton);
  gtk_widget_grab_default (okbutton);

}


SelectBooksDialog::~SelectBooksDialog ()
{
  gtk_widget_destroy (selectbooksdialog);
}


int SelectBooksDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (selectbooksdialog));
}


void SelectBooksDialog::on_none_clicked ()
{
  gtk_tree_selection_unselect_all (select1);
  gtk_tree_selection_unselect_all (select2);
  gtk_tree_selection_unselect_all (select3);
  gtk_tree_selection_unselect_all (select4);
  gtk_tree_selection_unselect_all (select5);
  gtk_tree_selection_unselect_all (select6);
}


void SelectBooksDialog::on_ot_clicked ()
{
  vector <unsigned int> ids = books_type_to_ids (btOldTestament);
  set<unsigned int> selection (ids.begin(), ids.end());
  select_books (&selection, GTK_TREE_MODEL (store1), select1, treeview1);
  select_books (&selection, GTK_TREE_MODEL (store2), select2, treeview2);
  select_books (&selection, GTK_TREE_MODEL (store3), select3, treeview3);
  select_books (&selection, GTK_TREE_MODEL (store4), select4, treeview4);
  select_books (&selection, GTK_TREE_MODEL (store5), select5, treeview5);
  select_books (&selection, GTK_TREE_MODEL (store6), select6, treeview6);
}


void SelectBooksDialog::on_nt_clicked () 
{
  vector <unsigned int> ids = books_type_to_ids (btNewTestament);
  set<unsigned int> selection (ids.begin(), ids.end());
  select_books (&selection, GTK_TREE_MODEL (store1), select1, treeview1);
  select_books (&selection, GTK_TREE_MODEL (store2), select2, treeview2);
  select_books (&selection, GTK_TREE_MODEL (store3), select3, treeview3);
  select_books (&selection, GTK_TREE_MODEL (store4), select4, treeview4);
  select_books (&selection, GTK_TREE_MODEL (store5), select5, treeview5);
  select_books (&selection, GTK_TREE_MODEL (store6), select6, treeview6);
}


void SelectBooksDialog::on_other_clicked ()
{
  set<unsigned int> selection;
  vector <unsigned int> ids = books_type_to_ids (btFrontBackMatter);
  for (unsigned int i = 0; i < ids.size(); i++)
    selection.insert (ids[i]);
  ids = books_type_to_ids (btOtherMaterial);
  for (unsigned int i = 0; i < ids.size(); i++)
    selection.insert (ids[i]);
  select_books (&selection, GTK_TREE_MODEL (store1), select1, treeview1);
  select_books (&selection, GTK_TREE_MODEL (store2), select2, treeview2);
  select_books (&selection, GTK_TREE_MODEL (store3), select3, treeview3);
  select_books (&selection, GTK_TREE_MODEL (store4), select4, treeview4);
  select_books (&selection, GTK_TREE_MODEL (store5), select5, treeview5);
  select_books (&selection, GTK_TREE_MODEL (store6), select6, treeview6);
}


void SelectBooksDialog::on_all_clicked ()
{
  gtk_tree_selection_select_all (select1);
  gtk_tree_selection_select_all (select2);
  gtk_tree_selection_select_all (select3);
  gtk_tree_selection_select_all (select4);
  gtk_tree_selection_select_all (select5);
  gtk_tree_selection_select_all (select6);
}


void SelectBooksDialog::on_current_clicked ()
{
  set<unsigned int> currentselection;
  currentselection.insert (genconfig.book());
  select_books (&currentselection, GTK_TREE_MODEL (store1), select1, treeview1);
  select_books (&currentselection, GTK_TREE_MODEL (store2), select2, treeview2);
  select_books (&currentselection, GTK_TREE_MODEL (store3), select3, treeview3);
  select_books (&currentselection, GTK_TREE_MODEL (store4), select4, treeview4);
  select_books (&currentselection, GTK_TREE_MODEL (store5), select5, treeview5);
  select_books (&currentselection, GTK_TREE_MODEL (store6), select6, treeview6);
}


void SelectBooksDialog::on_ok_clicked ()
{
  // Clear the selection set.
  myselection->clear ();
  // Add, through a callback, all selected books.
  gtk_tree_selection_selected_foreach (select1, selection_foreach_function, gpointer(this));
  gtk_tree_selection_selected_foreach (select2, selection_foreach_function, gpointer(this));
  gtk_tree_selection_selected_foreach (select3, selection_foreach_function, gpointer(this));
  gtk_tree_selection_selected_foreach (select4, selection_foreach_function, gpointer(this));
  gtk_tree_selection_selected_foreach (select5, selection_foreach_function, gpointer(this));
  gtk_tree_selection_selected_foreach (select6, selection_foreach_function, gpointer(this));
}


void SelectBooksDialog::addselection (const ustring book)
{
  myselection->insert (books_name_to_id (mylanguage, book));
}


void SelectBooksDialog::on_nobutton_clicked (GtkButton * button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_none_clicked ();
}


void SelectBooksDialog::on_otbutton_clicked (GtkButton * button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_ot_clicked ();
}


void SelectBooksDialog::on_ntbutton_clicked (GtkButton * button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_nt_clicked ();
}


void SelectBooksDialog::on_otherbutton_clicked (GtkButton *button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_other_clicked ();
}


void SelectBooksDialog::on_allbutton_clicked (GtkButton * button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_all_clicked ();
}


void SelectBooksDialog::on_currentbutton_clicked (GtkButton * button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_current_clicked ();
}


void SelectBooksDialog::on_okbutton_clicked (GtkButton * button, gpointer user_data)
{
  ((SelectBooksDialog *) user_data)->on_ok_clicked ();
}


void SelectBooksDialog::selection_foreach_function (GtkTreeModel * model,
                                               GtkTreePath * path,
                                               GtkTreeIter * iter, gpointer data)
{
  gchar *book;
  gtk_tree_model_get (model, iter, 0, &book, -1);
  ((SelectBooksDialog *) data)->addselection (book);
  g_free (book);
}


void SelectBooksDialog::initially_select_books ()
{
  // Initially select the books from myselection.
  select_books (myselection, GTK_TREE_MODEL (store1), select1, treeview1);
  select_books (myselection, GTK_TREE_MODEL (store2), select2, treeview2);
  select_books (myselection, GTK_TREE_MODEL (store3), select3, treeview3);
  select_books (myselection, GTK_TREE_MODEL (store4), select4, treeview4);
  select_books (myselection, GTK_TREE_MODEL (store5), select5, treeview5);
  select_books (myselection, GTK_TREE_MODEL (store6), select6, treeview6);
}


void SelectBooksDialog::select_books (set<unsigned int> * bookselection, GtkTreeModel *store, GtkTreeSelection * selection, GtkWidget * widget)
{
  // Unselect everything.
  gtk_tree_selection_unselect_all (selection);
  // Some variables.
  GtkTreeIter iter;
  gboolean valid;
  gint index = 0;
  // Get the first iter in the store.
  valid = gtk_tree_model_get_iter_first (store, &iter);
  while (valid) {
    // Walk through the list, reading each row
    gchar *str_data;
    // Make sure you terminate calls to gtk_tree_model_get() with a '-1' value.
    gtk_tree_model_get (store, &iter, 0, &str_data, -1);
    // If this is the marker we wish to display, select it.
    unsigned int id = books_name_to_id (mylanguage, str_data);
    if (bookselection->find (id) != bookselection->end()) {
      gtk_tree_selection_select_iter (selection, &iter);
    }
    g_free (str_data);
    valid = gtk_tree_model_iter_next (store, &iter);
    index++;
  }
}
