/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include <gtk/gtk.h>
#include "dialogchapternumber.h"
#include "generalconfig.h"
#include "projectconfig.h"
#include "projectutils.h"
#include "versification.h"
#include "combobox.h"
#include "help.h"
#include "books.h"


ChapterNumberDialog::ChapterNumberDialog (bool insert)
{
  // Initialize variables.
  GeneralConfiguration genconfig (0);
  ProjectConfiguration projectconfig ("");
  
  vector <unsigned int> currentchapters = project_get_chapters (genconfig.project(), genconfig.book ());
  for (unsigned int i = 0; i < currentchapters.size(); i++)
    currentchapters_set.insert (currentchapters[i]);
  
  currentchapter = convert_to_int (genconfig.chapter());
  
  myinsert = insert;

  // Build gui.  
  dialogchapternumber = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialogchapternumber), "Chapter Number");
  gtk_window_set_position (GTK_WINDOW (dialogchapternumber), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_type_hint (GTK_WINDOW (dialogchapternumber), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (dialogchapternumber)->vbox;
  gtk_widget_show (dialog_vbox1);

  if (insert) {
    
    label_purpose = gtk_label_new ("Insert a new chapter");
    gtk_widget_show (label_purpose);
    gtk_box_pack_start (GTK_BOX (dialog_vbox1), label_purpose, FALSE, FALSE, 0);
    gtk_misc_set_alignment (GTK_MISC (label_purpose), 0, 0.5);
                    
  } else {

    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox1);
    gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

    GSList *radiobutton_chapter_new_group = NULL;
  
    radiobutton_chapter_change = gtk_radio_button_new_with_mnemonic (NULL, "_Edit the chapter's number");
    gtk_widget_show (radiobutton_chapter_change);
    gtk_box_pack_start (GTK_BOX (vbox1), radiobutton_chapter_change, FALSE, FALSE, 0);
    gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_chapter_change), radiobutton_chapter_new_group);
    radiobutton_chapter_new_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton_chapter_change));

    radiobutton_chapter_erase = gtk_radio_button_new_with_mnemonic (NULL, "_Delete the chapter");
    gtk_widget_show (radiobutton_chapter_erase);
    gtk_box_pack_start (GTK_BOX (vbox1), radiobutton_chapter_erase, FALSE, FALSE, 0);
    gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_chapter_erase), radiobutton_chapter_new_group);
    radiobutton_chapter_new_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton_chapter_erase));

    g_signal_connect ((gpointer) radiobutton_chapter_change, "clicked",
                      G_CALLBACK (on_radiobutton_chapter_change_clicked),
                      gpointer(this));
    g_signal_connect ((gpointer) radiobutton_chapter_erase, "clicked",
                      G_CALLBACK (on_radiobutton_chapter_erase_clicked),
                      gpointer(this));
    
  }
  
  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

  GSList *radiobuttonlist_group = NULL;
  
  radiobuttonlist = gtk_radio_button_new_with_mnemonic (NULL, "From _list");
  gtk_widget_show (radiobuttonlist);
  gtk_table_attach (GTK_TABLE (table1), radiobuttonlist, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonlist), radiobuttonlist_group);
  radiobuttonlist_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonlist));

  radiobuttonentry = gtk_radio_button_new_with_mnemonic (NULL, "_Manual");
  gtk_widget_show (radiobuttonentry);
  gtk_table_attach (GTK_TABLE (table1), radiobuttonentry, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonentry), radiobuttonlist_group);
  radiobuttonlist_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonentry));

  combobox1 = gtk_combo_box_new_text ();
  gtk_widget_show (combobox1);
  gtk_table_attach (GTK_TABLE (table1), combobox1, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  // The combobox will show a list of free chapters.
  vector <unsigned int> templatechapters = versification_get_chapters (projectconfig.versification (), books_id_to_english (genconfig.book ()));
  vector <ustring> freechapters;
  for (unsigned int i = 0; i < templatechapters.size(); i++) {
    if (currentchapters_set.find (templatechapters[i]) == currentchapters_set.end())
      freechapters.push_back (convert_to_string (templatechapters[i]));
  }
  if (freechapters.empty()) freechapters.push_back ("<None available>");
  combobox_set_strings (combobox1, freechapters);
  combobox_set_string (combobox1, freechapters[0]);
  
  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_table_attach (GTK_TABLE (table1), entry1, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_max_length (GTK_ENTRY (entry1), 4);
  gtk_entry_set_activates_default (GTK_ENTRY (entry1), TRUE);
  gtk_entry_set_width_chars (GTK_ENTRY (entry1), 4);

  dialog_action_area1 = GTK_DIALOG (dialogchapternumber)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  help_button (dialog_action_area1, NULL, NULL);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialogchapternumber), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialogchapternumber), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) radiobuttonlist, "clicked",
                    G_CALLBACK (on_radiobuttonlist_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) radiobuttonentry, "clicked",
                    G_CALLBACK (on_radiobuttonentry_clicked),
                    gpointer(this));
  g_signal_connect ((gpointer) entry1, "changed",
                    G_CALLBACK (on_entry1_changed),
                    gpointer(this));
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_okbutton1_clicked),
                    gpointer(this));

  gtk_widget_grab_focus (okbutton1);
  gtk_widget_grab_default (okbutton1);

  // GUI.
  set_gui ();
}


ChapterNumberDialog::~ChapterNumberDialog ()
{
  gtk_widget_destroy (dialogchapternumber);
}


int ChapterNumberDialog::run ()
{
  return gtk_dialog_run (GTK_DIALOG (dialogchapternumber));
}


void ChapterNumberDialog::on_radiobuttonlist_clicked (GtkButton *button, gpointer user_data)
{
  ((ChapterNumberDialog *) user_data)->on_radiobuttonlist();
}


void ChapterNumberDialog::on_radiobuttonlist ()
{
  gtk_widget_grab_focus (combobox1);  
  set_gui ();
}


void ChapterNumberDialog::on_radiobuttonentry_clicked (GtkButton *button, gpointer user_data)
{
  ((ChapterNumberDialog *) user_data)->on_radiobuttonentry();
}


void ChapterNumberDialog::on_radiobuttonentry ()
{
  gtk_widget_grab_focus (entry1);
  set_gui ();
}


void ChapterNumberDialog::on_okbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((ChapterNumberDialog *) user_data)->on_ok();
}


void ChapterNumberDialog::on_ok ()
{
  GeneralConfiguration genconfig (0);
  ProjectConfiguration projectconfig ("");
  unsigned int newchapter = get_chapter();
  if (myinsert) {
    // Insert a chapter
    vector <ustring> lines;
    versification_create_chapter_template (projectconfig.versification(), books_id_to_english (genconfig.book()), newchapter, lines);
    CategorizeChapterVerse ccv (lines);    
    project_store_chapter (genconfig.project (), genconfig.book(), ccv);
    genconfig.chapter_set (convert_to_string (newchapter));    
  } else {
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton_chapter_change))) {
      // Change the chapter number.
      vector <ustring> lines = project_retrieve_chapter (genconfig.project(), genconfig.book(), currentchapter);
      lines.erase (lines.begin());
      lines.insert (lines.begin(), "\\c " + convert_to_string (newchapter));
      project_remove_chapter (genconfig.project(), genconfig.book(), currentchapter);
      CategorizeChapterVerse ccv (lines);    
      project_store_chapter (genconfig.project (), genconfig.book(), ccv);
      genconfig.chapter_set (convert_to_string (newchapter));    
    } else {
      // Erase the chapter.
      project_remove_chapter (genconfig.project(), genconfig.book(), currentchapter);
      genconfig.chapter_set (convert_to_string (currentchapter - 1));    
    }
  }
}


void ChapterNumberDialog::on_radiobutton_chapter_change_clicked (GtkButton *button, gpointer user_data)
{
  ((ChapterNumberDialog *) user_data)->set_gui ();
}


void ChapterNumberDialog::on_radiobutton_chapter_erase_clicked (GtkButton *button, gpointer user_data)
{
  ((ChapterNumberDialog *) user_data)->set_gui ();
}


void ChapterNumberDialog::set_gui ()
{
  // Variable.
  bool sensitive;
  
  // If erasing the chapter, set some selection controls insensitive.
  sensitive = true;
  if (!myinsert) {
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton_chapter_erase)))
      sensitive = false;
  }
  gtk_widget_set_sensitive (table1, sensitive);

  // Sensitivity of ok button.
  sensitive = true;
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttonlist))) {
    if (currentchapters_set.empty())
      sensitive = false;   
  } else {
    ustring ch = gtk_entry_get_text (GTK_ENTRY (entry1));
    ch = number_in_string (ch);
    if (ch.empty())
      sensitive = false;
    if (currentchapters_set.find (convert_to_int (ch)) != currentchapters_set.end())
      sensitive = false;
  }
  if (!myinsert) {
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton_chapter_erase)))
      if (currentchapter == 0)
        sensitive = false;
  }
  gtk_widget_set_sensitive (okbutton1, sensitive);
}


void ChapterNumberDialog::on_entry1_changed (GtkEditable *editable, gpointer user_data)
{
  ((ChapterNumberDialog *) user_data)->set_gui();
}


unsigned int ChapterNumberDialog::get_chapter ()
{
  unsigned int chapter;
  ustring ch;
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobuttonlist))) {
    ch = combobox_get_active_string (combobox1);
  } else {
    ch = gtk_entry_get_text (GTK_ENTRY (entry1));
  }
  chapter = convert_to_int (ch);
  return chapter;
}
