#include <windows.h>
#include <exdll.h>
#include "resource.h"

#define RECT_ID     1018
#define CHECKBOX_ID 10001

static volatile int g_done = 0;
static void *lpWndProcOld;

static HINSTANCE g_hInstance = NULL;
static HWND hwMainWindow     = NULL;
static HWND hwChild          = NULL;
static HWND hwNextButton     = NULL;
static HWND hwDialog         = NULL;
static HWND hwText           = NULL;
static HWND hwCheckBox       = NULL;

static BOOL CALLBACK dlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static BOOL CALLBACK ParentWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static void doShow(HWND hwndParent, char const* warning_text, char const* checkbox_text);

void __declspec(dllexport) show(HWND hwndParent, int string_size, char *variables, stack_t **stacktop)
{
	char* warning_text;
	char* checkbox_text;
	
	EXDLL_INIT();
	
	warning_text = GlobalAlloc(GPTR, string_size);
	checkbox_text = GlobalAlloc(GPTR, string_size);
	popstring(warning_text);
	popstring(checkbox_text);
	
	doShow(hwndParent, warning_text, checkbox_text);
	
	GlobalFree(warning_text);
	GlobalFree(checkbox_text);
}
	
void doShow(HWND hwndParent, char const* warning_text, char const* checkbox_text)
{
	int cw_vis;
	HDC memDC;
	RECT dialog_r, text_r;
	HFONT hFont = NULL;
	int dialog_width = 0;
	int dialog_height = 0;
	int cb_y = 0, cb_height = 15;
	
	hwMainWindow = hwndParent;
	
	hwChild = FindWindowEx(hwMainWindow, NULL, "#32770", NULL);
	if (!hwChild) hwChild = GetDlgItem(hwMainWindow, RECT_ID);
	if (!hwChild) {
		pushstring("error finding childwnd");
		return;
	}
	
	cw_vis = IsWindowVisible(hwChild);
	if (cw_vis) ShowWindow(hwChild, SW_HIDE);
	
	hwNextButton = GetDlgItem(hwMainWindow, IDOK);
	EnableWindow(hwNextButton, FALSE);
	
	hFont = (HFONT)SendMessage(hwMainWindow, WM_GETFONT, 0, 0);
	
	GetWindowRect(hwChild, &dialog_r);
	ScreenToClient(hwMainWindow, (LPPOINT)&dialog_r);
	ScreenToClient(hwMainWindow, ((LPPOINT)&dialog_r)+1);
	
	hwDialog = CreateDialog(g_hInstance, MAKEINTRESOURCE(IDD_DIALOG), hwMainWindow, dlgProc);
	if (!hwDialog) {
		pushstring("error creating dialog");
		if (cw_vis) ShowWindow(hwChild, SW_SHOW);
		return;
	}
	SetWindowPos(hwDialog, 0, dialog_r.left, dialog_r.top, dialog_r.right-dialog_r.left, dialog_r.bottom-dialog_r.top, SWP_NOZORDER|SWP_NOACTIVATE);
	SendMessage(hwDialog, WM_SETFONT, (WPARAM)hFont, TRUE);
	
	dialog_width = dialog_r.right-dialog_r.left;
	dialog_height = dialog_r.bottom-dialog_r.top;
	
	text_r.top = 0;
	text_r.left = 0;
	text_r.right = dialog_width;
	text_r.bottom = dialog_height;
	memDC = CreateCompatibleDC(GetDC(hwDialog));
	SelectObject(memDC, hFont);
	DrawText(memDC, warning_text, -1, &text_r, DT_CALCRECT|DT_WORDBREAK);
	DeleteDC(memDC);
	
	hwText = CreateWindowEx(
		WS_EX_TRANSPARENT,
		"STATIC",
		warning_text,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS,
		0, 0,
		text_r.right-text_r.left, text_r.bottom-text_r.top,
		hwDialog,
		NULL,
		g_hInstance,
		NULL
	);
	SendMessage(hwText, WM_SETFONT, (WPARAM)hFont, TRUE);

	cb_y = text_r.bottom-text_r.top+8;
	if (cb_y+cb_height > dialog_height) {
		cb_y = dialog_height-cb_height;
	}

	hwCheckBox = CreateWindowEx(
		0,
		"BUTTON",
		checkbox_text,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_TABSTOP | BS_TEXT | BS_VCENTER | BS_AUTOCHECKBOX,
		0, cb_y,
		dialog_width, cb_height,
		hwDialog,
		(HMENU)CHECKBOX_ID,
		g_hInstance,
		NULL
	);
	SendMessage(hwCheckBox, WM_SETFONT, (WPARAM)hFont, TRUE);

	lpWndProcOld = (void *)SetWindowLong(hwMainWindow, DWL_DLGPROC, (long)ParentWndProc);
	
	// Tell NSIS to remove old inner dialog and pass handle of the new inner dialog
	SendMessage(hwMainWindow, WM_NOTIFY_CUSTOM_READY, (WPARAM)hwDialog, 0);
	ShowWindow(hwDialog, SW_SHOWNA);
	
	while (!g_done) {
		MSG msg;
		int nResult = GetMessage(&msg, NULL, 0, 0);
		if (!IsDialogMessage(hwDialog, &msg) && !IsDialogMessage(hwMainWindow, &msg) && !TranslateMessage(&msg)) {
			DispatchMessage(&msg);
		}
	}
	DestroyWindow(hwDialog);
	SetWindowLong(hwMainWindow, DWL_DLGPROC, (long)lpWndProcOld);
	if (cw_vis) ShowWindow(hwChild, SW_SHOW);
}

static BOOL CALLBACK ParentWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	BOOL res = CallWindowProc((long (__stdcall *)(struct HWND__ *, unsigned int, unsigned int, long))lpWndProcOld, hwnd, message, wParam, lParam);
	if (message == WM_NOTIFY_OUTER_NEXT && !res) {
		g_done = 1;
		if (wParam == NOTIFY_BYE_BYE) {
			pushstring("cancel");
		} else if (wParam == -1) {
			pushstring("back");
		} else {
			pushstring("success");
		}
	}
	return res;
}

static BOOL CALLBACK dlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case CHECKBOX_ID:
			if (HIWORD(wParam) == BN_CLICKED) {
				EnableWindow(hwNextButton, SendMessage(hwCheckBox, BM_GETCHECK, 0, 0));
			}
			break;	
		}
		break;
	}
	return FALSE;
}

BOOL APIENTRY DllMain(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	g_hInstance = hInst;
	return TRUE;
}
