/*
    BFilter - a web proxy which removes banner ads
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "HeaderParser.h"
#include <cstring>
#include <string>

using namespace std;

class HeaderParser::EnvironmentManager
{
public:
	EnvironmentManager(
		HeaderParser& owner,
		HeaderParserListener* listener)
	:	m_rOwner(owner)
	{
		m_rOwner.m_pListener = listener;
	}
	
	~EnvironmentManager() {
		m_rOwner.reset();
		m_rOwner.m_valueStream.clear();
		m_rOwner.m_pListener = 0;
		m_rOwner.m_isProcessingParam = false;
	}
private:
	HeaderParser& m_rOwner;
};

HeaderParser::HeaderParser()
:	HeaderLexerCore(this),
	m_valueStream(60),
	m_pListener(0),
	m_isProcessingParam(false)
{
}

void
HeaderParser::consume(
	SplittableBuffer& hdr_value, HeaderParserListener* listener)
{
	EnvironmentManager manager(*this, listener);
	HeaderLexerCore::consume(hdr_value, true);
}

char
HeaderParser::unquoteChar(char ch)
{
	static const char in[]  = {'a', 'b', 'f', 'n', 'r', 't', 'v'}; 
	static const char out[] = {'\a','\b','\f','\n','\r','\t','\v'};
	char const* found = static_cast<char const*>(memchr(in, ch, sizeof(in)));
	if (found) {
		return out[found - in];
	}
	return ch;
}
