/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_OBJECTSTORAGE_H_
#define HTTPCACHE_OBJECTSTORAGE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RequestPtr.h"
#include "types.h"
#include <string>

namespace HttpCache
{

class AbstractItem;
class RequestResolution;

class ObjectStorage
{
public:
	virtual ~ObjectStorage() {}
	
	static ObjectStorage* instance();
	
	/**
	 * \brief Set the cache size.
	 *
	 * If we lower the cache size so that the used space exceedes the new size,
	 * the cache won't shrink immediately.  It will be shrinking gradually,
	 * during the other caching activity.
	 */
	virtual void setCacheSize(uint64_t size) = 0;
	
	/**
	 * \brief Sets and reads the cache directory.
	 *
	 * Initially, no cache directory is set, and handledRequest() is a no-op.
	 * \return true on success, false on failure.  A failure may be caused by:
	 * \li Specifying a directory that doesn't exist or doesn't have correct
	 * permissions.
	 * \li Unspecified or zero cache size.
	 * \note Once succeeded, this method may not be called again.
	 */
	virtual bool setCacheDir(std::string const& cache_dir) = 0;
	
	/**
	 * \brief Handle request metadata.
	 *
	 * \param request Non-null smart pointer to request metadata.
	 *        Request metadata is considered immutable and must not
	 *        be modified through non-const pointers or references.
	 * \param dont_create If true, no new cache entries will be created.
	 *        Reading and updating existing ones is still allowed.
	 */
	virtual RequestResolution handleRequest(
		ConstRequestPtr const& request, bool dont_create) = 0;
private:
	class Impl;
	class ImplRef;
};

} // namespace HttpCache

#endif
