/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "FileId.h"
#include <sstream>

namespace HttpCache
{

std::string
FileId::toFileName() const
{
	std::ostringstream strm;
	fileNameToStream(strm);
	return strm.str();
}

void
FileId::fileNameToStream(std::ostream& strm) const
{
	m_key.hexEncode(strm);
	strm << '.';
	strm.fill('0');
	strm.width(10); // enough for all possible values of uint32_t
	strm << m_version;
}

int
FileId::compare(FileId const& rhs) const
{
	int const key_comp = m_key.compare(rhs.m_key);
	if (key_comp) {
		return key_comp;
	}
	
	if (m_version > rhs.m_version) {
		return -1;
	} else if(m_version < rhs.m_version) {
		return 1;
	} else {
		return 0;
	}
}

} // namespace HttpCache
