/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPCACHE_ABSTRACTRESPONSEHANDLER_H_
#define HTTPCACHE_ABSTRACTRESPONSEHANDLER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RequestPtr.h"

class HttpRequestMetadata;
class HttpResponseMetadata;

namespace HttpCache
{

class ResponseResolution;

/**
 * \brief Used when the cache is interested in the server's response.
 */
class AbstractResponseHandler
{
public:
	virtual ~AbstractResponseHandler() {}
	
	/**
	 * \brief Get the request that is to be sent to the server.
	 *
	 * This may be the same request that was passed to
	 * AbstractItem::query(), or a modified one.
	 */
	virtual ConstRequestPtr const& getOutgoingRequest() const = 0;
	
	/**
	 * \brief Processes response metadata and decides what to do
	 *        with the rest of response.
	 *
	 * The ResponseResolution will contain either a reader, a writer,
	 * or none of them.
	 */
	virtual ResponseResolution handleResponse(
		HttpResponseMetadata const& response_metadata) = 0;
};

} // namespace HttpCache

#endif
