/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef RESPONSEFILTERCHAIN_H_
#define RESPONSEFILTERCHAIN_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractResponseHandler.h"
#include "RequestPtr.h"
#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "FilterGroupTag.h"
#include "FilterGlobalFlags.h"
#include "FilterGroupFlags.h"
#include "RequestTag.h"
#include <memory>
#include <string>
#include <deque>
#include <set>
#include <map>

class AbstractResponseFilter;
class HttpResponseMetadata;
class HttpRequestMetadata;
class ResponseErrorInitiator;
class ServiceContext;
class ErrorDescriptor;
class FilterTryList;
class JsFilterContext;
class DownloadProgress;
class RequestStatus;

class ResponseFilterChain : public AbstractResponseHandler
{
	DECLARE_NON_COPYABLE(ResponseFilterChain)
public:
	ResponseFilterChain(
		ServiceContext& context,
		ConstRequestPtr const& request,
		RequestTag const& request_tag,
		std::auto_ptr<FilterTryList> filter_try_list,
		IntrusivePtr<AbstractResponseHandler> const& final_recipient);
	
	virtual ~ResponseFilterChain();

	virtual void processProvisionalResponse(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processResponseMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	// postcondition: data is empty
	virtual void processBodyData(
		RequestStatus& status, SplittableBuffer& data, bool eof);
	
	virtual void processError(
		RequestStatus& status, std::auto_ptr<ErrorDescriptor> edesc);

	ServiceContext& getContext() { return m_rContext; }

	HttpRequestMetadata const& getRequest() const { return *m_ptrRequest; }

	ConstRequestPtr const& getRequestPtr() const { return m_ptrRequest; }

	RequestTag const& getRequestTag() const { return m_requestTag; }
	
	AbstractResponseHandler& getFinalRecipient() { return *m_ptrFinalRecipient; }

	void appendFilter(IntrusivePtr<AbstractResponseFilter> const& filter);
	
	IntrusivePtr<AbstractResponseFilter> nextFilter(HttpResponseMetadata const& metadata);
	
	FilterGlobalFlags& globalFlags() { return m_globalFlags; }
	
	FilterGlobalFlags const& globalFlags() const { return m_globalFlags; }
	
	FilterGroupFlags& groupLocalFlags() { return m_groupLocalFlags; }
	
	FilterGroupFlags const& groupLocalFlags() const { return m_groupLocalFlags; }
	
	bool isFlagSet(FilterGroupTag const& group, std::string const& flag) const;
	
	DownloadProgress const& getDownloadProgress() const { return m_requestTag->downloadProgress(); }
	
	JsFilterContext& getJsContextFor(FilterGroupTag const& group);
private:
	class Terminator;
	class RcJsFilterContext;

	typedef void (*Constructor)(ResponseFilterChain&, HttpResponseMetadata const&);
	
	ServiceContext& m_rContext;
	ConstRequestPtr m_ptrRequest;
	RequestTag m_requestTag;
	std::auto_ptr<FilterTryList> m_ptrFilterTryList;
	IntrusivePtr<AbstractResponseHandler> const m_ptrFinalRecipient;
	IntrusivePtr<AbstractResponseFilter> m_ptrTerminator;
	IntrusivePtr<AbstractResponseFilter> m_ptrFirstFilter;
	std::deque<IntrusivePtr<AbstractResponseFilter> > m_filterQueue;
	FilterGlobalFlags m_globalFlags;
	FilterGroupFlags m_groupLocalFlags;
	std::map<FilterGroupTag, IntrusivePtr<RcJsFilterContext>, FilterGroupTag::EquivComp> m_jsContexts;
};

#endif
