/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "PngImageInspector.h"
#include "PngContentIdentifier.h"
#include "types.h"

PngImageInspector::PngImageInspector()
:	m_state(ST_SIGNATURE),
	m_status(IN_PROGRESS),
	m_dataSize(0),
	m_width(0),
	m_height(0)
{
}

PngImageInspector::~PngImageInspector()
{
}

void
PngImageInspector::reset()
{
	m_state = ST_SIGNATURE;
	m_status = IN_PROGRESS;
	m_data.clear();
	m_dataSize = 0;
	m_width = 0;
	m_height = 0;
}

void
PngImageInspector::consumeDataChunk(SplittableBuffer& data, bool eof)
{
	m_dataSize += data.size();
	m_data.appendDestructive(data);
	if (m_status == IN_PROGRESS) {
		processNewData();
		if (eof && m_status == IN_PROGRESS) {
			m_status = FAILED;
		}
	}
}

void
PngImageInspector::processNewData()
{
	switch (m_state) {
		case ST_SIGNATURE: {
			if (!checkSignature()) {
				return;
			}
		}
		case ST_HEADER: {
			if (m_dataSize < 24) {
				return;
			}
			SplittableBuffer::ByteIterator pos = m_data.begin();
			pos += 16;
			m_width = unsigned(uint8_t(*pos)) << 24;
			++pos;
			m_width += unsigned(uint8_t(*pos)) << 16;
			++pos;
			m_width += unsigned(uint8_t(*pos)) << 8;
			++pos;
			m_width += unsigned(uint8_t(*pos));
			++pos;
			m_height = unsigned(uint8_t(*pos)) << 24;
			++pos;
			m_height += unsigned(uint8_t(*pos)) << 16;
			++pos;
			m_height += unsigned(uint8_t(*pos)) << 8;
			++pos;
			m_height += unsigned(uint8_t(*pos));
			m_status = COMPLETE;
		}
	}
}

bool
PngImageInspector::checkSignature()
{
	typedef PngContentIdentifier CI;
	SplittableBuffer::ByteIterator it(m_data.begin());
	char const* sigp = CI::SIGNATURE;
	char const* const sige = CI::SIGNATURE + sizeof(CI::SIGNATURE);
	for (;; ++it, ++sigp) {
		if (sigp == sige) {
			return true;
		} else if (it.isAtRightBorder()) {
			return false;
		} else if (*sigp != char(*it)) {
			m_status = FAILED;
			return false;
		}
	}
}
