/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LOGGINGRESPONSEHANDLER_H_
#define LOGGINGRESPONSEHANDLER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractResponseHandler.h"
#include "IntrusivePtr.h"
#include "RequestTag.h"
#include <memory>

class HttpResponseMetadata;
class SplittableBuffer;
class ErrorDescriptor;
class RequestStatus;

/**
 * \brief Logs events to RequestLog, then forwards them to another handler.
 */
class LoggingResponseHandler : public AbstractResponseHandler
{
public:
	LoggingResponseHandler(
		IntrusivePtr<AbstractResponseHandler> const& delegate,
		RequestTag const& request_tag);
	
	virtual ~LoggingResponseHandler();
	
	virtual void processProvisionalResponse(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processResponseMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status,
		SplittableBuffer& data, bool eof);
	
	virtual void processError(
		RequestStatus& status,
		std::auto_ptr<ErrorDescriptor> edesc);
private:
	IntrusivePtr<AbstractResponseHandler> m_ptrDelegate;
	RequestTag m_requestTag;
};

#endif
