/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2003  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPREQUESTPARSER_H_
#define HTTPREQUESTPARSER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpParserBase.h"
#include "HttpStateRequestStart.h"
#include "HttpStateRequestLine.h"
#include "HttpStateRequestHeaders.h"
#include <string>
#include <memory>

class HttpRequestLine;
class HttpRequestMetadata;

class HttpRequestParser : public HttpParserBase
{
public:
	HttpRequestParser();
	
	virtual ~HttpRequestParser();
	
	void switchToRequestStart();
	
	HttpState* activateStateRequestStart();
	
	HttpState* activateStateRequestLine();
	
	HttpState* activateStateHeaders(HttpRequestLine const& request_line);
	
	bool isInitialState() const { return getState() == &m_stateRequestStart; }	
	
	virtual void eventGotMetadata(
		std::auto_ptr<HttpRequestMetadata> metadata, bool is_persistent) = 0;
private:
	HttpStateRequestStart    m_stateRequestStart;
	HttpStateRequestLine     m_stateRequestLine;
	HttpStateRequestHeaders  m_stateRequestHeaders;
};

inline HttpState*
HttpRequestParser::activateStateRequestStart()
{
	m_stateRequestStart.activate();
	return &m_stateRequestStart;
}

inline HttpState*
HttpRequestParser::activateStateRequestLine()
{
	m_stateRequestLine.activate();
	return &m_stateRequestLine;
}

inline HttpState*
HttpRequestParser::activateStateHeaders(HttpRequestLine const& request_line)
{
	m_stateRequestHeaders.activate(request_line);
	return &m_stateRequestHeaders;
}

#endif
