/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTMLNODEWITHCHILDREN_H_
#define HTMLNODEWITHCHILDREN_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HtmlNode.h"
#include "HtmlNodeWithoutAttributes.h"
#include "HtmlNodeWithoutChildren.h"
#include "HtmlNodeWithoutContent.h"

class HtmlNodeWithChildren : virtual public HtmlNode
{
protected:
	HtmlNodeWithChildren();
	
	HtmlNodeWithChildren(HtmlNodeWithChildren const& other);
public:
	virtual ~HtmlNodeWithChildren();
	
	virtual bool hasChildren() const;
	
	virtual HtmlNode* getFirstChild();
	
	virtual HtmlNode const* getFirstChild() const;
	
	virtual HtmlNode* getLastChild();
	
	virtual HtmlNode const* getLastChild() const;
	
	virtual void appendChild(HtmlNode* node);
	
	virtual void prependChild(HtmlNode* node);
	
	virtual void removeAllChildren();
private:
	class Sentinel :
		public HtmlNodeWithoutAttributes,
		public HtmlNodeWithoutChildren,
		public HtmlNodeWithoutContent
	{
	public:
		virtual ~Sentinel();
		
		virtual HtmlNodePtr clone() const;
		
		virtual NodeType getNodeType() const;
	private:
		using HtmlNode::insertNextSibling;
		using HtmlNode::insertPrevSibling;
		// these don't work because sentinels have m_pParent == 0
	};

	Sentinel m_sentinel;
};

#endif
