/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DOWNLOADSIZELIMITER_H_
#define DOWNLOADSIZELIMITER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ResponseFilterBase.h"
#include "ResponseFilterChain.h"
#include "IntrusivePtr.h"
#include "NonCopyable.h"
#include "types.h"
#include <memory>

class HttpResponseMetadata;
class SplittableBuffer;
class ErrorDescriptor;
class RequestStatus;

class DownloadSizeLimiter : public ResponseFilterBase
{
	DECLARE_NON_COPYABLE(DownloadSizeLimiter)
public:
	DownloadSizeLimiter(ResponseFilterChain& filter_chain, uintmax_t size_limit);
	
	virtual ~DownloadSizeLimiter();
	
	virtual void processMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata);
	
	virtual void processBodyData(
		RequestStatus& status, SplittableBuffer& data, bool eof);
private:
	void cancelRequest(RequestStatus& status);
	
	uintmax_t m_sizeLimit;
};

#endif
