/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DATE_H_
#define DATE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <time.h>

class BString;

class Date
{
public:
	enum Style {
		RFC822,
		RFC1123 = RFC822,
		RFC850,
		RFC1036 = RFC850,
		ASCTIME
	};
	
	static BString format(time_t time, Style style=RFC822);
	
	static BString formatCurrentTime(Style style=RFC822);
	
	/**
	 * \brief Parses a textual datetime into time_t.
	 *
	 * Accepts RFC822 (RFC1123), RFC850 and asctime() formats.
	 * \note This function only works with GMT times. It will fail
	 *       if a different timezone is specified.
	 * \return The number of seconds since the epoch, or -1 on error.
	 */
	static time_t parse(BString const& str);
private:
	Date(); // forbid construction
	
	static time_t parseAsctime(char const* begin, char const* end);
	
	static time_t parseRFC822(char const* begin, char const* end);
	
	static time_t parseRFC850(char const* begin, char const* end);
	
	static int matchMonth(char const* month);
	
	static bool isLeapYear(unsigned year);
	
	static int leapsThroughEndOf(unsigned year);
	
	static time_t constructGmtTime(
		unsigned year, unsigned month, unsigned day,
		unsigned hour, unsigned min, unsigned sec);
	
	static int const m_daysByMonth[12];
	static char const m_wkdays[][4];
	static char const m_weekdays[][10];
	static char const m_months[][4];
	
};

#endif
