/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Color.h"
#include <cstring>

using namespace std;

Color::Color(uint8_t r, uint8_t g, uint8_t b)
{
	m_rgb[0] = r;
	m_rgb[1] = g;
	m_rgb[2] = b;
}

bool
Color::operator==(Color const& other) const
{
	return memcmp(m_rgb, other.m_rgb, sizeof(m_rgb)) == 0;
}

bool
Color::operator!=(Color const& other) const
{
	return memcmp(m_rgb, other.m_rgb, sizeof(m_rgb)) != 0;
}
