/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ABSTRACTRESPONSEHANDLER_H_
#define ABSTRACTRESPONSEHANDLER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RefCountable.h"
#include "RefCounter.h"
#include <memory>

class HttpResponseMetadata;
class SplittableBuffer;
class ErrorDescriptor;
class RequestStatus;

class AbstractResponseHandler
:	public RefCountable<RefCounter<ACE_NULL_SYNCH> >
{
public:
	virtual ~AbstractResponseHandler() {}
	
	virtual void processProvisionalResponse(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata) = 0;
	
	virtual void processResponseMetadata(
		RequestStatus& status,
		std::auto_ptr<HttpResponseMetadata> metadata) = 0;
	
	// postcondition: data is empty
	virtual void processBodyData(
		RequestStatus& status,
		SplittableBuffer& data, bool eof) = 0;
	
	virtual void processError(
		RequestStatus& status,
		std::auto_ptr<ErrorDescriptor> edesc) = 0;
};

#endif
