/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef NFACHARCLASS_H_
#define NFACHARCLASS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "Nfa.h"
#include "NfaState.h"
#include <string>

class NfaCharClass : public Nfa
{
public:
	NfaCharClass(std::string const& chars);
	
	NfaCharClass(uint8_t from, uint8_t to);
	
	virtual ~NfaCharClass();
	
	void addChars(std::string const& chars);
	
	void addChars(uint8_t from, uint8_t to);
	
	virtual int length() const;
	
	virtual NfaState const* statesBegin() const;
	
	virtual NfaState const* statesEnd() const;
	
	virtual int getStartPos() const;
	
	virtual int getFinishPos() const;
private:
	NfaState m_states[2];
};

#endif
